#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_DEVICE1_H
#define ORG_BLUEZ_DEVICE1_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "Device1" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace Device1 {

// method IDs
static const uint16 ID_Connect = 0;
static const uint16 ID_Disconnect = 1;
static const uint16 ID_Pair = 2;
static const uint16 ID_CancelPairing = 3;
static const uint16 ID_DiscoverServices = 4;
static const uint16 ID_CancelDiscovery = 5;

// signal IDs
static const uint16 ID_ReportLinkkey = 6;
static const uint16 ID_IncomingPairingComp = 7;
static const uint16 ID_SDPProcessReport = 8;

// property IDs
static const uint16 ID_Address = 9;
static const uint16 ID_Class = 10;
static const uint16 ID_Icon = 11;
static const uint16 ID_UUIDs = 12;
static const uint16 ID_Paired = 13;
static const uint16 ID_Connected = 14;
static const uint16 ID_Trusted = 15;
static const uint16 ID_Blocked = 16;
static const uint16 ID_Alias = 17;
static const uint16 ID_Adapter = 18;
static const uint16 ID_Modalias = 19;
static const uint16 ID_RSSI = 20;
static const uint16 ID_Vendor = 21;
static const uint16 ID_VendorSource = 22;
static const uint16 ID_Product = 23;
static const uint16 ID_MapInfo = 24;
static const uint16 ID_ConnectedService = 25;
static const uint16 ID_Version = 26;
static const uint16 ID_PBAPInfo = 27;
static const uint16 ID_Mode = 28;
static const uint16 ID_Role = 29;
static const uint16 ID_EnableAvpPause = 30;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class DiscoverServicesRequest;

class AddressUpdate;

class AddressRegister;

class ClassUpdate;

class ClassRegister;

class IconUpdate;

class IconRegister;

class UUIDsUpdate;

class UUIDsRegister;

class PairedUpdate;

class PairedRegister;

class ConnectedUpdate;

class ConnectedRegister;

class TrustedUpdate;

class TrustedRegister;

class BlockedUpdate;

class BlockedRegister;

class AliasUpdate;

class AliasRegister;

class AdapterUpdate;

class AdapterRegister;

class ModaliasUpdate;

class ModaliasRegister;

class RSSIUpdate;

class RSSIRegister;

class VendorUpdate;

class VendorRegister;

class VendorSourceUpdate;

class VendorSourceRegister;

class ProductUpdate;

class ProductRegister;

class MapInfoUpdate;

class MapInfoRegister;

class ConnectedServiceUpdate;

class ConnectedServiceRegister;

class VersionUpdate;

class VersionRegister;

class PBAPInfoUpdate;

class PBAPInfoRegister;

class ModeUpdate;

class ModeRegister;

class RoleUpdate;

class RoleRegister;

class EnableAvpPauseUpdate;

class EnableAvpPauseRegister;

class ReportLinkkeySignal;

class IncomingPairingCompSignal;

class SDPProcessReportSignal;

// type definitions
/**
 * If the meaning of "ConnectRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ConnectRequest;

/**
 * If the meaning of "ConnectResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ConnectResponse;

/**
 * If the meaning of "ConnectError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConnectError;

/**
 * If the meaning of "DisconnectRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DisconnectRequest;

/**
 * If the meaning of "DisconnectResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DisconnectResponse;

/**
 * If the meaning of "DisconnectError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisconnectError;

/**
 * If the meaning of "PairRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage PairRequest;

/**
 * If the meaning of "PairResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage PairResponse;

/**
 * If the meaning of "PairError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PairError;

/**
 * If the meaning of "CancelPairingRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelPairingRequest;

/**
 * If the meaning of "CancelPairingResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelPairingResponse;

/**
 * If the meaning of "CancelPairingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CancelPairingError;

/**
 * If the meaning of "DiscoverServicesResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DiscoverServicesResponse;

/**
 * If the meaning of "DiscoverServicesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DiscoverServicesError;

/**
 * If the meaning of "CancelDiscoveryRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelDiscoveryRequest;

/**
 * If the meaning of "CancelDiscoveryResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelDiscoveryResponse;

/**
 * If the meaning of "CancelDiscoveryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CancelDiscoveryError;

/**
 * If the meaning of "AddressSet" isn't clear, then there should be a description here.
 */
typedef AddressUpdate AddressSet;

/**
 * If the meaning of "AddressGet" isn't clear, then there should be a description here.
 */
typedef AddressUpdate AddressGet;

/**
 * If the meaning of "AddressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AddressError;

/**
 * If the meaning of "ClassSet" isn't clear, then there should be a description here.
 */
typedef ClassUpdate ClassSet;

/**
 * If the meaning of "ClassGet" isn't clear, then there should be a description here.
 */
typedef ClassUpdate ClassGet;

/**
 * If the meaning of "ClassError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ClassError;

/**
 * If the meaning of "IconSet" isn't clear, then there should be a description here.
 */
typedef IconUpdate IconSet;

/**
 * If the meaning of "IconGet" isn't clear, then there should be a description here.
 */
typedef IconUpdate IconGet;

/**
 * If the meaning of "IconError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IconError;

/**
 * If the meaning of "UUIDsSet" isn't clear, then there should be a description here.
 */
typedef UUIDsUpdate UUIDsSet;

/**
 * If the meaning of "UUIDsGet" isn't clear, then there should be a description here.
 */
typedef UUIDsUpdate UUIDsGet;

/**
 * If the meaning of "UUIDsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UUIDsError;

/**
 * If the meaning of "PairedSet" isn't clear, then there should be a description here.
 */
typedef PairedUpdate PairedSet;

/**
 * If the meaning of "PairedGet" isn't clear, then there should be a description here.
 */
typedef PairedUpdate PairedGet;

/**
 * If the meaning of "PairedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PairedError;

/**
 * If the meaning of "ConnectedSet" isn't clear, then there should be a description here.
 */
typedef ConnectedUpdate ConnectedSet;

/**
 * If the meaning of "ConnectedGet" isn't clear, then there should be a description here.
 */
typedef ConnectedUpdate ConnectedGet;

/**
 * If the meaning of "ConnectedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConnectedError;

/**
 * If the meaning of "TrustedSet" isn't clear, then there should be a description here.
 */
typedef TrustedUpdate TrustedSet;

/**
 * If the meaning of "TrustedGet" isn't clear, then there should be a description here.
 */
typedef TrustedUpdate TrustedGet;

/**
 * If the meaning of "TrustedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TrustedError;

/**
 * If the meaning of "BlockedSet" isn't clear, then there should be a description here.
 */
typedef BlockedUpdate BlockedSet;

/**
 * If the meaning of "BlockedGet" isn't clear, then there should be a description here.
 */
typedef BlockedUpdate BlockedGet;

/**
 * If the meaning of "BlockedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BlockedError;

/**
 * If the meaning of "AliasSet" isn't clear, then there should be a description here.
 */
typedef AliasUpdate AliasSet;

/**
 * If the meaning of "AliasGet" isn't clear, then there should be a description here.
 */
typedef AliasUpdate AliasGet;

/**
 * If the meaning of "AliasError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AliasError;

/**
 * If the meaning of "AdapterSet" isn't clear, then there should be a description here.
 */
typedef AdapterUpdate AdapterSet;

/**
 * If the meaning of "AdapterGet" isn't clear, then there should be a description here.
 */
typedef AdapterUpdate AdapterGet;

/**
 * If the meaning of "AdapterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AdapterError;

/**
 * If the meaning of "ModaliasSet" isn't clear, then there should be a description here.
 */
typedef ModaliasUpdate ModaliasSet;

/**
 * If the meaning of "ModaliasGet" isn't clear, then there should be a description here.
 */
typedef ModaliasUpdate ModaliasGet;

/**
 * If the meaning of "ModaliasError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ModaliasError;

/**
 * If the meaning of "RSSISet" isn't clear, then there should be a description here.
 */
typedef RSSIUpdate RSSISet;

/**
 * If the meaning of "RSSIGet" isn't clear, then there should be a description here.
 */
typedef RSSIUpdate RSSIGet;

/**
 * If the meaning of "RSSIError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RSSIError;

/**
 * If the meaning of "VendorSet" isn't clear, then there should be a description here.
 */
typedef VendorUpdate VendorSet;

/**
 * If the meaning of "VendorGet" isn't clear, then there should be a description here.
 */
typedef VendorUpdate VendorGet;

/**
 * If the meaning of "VendorError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VendorError;

/**
 * If the meaning of "VendorSourceSet" isn't clear, then there should be a description here.
 */
typedef VendorSourceUpdate VendorSourceSet;

/**
 * If the meaning of "VendorSourceGet" isn't clear, then there should be a description here.
 */
typedef VendorSourceUpdate VendorSourceGet;

/**
 * If the meaning of "VendorSourceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VendorSourceError;

/**
 * If the meaning of "ProductSet" isn't clear, then there should be a description here.
 */
typedef ProductUpdate ProductSet;

/**
 * If the meaning of "ProductGet" isn't clear, then there should be a description here.
 */
typedef ProductUpdate ProductGet;

/**
 * If the meaning of "ProductError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProductError;

/**
 * If the meaning of "MapInfoSet" isn't clear, then there should be a description here.
 */
typedef MapInfoUpdate MapInfoSet;

/**
 * If the meaning of "MapInfoGet" isn't clear, then there should be a description here.
 */
typedef MapInfoUpdate MapInfoGet;

/**
 * If the meaning of "MapInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MapInfoError;

/**
 * If the meaning of "ConnectedServiceSet" isn't clear, then there should be a description here.
 */
typedef ConnectedServiceUpdate ConnectedServiceSet;

/**
 * If the meaning of "ConnectedServiceGet" isn't clear, then there should be a description here.
 */
typedef ConnectedServiceUpdate ConnectedServiceGet;

/**
 * If the meaning of "ConnectedServiceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConnectedServiceError;

/**
 * If the meaning of "VersionSet" isn't clear, then there should be a description here.
 */
typedef VersionUpdate VersionSet;

/**
 * If the meaning of "VersionGet" isn't clear, then there should be a description here.
 */
typedef VersionUpdate VersionGet;

/**
 * If the meaning of "VersionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VersionError;

/**
 * If the meaning of "PBAPInfoSet" isn't clear, then there should be a description here.
 */
typedef PBAPInfoUpdate PBAPInfoSet;

/**
 * If the meaning of "PBAPInfoGet" isn't clear, then there should be a description here.
 */
typedef PBAPInfoUpdate PBAPInfoGet;

/**
 * If the meaning of "PBAPInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PBAPInfoError;

/**
 * If the meaning of "ModeSet" isn't clear, then there should be a description here.
 */
typedef ModeUpdate ModeSet;

/**
 * If the meaning of "ModeGet" isn't clear, then there should be a description here.
 */
typedef ModeUpdate ModeGet;

/**
 * If the meaning of "ModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ModeError;

/**
 * If the meaning of "RoleSet" isn't clear, then there should be a description here.
 */
typedef RoleUpdate RoleSet;

/**
 * If the meaning of "RoleGet" isn't clear, then there should be a description here.
 */
typedef RoleUpdate RoleGet;

/**
 * If the meaning of "RoleError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RoleError;

/**
 * If the meaning of "EnableAvpPauseSet" isn't clear, then there should be a description here.
 */
typedef EnableAvpPauseUpdate EnableAvpPauseSet;

/**
 * If the meaning of "EnableAvpPauseGet" isn't clear, then there should be a description here.
 */
typedef EnableAvpPauseUpdate EnableAvpPauseGet;

/**
 * If the meaning of "EnableAvpPauseError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EnableAvpPauseError;

/**
 * If the meaning of "ReportLinkkeyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReportLinkkeyError;

/**
 * If the meaning of "IncomingPairingCompError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IncomingPairingCompError;

/**
 * If the meaning of "SDPProcessReportError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SDPProcessReportError;


/**
 * If the meaning of "DiscoverServicesRequest" isn't clear, then there should be a description here.
 */
class DiscoverServicesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiscoverServicesRequest ();

    /**
     * Copy constructor
     */
    inline  DiscoverServicesRequest (const DiscoverServicesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DiscoverServicesRequest (const ::std::string& pattern_);

    /**
     * Destructor
     */
    inline virtual  ~DiscoverServicesRequest();

    /**
     * Assignment operator
     */
    inline DiscoverServicesRequest& operator = (const DiscoverServicesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiscoverServicesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiscoverServicesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiscoverServicesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiscoverServicesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pattern"

    static const int kPattern = 0;

    /**
     * Clears the field "pattern".
     *
     * The field will be set to its default value. The hasPattern()
     * method will return false.
     */
    inline void clearPattern();

    /**
     * Checks whether the field "pattern" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPattern()). Otherwise it will return false.
     */
    inline bool hasPattern () const;

    /**
     * Returns the value of the member "pattern".
     *
     * If the meaning of "pattern" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pattern"
     */
    inline const ::std::string& getPattern () const;

    /**
     * Retrieves the value of the field "pattern" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "pattern".
     */
    inline ::std::string& getPatternMutable ();

    /**
     * Sets the value of the member "pattern".
     *
     * If the meaning of "pattern" isn't clear, then there should be a description here.
     *
     * @param pattern The value which will be set
     */
    inline void setPattern (const ::std::string& pattern_);

    /**
     * Sets the value of the member "pattern".
     *
     * If the meaning of "pattern" isn't clear, then there should be a description here.
     *
     * @param pattern The value which will be set
     */
    inline void setPattern (const char* pattern_);

    /**
     * Sets the value of the member "pattern".
     *
     * If the meaning of "pattern" isn't clear, then there should be a description here.
     *
     * @param pattern The value which will be set
     */
    inline void setPattern (const char* value, size_t size);

    static const DiscoverServicesRequest &getDefaultInstance();

private:

    inline void set_has_pattern ();

    inline void clear_has_pattern ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _pattern;

};

/**
 * If the meaning of "AddressUpdate" isn't clear, then there should be a description here.
 */
class AddressUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddressUpdate ();

    /**
     * Copy constructor
     */
    inline  AddressUpdate (const AddressUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AddressUpdate (const ::std::string& Address_);

    /**
     * Destructor
     */
    inline virtual  ~AddressUpdate();

    /**
     * Assignment operator
     */
    inline AddressUpdate& operator = (const AddressUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddressUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddressUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddressUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddressUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Address"

    static const int kAddress = 0;

    /**
     * Clears the field "Address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "Address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "Address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const ::std::string& Address_);

    /**
     * Sets the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const char* Address_);

    /**
     * Sets the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    static const AddressUpdate &getDefaultInstance();

private:

    inline void set_has_Address ();

    inline void clear_has_Address ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Address;

};

/**
 * If the meaning of "AddressRegister" isn't clear, then there should be a description here.
 */
class AddressRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddressRegister ();

    /**
     * Copy constructor
     */
    inline  AddressRegister (const AddressRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AddressRegister();

    /**
     * Assignment operator
     */
    inline AddressRegister& operator = (const AddressRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddressRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddressRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddressRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddressRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AddressRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ClassUpdate" isn't clear, then there should be a description here.
 */
class ClassUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClassUpdate ();

    /**
     * Copy constructor
     */
    inline  ClassUpdate (const ClassUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ClassUpdate (uint32 Class_);

    /**
     * Destructor
     */
    inline virtual  ~ClassUpdate();

    /**
     * Assignment operator
     */
    inline ClassUpdate& operator = (const ClassUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClassUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClassUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClassUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClassUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Class"

    static const int kClass = 0;

    /**
     * Clears the field "Class".
     *
     * The field will be set to its default value. The hasClass()
     * method will return false.
     */
    inline void clearClass();

    /**
     * Checks whether the field "Class" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClass()). Otherwise it will return false.
     */
    inline bool hasClass () const;

    /**
     * Returns the value of the member "Class".
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Class"
     */
    inline uint32 getClass () const;

    /**
     * Sets the value of the member "Class".
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     *
     * @param Class The value which will be set
     */
    inline void setClass (uint32 Class_);

    static const ClassUpdate &getDefaultInstance();

private:

    inline void set_has_Class ();

    inline void clear_has_Class ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Class;

};

/**
 * If the meaning of "ClassRegister" isn't clear, then there should be a description here.
 */
class ClassRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClassRegister ();

    /**
     * Copy constructor
     */
    inline  ClassRegister (const ClassRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ClassRegister();

    /**
     * Assignment operator
     */
    inline ClassRegister& operator = (const ClassRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClassRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClassRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClassRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClassRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ClassRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "IconUpdate" isn't clear, then there should be a description here.
 */
class IconUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IconUpdate ();

    /**
     * Copy constructor
     */
    inline  IconUpdate (const IconUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  IconUpdate (const ::std::string& Icon_);

    /**
     * Destructor
     */
    inline virtual  ~IconUpdate();

    /**
     * Assignment operator
     */
    inline IconUpdate& operator = (const IconUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IconUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IconUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IconUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IconUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Icon"

    static const int kIcon = 0;

    /**
     * Clears the field "Icon".
     *
     * The field will be set to its default value. The hasIcon()
     * method will return false.
     */
    inline void clearIcon();

    /**
     * Checks whether the field "Icon" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIcon()). Otherwise it will return false.
     */
    inline bool hasIcon () const;

    /**
     * Returns the value of the member "Icon".
     *
     * If the meaning of "Icon" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Icon"
     */
    inline const ::std::string& getIcon () const;

    /**
     * Retrieves the value of the field "Icon" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Icon".
     */
    inline ::std::string& getIconMutable ();

    /**
     * Sets the value of the member "Icon".
     *
     * If the meaning of "Icon" isn't clear, then there should be a description here.
     *
     * @param Icon The value which will be set
     */
    inline void setIcon (const ::std::string& Icon_);

    /**
     * Sets the value of the member "Icon".
     *
     * If the meaning of "Icon" isn't clear, then there should be a description here.
     *
     * @param Icon The value which will be set
     */
    inline void setIcon (const char* Icon_);

    /**
     * Sets the value of the member "Icon".
     *
     * If the meaning of "Icon" isn't clear, then there should be a description here.
     *
     * @param Icon The value which will be set
     */
    inline void setIcon (const char* value, size_t size);

    static const IconUpdate &getDefaultInstance();

private:

    inline void set_has_Icon ();

    inline void clear_has_Icon ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Icon;

};

/**
 * If the meaning of "IconRegister" isn't clear, then there should be a description here.
 */
class IconRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IconRegister ();

    /**
     * Copy constructor
     */
    inline  IconRegister (const IconRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~IconRegister();

    /**
     * Assignment operator
     */
    inline IconRegister& operator = (const IconRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IconRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IconRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IconRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IconRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const IconRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "UUIDsUpdate" isn't clear, then there should be a description here.
 */
class UUIDsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UUIDsUpdate ();

    /**
     * Copy constructor
     */
    inline  UUIDsUpdate (const UUIDsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UUIDsUpdate (const ::std::vector< ::std::string >& UUIDs_);

    /**
     * Destructor
     */
    inline virtual  ~UUIDsUpdate();

    /**
     * Assignment operator
     */
    inline UUIDsUpdate& operator = (const UUIDsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UUIDsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UUIDsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UUIDsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UUIDsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UUIDs"

    static const int kUUIDs = 0;

    /**
     * Clears the field "UUIDs".
     *
     * The field will be set to its default value. The hasUUIDs()
     * method will return false.
     */
    inline void clearUUIDs();

    /**
     * Checks whether the field "UUIDs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUUIDs()). Otherwise it will return false.
     */
    inline bool hasUUIDs () const;

    /**
     * Returns the value of the member "UUIDs".
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     *
     * @return The value of the field "UUIDs"
     */
    inline const ::std::vector< ::std::string >& getUUIDs () const;

    /**
     * Retrieves the value of the field "UUIDs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UUIDs".
     */
    inline ::std::vector< ::std::string >& getUUIDsMutable ();

    /**
     * Sets the value of the member "UUIDs".
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     *
     * @param UUIDs The value which will be set
     */
    inline void setUUIDs (const ::std::vector< ::std::string >& UUIDs_);

    static const UUIDsUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_UUIDs ();

    inline void clear_has_UUIDs ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _UUIDs;

};

/**
 * If the meaning of "UUIDsRegister" isn't clear, then there should be a description here.
 */
class UUIDsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UUIDsRegister ();

    /**
     * Copy constructor
     */
    inline  UUIDsRegister (const UUIDsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UUIDsRegister();

    /**
     * Assignment operator
     */
    inline UUIDsRegister& operator = (const UUIDsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UUIDsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UUIDsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UUIDsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UUIDsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UUIDsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PairedUpdate" isn't clear, then there should be a description here.
 */
class PairedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PairedUpdate ();

    /**
     * Copy constructor
     */
    inline  PairedUpdate (const PairedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PairedUpdate (bool Paired_);

    /**
     * Destructor
     */
    inline virtual  ~PairedUpdate();

    /**
     * Assignment operator
     */
    inline PairedUpdate& operator = (const PairedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Paired"

    static const int kPaired = 0;

    /**
     * Clears the field "Paired".
     *
     * The field will be set to its default value. The hasPaired()
     * method will return false.
     */
    inline void clearPaired();

    /**
     * Checks whether the field "Paired" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPaired()). Otherwise it will return false.
     */
    inline bool hasPaired () const;

    /**
     * Returns the value of the member "Paired".
     *
     * If the meaning of "Paired" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Paired"
     */
    inline bool getPaired () const;

    /**
     * Sets the value of the member "Paired".
     *
     * If the meaning of "Paired" isn't clear, then there should be a description here.
     *
     * @param Paired The value which will be set
     */
    inline void setPaired (bool Paired_);

    static const PairedUpdate &getDefaultInstance();

private:

    inline void set_has_Paired ();

    inline void clear_has_Paired ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Paired;

};

/**
 * If the meaning of "PairedRegister" isn't clear, then there should be a description here.
 */
class PairedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PairedRegister ();

    /**
     * Copy constructor
     */
    inline  PairedRegister (const PairedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PairedRegister();

    /**
     * Assignment operator
     */
    inline PairedRegister& operator = (const PairedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PairedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ConnectedUpdate" isn't clear, then there should be a description here.
 */
class ConnectedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectedUpdate ();

    /**
     * Copy constructor
     */
    inline  ConnectedUpdate (const ConnectedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectedUpdate (bool Connected_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectedUpdate();

    /**
     * Assignment operator
     */
    inline ConnectedUpdate& operator = (const ConnectedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Connected"

    static const int kConnected = 0;

    /**
     * Clears the field "Connected".
     *
     * The field will be set to its default value. The hasConnected()
     * method will return false.
     */
    inline void clearConnected();

    /**
     * Checks whether the field "Connected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnected()). Otherwise it will return false.
     */
    inline bool hasConnected () const;

    /**
     * Returns the value of the member "Connected".
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Connected"
     */
    inline bool getConnected () const;

    /**
     * Sets the value of the member "Connected".
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @param Connected The value which will be set
     */
    inline void setConnected (bool Connected_);

    static const ConnectedUpdate &getDefaultInstance();

private:

    inline void set_has_Connected ();

    inline void clear_has_Connected ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Connected;

};

/**
 * If the meaning of "ConnectedRegister" isn't clear, then there should be a description here.
 */
class ConnectedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectedRegister ();

    /**
     * Copy constructor
     */
    inline  ConnectedRegister (const ConnectedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConnectedRegister();

    /**
     * Assignment operator
     */
    inline ConnectedRegister& operator = (const ConnectedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConnectedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "TrustedUpdate" isn't clear, then there should be a description here.
 */
class TrustedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TrustedUpdate ();

    /**
     * Copy constructor
     */
    inline  TrustedUpdate (const TrustedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TrustedUpdate (bool Trusted_);

    /**
     * Destructor
     */
    inline virtual  ~TrustedUpdate();

    /**
     * Assignment operator
     */
    inline TrustedUpdate& operator = (const TrustedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TrustedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TrustedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TrustedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TrustedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Trusted"

    static const int kTrusted = 0;

    /**
     * Clears the field "Trusted".
     *
     * The field will be set to its default value. The hasTrusted()
     * method will return false.
     */
    inline void clearTrusted();

    /**
     * Checks whether the field "Trusted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrusted()). Otherwise it will return false.
     */
    inline bool hasTrusted () const;

    /**
     * Returns the value of the member "Trusted".
     *
     * If the meaning of "Trusted" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Trusted"
     */
    inline bool getTrusted () const;

    /**
     * Sets the value of the member "Trusted".
     *
     * If the meaning of "Trusted" isn't clear, then there should be a description here.
     *
     * @param Trusted The value which will be set
     */
    inline void setTrusted (bool Trusted_);

    static const TrustedUpdate &getDefaultInstance();

private:

    inline void set_has_Trusted ();

    inline void clear_has_Trusted ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Trusted;

};

/**
 * If the meaning of "TrustedRegister" isn't clear, then there should be a description here.
 */
class TrustedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TrustedRegister ();

    /**
     * Copy constructor
     */
    inline  TrustedRegister (const TrustedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TrustedRegister();

    /**
     * Assignment operator
     */
    inline TrustedRegister& operator = (const TrustedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TrustedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TrustedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TrustedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TrustedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TrustedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "BlockedUpdate" isn't clear, then there should be a description here.
 */
class BlockedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BlockedUpdate ();

    /**
     * Copy constructor
     */
    inline  BlockedUpdate (const BlockedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  BlockedUpdate (bool Blocked_);

    /**
     * Destructor
     */
    inline virtual  ~BlockedUpdate();

    /**
     * Assignment operator
     */
    inline BlockedUpdate& operator = (const BlockedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BlockedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BlockedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BlockedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BlockedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Blocked"

    static const int kBlocked = 0;

    /**
     * Clears the field "Blocked".
     *
     * The field will be set to its default value. The hasBlocked()
     * method will return false.
     */
    inline void clearBlocked();

    /**
     * Checks whether the field "Blocked" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBlocked()). Otherwise it will return false.
     */
    inline bool hasBlocked () const;

    /**
     * Returns the value of the member "Blocked".
     *
     * If the meaning of "Blocked" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Blocked"
     */
    inline bool getBlocked () const;

    /**
     * Sets the value of the member "Blocked".
     *
     * If the meaning of "Blocked" isn't clear, then there should be a description here.
     *
     * @param Blocked The value which will be set
     */
    inline void setBlocked (bool Blocked_);

    static const BlockedUpdate &getDefaultInstance();

private:

    inline void set_has_Blocked ();

    inline void clear_has_Blocked ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Blocked;

};

/**
 * If the meaning of "BlockedRegister" isn't clear, then there should be a description here.
 */
class BlockedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BlockedRegister ();

    /**
     * Copy constructor
     */
    inline  BlockedRegister (const BlockedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~BlockedRegister();

    /**
     * Assignment operator
     */
    inline BlockedRegister& operator = (const BlockedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BlockedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BlockedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BlockedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BlockedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const BlockedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AliasUpdate" isn't clear, then there should be a description here.
 */
class AliasUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AliasUpdate ();

    /**
     * Copy constructor
     */
    inline  AliasUpdate (const AliasUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AliasUpdate (const ::std::string& Alias_);

    /**
     * Destructor
     */
    inline virtual  ~AliasUpdate();

    /**
     * Assignment operator
     */
    inline AliasUpdate& operator = (const AliasUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AliasUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AliasUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AliasUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AliasUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Alias"

    static const int kAlias = 0;

    /**
     * Clears the field "Alias".
     *
     * The field will be set to its default value. The hasAlias()
     * method will return false.
     */
    inline void clearAlias();

    /**
     * Checks whether the field "Alias" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlias()). Otherwise it will return false.
     */
    inline bool hasAlias () const;

    /**
     * Returns the value of the member "Alias".
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Alias"
     */
    inline const ::std::string& getAlias () const;

    /**
     * Retrieves the value of the field "Alias" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Alias".
     */
    inline ::std::string& getAliasMutable ();

    /**
     * Sets the value of the member "Alias".
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param Alias The value which will be set
     */
    inline void setAlias (const ::std::string& Alias_);

    /**
     * Sets the value of the member "Alias".
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param Alias The value which will be set
     */
    inline void setAlias (const char* Alias_);

    /**
     * Sets the value of the member "Alias".
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param Alias The value which will be set
     */
    inline void setAlias (const char* value, size_t size);

    static const AliasUpdate &getDefaultInstance();

private:

    inline void set_has_Alias ();

    inline void clear_has_Alias ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Alias;

};

/**
 * If the meaning of "AliasRegister" isn't clear, then there should be a description here.
 */
class AliasRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AliasRegister ();

    /**
     * Copy constructor
     */
    inline  AliasRegister (const AliasRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AliasRegister();

    /**
     * Assignment operator
     */
    inline AliasRegister& operator = (const AliasRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AliasRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AliasRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AliasRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AliasRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AliasRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AdapterUpdate" isn't clear, then there should be a description here.
 */
class AdapterUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AdapterUpdate ();

    /**
     * Copy constructor
     */
    inline  AdapterUpdate (const AdapterUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AdapterUpdate (const ::std::string& Adapter_);

    /**
     * Destructor
     */
    inline virtual  ~AdapterUpdate();

    /**
     * Assignment operator
     */
    inline AdapterUpdate& operator = (const AdapterUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AdapterUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AdapterUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AdapterUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AdapterUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Adapter"

    static const int kAdapter = 0;

    /**
     * Clears the field "Adapter".
     *
     * The field will be set to its default value. The hasAdapter()
     * method will return false.
     */
    inline void clearAdapter();

    /**
     * Checks whether the field "Adapter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAdapter()). Otherwise it will return false.
     */
    inline bool hasAdapter () const;

    /**
     * Returns the value of the member "Adapter".
     *
     * If the meaning of "Adapter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Adapter"
     */
    inline const ::std::string& getAdapter () const;

    /**
     * Retrieves the value of the field "Adapter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Adapter".
     */
    inline ::std::string& getAdapterMutable ();

    /**
     * Sets the value of the member "Adapter".
     *
     * If the meaning of "Adapter" isn't clear, then there should be a description here.
     *
     * @param Adapter The value which will be set
     */
    inline void setAdapter (const ::std::string& Adapter_);

    /**
     * Sets the value of the member "Adapter".
     *
     * If the meaning of "Adapter" isn't clear, then there should be a description here.
     *
     * @param Adapter The value which will be set
     */
    inline void setAdapter (const char* Adapter_);

    /**
     * Sets the value of the member "Adapter".
     *
     * If the meaning of "Adapter" isn't clear, then there should be a description here.
     *
     * @param Adapter The value which will be set
     */
    inline void setAdapter (const char* value, size_t size);

    static const AdapterUpdate &getDefaultInstance();

private:

    inline void set_has_Adapter ();

    inline void clear_has_Adapter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Adapter;

};

/**
 * If the meaning of "AdapterRegister" isn't clear, then there should be a description here.
 */
class AdapterRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AdapterRegister ();

    /**
     * Copy constructor
     */
    inline  AdapterRegister (const AdapterRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AdapterRegister();

    /**
     * Assignment operator
     */
    inline AdapterRegister& operator = (const AdapterRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AdapterRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AdapterRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AdapterRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AdapterRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AdapterRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ModaliasUpdate" isn't clear, then there should be a description here.
 */
class ModaliasUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ModaliasUpdate ();

    /**
     * Copy constructor
     */
    inline  ModaliasUpdate (const ModaliasUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ModaliasUpdate (const ::std::string& Modalias_);

    /**
     * Destructor
     */
    inline virtual  ~ModaliasUpdate();

    /**
     * Assignment operator
     */
    inline ModaliasUpdate& operator = (const ModaliasUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ModaliasUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ModaliasUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ModaliasUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ModaliasUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Modalias"

    static const int kModalias = 0;

    /**
     * Clears the field "Modalias".
     *
     * The field will be set to its default value. The hasModalias()
     * method will return false.
     */
    inline void clearModalias();

    /**
     * Checks whether the field "Modalias" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setModalias()). Otherwise it will return false.
     */
    inline bool hasModalias () const;

    /**
     * Returns the value of the member "Modalias".
     *
     * If the meaning of "Modalias" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Modalias"
     */
    inline const ::std::string& getModalias () const;

    /**
     * Retrieves the value of the field "Modalias" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Modalias".
     */
    inline ::std::string& getModaliasMutable ();

    /**
     * Sets the value of the member "Modalias".
     *
     * If the meaning of "Modalias" isn't clear, then there should be a description here.
     *
     * @param Modalias The value which will be set
     */
    inline void setModalias (const ::std::string& Modalias_);

    /**
     * Sets the value of the member "Modalias".
     *
     * If the meaning of "Modalias" isn't clear, then there should be a description here.
     *
     * @param Modalias The value which will be set
     */
    inline void setModalias (const char* Modalias_);

    /**
     * Sets the value of the member "Modalias".
     *
     * If the meaning of "Modalias" isn't clear, then there should be a description here.
     *
     * @param Modalias The value which will be set
     */
    inline void setModalias (const char* value, size_t size);

    static const ModaliasUpdate &getDefaultInstance();

private:

    inline void set_has_Modalias ();

    inline void clear_has_Modalias ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Modalias;

};

/**
 * If the meaning of "ModaliasRegister" isn't clear, then there should be a description here.
 */
class ModaliasRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ModaliasRegister ();

    /**
     * Copy constructor
     */
    inline  ModaliasRegister (const ModaliasRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ModaliasRegister();

    /**
     * Assignment operator
     */
    inline ModaliasRegister& operator = (const ModaliasRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ModaliasRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ModaliasRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ModaliasRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ModaliasRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ModaliasRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "RSSIUpdate" isn't clear, then there should be a description here.
 */
class RSSIUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RSSIUpdate ();

    /**
     * Copy constructor
     */
    inline  RSSIUpdate (const RSSIUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RSSIUpdate (uint8 RSSI_);

    /**
     * Destructor
     */
    inline virtual  ~RSSIUpdate();

    /**
     * Assignment operator
     */
    inline RSSIUpdate& operator = (const RSSIUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RSSIUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RSSIUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RSSIUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RSSIUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RSSI"

    static const int kRSSI = 0;

    /**
     * Clears the field "RSSI".
     *
     * The field will be set to its default value. The hasRSSI()
     * method will return false.
     */
    inline void clearRSSI();

    /**
     * Checks whether the field "RSSI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSSI()). Otherwise it will return false.
     */
    inline bool hasRSSI () const;

    /**
     * Returns the value of the member "RSSI".
     *
     * If the meaning of "RSSI" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RSSI"
     */
    inline uint8 getRSSI () const;

    /**
     * Sets the value of the member "RSSI".
     *
     * If the meaning of "RSSI" isn't clear, then there should be a description here.
     *
     * @param RSSI The value which will be set
     */
    inline void setRSSI (uint8 RSSI_);

    static const RSSIUpdate &getDefaultInstance();

private:

    inline void set_has_RSSI ();

    inline void clear_has_RSSI ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _RSSI;

};

/**
 * If the meaning of "RSSIRegister" isn't clear, then there should be a description here.
 */
class RSSIRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RSSIRegister ();

    /**
     * Copy constructor
     */
    inline  RSSIRegister (const RSSIRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RSSIRegister();

    /**
     * Assignment operator
     */
    inline RSSIRegister& operator = (const RSSIRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RSSIRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RSSIRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RSSIRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RSSIRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RSSIRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "VendorUpdate" isn't clear, then there should be a description here.
 */
class VendorUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VendorUpdate ();

    /**
     * Copy constructor
     */
    inline  VendorUpdate (const VendorUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VendorUpdate (uint16 Vendor_);

    /**
     * Destructor
     */
    inline virtual  ~VendorUpdate();

    /**
     * Assignment operator
     */
    inline VendorUpdate& operator = (const VendorUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VendorUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VendorUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VendorUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VendorUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Vendor"

    static const int kVendor = 0;

    /**
     * Clears the field "Vendor".
     *
     * The field will be set to its default value. The hasVendor()
     * method will return false.
     */
    inline void clearVendor();

    /**
     * Checks whether the field "Vendor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVendor()). Otherwise it will return false.
     */
    inline bool hasVendor () const;

    /**
     * Returns the value of the member "Vendor".
     *
     * If the meaning of "Vendor" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Vendor"
     */
    inline uint16 getVendor () const;

    /**
     * Sets the value of the member "Vendor".
     *
     * If the meaning of "Vendor" isn't clear, then there should be a description here.
     *
     * @param Vendor The value which will be set
     */
    inline void setVendor (uint16 Vendor_);

    static const VendorUpdate &getDefaultInstance();

private:

    inline void set_has_Vendor ();

    inline void clear_has_Vendor ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Vendor;

};

/**
 * If the meaning of "VendorRegister" isn't clear, then there should be a description here.
 */
class VendorRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VendorRegister ();

    /**
     * Copy constructor
     */
    inline  VendorRegister (const VendorRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VendorRegister();

    /**
     * Assignment operator
     */
    inline VendorRegister& operator = (const VendorRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VendorRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VendorRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VendorRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VendorRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VendorRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "VendorSourceUpdate" isn't clear, then there should be a description here.
 */
class VendorSourceUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VendorSourceUpdate ();

    /**
     * Copy constructor
     */
    inline  VendorSourceUpdate (const VendorSourceUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VendorSourceUpdate (uint16 VendorSource_);

    /**
     * Destructor
     */
    inline virtual  ~VendorSourceUpdate();

    /**
     * Assignment operator
     */
    inline VendorSourceUpdate& operator = (const VendorSourceUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VendorSourceUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VendorSourceUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VendorSourceUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VendorSourceUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VendorSource"

    static const int kVendorSource = 0;

    /**
     * Clears the field "VendorSource".
     *
     * The field will be set to its default value. The hasVendorSource()
     * method will return false.
     */
    inline void clearVendorSource();

    /**
     * Checks whether the field "VendorSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVendorSource()). Otherwise it will return false.
     */
    inline bool hasVendorSource () const;

    /**
     * Returns the value of the member "VendorSource".
     *
     * If the meaning of "VendorSource" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VendorSource"
     */
    inline uint16 getVendorSource () const;

    /**
     * Sets the value of the member "VendorSource".
     *
     * If the meaning of "VendorSource" isn't clear, then there should be a description here.
     *
     * @param VendorSource The value which will be set
     */
    inline void setVendorSource (uint16 VendorSource_);

    static const VendorSourceUpdate &getDefaultInstance();

private:

    inline void set_has_VendorSource ();

    inline void clear_has_VendorSource ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _VendorSource;

};

/**
 * If the meaning of "VendorSourceRegister" isn't clear, then there should be a description here.
 */
class VendorSourceRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VendorSourceRegister ();

    /**
     * Copy constructor
     */
    inline  VendorSourceRegister (const VendorSourceRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VendorSourceRegister();

    /**
     * Assignment operator
     */
    inline VendorSourceRegister& operator = (const VendorSourceRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VendorSourceRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VendorSourceRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VendorSourceRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VendorSourceRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VendorSourceRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ProductUpdate" isn't clear, then there should be a description here.
 */
class ProductUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProductUpdate ();

    /**
     * Copy constructor
     */
    inline  ProductUpdate (const ProductUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ProductUpdate (uint16 Product_);

    /**
     * Destructor
     */
    inline virtual  ~ProductUpdate();

    /**
     * Assignment operator
     */
    inline ProductUpdate& operator = (const ProductUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProductUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProductUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProductUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProductUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Product"

    static const int kProduct = 0;

    /**
     * Clears the field "Product".
     *
     * The field will be set to its default value. The hasProduct()
     * method will return false.
     */
    inline void clearProduct();

    /**
     * Checks whether the field "Product" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProduct()). Otherwise it will return false.
     */
    inline bool hasProduct () const;

    /**
     * Returns the value of the member "Product".
     *
     * If the meaning of "Product" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Product"
     */
    inline uint16 getProduct () const;

    /**
     * Sets the value of the member "Product".
     *
     * If the meaning of "Product" isn't clear, then there should be a description here.
     *
     * @param Product The value which will be set
     */
    inline void setProduct (uint16 Product_);

    static const ProductUpdate &getDefaultInstance();

private:

    inline void set_has_Product ();

    inline void clear_has_Product ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Product;

};

/**
 * If the meaning of "ProductRegister" isn't clear, then there should be a description here.
 */
class ProductRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProductRegister ();

    /**
     * Copy constructor
     */
    inline  ProductRegister (const ProductRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ProductRegister();

    /**
     * Assignment operator
     */
    inline ProductRegister& operator = (const ProductRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProductRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProductRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProductRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProductRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ProductRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "MapInfoUpdate" isn't clear, then there should be a description here.
 */
class MapInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MapInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  MapInfoUpdate (const MapInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MapInfoUpdate (const ::std::vector< ::std::string >& MapInfo_);

    /**
     * Destructor
     */
    inline virtual  ~MapInfoUpdate();

    /**
     * Assignment operator
     */
    inline MapInfoUpdate& operator = (const MapInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MapInfo"

    static const int kMapInfo = 0;

    /**
     * Clears the field "MapInfo".
     *
     * The field will be set to its default value. The hasMapInfo()
     * method will return false.
     */
    inline void clearMapInfo();

    /**
     * Checks whether the field "MapInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMapInfo()). Otherwise it will return false.
     */
    inline bool hasMapInfo () const;

    /**
     * Returns the value of the member "MapInfo".
     *
     * If the meaning of "MapInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MapInfo"
     */
    inline const ::std::vector< ::std::string >& getMapInfo () const;

    /**
     * Retrieves the value of the field "MapInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MapInfo".
     */
    inline ::std::vector< ::std::string >& getMapInfoMutable ();

    /**
     * Sets the value of the member "MapInfo".
     *
     * If the meaning of "MapInfo" isn't clear, then there should be a description here.
     *
     * @param MapInfo The value which will be set
     */
    inline void setMapInfo (const ::std::vector< ::std::string >& MapInfo_);

    static const MapInfoUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_MapInfo ();

    inline void clear_has_MapInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _MapInfo;

};

/**
 * If the meaning of "MapInfoRegister" isn't clear, then there should be a description here.
 */
class MapInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MapInfoRegister ();

    /**
     * Copy constructor
     */
    inline  MapInfoRegister (const MapInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MapInfoRegister();

    /**
     * Assignment operator
     */
    inline MapInfoRegister& operator = (const MapInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MapInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ConnectedServiceUpdate" isn't clear, then there should be a description here.
 */
class ConnectedServiceUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectedServiceUpdate ();

    /**
     * Copy constructor
     */
    inline  ConnectedServiceUpdate (const ConnectedServiceUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectedServiceUpdate (uint64 ConnectedService_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectedServiceUpdate();

    /**
     * Assignment operator
     */
    inline ConnectedServiceUpdate& operator = (const ConnectedServiceUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectedServiceUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectedServiceUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectedServiceUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectedServiceUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConnectedService"

    static const int kConnectedService = 0;

    /**
     * Clears the field "ConnectedService".
     *
     * The field will be set to its default value. The hasConnectedService()
     * method will return false.
     */
    inline void clearConnectedService();

    /**
     * Checks whether the field "ConnectedService" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectedService()). Otherwise it will return false.
     */
    inline bool hasConnectedService () const;

    /**
     * Returns the value of the member "ConnectedService".
     *
     * If the meaning of "ConnectedService" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ConnectedService"
     */
    inline uint64 getConnectedService () const;

    /**
     * Sets the value of the member "ConnectedService".
     *
     * If the meaning of "ConnectedService" isn't clear, then there should be a description here.
     *
     * @param ConnectedService The value which will be set
     */
    inline void setConnectedService (uint64 ConnectedService_);

    static const ConnectedServiceUpdate &getDefaultInstance();

private:

    inline void set_has_ConnectedService ();

    inline void clear_has_ConnectedService ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _ConnectedService;

};

/**
 * If the meaning of "ConnectedServiceRegister" isn't clear, then there should be a description here.
 */
class ConnectedServiceRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectedServiceRegister ();

    /**
     * Copy constructor
     */
    inline  ConnectedServiceRegister (const ConnectedServiceRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConnectedServiceRegister();

    /**
     * Assignment operator
     */
    inline ConnectedServiceRegister& operator = (const ConnectedServiceRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectedServiceRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectedServiceRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectedServiceRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectedServiceRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConnectedServiceRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "VersionUpdate" isn't clear, then there should be a description here.
 */
class VersionUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VersionUpdate ();

    /**
     * Copy constructor
     */
    inline  VersionUpdate (const VersionUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VersionUpdate (uint16 Version_);

    /**
     * Destructor
     */
    inline virtual  ~VersionUpdate();

    /**
     * Assignment operator
     */
    inline VersionUpdate& operator = (const VersionUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VersionUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VersionUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VersionUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VersionUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Version"

    static const int kVersion = 0;

    /**
     * Clears the field "Version".
     *
     * The field will be set to its default value. The hasVersion()
     * method will return false.
     */
    inline void clearVersion();

    /**
     * Checks whether the field "Version" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersion()). Otherwise it will return false.
     */
    inline bool hasVersion () const;

    /**
     * Returns the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Version"
     */
    inline uint16 getVersion () const;

    /**
     * Sets the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (uint16 Version_);

    static const VersionUpdate &getDefaultInstance();

private:

    inline void set_has_Version ();

    inline void clear_has_Version ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Version;

};

/**
 * If the meaning of "VersionRegister" isn't clear, then there should be a description here.
 */
class VersionRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VersionRegister ();

    /**
     * Copy constructor
     */
    inline  VersionRegister (const VersionRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VersionRegister();

    /**
     * Assignment operator
     */
    inline VersionRegister& operator = (const VersionRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VersionRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VersionRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VersionRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VersionRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VersionRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PBAPInfoUpdate" isn't clear, then there should be a description here.
 */
class PBAPInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PBAPInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  PBAPInfoUpdate (const PBAPInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PBAPInfoUpdate (const ::std::string& PBAPInfo_);

    /**
     * Destructor
     */
    inline virtual  ~PBAPInfoUpdate();

    /**
     * Assignment operator
     */
    inline PBAPInfoUpdate& operator = (const PBAPInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PBAPInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PBAPInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PBAPInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PBAPInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PBAPInfo"

    static const int kPBAPInfo = 0;

    /**
     * Clears the field "PBAPInfo".
     *
     * The field will be set to its default value. The hasPBAPInfo()
     * method will return false.
     */
    inline void clearPBAPInfo();

    /**
     * Checks whether the field "PBAPInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPBAPInfo()). Otherwise it will return false.
     */
    inline bool hasPBAPInfo () const;

    /**
     * Returns the value of the member "PBAPInfo".
     *
     * If the meaning of "PBAPInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PBAPInfo"
     */
    inline const ::std::string& getPBAPInfo () const;

    /**
     * Retrieves the value of the field "PBAPInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PBAPInfo".
     */
    inline ::std::string& getPBAPInfoMutable ();

    /**
     * Sets the value of the member "PBAPInfo".
     *
     * If the meaning of "PBAPInfo" isn't clear, then there should be a description here.
     *
     * @param PBAPInfo The value which will be set
     */
    inline void setPBAPInfo (const ::std::string& PBAPInfo_);

    /**
     * Sets the value of the member "PBAPInfo".
     *
     * If the meaning of "PBAPInfo" isn't clear, then there should be a description here.
     *
     * @param PBAPInfo The value which will be set
     */
    inline void setPBAPInfo (const char* PBAPInfo_);

    /**
     * Sets the value of the member "PBAPInfo".
     *
     * If the meaning of "PBAPInfo" isn't clear, then there should be a description here.
     *
     * @param PBAPInfo The value which will be set
     */
    inline void setPBAPInfo (const char* value, size_t size);

    static const PBAPInfoUpdate &getDefaultInstance();

private:

    inline void set_has_PBAPInfo ();

    inline void clear_has_PBAPInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _PBAPInfo;

};

/**
 * If the meaning of "PBAPInfoRegister" isn't clear, then there should be a description here.
 */
class PBAPInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PBAPInfoRegister ();

    /**
     * Copy constructor
     */
    inline  PBAPInfoRegister (const PBAPInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PBAPInfoRegister();

    /**
     * Assignment operator
     */
    inline PBAPInfoRegister& operator = (const PBAPInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PBAPInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PBAPInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PBAPInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PBAPInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PBAPInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ModeUpdate" isn't clear, then there should be a description here.
 */
class ModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ModeUpdate ();

    /**
     * Copy constructor
     */
    inline  ModeUpdate (const ModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ModeUpdate (uint8 Mode_);

    /**
     * Destructor
     */
    inline virtual  ~ModeUpdate();

    /**
     * Assignment operator
     */
    inline ModeUpdate& operator = (const ModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Mode"

    static const int kMode = 0;

    /**
     * Clears the field "Mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "Mode".
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Mode"
     */
    inline uint8 getMode () const;

    /**
     * Sets the value of the member "Mode".
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @param Mode The value which will be set
     */
    inline void setMode (uint8 Mode_);

    static const ModeUpdate &getDefaultInstance();

private:

    inline void set_has_Mode ();

    inline void clear_has_Mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Mode;

};

/**
 * If the meaning of "ModeRegister" isn't clear, then there should be a description here.
 */
class ModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ModeRegister ();

    /**
     * Copy constructor
     */
    inline  ModeRegister (const ModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ModeRegister();

    /**
     * Assignment operator
     */
    inline ModeRegister& operator = (const ModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "RoleUpdate" isn't clear, then there should be a description here.
 */
class RoleUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RoleUpdate ();

    /**
     * Copy constructor
     */
    inline  RoleUpdate (const RoleUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RoleUpdate (uint8 Role_);

    /**
     * Destructor
     */
    inline virtual  ~RoleUpdate();

    /**
     * Assignment operator
     */
    inline RoleUpdate& operator = (const RoleUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RoleUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RoleUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RoleUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RoleUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Role"

    static const int kRole = 0;

    /**
     * Clears the field "Role".
     *
     * The field will be set to its default value. The hasRole()
     * method will return false.
     */
    inline void clearRole();

    /**
     * Checks whether the field "Role" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRole()). Otherwise it will return false.
     */
    inline bool hasRole () const;

    /**
     * Returns the value of the member "Role".
     *
     * If the meaning of "Role" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Role"
     */
    inline uint8 getRole () const;

    /**
     * Sets the value of the member "Role".
     *
     * If the meaning of "Role" isn't clear, then there should be a description here.
     *
     * @param Role The value which will be set
     */
    inline void setRole (uint8 Role_);

    static const RoleUpdate &getDefaultInstance();

private:

    inline void set_has_Role ();

    inline void clear_has_Role ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Role;

};

/**
 * If the meaning of "RoleRegister" isn't clear, then there should be a description here.
 */
class RoleRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RoleRegister ();

    /**
     * Copy constructor
     */
    inline  RoleRegister (const RoleRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RoleRegister();

    /**
     * Assignment operator
     */
    inline RoleRegister& operator = (const RoleRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RoleRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RoleRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RoleRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RoleRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RoleRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "EnableAvpPauseUpdate" isn't clear, then there should be a description here.
 */
class EnableAvpPauseUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EnableAvpPauseUpdate ();

    /**
     * Copy constructor
     */
    inline  EnableAvpPauseUpdate (const EnableAvpPauseUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  EnableAvpPauseUpdate (bool EnableAvpPause_);

    /**
     * Destructor
     */
    inline virtual  ~EnableAvpPauseUpdate();

    /**
     * Assignment operator
     */
    inline EnableAvpPauseUpdate& operator = (const EnableAvpPauseUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnableAvpPauseUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnableAvpPauseUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnableAvpPauseUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnableAvpPauseUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EnableAvpPause"

    static const int kEnableAvpPause = 0;

    /**
     * Clears the field "EnableAvpPause".
     *
     * The field will be set to its default value. The hasEnableAvpPause()
     * method will return false.
     */
    inline void clearEnableAvpPause();

    /**
     * Checks whether the field "EnableAvpPause" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnableAvpPause()). Otherwise it will return false.
     */
    inline bool hasEnableAvpPause () const;

    /**
     * Returns the value of the member "EnableAvpPause".
     *
     * If the meaning of "EnableAvpPause" isn't clear, then there should be a description here.
     *
     * @return The value of the field "EnableAvpPause"
     */
    inline bool getEnableAvpPause () const;

    /**
     * Sets the value of the member "EnableAvpPause".
     *
     * If the meaning of "EnableAvpPause" isn't clear, then there should be a description here.
     *
     * @param EnableAvpPause The value which will be set
     */
    inline void setEnableAvpPause (bool EnableAvpPause_);

    static const EnableAvpPauseUpdate &getDefaultInstance();

private:

    inline void set_has_EnableAvpPause ();

    inline void clear_has_EnableAvpPause ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _EnableAvpPause;

};

/**
 * If the meaning of "EnableAvpPauseRegister" isn't clear, then there should be a description here.
 */
class EnableAvpPauseRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EnableAvpPauseRegister ();

    /**
     * Copy constructor
     */
    inline  EnableAvpPauseRegister (const EnableAvpPauseRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~EnableAvpPauseRegister();

    /**
     * Assignment operator
     */
    inline EnableAvpPauseRegister& operator = (const EnableAvpPauseRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnableAvpPauseRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnableAvpPauseRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnableAvpPauseRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnableAvpPauseRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const EnableAvpPauseRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ReportLinkkeySignal" isn't clear, then there should be a description here.
 */
class ReportLinkkeySignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReportLinkkeySignal ();

    /**
     * Copy constructor
     */
    inline  ReportLinkkeySignal (const ReportLinkkeySignal &rhs);

    /**
     * All fields constructor
     */
    inline  ReportLinkkeySignal (const ::std::vector< uint8 >& linkkey_);

    /**
     * Destructor
     */
    inline virtual  ~ReportLinkkeySignal();

    /**
     * Assignment operator
     */
    inline ReportLinkkeySignal& operator = (const ReportLinkkeySignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReportLinkkeySignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReportLinkkeySignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReportLinkkeySignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReportLinkkeySignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "linkkey"

    static const int kLinkkey = 0;

    /**
     * Clears the field "linkkey".
     *
     * The field will be set to its default value. The hasLinkkey()
     * method will return false.
     */
    inline void clearLinkkey();

    /**
     * Checks whether the field "linkkey" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLinkkey()). Otherwise it will return false.
     */
    inline bool hasLinkkey () const;

    /**
     * Returns the value of the member "linkkey".
     *
     * If the meaning of "linkkey" isn't clear, then there should be a description here.
     *
     * @return The value of the field "linkkey"
     */
    inline const ::std::vector< uint8 >& getLinkkey () const;

    /**
     * Retrieves the value of the field "linkkey" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "linkkey".
     */
    inline ::std::vector< uint8 >& getLinkkeyMutable ();

    /**
     * Sets the value of the member "linkkey".
     *
     * If the meaning of "linkkey" isn't clear, then there should be a description here.
     *
     * @param linkkey The value which will be set
     */
    inline void setLinkkey (const ::std::vector< uint8 >& linkkey_);

    static const ReportLinkkeySignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_linkkey ();

    inline void clear_has_linkkey ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _linkkey;

};

/**
 * If the meaning of "IncomingPairingCompSignal" isn't clear, then there should be a description here.
 */
class IncomingPairingCompSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IncomingPairingCompSignal ();

    /**
     * Copy constructor
     */
    inline  IncomingPairingCompSignal (const IncomingPairingCompSignal &rhs);

    /**
     * All fields constructor
     */
    inline  IncomingPairingCompSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~IncomingPairingCompSignal();

    /**
     * Assignment operator
     */
    inline IncomingPairingCompSignal& operator = (const IncomingPairingCompSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IncomingPairingCompSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IncomingPairingCompSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IncomingPairingCompSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IncomingPairingCompSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const IncomingPairingCompSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

/**
 * If the meaning of "SDPProcessReportSignal" isn't clear, then there should be a description here.
 */
class SDPProcessReportSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SDPProcessReportSignal ();

    /**
     * Copy constructor
     */
    inline  SDPProcessReportSignal (const SDPProcessReportSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SDPProcessReportSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~SDPProcessReportSignal();

    /**
     * Assignment operator
     */
    inline SDPProcessReportSignal& operator = (const SDPProcessReportSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SDPProcessReportSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SDPProcessReportSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SDPProcessReportSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SDPProcessReportSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const SDPProcessReportSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

inline  DiscoverServicesRequest::DiscoverServicesRequest ()  :
    _pattern ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiscoverServicesRequest::DiscoverServicesRequest (const DiscoverServicesRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _pattern ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiscoverServicesRequest::DiscoverServicesRequest (const ::std::string& pattern_)  :
    _pattern (pattern_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (pattern_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiscoverServicesRequest::~DiscoverServicesRequest() {
}

inline DiscoverServicesRequest& DiscoverServicesRequest::operator = (const DiscoverServicesRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPattern()) {
            setPattern(rhs.getPattern());
        } else {
            clearPattern();
        }
    }
    return *this;
}

inline bool DiscoverServicesRequest::operator == (const DiscoverServicesRequest& rhs) const {
    return (((!hasPattern() && !rhs.hasPattern()) || getPattern() == rhs.getPattern()));
}

inline bool DiscoverServicesRequest::operator != (const DiscoverServicesRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DiscoverServicesRequest::operator < (const DiscoverServicesRequest& rhs) const {
    if (hasPattern() || rhs.hasPattern()) {
        if (getPattern() < rhs.getPattern()) return true;
        if (getPattern() > rhs.getPattern()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiscoverServicesRequest::clone() {
    return new DiscoverServicesRequest(*this);
}

inline bool DiscoverServicesRequest::operator > (const DiscoverServicesRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiscoverServicesRequest::clear() {
    clearPattern();
}

inline void DiscoverServicesRequest::clearPattern() {
    if (hasPattern()) {
         clear_has_pattern();
        _pattern.clear();
     }
}

inline bool DiscoverServicesRequest::hasPattern () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DiscoverServicesRequest::getPattern () const {
    return _pattern;
}

inline ::std::string& DiscoverServicesRequest::getPatternMutable () {
    set_has_pattern();
    return _pattern;
}

inline void DiscoverServicesRequest::setPattern (const ::std::string& pattern_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (pattern_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_pattern();
    this->_pattern = pattern_;
}

inline void DiscoverServicesRequest::setPattern (const char* pattern_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (pattern_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_pattern();
    this->_pattern.assign(pattern_);
}

inline void DiscoverServicesRequest::setPattern (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_pattern();
    this->_pattern.assign(value, size);
}

inline void DiscoverServicesRequest::set_has_pattern () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiscoverServicesRequest::clear_has_pattern () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddressUpdate::AddressUpdate ()  :
    _Address ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddressUpdate::AddressUpdate (const AddressUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Address ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddressUpdate::AddressUpdate (const ::std::string& Address_)  :
    _Address (Address_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddressUpdate::~AddressUpdate() {
}

inline AddressUpdate& AddressUpdate::operator = (const AddressUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
    }
    return *this;
}

inline bool AddressUpdate::operator == (const AddressUpdate& rhs) const {
    return (((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()));
}

inline bool AddressUpdate::operator != (const AddressUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AddressUpdate::operator < (const AddressUpdate& rhs) const {
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddressUpdate::clone() {
    return new AddressUpdate(*this);
}

inline bool AddressUpdate::operator > (const AddressUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddressUpdate::clear() {
    clearAddress();
}

inline void AddressUpdate::clearAddress() {
    if (hasAddress()) {
         clear_has_Address();
        _Address.clear();
     }
}

inline bool AddressUpdate::hasAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AddressUpdate::getAddress () const {
    return _Address;
}

inline ::std::string& AddressUpdate::getAddressMutable () {
    set_has_Address();
    return _Address;
}

inline void AddressUpdate::setAddress (const ::std::string& Address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Address();
    this->_Address = Address_;
}

inline void AddressUpdate::setAddress (const char* Address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Address();
    this->_Address.assign(Address_);
}

inline void AddressUpdate::setAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Address();
    this->_Address.assign(value, size);
}

inline void AddressUpdate::set_has_Address () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddressUpdate::clear_has_Address () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddressRegister::AddressRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddressRegister::AddressRegister (const AddressRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddressRegister::~AddressRegister() {
}

inline AddressRegister& AddressRegister::operator = (const AddressRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AddressRegister::operator == (const AddressRegister& ) const {
    return true;
}

inline bool AddressRegister::operator != (const AddressRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AddressRegister::operator < (const AddressRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AddressRegister::clone() {
    return new AddressRegister(*this);
}

inline bool AddressRegister::operator > (const AddressRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddressRegister::clear() {
}

inline  ClassUpdate::ClassUpdate ()  :
    _Class (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClassUpdate::ClassUpdate (const ClassUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Class (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClassUpdate::ClassUpdate (uint32 Class_)  :
    _Class (Class_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ClassUpdate::~ClassUpdate() {
}

inline ClassUpdate& ClassUpdate::operator = (const ClassUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClass()) {
            setClass(rhs.getClass());
        } else {
            clearClass();
        }
    }
    return *this;
}

inline bool ClassUpdate::operator == (const ClassUpdate& rhs) const {
    return (((!hasClass() && !rhs.hasClass()) || getClass() == rhs.getClass()));
}

inline bool ClassUpdate::operator != (const ClassUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ClassUpdate::operator < (const ClassUpdate& rhs) const {
    if (hasClass() || rhs.hasClass()) {
        if (getClass() < rhs.getClass()) return true;
        if (getClass() > rhs.getClass()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ClassUpdate::clone() {
    return new ClassUpdate(*this);
}

inline bool ClassUpdate::operator > (const ClassUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClassUpdate::clear() {
    clearClass();
}

inline void ClassUpdate::clearClass() {
    if (hasClass()) {
         clear_has_Class();
        _Class = 0u;
     }
}

inline bool ClassUpdate::hasClass () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ClassUpdate::getClass () const {
    return _Class;
}

inline void ClassUpdate::setClass (uint32 Class_) {
    set_has_Class();
    this->_Class = Class_;
}

inline void ClassUpdate::set_has_Class () {
    _has_bits_[0] |= 1u << 0;
}

inline void ClassUpdate::clear_has_Class () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ClassRegister::ClassRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClassRegister::ClassRegister (const ClassRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClassRegister::~ClassRegister() {
}

inline ClassRegister& ClassRegister::operator = (const ClassRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ClassRegister::operator == (const ClassRegister& ) const {
    return true;
}

inline bool ClassRegister::operator != (const ClassRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ClassRegister::operator < (const ClassRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ClassRegister::clone() {
    return new ClassRegister(*this);
}

inline bool ClassRegister::operator > (const ClassRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClassRegister::clear() {
}

inline  IconUpdate::IconUpdate ()  :
    _Icon ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IconUpdate::IconUpdate (const IconUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Icon ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IconUpdate::IconUpdate (const ::std::string& Icon_)  :
    _Icon (Icon_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Icon_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  IconUpdate::~IconUpdate() {
}

inline IconUpdate& IconUpdate::operator = (const IconUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIcon()) {
            setIcon(rhs.getIcon());
        } else {
            clearIcon();
        }
    }
    return *this;
}

inline bool IconUpdate::operator == (const IconUpdate& rhs) const {
    return (((!hasIcon() && !rhs.hasIcon()) || getIcon() == rhs.getIcon()));
}

inline bool IconUpdate::operator != (const IconUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool IconUpdate::operator < (const IconUpdate& rhs) const {
    if (hasIcon() || rhs.hasIcon()) {
        if (getIcon() < rhs.getIcon()) return true;
        if (getIcon() > rhs.getIcon()) return false;
    }
    return false;
}

inline ::asf::core::Payload* IconUpdate::clone() {
    return new IconUpdate(*this);
}

inline bool IconUpdate::operator > (const IconUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IconUpdate::clear() {
    clearIcon();
}

inline void IconUpdate::clearIcon() {
    if (hasIcon()) {
         clear_has_Icon();
        _Icon.clear();
     }
}

inline bool IconUpdate::hasIcon () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& IconUpdate::getIcon () const {
    return _Icon;
}

inline ::std::string& IconUpdate::getIconMutable () {
    set_has_Icon();
    return _Icon;
}

inline void IconUpdate::setIcon (const ::std::string& Icon_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Icon_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Icon();
    this->_Icon = Icon_;
}

inline void IconUpdate::setIcon (const char* Icon_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Icon_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Icon();
    this->_Icon.assign(Icon_);
}

inline void IconUpdate::setIcon (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Icon();
    this->_Icon.assign(value, size);
}

inline void IconUpdate::set_has_Icon () {
    _has_bits_[0] |= 1u << 0;
}

inline void IconUpdate::clear_has_Icon () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  IconRegister::IconRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IconRegister::IconRegister (const IconRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IconRegister::~IconRegister() {
}

inline IconRegister& IconRegister::operator = (const IconRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool IconRegister::operator == (const IconRegister& ) const {
    return true;
}

inline bool IconRegister::operator != (const IconRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool IconRegister::operator < (const IconRegister& ) const {
    return false;
}

inline ::asf::core::Payload* IconRegister::clone() {
    return new IconRegister(*this);
}

inline bool IconRegister::operator > (const IconRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IconRegister::clear() {
}

inline  UUIDsUpdate::UUIDsUpdate ()  :
    _UUIDs ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UUIDsUpdate::UUIDsUpdate (const UUIDsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _UUIDs ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UUIDsUpdate::UUIDsUpdate (const ::std::vector< ::std::string >& UUIDs_)  :
    _UUIDs (UUIDs_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UUIDsUpdate::~UUIDsUpdate() {
}

inline UUIDsUpdate& UUIDsUpdate::operator = (const UUIDsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUUIDs()) {
            setUUIDs(rhs.getUUIDs());
        } else {
            clearUUIDs();
        }
    }
    return *this;
}

inline bool UUIDsUpdate::operator == (const UUIDsUpdate& rhs) const {
    return (((!hasUUIDs() && !rhs.hasUUIDs()) || getUUIDs() == rhs.getUUIDs()));
}

inline bool UUIDsUpdate::operator != (const UUIDsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool UUIDsUpdate::operator < (const UUIDsUpdate& rhs) const {
    if (hasUUIDs() || rhs.hasUUIDs()) {
        if (getUUIDs() < rhs.getUUIDs()) return true;
        if (getUUIDs() > rhs.getUUIDs()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UUIDsUpdate::clone() {
    return new UUIDsUpdate(*this);
}

inline bool UUIDsUpdate::operator > (const UUIDsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UUIDsUpdate::clear() {
    clearUUIDs();
}

inline void UUIDsUpdate::clearUUIDs() {
    if (hasUUIDs()) {
         clear_has_UUIDs();
        _UUIDs.clear();
     }
}

inline bool UUIDsUpdate::hasUUIDs () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& UUIDsUpdate::getUUIDs () const {
    return _UUIDs;
}

inline ::std::vector< ::std::string >& UUIDsUpdate::getUUIDsMutable () {
    set_has_UUIDs();
    return _UUIDs;
}

inline void UUIDsUpdate::setUUIDs (const ::std::vector< ::std::string >& UUIDs_) {
    set_has_UUIDs();
    this->_UUIDs = UUIDs_;
}

inline void UUIDsUpdate::set_has_UUIDs () {
    _has_bits_[0] |= 1u << 0;
}

inline void UUIDsUpdate::clear_has_UUIDs () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UUIDsRegister::UUIDsRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UUIDsRegister::UUIDsRegister (const UUIDsRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UUIDsRegister::~UUIDsRegister() {
}

inline UUIDsRegister& UUIDsRegister::operator = (const UUIDsRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool UUIDsRegister::operator == (const UUIDsRegister& ) const {
    return true;
}

inline bool UUIDsRegister::operator != (const UUIDsRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool UUIDsRegister::operator < (const UUIDsRegister& ) const {
    return false;
}

inline ::asf::core::Payload* UUIDsRegister::clone() {
    return new UUIDsRegister(*this);
}

inline bool UUIDsRegister::operator > (const UUIDsRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UUIDsRegister::clear() {
}

inline  PairedUpdate::PairedUpdate ()  :
    _Paired (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PairedUpdate::PairedUpdate (const PairedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Paired (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PairedUpdate::PairedUpdate (bool Paired_)  :
    _Paired (Paired_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PairedUpdate::~PairedUpdate() {
}

inline PairedUpdate& PairedUpdate::operator = (const PairedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPaired()) {
            setPaired(rhs.getPaired());
        } else {
            clearPaired();
        }
    }
    return *this;
}

inline bool PairedUpdate::operator == (const PairedUpdate& rhs) const {
    return (((!hasPaired() && !rhs.hasPaired()) || getPaired() == rhs.getPaired()));
}

inline bool PairedUpdate::operator != (const PairedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PairedUpdate::operator < (const PairedUpdate& rhs) const {
    if (hasPaired() || rhs.hasPaired()) {
        if (getPaired() < rhs.getPaired()) return true;
        if (getPaired() > rhs.getPaired()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PairedUpdate::clone() {
    return new PairedUpdate(*this);
}

inline bool PairedUpdate::operator > (const PairedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PairedUpdate::clear() {
    clearPaired();
}

inline void PairedUpdate::clearPaired() {
    if (hasPaired()) {
         clear_has_Paired();
        _Paired = false;
     }
}

inline bool PairedUpdate::hasPaired () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool PairedUpdate::getPaired () const {
    return _Paired;
}

inline void PairedUpdate::setPaired (bool Paired_) {
    set_has_Paired();
    this->_Paired = Paired_;
}

inline void PairedUpdate::set_has_Paired () {
    _has_bits_[0] |= 1u << 0;
}

inline void PairedUpdate::clear_has_Paired () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PairedRegister::PairedRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PairedRegister::PairedRegister (const PairedRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PairedRegister::~PairedRegister() {
}

inline PairedRegister& PairedRegister::operator = (const PairedRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PairedRegister::operator == (const PairedRegister& ) const {
    return true;
}

inline bool PairedRegister::operator != (const PairedRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PairedRegister::operator < (const PairedRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PairedRegister::clone() {
    return new PairedRegister(*this);
}

inline bool PairedRegister::operator > (const PairedRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PairedRegister::clear() {
}

inline  ConnectedUpdate::ConnectedUpdate ()  :
    _Connected (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectedUpdate::ConnectedUpdate (const ConnectedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Connected (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectedUpdate::ConnectedUpdate (bool Connected_)  :
    _Connected (Connected_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConnectedUpdate::~ConnectedUpdate() {
}

inline ConnectedUpdate& ConnectedUpdate::operator = (const ConnectedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConnected()) {
            setConnected(rhs.getConnected());
        } else {
            clearConnected();
        }
    }
    return *this;
}

inline bool ConnectedUpdate::operator == (const ConnectedUpdate& rhs) const {
    return (((!hasConnected() && !rhs.hasConnected()) || getConnected() == rhs.getConnected()));
}

inline bool ConnectedUpdate::operator != (const ConnectedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectedUpdate::operator < (const ConnectedUpdate& rhs) const {
    if (hasConnected() || rhs.hasConnected()) {
        if (getConnected() < rhs.getConnected()) return true;
        if (getConnected() > rhs.getConnected()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConnectedUpdate::clone() {
    return new ConnectedUpdate(*this);
}

inline bool ConnectedUpdate::operator > (const ConnectedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectedUpdate::clear() {
    clearConnected();
}

inline void ConnectedUpdate::clearConnected() {
    if (hasConnected()) {
         clear_has_Connected();
        _Connected = false;
     }
}

inline bool ConnectedUpdate::hasConnected () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ConnectedUpdate::getConnected () const {
    return _Connected;
}

inline void ConnectedUpdate::setConnected (bool Connected_) {
    set_has_Connected();
    this->_Connected = Connected_;
}

inline void ConnectedUpdate::set_has_Connected () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConnectedUpdate::clear_has_Connected () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ConnectedRegister::ConnectedRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectedRegister::ConnectedRegister (const ConnectedRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectedRegister::~ConnectedRegister() {
}

inline ConnectedRegister& ConnectedRegister::operator = (const ConnectedRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ConnectedRegister::operator == (const ConnectedRegister& ) const {
    return true;
}

inline bool ConnectedRegister::operator != (const ConnectedRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectedRegister::operator < (const ConnectedRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ConnectedRegister::clone() {
    return new ConnectedRegister(*this);
}

inline bool ConnectedRegister::operator > (const ConnectedRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectedRegister::clear() {
}

inline  TrustedUpdate::TrustedUpdate ()  :
    _Trusted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TrustedUpdate::TrustedUpdate (const TrustedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Trusted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TrustedUpdate::TrustedUpdate (bool Trusted_)  :
    _Trusted (Trusted_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TrustedUpdate::~TrustedUpdate() {
}

inline TrustedUpdate& TrustedUpdate::operator = (const TrustedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTrusted()) {
            setTrusted(rhs.getTrusted());
        } else {
            clearTrusted();
        }
    }
    return *this;
}

inline bool TrustedUpdate::operator == (const TrustedUpdate& rhs) const {
    return (((!hasTrusted() && !rhs.hasTrusted()) || getTrusted() == rhs.getTrusted()));
}

inline bool TrustedUpdate::operator != (const TrustedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool TrustedUpdate::operator < (const TrustedUpdate& rhs) const {
    if (hasTrusted() || rhs.hasTrusted()) {
        if (getTrusted() < rhs.getTrusted()) return true;
        if (getTrusted() > rhs.getTrusted()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TrustedUpdate::clone() {
    return new TrustedUpdate(*this);
}

inline bool TrustedUpdate::operator > (const TrustedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TrustedUpdate::clear() {
    clearTrusted();
}

inline void TrustedUpdate::clearTrusted() {
    if (hasTrusted()) {
         clear_has_Trusted();
        _Trusted = false;
     }
}

inline bool TrustedUpdate::hasTrusted () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool TrustedUpdate::getTrusted () const {
    return _Trusted;
}

inline void TrustedUpdate::setTrusted (bool Trusted_) {
    set_has_Trusted();
    this->_Trusted = Trusted_;
}

inline void TrustedUpdate::set_has_Trusted () {
    _has_bits_[0] |= 1u << 0;
}

inline void TrustedUpdate::clear_has_Trusted () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TrustedRegister::TrustedRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TrustedRegister::TrustedRegister (const TrustedRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TrustedRegister::~TrustedRegister() {
}

inline TrustedRegister& TrustedRegister::operator = (const TrustedRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool TrustedRegister::operator == (const TrustedRegister& ) const {
    return true;
}

inline bool TrustedRegister::operator != (const TrustedRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool TrustedRegister::operator < (const TrustedRegister& ) const {
    return false;
}

inline ::asf::core::Payload* TrustedRegister::clone() {
    return new TrustedRegister(*this);
}

inline bool TrustedRegister::operator > (const TrustedRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TrustedRegister::clear() {
}

inline  BlockedUpdate::BlockedUpdate ()  :
    _Blocked (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BlockedUpdate::BlockedUpdate (const BlockedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Blocked (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BlockedUpdate::BlockedUpdate (bool Blocked_)  :
    _Blocked (Blocked_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BlockedUpdate::~BlockedUpdate() {
}

inline BlockedUpdate& BlockedUpdate::operator = (const BlockedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBlocked()) {
            setBlocked(rhs.getBlocked());
        } else {
            clearBlocked();
        }
    }
    return *this;
}

inline bool BlockedUpdate::operator == (const BlockedUpdate& rhs) const {
    return (((!hasBlocked() && !rhs.hasBlocked()) || getBlocked() == rhs.getBlocked()));
}

inline bool BlockedUpdate::operator != (const BlockedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool BlockedUpdate::operator < (const BlockedUpdate& rhs) const {
    if (hasBlocked() || rhs.hasBlocked()) {
        if (getBlocked() < rhs.getBlocked()) return true;
        if (getBlocked() > rhs.getBlocked()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BlockedUpdate::clone() {
    return new BlockedUpdate(*this);
}

inline bool BlockedUpdate::operator > (const BlockedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BlockedUpdate::clear() {
    clearBlocked();
}

inline void BlockedUpdate::clearBlocked() {
    if (hasBlocked()) {
         clear_has_Blocked();
        _Blocked = false;
     }
}

inline bool BlockedUpdate::hasBlocked () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool BlockedUpdate::getBlocked () const {
    return _Blocked;
}

inline void BlockedUpdate::setBlocked (bool Blocked_) {
    set_has_Blocked();
    this->_Blocked = Blocked_;
}

inline void BlockedUpdate::set_has_Blocked () {
    _has_bits_[0] |= 1u << 0;
}

inline void BlockedUpdate::clear_has_Blocked () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BlockedRegister::BlockedRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BlockedRegister::BlockedRegister (const BlockedRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BlockedRegister::~BlockedRegister() {
}

inline BlockedRegister& BlockedRegister::operator = (const BlockedRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool BlockedRegister::operator == (const BlockedRegister& ) const {
    return true;
}

inline bool BlockedRegister::operator != (const BlockedRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool BlockedRegister::operator < (const BlockedRegister& ) const {
    return false;
}

inline ::asf::core::Payload* BlockedRegister::clone() {
    return new BlockedRegister(*this);
}

inline bool BlockedRegister::operator > (const BlockedRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BlockedRegister::clear() {
}

inline  AliasUpdate::AliasUpdate ()  :
    _Alias ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AliasUpdate::AliasUpdate (const AliasUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Alias ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AliasUpdate::AliasUpdate (const ::std::string& Alias_)  :
    _Alias (Alias_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Alias_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AliasUpdate::~AliasUpdate() {
}

inline AliasUpdate& AliasUpdate::operator = (const AliasUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAlias()) {
            setAlias(rhs.getAlias());
        } else {
            clearAlias();
        }
    }
    return *this;
}

inline bool AliasUpdate::operator == (const AliasUpdate& rhs) const {
    return (((!hasAlias() && !rhs.hasAlias()) || getAlias() == rhs.getAlias()));
}

inline bool AliasUpdate::operator != (const AliasUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AliasUpdate::operator < (const AliasUpdate& rhs) const {
    if (hasAlias() || rhs.hasAlias()) {
        if (getAlias() < rhs.getAlias()) return true;
        if (getAlias() > rhs.getAlias()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AliasUpdate::clone() {
    return new AliasUpdate(*this);
}

inline bool AliasUpdate::operator > (const AliasUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AliasUpdate::clear() {
    clearAlias();
}

inline void AliasUpdate::clearAlias() {
    if (hasAlias()) {
         clear_has_Alias();
        _Alias.clear();
     }
}

inline bool AliasUpdate::hasAlias () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AliasUpdate::getAlias () const {
    return _Alias;
}

inline ::std::string& AliasUpdate::getAliasMutable () {
    set_has_Alias();
    return _Alias;
}

inline void AliasUpdate::setAlias (const ::std::string& Alias_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Alias_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Alias();
    this->_Alias = Alias_;
}

inline void AliasUpdate::setAlias (const char* Alias_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Alias_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Alias();
    this->_Alias.assign(Alias_);
}

inline void AliasUpdate::setAlias (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Alias();
    this->_Alias.assign(value, size);
}

inline void AliasUpdate::set_has_Alias () {
    _has_bits_[0] |= 1u << 0;
}

inline void AliasUpdate::clear_has_Alias () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AliasRegister::AliasRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AliasRegister::AliasRegister (const AliasRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AliasRegister::~AliasRegister() {
}

inline AliasRegister& AliasRegister::operator = (const AliasRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AliasRegister::operator == (const AliasRegister& ) const {
    return true;
}

inline bool AliasRegister::operator != (const AliasRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AliasRegister::operator < (const AliasRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AliasRegister::clone() {
    return new AliasRegister(*this);
}

inline bool AliasRegister::operator > (const AliasRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AliasRegister::clear() {
}

inline  AdapterUpdate::AdapterUpdate ()  :
    _Adapter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AdapterUpdate::AdapterUpdate (const AdapterUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Adapter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AdapterUpdate::AdapterUpdate (const ::std::string& Adapter_)  :
    _Adapter (Adapter_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Adapter_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AdapterUpdate::~AdapterUpdate() {
}

inline AdapterUpdate& AdapterUpdate::operator = (const AdapterUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAdapter()) {
            setAdapter(rhs.getAdapter());
        } else {
            clearAdapter();
        }
    }
    return *this;
}

inline bool AdapterUpdate::operator == (const AdapterUpdate& rhs) const {
    return (((!hasAdapter() && !rhs.hasAdapter()) || getAdapter() == rhs.getAdapter()));
}

inline bool AdapterUpdate::operator != (const AdapterUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AdapterUpdate::operator < (const AdapterUpdate& rhs) const {
    if (hasAdapter() || rhs.hasAdapter()) {
        if (getAdapter() < rhs.getAdapter()) return true;
        if (getAdapter() > rhs.getAdapter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AdapterUpdate::clone() {
    return new AdapterUpdate(*this);
}

inline bool AdapterUpdate::operator > (const AdapterUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AdapterUpdate::clear() {
    clearAdapter();
}

inline void AdapterUpdate::clearAdapter() {
    if (hasAdapter()) {
         clear_has_Adapter();
        _Adapter.clear();
     }
}

inline bool AdapterUpdate::hasAdapter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AdapterUpdate::getAdapter () const {
    return _Adapter;
}

inline ::std::string& AdapterUpdate::getAdapterMutable () {
    set_has_Adapter();
    return _Adapter;
}

inline void AdapterUpdate::setAdapter (const ::std::string& Adapter_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Adapter_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Adapter();
    this->_Adapter = Adapter_;
}

inline void AdapterUpdate::setAdapter (const char* Adapter_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Adapter_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Adapter();
    this->_Adapter.assign(Adapter_);
}

inline void AdapterUpdate::setAdapter (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Adapter();
    this->_Adapter.assign(value, size);
}

inline void AdapterUpdate::set_has_Adapter () {
    _has_bits_[0] |= 1u << 0;
}

inline void AdapterUpdate::clear_has_Adapter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AdapterRegister::AdapterRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AdapterRegister::AdapterRegister (const AdapterRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AdapterRegister::~AdapterRegister() {
}

inline AdapterRegister& AdapterRegister::operator = (const AdapterRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AdapterRegister::operator == (const AdapterRegister& ) const {
    return true;
}

inline bool AdapterRegister::operator != (const AdapterRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AdapterRegister::operator < (const AdapterRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AdapterRegister::clone() {
    return new AdapterRegister(*this);
}

inline bool AdapterRegister::operator > (const AdapterRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AdapterRegister::clear() {
}

inline  ModaliasUpdate::ModaliasUpdate ()  :
    _Modalias ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ModaliasUpdate::ModaliasUpdate (const ModaliasUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Modalias ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ModaliasUpdate::ModaliasUpdate (const ::std::string& Modalias_)  :
    _Modalias (Modalias_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Modalias_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ModaliasUpdate::~ModaliasUpdate() {
}

inline ModaliasUpdate& ModaliasUpdate::operator = (const ModaliasUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasModalias()) {
            setModalias(rhs.getModalias());
        } else {
            clearModalias();
        }
    }
    return *this;
}

inline bool ModaliasUpdate::operator == (const ModaliasUpdate& rhs) const {
    return (((!hasModalias() && !rhs.hasModalias()) || getModalias() == rhs.getModalias()));
}

inline bool ModaliasUpdate::operator != (const ModaliasUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ModaliasUpdate::operator < (const ModaliasUpdate& rhs) const {
    if (hasModalias() || rhs.hasModalias()) {
        if (getModalias() < rhs.getModalias()) return true;
        if (getModalias() > rhs.getModalias()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ModaliasUpdate::clone() {
    return new ModaliasUpdate(*this);
}

inline bool ModaliasUpdate::operator > (const ModaliasUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ModaliasUpdate::clear() {
    clearModalias();
}

inline void ModaliasUpdate::clearModalias() {
    if (hasModalias()) {
         clear_has_Modalias();
        _Modalias.clear();
     }
}

inline bool ModaliasUpdate::hasModalias () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ModaliasUpdate::getModalias () const {
    return _Modalias;
}

inline ::std::string& ModaliasUpdate::getModaliasMutable () {
    set_has_Modalias();
    return _Modalias;
}

inline void ModaliasUpdate::setModalias (const ::std::string& Modalias_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Modalias_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Modalias();
    this->_Modalias = Modalias_;
}

inline void ModaliasUpdate::setModalias (const char* Modalias_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Modalias_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Modalias();
    this->_Modalias.assign(Modalias_);
}

inline void ModaliasUpdate::setModalias (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Modalias();
    this->_Modalias.assign(value, size);
}

inline void ModaliasUpdate::set_has_Modalias () {
    _has_bits_[0] |= 1u << 0;
}

inline void ModaliasUpdate::clear_has_Modalias () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ModaliasRegister::ModaliasRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ModaliasRegister::ModaliasRegister (const ModaliasRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ModaliasRegister::~ModaliasRegister() {
}

inline ModaliasRegister& ModaliasRegister::operator = (const ModaliasRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ModaliasRegister::operator == (const ModaliasRegister& ) const {
    return true;
}

inline bool ModaliasRegister::operator != (const ModaliasRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ModaliasRegister::operator < (const ModaliasRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ModaliasRegister::clone() {
    return new ModaliasRegister(*this);
}

inline bool ModaliasRegister::operator > (const ModaliasRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ModaliasRegister::clear() {
}

inline  RSSIUpdate::RSSIUpdate ()  :
    _RSSI (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RSSIUpdate::RSSIUpdate (const RSSIUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RSSI (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RSSIUpdate::RSSIUpdate (uint8 RSSI_)  :
    _RSSI (RSSI_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RSSIUpdate::~RSSIUpdate() {
}

inline RSSIUpdate& RSSIUpdate::operator = (const RSSIUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRSSI()) {
            setRSSI(rhs.getRSSI());
        } else {
            clearRSSI();
        }
    }
    return *this;
}

inline bool RSSIUpdate::operator == (const RSSIUpdate& rhs) const {
    return (((!hasRSSI() && !rhs.hasRSSI()) || getRSSI() == rhs.getRSSI()));
}

inline bool RSSIUpdate::operator != (const RSSIUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RSSIUpdate::operator < (const RSSIUpdate& rhs) const {
    if (hasRSSI() || rhs.hasRSSI()) {
        if (getRSSI() < rhs.getRSSI()) return true;
        if (getRSSI() > rhs.getRSSI()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RSSIUpdate::clone() {
    return new RSSIUpdate(*this);
}

inline bool RSSIUpdate::operator > (const RSSIUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RSSIUpdate::clear() {
    clearRSSI();
}

inline void RSSIUpdate::clearRSSI() {
    if (hasRSSI()) {
         clear_has_RSSI();
        _RSSI = 0u;
     }
}

inline bool RSSIUpdate::hasRSSI () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 RSSIUpdate::getRSSI () const {
    return _RSSI;
}

inline void RSSIUpdate::setRSSI (uint8 RSSI_) {
    set_has_RSSI();
    this->_RSSI = RSSI_;
}

inline void RSSIUpdate::set_has_RSSI () {
    _has_bits_[0] |= 1u << 0;
}

inline void RSSIUpdate::clear_has_RSSI () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RSSIRegister::RSSIRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RSSIRegister::RSSIRegister (const RSSIRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RSSIRegister::~RSSIRegister() {
}

inline RSSIRegister& RSSIRegister::operator = (const RSSIRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RSSIRegister::operator == (const RSSIRegister& ) const {
    return true;
}

inline bool RSSIRegister::operator != (const RSSIRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RSSIRegister::operator < (const RSSIRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RSSIRegister::clone() {
    return new RSSIRegister(*this);
}

inline bool RSSIRegister::operator > (const RSSIRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RSSIRegister::clear() {
}

inline  VendorUpdate::VendorUpdate ()  :
    _Vendor (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VendorUpdate::VendorUpdate (const VendorUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Vendor (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VendorUpdate::VendorUpdate (uint16 Vendor_)  :
    _Vendor (Vendor_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VendorUpdate::~VendorUpdate() {
}

inline VendorUpdate& VendorUpdate::operator = (const VendorUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVendor()) {
            setVendor(rhs.getVendor());
        } else {
            clearVendor();
        }
    }
    return *this;
}

inline bool VendorUpdate::operator == (const VendorUpdate& rhs) const {
    return (((!hasVendor() && !rhs.hasVendor()) || getVendor() == rhs.getVendor()));
}

inline bool VendorUpdate::operator != (const VendorUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool VendorUpdate::operator < (const VendorUpdate& rhs) const {
    if (hasVendor() || rhs.hasVendor()) {
        if (getVendor() < rhs.getVendor()) return true;
        if (getVendor() > rhs.getVendor()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VendorUpdate::clone() {
    return new VendorUpdate(*this);
}

inline bool VendorUpdate::operator > (const VendorUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VendorUpdate::clear() {
    clearVendor();
}

inline void VendorUpdate::clearVendor() {
    if (hasVendor()) {
         clear_has_Vendor();
        _Vendor = 0u;
     }
}

inline bool VendorUpdate::hasVendor () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 VendorUpdate::getVendor () const {
    return _Vendor;
}

inline void VendorUpdate::setVendor (uint16 Vendor_) {
    set_has_Vendor();
    this->_Vendor = Vendor_;
}

inline void VendorUpdate::set_has_Vendor () {
    _has_bits_[0] |= 1u << 0;
}

inline void VendorUpdate::clear_has_Vendor () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VendorRegister::VendorRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VendorRegister::VendorRegister (const VendorRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VendorRegister::~VendorRegister() {
}

inline VendorRegister& VendorRegister::operator = (const VendorRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool VendorRegister::operator == (const VendorRegister& ) const {
    return true;
}

inline bool VendorRegister::operator != (const VendorRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool VendorRegister::operator < (const VendorRegister& ) const {
    return false;
}

inline ::asf::core::Payload* VendorRegister::clone() {
    return new VendorRegister(*this);
}

inline bool VendorRegister::operator > (const VendorRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VendorRegister::clear() {
}

inline  VendorSourceUpdate::VendorSourceUpdate ()  :
    _VendorSource (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VendorSourceUpdate::VendorSourceUpdate (const VendorSourceUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _VendorSource (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VendorSourceUpdate::VendorSourceUpdate (uint16 VendorSource_)  :
    _VendorSource (VendorSource_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VendorSourceUpdate::~VendorSourceUpdate() {
}

inline VendorSourceUpdate& VendorSourceUpdate::operator = (const VendorSourceUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVendorSource()) {
            setVendorSource(rhs.getVendorSource());
        } else {
            clearVendorSource();
        }
    }
    return *this;
}

inline bool VendorSourceUpdate::operator == (const VendorSourceUpdate& rhs) const {
    return (((!hasVendorSource() && !rhs.hasVendorSource()) || getVendorSource() == rhs.getVendorSource()));
}

inline bool VendorSourceUpdate::operator != (const VendorSourceUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool VendorSourceUpdate::operator < (const VendorSourceUpdate& rhs) const {
    if (hasVendorSource() || rhs.hasVendorSource()) {
        if (getVendorSource() < rhs.getVendorSource()) return true;
        if (getVendorSource() > rhs.getVendorSource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VendorSourceUpdate::clone() {
    return new VendorSourceUpdate(*this);
}

inline bool VendorSourceUpdate::operator > (const VendorSourceUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VendorSourceUpdate::clear() {
    clearVendorSource();
}

inline void VendorSourceUpdate::clearVendorSource() {
    if (hasVendorSource()) {
         clear_has_VendorSource();
        _VendorSource = 0u;
     }
}

inline bool VendorSourceUpdate::hasVendorSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 VendorSourceUpdate::getVendorSource () const {
    return _VendorSource;
}

inline void VendorSourceUpdate::setVendorSource (uint16 VendorSource_) {
    set_has_VendorSource();
    this->_VendorSource = VendorSource_;
}

inline void VendorSourceUpdate::set_has_VendorSource () {
    _has_bits_[0] |= 1u << 0;
}

inline void VendorSourceUpdate::clear_has_VendorSource () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VendorSourceRegister::VendorSourceRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VendorSourceRegister::VendorSourceRegister (const VendorSourceRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VendorSourceRegister::~VendorSourceRegister() {
}

inline VendorSourceRegister& VendorSourceRegister::operator = (const VendorSourceRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool VendorSourceRegister::operator == (const VendorSourceRegister& ) const {
    return true;
}

inline bool VendorSourceRegister::operator != (const VendorSourceRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool VendorSourceRegister::operator < (const VendorSourceRegister& ) const {
    return false;
}

inline ::asf::core::Payload* VendorSourceRegister::clone() {
    return new VendorSourceRegister(*this);
}

inline bool VendorSourceRegister::operator > (const VendorSourceRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VendorSourceRegister::clear() {
}

inline  ProductUpdate::ProductUpdate ()  :
    _Product (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProductUpdate::ProductUpdate (const ProductUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Product (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProductUpdate::ProductUpdate (uint16 Product_)  :
    _Product (Product_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProductUpdate::~ProductUpdate() {
}

inline ProductUpdate& ProductUpdate::operator = (const ProductUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProduct()) {
            setProduct(rhs.getProduct());
        } else {
            clearProduct();
        }
    }
    return *this;
}

inline bool ProductUpdate::operator == (const ProductUpdate& rhs) const {
    return (((!hasProduct() && !rhs.hasProduct()) || getProduct() == rhs.getProduct()));
}

inline bool ProductUpdate::operator != (const ProductUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ProductUpdate::operator < (const ProductUpdate& rhs) const {
    if (hasProduct() || rhs.hasProduct()) {
        if (getProduct() < rhs.getProduct()) return true;
        if (getProduct() > rhs.getProduct()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProductUpdate::clone() {
    return new ProductUpdate(*this);
}

inline bool ProductUpdate::operator > (const ProductUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProductUpdate::clear() {
    clearProduct();
}

inline void ProductUpdate::clearProduct() {
    if (hasProduct()) {
         clear_has_Product();
        _Product = 0u;
     }
}

inline bool ProductUpdate::hasProduct () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 ProductUpdate::getProduct () const {
    return _Product;
}

inline void ProductUpdate::setProduct (uint16 Product_) {
    set_has_Product();
    this->_Product = Product_;
}

inline void ProductUpdate::set_has_Product () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProductUpdate::clear_has_Product () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ProductRegister::ProductRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProductRegister::ProductRegister (const ProductRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProductRegister::~ProductRegister() {
}

inline ProductRegister& ProductRegister::operator = (const ProductRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ProductRegister::operator == (const ProductRegister& ) const {
    return true;
}

inline bool ProductRegister::operator != (const ProductRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ProductRegister::operator < (const ProductRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ProductRegister::clone() {
    return new ProductRegister(*this);
}

inline bool ProductRegister::operator > (const ProductRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProductRegister::clear() {
}

inline  MapInfoUpdate::MapInfoUpdate ()  :
    _MapInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MapInfoUpdate::MapInfoUpdate (const MapInfoUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _MapInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MapInfoUpdate::MapInfoUpdate (const ::std::vector< ::std::string >& MapInfo_)  :
    _MapInfo (MapInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MapInfoUpdate::~MapInfoUpdate() {
}

inline MapInfoUpdate& MapInfoUpdate::operator = (const MapInfoUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMapInfo()) {
            setMapInfo(rhs.getMapInfo());
        } else {
            clearMapInfo();
        }
    }
    return *this;
}

inline bool MapInfoUpdate::operator == (const MapInfoUpdate& rhs) const {
    return (((!hasMapInfo() && !rhs.hasMapInfo()) || getMapInfo() == rhs.getMapInfo()));
}

inline bool MapInfoUpdate::operator != (const MapInfoUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool MapInfoUpdate::operator < (const MapInfoUpdate& rhs) const {
    if (hasMapInfo() || rhs.hasMapInfo()) {
        if (getMapInfo() < rhs.getMapInfo()) return true;
        if (getMapInfo() > rhs.getMapInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MapInfoUpdate::clone() {
    return new MapInfoUpdate(*this);
}

inline bool MapInfoUpdate::operator > (const MapInfoUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MapInfoUpdate::clear() {
    clearMapInfo();
}

inline void MapInfoUpdate::clearMapInfo() {
    if (hasMapInfo()) {
         clear_has_MapInfo();
        _MapInfo.clear();
     }
}

inline bool MapInfoUpdate::hasMapInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& MapInfoUpdate::getMapInfo () const {
    return _MapInfo;
}

inline ::std::vector< ::std::string >& MapInfoUpdate::getMapInfoMutable () {
    set_has_MapInfo();
    return _MapInfo;
}

inline void MapInfoUpdate::setMapInfo (const ::std::vector< ::std::string >& MapInfo_) {
    set_has_MapInfo();
    this->_MapInfo = MapInfo_;
}

inline void MapInfoUpdate::set_has_MapInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void MapInfoUpdate::clear_has_MapInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MapInfoRegister::MapInfoRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MapInfoRegister::MapInfoRegister (const MapInfoRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MapInfoRegister::~MapInfoRegister() {
}

inline MapInfoRegister& MapInfoRegister::operator = (const MapInfoRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool MapInfoRegister::operator == (const MapInfoRegister& ) const {
    return true;
}

inline bool MapInfoRegister::operator != (const MapInfoRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool MapInfoRegister::operator < (const MapInfoRegister& ) const {
    return false;
}

inline ::asf::core::Payload* MapInfoRegister::clone() {
    return new MapInfoRegister(*this);
}

inline bool MapInfoRegister::operator > (const MapInfoRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MapInfoRegister::clear() {
}

inline  ConnectedServiceUpdate::ConnectedServiceUpdate ()  :
    _ConnectedService (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectedServiceUpdate::ConnectedServiceUpdate (const ConnectedServiceUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ConnectedService (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectedServiceUpdate::ConnectedServiceUpdate (uint64 ConnectedService_)  :
    _ConnectedService (ConnectedService_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConnectedServiceUpdate::~ConnectedServiceUpdate() {
}

inline ConnectedServiceUpdate& ConnectedServiceUpdate::operator = (const ConnectedServiceUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConnectedService()) {
            setConnectedService(rhs.getConnectedService());
        } else {
            clearConnectedService();
        }
    }
    return *this;
}

inline bool ConnectedServiceUpdate::operator == (const ConnectedServiceUpdate& rhs) const {
    return (((!hasConnectedService() && !rhs.hasConnectedService()) || getConnectedService() == rhs.getConnectedService()));
}

inline bool ConnectedServiceUpdate::operator != (const ConnectedServiceUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectedServiceUpdate::operator < (const ConnectedServiceUpdate& rhs) const {
    if (hasConnectedService() || rhs.hasConnectedService()) {
        if (getConnectedService() < rhs.getConnectedService()) return true;
        if (getConnectedService() > rhs.getConnectedService()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConnectedServiceUpdate::clone() {
    return new ConnectedServiceUpdate(*this);
}

inline bool ConnectedServiceUpdate::operator > (const ConnectedServiceUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectedServiceUpdate::clear() {
    clearConnectedService();
}

inline void ConnectedServiceUpdate::clearConnectedService() {
    if (hasConnectedService()) {
         clear_has_ConnectedService();
        _ConnectedService = 0u;
     }
}

inline bool ConnectedServiceUpdate::hasConnectedService () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 ConnectedServiceUpdate::getConnectedService () const {
    return _ConnectedService;
}

inline void ConnectedServiceUpdate::setConnectedService (uint64 ConnectedService_) {
    set_has_ConnectedService();
    this->_ConnectedService = ConnectedService_;
}

inline void ConnectedServiceUpdate::set_has_ConnectedService () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConnectedServiceUpdate::clear_has_ConnectedService () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ConnectedServiceRegister::ConnectedServiceRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectedServiceRegister::ConnectedServiceRegister (const ConnectedServiceRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectedServiceRegister::~ConnectedServiceRegister() {
}

inline ConnectedServiceRegister& ConnectedServiceRegister::operator = (const ConnectedServiceRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ConnectedServiceRegister::operator == (const ConnectedServiceRegister& ) const {
    return true;
}

inline bool ConnectedServiceRegister::operator != (const ConnectedServiceRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectedServiceRegister::operator < (const ConnectedServiceRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ConnectedServiceRegister::clone() {
    return new ConnectedServiceRegister(*this);
}

inline bool ConnectedServiceRegister::operator > (const ConnectedServiceRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectedServiceRegister::clear() {
}

inline  VersionUpdate::VersionUpdate ()  :
    _Version (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VersionUpdate::VersionUpdate (const VersionUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Version (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VersionUpdate::VersionUpdate (uint16 Version_)  :
    _Version (Version_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VersionUpdate::~VersionUpdate() {
}

inline VersionUpdate& VersionUpdate::operator = (const VersionUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVersion()) {
            setVersion(rhs.getVersion());
        } else {
            clearVersion();
        }
    }
    return *this;
}

inline bool VersionUpdate::operator == (const VersionUpdate& rhs) const {
    return (((!hasVersion() && !rhs.hasVersion()) || getVersion() == rhs.getVersion()));
}

inline bool VersionUpdate::operator != (const VersionUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool VersionUpdate::operator < (const VersionUpdate& rhs) const {
    if (hasVersion() || rhs.hasVersion()) {
        if (getVersion() < rhs.getVersion()) return true;
        if (getVersion() > rhs.getVersion()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VersionUpdate::clone() {
    return new VersionUpdate(*this);
}

inline bool VersionUpdate::operator > (const VersionUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VersionUpdate::clear() {
    clearVersion();
}

inline void VersionUpdate::clearVersion() {
    if (hasVersion()) {
         clear_has_Version();
        _Version = 0u;
     }
}

inline bool VersionUpdate::hasVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 VersionUpdate::getVersion () const {
    return _Version;
}

inline void VersionUpdate::setVersion (uint16 Version_) {
    set_has_Version();
    this->_Version = Version_;
}

inline void VersionUpdate::set_has_Version () {
    _has_bits_[0] |= 1u << 0;
}

inline void VersionUpdate::clear_has_Version () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VersionRegister::VersionRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VersionRegister::VersionRegister (const VersionRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VersionRegister::~VersionRegister() {
}

inline VersionRegister& VersionRegister::operator = (const VersionRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool VersionRegister::operator == (const VersionRegister& ) const {
    return true;
}

inline bool VersionRegister::operator != (const VersionRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool VersionRegister::operator < (const VersionRegister& ) const {
    return false;
}

inline ::asf::core::Payload* VersionRegister::clone() {
    return new VersionRegister(*this);
}

inline bool VersionRegister::operator > (const VersionRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VersionRegister::clear() {
}

inline  PBAPInfoUpdate::PBAPInfoUpdate ()  :
    _PBAPInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PBAPInfoUpdate::PBAPInfoUpdate (const PBAPInfoUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _PBAPInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PBAPInfoUpdate::PBAPInfoUpdate (const ::std::string& PBAPInfo_)  :
    _PBAPInfo (PBAPInfo_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PBAPInfo_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PBAPInfoUpdate::~PBAPInfoUpdate() {
}

inline PBAPInfoUpdate& PBAPInfoUpdate::operator = (const PBAPInfoUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPBAPInfo()) {
            setPBAPInfo(rhs.getPBAPInfo());
        } else {
            clearPBAPInfo();
        }
    }
    return *this;
}

inline bool PBAPInfoUpdate::operator == (const PBAPInfoUpdate& rhs) const {
    return (((!hasPBAPInfo() && !rhs.hasPBAPInfo()) || getPBAPInfo() == rhs.getPBAPInfo()));
}

inline bool PBAPInfoUpdate::operator != (const PBAPInfoUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PBAPInfoUpdate::operator < (const PBAPInfoUpdate& rhs) const {
    if (hasPBAPInfo() || rhs.hasPBAPInfo()) {
        if (getPBAPInfo() < rhs.getPBAPInfo()) return true;
        if (getPBAPInfo() > rhs.getPBAPInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PBAPInfoUpdate::clone() {
    return new PBAPInfoUpdate(*this);
}

inline bool PBAPInfoUpdate::operator > (const PBAPInfoUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PBAPInfoUpdate::clear() {
    clearPBAPInfo();
}

inline void PBAPInfoUpdate::clearPBAPInfo() {
    if (hasPBAPInfo()) {
         clear_has_PBAPInfo();
        _PBAPInfo.clear();
     }
}

inline bool PBAPInfoUpdate::hasPBAPInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PBAPInfoUpdate::getPBAPInfo () const {
    return _PBAPInfo;
}

inline ::std::string& PBAPInfoUpdate::getPBAPInfoMutable () {
    set_has_PBAPInfo();
    return _PBAPInfo;
}

inline void PBAPInfoUpdate::setPBAPInfo (const ::std::string& PBAPInfo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PBAPInfo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PBAPInfo();
    this->_PBAPInfo = PBAPInfo_;
}

inline void PBAPInfoUpdate::setPBAPInfo (const char* PBAPInfo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PBAPInfo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PBAPInfo();
    this->_PBAPInfo.assign(PBAPInfo_);
}

inline void PBAPInfoUpdate::setPBAPInfo (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PBAPInfo();
    this->_PBAPInfo.assign(value, size);
}

inline void PBAPInfoUpdate::set_has_PBAPInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void PBAPInfoUpdate::clear_has_PBAPInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PBAPInfoRegister::PBAPInfoRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PBAPInfoRegister::PBAPInfoRegister (const PBAPInfoRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PBAPInfoRegister::~PBAPInfoRegister() {
}

inline PBAPInfoRegister& PBAPInfoRegister::operator = (const PBAPInfoRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PBAPInfoRegister::operator == (const PBAPInfoRegister& ) const {
    return true;
}

inline bool PBAPInfoRegister::operator != (const PBAPInfoRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PBAPInfoRegister::operator < (const PBAPInfoRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PBAPInfoRegister::clone() {
    return new PBAPInfoRegister(*this);
}

inline bool PBAPInfoRegister::operator > (const PBAPInfoRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PBAPInfoRegister::clear() {
}

inline  ModeUpdate::ModeUpdate ()  :
    _Mode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ModeUpdate::ModeUpdate (const ModeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Mode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ModeUpdate::ModeUpdate (uint8 Mode_)  :
    _Mode (Mode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ModeUpdate::~ModeUpdate() {
}

inline ModeUpdate& ModeUpdate::operator = (const ModeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool ModeUpdate::operator == (const ModeUpdate& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool ModeUpdate::operator != (const ModeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ModeUpdate::operator < (const ModeUpdate& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ModeUpdate::clone() {
    return new ModeUpdate(*this);
}

inline bool ModeUpdate::operator > (const ModeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ModeUpdate::clear() {
    clearMode();
}

inline void ModeUpdate::clearMode() {
    if (hasMode()) {
         clear_has_Mode();
        _Mode = 0u;
     }
}

inline bool ModeUpdate::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ModeUpdate::getMode () const {
    return _Mode;
}

inline void ModeUpdate::setMode (uint8 Mode_) {
    set_has_Mode();
    this->_Mode = Mode_;
}

inline void ModeUpdate::set_has_Mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void ModeUpdate::clear_has_Mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ModeRegister::ModeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ModeRegister::ModeRegister (const ModeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ModeRegister::~ModeRegister() {
}

inline ModeRegister& ModeRegister::operator = (const ModeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ModeRegister::operator == (const ModeRegister& ) const {
    return true;
}

inline bool ModeRegister::operator != (const ModeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ModeRegister::operator < (const ModeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ModeRegister::clone() {
    return new ModeRegister(*this);
}

inline bool ModeRegister::operator > (const ModeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ModeRegister::clear() {
}

inline  RoleUpdate::RoleUpdate ()  :
    _Role (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RoleUpdate::RoleUpdate (const RoleUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Role (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RoleUpdate::RoleUpdate (uint8 Role_)  :
    _Role (Role_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RoleUpdate::~RoleUpdate() {
}

inline RoleUpdate& RoleUpdate::operator = (const RoleUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRole()) {
            setRole(rhs.getRole());
        } else {
            clearRole();
        }
    }
    return *this;
}

inline bool RoleUpdate::operator == (const RoleUpdate& rhs) const {
    return (((!hasRole() && !rhs.hasRole()) || getRole() == rhs.getRole()));
}

inline bool RoleUpdate::operator != (const RoleUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RoleUpdate::operator < (const RoleUpdate& rhs) const {
    if (hasRole() || rhs.hasRole()) {
        if (getRole() < rhs.getRole()) return true;
        if (getRole() > rhs.getRole()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RoleUpdate::clone() {
    return new RoleUpdate(*this);
}

inline bool RoleUpdate::operator > (const RoleUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RoleUpdate::clear() {
    clearRole();
}

inline void RoleUpdate::clearRole() {
    if (hasRole()) {
         clear_has_Role();
        _Role = 0u;
     }
}

inline bool RoleUpdate::hasRole () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 RoleUpdate::getRole () const {
    return _Role;
}

inline void RoleUpdate::setRole (uint8 Role_) {
    set_has_Role();
    this->_Role = Role_;
}

inline void RoleUpdate::set_has_Role () {
    _has_bits_[0] |= 1u << 0;
}

inline void RoleUpdate::clear_has_Role () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RoleRegister::RoleRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RoleRegister::RoleRegister (const RoleRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RoleRegister::~RoleRegister() {
}

inline RoleRegister& RoleRegister::operator = (const RoleRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RoleRegister::operator == (const RoleRegister& ) const {
    return true;
}

inline bool RoleRegister::operator != (const RoleRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RoleRegister::operator < (const RoleRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RoleRegister::clone() {
    return new RoleRegister(*this);
}

inline bool RoleRegister::operator > (const RoleRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RoleRegister::clear() {
}

inline  EnableAvpPauseUpdate::EnableAvpPauseUpdate ()  :
    _EnableAvpPause (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EnableAvpPauseUpdate::EnableAvpPauseUpdate (const EnableAvpPauseUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _EnableAvpPause (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EnableAvpPauseUpdate::EnableAvpPauseUpdate (bool EnableAvpPause_)  :
    _EnableAvpPause (EnableAvpPause_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EnableAvpPauseUpdate::~EnableAvpPauseUpdate() {
}

inline EnableAvpPauseUpdate& EnableAvpPauseUpdate::operator = (const EnableAvpPauseUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnableAvpPause()) {
            setEnableAvpPause(rhs.getEnableAvpPause());
        } else {
            clearEnableAvpPause();
        }
    }
    return *this;
}

inline bool EnableAvpPauseUpdate::operator == (const EnableAvpPauseUpdate& rhs) const {
    return (((!hasEnableAvpPause() && !rhs.hasEnableAvpPause()) || getEnableAvpPause() == rhs.getEnableAvpPause()));
}

inline bool EnableAvpPauseUpdate::operator != (const EnableAvpPauseUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool EnableAvpPauseUpdate::operator < (const EnableAvpPauseUpdate& rhs) const {
    if (hasEnableAvpPause() || rhs.hasEnableAvpPause()) {
        if (getEnableAvpPause() < rhs.getEnableAvpPause()) return true;
        if (getEnableAvpPause() > rhs.getEnableAvpPause()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EnableAvpPauseUpdate::clone() {
    return new EnableAvpPauseUpdate(*this);
}

inline bool EnableAvpPauseUpdate::operator > (const EnableAvpPauseUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EnableAvpPauseUpdate::clear() {
    clearEnableAvpPause();
}

inline void EnableAvpPauseUpdate::clearEnableAvpPause() {
    if (hasEnableAvpPause()) {
         clear_has_EnableAvpPause();
        _EnableAvpPause = false;
     }
}

inline bool EnableAvpPauseUpdate::hasEnableAvpPause () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool EnableAvpPauseUpdate::getEnableAvpPause () const {
    return _EnableAvpPause;
}

inline void EnableAvpPauseUpdate::setEnableAvpPause (bool EnableAvpPause_) {
    set_has_EnableAvpPause();
    this->_EnableAvpPause = EnableAvpPause_;
}

inline void EnableAvpPauseUpdate::set_has_EnableAvpPause () {
    _has_bits_[0] |= 1u << 0;
}

inline void EnableAvpPauseUpdate::clear_has_EnableAvpPause () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EnableAvpPauseRegister::EnableAvpPauseRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EnableAvpPauseRegister::EnableAvpPauseRegister (const EnableAvpPauseRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EnableAvpPauseRegister::~EnableAvpPauseRegister() {
}

inline EnableAvpPauseRegister& EnableAvpPauseRegister::operator = (const EnableAvpPauseRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool EnableAvpPauseRegister::operator == (const EnableAvpPauseRegister& ) const {
    return true;
}

inline bool EnableAvpPauseRegister::operator != (const EnableAvpPauseRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool EnableAvpPauseRegister::operator < (const EnableAvpPauseRegister& ) const {
    return false;
}

inline ::asf::core::Payload* EnableAvpPauseRegister::clone() {
    return new EnableAvpPauseRegister(*this);
}

inline bool EnableAvpPauseRegister::operator > (const EnableAvpPauseRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EnableAvpPauseRegister::clear() {
}

inline  ReportLinkkeySignal::ReportLinkkeySignal ()  :
    _linkkey ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReportLinkkeySignal::ReportLinkkeySignal (const ReportLinkkeySignal &rhs)  :
    ::asf::core::Payload(rhs),
    _linkkey ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReportLinkkeySignal::ReportLinkkeySignal (const ::std::vector< uint8 >& linkkey_)  :
    _linkkey (linkkey_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReportLinkkeySignal::~ReportLinkkeySignal() {
}

inline ReportLinkkeySignal& ReportLinkkeySignal::operator = (const ReportLinkkeySignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLinkkey()) {
            setLinkkey(rhs.getLinkkey());
        } else {
            clearLinkkey();
        }
    }
    return *this;
}

inline bool ReportLinkkeySignal::operator == (const ReportLinkkeySignal& rhs) const {
    return (((!hasLinkkey() && !rhs.hasLinkkey()) || getLinkkey() == rhs.getLinkkey()));
}

inline bool ReportLinkkeySignal::operator != (const ReportLinkkeySignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ReportLinkkeySignal::operator < (const ReportLinkkeySignal& rhs) const {
    if (hasLinkkey() || rhs.hasLinkkey()) {
        if (getLinkkey() < rhs.getLinkkey()) return true;
        if (getLinkkey() > rhs.getLinkkey()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReportLinkkeySignal::clone() {
    return new ReportLinkkeySignal(*this);
}

inline bool ReportLinkkeySignal::operator > (const ReportLinkkeySignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReportLinkkeySignal::clear() {
    clearLinkkey();
}

inline void ReportLinkkeySignal::clearLinkkey() {
    if (hasLinkkey()) {
         clear_has_linkkey();
        _linkkey.clear();
     }
}

inline bool ReportLinkkeySignal::hasLinkkey () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& ReportLinkkeySignal::getLinkkey () const {
    return _linkkey;
}

inline ::std::vector< uint8 >& ReportLinkkeySignal::getLinkkeyMutable () {
    set_has_linkkey();
    return _linkkey;
}

inline void ReportLinkkeySignal::setLinkkey (const ::std::vector< uint8 >& linkkey_) {
    set_has_linkkey();
    this->_linkkey = linkkey_;
}

inline void ReportLinkkeySignal::set_has_linkkey () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReportLinkkeySignal::clear_has_linkkey () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  IncomingPairingCompSignal::IncomingPairingCompSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IncomingPairingCompSignal::IncomingPairingCompSignal (const IncomingPairingCompSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IncomingPairingCompSignal::IncomingPairingCompSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  IncomingPairingCompSignal::~IncomingPairingCompSignal() {
}

inline IncomingPairingCompSignal& IncomingPairingCompSignal::operator = (const IncomingPairingCompSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool IncomingPairingCompSignal::operator == (const IncomingPairingCompSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool IncomingPairingCompSignal::operator != (const IncomingPairingCompSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool IncomingPairingCompSignal::operator < (const IncomingPairingCompSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* IncomingPairingCompSignal::clone() {
    return new IncomingPairingCompSignal(*this);
}

inline bool IncomingPairingCompSignal::operator > (const IncomingPairingCompSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IncomingPairingCompSignal::clear() {
    clearStatus();
}

inline void IncomingPairingCompSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool IncomingPairingCompSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 IncomingPairingCompSignal::getStatus () const {
    return _status;
}

inline void IncomingPairingCompSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void IncomingPairingCompSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void IncomingPairingCompSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SDPProcessReportSignal::SDPProcessReportSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SDPProcessReportSignal::SDPProcessReportSignal (const SDPProcessReportSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SDPProcessReportSignal::SDPProcessReportSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SDPProcessReportSignal::~SDPProcessReportSignal() {
}

inline SDPProcessReportSignal& SDPProcessReportSignal::operator = (const SDPProcessReportSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SDPProcessReportSignal::operator == (const SDPProcessReportSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SDPProcessReportSignal::operator != (const SDPProcessReportSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SDPProcessReportSignal::operator < (const SDPProcessReportSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SDPProcessReportSignal::clone() {
    return new SDPProcessReportSignal(*this);
}

inline bool SDPProcessReportSignal::operator > (const SDPProcessReportSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SDPProcessReportSignal::clear() {
    clearStatus();
}

inline void SDPProcessReportSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool SDPProcessReportSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SDPProcessReportSignal::getStatus () const {
    return _status;
}

inline void SDPProcessReportSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void SDPProcessReportSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SDPProcessReportSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace Device1
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_DEVICE1_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
