/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/Agent.h"
#include "org/bluez/AgentDBus.h"
#include "org/bluez/AgentJson.h"
#include "org/bluez/AgentStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace Agent {

DEFINE_CLASS_LOGGER("//org/bosch/genivi/org/bluez/Agent", AgentStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 6, "Cancel", 5 },
    { 7, "Release", 0 },
    { 13, "CancelRequest", 6 },
    { 14, "DisplayPasskey", 10 },
    { 14, "DisplayPinCode", 2 },
    { 14, "RequestLinkkey", 9 },
    { 14, "RequestPasskey", 3 },
    { 14, "RequestPinCode", 1 },
    { 16, "AuthorizeService", 7 },
    { 19, "RequestConfirmation", 4 },
    { 20, "RequestAuthorization", 8 },
};


class AgentStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    AgentStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    AgentStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    AgentStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.Agent"),
          _logger(logger) {}

    virtual ~AgentStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void AgentStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 11, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Release'

            LOG_DEBUG_STUB("process method '%s'", "Release");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Release", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReleaseRequest > payload = ::boost::static_pointer_cast<ReleaseRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onReleaseRequest(payload);
            return;
        }
        case 1: {

            // method 'RequestPinCode'

            LOG_DEBUG_STUB("process method '%s'", "RequestPinCode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestPinCodeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestPinCode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestPinCodeRequest > payload = ::boost::static_pointer_cast<RequestPinCodeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onRequestPinCodeRequest(payload);
            return;
        }
        case 2: {

            // method 'DisplayPinCode'

            LOG_DEBUG_STUB("process method '%s'", "DisplayPinCode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisplayPinCodeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DisplayPinCode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DisplayPinCodeRequest > payload = ::boost::static_pointer_cast<DisplayPinCodeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onDisplayPinCodeRequest(payload);
            return;
        }
        case 3: {

            // method 'RequestPasskey'

            LOG_DEBUG_STUB("process method '%s'", "RequestPasskey");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestPasskeyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestPasskey", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestPasskeyRequest > payload = ::boost::static_pointer_cast<RequestPasskeyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onRequestPasskeyRequest(payload);
            return;
        }
        case 4: {

            // method 'RequestConfirmation'

            LOG_DEBUG_STUB("process method '%s'", "RequestConfirmation");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestConfirmationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestConfirmation", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestConfirmationRequest > payload = ::boost::static_pointer_cast<RequestConfirmationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onRequestConfirmationRequest(payload);
            return;
        }
        case 5: {

            // method 'Cancel'

            LOG_DEBUG_STUB("process method '%s'", "Cancel");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Cancel", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CancelRequest > payload = ::boost::static_pointer_cast<CancelRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onCancelRequest(payload);
            return;
        }
        case 6: {

            // method 'CancelRequest'

            LOG_DEBUG_STUB("process method '%s'", "CancelRequest");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelRequestRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CancelRequest", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CancelRequestRequest > payload = ::boost::static_pointer_cast<CancelRequestRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onCancelRequestRequest(payload);
            return;
        }
        case 7: {

            // method 'AuthorizeService'

            LOG_DEBUG_STUB("process method '%s'", "AuthorizeService");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AuthorizeServiceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AuthorizeService", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AuthorizeServiceRequest > payload = ::boost::static_pointer_cast<AuthorizeServiceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onAuthorizeServiceRequest(payload);
            return;
        }
        case 8: {

            // method 'RequestAuthorization'

            LOG_DEBUG_STUB("process method '%s'", "RequestAuthorization");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestAuthorizationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestAuthorization", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestAuthorizationRequest > payload = ::boost::static_pointer_cast<RequestAuthorizationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onRequestAuthorizationRequest(payload);
            return;
        }
        case 9: {

            // method 'RequestLinkkey'

            LOG_DEBUG_STUB("process method '%s'", "RequestLinkkey");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestLinkkeyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestLinkkey", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestLinkkeyRequest > payload = ::boost::static_pointer_cast<RequestLinkkeyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onRequestLinkkeyRequest(payload);
            return;
        }
        case 10: {

            // method 'DisplayPasskey'

            LOG_DEBUG_STUB("process method '%s'", "DisplayPasskey");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisplayPasskeyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DisplayPasskey", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DisplayPasskeyRequest > payload = ::boost::static_pointer_cast<DisplayPasskeyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onDisplayPasskeyRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* AgentStubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.Agent\">\n"
            "      <method name=\"Release\"/>\n"
            "      <method name=\"RequestPinCode\">\n"
            "        <arg direction=\"in\" name=\"device\" type=\"o\"/>\n"
            "        <arg direction=\"out\" name=\"pincode\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"DisplayPinCode\">\n"
            "        <arg direction=\"in\" name=\"device\" type=\"o\"/>\n"
            "        <arg direction=\"in\" name=\"pincode\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"RequestPasskey\">\n"
            "        <arg direction=\"in\" name=\"device\" type=\"o\"/>\n"
            "        <arg direction=\"out\" name=\"passkey\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"RequestConfirmation\">\n"
            "        <arg direction=\"in\" name=\"device\" type=\"o\"/>\n"
            "        <arg direction=\"in\" name=\"passkey\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"Cancel\"/>\n"
            "      <method name=\"CancelRequest\">\n"
            "        <arg direction=\"in\" name=\"device\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"AuthorizeService\">\n"
            "        <arg direction=\"in\" name=\"device\" type=\"o\"/>\n"
            "        <arg direction=\"in\" name=\"uuid\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"RequestAuthorization\">\n"
            "        <arg direction=\"in\" name=\"device\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"RequestLinkkey\">\n"
            "        <arg direction=\"in\" name=\"device\" type=\"o\"/>\n"
            "        <arg direction=\"out\" name=\"linkkey\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <method name=\"DisplayPasskey\">\n"
            "        <arg direction=\"in\" name=\"device\" type=\"o\"/>\n"
            "        <arg direction=\"in\" name=\"passkey\" type=\"u\"/>\n"
            "        <arg direction=\"in\" name=\"entered\" type=\"y\"/>\n"
            "      </method>\n"
            "</interface>\n";
}

void AgentStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<AgentStub*>(getStub()))->onGetAll (properties);
}

void AgentStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void AgentStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

AgentStub::AgentStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AgentStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AgentStub::AgentStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AgentStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AgentStub::~AgentStub() {
    delete _stubDelegate;
}

void  AgentStub::sendReleaseResponse (act_t act) {
    ReleaseResponse* payload = new ReleaseResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Release", ReleaseResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Release", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendReleaseError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReleaseError* payload = new ReleaseError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Release", ReleaseError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Release", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendRequestPinCodeResponse (const ::std::string& pincode, act_t act) {
    RequestPinCodeResponse* payload = new RequestPinCodeResponse(pincode);
    DBUS_MESSAGE_REPLY(dbusMessage, "RequestPinCode", RequestPinCodeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestPinCode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendRequestPinCodeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestPinCodeError* payload = new RequestPinCodeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RequestPinCode", RequestPinCodeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestPinCode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendDisplayPinCodeResponse (act_t act) {
    DisplayPinCodeResponse* payload = new DisplayPinCodeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "DisplayPinCode", DisplayPinCodeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DisplayPinCode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendDisplayPinCodeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DisplayPinCodeError* payload = new DisplayPinCodeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DisplayPinCode", DisplayPinCodeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DisplayPinCode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendRequestPasskeyResponse (uint32 passkey, act_t act) {
    RequestPasskeyResponse* payload = new RequestPasskeyResponse(passkey);
    DBUS_MESSAGE_REPLY(dbusMessage, "RequestPasskey", RequestPasskeyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestPasskey", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendRequestPasskeyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestPasskeyError* payload = new RequestPasskeyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RequestPasskey", RequestPasskeyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestPasskey", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendRequestConfirmationResponse (act_t act) {
    RequestConfirmationResponse* payload = new RequestConfirmationResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RequestConfirmation", RequestConfirmationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestConfirmation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendRequestConfirmationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestConfirmationError* payload = new RequestConfirmationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RequestConfirmation", RequestConfirmationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestConfirmation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendCancelResponse (act_t act) {
    CancelResponse* payload = new CancelResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Cancel", CancelResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Cancel", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendCancelError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CancelError* payload = new CancelError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Cancel", CancelError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Cancel", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendCancelRequestResponse (act_t act) {
    CancelRequestResponse* payload = new CancelRequestResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "CancelRequest", CancelRequestResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CancelRequest", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendCancelRequestError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CancelRequestError* payload = new CancelRequestError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CancelRequest", CancelRequestError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CancelRequest", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendAuthorizeServiceResponse (act_t act) {
    AuthorizeServiceResponse* payload = new AuthorizeServiceResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AuthorizeService", AuthorizeServiceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AuthorizeService", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendAuthorizeServiceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AuthorizeServiceError* payload = new AuthorizeServiceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AuthorizeService", AuthorizeServiceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AuthorizeService", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendRequestAuthorizationResponse (act_t act) {
    RequestAuthorizationResponse* payload = new RequestAuthorizationResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RequestAuthorization", RequestAuthorizationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestAuthorization", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendRequestAuthorizationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestAuthorizationError* payload = new RequestAuthorizationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RequestAuthorization", RequestAuthorizationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestAuthorization", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendRequestLinkkeyResponse (const ::std::vector< uint8 >& linkkey, act_t act) {
    RequestLinkkeyResponse* payload = new RequestLinkkeyResponse(linkkey);
    DBUS_MESSAGE_REPLY(dbusMessage, "RequestLinkkey", RequestLinkkeyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestLinkkey", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendRequestLinkkeyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestLinkkeyError* payload = new RequestLinkkeyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RequestLinkkey", RequestLinkkeyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestLinkkey", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendDisplayPasskeyResponse (act_t act) {
    DisplayPasskeyResponse* payload = new DisplayPasskeyResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "DisplayPasskey", DisplayPasskeyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DisplayPasskey", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendDisplayPasskeyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DisplayPasskeyError* payload = new DisplayPasskeyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DisplayPasskey", DisplayPasskeyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DisplayPasskey", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void AgentStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Agent
} // namespace bluez
} // namespace org
