/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_AGENTMANAGERPROXY_H
#define ORG_BLUEZ_AGENTMANAGERPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/AgentManager.h"
#include <dbus/dbus.h>
#include <string>

namespace org {
namespace bluez {
namespace AgentManager {

class AgentManagerProxy;

class RegisterAgentCallbackIF {
public:
    virtual ~RegisterAgentCallbackIF() {}

    virtual void onRegisterAgentError(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RegisterAgentError >& error) = 0;

    virtual void onRegisterAgentResponse(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RegisterAgentResponse >& response) = 0;
};

class RequestDefaultAgentCallbackIF {
public:
    virtual ~RequestDefaultAgentCallbackIF() {}

    virtual void onRequestDefaultAgentError(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RequestDefaultAgentError >& error) = 0;

    virtual void onRequestDefaultAgentResponse(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RequestDefaultAgentResponse >& response) = 0;
};

class UnregisterAgentCallbackIF {
public:
    virtual ~UnregisterAgentCallbackIF() {}

    virtual void onUnregisterAgentError(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< UnregisterAgentError >& error) = 0;

    virtual void onUnregisterAgentResponse(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< UnregisterAgentResponse >& response) = 0;
};


/**
 * AgentManagerProxy is the client side representation of the D-Bus
 * service interface 'org.bluez.AgentManager' (specified in file
 * stack_component_agent_manager.xml).
 *
 * If the meaning of "org.bluez.AgentManager" isn't clear, then there should be a description here.
 */
class AgentManagerProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of AgentManagerProxy.
     */
    static ::boost::shared_ptr< AgentManagerProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of AgentManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< AgentManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of AgentManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< AgentManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< AgentManagerProxy > proxyNew(new AgentManagerProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~AgentManagerProxy ();




    // Method 'RegisterAgent'

    /**
     * Call the method 'RegisterAgent'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'RegisterAgent'</b>:
     *
     * possible values for capability:
     * DisplayOnly
     * DisplayYesNo
     * KeyboardOnly
     * NoInputNoOutput
     * KeyboardDisplay
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param agent If the meaning of "agent" isn't clear, then there should be a description here.
     *
     * @param capability If the meaning of "capability" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegisterAgentRequest(RegisterAgentCallbackIF& cb, const ::std::string& agent, const ::std::string& capability) const;

    // Method 'UnregisterAgent'

    /**
     * Call the method 'UnregisterAgent'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'UnregisterAgent'</b>:
     *
     * If the meaning of "UnregisterAgent" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param agent If the meaning of "agent" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnregisterAgentRequest(UnregisterAgentCallbackIF& cb, const ::std::string& agent) const;

    // Method 'RequestDefaultAgent'

    /**
     * Call the method 'RequestDefaultAgent'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'RequestDefaultAgent'</b>:
     *
     * If the meaning of "RequestDefaultAgent" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param agent If the meaning of "agent" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestDefaultAgentRequest(RequestDefaultAgentCallbackIF& cb, const ::std::string& agent) const;


private:

    AgentManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class AgentManagerProxyCallback;
};

} // namespace AgentManager
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_AGENTMANAGERPROXY_H
