#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_AGENTMANAGER_H
#define ORG_BLUEZ_AGENTMANAGER_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "AgentManager" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace AgentManager {

// method IDs
static const uint16 ID_RegisterAgent = 0;
static const uint16 ID_UnregisterAgent = 1;
static const uint16 ID_RequestDefaultAgent = 2;

// signal IDs

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class RegisterAgentRequest;

class UnregisterAgentRequest;

class RequestDefaultAgentRequest;

// type definitions
/**
 * If the meaning of "RegisterAgentResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RegisterAgentResponse;

/**
 * If the meaning of "RegisterAgentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RegisterAgentError;

/**
 * If the meaning of "UnregisterAgentResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UnregisterAgentResponse;

/**
 * If the meaning of "UnregisterAgentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnregisterAgentError;

/**
 * If the meaning of "RequestDefaultAgentResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestDefaultAgentResponse;

/**
 * If the meaning of "RequestDefaultAgentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestDefaultAgentError;


/**
 * If the meaning of "RegisterAgentRequest" isn't clear, then there should be a description here.
 */
class RegisterAgentRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterAgentRequest ();

    /**
     * Copy constructor
     */
    inline  RegisterAgentRequest (const RegisterAgentRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterAgentRequest (const ::std::string& agent_, const ::std::string& capability_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterAgentRequest();

    /**
     * Assignment operator
     */
    inline RegisterAgentRequest& operator = (const RegisterAgentRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterAgentRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterAgentRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterAgentRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterAgentRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "agent"

    static const int kAgent = 0;

    /**
     * Clears the field "agent".
     *
     * The field will be set to its default value. The hasAgent()
     * method will return false.
     */
    inline void clearAgent();

    /**
     * Checks whether the field "agent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAgent()). Otherwise it will return false.
     */
    inline bool hasAgent () const;

    /**
     * Returns the value of the member "agent".
     *
     * If the meaning of "agent" isn't clear, then there should be a description here.
     *
     * @return The value of the field "agent"
     */
    inline const ::std::string& getAgent () const;

    /**
     * Retrieves the value of the field "agent" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "agent".
     */
    inline ::std::string& getAgentMutable ();

    /**
     * Sets the value of the member "agent".
     *
     * If the meaning of "agent" isn't clear, then there should be a description here.
     *
     * @param agent The value which will be set
     */
    inline void setAgent (const ::std::string& agent_);

    /**
     * Sets the value of the member "agent".
     *
     * If the meaning of "agent" isn't clear, then there should be a description here.
     *
     * @param agent The value which will be set
     */
    inline void setAgent (const char* agent_);

    /**
     * Sets the value of the member "agent".
     *
     * If the meaning of "agent" isn't clear, then there should be a description here.
     *
     * @param agent The value which will be set
     */
    inline void setAgent (const char* value, size_t size);

    // API of field "capability"

    static const int kCapability = 1;

    /**
     * Clears the field "capability".
     *
     * The field will be set to its default value. The hasCapability()
     * method will return false.
     */
    inline void clearCapability();

    /**
     * Checks whether the field "capability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCapability()). Otherwise it will return false.
     */
    inline bool hasCapability () const;

    /**
     * Returns the value of the member "capability".
     *
     * If the meaning of "capability" isn't clear, then there should be a description here.
     *
     * @return The value of the field "capability"
     */
    inline const ::std::string& getCapability () const;

    /**
     * Retrieves the value of the field "capability" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "capability".
     */
    inline ::std::string& getCapabilityMutable ();

    /**
     * Sets the value of the member "capability".
     *
     * If the meaning of "capability" isn't clear, then there should be a description here.
     *
     * @param capability The value which will be set
     */
    inline void setCapability (const ::std::string& capability_);

    /**
     * Sets the value of the member "capability".
     *
     * If the meaning of "capability" isn't clear, then there should be a description here.
     *
     * @param capability The value which will be set
     */
    inline void setCapability (const char* capability_);

    /**
     * Sets the value of the member "capability".
     *
     * If the meaning of "capability" isn't clear, then there should be a description here.
     *
     * @param capability The value which will be set
     */
    inline void setCapability (const char* value, size_t size);

    static const RegisterAgentRequest &getDefaultInstance();

private:

    inline void set_has_agent ();

    inline void clear_has_agent ();

    inline void set_has_capability ();

    inline void clear_has_capability ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _agent;

    ::std::string _capability;

};

/**
 * If the meaning of "UnregisterAgentRequest" isn't clear, then there should be a description here.
 */
class UnregisterAgentRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnregisterAgentRequest ();

    /**
     * Copy constructor
     */
    inline  UnregisterAgentRequest (const UnregisterAgentRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UnregisterAgentRequest (const ::std::string& agent_);

    /**
     * Destructor
     */
    inline virtual  ~UnregisterAgentRequest();

    /**
     * Assignment operator
     */
    inline UnregisterAgentRequest& operator = (const UnregisterAgentRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnregisterAgentRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnregisterAgentRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnregisterAgentRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnregisterAgentRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "agent"

    static const int kAgent = 0;

    /**
     * Clears the field "agent".
     *
     * The field will be set to its default value. The hasAgent()
     * method will return false.
     */
    inline void clearAgent();

    /**
     * Checks whether the field "agent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAgent()). Otherwise it will return false.
     */
    inline bool hasAgent () const;

    /**
     * Returns the value of the member "agent".
     *
     * If the meaning of "agent" isn't clear, then there should be a description here.
     *
     * @return The value of the field "agent"
     */
    inline const ::std::string& getAgent () const;

    /**
     * Retrieves the value of the field "agent" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "agent".
     */
    inline ::std::string& getAgentMutable ();

    /**
     * Sets the value of the member "agent".
     *
     * If the meaning of "agent" isn't clear, then there should be a description here.
     *
     * @param agent The value which will be set
     */
    inline void setAgent (const ::std::string& agent_);

    /**
     * Sets the value of the member "agent".
     *
     * If the meaning of "agent" isn't clear, then there should be a description here.
     *
     * @param agent The value which will be set
     */
    inline void setAgent (const char* agent_);

    /**
     * Sets the value of the member "agent".
     *
     * If the meaning of "agent" isn't clear, then there should be a description here.
     *
     * @param agent The value which will be set
     */
    inline void setAgent (const char* value, size_t size);

    static const UnregisterAgentRequest &getDefaultInstance();

private:

    inline void set_has_agent ();

    inline void clear_has_agent ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _agent;

};

/**
 * If the meaning of "RequestDefaultAgentRequest" isn't clear, then there should be a description here.
 */
class RequestDefaultAgentRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestDefaultAgentRequest ();

    /**
     * Copy constructor
     */
    inline  RequestDefaultAgentRequest (const RequestDefaultAgentRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestDefaultAgentRequest (const ::std::string& agent_);

    /**
     * Destructor
     */
    inline virtual  ~RequestDefaultAgentRequest();

    /**
     * Assignment operator
     */
    inline RequestDefaultAgentRequest& operator = (const RequestDefaultAgentRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestDefaultAgentRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestDefaultAgentRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestDefaultAgentRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestDefaultAgentRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "agent"

    static const int kAgent = 0;

    /**
     * Clears the field "agent".
     *
     * The field will be set to its default value. The hasAgent()
     * method will return false.
     */
    inline void clearAgent();

    /**
     * Checks whether the field "agent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAgent()). Otherwise it will return false.
     */
    inline bool hasAgent () const;

    /**
     * Returns the value of the member "agent".
     *
     * If the meaning of "agent" isn't clear, then there should be a description here.
     *
     * @return The value of the field "agent"
     */
    inline const ::std::string& getAgent () const;

    /**
     * Retrieves the value of the field "agent" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "agent".
     */
    inline ::std::string& getAgentMutable ();

    /**
     * Sets the value of the member "agent".
     *
     * If the meaning of "agent" isn't clear, then there should be a description here.
     *
     * @param agent The value which will be set
     */
    inline void setAgent (const ::std::string& agent_);

    /**
     * Sets the value of the member "agent".
     *
     * If the meaning of "agent" isn't clear, then there should be a description here.
     *
     * @param agent The value which will be set
     */
    inline void setAgent (const char* agent_);

    /**
     * Sets the value of the member "agent".
     *
     * If the meaning of "agent" isn't clear, then there should be a description here.
     *
     * @param agent The value which will be set
     */
    inline void setAgent (const char* value, size_t size);

    static const RequestDefaultAgentRequest &getDefaultInstance();

private:

    inline void set_has_agent ();

    inline void clear_has_agent ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _agent;

};

inline  RegisterAgentRequest::RegisterAgentRequest ()  :
    _agent (),
    _capability ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterAgentRequest::RegisterAgentRequest (const RegisterAgentRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _agent (),
    _capability ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterAgentRequest::RegisterAgentRequest (const ::std::string& agent_, const ::std::string& capability_)  :
    _agent (agent_),
    _capability (capability_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (agent_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (capability_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterAgentRequest::~RegisterAgentRequest() {
}

inline RegisterAgentRequest& RegisterAgentRequest::operator = (const RegisterAgentRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAgent()) {
            setAgent(rhs.getAgent());
        } else {
            clearAgent();
        }
        if (rhs.hasCapability()) {
            setCapability(rhs.getCapability());
        } else {
            clearCapability();
        }
    }
    return *this;
}

inline bool RegisterAgentRequest::operator == (const RegisterAgentRequest& rhs) const {
    return (((!hasAgent() && !rhs.hasAgent()) || getAgent() == rhs.getAgent()) &&
        ((!hasCapability() && !rhs.hasCapability()) || getCapability() == rhs.getCapability()));
}

inline bool RegisterAgentRequest::operator != (const RegisterAgentRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterAgentRequest::operator < (const RegisterAgentRequest& rhs) const {
    if (hasAgent() || rhs.hasAgent()) {
        if (getAgent() < rhs.getAgent()) return true;
        if (getAgent() > rhs.getAgent()) return false;
    }
    if (hasCapability() || rhs.hasCapability()) {
        if (getCapability() < rhs.getCapability()) return true;
        if (getCapability() > rhs.getCapability()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterAgentRequest::clone() {
    return new RegisterAgentRequest(*this);
}

inline bool RegisterAgentRequest::operator > (const RegisterAgentRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterAgentRequest::clear() {
    clearAgent();
    clearCapability();
}

inline void RegisterAgentRequest::clearAgent() {
    if (hasAgent()) {
         clear_has_agent();
        _agent.clear();
     }
}

inline bool RegisterAgentRequest::hasAgent () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RegisterAgentRequest::getAgent () const {
    return _agent;
}

inline ::std::string& RegisterAgentRequest::getAgentMutable () {
    set_has_agent();
    return _agent;
}

inline void RegisterAgentRequest::setAgent (const ::std::string& agent_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (agent_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_agent();
    this->_agent = agent_;
}

inline void RegisterAgentRequest::setAgent (const char* agent_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (agent_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_agent();
    this->_agent.assign(agent_);
}

inline void RegisterAgentRequest::setAgent (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_agent();
    this->_agent.assign(value, size);
}

inline void RegisterAgentRequest::clearCapability() {
    if (hasCapability()) {
         clear_has_capability();
        _capability.clear();
     }
}

inline bool RegisterAgentRequest::hasCapability () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& RegisterAgentRequest::getCapability () const {
    return _capability;
}

inline ::std::string& RegisterAgentRequest::getCapabilityMutable () {
    set_has_capability();
    return _capability;
}

inline void RegisterAgentRequest::setCapability (const ::std::string& capability_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (capability_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_capability();
    this->_capability = capability_;
}

inline void RegisterAgentRequest::setCapability (const char* capability_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (capability_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_capability();
    this->_capability.assign(capability_);
}

inline void RegisterAgentRequest::setCapability (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_capability();
    this->_capability.assign(value, size);
}

inline void RegisterAgentRequest::set_has_agent () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterAgentRequest::clear_has_agent () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RegisterAgentRequest::set_has_capability () {
    _has_bits_[0] |= 1u << 1;
}

inline void RegisterAgentRequest::clear_has_capability () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  UnregisterAgentRequest::UnregisterAgentRequest ()  :
    _agent ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnregisterAgentRequest::UnregisterAgentRequest (const UnregisterAgentRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _agent ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnregisterAgentRequest::UnregisterAgentRequest (const ::std::string& agent_)  :
    _agent (agent_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (agent_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnregisterAgentRequest::~UnregisterAgentRequest() {
}

inline UnregisterAgentRequest& UnregisterAgentRequest::operator = (const UnregisterAgentRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAgent()) {
            setAgent(rhs.getAgent());
        } else {
            clearAgent();
        }
    }
    return *this;
}

inline bool UnregisterAgentRequest::operator == (const UnregisterAgentRequest& rhs) const {
    return (((!hasAgent() && !rhs.hasAgent()) || getAgent() == rhs.getAgent()));
}

inline bool UnregisterAgentRequest::operator != (const UnregisterAgentRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UnregisterAgentRequest::operator < (const UnregisterAgentRequest& rhs) const {
    if (hasAgent() || rhs.hasAgent()) {
        if (getAgent() < rhs.getAgent()) return true;
        if (getAgent() > rhs.getAgent()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnregisterAgentRequest::clone() {
    return new UnregisterAgentRequest(*this);
}

inline bool UnregisterAgentRequest::operator > (const UnregisterAgentRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnregisterAgentRequest::clear() {
    clearAgent();
}

inline void UnregisterAgentRequest::clearAgent() {
    if (hasAgent()) {
         clear_has_agent();
        _agent.clear();
     }
}

inline bool UnregisterAgentRequest::hasAgent () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& UnregisterAgentRequest::getAgent () const {
    return _agent;
}

inline ::std::string& UnregisterAgentRequest::getAgentMutable () {
    set_has_agent();
    return _agent;
}

inline void UnregisterAgentRequest::setAgent (const ::std::string& agent_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (agent_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_agent();
    this->_agent = agent_;
}

inline void UnregisterAgentRequest::setAgent (const char* agent_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (agent_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_agent();
    this->_agent.assign(agent_);
}

inline void UnregisterAgentRequest::setAgent (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_agent();
    this->_agent.assign(value, size);
}

inline void UnregisterAgentRequest::set_has_agent () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnregisterAgentRequest::clear_has_agent () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestDefaultAgentRequest::RequestDefaultAgentRequest ()  :
    _agent ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestDefaultAgentRequest::RequestDefaultAgentRequest (const RequestDefaultAgentRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _agent ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestDefaultAgentRequest::RequestDefaultAgentRequest (const ::std::string& agent_)  :
    _agent (agent_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (agent_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestDefaultAgentRequest::~RequestDefaultAgentRequest() {
}

inline RequestDefaultAgentRequest& RequestDefaultAgentRequest::operator = (const RequestDefaultAgentRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAgent()) {
            setAgent(rhs.getAgent());
        } else {
            clearAgent();
        }
    }
    return *this;
}

inline bool RequestDefaultAgentRequest::operator == (const RequestDefaultAgentRequest& rhs) const {
    return (((!hasAgent() && !rhs.hasAgent()) || getAgent() == rhs.getAgent()));
}

inline bool RequestDefaultAgentRequest::operator != (const RequestDefaultAgentRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestDefaultAgentRequest::operator < (const RequestDefaultAgentRequest& rhs) const {
    if (hasAgent() || rhs.hasAgent()) {
        if (getAgent() < rhs.getAgent()) return true;
        if (getAgent() > rhs.getAgent()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestDefaultAgentRequest::clone() {
    return new RequestDefaultAgentRequest(*this);
}

inline bool RequestDefaultAgentRequest::operator > (const RequestDefaultAgentRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestDefaultAgentRequest::clear() {
    clearAgent();
}

inline void RequestDefaultAgentRequest::clearAgent() {
    if (hasAgent()) {
         clear_has_agent();
        _agent.clear();
     }
}

inline bool RequestDefaultAgentRequest::hasAgent () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RequestDefaultAgentRequest::getAgent () const {
    return _agent;
}

inline ::std::string& RequestDefaultAgentRequest::getAgentMutable () {
    set_has_agent();
    return _agent;
}

inline void RequestDefaultAgentRequest::setAgent (const ::std::string& agent_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (agent_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_agent();
    this->_agent = agent_;
}

inline void RequestDefaultAgentRequest::setAgent (const char* agent_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (agent_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_agent();
    this->_agent.assign(agent_);
}

inline void RequestDefaultAgentRequest::setAgent (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_agent();
    this->_agent.assign(value, size);
}

inline void RequestDefaultAgentRequest::set_has_agent () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestDefaultAgentRequest::clear_has_agent () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace AgentManager
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_AGENTMANAGER_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
