/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_ADAPTER1STUB_H
#define ORG_BLUEZ_ADAPTER1STUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/Adapter1.h"
#include <map>
#include <string>
#include <vector>

namespace org {
namespace bluez {
namespace Adapter1 {

class Adapter1StubDelegate;

class Adapter1Stub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the Adapter1Stub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    Adapter1Stub (const std::string& portName);

    /**
     * Create an instance of the Adapter1Stub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    Adapter1Stub (const std::string& portName, const std::string& objectPath);

    virtual ~Adapter1Stub();

    // signal 'AdapterInitialization'

    /**
     * Raise the signal 'AdapterInitialization' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'AdapterInitialization'</b>:
     *
     * If the meaning of "AdapterInitialization" isn't clear, then there should be a description here.
     */
    void sendAdapterInitializationSignal();

    // signal 'DeviceCreated'

    /**
     * Raise the signal 'DeviceCreated' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'DeviceCreated'</b>:
     *
     * If the meaning of "DeviceCreated" isn't clear, then there should be a description here.
     */
    void sendDeviceCreatedSignal(const ::std::string& device);

    // signal 'DeviceRemoved'

    /**
     * Raise the signal 'DeviceRemoved' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'DeviceRemoved'</b>:
     *
     * If the meaning of "DeviceRemoved" isn't clear, then there should be a description here.
     */
    void sendDeviceRemovedSignal(const ::std::string& device);

    // signal 'BtStackLog'

    /**
     * Raise the signal 'BtStackLog' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'BtStackLog'</b>:
     *
     * If the meaning of "BtStackLog" isn't clear, then there should be a description here.
     */
    void sendBtStackLogSignal(uint8 status, uint16 opcode, const ::std::vector< uint8 >& data);

    // signal 'HCIEvent'

    /**
     * Raise the signal 'HCIEvent' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'HCIEvent'</b>:
     *
     * If the meaning of "HCIEvent" isn't clear, then there should be a description here.
     */
    void sendHCIEventSignal(const ::std::vector< uint8 >& data);

    // signal 'DeviceFound'

    /**
     * Raise the signal 'DeviceFound' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'DeviceFound'</b>:
     *
     * If the meaning of "DeviceFound" isn't clear, then there should be a description here.
     */
    void sendDeviceFoundSignal(const ::std::string& address, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& values);

    // property 'Address'

    /**
     * The method onAddressGet() is called by ASF when a client invokes the
     * read method for the property 'Address'. The onAddressGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    virtual void onAddressGet(const ::boost::shared_ptr< AddressGet >& payload);

    /**
     * Sends back the update to a previous onAddressGet().
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAddressGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAddressGetUpdate(const ::std::string& address, act_t act = 0);

    /**
     * Set the value of the property 'Address' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    void setAddress(const ::std::string& address);

    /**
     * Returns the current value of the property 'Address'.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    const ::std::string& getAddress() const;

    /**
     * Returns the current value of the property 'Address' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendAddressUpdate() method.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    ::std::string& getAddressMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAddressUpdate().
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    void sendAddressUpdate();

    // property 'Class'

    /**
     * The method onClassGet() is called by ASF when a client invokes the read
     * method for the property 'Class'. The onClassGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     */
    virtual void onClassGet(const ::boost::shared_ptr< ClassGet >& payload);

    /**
     * Sends back the update to a previous onClassGet().
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onClassGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendClassGetUpdate(uint32 class_, act_t act = 0);

    /**
     * Set the value of the property 'Class' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     */
    void setClass(uint32 class_);

    /**
     * Returns the current value of the property 'Class'.
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     */
    uint32 getClass() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendClassUpdate().
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     */
    void sendClassUpdate();

    // property 'Alias'

    /**
     * The method onAliasGet() is called by ASF when a client invokes the read
     * method for the property 'Alias'. The onAliasGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    virtual void onAliasGet(const ::boost::shared_ptr< AliasGet >& payload);

    /**
     * Sends back the update to a previous onAliasGet().
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAliasGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAliasGetUpdate(const ::std::string& alias, act_t act = 0);

    /**
     * The method onAliasSet() is called by ASF when a client invokes the
     * write method for the property 'Alias'. The onAliasSet() method set
     * property value to the given parameter Alias by default. If this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    virtual void onAliasSet(const ::boost::shared_ptr< AliasSet >& payload);

    /**
     * Sends back the update to a previous onAliasSet().
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAliasSet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAliasSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Alias' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    void setAlias(const ::std::string& alias);

    /**
     * Returns the current value of the property 'Alias'.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    const ::std::string& getAlias() const;

    /**
     * Returns the current value of the property 'Alias' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendAliasUpdate() method.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    ::std::string& getAliasMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAliasUpdate().
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    void sendAliasUpdate();

    // property 'Powered'

    /**
     * The method onPoweredGet() is called by ASF when a client invokes the
     * read method for the property 'Powered'. The onPoweredGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    virtual void onPoweredGet(const ::boost::shared_ptr< PoweredGet >& payload);

    /**
     * Sends back the update to a previous onPoweredGet().
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPoweredGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPoweredGetUpdate(bool powered, act_t act = 0);

    /**
     * The method onPoweredSet() is called by ASF when a client invokes the
     * write method for the property 'Powered'. The onPoweredSet() method set
     * property value to the given parameter Powered by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    virtual void onPoweredSet(const ::boost::shared_ptr< PoweredSet >& payload);

    /**
     * Sends back the update to a previous onPoweredSet().
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPoweredSet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPoweredSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Powered' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    void setPowered(bool powered);

    /**
     * Returns the current value of the property 'Powered'.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    bool getPowered() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPoweredUpdate().
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    void sendPoweredUpdate();

    // property 'Discoverable'

    /**
     * The method onDiscoverableGet() is called by ASF when a client invokes
     * the read method for the property 'Discoverable'. The
     * onDiscoverableGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'Discoverable'</b>:
     *
     * If the meaning of "Discoverable" isn't clear, then there should be a description here.
     */
    virtual void onDiscoverableGet(const ::boost::shared_ptr< DiscoverableGet >& payload);

    /**
     * Sends back the update to a previous onDiscoverableGet().
     *
     * <b>Documentation of 'Discoverable'</b>:
     *
     * If the meaning of "Discoverable" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onDiscoverableGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDiscoverableGetUpdate(bool discoverable, act_t act = 0);

    /**
     * The method onDiscoverableSet() is called by ASF when a client invokes
     * the write method for the property 'Discoverable'. The
     * onDiscoverableSet() method set property value to the given parameter
     * Discoverable by default. If this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'Discoverable'</b>:
     *
     * If the meaning of "Discoverable" isn't clear, then there should be a description here.
     */
    virtual void onDiscoverableSet(const ::boost::shared_ptr< DiscoverableSet >& payload);

    /**
     * Sends back the update to a previous onDiscoverableSet().
     *
     * <b>Documentation of 'Discoverable'</b>:
     *
     * If the meaning of "Discoverable" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onDiscoverableSet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDiscoverableSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Discoverable' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Discoverable'</b>:
     *
     * If the meaning of "Discoverable" isn't clear, then there should be a description here.
     */
    void setDiscoverable(bool discoverable);

    /**
     * Returns the current value of the property 'Discoverable'.
     *
     * <b>Documentation of 'Discoverable'</b>:
     *
     * If the meaning of "Discoverable" isn't clear, then there should be a description here.
     */
    bool getDiscoverable() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDiscoverableUpdate().
     *
     * <b>Documentation of 'Discoverable'</b>:
     *
     * If the meaning of "Discoverable" isn't clear, then there should be a description here.
     */
    void sendDiscoverableUpdate();

    // property 'DiscoverableTimeout'

    /**
     * The method onDiscoverableTimeoutGet() is called by ASF when a client
     * invokes the read method for the property 'DiscoverableTimeout'. The
     * onDiscoverableTimeoutGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'DiscoverableTimeout'</b>:
     *
     * If the meaning of "DiscoverableTimeout" isn't clear, then there should be a description here.
     */
    virtual void onDiscoverableTimeoutGet(const ::boost::shared_ptr< DiscoverableTimeoutGet >& payload);

    /**
     * Sends back the update to a previous onDiscoverableTimeoutGet().
     *
     * <b>Documentation of 'DiscoverableTimeout'</b>:
     *
     * If the meaning of "DiscoverableTimeout" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onDiscoverableTimeoutGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDiscoverableTimeoutGetUpdate(uint32 discoverableTimeout, act_t act = 0);

    /**
     * The method onDiscoverableTimeoutSet() is called by ASF when a client
     * invokes the write method for the property 'DiscoverableTimeout'. The
     * onDiscoverableTimeoutSet() method set property value to the given
     * parameter DiscoverableTimeout by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'DiscoverableTimeout'</b>:
     *
     * If the meaning of "DiscoverableTimeout" isn't clear, then there should be a description here.
     */
    virtual void onDiscoverableTimeoutSet(const ::boost::shared_ptr< DiscoverableTimeoutSet >& payload);

    /**
     * Sends back the update to a previous onDiscoverableTimeoutSet().
     *
     * <b>Documentation of 'DiscoverableTimeout'</b>:
     *
     * If the meaning of "DiscoverableTimeout" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onDiscoverableTimeoutSet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDiscoverableTimeoutSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'DiscoverableTimeout' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DiscoverableTimeout'</b>:
     *
     * If the meaning of "DiscoverableTimeout" isn't clear, then there should be a description here.
     */
    void setDiscoverableTimeout(uint32 discoverableTimeout);

    /**
     * Returns the current value of the property 'DiscoverableTimeout'.
     *
     * <b>Documentation of 'DiscoverableTimeout'</b>:
     *
     * If the meaning of "DiscoverableTimeout" isn't clear, then there should be a description here.
     */
    uint32 getDiscoverableTimeout() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDiscoverableTimeoutUpdate().
     *
     * <b>Documentation of 'DiscoverableTimeout'</b>:
     *
     * If the meaning of "DiscoverableTimeout" isn't clear, then there should be a description here.
     */
    void sendDiscoverableTimeoutUpdate();

    // property 'Pairable'

    /**
     * The method onPairableGet() is called by ASF when a client invokes the
     * read method for the property 'Pairable'. The onPairableGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Pairable'</b>:
     *
     * If the meaning of "Pairable" isn't clear, then there should be a description here.
     */
    virtual void onPairableGet(const ::boost::shared_ptr< PairableGet >& payload);

    /**
     * Sends back the update to a previous onPairableGet().
     *
     * <b>Documentation of 'Pairable'</b>:
     *
     * If the meaning of "Pairable" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPairableGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPairableGetUpdate(bool pairable, act_t act = 0);

    /**
     * The method onPairableSet() is called by ASF when a client invokes the
     * write method for the property 'Pairable'. The onPairableSet() method
     * set property value to the given parameter Pairable by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Pairable'</b>:
     *
     * If the meaning of "Pairable" isn't clear, then there should be a description here.
     */
    virtual void onPairableSet(const ::boost::shared_ptr< PairableSet >& payload);

    /**
     * Sends back the update to a previous onPairableSet().
     *
     * <b>Documentation of 'Pairable'</b>:
     *
     * If the meaning of "Pairable" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPairableSet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPairableSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Pairable' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Pairable'</b>:
     *
     * If the meaning of "Pairable" isn't clear, then there should be a description here.
     */
    void setPairable(bool pairable);

    /**
     * Returns the current value of the property 'Pairable'.
     *
     * <b>Documentation of 'Pairable'</b>:
     *
     * If the meaning of "Pairable" isn't clear, then there should be a description here.
     */
    bool getPairable() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPairableUpdate().
     *
     * <b>Documentation of 'Pairable'</b>:
     *
     * If the meaning of "Pairable" isn't clear, then there should be a description here.
     */
    void sendPairableUpdate();

    // property 'PairableTimeout'

    /**
     * The method onPairableTimeoutGet() is called by ASF when a client
     * invokes the read method for the property 'PairableTimeout'. The
     * onPairableTimeoutGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'PairableTimeout'</b>:
     *
     * If the meaning of "PairableTimeout" isn't clear, then there should be a description here.
     */
    virtual void onPairableTimeoutGet(const ::boost::shared_ptr< PairableTimeoutGet >& payload);

    /**
     * Sends back the update to a previous onPairableTimeoutGet().
     *
     * <b>Documentation of 'PairableTimeout'</b>:
     *
     * If the meaning of "PairableTimeout" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPairableTimeoutGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPairableTimeoutGetUpdate(uint32 pairableTimeout, act_t act = 0);

    /**
     * The method onPairableTimeoutSet() is called by ASF when a client
     * invokes the write method for the property 'PairableTimeout'. The
     * onPairableTimeoutSet() method set property value to the given parameter
     * PairableTimeout by default. If this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'PairableTimeout'</b>:
     *
     * If the meaning of "PairableTimeout" isn't clear, then there should be a description here.
     */
    virtual void onPairableTimeoutSet(const ::boost::shared_ptr< PairableTimeoutSet >& payload);

    /**
     * Sends back the update to a previous onPairableTimeoutSet().
     *
     * <b>Documentation of 'PairableTimeout'</b>:
     *
     * If the meaning of "PairableTimeout" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPairableTimeoutSet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPairableTimeoutSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'PairableTimeout' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'PairableTimeout'</b>:
     *
     * If the meaning of "PairableTimeout" isn't clear, then there should be a description here.
     */
    void setPairableTimeout(uint32 pairableTimeout);

    /**
     * Returns the current value of the property 'PairableTimeout'.
     *
     * <b>Documentation of 'PairableTimeout'</b>:
     *
     * If the meaning of "PairableTimeout" isn't clear, then there should be a description here.
     */
    uint32 getPairableTimeout() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPairableTimeoutUpdate().
     *
     * <b>Documentation of 'PairableTimeout'</b>:
     *
     * If the meaning of "PairableTimeout" isn't clear, then there should be a description here.
     */
    void sendPairableTimeoutUpdate();

    // property 'Discovering'

    /**
     * The method onDiscoveringGet() is called by ASF when a client invokes
     * the read method for the property 'Discovering'. The onDiscoveringGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'Discovering'</b>:
     *
     * If the meaning of "Discovering" isn't clear, then there should be a description here.
     */
    virtual void onDiscoveringGet(const ::boost::shared_ptr< DiscoveringGet >& payload);

    /**
     * Sends back the update to a previous onDiscoveringGet().
     *
     * <b>Documentation of 'Discovering'</b>:
     *
     * If the meaning of "Discovering" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onDiscoveringGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDiscoveringGetUpdate(bool discovering, act_t act = 0);

    /**
     * Set the value of the property 'Discovering' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Discovering'</b>:
     *
     * If the meaning of "Discovering" isn't clear, then there should be a description here.
     */
    void setDiscovering(bool discovering);

    /**
     * Returns the current value of the property 'Discovering'.
     *
     * <b>Documentation of 'Discovering'</b>:
     *
     * If the meaning of "Discovering" isn't clear, then there should be a description here.
     */
    bool getDiscovering() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDiscoveringUpdate().
     *
     * <b>Documentation of 'Discovering'</b>:
     *
     * If the meaning of "Discovering" isn't clear, then there should be a description here.
     */
    void sendDiscoveringUpdate();

    // property 'UUIDs'

    /**
     * The method onUUIDsGet() is called by ASF when a client invokes the read
     * method for the property 'UUIDs'. The onUUIDsGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     */
    virtual void onUUIDsGet(const ::boost::shared_ptr< UUIDsGet >& payload);

    /**
     * Sends back the update to a previous onUUIDsGet().
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onUUIDsGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendUUIDsGetUpdate(const ::std::vector< ::std::string >& uUIDs, act_t act = 0);

    /**
     * The method onUUIDsSet() is called by ASF when a client invokes the
     * write method for the property 'UUIDs'. The onUUIDsSet() method set
     * property value to the given parameter UUIDs by default. If this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     */
    virtual void onUUIDsSet(const ::boost::shared_ptr< UUIDsSet >& payload);

    /**
     * Sends back the update to a previous onUUIDsSet().
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onUUIDsSet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendUUIDsSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'UUIDs' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     */
    void setUUIDs(const ::std::vector< ::std::string >& uUIDs);

    /**
     * Returns the current value of the property 'UUIDs'.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     */
    const ::std::vector< ::std::string >& getUUIDs() const;

    /**
     * Returns the current value of the property 'UUIDs' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendUUIDsUpdate() method.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     */
    ::std::vector< ::std::string >& getUUIDsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUUIDsUpdate().
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     */
    void sendUUIDsUpdate();

    // property 'WBSMode'

    /**
     * The method onWBSModeGet() is called by ASF when a client invokes the
     * read method for the property 'WBSMode'. The onWBSModeGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'WBSMode'</b>:
     *
     * If the meaning of "WBSMode" isn't clear, then there should be a description here.
     */
    virtual void onWBSModeGet(const ::boost::shared_ptr< WBSModeGet >& payload);

    /**
     * Sends back the update to a previous onWBSModeGet().
     *
     * <b>Documentation of 'WBSMode'</b>:
     *
     * If the meaning of "WBSMode" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onWBSModeGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendWBSModeGetUpdate(bool wBSMode, act_t act = 0);

    /**
     * The method onWBSModeSet() is called by ASF when a client invokes the
     * write method for the property 'WBSMode'. The onWBSModeSet() method set
     * property value to the given parameter WBSMode by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'WBSMode'</b>:
     *
     * If the meaning of "WBSMode" isn't clear, then there should be a description here.
     */
    virtual void onWBSModeSet(const ::boost::shared_ptr< WBSModeSet >& payload);

    /**
     * Sends back the update to a previous onWBSModeSet().
     *
     * <b>Documentation of 'WBSMode'</b>:
     *
     * If the meaning of "WBSMode" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onWBSModeSet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendWBSModeSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'WBSMode' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'WBSMode'</b>:
     *
     * If the meaning of "WBSMode" isn't clear, then there should be a description here.
     */
    void setWBSMode(bool wBSMode);

    /**
     * Returns the current value of the property 'WBSMode'.
     *
     * <b>Documentation of 'WBSMode'</b>:
     *
     * If the meaning of "WBSMode" isn't clear, then there should be a description here.
     */
    bool getWBSMode() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWBSModeUpdate().
     *
     * <b>Documentation of 'WBSMode'</b>:
     *
     * If the meaning of "WBSMode" isn't clear, then there should be a description here.
     */
    void sendWBSModeUpdate();

    // property 'Connectable'

    /**
     * The method onConnectableGet() is called by ASF when a client invokes
     * the read method for the property 'Connectable'. The onConnectableGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'Connectable'</b>:
     *
     * If the meaning of "Connectable" isn't clear, then there should be a description here.
     */
    virtual void onConnectableGet(const ::boost::shared_ptr< ConnectableGet >& payload);

    /**
     * Sends back the update to a previous onConnectableGet().
     *
     * <b>Documentation of 'Connectable'</b>:
     *
     * If the meaning of "Connectable" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onConnectableGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendConnectableGetUpdate(bool connectable, act_t act = 0);

    /**
     * The method onConnectableSet() is called by ASF when a client invokes
     * the write method for the property 'Connectable'. The onConnectableSet()
     * method set property value to the given parameter Connectable by
     * default. If this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'Connectable'</b>:
     *
     * If the meaning of "Connectable" isn't clear, then there should be a description here.
     */
    virtual void onConnectableSet(const ::boost::shared_ptr< ConnectableSet >& payload);

    /**
     * Sends back the update to a previous onConnectableSet().
     *
     * <b>Documentation of 'Connectable'</b>:
     *
     * If the meaning of "Connectable" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onConnectableSet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendConnectableSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Connectable' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Connectable'</b>:
     *
     * If the meaning of "Connectable" isn't clear, then there should be a description here.
     */
    void setConnectable(bool connectable);

    /**
     * Returns the current value of the property 'Connectable'.
     *
     * <b>Documentation of 'Connectable'</b>:
     *
     * If the meaning of "Connectable" isn't clear, then there should be a description here.
     */
    bool getConnectable() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendConnectableUpdate().
     *
     * <b>Documentation of 'Connectable'</b>:
     *
     * If the meaning of "Connectable" isn't clear, then there should be a description here.
     */
    void sendConnectableUpdate();

    // property 'HCIMode'

    /**
     * The method onHCIModeGet() is called by ASF when a client invokes the
     * read method for the property 'HCIMode'. The onHCIModeGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'HCIMode'</b>:
     *
     * If the meaning of "HCIMode" isn't clear, then there should be a description here.
     */
    virtual void onHCIModeGet(const ::boost::shared_ptr< HCIModeGet >& payload);

    /**
     * Sends back the update to a previous onHCIModeGet().
     *
     * <b>Documentation of 'HCIMode'</b>:
     *
     * If the meaning of "HCIMode" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onHCIModeGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendHCIModeGetUpdate(bool hCIMode, act_t act = 0);

    /**
     * The method onHCIModeSet() is called by ASF when a client invokes the
     * write method for the property 'HCIMode'. The onHCIModeSet() method set
     * property value to the given parameter HCIMode by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'HCIMode'</b>:
     *
     * If the meaning of "HCIMode" isn't clear, then there should be a description here.
     */
    virtual void onHCIModeSet(const ::boost::shared_ptr< HCIModeSet >& payload);

    /**
     * Sends back the update to a previous onHCIModeSet().
     *
     * <b>Documentation of 'HCIMode'</b>:
     *
     * If the meaning of "HCIMode" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onHCIModeSet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendHCIModeSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'HCIMode' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'HCIMode'</b>:
     *
     * If the meaning of "HCIMode" isn't clear, then there should be a description here.
     */
    void setHCIMode(bool hCIMode);

    /**
     * Returns the current value of the property 'HCIMode'.
     *
     * <b>Documentation of 'HCIMode'</b>:
     *
     * If the meaning of "HCIMode" isn't clear, then there should be a description here.
     */
    bool getHCIMode() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendHCIModeUpdate().
     *
     * <b>Documentation of 'HCIMode'</b>:
     *
     * If the meaning of "HCIMode" isn't clear, then there should be a description here.
     */
    void sendHCIModeUpdate();

    // property 'Version'

    /**
     * The method onVersionGet() is called by ASF when a client invokes the
     * read method for the property 'Version'. The onVersionGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    virtual void onVersionGet(const ::boost::shared_ptr< VersionGet >& payload);

    /**
     * Sends back the update to a previous onVersionGet().
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onVersionGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendVersionGetUpdate(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& version, act_t act = 0);

    /**
     * Set the value of the property 'Version' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    void setVersion(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& version);

    /**
     * Returns the current value of the property 'Version'.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getVersion() const;

    /**
     * Returns the current value of the property 'Version' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendVersionUpdate() method.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getVersionMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendVersionUpdate().
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    void sendVersionUpdate();

    // property 'TraceLevel'

    /**
     * The method onTraceLevelGet() is called by ASF when a client invokes the
     * read method for the property 'TraceLevel'. The onTraceLevelGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'TraceLevel'</b>:
     *
     * If the meaning of "TraceLevel" isn't clear, then there should be a description here.
     */
    virtual void onTraceLevelGet(const ::boost::shared_ptr< TraceLevelGet >& payload);

    /**
     * Sends back the update to a previous onTraceLevelGet().
     *
     * <b>Documentation of 'TraceLevel'</b>:
     *
     * If the meaning of "TraceLevel" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTraceLevelGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTraceLevelGetUpdate(const ::std::vector< ::std::string >& traceLevel, act_t act = 0);

    /**
     * The method onTraceLevelSet() is called by ASF when a client invokes the
     * write method for the property 'TraceLevel'. The onTraceLevelSet()
     * method set property value to the given parameter TraceLevel by default.
     * If this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'TraceLevel'</b>:
     *
     * If the meaning of "TraceLevel" isn't clear, then there should be a description here.
     */
    virtual void onTraceLevelSet(const ::boost::shared_ptr< TraceLevelSet >& payload);

    /**
     * Sends back the update to a previous onTraceLevelSet().
     *
     * <b>Documentation of 'TraceLevel'</b>:
     *
     * If the meaning of "TraceLevel" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTraceLevelSet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTraceLevelSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'TraceLevel' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'TraceLevel'</b>:
     *
     * If the meaning of "TraceLevel" isn't clear, then there should be a description here.
     */
    void setTraceLevel(const ::std::vector< ::std::string >& traceLevel);

    /**
     * Returns the current value of the property 'TraceLevel'.
     *
     * <b>Documentation of 'TraceLevel'</b>:
     *
     * If the meaning of "TraceLevel" isn't clear, then there should be a description here.
     */
    const ::std::vector< ::std::string >& getTraceLevel() const;

    /**
     * Returns the current value of the property 'TraceLevel' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendTraceLevelUpdate() method.
     *
     * <b>Documentation of 'TraceLevel'</b>:
     *
     * If the meaning of "TraceLevel" isn't clear, then there should be a description here.
     */
    ::std::vector< ::std::string >& getTraceLevelMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTraceLevelUpdate().
     *
     * <b>Documentation of 'TraceLevel'</b>:
     *
     * If the meaning of "TraceLevel" isn't clear, then there should be a description here.
     */
    void sendTraceLevelUpdate();

    // property 'TraceCategory'

    /**
     * The method onTraceCategoryGet() is called by ASF when a client invokes
     * the read method for the property 'TraceCategory'. The
     * onTraceCategoryGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'TraceCategory'</b>:
     *
     * If the meaning of "TraceCategory" isn't clear, then there should be a description here.
     */
    virtual void onTraceCategoryGet(const ::boost::shared_ptr< TraceCategoryGet >& payload);

    /**
     * Sends back the update to a previous onTraceCategoryGet().
     *
     * <b>Documentation of 'TraceCategory'</b>:
     *
     * If the meaning of "TraceCategory" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTraceCategoryGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTraceCategoryGetUpdate(const ::std::vector< ::std::string >& traceCategory, act_t act = 0);

    /**
     * The method onTraceCategorySet() is called by ASF when a client invokes
     * the write method for the property 'TraceCategory'. The
     * onTraceCategorySet() method set property value to the given parameter
     * TraceCategory by default. If this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'TraceCategory'</b>:
     *
     * If the meaning of "TraceCategory" isn't clear, then there should be a description here.
     */
    virtual void onTraceCategorySet(const ::boost::shared_ptr< TraceCategorySet >& payload);

    /**
     * Sends back the update to a previous onTraceCategorySet().
     *
     * <b>Documentation of 'TraceCategory'</b>:
     *
     * If the meaning of "TraceCategory" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTraceCategorySet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTraceCategorySetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'TraceCategory' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'TraceCategory'</b>:
     *
     * If the meaning of "TraceCategory" isn't clear, then there should be a description here.
     */
    void setTraceCategory(const ::std::vector< ::std::string >& traceCategory);

    /**
     * Returns the current value of the property 'TraceCategory'.
     *
     * <b>Documentation of 'TraceCategory'</b>:
     *
     * If the meaning of "TraceCategory" isn't clear, then there should be a description here.
     */
    const ::std::vector< ::std::string >& getTraceCategory() const;

    /**
     * Returns the current value of the property 'TraceCategory' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendTraceCategoryUpdate() method.
     *
     * <b>Documentation of 'TraceCategory'</b>:
     *
     * If the meaning of "TraceCategory" isn't clear, then there should be a description here.
     */
    ::std::vector< ::std::string >& getTraceCategoryMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTraceCategoryUpdate().
     *
     * <b>Documentation of 'TraceCategory'</b>:
     *
     * If the meaning of "TraceCategory" isn't clear, then there should be a description here.
     */
    void sendTraceCategoryUpdate();

    // property 'AvailableSPPServers'

    /**
     * The method onAvailableSPPServersGet() is called by ASF when a client
     * invokes the read method for the property 'AvailableSPPServers'. The
     * onAvailableSPPServersGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'AvailableSPPServers'</b>:
     *
     * If the meaning of "AvailableSPPServers" isn't clear, then there should be a description here.
     */
    virtual void onAvailableSPPServersGet(const ::boost::shared_ptr< AvailableSPPServersGet >& payload);

    /**
     * Sends back the update to a previous onAvailableSPPServersGet().
     *
     * <b>Documentation of 'AvailableSPPServers'</b>:
     *
     * If the meaning of "AvailableSPPServers" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onAvailableSPPServersGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendAvailableSPPServersGetUpdate(const ::std::vector< ::std::string >& availableSPPServers, act_t act = 0);

    /**
     * The method onAvailableSPPServersSet() is called by ASF when a client
     * invokes the write method for the property 'AvailableSPPServers'. The
     * onAvailableSPPServersSet() method set property value to the given
     * parameter AvailableSPPServers by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'AvailableSPPServers'</b>:
     *
     * If the meaning of "AvailableSPPServers" isn't clear, then there should be a description here.
     */
    virtual void onAvailableSPPServersSet(const ::boost::shared_ptr< AvailableSPPServersSet >& payload);

    /**
     * Sends back the update to a previous onAvailableSPPServersSet().
     *
     * <b>Documentation of 'AvailableSPPServers'</b>:
     *
     * If the meaning of "AvailableSPPServers" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onAvailableSPPServersSet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendAvailableSPPServersSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'AvailableSPPServers' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'AvailableSPPServers'</b>:
     *
     * If the meaning of "AvailableSPPServers" isn't clear, then there should be a description here.
     */
    void setAvailableSPPServers(const ::std::vector< ::std::string >& availableSPPServers);

    /**
     * Returns the current value of the property 'AvailableSPPServers'.
     *
     * <b>Documentation of 'AvailableSPPServers'</b>:
     *
     * If the meaning of "AvailableSPPServers" isn't clear, then there should be a description here.
     */
    const ::std::vector< ::std::string >& getAvailableSPPServers() const;

    /**
     * Returns the current value of the property 'AvailableSPPServers' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendAvailableSPPServersUpdate() method.
     *
     * <b>Documentation of 'AvailableSPPServers'</b>:
     *
     * If the meaning of "AvailableSPPServers" isn't clear, then there should be a description here.
     */
    ::std::vector< ::std::string >& getAvailableSPPServersMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAvailableSPPServersUpdate().
     *
     * <b>Documentation of 'AvailableSPPServers'</b>:
     *
     * If the meaning of "AvailableSPPServers" isn't clear, then there should be a description here.
     */
    void sendAvailableSPPServersUpdate();

    // method 'StartDiscovery'

    /**
     * The method onStartDiscovery() is called by ASF when a client invokes
     * the method 'StartDiscovery'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendStartDiscovery() or sendStartDiscoveryError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'StartDiscovery'</b>:
     *
     * If the meaning of "StartDiscovery" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartDiscoveryRequest (const ::boost::shared_ptr< StartDiscoveryRequest >& request) = 0;

    /**
     * The method sendStartDiscoveryResponse() sends a response of a previous
     * method invocation of 'StartDiscovery' back to the client.
     *
     * <b>Documentation of 'StartDiscovery'</b>:
     *
     * If the meaning of "StartDiscovery" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartDiscovery(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendStartDiscoveryResponse (act_t act = 0);

    /**
     * The method sendStartDiscoveryError() sends an error response of a
     * previous method invocation of 'StartDiscovery' back to the client.
     *
     * <b>Documentation of 'StartDiscovery'</b>:
     *
     * If the meaning of "StartDiscovery" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStartDiscovery(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartDiscoveryError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StopDiscovery'

    /**
     * The method onStopDiscovery() is called by ASF when a client invokes the
     * method 'StopDiscovery'. A subclass has to implement this method and
     * send back a response to the client either with the sendStopDiscovery()
     * or sendStopDiscoveryError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'StopDiscovery'</b>:
     *
     * If the meaning of "StopDiscovery" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStopDiscoveryRequest (const ::boost::shared_ptr< StopDiscoveryRequest >& request) = 0;

    /**
     * The method sendStopDiscoveryResponse() sends a response of a previous
     * method invocation of 'StopDiscovery' back to the client.
     *
     * <b>Documentation of 'StopDiscovery'</b>:
     *
     * If the meaning of "StopDiscovery" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStopDiscovery(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendStopDiscoveryResponse (act_t act = 0);

    /**
     * The method sendStopDiscoveryError() sends an error response of a
     * previous method invocation of 'StopDiscovery' back to the client.
     *
     * <b>Documentation of 'StopDiscovery'</b>:
     *
     * If the meaning of "StopDiscovery" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStopDiscovery(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStopDiscoveryError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RemoveDevice'

    /**
     * The method onRemoveDevice() is called by ASF when a client invokes the
     * method 'RemoveDevice'. A subclass has to implement this method and send
     * back a response to the client either with the sendRemoveDevice() or
     * sendRemoveDeviceError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'RemoveDevice'</b>:
     *
     * If the meaning of "RemoveDevice" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRemoveDeviceRequest (const ::boost::shared_ptr< RemoveDeviceRequest >& request) = 0;

    /**
     * The method sendRemoveDeviceResponse() sends a response of a previous
     * method invocation of 'RemoveDevice' back to the client.
     *
     * <b>Documentation of 'RemoveDevice'</b>:
     *
     * If the meaning of "RemoveDevice" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRemoveDevice(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRemoveDeviceResponse (act_t act = 0);

    /**
     * The method sendRemoveDeviceError() sends an error response of a
     * previous method invocation of 'RemoveDevice' back to the client.
     *
     * <b>Documentation of 'RemoveDevice'</b>:
     *
     * If the meaning of "RemoveDevice" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRemoveDevice(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRemoveDeviceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'CreateDevice'

    /**
     * The method onCreateDevice() is called by ASF when a client invokes the
     * method 'CreateDevice'. A subclass has to implement this method and send
     * back a response to the client either with the sendCreateDevice() or
     * sendCreateDeviceError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'CreateDevice'</b>:
     *
     * If the meaning of "CreateDevice" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCreateDeviceRequest (const ::boost::shared_ptr< CreateDeviceRequest >& request) = 0;

    /**
     * The method sendCreateDeviceResponse() sends a response of a previous
     * method invocation of 'CreateDevice' back to the client.
     *
     * <b>Documentation of 'CreateDevice'</b>:
     *
     * If the meaning of "CreateDevice" isn't clear, then there should be a description here.
     *
     * @param device If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCreateDevice(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCreateDeviceResponse (const ::std::string& device, act_t act = 0);

    /**
     * The method sendCreateDeviceError() sends an error response of a
     * previous method invocation of 'CreateDevice' back to the client.
     *
     * <b>Documentation of 'CreateDevice'</b>:
     *
     * If the meaning of "CreateDevice" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCreateDevice(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCreateDeviceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SendHCICmd'

    /**
     * The method onSendHCICmd() is called by ASF when a client invokes the
     * method 'SendHCICmd'. A subclass has to implement this method and send
     * back a response to the client either with the sendSendHCICmd() or
     * sendSendHCICmdError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SendHCICmd'</b>:
     *
     * If the meaning of "SendHCICmd" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSendHCICmdRequest (const ::boost::shared_ptr< SendHCICmdRequest >& request) = 0;

    /**
     * The method sendSendHCICmdResponse() sends a response of a previous
     * method invocation of 'SendHCICmd' back to the client.
     *
     * <b>Documentation of 'SendHCICmd'</b>:
     *
     * If the meaning of "SendHCICmd" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSendHCICmd(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSendHCICmdResponse (act_t act = 0);

    /**
     * The method sendSendHCICmdError() sends an error response of a previous
     * method invocation of 'SendHCICmd' back to the client.
     *
     * <b>Documentation of 'SendHCICmd'</b>:
     *
     * If the meaning of "SendHCICmd" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSendHCICmd(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSendHCICmdError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    AddressUpdate _AddressProperty;

    ClassUpdate _ClassProperty;

    AliasUpdate _AliasProperty;

    PoweredUpdate _PoweredProperty;

    DiscoverableUpdate _DiscoverableProperty;

    DiscoverableTimeoutUpdate _DiscoverableTimeoutProperty;

    PairableUpdate _PairableProperty;

    PairableTimeoutUpdate _PairableTimeoutProperty;

    DiscoveringUpdate _DiscoveringProperty;

    UUIDsUpdate _UUIDsProperty;

    WBSModeUpdate _WBSModeProperty;

    ConnectableUpdate _ConnectableProperty;

    HCIModeUpdate _HCIModeProperty;

    VersionUpdate _VersionProperty;

    TraceLevelUpdate _TraceLevelProperty;

    TraceCategoryUpdate _TraceCategoryProperty;

    AvailableSPPServersUpdate _AvailableSPPServersProperty;

    friend class Adapter1StubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Adapter1
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_ADAPTER1STUB_H
