/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/Adapter1.h"
#include "org/bluez/Adapter1DBus.h"
#include "org/bluez/Adapter1Json.h"
#include "org/bluez/Adapter1Stub.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace Adapter1 {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/org/bluez/Adapter1", Adapter1Stub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 10, "SendHCICmd", 4 },
    { 12, "CreateDevice", 3 },
    { 12, "RemoveDevice", 2 },
    { 13, "StopDiscovery", 1 },
    { 14, "StartDiscovery", 0 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 5, "Alias", 2 },
    { 5, "Class", 1 },
    { 5, "UUIDs", 9 },
    { 7, "Address", 0 },
    { 7, "HCIMode", 12 },
    { 7, "Powered", 3 },
    { 7, "Version", 13 },
    { 7, "WBSMode", 10 },
    { 8, "Pairable", 6 },
    { 10, "TraceLevel", 14 },
    { 11, "Connectable", 11 },
    { 11, "Discovering", 8 },
    { 12, "Discoverable", 4 },
    { 13, "TraceCategory", 15 },
    { 15, "PairableTimeout", 7 },
    { 19, "AvailableSPPServers", 16 },
    { 19, "DiscoverableTimeout", 5 },
};

class Adapter1StubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    Adapter1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    Adapter1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    Adapter1StubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.Adapter1"),
          _logger(logger) {}

    virtual ~Adapter1StubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void Adapter1StubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 5, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'StartDiscovery'

            LOG_DEBUG_STUB("process method '%s'", "StartDiscovery");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartDiscoveryRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartDiscovery", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartDiscoveryRequest > payload = ::boost::static_pointer_cast<StartDiscoveryRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Adapter1Stub*>(getStub())->onStartDiscoveryRequest(payload);
            return;
        }
        case 1: {

            // method 'StopDiscovery'

            LOG_DEBUG_STUB("process method '%s'", "StopDiscovery");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StopDiscoveryRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StopDiscovery", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StopDiscoveryRequest > payload = ::boost::static_pointer_cast<StopDiscoveryRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Adapter1Stub*>(getStub())->onStopDiscoveryRequest(payload);
            return;
        }
        case 2: {

            // method 'RemoveDevice'

            LOG_DEBUG_STUB("process method '%s'", "RemoveDevice");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoveDeviceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RemoveDevice", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RemoveDeviceRequest > payload = ::boost::static_pointer_cast<RemoveDeviceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Adapter1Stub*>(getStub())->onRemoveDeviceRequest(payload);
            return;
        }
        case 3: {

            // method 'CreateDevice'

            LOG_DEBUG_STUB("process method '%s'", "CreateDevice");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CreateDeviceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CreateDevice", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CreateDeviceRequest > payload = ::boost::static_pointer_cast<CreateDeviceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Adapter1Stub*>(getStub())->onCreateDeviceRequest(payload);
            return;
        }
        case 4: {

            // method 'SendHCICmd'

            LOG_DEBUG_STUB("process method '%s'", "SendHCICmd");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendHCICmdRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SendHCICmd", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SendHCICmdRequest > payload = ::boost::static_pointer_cast<SendHCICmdRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Adapter1Stub*>(getStub())->onSendHCICmdRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* Adapter1StubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.Adapter1\">\n"
            "      <method name=\"StartDiscovery\"/>\n"
            "      <method name=\"StopDiscovery\"/>\n"
            "      <method name=\"RemoveDevice\">\n"
            "        <arg direction=\"in\" name=\"device\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"CreateDevice\">\n"
            "        <arg direction=\"in\" name=\"address\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"device\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"SendHCICmd\">\n"
            "        <arg direction=\"in\" name=\"data\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <signal name=\"AdapterInitialization\"/>\n"
            "      <signal name=\"DeviceCreated\">\n"
            "        <arg name=\"device\" type=\"o\"/>\n"
            "      </signal>\n"
            "      <signal name=\"DeviceRemoved\">\n"
            "        <arg name=\"device\" type=\"o\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtStackLog\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "        <arg name=\"opcode\" type=\"q\"/>\n"
            "        <arg name=\"data\" type=\"ay\"/>\n"
            "      </signal>\n"
            "      <signal name=\"HCIEvent\">\n"
            "        <arg name=\"data\" type=\"ay\"/>\n"
            "      </signal>\n"
            "      <signal name=\"DeviceFound\">\n"
            "        <arg name=\"address\" type=\"s\"/>\n"
            "        <arg name=\"values\" type=\"a{sv}\"/>\n"
            "      </signal>\n"
            "      <property access=\"read\" name=\"Address\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Class\" type=\"u\"/>\n"
            "      <property access=\"readwrite\" name=\"Alias\" type=\"s\"/>\n"
            "      <property access=\"readwrite\" name=\"Powered\" type=\"b\"/>\n"
            "      <property access=\"readwrite\" name=\"Discoverable\" type=\"b\"/>\n"
            "      <property access=\"readwrite\" name=\"DiscoverableTimeout\" type=\"u\"/>\n"
            "      <property access=\"readwrite\" name=\"Pairable\" type=\"b\"/>\n"
            "      <property access=\"readwrite\" name=\"PairableTimeout\" type=\"u\"/>\n"
            "      <property access=\"read\" name=\"Discovering\" type=\"b\"/>\n"
            "      <property access=\"readwrite\" name=\"UUIDs\" type=\"as\"/>\n"
            "      <property access=\"readwrite\" name=\"WBSMode\" type=\"b\"/>\n"
            "      <property access=\"readwrite\" name=\"Connectable\" type=\"b\"/>\n"
            "      <property access=\"readwrite\" name=\"HCIMode\" type=\"b\"/>\n"
            "      <property access=\"read\" name=\"Version\" type=\"a{sv}\"/>\n"
            "      <property access=\"readwrite\" name=\"TraceLevel\" type=\"as\"/>\n"
            "      <property access=\"readwrite\" name=\"TraceCategory\" type=\"as\"/>\n"
            "      <property access=\"readwrite\" name=\"AvailableSPPServers\" type=\"as\"/>\n"
            "</interface>\n";
}

void Adapter1StubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<Adapter1Stub*>(getStub()))->onGetAll (properties);
}

void Adapter1StubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 17, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Address");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Class");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Alias");
            ::boost::shared_ptr< AliasSet > payload(new AliasSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Adapter1Stub*>(getStub())->onAliasSet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Powered");
            ::boost::shared_ptr< PoweredSet > payload(new PoweredSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Adapter1Stub*>(getStub())->onPoweredSet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "Discoverable");
            ::boost::shared_ptr< DiscoverableSet > payload(new DiscoverableSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Adapter1Stub*>(getStub())->onDiscoverableSet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "DiscoverableTimeout");
            ::boost::shared_ptr< DiscoverableTimeoutSet > payload(new DiscoverableTimeoutSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Adapter1Stub*>(getStub())->onDiscoverableTimeoutSet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "Pairable");
            ::boost::shared_ptr< PairableSet > payload(new PairableSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Adapter1Stub*>(getStub())->onPairableSet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "PairableTimeout");
            ::boost::shared_ptr< PairableTimeoutSet > payload(new PairableTimeoutSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Adapter1Stub*>(getStub())->onPairableTimeoutSet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "Discovering");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "UUIDs");
            ::boost::shared_ptr< UUIDsSet > payload(new UUIDsSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Adapter1Stub*>(getStub())->onUUIDsSet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "WBSMode");
            ::boost::shared_ptr< WBSModeSet > payload(new WBSModeSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Adapter1Stub*>(getStub())->onWBSModeSet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "Connectable");
            ::boost::shared_ptr< ConnectableSet > payload(new ConnectableSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Adapter1Stub*>(getStub())->onConnectableSet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "HCIMode");
            ::boost::shared_ptr< HCIModeSet > payload(new HCIModeSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Adapter1Stub*>(getStub())->onHCIModeSet (payload);
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "Version");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "TraceLevel");
            ::boost::shared_ptr< TraceLevelSet > payload(new TraceLevelSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Adapter1Stub*>(getStub())->onTraceLevelSet (payload);
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "TraceCategory");
            ::boost::shared_ptr< TraceCategorySet > payload(new TraceCategorySet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Adapter1Stub*>(getStub())->onTraceCategorySet (payload);
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "AvailableSPPServers");
            ::boost::shared_ptr< AvailableSPPServersSet > payload(new AvailableSPPServersSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Adapter1Stub*>(getStub())->onAvailableSPPServersSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void Adapter1StubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 17, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Address");
            ::boost::shared_ptr< AddressGet > payload(new AddressGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onAddressGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Class");
            ::boost::shared_ptr< ClassGet > payload(new ClassGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onClassGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Alias");
            ::boost::shared_ptr< AliasGet > payload(new AliasGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onAliasGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Powered");
            ::boost::shared_ptr< PoweredGet > payload(new PoweredGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onPoweredGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "Discoverable");
            ::boost::shared_ptr< DiscoverableGet > payload(new DiscoverableGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onDiscoverableGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "DiscoverableTimeout");
            ::boost::shared_ptr< DiscoverableTimeoutGet > payload(new DiscoverableTimeoutGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onDiscoverableTimeoutGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "Pairable");
            ::boost::shared_ptr< PairableGet > payload(new PairableGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onPairableGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "PairableTimeout");
            ::boost::shared_ptr< PairableTimeoutGet > payload(new PairableTimeoutGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onPairableTimeoutGet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "Discovering");
            ::boost::shared_ptr< DiscoveringGet > payload(new DiscoveringGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onDiscoveringGet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "UUIDs");
            ::boost::shared_ptr< UUIDsGet > payload(new UUIDsGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onUUIDsGet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "WBSMode");
            ::boost::shared_ptr< WBSModeGet > payload(new WBSModeGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onWBSModeGet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "Connectable");
            ::boost::shared_ptr< ConnectableGet > payload(new ConnectableGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onConnectableGet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "HCIMode");
            ::boost::shared_ptr< HCIModeGet > payload(new HCIModeGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onHCIModeGet (payload);
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "Version");
            ::boost::shared_ptr< VersionGet > payload(new VersionGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onVersionGet (payload);
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "TraceLevel");
            ::boost::shared_ptr< TraceLevelGet > payload(new TraceLevelGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onTraceLevelGet (payload);
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "TraceCategory");
            ::boost::shared_ptr< TraceCategoryGet > payload(new TraceCategoryGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onTraceCategoryGet (payload);
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "AvailableSPPServers");
            ::boost::shared_ptr< AvailableSPPServersGet > payload(new AvailableSPPServersGet());
            payload->setAct(act);
            static_cast<Adapter1Stub*>(getStub())->onAvailableSPPServersGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

Adapter1Stub::Adapter1Stub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Adapter1StubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Adapter1Stub::Adapter1Stub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Adapter1StubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Adapter1Stub::~Adapter1Stub() {
    delete _stubDelegate;
}

void Adapter1Stub::sendAdapterInitializationSignal() {
    if (_stubDelegate->isConnected()) {
        AdapterInitializationSignal* payload = new AdapterInitializationSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "AdapterInitialization", AdapterInitializationSignal, payload)
        LOG_INFO ("-> send%sSignal", "AdapterInitialization");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "AdapterInitialization");
    }
}

void Adapter1Stub::sendDeviceCreatedSignal(const ::std::string& device) {
    if (_stubDelegate->isConnected()) {
        DeviceCreatedSignal* payload = new DeviceCreatedSignal(device);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "DeviceCreated", DeviceCreatedSignal, payload)
        LOG_INFO ("-> send%sSignal", "DeviceCreated");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "DeviceCreated");
    }
}

void Adapter1Stub::sendDeviceRemovedSignal(const ::std::string& device) {
    if (_stubDelegate->isConnected()) {
        DeviceRemovedSignal* payload = new DeviceRemovedSignal(device);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "DeviceRemoved", DeviceRemovedSignal, payload)
        LOG_INFO ("-> send%sSignal", "DeviceRemoved");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "DeviceRemoved");
    }
}

void Adapter1Stub::sendBtStackLogSignal(uint8 status, uint16 opcode, const ::std::vector< uint8 >& data) {
    if (_stubDelegate->isConnected()) {
        BtStackLogSignal* payload = new BtStackLogSignal(status, opcode, data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtStackLog", BtStackLogSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtStackLog");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtStackLog");
    }
}

void Adapter1Stub::sendHCIEventSignal(const ::std::vector< uint8 >& data) {
    if (_stubDelegate->isConnected()) {
        HCIEventSignal* payload = new HCIEventSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "HCIEvent", HCIEventSignal, payload)
        LOG_INFO ("-> send%sSignal", "HCIEvent");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "HCIEvent");
    }
}

void Adapter1Stub::sendDeviceFoundSignal(const ::std::string& address, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& values) {
    if (_stubDelegate->isConnected()) {
        DeviceFoundSignal* payload = new DeviceFoundSignal(address, values);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "DeviceFound", DeviceFoundSignal, payload)
        LOG_INFO ("-> send%sSignal", "DeviceFound");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "DeviceFound");
    }
}

void Adapter1Stub::sendAddressUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AddressUpdate payload(_AddressProperty);

        LOG_INFO ("-> send%s", "AddressUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Address", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AddressUpdate");
    }
}

void Adapter1Stub::onAddressGet(const ::boost::shared_ptr< AddressGet >& address) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AddressGet", address->getAct());
    sendAddressGetUpdate(_AddressProperty.getAddress(), address->getAct());
}

void Adapter1Stub::sendAddressGetUpdate(const ::std::string& address, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AddressGet payload(address);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AddressGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::setAddress(const ::std::string& address) {
    if(address!=_AddressProperty.getAddress()) {
        _AddressProperty.setAddress(address);
        sendAddressUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& Adapter1Stub::getAddress() const {
    return _AddressProperty.getAddress();
}

::std::string& Adapter1Stub::getAddressMutable() {
    return _AddressProperty.getAddressMutable();
}

void Adapter1Stub::sendClassUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ClassUpdate payload(_ClassProperty);

        LOG_INFO ("-> send%s", "ClassUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Class", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ClassUpdate");
    }
}

void Adapter1Stub::onClassGet(const ::boost::shared_ptr< ClassGet >& class_) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ClassGet", class_->getAct());
    sendClassGetUpdate(_ClassProperty.getClass(), class_->getAct());
}

void Adapter1Stub::sendClassGetUpdate(uint32 class_, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ClassGet payload(class_);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ClassGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::setClass(uint32 class_) {
    if(class_!=_ClassProperty.getClass()) {
        _ClassProperty.setClass(class_);
        sendClassUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Adapter1Stub::getClass() const {
    return _ClassProperty.getClass();
}

void Adapter1Stub::sendAliasUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AliasUpdate payload(_AliasProperty);

        LOG_INFO ("-> send%s", "AliasUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Alias", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AliasUpdate");
    }
}

void Adapter1Stub::onAliasGet(const ::boost::shared_ptr< AliasGet >& alias) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AliasGet", alias->getAct());
    sendAliasGetUpdate(_AliasProperty.getAlias(), alias->getAct());
}

void Adapter1Stub::sendAliasGetUpdate(const ::std::string& alias, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AliasGet payload(alias);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AliasGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::onAliasSet(const ::boost::shared_ptr< AliasSet >& alias) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AliasSet", alias->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*alias, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAlias (alias->getAlias());
    sendAliasSetUpdate(alias->getAct());
}

void Adapter1Stub::sendAliasSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AliasSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Adapter1Stub::setAlias(const ::std::string& alias) {
    if(alias!=_AliasProperty.getAlias()) {
        _AliasProperty.setAlias(alias);
        sendAliasUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& Adapter1Stub::getAlias() const {
    return _AliasProperty.getAlias();
}

::std::string& Adapter1Stub::getAliasMutable() {
    return _AliasProperty.getAliasMutable();
}

void Adapter1Stub::sendPoweredUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PoweredUpdate payload(_PoweredProperty);

        LOG_INFO ("-> send%s", "PoweredUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Powered", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PoweredUpdate");
    }
}

void Adapter1Stub::onPoweredGet(const ::boost::shared_ptr< PoweredGet >& powered) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PoweredGet", powered->getAct());
    sendPoweredGetUpdate(_PoweredProperty.getPowered(), powered->getAct());
}

void Adapter1Stub::sendPoweredGetUpdate(bool powered, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PoweredGet payload(powered);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PoweredGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::onPoweredSet(const ::boost::shared_ptr< PoweredSet >& powered) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PoweredSet", powered->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*powered, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setPowered (powered->getPowered());
    sendPoweredSetUpdate(powered->getAct());
}

void Adapter1Stub::sendPoweredSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PoweredSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Adapter1Stub::setPowered(bool powered) {
    if(powered!=_PoweredProperty.getPowered()) {
        _PoweredProperty.setPowered(powered);
        sendPoweredUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Adapter1Stub::getPowered() const {
    return _PoweredProperty.getPowered();
}

void Adapter1Stub::sendDiscoverableUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DiscoverableUpdate payload(_DiscoverableProperty);

        LOG_INFO ("-> send%s", "DiscoverableUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Discoverable", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DiscoverableUpdate");
    }
}

void Adapter1Stub::onDiscoverableGet(const ::boost::shared_ptr< DiscoverableGet >& discoverable) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DiscoverableGet", discoverable->getAct());
    sendDiscoverableGetUpdate(_DiscoverableProperty.getDiscoverable(), discoverable->getAct());
}

void Adapter1Stub::sendDiscoverableGetUpdate(bool discoverable, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DiscoverableGet payload(discoverable);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DiscoverableGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::onDiscoverableSet(const ::boost::shared_ptr< DiscoverableSet >& discoverable) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DiscoverableSet", discoverable->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*discoverable, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setDiscoverable (discoverable->getDiscoverable());
    sendDiscoverableSetUpdate(discoverable->getAct());
}

void Adapter1Stub::sendDiscoverableSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DiscoverableSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Adapter1Stub::setDiscoverable(bool discoverable) {
    if(discoverable!=_DiscoverableProperty.getDiscoverable()) {
        _DiscoverableProperty.setDiscoverable(discoverable);
        sendDiscoverableUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Adapter1Stub::getDiscoverable() const {
    return _DiscoverableProperty.getDiscoverable();
}

void Adapter1Stub::sendDiscoverableTimeoutUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DiscoverableTimeoutUpdate payload(_DiscoverableTimeoutProperty);

        LOG_INFO ("-> send%s", "DiscoverableTimeoutUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DiscoverableTimeout", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DiscoverableTimeoutUpdate");
    }
}

void Adapter1Stub::onDiscoverableTimeoutGet(const ::boost::shared_ptr< DiscoverableTimeoutGet >& discoverableTimeout) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DiscoverableTimeoutGet", discoverableTimeout->getAct());
    sendDiscoverableTimeoutGetUpdate(_DiscoverableTimeoutProperty.getDiscoverableTimeout(), discoverableTimeout->getAct());
}

void Adapter1Stub::sendDiscoverableTimeoutGetUpdate(uint32 discoverableTimeout, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DiscoverableTimeoutGet payload(discoverableTimeout);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DiscoverableTimeoutGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::onDiscoverableTimeoutSet(const ::boost::shared_ptr< DiscoverableTimeoutSet >& discoverableTimeout) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DiscoverableTimeoutSet", discoverableTimeout->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*discoverableTimeout, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setDiscoverableTimeout (discoverableTimeout->getDiscoverableTimeout());
    sendDiscoverableTimeoutSetUpdate(discoverableTimeout->getAct());
}

void Adapter1Stub::sendDiscoverableTimeoutSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DiscoverableTimeoutSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Adapter1Stub::setDiscoverableTimeout(uint32 discoverableTimeout) {
    if(discoverableTimeout!=_DiscoverableTimeoutProperty.getDiscoverableTimeout()) {
        _DiscoverableTimeoutProperty.setDiscoverableTimeout(discoverableTimeout);
        sendDiscoverableTimeoutUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Adapter1Stub::getDiscoverableTimeout() const {
    return _DiscoverableTimeoutProperty.getDiscoverableTimeout();
}

void Adapter1Stub::sendPairableUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PairableUpdate payload(_PairableProperty);

        LOG_INFO ("-> send%s", "PairableUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Pairable", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PairableUpdate");
    }
}

void Adapter1Stub::onPairableGet(const ::boost::shared_ptr< PairableGet >& pairable) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PairableGet", pairable->getAct());
    sendPairableGetUpdate(_PairableProperty.getPairable(), pairable->getAct());
}

void Adapter1Stub::sendPairableGetUpdate(bool pairable, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PairableGet payload(pairable);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PairableGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::onPairableSet(const ::boost::shared_ptr< PairableSet >& pairable) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PairableSet", pairable->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*pairable, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setPairable (pairable->getPairable());
    sendPairableSetUpdate(pairable->getAct());
}

void Adapter1Stub::sendPairableSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PairableSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Adapter1Stub::setPairable(bool pairable) {
    if(pairable!=_PairableProperty.getPairable()) {
        _PairableProperty.setPairable(pairable);
        sendPairableUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Adapter1Stub::getPairable() const {
    return _PairableProperty.getPairable();
}

void Adapter1Stub::sendPairableTimeoutUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PairableTimeoutUpdate payload(_PairableTimeoutProperty);

        LOG_INFO ("-> send%s", "PairableTimeoutUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PairableTimeout", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PairableTimeoutUpdate");
    }
}

void Adapter1Stub::onPairableTimeoutGet(const ::boost::shared_ptr< PairableTimeoutGet >& pairableTimeout) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PairableTimeoutGet", pairableTimeout->getAct());
    sendPairableTimeoutGetUpdate(_PairableTimeoutProperty.getPairableTimeout(), pairableTimeout->getAct());
}

void Adapter1Stub::sendPairableTimeoutGetUpdate(uint32 pairableTimeout, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PairableTimeoutGet payload(pairableTimeout);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PairableTimeoutGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::onPairableTimeoutSet(const ::boost::shared_ptr< PairableTimeoutSet >& pairableTimeout) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PairableTimeoutSet", pairableTimeout->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*pairableTimeout, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setPairableTimeout (pairableTimeout->getPairableTimeout());
    sendPairableTimeoutSetUpdate(pairableTimeout->getAct());
}

void Adapter1Stub::sendPairableTimeoutSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PairableTimeoutSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Adapter1Stub::setPairableTimeout(uint32 pairableTimeout) {
    if(pairableTimeout!=_PairableTimeoutProperty.getPairableTimeout()) {
        _PairableTimeoutProperty.setPairableTimeout(pairableTimeout);
        sendPairableTimeoutUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Adapter1Stub::getPairableTimeout() const {
    return _PairableTimeoutProperty.getPairableTimeout();
}

void Adapter1Stub::sendDiscoveringUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DiscoveringUpdate payload(_DiscoveringProperty);

        LOG_INFO ("-> send%s", "DiscoveringUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Discovering", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DiscoveringUpdate");
    }
}

void Adapter1Stub::onDiscoveringGet(const ::boost::shared_ptr< DiscoveringGet >& discovering) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DiscoveringGet", discovering->getAct());
    sendDiscoveringGetUpdate(_DiscoveringProperty.getDiscovering(), discovering->getAct());
}

void Adapter1Stub::sendDiscoveringGetUpdate(bool discovering, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DiscoveringGet payload(discovering);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DiscoveringGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::setDiscovering(bool discovering) {
    if(discovering!=_DiscoveringProperty.getDiscovering()) {
        _DiscoveringProperty.setDiscovering(discovering);
        sendDiscoveringUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Adapter1Stub::getDiscovering() const {
    return _DiscoveringProperty.getDiscovering();
}

void Adapter1Stub::sendUUIDsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UUIDsUpdate payload(_UUIDsProperty);

        LOG_INFO ("-> send%s", "UUIDsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UUIDs", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UUIDsUpdate");
    }
}

void Adapter1Stub::onUUIDsGet(const ::boost::shared_ptr< UUIDsGet >& uUIDs) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UUIDsGet", uUIDs->getAct());
    sendUUIDsGetUpdate(_UUIDsProperty.getUUIDs(), uUIDs->getAct());
}

void Adapter1Stub::sendUUIDsGetUpdate(const ::std::vector< ::std::string >& uUIDs, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UUIDsGet payload(uUIDs);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UUIDsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::onUUIDsSet(const ::boost::shared_ptr< UUIDsSet >& uUIDs) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UUIDsSet", uUIDs->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*uUIDs, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setUUIDs (uUIDs->getUUIDs());
    sendUUIDsSetUpdate(uUIDs->getAct());
}

void Adapter1Stub::sendUUIDsSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UUIDsSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Adapter1Stub::setUUIDs(const ::std::vector< ::std::string >& uUIDs) {
    if(uUIDs!=_UUIDsProperty.getUUIDs()) {
        _UUIDsProperty.setUUIDs(uUIDs);
        sendUUIDsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& Adapter1Stub::getUUIDs() const {
    return _UUIDsProperty.getUUIDs();
}

::std::vector< ::std::string >& Adapter1Stub::getUUIDsMutable() {
    return _UUIDsProperty.getUUIDsMutable();
}

void Adapter1Stub::sendWBSModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WBSModeUpdate payload(_WBSModeProperty);

        LOG_INFO ("-> send%s", "WBSModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("WBSMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WBSModeUpdate");
    }
}

void Adapter1Stub::onWBSModeGet(const ::boost::shared_ptr< WBSModeGet >& wBSMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WBSModeGet", wBSMode->getAct());
    sendWBSModeGetUpdate(_WBSModeProperty.getWBSMode(), wBSMode->getAct());
}

void Adapter1Stub::sendWBSModeGetUpdate(bool wBSMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WBSModeGet payload(wBSMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WBSModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::onWBSModeSet(const ::boost::shared_ptr< WBSModeSet >& wBSMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WBSModeSet", wBSMode->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*wBSMode, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setWBSMode (wBSMode->getWBSMode());
    sendWBSModeSetUpdate(wBSMode->getAct());
}

void Adapter1Stub::sendWBSModeSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WBSModeSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Adapter1Stub::setWBSMode(bool wBSMode) {
    if(wBSMode!=_WBSModeProperty.getWBSMode()) {
        _WBSModeProperty.setWBSMode(wBSMode);
        sendWBSModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Adapter1Stub::getWBSMode() const {
    return _WBSModeProperty.getWBSMode();
}

void Adapter1Stub::sendConnectableUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConnectableUpdate payload(_ConnectableProperty);

        LOG_INFO ("-> send%s", "ConnectableUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Connectable", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConnectableUpdate");
    }
}

void Adapter1Stub::onConnectableGet(const ::boost::shared_ptr< ConnectableGet >& connectable) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConnectableGet", connectable->getAct());
    sendConnectableGetUpdate(_ConnectableProperty.getConnectable(), connectable->getAct());
}

void Adapter1Stub::sendConnectableGetUpdate(bool connectable, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConnectableGet payload(connectable);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConnectableGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::onConnectableSet(const ::boost::shared_ptr< ConnectableSet >& connectable) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConnectableSet", connectable->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*connectable, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setConnectable (connectable->getConnectable());
    sendConnectableSetUpdate(connectable->getAct());
}

void Adapter1Stub::sendConnectableSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConnectableSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Adapter1Stub::setConnectable(bool connectable) {
    if(connectable!=_ConnectableProperty.getConnectable()) {
        _ConnectableProperty.setConnectable(connectable);
        sendConnectableUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Adapter1Stub::getConnectable() const {
    return _ConnectableProperty.getConnectable();
}

void Adapter1Stub::sendHCIModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        HCIModeUpdate payload(_HCIModeProperty);

        LOG_INFO ("-> send%s", "HCIModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("HCIMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "HCIModeUpdate");
    }
}

void Adapter1Stub::onHCIModeGet(const ::boost::shared_ptr< HCIModeGet >& hCIMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "HCIModeGet", hCIMode->getAct());
    sendHCIModeGetUpdate(_HCIModeProperty.getHCIMode(), hCIMode->getAct());
}

void Adapter1Stub::sendHCIModeGetUpdate(bool hCIMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    HCIModeGet payload(hCIMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "HCIModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::onHCIModeSet(const ::boost::shared_ptr< HCIModeSet >& hCIMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "HCIModeSet", hCIMode->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*hCIMode, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setHCIMode (hCIMode->getHCIMode());
    sendHCIModeSetUpdate(hCIMode->getAct());
}

void Adapter1Stub::sendHCIModeSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "HCIModeSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Adapter1Stub::setHCIMode(bool hCIMode) {
    if(hCIMode!=_HCIModeProperty.getHCIMode()) {
        _HCIModeProperty.setHCIMode(hCIMode);
        sendHCIModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Adapter1Stub::getHCIMode() const {
    return _HCIModeProperty.getHCIMode();
}

void Adapter1Stub::sendVersionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VersionUpdate payload(_VersionProperty);

        LOG_INFO ("-> send%s", "VersionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Version", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VersionUpdate");
    }
}

void Adapter1Stub::onVersionGet(const ::boost::shared_ptr< VersionGet >& version) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VersionGet", version->getAct());
    sendVersionGetUpdate(_VersionProperty.getVersion(), version->getAct());
}

void Adapter1Stub::sendVersionGetUpdate(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& version, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VersionGet payload(version);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VersionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::setVersion(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& version) {
    if(version!=_VersionProperty.getVersion()) {
        _VersionProperty.setVersion(version);
        sendVersionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& Adapter1Stub::getVersion() const {
    return _VersionProperty.getVersion();
}

::std::map< ::std::string, ::asf::dbus::DBusVariant >& Adapter1Stub::getVersionMutable() {
    return _VersionProperty.getVersionMutable();
}

void Adapter1Stub::sendTraceLevelUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TraceLevelUpdate payload(_TraceLevelProperty);

        LOG_INFO ("-> send%s", "TraceLevelUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("TraceLevel", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TraceLevelUpdate");
    }
}

void Adapter1Stub::onTraceLevelGet(const ::boost::shared_ptr< TraceLevelGet >& traceLevel) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TraceLevelGet", traceLevel->getAct());
    sendTraceLevelGetUpdate(_TraceLevelProperty.getTraceLevel(), traceLevel->getAct());
}

void Adapter1Stub::sendTraceLevelGetUpdate(const ::std::vector< ::std::string >& traceLevel, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TraceLevelGet payload(traceLevel);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TraceLevelGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::onTraceLevelSet(const ::boost::shared_ptr< TraceLevelSet >& traceLevel) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TraceLevelSet", traceLevel->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*traceLevel, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setTraceLevel (traceLevel->getTraceLevel());
    sendTraceLevelSetUpdate(traceLevel->getAct());
}

void Adapter1Stub::sendTraceLevelSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TraceLevelSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Adapter1Stub::setTraceLevel(const ::std::vector< ::std::string >& traceLevel) {
    if(traceLevel!=_TraceLevelProperty.getTraceLevel()) {
        _TraceLevelProperty.setTraceLevel(traceLevel);
        sendTraceLevelUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& Adapter1Stub::getTraceLevel() const {
    return _TraceLevelProperty.getTraceLevel();
}

::std::vector< ::std::string >& Adapter1Stub::getTraceLevelMutable() {
    return _TraceLevelProperty.getTraceLevelMutable();
}

void Adapter1Stub::sendTraceCategoryUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TraceCategoryUpdate payload(_TraceCategoryProperty);

        LOG_INFO ("-> send%s", "TraceCategoryUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("TraceCategory", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TraceCategoryUpdate");
    }
}

void Adapter1Stub::onTraceCategoryGet(const ::boost::shared_ptr< TraceCategoryGet >& traceCategory) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TraceCategoryGet", traceCategory->getAct());
    sendTraceCategoryGetUpdate(_TraceCategoryProperty.getTraceCategory(), traceCategory->getAct());
}

void Adapter1Stub::sendTraceCategoryGetUpdate(const ::std::vector< ::std::string >& traceCategory, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TraceCategoryGet payload(traceCategory);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TraceCategoryGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::onTraceCategorySet(const ::boost::shared_ptr< TraceCategorySet >& traceCategory) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TraceCategorySet", traceCategory->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*traceCategory, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setTraceCategory (traceCategory->getTraceCategory());
    sendTraceCategorySetUpdate(traceCategory->getAct());
}

void Adapter1Stub::sendTraceCategorySetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TraceCategorySetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Adapter1Stub::setTraceCategory(const ::std::vector< ::std::string >& traceCategory) {
    if(traceCategory!=_TraceCategoryProperty.getTraceCategory()) {
        _TraceCategoryProperty.setTraceCategory(traceCategory);
        sendTraceCategoryUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& Adapter1Stub::getTraceCategory() const {
    return _TraceCategoryProperty.getTraceCategory();
}

::std::vector< ::std::string >& Adapter1Stub::getTraceCategoryMutable() {
    return _TraceCategoryProperty.getTraceCategoryMutable();
}

void Adapter1Stub::sendAvailableSPPServersUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AvailableSPPServersUpdate payload(_AvailableSPPServersProperty);

        LOG_INFO ("-> send%s", "AvailableSPPServersUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AvailableSPPServers", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AvailableSPPServersUpdate");
    }
}

void Adapter1Stub::onAvailableSPPServersGet(const ::boost::shared_ptr< AvailableSPPServersGet >& availableSPPServers) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AvailableSPPServersGet", availableSPPServers->getAct());
    sendAvailableSPPServersGetUpdate(_AvailableSPPServersProperty.getAvailableSPPServers(), availableSPPServers->getAct());
}

void Adapter1Stub::sendAvailableSPPServersGetUpdate(const ::std::vector< ::std::string >& availableSPPServers, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AvailableSPPServersGet payload(availableSPPServers);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AvailableSPPServersGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Adapter1Stub::onAvailableSPPServersSet(const ::boost::shared_ptr< AvailableSPPServersSet >& availableSPPServers) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AvailableSPPServersSet", availableSPPServers->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*availableSPPServers, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAvailableSPPServers (availableSPPServers->getAvailableSPPServers());
    sendAvailableSPPServersSetUpdate(availableSPPServers->getAct());
}

void Adapter1Stub::sendAvailableSPPServersSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AvailableSPPServersSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Adapter1Stub::setAvailableSPPServers(const ::std::vector< ::std::string >& availableSPPServers) {
    if(availableSPPServers!=_AvailableSPPServersProperty.getAvailableSPPServers()) {
        _AvailableSPPServersProperty.setAvailableSPPServers(availableSPPServers);
        sendAvailableSPPServersUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& Adapter1Stub::getAvailableSPPServers() const {
    return _AvailableSPPServersProperty.getAvailableSPPServers();
}

::std::vector< ::std::string >& Adapter1Stub::getAvailableSPPServersMutable() {
    return _AvailableSPPServersProperty.getAvailableSPPServersMutable();
}

void  Adapter1Stub::sendStartDiscoveryResponse (act_t act) {
    StartDiscoveryResponse* payload = new StartDiscoveryResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "StartDiscovery", StartDiscoveryResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartDiscovery", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Adapter1Stub::sendStartDiscoveryError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartDiscoveryError* payload = new StartDiscoveryError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StartDiscovery", StartDiscoveryError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartDiscovery", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Adapter1Stub::sendStopDiscoveryResponse (act_t act) {
    StopDiscoveryResponse* payload = new StopDiscoveryResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "StopDiscovery", StopDiscoveryResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StopDiscovery", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Adapter1Stub::sendStopDiscoveryError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StopDiscoveryError* payload = new StopDiscoveryError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StopDiscovery", StopDiscoveryError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StopDiscovery", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Adapter1Stub::sendRemoveDeviceResponse (act_t act) {
    RemoveDeviceResponse* payload = new RemoveDeviceResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RemoveDevice", RemoveDeviceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RemoveDevice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Adapter1Stub::sendRemoveDeviceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RemoveDeviceError* payload = new RemoveDeviceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RemoveDevice", RemoveDeviceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RemoveDevice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Adapter1Stub::sendCreateDeviceResponse (const ::std::string& device, act_t act) {
    CreateDeviceResponse* payload = new CreateDeviceResponse(device);
    DBUS_MESSAGE_REPLY(dbusMessage, "CreateDevice", CreateDeviceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CreateDevice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Adapter1Stub::sendCreateDeviceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CreateDeviceError* payload = new CreateDeviceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CreateDevice", CreateDeviceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CreateDevice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Adapter1Stub::sendSendHCICmdResponse (act_t act) {
    SendHCICmdResponse* payload = new SendHCICmdResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SendHCICmd", SendHCICmdResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SendHCICmd", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Adapter1Stub::sendSendHCICmdError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SendHCICmdError* payload = new SendHCICmdError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SendHCICmd", SendHCICmdError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SendHCICmd", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void Adapter1Stub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Address'
    {
        ::asf::dbus::DBusVariant variant;
        AddressGet payload(_AddressProperty.getAddress());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Address", variant));
    }

    //property 'Class'
    {
        ::asf::dbus::DBusVariant variant;
        ClassGet payload(_ClassProperty.getClass());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Class", variant));
    }

    //property 'Alias'
    {
        ::asf::dbus::DBusVariant variant;
        AliasGet payload(_AliasProperty.getAlias());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Alias", variant));
    }

    //property 'Powered'
    {
        ::asf::dbus::DBusVariant variant;
        PoweredGet payload(_PoweredProperty.getPowered());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Powered", variant));
    }

    //property 'Discoverable'
    {
        ::asf::dbus::DBusVariant variant;
        DiscoverableGet payload(_DiscoverableProperty.getDiscoverable());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Discoverable", variant));
    }

    //property 'DiscoverableTimeout'
    {
        ::asf::dbus::DBusVariant variant;
        DiscoverableTimeoutGet payload(_DiscoverableTimeoutProperty.getDiscoverableTimeout());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DiscoverableTimeout", variant));
    }

    //property 'Pairable'
    {
        ::asf::dbus::DBusVariant variant;
        PairableGet payload(_PairableProperty.getPairable());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Pairable", variant));
    }

    //property 'PairableTimeout'
    {
        ::asf::dbus::DBusVariant variant;
        PairableTimeoutGet payload(_PairableTimeoutProperty.getPairableTimeout());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PairableTimeout", variant));
    }

    //property 'Discovering'
    {
        ::asf::dbus::DBusVariant variant;
        DiscoveringGet payload(_DiscoveringProperty.getDiscovering());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Discovering", variant));
    }

    //property 'UUIDs'
    {
        ::asf::dbus::DBusVariant variant;
        UUIDsGet payload(_UUIDsProperty.getUUIDs());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UUIDs", variant));
    }

    //property 'WBSMode'
    {
        ::asf::dbus::DBusVariant variant;
        WBSModeGet payload(_WBSModeProperty.getWBSMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("WBSMode", variant));
    }

    //property 'Connectable'
    {
        ::asf::dbus::DBusVariant variant;
        ConnectableGet payload(_ConnectableProperty.getConnectable());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Connectable", variant));
    }

    //property 'HCIMode'
    {
        ::asf::dbus::DBusVariant variant;
        HCIModeGet payload(_HCIModeProperty.getHCIMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("HCIMode", variant));
    }

    //property 'Version'
    {
        ::asf::dbus::DBusVariant variant;
        VersionGet payload(_VersionProperty.getVersion());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Version", variant));
    }

    //property 'TraceLevel'
    {
        ::asf::dbus::DBusVariant variant;
        TraceLevelGet payload(_TraceLevelProperty.getTraceLevel());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("TraceLevel", variant));
    }

    //property 'TraceCategory'
    {
        ::asf::dbus::DBusVariant variant;
        TraceCategoryGet payload(_TraceCategoryProperty.getTraceCategory());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("TraceCategory", variant));
    }

    //property 'AvailableSPPServers'
    {
        ::asf::dbus::DBusVariant variant;
        AvailableSPPServersGet payload(_AvailableSPPServersProperty.getAvailableSPPServers());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AvailableSPPServers", variant));
    }
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
