/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_ADAPTER1PROXY_H
#define ORG_BLUEZ_ADAPTER1PROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/Adapter1.h"
#include <dbus/dbus.h>
#include <map>
#include <string>
#include <vector>

namespace org {
namespace bluez {
namespace Adapter1 {

class Adapter1Proxy;

class AdapterInitializationCallbackIF {
public:
    virtual ~AdapterInitializationCallbackIF() {}

    virtual void onAdapterInitializationError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdapterInitializationError >& error) = 0;

    virtual void onAdapterInitializationSignal(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdapterInitializationSignal >& signal) = 0;
};

class AddressCallbackIF {
public:
    virtual ~AddressCallbackIF() {}

    virtual void onAddressError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressError >& error) = 0;

    virtual void onAddressUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressUpdate >& update) = 0;
};

class AliasCallbackIF {
public:
    virtual ~AliasCallbackIF() {}

    virtual void onAliasError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AliasError >& error) = 0;

    virtual void onAliasUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AliasUpdate >& update) = 0;
};

class AvailableSPPServersCallbackIF {
public:
    virtual ~AvailableSPPServersCallbackIF() {}

    virtual void onAvailableSPPServersError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AvailableSPPServersError >& error) = 0;

    virtual void onAvailableSPPServersUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AvailableSPPServersUpdate >& update) = 0;
};

class BtStackLogCallbackIF {
public:
    virtual ~BtStackLogCallbackIF() {}

    virtual void onBtStackLogError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< BtStackLogError >& error) = 0;

    virtual void onBtStackLogSignal(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< BtStackLogSignal >& signal) = 0;
};

class ClassCallbackIF {
public:
    virtual ~ClassCallbackIF() {}

    virtual void onClassError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< ClassError >& error) = 0;

    virtual void onClassUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< ClassUpdate >& update) = 0;
};

class ConnectableCallbackIF {
public:
    virtual ~ConnectableCallbackIF() {}

    virtual void onConnectableError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< ConnectableError >& error) = 0;

    virtual void onConnectableUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< ConnectableUpdate >& update) = 0;
};

class CreateDeviceCallbackIF {
public:
    virtual ~CreateDeviceCallbackIF() {}

    virtual void onCreateDeviceError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< CreateDeviceError >& error) = 0;

    virtual void onCreateDeviceResponse(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< CreateDeviceResponse >& response) = 0;
};

class DeviceCreatedCallbackIF {
public:
    virtual ~DeviceCreatedCallbackIF() {}

    virtual void onDeviceCreatedError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DeviceCreatedError >& error) = 0;

    virtual void onDeviceCreatedSignal(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DeviceCreatedSignal >& signal) = 0;
};

class DeviceFoundCallbackIF {
public:
    virtual ~DeviceFoundCallbackIF() {}

    virtual void onDeviceFoundError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DeviceFoundError >& error) = 0;

    virtual void onDeviceFoundSignal(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DeviceFoundSignal >& signal) = 0;
};

class DeviceRemovedCallbackIF {
public:
    virtual ~DeviceRemovedCallbackIF() {}

    virtual void onDeviceRemovedError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DeviceRemovedError >& error) = 0;

    virtual void onDeviceRemovedSignal(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DeviceRemovedSignal >& signal) = 0;
};

class DiscoverableCallbackIF {
public:
    virtual ~DiscoverableCallbackIF() {}

    virtual void onDiscoverableError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoverableError >& error) = 0;

    virtual void onDiscoverableUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoverableUpdate >& update) = 0;
};

class DiscoverableTimeoutCallbackIF {
public:
    virtual ~DiscoverableTimeoutCallbackIF() {}

    virtual void onDiscoverableTimeoutError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoverableTimeoutError >& error) = 0;

    virtual void onDiscoverableTimeoutUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoverableTimeoutUpdate >& update) = 0;
};

class DiscoveringCallbackIF {
public:
    virtual ~DiscoveringCallbackIF() {}

    virtual void onDiscoveringError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoveringError >& error) = 0;

    virtual void onDiscoveringUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoveringUpdate >& update) = 0;
};

class HCIEventCallbackIF {
public:
    virtual ~HCIEventCallbackIF() {}

    virtual void onHCIEventError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< HCIEventError >& error) = 0;

    virtual void onHCIEventSignal(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< HCIEventSignal >& signal) = 0;
};

class HCIModeCallbackIF {
public:
    virtual ~HCIModeCallbackIF() {}

    virtual void onHCIModeError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< HCIModeError >& error) = 0;

    virtual void onHCIModeUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< HCIModeUpdate >& update) = 0;
};

class PairableCallbackIF {
public:
    virtual ~PairableCallbackIF() {}

    virtual void onPairableError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< PairableError >& error) = 0;

    virtual void onPairableUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< PairableUpdate >& update) = 0;
};

class PairableTimeoutCallbackIF {
public:
    virtual ~PairableTimeoutCallbackIF() {}

    virtual void onPairableTimeoutError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< PairableTimeoutError >& error) = 0;

    virtual void onPairableTimeoutUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< PairableTimeoutUpdate >& update) = 0;
};

class PoweredCallbackIF {
public:
    virtual ~PoweredCallbackIF() {}

    virtual void onPoweredError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< PoweredError >& error) = 0;

    virtual void onPoweredUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< PoweredUpdate >& update) = 0;
};

class RemoveDeviceCallbackIF {
public:
    virtual ~RemoveDeviceCallbackIF() {}

    virtual void onRemoveDeviceError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< RemoveDeviceError >& error) = 0;

    virtual void onRemoveDeviceResponse(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< RemoveDeviceResponse >& response) = 0;
};

class SendHCICmdCallbackIF {
public:
    virtual ~SendHCICmdCallbackIF() {}

    virtual void onSendHCICmdError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< SendHCICmdError >& error) = 0;

    virtual void onSendHCICmdResponse(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< SendHCICmdResponse >& response) = 0;
};

class StartDiscoveryCallbackIF {
public:
    virtual ~StartDiscoveryCallbackIF() {}

    virtual void onStartDiscoveryError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< StartDiscoveryError >& error) = 0;

    virtual void onStartDiscoveryResponse(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< StartDiscoveryResponse >& response) = 0;
};

class StopDiscoveryCallbackIF {
public:
    virtual ~StopDiscoveryCallbackIF() {}

    virtual void onStopDiscoveryError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< StopDiscoveryError >& error) = 0;

    virtual void onStopDiscoveryResponse(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< StopDiscoveryResponse >& response) = 0;
};

class TraceCategoryCallbackIF {
public:
    virtual ~TraceCategoryCallbackIF() {}

    virtual void onTraceCategoryError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< TraceCategoryError >& error) = 0;

    virtual void onTraceCategoryUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< TraceCategoryUpdate >& update) = 0;
};

class TraceLevelCallbackIF {
public:
    virtual ~TraceLevelCallbackIF() {}

    virtual void onTraceLevelError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< TraceLevelError >& error) = 0;

    virtual void onTraceLevelUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< TraceLevelUpdate >& update) = 0;
};

class UUIDsCallbackIF {
public:
    virtual ~UUIDsCallbackIF() {}

    virtual void onUUIDsError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< UUIDsError >& error) = 0;

    virtual void onUUIDsUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< UUIDsUpdate >& update) = 0;
};

class VersionCallbackIF {
public:
    virtual ~VersionCallbackIF() {}

    virtual void onVersionError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< VersionError >& error) = 0;

    virtual void onVersionUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< VersionUpdate >& update) = 0;
};

class WBSModeCallbackIF {
public:
    virtual ~WBSModeCallbackIF() {}

    virtual void onWBSModeError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< WBSModeError >& error) = 0;

    virtual void onWBSModeUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< WBSModeUpdate >& update) = 0;
};


/**
 * Adapter1Proxy is the client side representation of the D-Bus service
 * interface 'org.bluez.Adapter1' (specified in file
 * stack_component_adapter.xml).
 *
 * If the meaning of "org.bluez.Adapter1" isn't clear, then there should be a description here.
 */
class Adapter1Proxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of Adapter1Proxy.
     */
    static ::boost::shared_ptr< Adapter1Proxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of Adapter1Proxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< Adapter1Proxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of Adapter1Proxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< Adapter1Proxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Adapter1Proxy > proxyNew(new Adapter1Proxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~Adapter1Proxy ();


    // Signal 'AdapterInitialization'

    /**
     * Notify on the signal 'AdapterInitialization'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'AdapterInitialization'</b>:
     *
     * If the meaning of "AdapterInitialization" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAdapterInitializationRegister(AdapterInitializationCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'AdapterInitialization'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'AdapterInitialization'</b>:
     *
     * If the meaning of "AdapterInitialization" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAdapterInitializationRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAdapterInitializationDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'AdapterInitialization'.
     */
    void sendAdapterInitializationDeregisterAll () const;

    // Signal 'DeviceCreated'

    /**
     * Notify on the signal 'DeviceCreated'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'DeviceCreated'</b>:
     *
     * If the meaning of "DeviceCreated" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceCreatedRegister(DeviceCreatedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'DeviceCreated'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'DeviceCreated'</b>:
     *
     * If the meaning of "DeviceCreated" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDeviceCreatedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDeviceCreatedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'DeviceCreated'.
     */
    void sendDeviceCreatedDeregisterAll () const;

    // Signal 'DeviceRemoved'

    /**
     * Notify on the signal 'DeviceRemoved'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'DeviceRemoved'</b>:
     *
     * If the meaning of "DeviceRemoved" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceRemovedRegister(DeviceRemovedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'DeviceRemoved'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'DeviceRemoved'</b>:
     *
     * If the meaning of "DeviceRemoved" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDeviceRemovedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDeviceRemovedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'DeviceRemoved'.
     */
    void sendDeviceRemovedDeregisterAll () const;

    // Signal 'BtStackLog'

    /**
     * Notify on the signal 'BtStackLog'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'BtStackLog'</b>:
     *
     * If the meaning of "BtStackLog" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtStackLogRegister(BtStackLogCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtStackLog'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtStackLog'</b>:
     *
     * If the meaning of "BtStackLog" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtStackLogRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtStackLogDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtStackLog'.
     */
    void sendBtStackLogDeregisterAll () const;

    // Signal 'HCIEvent'

    /**
     * Notify on the signal 'HCIEvent'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'HCIEvent'</b>:
     *
     * If the meaning of "HCIEvent" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHCIEventRegister(HCIEventCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'HCIEvent'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'HCIEvent'</b>:
     *
     * If the meaning of "HCIEvent" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendHCIEventRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendHCIEventDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'HCIEvent'.
     */
    void sendHCIEventDeregisterAll () const;

    // Signal 'DeviceFound'

    /**
     * Notify on the signal 'DeviceFound'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'DeviceFound'</b>:
     *
     * If the meaning of "DeviceFound" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceFoundRegister(DeviceFoundCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'DeviceFound'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'DeviceFound'</b>:
     *
     * If the meaning of "DeviceFound" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDeviceFoundRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDeviceFoundDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'DeviceFound'.
     */
    void sendDeviceFoundDeregisterAll () const;


    // Property 'Address'

    /**
     * Notify on the property 'Address'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddressRegister(AddressCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Address'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAddressRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAddressDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Address'.
     */
    void sendAddressDeregisterAll() const;

    /**
     * Request the value of the property 'Address' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddressGet(AddressCallbackIF& cb);


    /**
     * Returns the current value of the property 'Address' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasAddress()
     * returns true.
     *
     * @return the previously received value of the property 'Address'.
     */
    const ::std::string& getAddress() const;

    /**
     * Determines whether a status message for the property 'Address' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAddress() const;

    // Property 'Class'

    /**
     * Notify on the property 'Class'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClassRegister(ClassCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Class'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendClassRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendClassDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Class'.
     */
    void sendClassDeregisterAll() const;

    /**
     * Request the value of the property 'Class' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClassGet(ClassCallbackIF& cb);


    /**
     * Returns the current value of the property 'Class' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasClass()
     * returns true.
     *
     * @return the previously received value of the property 'Class'.
     */
    uint32 getClass() const;

    /**
     * Determines whether a status message for the property 'Class' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasClass() const;

    // Property 'Alias'

    /**
     * Notify on the property 'Alias'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAliasRegister(AliasCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Alias'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAliasRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAliasDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Alias'.
     */
    void sendAliasDeregisterAll() const;

    /**
     * Request the value of the property 'Alias' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAliasGet(AliasCallbackIF& cb);

    /**
     * Set the value of the property 'Alias'. This method sends a Set message
     * to the D-Bus server.
     *
     * @deprecated use the sendAliasSet(AliasCallbackIF& cb, const
     * ::std::string& alias) method instead.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    void sendAliasSet(const ::std::string& alias);

    /**
     * Set the value of the property 'Alias'. This method sends a Set message
     * to the D-Bus server.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAliasSet(AliasCallbackIF& cb, const ::std::string& alias);

    /**
     * Returns the current value of the property 'Alias' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasAlias()
     * returns true.
     *
     * @return the previously received value of the property 'Alias'.
     */
    const ::std::string& getAlias() const;

    /**
     * Determines whether a status message for the property 'Alias' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAlias() const;

    // Property 'Powered'

    /**
     * Notify on the property 'Powered'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPoweredRegister(PoweredCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Powered'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPoweredRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPoweredDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Powered'.
     */
    void sendPoweredDeregisterAll() const;

    /**
     * Request the value of the property 'Powered' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPoweredGet(PoweredCallbackIF& cb);

    /**
     * Set the value of the property 'Powered'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendPoweredSet(PoweredCallbackIF& cb, bool powered)
     * method instead.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    void sendPoweredSet(bool powered);

    /**
     * Set the value of the property 'Powered'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPoweredSet(PoweredCallbackIF& cb, bool powered);

    /**
     * Returns the current value of the property 'Powered' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasPowered()
     * returns true.
     *
     * @return the previously received value of the property 'Powered'.
     */
    bool getPowered() const;

    /**
     * Determines whether a status message for the property 'Powered' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPowered() const;

    // Property 'Discoverable'

    /**
     * Notify on the property 'Discoverable'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'Discoverable'</b>:
     *
     * If the meaning of "Discoverable" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiscoverableRegister(DiscoverableCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Discoverable'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'Discoverable'</b>:
     *
     * If the meaning of "Discoverable" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDiscoverableRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDiscoverableDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Discoverable'.
     */
    void sendDiscoverableDeregisterAll() const;

    /**
     * Request the value of the property 'Discoverable' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Discoverable'</b>:
     *
     * If the meaning of "Discoverable" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiscoverableGet(DiscoverableCallbackIF& cb);

    /**
     * Set the value of the property 'Discoverable'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendDiscoverableSet(DiscoverableCallbackIF& cb,
     * bool discoverable) method instead.
     *
     * <b>Documentation of 'Discoverable'</b>:
     *
     * If the meaning of "Discoverable" isn't clear, then there should be a description here.
     */
    void sendDiscoverableSet(bool discoverable);

    /**
     * Set the value of the property 'Discoverable'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'Discoverable'</b>:
     *
     * If the meaning of "Discoverable" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiscoverableSet(DiscoverableCallbackIF& cb, bool discoverable);

    /**
     * Returns the current value of the property 'Discoverable' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDiscoverable() returns true.
     *
     * @return the previously received value of the property 'Discoverable'.
     */
    bool getDiscoverable() const;

    /**
     * Determines whether a status message for the property 'Discoverable' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiscoverable() const;

    // Property 'DiscoverableTimeout'

    /**
     * Notify on the property 'DiscoverableTimeout'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'DiscoverableTimeout'</b>:
     *
     * If the meaning of "DiscoverableTimeout" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiscoverableTimeoutRegister(DiscoverableTimeoutCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'DiscoverableTimeout'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'DiscoverableTimeout'</b>:
     *
     * If the meaning of "DiscoverableTimeout" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDiscoverableTimeoutRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDiscoverableTimeoutDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'DiscoverableTimeout'.
     */
    void sendDiscoverableTimeoutDeregisterAll() const;

    /**
     * Request the value of the property 'DiscoverableTimeout' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'DiscoverableTimeout'</b>:
     *
     * If the meaning of "DiscoverableTimeout" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiscoverableTimeoutGet(DiscoverableTimeoutCallbackIF& cb);

    /**
     * Set the value of the property 'DiscoverableTimeout'. This method sends
     * a Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendDiscoverableTimeoutSet(DiscoverableTimeoutCallbackIF& cb, uint32
     * discoverableTimeout) method instead.
     *
     * <b>Documentation of 'DiscoverableTimeout'</b>:
     *
     * If the meaning of "DiscoverableTimeout" isn't clear, then there should be a description here.
     */
    void sendDiscoverableTimeoutSet(uint32 discoverableTimeout);

    /**
     * Set the value of the property 'DiscoverableTimeout'. This method sends
     * a Set message to the D-Bus server.
     *
     * <b>Documentation of 'DiscoverableTimeout'</b>:
     *
     * If the meaning of "DiscoverableTimeout" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiscoverableTimeoutSet(DiscoverableTimeoutCallbackIF& cb, uint32 discoverableTimeout);

    /**
     * Returns the current value of the property 'DiscoverableTimeout' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDiscoverableTimeout() returns true.
     *
     * @return the previously received value of the property 'DiscoverableTimeout'.
     */
    uint32 getDiscoverableTimeout() const;

    /**
     * Determines whether a status message for the property
     * 'DiscoverableTimeout' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiscoverableTimeout() const;

    // Property 'Pairable'

    /**
     * Notify on the property 'Pairable'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Pairable'</b>:
     *
     * If the meaning of "Pairable" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairableRegister(PairableCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Pairable'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Pairable'</b>:
     *
     * If the meaning of "Pairable" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPairableRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPairableDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Pairable'.
     */
    void sendPairableDeregisterAll() const;

    /**
     * Request the value of the property 'Pairable' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Pairable'</b>:
     *
     * If the meaning of "Pairable" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairableGet(PairableCallbackIF& cb);

    /**
     * Set the value of the property 'Pairable'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendPairableSet(PairableCallbackIF& cb, bool
     * pairable) method instead.
     *
     * <b>Documentation of 'Pairable'</b>:
     *
     * If the meaning of "Pairable" isn't clear, then there should be a description here.
     */
    void sendPairableSet(bool pairable);

    /**
     * Set the value of the property 'Pairable'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'Pairable'</b>:
     *
     * If the meaning of "Pairable" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairableSet(PairableCallbackIF& cb, bool pairable);

    /**
     * Returns the current value of the property 'Pairable' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasPairable()
     * returns true.
     *
     * @return the previously received value of the property 'Pairable'.
     */
    bool getPairable() const;

    /**
     * Determines whether a status message for the property 'Pairable' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPairable() const;

    // Property 'PairableTimeout'

    /**
     * Notify on the property 'PairableTimeout'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'PairableTimeout'</b>:
     *
     * If the meaning of "PairableTimeout" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairableTimeoutRegister(PairableTimeoutCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'PairableTimeout'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'PairableTimeout'</b>:
     *
     * If the meaning of "PairableTimeout" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPairableTimeoutRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPairableTimeoutDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'PairableTimeout'.
     */
    void sendPairableTimeoutDeregisterAll() const;

    /**
     * Request the value of the property 'PairableTimeout' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'PairableTimeout'</b>:
     *
     * If the meaning of "PairableTimeout" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairableTimeoutGet(PairableTimeoutCallbackIF& cb);

    /**
     * Set the value of the property 'PairableTimeout'. This method sends a
     * Set message to the D-Bus server.
     *
     * @deprecated use the sendPairableTimeoutSet(PairableTimeoutCallbackIF&
     * cb, uint32 pairableTimeout) method instead.
     *
     * <b>Documentation of 'PairableTimeout'</b>:
     *
     * If the meaning of "PairableTimeout" isn't clear, then there should be a description here.
     */
    void sendPairableTimeoutSet(uint32 pairableTimeout);

    /**
     * Set the value of the property 'PairableTimeout'. This method sends a
     * Set message to the D-Bus server.
     *
     * <b>Documentation of 'PairableTimeout'</b>:
     *
     * If the meaning of "PairableTimeout" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairableTimeoutSet(PairableTimeoutCallbackIF& cb, uint32 pairableTimeout);

    /**
     * Returns the current value of the property 'PairableTimeout' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasPairableTimeout() returns true.
     *
     * @return the previously received value of the property 'PairableTimeout'.
     */
    uint32 getPairableTimeout() const;

    /**
     * Determines whether a status message for the property 'PairableTimeout'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPairableTimeout() const;

    // Property 'Discovering'

    /**
     * Notify on the property 'Discovering'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'Discovering'</b>:
     *
     * If the meaning of "Discovering" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiscoveringRegister(DiscoveringCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Discovering'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'Discovering'</b>:
     *
     * If the meaning of "Discovering" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDiscoveringRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDiscoveringDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Discovering'.
     */
    void sendDiscoveringDeregisterAll() const;

    /**
     * Request the value of the property 'Discovering' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Discovering'</b>:
     *
     * If the meaning of "Discovering" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiscoveringGet(DiscoveringCallbackIF& cb);


    /**
     * Returns the current value of the property 'Discovering' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDiscovering() returns true.
     *
     * @return the previously received value of the property 'Discovering'.
     */
    bool getDiscovering() const;

    /**
     * Determines whether a status message for the property 'Discovering' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiscovering() const;

    // Property 'UUIDs'

    /**
     * Notify on the property 'UUIDs'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUUIDsRegister(UUIDsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'UUIDs'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendUUIDsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendUUIDsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'UUIDs'.
     */
    void sendUUIDsDeregisterAll() const;

    /**
     * Request the value of the property 'UUIDs' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUUIDsGet(UUIDsCallbackIF& cb);

    /**
     * Set the value of the property 'UUIDs'. This method sends a Set message
     * to the D-Bus server.
     *
     * @deprecated use the sendUUIDsSet(UUIDsCallbackIF& cb, const
     * ::std::vector< ::std::string >& uUIDs) method instead.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     */
    void sendUUIDsSet(const ::std::vector< ::std::string >& uUIDs);

    /**
     * Set the value of the property 'UUIDs'. This method sends a Set message
     * to the D-Bus server.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUUIDsSet(UUIDsCallbackIF& cb, const ::std::vector< ::std::string >& uUIDs);

    /**
     * Returns the current value of the property 'UUIDs' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasUUIDs()
     * returns true.
     *
     * @return the previously received value of the property 'UUIDs'.
     */
    const ::std::vector< ::std::string >& getUUIDs() const;

    /**
     * Determines whether a status message for the property 'UUIDs' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUUIDs() const;

    // Property 'WBSMode'

    /**
     * Notify on the property 'WBSMode'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'WBSMode'</b>:
     *
     * If the meaning of "WBSMode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWBSModeRegister(WBSModeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'WBSMode'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'WBSMode'</b>:
     *
     * If the meaning of "WBSMode" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendWBSModeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendWBSModeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'WBSMode'.
     */
    void sendWBSModeDeregisterAll() const;

    /**
     * Request the value of the property 'WBSMode' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'WBSMode'</b>:
     *
     * If the meaning of "WBSMode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWBSModeGet(WBSModeCallbackIF& cb);

    /**
     * Set the value of the property 'WBSMode'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendWBSModeSet(WBSModeCallbackIF& cb, bool wBSMode)
     * method instead.
     *
     * <b>Documentation of 'WBSMode'</b>:
     *
     * If the meaning of "WBSMode" isn't clear, then there should be a description here.
     */
    void sendWBSModeSet(bool wBSMode);

    /**
     * Set the value of the property 'WBSMode'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'WBSMode'</b>:
     *
     * If the meaning of "WBSMode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWBSModeSet(WBSModeCallbackIF& cb, bool wBSMode);

    /**
     * Returns the current value of the property 'WBSMode' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasWBSMode()
     * returns true.
     *
     * @return the previously received value of the property 'WBSMode'.
     */
    bool getWBSMode() const;

    /**
     * Determines whether a status message for the property 'WBSMode' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWBSMode() const;

    // Property 'Connectable'

    /**
     * Notify on the property 'Connectable'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'Connectable'</b>:
     *
     * If the meaning of "Connectable" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectableRegister(ConnectableCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Connectable'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'Connectable'</b>:
     *
     * If the meaning of "Connectable" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendConnectableRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConnectableDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Connectable'.
     */
    void sendConnectableDeregisterAll() const;

    /**
     * Request the value of the property 'Connectable' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Connectable'</b>:
     *
     * If the meaning of "Connectable" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectableGet(ConnectableCallbackIF& cb);

    /**
     * Set the value of the property 'Connectable'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendConnectableSet(ConnectableCallbackIF& cb, bool
     * connectable) method instead.
     *
     * <b>Documentation of 'Connectable'</b>:
     *
     * If the meaning of "Connectable" isn't clear, then there should be a description here.
     */
    void sendConnectableSet(bool connectable);

    /**
     * Set the value of the property 'Connectable'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'Connectable'</b>:
     *
     * If the meaning of "Connectable" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectableSet(ConnectableCallbackIF& cb, bool connectable);

    /**
     * Returns the current value of the property 'Connectable' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasConnectable() returns true.
     *
     * @return the previously received value of the property 'Connectable'.
     */
    bool getConnectable() const;

    /**
     * Determines whether a status message for the property 'Connectable' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConnectable() const;

    // Property 'HCIMode'

    /**
     * Notify on the property 'HCIMode'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'HCIMode'</b>:
     *
     * If the meaning of "HCIMode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHCIModeRegister(HCIModeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'HCIMode'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'HCIMode'</b>:
     *
     * If the meaning of "HCIMode" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendHCIModeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendHCIModeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'HCIMode'.
     */
    void sendHCIModeDeregisterAll() const;

    /**
     * Request the value of the property 'HCIMode' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'HCIMode'</b>:
     *
     * If the meaning of "HCIMode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHCIModeGet(HCIModeCallbackIF& cb);

    /**
     * Set the value of the property 'HCIMode'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendHCIModeSet(HCIModeCallbackIF& cb, bool hCIMode)
     * method instead.
     *
     * <b>Documentation of 'HCIMode'</b>:
     *
     * If the meaning of "HCIMode" isn't clear, then there should be a description here.
     */
    void sendHCIModeSet(bool hCIMode);

    /**
     * Set the value of the property 'HCIMode'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'HCIMode'</b>:
     *
     * If the meaning of "HCIMode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHCIModeSet(HCIModeCallbackIF& cb, bool hCIMode);

    /**
     * Returns the current value of the property 'HCIMode' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasHCIMode()
     * returns true.
     *
     * @return the previously received value of the property 'HCIMode'.
     */
    bool getHCIMode() const;

    /**
     * Determines whether a status message for the property 'HCIMode' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasHCIMode() const;

    // Property 'Version'

    /**
     * Notify on the property 'Version'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVersionRegister(VersionCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Version'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendVersionRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendVersionDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Version'.
     */
    void sendVersionDeregisterAll() const;

    /**
     * Request the value of the property 'Version' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVersionGet(VersionCallbackIF& cb);


    /**
     * Returns the current value of the property 'Version' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasVersion()
     * returns true.
     *
     * @return the previously received value of the property 'Version'.
     */
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getVersion() const;

    /**
     * Determines whether a status message for the property 'Version' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVersion() const;

    // Property 'TraceLevel'

    /**
     * Notify on the property 'TraceLevel'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'TraceLevel'</b>:
     *
     * If the meaning of "TraceLevel" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTraceLevelRegister(TraceLevelCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'TraceLevel'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'TraceLevel'</b>:
     *
     * If the meaning of "TraceLevel" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTraceLevelRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTraceLevelDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'TraceLevel'.
     */
    void sendTraceLevelDeregisterAll() const;

    /**
     * Request the value of the property 'TraceLevel' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'TraceLevel'</b>:
     *
     * If the meaning of "TraceLevel" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTraceLevelGet(TraceLevelCallbackIF& cb);

    /**
     * Set the value of the property 'TraceLevel'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendTraceLevelSet(TraceLevelCallbackIF& cb, const
     * ::std::vector< ::std::string >& traceLevel) method instead.
     *
     * <b>Documentation of 'TraceLevel'</b>:
     *
     * If the meaning of "TraceLevel" isn't clear, then there should be a description here.
     */
    void sendTraceLevelSet(const ::std::vector< ::std::string >& traceLevel);

    /**
     * Set the value of the property 'TraceLevel'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'TraceLevel'</b>:
     *
     * If the meaning of "TraceLevel" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTraceLevelSet(TraceLevelCallbackIF& cb, const ::std::vector< ::std::string >& traceLevel);

    /**
     * Returns the current value of the property 'TraceLevel' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasTraceLevel() returns true.
     *
     * @return the previously received value of the property 'TraceLevel'.
     */
    const ::std::vector< ::std::string >& getTraceLevel() const;

    /**
     * Determines whether a status message for the property 'TraceLevel' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTraceLevel() const;

    // Property 'TraceCategory'

    /**
     * Notify on the property 'TraceCategory'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'TraceCategory'</b>:
     *
     * If the meaning of "TraceCategory" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTraceCategoryRegister(TraceCategoryCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'TraceCategory'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'TraceCategory'</b>:
     *
     * If the meaning of "TraceCategory" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTraceCategoryRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTraceCategoryDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'TraceCategory'.
     */
    void sendTraceCategoryDeregisterAll() const;

    /**
     * Request the value of the property 'TraceCategory' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'TraceCategory'</b>:
     *
     * If the meaning of "TraceCategory" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTraceCategoryGet(TraceCategoryCallbackIF& cb);

    /**
     * Set the value of the property 'TraceCategory'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendTraceCategorySet(TraceCategoryCallbackIF& cb,
     * const ::std::vector< ::std::string >& traceCategory) method instead.
     *
     * <b>Documentation of 'TraceCategory'</b>:
     *
     * If the meaning of "TraceCategory" isn't clear, then there should be a description here.
     */
    void sendTraceCategorySet(const ::std::vector< ::std::string >& traceCategory);

    /**
     * Set the value of the property 'TraceCategory'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'TraceCategory'</b>:
     *
     * If the meaning of "TraceCategory" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTraceCategorySet(TraceCategoryCallbackIF& cb, const ::std::vector< ::std::string >& traceCategory);

    /**
     * Returns the current value of the property 'TraceCategory' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasTraceCategory() returns true.
     *
     * @return the previously received value of the property 'TraceCategory'.
     */
    const ::std::vector< ::std::string >& getTraceCategory() const;

    /**
     * Determines whether a status message for the property 'TraceCategory'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTraceCategory() const;

    // Property 'AvailableSPPServers'

    /**
     * Notify on the property 'AvailableSPPServers'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'AvailableSPPServers'</b>:
     *
     * If the meaning of "AvailableSPPServers" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAvailableSPPServersRegister(AvailableSPPServersCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'AvailableSPPServers'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'AvailableSPPServers'</b>:
     *
     * If the meaning of "AvailableSPPServers" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAvailableSPPServersRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAvailableSPPServersDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'AvailableSPPServers'.
     */
    void sendAvailableSPPServersDeregisterAll() const;

    /**
     * Request the value of the property 'AvailableSPPServers' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'AvailableSPPServers'</b>:
     *
     * If the meaning of "AvailableSPPServers" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAvailableSPPServersGet(AvailableSPPServersCallbackIF& cb);

    /**
     * Set the value of the property 'AvailableSPPServers'. This method sends
     * a Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendAvailableSPPServersSet(AvailableSPPServersCallbackIF& cb, const
     * ::std::vector< ::std::string >& availableSPPServers) method instead.
     *
     * <b>Documentation of 'AvailableSPPServers'</b>:
     *
     * If the meaning of "AvailableSPPServers" isn't clear, then there should be a description here.
     */
    void sendAvailableSPPServersSet(const ::std::vector< ::std::string >& availableSPPServers);

    /**
     * Set the value of the property 'AvailableSPPServers'. This method sends
     * a Set message to the D-Bus server.
     *
     * <b>Documentation of 'AvailableSPPServers'</b>:
     *
     * If the meaning of "AvailableSPPServers" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAvailableSPPServersSet(AvailableSPPServersCallbackIF& cb, const ::std::vector< ::std::string >& availableSPPServers);

    /**
     * Returns the current value of the property 'AvailableSPPServers' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAvailableSPPServers() returns true.
     *
     * @return the previously received value of the property 'AvailableSPPServers'.
     */
    const ::std::vector< ::std::string >& getAvailableSPPServers() const;

    /**
     * Determines whether a status message for the property
     * 'AvailableSPPServers' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAvailableSPPServers() const;


    // Method 'StartDiscovery'

    /**
     * Call the method 'StartDiscovery'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'StartDiscovery'</b>:
     *
     * If the meaning of "StartDiscovery" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartDiscoveryRequest(StartDiscoveryCallbackIF& cb) const;

    // Method 'StopDiscovery'

    /**
     * Call the method 'StopDiscovery'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'StopDiscovery'</b>:
     *
     * If the meaning of "StopDiscovery" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStopDiscoveryRequest(StopDiscoveryCallbackIF& cb) const;

    // Method 'RemoveDevice'

    /**
     * Call the method 'RemoveDevice'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'RemoveDevice'</b>:
     *
     * If the meaning of "RemoveDevice" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param device If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoveDeviceRequest(RemoveDeviceCallbackIF& cb, const ::std::string& device) const;

    // Method 'CreateDevice'

    /**
     * Call the method 'CreateDevice'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'CreateDevice'</b>:
     *
     * If the meaning of "CreateDevice" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param address If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCreateDeviceRequest(CreateDeviceCallbackIF& cb, const ::std::string& address) const;

    // Method 'SendHCICmd'

    /**
     * Call the method 'SendHCICmd'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SendHCICmd'</b>:
     *
     * If the meaning of "SendHCICmd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendHCICmdRequest(SendHCICmdCallbackIF& cb, const ::std::vector< uint8 >& data) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    Adapter1Proxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'Address'

    ::asf::core::nullable< AddressUpdate > _address;

    // Property 'Class'

    ::asf::core::nullable< ClassUpdate > _class;

    // Property 'Alias'

    ::asf::core::nullable< AliasUpdate > _alias;

    // Property 'Powered'

    ::asf::core::nullable< PoweredUpdate > _powered;

    // Property 'Discoverable'

    ::asf::core::nullable< DiscoverableUpdate > _discoverable;

    // Property 'DiscoverableTimeout'

    ::asf::core::nullable< DiscoverableTimeoutUpdate > _discoverableTimeout;

    // Property 'Pairable'

    ::asf::core::nullable< PairableUpdate > _pairable;

    // Property 'PairableTimeout'

    ::asf::core::nullable< PairableTimeoutUpdate > _pairableTimeout;

    // Property 'Discovering'

    ::asf::core::nullable< DiscoveringUpdate > _discovering;

    // Property 'UUIDs'

    ::asf::core::nullable< UUIDsUpdate > _uUIDs;

    // Property 'WBSMode'

    ::asf::core::nullable< WBSModeUpdate > _wBSMode;

    // Property 'Connectable'

    ::asf::core::nullable< ConnectableUpdate > _connectable;

    // Property 'HCIMode'

    ::asf::core::nullable< HCIModeUpdate > _hCIMode;

    // Property 'Version'

    ::asf::core::nullable< VersionUpdate > _version;

    // Property 'TraceLevel'

    ::asf::core::nullable< TraceLevelUpdate > _traceLevel;

    // Property 'TraceCategory'

    ::asf::core::nullable< TraceCategoryUpdate > _traceCategory;

    // Property 'AvailableSPPServers'

    ::asf::core::nullable< AvailableSPPServersUpdate > _availableSPPServers;

    DECLARE_CLASS_LOGGER();

    friend class Adapter1ProxyCallback;
};

} // namespace Adapter1
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_ADAPTER1PROXY_H
