/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/stream/json.h"
#include "org/bluez/Adapter1.h"
#include "org/bluez/Adapter1Json.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "RemoveDeviceRequest"

void serializeJson (const ::org::bluez::Adapter1::RemoveDeviceRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDevice()) {
        yajl_gen_string(g, (const unsigned char*)  "device" , 6);
        const char *s = value.getDevice().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::RemoveDeviceRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateDeviceRequest"

void serializeJson (const ::org::bluez::Adapter1::CreateDeviceRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "address" , 7);
        const char *s = value.getAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::CreateDeviceRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateDeviceResponse"

void serializeJson (const ::org::bluez::Adapter1::CreateDeviceResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDevice()) {
        yajl_gen_string(g, (const unsigned char*)  "device" , 6);
        const char *s = value.getDevice().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::CreateDeviceResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendHCICmdRequest"

void serializeJson (const ::org::bluez::Adapter1::SendHCICmdRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o1 = value.getData();
        {
            ::std::vector< uint8 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::SendHCICmdRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AddressUpdate"

void serializeJson (const ::org::bluez::Adapter1::AddressUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "Address" , 7);
        const char *s = value.getAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::AddressUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AddressRegister"

void serializeJson (const ::org::bluez::Adapter1::AddressRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::AddressRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClassUpdate"

void serializeJson (const ::org::bluez::Adapter1::ClassUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClass()) {
        yajl_gen_string(g, (const unsigned char*)  "Class" , 5);
        yajl_gen_integer(g, (long long)value.getClass());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::ClassUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClassRegister"

void serializeJson (const ::org::bluez::Adapter1::ClassRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::ClassRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AliasUpdate"

void serializeJson (const ::org::bluez::Adapter1::AliasUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAlias()) {
        yajl_gen_string(g, (const unsigned char*)  "Alias" , 5);
        const char *s = value.getAlias().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::AliasUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AliasRegister"

void serializeJson (const ::org::bluez::Adapter1::AliasRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::AliasRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PoweredUpdate"

void serializeJson (const ::org::bluez::Adapter1::PoweredUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPowered()) {
        yajl_gen_string(g, (const unsigned char*)  "Powered" , 7);
        yajl_gen_bool(g, (bool)value.getPowered());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::PoweredUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PoweredRegister"

void serializeJson (const ::org::bluez::Adapter1::PoweredRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::PoweredRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiscoverableUpdate"

void serializeJson (const ::org::bluez::Adapter1::DiscoverableUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDiscoverable()) {
        yajl_gen_string(g, (const unsigned char*)  "Discoverable" , 12);
        yajl_gen_bool(g, (bool)value.getDiscoverable());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::DiscoverableUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiscoverableRegister"

void serializeJson (const ::org::bluez::Adapter1::DiscoverableRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::DiscoverableRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiscoverableTimeoutUpdate"

void serializeJson (const ::org::bluez::Adapter1::DiscoverableTimeoutUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDiscoverableTimeout()) {
        yajl_gen_string(g, (const unsigned char*)  "DiscoverableTimeout" , 19);
        yajl_gen_integer(g, (long long)value.getDiscoverableTimeout());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::DiscoverableTimeoutUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiscoverableTimeoutRegister"

void serializeJson (const ::org::bluez::Adapter1::DiscoverableTimeoutRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::DiscoverableTimeoutRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PairableUpdate"

void serializeJson (const ::org::bluez::Adapter1::PairableUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPairable()) {
        yajl_gen_string(g, (const unsigned char*)  "Pairable" , 8);
        yajl_gen_bool(g, (bool)value.getPairable());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::PairableUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PairableRegister"

void serializeJson (const ::org::bluez::Adapter1::PairableRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::PairableRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PairableTimeoutUpdate"

void serializeJson (const ::org::bluez::Adapter1::PairableTimeoutUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPairableTimeout()) {
        yajl_gen_string(g, (const unsigned char*)  "PairableTimeout" , 15);
        yajl_gen_integer(g, (long long)value.getPairableTimeout());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::PairableTimeoutUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PairableTimeoutRegister"

void serializeJson (const ::org::bluez::Adapter1::PairableTimeoutRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::PairableTimeoutRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiscoveringUpdate"

void serializeJson (const ::org::bluez::Adapter1::DiscoveringUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDiscovering()) {
        yajl_gen_string(g, (const unsigned char*)  "Discovering" , 11);
        yajl_gen_bool(g, (bool)value.getDiscovering());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::DiscoveringUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiscoveringRegister"

void serializeJson (const ::org::bluez::Adapter1::DiscoveringRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::DiscoveringRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UUIDsUpdate"

void serializeJson (const ::org::bluez::Adapter1::UUIDsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUUIDs()) {
        yajl_gen_string(g, (const unsigned char*)  "UUIDs" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o3 = value.getUUIDs();
        {
            ::std::vector< ::std::string >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                const char *s = (*o2).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::UUIDsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UUIDsRegister"

void serializeJson (const ::org::bluez::Adapter1::UUIDsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::UUIDsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WBSModeUpdate"

void serializeJson (const ::org::bluez::Adapter1::WBSModeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWBSMode()) {
        yajl_gen_string(g, (const unsigned char*)  "WBSMode" , 7);
        yajl_gen_bool(g, (bool)value.getWBSMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::WBSModeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WBSModeRegister"

void serializeJson (const ::org::bluez::Adapter1::WBSModeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::WBSModeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConnectableUpdate"

void serializeJson (const ::org::bluez::Adapter1::ConnectableUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConnectable()) {
        yajl_gen_string(g, (const unsigned char*)  "Connectable" , 11);
        yajl_gen_bool(g, (bool)value.getConnectable());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::ConnectableUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConnectableRegister"

void serializeJson (const ::org::bluez::Adapter1::ConnectableRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::ConnectableRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HCIModeUpdate"

void serializeJson (const ::org::bluez::Adapter1::HCIModeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasHCIMode()) {
        yajl_gen_string(g, (const unsigned char*)  "HCIMode" , 7);
        yajl_gen_bool(g, (bool)value.getHCIMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::HCIModeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HCIModeRegister"

void serializeJson (const ::org::bluez::Adapter1::HCIModeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::HCIModeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VersionUpdate"

void serializeJson (const ::org::bluez::Adapter1::VersionUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "Version" , 7);
        yajl_gen_map_open(g);
        const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& o5 = value.getVersion();
        {
            ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                {
                    const char *s = o4->first.c_str();
                    genStringAndCheck(g, (const unsigned char*) s , strlen(s));
                }
                {
                    yajl_gen_null(g);
                }
            }
        }
        yajl_gen_map_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::VersionUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VersionRegister"

void serializeJson (const ::org::bluez::Adapter1::VersionRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::VersionRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TraceLevelUpdate"

void serializeJson (const ::org::bluez::Adapter1::TraceLevelUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTraceLevel()) {
        yajl_gen_string(g, (const unsigned char*)  "TraceLevel" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o7 = value.getTraceLevel();
        {
            ::std::vector< ::std::string >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                const char *s = (*o6).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::TraceLevelUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TraceLevelRegister"

void serializeJson (const ::org::bluez::Adapter1::TraceLevelRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::TraceLevelRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TraceCategoryUpdate"

void serializeJson (const ::org::bluez::Adapter1::TraceCategoryUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTraceCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "TraceCategory" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o9 = value.getTraceCategory();
        {
            ::std::vector< ::std::string >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                const char *s = (*o8).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::TraceCategoryUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TraceCategoryRegister"

void serializeJson (const ::org::bluez::Adapter1::TraceCategoryRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::TraceCategoryRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AvailableSPPServersUpdate"

void serializeJson (const ::org::bluez::Adapter1::AvailableSPPServersUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAvailableSPPServers()) {
        yajl_gen_string(g, (const unsigned char*)  "AvailableSPPServers" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o11 = value.getAvailableSPPServers();
        {
            ::std::vector< ::std::string >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                const char *s = (*o10).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::AvailableSPPServersUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AvailableSPPServersRegister"

void serializeJson (const ::org::bluez::Adapter1::AvailableSPPServersRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::AvailableSPPServersRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeviceCreatedSignal"

void serializeJson (const ::org::bluez::Adapter1::DeviceCreatedSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDevice()) {
        yajl_gen_string(g, (const unsigned char*)  "device" , 6);
        const char *s = value.getDevice().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::DeviceCreatedSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeviceRemovedSignal"

void serializeJson (const ::org::bluez::Adapter1::DeviceRemovedSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDevice()) {
        yajl_gen_string(g, (const unsigned char*)  "device" , 6);
        const char *s = value.getDevice().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::DeviceRemovedSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BtStackLogSignal"

void serializeJson (const ::org::bluez::Adapter1::BtStackLogSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        yajl_gen_integer(g, (long long)value.getStatus());
    }
    if (!isSparse || value.hasOpcode()) {
        yajl_gen_string(g, (const unsigned char*)  "opcode" , 6);
        yajl_gen_integer(g, (long long)value.getOpcode());
    }
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o13 = value.getData();
        {
            ::std::vector< uint8 >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                yajl_gen_integer(g, (long long)(*o12));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::BtStackLogSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HCIEventSignal"

void serializeJson (const ::org::bluez::Adapter1::HCIEventSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o15 = value.getData();
        {
            ::std::vector< uint8 >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                yajl_gen_integer(g, (long long)(*o14));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::HCIEventSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeviceFoundSignal"

void serializeJson (const ::org::bluez::Adapter1::DeviceFoundSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "address" , 7);
        const char *s = value.getAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasValues()) {
        yajl_gen_string(g, (const unsigned char*)  "values" , 6);
        yajl_gen_map_open(g);
        const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& o17 = value.getValues();
        {
            ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                {
                    const char *s = o16->first.c_str();
                    genStringAndCheck(g, (const unsigned char*) s , strlen(s));
                }
                {
                    yajl_gen_null(g);
                }
            }
        }
        yajl_gen_map_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bluez::Adapter1::DeviceFoundSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::RemoveDeviceRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::CreateDeviceRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::CreateDeviceResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::SendHCICmdRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::AddressUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::AddressRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::ClassUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::ClassRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::AliasUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::AliasRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::PoweredUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::PoweredRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::DiscoverableUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::DiscoverableRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::DiscoverableTimeoutUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::DiscoverableTimeoutRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::PairableUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::PairableRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::PairableTimeoutUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::PairableTimeoutRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::DiscoveringUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::DiscoveringRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::UUIDsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::UUIDsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::WBSModeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::WBSModeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::ConnectableUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::ConnectableRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::HCIModeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::HCIModeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::VersionUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::VersionRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::TraceLevelUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::TraceLevelRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::TraceCategoryUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::TraceCategoryRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::AvailableSPPServersUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::AvailableSPPServersRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::DeviceCreatedSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::DeviceRemovedSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::BtStackLogSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::HCIEventSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bluez {
namespace Adapter1 {

std::ostream& operator<<(std::ostream& o, const ::org::bluez::Adapter1::DeviceFoundSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org

