/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DBusVariantDBus.h"
#include "org/bluez/Adapter1.h"
#include "org/bluez/Adapter1DBus.h"
#include <dbus/dbus.h>
#include <map>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of RemoveDeviceRequest

void serializeDBus (const ::org::bluez::Adapter1::RemoveDeviceRequest& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getDevice())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getDevice()));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::RemoveDeviceRequest& out) {
    {
        ::std::string deviceValue;
        ::std::string &deviceTmpValue = deviceValue;
        {
            char* o0 = 0;
            dbus_message_iter_get_basic(in, &o0);
            deviceTmpValue.assign (o0);
        }
        out.setDevice(deviceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CreateDeviceRequest

void serializeDBus (const ::org::bluez::Adapter1::CreateDeviceRequest& in, DBusMessageIter* out) {
    const char* o1 = in.getAddress().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o1));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::CreateDeviceRequest& out) {
    {
        ::std::string addressValue;
        ::std::string &addressTmpValue = addressValue;
        {
            char* o2 = 0;
            dbus_message_iter_get_basic(in, &o2);
            addressTmpValue.assign (o2);
        }
        out.setAddress(addressValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CreateDeviceResponse

void serializeDBus (const ::org::bluez::Adapter1::CreateDeviceResponse& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getDevice())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getDevice()));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::CreateDeviceResponse& out) {
    {
        ::std::string deviceValue;
        ::std::string &deviceTmpValue = deviceValue;
        {
            char* o3 = 0;
            dbus_message_iter_get_basic(in, &o3);
            deviceTmpValue.assign (o3);
        }
        out.setDevice(deviceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SendHCICmdRequest

void serializeDBus (const ::org::bluez::Adapter1::SendHCICmdRequest& in, DBusMessageIter* out) {
    DBusMessageIter o4ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o4ArrayIter));
    const ::std::vector< uint8 >* o5 = &in.getData();
    ::std::vector< uint8 >::const_iterator o6 = o5->end();
    for (::std::vector< uint8 >::const_iterator o7 = o5->begin(); o7 != o6; ++o7) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o4ArrayIter, DBUS_TYPE_BYTE, &(*o7)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o4ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::SendHCICmdRequest& out) {
    {
        ::std::vector< uint8 > dataValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o8ArrayIter;
            dbus_message_iter_recurse (in, &o8ArrayIter);

            if(dbus_message_iter_get_arg_type(&o8ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o9;
                    dbus_message_iter_get_basic(&o8ArrayIter, &o9);
                    dataValue.push_back(o9);
                } while (dbus_message_iter_next(&o8ArrayIter));
            }
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AddressUpdate

void serializeDBus (const ::org::bluez::Adapter1::AddressUpdate& in, DBusMessageIter* out) {
    const char* o10 = in.getAddress().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o10));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::AddressUpdate& out) {
    {
        ::std::string AddressValue;
        ::std::string &AddressTmpValue = AddressValue;
        {
            char* o11 = 0;
            dbus_message_iter_get_basic(in, &o11);
            AddressTmpValue.assign (o11);
        }
        out.setAddress(AddressValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AddressRegister

void serializeDBus (const ::org::bluez::Adapter1::AddressRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::AddressRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ClassUpdate

void serializeDBus (const ::org::bluez::Adapter1::ClassUpdate& in, DBusMessageIter* out) {
    uint32 o12 = in.getClass();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o12));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::ClassUpdate& out) {
    {
        uint32 ClassValue;
        uint32 &ClassTmpValue = ClassValue;
        dbus_message_iter_get_basic(in, &ClassTmpValue);
        out.setClass(ClassValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ClassRegister

void serializeDBus (const ::org::bluez::Adapter1::ClassRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::ClassRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AliasUpdate

void serializeDBus (const ::org::bluez::Adapter1::AliasUpdate& in, DBusMessageIter* out) {
    const char* o13 = in.getAlias().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o13));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::AliasUpdate& out) {
    {
        ::std::string AliasValue;
        ::std::string &AliasTmpValue = AliasValue;
        {
            char* o14 = 0;
            dbus_message_iter_get_basic(in, &o14);
            AliasTmpValue.assign (o14);
        }
        out.setAlias(AliasValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AliasRegister

void serializeDBus (const ::org::bluez::Adapter1::AliasRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::AliasRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PoweredUpdate

void serializeDBus (const ::org::bluez::Adapter1::PoweredUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o15 = in.getPowered() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o15));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::PoweredUpdate& out) {
    {
        bool PoweredValue;
        bool &PoweredTmpValue = PoweredValue;
        {
            dbus_bool_t o16;
            dbus_message_iter_get_basic(in, &o16);
            PoweredTmpValue = o16 ? true : false;
        }
        out.setPowered(PoweredValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PoweredRegister

void serializeDBus (const ::org::bluez::Adapter1::PoweredRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::PoweredRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DiscoverableUpdate

void serializeDBus (const ::org::bluez::Adapter1::DiscoverableUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o17 = in.getDiscoverable() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o17));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::DiscoverableUpdate& out) {
    {
        bool DiscoverableValue;
        bool &DiscoverableTmpValue = DiscoverableValue;
        {
            dbus_bool_t o18;
            dbus_message_iter_get_basic(in, &o18);
            DiscoverableTmpValue = o18 ? true : false;
        }
        out.setDiscoverable(DiscoverableValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DiscoverableRegister

void serializeDBus (const ::org::bluez::Adapter1::DiscoverableRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::DiscoverableRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DiscoverableTimeoutUpdate

void serializeDBus (const ::org::bluez::Adapter1::DiscoverableTimeoutUpdate& in, DBusMessageIter* out) {
    uint32 o19 = in.getDiscoverableTimeout();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o19));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::DiscoverableTimeoutUpdate& out) {
    {
        uint32 DiscoverableTimeoutValue;
        uint32 &DiscoverableTimeoutTmpValue = DiscoverableTimeoutValue;
        dbus_message_iter_get_basic(in, &DiscoverableTimeoutTmpValue);
        out.setDiscoverableTimeout(DiscoverableTimeoutValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DiscoverableTimeoutRegister

void serializeDBus (const ::org::bluez::Adapter1::DiscoverableTimeoutRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::DiscoverableTimeoutRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PairableUpdate

void serializeDBus (const ::org::bluez::Adapter1::PairableUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o20 = in.getPairable() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o20));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::PairableUpdate& out) {
    {
        bool PairableValue;
        bool &PairableTmpValue = PairableValue;
        {
            dbus_bool_t o21;
            dbus_message_iter_get_basic(in, &o21);
            PairableTmpValue = o21 ? true : false;
        }
        out.setPairable(PairableValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PairableRegister

void serializeDBus (const ::org::bluez::Adapter1::PairableRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::PairableRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PairableTimeoutUpdate

void serializeDBus (const ::org::bluez::Adapter1::PairableTimeoutUpdate& in, DBusMessageIter* out) {
    uint32 o22 = in.getPairableTimeout();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o22));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::PairableTimeoutUpdate& out) {
    {
        uint32 PairableTimeoutValue;
        uint32 &PairableTimeoutTmpValue = PairableTimeoutValue;
        dbus_message_iter_get_basic(in, &PairableTimeoutTmpValue);
        out.setPairableTimeout(PairableTimeoutValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PairableTimeoutRegister

void serializeDBus (const ::org::bluez::Adapter1::PairableTimeoutRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::PairableTimeoutRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DiscoveringUpdate

void serializeDBus (const ::org::bluez::Adapter1::DiscoveringUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o23 = in.getDiscovering() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o23));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::DiscoveringUpdate& out) {
    {
        bool DiscoveringValue;
        bool &DiscoveringTmpValue = DiscoveringValue;
        {
            dbus_bool_t o24;
            dbus_message_iter_get_basic(in, &o24);
            DiscoveringTmpValue = o24 ? true : false;
        }
        out.setDiscovering(DiscoveringValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DiscoveringRegister

void serializeDBus (const ::org::bluez::Adapter1::DiscoveringRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::DiscoveringRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of UUIDsUpdate

void serializeDBus (const ::org::bluez::Adapter1::UUIDsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o25ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o25ArrayIter));
    const ::std::vector< ::std::string >* o26 = &in.getUUIDs();
    ::std::vector< ::std::string >::const_iterator o27 = o26->end();
    for (::std::vector< ::std::string >::const_iterator o28 = o26->begin(); o28 != o27; ++o28) {
        const char* o29 = (*o28).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o25ArrayIter, DBUS_TYPE_STRING, &o29));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o25ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::UUIDsUpdate& out) {
    {
        ::std::vector< ::std::string > UUIDsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o30ArrayIter;
            dbus_message_iter_recurse (in, &o30ArrayIter);

            if(dbus_message_iter_get_arg_type(&o30ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o31;
                    {
                        char* o32 = 0;
                        dbus_message_iter_get_basic(&o30ArrayIter, &o32);
                        o31.assign (o32);
                    }
                    UUIDsValue.push_back(o31);
                } while (dbus_message_iter_next(&o30ArrayIter));
            }
        }
        out.setUUIDs(UUIDsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UUIDsRegister

void serializeDBus (const ::org::bluez::Adapter1::UUIDsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::UUIDsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of WBSModeUpdate

void serializeDBus (const ::org::bluez::Adapter1::WBSModeUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o33 = in.getWBSMode() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o33));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::WBSModeUpdate& out) {
    {
        bool WBSModeValue;
        bool &WBSModeTmpValue = WBSModeValue;
        {
            dbus_bool_t o34;
            dbus_message_iter_get_basic(in, &o34);
            WBSModeTmpValue = o34 ? true : false;
        }
        out.setWBSMode(WBSModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of WBSModeRegister

void serializeDBus (const ::org::bluez::Adapter1::WBSModeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::WBSModeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ConnectableUpdate

void serializeDBus (const ::org::bluez::Adapter1::ConnectableUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o35 = in.getConnectable() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o35));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::ConnectableUpdate& out) {
    {
        bool ConnectableValue;
        bool &ConnectableTmpValue = ConnectableValue;
        {
            dbus_bool_t o36;
            dbus_message_iter_get_basic(in, &o36);
            ConnectableTmpValue = o36 ? true : false;
        }
        out.setConnectable(ConnectableValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ConnectableRegister

void serializeDBus (const ::org::bluez::Adapter1::ConnectableRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::ConnectableRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of HCIModeUpdate

void serializeDBus (const ::org::bluez::Adapter1::HCIModeUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o37 = in.getHCIMode() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o37));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::HCIModeUpdate& out) {
    {
        bool HCIModeValue;
        bool &HCIModeTmpValue = HCIModeValue;
        {
            dbus_bool_t o38;
            dbus_message_iter_get_basic(in, &o38);
            HCIModeTmpValue = o38 ? true : false;
        }
        out.setHCIMode(HCIModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of HCIModeRegister

void serializeDBus (const ::org::bluez::Adapter1::HCIModeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::HCIModeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of VersionUpdate

void serializeDBus (const ::org::bluez::Adapter1::VersionUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o39ArrayIter;
    DBusMessageIter o40DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o39ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o41 = &in.getVersion();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o42 = o41->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o43 = o41->begin(); o43 != o42; ++o43) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o39ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o40DictIter));
        const char* o44 = o43->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o40DictIter, DBUS_TYPE_STRING, &o44));
        serializeDBus(o43->second, &o40DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o39ArrayIter, &o40DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o39ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::VersionUpdate& out) {
    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > VersionValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o45ArrayIter;
            DBusMessageIter o46DictIter;
            dbus_message_iter_recurse (in, &o45ArrayIter);

            if (dbus_message_iter_get_arg_type(&o45ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o47Key;
                    ::asf::dbus::DBusVariant o47Value;
                    dbus_message_iter_recurse (&o45ArrayIter, &o46DictIter);
                    {
                        char* o48 = 0;
                        dbus_message_iter_get_basic(&o46DictIter, &o48);
                        o47Key.assign (o48);
                    }
                    dbus_message_iter_next(&o46DictIter);
                    {
                        DBusMessageIter o49;
                        char* signature = dbus_message_iter_get_signature(&o46DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o46DictIter)) {
                                dbus_message_iter_recurse (&o46DictIter, &o49);

                                if (!deserializeDBus(&o49, o47Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    VersionValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o47Key, o47Value));
                } while (dbus_message_iter_next(&o45ArrayIter));
            }
        }
        out.setVersion(VersionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VersionRegister

void serializeDBus (const ::org::bluez::Adapter1::VersionRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::VersionRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TraceLevelUpdate

void serializeDBus (const ::org::bluez::Adapter1::TraceLevelUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o50ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o50ArrayIter));
    const ::std::vector< ::std::string >* o51 = &in.getTraceLevel();
    ::std::vector< ::std::string >::const_iterator o52 = o51->end();
    for (::std::vector< ::std::string >::const_iterator o53 = o51->begin(); o53 != o52; ++o53) {
        const char* o54 = (*o53).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o50ArrayIter, DBUS_TYPE_STRING, &o54));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o50ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::TraceLevelUpdate& out) {
    {
        ::std::vector< ::std::string > TraceLevelValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o55ArrayIter;
            dbus_message_iter_recurse (in, &o55ArrayIter);

            if(dbus_message_iter_get_arg_type(&o55ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o56;
                    {
                        char* o57 = 0;
                        dbus_message_iter_get_basic(&o55ArrayIter, &o57);
                        o56.assign (o57);
                    }
                    TraceLevelValue.push_back(o56);
                } while (dbus_message_iter_next(&o55ArrayIter));
            }
        }
        out.setTraceLevel(TraceLevelValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TraceLevelRegister

void serializeDBus (const ::org::bluez::Adapter1::TraceLevelRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::TraceLevelRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TraceCategoryUpdate

void serializeDBus (const ::org::bluez::Adapter1::TraceCategoryUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o58ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o58ArrayIter));
    const ::std::vector< ::std::string >* o59 = &in.getTraceCategory();
    ::std::vector< ::std::string >::const_iterator o60 = o59->end();
    for (::std::vector< ::std::string >::const_iterator o61 = o59->begin(); o61 != o60; ++o61) {
        const char* o62 = (*o61).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o58ArrayIter, DBUS_TYPE_STRING, &o62));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o58ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::TraceCategoryUpdate& out) {
    {
        ::std::vector< ::std::string > TraceCategoryValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o63ArrayIter;
            dbus_message_iter_recurse (in, &o63ArrayIter);

            if(dbus_message_iter_get_arg_type(&o63ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o64;
                    {
                        char* o65 = 0;
                        dbus_message_iter_get_basic(&o63ArrayIter, &o65);
                        o64.assign (o65);
                    }
                    TraceCategoryValue.push_back(o64);
                } while (dbus_message_iter_next(&o63ArrayIter));
            }
        }
        out.setTraceCategory(TraceCategoryValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TraceCategoryRegister

void serializeDBus (const ::org::bluez::Adapter1::TraceCategoryRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::TraceCategoryRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AvailableSPPServersUpdate

void serializeDBus (const ::org::bluez::Adapter1::AvailableSPPServersUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o66ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o66ArrayIter));
    const ::std::vector< ::std::string >* o67 = &in.getAvailableSPPServers();
    ::std::vector< ::std::string >::const_iterator o68 = o67->end();
    for (::std::vector< ::std::string >::const_iterator o69 = o67->begin(); o69 != o68; ++o69) {
        const char* o70 = (*o69).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o66ArrayIter, DBUS_TYPE_STRING, &o70));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o66ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::AvailableSPPServersUpdate& out) {
    {
        ::std::vector< ::std::string > AvailableSPPServersValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o71ArrayIter;
            dbus_message_iter_recurse (in, &o71ArrayIter);

            if(dbus_message_iter_get_arg_type(&o71ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o72;
                    {
                        char* o73 = 0;
                        dbus_message_iter_get_basic(&o71ArrayIter, &o73);
                        o72.assign (o73);
                    }
                    AvailableSPPServersValue.push_back(o72);
                } while (dbus_message_iter_next(&o71ArrayIter));
            }
        }
        out.setAvailableSPPServers(AvailableSPPServersValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AvailableSPPServersRegister

void serializeDBus (const ::org::bluez::Adapter1::AvailableSPPServersRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::Adapter1::AvailableSPPServersRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DeviceCreatedSignal

void serializeDBus (const ::org::bluez::Adapter1::DeviceCreatedSignal& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getDevice())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getDevice()));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::DeviceCreatedSignal& out) {
    {
        ::std::string deviceValue;
        ::std::string &deviceTmpValue = deviceValue;
        {
            char* o74 = 0;
            dbus_message_iter_get_basic(in, &o74);
            deviceTmpValue.assign (o74);
        }
        out.setDevice(deviceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DeviceRemovedSignal

void serializeDBus (const ::org::bluez::Adapter1::DeviceRemovedSignal& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getDevice())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getDevice()));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::DeviceRemovedSignal& out) {
    {
        ::std::string deviceValue;
        ::std::string &deviceTmpValue = deviceValue;
        {
            char* o75 = 0;
            dbus_message_iter_get_basic(in, &o75);
            deviceTmpValue.assign (o75);
        }
        out.setDevice(deviceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BtStackLogSignal

void serializeDBus (const ::org::bluez::Adapter1::BtStackLogSignal& in, DBusMessageIter* out) {
    uint8 o76 = in.getStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o76));
    uint16 o77 = in.getOpcode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o77));
    DBusMessageIter o78ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o78ArrayIter));
    const ::std::vector< uint8 >* o79 = &in.getData();
    ::std::vector< uint8 >::const_iterator o80 = o79->end();
    for (::std::vector< uint8 >::const_iterator o81 = o79->begin(); o81 != o80; ++o81) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o78ArrayIter, DBUS_TYPE_BYTE, &(*o81)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o78ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::BtStackLogSignal& out) {
    {
        uint8 statusValue;
        uint8 &statusTmpValue = statusValue;
        dbus_message_iter_get_basic(in, &statusTmpValue);
        out.setStatus(statusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 opcodeValue;
        uint16 &opcodeTmpValue = opcodeValue;
        dbus_message_iter_get_basic(in, &opcodeTmpValue);
        out.setOpcode(opcodeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< uint8 > dataValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o82ArrayIter;
            dbus_message_iter_recurse (in, &o82ArrayIter);

            if(dbus_message_iter_get_arg_type(&o82ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o83;
                    dbus_message_iter_get_basic(&o82ArrayIter, &o83);
                    dataValue.push_back(o83);
                } while (dbus_message_iter_next(&o82ArrayIter));
            }
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of HCIEventSignal

void serializeDBus (const ::org::bluez::Adapter1::HCIEventSignal& in, DBusMessageIter* out) {
    DBusMessageIter o84ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o84ArrayIter));
    const ::std::vector< uint8 >* o85 = &in.getData();
    ::std::vector< uint8 >::const_iterator o86 = o85->end();
    for (::std::vector< uint8 >::const_iterator o87 = o85->begin(); o87 != o86; ++o87) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o84ArrayIter, DBUS_TYPE_BYTE, &(*o87)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o84ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::HCIEventSignal& out) {
    {
        ::std::vector< uint8 > dataValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o88ArrayIter;
            dbus_message_iter_recurse (in, &o88ArrayIter);

            if(dbus_message_iter_get_arg_type(&o88ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o89;
                    dbus_message_iter_get_basic(&o88ArrayIter, &o89);
                    dataValue.push_back(o89);
                } while (dbus_message_iter_next(&o88ArrayIter));
            }
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DeviceFoundSignal

void serializeDBus (const ::org::bluez::Adapter1::DeviceFoundSignal& in, DBusMessageIter* out) {
    const char* o90 = in.getAddress().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o90));
    DBusMessageIter o91ArrayIter;
    DBusMessageIter o92DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o91ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o93 = &in.getValues();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o94 = o93->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o95 = o93->begin(); o95 != o94; ++o95) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o91ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o92DictIter));
        const char* o96 = o95->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o92DictIter, DBUS_TYPE_STRING, &o96));
        serializeDBus(o95->second, &o92DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o91ArrayIter, &o92DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o91ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::Adapter1::DeviceFoundSignal& out) {
    {
        ::std::string addressValue;
        ::std::string &addressTmpValue = addressValue;
        {
            char* o97 = 0;
            dbus_message_iter_get_basic(in, &o97);
            addressTmpValue.assign (o97);
        }
        out.setAddress(addressValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > valuesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o98ArrayIter;
            DBusMessageIter o99DictIter;
            dbus_message_iter_recurse (in, &o98ArrayIter);

            if (dbus_message_iter_get_arg_type(&o98ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o100Key;
                    ::asf::dbus::DBusVariant o100Value;
                    dbus_message_iter_recurse (&o98ArrayIter, &o99DictIter);
                    {
                        char* o101 = 0;
                        dbus_message_iter_get_basic(&o99DictIter, &o101);
                        o100Key.assign (o101);
                    }
                    dbus_message_iter_next(&o99DictIter);
                    {
                        DBusMessageIter o102;
                        char* signature = dbus_message_iter_get_signature(&o99DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o99DictIter)) {
                                dbus_message_iter_recurse (&o99DictIter, &o102);

                                if (!deserializeDBus(&o102, o100Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    valuesValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o100Key, o100Value));
                } while (dbus_message_iter_next(&o98ArrayIter));
            }
        }
        out.setValues(valuesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

