#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_ADAPTER1_H
#define ORG_BLUEZ_ADAPTER1_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * If the meaning of "Adapter1" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace Adapter1 {

// method IDs
static const uint16 ID_StartDiscovery = 0;
static const uint16 ID_StopDiscovery = 1;
static const uint16 ID_RemoveDevice = 2;
static const uint16 ID_CreateDevice = 3;
static const uint16 ID_SendHCICmd = 4;

// signal IDs
static const uint16 ID_AdapterInitialization = 5;
static const uint16 ID_DeviceCreated = 6;
static const uint16 ID_DeviceRemoved = 7;
static const uint16 ID_BtStackLog = 8;
static const uint16 ID_HCIEvent = 9;
static const uint16 ID_DeviceFound = 10;

// property IDs
static const uint16 ID_Address = 11;
static const uint16 ID_Class = 12;
static const uint16 ID_Alias = 13;
static const uint16 ID_Powered = 14;
static const uint16 ID_Discoverable = 15;
static const uint16 ID_DiscoverableTimeout = 16;
static const uint16 ID_Pairable = 17;
static const uint16 ID_PairableTimeout = 18;
static const uint16 ID_Discovering = 19;
static const uint16 ID_UUIDs = 20;
static const uint16 ID_WBSMode = 21;
static const uint16 ID_Connectable = 22;
static const uint16 ID_HCIMode = 23;
static const uint16 ID_Version = 24;
static const uint16 ID_TraceLevel = 25;
static const uint16 ID_TraceCategory = 26;
static const uint16 ID_AvailableSPPServers = 27;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class RemoveDeviceRequest;

class CreateDeviceRequest;

class CreateDeviceResponse;

class SendHCICmdRequest;

class AddressUpdate;

class AddressRegister;

class ClassUpdate;

class ClassRegister;

class AliasUpdate;

class AliasRegister;

class PoweredUpdate;

class PoweredRegister;

class DiscoverableUpdate;

class DiscoverableRegister;

class DiscoverableTimeoutUpdate;

class DiscoverableTimeoutRegister;

class PairableUpdate;

class PairableRegister;

class PairableTimeoutUpdate;

class PairableTimeoutRegister;

class DiscoveringUpdate;

class DiscoveringRegister;

class UUIDsUpdate;

class UUIDsRegister;

class WBSModeUpdate;

class WBSModeRegister;

class ConnectableUpdate;

class ConnectableRegister;

class HCIModeUpdate;

class HCIModeRegister;

class VersionUpdate;

class VersionRegister;

class TraceLevelUpdate;

class TraceLevelRegister;

class TraceCategoryUpdate;

class TraceCategoryRegister;

class AvailableSPPServersUpdate;

class AvailableSPPServersRegister;

class DeviceCreatedSignal;

class DeviceRemovedSignal;

class BtStackLogSignal;

class HCIEventSignal;

class DeviceFoundSignal;

// type definitions
/**
 * If the meaning of "StartDiscoveryRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartDiscoveryRequest;

/**
 * If the meaning of "StartDiscoveryResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartDiscoveryResponse;

/**
 * If the meaning of "StartDiscoveryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartDiscoveryError;

/**
 * If the meaning of "StopDiscoveryRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StopDiscoveryRequest;

/**
 * If the meaning of "StopDiscoveryResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StopDiscoveryResponse;

/**
 * If the meaning of "StopDiscoveryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StopDiscoveryError;

/**
 * If the meaning of "RemoveDeviceResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RemoveDeviceResponse;

/**
 * If the meaning of "RemoveDeviceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemoveDeviceError;

/**
 * If the meaning of "CreateDeviceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CreateDeviceError;

/**
 * If the meaning of "SendHCICmdResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SendHCICmdResponse;

/**
 * If the meaning of "SendHCICmdError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SendHCICmdError;

/**
 * If the meaning of "AddressSet" isn't clear, then there should be a description here.
 */
typedef AddressUpdate AddressSet;

/**
 * If the meaning of "AddressGet" isn't clear, then there should be a description here.
 */
typedef AddressUpdate AddressGet;

/**
 * If the meaning of "AddressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AddressError;

/**
 * If the meaning of "ClassSet" isn't clear, then there should be a description here.
 */
typedef ClassUpdate ClassSet;

/**
 * If the meaning of "ClassGet" isn't clear, then there should be a description here.
 */
typedef ClassUpdate ClassGet;

/**
 * If the meaning of "ClassError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ClassError;

/**
 * If the meaning of "AliasSet" isn't clear, then there should be a description here.
 */
typedef AliasUpdate AliasSet;

/**
 * If the meaning of "AliasGet" isn't clear, then there should be a description here.
 */
typedef AliasUpdate AliasGet;

/**
 * If the meaning of "AliasError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AliasError;

/**
 * If the meaning of "PoweredSet" isn't clear, then there should be a description here.
 */
typedef PoweredUpdate PoweredSet;

/**
 * If the meaning of "PoweredGet" isn't clear, then there should be a description here.
 */
typedef PoweredUpdate PoweredGet;

/**
 * If the meaning of "PoweredError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PoweredError;

/**
 * If the meaning of "DiscoverableSet" isn't clear, then there should be a description here.
 */
typedef DiscoverableUpdate DiscoverableSet;

/**
 * If the meaning of "DiscoverableGet" isn't clear, then there should be a description here.
 */
typedef DiscoverableUpdate DiscoverableGet;

/**
 * If the meaning of "DiscoverableError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DiscoverableError;

/**
 * If the meaning of "DiscoverableTimeoutSet" isn't clear, then there should be a description here.
 */
typedef DiscoverableTimeoutUpdate DiscoverableTimeoutSet;

/**
 * If the meaning of "DiscoverableTimeoutGet" isn't clear, then there should be a description here.
 */
typedef DiscoverableTimeoutUpdate DiscoverableTimeoutGet;

/**
 * If the meaning of "DiscoverableTimeoutError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DiscoverableTimeoutError;

/**
 * If the meaning of "PairableSet" isn't clear, then there should be a description here.
 */
typedef PairableUpdate PairableSet;

/**
 * If the meaning of "PairableGet" isn't clear, then there should be a description here.
 */
typedef PairableUpdate PairableGet;

/**
 * If the meaning of "PairableError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PairableError;

/**
 * If the meaning of "PairableTimeoutSet" isn't clear, then there should be a description here.
 */
typedef PairableTimeoutUpdate PairableTimeoutSet;

/**
 * If the meaning of "PairableTimeoutGet" isn't clear, then there should be a description here.
 */
typedef PairableTimeoutUpdate PairableTimeoutGet;

/**
 * If the meaning of "PairableTimeoutError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PairableTimeoutError;

/**
 * If the meaning of "DiscoveringSet" isn't clear, then there should be a description here.
 */
typedef DiscoveringUpdate DiscoveringSet;

/**
 * If the meaning of "DiscoveringGet" isn't clear, then there should be a description here.
 */
typedef DiscoveringUpdate DiscoveringGet;

/**
 * If the meaning of "DiscoveringError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DiscoveringError;

/**
 * If the meaning of "UUIDsSet" isn't clear, then there should be a description here.
 */
typedef UUIDsUpdate UUIDsSet;

/**
 * If the meaning of "UUIDsGet" isn't clear, then there should be a description here.
 */
typedef UUIDsUpdate UUIDsGet;

/**
 * If the meaning of "UUIDsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UUIDsError;

/**
 * If the meaning of "WBSModeSet" isn't clear, then there should be a description here.
 */
typedef WBSModeUpdate WBSModeSet;

/**
 * If the meaning of "WBSModeGet" isn't clear, then there should be a description here.
 */
typedef WBSModeUpdate WBSModeGet;

/**
 * If the meaning of "WBSModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WBSModeError;

/**
 * If the meaning of "ConnectableSet" isn't clear, then there should be a description here.
 */
typedef ConnectableUpdate ConnectableSet;

/**
 * If the meaning of "ConnectableGet" isn't clear, then there should be a description here.
 */
typedef ConnectableUpdate ConnectableGet;

/**
 * If the meaning of "ConnectableError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConnectableError;

/**
 * If the meaning of "HCIModeSet" isn't clear, then there should be a description here.
 */
typedef HCIModeUpdate HCIModeSet;

/**
 * If the meaning of "HCIModeGet" isn't clear, then there should be a description here.
 */
typedef HCIModeUpdate HCIModeGet;

/**
 * If the meaning of "HCIModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HCIModeError;

/**
 * If the meaning of "VersionSet" isn't clear, then there should be a description here.
 */
typedef VersionUpdate VersionSet;

/**
 * If the meaning of "VersionGet" isn't clear, then there should be a description here.
 */
typedef VersionUpdate VersionGet;

/**
 * If the meaning of "VersionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VersionError;

/**
 * If the meaning of "TraceLevelSet" isn't clear, then there should be a description here.
 */
typedef TraceLevelUpdate TraceLevelSet;

/**
 * If the meaning of "TraceLevelGet" isn't clear, then there should be a description here.
 */
typedef TraceLevelUpdate TraceLevelGet;

/**
 * If the meaning of "TraceLevelError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TraceLevelError;

/**
 * If the meaning of "TraceCategorySet" isn't clear, then there should be a description here.
 */
typedef TraceCategoryUpdate TraceCategorySet;

/**
 * If the meaning of "TraceCategoryGet" isn't clear, then there should be a description here.
 */
typedef TraceCategoryUpdate TraceCategoryGet;

/**
 * If the meaning of "TraceCategoryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TraceCategoryError;

/**
 * If the meaning of "AvailableSPPServersSet" isn't clear, then there should be a description here.
 */
typedef AvailableSPPServersUpdate AvailableSPPServersSet;

/**
 * If the meaning of "AvailableSPPServersGet" isn't clear, then there should be a description here.
 */
typedef AvailableSPPServersUpdate AvailableSPPServersGet;

/**
 * If the meaning of "AvailableSPPServersError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AvailableSPPServersError;

/**
 * If the meaning of "AdapterInitializationSignal" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AdapterInitializationSignal;

/**
 * If the meaning of "AdapterInitializationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AdapterInitializationError;

/**
 * If the meaning of "DeviceCreatedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeviceCreatedError;

/**
 * If the meaning of "DeviceRemovedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeviceRemovedError;

/**
 * If the meaning of "BtStackLogError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtStackLogError;

/**
 * If the meaning of "HCIEventError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HCIEventError;

/**
 * If the meaning of "DeviceFoundError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeviceFoundError;


/**
 * If the meaning of "RemoveDeviceRequest" isn't clear, then there should be a description here.
 */
class RemoveDeviceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveDeviceRequest ();

    /**
     * Copy constructor
     */
    inline  RemoveDeviceRequest (const RemoveDeviceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveDeviceRequest (const ::std::string& device_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveDeviceRequest();

    /**
     * Assignment operator
     */
    inline RemoveDeviceRequest& operator = (const RemoveDeviceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveDeviceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveDeviceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveDeviceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveDeviceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const RemoveDeviceRequest &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _device;

};

/**
 * If the meaning of "CreateDeviceRequest" isn't clear, then there should be a description here.
 */
class CreateDeviceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateDeviceRequest ();

    /**
     * Copy constructor
     */
    inline  CreateDeviceRequest (const CreateDeviceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CreateDeviceRequest (const ::std::string& address_);

    /**
     * Destructor
     */
    inline virtual  ~CreateDeviceRequest();

    /**
     * Assignment operator
     */
    inline CreateDeviceRequest& operator = (const CreateDeviceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateDeviceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateDeviceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateDeviceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateDeviceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "address"

    static const int kAddress = 0;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::string& address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    static const CreateDeviceRequest &getDefaultInstance();

private:

    inline void set_has_address ();

    inline void clear_has_address ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _address;

};

/**
 * If the meaning of "CreateDeviceResponse" isn't clear, then there should be a description here.
 */
class CreateDeviceResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateDeviceResponse ();

    /**
     * Copy constructor
     */
    inline  CreateDeviceResponse (const CreateDeviceResponse &rhs);

    /**
     * All fields constructor
     */
    inline  CreateDeviceResponse (const ::std::string& device_);

    /**
     * Destructor
     */
    inline virtual  ~CreateDeviceResponse();

    /**
     * Assignment operator
     */
    inline CreateDeviceResponse& operator = (const CreateDeviceResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateDeviceResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateDeviceResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateDeviceResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateDeviceResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const CreateDeviceResponse &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _device;

};

/**
 * If the meaning of "SendHCICmdRequest" isn't clear, then there should be a description here.
 */
class SendHCICmdRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendHCICmdRequest ();

    /**
     * Copy constructor
     */
    inline  SendHCICmdRequest (const SendHCICmdRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SendHCICmdRequest (const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~SendHCICmdRequest();

    /**
     * Assignment operator
     */
    inline SendHCICmdRequest& operator = (const SendHCICmdRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendHCICmdRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendHCICmdRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendHCICmdRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendHCICmdRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const SendHCICmdRequest &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "AddressUpdate" isn't clear, then there should be a description here.
 */
class AddressUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddressUpdate ();

    /**
     * Copy constructor
     */
    inline  AddressUpdate (const AddressUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AddressUpdate (const ::std::string& Address_);

    /**
     * Destructor
     */
    inline virtual  ~AddressUpdate();

    /**
     * Assignment operator
     */
    inline AddressUpdate& operator = (const AddressUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddressUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddressUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddressUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddressUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Address"

    static const int kAddress = 0;

    /**
     * Clears the field "Address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "Address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "Address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const ::std::string& Address_);

    /**
     * Sets the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const char* Address_);

    /**
     * Sets the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    static const AddressUpdate &getDefaultInstance();

private:

    inline void set_has_Address ();

    inline void clear_has_Address ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Address;

};

/**
 * If the meaning of "AddressRegister" isn't clear, then there should be a description here.
 */
class AddressRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddressRegister ();

    /**
     * Copy constructor
     */
    inline  AddressRegister (const AddressRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AddressRegister();

    /**
     * Assignment operator
     */
    inline AddressRegister& operator = (const AddressRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddressRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddressRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddressRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddressRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AddressRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ClassUpdate" isn't clear, then there should be a description here.
 */
class ClassUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClassUpdate ();

    /**
     * Copy constructor
     */
    inline  ClassUpdate (const ClassUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ClassUpdate (uint32 Class_);

    /**
     * Destructor
     */
    inline virtual  ~ClassUpdate();

    /**
     * Assignment operator
     */
    inline ClassUpdate& operator = (const ClassUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClassUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClassUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClassUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClassUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Class"

    static const int kClass = 0;

    /**
     * Clears the field "Class".
     *
     * The field will be set to its default value. The hasClass()
     * method will return false.
     */
    inline void clearClass();

    /**
     * Checks whether the field "Class" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClass()). Otherwise it will return false.
     */
    inline bool hasClass () const;

    /**
     * Returns the value of the member "Class".
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Class"
     */
    inline uint32 getClass () const;

    /**
     * Sets the value of the member "Class".
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     *
     * @param Class The value which will be set
     */
    inline void setClass (uint32 Class_);

    static const ClassUpdate &getDefaultInstance();

private:

    inline void set_has_Class ();

    inline void clear_has_Class ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Class;

};

/**
 * If the meaning of "ClassRegister" isn't clear, then there should be a description here.
 */
class ClassRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClassRegister ();

    /**
     * Copy constructor
     */
    inline  ClassRegister (const ClassRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ClassRegister();

    /**
     * Assignment operator
     */
    inline ClassRegister& operator = (const ClassRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClassRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClassRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClassRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClassRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ClassRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AliasUpdate" isn't clear, then there should be a description here.
 */
class AliasUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AliasUpdate ();

    /**
     * Copy constructor
     */
    inline  AliasUpdate (const AliasUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AliasUpdate (const ::std::string& Alias_);

    /**
     * Destructor
     */
    inline virtual  ~AliasUpdate();

    /**
     * Assignment operator
     */
    inline AliasUpdate& operator = (const AliasUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AliasUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AliasUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AliasUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AliasUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Alias"

    static const int kAlias = 0;

    /**
     * Clears the field "Alias".
     *
     * The field will be set to its default value. The hasAlias()
     * method will return false.
     */
    inline void clearAlias();

    /**
     * Checks whether the field "Alias" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlias()). Otherwise it will return false.
     */
    inline bool hasAlias () const;

    /**
     * Returns the value of the member "Alias".
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Alias"
     */
    inline const ::std::string& getAlias () const;

    /**
     * Retrieves the value of the field "Alias" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Alias".
     */
    inline ::std::string& getAliasMutable ();

    /**
     * Sets the value of the member "Alias".
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param Alias The value which will be set
     */
    inline void setAlias (const ::std::string& Alias_);

    /**
     * Sets the value of the member "Alias".
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param Alias The value which will be set
     */
    inline void setAlias (const char* Alias_);

    /**
     * Sets the value of the member "Alias".
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param Alias The value which will be set
     */
    inline void setAlias (const char* value, size_t size);

    static const AliasUpdate &getDefaultInstance();

private:

    inline void set_has_Alias ();

    inline void clear_has_Alias ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Alias;

};

/**
 * If the meaning of "AliasRegister" isn't clear, then there should be a description here.
 */
class AliasRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AliasRegister ();

    /**
     * Copy constructor
     */
    inline  AliasRegister (const AliasRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AliasRegister();

    /**
     * Assignment operator
     */
    inline AliasRegister& operator = (const AliasRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AliasRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AliasRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AliasRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AliasRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AliasRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PoweredUpdate" isn't clear, then there should be a description here.
 */
class PoweredUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PoweredUpdate ();

    /**
     * Copy constructor
     */
    inline  PoweredUpdate (const PoweredUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PoweredUpdate (bool Powered_);

    /**
     * Destructor
     */
    inline virtual  ~PoweredUpdate();

    /**
     * Assignment operator
     */
    inline PoweredUpdate& operator = (const PoweredUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PoweredUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PoweredUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PoweredUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PoweredUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Powered"

    static const int kPowered = 0;

    /**
     * Clears the field "Powered".
     *
     * The field will be set to its default value. The hasPowered()
     * method will return false.
     */
    inline void clearPowered();

    /**
     * Checks whether the field "Powered" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPowered()). Otherwise it will return false.
     */
    inline bool hasPowered () const;

    /**
     * Returns the value of the member "Powered".
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Powered"
     */
    inline bool getPowered () const;

    /**
     * Sets the value of the member "Powered".
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param Powered The value which will be set
     */
    inline void setPowered (bool Powered_);

    static const PoweredUpdate &getDefaultInstance();

private:

    inline void set_has_Powered ();

    inline void clear_has_Powered ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Powered;

};

/**
 * If the meaning of "PoweredRegister" isn't clear, then there should be a description here.
 */
class PoweredRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PoweredRegister ();

    /**
     * Copy constructor
     */
    inline  PoweredRegister (const PoweredRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PoweredRegister();

    /**
     * Assignment operator
     */
    inline PoweredRegister& operator = (const PoweredRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PoweredRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PoweredRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PoweredRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PoweredRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PoweredRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "DiscoverableUpdate" isn't clear, then there should be a description here.
 */
class DiscoverableUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiscoverableUpdate ();

    /**
     * Copy constructor
     */
    inline  DiscoverableUpdate (const DiscoverableUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DiscoverableUpdate (bool Discoverable_);

    /**
     * Destructor
     */
    inline virtual  ~DiscoverableUpdate();

    /**
     * Assignment operator
     */
    inline DiscoverableUpdate& operator = (const DiscoverableUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiscoverableUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiscoverableUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiscoverableUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiscoverableUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Discoverable"

    static const int kDiscoverable = 0;

    /**
     * Clears the field "Discoverable".
     *
     * The field will be set to its default value. The hasDiscoverable()
     * method will return false.
     */
    inline void clearDiscoverable();

    /**
     * Checks whether the field "Discoverable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDiscoverable()). Otherwise it will return false.
     */
    inline bool hasDiscoverable () const;

    /**
     * Returns the value of the member "Discoverable".
     *
     * If the meaning of "Discoverable" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Discoverable"
     */
    inline bool getDiscoverable () const;

    /**
     * Sets the value of the member "Discoverable".
     *
     * If the meaning of "Discoverable" isn't clear, then there should be a description here.
     *
     * @param Discoverable The value which will be set
     */
    inline void setDiscoverable (bool Discoverable_);

    static const DiscoverableUpdate &getDefaultInstance();

private:

    inline void set_has_Discoverable ();

    inline void clear_has_Discoverable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Discoverable;

};

/**
 * If the meaning of "DiscoverableRegister" isn't clear, then there should be a description here.
 */
class DiscoverableRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiscoverableRegister ();

    /**
     * Copy constructor
     */
    inline  DiscoverableRegister (const DiscoverableRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DiscoverableRegister();

    /**
     * Assignment operator
     */
    inline DiscoverableRegister& operator = (const DiscoverableRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiscoverableRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiscoverableRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiscoverableRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiscoverableRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DiscoverableRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "DiscoverableTimeoutUpdate" isn't clear, then there should be a description here.
 */
class DiscoverableTimeoutUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiscoverableTimeoutUpdate ();

    /**
     * Copy constructor
     */
    inline  DiscoverableTimeoutUpdate (const DiscoverableTimeoutUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DiscoverableTimeoutUpdate (uint32 DiscoverableTimeout_);

    /**
     * Destructor
     */
    inline virtual  ~DiscoverableTimeoutUpdate();

    /**
     * Assignment operator
     */
    inline DiscoverableTimeoutUpdate& operator = (const DiscoverableTimeoutUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiscoverableTimeoutUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiscoverableTimeoutUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiscoverableTimeoutUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiscoverableTimeoutUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DiscoverableTimeout"

    static const int kDiscoverableTimeout = 0;

    /**
     * Clears the field "DiscoverableTimeout".
     *
     * The field will be set to its default value. The hasDiscoverableTimeout()
     * method will return false.
     */
    inline void clearDiscoverableTimeout();

    /**
     * Checks whether the field "DiscoverableTimeout" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDiscoverableTimeout()). Otherwise it will return false.
     */
    inline bool hasDiscoverableTimeout () const;

    /**
     * Returns the value of the member "DiscoverableTimeout".
     *
     * If the meaning of "DiscoverableTimeout" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DiscoverableTimeout"
     */
    inline uint32 getDiscoverableTimeout () const;

    /**
     * Sets the value of the member "DiscoverableTimeout".
     *
     * If the meaning of "DiscoverableTimeout" isn't clear, then there should be a description here.
     *
     * @param DiscoverableTimeout The value which will be set
     */
    inline void setDiscoverableTimeout (uint32 DiscoverableTimeout_);

    static const DiscoverableTimeoutUpdate &getDefaultInstance();

private:

    inline void set_has_DiscoverableTimeout ();

    inline void clear_has_DiscoverableTimeout ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _DiscoverableTimeout;

};

/**
 * If the meaning of "DiscoverableTimeoutRegister" isn't clear, then there should be a description here.
 */
class DiscoverableTimeoutRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiscoverableTimeoutRegister ();

    /**
     * Copy constructor
     */
    inline  DiscoverableTimeoutRegister (const DiscoverableTimeoutRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DiscoverableTimeoutRegister();

    /**
     * Assignment operator
     */
    inline DiscoverableTimeoutRegister& operator = (const DiscoverableTimeoutRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiscoverableTimeoutRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiscoverableTimeoutRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiscoverableTimeoutRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiscoverableTimeoutRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DiscoverableTimeoutRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PairableUpdate" isn't clear, then there should be a description here.
 */
class PairableUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PairableUpdate ();

    /**
     * Copy constructor
     */
    inline  PairableUpdate (const PairableUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PairableUpdate (bool Pairable_);

    /**
     * Destructor
     */
    inline virtual  ~PairableUpdate();

    /**
     * Assignment operator
     */
    inline PairableUpdate& operator = (const PairableUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairableUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairableUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairableUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairableUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Pairable"

    static const int kPairable = 0;

    /**
     * Clears the field "Pairable".
     *
     * The field will be set to its default value. The hasPairable()
     * method will return false.
     */
    inline void clearPairable();

    /**
     * Checks whether the field "Pairable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPairable()). Otherwise it will return false.
     */
    inline bool hasPairable () const;

    /**
     * Returns the value of the member "Pairable".
     *
     * If the meaning of "Pairable" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Pairable"
     */
    inline bool getPairable () const;

    /**
     * Sets the value of the member "Pairable".
     *
     * If the meaning of "Pairable" isn't clear, then there should be a description here.
     *
     * @param Pairable The value which will be set
     */
    inline void setPairable (bool Pairable_);

    static const PairableUpdate &getDefaultInstance();

private:

    inline void set_has_Pairable ();

    inline void clear_has_Pairable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Pairable;

};

/**
 * If the meaning of "PairableRegister" isn't clear, then there should be a description here.
 */
class PairableRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PairableRegister ();

    /**
     * Copy constructor
     */
    inline  PairableRegister (const PairableRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PairableRegister();

    /**
     * Assignment operator
     */
    inline PairableRegister& operator = (const PairableRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairableRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairableRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairableRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairableRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PairableRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PairableTimeoutUpdate" isn't clear, then there should be a description here.
 */
class PairableTimeoutUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PairableTimeoutUpdate ();

    /**
     * Copy constructor
     */
    inline  PairableTimeoutUpdate (const PairableTimeoutUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PairableTimeoutUpdate (uint32 PairableTimeout_);

    /**
     * Destructor
     */
    inline virtual  ~PairableTimeoutUpdate();

    /**
     * Assignment operator
     */
    inline PairableTimeoutUpdate& operator = (const PairableTimeoutUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairableTimeoutUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairableTimeoutUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairableTimeoutUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairableTimeoutUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PairableTimeout"

    static const int kPairableTimeout = 0;

    /**
     * Clears the field "PairableTimeout".
     *
     * The field will be set to its default value. The hasPairableTimeout()
     * method will return false.
     */
    inline void clearPairableTimeout();

    /**
     * Checks whether the field "PairableTimeout" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPairableTimeout()). Otherwise it will return false.
     */
    inline bool hasPairableTimeout () const;

    /**
     * Returns the value of the member "PairableTimeout".
     *
     * If the meaning of "PairableTimeout" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PairableTimeout"
     */
    inline uint32 getPairableTimeout () const;

    /**
     * Sets the value of the member "PairableTimeout".
     *
     * If the meaning of "PairableTimeout" isn't clear, then there should be a description here.
     *
     * @param PairableTimeout The value which will be set
     */
    inline void setPairableTimeout (uint32 PairableTimeout_);

    static const PairableTimeoutUpdate &getDefaultInstance();

private:

    inline void set_has_PairableTimeout ();

    inline void clear_has_PairableTimeout ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _PairableTimeout;

};

/**
 * If the meaning of "PairableTimeoutRegister" isn't clear, then there should be a description here.
 */
class PairableTimeoutRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PairableTimeoutRegister ();

    /**
     * Copy constructor
     */
    inline  PairableTimeoutRegister (const PairableTimeoutRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PairableTimeoutRegister();

    /**
     * Assignment operator
     */
    inline PairableTimeoutRegister& operator = (const PairableTimeoutRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairableTimeoutRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairableTimeoutRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairableTimeoutRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairableTimeoutRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PairableTimeoutRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "DiscoveringUpdate" isn't clear, then there should be a description here.
 */
class DiscoveringUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiscoveringUpdate ();

    /**
     * Copy constructor
     */
    inline  DiscoveringUpdate (const DiscoveringUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DiscoveringUpdate (bool Discovering_);

    /**
     * Destructor
     */
    inline virtual  ~DiscoveringUpdate();

    /**
     * Assignment operator
     */
    inline DiscoveringUpdate& operator = (const DiscoveringUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiscoveringUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiscoveringUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiscoveringUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiscoveringUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Discovering"

    static const int kDiscovering = 0;

    /**
     * Clears the field "Discovering".
     *
     * The field will be set to its default value. The hasDiscovering()
     * method will return false.
     */
    inline void clearDiscovering();

    /**
     * Checks whether the field "Discovering" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDiscovering()). Otherwise it will return false.
     */
    inline bool hasDiscovering () const;

    /**
     * Returns the value of the member "Discovering".
     *
     * If the meaning of "Discovering" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Discovering"
     */
    inline bool getDiscovering () const;

    /**
     * Sets the value of the member "Discovering".
     *
     * If the meaning of "Discovering" isn't clear, then there should be a description here.
     *
     * @param Discovering The value which will be set
     */
    inline void setDiscovering (bool Discovering_);

    static const DiscoveringUpdate &getDefaultInstance();

private:

    inline void set_has_Discovering ();

    inline void clear_has_Discovering ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Discovering;

};

/**
 * If the meaning of "DiscoveringRegister" isn't clear, then there should be a description here.
 */
class DiscoveringRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiscoveringRegister ();

    /**
     * Copy constructor
     */
    inline  DiscoveringRegister (const DiscoveringRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DiscoveringRegister();

    /**
     * Assignment operator
     */
    inline DiscoveringRegister& operator = (const DiscoveringRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiscoveringRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiscoveringRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiscoveringRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiscoveringRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DiscoveringRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "UUIDsUpdate" isn't clear, then there should be a description here.
 */
class UUIDsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UUIDsUpdate ();

    /**
     * Copy constructor
     */
    inline  UUIDsUpdate (const UUIDsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UUIDsUpdate (const ::std::vector< ::std::string >& UUIDs_);

    /**
     * Destructor
     */
    inline virtual  ~UUIDsUpdate();

    /**
     * Assignment operator
     */
    inline UUIDsUpdate& operator = (const UUIDsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UUIDsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UUIDsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UUIDsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UUIDsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UUIDs"

    static const int kUUIDs = 0;

    /**
     * Clears the field "UUIDs".
     *
     * The field will be set to its default value. The hasUUIDs()
     * method will return false.
     */
    inline void clearUUIDs();

    /**
     * Checks whether the field "UUIDs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUUIDs()). Otherwise it will return false.
     */
    inline bool hasUUIDs () const;

    /**
     * Returns the value of the member "UUIDs".
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     *
     * @return The value of the field "UUIDs"
     */
    inline const ::std::vector< ::std::string >& getUUIDs () const;

    /**
     * Retrieves the value of the field "UUIDs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UUIDs".
     */
    inline ::std::vector< ::std::string >& getUUIDsMutable ();

    /**
     * Sets the value of the member "UUIDs".
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     *
     * @param UUIDs The value which will be set
     */
    inline void setUUIDs (const ::std::vector< ::std::string >& UUIDs_);

    static const UUIDsUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_UUIDs ();

    inline void clear_has_UUIDs ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _UUIDs;

};

/**
 * If the meaning of "UUIDsRegister" isn't clear, then there should be a description here.
 */
class UUIDsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UUIDsRegister ();

    /**
     * Copy constructor
     */
    inline  UUIDsRegister (const UUIDsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UUIDsRegister();

    /**
     * Assignment operator
     */
    inline UUIDsRegister& operator = (const UUIDsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UUIDsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UUIDsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UUIDsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UUIDsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UUIDsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "WBSModeUpdate" isn't clear, then there should be a description here.
 */
class WBSModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WBSModeUpdate ();

    /**
     * Copy constructor
     */
    inline  WBSModeUpdate (const WBSModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  WBSModeUpdate (bool WBSMode_);

    /**
     * Destructor
     */
    inline virtual  ~WBSModeUpdate();

    /**
     * Assignment operator
     */
    inline WBSModeUpdate& operator = (const WBSModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WBSModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WBSModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WBSModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WBSModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WBSMode"

    static const int kWBSMode = 0;

    /**
     * Clears the field "WBSMode".
     *
     * The field will be set to its default value. The hasWBSMode()
     * method will return false.
     */
    inline void clearWBSMode();

    /**
     * Checks whether the field "WBSMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWBSMode()). Otherwise it will return false.
     */
    inline bool hasWBSMode () const;

    /**
     * Returns the value of the member "WBSMode".
     *
     * If the meaning of "WBSMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WBSMode"
     */
    inline bool getWBSMode () const;

    /**
     * Sets the value of the member "WBSMode".
     *
     * If the meaning of "WBSMode" isn't clear, then there should be a description here.
     *
     * @param WBSMode The value which will be set
     */
    inline void setWBSMode (bool WBSMode_);

    static const WBSModeUpdate &getDefaultInstance();

private:

    inline void set_has_WBSMode ();

    inline void clear_has_WBSMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _WBSMode;

};

/**
 * If the meaning of "WBSModeRegister" isn't clear, then there should be a description here.
 */
class WBSModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WBSModeRegister ();

    /**
     * Copy constructor
     */
    inline  WBSModeRegister (const WBSModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~WBSModeRegister();

    /**
     * Assignment operator
     */
    inline WBSModeRegister& operator = (const WBSModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WBSModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WBSModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WBSModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WBSModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const WBSModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ConnectableUpdate" isn't clear, then there should be a description here.
 */
class ConnectableUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectableUpdate ();

    /**
     * Copy constructor
     */
    inline  ConnectableUpdate (const ConnectableUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectableUpdate (bool Connectable_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectableUpdate();

    /**
     * Assignment operator
     */
    inline ConnectableUpdate& operator = (const ConnectableUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectableUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectableUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectableUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectableUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Connectable"

    static const int kConnectable = 0;

    /**
     * Clears the field "Connectable".
     *
     * The field will be set to its default value. The hasConnectable()
     * method will return false.
     */
    inline void clearConnectable();

    /**
     * Checks whether the field "Connectable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectable()). Otherwise it will return false.
     */
    inline bool hasConnectable () const;

    /**
     * Returns the value of the member "Connectable".
     *
     * If the meaning of "Connectable" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Connectable"
     */
    inline bool getConnectable () const;

    /**
     * Sets the value of the member "Connectable".
     *
     * If the meaning of "Connectable" isn't clear, then there should be a description here.
     *
     * @param Connectable The value which will be set
     */
    inline void setConnectable (bool Connectable_);

    static const ConnectableUpdate &getDefaultInstance();

private:

    inline void set_has_Connectable ();

    inline void clear_has_Connectable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Connectable;

};

/**
 * If the meaning of "ConnectableRegister" isn't clear, then there should be a description here.
 */
class ConnectableRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectableRegister ();

    /**
     * Copy constructor
     */
    inline  ConnectableRegister (const ConnectableRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConnectableRegister();

    /**
     * Assignment operator
     */
    inline ConnectableRegister& operator = (const ConnectableRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectableRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectableRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectableRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectableRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConnectableRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "HCIModeUpdate" isn't clear, then there should be a description here.
 */
class HCIModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HCIModeUpdate ();

    /**
     * Copy constructor
     */
    inline  HCIModeUpdate (const HCIModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  HCIModeUpdate (bool HCIMode_);

    /**
     * Destructor
     */
    inline virtual  ~HCIModeUpdate();

    /**
     * Assignment operator
     */
    inline HCIModeUpdate& operator = (const HCIModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HCIModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HCIModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HCIModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HCIModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "HCIMode"

    static const int kHCIMode = 0;

    /**
     * Clears the field "HCIMode".
     *
     * The field will be set to its default value. The hasHCIMode()
     * method will return false.
     */
    inline void clearHCIMode();

    /**
     * Checks whether the field "HCIMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHCIMode()). Otherwise it will return false.
     */
    inline bool hasHCIMode () const;

    /**
     * Returns the value of the member "HCIMode".
     *
     * If the meaning of "HCIMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HCIMode"
     */
    inline bool getHCIMode () const;

    /**
     * Sets the value of the member "HCIMode".
     *
     * If the meaning of "HCIMode" isn't clear, then there should be a description here.
     *
     * @param HCIMode The value which will be set
     */
    inline void setHCIMode (bool HCIMode_);

    static const HCIModeUpdate &getDefaultInstance();

private:

    inline void set_has_HCIMode ();

    inline void clear_has_HCIMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _HCIMode;

};

/**
 * If the meaning of "HCIModeRegister" isn't clear, then there should be a description here.
 */
class HCIModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HCIModeRegister ();

    /**
     * Copy constructor
     */
    inline  HCIModeRegister (const HCIModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~HCIModeRegister();

    /**
     * Assignment operator
     */
    inline HCIModeRegister& operator = (const HCIModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HCIModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HCIModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HCIModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HCIModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const HCIModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "VersionUpdate" isn't clear, then there should be a description here.
 */
class VersionUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VersionUpdate ();

    /**
     * Copy constructor
     */
    inline  VersionUpdate (const VersionUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VersionUpdate (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& Version_);

    /**
     * Destructor
     */
    inline virtual  ~VersionUpdate();

    /**
     * Assignment operator
     */
    inline VersionUpdate& operator = (const VersionUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VersionUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VersionUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VersionUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VersionUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Version"

    static const int kVersion = 0;

    /**
     * Clears the field "Version".
     *
     * The field will be set to its default value. The hasVersion()
     * method will return false.
     */
    inline void clearVersion();

    /**
     * Checks whether the field "Version" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersion()). Otherwise it will return false.
     */
    inline bool hasVersion () const;

    /**
     * Returns the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Version"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getVersion () const;

    /**
     * Retrieves the value of the field "Version" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Version".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getVersionMutable ();

    /**
     * Sets the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& Version_);

    static const VersionUpdate &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_Version ();

    inline void clear_has_Version ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _Version;

};

/**
 * If the meaning of "VersionRegister" isn't clear, then there should be a description here.
 */
class VersionRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VersionRegister ();

    /**
     * Copy constructor
     */
    inline  VersionRegister (const VersionRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VersionRegister();

    /**
     * Assignment operator
     */
    inline VersionRegister& operator = (const VersionRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VersionRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VersionRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VersionRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VersionRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VersionRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "TraceLevelUpdate" isn't clear, then there should be a description here.
 */
class TraceLevelUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TraceLevelUpdate ();

    /**
     * Copy constructor
     */
    inline  TraceLevelUpdate (const TraceLevelUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TraceLevelUpdate (const ::std::vector< ::std::string >& TraceLevel_);

    /**
     * Destructor
     */
    inline virtual  ~TraceLevelUpdate();

    /**
     * Assignment operator
     */
    inline TraceLevelUpdate& operator = (const TraceLevelUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TraceLevelUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TraceLevelUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TraceLevelUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TraceLevelUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TraceLevel"

    static const int kTraceLevel = 0;

    /**
     * Clears the field "TraceLevel".
     *
     * The field will be set to its default value. The hasTraceLevel()
     * method will return false.
     */
    inline void clearTraceLevel();

    /**
     * Checks whether the field "TraceLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTraceLevel()). Otherwise it will return false.
     */
    inline bool hasTraceLevel () const;

    /**
     * Returns the value of the member "TraceLevel".
     *
     * If the meaning of "TraceLevel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TraceLevel"
     */
    inline const ::std::vector< ::std::string >& getTraceLevel () const;

    /**
     * Retrieves the value of the field "TraceLevel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TraceLevel".
     */
    inline ::std::vector< ::std::string >& getTraceLevelMutable ();

    /**
     * Sets the value of the member "TraceLevel".
     *
     * If the meaning of "TraceLevel" isn't clear, then there should be a description here.
     *
     * @param TraceLevel The value which will be set
     */
    inline void setTraceLevel (const ::std::vector< ::std::string >& TraceLevel_);

    static const TraceLevelUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_TraceLevel ();

    inline void clear_has_TraceLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _TraceLevel;

};

/**
 * If the meaning of "TraceLevelRegister" isn't clear, then there should be a description here.
 */
class TraceLevelRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TraceLevelRegister ();

    /**
     * Copy constructor
     */
    inline  TraceLevelRegister (const TraceLevelRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TraceLevelRegister();

    /**
     * Assignment operator
     */
    inline TraceLevelRegister& operator = (const TraceLevelRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TraceLevelRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TraceLevelRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TraceLevelRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TraceLevelRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TraceLevelRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "TraceCategoryUpdate" isn't clear, then there should be a description here.
 */
class TraceCategoryUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TraceCategoryUpdate ();

    /**
     * Copy constructor
     */
    inline  TraceCategoryUpdate (const TraceCategoryUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TraceCategoryUpdate (const ::std::vector< ::std::string >& TraceCategory_);

    /**
     * Destructor
     */
    inline virtual  ~TraceCategoryUpdate();

    /**
     * Assignment operator
     */
    inline TraceCategoryUpdate& operator = (const TraceCategoryUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TraceCategoryUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TraceCategoryUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TraceCategoryUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TraceCategoryUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TraceCategory"

    static const int kTraceCategory = 0;

    /**
     * Clears the field "TraceCategory".
     *
     * The field will be set to its default value. The hasTraceCategory()
     * method will return false.
     */
    inline void clearTraceCategory();

    /**
     * Checks whether the field "TraceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTraceCategory()). Otherwise it will return false.
     */
    inline bool hasTraceCategory () const;

    /**
     * Returns the value of the member "TraceCategory".
     *
     * If the meaning of "TraceCategory" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TraceCategory"
     */
    inline const ::std::vector< ::std::string >& getTraceCategory () const;

    /**
     * Retrieves the value of the field "TraceCategory" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TraceCategory".
     */
    inline ::std::vector< ::std::string >& getTraceCategoryMutable ();

    /**
     * Sets the value of the member "TraceCategory".
     *
     * If the meaning of "TraceCategory" isn't clear, then there should be a description here.
     *
     * @param TraceCategory The value which will be set
     */
    inline void setTraceCategory (const ::std::vector< ::std::string >& TraceCategory_);

    static const TraceCategoryUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_TraceCategory ();

    inline void clear_has_TraceCategory ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _TraceCategory;

};

/**
 * If the meaning of "TraceCategoryRegister" isn't clear, then there should be a description here.
 */
class TraceCategoryRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TraceCategoryRegister ();

    /**
     * Copy constructor
     */
    inline  TraceCategoryRegister (const TraceCategoryRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TraceCategoryRegister();

    /**
     * Assignment operator
     */
    inline TraceCategoryRegister& operator = (const TraceCategoryRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TraceCategoryRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TraceCategoryRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TraceCategoryRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TraceCategoryRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TraceCategoryRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AvailableSPPServersUpdate" isn't clear, then there should be a description here.
 */
class AvailableSPPServersUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AvailableSPPServersUpdate ();

    /**
     * Copy constructor
     */
    inline  AvailableSPPServersUpdate (const AvailableSPPServersUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AvailableSPPServersUpdate (const ::std::vector< ::std::string >& AvailableSPPServers_);

    /**
     * Destructor
     */
    inline virtual  ~AvailableSPPServersUpdate();

    /**
     * Assignment operator
     */
    inline AvailableSPPServersUpdate& operator = (const AvailableSPPServersUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AvailableSPPServersUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AvailableSPPServersUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AvailableSPPServersUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AvailableSPPServersUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AvailableSPPServers"

    static const int kAvailableSPPServers = 0;

    /**
     * Clears the field "AvailableSPPServers".
     *
     * The field will be set to its default value. The hasAvailableSPPServers()
     * method will return false.
     */
    inline void clearAvailableSPPServers();

    /**
     * Checks whether the field "AvailableSPPServers" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailableSPPServers()). Otherwise it will return false.
     */
    inline bool hasAvailableSPPServers () const;

    /**
     * Returns the value of the member "AvailableSPPServers".
     *
     * If the meaning of "AvailableSPPServers" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AvailableSPPServers"
     */
    inline const ::std::vector< ::std::string >& getAvailableSPPServers () const;

    /**
     * Retrieves the value of the field "AvailableSPPServers" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AvailableSPPServers".
     */
    inline ::std::vector< ::std::string >& getAvailableSPPServersMutable ();

    /**
     * Sets the value of the member "AvailableSPPServers".
     *
     * If the meaning of "AvailableSPPServers" isn't clear, then there should be a description here.
     *
     * @param AvailableSPPServers The value which will be set
     */
    inline void setAvailableSPPServers (const ::std::vector< ::std::string >& AvailableSPPServers_);

    static const AvailableSPPServersUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_AvailableSPPServers ();

    inline void clear_has_AvailableSPPServers ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _AvailableSPPServers;

};

/**
 * If the meaning of "AvailableSPPServersRegister" isn't clear, then there should be a description here.
 */
class AvailableSPPServersRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AvailableSPPServersRegister ();

    /**
     * Copy constructor
     */
    inline  AvailableSPPServersRegister (const AvailableSPPServersRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AvailableSPPServersRegister();

    /**
     * Assignment operator
     */
    inline AvailableSPPServersRegister& operator = (const AvailableSPPServersRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AvailableSPPServersRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AvailableSPPServersRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AvailableSPPServersRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AvailableSPPServersRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AvailableSPPServersRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "DeviceCreatedSignal" isn't clear, then there should be a description here.
 */
class DeviceCreatedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceCreatedSignal ();

    /**
     * Copy constructor
     */
    inline  DeviceCreatedSignal (const DeviceCreatedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceCreatedSignal (const ::std::string& device_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceCreatedSignal();

    /**
     * Assignment operator
     */
    inline DeviceCreatedSignal& operator = (const DeviceCreatedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceCreatedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceCreatedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceCreatedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceCreatedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const DeviceCreatedSignal &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _device;

};

/**
 * If the meaning of "DeviceRemovedSignal" isn't clear, then there should be a description here.
 */
class DeviceRemovedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceRemovedSignal ();

    /**
     * Copy constructor
     */
    inline  DeviceRemovedSignal (const DeviceRemovedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceRemovedSignal (const ::std::string& device_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceRemovedSignal();

    /**
     * Assignment operator
     */
    inline DeviceRemovedSignal& operator = (const DeviceRemovedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceRemovedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceRemovedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceRemovedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceRemovedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const DeviceRemovedSignal &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _device;

};

/**
 * If the meaning of "BtStackLogSignal" isn't clear, then there should be a description here.
 */
class BtStackLogSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtStackLogSignal ();

    /**
     * Copy constructor
     */
    inline  BtStackLogSignal (const BtStackLogSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtStackLogSignal (uint8 status_, uint16 opcode_, const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~BtStackLogSignal();

    /**
     * Assignment operator
     */
    inline BtStackLogSignal& operator = (const BtStackLogSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtStackLogSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtStackLogSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtStackLogSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtStackLogSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    // API of field "opcode"

    static const int kOpcode = 1;

    /**
     * Clears the field "opcode".
     *
     * The field will be set to its default value. The hasOpcode()
     * method will return false.
     */
    inline void clearOpcode();

    /**
     * Checks whether the field "opcode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOpcode()). Otherwise it will return false.
     */
    inline bool hasOpcode () const;

    /**
     * Returns the value of the member "opcode".
     *
     * If the meaning of "opcode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "opcode"
     */
    inline uint16 getOpcode () const;

    /**
     * Sets the value of the member "opcode".
     *
     * If the meaning of "opcode" isn't clear, then there should be a description here.
     *
     * @param opcode The value which will be set
     */
    inline void setOpcode (uint16 opcode_);

    // API of field "data"

    static const int kData = 2;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const BtStackLogSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_opcode ();

    inline void clear_has_opcode ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _status;

    uint16 _opcode;

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "HCIEventSignal" isn't clear, then there should be a description here.
 */
class HCIEventSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HCIEventSignal ();

    /**
     * Copy constructor
     */
    inline  HCIEventSignal (const HCIEventSignal &rhs);

    /**
     * All fields constructor
     */
    inline  HCIEventSignal (const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~HCIEventSignal();

    /**
     * Assignment operator
     */
    inline HCIEventSignal& operator = (const HCIEventSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HCIEventSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HCIEventSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HCIEventSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HCIEventSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const HCIEventSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "DeviceFoundSignal" isn't clear, then there should be a description here.
 */
class DeviceFoundSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceFoundSignal ();

    /**
     * Copy constructor
     */
    inline  DeviceFoundSignal (const DeviceFoundSignal &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceFoundSignal (const ::std::string& address_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& values_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceFoundSignal();

    /**
     * Assignment operator
     */
    inline DeviceFoundSignal& operator = (const DeviceFoundSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceFoundSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceFoundSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceFoundSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceFoundSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "address"

    static const int kAddress = 0;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::string& address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    // API of field "values"

    static const int kValues = 1;

    /**
     * Clears the field "values".
     *
     * The field will be set to its default value. The hasValues()
     * method will return false.
     */
    inline void clearValues();

    /**
     * Checks whether the field "values" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValues()). Otherwise it will return false.
     */
    inline bool hasValues () const;

    /**
     * Returns the value of the member "values".
     *
     * If the meaning of "values" isn't clear, then there should be a description here.
     *
     * @return The value of the field "values"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getValues () const;

    /**
     * Retrieves the value of the field "values" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "values".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getValuesMutable ();

    /**
     * Sets the value of the member "values".
     *
     * If the meaning of "values" isn't clear, then there should be a description here.
     *
     * @param values The value which will be set
     */
    inline void setValues (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& values_);

    static const DeviceFoundSignal &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_address ();

    inline void clear_has_address ();

    inline void set_has_values ();

    inline void clear_has_values ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _address;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _values;

};

inline  RemoveDeviceRequest::RemoveDeviceRequest ()  :
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveDeviceRequest::RemoveDeviceRequest (const RemoveDeviceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveDeviceRequest::RemoveDeviceRequest (const ::std::string& device_)  :
    _device (device_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveDeviceRequest::~RemoveDeviceRequest() {
}

inline RemoveDeviceRequest& RemoveDeviceRequest::operator = (const RemoveDeviceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool RemoveDeviceRequest::operator == (const RemoveDeviceRequest& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool RemoveDeviceRequest::operator != (const RemoveDeviceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveDeviceRequest::operator < (const RemoveDeviceRequest& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveDeviceRequest::clone() {
    return new RemoveDeviceRequest(*this);
}

inline bool RemoveDeviceRequest::operator > (const RemoveDeviceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveDeviceRequest::clear() {
    clearDevice();
}

inline void RemoveDeviceRequest::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool RemoveDeviceRequest::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemoveDeviceRequest::getDevice () const {
    return _device;
}

inline ::std::string& RemoveDeviceRequest::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void RemoveDeviceRequest::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void RemoveDeviceRequest::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void RemoveDeviceRequest::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void RemoveDeviceRequest::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveDeviceRequest::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CreateDeviceRequest::CreateDeviceRequest ()  :
    _address ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CreateDeviceRequest::CreateDeviceRequest (const CreateDeviceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _address ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CreateDeviceRequest::CreateDeviceRequest (const ::std::string& address_)  :
    _address (address_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CreateDeviceRequest::~CreateDeviceRequest() {
}

inline CreateDeviceRequest& CreateDeviceRequest::operator = (const CreateDeviceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
    }
    return *this;
}

inline bool CreateDeviceRequest::operator == (const CreateDeviceRequest& rhs) const {
    return (((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()));
}

inline bool CreateDeviceRequest::operator != (const CreateDeviceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool CreateDeviceRequest::operator < (const CreateDeviceRequest& rhs) const {
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CreateDeviceRequest::clone() {
    return new CreateDeviceRequest(*this);
}

inline bool CreateDeviceRequest::operator > (const CreateDeviceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CreateDeviceRequest::clear() {
    clearAddress();
}

inline void CreateDeviceRequest::clearAddress() {
    if (hasAddress()) {
         clear_has_address();
        _address.clear();
     }
}

inline bool CreateDeviceRequest::hasAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CreateDeviceRequest::getAddress () const {
    return _address;
}

inline ::std::string& CreateDeviceRequest::getAddressMutable () {
    set_has_address();
    return _address;
}

inline void CreateDeviceRequest::setAddress (const ::std::string& address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address = address_;
}

inline void CreateDeviceRequest::setAddress (const char* address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(address_);
}

inline void CreateDeviceRequest::setAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(value, size);
}

inline void CreateDeviceRequest::set_has_address () {
    _has_bits_[0] |= 1u << 0;
}

inline void CreateDeviceRequest::clear_has_address () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CreateDeviceResponse::CreateDeviceResponse ()  :
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CreateDeviceResponse::CreateDeviceResponse (const CreateDeviceResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CreateDeviceResponse::CreateDeviceResponse (const ::std::string& device_)  :
    _device (device_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CreateDeviceResponse::~CreateDeviceResponse() {
}

inline CreateDeviceResponse& CreateDeviceResponse::operator = (const CreateDeviceResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool CreateDeviceResponse::operator == (const CreateDeviceResponse& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool CreateDeviceResponse::operator != (const CreateDeviceResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool CreateDeviceResponse::operator < (const CreateDeviceResponse& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CreateDeviceResponse::clone() {
    return new CreateDeviceResponse(*this);
}

inline bool CreateDeviceResponse::operator > (const CreateDeviceResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CreateDeviceResponse::clear() {
    clearDevice();
}

inline void CreateDeviceResponse::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool CreateDeviceResponse::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CreateDeviceResponse::getDevice () const {
    return _device;
}

inline ::std::string& CreateDeviceResponse::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void CreateDeviceResponse::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void CreateDeviceResponse::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void CreateDeviceResponse::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void CreateDeviceResponse::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void CreateDeviceResponse::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SendHCICmdRequest::SendHCICmdRequest ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendHCICmdRequest::SendHCICmdRequest (const SendHCICmdRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendHCICmdRequest::SendHCICmdRequest (const ::std::vector< uint8 >& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendHCICmdRequest::~SendHCICmdRequest() {
}

inline SendHCICmdRequest& SendHCICmdRequest::operator = (const SendHCICmdRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SendHCICmdRequest::operator == (const SendHCICmdRequest& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SendHCICmdRequest::operator != (const SendHCICmdRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SendHCICmdRequest::operator < (const SendHCICmdRequest& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SendHCICmdRequest::clone() {
    return new SendHCICmdRequest(*this);
}

inline bool SendHCICmdRequest::operator > (const SendHCICmdRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendHCICmdRequest::clear() {
    clearData();
}

inline void SendHCICmdRequest::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool SendHCICmdRequest::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& SendHCICmdRequest::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& SendHCICmdRequest::getDataMutable () {
    set_has_data();
    return _data;
}

inline void SendHCICmdRequest::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void SendHCICmdRequest::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendHCICmdRequest::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddressUpdate::AddressUpdate ()  :
    _Address ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddressUpdate::AddressUpdate (const AddressUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Address ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddressUpdate::AddressUpdate (const ::std::string& Address_)  :
    _Address (Address_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddressUpdate::~AddressUpdate() {
}

inline AddressUpdate& AddressUpdate::operator = (const AddressUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
    }
    return *this;
}

inline bool AddressUpdate::operator == (const AddressUpdate& rhs) const {
    return (((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()));
}

inline bool AddressUpdate::operator != (const AddressUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AddressUpdate::operator < (const AddressUpdate& rhs) const {
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddressUpdate::clone() {
    return new AddressUpdate(*this);
}

inline bool AddressUpdate::operator > (const AddressUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddressUpdate::clear() {
    clearAddress();
}

inline void AddressUpdate::clearAddress() {
    if (hasAddress()) {
         clear_has_Address();
        _Address.clear();
     }
}

inline bool AddressUpdate::hasAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AddressUpdate::getAddress () const {
    return _Address;
}

inline ::std::string& AddressUpdate::getAddressMutable () {
    set_has_Address();
    return _Address;
}

inline void AddressUpdate::setAddress (const ::std::string& Address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Address();
    this->_Address = Address_;
}

inline void AddressUpdate::setAddress (const char* Address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Address();
    this->_Address.assign(Address_);
}

inline void AddressUpdate::setAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Address();
    this->_Address.assign(value, size);
}

inline void AddressUpdate::set_has_Address () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddressUpdate::clear_has_Address () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddressRegister::AddressRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddressRegister::AddressRegister (const AddressRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddressRegister::~AddressRegister() {
}

inline AddressRegister& AddressRegister::operator = (const AddressRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AddressRegister::operator == (const AddressRegister& ) const {
    return true;
}

inline bool AddressRegister::operator != (const AddressRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AddressRegister::operator < (const AddressRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AddressRegister::clone() {
    return new AddressRegister(*this);
}

inline bool AddressRegister::operator > (const AddressRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddressRegister::clear() {
}

inline  ClassUpdate::ClassUpdate ()  :
    _Class (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClassUpdate::ClassUpdate (const ClassUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Class (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClassUpdate::ClassUpdate (uint32 Class_)  :
    _Class (Class_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ClassUpdate::~ClassUpdate() {
}

inline ClassUpdate& ClassUpdate::operator = (const ClassUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClass()) {
            setClass(rhs.getClass());
        } else {
            clearClass();
        }
    }
    return *this;
}

inline bool ClassUpdate::operator == (const ClassUpdate& rhs) const {
    return (((!hasClass() && !rhs.hasClass()) || getClass() == rhs.getClass()));
}

inline bool ClassUpdate::operator != (const ClassUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ClassUpdate::operator < (const ClassUpdate& rhs) const {
    if (hasClass() || rhs.hasClass()) {
        if (getClass() < rhs.getClass()) return true;
        if (getClass() > rhs.getClass()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ClassUpdate::clone() {
    return new ClassUpdate(*this);
}

inline bool ClassUpdate::operator > (const ClassUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClassUpdate::clear() {
    clearClass();
}

inline void ClassUpdate::clearClass() {
    if (hasClass()) {
         clear_has_Class();
        _Class = 0u;
     }
}

inline bool ClassUpdate::hasClass () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ClassUpdate::getClass () const {
    return _Class;
}

inline void ClassUpdate::setClass (uint32 Class_) {
    set_has_Class();
    this->_Class = Class_;
}

inline void ClassUpdate::set_has_Class () {
    _has_bits_[0] |= 1u << 0;
}

inline void ClassUpdate::clear_has_Class () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ClassRegister::ClassRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClassRegister::ClassRegister (const ClassRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClassRegister::~ClassRegister() {
}

inline ClassRegister& ClassRegister::operator = (const ClassRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ClassRegister::operator == (const ClassRegister& ) const {
    return true;
}

inline bool ClassRegister::operator != (const ClassRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ClassRegister::operator < (const ClassRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ClassRegister::clone() {
    return new ClassRegister(*this);
}

inline bool ClassRegister::operator > (const ClassRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClassRegister::clear() {
}

inline  AliasUpdate::AliasUpdate ()  :
    _Alias ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AliasUpdate::AliasUpdate (const AliasUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Alias ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AliasUpdate::AliasUpdate (const ::std::string& Alias_)  :
    _Alias (Alias_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Alias_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AliasUpdate::~AliasUpdate() {
}

inline AliasUpdate& AliasUpdate::operator = (const AliasUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAlias()) {
            setAlias(rhs.getAlias());
        } else {
            clearAlias();
        }
    }
    return *this;
}

inline bool AliasUpdate::operator == (const AliasUpdate& rhs) const {
    return (((!hasAlias() && !rhs.hasAlias()) || getAlias() == rhs.getAlias()));
}

inline bool AliasUpdate::operator != (const AliasUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AliasUpdate::operator < (const AliasUpdate& rhs) const {
    if (hasAlias() || rhs.hasAlias()) {
        if (getAlias() < rhs.getAlias()) return true;
        if (getAlias() > rhs.getAlias()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AliasUpdate::clone() {
    return new AliasUpdate(*this);
}

inline bool AliasUpdate::operator > (const AliasUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AliasUpdate::clear() {
    clearAlias();
}

inline void AliasUpdate::clearAlias() {
    if (hasAlias()) {
         clear_has_Alias();
        _Alias.clear();
     }
}

inline bool AliasUpdate::hasAlias () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AliasUpdate::getAlias () const {
    return _Alias;
}

inline ::std::string& AliasUpdate::getAliasMutable () {
    set_has_Alias();
    return _Alias;
}

inline void AliasUpdate::setAlias (const ::std::string& Alias_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Alias_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Alias();
    this->_Alias = Alias_;
}

inline void AliasUpdate::setAlias (const char* Alias_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Alias_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Alias();
    this->_Alias.assign(Alias_);
}

inline void AliasUpdate::setAlias (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Alias();
    this->_Alias.assign(value, size);
}

inline void AliasUpdate::set_has_Alias () {
    _has_bits_[0] |= 1u << 0;
}

inline void AliasUpdate::clear_has_Alias () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AliasRegister::AliasRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AliasRegister::AliasRegister (const AliasRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AliasRegister::~AliasRegister() {
}

inline AliasRegister& AliasRegister::operator = (const AliasRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AliasRegister::operator == (const AliasRegister& ) const {
    return true;
}

inline bool AliasRegister::operator != (const AliasRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AliasRegister::operator < (const AliasRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AliasRegister::clone() {
    return new AliasRegister(*this);
}

inline bool AliasRegister::operator > (const AliasRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AliasRegister::clear() {
}

inline  PoweredUpdate::PoweredUpdate ()  :
    _Powered (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PoweredUpdate::PoweredUpdate (const PoweredUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Powered (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PoweredUpdate::PoweredUpdate (bool Powered_)  :
    _Powered (Powered_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PoweredUpdate::~PoweredUpdate() {
}

inline PoweredUpdate& PoweredUpdate::operator = (const PoweredUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPowered()) {
            setPowered(rhs.getPowered());
        } else {
            clearPowered();
        }
    }
    return *this;
}

inline bool PoweredUpdate::operator == (const PoweredUpdate& rhs) const {
    return (((!hasPowered() && !rhs.hasPowered()) || getPowered() == rhs.getPowered()));
}

inline bool PoweredUpdate::operator != (const PoweredUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PoweredUpdate::operator < (const PoweredUpdate& rhs) const {
    if (hasPowered() || rhs.hasPowered()) {
        if (getPowered() < rhs.getPowered()) return true;
        if (getPowered() > rhs.getPowered()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PoweredUpdate::clone() {
    return new PoweredUpdate(*this);
}

inline bool PoweredUpdate::operator > (const PoweredUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PoweredUpdate::clear() {
    clearPowered();
}

inline void PoweredUpdate::clearPowered() {
    if (hasPowered()) {
         clear_has_Powered();
        _Powered = false;
     }
}

inline bool PoweredUpdate::hasPowered () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool PoweredUpdate::getPowered () const {
    return _Powered;
}

inline void PoweredUpdate::setPowered (bool Powered_) {
    set_has_Powered();
    this->_Powered = Powered_;
}

inline void PoweredUpdate::set_has_Powered () {
    _has_bits_[0] |= 1u << 0;
}

inline void PoweredUpdate::clear_has_Powered () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PoweredRegister::PoweredRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PoweredRegister::PoweredRegister (const PoweredRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PoweredRegister::~PoweredRegister() {
}

inline PoweredRegister& PoweredRegister::operator = (const PoweredRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PoweredRegister::operator == (const PoweredRegister& ) const {
    return true;
}

inline bool PoweredRegister::operator != (const PoweredRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PoweredRegister::operator < (const PoweredRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PoweredRegister::clone() {
    return new PoweredRegister(*this);
}

inline bool PoweredRegister::operator > (const PoweredRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PoweredRegister::clear() {
}

inline  DiscoverableUpdate::DiscoverableUpdate ()  :
    _Discoverable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiscoverableUpdate::DiscoverableUpdate (const DiscoverableUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Discoverable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiscoverableUpdate::DiscoverableUpdate (bool Discoverable_)  :
    _Discoverable (Discoverable_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiscoverableUpdate::~DiscoverableUpdate() {
}

inline DiscoverableUpdate& DiscoverableUpdate::operator = (const DiscoverableUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDiscoverable()) {
            setDiscoverable(rhs.getDiscoverable());
        } else {
            clearDiscoverable();
        }
    }
    return *this;
}

inline bool DiscoverableUpdate::operator == (const DiscoverableUpdate& rhs) const {
    return (((!hasDiscoverable() && !rhs.hasDiscoverable()) || getDiscoverable() == rhs.getDiscoverable()));
}

inline bool DiscoverableUpdate::operator != (const DiscoverableUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DiscoverableUpdate::operator < (const DiscoverableUpdate& rhs) const {
    if (hasDiscoverable() || rhs.hasDiscoverable()) {
        if (getDiscoverable() < rhs.getDiscoverable()) return true;
        if (getDiscoverable() > rhs.getDiscoverable()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiscoverableUpdate::clone() {
    return new DiscoverableUpdate(*this);
}

inline bool DiscoverableUpdate::operator > (const DiscoverableUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiscoverableUpdate::clear() {
    clearDiscoverable();
}

inline void DiscoverableUpdate::clearDiscoverable() {
    if (hasDiscoverable()) {
         clear_has_Discoverable();
        _Discoverable = false;
     }
}

inline bool DiscoverableUpdate::hasDiscoverable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DiscoverableUpdate::getDiscoverable () const {
    return _Discoverable;
}

inline void DiscoverableUpdate::setDiscoverable (bool Discoverable_) {
    set_has_Discoverable();
    this->_Discoverable = Discoverable_;
}

inline void DiscoverableUpdate::set_has_Discoverable () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiscoverableUpdate::clear_has_Discoverable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DiscoverableRegister::DiscoverableRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiscoverableRegister::DiscoverableRegister (const DiscoverableRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiscoverableRegister::~DiscoverableRegister() {
}

inline DiscoverableRegister& DiscoverableRegister::operator = (const DiscoverableRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DiscoverableRegister::operator == (const DiscoverableRegister& ) const {
    return true;
}

inline bool DiscoverableRegister::operator != (const DiscoverableRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DiscoverableRegister::operator < (const DiscoverableRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DiscoverableRegister::clone() {
    return new DiscoverableRegister(*this);
}

inline bool DiscoverableRegister::operator > (const DiscoverableRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiscoverableRegister::clear() {
}

inline  DiscoverableTimeoutUpdate::DiscoverableTimeoutUpdate ()  :
    _DiscoverableTimeout (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiscoverableTimeoutUpdate::DiscoverableTimeoutUpdate (const DiscoverableTimeoutUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _DiscoverableTimeout (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiscoverableTimeoutUpdate::DiscoverableTimeoutUpdate (uint32 DiscoverableTimeout_)  :
    _DiscoverableTimeout (DiscoverableTimeout_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiscoverableTimeoutUpdate::~DiscoverableTimeoutUpdate() {
}

inline DiscoverableTimeoutUpdate& DiscoverableTimeoutUpdate::operator = (const DiscoverableTimeoutUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDiscoverableTimeout()) {
            setDiscoverableTimeout(rhs.getDiscoverableTimeout());
        } else {
            clearDiscoverableTimeout();
        }
    }
    return *this;
}

inline bool DiscoverableTimeoutUpdate::operator == (const DiscoverableTimeoutUpdate& rhs) const {
    return (((!hasDiscoverableTimeout() && !rhs.hasDiscoverableTimeout()) || getDiscoverableTimeout() == rhs.getDiscoverableTimeout()));
}

inline bool DiscoverableTimeoutUpdate::operator != (const DiscoverableTimeoutUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DiscoverableTimeoutUpdate::operator < (const DiscoverableTimeoutUpdate& rhs) const {
    if (hasDiscoverableTimeout() || rhs.hasDiscoverableTimeout()) {
        if (getDiscoverableTimeout() < rhs.getDiscoverableTimeout()) return true;
        if (getDiscoverableTimeout() > rhs.getDiscoverableTimeout()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiscoverableTimeoutUpdate::clone() {
    return new DiscoverableTimeoutUpdate(*this);
}

inline bool DiscoverableTimeoutUpdate::operator > (const DiscoverableTimeoutUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiscoverableTimeoutUpdate::clear() {
    clearDiscoverableTimeout();
}

inline void DiscoverableTimeoutUpdate::clearDiscoverableTimeout() {
    if (hasDiscoverableTimeout()) {
         clear_has_DiscoverableTimeout();
        _DiscoverableTimeout = 0u;
     }
}

inline bool DiscoverableTimeoutUpdate::hasDiscoverableTimeout () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 DiscoverableTimeoutUpdate::getDiscoverableTimeout () const {
    return _DiscoverableTimeout;
}

inline void DiscoverableTimeoutUpdate::setDiscoverableTimeout (uint32 DiscoverableTimeout_) {
    set_has_DiscoverableTimeout();
    this->_DiscoverableTimeout = DiscoverableTimeout_;
}

inline void DiscoverableTimeoutUpdate::set_has_DiscoverableTimeout () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiscoverableTimeoutUpdate::clear_has_DiscoverableTimeout () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DiscoverableTimeoutRegister::DiscoverableTimeoutRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiscoverableTimeoutRegister::DiscoverableTimeoutRegister (const DiscoverableTimeoutRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiscoverableTimeoutRegister::~DiscoverableTimeoutRegister() {
}

inline DiscoverableTimeoutRegister& DiscoverableTimeoutRegister::operator = (const DiscoverableTimeoutRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DiscoverableTimeoutRegister::operator == (const DiscoverableTimeoutRegister& ) const {
    return true;
}

inline bool DiscoverableTimeoutRegister::operator != (const DiscoverableTimeoutRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DiscoverableTimeoutRegister::operator < (const DiscoverableTimeoutRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DiscoverableTimeoutRegister::clone() {
    return new DiscoverableTimeoutRegister(*this);
}

inline bool DiscoverableTimeoutRegister::operator > (const DiscoverableTimeoutRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiscoverableTimeoutRegister::clear() {
}

inline  PairableUpdate::PairableUpdate ()  :
    _Pairable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PairableUpdate::PairableUpdate (const PairableUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Pairable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PairableUpdate::PairableUpdate (bool Pairable_)  :
    _Pairable (Pairable_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PairableUpdate::~PairableUpdate() {
}

inline PairableUpdate& PairableUpdate::operator = (const PairableUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPairable()) {
            setPairable(rhs.getPairable());
        } else {
            clearPairable();
        }
    }
    return *this;
}

inline bool PairableUpdate::operator == (const PairableUpdate& rhs) const {
    return (((!hasPairable() && !rhs.hasPairable()) || getPairable() == rhs.getPairable()));
}

inline bool PairableUpdate::operator != (const PairableUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PairableUpdate::operator < (const PairableUpdate& rhs) const {
    if (hasPairable() || rhs.hasPairable()) {
        if (getPairable() < rhs.getPairable()) return true;
        if (getPairable() > rhs.getPairable()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PairableUpdate::clone() {
    return new PairableUpdate(*this);
}

inline bool PairableUpdate::operator > (const PairableUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PairableUpdate::clear() {
    clearPairable();
}

inline void PairableUpdate::clearPairable() {
    if (hasPairable()) {
         clear_has_Pairable();
        _Pairable = false;
     }
}

inline bool PairableUpdate::hasPairable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool PairableUpdate::getPairable () const {
    return _Pairable;
}

inline void PairableUpdate::setPairable (bool Pairable_) {
    set_has_Pairable();
    this->_Pairable = Pairable_;
}

inline void PairableUpdate::set_has_Pairable () {
    _has_bits_[0] |= 1u << 0;
}

inline void PairableUpdate::clear_has_Pairable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PairableRegister::PairableRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PairableRegister::PairableRegister (const PairableRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PairableRegister::~PairableRegister() {
}

inline PairableRegister& PairableRegister::operator = (const PairableRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PairableRegister::operator == (const PairableRegister& ) const {
    return true;
}

inline bool PairableRegister::operator != (const PairableRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PairableRegister::operator < (const PairableRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PairableRegister::clone() {
    return new PairableRegister(*this);
}

inline bool PairableRegister::operator > (const PairableRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PairableRegister::clear() {
}

inline  PairableTimeoutUpdate::PairableTimeoutUpdate ()  :
    _PairableTimeout (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PairableTimeoutUpdate::PairableTimeoutUpdate (const PairableTimeoutUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _PairableTimeout (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PairableTimeoutUpdate::PairableTimeoutUpdate (uint32 PairableTimeout_)  :
    _PairableTimeout (PairableTimeout_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PairableTimeoutUpdate::~PairableTimeoutUpdate() {
}

inline PairableTimeoutUpdate& PairableTimeoutUpdate::operator = (const PairableTimeoutUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPairableTimeout()) {
            setPairableTimeout(rhs.getPairableTimeout());
        } else {
            clearPairableTimeout();
        }
    }
    return *this;
}

inline bool PairableTimeoutUpdate::operator == (const PairableTimeoutUpdate& rhs) const {
    return (((!hasPairableTimeout() && !rhs.hasPairableTimeout()) || getPairableTimeout() == rhs.getPairableTimeout()));
}

inline bool PairableTimeoutUpdate::operator != (const PairableTimeoutUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PairableTimeoutUpdate::operator < (const PairableTimeoutUpdate& rhs) const {
    if (hasPairableTimeout() || rhs.hasPairableTimeout()) {
        if (getPairableTimeout() < rhs.getPairableTimeout()) return true;
        if (getPairableTimeout() > rhs.getPairableTimeout()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PairableTimeoutUpdate::clone() {
    return new PairableTimeoutUpdate(*this);
}

inline bool PairableTimeoutUpdate::operator > (const PairableTimeoutUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PairableTimeoutUpdate::clear() {
    clearPairableTimeout();
}

inline void PairableTimeoutUpdate::clearPairableTimeout() {
    if (hasPairableTimeout()) {
         clear_has_PairableTimeout();
        _PairableTimeout = 0u;
     }
}

inline bool PairableTimeoutUpdate::hasPairableTimeout () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 PairableTimeoutUpdate::getPairableTimeout () const {
    return _PairableTimeout;
}

inline void PairableTimeoutUpdate::setPairableTimeout (uint32 PairableTimeout_) {
    set_has_PairableTimeout();
    this->_PairableTimeout = PairableTimeout_;
}

inline void PairableTimeoutUpdate::set_has_PairableTimeout () {
    _has_bits_[0] |= 1u << 0;
}

inline void PairableTimeoutUpdate::clear_has_PairableTimeout () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PairableTimeoutRegister::PairableTimeoutRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PairableTimeoutRegister::PairableTimeoutRegister (const PairableTimeoutRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PairableTimeoutRegister::~PairableTimeoutRegister() {
}

inline PairableTimeoutRegister& PairableTimeoutRegister::operator = (const PairableTimeoutRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PairableTimeoutRegister::operator == (const PairableTimeoutRegister& ) const {
    return true;
}

inline bool PairableTimeoutRegister::operator != (const PairableTimeoutRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PairableTimeoutRegister::operator < (const PairableTimeoutRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PairableTimeoutRegister::clone() {
    return new PairableTimeoutRegister(*this);
}

inline bool PairableTimeoutRegister::operator > (const PairableTimeoutRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PairableTimeoutRegister::clear() {
}

inline  DiscoveringUpdate::DiscoveringUpdate ()  :
    _Discovering (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiscoveringUpdate::DiscoveringUpdate (const DiscoveringUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Discovering (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiscoveringUpdate::DiscoveringUpdate (bool Discovering_)  :
    _Discovering (Discovering_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiscoveringUpdate::~DiscoveringUpdate() {
}

inline DiscoveringUpdate& DiscoveringUpdate::operator = (const DiscoveringUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDiscovering()) {
            setDiscovering(rhs.getDiscovering());
        } else {
            clearDiscovering();
        }
    }
    return *this;
}

inline bool DiscoveringUpdate::operator == (const DiscoveringUpdate& rhs) const {
    return (((!hasDiscovering() && !rhs.hasDiscovering()) || getDiscovering() == rhs.getDiscovering()));
}

inline bool DiscoveringUpdate::operator != (const DiscoveringUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DiscoveringUpdate::operator < (const DiscoveringUpdate& rhs) const {
    if (hasDiscovering() || rhs.hasDiscovering()) {
        if (getDiscovering() < rhs.getDiscovering()) return true;
        if (getDiscovering() > rhs.getDiscovering()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiscoveringUpdate::clone() {
    return new DiscoveringUpdate(*this);
}

inline bool DiscoveringUpdate::operator > (const DiscoveringUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiscoveringUpdate::clear() {
    clearDiscovering();
}

inline void DiscoveringUpdate::clearDiscovering() {
    if (hasDiscovering()) {
         clear_has_Discovering();
        _Discovering = false;
     }
}

inline bool DiscoveringUpdate::hasDiscovering () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DiscoveringUpdate::getDiscovering () const {
    return _Discovering;
}

inline void DiscoveringUpdate::setDiscovering (bool Discovering_) {
    set_has_Discovering();
    this->_Discovering = Discovering_;
}

inline void DiscoveringUpdate::set_has_Discovering () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiscoveringUpdate::clear_has_Discovering () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DiscoveringRegister::DiscoveringRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiscoveringRegister::DiscoveringRegister (const DiscoveringRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiscoveringRegister::~DiscoveringRegister() {
}

inline DiscoveringRegister& DiscoveringRegister::operator = (const DiscoveringRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DiscoveringRegister::operator == (const DiscoveringRegister& ) const {
    return true;
}

inline bool DiscoveringRegister::operator != (const DiscoveringRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DiscoveringRegister::operator < (const DiscoveringRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DiscoveringRegister::clone() {
    return new DiscoveringRegister(*this);
}

inline bool DiscoveringRegister::operator > (const DiscoveringRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiscoveringRegister::clear() {
}

inline  UUIDsUpdate::UUIDsUpdate ()  :
    _UUIDs ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UUIDsUpdate::UUIDsUpdate (const UUIDsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _UUIDs ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UUIDsUpdate::UUIDsUpdate (const ::std::vector< ::std::string >& UUIDs_)  :
    _UUIDs (UUIDs_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UUIDsUpdate::~UUIDsUpdate() {
}

inline UUIDsUpdate& UUIDsUpdate::operator = (const UUIDsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUUIDs()) {
            setUUIDs(rhs.getUUIDs());
        } else {
            clearUUIDs();
        }
    }
    return *this;
}

inline bool UUIDsUpdate::operator == (const UUIDsUpdate& rhs) const {
    return (((!hasUUIDs() && !rhs.hasUUIDs()) || getUUIDs() == rhs.getUUIDs()));
}

inline bool UUIDsUpdate::operator != (const UUIDsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool UUIDsUpdate::operator < (const UUIDsUpdate& rhs) const {
    if (hasUUIDs() || rhs.hasUUIDs()) {
        if (getUUIDs() < rhs.getUUIDs()) return true;
        if (getUUIDs() > rhs.getUUIDs()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UUIDsUpdate::clone() {
    return new UUIDsUpdate(*this);
}

inline bool UUIDsUpdate::operator > (const UUIDsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UUIDsUpdate::clear() {
    clearUUIDs();
}

inline void UUIDsUpdate::clearUUIDs() {
    if (hasUUIDs()) {
         clear_has_UUIDs();
        _UUIDs.clear();
     }
}

inline bool UUIDsUpdate::hasUUIDs () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& UUIDsUpdate::getUUIDs () const {
    return _UUIDs;
}

inline ::std::vector< ::std::string >& UUIDsUpdate::getUUIDsMutable () {
    set_has_UUIDs();
    return _UUIDs;
}

inline void UUIDsUpdate::setUUIDs (const ::std::vector< ::std::string >& UUIDs_) {
    set_has_UUIDs();
    this->_UUIDs = UUIDs_;
}

inline void UUIDsUpdate::set_has_UUIDs () {
    _has_bits_[0] |= 1u << 0;
}

inline void UUIDsUpdate::clear_has_UUIDs () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UUIDsRegister::UUIDsRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UUIDsRegister::UUIDsRegister (const UUIDsRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UUIDsRegister::~UUIDsRegister() {
}

inline UUIDsRegister& UUIDsRegister::operator = (const UUIDsRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool UUIDsRegister::operator == (const UUIDsRegister& ) const {
    return true;
}

inline bool UUIDsRegister::operator != (const UUIDsRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool UUIDsRegister::operator < (const UUIDsRegister& ) const {
    return false;
}

inline ::asf::core::Payload* UUIDsRegister::clone() {
    return new UUIDsRegister(*this);
}

inline bool UUIDsRegister::operator > (const UUIDsRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UUIDsRegister::clear() {
}

inline  WBSModeUpdate::WBSModeUpdate ()  :
    _WBSMode (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WBSModeUpdate::WBSModeUpdate (const WBSModeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _WBSMode (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WBSModeUpdate::WBSModeUpdate (bool WBSMode_)  :
    _WBSMode (WBSMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WBSModeUpdate::~WBSModeUpdate() {
}

inline WBSModeUpdate& WBSModeUpdate::operator = (const WBSModeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWBSMode()) {
            setWBSMode(rhs.getWBSMode());
        } else {
            clearWBSMode();
        }
    }
    return *this;
}

inline bool WBSModeUpdate::operator == (const WBSModeUpdate& rhs) const {
    return (((!hasWBSMode() && !rhs.hasWBSMode()) || getWBSMode() == rhs.getWBSMode()));
}

inline bool WBSModeUpdate::operator != (const WBSModeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool WBSModeUpdate::operator < (const WBSModeUpdate& rhs) const {
    if (hasWBSMode() || rhs.hasWBSMode()) {
        if (getWBSMode() < rhs.getWBSMode()) return true;
        if (getWBSMode() > rhs.getWBSMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WBSModeUpdate::clone() {
    return new WBSModeUpdate(*this);
}

inline bool WBSModeUpdate::operator > (const WBSModeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WBSModeUpdate::clear() {
    clearWBSMode();
}

inline void WBSModeUpdate::clearWBSMode() {
    if (hasWBSMode()) {
         clear_has_WBSMode();
        _WBSMode = false;
     }
}

inline bool WBSModeUpdate::hasWBSMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool WBSModeUpdate::getWBSMode () const {
    return _WBSMode;
}

inline void WBSModeUpdate::setWBSMode (bool WBSMode_) {
    set_has_WBSMode();
    this->_WBSMode = WBSMode_;
}

inline void WBSModeUpdate::set_has_WBSMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void WBSModeUpdate::clear_has_WBSMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WBSModeRegister::WBSModeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WBSModeRegister::WBSModeRegister (const WBSModeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WBSModeRegister::~WBSModeRegister() {
}

inline WBSModeRegister& WBSModeRegister::operator = (const WBSModeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool WBSModeRegister::operator == (const WBSModeRegister& ) const {
    return true;
}

inline bool WBSModeRegister::operator != (const WBSModeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool WBSModeRegister::operator < (const WBSModeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* WBSModeRegister::clone() {
    return new WBSModeRegister(*this);
}

inline bool WBSModeRegister::operator > (const WBSModeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WBSModeRegister::clear() {
}

inline  ConnectableUpdate::ConnectableUpdate ()  :
    _Connectable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectableUpdate::ConnectableUpdate (const ConnectableUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Connectable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectableUpdate::ConnectableUpdate (bool Connectable_)  :
    _Connectable (Connectable_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConnectableUpdate::~ConnectableUpdate() {
}

inline ConnectableUpdate& ConnectableUpdate::operator = (const ConnectableUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConnectable()) {
            setConnectable(rhs.getConnectable());
        } else {
            clearConnectable();
        }
    }
    return *this;
}

inline bool ConnectableUpdate::operator == (const ConnectableUpdate& rhs) const {
    return (((!hasConnectable() && !rhs.hasConnectable()) || getConnectable() == rhs.getConnectable()));
}

inline bool ConnectableUpdate::operator != (const ConnectableUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectableUpdate::operator < (const ConnectableUpdate& rhs) const {
    if (hasConnectable() || rhs.hasConnectable()) {
        if (getConnectable() < rhs.getConnectable()) return true;
        if (getConnectable() > rhs.getConnectable()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConnectableUpdate::clone() {
    return new ConnectableUpdate(*this);
}

inline bool ConnectableUpdate::operator > (const ConnectableUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectableUpdate::clear() {
    clearConnectable();
}

inline void ConnectableUpdate::clearConnectable() {
    if (hasConnectable()) {
         clear_has_Connectable();
        _Connectable = false;
     }
}

inline bool ConnectableUpdate::hasConnectable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ConnectableUpdate::getConnectable () const {
    return _Connectable;
}

inline void ConnectableUpdate::setConnectable (bool Connectable_) {
    set_has_Connectable();
    this->_Connectable = Connectable_;
}

inline void ConnectableUpdate::set_has_Connectable () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConnectableUpdate::clear_has_Connectable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ConnectableRegister::ConnectableRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectableRegister::ConnectableRegister (const ConnectableRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectableRegister::~ConnectableRegister() {
}

inline ConnectableRegister& ConnectableRegister::operator = (const ConnectableRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ConnectableRegister::operator == (const ConnectableRegister& ) const {
    return true;
}

inline bool ConnectableRegister::operator != (const ConnectableRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectableRegister::operator < (const ConnectableRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ConnectableRegister::clone() {
    return new ConnectableRegister(*this);
}

inline bool ConnectableRegister::operator > (const ConnectableRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectableRegister::clear() {
}

inline  HCIModeUpdate::HCIModeUpdate ()  :
    _HCIMode (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HCIModeUpdate::HCIModeUpdate (const HCIModeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _HCIMode (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HCIModeUpdate::HCIModeUpdate (bool HCIMode_)  :
    _HCIMode (HCIMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HCIModeUpdate::~HCIModeUpdate() {
}

inline HCIModeUpdate& HCIModeUpdate::operator = (const HCIModeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasHCIMode()) {
            setHCIMode(rhs.getHCIMode());
        } else {
            clearHCIMode();
        }
    }
    return *this;
}

inline bool HCIModeUpdate::operator == (const HCIModeUpdate& rhs) const {
    return (((!hasHCIMode() && !rhs.hasHCIMode()) || getHCIMode() == rhs.getHCIMode()));
}

inline bool HCIModeUpdate::operator != (const HCIModeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool HCIModeUpdate::operator < (const HCIModeUpdate& rhs) const {
    if (hasHCIMode() || rhs.hasHCIMode()) {
        if (getHCIMode() < rhs.getHCIMode()) return true;
        if (getHCIMode() > rhs.getHCIMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HCIModeUpdate::clone() {
    return new HCIModeUpdate(*this);
}

inline bool HCIModeUpdate::operator > (const HCIModeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HCIModeUpdate::clear() {
    clearHCIMode();
}

inline void HCIModeUpdate::clearHCIMode() {
    if (hasHCIMode()) {
         clear_has_HCIMode();
        _HCIMode = false;
     }
}

inline bool HCIModeUpdate::hasHCIMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool HCIModeUpdate::getHCIMode () const {
    return _HCIMode;
}

inline void HCIModeUpdate::setHCIMode (bool HCIMode_) {
    set_has_HCIMode();
    this->_HCIMode = HCIMode_;
}

inline void HCIModeUpdate::set_has_HCIMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void HCIModeUpdate::clear_has_HCIMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  HCIModeRegister::HCIModeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HCIModeRegister::HCIModeRegister (const HCIModeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HCIModeRegister::~HCIModeRegister() {
}

inline HCIModeRegister& HCIModeRegister::operator = (const HCIModeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool HCIModeRegister::operator == (const HCIModeRegister& ) const {
    return true;
}

inline bool HCIModeRegister::operator != (const HCIModeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool HCIModeRegister::operator < (const HCIModeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* HCIModeRegister::clone() {
    return new HCIModeRegister(*this);
}

inline bool HCIModeRegister::operator > (const HCIModeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HCIModeRegister::clear() {
}

inline  VersionUpdate::VersionUpdate ()  :
    _Version ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VersionUpdate::VersionUpdate (const VersionUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Version ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VersionUpdate::VersionUpdate (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& Version_)  :
    _Version (Version_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VersionUpdate::~VersionUpdate() {
}

inline VersionUpdate& VersionUpdate::operator = (const VersionUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVersion()) {
            setVersion(rhs.getVersion());
        } else {
            clearVersion();
        }
    }
    return *this;
}

inline bool VersionUpdate::operator == (const VersionUpdate& rhs) const {
    return (((!hasVersion() && !rhs.hasVersion()) || getVersion() == rhs.getVersion()));
}

inline bool VersionUpdate::operator != (const VersionUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool VersionUpdate::operator < (const VersionUpdate& rhs) const {
    if (hasVersion() || rhs.hasVersion()) {
        if (getVersion() < rhs.getVersion()) return true;
        if (getVersion() > rhs.getVersion()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VersionUpdate::clone() {
    return new VersionUpdate(*this);
}

inline bool VersionUpdate::operator > (const VersionUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VersionUpdate::clear() {
    clearVersion();
}

inline void VersionUpdate::clearVersion() {
    if (hasVersion()) {
         clear_has_Version();
        _Version.clear();
     }
}

inline bool VersionUpdate::hasVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& VersionUpdate::getVersion () const {
    return _Version;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& VersionUpdate::getVersionMutable () {
    set_has_Version();
    return _Version;
}

inline void VersionUpdate::setVersion (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& Version_) {
    set_has_Version();
    this->_Version = Version_;
}

inline void VersionUpdate::set_has_Version () {
    _has_bits_[0] |= 1u << 0;
}

inline void VersionUpdate::clear_has_Version () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VersionRegister::VersionRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VersionRegister::VersionRegister (const VersionRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VersionRegister::~VersionRegister() {
}

inline VersionRegister& VersionRegister::operator = (const VersionRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool VersionRegister::operator == (const VersionRegister& ) const {
    return true;
}

inline bool VersionRegister::operator != (const VersionRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool VersionRegister::operator < (const VersionRegister& ) const {
    return false;
}

inline ::asf::core::Payload* VersionRegister::clone() {
    return new VersionRegister(*this);
}

inline bool VersionRegister::operator > (const VersionRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VersionRegister::clear() {
}

inline  TraceLevelUpdate::TraceLevelUpdate ()  :
    _TraceLevel ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TraceLevelUpdate::TraceLevelUpdate (const TraceLevelUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _TraceLevel ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TraceLevelUpdate::TraceLevelUpdate (const ::std::vector< ::std::string >& TraceLevel_)  :
    _TraceLevel (TraceLevel_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TraceLevelUpdate::~TraceLevelUpdate() {
}

inline TraceLevelUpdate& TraceLevelUpdate::operator = (const TraceLevelUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTraceLevel()) {
            setTraceLevel(rhs.getTraceLevel());
        } else {
            clearTraceLevel();
        }
    }
    return *this;
}

inline bool TraceLevelUpdate::operator == (const TraceLevelUpdate& rhs) const {
    return (((!hasTraceLevel() && !rhs.hasTraceLevel()) || getTraceLevel() == rhs.getTraceLevel()));
}

inline bool TraceLevelUpdate::operator != (const TraceLevelUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool TraceLevelUpdate::operator < (const TraceLevelUpdate& rhs) const {
    if (hasTraceLevel() || rhs.hasTraceLevel()) {
        if (getTraceLevel() < rhs.getTraceLevel()) return true;
        if (getTraceLevel() > rhs.getTraceLevel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TraceLevelUpdate::clone() {
    return new TraceLevelUpdate(*this);
}

inline bool TraceLevelUpdate::operator > (const TraceLevelUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TraceLevelUpdate::clear() {
    clearTraceLevel();
}

inline void TraceLevelUpdate::clearTraceLevel() {
    if (hasTraceLevel()) {
         clear_has_TraceLevel();
        _TraceLevel.clear();
     }
}

inline bool TraceLevelUpdate::hasTraceLevel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& TraceLevelUpdate::getTraceLevel () const {
    return _TraceLevel;
}

inline ::std::vector< ::std::string >& TraceLevelUpdate::getTraceLevelMutable () {
    set_has_TraceLevel();
    return _TraceLevel;
}

inline void TraceLevelUpdate::setTraceLevel (const ::std::vector< ::std::string >& TraceLevel_) {
    set_has_TraceLevel();
    this->_TraceLevel = TraceLevel_;
}

inline void TraceLevelUpdate::set_has_TraceLevel () {
    _has_bits_[0] |= 1u << 0;
}

inline void TraceLevelUpdate::clear_has_TraceLevel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TraceLevelRegister::TraceLevelRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TraceLevelRegister::TraceLevelRegister (const TraceLevelRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TraceLevelRegister::~TraceLevelRegister() {
}

inline TraceLevelRegister& TraceLevelRegister::operator = (const TraceLevelRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool TraceLevelRegister::operator == (const TraceLevelRegister& ) const {
    return true;
}

inline bool TraceLevelRegister::operator != (const TraceLevelRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool TraceLevelRegister::operator < (const TraceLevelRegister& ) const {
    return false;
}

inline ::asf::core::Payload* TraceLevelRegister::clone() {
    return new TraceLevelRegister(*this);
}

inline bool TraceLevelRegister::operator > (const TraceLevelRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TraceLevelRegister::clear() {
}

inline  TraceCategoryUpdate::TraceCategoryUpdate ()  :
    _TraceCategory ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TraceCategoryUpdate::TraceCategoryUpdate (const TraceCategoryUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _TraceCategory ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TraceCategoryUpdate::TraceCategoryUpdate (const ::std::vector< ::std::string >& TraceCategory_)  :
    _TraceCategory (TraceCategory_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TraceCategoryUpdate::~TraceCategoryUpdate() {
}

inline TraceCategoryUpdate& TraceCategoryUpdate::operator = (const TraceCategoryUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTraceCategory()) {
            setTraceCategory(rhs.getTraceCategory());
        } else {
            clearTraceCategory();
        }
    }
    return *this;
}

inline bool TraceCategoryUpdate::operator == (const TraceCategoryUpdate& rhs) const {
    return (((!hasTraceCategory() && !rhs.hasTraceCategory()) || getTraceCategory() == rhs.getTraceCategory()));
}

inline bool TraceCategoryUpdate::operator != (const TraceCategoryUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool TraceCategoryUpdate::operator < (const TraceCategoryUpdate& rhs) const {
    if (hasTraceCategory() || rhs.hasTraceCategory()) {
        if (getTraceCategory() < rhs.getTraceCategory()) return true;
        if (getTraceCategory() > rhs.getTraceCategory()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TraceCategoryUpdate::clone() {
    return new TraceCategoryUpdate(*this);
}

inline bool TraceCategoryUpdate::operator > (const TraceCategoryUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TraceCategoryUpdate::clear() {
    clearTraceCategory();
}

inline void TraceCategoryUpdate::clearTraceCategory() {
    if (hasTraceCategory()) {
         clear_has_TraceCategory();
        _TraceCategory.clear();
     }
}

inline bool TraceCategoryUpdate::hasTraceCategory () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& TraceCategoryUpdate::getTraceCategory () const {
    return _TraceCategory;
}

inline ::std::vector< ::std::string >& TraceCategoryUpdate::getTraceCategoryMutable () {
    set_has_TraceCategory();
    return _TraceCategory;
}

inline void TraceCategoryUpdate::setTraceCategory (const ::std::vector< ::std::string >& TraceCategory_) {
    set_has_TraceCategory();
    this->_TraceCategory = TraceCategory_;
}

inline void TraceCategoryUpdate::set_has_TraceCategory () {
    _has_bits_[0] |= 1u << 0;
}

inline void TraceCategoryUpdate::clear_has_TraceCategory () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TraceCategoryRegister::TraceCategoryRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TraceCategoryRegister::TraceCategoryRegister (const TraceCategoryRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TraceCategoryRegister::~TraceCategoryRegister() {
}

inline TraceCategoryRegister& TraceCategoryRegister::operator = (const TraceCategoryRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool TraceCategoryRegister::operator == (const TraceCategoryRegister& ) const {
    return true;
}

inline bool TraceCategoryRegister::operator != (const TraceCategoryRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool TraceCategoryRegister::operator < (const TraceCategoryRegister& ) const {
    return false;
}

inline ::asf::core::Payload* TraceCategoryRegister::clone() {
    return new TraceCategoryRegister(*this);
}

inline bool TraceCategoryRegister::operator > (const TraceCategoryRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TraceCategoryRegister::clear() {
}

inline  AvailableSPPServersUpdate::AvailableSPPServersUpdate ()  :
    _AvailableSPPServers ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AvailableSPPServersUpdate::AvailableSPPServersUpdate (const AvailableSPPServersUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _AvailableSPPServers ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AvailableSPPServersUpdate::AvailableSPPServersUpdate (const ::std::vector< ::std::string >& AvailableSPPServers_)  :
    _AvailableSPPServers (AvailableSPPServers_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AvailableSPPServersUpdate::~AvailableSPPServersUpdate() {
}

inline AvailableSPPServersUpdate& AvailableSPPServersUpdate::operator = (const AvailableSPPServersUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAvailableSPPServers()) {
            setAvailableSPPServers(rhs.getAvailableSPPServers());
        } else {
            clearAvailableSPPServers();
        }
    }
    return *this;
}

inline bool AvailableSPPServersUpdate::operator == (const AvailableSPPServersUpdate& rhs) const {
    return (((!hasAvailableSPPServers() && !rhs.hasAvailableSPPServers()) || getAvailableSPPServers() == rhs.getAvailableSPPServers()));
}

inline bool AvailableSPPServersUpdate::operator != (const AvailableSPPServersUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AvailableSPPServersUpdate::operator < (const AvailableSPPServersUpdate& rhs) const {
    if (hasAvailableSPPServers() || rhs.hasAvailableSPPServers()) {
        if (getAvailableSPPServers() < rhs.getAvailableSPPServers()) return true;
        if (getAvailableSPPServers() > rhs.getAvailableSPPServers()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AvailableSPPServersUpdate::clone() {
    return new AvailableSPPServersUpdate(*this);
}

inline bool AvailableSPPServersUpdate::operator > (const AvailableSPPServersUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AvailableSPPServersUpdate::clear() {
    clearAvailableSPPServers();
}

inline void AvailableSPPServersUpdate::clearAvailableSPPServers() {
    if (hasAvailableSPPServers()) {
         clear_has_AvailableSPPServers();
        _AvailableSPPServers.clear();
     }
}

inline bool AvailableSPPServersUpdate::hasAvailableSPPServers () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& AvailableSPPServersUpdate::getAvailableSPPServers () const {
    return _AvailableSPPServers;
}

inline ::std::vector< ::std::string >& AvailableSPPServersUpdate::getAvailableSPPServersMutable () {
    set_has_AvailableSPPServers();
    return _AvailableSPPServers;
}

inline void AvailableSPPServersUpdate::setAvailableSPPServers (const ::std::vector< ::std::string >& AvailableSPPServers_) {
    set_has_AvailableSPPServers();
    this->_AvailableSPPServers = AvailableSPPServers_;
}

inline void AvailableSPPServersUpdate::set_has_AvailableSPPServers () {
    _has_bits_[0] |= 1u << 0;
}

inline void AvailableSPPServersUpdate::clear_has_AvailableSPPServers () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AvailableSPPServersRegister::AvailableSPPServersRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AvailableSPPServersRegister::AvailableSPPServersRegister (const AvailableSPPServersRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AvailableSPPServersRegister::~AvailableSPPServersRegister() {
}

inline AvailableSPPServersRegister& AvailableSPPServersRegister::operator = (const AvailableSPPServersRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AvailableSPPServersRegister::operator == (const AvailableSPPServersRegister& ) const {
    return true;
}

inline bool AvailableSPPServersRegister::operator != (const AvailableSPPServersRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AvailableSPPServersRegister::operator < (const AvailableSPPServersRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AvailableSPPServersRegister::clone() {
    return new AvailableSPPServersRegister(*this);
}

inline bool AvailableSPPServersRegister::operator > (const AvailableSPPServersRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AvailableSPPServersRegister::clear() {
}

inline  DeviceCreatedSignal::DeviceCreatedSignal ()  :
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceCreatedSignal::DeviceCreatedSignal (const DeviceCreatedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceCreatedSignal::DeviceCreatedSignal (const ::std::string& device_)  :
    _device (device_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeviceCreatedSignal::~DeviceCreatedSignal() {
}

inline DeviceCreatedSignal& DeviceCreatedSignal::operator = (const DeviceCreatedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool DeviceCreatedSignal::operator == (const DeviceCreatedSignal& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool DeviceCreatedSignal::operator != (const DeviceCreatedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceCreatedSignal::operator < (const DeviceCreatedSignal& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeviceCreatedSignal::clone() {
    return new DeviceCreatedSignal(*this);
}

inline bool DeviceCreatedSignal::operator > (const DeviceCreatedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceCreatedSignal::clear() {
    clearDevice();
}

inline void DeviceCreatedSignal::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool DeviceCreatedSignal::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DeviceCreatedSignal::getDevice () const {
    return _device;
}

inline ::std::string& DeviceCreatedSignal::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void DeviceCreatedSignal::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void DeviceCreatedSignal::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void DeviceCreatedSignal::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void DeviceCreatedSignal::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeviceCreatedSignal::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeviceRemovedSignal::DeviceRemovedSignal ()  :
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceRemovedSignal::DeviceRemovedSignal (const DeviceRemovedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceRemovedSignal::DeviceRemovedSignal (const ::std::string& device_)  :
    _device (device_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeviceRemovedSignal::~DeviceRemovedSignal() {
}

inline DeviceRemovedSignal& DeviceRemovedSignal::operator = (const DeviceRemovedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool DeviceRemovedSignal::operator == (const DeviceRemovedSignal& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool DeviceRemovedSignal::operator != (const DeviceRemovedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceRemovedSignal::operator < (const DeviceRemovedSignal& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeviceRemovedSignal::clone() {
    return new DeviceRemovedSignal(*this);
}

inline bool DeviceRemovedSignal::operator > (const DeviceRemovedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceRemovedSignal::clear() {
    clearDevice();
}

inline void DeviceRemovedSignal::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool DeviceRemovedSignal::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DeviceRemovedSignal::getDevice () const {
    return _device;
}

inline ::std::string& DeviceRemovedSignal::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void DeviceRemovedSignal::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void DeviceRemovedSignal::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void DeviceRemovedSignal::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void DeviceRemovedSignal::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeviceRemovedSignal::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtStackLogSignal::BtStackLogSignal ()  :
    _status (0u),
    _opcode (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtStackLogSignal::BtStackLogSignal (const BtStackLogSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u),
    _opcode (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtStackLogSignal::BtStackLogSignal (uint8 status_, uint16 opcode_, const ::std::vector< uint8 >& data_)  :
    _status (status_),
    _opcode (opcode_),
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtStackLogSignal::~BtStackLogSignal() {
}

inline BtStackLogSignal& BtStackLogSignal::operator = (const BtStackLogSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasOpcode()) {
            setOpcode(rhs.getOpcode());
        } else {
            clearOpcode();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool BtStackLogSignal::operator == (const BtStackLogSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasOpcode() && !rhs.hasOpcode()) || getOpcode() == rhs.getOpcode()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool BtStackLogSignal::operator != (const BtStackLogSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtStackLogSignal::operator < (const BtStackLogSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasOpcode() || rhs.hasOpcode()) {
        if (getOpcode() < rhs.getOpcode()) return true;
        if (getOpcode() > rhs.getOpcode()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtStackLogSignal::clone() {
    return new BtStackLogSignal(*this);
}

inline bool BtStackLogSignal::operator > (const BtStackLogSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtStackLogSignal::clear() {
    clearStatus();
    clearOpcode();
    clearData();
}

inline void BtStackLogSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtStackLogSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtStackLogSignal::getStatus () const {
    return _status;
}

inline void BtStackLogSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtStackLogSignal::clearOpcode() {
    if (hasOpcode()) {
         clear_has_opcode();
        _opcode = 0u;
     }
}

inline bool BtStackLogSignal::hasOpcode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 BtStackLogSignal::getOpcode () const {
    return _opcode;
}

inline void BtStackLogSignal::setOpcode (uint16 opcode_) {
    set_has_opcode();
    this->_opcode = opcode_;
}

inline void BtStackLogSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool BtStackLogSignal::hasData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint8 >& BtStackLogSignal::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& BtStackLogSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void BtStackLogSignal::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void BtStackLogSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtStackLogSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtStackLogSignal::set_has_opcode () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtStackLogSignal::clear_has_opcode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BtStackLogSignal::set_has_data () {
    _has_bits_[0] |= 1u << 2;
}

inline void BtStackLogSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  HCIEventSignal::HCIEventSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HCIEventSignal::HCIEventSignal (const HCIEventSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HCIEventSignal::HCIEventSignal (const ::std::vector< uint8 >& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HCIEventSignal::~HCIEventSignal() {
}

inline HCIEventSignal& HCIEventSignal::operator = (const HCIEventSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool HCIEventSignal::operator == (const HCIEventSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool HCIEventSignal::operator != (const HCIEventSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool HCIEventSignal::operator < (const HCIEventSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HCIEventSignal::clone() {
    return new HCIEventSignal(*this);
}

inline bool HCIEventSignal::operator > (const HCIEventSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HCIEventSignal::clear() {
    clearData();
}

inline void HCIEventSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool HCIEventSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& HCIEventSignal::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& HCIEventSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void HCIEventSignal::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void HCIEventSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void HCIEventSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeviceFoundSignal::DeviceFoundSignal ()  :
    _address (),
    _values ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceFoundSignal::DeviceFoundSignal (const DeviceFoundSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _address (),
    _values ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceFoundSignal::DeviceFoundSignal (const ::std::string& address_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& values_)  :
    _address (address_),
    _values (values_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeviceFoundSignal::~DeviceFoundSignal() {
}

inline DeviceFoundSignal& DeviceFoundSignal::operator = (const DeviceFoundSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
        if (rhs.hasValues()) {
            setValues(rhs.getValues());
        } else {
            clearValues();
        }
    }
    return *this;
}

inline bool DeviceFoundSignal::operator == (const DeviceFoundSignal& rhs) const {
    return (((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()) &&
        ((!hasValues() && !rhs.hasValues()) || getValues() == rhs.getValues()));
}

inline bool DeviceFoundSignal::operator != (const DeviceFoundSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceFoundSignal::operator < (const DeviceFoundSignal& rhs) const {
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    if (hasValues() || rhs.hasValues()) {
        if (getValues() < rhs.getValues()) return true;
        if (getValues() > rhs.getValues()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeviceFoundSignal::clone() {
    return new DeviceFoundSignal(*this);
}

inline bool DeviceFoundSignal::operator > (const DeviceFoundSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceFoundSignal::clear() {
    clearAddress();
    clearValues();
}

inline void DeviceFoundSignal::clearAddress() {
    if (hasAddress()) {
         clear_has_address();
        _address.clear();
     }
}

inline bool DeviceFoundSignal::hasAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DeviceFoundSignal::getAddress () const {
    return _address;
}

inline ::std::string& DeviceFoundSignal::getAddressMutable () {
    set_has_address();
    return _address;
}

inline void DeviceFoundSignal::setAddress (const ::std::string& address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address = address_;
}

inline void DeviceFoundSignal::setAddress (const char* address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(address_);
}

inline void DeviceFoundSignal::setAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(value, size);
}

inline void DeviceFoundSignal::clearValues() {
    if (hasValues()) {
         clear_has_values();
        _values.clear();
     }
}

inline bool DeviceFoundSignal::hasValues () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& DeviceFoundSignal::getValues () const {
    return _values;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& DeviceFoundSignal::getValuesMutable () {
    set_has_values();
    return _values;
}

inline void DeviceFoundSignal::setValues (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& values_) {
    set_has_values();
    this->_values = values_;
}

inline void DeviceFoundSignal::set_has_address () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeviceFoundSignal::clear_has_address () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DeviceFoundSignal::set_has_values () {
    _has_bits_[0] |= 1u << 1;
}

inline void DeviceFoundSignal::clear_has_values () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace Adapter1
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_ADAPTER1_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
