/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/genivi/Trace.h"
#include "org/bluez/genivi/TraceDBus.h"
#include "org/bluez/genivi/TraceJson.h"
#include "org/bluez/genivi/TraceProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace genivi {
namespace Trace {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/org/bluez/genivi/Trace", TraceProxy);

class TraceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    TraceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< TraceProxy >& proxyShared = ::boost::static_pointer_cast< TraceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_ReportDebugTrace:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReportDebugTraceSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ReportDebugTrace", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ReportDebugTraceSignal> payload = ::boost::static_pointer_cast<ReportDebugTraceSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ReportDebugTraceCallbackIF*) _callback)->onReportDebugTraceSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_FatalError:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FatalErrorSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FatalError", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<FatalErrorSignal> payload = ::boost::static_pointer_cast<FatalErrorSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((FatalErrorCallbackIF*) _callback)->onFatalErrorSignal (proxyShared, payload);
                    return true;
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_ReportDebugTrace: {
                ::boost::shared_ptr< ReportDebugTraceError > payload = ::boost::shared_ptr< ReportDebugTraceError >
                (new ReportDebugTraceError(DBUS_ERROR_NO_SERVER, "The DBus service Trace is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReportDebugTrace", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TraceProxy> proxyShared = ::boost::static_pointer_cast<TraceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReportDebugTraceCallbackIF*) _callback)->onReportDebugTraceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FatalError: {
                ::boost::shared_ptr< FatalErrorError > payload = ::boost::shared_ptr< FatalErrorError >
                (new FatalErrorError(DBUS_ERROR_NO_SERVER, "The DBus service Trace is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FatalError", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TraceProxy> proxyShared = ::boost::static_pointer_cast<TraceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FatalErrorCallbackIF*) _callback)->onFatalErrorError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& TraceProxyCallback::_logger (TraceProxy::_logger);

TraceProxy::TraceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bluez.genivi.Trace", serviceAvailable, _logger) {
}

TraceProxy::~TraceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< TraceProxy > TraceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<TraceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< TraceProxy > proxyNew(new TraceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t TraceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    TraceProxyCallback* callback = new TraceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t TraceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    TraceProxyCallback* callback = new TraceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void TraceProxy::sendDeregisterAll () const
{
    sendReportDebugTraceDeregisterAll();
    sendFatalErrorDeregisterAll();
}

act_t TraceProxy::sendReportDebugTraceRegister(ReportDebugTraceCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ReportDebugTrace");
    act_t act = addSignalCallback(ID_ReportDebugTrace, "ReportDebugTrace", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ReportDebugTrace", &cb, act);
    return act;
}

bool TraceProxy::sendReportDebugTraceDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ReportDebugTrace", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ReportDebugTrace", act, static_cast<int>(rv));
    return rv;
}

void TraceProxy::sendReportDebugTraceDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ReportDebugTrace");
    _dbusProxyDelegate->deregisterSignalCallback("ReportDebugTrace", 0, _dbusDaemonProxy.get(), false);
}

act_t TraceProxy::sendFatalErrorRegister(FatalErrorCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "FatalError");
    act_t act = addSignalCallback(ID_FatalError, "FatalError", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FatalError", &cb, act);
    return act;
}

bool TraceProxy::sendFatalErrorDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FatalError", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FatalError", act, static_cast<int>(rv));
    return rv;
}

void TraceProxy::sendFatalErrorDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FatalError");
    _dbusProxyDelegate->deregisterSignalCallback("FatalError", 0, _dbusDaemonProxy.get(), false);
}

} // namespace Trace
} // namespace genivi
} // namespace bluez
} // namespace org
