/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_EVO_TRACEPROXY_H
#define ORG_BLUEZ_EVO_TRACEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/evo/Trace.h"
#include <dbus/dbus.h>

namespace org {
namespace bluez {
namespace evo {
namespace Trace {

class TraceProxy;

class DebugTraceConfigCallbackIF {
public:
    virtual ~DebugTraceConfigCallbackIF() {}

    virtual void onDebugTraceConfigError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< DebugTraceConfigError >& error) = 0;

    virtual void onDebugTraceConfigResponse(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< DebugTraceConfigResponse >& response) = 0;
};

class FatalErrorCallbackIF {
public:
    virtual ~FatalErrorCallbackIF() {}

    virtual void onFatalErrorError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< FatalErrorError >& error) = 0;

    virtual void onFatalErrorSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< FatalErrorSignal >& signal) = 0;
};

class GeneralErrorCallbackIF {
public:
    virtual ~GeneralErrorCallbackIF() {}

    virtual void onGeneralErrorError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< GeneralErrorError >& error) = 0;

    virtual void onGeneralErrorSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< GeneralErrorSignal >& signal) = 0;
};

class ProtocolTraceConfigCallbackIF {
public:
    virtual ~ProtocolTraceConfigCallbackIF() {}

    virtual void onProtocolTraceConfigError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ProtocolTraceConfigError >& error) = 0;

    virtual void onProtocolTraceConfigResponse(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ProtocolTraceConfigResponse >& response) = 0;
};

class ReportDebugTraceCallbackIF {
public:
    virtual ~ReportDebugTraceCallbackIF() {}

    virtual void onReportDebugTraceError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportDebugTraceError >& error) = 0;

    virtual void onReportDebugTraceSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportDebugTraceSignal >& signal) = 0;
};

class ReportProtocolTraceCallbackIF {
public:
    virtual ~ReportProtocolTraceCallbackIF() {}

    virtual void onReportProtocolTraceError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportProtocolTraceError >& error) = 0;

    virtual void onReportProtocolTraceSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportProtocolTraceSignal >& signal) = 0;
};


/**
 * TraceProxy is the client side representation of the D-Bus service
 * interface 'org.bluez.evo.Trace' (specified in file
 * stack_component_evo_trace.xml).
 *
 * If the meaning of "org.bluez.evo.Trace" isn't clear, then there should be a description here.
 */
class TraceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of TraceProxy.
     */
    static ::boost::shared_ptr< TraceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of TraceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< TraceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of TraceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< TraceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< TraceProxy > proxyNew(new TraceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~TraceProxy ();


    // Signal 'ReportDebugTrace'

    /**
     * Notify on the signal 'ReportDebugTrace'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'ReportDebugTrace'</b>:
     *
     * If the meaning of "ReportDebugTrace" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReportDebugTraceRegister(ReportDebugTraceCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ReportDebugTrace'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ReportDebugTrace'</b>:
     *
     * If the meaning of "ReportDebugTrace" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendReportDebugTraceRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendReportDebugTraceDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'ReportDebugTrace'.
     */
    void sendReportDebugTraceDeregisterAll () const;

    // Signal 'ReportProtocolTrace'

    /**
     * Notify on the signal 'ReportProtocolTrace'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'ReportProtocolTrace'</b>:
     *
     * If the meaning of "ReportProtocolTrace" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReportProtocolTraceRegister(ReportProtocolTraceCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ReportProtocolTrace'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ReportProtocolTrace'</b>:
     *
     * If the meaning of "ReportProtocolTrace" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendReportProtocolTraceRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendReportProtocolTraceDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'ReportProtocolTrace'.
     */
    void sendReportProtocolTraceDeregisterAll () const;

    // Signal 'FatalError'

    /**
     * Notify on the signal 'FatalError'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'FatalError'</b>:
     *
     * If the meaning of "FatalError" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFatalErrorRegister(FatalErrorCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'FatalError'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'FatalError'</b>:
     *
     * If the meaning of "FatalError" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendFatalErrorRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFatalErrorDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'FatalError'.
     */
    void sendFatalErrorDeregisterAll () const;

    // Signal 'GeneralError'

    /**
     * Notify on the signal 'GeneralError'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'GeneralError'</b>:
     *
     * If the meaning of "GeneralError" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGeneralErrorRegister(GeneralErrorCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'GeneralError'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'GeneralError'</b>:
     *
     * If the meaning of "GeneralError" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendGeneralErrorRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendGeneralErrorDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'GeneralError'.
     */
    void sendGeneralErrorDeregisterAll () const;



    // Method 'DebugTraceConfig'

    /**
     * Call the method 'DebugTraceConfig'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'DebugTraceConfig'</b>:
     *
     * If the meaning of "DebugTraceConfig" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param level If the meaning of "level" isn't clear, then there should be a description here.
     *
     * @param current_time If the meaning of "current_time" isn't clear, then there should be a description here.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param category1 If the meaning of "category1" isn't clear, then there should be a description here.
     *
     * @param category2 If the meaning of "category2" isn't clear, then there should be a description here.
     *
     * @param category3 If the meaning of "category3" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDebugTraceConfigRequest(DebugTraceConfigCallbackIF& cb, uint8 level, uint32 current_time, uint8 mode, uint32 category1, uint32 category2, uint32 category3) const;

    // Method 'ProtocolTraceConfig'

    /**
     * Call the method 'ProtocolTraceConfig'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'ProtocolTraceConfig'</b>:
     *
     * If the meaning of "ProtocolTraceConfig" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param filter If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProtocolTraceConfigRequest(ProtocolTraceConfigCallbackIF& cb, uint16 filter) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    TraceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class TraceProxyCallback;
};

} // namespace Trace
} // namespace evo
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_EVO_TRACEPROXY_H
