#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_EVO_TRACE_H
#define ORG_BLUEZ_EVO_TRACE_H

#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstring>
#include <vector>

/**
 * If the meaning of "Trace" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace evo {
namespace Trace {

// method IDs
static const uint16 ID_DebugTraceConfig = 0;
static const uint16 ID_ProtocolTraceConfig = 1;

// signal IDs
static const uint16 ID_ReportDebugTrace = 2;
static const uint16 ID_ReportProtocolTrace = 3;
static const uint16 ID_FatalError = 4;
static const uint16 ID_GeneralError = 5;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class DebugTraceConfigRequest;

class ProtocolTraceConfigRequest;

class ReportDebugTraceSignal;

class ReportProtocolTraceSignal;

class FatalErrorSignal;

class GeneralErrorSignal;

// type definitions
/**
 * If the meaning of "DebugTraceConfigResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DebugTraceConfigResponse;

/**
 * If the meaning of "DebugTraceConfigError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DebugTraceConfigError;

/**
 * If the meaning of "ProtocolTraceConfigResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ProtocolTraceConfigResponse;

/**
 * If the meaning of "ProtocolTraceConfigError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProtocolTraceConfigError;

/**
 * If the meaning of "ReportDebugTraceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReportDebugTraceError;

/**
 * If the meaning of "ReportProtocolTraceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReportProtocolTraceError;

/**
 * If the meaning of "FatalErrorError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FatalErrorError;

/**
 * If the meaning of "GeneralErrorError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GeneralErrorError;


/**
 * If the meaning of "DebugTraceConfigRequest" isn't clear, then there should be a description here.
 */
class DebugTraceConfigRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DebugTraceConfigRequest ();

    /**
     * Copy constructor
     */
    inline  DebugTraceConfigRequest (const DebugTraceConfigRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DebugTraceConfigRequest (uint8 level_, uint32 current_time_, uint8 mode_, uint32 category1_, uint32 category2_, uint32 category3_);

    /**
     * Destructor
     */
    inline virtual  ~DebugTraceConfigRequest();

    /**
     * Assignment operator
     */
    inline DebugTraceConfigRequest& operator = (const DebugTraceConfigRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DebugTraceConfigRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DebugTraceConfigRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DebugTraceConfigRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DebugTraceConfigRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "level"

    static const int kLevel = 0;

    /**
     * Clears the field "level".
     *
     * The field will be set to its default value. The hasLevel()
     * method will return false.
     */
    inline void clearLevel();

    /**
     * Checks whether the field "level" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLevel()). Otherwise it will return false.
     */
    inline bool hasLevel () const;

    /**
     * Returns the value of the member "level".
     *
     * If the meaning of "level" isn't clear, then there should be a description here.
     *
     * @return The value of the field "level"
     */
    inline uint8 getLevel () const;

    /**
     * Sets the value of the member "level".
     *
     * If the meaning of "level" isn't clear, then there should be a description here.
     *
     * @param level The value which will be set
     */
    inline void setLevel (uint8 level_);

    // API of field "current_time"

    static const int kCurrent_time = 1;

    /**
     * Clears the field "current_time".
     *
     * The field will be set to its default value. The hasCurrent_time()
     * method will return false.
     */
    inline void clearCurrent_time();

    /**
     * Checks whether the field "current_time" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrent_time()). Otherwise it will return false.
     */
    inline bool hasCurrent_time () const;

    /**
     * Returns the value of the member "current_time".
     *
     * If the meaning of "current_time" isn't clear, then there should be a description here.
     *
     * @return The value of the field "current_time"
     */
    inline uint32 getCurrent_time () const;

    /**
     * Sets the value of the member "current_time".
     *
     * If the meaning of "current_time" isn't clear, then there should be a description here.
     *
     * @param current_time The value which will be set
     */
    inline void setCurrent_time (uint32 current_time_);

    // API of field "mode"

    static const int kMode = 2;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline uint8 getMode () const;

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (uint8 mode_);

    // API of field "category1"

    static const int kCategory1 = 3;

    /**
     * Clears the field "category1".
     *
     * The field will be set to its default value. The hasCategory1()
     * method will return false.
     */
    inline void clearCategory1();

    /**
     * Checks whether the field "category1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategory1()). Otherwise it will return false.
     */
    inline bool hasCategory1 () const;

    /**
     * Returns the value of the member "category1".
     *
     * If the meaning of "category1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "category1"
     */
    inline uint32 getCategory1 () const;

    /**
     * Sets the value of the member "category1".
     *
     * If the meaning of "category1" isn't clear, then there should be a description here.
     *
     * @param category1 The value which will be set
     */
    inline void setCategory1 (uint32 category1_);

    // API of field "category2"

    static const int kCategory2 = 4;

    /**
     * Clears the field "category2".
     *
     * The field will be set to its default value. The hasCategory2()
     * method will return false.
     */
    inline void clearCategory2();

    /**
     * Checks whether the field "category2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategory2()). Otherwise it will return false.
     */
    inline bool hasCategory2 () const;

    /**
     * Returns the value of the member "category2".
     *
     * If the meaning of "category2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "category2"
     */
    inline uint32 getCategory2 () const;

    /**
     * Sets the value of the member "category2".
     *
     * If the meaning of "category2" isn't clear, then there should be a description here.
     *
     * @param category2 The value which will be set
     */
    inline void setCategory2 (uint32 category2_);

    // API of field "category3"

    static const int kCategory3 = 5;

    /**
     * Clears the field "category3".
     *
     * The field will be set to its default value. The hasCategory3()
     * method will return false.
     */
    inline void clearCategory3();

    /**
     * Checks whether the field "category3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategory3()). Otherwise it will return false.
     */
    inline bool hasCategory3 () const;

    /**
     * Returns the value of the member "category3".
     *
     * If the meaning of "category3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "category3"
     */
    inline uint32 getCategory3 () const;

    /**
     * Sets the value of the member "category3".
     *
     * If the meaning of "category3" isn't clear, then there should be a description here.
     *
     * @param category3 The value which will be set
     */
    inline void setCategory3 (uint32 category3_);

    static const DebugTraceConfigRequest &getDefaultInstance();

private:

    inline void set_has_level ();

    inline void clear_has_level ();

    inline void set_has_current_time ();

    inline void clear_has_current_time ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    inline void set_has_category1 ();

    inline void clear_has_category1 ();

    inline void set_has_category2 ();

    inline void clear_has_category2 ();

    inline void set_has_category3 ();

    inline void clear_has_category3 ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint8 _level;

    uint32 _current_time;

    uint8 _mode;

    uint32 _category1;

    uint32 _category2;

    uint32 _category3;

};

/**
 * If the meaning of "ProtocolTraceConfigRequest" isn't clear, then there should be a description here.
 */
class ProtocolTraceConfigRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProtocolTraceConfigRequest ();

    /**
     * Copy constructor
     */
    inline  ProtocolTraceConfigRequest (const ProtocolTraceConfigRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ProtocolTraceConfigRequest (uint16 filter_);

    /**
     * Destructor
     */
    inline virtual  ~ProtocolTraceConfigRequest();

    /**
     * Assignment operator
     */
    inline ProtocolTraceConfigRequest& operator = (const ProtocolTraceConfigRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProtocolTraceConfigRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProtocolTraceConfigRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProtocolTraceConfigRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProtocolTraceConfigRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "filter"

    static const int kFilter = 0;

    /**
     * Clears the field "filter".
     *
     * The field will be set to its default value. The hasFilter()
     * method will return false.
     */
    inline void clearFilter();

    /**
     * Checks whether the field "filter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilter()). Otherwise it will return false.
     */
    inline bool hasFilter () const;

    /**
     * Returns the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "filter"
     */
    inline uint16 getFilter () const;

    /**
     * Sets the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @param filter The value which will be set
     */
    inline void setFilter (uint16 filter_);

    static const ProtocolTraceConfigRequest &getDefaultInstance();

private:

    inline void set_has_filter ();

    inline void clear_has_filter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _filter;

};

/**
 * If the meaning of "ReportDebugTraceSignal" isn't clear, then there should be a description here.
 */
class ReportDebugTraceSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReportDebugTraceSignal ();

    /**
     * Copy constructor
     */
    inline  ReportDebugTraceSignal (const ReportDebugTraceSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ReportDebugTraceSignal (uint32 location_, uint8 level_, uint8 category_, uint16 error_code_, const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~ReportDebugTraceSignal();

    /**
     * Assignment operator
     */
    inline ReportDebugTraceSignal& operator = (const ReportDebugTraceSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReportDebugTraceSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReportDebugTraceSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReportDebugTraceSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReportDebugTraceSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "location"

    static const int kLocation = 0;

    /**
     * Clears the field "location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "location"
     */
    inline uint32 getLocation () const;

    /**
     * Sets the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @param location The value which will be set
     */
    inline void setLocation (uint32 location_);

    // API of field "level"

    static const int kLevel = 1;

    /**
     * Clears the field "level".
     *
     * The field will be set to its default value. The hasLevel()
     * method will return false.
     */
    inline void clearLevel();

    /**
     * Checks whether the field "level" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLevel()). Otherwise it will return false.
     */
    inline bool hasLevel () const;

    /**
     * Returns the value of the member "level".
     *
     * If the meaning of "level" isn't clear, then there should be a description here.
     *
     * @return The value of the field "level"
     */
    inline uint8 getLevel () const;

    /**
     * Sets the value of the member "level".
     *
     * If the meaning of "level" isn't clear, then there should be a description here.
     *
     * @param level The value which will be set
     */
    inline void setLevel (uint8 level_);

    // API of field "category"

    static const int kCategory = 2;

    /**
     * Clears the field "category".
     *
     * The field will be set to its default value. The hasCategory()
     * method will return false.
     */
    inline void clearCategory();

    /**
     * Checks whether the field "category" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategory()). Otherwise it will return false.
     */
    inline bool hasCategory () const;

    /**
     * Returns the value of the member "category".
     *
     * If the meaning of "category" isn't clear, then there should be a description here.
     *
     * @return The value of the field "category"
     */
    inline uint8 getCategory () const;

    /**
     * Sets the value of the member "category".
     *
     * If the meaning of "category" isn't clear, then there should be a description here.
     *
     * @param category The value which will be set
     */
    inline void setCategory (uint8 category_);

    // API of field "error_code"

    static const int kError_code = 3;

    /**
     * Clears the field "error_code".
     *
     * The field will be set to its default value. The hasError_code()
     * method will return false.
     */
    inline void clearError_code();

    /**
     * Checks whether the field "error_code" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError_code()). Otherwise it will return false.
     */
    inline bool hasError_code () const;

    /**
     * Returns the value of the member "error_code".
     *
     * If the meaning of "error_code" isn't clear, then there should be a description here.
     *
     * @return The value of the field "error_code"
     */
    inline uint16 getError_code () const;

    /**
     * Sets the value of the member "error_code".
     *
     * If the meaning of "error_code" isn't clear, then there should be a description here.
     *
     * @param error_code The value which will be set
     */
    inline void setError_code (uint16 error_code_);

    // API of field "data"

    static const int kData = 4;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const ReportDebugTraceSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_location ();

    inline void clear_has_location ();

    inline void set_has_level ();

    inline void clear_has_level ();

    inline void set_has_category ();

    inline void clear_has_category ();

    inline void set_has_error_code ();

    inline void clear_has_error_code ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _location;

    uint8 _level;

    uint8 _category;

    uint16 _error_code;

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "ReportProtocolTraceSignal" isn't clear, then there should be a description here.
 */
class ReportProtocolTraceSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReportProtocolTraceSignal ();

    /**
     * Copy constructor
     */
    inline  ReportProtocolTraceSignal (const ReportProtocolTraceSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ReportProtocolTraceSignal (uint16 type_, uint8 direction_, const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~ReportProtocolTraceSignal();

    /**
     * Assignment operator
     */
    inline ReportProtocolTraceSignal& operator = (const ReportProtocolTraceSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReportProtocolTraceSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReportProtocolTraceSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReportProtocolTraceSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReportProtocolTraceSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "type"

    static const int kType = 0;

    /**
     * Clears the field "type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "type".
     *
     * If the meaning of "type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "type"
     */
    inline uint16 getType () const;

    /**
     * Sets the value of the member "type".
     *
     * If the meaning of "type" isn't clear, then there should be a description here.
     *
     * @param type The value which will be set
     */
    inline void setType (uint16 type_);

    // API of field "direction"

    static const int kDirection = 1;

    /**
     * Clears the field "direction".
     *
     * The field will be set to its default value. The hasDirection()
     * method will return false.
     */
    inline void clearDirection();

    /**
     * Checks whether the field "direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirection()). Otherwise it will return false.
     */
    inline bool hasDirection () const;

    /**
     * Returns the value of the member "direction".
     *
     * If the meaning of "direction" isn't clear, then there should be a description here.
     *
     * @return The value of the field "direction"
     */
    inline uint8 getDirection () const;

    /**
     * Sets the value of the member "direction".
     *
     * If the meaning of "direction" isn't clear, then there should be a description here.
     *
     * @param direction The value which will be set
     */
    inline void setDirection (uint8 direction_);

    // API of field "data"

    static const int kData = 2;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const ReportProtocolTraceSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_type ();

    inline void clear_has_type ();

    inline void set_has_direction ();

    inline void clear_has_direction ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _type;

    uint8 _direction;

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "FatalErrorSignal" isn't clear, then there should be a description here.
 */
class FatalErrorSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FatalErrorSignal ();

    /**
     * Copy constructor
     */
    inline  FatalErrorSignal (const FatalErrorSignal &rhs);

    /**
     * All fields constructor
     */
    inline  FatalErrorSignal (uint32 err_localtion_, uint32 err_type_);

    /**
     * Destructor
     */
    inline virtual  ~FatalErrorSignal();

    /**
     * Assignment operator
     */
    inline FatalErrorSignal& operator = (const FatalErrorSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FatalErrorSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FatalErrorSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FatalErrorSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FatalErrorSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "err_localtion"

    static const int kErr_localtion = 0;

    /**
     * Clears the field "err_localtion".
     *
     * The field will be set to its default value. The hasErr_localtion()
     * method will return false.
     */
    inline void clearErr_localtion();

    /**
     * Checks whether the field "err_localtion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErr_localtion()). Otherwise it will return false.
     */
    inline bool hasErr_localtion () const;

    /**
     * Returns the value of the member "err_localtion".
     *
     * If the meaning of "err_localtion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "err_localtion"
     */
    inline uint32 getErr_localtion () const;

    /**
     * Sets the value of the member "err_localtion".
     *
     * If the meaning of "err_localtion" isn't clear, then there should be a description here.
     *
     * @param err_localtion The value which will be set
     */
    inline void setErr_localtion (uint32 err_localtion_);

    // API of field "err_type"

    static const int kErr_type = 1;

    /**
     * Clears the field "err_type".
     *
     * The field will be set to its default value. The hasErr_type()
     * method will return false.
     */
    inline void clearErr_type();

    /**
     * Checks whether the field "err_type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErr_type()). Otherwise it will return false.
     */
    inline bool hasErr_type () const;

    /**
     * Returns the value of the member "err_type".
     *
     * If the meaning of "err_type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "err_type"
     */
    inline uint32 getErr_type () const;

    /**
     * Sets the value of the member "err_type".
     *
     * If the meaning of "err_type" isn't clear, then there should be a description here.
     *
     * @param err_type The value which will be set
     */
    inline void setErr_type (uint32 err_type_);

    static const FatalErrorSignal &getDefaultInstance();

private:

    inline void set_has_err_localtion ();

    inline void clear_has_err_localtion ();

    inline void set_has_err_type ();

    inline void clear_has_err_type ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _err_localtion;

    uint32 _err_type;

};

/**
 * If the meaning of "GeneralErrorSignal" isn't clear, then there should be a description here.
 */
class GeneralErrorSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GeneralErrorSignal ();

    /**
     * Copy constructor
     */
    inline  GeneralErrorSignal (const GeneralErrorSignal &rhs);

    /**
     * All fields constructor
     */
    inline  GeneralErrorSignal (uint8 status_, uint16 op_code_);

    /**
     * Destructor
     */
    inline virtual  ~GeneralErrorSignal();

    /**
     * Assignment operator
     */
    inline GeneralErrorSignal& operator = (const GeneralErrorSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneralErrorSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneralErrorSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneralErrorSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneralErrorSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    // API of field "op_code"

    static const int kOp_code = 1;

    /**
     * Clears the field "op_code".
     *
     * The field will be set to its default value. The hasOp_code()
     * method will return false.
     */
    inline void clearOp_code();

    /**
     * Checks whether the field "op_code" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOp_code()). Otherwise it will return false.
     */
    inline bool hasOp_code () const;

    /**
     * Returns the value of the member "op_code".
     *
     * If the meaning of "op_code" isn't clear, then there should be a description here.
     *
     * @return The value of the field "op_code"
     */
    inline uint16 getOp_code () const;

    /**
     * Sets the value of the member "op_code".
     *
     * If the meaning of "op_code" isn't clear, then there should be a description here.
     *
     * @param op_code The value which will be set
     */
    inline void setOp_code (uint16 op_code_);

    static const GeneralErrorSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_op_code ();

    inline void clear_has_op_code ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _status;

    uint16 _op_code;

};

inline  DebugTraceConfigRequest::DebugTraceConfigRequest ()  :
    _level (0u),
    _current_time (0u),
    _mode (0u),
    _category1 (0u),
    _category2 (0u),
    _category3 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DebugTraceConfigRequest::DebugTraceConfigRequest (const DebugTraceConfigRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _level (0u),
    _current_time (0u),
    _mode (0u),
    _category1 (0u),
    _category2 (0u),
    _category3 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DebugTraceConfigRequest::DebugTraceConfigRequest (uint8 level_, uint32 current_time_, uint8 mode_, uint32 category1_, uint32 category2_, uint32 category3_)  :
    _level (level_),
    _current_time (current_time_),
    _mode (mode_),
    _category1 (category1_),
    _category2 (category2_),
    _category3 (category3_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DebugTraceConfigRequest::~DebugTraceConfigRequest() {
}

inline DebugTraceConfigRequest& DebugTraceConfigRequest::operator = (const DebugTraceConfigRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLevel()) {
            setLevel(rhs.getLevel());
        } else {
            clearLevel();
        }
        if (rhs.hasCurrent_time()) {
            setCurrent_time(rhs.getCurrent_time());
        } else {
            clearCurrent_time();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
        if (rhs.hasCategory1()) {
            setCategory1(rhs.getCategory1());
        } else {
            clearCategory1();
        }
        if (rhs.hasCategory2()) {
            setCategory2(rhs.getCategory2());
        } else {
            clearCategory2();
        }
        if (rhs.hasCategory3()) {
            setCategory3(rhs.getCategory3());
        } else {
            clearCategory3();
        }
    }
    return *this;
}

inline bool DebugTraceConfigRequest::operator == (const DebugTraceConfigRequest& rhs) const {
    return (((!hasLevel() && !rhs.hasLevel()) || getLevel() == rhs.getLevel()) &&
        ((!hasCurrent_time() && !rhs.hasCurrent_time()) || getCurrent_time() == rhs.getCurrent_time()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()) &&
        ((!hasCategory1() && !rhs.hasCategory1()) || getCategory1() == rhs.getCategory1()) &&
        ((!hasCategory2() && !rhs.hasCategory2()) || getCategory2() == rhs.getCategory2()) &&
        ((!hasCategory3() && !rhs.hasCategory3()) || getCategory3() == rhs.getCategory3()));
}

inline bool DebugTraceConfigRequest::operator != (const DebugTraceConfigRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DebugTraceConfigRequest::operator < (const DebugTraceConfigRequest& rhs) const {
    if (hasLevel() || rhs.hasLevel()) {
        if (getLevel() < rhs.getLevel()) return true;
        if (getLevel() > rhs.getLevel()) return false;
    }
    if (hasCurrent_time() || rhs.hasCurrent_time()) {
        if (getCurrent_time() < rhs.getCurrent_time()) return true;
        if (getCurrent_time() > rhs.getCurrent_time()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    if (hasCategory1() || rhs.hasCategory1()) {
        if (getCategory1() < rhs.getCategory1()) return true;
        if (getCategory1() > rhs.getCategory1()) return false;
    }
    if (hasCategory2() || rhs.hasCategory2()) {
        if (getCategory2() < rhs.getCategory2()) return true;
        if (getCategory2() > rhs.getCategory2()) return false;
    }
    if (hasCategory3() || rhs.hasCategory3()) {
        if (getCategory3() < rhs.getCategory3()) return true;
        if (getCategory3() > rhs.getCategory3()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DebugTraceConfigRequest::clone() {
    return new DebugTraceConfigRequest(*this);
}

inline bool DebugTraceConfigRequest::operator > (const DebugTraceConfigRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DebugTraceConfigRequest::clear() {
    clearLevel();
    clearCurrent_time();
    clearMode();
    clearCategory1();
    clearCategory2();
    clearCategory3();
}

inline void DebugTraceConfigRequest::clearLevel() {
    if (hasLevel()) {
         clear_has_level();
        _level = 0u;
     }
}

inline bool DebugTraceConfigRequest::hasLevel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DebugTraceConfigRequest::getLevel () const {
    return _level;
}

inline void DebugTraceConfigRequest::setLevel (uint8 level_) {
    set_has_level();
    this->_level = level_;
}

inline void DebugTraceConfigRequest::clearCurrent_time() {
    if (hasCurrent_time()) {
         clear_has_current_time();
        _current_time = 0u;
     }
}

inline bool DebugTraceConfigRequest::hasCurrent_time () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DebugTraceConfigRequest::getCurrent_time () const {
    return _current_time;
}

inline void DebugTraceConfigRequest::setCurrent_time (uint32 current_time_) {
    set_has_current_time();
    this->_current_time = current_time_;
}

inline void DebugTraceConfigRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode = 0u;
     }
}

inline bool DebugTraceConfigRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 DebugTraceConfigRequest::getMode () const {
    return _mode;
}

inline void DebugTraceConfigRequest::setMode (uint8 mode_) {
    set_has_mode();
    this->_mode = mode_;
}

inline void DebugTraceConfigRequest::clearCategory1() {
    if (hasCategory1()) {
         clear_has_category1();
        _category1 = 0u;
     }
}

inline bool DebugTraceConfigRequest::hasCategory1 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 DebugTraceConfigRequest::getCategory1 () const {
    return _category1;
}

inline void DebugTraceConfigRequest::setCategory1 (uint32 category1_) {
    set_has_category1();
    this->_category1 = category1_;
}

inline void DebugTraceConfigRequest::clearCategory2() {
    if (hasCategory2()) {
         clear_has_category2();
        _category2 = 0u;
     }
}

inline bool DebugTraceConfigRequest::hasCategory2 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 DebugTraceConfigRequest::getCategory2 () const {
    return _category2;
}

inline void DebugTraceConfigRequest::setCategory2 (uint32 category2_) {
    set_has_category2();
    this->_category2 = category2_;
}

inline void DebugTraceConfigRequest::clearCategory3() {
    if (hasCategory3()) {
         clear_has_category3();
        _category3 = 0u;
     }
}

inline bool DebugTraceConfigRequest::hasCategory3 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 DebugTraceConfigRequest::getCategory3 () const {
    return _category3;
}

inline void DebugTraceConfigRequest::setCategory3 (uint32 category3_) {
    set_has_category3();
    this->_category3 = category3_;
}

inline void DebugTraceConfigRequest::set_has_level () {
    _has_bits_[0] |= 1u << 0;
}

inline void DebugTraceConfigRequest::clear_has_level () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DebugTraceConfigRequest::set_has_current_time () {
    _has_bits_[0] |= 1u << 1;
}

inline void DebugTraceConfigRequest::clear_has_current_time () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DebugTraceConfigRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 2;
}

inline void DebugTraceConfigRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DebugTraceConfigRequest::set_has_category1 () {
    _has_bits_[0] |= 1u << 3;
}

inline void DebugTraceConfigRequest::clear_has_category1 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void DebugTraceConfigRequest::set_has_category2 () {
    _has_bits_[0] |= 1u << 4;
}

inline void DebugTraceConfigRequest::clear_has_category2 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void DebugTraceConfigRequest::set_has_category3 () {
    _has_bits_[0] |= 1u << 5;
}

inline void DebugTraceConfigRequest::clear_has_category3 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  ProtocolTraceConfigRequest::ProtocolTraceConfigRequest ()  :
    _filter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProtocolTraceConfigRequest::ProtocolTraceConfigRequest (const ProtocolTraceConfigRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _filter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProtocolTraceConfigRequest::ProtocolTraceConfigRequest (uint16 filter_)  :
    _filter (filter_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProtocolTraceConfigRequest::~ProtocolTraceConfigRequest() {
}

inline ProtocolTraceConfigRequest& ProtocolTraceConfigRequest::operator = (const ProtocolTraceConfigRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFilter()) {
            setFilter(rhs.getFilter());
        } else {
            clearFilter();
        }
    }
    return *this;
}

inline bool ProtocolTraceConfigRequest::operator == (const ProtocolTraceConfigRequest& rhs) const {
    return (((!hasFilter() && !rhs.hasFilter()) || getFilter() == rhs.getFilter()));
}

inline bool ProtocolTraceConfigRequest::operator != (const ProtocolTraceConfigRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ProtocolTraceConfigRequest::operator < (const ProtocolTraceConfigRequest& rhs) const {
    if (hasFilter() || rhs.hasFilter()) {
        if (getFilter() < rhs.getFilter()) return true;
        if (getFilter() > rhs.getFilter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProtocolTraceConfigRequest::clone() {
    return new ProtocolTraceConfigRequest(*this);
}

inline bool ProtocolTraceConfigRequest::operator > (const ProtocolTraceConfigRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProtocolTraceConfigRequest::clear() {
    clearFilter();
}

inline void ProtocolTraceConfigRequest::clearFilter() {
    if (hasFilter()) {
         clear_has_filter();
        _filter = 0u;
     }
}

inline bool ProtocolTraceConfigRequest::hasFilter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 ProtocolTraceConfigRequest::getFilter () const {
    return _filter;
}

inline void ProtocolTraceConfigRequest::setFilter (uint16 filter_) {
    set_has_filter();
    this->_filter = filter_;
}

inline void ProtocolTraceConfigRequest::set_has_filter () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProtocolTraceConfigRequest::clear_has_filter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReportDebugTraceSignal::ReportDebugTraceSignal ()  :
    _location (0u),
    _level (0u),
    _category (0u),
    _error_code (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReportDebugTraceSignal::ReportDebugTraceSignal (const ReportDebugTraceSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _location (0u),
    _level (0u),
    _category (0u),
    _error_code (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReportDebugTraceSignal::ReportDebugTraceSignal (uint32 location_, uint8 level_, uint8 category_, uint16 error_code_, const ::std::vector< uint8 >& data_)  :
    _location (location_),
    _level (level_),
    _category (category_),
    _error_code (error_code_),
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReportDebugTraceSignal::~ReportDebugTraceSignal() {
}

inline ReportDebugTraceSignal& ReportDebugTraceSignal::operator = (const ReportDebugTraceSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLocation()) {
            setLocation(rhs.getLocation());
        } else {
            clearLocation();
        }
        if (rhs.hasLevel()) {
            setLevel(rhs.getLevel());
        } else {
            clearLevel();
        }
        if (rhs.hasCategory()) {
            setCategory(rhs.getCategory());
        } else {
            clearCategory();
        }
        if (rhs.hasError_code()) {
            setError_code(rhs.getError_code());
        } else {
            clearError_code();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool ReportDebugTraceSignal::operator == (const ReportDebugTraceSignal& rhs) const {
    return (((!hasLocation() && !rhs.hasLocation()) || getLocation() == rhs.getLocation()) &&
        ((!hasLevel() && !rhs.hasLevel()) || getLevel() == rhs.getLevel()) &&
        ((!hasCategory() && !rhs.hasCategory()) || getCategory() == rhs.getCategory()) &&
        ((!hasError_code() && !rhs.hasError_code()) || getError_code() == rhs.getError_code()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool ReportDebugTraceSignal::operator != (const ReportDebugTraceSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ReportDebugTraceSignal::operator < (const ReportDebugTraceSignal& rhs) const {
    if (hasLocation() || rhs.hasLocation()) {
        if (getLocation() < rhs.getLocation()) return true;
        if (getLocation() > rhs.getLocation()) return false;
    }
    if (hasLevel() || rhs.hasLevel()) {
        if (getLevel() < rhs.getLevel()) return true;
        if (getLevel() > rhs.getLevel()) return false;
    }
    if (hasCategory() || rhs.hasCategory()) {
        if (getCategory() < rhs.getCategory()) return true;
        if (getCategory() > rhs.getCategory()) return false;
    }
    if (hasError_code() || rhs.hasError_code()) {
        if (getError_code() < rhs.getError_code()) return true;
        if (getError_code() > rhs.getError_code()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReportDebugTraceSignal::clone() {
    return new ReportDebugTraceSignal(*this);
}

inline bool ReportDebugTraceSignal::operator > (const ReportDebugTraceSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReportDebugTraceSignal::clear() {
    clearLocation();
    clearLevel();
    clearCategory();
    clearError_code();
    clearData();
}

inline void ReportDebugTraceSignal::clearLocation() {
    if (hasLocation()) {
         clear_has_location();
        _location = 0u;
     }
}

inline bool ReportDebugTraceSignal::hasLocation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ReportDebugTraceSignal::getLocation () const {
    return _location;
}

inline void ReportDebugTraceSignal::setLocation (uint32 location_) {
    set_has_location();
    this->_location = location_;
}

inline void ReportDebugTraceSignal::clearLevel() {
    if (hasLevel()) {
         clear_has_level();
        _level = 0u;
     }
}

inline bool ReportDebugTraceSignal::hasLevel () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReportDebugTraceSignal::getLevel () const {
    return _level;
}

inline void ReportDebugTraceSignal::setLevel (uint8 level_) {
    set_has_level();
    this->_level = level_;
}

inline void ReportDebugTraceSignal::clearCategory() {
    if (hasCategory()) {
         clear_has_category();
        _category = 0u;
     }
}

inline bool ReportDebugTraceSignal::hasCategory () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 ReportDebugTraceSignal::getCategory () const {
    return _category;
}

inline void ReportDebugTraceSignal::setCategory (uint8 category_) {
    set_has_category();
    this->_category = category_;
}

inline void ReportDebugTraceSignal::clearError_code() {
    if (hasError_code()) {
         clear_has_error_code();
        _error_code = 0u;
     }
}

inline bool ReportDebugTraceSignal::hasError_code () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 ReportDebugTraceSignal::getError_code () const {
    return _error_code;
}

inline void ReportDebugTraceSignal::setError_code (uint16 error_code_) {
    set_has_error_code();
    this->_error_code = error_code_;
}

inline void ReportDebugTraceSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool ReportDebugTraceSignal::hasData () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::vector< uint8 >& ReportDebugTraceSignal::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& ReportDebugTraceSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void ReportDebugTraceSignal::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void ReportDebugTraceSignal::set_has_location () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReportDebugTraceSignal::clear_has_location () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReportDebugTraceSignal::set_has_level () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReportDebugTraceSignal::clear_has_level () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReportDebugTraceSignal::set_has_category () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReportDebugTraceSignal::clear_has_category () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReportDebugTraceSignal::set_has_error_code () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReportDebugTraceSignal::clear_has_error_code () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ReportDebugTraceSignal::set_has_data () {
    _has_bits_[0] |= 1u << 4;
}

inline void ReportDebugTraceSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  ReportProtocolTraceSignal::ReportProtocolTraceSignal ()  :
    _type (0u),
    _direction (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReportProtocolTraceSignal::ReportProtocolTraceSignal (const ReportProtocolTraceSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _type (0u),
    _direction (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReportProtocolTraceSignal::ReportProtocolTraceSignal (uint16 type_, uint8 direction_, const ::std::vector< uint8 >& data_)  :
    _type (type_),
    _direction (direction_),
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReportProtocolTraceSignal::~ReportProtocolTraceSignal() {
}

inline ReportProtocolTraceSignal& ReportProtocolTraceSignal::operator = (const ReportProtocolTraceSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
        if (rhs.hasDirection()) {
            setDirection(rhs.getDirection());
        } else {
            clearDirection();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool ReportProtocolTraceSignal::operator == (const ReportProtocolTraceSignal& rhs) const {
    return (((!hasType() && !rhs.hasType()) || getType() == rhs.getType()) &&
        ((!hasDirection() && !rhs.hasDirection()) || getDirection() == rhs.getDirection()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool ReportProtocolTraceSignal::operator != (const ReportProtocolTraceSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ReportProtocolTraceSignal::operator < (const ReportProtocolTraceSignal& rhs) const {
    if (hasType() || rhs.hasType()) {
        if (getType() < rhs.getType()) return true;
        if (getType() > rhs.getType()) return false;
    }
    if (hasDirection() || rhs.hasDirection()) {
        if (getDirection() < rhs.getDirection()) return true;
        if (getDirection() > rhs.getDirection()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReportProtocolTraceSignal::clone() {
    return new ReportProtocolTraceSignal(*this);
}

inline bool ReportProtocolTraceSignal::operator > (const ReportProtocolTraceSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReportProtocolTraceSignal::clear() {
    clearType();
    clearDirection();
    clearData();
}

inline void ReportProtocolTraceSignal::clearType() {
    if (hasType()) {
         clear_has_type();
        _type = 0u;
     }
}

inline bool ReportProtocolTraceSignal::hasType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 ReportProtocolTraceSignal::getType () const {
    return _type;
}

inline void ReportProtocolTraceSignal::setType (uint16 type_) {
    set_has_type();
    this->_type = type_;
}

inline void ReportProtocolTraceSignal::clearDirection() {
    if (hasDirection()) {
         clear_has_direction();
        _direction = 0u;
     }
}

inline bool ReportProtocolTraceSignal::hasDirection () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReportProtocolTraceSignal::getDirection () const {
    return _direction;
}

inline void ReportProtocolTraceSignal::setDirection (uint8 direction_) {
    set_has_direction();
    this->_direction = direction_;
}

inline void ReportProtocolTraceSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool ReportProtocolTraceSignal::hasData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint8 >& ReportProtocolTraceSignal::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& ReportProtocolTraceSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void ReportProtocolTraceSignal::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void ReportProtocolTraceSignal::set_has_type () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReportProtocolTraceSignal::clear_has_type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReportProtocolTraceSignal::set_has_direction () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReportProtocolTraceSignal::clear_has_direction () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReportProtocolTraceSignal::set_has_data () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReportProtocolTraceSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  FatalErrorSignal::FatalErrorSignal ()  :
    _err_localtion (0u),
    _err_type (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FatalErrorSignal::FatalErrorSignal (const FatalErrorSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _err_localtion (0u),
    _err_type (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FatalErrorSignal::FatalErrorSignal (uint32 err_localtion_, uint32 err_type_)  :
    _err_localtion (err_localtion_),
    _err_type (err_type_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FatalErrorSignal::~FatalErrorSignal() {
}

inline FatalErrorSignal& FatalErrorSignal::operator = (const FatalErrorSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErr_localtion()) {
            setErr_localtion(rhs.getErr_localtion());
        } else {
            clearErr_localtion();
        }
        if (rhs.hasErr_type()) {
            setErr_type(rhs.getErr_type());
        } else {
            clearErr_type();
        }
    }
    return *this;
}

inline bool FatalErrorSignal::operator == (const FatalErrorSignal& rhs) const {
    return (((!hasErr_localtion() && !rhs.hasErr_localtion()) || getErr_localtion() == rhs.getErr_localtion()) &&
        ((!hasErr_type() && !rhs.hasErr_type()) || getErr_type() == rhs.getErr_type()));
}

inline bool FatalErrorSignal::operator != (const FatalErrorSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool FatalErrorSignal::operator < (const FatalErrorSignal& rhs) const {
    if (hasErr_localtion() || rhs.hasErr_localtion()) {
        if (getErr_localtion() < rhs.getErr_localtion()) return true;
        if (getErr_localtion() > rhs.getErr_localtion()) return false;
    }
    if (hasErr_type() || rhs.hasErr_type()) {
        if (getErr_type() < rhs.getErr_type()) return true;
        if (getErr_type() > rhs.getErr_type()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FatalErrorSignal::clone() {
    return new FatalErrorSignal(*this);
}

inline bool FatalErrorSignal::operator > (const FatalErrorSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FatalErrorSignal::clear() {
    clearErr_localtion();
    clearErr_type();
}

inline void FatalErrorSignal::clearErr_localtion() {
    if (hasErr_localtion()) {
         clear_has_err_localtion();
        _err_localtion = 0u;
     }
}

inline bool FatalErrorSignal::hasErr_localtion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 FatalErrorSignal::getErr_localtion () const {
    return _err_localtion;
}

inline void FatalErrorSignal::setErr_localtion (uint32 err_localtion_) {
    set_has_err_localtion();
    this->_err_localtion = err_localtion_;
}

inline void FatalErrorSignal::clearErr_type() {
    if (hasErr_type()) {
         clear_has_err_type();
        _err_type = 0u;
     }
}

inline bool FatalErrorSignal::hasErr_type () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 FatalErrorSignal::getErr_type () const {
    return _err_type;
}

inline void FatalErrorSignal::setErr_type (uint32 err_type_) {
    set_has_err_type();
    this->_err_type = err_type_;
}

inline void FatalErrorSignal::set_has_err_localtion () {
    _has_bits_[0] |= 1u << 0;
}

inline void FatalErrorSignal::clear_has_err_localtion () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FatalErrorSignal::set_has_err_type () {
    _has_bits_[0] |= 1u << 1;
}

inline void FatalErrorSignal::clear_has_err_type () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GeneralErrorSignal::GeneralErrorSignal ()  :
    _status (0u),
    _op_code (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GeneralErrorSignal::GeneralErrorSignal (const GeneralErrorSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u),
    _op_code (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GeneralErrorSignal::GeneralErrorSignal (uint8 status_, uint16 op_code_)  :
    _status (status_),
    _op_code (op_code_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GeneralErrorSignal::~GeneralErrorSignal() {
}

inline GeneralErrorSignal& GeneralErrorSignal::operator = (const GeneralErrorSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasOp_code()) {
            setOp_code(rhs.getOp_code());
        } else {
            clearOp_code();
        }
    }
    return *this;
}

inline bool GeneralErrorSignal::operator == (const GeneralErrorSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasOp_code() && !rhs.hasOp_code()) || getOp_code() == rhs.getOp_code()));
}

inline bool GeneralErrorSignal::operator != (const GeneralErrorSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool GeneralErrorSignal::operator < (const GeneralErrorSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasOp_code() || rhs.hasOp_code()) {
        if (getOp_code() < rhs.getOp_code()) return true;
        if (getOp_code() > rhs.getOp_code()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GeneralErrorSignal::clone() {
    return new GeneralErrorSignal(*this);
}

inline bool GeneralErrorSignal::operator > (const GeneralErrorSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GeneralErrorSignal::clear() {
    clearStatus();
    clearOp_code();
}

inline void GeneralErrorSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool GeneralErrorSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GeneralErrorSignal::getStatus () const {
    return _status;
}

inline void GeneralErrorSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void GeneralErrorSignal::clearOp_code() {
    if (hasOp_code()) {
         clear_has_op_code();
        _op_code = 0u;
     }
}

inline bool GeneralErrorSignal::hasOp_code () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 GeneralErrorSignal::getOp_code () const {
    return _op_code;
}

inline void GeneralErrorSignal::setOp_code (uint16 op_code_) {
    set_has_op_code();
    this->_op_code = op_code_;
}

inline void GeneralErrorSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void GeneralErrorSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GeneralErrorSignal::set_has_op_code () {
    _has_bits_[0] |= 1u << 1;
}

inline void GeneralErrorSignal::clear_has_op_code () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace Trace
} // namespace evo
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_EVO_TRACE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
