/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_SERIALSTUB_H
#define ORG_BLUEZ_SERIALSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/Serial.h"
#include <string>
#include <vector>

namespace org {
namespace bluez {
namespace Serial {

class SerialStubDelegate;

class SerialStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the SerialStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    SerialStub (const std::string& portName);

    /**
     * Create an instance of the SerialStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    SerialStub (const std::string& portName, const std::string& objectPath);

    virtual ~SerialStub();

    // signal 'SppDataInd'

    /**
     * Raise the signal 'SppDataInd' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'SppDataInd'</b>:
     *
     * If the meaning of "SppDataInd" isn't clear, then there should be a description here.
     */
    void sendSppDataIndSignal(const ::std::vector< uint8 >& data);

    // signal 'FlowCtrlSend'

    /**
     * Raise the signal 'FlowCtrlSend' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'FlowCtrlSend'</b>:
     *
     * If the meaning of "FlowCtrlSend" isn't clear, then there should be a description here.
     */
    void sendFlowCtrlSendSignal(const ::std::string& status);

    // signal 'DeviceFilePath'

    /**
     * Raise the signal 'DeviceFilePath' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'DeviceFilePath'</b>:
     *
     * If the meaning of "DeviceFilePath" isn't clear, then there should be a description here.
     */
    void sendDeviceFilePathSignal(const ::std::vector< uint8 >& path);

    // property 'FlowCtrlRecv'

    /**
     * The method onFlowCtrlRecvGet() is called by ASF when a client invokes
     * the read method for the property 'FlowCtrlRecv'. The
     * onFlowCtrlRecvGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'FlowCtrlRecv'</b>:
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     */
    virtual void onFlowCtrlRecvGet(const ::boost::shared_ptr< FlowCtrlRecvGet >& payload);

    /**
     * Sends back the update to a previous onFlowCtrlRecvGet().
     *
     * <b>Documentation of 'FlowCtrlRecv'</b>:
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onFlowCtrlRecvGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendFlowCtrlRecvGetUpdate(const ::std::string& flowCtrlRecv, act_t act = 0);

    /**
     * The method onFlowCtrlRecvSet() is called by ASF when a client invokes
     * the write method for the property 'FlowCtrlRecv'. The
     * onFlowCtrlRecvSet() method set property value to the given parameter
     * FlowCtrlRecv by default. If this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'FlowCtrlRecv'</b>:
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     */
    virtual void onFlowCtrlRecvSet(const ::boost::shared_ptr< FlowCtrlRecvSet >& payload);

    /**
     * Sends back the update to a previous onFlowCtrlRecvSet().
     *
     * <b>Documentation of 'FlowCtrlRecv'</b>:
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onFlowCtrlRecvSet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendFlowCtrlRecvSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'FlowCtrlRecv' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'FlowCtrlRecv'</b>:
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     */
    void setFlowCtrlRecv(const ::std::string& flowCtrlRecv);

    /**
     * Returns the current value of the property 'FlowCtrlRecv'.
     *
     * <b>Documentation of 'FlowCtrlRecv'</b>:
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     */
    const ::std::string& getFlowCtrlRecv() const;

    /**
     * Returns the current value of the property 'FlowCtrlRecv' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendFlowCtrlRecvUpdate() method.
     *
     * <b>Documentation of 'FlowCtrlRecv'</b>:
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     */
    ::std::string& getFlowCtrlRecvMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFlowCtrlRecvUpdate().
     *
     * <b>Documentation of 'FlowCtrlRecv'</b>:
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     */
    void sendFlowCtrlRecvUpdate();

    // property 'device_name'

    /**
     * The method onDevice_nameGet() is called by ASF when a client invokes
     * the read method for the property 'device_name'. The onDevice_nameGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'device_name'</b>:
     *
     * If the meaning of "device_name" isn't clear, then there should be a description here.
     */
    virtual void onDevice_nameGet(const ::boost::shared_ptr< Device_nameGet >& payload);

    /**
     * Sends back the update to a previous onDevice_nameGet().
     *
     * <b>Documentation of 'device_name'</b>:
     *
     * If the meaning of "device_name" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onDevice_nameGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDevice_nameGetUpdate(const ::std::vector< uint8 >& device_name, act_t act = 0);

    /**
     * Set the value of the property 'device_name' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'device_name'</b>:
     *
     * If the meaning of "device_name" isn't clear, then there should be a description here.
     */
    void setDevice_name(const ::std::vector< uint8 >& device_name);

    /**
     * Returns the current value of the property 'device_name'.
     *
     * <b>Documentation of 'device_name'</b>:
     *
     * If the meaning of "device_name" isn't clear, then there should be a description here.
     */
    const ::std::vector< uint8 >& getDevice_name() const;

    /**
     * Returns the current value of the property 'device_name' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendDevice_nameUpdate() method.
     *
     * <b>Documentation of 'device_name'</b>:
     *
     * If the meaning of "device_name" isn't clear, then there should be a description here.
     */
    ::std::vector< uint8 >& getDevice_nameMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDevice_nameUpdate().
     *
     * <b>Documentation of 'device_name'</b>:
     *
     * If the meaning of "device_name" isn't clear, then there should be a description here.
     */
    void sendDevice_nameUpdate();

    // method 'SendData'

    /**
     * The method onSendData() is called by ASF when a client invokes the
     * method 'SendData'. A subclass has to implement this method and send
     * back a response to the client either with the sendSendData() or
     * sendSendDataError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SendData'</b>:
     *
     * If the meaning of "SendData" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSendDataRequest (const ::boost::shared_ptr< SendDataRequest >& request) = 0;

    /**
     * The method sendSendDataResponse() sends a response of a previous method
     * invocation of 'SendData' back to the client.
     *
     * <b>Documentation of 'SendData'</b>:
     *
     * If the meaning of "SendData" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSendData(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSendDataResponse (act_t act = 0);

    /**
     * The method sendSendDataError() sends an error response of a previous
     * method invocation of 'SendData' back to the client.
     *
     * <b>Documentation of 'SendData'</b>:
     *
     * If the meaning of "SendData" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSendData(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSendDataError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    FlowCtrlRecvUpdate _FlowCtrlRecvProperty;

    Device_nameUpdate _device_nameProperty;

    friend class SerialStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Serial
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_SERIALSTUB_H
