/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_SERIALPROXY_H
#define ORG_BLUEZ_SERIALPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/Serial.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace org {
namespace bluez {
namespace Serial {

class SerialProxy;

class DeviceFilePathCallbackIF {
public:
    virtual ~DeviceFilePathCallbackIF() {}

    virtual void onDeviceFilePathError(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< DeviceFilePathError >& error) = 0;

    virtual void onDeviceFilePathSignal(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< DeviceFilePathSignal >& signal) = 0;
};

class Device_nameCallbackIF {
public:
    virtual ~Device_nameCallbackIF() {}

    virtual void onDevice_nameError(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< Device_nameError >& error) = 0;

    virtual void onDevice_nameUpdate(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< Device_nameUpdate >& update) = 0;
};

class FlowCtrlRecvCallbackIF {
public:
    virtual ~FlowCtrlRecvCallbackIF() {}

    virtual void onFlowCtrlRecvError(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< FlowCtrlRecvError >& error) = 0;

    virtual void onFlowCtrlRecvUpdate(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< FlowCtrlRecvUpdate >& update) = 0;
};

class FlowCtrlSendCallbackIF {
public:
    virtual ~FlowCtrlSendCallbackIF() {}

    virtual void onFlowCtrlSendError(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< FlowCtrlSendError >& error) = 0;

    virtual void onFlowCtrlSendSignal(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< FlowCtrlSendSignal >& signal) = 0;
};

class SendDataCallbackIF {
public:
    virtual ~SendDataCallbackIF() {}

    virtual void onSendDataError(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< SendDataError >& error) = 0;

    virtual void onSendDataResponse(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< SendDataResponse >& response) = 0;
};

class SppDataIndCallbackIF {
public:
    virtual ~SppDataIndCallbackIF() {}

    virtual void onSppDataIndError(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< SppDataIndError >& error) = 0;

    virtual void onSppDataIndSignal(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< SppDataIndSignal >& signal) = 0;
};


/**
 * SerialProxy is the client side representation of the D-Bus service
 * interface 'org.bluez.Serial' (specified in file
 * stack_component_serial.xml).
 *
 * If the meaning of "org.bluez.Serial" isn't clear, then there should be a description here.
 */
class SerialProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of SerialProxy.
     */
    static ::boost::shared_ptr< SerialProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of SerialProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< SerialProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of SerialProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< SerialProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< SerialProxy > proxyNew(new SerialProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~SerialProxy ();


    // Signal 'SppDataInd'

    /**
     * Notify on the signal 'SppDataInd'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SppDataInd'</b>:
     *
     * If the meaning of "SppDataInd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSppDataIndRegister(SppDataIndCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SppDataInd'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SppDataInd'</b>:
     *
     * If the meaning of "SppDataInd" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSppDataIndRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSppDataIndDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SppDataInd'.
     */
    void sendSppDataIndDeregisterAll () const;

    // Signal 'FlowCtrlSend'

    /**
     * Notify on the signal 'FlowCtrlSend'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'FlowCtrlSend'</b>:
     *
     * If the meaning of "FlowCtrlSend" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFlowCtrlSendRegister(FlowCtrlSendCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'FlowCtrlSend'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'FlowCtrlSend'</b>:
     *
     * If the meaning of "FlowCtrlSend" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendFlowCtrlSendRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFlowCtrlSendDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'FlowCtrlSend'.
     */
    void sendFlowCtrlSendDeregisterAll () const;

    // Signal 'DeviceFilePath'

    /**
     * Notify on the signal 'DeviceFilePath'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'DeviceFilePath'</b>:
     *
     * If the meaning of "DeviceFilePath" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceFilePathRegister(DeviceFilePathCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'DeviceFilePath'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'DeviceFilePath'</b>:
     *
     * If the meaning of "DeviceFilePath" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDeviceFilePathRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDeviceFilePathDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'DeviceFilePath'.
     */
    void sendDeviceFilePathDeregisterAll () const;


    // Property 'FlowCtrlRecv'

    /**
     * Notify on the property 'FlowCtrlRecv'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'FlowCtrlRecv'</b>:
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFlowCtrlRecvRegister(FlowCtrlRecvCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'FlowCtrlRecv'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'FlowCtrlRecv'</b>:
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendFlowCtrlRecvRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFlowCtrlRecvDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'FlowCtrlRecv'.
     */
    void sendFlowCtrlRecvDeregisterAll() const;

    /**
     * Request the value of the property 'FlowCtrlRecv' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'FlowCtrlRecv'</b>:
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFlowCtrlRecvGet(FlowCtrlRecvCallbackIF& cb);

    /**
     * Set the value of the property 'FlowCtrlRecv'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendFlowCtrlRecvSet(FlowCtrlRecvCallbackIF& cb,
     * const ::std::string& flowCtrlRecv) method instead.
     *
     * <b>Documentation of 'FlowCtrlRecv'</b>:
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     */
    void sendFlowCtrlRecvSet(const ::std::string& flowCtrlRecv);

    /**
     * Set the value of the property 'FlowCtrlRecv'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'FlowCtrlRecv'</b>:
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFlowCtrlRecvSet(FlowCtrlRecvCallbackIF& cb, const ::std::string& flowCtrlRecv);

    /**
     * Returns the current value of the property 'FlowCtrlRecv' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasFlowCtrlRecv() returns true.
     *
     * @return the previously received value of the property 'FlowCtrlRecv'.
     */
    const ::std::string& getFlowCtrlRecv() const;

    /**
     * Determines whether a status message for the property 'FlowCtrlRecv' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFlowCtrlRecv() const;

    // Property 'device_name'

    /**
     * Notify on the property 'device_name'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'device_name'</b>:
     *
     * If the meaning of "device_name" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevice_nameRegister(Device_nameCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'device_name'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'device_name'</b>:
     *
     * If the meaning of "device_name" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDevice_nameRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDevice_nameDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'device_name'.
     */
    void sendDevice_nameDeregisterAll() const;

    /**
     * Request the value of the property 'device_name' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'device_name'</b>:
     *
     * If the meaning of "device_name" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevice_nameGet(Device_nameCallbackIF& cb);


    /**
     * Returns the current value of the property 'device_name' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDevice_name() returns true.
     *
     * @return the previously received value of the property 'device_name'.
     */
    const ::std::vector< uint8 >& getDevice_name() const;

    /**
     * Determines whether a status message for the property 'device_name' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDevice_name() const;


    // Method 'SendData'

    /**
     * Call the method 'SendData'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SendData'</b>:
     *
     * If the meaning of "SendData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Data If the meaning of "Data" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendDataRequest(SendDataCallbackIF& cb, const ::std::vector< uint8 >& data) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    SerialProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'FlowCtrlRecv'

    ::asf::core::nullable< FlowCtrlRecvUpdate > _flowCtrlRecv;

    // Property 'device_name'

    ::asf::core::nullable< Device_nameUpdate > _device_name;

    DECLARE_CLASS_LOGGER();

    friend class SerialProxyCallback;
};

} // namespace Serial
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_SERIALPROXY_H
