#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_SERIAL_H
#define ORG_BLUEZ_SERIAL_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "Serial" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace Serial {

// method IDs
static const uint16 ID_SendData = 0;

// signal IDs
static const uint16 ID_SppDataInd = 1;
static const uint16 ID_FlowCtrlSend = 2;
static const uint16 ID_DeviceFilePath = 3;

// property IDs
static const uint16 ID_FlowCtrlRecv = 4;
static const uint16 ID_device_name = 5;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class SendDataRequest;

class FlowCtrlRecvUpdate;

class FlowCtrlRecvRegister;

class Device_nameUpdate;

class Device_nameRegister;

class SppDataIndSignal;

class FlowCtrlSendSignal;

class DeviceFilePathSignal;

// type definitions
/**
 * If the meaning of "SendDataResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SendDataResponse;

/**
 * If the meaning of "SendDataError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SendDataError;

/**
 * If the meaning of "FlowCtrlRecvSet" isn't clear, then there should be a description here.
 */
typedef FlowCtrlRecvUpdate FlowCtrlRecvSet;

/**
 * If the meaning of "FlowCtrlRecvGet" isn't clear, then there should be a description here.
 */
typedef FlowCtrlRecvUpdate FlowCtrlRecvGet;

/**
 * If the meaning of "FlowCtrlRecvError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FlowCtrlRecvError;

/**
 * If the meaning of "Device_nameSet" isn't clear, then there should be a description here.
 */
typedef Device_nameUpdate Device_nameSet;

/**
 * If the meaning of "Device_nameGet" isn't clear, then there should be a description here.
 */
typedef Device_nameUpdate Device_nameGet;

/**
 * If the meaning of "Device_nameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Device_nameError;

/**
 * If the meaning of "SppDataIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SppDataIndError;

/**
 * If the meaning of "FlowCtrlSendError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FlowCtrlSendError;

/**
 * If the meaning of "DeviceFilePathError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeviceFilePathError;


/**
 * If the meaning of "SendDataRequest" isn't clear, then there should be a description here.
 */
class SendDataRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendDataRequest ();

    /**
     * Copy constructor
     */
    inline  SendDataRequest (const SendDataRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SendDataRequest (const ::std::vector< uint8 >& Data_);

    /**
     * Destructor
     */
    inline virtual  ~SendDataRequest();

    /**
     * Assignment operator
     */
    inline SendDataRequest& operator = (const SendDataRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendDataRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendDataRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendDataRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendDataRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Data"

    static const int kData = 0;

    /**
     * Clears the field "Data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "Data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "Data".
     *
     * If the meaning of "Data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "Data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "Data".
     *
     * If the meaning of "Data" isn't clear, then there should be a description here.
     *
     * @param Data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& Data_);

    static const SendDataRequest &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_Data ();

    inline void clear_has_Data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _Data;

};

/**
 * If the meaning of "FlowCtrlRecvUpdate" isn't clear, then there should be a description here.
 */
class FlowCtrlRecvUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FlowCtrlRecvUpdate ();

    /**
     * Copy constructor
     */
    inline  FlowCtrlRecvUpdate (const FlowCtrlRecvUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FlowCtrlRecvUpdate (const ::std::string& FlowCtrlRecv_);

    /**
     * Destructor
     */
    inline virtual  ~FlowCtrlRecvUpdate();

    /**
     * Assignment operator
     */
    inline FlowCtrlRecvUpdate& operator = (const FlowCtrlRecvUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FlowCtrlRecvUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FlowCtrlRecvUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FlowCtrlRecvUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FlowCtrlRecvUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FlowCtrlRecv"

    static const int kFlowCtrlRecv = 0;

    /**
     * Clears the field "FlowCtrlRecv".
     *
     * The field will be set to its default value. The hasFlowCtrlRecv()
     * method will return false.
     */
    inline void clearFlowCtrlRecv();

    /**
     * Checks whether the field "FlowCtrlRecv" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFlowCtrlRecv()). Otherwise it will return false.
     */
    inline bool hasFlowCtrlRecv () const;

    /**
     * Returns the value of the member "FlowCtrlRecv".
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     *
     * @return The value of the field "FlowCtrlRecv"
     */
    inline const ::std::string& getFlowCtrlRecv () const;

    /**
     * Retrieves the value of the field "FlowCtrlRecv" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FlowCtrlRecv".
     */
    inline ::std::string& getFlowCtrlRecvMutable ();

    /**
     * Sets the value of the member "FlowCtrlRecv".
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     *
     * @param FlowCtrlRecv The value which will be set
     */
    inline void setFlowCtrlRecv (const ::std::string& FlowCtrlRecv_);

    /**
     * Sets the value of the member "FlowCtrlRecv".
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     *
     * @param FlowCtrlRecv The value which will be set
     */
    inline void setFlowCtrlRecv (const char* FlowCtrlRecv_);

    /**
     * Sets the value of the member "FlowCtrlRecv".
     *
     * If the meaning of "FlowCtrlRecv" isn't clear, then there should be a description here.
     *
     * @param FlowCtrlRecv The value which will be set
     */
    inline void setFlowCtrlRecv (const char* value, size_t size);

    static const FlowCtrlRecvUpdate &getDefaultInstance();

private:

    inline void set_has_FlowCtrlRecv ();

    inline void clear_has_FlowCtrlRecv ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _FlowCtrlRecv;

};

/**
 * If the meaning of "FlowCtrlRecvRegister" isn't clear, then there should be a description here.
 */
class FlowCtrlRecvRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FlowCtrlRecvRegister ();

    /**
     * Copy constructor
     */
    inline  FlowCtrlRecvRegister (const FlowCtrlRecvRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FlowCtrlRecvRegister();

    /**
     * Assignment operator
     */
    inline FlowCtrlRecvRegister& operator = (const FlowCtrlRecvRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FlowCtrlRecvRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FlowCtrlRecvRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FlowCtrlRecvRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FlowCtrlRecvRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FlowCtrlRecvRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "Device_nameUpdate" isn't clear, then there should be a description here.
 */
class Device_nameUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Device_nameUpdate ();

    /**
     * Copy constructor
     */
    inline  Device_nameUpdate (const Device_nameUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  Device_nameUpdate (const ::std::vector< uint8 >& device_name_);

    /**
     * Destructor
     */
    inline virtual  ~Device_nameUpdate();

    /**
     * Assignment operator
     */
    inline Device_nameUpdate& operator = (const Device_nameUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Device_nameUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Device_nameUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Device_nameUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Device_nameUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device_name"

    static const int kDevice_name = 0;

    /**
     * Clears the field "device_name".
     *
     * The field will be set to its default value. The hasDevice_name()
     * method will return false.
     */
    inline void clearDevice_name();

    /**
     * Checks whether the field "device_name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice_name()). Otherwise it will return false.
     */
    inline bool hasDevice_name () const;

    /**
     * Returns the value of the member "device_name".
     *
     * If the meaning of "device_name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device_name"
     */
    inline const ::std::vector< uint8 >& getDevice_name () const;

    /**
     * Retrieves the value of the field "device_name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device_name".
     */
    inline ::std::vector< uint8 >& getDevice_nameMutable ();

    /**
     * Sets the value of the member "device_name".
     *
     * If the meaning of "device_name" isn't clear, then there should be a description here.
     *
     * @param device_name The value which will be set
     */
    inline void setDevice_name (const ::std::vector< uint8 >& device_name_);

    static const Device_nameUpdate &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_device_name ();

    inline void clear_has_device_name ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _device_name;

};

/**
 * If the meaning of "Device_nameRegister" isn't clear, then there should be a description here.
 */
class Device_nameRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Device_nameRegister ();

    /**
     * Copy constructor
     */
    inline  Device_nameRegister (const Device_nameRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~Device_nameRegister();

    /**
     * Assignment operator
     */
    inline Device_nameRegister& operator = (const Device_nameRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Device_nameRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Device_nameRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Device_nameRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Device_nameRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const Device_nameRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "SppDataIndSignal" isn't clear, then there should be a description here.
 */
class SppDataIndSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SppDataIndSignal ();

    /**
     * Copy constructor
     */
    inline  SppDataIndSignal (const SppDataIndSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SppDataIndSignal (const ::std::vector< uint8 >& Data_);

    /**
     * Destructor
     */
    inline virtual  ~SppDataIndSignal();

    /**
     * Assignment operator
     */
    inline SppDataIndSignal& operator = (const SppDataIndSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SppDataIndSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SppDataIndSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SppDataIndSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SppDataIndSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Data"

    static const int kData = 0;

    /**
     * Clears the field "Data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "Data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "Data".
     *
     * If the meaning of "Data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "Data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "Data".
     *
     * If the meaning of "Data" isn't clear, then there should be a description here.
     *
     * @param Data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& Data_);

    static const SppDataIndSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_Data ();

    inline void clear_has_Data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _Data;

};

/**
 * If the meaning of "FlowCtrlSendSignal" isn't clear, then there should be a description here.
 */
class FlowCtrlSendSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FlowCtrlSendSignal ();

    /**
     * Copy constructor
     */
    inline  FlowCtrlSendSignal (const FlowCtrlSendSignal &rhs);

    /**
     * All fields constructor
     */
    inline  FlowCtrlSendSignal (const ::std::string& Status_);

    /**
     * Destructor
     */
    inline virtual  ~FlowCtrlSendSignal();

    /**
     * Assignment operator
     */
    inline FlowCtrlSendSignal& operator = (const FlowCtrlSendSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FlowCtrlSendSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FlowCtrlSendSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FlowCtrlSendSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FlowCtrlSendSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Status"
     */
    inline const ::std::string& getStatus () const;

    /**
     * Retrieves the value of the field "Status" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Status".
     */
    inline ::std::string& getStatusMutable ();

    /**
     * Sets the value of the member "Status".
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (const ::std::string& Status_);

    /**
     * Sets the value of the member "Status".
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (const char* Status_);

    /**
     * Sets the value of the member "Status".
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (const char* value, size_t size);

    static const FlowCtrlSendSignal &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Status;

};

/**
 * If the meaning of "DeviceFilePathSignal" isn't clear, then there should be a description here.
 */
class DeviceFilePathSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceFilePathSignal ();

    /**
     * Copy constructor
     */
    inline  DeviceFilePathSignal (const DeviceFilePathSignal &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceFilePathSignal (const ::std::vector< uint8 >& Path_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceFilePathSignal();

    /**
     * Assignment operator
     */
    inline DeviceFilePathSignal& operator = (const DeviceFilePathSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceFilePathSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceFilePathSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceFilePathSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceFilePathSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Path"

    static const int kPath = 0;

    /**
     * Clears the field "Path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "Path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "Path".
     *
     * If the meaning of "Path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Path"
     */
    inline const ::std::vector< uint8 >& getPath () const;

    /**
     * Retrieves the value of the field "Path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Path".
     */
    inline ::std::vector< uint8 >& getPathMutable ();

    /**
     * Sets the value of the member "Path".
     *
     * If the meaning of "Path" isn't clear, then there should be a description here.
     *
     * @param Path The value which will be set
     */
    inline void setPath (const ::std::vector< uint8 >& Path_);

    static const DeviceFilePathSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_Path ();

    inline void clear_has_Path ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _Path;

};

inline  SendDataRequest::SendDataRequest ()  :
    _Data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendDataRequest::SendDataRequest (const SendDataRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendDataRequest::SendDataRequest (const ::std::vector< uint8 >& Data_)  :
    _Data (Data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendDataRequest::~SendDataRequest() {
}

inline SendDataRequest& SendDataRequest::operator = (const SendDataRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SendDataRequest::operator == (const SendDataRequest& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SendDataRequest::operator != (const SendDataRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SendDataRequest::operator < (const SendDataRequest& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SendDataRequest::clone() {
    return new SendDataRequest(*this);
}

inline bool SendDataRequest::operator > (const SendDataRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendDataRequest::clear() {
    clearData();
}

inline void SendDataRequest::clearData() {
    if (hasData()) {
         clear_has_Data();
        _Data.clear();
     }
}

inline bool SendDataRequest::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& SendDataRequest::getData () const {
    return _Data;
}

inline ::std::vector< uint8 >& SendDataRequest::getDataMutable () {
    set_has_Data();
    return _Data;
}

inline void SendDataRequest::setData (const ::std::vector< uint8 >& Data_) {
    set_has_Data();
    this->_Data = Data_;
}

inline void SendDataRequest::set_has_Data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendDataRequest::clear_has_Data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FlowCtrlRecvUpdate::FlowCtrlRecvUpdate ()  :
    _FlowCtrlRecv ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FlowCtrlRecvUpdate::FlowCtrlRecvUpdate (const FlowCtrlRecvUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _FlowCtrlRecv ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FlowCtrlRecvUpdate::FlowCtrlRecvUpdate (const ::std::string& FlowCtrlRecv_)  :
    _FlowCtrlRecv (FlowCtrlRecv_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FlowCtrlRecv_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FlowCtrlRecvUpdate::~FlowCtrlRecvUpdate() {
}

inline FlowCtrlRecvUpdate& FlowCtrlRecvUpdate::operator = (const FlowCtrlRecvUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFlowCtrlRecv()) {
            setFlowCtrlRecv(rhs.getFlowCtrlRecv());
        } else {
            clearFlowCtrlRecv();
        }
    }
    return *this;
}

inline bool FlowCtrlRecvUpdate::operator == (const FlowCtrlRecvUpdate& rhs) const {
    return (((!hasFlowCtrlRecv() && !rhs.hasFlowCtrlRecv()) || getFlowCtrlRecv() == rhs.getFlowCtrlRecv()));
}

inline bool FlowCtrlRecvUpdate::operator != (const FlowCtrlRecvUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool FlowCtrlRecvUpdate::operator < (const FlowCtrlRecvUpdate& rhs) const {
    if (hasFlowCtrlRecv() || rhs.hasFlowCtrlRecv()) {
        if (getFlowCtrlRecv() < rhs.getFlowCtrlRecv()) return true;
        if (getFlowCtrlRecv() > rhs.getFlowCtrlRecv()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FlowCtrlRecvUpdate::clone() {
    return new FlowCtrlRecvUpdate(*this);
}

inline bool FlowCtrlRecvUpdate::operator > (const FlowCtrlRecvUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FlowCtrlRecvUpdate::clear() {
    clearFlowCtrlRecv();
}

inline void FlowCtrlRecvUpdate::clearFlowCtrlRecv() {
    if (hasFlowCtrlRecv()) {
         clear_has_FlowCtrlRecv();
        _FlowCtrlRecv.clear();
     }
}

inline bool FlowCtrlRecvUpdate::hasFlowCtrlRecv () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& FlowCtrlRecvUpdate::getFlowCtrlRecv () const {
    return _FlowCtrlRecv;
}

inline ::std::string& FlowCtrlRecvUpdate::getFlowCtrlRecvMutable () {
    set_has_FlowCtrlRecv();
    return _FlowCtrlRecv;
}

inline void FlowCtrlRecvUpdate::setFlowCtrlRecv (const ::std::string& FlowCtrlRecv_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FlowCtrlRecv_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FlowCtrlRecv();
    this->_FlowCtrlRecv = FlowCtrlRecv_;
}

inline void FlowCtrlRecvUpdate::setFlowCtrlRecv (const char* FlowCtrlRecv_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FlowCtrlRecv_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FlowCtrlRecv();
    this->_FlowCtrlRecv.assign(FlowCtrlRecv_);
}

inline void FlowCtrlRecvUpdate::setFlowCtrlRecv (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FlowCtrlRecv();
    this->_FlowCtrlRecv.assign(value, size);
}

inline void FlowCtrlRecvUpdate::set_has_FlowCtrlRecv () {
    _has_bits_[0] |= 1u << 0;
}

inline void FlowCtrlRecvUpdate::clear_has_FlowCtrlRecv () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FlowCtrlRecvRegister::FlowCtrlRecvRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FlowCtrlRecvRegister::FlowCtrlRecvRegister (const FlowCtrlRecvRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FlowCtrlRecvRegister::~FlowCtrlRecvRegister() {
}

inline FlowCtrlRecvRegister& FlowCtrlRecvRegister::operator = (const FlowCtrlRecvRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool FlowCtrlRecvRegister::operator == (const FlowCtrlRecvRegister& ) const {
    return true;
}

inline bool FlowCtrlRecvRegister::operator != (const FlowCtrlRecvRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool FlowCtrlRecvRegister::operator < (const FlowCtrlRecvRegister& ) const {
    return false;
}

inline ::asf::core::Payload* FlowCtrlRecvRegister::clone() {
    return new FlowCtrlRecvRegister(*this);
}

inline bool FlowCtrlRecvRegister::operator > (const FlowCtrlRecvRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FlowCtrlRecvRegister::clear() {
}

inline  Device_nameUpdate::Device_nameUpdate ()  :
    _device_name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Device_nameUpdate::Device_nameUpdate (const Device_nameUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _device_name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Device_nameUpdate::Device_nameUpdate (const ::std::vector< uint8 >& device_name_)  :
    _device_name (device_name_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Device_nameUpdate::~Device_nameUpdate() {
}

inline Device_nameUpdate& Device_nameUpdate::operator = (const Device_nameUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice_name()) {
            setDevice_name(rhs.getDevice_name());
        } else {
            clearDevice_name();
        }
    }
    return *this;
}

inline bool Device_nameUpdate::operator == (const Device_nameUpdate& rhs) const {
    return (((!hasDevice_name() && !rhs.hasDevice_name()) || getDevice_name() == rhs.getDevice_name()));
}

inline bool Device_nameUpdate::operator != (const Device_nameUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool Device_nameUpdate::operator < (const Device_nameUpdate& rhs) const {
    if (hasDevice_name() || rhs.hasDevice_name()) {
        if (getDevice_name() < rhs.getDevice_name()) return true;
        if (getDevice_name() > rhs.getDevice_name()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Device_nameUpdate::clone() {
    return new Device_nameUpdate(*this);
}

inline bool Device_nameUpdate::operator > (const Device_nameUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Device_nameUpdate::clear() {
    clearDevice_name();
}

inline void Device_nameUpdate::clearDevice_name() {
    if (hasDevice_name()) {
         clear_has_device_name();
        _device_name.clear();
     }
}

inline bool Device_nameUpdate::hasDevice_name () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& Device_nameUpdate::getDevice_name () const {
    return _device_name;
}

inline ::std::vector< uint8 >& Device_nameUpdate::getDevice_nameMutable () {
    set_has_device_name();
    return _device_name;
}

inline void Device_nameUpdate::setDevice_name (const ::std::vector< uint8 >& device_name_) {
    set_has_device_name();
    this->_device_name = device_name_;
}

inline void Device_nameUpdate::set_has_device_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void Device_nameUpdate::clear_has_device_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Device_nameRegister::Device_nameRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Device_nameRegister::Device_nameRegister (const Device_nameRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Device_nameRegister::~Device_nameRegister() {
}

inline Device_nameRegister& Device_nameRegister::operator = (const Device_nameRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool Device_nameRegister::operator == (const Device_nameRegister& ) const {
    return true;
}

inline bool Device_nameRegister::operator != (const Device_nameRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool Device_nameRegister::operator < (const Device_nameRegister& ) const {
    return false;
}

inline ::asf::core::Payload* Device_nameRegister::clone() {
    return new Device_nameRegister(*this);
}

inline bool Device_nameRegister::operator > (const Device_nameRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Device_nameRegister::clear() {
}

inline  SppDataIndSignal::SppDataIndSignal ()  :
    _Data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SppDataIndSignal::SppDataIndSignal (const SppDataIndSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _Data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SppDataIndSignal::SppDataIndSignal (const ::std::vector< uint8 >& Data_)  :
    _Data (Data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SppDataIndSignal::~SppDataIndSignal() {
}

inline SppDataIndSignal& SppDataIndSignal::operator = (const SppDataIndSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SppDataIndSignal::operator == (const SppDataIndSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SppDataIndSignal::operator != (const SppDataIndSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SppDataIndSignal::operator < (const SppDataIndSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SppDataIndSignal::clone() {
    return new SppDataIndSignal(*this);
}

inline bool SppDataIndSignal::operator > (const SppDataIndSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SppDataIndSignal::clear() {
    clearData();
}

inline void SppDataIndSignal::clearData() {
    if (hasData()) {
         clear_has_Data();
        _Data.clear();
     }
}

inline bool SppDataIndSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& SppDataIndSignal::getData () const {
    return _Data;
}

inline ::std::vector< uint8 >& SppDataIndSignal::getDataMutable () {
    set_has_Data();
    return _Data;
}

inline void SppDataIndSignal::setData (const ::std::vector< uint8 >& Data_) {
    set_has_Data();
    this->_Data = Data_;
}

inline void SppDataIndSignal::set_has_Data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SppDataIndSignal::clear_has_Data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FlowCtrlSendSignal::FlowCtrlSendSignal ()  :
    _Status ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FlowCtrlSendSignal::FlowCtrlSendSignal (const FlowCtrlSendSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _Status ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FlowCtrlSendSignal::FlowCtrlSendSignal (const ::std::string& Status_)  :
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Status_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FlowCtrlSendSignal::~FlowCtrlSendSignal() {
}

inline FlowCtrlSendSignal& FlowCtrlSendSignal::operator = (const FlowCtrlSendSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool FlowCtrlSendSignal::operator == (const FlowCtrlSendSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool FlowCtrlSendSignal::operator != (const FlowCtrlSendSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool FlowCtrlSendSignal::operator < (const FlowCtrlSendSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FlowCtrlSendSignal::clone() {
    return new FlowCtrlSendSignal(*this);
}

inline bool FlowCtrlSendSignal::operator > (const FlowCtrlSendSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FlowCtrlSendSignal::clear() {
    clearStatus();
}

inline void FlowCtrlSendSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status.clear();
     }
}

inline bool FlowCtrlSendSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& FlowCtrlSendSignal::getStatus () const {
    return _Status;
}

inline ::std::string& FlowCtrlSendSignal::getStatusMutable () {
    set_has_Status();
    return _Status;
}

inline void FlowCtrlSendSignal::setStatus (const ::std::string& Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Status_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void FlowCtrlSendSignal::setStatus (const char* Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Status_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Status();
    this->_Status.assign(Status_);
}

inline void FlowCtrlSendSignal::setStatus (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Status();
    this->_Status.assign(value, size);
}

inline void FlowCtrlSendSignal::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void FlowCtrlSendSignal::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeviceFilePathSignal::DeviceFilePathSignal ()  :
    _Path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceFilePathSignal::DeviceFilePathSignal (const DeviceFilePathSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _Path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceFilePathSignal::DeviceFilePathSignal (const ::std::vector< uint8 >& Path_)  :
    _Path (Path_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeviceFilePathSignal::~DeviceFilePathSignal() {
}

inline DeviceFilePathSignal& DeviceFilePathSignal::operator = (const DeviceFilePathSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
    }
    return *this;
}

inline bool DeviceFilePathSignal::operator == (const DeviceFilePathSignal& rhs) const {
    return (((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()));
}

inline bool DeviceFilePathSignal::operator != (const DeviceFilePathSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceFilePathSignal::operator < (const DeviceFilePathSignal& rhs) const {
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeviceFilePathSignal::clone() {
    return new DeviceFilePathSignal(*this);
}

inline bool DeviceFilePathSignal::operator > (const DeviceFilePathSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceFilePathSignal::clear() {
    clearPath();
}

inline void DeviceFilePathSignal::clearPath() {
    if (hasPath()) {
         clear_has_Path();
        _Path.clear();
     }
}

inline bool DeviceFilePathSignal::hasPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& DeviceFilePathSignal::getPath () const {
    return _Path;
}

inline ::std::vector< uint8 >& DeviceFilePathSignal::getPathMutable () {
    set_has_Path();
    return _Path;
}

inline void DeviceFilePathSignal::setPath (const ::std::vector< uint8 >& Path_) {
    set_has_Path();
    this->_Path = Path_;
}

inline void DeviceFilePathSignal::set_has_Path () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeviceFilePathSignal::clear_has_Path () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace Serial
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_SERIAL_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
