/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/alps/evo/PAN.h"
#include "org/alps/evo/PANDBus.h"
#include "org/alps/evo/PANJson.h"
#include "org/alps/evo/PANStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace alps {
namespace evo {
namespace PAN {

DEFINE_CLASS_LOGGER("//org/alps/evolution/hli/org/alps/evo/PAN", PANStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 20, "BtApplPanSendDataReq", 0 },
    { 25, "BtApplPanFilterMuladdrReq", 2 },
    { 25, "BtApplPanFilterNettypeReq", 1 },
};


class PANStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    PANStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    PANStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    PANStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.alps.evo.PAN"),
          _logger(logger) {}

    virtual ~PANStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void PANStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 3, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'BtApplPanSendDataReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplPanSendDataReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanSendDataReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplPanSendDataReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplPanSendDataReqRequest > payload = ::boost::static_pointer_cast<BtApplPanSendDataReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<PANStub*>(getStub())->onBtApplPanSendDataReqRequest(payload);
            return;
        }
        case 1: {

            // method 'BtApplPanFilterNettypeReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplPanFilterNettypeReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanFilterNettypeReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplPanFilterNettypeReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplPanFilterNettypeReqRequest > payload = ::boost::static_pointer_cast<BtApplPanFilterNettypeReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<PANStub*>(getStub())->onBtApplPanFilterNettypeReqRequest(payload);
            return;
        }
        case 2: {

            // method 'BtApplPanFilterMuladdrReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplPanFilterMuladdrReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanFilterMuladdrReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplPanFilterMuladdrReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplPanFilterMuladdrReqRequest > payload = ::boost::static_pointer_cast<BtApplPanFilterMuladdrReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<PANStub*>(getStub())->onBtApplPanFilterMuladdrReqRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* PANStubDelegate::introspect() const {
    return     "<interface name=\"org.alps.evo.PAN\">\n"
            "      <method name=\"BtApplPanSendDataReq\">\n"
            "        <arg direction=\"in\" name=\"dest_addr\" type=\"ay\"/>\n"
            "        <arg direction=\"in\" name=\"src_addr\" type=\"ay\"/>\n"
            "        <arg direction=\"in\" name=\"pkt_type\" type=\"q\"/>\n"
            "        <arg direction=\"in\" name=\"data\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <method name=\"BtApplPanFilterNettypeReq\">\n"
            "        <arg direction=\"in\" name=\"nettype_num\" type=\"q\"/>\n"
            "        <arg direction=\"in\" name=\"nettype_filter_list\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <method name=\"BtApplPanFilterMuladdrReq\">\n"
            "        <arg direction=\"in\" name=\"addr_num\" type=\"q\"/>\n"
            "        <arg direction=\"in\" name=\"addr_filter_list\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <signal name=\"BtApplPanSendDataCfm\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplPanSendInd\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplPanFilterNettypeCfm\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplPanFilterNettypeInd\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplPanFilterMuladdrCfm\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplPanFilterMuladdrInd\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplPanDataInd\">\n"
            "        <arg name=\"src_addr\" type=\"ay\"/>\n"
            "        <arg name=\"pkt_type\" type=\"q\"/>\n"
            "        <arg name=\"packet\" type=\"ay\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void PANStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<PANStub*>(getStub()))->onGetAll (properties);
}

void PANStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void PANStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

PANStub::PANStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new PANStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

PANStub::PANStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new PANStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

PANStub::~PANStub() {
    delete _stubDelegate;
}

void PANStub::sendBtApplPanSendDataCfmSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplPanSendDataCfmSignal* payload = new BtApplPanSendDataCfmSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplPanSendDataCfm", BtApplPanSendDataCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplPanSendDataCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplPanSendDataCfm");
    }
}

void PANStub::sendBtApplPanSendIndSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplPanSendIndSignal* payload = new BtApplPanSendIndSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplPanSendInd", BtApplPanSendIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplPanSendInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplPanSendInd");
    }
}

void PANStub::sendBtApplPanFilterNettypeCfmSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplPanFilterNettypeCfmSignal* payload = new BtApplPanFilterNettypeCfmSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplPanFilterNettypeCfm", BtApplPanFilterNettypeCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplPanFilterNettypeCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplPanFilterNettypeCfm");
    }
}

void PANStub::sendBtApplPanFilterNettypeIndSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplPanFilterNettypeIndSignal* payload = new BtApplPanFilterNettypeIndSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplPanFilterNettypeInd", BtApplPanFilterNettypeIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplPanFilterNettypeInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplPanFilterNettypeInd");
    }
}

void PANStub::sendBtApplPanFilterMuladdrCfmSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplPanFilterMuladdrCfmSignal* payload = new BtApplPanFilterMuladdrCfmSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplPanFilterMuladdrCfm", BtApplPanFilterMuladdrCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplPanFilterMuladdrCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplPanFilterMuladdrCfm");
    }
}

void PANStub::sendBtApplPanFilterMuladdrIndSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplPanFilterMuladdrIndSignal* payload = new BtApplPanFilterMuladdrIndSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplPanFilterMuladdrInd", BtApplPanFilterMuladdrIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplPanFilterMuladdrInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplPanFilterMuladdrInd");
    }
}

void PANStub::sendBtApplPanDataIndSignal(const ::std::vector< uint8 >& src_addr, uint16 pkt_type, const ::std::vector< uint8 >& packet) {
    if (_stubDelegate->isConnected()) {
        BtApplPanDataIndSignal* payload = new BtApplPanDataIndSignal(src_addr, pkt_type, packet);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplPanDataInd", BtApplPanDataIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplPanDataInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplPanDataInd");
    }
}

void  PANStub::sendBtApplPanSendDataReqResponse (act_t act) {
    BtApplPanSendDataReqResponse* payload = new BtApplPanSendDataReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplPanSendDataReq", BtApplPanSendDataReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplPanSendDataReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PANStub::sendBtApplPanSendDataReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplPanSendDataReqError* payload = new BtApplPanSendDataReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplPanSendDataReq", BtApplPanSendDataReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplPanSendDataReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PANStub::sendBtApplPanFilterNettypeReqResponse (act_t act) {
    BtApplPanFilterNettypeReqResponse* payload = new BtApplPanFilterNettypeReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplPanFilterNettypeReq", BtApplPanFilterNettypeReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplPanFilterNettypeReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PANStub::sendBtApplPanFilterNettypeReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplPanFilterNettypeReqError* payload = new BtApplPanFilterNettypeReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplPanFilterNettypeReq", BtApplPanFilterNettypeReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplPanFilterNettypeReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PANStub::sendBtApplPanFilterMuladdrReqResponse (act_t act) {
    BtApplPanFilterMuladdrReqResponse* payload = new BtApplPanFilterMuladdrReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplPanFilterMuladdrReq", BtApplPanFilterMuladdrReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplPanFilterMuladdrReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PANStub::sendBtApplPanFilterMuladdrReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplPanFilterMuladdrReqError* payload = new BtApplPanFilterMuladdrReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplPanFilterMuladdrReq", BtApplPanFilterMuladdrReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplPanFilterMuladdrReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void PANStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace PAN
} // namespace evo
} // namespace alps
} // namespace org
