#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_ALPS_EVO_PAN_H
#define ORG_ALPS_EVO_PAN_H

#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstring>
#include <vector>

/**
 * If the meaning of "PAN" isn't clear, then there should be a description here.
 */

namespace org {
namespace alps {
namespace evo {
namespace PAN {

// method IDs
static const uint16 ID_BtApplPanSendDataReq = 0;
static const uint16 ID_BtApplPanFilterNettypeReq = 1;
static const uint16 ID_BtApplPanFilterMuladdrReq = 2;

// signal IDs
static const uint16 ID_BtApplPanSendDataCfm = 3;
static const uint16 ID_BtApplPanSendInd = 4;
static const uint16 ID_BtApplPanFilterNettypeCfm = 5;
static const uint16 ID_BtApplPanFilterNettypeInd = 6;
static const uint16 ID_BtApplPanFilterMuladdrCfm = 7;
static const uint16 ID_BtApplPanFilterMuladdrInd = 8;
static const uint16 ID_BtApplPanDataInd = 9;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class BtApplPanSendDataReqRequest;

class BtApplPanFilterNettypeReqRequest;

class BtApplPanFilterMuladdrReqRequest;

class BtApplPanSendDataCfmSignal;

class BtApplPanSendIndSignal;

class BtApplPanFilterNettypeCfmSignal;

class BtApplPanFilterNettypeIndSignal;

class BtApplPanFilterMuladdrCfmSignal;

class BtApplPanFilterMuladdrIndSignal;

class BtApplPanDataIndSignal;

// type definitions
/**
 * If the meaning of "BtApplPanSendDataReqResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplPanSendDataReqResponse;

/**
 * If the meaning of "BtApplPanSendDataReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplPanSendDataReqError;

/**
 * If the meaning of "BtApplPanFilterNettypeReqResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplPanFilterNettypeReqResponse;

/**
 * If the meaning of "BtApplPanFilterNettypeReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplPanFilterNettypeReqError;

/**
 * If the meaning of "BtApplPanFilterMuladdrReqResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplPanFilterMuladdrReqResponse;

/**
 * If the meaning of "BtApplPanFilterMuladdrReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplPanFilterMuladdrReqError;

/**
 * If the meaning of "BtApplPanSendDataCfmError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplPanSendDataCfmError;

/**
 * If the meaning of "BtApplPanSendIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplPanSendIndError;

/**
 * If the meaning of "BtApplPanFilterNettypeCfmError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplPanFilterNettypeCfmError;

/**
 * If the meaning of "BtApplPanFilterNettypeIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplPanFilterNettypeIndError;

/**
 * If the meaning of "BtApplPanFilterMuladdrCfmError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplPanFilterMuladdrCfmError;

/**
 * If the meaning of "BtApplPanFilterMuladdrIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplPanFilterMuladdrIndError;

/**
 * If the meaning of "BtApplPanDataIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplPanDataIndError;


/**
 * If the meaning of "BtApplPanSendDataReqRequest" isn't clear, then there should be a description here.
 */
class BtApplPanSendDataReqRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplPanSendDataReqRequest ();

    /**
     * Copy constructor
     */
    inline  BtApplPanSendDataReqRequest (const BtApplPanSendDataReqRequest &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplPanSendDataReqRequest (const ::std::vector< uint8 >& dest_addr_, const ::std::vector< uint8 >& src_addr_, uint16 pkt_type_, const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplPanSendDataReqRequest();

    /**
     * Assignment operator
     */
    inline BtApplPanSendDataReqRequest& operator = (const BtApplPanSendDataReqRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplPanSendDataReqRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplPanSendDataReqRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplPanSendDataReqRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplPanSendDataReqRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "dest_addr"

    static const int kDest_addr = 0;

    /**
     * Clears the field "dest_addr".
     *
     * The field will be set to its default value. The hasDest_addr()
     * method will return false.
     */
    inline void clearDest_addr();

    /**
     * Checks whether the field "dest_addr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDest_addr()). Otherwise it will return false.
     */
    inline bool hasDest_addr () const;

    /**
     * Returns the value of the member "dest_addr".
     *
     * If the meaning of "dest_addr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "dest_addr"
     */
    inline const ::std::vector< uint8 >& getDest_addr () const;

    /**
     * Retrieves the value of the field "dest_addr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dest_addr".
     */
    inline ::std::vector< uint8 >& getDest_addrMutable ();

    /**
     * Sets the value of the member "dest_addr".
     *
     * If the meaning of "dest_addr" isn't clear, then there should be a description here.
     *
     * @param dest_addr The value which will be set
     */
    inline void setDest_addr (const ::std::vector< uint8 >& dest_addr_);

    // API of field "src_addr"

    static const int kSrc_addr = 1;

    /**
     * Clears the field "src_addr".
     *
     * The field will be set to its default value. The hasSrc_addr()
     * method will return false.
     */
    inline void clearSrc_addr();

    /**
     * Checks whether the field "src_addr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSrc_addr()). Otherwise it will return false.
     */
    inline bool hasSrc_addr () const;

    /**
     * Returns the value of the member "src_addr".
     *
     * If the meaning of "src_addr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "src_addr"
     */
    inline const ::std::vector< uint8 >& getSrc_addr () const;

    /**
     * Retrieves the value of the field "src_addr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "src_addr".
     */
    inline ::std::vector< uint8 >& getSrc_addrMutable ();

    /**
     * Sets the value of the member "src_addr".
     *
     * If the meaning of "src_addr" isn't clear, then there should be a description here.
     *
     * @param src_addr The value which will be set
     */
    inline void setSrc_addr (const ::std::vector< uint8 >& src_addr_);

    // API of field "pkt_type"

    static const int kPkt_type = 2;

    /**
     * Clears the field "pkt_type".
     *
     * The field will be set to its default value. The hasPkt_type()
     * method will return false.
     */
    inline void clearPkt_type();

    /**
     * Checks whether the field "pkt_type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPkt_type()). Otherwise it will return false.
     */
    inline bool hasPkt_type () const;

    /**
     * Returns the value of the member "pkt_type".
     *
     * If the meaning of "pkt_type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pkt_type"
     */
    inline uint16 getPkt_type () const;

    /**
     * Sets the value of the member "pkt_type".
     *
     * If the meaning of "pkt_type" isn't clear, then there should be a description here.
     *
     * @param pkt_type The value which will be set
     */
    inline void setPkt_type (uint16 pkt_type_);

    // API of field "data"

    static const int kData = 3;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const BtApplPanSendDataReqRequest &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_dest_addr ();

    inline void clear_has_dest_addr ();

    inline void set_has_src_addr ();

    inline void clear_has_src_addr ();

    inline void set_has_pkt_type ();

    inline void clear_has_pkt_type ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::vector< uint8 > _dest_addr;

    ::std::vector< uint8 > _src_addr;

    uint16 _pkt_type;

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "BtApplPanFilterNettypeReqRequest" isn't clear, then there should be a description here.
 */
class BtApplPanFilterNettypeReqRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplPanFilterNettypeReqRequest ();

    /**
     * Copy constructor
     */
    inline  BtApplPanFilterNettypeReqRequest (const BtApplPanFilterNettypeReqRequest &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplPanFilterNettypeReqRequest (uint16 nettype_num_, const ::std::vector< uint8 >& nettype_filter_list_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplPanFilterNettypeReqRequest();

    /**
     * Assignment operator
     */
    inline BtApplPanFilterNettypeReqRequest& operator = (const BtApplPanFilterNettypeReqRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplPanFilterNettypeReqRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplPanFilterNettypeReqRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplPanFilterNettypeReqRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplPanFilterNettypeReqRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "nettype_num"

    static const int kNettype_num = 0;

    /**
     * Clears the field "nettype_num".
     *
     * The field will be set to its default value. The hasNettype_num()
     * method will return false.
     */
    inline void clearNettype_num();

    /**
     * Checks whether the field "nettype_num" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNettype_num()). Otherwise it will return false.
     */
    inline bool hasNettype_num () const;

    /**
     * Returns the value of the member "nettype_num".
     *
     * If the meaning of "nettype_num" isn't clear, then there should be a description here.
     *
     * @return The value of the field "nettype_num"
     */
    inline uint16 getNettype_num () const;

    /**
     * Sets the value of the member "nettype_num".
     *
     * If the meaning of "nettype_num" isn't clear, then there should be a description here.
     *
     * @param nettype_num The value which will be set
     */
    inline void setNettype_num (uint16 nettype_num_);

    // API of field "nettype_filter_list"

    static const int kNettype_filter_list = 1;

    /**
     * Clears the field "nettype_filter_list".
     *
     * The field will be set to its default value. The hasNettype_filter_list()
     * method will return false.
     */
    inline void clearNettype_filter_list();

    /**
     * Checks whether the field "nettype_filter_list" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNettype_filter_list()). Otherwise it will return false.
     */
    inline bool hasNettype_filter_list () const;

    /**
     * Returns the value of the member "nettype_filter_list".
     *
     * If the meaning of "nettype_filter_list" isn't clear, then there should be a description here.
     *
     * @return The value of the field "nettype_filter_list"
     */
    inline const ::std::vector< uint8 >& getNettype_filter_list () const;

    /**
     * Retrieves the value of the field "nettype_filter_list" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "nettype_filter_list".
     */
    inline ::std::vector< uint8 >& getNettype_filter_listMutable ();

    /**
     * Sets the value of the member "nettype_filter_list".
     *
     * If the meaning of "nettype_filter_list" isn't clear, then there should be a description here.
     *
     * @param nettype_filter_list The value which will be set
     */
    inline void setNettype_filter_list (const ::std::vector< uint8 >& nettype_filter_list_);

    static const BtApplPanFilterNettypeReqRequest &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_nettype_num ();

    inline void clear_has_nettype_num ();

    inline void set_has_nettype_filter_list ();

    inline void clear_has_nettype_filter_list ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _nettype_num;

    ::std::vector< uint8 > _nettype_filter_list;

};

/**
 * If the meaning of "BtApplPanFilterMuladdrReqRequest" isn't clear, then there should be a description here.
 */
class BtApplPanFilterMuladdrReqRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplPanFilterMuladdrReqRequest ();

    /**
     * Copy constructor
     */
    inline  BtApplPanFilterMuladdrReqRequest (const BtApplPanFilterMuladdrReqRequest &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplPanFilterMuladdrReqRequest (uint16 addr_num_, const ::std::vector< uint8 >& addr_filter_list_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplPanFilterMuladdrReqRequest();

    /**
     * Assignment operator
     */
    inline BtApplPanFilterMuladdrReqRequest& operator = (const BtApplPanFilterMuladdrReqRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplPanFilterMuladdrReqRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplPanFilterMuladdrReqRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplPanFilterMuladdrReqRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplPanFilterMuladdrReqRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "addr_num"

    static const int kAddr_num = 0;

    /**
     * Clears the field "addr_num".
     *
     * The field will be set to its default value. The hasAddr_num()
     * method will return false.
     */
    inline void clearAddr_num();

    /**
     * Checks whether the field "addr_num" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddr_num()). Otherwise it will return false.
     */
    inline bool hasAddr_num () const;

    /**
     * Returns the value of the member "addr_num".
     *
     * If the meaning of "addr_num" isn't clear, then there should be a description here.
     *
     * @return The value of the field "addr_num"
     */
    inline uint16 getAddr_num () const;

    /**
     * Sets the value of the member "addr_num".
     *
     * If the meaning of "addr_num" isn't clear, then there should be a description here.
     *
     * @param addr_num The value which will be set
     */
    inline void setAddr_num (uint16 addr_num_);

    // API of field "addr_filter_list"

    static const int kAddr_filter_list = 1;

    /**
     * Clears the field "addr_filter_list".
     *
     * The field will be set to its default value. The hasAddr_filter_list()
     * method will return false.
     */
    inline void clearAddr_filter_list();

    /**
     * Checks whether the field "addr_filter_list" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddr_filter_list()). Otherwise it will return false.
     */
    inline bool hasAddr_filter_list () const;

    /**
     * Returns the value of the member "addr_filter_list".
     *
     * If the meaning of "addr_filter_list" isn't clear, then there should be a description here.
     *
     * @return The value of the field "addr_filter_list"
     */
    inline const ::std::vector< uint8 >& getAddr_filter_list () const;

    /**
     * Retrieves the value of the field "addr_filter_list" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "addr_filter_list".
     */
    inline ::std::vector< uint8 >& getAddr_filter_listMutable ();

    /**
     * Sets the value of the member "addr_filter_list".
     *
     * If the meaning of "addr_filter_list" isn't clear, then there should be a description here.
     *
     * @param addr_filter_list The value which will be set
     */
    inline void setAddr_filter_list (const ::std::vector< uint8 >& addr_filter_list_);

    static const BtApplPanFilterMuladdrReqRequest &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_addr_num ();

    inline void clear_has_addr_num ();

    inline void set_has_addr_filter_list ();

    inline void clear_has_addr_filter_list ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _addr_num;

    ::std::vector< uint8 > _addr_filter_list;

};

/**
 * If the meaning of "BtApplPanSendDataCfmSignal" isn't clear, then there should be a description here.
 */
class BtApplPanSendDataCfmSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplPanSendDataCfmSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplPanSendDataCfmSignal (const BtApplPanSendDataCfmSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplPanSendDataCfmSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplPanSendDataCfmSignal();

    /**
     * Assignment operator
     */
    inline BtApplPanSendDataCfmSignal& operator = (const BtApplPanSendDataCfmSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplPanSendDataCfmSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplPanSendDataCfmSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplPanSendDataCfmSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplPanSendDataCfmSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const BtApplPanSendDataCfmSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

/**
 * If the meaning of "BtApplPanSendIndSignal" isn't clear, then there should be a description here.
 */
class BtApplPanSendIndSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplPanSendIndSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplPanSendIndSignal (const BtApplPanSendIndSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplPanSendIndSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplPanSendIndSignal();

    /**
     * Assignment operator
     */
    inline BtApplPanSendIndSignal& operator = (const BtApplPanSendIndSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplPanSendIndSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplPanSendIndSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplPanSendIndSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplPanSendIndSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const BtApplPanSendIndSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

/**
 * If the meaning of "BtApplPanFilterNettypeCfmSignal" isn't clear, then there should be a description here.
 */
class BtApplPanFilterNettypeCfmSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplPanFilterNettypeCfmSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplPanFilterNettypeCfmSignal (const BtApplPanFilterNettypeCfmSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplPanFilterNettypeCfmSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplPanFilterNettypeCfmSignal();

    /**
     * Assignment operator
     */
    inline BtApplPanFilterNettypeCfmSignal& operator = (const BtApplPanFilterNettypeCfmSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplPanFilterNettypeCfmSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplPanFilterNettypeCfmSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplPanFilterNettypeCfmSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplPanFilterNettypeCfmSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const BtApplPanFilterNettypeCfmSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

/**
 * If the meaning of "BtApplPanFilterNettypeIndSignal" isn't clear, then there should be a description here.
 */
class BtApplPanFilterNettypeIndSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplPanFilterNettypeIndSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplPanFilterNettypeIndSignal (const BtApplPanFilterNettypeIndSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplPanFilterNettypeIndSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplPanFilterNettypeIndSignal();

    /**
     * Assignment operator
     */
    inline BtApplPanFilterNettypeIndSignal& operator = (const BtApplPanFilterNettypeIndSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplPanFilterNettypeIndSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplPanFilterNettypeIndSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplPanFilterNettypeIndSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplPanFilterNettypeIndSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const BtApplPanFilterNettypeIndSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

/**
 * If the meaning of "BtApplPanFilterMuladdrCfmSignal" isn't clear, then there should be a description here.
 */
class BtApplPanFilterMuladdrCfmSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplPanFilterMuladdrCfmSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplPanFilterMuladdrCfmSignal (const BtApplPanFilterMuladdrCfmSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplPanFilterMuladdrCfmSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplPanFilterMuladdrCfmSignal();

    /**
     * Assignment operator
     */
    inline BtApplPanFilterMuladdrCfmSignal& operator = (const BtApplPanFilterMuladdrCfmSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplPanFilterMuladdrCfmSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplPanFilterMuladdrCfmSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplPanFilterMuladdrCfmSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplPanFilterMuladdrCfmSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const BtApplPanFilterMuladdrCfmSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

/**
 * If the meaning of "BtApplPanFilterMuladdrIndSignal" isn't clear, then there should be a description here.
 */
class BtApplPanFilterMuladdrIndSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplPanFilterMuladdrIndSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplPanFilterMuladdrIndSignal (const BtApplPanFilterMuladdrIndSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplPanFilterMuladdrIndSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplPanFilterMuladdrIndSignal();

    /**
     * Assignment operator
     */
    inline BtApplPanFilterMuladdrIndSignal& operator = (const BtApplPanFilterMuladdrIndSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplPanFilterMuladdrIndSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplPanFilterMuladdrIndSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplPanFilterMuladdrIndSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplPanFilterMuladdrIndSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const BtApplPanFilterMuladdrIndSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

/**
 * If the meaning of "BtApplPanDataIndSignal" isn't clear, then there should be a description here.
 */
class BtApplPanDataIndSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplPanDataIndSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplPanDataIndSignal (const BtApplPanDataIndSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplPanDataIndSignal (const ::std::vector< uint8 >& src_addr_, uint16 pkt_type_, const ::std::vector< uint8 >& packet_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplPanDataIndSignal();

    /**
     * Assignment operator
     */
    inline BtApplPanDataIndSignal& operator = (const BtApplPanDataIndSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplPanDataIndSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplPanDataIndSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplPanDataIndSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplPanDataIndSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "src_addr"

    static const int kSrc_addr = 0;

    /**
     * Clears the field "src_addr".
     *
     * The field will be set to its default value. The hasSrc_addr()
     * method will return false.
     */
    inline void clearSrc_addr();

    /**
     * Checks whether the field "src_addr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSrc_addr()). Otherwise it will return false.
     */
    inline bool hasSrc_addr () const;

    /**
     * Returns the value of the member "src_addr".
     *
     * If the meaning of "src_addr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "src_addr"
     */
    inline const ::std::vector< uint8 >& getSrc_addr () const;

    /**
     * Retrieves the value of the field "src_addr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "src_addr".
     */
    inline ::std::vector< uint8 >& getSrc_addrMutable ();

    /**
     * Sets the value of the member "src_addr".
     *
     * If the meaning of "src_addr" isn't clear, then there should be a description here.
     *
     * @param src_addr The value which will be set
     */
    inline void setSrc_addr (const ::std::vector< uint8 >& src_addr_);

    // API of field "pkt_type"

    static const int kPkt_type = 1;

    /**
     * Clears the field "pkt_type".
     *
     * The field will be set to its default value. The hasPkt_type()
     * method will return false.
     */
    inline void clearPkt_type();

    /**
     * Checks whether the field "pkt_type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPkt_type()). Otherwise it will return false.
     */
    inline bool hasPkt_type () const;

    /**
     * Returns the value of the member "pkt_type".
     *
     * If the meaning of "pkt_type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pkt_type"
     */
    inline uint16 getPkt_type () const;

    /**
     * Sets the value of the member "pkt_type".
     *
     * If the meaning of "pkt_type" isn't clear, then there should be a description here.
     *
     * @param pkt_type The value which will be set
     */
    inline void setPkt_type (uint16 pkt_type_);

    // API of field "packet"

    static const int kPacket = 2;

    /**
     * Clears the field "packet".
     *
     * The field will be set to its default value. The hasPacket()
     * method will return false.
     */
    inline void clearPacket();

    /**
     * Checks whether the field "packet" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPacket()). Otherwise it will return false.
     */
    inline bool hasPacket () const;

    /**
     * Returns the value of the member "packet".
     *
     * If the meaning of "packet" isn't clear, then there should be a description here.
     *
     * @return The value of the field "packet"
     */
    inline const ::std::vector< uint8 >& getPacket () const;

    /**
     * Retrieves the value of the field "packet" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "packet".
     */
    inline ::std::vector< uint8 >& getPacketMutable ();

    /**
     * Sets the value of the member "packet".
     *
     * If the meaning of "packet" isn't clear, then there should be a description here.
     *
     * @param packet The value which will be set
     */
    inline void setPacket (const ::std::vector< uint8 >& packet_);

    static const BtApplPanDataIndSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_src_addr ();

    inline void clear_has_src_addr ();

    inline void set_has_pkt_type ();

    inline void clear_has_pkt_type ();

    inline void set_has_packet ();

    inline void clear_has_packet ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< uint8 > _src_addr;

    uint16 _pkt_type;

    ::std::vector< uint8 > _packet;

};

inline  BtApplPanSendDataReqRequest::BtApplPanSendDataReqRequest ()  :
    _dest_addr (),
    _src_addr (),
    _pkt_type (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplPanSendDataReqRequest::BtApplPanSendDataReqRequest (const BtApplPanSendDataReqRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _dest_addr (),
    _src_addr (),
    _pkt_type (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplPanSendDataReqRequest::BtApplPanSendDataReqRequest (const ::std::vector< uint8 >& dest_addr_, const ::std::vector< uint8 >& src_addr_, uint16 pkt_type_, const ::std::vector< uint8 >& data_)  :
    _dest_addr (dest_addr_),
    _src_addr (src_addr_),
    _pkt_type (pkt_type_),
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplPanSendDataReqRequest::~BtApplPanSendDataReqRequest() {
}

inline BtApplPanSendDataReqRequest& BtApplPanSendDataReqRequest::operator = (const BtApplPanSendDataReqRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDest_addr()) {
            setDest_addr(rhs.getDest_addr());
        } else {
            clearDest_addr();
        }
        if (rhs.hasSrc_addr()) {
            setSrc_addr(rhs.getSrc_addr());
        } else {
            clearSrc_addr();
        }
        if (rhs.hasPkt_type()) {
            setPkt_type(rhs.getPkt_type());
        } else {
            clearPkt_type();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool BtApplPanSendDataReqRequest::operator == (const BtApplPanSendDataReqRequest& rhs) const {
    return (((!hasDest_addr() && !rhs.hasDest_addr()) || getDest_addr() == rhs.getDest_addr()) &&
        ((!hasSrc_addr() && !rhs.hasSrc_addr()) || getSrc_addr() == rhs.getSrc_addr()) &&
        ((!hasPkt_type() && !rhs.hasPkt_type()) || getPkt_type() == rhs.getPkt_type()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool BtApplPanSendDataReqRequest::operator != (const BtApplPanSendDataReqRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplPanSendDataReqRequest::operator < (const BtApplPanSendDataReqRequest& rhs) const {
    if (hasDest_addr() || rhs.hasDest_addr()) {
        if (getDest_addr() < rhs.getDest_addr()) return true;
        if (getDest_addr() > rhs.getDest_addr()) return false;
    }
    if (hasSrc_addr() || rhs.hasSrc_addr()) {
        if (getSrc_addr() < rhs.getSrc_addr()) return true;
        if (getSrc_addr() > rhs.getSrc_addr()) return false;
    }
    if (hasPkt_type() || rhs.hasPkt_type()) {
        if (getPkt_type() < rhs.getPkt_type()) return true;
        if (getPkt_type() > rhs.getPkt_type()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplPanSendDataReqRequest::clone() {
    return new BtApplPanSendDataReqRequest(*this);
}

inline bool BtApplPanSendDataReqRequest::operator > (const BtApplPanSendDataReqRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplPanSendDataReqRequest::clear() {
    clearDest_addr();
    clearSrc_addr();
    clearPkt_type();
    clearData();
}

inline void BtApplPanSendDataReqRequest::clearDest_addr() {
    if (hasDest_addr()) {
         clear_has_dest_addr();
        _dest_addr.clear();
     }
}

inline bool BtApplPanSendDataReqRequest::hasDest_addr () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& BtApplPanSendDataReqRequest::getDest_addr () const {
    return _dest_addr;
}

inline ::std::vector< uint8 >& BtApplPanSendDataReqRequest::getDest_addrMutable () {
    set_has_dest_addr();
    return _dest_addr;
}

inline void BtApplPanSendDataReqRequest::setDest_addr (const ::std::vector< uint8 >& dest_addr_) {
    set_has_dest_addr();
    this->_dest_addr = dest_addr_;
}

inline void BtApplPanSendDataReqRequest::clearSrc_addr() {
    if (hasSrc_addr()) {
         clear_has_src_addr();
        _src_addr.clear();
     }
}

inline bool BtApplPanSendDataReqRequest::hasSrc_addr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& BtApplPanSendDataReqRequest::getSrc_addr () const {
    return _src_addr;
}

inline ::std::vector< uint8 >& BtApplPanSendDataReqRequest::getSrc_addrMutable () {
    set_has_src_addr();
    return _src_addr;
}

inline void BtApplPanSendDataReqRequest::setSrc_addr (const ::std::vector< uint8 >& src_addr_) {
    set_has_src_addr();
    this->_src_addr = src_addr_;
}

inline void BtApplPanSendDataReqRequest::clearPkt_type() {
    if (hasPkt_type()) {
         clear_has_pkt_type();
        _pkt_type = 0u;
     }
}

inline bool BtApplPanSendDataReqRequest::hasPkt_type () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 BtApplPanSendDataReqRequest::getPkt_type () const {
    return _pkt_type;
}

inline void BtApplPanSendDataReqRequest::setPkt_type (uint16 pkt_type_) {
    set_has_pkt_type();
    this->_pkt_type = pkt_type_;
}

inline void BtApplPanSendDataReqRequest::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool BtApplPanSendDataReqRequest::hasData () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< uint8 >& BtApplPanSendDataReqRequest::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& BtApplPanSendDataReqRequest::getDataMutable () {
    set_has_data();
    return _data;
}

inline void BtApplPanSendDataReqRequest::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void BtApplPanSendDataReqRequest::set_has_dest_addr () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplPanSendDataReqRequest::clear_has_dest_addr () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplPanSendDataReqRequest::set_has_src_addr () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplPanSendDataReqRequest::clear_has_src_addr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BtApplPanSendDataReqRequest::set_has_pkt_type () {
    _has_bits_[0] |= 1u << 2;
}

inline void BtApplPanSendDataReqRequest::clear_has_pkt_type () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void BtApplPanSendDataReqRequest::set_has_data () {
    _has_bits_[0] |= 1u << 3;
}

inline void BtApplPanSendDataReqRequest::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  BtApplPanFilterNettypeReqRequest::BtApplPanFilterNettypeReqRequest ()  :
    _nettype_num (0u),
    _nettype_filter_list ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplPanFilterNettypeReqRequest::BtApplPanFilterNettypeReqRequest (const BtApplPanFilterNettypeReqRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _nettype_num (0u),
    _nettype_filter_list ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplPanFilterNettypeReqRequest::BtApplPanFilterNettypeReqRequest (uint16 nettype_num_, const ::std::vector< uint8 >& nettype_filter_list_)  :
    _nettype_num (nettype_num_),
    _nettype_filter_list (nettype_filter_list_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplPanFilterNettypeReqRequest::~BtApplPanFilterNettypeReqRequest() {
}

inline BtApplPanFilterNettypeReqRequest& BtApplPanFilterNettypeReqRequest::operator = (const BtApplPanFilterNettypeReqRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNettype_num()) {
            setNettype_num(rhs.getNettype_num());
        } else {
            clearNettype_num();
        }
        if (rhs.hasNettype_filter_list()) {
            setNettype_filter_list(rhs.getNettype_filter_list());
        } else {
            clearNettype_filter_list();
        }
    }
    return *this;
}

inline bool BtApplPanFilterNettypeReqRequest::operator == (const BtApplPanFilterNettypeReqRequest& rhs) const {
    return (((!hasNettype_num() && !rhs.hasNettype_num()) || getNettype_num() == rhs.getNettype_num()) &&
        ((!hasNettype_filter_list() && !rhs.hasNettype_filter_list()) || getNettype_filter_list() == rhs.getNettype_filter_list()));
}

inline bool BtApplPanFilterNettypeReqRequest::operator != (const BtApplPanFilterNettypeReqRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplPanFilterNettypeReqRequest::operator < (const BtApplPanFilterNettypeReqRequest& rhs) const {
    if (hasNettype_num() || rhs.hasNettype_num()) {
        if (getNettype_num() < rhs.getNettype_num()) return true;
        if (getNettype_num() > rhs.getNettype_num()) return false;
    }
    if (hasNettype_filter_list() || rhs.hasNettype_filter_list()) {
        if (getNettype_filter_list() < rhs.getNettype_filter_list()) return true;
        if (getNettype_filter_list() > rhs.getNettype_filter_list()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplPanFilterNettypeReqRequest::clone() {
    return new BtApplPanFilterNettypeReqRequest(*this);
}

inline bool BtApplPanFilterNettypeReqRequest::operator > (const BtApplPanFilterNettypeReqRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplPanFilterNettypeReqRequest::clear() {
    clearNettype_num();
    clearNettype_filter_list();
}

inline void BtApplPanFilterNettypeReqRequest::clearNettype_num() {
    if (hasNettype_num()) {
         clear_has_nettype_num();
        _nettype_num = 0u;
     }
}

inline bool BtApplPanFilterNettypeReqRequest::hasNettype_num () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 BtApplPanFilterNettypeReqRequest::getNettype_num () const {
    return _nettype_num;
}

inline void BtApplPanFilterNettypeReqRequest::setNettype_num (uint16 nettype_num_) {
    set_has_nettype_num();
    this->_nettype_num = nettype_num_;
}

inline void BtApplPanFilterNettypeReqRequest::clearNettype_filter_list() {
    if (hasNettype_filter_list()) {
         clear_has_nettype_filter_list();
        _nettype_filter_list.clear();
     }
}

inline bool BtApplPanFilterNettypeReqRequest::hasNettype_filter_list () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& BtApplPanFilterNettypeReqRequest::getNettype_filter_list () const {
    return _nettype_filter_list;
}

inline ::std::vector< uint8 >& BtApplPanFilterNettypeReqRequest::getNettype_filter_listMutable () {
    set_has_nettype_filter_list();
    return _nettype_filter_list;
}

inline void BtApplPanFilterNettypeReqRequest::setNettype_filter_list (const ::std::vector< uint8 >& nettype_filter_list_) {
    set_has_nettype_filter_list();
    this->_nettype_filter_list = nettype_filter_list_;
}

inline void BtApplPanFilterNettypeReqRequest::set_has_nettype_num () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplPanFilterNettypeReqRequest::clear_has_nettype_num () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplPanFilterNettypeReqRequest::set_has_nettype_filter_list () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplPanFilterNettypeReqRequest::clear_has_nettype_filter_list () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  BtApplPanFilterMuladdrReqRequest::BtApplPanFilterMuladdrReqRequest ()  :
    _addr_num (0u),
    _addr_filter_list ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplPanFilterMuladdrReqRequest::BtApplPanFilterMuladdrReqRequest (const BtApplPanFilterMuladdrReqRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _addr_num (0u),
    _addr_filter_list ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplPanFilterMuladdrReqRequest::BtApplPanFilterMuladdrReqRequest (uint16 addr_num_, const ::std::vector< uint8 >& addr_filter_list_)  :
    _addr_num (addr_num_),
    _addr_filter_list (addr_filter_list_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplPanFilterMuladdrReqRequest::~BtApplPanFilterMuladdrReqRequest() {
}

inline BtApplPanFilterMuladdrReqRequest& BtApplPanFilterMuladdrReqRequest::operator = (const BtApplPanFilterMuladdrReqRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddr_num()) {
            setAddr_num(rhs.getAddr_num());
        } else {
            clearAddr_num();
        }
        if (rhs.hasAddr_filter_list()) {
            setAddr_filter_list(rhs.getAddr_filter_list());
        } else {
            clearAddr_filter_list();
        }
    }
    return *this;
}

inline bool BtApplPanFilterMuladdrReqRequest::operator == (const BtApplPanFilterMuladdrReqRequest& rhs) const {
    return (((!hasAddr_num() && !rhs.hasAddr_num()) || getAddr_num() == rhs.getAddr_num()) &&
        ((!hasAddr_filter_list() && !rhs.hasAddr_filter_list()) || getAddr_filter_list() == rhs.getAddr_filter_list()));
}

inline bool BtApplPanFilterMuladdrReqRequest::operator != (const BtApplPanFilterMuladdrReqRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplPanFilterMuladdrReqRequest::operator < (const BtApplPanFilterMuladdrReqRequest& rhs) const {
    if (hasAddr_num() || rhs.hasAddr_num()) {
        if (getAddr_num() < rhs.getAddr_num()) return true;
        if (getAddr_num() > rhs.getAddr_num()) return false;
    }
    if (hasAddr_filter_list() || rhs.hasAddr_filter_list()) {
        if (getAddr_filter_list() < rhs.getAddr_filter_list()) return true;
        if (getAddr_filter_list() > rhs.getAddr_filter_list()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplPanFilterMuladdrReqRequest::clone() {
    return new BtApplPanFilterMuladdrReqRequest(*this);
}

inline bool BtApplPanFilterMuladdrReqRequest::operator > (const BtApplPanFilterMuladdrReqRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplPanFilterMuladdrReqRequest::clear() {
    clearAddr_num();
    clearAddr_filter_list();
}

inline void BtApplPanFilterMuladdrReqRequest::clearAddr_num() {
    if (hasAddr_num()) {
         clear_has_addr_num();
        _addr_num = 0u;
     }
}

inline bool BtApplPanFilterMuladdrReqRequest::hasAddr_num () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 BtApplPanFilterMuladdrReqRequest::getAddr_num () const {
    return _addr_num;
}

inline void BtApplPanFilterMuladdrReqRequest::setAddr_num (uint16 addr_num_) {
    set_has_addr_num();
    this->_addr_num = addr_num_;
}

inline void BtApplPanFilterMuladdrReqRequest::clearAddr_filter_list() {
    if (hasAddr_filter_list()) {
         clear_has_addr_filter_list();
        _addr_filter_list.clear();
     }
}

inline bool BtApplPanFilterMuladdrReqRequest::hasAddr_filter_list () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& BtApplPanFilterMuladdrReqRequest::getAddr_filter_list () const {
    return _addr_filter_list;
}

inline ::std::vector< uint8 >& BtApplPanFilterMuladdrReqRequest::getAddr_filter_listMutable () {
    set_has_addr_filter_list();
    return _addr_filter_list;
}

inline void BtApplPanFilterMuladdrReqRequest::setAddr_filter_list (const ::std::vector< uint8 >& addr_filter_list_) {
    set_has_addr_filter_list();
    this->_addr_filter_list = addr_filter_list_;
}

inline void BtApplPanFilterMuladdrReqRequest::set_has_addr_num () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplPanFilterMuladdrReqRequest::clear_has_addr_num () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplPanFilterMuladdrReqRequest::set_has_addr_filter_list () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplPanFilterMuladdrReqRequest::clear_has_addr_filter_list () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  BtApplPanSendDataCfmSignal::BtApplPanSendDataCfmSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplPanSendDataCfmSignal::BtApplPanSendDataCfmSignal (const BtApplPanSendDataCfmSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplPanSendDataCfmSignal::BtApplPanSendDataCfmSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplPanSendDataCfmSignal::~BtApplPanSendDataCfmSignal() {
}

inline BtApplPanSendDataCfmSignal& BtApplPanSendDataCfmSignal::operator = (const BtApplPanSendDataCfmSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool BtApplPanSendDataCfmSignal::operator == (const BtApplPanSendDataCfmSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool BtApplPanSendDataCfmSignal::operator != (const BtApplPanSendDataCfmSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplPanSendDataCfmSignal::operator < (const BtApplPanSendDataCfmSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplPanSendDataCfmSignal::clone() {
    return new BtApplPanSendDataCfmSignal(*this);
}

inline bool BtApplPanSendDataCfmSignal::operator > (const BtApplPanSendDataCfmSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplPanSendDataCfmSignal::clear() {
    clearStatus();
}

inline void BtApplPanSendDataCfmSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplPanSendDataCfmSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplPanSendDataCfmSignal::getStatus () const {
    return _status;
}

inline void BtApplPanSendDataCfmSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplPanSendDataCfmSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplPanSendDataCfmSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplPanSendIndSignal::BtApplPanSendIndSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplPanSendIndSignal::BtApplPanSendIndSignal (const BtApplPanSendIndSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplPanSendIndSignal::BtApplPanSendIndSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplPanSendIndSignal::~BtApplPanSendIndSignal() {
}

inline BtApplPanSendIndSignal& BtApplPanSendIndSignal::operator = (const BtApplPanSendIndSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool BtApplPanSendIndSignal::operator == (const BtApplPanSendIndSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool BtApplPanSendIndSignal::operator != (const BtApplPanSendIndSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplPanSendIndSignal::operator < (const BtApplPanSendIndSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplPanSendIndSignal::clone() {
    return new BtApplPanSendIndSignal(*this);
}

inline bool BtApplPanSendIndSignal::operator > (const BtApplPanSendIndSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplPanSendIndSignal::clear() {
    clearStatus();
}

inline void BtApplPanSendIndSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplPanSendIndSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplPanSendIndSignal::getStatus () const {
    return _status;
}

inline void BtApplPanSendIndSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplPanSendIndSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplPanSendIndSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplPanFilterNettypeCfmSignal::BtApplPanFilterNettypeCfmSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplPanFilterNettypeCfmSignal::BtApplPanFilterNettypeCfmSignal (const BtApplPanFilterNettypeCfmSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplPanFilterNettypeCfmSignal::BtApplPanFilterNettypeCfmSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplPanFilterNettypeCfmSignal::~BtApplPanFilterNettypeCfmSignal() {
}

inline BtApplPanFilterNettypeCfmSignal& BtApplPanFilterNettypeCfmSignal::operator = (const BtApplPanFilterNettypeCfmSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool BtApplPanFilterNettypeCfmSignal::operator == (const BtApplPanFilterNettypeCfmSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool BtApplPanFilterNettypeCfmSignal::operator != (const BtApplPanFilterNettypeCfmSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplPanFilterNettypeCfmSignal::operator < (const BtApplPanFilterNettypeCfmSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplPanFilterNettypeCfmSignal::clone() {
    return new BtApplPanFilterNettypeCfmSignal(*this);
}

inline bool BtApplPanFilterNettypeCfmSignal::operator > (const BtApplPanFilterNettypeCfmSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplPanFilterNettypeCfmSignal::clear() {
    clearStatus();
}

inline void BtApplPanFilterNettypeCfmSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplPanFilterNettypeCfmSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplPanFilterNettypeCfmSignal::getStatus () const {
    return _status;
}

inline void BtApplPanFilterNettypeCfmSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplPanFilterNettypeCfmSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplPanFilterNettypeCfmSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplPanFilterNettypeIndSignal::BtApplPanFilterNettypeIndSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplPanFilterNettypeIndSignal::BtApplPanFilterNettypeIndSignal (const BtApplPanFilterNettypeIndSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplPanFilterNettypeIndSignal::BtApplPanFilterNettypeIndSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplPanFilterNettypeIndSignal::~BtApplPanFilterNettypeIndSignal() {
}

inline BtApplPanFilterNettypeIndSignal& BtApplPanFilterNettypeIndSignal::operator = (const BtApplPanFilterNettypeIndSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool BtApplPanFilterNettypeIndSignal::operator == (const BtApplPanFilterNettypeIndSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool BtApplPanFilterNettypeIndSignal::operator != (const BtApplPanFilterNettypeIndSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplPanFilterNettypeIndSignal::operator < (const BtApplPanFilterNettypeIndSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplPanFilterNettypeIndSignal::clone() {
    return new BtApplPanFilterNettypeIndSignal(*this);
}

inline bool BtApplPanFilterNettypeIndSignal::operator > (const BtApplPanFilterNettypeIndSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplPanFilterNettypeIndSignal::clear() {
    clearStatus();
}

inline void BtApplPanFilterNettypeIndSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplPanFilterNettypeIndSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplPanFilterNettypeIndSignal::getStatus () const {
    return _status;
}

inline void BtApplPanFilterNettypeIndSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplPanFilterNettypeIndSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplPanFilterNettypeIndSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplPanFilterMuladdrCfmSignal::BtApplPanFilterMuladdrCfmSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplPanFilterMuladdrCfmSignal::BtApplPanFilterMuladdrCfmSignal (const BtApplPanFilterMuladdrCfmSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplPanFilterMuladdrCfmSignal::BtApplPanFilterMuladdrCfmSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplPanFilterMuladdrCfmSignal::~BtApplPanFilterMuladdrCfmSignal() {
}

inline BtApplPanFilterMuladdrCfmSignal& BtApplPanFilterMuladdrCfmSignal::operator = (const BtApplPanFilterMuladdrCfmSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool BtApplPanFilterMuladdrCfmSignal::operator == (const BtApplPanFilterMuladdrCfmSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool BtApplPanFilterMuladdrCfmSignal::operator != (const BtApplPanFilterMuladdrCfmSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplPanFilterMuladdrCfmSignal::operator < (const BtApplPanFilterMuladdrCfmSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplPanFilterMuladdrCfmSignal::clone() {
    return new BtApplPanFilterMuladdrCfmSignal(*this);
}

inline bool BtApplPanFilterMuladdrCfmSignal::operator > (const BtApplPanFilterMuladdrCfmSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplPanFilterMuladdrCfmSignal::clear() {
    clearStatus();
}

inline void BtApplPanFilterMuladdrCfmSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplPanFilterMuladdrCfmSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplPanFilterMuladdrCfmSignal::getStatus () const {
    return _status;
}

inline void BtApplPanFilterMuladdrCfmSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplPanFilterMuladdrCfmSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplPanFilterMuladdrCfmSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplPanFilterMuladdrIndSignal::BtApplPanFilterMuladdrIndSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplPanFilterMuladdrIndSignal::BtApplPanFilterMuladdrIndSignal (const BtApplPanFilterMuladdrIndSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplPanFilterMuladdrIndSignal::BtApplPanFilterMuladdrIndSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplPanFilterMuladdrIndSignal::~BtApplPanFilterMuladdrIndSignal() {
}

inline BtApplPanFilterMuladdrIndSignal& BtApplPanFilterMuladdrIndSignal::operator = (const BtApplPanFilterMuladdrIndSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool BtApplPanFilterMuladdrIndSignal::operator == (const BtApplPanFilterMuladdrIndSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool BtApplPanFilterMuladdrIndSignal::operator != (const BtApplPanFilterMuladdrIndSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplPanFilterMuladdrIndSignal::operator < (const BtApplPanFilterMuladdrIndSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplPanFilterMuladdrIndSignal::clone() {
    return new BtApplPanFilterMuladdrIndSignal(*this);
}

inline bool BtApplPanFilterMuladdrIndSignal::operator > (const BtApplPanFilterMuladdrIndSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplPanFilterMuladdrIndSignal::clear() {
    clearStatus();
}

inline void BtApplPanFilterMuladdrIndSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplPanFilterMuladdrIndSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplPanFilterMuladdrIndSignal::getStatus () const {
    return _status;
}

inline void BtApplPanFilterMuladdrIndSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplPanFilterMuladdrIndSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplPanFilterMuladdrIndSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplPanDataIndSignal::BtApplPanDataIndSignal ()  :
    _src_addr (),
    _pkt_type (0u),
    _packet ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplPanDataIndSignal::BtApplPanDataIndSignal (const BtApplPanDataIndSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _src_addr (),
    _pkt_type (0u),
    _packet ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplPanDataIndSignal::BtApplPanDataIndSignal (const ::std::vector< uint8 >& src_addr_, uint16 pkt_type_, const ::std::vector< uint8 >& packet_)  :
    _src_addr (src_addr_),
    _pkt_type (pkt_type_),
    _packet (packet_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplPanDataIndSignal::~BtApplPanDataIndSignal() {
}

inline BtApplPanDataIndSignal& BtApplPanDataIndSignal::operator = (const BtApplPanDataIndSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSrc_addr()) {
            setSrc_addr(rhs.getSrc_addr());
        } else {
            clearSrc_addr();
        }
        if (rhs.hasPkt_type()) {
            setPkt_type(rhs.getPkt_type());
        } else {
            clearPkt_type();
        }
        if (rhs.hasPacket()) {
            setPacket(rhs.getPacket());
        } else {
            clearPacket();
        }
    }
    return *this;
}

inline bool BtApplPanDataIndSignal::operator == (const BtApplPanDataIndSignal& rhs) const {
    return (((!hasSrc_addr() && !rhs.hasSrc_addr()) || getSrc_addr() == rhs.getSrc_addr()) &&
        ((!hasPkt_type() && !rhs.hasPkt_type()) || getPkt_type() == rhs.getPkt_type()) &&
        ((!hasPacket() && !rhs.hasPacket()) || getPacket() == rhs.getPacket()));
}

inline bool BtApplPanDataIndSignal::operator != (const BtApplPanDataIndSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplPanDataIndSignal::operator < (const BtApplPanDataIndSignal& rhs) const {
    if (hasSrc_addr() || rhs.hasSrc_addr()) {
        if (getSrc_addr() < rhs.getSrc_addr()) return true;
        if (getSrc_addr() > rhs.getSrc_addr()) return false;
    }
    if (hasPkt_type() || rhs.hasPkt_type()) {
        if (getPkt_type() < rhs.getPkt_type()) return true;
        if (getPkt_type() > rhs.getPkt_type()) return false;
    }
    if (hasPacket() || rhs.hasPacket()) {
        if (getPacket() < rhs.getPacket()) return true;
        if (getPacket() > rhs.getPacket()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplPanDataIndSignal::clone() {
    return new BtApplPanDataIndSignal(*this);
}

inline bool BtApplPanDataIndSignal::operator > (const BtApplPanDataIndSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplPanDataIndSignal::clear() {
    clearSrc_addr();
    clearPkt_type();
    clearPacket();
}

inline void BtApplPanDataIndSignal::clearSrc_addr() {
    if (hasSrc_addr()) {
         clear_has_src_addr();
        _src_addr.clear();
     }
}

inline bool BtApplPanDataIndSignal::hasSrc_addr () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& BtApplPanDataIndSignal::getSrc_addr () const {
    return _src_addr;
}

inline ::std::vector< uint8 >& BtApplPanDataIndSignal::getSrc_addrMutable () {
    set_has_src_addr();
    return _src_addr;
}

inline void BtApplPanDataIndSignal::setSrc_addr (const ::std::vector< uint8 >& src_addr_) {
    set_has_src_addr();
    this->_src_addr = src_addr_;
}

inline void BtApplPanDataIndSignal::clearPkt_type() {
    if (hasPkt_type()) {
         clear_has_pkt_type();
        _pkt_type = 0u;
     }
}

inline bool BtApplPanDataIndSignal::hasPkt_type () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 BtApplPanDataIndSignal::getPkt_type () const {
    return _pkt_type;
}

inline void BtApplPanDataIndSignal::setPkt_type (uint16 pkt_type_) {
    set_has_pkt_type();
    this->_pkt_type = pkt_type_;
}

inline void BtApplPanDataIndSignal::clearPacket() {
    if (hasPacket()) {
         clear_has_packet();
        _packet.clear();
     }
}

inline bool BtApplPanDataIndSignal::hasPacket () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint8 >& BtApplPanDataIndSignal::getPacket () const {
    return _packet;
}

inline ::std::vector< uint8 >& BtApplPanDataIndSignal::getPacketMutable () {
    set_has_packet();
    return _packet;
}

inline void BtApplPanDataIndSignal::setPacket (const ::std::vector< uint8 >& packet_) {
    set_has_packet();
    this->_packet = packet_;
}

inline void BtApplPanDataIndSignal::set_has_src_addr () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplPanDataIndSignal::clear_has_src_addr () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplPanDataIndSignal::set_has_pkt_type () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplPanDataIndSignal::clear_has_pkt_type () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BtApplPanDataIndSignal::set_has_packet () {
    _has_bits_[0] |= 1u << 2;
}

inline void BtApplPanDataIndSignal::clear_has_packet () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace PAN
} // namespace evo
} // namespace alps
} // namespace org

#endif // ORG_ALPS_EVO_PAN_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
