/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_ALPS_EVO_DUNPROXY_H
#define ORG_ALPS_EVO_DUNPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/alps/evo/DUN.h"
#include <dbus/dbus.h>
#include <vector>

namespace org {
namespace alps {
namespace evo {
namespace DUN {

class DUNProxy;

class BtApplDunDataIndCallbackIF {
public:
    virtual ~BtApplDunDataIndCallbackIF() {}

    virtual void onBtApplDunDataIndError(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunDataIndError >& error) = 0;

    virtual void onBtApplDunDataIndSignal(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunDataIndSignal >& signal) = 0;
};

class BtApplDunDataSendFcIndCallbackIF {
public:
    virtual ~BtApplDunDataSendFcIndCallbackIF() {}

    virtual void onBtApplDunDataSendFcIndError(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunDataSendFcIndError >& error) = 0;

    virtual void onBtApplDunDataSendFcIndSignal(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunDataSendFcIndSignal >& signal) = 0;
};

class BtApplDunFlowCtrlCfmCallbackIF {
public:
    virtual ~BtApplDunFlowCtrlCfmCallbackIF() {}

    virtual void onBtApplDunFlowCtrlCfmError(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunFlowCtrlCfmError >& error) = 0;

    virtual void onBtApplDunFlowCtrlCfmSignal(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunFlowCtrlCfmSignal >& signal) = 0;
};

class BtApplDunFlowCtrlReqCallbackIF {
public:
    virtual ~BtApplDunFlowCtrlReqCallbackIF() {}

    virtual void onBtApplDunFlowCtrlReqError(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunFlowCtrlReqError >& error) = 0;

    virtual void onBtApplDunFlowCtrlReqResponse(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunFlowCtrlReqResponse >& response) = 0;
};

class BtApplDunSendDataCfmCallbackIF {
public:
    virtual ~BtApplDunSendDataCfmCallbackIF() {}

    virtual void onBtApplDunSendDataCfmError(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunSendDataCfmError >& error) = 0;

    virtual void onBtApplDunSendDataCfmSignal(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunSendDataCfmSignal >& signal) = 0;
};

class BtApplDunSendDataReqCallbackIF {
public:
    virtual ~BtApplDunSendDataReqCallbackIF() {}

    virtual void onBtApplDunSendDataReqError(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunSendDataReqError >& error) = 0;

    virtual void onBtApplDunSendDataReqResponse(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunSendDataReqResponse >& response) = 0;
};

class BtApplDunSendIndCallbackIF {
public:
    virtual ~BtApplDunSendIndCallbackIF() {}

    virtual void onBtApplDunSendIndError(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunSendIndError >& error) = 0;

    virtual void onBtApplDunSendIndSignal(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunSendIndSignal >& signal) = 0;
};

class DeviceFilePathCallbackIF {
public:
    virtual ~DeviceFilePathCallbackIF() {}

    virtual void onDeviceFilePathError(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< DeviceFilePathError >& error) = 0;

    virtual void onDeviceFilePathUpdate(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< DeviceFilePathUpdate >& update) = 0;
};


/**
 * DUNProxy is the client side representation of the D-Bus service
 * interface 'org.alps.evo.DUN' (specified in file dun_dun.xml).
 *
 * If the meaning of "org.alps.evo.DUN" isn't clear, then there should be a description here.
 */
class DUNProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of DUNProxy.
     */
    static ::boost::shared_ptr< DUNProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of DUNProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< DUNProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of DUNProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< DUNProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< DUNProxy > proxyNew(new DUNProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~DUNProxy ();


    // Signal 'BtApplDunSendDataCfm'

    /**
     * Notify on the signal 'BtApplDunSendDataCfm'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplDunSendDataCfm'</b>:
     *
     * If the meaning of "BtApplDunSendDataCfm" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDunSendDataCfmRegister(BtApplDunSendDataCfmCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplDunSendDataCfm'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplDunSendDataCfm'</b>:
     *
     * If the meaning of "BtApplDunSendDataCfm" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplDunSendDataCfmRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplDunSendDataCfmDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtApplDunSendDataCfm'.
     */
    void sendBtApplDunSendDataCfmDeregisterAll () const;

    // Signal 'BtApplDunSendInd'

    /**
     * Notify on the signal 'BtApplDunSendInd'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplDunSendInd'</b>:
     *
     * If the meaning of "BtApplDunSendInd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDunSendIndRegister(BtApplDunSendIndCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplDunSendInd'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplDunSendInd'</b>:
     *
     * If the meaning of "BtApplDunSendInd" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplDunSendIndRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplDunSendIndDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtApplDunSendInd'.
     */
    void sendBtApplDunSendIndDeregisterAll () const;

    // Signal 'BtApplDunDataInd'

    /**
     * Notify on the signal 'BtApplDunDataInd'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplDunDataInd'</b>:
     *
     * If the meaning of "BtApplDunDataInd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDunDataIndRegister(BtApplDunDataIndCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplDunDataInd'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplDunDataInd'</b>:
     *
     * If the meaning of "BtApplDunDataInd" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplDunDataIndRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplDunDataIndDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtApplDunDataInd'.
     */
    void sendBtApplDunDataIndDeregisterAll () const;

    // Signal 'BtApplDunDataSendFcInd'

    /**
     * Notify on the signal 'BtApplDunDataSendFcInd'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplDunDataSendFcInd'</b>:
     *
     * If the meaning of "BtApplDunDataSendFcInd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDunDataSendFcIndRegister(BtApplDunDataSendFcIndCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplDunDataSendFcInd'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplDunDataSendFcInd'</b>:
     *
     * If the meaning of "BtApplDunDataSendFcInd" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplDunDataSendFcIndRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplDunDataSendFcIndDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtApplDunDataSendFcInd'.
     */
    void sendBtApplDunDataSendFcIndDeregisterAll () const;

    // Signal 'BtApplDunFlowCtrlCfm'

    /**
     * Notify on the signal 'BtApplDunFlowCtrlCfm'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplDunFlowCtrlCfm'</b>:
     *
     * If the meaning of "BtApplDunFlowCtrlCfm" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDunFlowCtrlCfmRegister(BtApplDunFlowCtrlCfmCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplDunFlowCtrlCfm'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplDunFlowCtrlCfm'</b>:
     *
     * If the meaning of "BtApplDunFlowCtrlCfm" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplDunFlowCtrlCfmRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplDunFlowCtrlCfmDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtApplDunFlowCtrlCfm'.
     */
    void sendBtApplDunFlowCtrlCfmDeregisterAll () const;


    // Property 'DeviceFilePath'

    /**
     * Notify on the property 'DeviceFilePath'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'DeviceFilePath'</b>:
     *
     * If the meaning of "DeviceFilePath" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceFilePathRegister(DeviceFilePathCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'DeviceFilePath'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'DeviceFilePath'</b>:
     *
     * If the meaning of "DeviceFilePath" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDeviceFilePathRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDeviceFilePathDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'DeviceFilePath'.
     */
    void sendDeviceFilePathDeregisterAll() const;

    /**
     * Request the value of the property 'DeviceFilePath' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'DeviceFilePath'</b>:
     *
     * If the meaning of "DeviceFilePath" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceFilePathGet(DeviceFilePathCallbackIF& cb);


    /**
     * Returns the current value of the property 'DeviceFilePath' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDeviceFilePath() returns true.
     *
     * @return the previously received value of the property 'DeviceFilePath'.
     */
    const ::std::vector< uint8 >& getDeviceFilePath() const;

    /**
     * Determines whether a status message for the property 'DeviceFilePath'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDeviceFilePath() const;


    // Method 'BtApplDunSendDataReq'

    /**
     * Call the method 'BtApplDunSendDataReq'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'BtApplDunSendDataReq'</b>:
     *
     * If the meaning of "BtApplDunSendDataReq" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDunSendDataReqRequest(BtApplDunSendDataReqCallbackIF& cb, const ::std::vector< uint8 >& data) const;

    // Method 'BtApplDunFlowCtrlReq'

    /**
     * Call the method 'BtApplDunFlowCtrlReq'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'BtApplDunFlowCtrlReq'</b>:
     *
     * If the meaning of "BtApplDunFlowCtrlReq" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param action If the meaning of "action" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDunFlowCtrlReqRequest(BtApplDunFlowCtrlReqCallbackIF& cb, uint8 action) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    DUNProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'DeviceFilePath'

    ::asf::core::nullable< DeviceFilePathUpdate > _deviceFilePath;

    DECLARE_CLASS_LOGGER();

    friend class DUNProxyCallback;
};

} // namespace DUN
} // namespace evo
} // namespace alps
} // namespace org

#endif // ORG_ALPS_EVO_DUNPROXY_H
