/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/alps/evo/DUN.h"
#include "org/alps/evo/DUNDBus.h"
#include "org/alps/evo/DUNJson.h"
#include "org/alps/evo/DUNProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace alps {
namespace evo {
namespace DUN {

DEFINE_CLASS_LOGGER("//org/alps/evolution/hli/org/alps/evo/DUN", DUNProxy);

class DUNProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    DUNProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< DUNProxy >& proxyShared = ::boost::static_pointer_cast< DUNProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_BtApplDunSendDataCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDunSendDataCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplDunSendDataCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplDunSendDataCfmSignal> payload = ::boost::static_pointer_cast<BtApplDunSendDataCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplDunSendDataCfmCallbackIF*) _callback)->onBtApplDunSendDataCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplDunSendInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDunSendIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplDunSendInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplDunSendIndSignal> payload = ::boost::static_pointer_cast<BtApplDunSendIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplDunSendIndCallbackIF*) _callback)->onBtApplDunSendIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplDunDataInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDunDataIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplDunDataInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplDunDataIndSignal> payload = ::boost::static_pointer_cast<BtApplDunDataIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplDunDataIndCallbackIF*) _callback)->onBtApplDunDataIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplDunDataSendFcInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDunDataSendFcIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplDunDataSendFcInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplDunDataSendFcIndSignal> payload = ::boost::static_pointer_cast<BtApplDunDataSendFcIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplDunDataSendFcIndCallbackIF*) _callback)->onBtApplDunDataSendFcIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplDunFlowCtrlCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDunFlowCtrlCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplDunFlowCtrlCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplDunFlowCtrlCfmSignal> payload = ::boost::static_pointer_cast<BtApplDunFlowCtrlCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplDunFlowCtrlCfmCallbackIF*) _callback)->onBtApplDunFlowCtrlCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_DeviceFilePath:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeviceFilePathError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeviceFilePath", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeviceFilePathError> payload = ::boost::static_pointer_cast<DeviceFilePathError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DeviceFilePathCallbackIF*) _callback)->onDeviceFilePathError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeviceFilePathUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeviceFilePath", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeviceFilePathUpdate> payload = ::boost::static_pointer_cast<DeviceFilePathUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DeviceFilePathCallbackIF*) _callback)->onDeviceFilePathUpdate(proxyShared, payload);
                        proxyShared->_deviceFilePath = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_BtApplDunSendDataReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDunSendDataReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplDunSendDataReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplDunSendDataReqError> payload = ::boost::static_pointer_cast<BtApplDunSendDataReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplDunSendDataReqCallbackIF*) _callback)->onBtApplDunSendDataReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDunSendDataReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplDunSendDataReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplDunSendDataReqResponse> payload = ::boost::static_pointer_cast<BtApplDunSendDataReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplDunSendDataReqCallbackIF*) _callback)->onBtApplDunSendDataReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_BtApplDunFlowCtrlReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDunFlowCtrlReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplDunFlowCtrlReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplDunFlowCtrlReqError> payload = ::boost::static_pointer_cast<BtApplDunFlowCtrlReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplDunFlowCtrlReqCallbackIF*) _callback)->onBtApplDunFlowCtrlReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDunFlowCtrlReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplDunFlowCtrlReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplDunFlowCtrlReqResponse> payload = ::boost::static_pointer_cast<BtApplDunFlowCtrlReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplDunFlowCtrlReqCallbackIF*) _callback)->onBtApplDunFlowCtrlReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_BtApplDunSendDataCfm: {
                ::boost::shared_ptr< BtApplDunSendDataCfmError > payload = ::boost::shared_ptr< BtApplDunSendDataCfmError >
                (new BtApplDunSendDataCfmError(DBUS_ERROR_NO_SERVER, "The DBus service DUN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDunSendDataCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DUNProxy> proxyShared = ::boost::static_pointer_cast<DUNProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDunSendDataCfmCallbackIF*) _callback)->onBtApplDunSendDataCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplDunSendInd: {
                ::boost::shared_ptr< BtApplDunSendIndError > payload = ::boost::shared_ptr< BtApplDunSendIndError >
                (new BtApplDunSendIndError(DBUS_ERROR_NO_SERVER, "The DBus service DUN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDunSendInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DUNProxy> proxyShared = ::boost::static_pointer_cast<DUNProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDunSendIndCallbackIF*) _callback)->onBtApplDunSendIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplDunDataInd: {
                ::boost::shared_ptr< BtApplDunDataIndError > payload = ::boost::shared_ptr< BtApplDunDataIndError >
                (new BtApplDunDataIndError(DBUS_ERROR_NO_SERVER, "The DBus service DUN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDunDataInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DUNProxy> proxyShared = ::boost::static_pointer_cast<DUNProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDunDataIndCallbackIF*) _callback)->onBtApplDunDataIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplDunDataSendFcInd: {
                ::boost::shared_ptr< BtApplDunDataSendFcIndError > payload = ::boost::shared_ptr< BtApplDunDataSendFcIndError >
                (new BtApplDunDataSendFcIndError(DBUS_ERROR_NO_SERVER, "The DBus service DUN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDunDataSendFcInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DUNProxy> proxyShared = ::boost::static_pointer_cast<DUNProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDunDataSendFcIndCallbackIF*) _callback)->onBtApplDunDataSendFcIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplDunFlowCtrlCfm: {
                ::boost::shared_ptr< BtApplDunFlowCtrlCfmError > payload = ::boost::shared_ptr< BtApplDunFlowCtrlCfmError >
                (new BtApplDunFlowCtrlCfmError(DBUS_ERROR_NO_SERVER, "The DBus service DUN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDunFlowCtrlCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DUNProxy> proxyShared = ::boost::static_pointer_cast<DUNProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDunFlowCtrlCfmCallbackIF*) _callback)->onBtApplDunFlowCtrlCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DeviceFilePath: {
                ::boost::shared_ptr< DeviceFilePathError > payload = ::boost::shared_ptr< DeviceFilePathError >
                (new DeviceFilePathError(DBUS_ERROR_NO_SERVER, "The DBus service DUN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeviceFilePath", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DUNProxy> proxyShared = ::boost::static_pointer_cast<DUNProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeviceFilePathCallbackIF*) _callback)->onDeviceFilePathError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplDunSendDataReq: {
                ::boost::shared_ptr< BtApplDunSendDataReqError > payload = ::boost::shared_ptr< BtApplDunSendDataReqError >
                (new BtApplDunSendDataReqError(DBUS_ERROR_NO_SERVER, "The DBus service DUN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDunSendDataReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DUNProxy> proxyShared = ::boost::static_pointer_cast<DUNProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDunSendDataReqCallbackIF*) _callback)->onBtApplDunSendDataReqError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplDunFlowCtrlReq: {
                ::boost::shared_ptr< BtApplDunFlowCtrlReqError > payload = ::boost::shared_ptr< BtApplDunFlowCtrlReqError >
                (new BtApplDunFlowCtrlReqError(DBUS_ERROR_NO_SERVER, "The DBus service DUN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDunFlowCtrlReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DUNProxy> proxyShared = ::boost::static_pointer_cast<DUNProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDunFlowCtrlReqCallbackIF*) _callback)->onBtApplDunFlowCtrlReqError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& DUNProxyCallback::_logger (DUNProxy::_logger);

DUNProxy::DUNProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.alps.evo.DUN", serviceAvailable, _logger) {
}

DUNProxy::~DUNProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< DUNProxy > DUNProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<DUNProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< DUNProxy > proxyNew(new DUNProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t DUNProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    DUNProxyCallback* callback = new DUNProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t DUNProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    DUNProxyCallback* callback = new DUNProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void DUNProxy::clearAllProperties ()
{
    _deviceFilePath = ::asf::core::nullable< DeviceFilePathUpdate >();
}

void DUNProxy::sendDeregisterAll () const
{
    sendDeviceFilePathDeregisterAll();
    sendBtApplDunSendDataCfmDeregisterAll();
    sendBtApplDunSendIndDeregisterAll();
    sendBtApplDunDataIndDeregisterAll();
    sendBtApplDunDataSendFcIndDeregisterAll();
    sendBtApplDunFlowCtrlCfmDeregisterAll();
}

act_t DUNProxy::sendBtApplDunSendDataCfmRegister(BtApplDunSendDataCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplDunSendDataCfm");
    act_t act = addSignalCallback(ID_BtApplDunSendDataCfm, "BtApplDunSendDataCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplDunSendDataCfm", &cb, act);
    return act;
}

bool DUNProxy::sendBtApplDunSendDataCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplDunSendDataCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplDunSendDataCfm", act, static_cast<int>(rv));
    return rv;
}

void DUNProxy::sendBtApplDunSendDataCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplDunSendDataCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplDunSendDataCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t DUNProxy::sendBtApplDunSendIndRegister(BtApplDunSendIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplDunSendInd");
    act_t act = addSignalCallback(ID_BtApplDunSendInd, "BtApplDunSendInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplDunSendInd", &cb, act);
    return act;
}

bool DUNProxy::sendBtApplDunSendIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplDunSendInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplDunSendInd", act, static_cast<int>(rv));
    return rv;
}

void DUNProxy::sendBtApplDunSendIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplDunSendInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplDunSendInd", 0, _dbusDaemonProxy.get(), false);
}

act_t DUNProxy::sendBtApplDunDataIndRegister(BtApplDunDataIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplDunDataInd");
    act_t act = addSignalCallback(ID_BtApplDunDataInd, "BtApplDunDataInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplDunDataInd", &cb, act);
    return act;
}

bool DUNProxy::sendBtApplDunDataIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplDunDataInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplDunDataInd", act, static_cast<int>(rv));
    return rv;
}

void DUNProxy::sendBtApplDunDataIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplDunDataInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplDunDataInd", 0, _dbusDaemonProxy.get(), false);
}

act_t DUNProxy::sendBtApplDunDataSendFcIndRegister(BtApplDunDataSendFcIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplDunDataSendFcInd");
    act_t act = addSignalCallback(ID_BtApplDunDataSendFcInd, "BtApplDunDataSendFcInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplDunDataSendFcInd", &cb, act);
    return act;
}

bool DUNProxy::sendBtApplDunDataSendFcIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplDunDataSendFcInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplDunDataSendFcInd", act, static_cast<int>(rv));
    return rv;
}

void DUNProxy::sendBtApplDunDataSendFcIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplDunDataSendFcInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplDunDataSendFcInd", 0, _dbusDaemonProxy.get(), false);
}

act_t DUNProxy::sendBtApplDunFlowCtrlCfmRegister(BtApplDunFlowCtrlCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplDunFlowCtrlCfm");
    act_t act = addSignalCallback(ID_BtApplDunFlowCtrlCfm, "BtApplDunFlowCtrlCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplDunFlowCtrlCfm", &cb, act);
    return act;
}

bool DUNProxy::sendBtApplDunFlowCtrlCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplDunFlowCtrlCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplDunFlowCtrlCfm", act, static_cast<int>(rv));
    return rv;
}

void DUNProxy::sendBtApplDunFlowCtrlCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplDunFlowCtrlCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplDunFlowCtrlCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t DUNProxy::sendDeviceFilePathRegister(DeviceFilePathCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DeviceFilePath, "DeviceFilePath", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DeviceFilePath", &cb, act);
    return act;
}

bool DUNProxy::sendDeviceFilePathDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DeviceFilePath", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DeviceFilePath", act, static_cast<int>(rv));
    return rv;
}

act_t DUNProxy::sendDeviceFilePathGet(DeviceFilePathCallbackIF& cb) {
    DUNProxyCallback* callback = new DUNProxyCallback(ID_DeviceFilePath, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DeviceFilePath", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DeviceFilePath", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< uint8 >& DUNProxy::getDeviceFilePath() const {
    return _deviceFilePath.get().getDeviceFilePath();
}

bool DUNProxy::hasDeviceFilePath() const {
    return _deviceFilePath.hasValue();
}

void DUNProxy::sendDeviceFilePathDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DeviceFilePath");
    _dbusProxyDelegate->deregisterSignalCallback("DeviceFilePath", 0, _dbusDaemonProxy.get(), true);
}

act_t DUNProxy::sendBtApplDunSendDataReqRequest(BtApplDunSendDataReqCallbackIF& cb, const ::std::vector< uint8 >& data) const {
    BtApplDunSendDataReqRequest* payload = new BtApplDunSendDataReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setData(data);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplDunSendDataReq", BtApplDunSendDataReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplDunSendDataReq, dbusMessage.getUniqueSerial(), "BtApplDunSendDataReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplDunSendDataReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DUNProxy::sendBtApplDunFlowCtrlReqRequest(BtApplDunFlowCtrlReqCallbackIF& cb, uint8 action) const {
    BtApplDunFlowCtrlReqRequest* payload = new BtApplDunFlowCtrlReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setAction(action);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplDunFlowCtrlReq", BtApplDunFlowCtrlReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplDunFlowCtrlReq, dbusMessage.getUniqueSerial(), "BtApplDunFlowCtrlReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplDunFlowCtrlReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace DUN
} // namespace evo
} // namespace alps
} // namespace org
