/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_ALPS_EVO_DMSTUB_H
#define ORG_ALPS_EVO_DMSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/alps/evo/DM.h"
#include <vector>

namespace org {
namespace alps {
namespace evo {
namespace DM {

class DMStubDelegate;

class DMStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the DMStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    DMStub (const std::string& portName);

    /**
     * Create an instance of the DMStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    DMStub (const std::string& portName, const std::string& objectPath);

    virtual ~DMStub();

    // signal 'BtApplDeviceConnectCfm'

    /**
     * Raise the signal 'BtApplDeviceConnectCfm' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'BtApplDeviceConnectCfm'</b>:
     *
     * If the meaning of "BtApplDeviceConnectCfm" isn't clear, then there should be a description here.
     */
    void sendBtApplDeviceConnectCfmSignal(uint8 status);

    // signal 'BtApplDeviceConnectInd'

    /**
     * Raise the signal 'BtApplDeviceConnectInd' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'BtApplDeviceConnectInd'</b>:
     *
     * If the meaning of "BtApplDeviceConnectInd" isn't clear, then there should be a description here.
     */
    void sendBtApplDeviceConnectIndSignal(uint8 status, const ::std::vector< uint8 >& address, uint64 function, uint8 instance);

    // signal 'BtApplDeviceDisconnectCfm'

    /**
     * Raise the signal 'BtApplDeviceDisconnectCfm' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'BtApplDeviceDisconnectCfm'</b>:
     *
     * If the meaning of "BtApplDeviceDisconnectCfm" isn't clear, then there should be a description here.
     */
    void sendBtApplDeviceDisconnectCfmSignal(uint8 status);

    // signal 'BtApplDeviceDisconnectInd'

    /**
     * Raise the signal 'BtApplDeviceDisconnectInd' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'BtApplDeviceDisconnectInd'</b>:
     *
     * If the meaning of "BtApplDeviceDisconnectInd" isn't clear, then there should be a description here.
     */
    void sendBtApplDeviceDisconnectIndSignal(uint8 status, const ::std::vector< uint8 >& address, uint8 reason, uint64 function, uint8 instance);

    // signal 'BtApplDeviceDisconnectCompInd'

    /**
     * Raise the signal 'BtApplDeviceDisconnectCompInd' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'BtApplDeviceDisconnectCompInd'</b>:
     *
     * If the meaning of "BtApplDeviceDisconnectCompInd" isn't clear, then there should be a description here.
     */
    void sendBtApplDeviceDisconnectCompIndSignal();

    // signal 'BtApplDeviceConnectCompInd'

    /**
     * Raise the signal 'BtApplDeviceConnectCompInd' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'BtApplDeviceConnectCompInd'</b>:
     *
     * If the meaning of "BtApplDeviceConnectCompInd" isn't clear, then there should be a description here.
     */
    void sendBtApplDeviceConnectCompIndSignal();

    // signal 'BtApplCancelConnectCfm'

    /**
     * Raise the signal 'BtApplCancelConnectCfm' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'BtApplCancelConnectCfm'</b>:
     *
     * If the meaning of "BtApplCancelConnectCfm" isn't clear, then there should be a description here.
     */
    void sendBtApplCancelConnectCfmSignal(uint8 status);

    // signal 'BtApplStatusNotificationInd'

    /**
     * Raise the signal 'BtApplStatusNotificationInd' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'BtApplStatusNotificationInd'</b>:
     *
     * If the meaning of "BtApplStatusNotificationInd" isn't clear, then there should be a description here.
     */
    void sendBtApplStatusNotificationIndSignal(const ::std::vector< uint8 >& data);

    // signal 'BtApplGetHwVersionCfm'

    /**
     * Raise the signal 'BtApplGetHwVersionCfm' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'BtApplGetHwVersionCfm'</b>:
     *
     * If the meaning of "BtApplGetHwVersionCfm" isn't clear, then there should be a description here.
     */
    void sendBtApplGetHwVersionCfmSignal(uint8 status, uint8 bt_version, uint16 manufactory, uint16 hw_subversion, const ::std::vector< uint8 >& ext_info);

    // signal 'BtApplSetConfigurationCfm'

    /**
     * Raise the signal 'BtApplSetConfigurationCfm' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'BtApplSetConfigurationCfm'</b>:
     *
     * If the meaning of "BtApplSetConfigurationCfm" isn't clear, then there should be a description here.
     */
    void sendBtApplSetConfigurationCfmSignal(uint8 status, uint8 instance, uint16 config_id);

    // signal 'BtApplReadConfigurationCfm'

    /**
     * Raise the signal 'BtApplReadConfigurationCfm' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'BtApplReadConfigurationCfm'</b>:
     *
     * If the meaning of "BtApplReadConfigurationCfm" isn't clear, then there should be a description here.
     */
    void sendBtApplReadConfigurationCfmSignal(uint8 status, uint8 instance, uint16 config_id, const ::std::vector< uint8 >& data);

    // signal 'BtApplTestModeCfm'

    /**
     * Raise the signal 'BtApplTestModeCfm' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'BtApplTestModeCfm'</b>:
     *
     * If the meaning of "BtApplTestModeCfm" isn't clear, then there should be a description here.
     */
    void sendBtApplTestModeCfmSignal(uint8 status);

    // signal 'BtApplTestModeCompInd'

    /**
     * Raise the signal 'BtApplTestModeCompInd' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'BtApplTestModeCompInd'</b>:
     *
     * If the meaning of "BtApplTestModeCompInd" isn't clear, then there should be a description here.
     */
    void sendBtApplTestModeCompIndSignal(uint8 notiType, uint8 status);

    // signal 'BtApplTestModeLinkQualityCfm'

    /**
     * Raise the signal 'BtApplTestModeLinkQualityCfm' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'BtApplTestModeLinkQualityCfm'</b>:
     *
     * If the meaning of "BtApplTestModeLinkQualityCfm" isn't clear, then there should be a description here.
     */
    void sendBtApplTestModeLinkQualityCfmSignal(uint8 status, uint8 rssi, uint8 linkquality);

    // method 'BtApplDeviceConnectReq'

    /**
     * The method onBtApplDeviceConnectReq() is called by ASF when a client
     * invokes the method 'BtApplDeviceConnectReq'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendBtApplDeviceConnectReq() or
     * sendBtApplDeviceConnectReqError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'BtApplDeviceConnectReq'</b>:
     *
     * If the meaning of "BtApplDeviceConnectReq" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBtApplDeviceConnectReqRequest (const ::boost::shared_ptr< BtApplDeviceConnectReqRequest >& request) = 0;

    /**
     * The method sendBtApplDeviceConnectReqResponse() sends a response of a
     * previous method invocation of 'BtApplDeviceConnectReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplDeviceConnectReq'</b>:
     *
     * If the meaning of "BtApplDeviceConnectReq" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBtApplDeviceConnectReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplDeviceConnectReqResponse (act_t act = 0);

    /**
     * The method sendBtApplDeviceConnectReqError() sends an error response of
     * a previous method invocation of 'BtApplDeviceConnectReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplDeviceConnectReq'</b>:
     *
     * If the meaning of "BtApplDeviceConnectReq" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onBtApplDeviceConnectReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplDeviceConnectReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'BtApplDeviceDisconnectReq'

    /**
     * The method onBtApplDeviceDisconnectReq() is called by ASF when a client
     * invokes the method 'BtApplDeviceDisconnectReq'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendBtApplDeviceDisconnectReq() or
     * sendBtApplDeviceDisconnectReqError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'BtApplDeviceDisconnectReq'</b>:
     *
     * If the meaning of "BtApplDeviceDisconnectReq" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBtApplDeviceDisconnectReqRequest (const ::boost::shared_ptr< BtApplDeviceDisconnectReqRequest >& request) = 0;

    /**
     * The method sendBtApplDeviceDisconnectReqResponse() sends a response of
     * a previous method invocation of 'BtApplDeviceDisconnectReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplDeviceDisconnectReq'</b>:
     *
     * If the meaning of "BtApplDeviceDisconnectReq" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBtApplDeviceDisconnectReq(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplDeviceDisconnectReqResponse (act_t act = 0);

    /**
     * The method sendBtApplDeviceDisconnectReqError() sends an error response
     * of a previous method invocation of 'BtApplDeviceDisconnectReq' back to
     * the client.
     *
     * <b>Documentation of 'BtApplDeviceDisconnectReq'</b>:
     *
     * If the meaning of "BtApplDeviceDisconnectReq" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onBtApplDeviceDisconnectReq(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplDeviceDisconnectReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'BtApplCancelConnectReq'

    /**
     * The method onBtApplCancelConnectReq() is called by ASF when a client
     * invokes the method 'BtApplCancelConnectReq'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendBtApplCancelConnectReq() or
     * sendBtApplCancelConnectReqError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'BtApplCancelConnectReq'</b>:
     *
     * If the meaning of "BtApplCancelConnectReq" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBtApplCancelConnectReqRequest (const ::boost::shared_ptr< BtApplCancelConnectReqRequest >& request) = 0;

    /**
     * The method sendBtApplCancelConnectReqResponse() sends a response of a
     * previous method invocation of 'BtApplCancelConnectReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplCancelConnectReq'</b>:
     *
     * If the meaning of "BtApplCancelConnectReq" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBtApplCancelConnectReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplCancelConnectReqResponse (act_t act = 0);

    /**
     * The method sendBtApplCancelConnectReqError() sends an error response of
     * a previous method invocation of 'BtApplCancelConnectReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplCancelConnectReq'</b>:
     *
     * If the meaning of "BtApplCancelConnectReq" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onBtApplCancelConnectReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplCancelConnectReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'BtApplGetHwVersionReq'

    /**
     * The method onBtApplGetHwVersionReq() is called by ASF when a client
     * invokes the method 'BtApplGetHwVersionReq'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendBtApplGetHwVersionReq() or sendBtApplGetHwVersionReqError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'BtApplGetHwVersionReq'</b>:
     *
     * If the meaning of "BtApplGetHwVersionReq" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBtApplGetHwVersionReqRequest (const ::boost::shared_ptr< BtApplGetHwVersionReqRequest >& request) = 0;

    /**
     * The method sendBtApplGetHwVersionReqResponse() sends a response of a
     * previous method invocation of 'BtApplGetHwVersionReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplGetHwVersionReq'</b>:
     *
     * If the meaning of "BtApplGetHwVersionReq" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBtApplGetHwVersionReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplGetHwVersionReqResponse (act_t act = 0);

    /**
     * The method sendBtApplGetHwVersionReqError() sends an error response of
     * a previous method invocation of 'BtApplGetHwVersionReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplGetHwVersionReq'</b>:
     *
     * If the meaning of "BtApplGetHwVersionReq" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onBtApplGetHwVersionReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplGetHwVersionReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'BtApplSetConfigurationReq'

    /**
     * The method onBtApplSetConfigurationReq() is called by ASF when a client
     * invokes the method 'BtApplSetConfigurationReq'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendBtApplSetConfigurationReq() or
     * sendBtApplSetConfigurationReqError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'BtApplSetConfigurationReq'</b>:
     *
     * If the meaning of "BtApplSetConfigurationReq" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBtApplSetConfigurationReqRequest (const ::boost::shared_ptr< BtApplSetConfigurationReqRequest >& request) = 0;

    /**
     * The method sendBtApplSetConfigurationReqResponse() sends a response of
     * a previous method invocation of 'BtApplSetConfigurationReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplSetConfigurationReq'</b>:
     *
     * If the meaning of "BtApplSetConfigurationReq" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBtApplSetConfigurationReq(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplSetConfigurationReqResponse (act_t act = 0);

    /**
     * The method sendBtApplSetConfigurationReqError() sends an error response
     * of a previous method invocation of 'BtApplSetConfigurationReq' back to
     * the client.
     *
     * <b>Documentation of 'BtApplSetConfigurationReq'</b>:
     *
     * If the meaning of "BtApplSetConfigurationReq" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onBtApplSetConfigurationReq(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplSetConfigurationReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'BtApplReadConfigurationReq'

    /**
     * The method onBtApplReadConfigurationReq() is called by ASF when a
     * client invokes the method 'BtApplReadConfigurationReq'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendBtApplReadConfigurationReq() or
     * sendBtApplReadConfigurationReqError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'BtApplReadConfigurationReq'</b>:
     *
     * If the meaning of "BtApplReadConfigurationReq" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBtApplReadConfigurationReqRequest (const ::boost::shared_ptr< BtApplReadConfigurationReqRequest >& request) = 0;

    /**
     * The method sendBtApplReadConfigurationReqResponse() sends a response of
     * a previous method invocation of 'BtApplReadConfigurationReq' back to
     * the client.
     *
     * <b>Documentation of 'BtApplReadConfigurationReq'</b>:
     *
     * If the meaning of "BtApplReadConfigurationReq" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBtApplReadConfigurationReq(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplReadConfigurationReqResponse (act_t act = 0);

    /**
     * The method sendBtApplReadConfigurationReqError() sends an error
     * response of a previous method invocation of
     * 'BtApplReadConfigurationReq' back to the client.
     *
     * <b>Documentation of 'BtApplReadConfigurationReq'</b>:
     *
     * If the meaning of "BtApplReadConfigurationReq" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onBtApplReadConfigurationReq(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplReadConfigurationReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'BtApplSspDebugModeReq'

    /**
     * The method onBtApplSspDebugModeReq() is called by ASF when a client
     * invokes the method 'BtApplSspDebugModeReq'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendBtApplSspDebugModeReq() or sendBtApplSspDebugModeReqError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'BtApplSspDebugModeReq'</b>:
     *
     * If the meaning of "BtApplSspDebugModeReq" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBtApplSspDebugModeReqRequest (const ::boost::shared_ptr< BtApplSspDebugModeReqRequest >& request) = 0;

    /**
     * The method sendBtApplSspDebugModeReqResponse() sends a response of a
     * previous method invocation of 'BtApplSspDebugModeReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplSspDebugModeReq'</b>:
     *
     * If the meaning of "BtApplSspDebugModeReq" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBtApplSspDebugModeReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplSspDebugModeReqResponse (act_t act = 0);

    /**
     * The method sendBtApplSspDebugModeReqError() sends an error response of
     * a previous method invocation of 'BtApplSspDebugModeReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplSspDebugModeReq'</b>:
     *
     * If the meaning of "BtApplSspDebugModeReq" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onBtApplSspDebugModeReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplSspDebugModeReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'BtApplTestModeReq'

    /**
     * The method onBtApplTestModeReq() is called by ASF when a client invokes
     * the method 'BtApplTestModeReq'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendBtApplTestModeReq() or sendBtApplTestModeReqError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'BtApplTestModeReq'</b>:
     *
     * If the meaning of "BtApplTestModeReq" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBtApplTestModeReqRequest (const ::boost::shared_ptr< BtApplTestModeReqRequest >& request) = 0;

    /**
     * The method sendBtApplTestModeReqResponse() sends a response of a
     * previous method invocation of 'BtApplTestModeReq' back to the client.
     *
     * <b>Documentation of 'BtApplTestModeReq'</b>:
     *
     * If the meaning of "BtApplTestModeReq" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBtApplTestModeReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplTestModeReqResponse (act_t act = 0);

    /**
     * The method sendBtApplTestModeReqError() sends an error response of a
     * previous method invocation of 'BtApplTestModeReq' back to the client.
     *
     * <b>Documentation of 'BtApplTestModeReq'</b>:
     *
     * If the meaning of "BtApplTestModeReq" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onBtApplTestModeReq().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendBtApplTestModeReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'BtApplTestModeLinkQualityReq'

    /**
     * The method onBtApplTestModeLinkQualityReq() is called by ASF when a
     * client invokes the method 'BtApplTestModeLinkQualityReq'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendBtApplTestModeLinkQualityReq() or
     * sendBtApplTestModeLinkQualityReqError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'BtApplTestModeLinkQualityReq'</b>:
     *
     * If the meaning of "BtApplTestModeLinkQualityReq" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBtApplTestModeLinkQualityReqRequest (const ::boost::shared_ptr< BtApplTestModeLinkQualityReqRequest >& request) = 0;

    /**
     * The method sendBtApplTestModeLinkQualityReqResponse() sends a response
     * of a previous method invocation of 'BtApplTestModeLinkQualityReq' back
     * to the client.
     *
     * <b>Documentation of 'BtApplTestModeLinkQualityReq'</b>:
     *
     * If the meaning of "BtApplTestModeLinkQualityReq" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBtApplTestModeLinkQualityReq(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplTestModeLinkQualityReqResponse (act_t act = 0);

    /**
     * The method sendBtApplTestModeLinkQualityReqError() sends an error
     * response of a previous method invocation of
     * 'BtApplTestModeLinkQualityReq' back to the client.
     *
     * <b>Documentation of 'BtApplTestModeLinkQualityReq'</b>:
     *
     * If the meaning of "BtApplTestModeLinkQualityReq" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onBtApplTestModeLinkQualityReq(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplTestModeLinkQualityReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class DMStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace DM
} // namespace evo
} // namespace alps
} // namespace org

#endif // ORG_ALPS_EVO_DMSTUB_H
