/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_ALPS_EVO_DMPROXY_H
#define ORG_ALPS_EVO_DMPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/alps/evo/DM.h"
#include <dbus/dbus.h>
#include <vector>

namespace org {
namespace alps {
namespace evo {
namespace DM {

class DMProxy;

class BtApplCancelConnectCfmCallbackIF {
public:
    virtual ~BtApplCancelConnectCfmCallbackIF() {}

    virtual void onBtApplCancelConnectCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplCancelConnectCfmError >& error) = 0;

    virtual void onBtApplCancelConnectCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplCancelConnectCfmSignal >& signal) = 0;
};

class BtApplCancelConnectReqCallbackIF {
public:
    virtual ~BtApplCancelConnectReqCallbackIF() {}

    virtual void onBtApplCancelConnectReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplCancelConnectReqError >& error) = 0;

    virtual void onBtApplCancelConnectReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplCancelConnectReqResponse >& response) = 0;
};

class BtApplDeviceConnectCfmCallbackIF {
public:
    virtual ~BtApplDeviceConnectCfmCallbackIF() {}

    virtual void onBtApplDeviceConnectCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectCfmError >& error) = 0;

    virtual void onBtApplDeviceConnectCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectCfmSignal >& signal) = 0;
};

class BtApplDeviceConnectCompIndCallbackIF {
public:
    virtual ~BtApplDeviceConnectCompIndCallbackIF() {}

    virtual void onBtApplDeviceConnectCompIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectCompIndError >& error) = 0;

    virtual void onBtApplDeviceConnectCompIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectCompIndSignal >& signal) = 0;
};

class BtApplDeviceConnectIndCallbackIF {
public:
    virtual ~BtApplDeviceConnectIndCallbackIF() {}

    virtual void onBtApplDeviceConnectIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectIndError >& error) = 0;

    virtual void onBtApplDeviceConnectIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectIndSignal >& signal) = 0;
};

class BtApplDeviceConnectReqCallbackIF {
public:
    virtual ~BtApplDeviceConnectReqCallbackIF() {}

    virtual void onBtApplDeviceConnectReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectReqError >& error) = 0;

    virtual void onBtApplDeviceConnectReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectReqResponse >& response) = 0;
};

class BtApplDeviceDisconnectCfmCallbackIF {
public:
    virtual ~BtApplDeviceDisconnectCfmCallbackIF() {}

    virtual void onBtApplDeviceDisconnectCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectCfmError >& error) = 0;

    virtual void onBtApplDeviceDisconnectCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectCfmSignal >& signal) = 0;
};

class BtApplDeviceDisconnectCompIndCallbackIF {
public:
    virtual ~BtApplDeviceDisconnectCompIndCallbackIF() {}

    virtual void onBtApplDeviceDisconnectCompIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectCompIndError >& error) = 0;

    virtual void onBtApplDeviceDisconnectCompIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectCompIndSignal >& signal) = 0;
};

class BtApplDeviceDisconnectIndCallbackIF {
public:
    virtual ~BtApplDeviceDisconnectIndCallbackIF() {}

    virtual void onBtApplDeviceDisconnectIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectIndError >& error) = 0;

    virtual void onBtApplDeviceDisconnectIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectIndSignal >& signal) = 0;
};

class BtApplDeviceDisconnectReqCallbackIF {
public:
    virtual ~BtApplDeviceDisconnectReqCallbackIF() {}

    virtual void onBtApplDeviceDisconnectReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectReqError >& error) = 0;

    virtual void onBtApplDeviceDisconnectReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectReqResponse >& response) = 0;
};

class BtApplGetHwVersionCfmCallbackIF {
public:
    virtual ~BtApplGetHwVersionCfmCallbackIF() {}

    virtual void onBtApplGetHwVersionCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplGetHwVersionCfmError >& error) = 0;

    virtual void onBtApplGetHwVersionCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplGetHwVersionCfmSignal >& signal) = 0;
};

class BtApplGetHwVersionReqCallbackIF {
public:
    virtual ~BtApplGetHwVersionReqCallbackIF() {}

    virtual void onBtApplGetHwVersionReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplGetHwVersionReqError >& error) = 0;

    virtual void onBtApplGetHwVersionReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplGetHwVersionReqResponse >& response) = 0;
};

class BtApplReadConfigurationCfmCallbackIF {
public:
    virtual ~BtApplReadConfigurationCfmCallbackIF() {}

    virtual void onBtApplReadConfigurationCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplReadConfigurationCfmError >& error) = 0;

    virtual void onBtApplReadConfigurationCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplReadConfigurationCfmSignal >& signal) = 0;
};

class BtApplReadConfigurationReqCallbackIF {
public:
    virtual ~BtApplReadConfigurationReqCallbackIF() {}

    virtual void onBtApplReadConfigurationReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplReadConfigurationReqError >& error) = 0;

    virtual void onBtApplReadConfigurationReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplReadConfigurationReqResponse >& response) = 0;
};

class BtApplSetConfigurationCfmCallbackIF {
public:
    virtual ~BtApplSetConfigurationCfmCallbackIF() {}

    virtual void onBtApplSetConfigurationCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSetConfigurationCfmError >& error) = 0;

    virtual void onBtApplSetConfigurationCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSetConfigurationCfmSignal >& signal) = 0;
};

class BtApplSetConfigurationReqCallbackIF {
public:
    virtual ~BtApplSetConfigurationReqCallbackIF() {}

    virtual void onBtApplSetConfigurationReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSetConfigurationReqError >& error) = 0;

    virtual void onBtApplSetConfigurationReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSetConfigurationReqResponse >& response) = 0;
};

class BtApplSspDebugModeReqCallbackIF {
public:
    virtual ~BtApplSspDebugModeReqCallbackIF() {}

    virtual void onBtApplSspDebugModeReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSspDebugModeReqError >& error) = 0;

    virtual void onBtApplSspDebugModeReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSspDebugModeReqResponse >& response) = 0;
};

class BtApplStatusNotificationIndCallbackIF {
public:
    virtual ~BtApplStatusNotificationIndCallbackIF() {}

    virtual void onBtApplStatusNotificationIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplStatusNotificationIndError >& error) = 0;

    virtual void onBtApplStatusNotificationIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplStatusNotificationIndSignal >& signal) = 0;
};

class BtApplTestModeCfmCallbackIF {
public:
    virtual ~BtApplTestModeCfmCallbackIF() {}

    virtual void onBtApplTestModeCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeCfmError >& error) = 0;

    virtual void onBtApplTestModeCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeCfmSignal >& signal) = 0;
};

class BtApplTestModeCompIndCallbackIF {
public:
    virtual ~BtApplTestModeCompIndCallbackIF() {}

    virtual void onBtApplTestModeCompIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeCompIndError >& error) = 0;

    virtual void onBtApplTestModeCompIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeCompIndSignal >& signal) = 0;
};

class BtApplTestModeLinkQualityCfmCallbackIF {
public:
    virtual ~BtApplTestModeLinkQualityCfmCallbackIF() {}

    virtual void onBtApplTestModeLinkQualityCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeLinkQualityCfmError >& error) = 0;

    virtual void onBtApplTestModeLinkQualityCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeLinkQualityCfmSignal >& signal) = 0;
};

class BtApplTestModeLinkQualityReqCallbackIF {
public:
    virtual ~BtApplTestModeLinkQualityReqCallbackIF() {}

    virtual void onBtApplTestModeLinkQualityReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeLinkQualityReqError >& error) = 0;

    virtual void onBtApplTestModeLinkQualityReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeLinkQualityReqResponse >& response) = 0;
};

class BtApplTestModeReqCallbackIF {
public:
    virtual ~BtApplTestModeReqCallbackIF() {}

    virtual void onBtApplTestModeReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeReqError >& error) = 0;

    virtual void onBtApplTestModeReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeReqResponse >& response) = 0;
};


/**
 * DMProxy is the client side representation of the D-Bus service
 * interface 'org.alps.evo.DM' (specified in file stack_component_dm.xml).
 *
 * If the meaning of "org.alps.evo.DM" isn't clear, then there should be a description here.
 */
class DMProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of DMProxy.
     */
    static ::boost::shared_ptr< DMProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of DMProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< DMProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of DMProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< DMProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< DMProxy > proxyNew(new DMProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~DMProxy ();


    // Signal 'BtApplDeviceConnectCfm'

    /**
     * Notify on the signal 'BtApplDeviceConnectCfm'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplDeviceConnectCfm'</b>:
     *
     * If the meaning of "BtApplDeviceConnectCfm" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDeviceConnectCfmRegister(BtApplDeviceConnectCfmCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplDeviceConnectCfm'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplDeviceConnectCfm'</b>:
     *
     * If the meaning of "BtApplDeviceConnectCfm" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplDeviceConnectCfmRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplDeviceConnectCfmDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtApplDeviceConnectCfm'.
     */
    void sendBtApplDeviceConnectCfmDeregisterAll () const;

    // Signal 'BtApplDeviceConnectInd'

    /**
     * Notify on the signal 'BtApplDeviceConnectInd'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplDeviceConnectInd'</b>:
     *
     * If the meaning of "BtApplDeviceConnectInd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDeviceConnectIndRegister(BtApplDeviceConnectIndCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplDeviceConnectInd'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplDeviceConnectInd'</b>:
     *
     * If the meaning of "BtApplDeviceConnectInd" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplDeviceConnectIndRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplDeviceConnectIndDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtApplDeviceConnectInd'.
     */
    void sendBtApplDeviceConnectIndDeregisterAll () const;

    // Signal 'BtApplDeviceDisconnectCfm'

    /**
     * Notify on the signal 'BtApplDeviceDisconnectCfm'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplDeviceDisconnectCfm'</b>:
     *
     * If the meaning of "BtApplDeviceDisconnectCfm" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDeviceDisconnectCfmRegister(BtApplDeviceDisconnectCfmCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplDeviceDisconnectCfm'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplDeviceDisconnectCfm'</b>:
     *
     * If the meaning of "BtApplDeviceDisconnectCfm" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplDeviceDisconnectCfmRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplDeviceDisconnectCfmDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'BtApplDeviceDisconnectCfm'.
     */
    void sendBtApplDeviceDisconnectCfmDeregisterAll () const;

    // Signal 'BtApplDeviceDisconnectInd'

    /**
     * Notify on the signal 'BtApplDeviceDisconnectInd'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplDeviceDisconnectInd'</b>:
     *
     * If the meaning of "BtApplDeviceDisconnectInd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDeviceDisconnectIndRegister(BtApplDeviceDisconnectIndCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplDeviceDisconnectInd'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplDeviceDisconnectInd'</b>:
     *
     * If the meaning of "BtApplDeviceDisconnectInd" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplDeviceDisconnectIndRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplDeviceDisconnectIndDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'BtApplDeviceDisconnectInd'.
     */
    void sendBtApplDeviceDisconnectIndDeregisterAll () const;

    // Signal 'BtApplDeviceDisconnectCompInd'

    /**
     * Notify on the signal 'BtApplDeviceDisconnectCompInd'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplDeviceDisconnectCompInd'</b>:
     *
     * If the meaning of "BtApplDeviceDisconnectCompInd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDeviceDisconnectCompIndRegister(BtApplDeviceDisconnectCompIndCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplDeviceDisconnectCompInd'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplDeviceDisconnectCompInd'</b>:
     *
     * If the meaning of "BtApplDeviceDisconnectCompInd" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplDeviceDisconnectCompIndRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplDeviceDisconnectCompIndDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'BtApplDeviceDisconnectCompInd'.
     */
    void sendBtApplDeviceDisconnectCompIndDeregisterAll () const;

    // Signal 'BtApplDeviceConnectCompInd'

    /**
     * Notify on the signal 'BtApplDeviceConnectCompInd'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplDeviceConnectCompInd'</b>:
     *
     * If the meaning of "BtApplDeviceConnectCompInd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDeviceConnectCompIndRegister(BtApplDeviceConnectCompIndCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplDeviceConnectCompInd'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplDeviceConnectCompInd'</b>:
     *
     * If the meaning of "BtApplDeviceConnectCompInd" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplDeviceConnectCompIndRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplDeviceConnectCompIndDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'BtApplDeviceConnectCompInd'.
     */
    void sendBtApplDeviceConnectCompIndDeregisterAll () const;

    // Signal 'BtApplCancelConnectCfm'

    /**
     * Notify on the signal 'BtApplCancelConnectCfm'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplCancelConnectCfm'</b>:
     *
     * If the meaning of "BtApplCancelConnectCfm" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplCancelConnectCfmRegister(BtApplCancelConnectCfmCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplCancelConnectCfm'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplCancelConnectCfm'</b>:
     *
     * If the meaning of "BtApplCancelConnectCfm" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplCancelConnectCfmRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplCancelConnectCfmDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtApplCancelConnectCfm'.
     */
    void sendBtApplCancelConnectCfmDeregisterAll () const;

    // Signal 'BtApplStatusNotificationInd'

    /**
     * Notify on the signal 'BtApplStatusNotificationInd'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplStatusNotificationInd'</b>:
     *
     * If the meaning of "BtApplStatusNotificationInd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplStatusNotificationIndRegister(BtApplStatusNotificationIndCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplStatusNotificationInd'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplStatusNotificationInd'</b>:
     *
     * If the meaning of "BtApplStatusNotificationInd" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplStatusNotificationIndRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplStatusNotificationIndDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'BtApplStatusNotificationInd'.
     */
    void sendBtApplStatusNotificationIndDeregisterAll () const;

    // Signal 'BtApplGetHwVersionCfm'

    /**
     * Notify on the signal 'BtApplGetHwVersionCfm'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplGetHwVersionCfm'</b>:
     *
     * If the meaning of "BtApplGetHwVersionCfm" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplGetHwVersionCfmRegister(BtApplGetHwVersionCfmCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplGetHwVersionCfm'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplGetHwVersionCfm'</b>:
     *
     * If the meaning of "BtApplGetHwVersionCfm" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplGetHwVersionCfmRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplGetHwVersionCfmDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtApplGetHwVersionCfm'.
     */
    void sendBtApplGetHwVersionCfmDeregisterAll () const;

    // Signal 'BtApplSetConfigurationCfm'

    /**
     * Notify on the signal 'BtApplSetConfigurationCfm'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplSetConfigurationCfm'</b>:
     *
     * If the meaning of "BtApplSetConfigurationCfm" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplSetConfigurationCfmRegister(BtApplSetConfigurationCfmCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplSetConfigurationCfm'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplSetConfigurationCfm'</b>:
     *
     * If the meaning of "BtApplSetConfigurationCfm" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplSetConfigurationCfmRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplSetConfigurationCfmDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'BtApplSetConfigurationCfm'.
     */
    void sendBtApplSetConfigurationCfmDeregisterAll () const;

    // Signal 'BtApplReadConfigurationCfm'

    /**
     * Notify on the signal 'BtApplReadConfigurationCfm'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplReadConfigurationCfm'</b>:
     *
     * If the meaning of "BtApplReadConfigurationCfm" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplReadConfigurationCfmRegister(BtApplReadConfigurationCfmCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplReadConfigurationCfm'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplReadConfigurationCfm'</b>:
     *
     * If the meaning of "BtApplReadConfigurationCfm" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplReadConfigurationCfmRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplReadConfigurationCfmDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'BtApplReadConfigurationCfm'.
     */
    void sendBtApplReadConfigurationCfmDeregisterAll () const;

    // Signal 'BtApplTestModeCfm'

    /**
     * Notify on the signal 'BtApplTestModeCfm'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplTestModeCfm'</b>:
     *
     * If the meaning of "BtApplTestModeCfm" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplTestModeCfmRegister(BtApplTestModeCfmCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplTestModeCfm'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplTestModeCfm'</b>:
     *
     * If the meaning of "BtApplTestModeCfm" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplTestModeCfmRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplTestModeCfmDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtApplTestModeCfm'.
     */
    void sendBtApplTestModeCfmDeregisterAll () const;

    // Signal 'BtApplTestModeCompInd'

    /**
     * Notify on the signal 'BtApplTestModeCompInd'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplTestModeCompInd'</b>:
     *
     * If the meaning of "BtApplTestModeCompInd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplTestModeCompIndRegister(BtApplTestModeCompIndCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplTestModeCompInd'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplTestModeCompInd'</b>:
     *
     * If the meaning of "BtApplTestModeCompInd" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplTestModeCompIndRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplTestModeCompIndDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtApplTestModeCompInd'.
     */
    void sendBtApplTestModeCompIndDeregisterAll () const;

    // Signal 'BtApplTestModeLinkQualityCfm'

    /**
     * Notify on the signal 'BtApplTestModeLinkQualityCfm'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplTestModeLinkQualityCfm'</b>:
     *
     * If the meaning of "BtApplTestModeLinkQualityCfm" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplTestModeLinkQualityCfmRegister(BtApplTestModeLinkQualityCfmCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplTestModeLinkQualityCfm'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplTestModeLinkQualityCfm'</b>:
     *
     * If the meaning of "BtApplTestModeLinkQualityCfm" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplTestModeLinkQualityCfmRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplTestModeLinkQualityCfmDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'BtApplTestModeLinkQualityCfm'.
     */
    void sendBtApplTestModeLinkQualityCfmDeregisterAll () const;



    // Method 'BtApplDeviceConnectReq'

    /**
     * Call the method 'BtApplDeviceConnectReq'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'BtApplDeviceConnectReq'</b>:
     *
     * If the meaning of "BtApplDeviceConnectReq" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param address If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param function If the meaning of "function" isn't clear, then there should be a description here.
     *
     * @param instance If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDeviceConnectReqRequest(BtApplDeviceConnectReqCallbackIF& cb, const ::std::vector< uint8 >& address, uint64 function, uint8 instance) const;

    // Method 'BtApplDeviceDisconnectReq'

    /**
     * Call the method 'BtApplDeviceDisconnectReq'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'BtApplDeviceDisconnectReq'</b>:
     *
     * If the meaning of "BtApplDeviceDisconnectReq" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param function If the meaning of "function" isn't clear, then there should be a description here.
     *
     * @param instance If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDeviceDisconnectReqRequest(BtApplDeviceDisconnectReqCallbackIF& cb, uint64 function, uint8 instance) const;

    // Method 'BtApplCancelConnectReq'

    /**
     * Call the method 'BtApplCancelConnectReq'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'BtApplCancelConnectReq'</b>:
     *
     * If the meaning of "BtApplCancelConnectReq" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplCancelConnectReqRequest(BtApplCancelConnectReqCallbackIF& cb) const;

    // Method 'BtApplGetHwVersionReq'

    /**
     * Call the method 'BtApplGetHwVersionReq'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'BtApplGetHwVersionReq'</b>:
     *
     * If the meaning of "BtApplGetHwVersionReq" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplGetHwVersionReqRequest(BtApplGetHwVersionReqCallbackIF& cb) const;

    // Method 'BtApplSetConfigurationReq'

    /**
     * Call the method 'BtApplSetConfigurationReq'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'BtApplSetConfigurationReq'</b>:
     *
     * If the meaning of "BtApplSetConfigurationReq" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param instance If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @param config_id If the meaning of "config_id" isn't clear, then there should be a description here.
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplSetConfigurationReqRequest(BtApplSetConfigurationReqCallbackIF& cb, uint8 instance, uint16 config_id, const ::std::vector< uint8 >& data) const;

    // Method 'BtApplReadConfigurationReq'

    /**
     * Call the method 'BtApplReadConfigurationReq'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'BtApplReadConfigurationReq'</b>:
     *
     * If the meaning of "BtApplReadConfigurationReq" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param instance If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @param config_id If the meaning of "config_id" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplReadConfigurationReqRequest(BtApplReadConfigurationReqCallbackIF& cb, uint8 instance, uint16 config_id) const;

    // Method 'BtApplSspDebugModeReq'

    /**
     * Call the method 'BtApplSspDebugModeReq'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'BtApplSspDebugModeReq'</b>:
     *
     * If the meaning of "BtApplSspDebugModeReq" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplSspDebugModeReqRequest(BtApplSspDebugModeReqCallbackIF& cb, uint8 mode) const;

    // Method 'BtApplTestModeReq'

    /**
     * Call the method 'BtApplTestModeReq'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'BtApplTestModeReq'</b>:
     *
     * If the meaning of "BtApplTestModeReq" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param enable If the meaning of "enable" isn't clear, then there should be a description here.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param role If the meaning of "role" isn't clear, then there should be a description here.
     *
     * @param addr If the meaning of "addr" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplTestModeReqRequest(BtApplTestModeReqCallbackIF& cb, uint8 enable, uint8 mode, uint8 role, const ::std::vector< uint8 >& addr) const;

    // Method 'BtApplTestModeLinkQualityReq'

    /**
     * Call the method 'BtApplTestModeLinkQualityReq'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'BtApplTestModeLinkQualityReq'</b>:
     *
     * If the meaning of "BtApplTestModeLinkQualityReq" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplTestModeLinkQualityReqRequest(BtApplTestModeLinkQualityReqCallbackIF& cb, uint8 mode) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    DMProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class DMProxyCallback;
};

} // namespace DM
} // namespace evo
} // namespace alps
} // namespace org

#endif // ORG_ALPS_EVO_DMPROXY_H
