#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_ALPS_EVO_DM_H
#define ORG_ALPS_EVO_DM_H

#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstring>
#include <vector>

/**
 * If the meaning of "DM" isn't clear, then there should be a description here.
 */

namespace org {
namespace alps {
namespace evo {
namespace DM {

// method IDs
static const uint16 ID_BtApplDeviceConnectReq = 0;
static const uint16 ID_BtApplDeviceDisconnectReq = 1;
static const uint16 ID_BtApplCancelConnectReq = 2;
static const uint16 ID_BtApplGetHwVersionReq = 3;
static const uint16 ID_BtApplSetConfigurationReq = 4;
static const uint16 ID_BtApplReadConfigurationReq = 5;
static const uint16 ID_BtApplSspDebugModeReq = 6;
static const uint16 ID_BtApplTestModeReq = 7;
static const uint16 ID_BtApplTestModeLinkQualityReq = 8;

// signal IDs
static const uint16 ID_BtApplDeviceConnectCfm = 9;
static const uint16 ID_BtApplDeviceConnectInd = 10;
static const uint16 ID_BtApplDeviceDisconnectCfm = 11;
static const uint16 ID_BtApplDeviceDisconnectInd = 12;
static const uint16 ID_BtApplDeviceDisconnectCompInd = 13;
static const uint16 ID_BtApplDeviceConnectCompInd = 14;
static const uint16 ID_BtApplCancelConnectCfm = 15;
static const uint16 ID_BtApplStatusNotificationInd = 16;
static const uint16 ID_BtApplGetHwVersionCfm = 17;
static const uint16 ID_BtApplSetConfigurationCfm = 18;
static const uint16 ID_BtApplReadConfigurationCfm = 19;
static const uint16 ID_BtApplTestModeCfm = 20;
static const uint16 ID_BtApplTestModeCompInd = 21;
static const uint16 ID_BtApplTestModeLinkQualityCfm = 22;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class BtApplDeviceConnectReqRequest;

class BtApplDeviceDisconnectReqRequest;

class BtApplSetConfigurationReqRequest;

class BtApplReadConfigurationReqRequest;

class BtApplSspDebugModeReqRequest;

class BtApplTestModeReqRequest;

class BtApplTestModeLinkQualityReqRequest;

class BtApplDeviceConnectCfmSignal;

class BtApplDeviceConnectIndSignal;

class BtApplDeviceDisconnectCfmSignal;

class BtApplDeviceDisconnectIndSignal;

class BtApplCancelConnectCfmSignal;

class BtApplStatusNotificationIndSignal;

class BtApplGetHwVersionCfmSignal;

class BtApplSetConfigurationCfmSignal;

class BtApplReadConfigurationCfmSignal;

class BtApplTestModeCfmSignal;

class BtApplTestModeCompIndSignal;

class BtApplTestModeLinkQualityCfmSignal;

// type definitions
/**
 * If the meaning of "BtApplDeviceConnectReqResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplDeviceConnectReqResponse;

/**
 * If the meaning of "BtApplDeviceConnectReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplDeviceConnectReqError;

/**
 * If the meaning of "BtApplDeviceDisconnectReqResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplDeviceDisconnectReqResponse;

/**
 * If the meaning of "BtApplDeviceDisconnectReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplDeviceDisconnectReqError;

/**
 * If the meaning of "BtApplCancelConnectReqRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplCancelConnectReqRequest;

/**
 * If the meaning of "BtApplCancelConnectReqResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplCancelConnectReqResponse;

/**
 * If the meaning of "BtApplCancelConnectReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplCancelConnectReqError;

/**
 * If the meaning of "BtApplGetHwVersionReqRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplGetHwVersionReqRequest;

/**
 * If the meaning of "BtApplGetHwVersionReqResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplGetHwVersionReqResponse;

/**
 * If the meaning of "BtApplGetHwVersionReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplGetHwVersionReqError;

/**
 * If the meaning of "BtApplSetConfigurationReqResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplSetConfigurationReqResponse;

/**
 * If the meaning of "BtApplSetConfigurationReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplSetConfigurationReqError;

/**
 * If the meaning of "BtApplReadConfigurationReqResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplReadConfigurationReqResponse;

/**
 * If the meaning of "BtApplReadConfigurationReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplReadConfigurationReqError;

/**
 * If the meaning of "BtApplSspDebugModeReqResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplSspDebugModeReqResponse;

/**
 * If the meaning of "BtApplSspDebugModeReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplSspDebugModeReqError;

/**
 * If the meaning of "BtApplTestModeReqResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplTestModeReqResponse;

/**
 * If the meaning of "BtApplTestModeReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplTestModeReqError;

/**
 * If the meaning of "BtApplTestModeLinkQualityReqResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplTestModeLinkQualityReqResponse;

/**
 * If the meaning of "BtApplTestModeLinkQualityReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplTestModeLinkQualityReqError;

/**
 * If the meaning of "BtApplDeviceConnectCfmError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplDeviceConnectCfmError;

/**
 * If the meaning of "BtApplDeviceConnectIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplDeviceConnectIndError;

/**
 * If the meaning of "BtApplDeviceDisconnectCfmError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplDeviceDisconnectCfmError;

/**
 * If the meaning of "BtApplDeviceDisconnectIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplDeviceDisconnectIndError;

/**
 * If the meaning of "BtApplDeviceDisconnectCompIndSignal" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplDeviceDisconnectCompIndSignal;

/**
 * If the meaning of "BtApplDeviceDisconnectCompIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplDeviceDisconnectCompIndError;

/**
 * If the meaning of "BtApplDeviceConnectCompIndSignal" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplDeviceConnectCompIndSignal;

/**
 * If the meaning of "BtApplDeviceConnectCompIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplDeviceConnectCompIndError;

/**
 * If the meaning of "BtApplCancelConnectCfmError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplCancelConnectCfmError;

/**
 * If the meaning of "BtApplStatusNotificationIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplStatusNotificationIndError;

/**
 * If the meaning of "BtApplGetHwVersionCfmError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplGetHwVersionCfmError;

/**
 * If the meaning of "BtApplSetConfigurationCfmError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplSetConfigurationCfmError;

/**
 * If the meaning of "BtApplReadConfigurationCfmError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplReadConfigurationCfmError;

/**
 * If the meaning of "BtApplTestModeCfmError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplTestModeCfmError;

/**
 * If the meaning of "BtApplTestModeCompIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplTestModeCompIndError;

/**
 * If the meaning of "BtApplTestModeLinkQualityCfmError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplTestModeLinkQualityCfmError;


/**
 * If the meaning of "BtApplDeviceConnectReqRequest" isn't clear, then there should be a description here.
 */
class BtApplDeviceConnectReqRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplDeviceConnectReqRequest ();

    /**
     * Copy constructor
     */
    inline  BtApplDeviceConnectReqRequest (const BtApplDeviceConnectReqRequest &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplDeviceConnectReqRequest (const ::std::vector< uint8 >& address_, uint64 function_, uint8 instance_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplDeviceConnectReqRequest();

    /**
     * Assignment operator
     */
    inline BtApplDeviceConnectReqRequest& operator = (const BtApplDeviceConnectReqRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplDeviceConnectReqRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplDeviceConnectReqRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplDeviceConnectReqRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplDeviceConnectReqRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "address"

    static const int kAddress = 0;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "address"
     */
    inline const ::std::vector< uint8 >& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::vector< uint8 >& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::vector< uint8 >& address_);

    // API of field "function"

    static const int kFunction = 1;

    /**
     * Clears the field "function".
     *
     * The field will be set to its default value. The hasFunction()
     * method will return false.
     */
    inline void clearFunction();

    /**
     * Checks whether the field "function" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFunction()). Otherwise it will return false.
     */
    inline bool hasFunction () const;

    /**
     * Returns the value of the member "function".
     *
     * If the meaning of "function" isn't clear, then there should be a description here.
     *
     * @return The value of the field "function"
     */
    inline uint64 getFunction () const;

    /**
     * Sets the value of the member "function".
     *
     * If the meaning of "function" isn't clear, then there should be a description here.
     *
     * @param function The value which will be set
     */
    inline void setFunction (uint64 function_);

    // API of field "instance"

    static const int kInstance = 2;

    /**
     * Clears the field "instance".
     *
     * The field will be set to its default value. The hasInstance()
     * method will return false.
     */
    inline void clearInstance();

    /**
     * Checks whether the field "instance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstance()). Otherwise it will return false.
     */
    inline bool hasInstance () const;

    /**
     * Returns the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instance"
     */
    inline uint8 getInstance () const;

    /**
     * Sets the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @param instance The value which will be set
     */
    inline void setInstance (uint8 instance_);

    static const BtApplDeviceConnectReqRequest &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_address ();

    inline void clear_has_address ();

    inline void set_has_function ();

    inline void clear_has_function ();

    inline void set_has_instance ();

    inline void clear_has_instance ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< uint8 > _address;

    uint64 _function;

    uint8 _instance;

};

/**
 * If the meaning of "BtApplDeviceDisconnectReqRequest" isn't clear, then there should be a description here.
 */
class BtApplDeviceDisconnectReqRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplDeviceDisconnectReqRequest ();

    /**
     * Copy constructor
     */
    inline  BtApplDeviceDisconnectReqRequest (const BtApplDeviceDisconnectReqRequest &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplDeviceDisconnectReqRequest (uint64 function_, uint8 instance_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplDeviceDisconnectReqRequest();

    /**
     * Assignment operator
     */
    inline BtApplDeviceDisconnectReqRequest& operator = (const BtApplDeviceDisconnectReqRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplDeviceDisconnectReqRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplDeviceDisconnectReqRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplDeviceDisconnectReqRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplDeviceDisconnectReqRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "function"

    static const int kFunction = 0;

    /**
     * Clears the field "function".
     *
     * The field will be set to its default value. The hasFunction()
     * method will return false.
     */
    inline void clearFunction();

    /**
     * Checks whether the field "function" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFunction()). Otherwise it will return false.
     */
    inline bool hasFunction () const;

    /**
     * Returns the value of the member "function".
     *
     * If the meaning of "function" isn't clear, then there should be a description here.
     *
     * @return The value of the field "function"
     */
    inline uint64 getFunction () const;

    /**
     * Sets the value of the member "function".
     *
     * If the meaning of "function" isn't clear, then there should be a description here.
     *
     * @param function The value which will be set
     */
    inline void setFunction (uint64 function_);

    // API of field "instance"

    static const int kInstance = 1;

    /**
     * Clears the field "instance".
     *
     * The field will be set to its default value. The hasInstance()
     * method will return false.
     */
    inline void clearInstance();

    /**
     * Checks whether the field "instance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstance()). Otherwise it will return false.
     */
    inline bool hasInstance () const;

    /**
     * Returns the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instance"
     */
    inline uint8 getInstance () const;

    /**
     * Sets the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @param instance The value which will be set
     */
    inline void setInstance (uint8 instance_);

    static const BtApplDeviceDisconnectReqRequest &getDefaultInstance();

private:

    inline void set_has_function ();

    inline void clear_has_function ();

    inline void set_has_instance ();

    inline void clear_has_instance ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint64 _function;

    uint8 _instance;

};

/**
 * If the meaning of "BtApplSetConfigurationReqRequest" isn't clear, then there should be a description here.
 */
class BtApplSetConfigurationReqRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplSetConfigurationReqRequest ();

    /**
     * Copy constructor
     */
    inline  BtApplSetConfigurationReqRequest (const BtApplSetConfigurationReqRequest &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplSetConfigurationReqRequest (uint8 instance_, uint16 config_id_, const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplSetConfigurationReqRequest();

    /**
     * Assignment operator
     */
    inline BtApplSetConfigurationReqRequest& operator = (const BtApplSetConfigurationReqRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplSetConfigurationReqRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplSetConfigurationReqRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplSetConfigurationReqRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplSetConfigurationReqRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "instance"

    static const int kInstance = 0;

    /**
     * Clears the field "instance".
     *
     * The field will be set to its default value. The hasInstance()
     * method will return false.
     */
    inline void clearInstance();

    /**
     * Checks whether the field "instance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstance()). Otherwise it will return false.
     */
    inline bool hasInstance () const;

    /**
     * Returns the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instance"
     */
    inline uint8 getInstance () const;

    /**
     * Sets the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @param instance The value which will be set
     */
    inline void setInstance (uint8 instance_);

    // API of field "config_id"

    static const int kConfig_id = 1;

    /**
     * Clears the field "config_id".
     *
     * The field will be set to its default value. The hasConfig_id()
     * method will return false.
     */
    inline void clearConfig_id();

    /**
     * Checks whether the field "config_id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfig_id()). Otherwise it will return false.
     */
    inline bool hasConfig_id () const;

    /**
     * Returns the value of the member "config_id".
     *
     * If the meaning of "config_id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "config_id"
     */
    inline uint16 getConfig_id () const;

    /**
     * Sets the value of the member "config_id".
     *
     * If the meaning of "config_id" isn't clear, then there should be a description here.
     *
     * @param config_id The value which will be set
     */
    inline void setConfig_id (uint16 config_id_);

    // API of field "data"

    static const int kData = 2;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const BtApplSetConfigurationReqRequest &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_instance ();

    inline void clear_has_instance ();

    inline void set_has_config_id ();

    inline void clear_has_config_id ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _instance;

    uint16 _config_id;

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "BtApplReadConfigurationReqRequest" isn't clear, then there should be a description here.
 */
class BtApplReadConfigurationReqRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplReadConfigurationReqRequest ();

    /**
     * Copy constructor
     */
    inline  BtApplReadConfigurationReqRequest (const BtApplReadConfigurationReqRequest &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplReadConfigurationReqRequest (uint8 instance_, uint16 config_id_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplReadConfigurationReqRequest();

    /**
     * Assignment operator
     */
    inline BtApplReadConfigurationReqRequest& operator = (const BtApplReadConfigurationReqRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplReadConfigurationReqRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplReadConfigurationReqRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplReadConfigurationReqRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplReadConfigurationReqRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "instance"

    static const int kInstance = 0;

    /**
     * Clears the field "instance".
     *
     * The field will be set to its default value. The hasInstance()
     * method will return false.
     */
    inline void clearInstance();

    /**
     * Checks whether the field "instance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstance()). Otherwise it will return false.
     */
    inline bool hasInstance () const;

    /**
     * Returns the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instance"
     */
    inline uint8 getInstance () const;

    /**
     * Sets the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @param instance The value which will be set
     */
    inline void setInstance (uint8 instance_);

    // API of field "config_id"

    static const int kConfig_id = 1;

    /**
     * Clears the field "config_id".
     *
     * The field will be set to its default value. The hasConfig_id()
     * method will return false.
     */
    inline void clearConfig_id();

    /**
     * Checks whether the field "config_id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfig_id()). Otherwise it will return false.
     */
    inline bool hasConfig_id () const;

    /**
     * Returns the value of the member "config_id".
     *
     * If the meaning of "config_id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "config_id"
     */
    inline uint16 getConfig_id () const;

    /**
     * Sets the value of the member "config_id".
     *
     * If the meaning of "config_id" isn't clear, then there should be a description here.
     *
     * @param config_id The value which will be set
     */
    inline void setConfig_id (uint16 config_id_);

    static const BtApplReadConfigurationReqRequest &getDefaultInstance();

private:

    inline void set_has_instance ();

    inline void clear_has_instance ();

    inline void set_has_config_id ();

    inline void clear_has_config_id ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _instance;

    uint16 _config_id;

};

/**
 * If the meaning of "BtApplSspDebugModeReqRequest" isn't clear, then there should be a description here.
 */
class BtApplSspDebugModeReqRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplSspDebugModeReqRequest ();

    /**
     * Copy constructor
     */
    inline  BtApplSspDebugModeReqRequest (const BtApplSspDebugModeReqRequest &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplSspDebugModeReqRequest (uint8 mode_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplSspDebugModeReqRequest();

    /**
     * Assignment operator
     */
    inline BtApplSspDebugModeReqRequest& operator = (const BtApplSspDebugModeReqRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplSspDebugModeReqRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplSspDebugModeReqRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplSspDebugModeReqRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplSspDebugModeReqRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mode"

    static const int kMode = 0;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline uint8 getMode () const;

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (uint8 mode_);

    static const BtApplSspDebugModeReqRequest &getDefaultInstance();

private:

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _mode;

};

/**
 * If the meaning of "BtApplTestModeReqRequest" isn't clear, then there should be a description here.
 */
class BtApplTestModeReqRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplTestModeReqRequest ();

    /**
     * Copy constructor
     */
    inline  BtApplTestModeReqRequest (const BtApplTestModeReqRequest &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplTestModeReqRequest (uint8 enable_, uint8 mode_, uint8 role_, const ::std::vector< uint8 >& addr_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplTestModeReqRequest();

    /**
     * Assignment operator
     */
    inline BtApplTestModeReqRequest& operator = (const BtApplTestModeReqRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplTestModeReqRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplTestModeReqRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplTestModeReqRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplTestModeReqRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enable"

    static const int kEnable = 0;

    /**
     * Clears the field "enable".
     *
     * The field will be set to its default value. The hasEnable()
     * method will return false.
     */
    inline void clearEnable();

    /**
     * Checks whether the field "enable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnable()). Otherwise it will return false.
     */
    inline bool hasEnable () const;

    /**
     * Returns the value of the member "enable".
     *
     * If the meaning of "enable" isn't clear, then there should be a description here.
     *
     * @return The value of the field "enable"
     */
    inline uint8 getEnable () const;

    /**
     * Sets the value of the member "enable".
     *
     * If the meaning of "enable" isn't clear, then there should be a description here.
     *
     * @param enable The value which will be set
     */
    inline void setEnable (uint8 enable_);

    // API of field "mode"

    static const int kMode = 1;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline uint8 getMode () const;

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (uint8 mode_);

    // API of field "role"

    static const int kRole = 2;

    /**
     * Clears the field "role".
     *
     * The field will be set to its default value. The hasRole()
     * method will return false.
     */
    inline void clearRole();

    /**
     * Checks whether the field "role" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRole()). Otherwise it will return false.
     */
    inline bool hasRole () const;

    /**
     * Returns the value of the member "role".
     *
     * If the meaning of "role" isn't clear, then there should be a description here.
     *
     * @return The value of the field "role"
     */
    inline uint8 getRole () const;

    /**
     * Sets the value of the member "role".
     *
     * If the meaning of "role" isn't clear, then there should be a description here.
     *
     * @param role The value which will be set
     */
    inline void setRole (uint8 role_);

    // API of field "addr"

    static const int kAddr = 3;

    /**
     * Clears the field "addr".
     *
     * The field will be set to its default value. The hasAddr()
     * method will return false.
     */
    inline void clearAddr();

    /**
     * Checks whether the field "addr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddr()). Otherwise it will return false.
     */
    inline bool hasAddr () const;

    /**
     * Returns the value of the member "addr".
     *
     * If the meaning of "addr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "addr"
     */
    inline const ::std::vector< uint8 >& getAddr () const;

    /**
     * Retrieves the value of the field "addr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "addr".
     */
    inline ::std::vector< uint8 >& getAddrMutable ();

    /**
     * Sets the value of the member "addr".
     *
     * If the meaning of "addr" isn't clear, then there should be a description here.
     *
     * @param addr The value which will be set
     */
    inline void setAddr (const ::std::vector< uint8 >& addr_);

    static const BtApplTestModeReqRequest &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_enable ();

    inline void clear_has_enable ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    inline void set_has_role ();

    inline void clear_has_role ();

    inline void set_has_addr ();

    inline void clear_has_addr ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _enable;

    uint8 _mode;

    uint8 _role;

    ::std::vector< uint8 > _addr;

};

/**
 * If the meaning of "BtApplTestModeLinkQualityReqRequest" isn't clear, then there should be a description here.
 */
class BtApplTestModeLinkQualityReqRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplTestModeLinkQualityReqRequest ();

    /**
     * Copy constructor
     */
    inline  BtApplTestModeLinkQualityReqRequest (const BtApplTestModeLinkQualityReqRequest &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplTestModeLinkQualityReqRequest (uint8 mode_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplTestModeLinkQualityReqRequest();

    /**
     * Assignment operator
     */
    inline BtApplTestModeLinkQualityReqRequest& operator = (const BtApplTestModeLinkQualityReqRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplTestModeLinkQualityReqRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplTestModeLinkQualityReqRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplTestModeLinkQualityReqRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplTestModeLinkQualityReqRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mode"

    static const int kMode = 0;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline uint8 getMode () const;

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (uint8 mode_);

    static const BtApplTestModeLinkQualityReqRequest &getDefaultInstance();

private:

    inline void set_has_mode ();

    inline void clear_has_mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _mode;

};

/**
 * If the meaning of "BtApplDeviceConnectCfmSignal" isn't clear, then there should be a description here.
 */
class BtApplDeviceConnectCfmSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplDeviceConnectCfmSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplDeviceConnectCfmSignal (const BtApplDeviceConnectCfmSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplDeviceConnectCfmSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplDeviceConnectCfmSignal();

    /**
     * Assignment operator
     */
    inline BtApplDeviceConnectCfmSignal& operator = (const BtApplDeviceConnectCfmSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplDeviceConnectCfmSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplDeviceConnectCfmSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplDeviceConnectCfmSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplDeviceConnectCfmSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const BtApplDeviceConnectCfmSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

/**
 * If the meaning of "BtApplDeviceConnectIndSignal" isn't clear, then there should be a description here.
 */
class BtApplDeviceConnectIndSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplDeviceConnectIndSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplDeviceConnectIndSignal (const BtApplDeviceConnectIndSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplDeviceConnectIndSignal (uint8 status_, const ::std::vector< uint8 >& address_, uint64 function_, uint8 instance_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplDeviceConnectIndSignal();

    /**
     * Assignment operator
     */
    inline BtApplDeviceConnectIndSignal& operator = (const BtApplDeviceConnectIndSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplDeviceConnectIndSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplDeviceConnectIndSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplDeviceConnectIndSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplDeviceConnectIndSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    // API of field "address"

    static const int kAddress = 1;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "address"
     */
    inline const ::std::vector< uint8 >& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::vector< uint8 >& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::vector< uint8 >& address_);

    // API of field "function"

    static const int kFunction = 2;

    /**
     * Clears the field "function".
     *
     * The field will be set to its default value. The hasFunction()
     * method will return false.
     */
    inline void clearFunction();

    /**
     * Checks whether the field "function" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFunction()). Otherwise it will return false.
     */
    inline bool hasFunction () const;

    /**
     * Returns the value of the member "function".
     *
     * If the meaning of "function" isn't clear, then there should be a description here.
     *
     * @return The value of the field "function"
     */
    inline uint64 getFunction () const;

    /**
     * Sets the value of the member "function".
     *
     * If the meaning of "function" isn't clear, then there should be a description here.
     *
     * @param function The value which will be set
     */
    inline void setFunction (uint64 function_);

    // API of field "instance"

    static const int kInstance = 3;

    /**
     * Clears the field "instance".
     *
     * The field will be set to its default value. The hasInstance()
     * method will return false.
     */
    inline void clearInstance();

    /**
     * Checks whether the field "instance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstance()). Otherwise it will return false.
     */
    inline bool hasInstance () const;

    /**
     * Returns the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instance"
     */
    inline uint8 getInstance () const;

    /**
     * Sets the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @param instance The value which will be set
     */
    inline void setInstance (uint8 instance_);

    static const BtApplDeviceConnectIndSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_address ();

    inline void clear_has_address ();

    inline void set_has_function ();

    inline void clear_has_function ();

    inline void set_has_instance ();

    inline void clear_has_instance ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _status;

    ::std::vector< uint8 > _address;

    uint64 _function;

    uint8 _instance;

};

/**
 * If the meaning of "BtApplDeviceDisconnectCfmSignal" isn't clear, then there should be a description here.
 */
class BtApplDeviceDisconnectCfmSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplDeviceDisconnectCfmSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplDeviceDisconnectCfmSignal (const BtApplDeviceDisconnectCfmSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplDeviceDisconnectCfmSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplDeviceDisconnectCfmSignal();

    /**
     * Assignment operator
     */
    inline BtApplDeviceDisconnectCfmSignal& operator = (const BtApplDeviceDisconnectCfmSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplDeviceDisconnectCfmSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplDeviceDisconnectCfmSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplDeviceDisconnectCfmSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplDeviceDisconnectCfmSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const BtApplDeviceDisconnectCfmSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

/**
 * If the meaning of "BtApplDeviceDisconnectIndSignal" isn't clear, then there should be a description here.
 */
class BtApplDeviceDisconnectIndSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplDeviceDisconnectIndSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplDeviceDisconnectIndSignal (const BtApplDeviceDisconnectIndSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplDeviceDisconnectIndSignal (uint8 status_, const ::std::vector< uint8 >& address_, uint8 reason_, uint64 function_, uint8 instance_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplDeviceDisconnectIndSignal();

    /**
     * Assignment operator
     */
    inline BtApplDeviceDisconnectIndSignal& operator = (const BtApplDeviceDisconnectIndSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplDeviceDisconnectIndSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplDeviceDisconnectIndSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplDeviceDisconnectIndSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplDeviceDisconnectIndSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    // API of field "address"

    static const int kAddress = 1;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "address"
     */
    inline const ::std::vector< uint8 >& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::vector< uint8 >& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::vector< uint8 >& address_);

    // API of field "reason"

    static const int kReason = 2;

    /**
     * Clears the field "reason".
     *
     * The field will be set to its default value. The hasReason()
     * method will return false.
     */
    inline void clearReason();

    /**
     * Checks whether the field "reason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReason()). Otherwise it will return false.
     */
    inline bool hasReason () const;

    /**
     * Returns the value of the member "reason".
     *
     * If the meaning of "reason" isn't clear, then there should be a description here.
     *
     * @return The value of the field "reason"
     */
    inline uint8 getReason () const;

    /**
     * Sets the value of the member "reason".
     *
     * If the meaning of "reason" isn't clear, then there should be a description here.
     *
     * @param reason The value which will be set
     */
    inline void setReason (uint8 reason_);

    // API of field "function"

    static const int kFunction = 3;

    /**
     * Clears the field "function".
     *
     * The field will be set to its default value. The hasFunction()
     * method will return false.
     */
    inline void clearFunction();

    /**
     * Checks whether the field "function" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFunction()). Otherwise it will return false.
     */
    inline bool hasFunction () const;

    /**
     * Returns the value of the member "function".
     *
     * If the meaning of "function" isn't clear, then there should be a description here.
     *
     * @return The value of the field "function"
     */
    inline uint64 getFunction () const;

    /**
     * Sets the value of the member "function".
     *
     * If the meaning of "function" isn't clear, then there should be a description here.
     *
     * @param function The value which will be set
     */
    inline void setFunction (uint64 function_);

    // API of field "instance"

    static const int kInstance = 4;

    /**
     * Clears the field "instance".
     *
     * The field will be set to its default value. The hasInstance()
     * method will return false.
     */
    inline void clearInstance();

    /**
     * Checks whether the field "instance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstance()). Otherwise it will return false.
     */
    inline bool hasInstance () const;

    /**
     * Returns the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instance"
     */
    inline uint8 getInstance () const;

    /**
     * Sets the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @param instance The value which will be set
     */
    inline void setInstance (uint8 instance_);

    static const BtApplDeviceDisconnectIndSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_address ();

    inline void clear_has_address ();

    inline void set_has_reason ();

    inline void clear_has_reason ();

    inline void set_has_function ();

    inline void clear_has_function ();

    inline void set_has_instance ();

    inline void clear_has_instance ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _status;

    ::std::vector< uint8 > _address;

    uint8 _reason;

    uint64 _function;

    uint8 _instance;

};

/**
 * If the meaning of "BtApplCancelConnectCfmSignal" isn't clear, then there should be a description here.
 */
class BtApplCancelConnectCfmSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplCancelConnectCfmSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplCancelConnectCfmSignal (const BtApplCancelConnectCfmSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplCancelConnectCfmSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplCancelConnectCfmSignal();

    /**
     * Assignment operator
     */
    inline BtApplCancelConnectCfmSignal& operator = (const BtApplCancelConnectCfmSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplCancelConnectCfmSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplCancelConnectCfmSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplCancelConnectCfmSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplCancelConnectCfmSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const BtApplCancelConnectCfmSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

/**
 * If the meaning of "BtApplStatusNotificationIndSignal" isn't clear, then there should be a description here.
 */
class BtApplStatusNotificationIndSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplStatusNotificationIndSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplStatusNotificationIndSignal (const BtApplStatusNotificationIndSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplStatusNotificationIndSignal (const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplStatusNotificationIndSignal();

    /**
     * Assignment operator
     */
    inline BtApplStatusNotificationIndSignal& operator = (const BtApplStatusNotificationIndSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplStatusNotificationIndSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplStatusNotificationIndSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplStatusNotificationIndSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplStatusNotificationIndSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const BtApplStatusNotificationIndSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "BtApplGetHwVersionCfmSignal" isn't clear, then there should be a description here.
 */
class BtApplGetHwVersionCfmSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplGetHwVersionCfmSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplGetHwVersionCfmSignal (const BtApplGetHwVersionCfmSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplGetHwVersionCfmSignal (uint8 status_, uint8 bt_version_, uint16 manufactory_, uint16 hw_subversion_, const ::std::vector< uint8 >& ext_info_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplGetHwVersionCfmSignal();

    /**
     * Assignment operator
     */
    inline BtApplGetHwVersionCfmSignal& operator = (const BtApplGetHwVersionCfmSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplGetHwVersionCfmSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplGetHwVersionCfmSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplGetHwVersionCfmSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplGetHwVersionCfmSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    // API of field "bt_version"

    static const int kBt_version = 1;

    /**
     * Clears the field "bt_version".
     *
     * The field will be set to its default value. The hasBt_version()
     * method will return false.
     */
    inline void clearBt_version();

    /**
     * Checks whether the field "bt_version" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBt_version()). Otherwise it will return false.
     */
    inline bool hasBt_version () const;

    /**
     * Returns the value of the member "bt_version".
     *
     * If the meaning of "bt_version" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bt_version"
     */
    inline uint8 getBt_version () const;

    /**
     * Sets the value of the member "bt_version".
     *
     * If the meaning of "bt_version" isn't clear, then there should be a description here.
     *
     * @param bt_version The value which will be set
     */
    inline void setBt_version (uint8 bt_version_);

    // API of field "manufactory"

    static const int kManufactory = 2;

    /**
     * Clears the field "manufactory".
     *
     * The field will be set to its default value. The hasManufactory()
     * method will return false.
     */
    inline void clearManufactory();

    /**
     * Checks whether the field "manufactory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setManufactory()). Otherwise it will return false.
     */
    inline bool hasManufactory () const;

    /**
     * Returns the value of the member "manufactory".
     *
     * If the meaning of "manufactory" isn't clear, then there should be a description here.
     *
     * @return The value of the field "manufactory"
     */
    inline uint16 getManufactory () const;

    /**
     * Sets the value of the member "manufactory".
     *
     * If the meaning of "manufactory" isn't clear, then there should be a description here.
     *
     * @param manufactory The value which will be set
     */
    inline void setManufactory (uint16 manufactory_);

    // API of field "hw_subversion"

    static const int kHw_subversion = 3;

    /**
     * Clears the field "hw_subversion".
     *
     * The field will be set to its default value. The hasHw_subversion()
     * method will return false.
     */
    inline void clearHw_subversion();

    /**
     * Checks whether the field "hw_subversion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHw_subversion()). Otherwise it will return false.
     */
    inline bool hasHw_subversion () const;

    /**
     * Returns the value of the member "hw_subversion".
     *
     * If the meaning of "hw_subversion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "hw_subversion"
     */
    inline uint16 getHw_subversion () const;

    /**
     * Sets the value of the member "hw_subversion".
     *
     * If the meaning of "hw_subversion" isn't clear, then there should be a description here.
     *
     * @param hw_subversion The value which will be set
     */
    inline void setHw_subversion (uint16 hw_subversion_);

    // API of field "ext_info"

    static const int kExt_info = 4;

    /**
     * Clears the field "ext_info".
     *
     * The field will be set to its default value. The hasExt_info()
     * method will return false.
     */
    inline void clearExt_info();

    /**
     * Checks whether the field "ext_info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExt_info()). Otherwise it will return false.
     */
    inline bool hasExt_info () const;

    /**
     * Returns the value of the member "ext_info".
     *
     * If the meaning of "ext_info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ext_info"
     */
    inline const ::std::vector< uint8 >& getExt_info () const;

    /**
     * Retrieves the value of the field "ext_info" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ext_info".
     */
    inline ::std::vector< uint8 >& getExt_infoMutable ();

    /**
     * Sets the value of the member "ext_info".
     *
     * If the meaning of "ext_info" isn't clear, then there should be a description here.
     *
     * @param ext_info The value which will be set
     */
    inline void setExt_info (const ::std::vector< uint8 >& ext_info_);

    static const BtApplGetHwVersionCfmSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_bt_version ();

    inline void clear_has_bt_version ();

    inline void set_has_manufactory ();

    inline void clear_has_manufactory ();

    inline void set_has_hw_subversion ();

    inline void clear_has_hw_subversion ();

    inline void set_has_ext_info ();

    inline void clear_has_ext_info ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _status;

    uint8 _bt_version;

    uint16 _manufactory;

    uint16 _hw_subversion;

    ::std::vector< uint8 > _ext_info;

};

/**
 * If the meaning of "BtApplSetConfigurationCfmSignal" isn't clear, then there should be a description here.
 */
class BtApplSetConfigurationCfmSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplSetConfigurationCfmSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplSetConfigurationCfmSignal (const BtApplSetConfigurationCfmSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplSetConfigurationCfmSignal (uint8 status_, uint8 instance_, uint16 config_id_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplSetConfigurationCfmSignal();

    /**
     * Assignment operator
     */
    inline BtApplSetConfigurationCfmSignal& operator = (const BtApplSetConfigurationCfmSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplSetConfigurationCfmSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplSetConfigurationCfmSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplSetConfigurationCfmSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplSetConfigurationCfmSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    // API of field "instance"

    static const int kInstance = 1;

    /**
     * Clears the field "instance".
     *
     * The field will be set to its default value. The hasInstance()
     * method will return false.
     */
    inline void clearInstance();

    /**
     * Checks whether the field "instance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstance()). Otherwise it will return false.
     */
    inline bool hasInstance () const;

    /**
     * Returns the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instance"
     */
    inline uint8 getInstance () const;

    /**
     * Sets the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @param instance The value which will be set
     */
    inline void setInstance (uint8 instance_);

    // API of field "config_id"

    static const int kConfig_id = 2;

    /**
     * Clears the field "config_id".
     *
     * The field will be set to its default value. The hasConfig_id()
     * method will return false.
     */
    inline void clearConfig_id();

    /**
     * Checks whether the field "config_id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfig_id()). Otherwise it will return false.
     */
    inline bool hasConfig_id () const;

    /**
     * Returns the value of the member "config_id".
     *
     * If the meaning of "config_id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "config_id"
     */
    inline uint16 getConfig_id () const;

    /**
     * Sets the value of the member "config_id".
     *
     * If the meaning of "config_id" isn't clear, then there should be a description here.
     *
     * @param config_id The value which will be set
     */
    inline void setConfig_id (uint16 config_id_);

    static const BtApplSetConfigurationCfmSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_instance ();

    inline void clear_has_instance ();

    inline void set_has_config_id ();

    inline void clear_has_config_id ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _status;

    uint8 _instance;

    uint16 _config_id;

};

/**
 * If the meaning of "BtApplReadConfigurationCfmSignal" isn't clear, then there should be a description here.
 */
class BtApplReadConfigurationCfmSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplReadConfigurationCfmSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplReadConfigurationCfmSignal (const BtApplReadConfigurationCfmSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplReadConfigurationCfmSignal (uint8 status_, uint8 instance_, uint16 config_id_, const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplReadConfigurationCfmSignal();

    /**
     * Assignment operator
     */
    inline BtApplReadConfigurationCfmSignal& operator = (const BtApplReadConfigurationCfmSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplReadConfigurationCfmSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplReadConfigurationCfmSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplReadConfigurationCfmSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplReadConfigurationCfmSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    // API of field "instance"

    static const int kInstance = 1;

    /**
     * Clears the field "instance".
     *
     * The field will be set to its default value. The hasInstance()
     * method will return false.
     */
    inline void clearInstance();

    /**
     * Checks whether the field "instance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstance()). Otherwise it will return false.
     */
    inline bool hasInstance () const;

    /**
     * Returns the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @return The value of the field "instance"
     */
    inline uint8 getInstance () const;

    /**
     * Sets the value of the member "instance".
     *
     * If the meaning of "instance" isn't clear, then there should be a description here.
     *
     * @param instance The value which will be set
     */
    inline void setInstance (uint8 instance_);

    // API of field "config_id"

    static const int kConfig_id = 2;

    /**
     * Clears the field "config_id".
     *
     * The field will be set to its default value. The hasConfig_id()
     * method will return false.
     */
    inline void clearConfig_id();

    /**
     * Checks whether the field "config_id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfig_id()). Otherwise it will return false.
     */
    inline bool hasConfig_id () const;

    /**
     * Returns the value of the member "config_id".
     *
     * If the meaning of "config_id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "config_id"
     */
    inline uint16 getConfig_id () const;

    /**
     * Sets the value of the member "config_id".
     *
     * If the meaning of "config_id" isn't clear, then there should be a description here.
     *
     * @param config_id The value which will be set
     */
    inline void setConfig_id (uint16 config_id_);

    // API of field "data"

    static const int kData = 3;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const BtApplReadConfigurationCfmSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_instance ();

    inline void clear_has_instance ();

    inline void set_has_config_id ();

    inline void clear_has_config_id ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _status;

    uint8 _instance;

    uint16 _config_id;

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "BtApplTestModeCfmSignal" isn't clear, then there should be a description here.
 */
class BtApplTestModeCfmSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplTestModeCfmSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplTestModeCfmSignal (const BtApplTestModeCfmSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplTestModeCfmSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplTestModeCfmSignal();

    /**
     * Assignment operator
     */
    inline BtApplTestModeCfmSignal& operator = (const BtApplTestModeCfmSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplTestModeCfmSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplTestModeCfmSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplTestModeCfmSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplTestModeCfmSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const BtApplTestModeCfmSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

/**
 * If the meaning of "BtApplTestModeCompIndSignal" isn't clear, then there should be a description here.
 */
class BtApplTestModeCompIndSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplTestModeCompIndSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplTestModeCompIndSignal (const BtApplTestModeCompIndSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplTestModeCompIndSignal (uint8 notiType_, uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplTestModeCompIndSignal();

    /**
     * Assignment operator
     */
    inline BtApplTestModeCompIndSignal& operator = (const BtApplTestModeCompIndSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplTestModeCompIndSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplTestModeCompIndSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplTestModeCompIndSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplTestModeCompIndSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "notiType"

    static const int kNotiType = 0;

    /**
     * Clears the field "notiType".
     *
     * The field will be set to its default value. The hasNotiType()
     * method will return false.
     */
    inline void clearNotiType();

    /**
     * Checks whether the field "notiType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNotiType()). Otherwise it will return false.
     */
    inline bool hasNotiType () const;

    /**
     * Returns the value of the member "notiType".
     *
     * If the meaning of "notiType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "notiType"
     */
    inline uint8 getNotiType () const;

    /**
     * Sets the value of the member "notiType".
     *
     * If the meaning of "notiType" isn't clear, then there should be a description here.
     *
     * @param notiType The value which will be set
     */
    inline void setNotiType (uint8 notiType_);

    // API of field "status"

    static const int kStatus = 1;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const BtApplTestModeCompIndSignal &getDefaultInstance();

private:

    inline void set_has_notiType ();

    inline void clear_has_notiType ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _notiType;

    uint8 _status;

};

/**
 * If the meaning of "BtApplTestModeLinkQualityCfmSignal" isn't clear, then there should be a description here.
 */
class BtApplTestModeLinkQualityCfmSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplTestModeLinkQualityCfmSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplTestModeLinkQualityCfmSignal (const BtApplTestModeLinkQualityCfmSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplTestModeLinkQualityCfmSignal (uint8 status_, uint8 rssi_, uint8 linkquality_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplTestModeLinkQualityCfmSignal();

    /**
     * Assignment operator
     */
    inline BtApplTestModeLinkQualityCfmSignal& operator = (const BtApplTestModeLinkQualityCfmSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplTestModeLinkQualityCfmSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplTestModeLinkQualityCfmSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplTestModeLinkQualityCfmSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplTestModeLinkQualityCfmSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    // API of field "rssi"

    static const int kRssi = 1;

    /**
     * Clears the field "rssi".
     *
     * The field will be set to its default value. The hasRssi()
     * method will return false.
     */
    inline void clearRssi();

    /**
     * Checks whether the field "rssi" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRssi()). Otherwise it will return false.
     */
    inline bool hasRssi () const;

    /**
     * Returns the value of the member "rssi".
     *
     * If the meaning of "rssi" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rssi"
     */
    inline uint8 getRssi () const;

    /**
     * Sets the value of the member "rssi".
     *
     * If the meaning of "rssi" isn't clear, then there should be a description here.
     *
     * @param rssi The value which will be set
     */
    inline void setRssi (uint8 rssi_);

    // API of field "linkquality"

    static const int kLinkquality = 2;

    /**
     * Clears the field "linkquality".
     *
     * The field will be set to its default value. The hasLinkquality()
     * method will return false.
     */
    inline void clearLinkquality();

    /**
     * Checks whether the field "linkquality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLinkquality()). Otherwise it will return false.
     */
    inline bool hasLinkquality () const;

    /**
     * Returns the value of the member "linkquality".
     *
     * If the meaning of "linkquality" isn't clear, then there should be a description here.
     *
     * @return The value of the field "linkquality"
     */
    inline uint8 getLinkquality () const;

    /**
     * Sets the value of the member "linkquality".
     *
     * If the meaning of "linkquality" isn't clear, then there should be a description here.
     *
     * @param linkquality The value which will be set
     */
    inline void setLinkquality (uint8 linkquality_);

    static const BtApplTestModeLinkQualityCfmSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_rssi ();

    inline void clear_has_rssi ();

    inline void set_has_linkquality ();

    inline void clear_has_linkquality ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _status;

    uint8 _rssi;

    uint8 _linkquality;

};

inline  BtApplDeviceConnectReqRequest::BtApplDeviceConnectReqRequest ()  :
    _address (),
    _function (0u),
    _instance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplDeviceConnectReqRequest::BtApplDeviceConnectReqRequest (const BtApplDeviceConnectReqRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _address (),
    _function (0u),
    _instance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplDeviceConnectReqRequest::BtApplDeviceConnectReqRequest (const ::std::vector< uint8 >& address_, uint64 function_, uint8 instance_)  :
    _address (address_),
    _function (function_),
    _instance (instance_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplDeviceConnectReqRequest::~BtApplDeviceConnectReqRequest() {
}

inline BtApplDeviceConnectReqRequest& BtApplDeviceConnectReqRequest::operator = (const BtApplDeviceConnectReqRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
        if (rhs.hasFunction()) {
            setFunction(rhs.getFunction());
        } else {
            clearFunction();
        }
        if (rhs.hasInstance()) {
            setInstance(rhs.getInstance());
        } else {
            clearInstance();
        }
    }
    return *this;
}

inline bool BtApplDeviceConnectReqRequest::operator == (const BtApplDeviceConnectReqRequest& rhs) const {
    return (((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()) &&
        ((!hasFunction() && !rhs.hasFunction()) || getFunction() == rhs.getFunction()) &&
        ((!hasInstance() && !rhs.hasInstance()) || getInstance() == rhs.getInstance()));
}

inline bool BtApplDeviceConnectReqRequest::operator != (const BtApplDeviceConnectReqRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplDeviceConnectReqRequest::operator < (const BtApplDeviceConnectReqRequest& rhs) const {
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    if (hasFunction() || rhs.hasFunction()) {
        if (getFunction() < rhs.getFunction()) return true;
        if (getFunction() > rhs.getFunction()) return false;
    }
    if (hasInstance() || rhs.hasInstance()) {
        if (getInstance() < rhs.getInstance()) return true;
        if (getInstance() > rhs.getInstance()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplDeviceConnectReqRequest::clone() {
    return new BtApplDeviceConnectReqRequest(*this);
}

inline bool BtApplDeviceConnectReqRequest::operator > (const BtApplDeviceConnectReqRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplDeviceConnectReqRequest::clear() {
    clearAddress();
    clearFunction();
    clearInstance();
}

inline void BtApplDeviceConnectReqRequest::clearAddress() {
    if (hasAddress()) {
         clear_has_address();
        _address.clear();
     }
}

inline bool BtApplDeviceConnectReqRequest::hasAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& BtApplDeviceConnectReqRequest::getAddress () const {
    return _address;
}

inline ::std::vector< uint8 >& BtApplDeviceConnectReqRequest::getAddressMutable () {
    set_has_address();
    return _address;
}

inline void BtApplDeviceConnectReqRequest::setAddress (const ::std::vector< uint8 >& address_) {
    set_has_address();
    this->_address = address_;
}

inline void BtApplDeviceConnectReqRequest::clearFunction() {
    if (hasFunction()) {
         clear_has_function();
        _function = 0u;
     }
}

inline bool BtApplDeviceConnectReqRequest::hasFunction () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint64 BtApplDeviceConnectReqRequest::getFunction () const {
    return _function;
}

inline void BtApplDeviceConnectReqRequest::setFunction (uint64 function_) {
    set_has_function();
    this->_function = function_;
}

inline void BtApplDeviceConnectReqRequest::clearInstance() {
    if (hasInstance()) {
         clear_has_instance();
        _instance = 0u;
     }
}

inline bool BtApplDeviceConnectReqRequest::hasInstance () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 BtApplDeviceConnectReqRequest::getInstance () const {
    return _instance;
}

inline void BtApplDeviceConnectReqRequest::setInstance (uint8 instance_) {
    set_has_instance();
    this->_instance = instance_;
}

inline void BtApplDeviceConnectReqRequest::set_has_address () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplDeviceConnectReqRequest::clear_has_address () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplDeviceConnectReqRequest::set_has_function () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplDeviceConnectReqRequest::clear_has_function () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BtApplDeviceConnectReqRequest::set_has_instance () {
    _has_bits_[0] |= 1u << 2;
}

inline void BtApplDeviceConnectReqRequest::clear_has_instance () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  BtApplDeviceDisconnectReqRequest::BtApplDeviceDisconnectReqRequest ()  :
    _function (0u),
    _instance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplDeviceDisconnectReqRequest::BtApplDeviceDisconnectReqRequest (const BtApplDeviceDisconnectReqRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _function (0u),
    _instance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplDeviceDisconnectReqRequest::BtApplDeviceDisconnectReqRequest (uint64 function_, uint8 instance_)  :
    _function (function_),
    _instance (instance_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplDeviceDisconnectReqRequest::~BtApplDeviceDisconnectReqRequest() {
}

inline BtApplDeviceDisconnectReqRequest& BtApplDeviceDisconnectReqRequest::operator = (const BtApplDeviceDisconnectReqRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFunction()) {
            setFunction(rhs.getFunction());
        } else {
            clearFunction();
        }
        if (rhs.hasInstance()) {
            setInstance(rhs.getInstance());
        } else {
            clearInstance();
        }
    }
    return *this;
}

inline bool BtApplDeviceDisconnectReqRequest::operator == (const BtApplDeviceDisconnectReqRequest& rhs) const {
    return (((!hasFunction() && !rhs.hasFunction()) || getFunction() == rhs.getFunction()) &&
        ((!hasInstance() && !rhs.hasInstance()) || getInstance() == rhs.getInstance()));
}

inline bool BtApplDeviceDisconnectReqRequest::operator != (const BtApplDeviceDisconnectReqRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplDeviceDisconnectReqRequest::operator < (const BtApplDeviceDisconnectReqRequest& rhs) const {
    if (hasFunction() || rhs.hasFunction()) {
        if (getFunction() < rhs.getFunction()) return true;
        if (getFunction() > rhs.getFunction()) return false;
    }
    if (hasInstance() || rhs.hasInstance()) {
        if (getInstance() < rhs.getInstance()) return true;
        if (getInstance() > rhs.getInstance()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplDeviceDisconnectReqRequest::clone() {
    return new BtApplDeviceDisconnectReqRequest(*this);
}

inline bool BtApplDeviceDisconnectReqRequest::operator > (const BtApplDeviceDisconnectReqRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplDeviceDisconnectReqRequest::clear() {
    clearFunction();
    clearInstance();
}

inline void BtApplDeviceDisconnectReqRequest::clearFunction() {
    if (hasFunction()) {
         clear_has_function();
        _function = 0u;
     }
}

inline bool BtApplDeviceDisconnectReqRequest::hasFunction () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 BtApplDeviceDisconnectReqRequest::getFunction () const {
    return _function;
}

inline void BtApplDeviceDisconnectReqRequest::setFunction (uint64 function_) {
    set_has_function();
    this->_function = function_;
}

inline void BtApplDeviceDisconnectReqRequest::clearInstance() {
    if (hasInstance()) {
         clear_has_instance();
        _instance = 0u;
     }
}

inline bool BtApplDeviceDisconnectReqRequest::hasInstance () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 BtApplDeviceDisconnectReqRequest::getInstance () const {
    return _instance;
}

inline void BtApplDeviceDisconnectReqRequest::setInstance (uint8 instance_) {
    set_has_instance();
    this->_instance = instance_;
}

inline void BtApplDeviceDisconnectReqRequest::set_has_function () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplDeviceDisconnectReqRequest::clear_has_function () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplDeviceDisconnectReqRequest::set_has_instance () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplDeviceDisconnectReqRequest::clear_has_instance () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  BtApplSetConfigurationReqRequest::BtApplSetConfigurationReqRequest ()  :
    _instance (0u),
    _config_id (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplSetConfigurationReqRequest::BtApplSetConfigurationReqRequest (const BtApplSetConfigurationReqRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _instance (0u),
    _config_id (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplSetConfigurationReqRequest::BtApplSetConfigurationReqRequest (uint8 instance_, uint16 config_id_, const ::std::vector< uint8 >& data_)  :
    _instance (instance_),
    _config_id (config_id_),
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplSetConfigurationReqRequest::~BtApplSetConfigurationReqRequest() {
}

inline BtApplSetConfigurationReqRequest& BtApplSetConfigurationReqRequest::operator = (const BtApplSetConfigurationReqRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInstance()) {
            setInstance(rhs.getInstance());
        } else {
            clearInstance();
        }
        if (rhs.hasConfig_id()) {
            setConfig_id(rhs.getConfig_id());
        } else {
            clearConfig_id();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool BtApplSetConfigurationReqRequest::operator == (const BtApplSetConfigurationReqRequest& rhs) const {
    return (((!hasInstance() && !rhs.hasInstance()) || getInstance() == rhs.getInstance()) &&
        ((!hasConfig_id() && !rhs.hasConfig_id()) || getConfig_id() == rhs.getConfig_id()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool BtApplSetConfigurationReqRequest::operator != (const BtApplSetConfigurationReqRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplSetConfigurationReqRequest::operator < (const BtApplSetConfigurationReqRequest& rhs) const {
    if (hasInstance() || rhs.hasInstance()) {
        if (getInstance() < rhs.getInstance()) return true;
        if (getInstance() > rhs.getInstance()) return false;
    }
    if (hasConfig_id() || rhs.hasConfig_id()) {
        if (getConfig_id() < rhs.getConfig_id()) return true;
        if (getConfig_id() > rhs.getConfig_id()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplSetConfigurationReqRequest::clone() {
    return new BtApplSetConfigurationReqRequest(*this);
}

inline bool BtApplSetConfigurationReqRequest::operator > (const BtApplSetConfigurationReqRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplSetConfigurationReqRequest::clear() {
    clearInstance();
    clearConfig_id();
    clearData();
}

inline void BtApplSetConfigurationReqRequest::clearInstance() {
    if (hasInstance()) {
         clear_has_instance();
        _instance = 0u;
     }
}

inline bool BtApplSetConfigurationReqRequest::hasInstance () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplSetConfigurationReqRequest::getInstance () const {
    return _instance;
}

inline void BtApplSetConfigurationReqRequest::setInstance (uint8 instance_) {
    set_has_instance();
    this->_instance = instance_;
}

inline void BtApplSetConfigurationReqRequest::clearConfig_id() {
    if (hasConfig_id()) {
         clear_has_config_id();
        _config_id = 0u;
     }
}

inline bool BtApplSetConfigurationReqRequest::hasConfig_id () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 BtApplSetConfigurationReqRequest::getConfig_id () const {
    return _config_id;
}

inline void BtApplSetConfigurationReqRequest::setConfig_id (uint16 config_id_) {
    set_has_config_id();
    this->_config_id = config_id_;
}

inline void BtApplSetConfigurationReqRequest::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool BtApplSetConfigurationReqRequest::hasData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint8 >& BtApplSetConfigurationReqRequest::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& BtApplSetConfigurationReqRequest::getDataMutable () {
    set_has_data();
    return _data;
}

inline void BtApplSetConfigurationReqRequest::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void BtApplSetConfigurationReqRequest::set_has_instance () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplSetConfigurationReqRequest::clear_has_instance () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplSetConfigurationReqRequest::set_has_config_id () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplSetConfigurationReqRequest::clear_has_config_id () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BtApplSetConfigurationReqRequest::set_has_data () {
    _has_bits_[0] |= 1u << 2;
}

inline void BtApplSetConfigurationReqRequest::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  BtApplReadConfigurationReqRequest::BtApplReadConfigurationReqRequest ()  :
    _instance (0u),
    _config_id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplReadConfigurationReqRequest::BtApplReadConfigurationReqRequest (const BtApplReadConfigurationReqRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _instance (0u),
    _config_id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplReadConfigurationReqRequest::BtApplReadConfigurationReqRequest (uint8 instance_, uint16 config_id_)  :
    _instance (instance_),
    _config_id (config_id_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplReadConfigurationReqRequest::~BtApplReadConfigurationReqRequest() {
}

inline BtApplReadConfigurationReqRequest& BtApplReadConfigurationReqRequest::operator = (const BtApplReadConfigurationReqRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInstance()) {
            setInstance(rhs.getInstance());
        } else {
            clearInstance();
        }
        if (rhs.hasConfig_id()) {
            setConfig_id(rhs.getConfig_id());
        } else {
            clearConfig_id();
        }
    }
    return *this;
}

inline bool BtApplReadConfigurationReqRequest::operator == (const BtApplReadConfigurationReqRequest& rhs) const {
    return (((!hasInstance() && !rhs.hasInstance()) || getInstance() == rhs.getInstance()) &&
        ((!hasConfig_id() && !rhs.hasConfig_id()) || getConfig_id() == rhs.getConfig_id()));
}

inline bool BtApplReadConfigurationReqRequest::operator != (const BtApplReadConfigurationReqRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplReadConfigurationReqRequest::operator < (const BtApplReadConfigurationReqRequest& rhs) const {
    if (hasInstance() || rhs.hasInstance()) {
        if (getInstance() < rhs.getInstance()) return true;
        if (getInstance() > rhs.getInstance()) return false;
    }
    if (hasConfig_id() || rhs.hasConfig_id()) {
        if (getConfig_id() < rhs.getConfig_id()) return true;
        if (getConfig_id() > rhs.getConfig_id()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplReadConfigurationReqRequest::clone() {
    return new BtApplReadConfigurationReqRequest(*this);
}

inline bool BtApplReadConfigurationReqRequest::operator > (const BtApplReadConfigurationReqRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplReadConfigurationReqRequest::clear() {
    clearInstance();
    clearConfig_id();
}

inline void BtApplReadConfigurationReqRequest::clearInstance() {
    if (hasInstance()) {
         clear_has_instance();
        _instance = 0u;
     }
}

inline bool BtApplReadConfigurationReqRequest::hasInstance () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplReadConfigurationReqRequest::getInstance () const {
    return _instance;
}

inline void BtApplReadConfigurationReqRequest::setInstance (uint8 instance_) {
    set_has_instance();
    this->_instance = instance_;
}

inline void BtApplReadConfigurationReqRequest::clearConfig_id() {
    if (hasConfig_id()) {
         clear_has_config_id();
        _config_id = 0u;
     }
}

inline bool BtApplReadConfigurationReqRequest::hasConfig_id () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 BtApplReadConfigurationReqRequest::getConfig_id () const {
    return _config_id;
}

inline void BtApplReadConfigurationReqRequest::setConfig_id (uint16 config_id_) {
    set_has_config_id();
    this->_config_id = config_id_;
}

inline void BtApplReadConfigurationReqRequest::set_has_instance () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplReadConfigurationReqRequest::clear_has_instance () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplReadConfigurationReqRequest::set_has_config_id () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplReadConfigurationReqRequest::clear_has_config_id () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  BtApplSspDebugModeReqRequest::BtApplSspDebugModeReqRequest ()  :
    _mode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplSspDebugModeReqRequest::BtApplSspDebugModeReqRequest (const BtApplSspDebugModeReqRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _mode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplSspDebugModeReqRequest::BtApplSspDebugModeReqRequest (uint8 mode_)  :
    _mode (mode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplSspDebugModeReqRequest::~BtApplSspDebugModeReqRequest() {
}

inline BtApplSspDebugModeReqRequest& BtApplSspDebugModeReqRequest::operator = (const BtApplSspDebugModeReqRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool BtApplSspDebugModeReqRequest::operator == (const BtApplSspDebugModeReqRequest& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool BtApplSspDebugModeReqRequest::operator != (const BtApplSspDebugModeReqRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplSspDebugModeReqRequest::operator < (const BtApplSspDebugModeReqRequest& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplSspDebugModeReqRequest::clone() {
    return new BtApplSspDebugModeReqRequest(*this);
}

inline bool BtApplSspDebugModeReqRequest::operator > (const BtApplSspDebugModeReqRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplSspDebugModeReqRequest::clear() {
    clearMode();
}

inline void BtApplSspDebugModeReqRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode = 0u;
     }
}

inline bool BtApplSspDebugModeReqRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplSspDebugModeReqRequest::getMode () const {
    return _mode;
}

inline void BtApplSspDebugModeReqRequest::setMode (uint8 mode_) {
    set_has_mode();
    this->_mode = mode_;
}

inline void BtApplSspDebugModeReqRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplSspDebugModeReqRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplTestModeReqRequest::BtApplTestModeReqRequest ()  :
    _enable (0u),
    _mode (0u),
    _role (0u),
    _addr ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplTestModeReqRequest::BtApplTestModeReqRequest (const BtApplTestModeReqRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _enable (0u),
    _mode (0u),
    _role (0u),
    _addr ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplTestModeReqRequest::BtApplTestModeReqRequest (uint8 enable_, uint8 mode_, uint8 role_, const ::std::vector< uint8 >& addr_)  :
    _enable (enable_),
    _mode (mode_),
    _role (role_),
    _addr (addr_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplTestModeReqRequest::~BtApplTestModeReqRequest() {
}

inline BtApplTestModeReqRequest& BtApplTestModeReqRequest::operator = (const BtApplTestModeReqRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnable()) {
            setEnable(rhs.getEnable());
        } else {
            clearEnable();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
        if (rhs.hasRole()) {
            setRole(rhs.getRole());
        } else {
            clearRole();
        }
        if (rhs.hasAddr()) {
            setAddr(rhs.getAddr());
        } else {
            clearAddr();
        }
    }
    return *this;
}

inline bool BtApplTestModeReqRequest::operator == (const BtApplTestModeReqRequest& rhs) const {
    return (((!hasEnable() && !rhs.hasEnable()) || getEnable() == rhs.getEnable()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()) &&
        ((!hasRole() && !rhs.hasRole()) || getRole() == rhs.getRole()) &&
        ((!hasAddr() && !rhs.hasAddr()) || getAddr() == rhs.getAddr()));
}

inline bool BtApplTestModeReqRequest::operator != (const BtApplTestModeReqRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplTestModeReqRequest::operator < (const BtApplTestModeReqRequest& rhs) const {
    if (hasEnable() || rhs.hasEnable()) {
        if (getEnable() < rhs.getEnable()) return true;
        if (getEnable() > rhs.getEnable()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    if (hasRole() || rhs.hasRole()) {
        if (getRole() < rhs.getRole()) return true;
        if (getRole() > rhs.getRole()) return false;
    }
    if (hasAddr() || rhs.hasAddr()) {
        if (getAddr() < rhs.getAddr()) return true;
        if (getAddr() > rhs.getAddr()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplTestModeReqRequest::clone() {
    return new BtApplTestModeReqRequest(*this);
}

inline bool BtApplTestModeReqRequest::operator > (const BtApplTestModeReqRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplTestModeReqRequest::clear() {
    clearEnable();
    clearMode();
    clearRole();
    clearAddr();
}

inline void BtApplTestModeReqRequest::clearEnable() {
    if (hasEnable()) {
         clear_has_enable();
        _enable = 0u;
     }
}

inline bool BtApplTestModeReqRequest::hasEnable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplTestModeReqRequest::getEnable () const {
    return _enable;
}

inline void BtApplTestModeReqRequest::setEnable (uint8 enable_) {
    set_has_enable();
    this->_enable = enable_;
}

inline void BtApplTestModeReqRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode = 0u;
     }
}

inline bool BtApplTestModeReqRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 BtApplTestModeReqRequest::getMode () const {
    return _mode;
}

inline void BtApplTestModeReqRequest::setMode (uint8 mode_) {
    set_has_mode();
    this->_mode = mode_;
}

inline void BtApplTestModeReqRequest::clearRole() {
    if (hasRole()) {
         clear_has_role();
        _role = 0u;
     }
}

inline bool BtApplTestModeReqRequest::hasRole () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 BtApplTestModeReqRequest::getRole () const {
    return _role;
}

inline void BtApplTestModeReqRequest::setRole (uint8 role_) {
    set_has_role();
    this->_role = role_;
}

inline void BtApplTestModeReqRequest::clearAddr() {
    if (hasAddr()) {
         clear_has_addr();
        _addr.clear();
     }
}

inline bool BtApplTestModeReqRequest::hasAddr () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< uint8 >& BtApplTestModeReqRequest::getAddr () const {
    return _addr;
}

inline ::std::vector< uint8 >& BtApplTestModeReqRequest::getAddrMutable () {
    set_has_addr();
    return _addr;
}

inline void BtApplTestModeReqRequest::setAddr (const ::std::vector< uint8 >& addr_) {
    set_has_addr();
    this->_addr = addr_;
}

inline void BtApplTestModeReqRequest::set_has_enable () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplTestModeReqRequest::clear_has_enable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplTestModeReqRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplTestModeReqRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BtApplTestModeReqRequest::set_has_role () {
    _has_bits_[0] |= 1u << 2;
}

inline void BtApplTestModeReqRequest::clear_has_role () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void BtApplTestModeReqRequest::set_has_addr () {
    _has_bits_[0] |= 1u << 3;
}

inline void BtApplTestModeReqRequest::clear_has_addr () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  BtApplTestModeLinkQualityReqRequest::BtApplTestModeLinkQualityReqRequest ()  :
    _mode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplTestModeLinkQualityReqRequest::BtApplTestModeLinkQualityReqRequest (const BtApplTestModeLinkQualityReqRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _mode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplTestModeLinkQualityReqRequest::BtApplTestModeLinkQualityReqRequest (uint8 mode_)  :
    _mode (mode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplTestModeLinkQualityReqRequest::~BtApplTestModeLinkQualityReqRequest() {
}

inline BtApplTestModeLinkQualityReqRequest& BtApplTestModeLinkQualityReqRequest::operator = (const BtApplTestModeLinkQualityReqRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool BtApplTestModeLinkQualityReqRequest::operator == (const BtApplTestModeLinkQualityReqRequest& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool BtApplTestModeLinkQualityReqRequest::operator != (const BtApplTestModeLinkQualityReqRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplTestModeLinkQualityReqRequest::operator < (const BtApplTestModeLinkQualityReqRequest& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplTestModeLinkQualityReqRequest::clone() {
    return new BtApplTestModeLinkQualityReqRequest(*this);
}

inline bool BtApplTestModeLinkQualityReqRequest::operator > (const BtApplTestModeLinkQualityReqRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplTestModeLinkQualityReqRequest::clear() {
    clearMode();
}

inline void BtApplTestModeLinkQualityReqRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode = 0u;
     }
}

inline bool BtApplTestModeLinkQualityReqRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplTestModeLinkQualityReqRequest::getMode () const {
    return _mode;
}

inline void BtApplTestModeLinkQualityReqRequest::setMode (uint8 mode_) {
    set_has_mode();
    this->_mode = mode_;
}

inline void BtApplTestModeLinkQualityReqRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplTestModeLinkQualityReqRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplDeviceConnectCfmSignal::BtApplDeviceConnectCfmSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplDeviceConnectCfmSignal::BtApplDeviceConnectCfmSignal (const BtApplDeviceConnectCfmSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplDeviceConnectCfmSignal::BtApplDeviceConnectCfmSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplDeviceConnectCfmSignal::~BtApplDeviceConnectCfmSignal() {
}

inline BtApplDeviceConnectCfmSignal& BtApplDeviceConnectCfmSignal::operator = (const BtApplDeviceConnectCfmSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool BtApplDeviceConnectCfmSignal::operator == (const BtApplDeviceConnectCfmSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool BtApplDeviceConnectCfmSignal::operator != (const BtApplDeviceConnectCfmSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplDeviceConnectCfmSignal::operator < (const BtApplDeviceConnectCfmSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplDeviceConnectCfmSignal::clone() {
    return new BtApplDeviceConnectCfmSignal(*this);
}

inline bool BtApplDeviceConnectCfmSignal::operator > (const BtApplDeviceConnectCfmSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplDeviceConnectCfmSignal::clear() {
    clearStatus();
}

inline void BtApplDeviceConnectCfmSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplDeviceConnectCfmSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplDeviceConnectCfmSignal::getStatus () const {
    return _status;
}

inline void BtApplDeviceConnectCfmSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplDeviceConnectCfmSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplDeviceConnectCfmSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplDeviceConnectIndSignal::BtApplDeviceConnectIndSignal ()  :
    _status (0u),
    _address (),
    _function (0u),
    _instance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplDeviceConnectIndSignal::BtApplDeviceConnectIndSignal (const BtApplDeviceConnectIndSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u),
    _address (),
    _function (0u),
    _instance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplDeviceConnectIndSignal::BtApplDeviceConnectIndSignal (uint8 status_, const ::std::vector< uint8 >& address_, uint64 function_, uint8 instance_)  :
    _status (status_),
    _address (address_),
    _function (function_),
    _instance (instance_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplDeviceConnectIndSignal::~BtApplDeviceConnectIndSignal() {
}

inline BtApplDeviceConnectIndSignal& BtApplDeviceConnectIndSignal::operator = (const BtApplDeviceConnectIndSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
        if (rhs.hasFunction()) {
            setFunction(rhs.getFunction());
        } else {
            clearFunction();
        }
        if (rhs.hasInstance()) {
            setInstance(rhs.getInstance());
        } else {
            clearInstance();
        }
    }
    return *this;
}

inline bool BtApplDeviceConnectIndSignal::operator == (const BtApplDeviceConnectIndSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()) &&
        ((!hasFunction() && !rhs.hasFunction()) || getFunction() == rhs.getFunction()) &&
        ((!hasInstance() && !rhs.hasInstance()) || getInstance() == rhs.getInstance()));
}

inline bool BtApplDeviceConnectIndSignal::operator != (const BtApplDeviceConnectIndSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplDeviceConnectIndSignal::operator < (const BtApplDeviceConnectIndSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    if (hasFunction() || rhs.hasFunction()) {
        if (getFunction() < rhs.getFunction()) return true;
        if (getFunction() > rhs.getFunction()) return false;
    }
    if (hasInstance() || rhs.hasInstance()) {
        if (getInstance() < rhs.getInstance()) return true;
        if (getInstance() > rhs.getInstance()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplDeviceConnectIndSignal::clone() {
    return new BtApplDeviceConnectIndSignal(*this);
}

inline bool BtApplDeviceConnectIndSignal::operator > (const BtApplDeviceConnectIndSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplDeviceConnectIndSignal::clear() {
    clearStatus();
    clearAddress();
    clearFunction();
    clearInstance();
}

inline void BtApplDeviceConnectIndSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplDeviceConnectIndSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplDeviceConnectIndSignal::getStatus () const {
    return _status;
}

inline void BtApplDeviceConnectIndSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplDeviceConnectIndSignal::clearAddress() {
    if (hasAddress()) {
         clear_has_address();
        _address.clear();
     }
}

inline bool BtApplDeviceConnectIndSignal::hasAddress () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& BtApplDeviceConnectIndSignal::getAddress () const {
    return _address;
}

inline ::std::vector< uint8 >& BtApplDeviceConnectIndSignal::getAddressMutable () {
    set_has_address();
    return _address;
}

inline void BtApplDeviceConnectIndSignal::setAddress (const ::std::vector< uint8 >& address_) {
    set_has_address();
    this->_address = address_;
}

inline void BtApplDeviceConnectIndSignal::clearFunction() {
    if (hasFunction()) {
         clear_has_function();
        _function = 0u;
     }
}

inline bool BtApplDeviceConnectIndSignal::hasFunction () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint64 BtApplDeviceConnectIndSignal::getFunction () const {
    return _function;
}

inline void BtApplDeviceConnectIndSignal::setFunction (uint64 function_) {
    set_has_function();
    this->_function = function_;
}

inline void BtApplDeviceConnectIndSignal::clearInstance() {
    if (hasInstance()) {
         clear_has_instance();
        _instance = 0u;
     }
}

inline bool BtApplDeviceConnectIndSignal::hasInstance () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 BtApplDeviceConnectIndSignal::getInstance () const {
    return _instance;
}

inline void BtApplDeviceConnectIndSignal::setInstance (uint8 instance_) {
    set_has_instance();
    this->_instance = instance_;
}

inline void BtApplDeviceConnectIndSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplDeviceConnectIndSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplDeviceConnectIndSignal::set_has_address () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplDeviceConnectIndSignal::clear_has_address () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BtApplDeviceConnectIndSignal::set_has_function () {
    _has_bits_[0] |= 1u << 2;
}

inline void BtApplDeviceConnectIndSignal::clear_has_function () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void BtApplDeviceConnectIndSignal::set_has_instance () {
    _has_bits_[0] |= 1u << 3;
}

inline void BtApplDeviceConnectIndSignal::clear_has_instance () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  BtApplDeviceDisconnectCfmSignal::BtApplDeviceDisconnectCfmSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplDeviceDisconnectCfmSignal::BtApplDeviceDisconnectCfmSignal (const BtApplDeviceDisconnectCfmSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplDeviceDisconnectCfmSignal::BtApplDeviceDisconnectCfmSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplDeviceDisconnectCfmSignal::~BtApplDeviceDisconnectCfmSignal() {
}

inline BtApplDeviceDisconnectCfmSignal& BtApplDeviceDisconnectCfmSignal::operator = (const BtApplDeviceDisconnectCfmSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool BtApplDeviceDisconnectCfmSignal::operator == (const BtApplDeviceDisconnectCfmSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool BtApplDeviceDisconnectCfmSignal::operator != (const BtApplDeviceDisconnectCfmSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplDeviceDisconnectCfmSignal::operator < (const BtApplDeviceDisconnectCfmSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplDeviceDisconnectCfmSignal::clone() {
    return new BtApplDeviceDisconnectCfmSignal(*this);
}

inline bool BtApplDeviceDisconnectCfmSignal::operator > (const BtApplDeviceDisconnectCfmSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplDeviceDisconnectCfmSignal::clear() {
    clearStatus();
}

inline void BtApplDeviceDisconnectCfmSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplDeviceDisconnectCfmSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplDeviceDisconnectCfmSignal::getStatus () const {
    return _status;
}

inline void BtApplDeviceDisconnectCfmSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplDeviceDisconnectCfmSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplDeviceDisconnectCfmSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplDeviceDisconnectIndSignal::BtApplDeviceDisconnectIndSignal ()  :
    _status (0u),
    _address (),
    _reason (0u),
    _function (0u),
    _instance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplDeviceDisconnectIndSignal::BtApplDeviceDisconnectIndSignal (const BtApplDeviceDisconnectIndSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u),
    _address (),
    _reason (0u),
    _function (0u),
    _instance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplDeviceDisconnectIndSignal::BtApplDeviceDisconnectIndSignal (uint8 status_, const ::std::vector< uint8 >& address_, uint8 reason_, uint64 function_, uint8 instance_)  :
    _status (status_),
    _address (address_),
    _reason (reason_),
    _function (function_),
    _instance (instance_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplDeviceDisconnectIndSignal::~BtApplDeviceDisconnectIndSignal() {
}

inline BtApplDeviceDisconnectIndSignal& BtApplDeviceDisconnectIndSignal::operator = (const BtApplDeviceDisconnectIndSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
        if (rhs.hasReason()) {
            setReason(rhs.getReason());
        } else {
            clearReason();
        }
        if (rhs.hasFunction()) {
            setFunction(rhs.getFunction());
        } else {
            clearFunction();
        }
        if (rhs.hasInstance()) {
            setInstance(rhs.getInstance());
        } else {
            clearInstance();
        }
    }
    return *this;
}

inline bool BtApplDeviceDisconnectIndSignal::operator == (const BtApplDeviceDisconnectIndSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()) &&
        ((!hasReason() && !rhs.hasReason()) || getReason() == rhs.getReason()) &&
        ((!hasFunction() && !rhs.hasFunction()) || getFunction() == rhs.getFunction()) &&
        ((!hasInstance() && !rhs.hasInstance()) || getInstance() == rhs.getInstance()));
}

inline bool BtApplDeviceDisconnectIndSignal::operator != (const BtApplDeviceDisconnectIndSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplDeviceDisconnectIndSignal::operator < (const BtApplDeviceDisconnectIndSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    if (hasReason() || rhs.hasReason()) {
        if (getReason() < rhs.getReason()) return true;
        if (getReason() > rhs.getReason()) return false;
    }
    if (hasFunction() || rhs.hasFunction()) {
        if (getFunction() < rhs.getFunction()) return true;
        if (getFunction() > rhs.getFunction()) return false;
    }
    if (hasInstance() || rhs.hasInstance()) {
        if (getInstance() < rhs.getInstance()) return true;
        if (getInstance() > rhs.getInstance()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplDeviceDisconnectIndSignal::clone() {
    return new BtApplDeviceDisconnectIndSignal(*this);
}

inline bool BtApplDeviceDisconnectIndSignal::operator > (const BtApplDeviceDisconnectIndSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplDeviceDisconnectIndSignal::clear() {
    clearStatus();
    clearAddress();
    clearReason();
    clearFunction();
    clearInstance();
}

inline void BtApplDeviceDisconnectIndSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplDeviceDisconnectIndSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplDeviceDisconnectIndSignal::getStatus () const {
    return _status;
}

inline void BtApplDeviceDisconnectIndSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplDeviceDisconnectIndSignal::clearAddress() {
    if (hasAddress()) {
         clear_has_address();
        _address.clear();
     }
}

inline bool BtApplDeviceDisconnectIndSignal::hasAddress () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& BtApplDeviceDisconnectIndSignal::getAddress () const {
    return _address;
}

inline ::std::vector< uint8 >& BtApplDeviceDisconnectIndSignal::getAddressMutable () {
    set_has_address();
    return _address;
}

inline void BtApplDeviceDisconnectIndSignal::setAddress (const ::std::vector< uint8 >& address_) {
    set_has_address();
    this->_address = address_;
}

inline void BtApplDeviceDisconnectIndSignal::clearReason() {
    if (hasReason()) {
         clear_has_reason();
        _reason = 0u;
     }
}

inline bool BtApplDeviceDisconnectIndSignal::hasReason () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 BtApplDeviceDisconnectIndSignal::getReason () const {
    return _reason;
}

inline void BtApplDeviceDisconnectIndSignal::setReason (uint8 reason_) {
    set_has_reason();
    this->_reason = reason_;
}

inline void BtApplDeviceDisconnectIndSignal::clearFunction() {
    if (hasFunction()) {
         clear_has_function();
        _function = 0u;
     }
}

inline bool BtApplDeviceDisconnectIndSignal::hasFunction () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint64 BtApplDeviceDisconnectIndSignal::getFunction () const {
    return _function;
}

inline void BtApplDeviceDisconnectIndSignal::setFunction (uint64 function_) {
    set_has_function();
    this->_function = function_;
}

inline void BtApplDeviceDisconnectIndSignal::clearInstance() {
    if (hasInstance()) {
         clear_has_instance();
        _instance = 0u;
     }
}

inline bool BtApplDeviceDisconnectIndSignal::hasInstance () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 BtApplDeviceDisconnectIndSignal::getInstance () const {
    return _instance;
}

inline void BtApplDeviceDisconnectIndSignal::setInstance (uint8 instance_) {
    set_has_instance();
    this->_instance = instance_;
}

inline void BtApplDeviceDisconnectIndSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplDeviceDisconnectIndSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplDeviceDisconnectIndSignal::set_has_address () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplDeviceDisconnectIndSignal::clear_has_address () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BtApplDeviceDisconnectIndSignal::set_has_reason () {
    _has_bits_[0] |= 1u << 2;
}

inline void BtApplDeviceDisconnectIndSignal::clear_has_reason () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void BtApplDeviceDisconnectIndSignal::set_has_function () {
    _has_bits_[0] |= 1u << 3;
}

inline void BtApplDeviceDisconnectIndSignal::clear_has_function () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void BtApplDeviceDisconnectIndSignal::set_has_instance () {
    _has_bits_[0] |= 1u << 4;
}

inline void BtApplDeviceDisconnectIndSignal::clear_has_instance () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  BtApplCancelConnectCfmSignal::BtApplCancelConnectCfmSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplCancelConnectCfmSignal::BtApplCancelConnectCfmSignal (const BtApplCancelConnectCfmSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplCancelConnectCfmSignal::BtApplCancelConnectCfmSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplCancelConnectCfmSignal::~BtApplCancelConnectCfmSignal() {
}

inline BtApplCancelConnectCfmSignal& BtApplCancelConnectCfmSignal::operator = (const BtApplCancelConnectCfmSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool BtApplCancelConnectCfmSignal::operator == (const BtApplCancelConnectCfmSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool BtApplCancelConnectCfmSignal::operator != (const BtApplCancelConnectCfmSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplCancelConnectCfmSignal::operator < (const BtApplCancelConnectCfmSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplCancelConnectCfmSignal::clone() {
    return new BtApplCancelConnectCfmSignal(*this);
}

inline bool BtApplCancelConnectCfmSignal::operator > (const BtApplCancelConnectCfmSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplCancelConnectCfmSignal::clear() {
    clearStatus();
}

inline void BtApplCancelConnectCfmSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplCancelConnectCfmSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplCancelConnectCfmSignal::getStatus () const {
    return _status;
}

inline void BtApplCancelConnectCfmSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplCancelConnectCfmSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplCancelConnectCfmSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplStatusNotificationIndSignal::BtApplStatusNotificationIndSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplStatusNotificationIndSignal::BtApplStatusNotificationIndSignal (const BtApplStatusNotificationIndSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplStatusNotificationIndSignal::BtApplStatusNotificationIndSignal (const ::std::vector< uint8 >& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplStatusNotificationIndSignal::~BtApplStatusNotificationIndSignal() {
}

inline BtApplStatusNotificationIndSignal& BtApplStatusNotificationIndSignal::operator = (const BtApplStatusNotificationIndSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool BtApplStatusNotificationIndSignal::operator == (const BtApplStatusNotificationIndSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool BtApplStatusNotificationIndSignal::operator != (const BtApplStatusNotificationIndSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplStatusNotificationIndSignal::operator < (const BtApplStatusNotificationIndSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplStatusNotificationIndSignal::clone() {
    return new BtApplStatusNotificationIndSignal(*this);
}

inline bool BtApplStatusNotificationIndSignal::operator > (const BtApplStatusNotificationIndSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplStatusNotificationIndSignal::clear() {
    clearData();
}

inline void BtApplStatusNotificationIndSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool BtApplStatusNotificationIndSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& BtApplStatusNotificationIndSignal::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& BtApplStatusNotificationIndSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void BtApplStatusNotificationIndSignal::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void BtApplStatusNotificationIndSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplStatusNotificationIndSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplGetHwVersionCfmSignal::BtApplGetHwVersionCfmSignal ()  :
    _status (0u),
    _bt_version (0u),
    _manufactory (0u),
    _hw_subversion (0u),
    _ext_info ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplGetHwVersionCfmSignal::BtApplGetHwVersionCfmSignal (const BtApplGetHwVersionCfmSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u),
    _bt_version (0u),
    _manufactory (0u),
    _hw_subversion (0u),
    _ext_info ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplGetHwVersionCfmSignal::BtApplGetHwVersionCfmSignal (uint8 status_, uint8 bt_version_, uint16 manufactory_, uint16 hw_subversion_, const ::std::vector< uint8 >& ext_info_)  :
    _status (status_),
    _bt_version (bt_version_),
    _manufactory (manufactory_),
    _hw_subversion (hw_subversion_),
    _ext_info (ext_info_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplGetHwVersionCfmSignal::~BtApplGetHwVersionCfmSignal() {
}

inline BtApplGetHwVersionCfmSignal& BtApplGetHwVersionCfmSignal::operator = (const BtApplGetHwVersionCfmSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasBt_version()) {
            setBt_version(rhs.getBt_version());
        } else {
            clearBt_version();
        }
        if (rhs.hasManufactory()) {
            setManufactory(rhs.getManufactory());
        } else {
            clearManufactory();
        }
        if (rhs.hasHw_subversion()) {
            setHw_subversion(rhs.getHw_subversion());
        } else {
            clearHw_subversion();
        }
        if (rhs.hasExt_info()) {
            setExt_info(rhs.getExt_info());
        } else {
            clearExt_info();
        }
    }
    return *this;
}

inline bool BtApplGetHwVersionCfmSignal::operator == (const BtApplGetHwVersionCfmSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasBt_version() && !rhs.hasBt_version()) || getBt_version() == rhs.getBt_version()) &&
        ((!hasManufactory() && !rhs.hasManufactory()) || getManufactory() == rhs.getManufactory()) &&
        ((!hasHw_subversion() && !rhs.hasHw_subversion()) || getHw_subversion() == rhs.getHw_subversion()) &&
        ((!hasExt_info() && !rhs.hasExt_info()) || getExt_info() == rhs.getExt_info()));
}

inline bool BtApplGetHwVersionCfmSignal::operator != (const BtApplGetHwVersionCfmSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplGetHwVersionCfmSignal::operator < (const BtApplGetHwVersionCfmSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasBt_version() || rhs.hasBt_version()) {
        if (getBt_version() < rhs.getBt_version()) return true;
        if (getBt_version() > rhs.getBt_version()) return false;
    }
    if (hasManufactory() || rhs.hasManufactory()) {
        if (getManufactory() < rhs.getManufactory()) return true;
        if (getManufactory() > rhs.getManufactory()) return false;
    }
    if (hasHw_subversion() || rhs.hasHw_subversion()) {
        if (getHw_subversion() < rhs.getHw_subversion()) return true;
        if (getHw_subversion() > rhs.getHw_subversion()) return false;
    }
    if (hasExt_info() || rhs.hasExt_info()) {
        if (getExt_info() < rhs.getExt_info()) return true;
        if (getExt_info() > rhs.getExt_info()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplGetHwVersionCfmSignal::clone() {
    return new BtApplGetHwVersionCfmSignal(*this);
}

inline bool BtApplGetHwVersionCfmSignal::operator > (const BtApplGetHwVersionCfmSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplGetHwVersionCfmSignal::clear() {
    clearStatus();
    clearBt_version();
    clearManufactory();
    clearHw_subversion();
    clearExt_info();
}

inline void BtApplGetHwVersionCfmSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplGetHwVersionCfmSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplGetHwVersionCfmSignal::getStatus () const {
    return _status;
}

inline void BtApplGetHwVersionCfmSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplGetHwVersionCfmSignal::clearBt_version() {
    if (hasBt_version()) {
         clear_has_bt_version();
        _bt_version = 0u;
     }
}

inline bool BtApplGetHwVersionCfmSignal::hasBt_version () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 BtApplGetHwVersionCfmSignal::getBt_version () const {
    return _bt_version;
}

inline void BtApplGetHwVersionCfmSignal::setBt_version (uint8 bt_version_) {
    set_has_bt_version();
    this->_bt_version = bt_version_;
}

inline void BtApplGetHwVersionCfmSignal::clearManufactory() {
    if (hasManufactory()) {
         clear_has_manufactory();
        _manufactory = 0u;
     }
}

inline bool BtApplGetHwVersionCfmSignal::hasManufactory () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 BtApplGetHwVersionCfmSignal::getManufactory () const {
    return _manufactory;
}

inline void BtApplGetHwVersionCfmSignal::setManufactory (uint16 manufactory_) {
    set_has_manufactory();
    this->_manufactory = manufactory_;
}

inline void BtApplGetHwVersionCfmSignal::clearHw_subversion() {
    if (hasHw_subversion()) {
         clear_has_hw_subversion();
        _hw_subversion = 0u;
     }
}

inline bool BtApplGetHwVersionCfmSignal::hasHw_subversion () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 BtApplGetHwVersionCfmSignal::getHw_subversion () const {
    return _hw_subversion;
}

inline void BtApplGetHwVersionCfmSignal::setHw_subversion (uint16 hw_subversion_) {
    set_has_hw_subversion();
    this->_hw_subversion = hw_subversion_;
}

inline void BtApplGetHwVersionCfmSignal::clearExt_info() {
    if (hasExt_info()) {
         clear_has_ext_info();
        _ext_info.clear();
     }
}

inline bool BtApplGetHwVersionCfmSignal::hasExt_info () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::vector< uint8 >& BtApplGetHwVersionCfmSignal::getExt_info () const {
    return _ext_info;
}

inline ::std::vector< uint8 >& BtApplGetHwVersionCfmSignal::getExt_infoMutable () {
    set_has_ext_info();
    return _ext_info;
}

inline void BtApplGetHwVersionCfmSignal::setExt_info (const ::std::vector< uint8 >& ext_info_) {
    set_has_ext_info();
    this->_ext_info = ext_info_;
}

inline void BtApplGetHwVersionCfmSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplGetHwVersionCfmSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplGetHwVersionCfmSignal::set_has_bt_version () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplGetHwVersionCfmSignal::clear_has_bt_version () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BtApplGetHwVersionCfmSignal::set_has_manufactory () {
    _has_bits_[0] |= 1u << 2;
}

inline void BtApplGetHwVersionCfmSignal::clear_has_manufactory () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void BtApplGetHwVersionCfmSignal::set_has_hw_subversion () {
    _has_bits_[0] |= 1u << 3;
}

inline void BtApplGetHwVersionCfmSignal::clear_has_hw_subversion () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void BtApplGetHwVersionCfmSignal::set_has_ext_info () {
    _has_bits_[0] |= 1u << 4;
}

inline void BtApplGetHwVersionCfmSignal::clear_has_ext_info () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  BtApplSetConfigurationCfmSignal::BtApplSetConfigurationCfmSignal ()  :
    _status (0u),
    _instance (0u),
    _config_id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplSetConfigurationCfmSignal::BtApplSetConfigurationCfmSignal (const BtApplSetConfigurationCfmSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u),
    _instance (0u),
    _config_id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplSetConfigurationCfmSignal::BtApplSetConfigurationCfmSignal (uint8 status_, uint8 instance_, uint16 config_id_)  :
    _status (status_),
    _instance (instance_),
    _config_id (config_id_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplSetConfigurationCfmSignal::~BtApplSetConfigurationCfmSignal() {
}

inline BtApplSetConfigurationCfmSignal& BtApplSetConfigurationCfmSignal::operator = (const BtApplSetConfigurationCfmSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasInstance()) {
            setInstance(rhs.getInstance());
        } else {
            clearInstance();
        }
        if (rhs.hasConfig_id()) {
            setConfig_id(rhs.getConfig_id());
        } else {
            clearConfig_id();
        }
    }
    return *this;
}

inline bool BtApplSetConfigurationCfmSignal::operator == (const BtApplSetConfigurationCfmSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasInstance() && !rhs.hasInstance()) || getInstance() == rhs.getInstance()) &&
        ((!hasConfig_id() && !rhs.hasConfig_id()) || getConfig_id() == rhs.getConfig_id()));
}

inline bool BtApplSetConfigurationCfmSignal::operator != (const BtApplSetConfigurationCfmSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplSetConfigurationCfmSignal::operator < (const BtApplSetConfigurationCfmSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasInstance() || rhs.hasInstance()) {
        if (getInstance() < rhs.getInstance()) return true;
        if (getInstance() > rhs.getInstance()) return false;
    }
    if (hasConfig_id() || rhs.hasConfig_id()) {
        if (getConfig_id() < rhs.getConfig_id()) return true;
        if (getConfig_id() > rhs.getConfig_id()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplSetConfigurationCfmSignal::clone() {
    return new BtApplSetConfigurationCfmSignal(*this);
}

inline bool BtApplSetConfigurationCfmSignal::operator > (const BtApplSetConfigurationCfmSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplSetConfigurationCfmSignal::clear() {
    clearStatus();
    clearInstance();
    clearConfig_id();
}

inline void BtApplSetConfigurationCfmSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplSetConfigurationCfmSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplSetConfigurationCfmSignal::getStatus () const {
    return _status;
}

inline void BtApplSetConfigurationCfmSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplSetConfigurationCfmSignal::clearInstance() {
    if (hasInstance()) {
         clear_has_instance();
        _instance = 0u;
     }
}

inline bool BtApplSetConfigurationCfmSignal::hasInstance () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 BtApplSetConfigurationCfmSignal::getInstance () const {
    return _instance;
}

inline void BtApplSetConfigurationCfmSignal::setInstance (uint8 instance_) {
    set_has_instance();
    this->_instance = instance_;
}

inline void BtApplSetConfigurationCfmSignal::clearConfig_id() {
    if (hasConfig_id()) {
         clear_has_config_id();
        _config_id = 0u;
     }
}

inline bool BtApplSetConfigurationCfmSignal::hasConfig_id () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 BtApplSetConfigurationCfmSignal::getConfig_id () const {
    return _config_id;
}

inline void BtApplSetConfigurationCfmSignal::setConfig_id (uint16 config_id_) {
    set_has_config_id();
    this->_config_id = config_id_;
}

inline void BtApplSetConfigurationCfmSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplSetConfigurationCfmSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplSetConfigurationCfmSignal::set_has_instance () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplSetConfigurationCfmSignal::clear_has_instance () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BtApplSetConfigurationCfmSignal::set_has_config_id () {
    _has_bits_[0] |= 1u << 2;
}

inline void BtApplSetConfigurationCfmSignal::clear_has_config_id () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  BtApplReadConfigurationCfmSignal::BtApplReadConfigurationCfmSignal ()  :
    _status (0u),
    _instance (0u),
    _config_id (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplReadConfigurationCfmSignal::BtApplReadConfigurationCfmSignal (const BtApplReadConfigurationCfmSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u),
    _instance (0u),
    _config_id (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplReadConfigurationCfmSignal::BtApplReadConfigurationCfmSignal (uint8 status_, uint8 instance_, uint16 config_id_, const ::std::vector< uint8 >& data_)  :
    _status (status_),
    _instance (instance_),
    _config_id (config_id_),
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplReadConfigurationCfmSignal::~BtApplReadConfigurationCfmSignal() {
}

inline BtApplReadConfigurationCfmSignal& BtApplReadConfigurationCfmSignal::operator = (const BtApplReadConfigurationCfmSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasInstance()) {
            setInstance(rhs.getInstance());
        } else {
            clearInstance();
        }
        if (rhs.hasConfig_id()) {
            setConfig_id(rhs.getConfig_id());
        } else {
            clearConfig_id();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool BtApplReadConfigurationCfmSignal::operator == (const BtApplReadConfigurationCfmSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasInstance() && !rhs.hasInstance()) || getInstance() == rhs.getInstance()) &&
        ((!hasConfig_id() && !rhs.hasConfig_id()) || getConfig_id() == rhs.getConfig_id()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool BtApplReadConfigurationCfmSignal::operator != (const BtApplReadConfigurationCfmSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplReadConfigurationCfmSignal::operator < (const BtApplReadConfigurationCfmSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasInstance() || rhs.hasInstance()) {
        if (getInstance() < rhs.getInstance()) return true;
        if (getInstance() > rhs.getInstance()) return false;
    }
    if (hasConfig_id() || rhs.hasConfig_id()) {
        if (getConfig_id() < rhs.getConfig_id()) return true;
        if (getConfig_id() > rhs.getConfig_id()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplReadConfigurationCfmSignal::clone() {
    return new BtApplReadConfigurationCfmSignal(*this);
}

inline bool BtApplReadConfigurationCfmSignal::operator > (const BtApplReadConfigurationCfmSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplReadConfigurationCfmSignal::clear() {
    clearStatus();
    clearInstance();
    clearConfig_id();
    clearData();
}

inline void BtApplReadConfigurationCfmSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplReadConfigurationCfmSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplReadConfigurationCfmSignal::getStatus () const {
    return _status;
}

inline void BtApplReadConfigurationCfmSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplReadConfigurationCfmSignal::clearInstance() {
    if (hasInstance()) {
         clear_has_instance();
        _instance = 0u;
     }
}

inline bool BtApplReadConfigurationCfmSignal::hasInstance () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 BtApplReadConfigurationCfmSignal::getInstance () const {
    return _instance;
}

inline void BtApplReadConfigurationCfmSignal::setInstance (uint8 instance_) {
    set_has_instance();
    this->_instance = instance_;
}

inline void BtApplReadConfigurationCfmSignal::clearConfig_id() {
    if (hasConfig_id()) {
         clear_has_config_id();
        _config_id = 0u;
     }
}

inline bool BtApplReadConfigurationCfmSignal::hasConfig_id () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 BtApplReadConfigurationCfmSignal::getConfig_id () const {
    return _config_id;
}

inline void BtApplReadConfigurationCfmSignal::setConfig_id (uint16 config_id_) {
    set_has_config_id();
    this->_config_id = config_id_;
}

inline void BtApplReadConfigurationCfmSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool BtApplReadConfigurationCfmSignal::hasData () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< uint8 >& BtApplReadConfigurationCfmSignal::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& BtApplReadConfigurationCfmSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void BtApplReadConfigurationCfmSignal::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void BtApplReadConfigurationCfmSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplReadConfigurationCfmSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplReadConfigurationCfmSignal::set_has_instance () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplReadConfigurationCfmSignal::clear_has_instance () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BtApplReadConfigurationCfmSignal::set_has_config_id () {
    _has_bits_[0] |= 1u << 2;
}

inline void BtApplReadConfigurationCfmSignal::clear_has_config_id () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void BtApplReadConfigurationCfmSignal::set_has_data () {
    _has_bits_[0] |= 1u << 3;
}

inline void BtApplReadConfigurationCfmSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  BtApplTestModeCfmSignal::BtApplTestModeCfmSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplTestModeCfmSignal::BtApplTestModeCfmSignal (const BtApplTestModeCfmSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplTestModeCfmSignal::BtApplTestModeCfmSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplTestModeCfmSignal::~BtApplTestModeCfmSignal() {
}

inline BtApplTestModeCfmSignal& BtApplTestModeCfmSignal::operator = (const BtApplTestModeCfmSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool BtApplTestModeCfmSignal::operator == (const BtApplTestModeCfmSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool BtApplTestModeCfmSignal::operator != (const BtApplTestModeCfmSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplTestModeCfmSignal::operator < (const BtApplTestModeCfmSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplTestModeCfmSignal::clone() {
    return new BtApplTestModeCfmSignal(*this);
}

inline bool BtApplTestModeCfmSignal::operator > (const BtApplTestModeCfmSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplTestModeCfmSignal::clear() {
    clearStatus();
}

inline void BtApplTestModeCfmSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplTestModeCfmSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplTestModeCfmSignal::getStatus () const {
    return _status;
}

inline void BtApplTestModeCfmSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplTestModeCfmSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplTestModeCfmSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplTestModeCompIndSignal::BtApplTestModeCompIndSignal ()  :
    _notiType (0u),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplTestModeCompIndSignal::BtApplTestModeCompIndSignal (const BtApplTestModeCompIndSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _notiType (0u),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplTestModeCompIndSignal::BtApplTestModeCompIndSignal (uint8 notiType_, uint8 status_)  :
    _notiType (notiType_),
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplTestModeCompIndSignal::~BtApplTestModeCompIndSignal() {
}

inline BtApplTestModeCompIndSignal& BtApplTestModeCompIndSignal::operator = (const BtApplTestModeCompIndSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNotiType()) {
            setNotiType(rhs.getNotiType());
        } else {
            clearNotiType();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool BtApplTestModeCompIndSignal::operator == (const BtApplTestModeCompIndSignal& rhs) const {
    return (((!hasNotiType() && !rhs.hasNotiType()) || getNotiType() == rhs.getNotiType()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool BtApplTestModeCompIndSignal::operator != (const BtApplTestModeCompIndSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplTestModeCompIndSignal::operator < (const BtApplTestModeCompIndSignal& rhs) const {
    if (hasNotiType() || rhs.hasNotiType()) {
        if (getNotiType() < rhs.getNotiType()) return true;
        if (getNotiType() > rhs.getNotiType()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplTestModeCompIndSignal::clone() {
    return new BtApplTestModeCompIndSignal(*this);
}

inline bool BtApplTestModeCompIndSignal::operator > (const BtApplTestModeCompIndSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplTestModeCompIndSignal::clear() {
    clearNotiType();
    clearStatus();
}

inline void BtApplTestModeCompIndSignal::clearNotiType() {
    if (hasNotiType()) {
         clear_has_notiType();
        _notiType = 0u;
     }
}

inline bool BtApplTestModeCompIndSignal::hasNotiType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplTestModeCompIndSignal::getNotiType () const {
    return _notiType;
}

inline void BtApplTestModeCompIndSignal::setNotiType (uint8 notiType_) {
    set_has_notiType();
    this->_notiType = notiType_;
}

inline void BtApplTestModeCompIndSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplTestModeCompIndSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 BtApplTestModeCompIndSignal::getStatus () const {
    return _status;
}

inline void BtApplTestModeCompIndSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplTestModeCompIndSignal::set_has_notiType () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplTestModeCompIndSignal::clear_has_notiType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplTestModeCompIndSignal::set_has_status () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplTestModeCompIndSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  BtApplTestModeLinkQualityCfmSignal::BtApplTestModeLinkQualityCfmSignal ()  :
    _status (0u),
    _rssi (0u),
    _linkquality (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplTestModeLinkQualityCfmSignal::BtApplTestModeLinkQualityCfmSignal (const BtApplTestModeLinkQualityCfmSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u),
    _rssi (0u),
    _linkquality (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplTestModeLinkQualityCfmSignal::BtApplTestModeLinkQualityCfmSignal (uint8 status_, uint8 rssi_, uint8 linkquality_)  :
    _status (status_),
    _rssi (rssi_),
    _linkquality (linkquality_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplTestModeLinkQualityCfmSignal::~BtApplTestModeLinkQualityCfmSignal() {
}

inline BtApplTestModeLinkQualityCfmSignal& BtApplTestModeLinkQualityCfmSignal::operator = (const BtApplTestModeLinkQualityCfmSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasRssi()) {
            setRssi(rhs.getRssi());
        } else {
            clearRssi();
        }
        if (rhs.hasLinkquality()) {
            setLinkquality(rhs.getLinkquality());
        } else {
            clearLinkquality();
        }
    }
    return *this;
}

inline bool BtApplTestModeLinkQualityCfmSignal::operator == (const BtApplTestModeLinkQualityCfmSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasRssi() && !rhs.hasRssi()) || getRssi() == rhs.getRssi()) &&
        ((!hasLinkquality() && !rhs.hasLinkquality()) || getLinkquality() == rhs.getLinkquality()));
}

inline bool BtApplTestModeLinkQualityCfmSignal::operator != (const BtApplTestModeLinkQualityCfmSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplTestModeLinkQualityCfmSignal::operator < (const BtApplTestModeLinkQualityCfmSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasRssi() || rhs.hasRssi()) {
        if (getRssi() < rhs.getRssi()) return true;
        if (getRssi() > rhs.getRssi()) return false;
    }
    if (hasLinkquality() || rhs.hasLinkquality()) {
        if (getLinkquality() < rhs.getLinkquality()) return true;
        if (getLinkquality() > rhs.getLinkquality()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplTestModeLinkQualityCfmSignal::clone() {
    return new BtApplTestModeLinkQualityCfmSignal(*this);
}

inline bool BtApplTestModeLinkQualityCfmSignal::operator > (const BtApplTestModeLinkQualityCfmSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplTestModeLinkQualityCfmSignal::clear() {
    clearStatus();
    clearRssi();
    clearLinkquality();
}

inline void BtApplTestModeLinkQualityCfmSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplTestModeLinkQualityCfmSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplTestModeLinkQualityCfmSignal::getStatus () const {
    return _status;
}

inline void BtApplTestModeLinkQualityCfmSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplTestModeLinkQualityCfmSignal::clearRssi() {
    if (hasRssi()) {
         clear_has_rssi();
        _rssi = 0u;
     }
}

inline bool BtApplTestModeLinkQualityCfmSignal::hasRssi () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 BtApplTestModeLinkQualityCfmSignal::getRssi () const {
    return _rssi;
}

inline void BtApplTestModeLinkQualityCfmSignal::setRssi (uint8 rssi_) {
    set_has_rssi();
    this->_rssi = rssi_;
}

inline void BtApplTestModeLinkQualityCfmSignal::clearLinkquality() {
    if (hasLinkquality()) {
         clear_has_linkquality();
        _linkquality = 0u;
     }
}

inline bool BtApplTestModeLinkQualityCfmSignal::hasLinkquality () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 BtApplTestModeLinkQualityCfmSignal::getLinkquality () const {
    return _linkquality;
}

inline void BtApplTestModeLinkQualityCfmSignal::setLinkquality (uint8 linkquality_) {
    set_has_linkquality();
    this->_linkquality = linkquality_;
}

inline void BtApplTestModeLinkQualityCfmSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplTestModeLinkQualityCfmSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BtApplTestModeLinkQualityCfmSignal::set_has_rssi () {
    _has_bits_[0] |= 1u << 1;
}

inline void BtApplTestModeLinkQualityCfmSignal::clear_has_rssi () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BtApplTestModeLinkQualityCfmSignal::set_has_linkquality () {
    _has_bits_[0] |= 1u << 2;
}

inline void BtApplTestModeLinkQualityCfmSignal::clear_has_linkquality () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace DM
} // namespace evo
} // namespace alps
} // namespace org

#endif // ORG_ALPS_EVO_DM_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
