/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/alps/evo/DID.h"
#include "org/alps/evo/DIDDBus.h"
#include "org/alps/evo/DIDJson.h"
#include "org/alps/evo/DIDStub.h"

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace alps {
namespace evo {
namespace DID {

DEFINE_CLASS_LOGGER("//org/alps/evolution/hli/org/alps/evo/DID", DIDStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 15, "BtApplDidSetReq", 0 },
};


class DIDStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    DIDStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    DIDStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    DIDStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.alps.evo.DID"),
          _logger(logger) {}

    virtual ~DIDStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void DIDStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'BtApplDidSetReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplDidSetReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDidSetReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplDidSetReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplDidSetReqRequest > payload = ::boost::static_pointer_cast<BtApplDidSetReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DIDStub*>(getStub())->onBtApplDidSetReqRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* DIDStubDelegate::introspect() const {
    return     "<interface name=\"org.alps.evo.DID\">\n"
            "      <method name=\"BtApplDidSetReq\">\n"
            "        <arg direction=\"in\" name=\"index\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"record\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <signal name=\"BtApplDidSetCfm\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void DIDStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<DIDStub*>(getStub()))->onGetAll (properties);
}

void DIDStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void DIDStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

DIDStub::DIDStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DIDStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DIDStub::DIDStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DIDStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DIDStub::~DIDStub() {
    delete _stubDelegate;
}

void DIDStub::sendBtApplDidSetCfmSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplDidSetCfmSignal* payload = new BtApplDidSetCfmSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplDidSetCfm", BtApplDidSetCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplDidSetCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplDidSetCfm");
    }
}

void  DIDStub::sendBtApplDidSetReqResponse (act_t act) {
    BtApplDidSetReqResponse* payload = new BtApplDidSetReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplDidSetReq", BtApplDidSetReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplDidSetReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DIDStub::sendBtApplDidSetReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplDidSetReqError* payload = new BtApplDidSetReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplDidSetReq", BtApplDidSetReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplDidSetReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void DIDStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace DID
} // namespace evo
} // namespace alps
} // namespace org
