/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_ALPS_EVO_DIDPROXY_H
#define ORG_ALPS_EVO_DIDPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/alps/evo/DID.h"
#include <dbus/dbus.h>
#include <vector>

namespace org {
namespace alps {
namespace evo {
namespace DID {

class DIDProxy;

class BtApplDidSetCfmCallbackIF {
public:
    virtual ~BtApplDidSetCfmCallbackIF() {}

    virtual void onBtApplDidSetCfmError(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetCfmError >& error) = 0;

    virtual void onBtApplDidSetCfmSignal(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetCfmSignal >& signal) = 0;
};

class BtApplDidSetReqCallbackIF {
public:
    virtual ~BtApplDidSetReqCallbackIF() {}

    virtual void onBtApplDidSetReqError(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetReqError >& error) = 0;

    virtual void onBtApplDidSetReqResponse(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetReqResponse >& response) = 0;
};


/**
 * DIDProxy is the client side representation of the D-Bus service
 * interface 'org.alps.evo.DID' (specified in file did_did.xml).
 *
 * If the meaning of "org.alps.evo.DID" isn't clear, then there should be a description here.
 */
class DIDProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of DIDProxy.
     */
    static ::boost::shared_ptr< DIDProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of DIDProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< DIDProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of DIDProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< DIDProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< DIDProxy > proxyNew(new DIDProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~DIDProxy ();


    // Signal 'BtApplDidSetCfm'

    /**
     * Notify on the signal 'BtApplDidSetCfm'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplDidSetCfm'</b>:
     *
     * If the meaning of "BtApplDidSetCfm" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDidSetCfmRegister(BtApplDidSetCfmCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplDidSetCfm'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplDidSetCfm'</b>:
     *
     * If the meaning of "BtApplDidSetCfm" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplDidSetCfmRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplDidSetCfmDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtApplDidSetCfm'.
     */
    void sendBtApplDidSetCfmDeregisterAll () const;



    // Method 'BtApplDidSetReq'

    /**
     * Call the method 'BtApplDidSetReq'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'BtApplDidSetReq'</b>:
     *
     * If the meaning of "BtApplDidSetReq" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param index If the meaning of "index" isn't clear, then there should be a description here.
     *
     * @param record If the meaning of "record" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplDidSetReqRequest(BtApplDidSetReqCallbackIF& cb, uint8 index, const ::std::vector< uint8 >& record) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    DIDProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class DIDProxyCallback;
};

} // namespace DID
} // namespace evo
} // namespace alps
} // namespace org

#endif // ORG_ALPS_EVO_DIDPROXY_H
