/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Technology.h"
#include "net/connman/TechnologyDBus.h"
#include "net/connman/TechnologyJson.h"
#include "net/connman/TechnologyStub.h"
#include <map>
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace net {
namespace connman {
namespace Technology {

DEFINE_CLASS_LOGGER("/net/Connman/net/connman/Technology", TechnologyStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 4, "Scan", 2 },
    { 11, "SetProperty", 1 },
    { 13, "GetProperties", 0 },
};


class TechnologyStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    TechnologyStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    TechnologyStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    TechnologyStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "net.connman.Technology"),
          _logger(logger) {}

    virtual ~TechnologyStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void TechnologyStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 3, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetProperties'

            LOG_DEBUG_STUB("process method '%s'", "GetProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPropertiesRequest > payload = ::boost::static_pointer_cast<GetPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<TechnologyStub*>(getStub())->onGetPropertiesRequest(payload);
            return;
        }
        case 1: {

            // method 'SetProperty'

            LOG_DEBUG_STUB("process method '%s'", "SetProperty");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetPropertyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetProperty", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetPropertyRequest > payload = ::boost::static_pointer_cast<SetPropertyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<TechnologyStub*>(getStub())->onSetPropertyRequest(payload);
            return;
        }
        case 2: {

            // method 'Scan'

            LOG_DEBUG_STUB("process method '%s'", "Scan");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ScanRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Scan", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ScanRequest > payload = ::boost::static_pointer_cast<ScanRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<TechnologyStub*>(getStub())->onScanRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* TechnologyStubDelegate::introspect() const {
    return     "<interface name=\"net.connman.Technology\">\n"
            "      <method name=\"GetProperties\">\n"
            "        <arg direction=\"out\" name=\"properties\" type=\"a{sv}\"/>\n"
            "      </method>\n"
            "      <method name=\"SetProperty\">\n"
            "        <arg direction=\"in\" name=\"name\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"value\" type=\"v\"/>\n"
            "      </method>\n"
            "      <method name=\"Scan\"/>\n"
            "      <signal name=\"PropertyChanged\">\n"
            "        <arg name=\"name\" type=\"s\"/>\n"
            "        <arg name=\"value\" type=\"v\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void TechnologyStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<TechnologyStub*>(getStub()))->onGetAll (properties);
}

void TechnologyStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void TechnologyStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

TechnologyStub::TechnologyStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new TechnologyStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

TechnologyStub::TechnologyStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new TechnologyStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

TechnologyStub::~TechnologyStub() {
    delete _stubDelegate;
}

void TechnologyStub::sendPropertyChangedSignal(const ::std::string& name, const ::asf::dbus::DBusVariant& value) {
    if (_stubDelegate->isConnected()) {
        PropertyChangedSignal* payload = new PropertyChangedSignal(name, value);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "PropertyChanged", PropertyChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "PropertyChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PropertyChanged");
    }
}

void  TechnologyStub::sendGetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act) {
    GetPropertiesResponse* payload = new GetPropertiesResponse(properties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetProperties", GetPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  TechnologyStub::sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPropertiesError* payload = new GetPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetProperties", GetPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  TechnologyStub::sendSetPropertyResponse (act_t act) {
    SetPropertyResponse* payload = new SetPropertyResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetProperty", SetPropertyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  TechnologyStub::sendSetPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetPropertyError* payload = new SetPropertyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetProperty", SetPropertyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  TechnologyStub::sendScanResponse (act_t act) {
    ScanResponse* payload = new ScanResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Scan", ScanResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Scan", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  TechnologyStub::sendScanError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ScanError* payload = new ScanError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Scan", ScanError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Scan", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void TechnologyStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Technology
} // namespace connman
} // namespace net
