/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "clock_main_fi.h"
#include "clock_main_fiJson.h"
#include "clock_main_fi_types.h"
#include "clock_main_fi_typesConst.h"
#include "clock_main_fi_typesJsonPrivate.h"
#include "diagnostics_main_fi_typesConst.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "TimeZoneStatus"

void serializeJson (const ::clock_main_fi::TimeZoneStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16Index()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Index" , 8);
        yajl_gen_integer(g, (long long)value.getU16Index());
    }
    if (!isSparse || value.hasSzDescription()) {
        yajl_gen_string(g, (const unsigned char*)  "szDescription" , 13);
        const char *s = value.getSzDescription().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::TimeZoneStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TimeZoneSet"

void serializeJson (const ::clock_main_fi::TimeZoneSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16Index()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Index" , 8);
        yajl_gen_integer(g, (long long)value.getU16Index());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::TimeZoneSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DaylightSavingTimeStatus"

void serializeJson (const ::clock_main_fi::DaylightSavingTimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBDST_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "bDST_Status" , 11);
        yajl_gen_bool(g, (bool)value.getBDST_Status());
    }
    if (!isSparse || value.hasBDST_AutoAdjust()) {
        yajl_gen_string(g, (const unsigned char*)  "bDST_AutoAdjust" , 15);
        yajl_gen_bool(g, (bool)value.getBDST_AutoAdjust());
    }
    if (!isSparse || value.hasEnDST_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "enDST_Status" , 12);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_DST_Setting_Name(value.getEnDST_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnDST_Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::DaylightSavingTimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DaylightSavingTimeSet"

void serializeJson (const ::clock_main_fi::DaylightSavingTimeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnDST_Setting()) {
        yajl_gen_string(g, (const unsigned char*)  "enDST_Setting" , 13);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_DST_Setting_Name(value.getEnDST_Setting());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnDST_Setting());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::DaylightSavingTimeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GPS_AutoSyncStatus"

void serializeJson (const ::clock_main_fi::GPS_AutoSyncStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBEnabled()) {
        yajl_gen_string(g, (const unsigned char*)  "bEnabled" , 8);
        yajl_gen_bool(g, (bool)value.getBEnabled());
    }
    if (!isSparse || value.hasBPositionBased()) {
        yajl_gen_string(g, (const unsigned char*)  "bPositionBased" , 14);
        yajl_gen_bool(g, (bool)value.getBPositionBased());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::GPS_AutoSyncStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GPS_AutoSyncSet"

void serializeJson (const ::clock_main_fi::GPS_AutoSyncSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBEnabled()) {
        yajl_gen_string(g, (const unsigned char*)  "bEnabled" , 8);
        yajl_gen_bool(g, (bool)value.getBEnabled());
    }
    if (!isSparse || value.hasBPositionBased()) {
        yajl_gen_string(g, (const unsigned char*)  "bPositionBased" , 14);
        yajl_gen_bool(g, (bool)value.getBPositionBased());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::GPS_AutoSyncSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SyncModeStatus"

void serializeJson (const ::clock_main_fi::SyncModeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnMode()) {
        yajl_gen_string(g, (const unsigned char*)  "enMode" , 6);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_SyncMode_Name(value.getEnMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::SyncModeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SyncModeSet"

void serializeJson (const ::clock_main_fi::SyncModeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnMode()) {
        yajl_gen_string(g, (const unsigned char*)  "enMode" , 6);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_SyncMode_Name(value.getEnMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::SyncModeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GPS_WeekEpochStatus"

void serializeJson (const ::clock_main_fi::GPS_WeekEpochStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGPSepoch()) {
        yajl_gen_string(g, (const unsigned char*)  "GPSepoch" , 8);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH_Name(value.getGPSepoch());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getGPSepoch());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::GPS_WeekEpochStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GPS_WeekEpochSet"

void serializeJson (const ::clock_main_fi::GPS_WeekEpochSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGPSepoch()) {
        yajl_gen_string(g, (const unsigned char*)  "GPSepoch" , 8);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH_Name(value.getGPSepoch());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getGPSepoch());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::GPS_WeekEpochSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LocalTimeOffsetStatus"

void serializeJson (const ::clock_main_fi::LocalTimeOffsetStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS64Offset_ScalarValue()) {
        yajl_gen_string(g, (const unsigned char*)  "s64Offset_ScalarValue" , 21);
        yajl_gen_integer(g, (long long)value.getS64Offset_ScalarValue());
    }
    if (!isSparse || value.hasBIsOffsetPostive()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsOffsetPostive" , 16);
        yajl_gen_bool(g, (bool)value.getBIsOffsetPostive());
    }
    if (!isSparse || value.hasS16Offset_Year()) {
        yajl_gen_string(g, (const unsigned char*)  "s16Offset_Year" , 14);
        yajl_gen_integer(g, (long long)value.getS16Offset_Year());
    }
    if (!isSparse || value.hasU8Offset_Month()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Offset_Month" , 14);
        yajl_gen_integer(g, (long long)value.getU8Offset_Month());
    }
    if (!isSparse || value.hasU8Offset_Day()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Offset_Day" , 12);
        yajl_gen_integer(g, (long long)value.getU8Offset_Day());
    }
    if (!isSparse || value.hasU8Offset_Hour()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Offset_Hour" , 13);
        yajl_gen_integer(g, (long long)value.getU8Offset_Hour());
    }
    if (!isSparse || value.hasU8Offset_Minute()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Offset_Minute" , 15);
        yajl_gen_integer(g, (long long)value.getU8Offset_Minute());
    }
    if (!isSparse || value.hasU8Offset_Second()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Offset_Second" , 15);
        yajl_gen_integer(g, (long long)value.getU8Offset_Second());
    }
    if (!isSparse || value.hasU32UTCTimeDate_ScalarValue()) {
        yajl_gen_string(g, (const unsigned char*)  "u32UTCTimeDate_ScalarValue" , 26);
        yajl_gen_integer(g, (long long)value.getU32UTCTimeDate_ScalarValue());
    }
    if (!isSparse || value.hasS16UTCTimeDate_Year()) {
        yajl_gen_string(g, (const unsigned char*)  "s16UTCTimeDate_Year" , 19);
        yajl_gen_integer(g, (long long)value.getS16UTCTimeDate_Year());
    }
    if (!isSparse || value.hasU8UTCTimeDate_Month()) {
        yajl_gen_string(g, (const unsigned char*)  "u8UTCTimeDate_Month" , 19);
        yajl_gen_integer(g, (long long)value.getU8UTCTimeDate_Month());
    }
    if (!isSparse || value.hasU8UTCTimeDate_Day()) {
        yajl_gen_string(g, (const unsigned char*)  "u8UTCTimeDate_Day" , 17);
        yajl_gen_integer(g, (long long)value.getU8UTCTimeDate_Day());
    }
    if (!isSparse || value.hasU8UTCTimeDate_Hour()) {
        yajl_gen_string(g, (const unsigned char*)  "u8UTCTimeDate_Hour" , 18);
        yajl_gen_integer(g, (long long)value.getU8UTCTimeDate_Hour());
    }
    if (!isSparse || value.hasU8UTCTimeDate_Minute()) {
        yajl_gen_string(g, (const unsigned char*)  "u8UTCTimeDate_Minute" , 20);
        yajl_gen_integer(g, (long long)value.getU8UTCTimeDate_Minute());
    }
    if (!isSparse || value.hasU8UTCTimeDate_Second()) {
        yajl_gen_string(g, (const unsigned char*)  "u8UTCTimeDate_Second" , 20);
        yajl_gen_integer(g, (long long)value.getU8UTCTimeDate_Second());
    }
    if (!isSparse || value.hasU8UTCTimeDate_Weekday()) {
        yajl_gen_string(g, (const unsigned char*)  "u8UTCTimeDate_Weekday" , 21);
        yajl_gen_integer(g, (long long)value.getU8UTCTimeDate_Weekday());
    }
    if (!isSparse || value.hasEnGpsRtcTimeState()) {
        yajl_gen_string(g, (const unsigned char*)  "enGpsRtcTimeState" , 17);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_GPSRTCTIMESTATE_Name(value.getEnGpsRtcTimeState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnGpsRtcTimeState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::LocalTimeOffsetStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LocalTimeDateStatus"

void serializeJson (const ::clock_main_fi::LocalTimeDateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16Year()) {
        yajl_gen_string(g, (const unsigned char*)  "s16Year" , 7);
        yajl_gen_integer(g, (long long)value.getS16Year());
    }
    if (!isSparse || value.hasU8Month()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Month" , 7);
        yajl_gen_integer(g, (long long)value.getU8Month());
    }
    if (!isSparse || value.hasU8Day()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Day" , 5);
        yajl_gen_integer(g, (long long)value.getU8Day());
    }
    if (!isSparse || value.hasU8Hours()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hours" , 7);
        yajl_gen_integer(g, (long long)value.getU8Hours());
    }
    if (!isSparse || value.hasU8Minutes()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Minutes" , 9);
        yajl_gen_integer(g, (long long)value.getU8Minutes());
    }
    if (!isSparse || value.hasU8Seconds()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Seconds" , 9);
        yajl_gen_integer(g, (long long)value.getU8Seconds());
    }
    if (!isSparse || value.hasU8Weekday()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Weekday" , 9);
        yajl_gen_integer(g, (long long)value.getU8Weekday());
    }
    if (!isSparse || value.hasU8TimeDateStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TimeDateStatus" , 16);
        yajl_gen_integer(g, (long long)value.getU8TimeDateStatus());
    }
    if (!isSparse || value.hasU32TimeDateValue()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TimeDateValue" , 16);
        yajl_gen_integer(g, (long long)value.getU32TimeDateValue());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::LocalTimeDateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LocalTimeDateSet"

void serializeJson (const ::clock_main_fi::LocalTimeDateSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16Year()) {
        yajl_gen_string(g, (const unsigned char*)  "s16Year" , 7);
        yajl_gen_integer(g, (long long)value.getS16Year());
    }
    if (!isSparse || value.hasU8Month()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Month" , 7);
        yajl_gen_integer(g, (long long)value.getU8Month());
    }
    if (!isSparse || value.hasU8Day()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Day" , 5);
        yajl_gen_integer(g, (long long)value.getU8Day());
    }
    if (!isSparse || value.hasU8Hours()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hours" , 7);
        yajl_gen_integer(g, (long long)value.getU8Hours());
    }
    if (!isSparse || value.hasU8Minutes()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Minutes" , 9);
        yajl_gen_integer(g, (long long)value.getU8Minutes());
    }
    if (!isSparse || value.hasU8Seconds()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Seconds" , 9);
        yajl_gen_integer(g, (long long)value.getU8Seconds());
    }
    if (!isSparse || value.hasU8Weekday()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Weekday" , 9);
        yajl_gen_integer(g, (long long)value.getU8Weekday());
    }
    if (!isSparse || value.hasU8ChangeMask()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ChangeMask" , 12);
        yajl_gen_integer(g, (long long)value.getU8ChangeMask());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::LocalTimeDateSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LocalTimeDateUpReg"

void serializeJson (const ::clock_main_fi::LocalTimeDateUpReg& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8UpdatePeriod()) {
        yajl_gen_string(g, (const unsigned char*)  "u8UpdatePeriod" , 14);
        yajl_gen_integer(g, (long long)value.getU8UpdatePeriod());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::LocalTimeDateUpReg& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LocalTimeDateRelUpReg"

void serializeJson (const ::clock_main_fi::LocalTimeDateRelUpReg& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8UpdatePeriod()) {
        yajl_gen_string(g, (const unsigned char*)  "u8UpdatePeriod" , 14);
        yajl_gen_integer(g, (long long)value.getU8UpdatePeriod());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::LocalTimeDateRelUpReg& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TimeFormatStatus"

void serializeJson (const ::clock_main_fi::TimeFormatStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnTimeFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "enTimeFormat" , 12);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_TimeFormat_Name(value.getEnTimeFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnTimeFormat());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::TimeFormatStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TimeFormatSet"

void serializeJson (const ::clock_main_fi::TimeFormatSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnTimeFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "enTimeFormat" , 12);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_TimeFormat_Name(value.getEnTimeFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnTimeFormat());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::TimeFormatSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DateFormatStatus"

void serializeJson (const ::clock_main_fi::DateFormatStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnDateFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "enDateFormat" , 12);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_DateFormat_Name(value.getEnDateFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnDateFormat());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::DateFormatStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DateFormatSet"

void serializeJson (const ::clock_main_fi::DateFormatSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnDateFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "enDateFormat" , 12);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_DateFormat_Name(value.getEnDateFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnDateFormat());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::DateFormatSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClockSourceStatusStatus"

void serializeJson (const ::clock_main_fi::ClockSourceStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnSourcesValid()) {
        yajl_gen_string(g, (const unsigned char*)  "enSourcesValid" , 14);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_ClockSourceStatus_Name(value.getEnSourcesValid());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnSourcesValid());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::ClockSourceStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FormatSourceStatusStatus"

void serializeJson (const ::clock_main_fi::FormatSourceStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnFormatSourceStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "enFormatSourceStatus" , 20);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_FormatSourceStatus_Name(value.getEnFormatSourceStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnFormatSourceStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::FormatSourceStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LocalTimeDate_MinuteUpdateStatus"

void serializeJson (const ::clock_main_fi::LocalTimeDate_MinuteUpdateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16Year()) {
        yajl_gen_string(g, (const unsigned char*)  "s16Year" , 7);
        yajl_gen_integer(g, (long long)value.getS16Year());
    }
    if (!isSparse || value.hasU8Month()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Month" , 7);
        yajl_gen_integer(g, (long long)value.getU8Month());
    }
    if (!isSparse || value.hasU8Day()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Day" , 5);
        yajl_gen_integer(g, (long long)value.getU8Day());
    }
    if (!isSparse || value.hasU8Hours()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hours" , 7);
        yajl_gen_integer(g, (long long)value.getU8Hours());
    }
    if (!isSparse || value.hasU8Minutes()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Minutes" , 9);
        yajl_gen_integer(g, (long long)value.getU8Minutes());
    }
    if (!isSparse || value.hasU8Seconds()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Seconds" , 9);
        yajl_gen_integer(g, (long long)value.getU8Seconds());
    }
    if (!isSparse || value.hasU8Weekday()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Weekday" , 9);
        yajl_gen_integer(g, (long long)value.getU8Weekday());
    }
    if (!isSparse || value.hasU8TimeDateStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TimeDateStatus" , 16);
        yajl_gen_integer(g, (long long)value.getU8TimeDateStatus());
    }
    if (!isSparse || value.hasU32TimeDateValue()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TimeDateValue" , 16);
        yajl_gen_integer(g, (long long)value.getU32TimeDateValue());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::LocalTimeDate_MinuteUpdateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LocalTimeDate_MinuteUpdateSet"

void serializeJson (const ::clock_main_fi::LocalTimeDate_MinuteUpdateSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16Year()) {
        yajl_gen_string(g, (const unsigned char*)  "s16Year" , 7);
        yajl_gen_integer(g, (long long)value.getS16Year());
    }
    if (!isSparse || value.hasU8Month()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Month" , 7);
        yajl_gen_integer(g, (long long)value.getU8Month());
    }
    if (!isSparse || value.hasU8Day()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Day" , 5);
        yajl_gen_integer(g, (long long)value.getU8Day());
    }
    if (!isSparse || value.hasU8Hours()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hours" , 7);
        yajl_gen_integer(g, (long long)value.getU8Hours());
    }
    if (!isSparse || value.hasU8Minutes()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Minutes" , 9);
        yajl_gen_integer(g, (long long)value.getU8Minutes());
    }
    if (!isSparse || value.hasU8Seconds()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Seconds" , 9);
        yajl_gen_integer(g, (long long)value.getU8Seconds());
    }
    if (!isSparse || value.hasU8Weekday()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Weekday" , 9);
        yajl_gen_integer(g, (long long)value.getU8Weekday());
    }
    if (!isSparse || value.hasU8ChangeMask()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ChangeMask" , 12);
        yajl_gen_integer(g, (long long)value.getU8ChangeMask());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::LocalTimeDate_MinuteUpdateSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Region_TimeZoneStatus"

void serializeJson (const ::clock_main_fi::Region_TimeZoneStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnTIMEZONE_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "enTIMEZONE_Status" , 17);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting_Name(value.getEnTIMEZONE_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnTIMEZONE_Status());
    }
    if (!isSparse || value.hasSzDescription()) {
        yajl_gen_string(g, (const unsigned char*)  "szDescription" , 13);
        const char *s = value.getSzDescription().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::Region_TimeZoneStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Region_TimeZoneSet"

void serializeJson (const ::clock_main_fi::Region_TimeZoneSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnTIMEZONE_Settings()) {
        yajl_gen_string(g, (const unsigned char*)  "enTIMEZONE_Settings" , 19);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting_Name(value.getEnTIMEZONE_Settings());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnTIMEZONE_Settings());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::Region_TimeZoneSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Auto_TimeZoneOffsetStatus"

void serializeJson (const ::clock_main_fi::Auto_TimeZoneOffsetStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS8Offset_Hour()) {
        yajl_gen_string(g, (const unsigned char*)  "s8Offset_Hour" , 13);
        yajl_gen_integer(g, (long long)value.getS8Offset_Hour());
    }
    if (!isSparse || value.hasS8Offset_Minute()) {
        yajl_gen_string(g, (const unsigned char*)  "s8Offset_Minute" , 15);
        yajl_gen_integer(g, (long long)value.getS8Offset_Minute());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::Auto_TimeZoneOffsetStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Auto_TimeZoneOffsetSet"

void serializeJson (const ::clock_main_fi::Auto_TimeZoneOffsetSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS8Offset_Hour()) {
        yajl_gen_string(g, (const unsigned char*)  "s8Offset_Hour" , 13);
        yajl_gen_integer(g, (long long)value.getS8Offset_Hour());
    }
    if (!isSparse || value.hasS8Offset_Minute()) {
        yajl_gen_string(g, (const unsigned char*)  "s8Offset_Minute" , 15);
        yajl_gen_integer(g, (long long)value.getS8Offset_Minute());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::Auto_TimeZoneOffsetSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NewDateFormatStatus"

void serializeJson (const ::clock_main_fi::NewDateFormatStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnDateFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "enDateFormat" , 12);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_NewDateFormat_Name(value.getEnDateFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnDateFormat());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::NewDateFormatStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NewDateFormatSet"

void serializeJson (const ::clock_main_fi::NewDateFormatSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnDateFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "enDateFormat" , 12);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_NewDateFormat_Name(value.getEnDateFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnDateFormat());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::NewDateFormatSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConnectionStatus"

void serializeJson (const ::clock_main_fi::ConnectionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSWCUnitConnectionStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SWCUnitConnectionStatus" , 23);
        serializeJson(value.getSWCUnitConnectionStatus(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::ConnectionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TimeZone_DSTAvailabilityStatus"

void serializeJson (const ::clock_main_fi::TimeZone_DSTAvailabilityStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBTimeZone_DSTAvailabilityForRegion()) {
        yajl_gen_string(g, (const unsigned char*)  "bTimeZone_DSTAvailabilityForRegion" , 34);
        yajl_gen_bool(g, (bool)value.getBTimeZone_DSTAvailabilityForRegion());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::TimeZone_DSTAvailabilityStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HardwareVersionStatus"

void serializeJson (const ::clock_main_fi::HardwareVersionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasArHardwareVersionList()) {
        yajl_gen_string(g, (const unsigned char*)  "arHardwareVersionList" , 21);
        yajl_gen_array_open(g);
        const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& o1 = value.getArHardwareVersionList();
        {
            ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::HardwareVersionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SoftwareVersionStatus"

void serializeJson (const ::clock_main_fi::SoftwareVersionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasArSoftwareVersionList()) {
        yajl_gen_string(g, (const unsigned char*)  "arSoftwareVersionList" , 21);
        yajl_gen_array_open(g);
        const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& o3 = value.getArSoftwareVersionList();
        {
            ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::SoftwareVersionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DebugMode_TimeDateStatus"

void serializeJson (const ::clock_main_fi::DebugMode_TimeDateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16Year()) {
        yajl_gen_string(g, (const unsigned char*)  "s16Year" , 7);
        yajl_gen_integer(g, (long long)value.getS16Year());
    }
    if (!isSparse || value.hasU8Month()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Month" , 7);
        yajl_gen_integer(g, (long long)value.getU8Month());
    }
    if (!isSparse || value.hasU8Day()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Day" , 5);
        yajl_gen_integer(g, (long long)value.getU8Day());
    }
    if (!isSparse || value.hasU8Hours()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hours" , 7);
        yajl_gen_integer(g, (long long)value.getU8Hours());
    }
    if (!isSparse || value.hasU8Minutes()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Minutes" , 9);
        yajl_gen_integer(g, (long long)value.getU8Minutes());
    }
    if (!isSparse || value.hasU8Seconds()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Seconds" , 9);
        yajl_gen_integer(g, (long long)value.getU8Seconds());
    }
    if (!isSparse || value.hasU8Weekday()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Weekday" , 9);
        yajl_gen_integer(g, (long long)value.getU8Weekday());
    }
    if (!isSparse || value.hasBdebugMode()) {
        yajl_gen_string(g, (const unsigned char*)  "bdebugMode" , 10);
        yajl_gen_bool(g, (bool)value.getBdebugMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::DebugMode_TimeDateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DebugMode_TimeDateSet"

void serializeJson (const ::clock_main_fi::DebugMode_TimeDateSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16Year()) {
        yajl_gen_string(g, (const unsigned char*)  "s16Year" , 7);
        yajl_gen_integer(g, (long long)value.getS16Year());
    }
    if (!isSparse || value.hasU8Month()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Month" , 7);
        yajl_gen_integer(g, (long long)value.getU8Month());
    }
    if (!isSparse || value.hasU8Day()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Day" , 5);
        yajl_gen_integer(g, (long long)value.getU8Day());
    }
    if (!isSparse || value.hasU8Hours()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hours" , 7);
        yajl_gen_integer(g, (long long)value.getU8Hours());
    }
    if (!isSparse || value.hasU8Minutes()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Minutes" , 9);
        yajl_gen_integer(g, (long long)value.getU8Minutes());
    }
    if (!isSparse || value.hasU8Seconds()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Seconds" , 9);
        yajl_gen_integer(g, (long long)value.getU8Seconds());
    }
    if (!isSparse || value.hasU8Weekday()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Weekday" , 9);
        yajl_gen_integer(g, (long long)value.getU8Weekday());
    }
    if (!isSparse || value.hasBdebugMode()) {
        yajl_gen_string(g, (const unsigned char*)  "bdebugMode" , 10);
        yajl_gen_bool(g, (bool)value.getBdebugMode());
    }
    if (!isSparse || value.hasU8ChangeMask()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ChangeMask" , 12);
        yajl_gen_integer(g, (long long)value.getU8ChangeMask());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::DebugMode_TimeDateSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UTC_TimeDateUpdateStatus"

void serializeJson (const ::clock_main_fi::UTC_TimeDateUpdateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16Year()) {
        yajl_gen_string(g, (const unsigned char*)  "s16Year" , 7);
        yajl_gen_integer(g, (long long)value.getS16Year());
    }
    if (!isSparse || value.hasU8Month()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Month" , 7);
        yajl_gen_integer(g, (long long)value.getU8Month());
    }
    if (!isSparse || value.hasU8Day()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Day" , 5);
        yajl_gen_integer(g, (long long)value.getU8Day());
    }
    if (!isSparse || value.hasU8Hours()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hours" , 7);
        yajl_gen_integer(g, (long long)value.getU8Hours());
    }
    if (!isSparse || value.hasU8Minutes()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Minutes" , 9);
        yajl_gen_integer(g, (long long)value.getU8Minutes());
    }
    if (!isSparse || value.hasU8Seconds()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Seconds" , 9);
        yajl_gen_integer(g, (long long)value.getU8Seconds());
    }
    if (!isSparse || value.hasU8Weekday()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Weekday" , 9);
        yajl_gen_integer(g, (long long)value.getU8Weekday());
    }
    if (!isSparse || value.hasBTimeValidity()) {
        yajl_gen_string(g, (const unsigned char*)  "bTimeValidity" , 13);
        yajl_gen_bool(g, (bool)value.getBTimeValidity());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::UTC_TimeDateUpdateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HUD_ActivationStatus"

void serializeJson (const ::clock_main_fi::HUD_ActivationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBHUD_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "bHUD_Status" , 11);
        yajl_gen_bool(g, (bool)value.getBHUD_Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::HUD_ActivationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HUD_ActivationSet"

void serializeJson (const ::clock_main_fi::HUD_ActivationSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnHUD_Setting()) {
        yajl_gen_string(g, (const unsigned char*)  "enHUD_Setting" , 13);
        const char* s = ::clock_main_fi_types::VDCLK_TEN_HUD_ActivationSettings_Name(value.getEnHUD_Setting());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnHUD_Setting());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::HUD_ActivationSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HUD_PostitionStatus"

void serializeJson (const ::clock_main_fi::HUD_PostitionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Up_Position()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Up_Position" , 13);
        yajl_gen_integer(g, (long long)value.getU8Up_Position());
    }
    if (!isSparse || value.hasU8Down_Position()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Down_Position" , 15);
        yajl_gen_integer(g, (long long)value.getU8Down_Position());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::HUD_PostitionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HUD_PostitionSet"

void serializeJson (const ::clock_main_fi::HUD_PostitionSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Up_Position()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Up_Position" , 13);
        yajl_gen_integer(g, (long long)value.getU8Up_Position());
    }
    if (!isSparse || value.hasU8Down_Position()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Down_Position" , 15);
        yajl_gen_integer(g, (long long)value.getU8Down_Position());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::HUD_PostitionSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetAvailableTimeZonesResult"

void serializeJson (const ::clock_main_fi::GetAvailableTimeZonesResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAszDescriptions()) {
        yajl_gen_string(g, (const unsigned char*)  "aszDescriptions" , 15);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o5 = value.getAszDescriptions();
        {
            ::std::vector< ::std::string >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                const char *s = (*o4).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasU16Indexes()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Indexes" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< uint16 >& o7 = value.getU16Indexes();
        {
            ::std::vector< uint16 >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                yajl_gen_integer(g, (long long)(*o6));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::GetAvailableTimeZonesResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetTimeDateFromValueStart"

void serializeJson (const ::clock_main_fi::GetTimeDateFromValueStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32TimeDateValue()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TimeDateValue" , 16);
        yajl_gen_integer(g, (long long)value.getU32TimeDateValue());
    }
    if (!isSparse || value.hasU8SourceDomain()) {
        yajl_gen_string(g, (const unsigned char*)  "u8SourceDomain" , 14);
        yajl_gen_integer(g, (long long)value.getU8SourceDomain());
    }
    if (!isSparse || value.hasU8TargetDomain()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TargetDomain" , 14);
        yajl_gen_integer(g, (long long)value.getU8TargetDomain());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::GetTimeDateFromValueStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetTimeDateFromValueResult"

void serializeJson (const ::clock_main_fi::GetTimeDateFromValueResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16Year()) {
        yajl_gen_string(g, (const unsigned char*)  "s16Year" , 7);
        yajl_gen_integer(g, (long long)value.getS16Year());
    }
    if (!isSparse || value.hasU8Month()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Month" , 7);
        yajl_gen_integer(g, (long long)value.getU8Month());
    }
    if (!isSparse || value.hasU8Day()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Day" , 5);
        yajl_gen_integer(g, (long long)value.getU8Day());
    }
    if (!isSparse || value.hasU8Hours()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hours" , 7);
        yajl_gen_integer(g, (long long)value.getU8Hours());
    }
    if (!isSparse || value.hasU8Minutes()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Minutes" , 9);
        yajl_gen_integer(g, (long long)value.getU8Minutes());
    }
    if (!isSparse || value.hasU8Seconds()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Seconds" , 9);
        yajl_gen_integer(g, (long long)value.getU8Seconds());
    }
    if (!isSparse || value.hasU8Weekday()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Weekday" , 9);
        yajl_gen_integer(g, (long long)value.getU8Weekday());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::GetTimeDateFromValueResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetDaysPerMonthStart"

void serializeJson (const ::clock_main_fi::GetDaysPerMonthStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16Year()) {
        yajl_gen_string(g, (const unsigned char*)  "s16Year" , 7);
        yajl_gen_integer(g, (long long)value.getS16Year());
    }
    if (!isSparse || value.hasU8Month()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Month" , 7);
        yajl_gen_integer(g, (long long)value.getU8Month());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::GetDaysPerMonthStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetDaysPerMonthResult"

void serializeJson (const ::clock_main_fi::GetDaysPerMonthResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8NumberOfDays()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NumberOfDays" , 14);
        yajl_gen_integer(g, (long long)value.getU8NumberOfDays());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::GetDaysPerMonthResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FID_S_DIAG_CONFIGURATIONStart"

void serializeJson (const ::clock_main_fi::FID_S_DIAG_CONFIGURATIONStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDefSetStateGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateGroup" , 16);
        const char* s = ::diagnostics_main_fi_types::T_e8_DefSetGroups_Name(value.getDefSetStateGroup());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDefSetStateGroup());
    }
    if (!isSparse || value.hasDefSetStateMode()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateMode" , 15);
        const char* s = ::diagnostics_main_fi_types::T_e8_DefSetMode_Name(value.getDefSetStateMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDefSetStateMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::FID_S_DIAG_CONFIGURATIONStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FID_S_DIAG_CONFIGURATIONResult"

void serializeJson (const ::clock_main_fi::FID_S_DIAG_CONFIGURATIONResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDefSetStateGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateGroup" , 16);
        const char* s = ::diagnostics_main_fi_types::T_e8_DefSetGroups_Name(value.getDefSetStateGroup());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDefSetStateGroup());
    }
    if (!isSparse || value.hasDefSetStateMode()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateMode" , 15);
        const char* s = ::diagnostics_main_fi_types::T_e8_DefSetMode_Name(value.getDefSetStateMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDefSetStateMode());
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "Status" , 6);
        yajl_gen_bool(g, (bool)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::clock_main_fi::FID_S_DIAG_CONFIGURATIONResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::TimeZoneStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::TimeZoneSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::DaylightSavingTimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::DaylightSavingTimeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::GPS_AutoSyncStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::GPS_AutoSyncSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::SyncModeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::SyncModeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::GPS_WeekEpochStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::GPS_WeekEpochSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::LocalTimeOffsetStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::LocalTimeDateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::LocalTimeDateSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::LocalTimeDateUpReg& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::LocalTimeDateRelUpReg& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::TimeFormatStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::TimeFormatSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::DateFormatStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::DateFormatSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::ClockSourceStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::FormatSourceStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::LocalTimeDate_MinuteUpdateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::LocalTimeDate_MinuteUpdateSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::Region_TimeZoneStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::Region_TimeZoneSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::Auto_TimeZoneOffsetStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::Auto_TimeZoneOffsetSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::NewDateFormatStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::NewDateFormatSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::ConnectionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::TimeZone_DSTAvailabilityStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::HardwareVersionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::SoftwareVersionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::DebugMode_TimeDateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::DebugMode_TimeDateSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::UTC_TimeDateUpdateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::HUD_ActivationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::HUD_ActivationSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::HUD_PostitionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::HUD_PostitionSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::GetAvailableTimeZonesResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::GetTimeDateFromValueStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::GetTimeDateFromValueResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::GetDaysPerMonthStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::GetDaysPerMonthResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::FID_S_DIAG_CONFIGURATIONStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi
using namespace ::asf::stream::json;

namespace clock_main_fi {

std::ostream& operator<<(std::ostream& o, const ::clock_main_fi::FID_S_DIAG_CONFIGURATIONResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace clock_main_fi

