#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef CLOCK_MAIN_FI_H
#define CLOCK_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "clock_main_fi_types.h"
#include "clock_main_fi_typesConst.h"
#include "diagnostics_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'clock_main_fi'
 *
 * Fullname: VD Clock Service, Application Functional Interface
 *
 * Version: $Revision:   1.8  $
 *
 * Author: Selvakumar
 *
 * Date: $Date:  21.04.2015  $
 *
 * Department:
 *
 * Title: clock_main_fi
 *
 * <b>Description of 'clock_main_fi':</b>
 *
 * Virtual device to provide date and time information
 */

namespace clock_main_fi {

static const int SERVICE_ID = 54;

static const int FID_TimeZone = 33808;

static const int FID_DaylightSavingTime = 33824;

static const int FID_GPS_AutoSync = 33840;

static const int FID_SyncMode = 33856;

static const int FID_GPS_WeekEpoch = 33872;

static const int FID_LocalTimeOffset = 33904;

static const int FID_LocalTimeDate = 33280;

static const int FID_TimeFormat = 33296;

static const int FID_DateFormat = 33312;

static const int FID_ClockSourceStatus = 33328;

static const int FID_FormatSourceStatus = 33344;

static const int FID_LocalTimeDate_MinuteUpdate = 33360;

static const int FID_Region_TimeZone = 33376;

static const int FID_Auto_TimeZoneOffset = 33392;

static const int FID_NewDateFormat = 33408;

static const int FID_Connection = 33393;

static const int FID_TimeZone_DSTAvailability = 33394;

static const int FID_HardwareVersion = 33395;

static const int FID_SoftwareVersion = 33396;

static const int FID_DebugMode_TimeDate = 33397;

static const int FID_UTC_TimeDateUpdate = 33398;

static const int FID_HUD_Activation = 33911;

static const int FID_HUD_Postition = 33912;

static const int FID_GetAvailableTimeZones = 33816;

static const int FID_GetTimeDateFromValue = 33313;

static const int FID_GetDaysPerMonth = 33314;

static const int FID_FID_S_DIAG_CONFIGURATION = 32769;

static const int FID_ResetHistory = 32770;

static const int FID_VersionInfo = 32771;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 5;

static const int VERSION_PATCH = 0;

// forward declarations
class TimeZoneStatus;

class TimeZoneSet;

class DaylightSavingTimeStatus;

class DaylightSavingTimeSet;

class GPS_AutoSyncStatus;

class GPS_AutoSyncSet;

class SyncModeStatus;

class SyncModeSet;

class GPS_WeekEpochStatus;

class GPS_WeekEpochSet;

class LocalTimeOffsetStatus;

class LocalTimeDateStatus;

class LocalTimeDateSet;

class LocalTimeDateUpReg;

class LocalTimeDateRelUpReg;

class TimeFormatStatus;

class TimeFormatSet;

class DateFormatStatus;

class DateFormatSet;

class ClockSourceStatusStatus;

class FormatSourceStatusStatus;

class LocalTimeDate_MinuteUpdateStatus;

class LocalTimeDate_MinuteUpdateSet;

class Region_TimeZoneStatus;

class Region_TimeZoneSet;

class Auto_TimeZoneOffsetStatus;

class Auto_TimeZoneOffsetSet;

class NewDateFormatStatus;

class NewDateFormatSet;

class ConnectionStatus;

class TimeZone_DSTAvailabilityStatus;

class HardwareVersionStatus;

class SoftwareVersionStatus;

class DebugMode_TimeDateStatus;

class DebugMode_TimeDateSet;

class UTC_TimeDateUpdateStatus;

class HUD_ActivationStatus;

class HUD_ActivationSet;

class HUD_PostitionStatus;

class HUD_PostitionSet;

class GetAvailableTimeZonesResult;

class GetTimeDateFromValueStart;

class GetTimeDateFromValueResult;

class GetDaysPerMonthStart;

class GetDaysPerMonthResult;

class FID_S_DIAG_CONFIGURATIONStart;

class FID_S_DIAG_CONFIGURATIONResult;

// type definitions
/**
 * The get message of the property "TimeZone"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TimeZoneGet;

/**
 * The upreg message of the property "TimeZone"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TimeZoneUpReg;

/**
 * The relUpReg message of the property "TimeZone"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TimeZoneRelUpReg;

/**
 * The error message of 'TimeZone'
 */
typedef ::asf::cca::CcaTypes::DefaultError TimeZoneError;

/**
 * The get message of the property "DaylightSavingTime"
 * <p>Property, indicating (or modifying), whether daylight saving time</p>
 * <p>(summer time) is On or Off</p>
 * Query current DST status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DaylightSavingTimeGet;

/**
 * The upreg message of the property "DaylightSavingTime"
 * <p>Property, indicating (or modifying), whether daylight saving time</p>
 * <p>(summer time) is On or Off</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DaylightSavingTimeUpReg;

/**
 * The relUpReg message of the property "DaylightSavingTime"
 * <p>Property, indicating (or modifying), whether daylight saving time</p>
 * <p>(summer time) is On or Off</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DaylightSavingTimeRelUpReg;

/**
 * The error message of 'DaylightSavingTime'
 */
typedef ::asf::cca::CcaTypes::DefaultError DaylightSavingTimeError;

/**
 * The get message of the property "GPS_AutoSync"
 * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
 * <p>if GPS-signal is available. This property controls, whether it is</p>
 * <p>transparently visible to the user ( = Enabled) or compensated by</p>
 * <p>internal offset shifting ( = Disabled).</p>
 * Query current status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GPS_AutoSyncGet;

/**
 * The upreg message of the property "GPS_AutoSync"
 * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
 * <p>if GPS-signal is available. This property controls, whether it is</p>
 * <p>transparently visible to the user ( = Enabled) or compensated by</p>
 * <p>internal offset shifting ( = Disabled).</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GPS_AutoSyncUpReg;

/**
 * The relUpReg message of the property "GPS_AutoSync"
 * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
 * <p>if GPS-signal is available. This property controls, whether it is</p>
 * <p>transparently visible to the user ( = Enabled) or compensated by</p>
 * <p>internal offset shifting ( = Disabled).</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GPS_AutoSyncRelUpReg;

/**
 * The error message of 'GPS_AutoSync'
 */
typedef ::asf::cca::CcaTypes::DefaultError GPS_AutoSyncError;

/**
 * The get message of the property "SyncMode"
 * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
 * <p>if GPS-signal is available. This property controls the source of local time:</p>
 * <p>GPS: UTC is transparently visible to the user</p>
 * <p>Manual: Compensated by internal offset shifting.</p>
 * <p>Auto: Set via received time on CAN.</p>
 * Query current status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SyncModeGet;

/**
 * The upreg message of the property "SyncMode"
 * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
 * <p>if GPS-signal is available. This property controls the source of local time:</p>
 * <p>GPS: UTC is transparently visible to the user</p>
 * <p>Manual: Compensated by internal offset shifting.</p>
 * <p>Auto: Set via received time on CAN.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SyncModeUpReg;

/**
 * The relUpReg message of the property "SyncMode"
 * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
 * <p>if GPS-signal is available. This property controls the source of local time:</p>
 * <p>GPS: UTC is transparently visible to the user</p>
 * <p>Manual: Compensated by internal offset shifting.</p>
 * <p>Auto: Set via received time on CAN.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SyncModeRelUpReg;

/**
 * The error message of 'SyncMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError SyncModeError;

/**
 * The get message of the property "GPS_WeekEpoch"
 * <p>GPS has a continuous runnning week counter which started 01.01.1980</p>
 * <p>This is a ten bit value (0...1023) which is increased each week by one.</p>
 * <p>To avoid the clock to be resetted to last date when an overflow</p>
 * <p>has been arrived this property indicates the current</p>
 * <p>epoch which has been reached until today.</p>
 * <p>This property can be set by Nissan garage via service menu.</p>
 * Query current status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GPS_WeekEpochGet;

/**
 * The upreg message of the property "GPS_WeekEpoch"
 * <p>GPS has a continuous runnning week counter which started 01.01.1980</p>
 * <p>This is a ten bit value (0...1023) which is increased each week by one.</p>
 * <p>To avoid the clock to be resetted to last date when an overflow</p>
 * <p>has been arrived this property indicates the current</p>
 * <p>epoch which has been reached until today.</p>
 * <p>This property can be set by Nissan garage via service menu.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GPS_WeekEpochUpReg;

/**
 * The relUpReg message of the property "GPS_WeekEpoch"
 * <p>GPS has a continuous runnning week counter which started 01.01.1980</p>
 * <p>This is a ten bit value (0...1023) which is increased each week by one.</p>
 * <p>To avoid the clock to be resetted to last date when an overflow</p>
 * <p>has been arrived this property indicates the current</p>
 * <p>epoch which has been reached until today.</p>
 * <p>This property can be set by Nissan garage via service menu.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GPS_WeekEpochRelUpReg;

/**
 * The error message of 'GPS_WeekEpoch'
 */
typedef ::asf::cca::CcaTypes::DefaultError GPS_WeekEpochError;

/**
 * The set message of the property "LocalTimeOffset"
 * Provides Offset value to calculate the localtime from the System(UTC) time.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LocalTimeOffsetSet;

/**
 * The get message of the property "LocalTimeOffset"
 * Provides Offset value to calculate the localtime from the System(UTC) time.
 * Get the initial offset value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LocalTimeOffsetGet;

/**
 * The upreg message of the property "LocalTimeOffset"
 * Provides Offset value to calculate the localtime from the System(UTC) time.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LocalTimeOffsetUpReg;

/**
 * The relUpReg message of the property "LocalTimeOffset"
 * Provides Offset value to calculate the localtime from the System(UTC) time.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LocalTimeOffsetRelUpReg;

/**
 * The error message of 'LocalTimeOffset'
 */
typedef ::asf::cca::CcaTypes::DefaultError LocalTimeOffsetError;

/**
 * The get message of the property "LocalTimeDate"
 * Current date and time. This is updated every second. Update period parameter is not handled. Use property LocalTimeDate_MinuteUpdate for getting update every minute.
 * The HMI application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LocalTimeDateGet;

/**
 * The error message of 'LocalTimeDate'
 */
typedef ::asf::cca::CcaTypes::DefaultError LocalTimeDateError;

/**
 * The get message of the property "TimeFormat"
 * European (24h) or American (12h a.m./p.m.) time format for use in HMI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TimeFormatGet;

/**
 * The upreg message of the property "TimeFormat"
 * European (24h) or American (12h a.m./p.m.) time format for use in HMI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TimeFormatUpReg;

/**
 * The relUpReg message of the property "TimeFormat"
 * European (24h) or American (12h a.m./p.m.) time format for use in HMI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TimeFormatRelUpReg;

/**
 * The error message of 'TimeFormat'
 */
typedef ::asf::cca::CcaTypes::DefaultError TimeFormatError;

/**
 * The get message of the property "DateFormat"
 * switch between date formats (for use by HMI):
 * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DateFormatGet;

/**
 * The upreg message of the property "DateFormat"
 * switch between date formats (for use by HMI):
 * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DateFormatUpReg;

/**
 * The relUpReg message of the property "DateFormat"
 * switch between date formats (for use by HMI):
 * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DateFormatRelUpReg;

/**
 * The error message of 'DateFormat'
 */
typedef ::asf::cca::CcaTypes::DefaultError DateFormatError;

/**
 * The get message of the property "ClockSourceStatus"
 * Status of different clock sources (system, master, GPS; read only).
 * Used by HMI to determine whether manual setting shall be enabled
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClockSourceStatusGet;

/**
 * The upreg message of the property "ClockSourceStatus"
 * Status of different clock sources (system, master, GPS; read only).
 * Used by HMI to determine whether manual setting shall be enabled
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClockSourceStatusUpReg;

/**
 * The relUpReg message of the property "ClockSourceStatus"
 * Status of different clock sources (system, master, GPS; read only).
 * Used by HMI to determine whether manual setting shall be enabled
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClockSourceStatusRelUpReg;

/**
 * The error message of 'ClockSourceStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError ClockSourceStatusError;

/**
 * The get message of the property "FormatSourceStatus"
 * Status of master signal dictating date and time format (read only).
 * Used by HMI to determine whether manual setting shall be enabled
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FormatSourceStatusGet;

/**
 * The upreg message of the property "FormatSourceStatus"
 * Status of master signal dictating date and time format (read only).
 * Used by HMI to determine whether manual setting shall be enabled
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FormatSourceStatusUpReg;

/**
 * The relUpReg message of the property "FormatSourceStatus"
 * Status of master signal dictating date and time format (read only).
 * Used by HMI to determine whether manual setting shall be enabled
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FormatSourceStatusRelUpReg;

/**
 * The error message of 'FormatSourceStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError FormatSourceStatusError;

/**
 * The get message of the property "LocalTimeDate_MinuteUpdate"
 * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
 * The client application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LocalTimeDate_MinuteUpdateGet;

/**
 * The upreg message of the property "LocalTimeDate_MinuteUpdate"
 * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
 * The client application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LocalTimeDate_MinuteUpdateUpReg;

/**
 * The relUpReg message of the property "LocalTimeDate_MinuteUpdate"
 * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
 * The client application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LocalTimeDate_MinuteUpdateRelUpReg;

/**
 * The error message of 'LocalTimeDate_MinuteUpdate'
 */
typedef ::asf::cca::CcaTypes::DefaultError LocalTimeDate_MinuteUpdateError;

/**
 * The get message of the property "Region_TimeZone"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Region_TimeZoneGet;

/**
 * The upreg message of the property "Region_TimeZone"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Region_TimeZoneUpReg;

/**
 * The relUpReg message of the property "Region_TimeZone"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Region_TimeZoneRelUpReg;

/**
 * The error message of 'Region_TimeZone'
 */
typedef ::asf::cca::CcaTypes::DefaultError Region_TimeZoneError;

/**
 * The get message of the property "Auto_TimeZoneOffset"
 * Get the initial offset value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Auto_TimeZoneOffsetGet;

/**
 * The upreg message of the property "Auto_TimeZoneOffset"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Auto_TimeZoneOffsetUpReg;

/**
 * The relUpReg message of the property "Auto_TimeZoneOffset"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Auto_TimeZoneOffsetRelUpReg;

/**
 * The error message of 'Auto_TimeZoneOffset'
 */
typedef ::asf::cca::CcaTypes::DefaultError Auto_TimeZoneOffsetError;

/**
 * The get message of the property "NewDateFormat"
 * switch between date formats (for use by HMI):
 * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NewDateFormatGet;

/**
 * The upreg message of the property "NewDateFormat"
 * switch between date formats (for use by HMI):
 * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NewDateFormatUpReg;

/**
 * The relUpReg message of the property "NewDateFormat"
 * switch between date formats (for use by HMI):
 * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NewDateFormatRelUpReg;

/**
 * The error message of 'NewDateFormat'
 */
typedef ::asf::cca::CcaTypes::DefaultError NewDateFormatError;

/**
 * The get message of the property "Connection"
 * This property gives information about the connection status to the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectionGet;

/**
 * The upreg message of the property "Connection"
 * This property gives information about the connection status to the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectionUpReg;

/**
 * The relUpReg message of the property "Connection"
 * This property gives information about the connection status to the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectionRelUpReg;

/**
 * The error message of 'Connection'
 */
typedef ::asf::cca::CcaTypes::DefaultError ConnectionError;

/**
 * The get message of the property "TimeZone_DSTAvailability"
 * This property gives information about the availability of timezones and DST for specific regions.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TimeZone_DSTAvailabilityGet;

/**
 * The upreg message of the property "TimeZone_DSTAvailability"
 * This property gives information about the availability of timezones and DST for specific regions.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TimeZone_DSTAvailabilityUpReg;

/**
 * The relUpReg message of the property "TimeZone_DSTAvailability"
 * This property gives information about the availability of timezones and DST for specific regions.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TimeZone_DSTAvailabilityRelUpReg;

/**
 * The error message of 'TimeZone_DSTAvailability'
 */
typedef ::asf::cca::CcaTypes::DefaultError TimeZone_DSTAvailabilityError;

/**
 * The get message of the property "HardwareVersion"
 * This property gives information about the hardware version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HardwareVersionGet;

/**
 * The upreg message of the property "HardwareVersion"
 * This property gives information about the hardware version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HardwareVersionUpReg;

/**
 * The relUpReg message of the property "HardwareVersion"
 * This property gives information about the hardware version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HardwareVersionRelUpReg;

/**
 * The error message of 'HardwareVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError HardwareVersionError;

/**
 * The get message of the property "SoftwareVersion"
 * This property gives information about the software version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SoftwareVersionGet;

/**
 * The upreg message of the property "SoftwareVersion"
 * This property gives information about the software version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SoftwareVersionUpReg;

/**
 * The relUpReg message of the property "SoftwareVersion"
 * This property gives information about the software version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SoftwareVersionRelUpReg;

/**
 * The error message of 'SoftwareVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError SoftwareVersionError;

/**
 * The get message of the property "DebugMode_TimeDate"
 * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
 * The client application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DebugMode_TimeDateGet;

/**
 * The upreg message of the property "DebugMode_TimeDate"
 * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
 * The client application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DebugMode_TimeDateUpReg;

/**
 * The relUpReg message of the property "DebugMode_TimeDate"
 * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
 * The client application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DebugMode_TimeDateRelUpReg;

/**
 * The error message of 'DebugMode_TimeDate'
 */
typedef ::asf::cca::CcaTypes::DefaultError DebugMode_TimeDateError;

/**
 * The get message of the property "UTC_TimeDateUpdate"
 * Current date and time. This is updated every second.
 * The client application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UTC_TimeDateUpdateGet;

/**
 * The upreg message of the property "UTC_TimeDateUpdate"
 * Current date and time. This is updated every second.
 * The client application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UTC_TimeDateUpdateUpReg;

/**
 * The relUpReg message of the property "UTC_TimeDateUpdate"
 * Current date and time. This is updated every second.
 * The client application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UTC_TimeDateUpdateRelUpReg;

/**
 * The error message of 'UTC_TimeDateUpdate'
 */
typedef ::asf::cca::CcaTypes::DefaultError UTC_TimeDateUpdateError;

/**
 * The get message of the property "HUD_Activation"
 * <p>Property, indicating (or modifying), HUD activation</p>
 * <p>(summer time) is On or Off</p>
 * Query current HUD activation status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HUD_ActivationGet;

/**
 * The upreg message of the property "HUD_Activation"
 * <p>Property, indicating (or modifying), HUD activation</p>
 * <p>(summer time) is On or Off</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HUD_ActivationUpReg;

/**
 * The relUpReg message of the property "HUD_Activation"
 * <p>Property, indicating (or modifying), HUD activation</p>
 * <p>(summer time) is On or Off</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HUD_ActivationRelUpReg;

/**
 * The error message of 'HUD_Activation'
 */
typedef ::asf::cca::CcaTypes::DefaultError HUD_ActivationError;

/**
 * The get message of the property "HUD_Postition"
 * Get the initial Postition value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HUD_PostitionGet;

/**
 * The upreg message of the property "HUD_Postition"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HUD_PostitionUpReg;

/**
 * The relUpReg message of the property "HUD_Postition"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HUD_PostitionRelUpReg;

/**
 * The error message of 'HUD_Postition'
 */
typedef ::asf::cca::CcaTypes::DefaultError HUD_PostitionError;

/**
 * The start message of the method "GetAvailableTimeZones"
 * Returns a list of available time zones for a given region
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetAvailableTimeZonesStart;

/**
 * The abort error message of the method "GetAvailableTimeZones"
 * Returns a list of available time zones for a given region
 */
typedef ::asf::cca::CcaTypes::DefaultError GetAvailableTimeZonesAbortError;

/**
 * The error message of 'GetAvailableTimeZones'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetAvailableTimeZonesError;

/**
 * The abort error message of the method "GetTimeDateFromValue"
 * utility to transform a scalar date/time value
 * (seconds elapsed since begin of century)
 * into date and time fields (year, month, day, hours, minutes, seconds and weekday of current date)
 * (to be used e. g. to calculate estimated time of arrival).
 */
typedef ::asf::cca::CcaTypes::DefaultError GetTimeDateFromValueAbortError;

/**
 * The error message of 'GetTimeDateFromValue'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetTimeDateFromValueError;

/**
 * The abort error message of the method "GetDaysPerMonth"
 * Calculates the number of days for a given month in a given year.
 * - takes into account leap years based on gregorian calendar.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetDaysPerMonthAbortError;

/**
 * The error message of 'GetDaysPerMonth'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetDaysPerMonthError;

/**
 * The abort error message of the method "FID_S_DIAG_CONFIGURATION"
 * With this method the diagnosis component tells the CLOCK component
 * that it has to set its internal settings to its default values or that
 * it has to react on an update of the coding value or calibration items
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_S_DIAG_CONFIGURATIONAbortError;

/**
 * The error message of 'FID_S_DIAG_CONFIGURATION'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_S_DIAG_CONFIGURATIONError;

/**
 * The start message of the method "ResetHistory"
 * This method is used to Clear History in Meter
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetHistoryStart;

/**
 * The result message of the method "ResetHistory"
 * This method is used to Clear History in Meter
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetHistoryResult;

/**
 * The abort error message of the method "ResetHistory"
 * This method is used to Clear History in Meter
 */
typedef ::asf::cca::CcaTypes::DefaultError ResetHistoryAbortError;

/**
 * The error message of 'ResetHistory'
 */
typedef ::asf::cca::CcaTypes::DefaultError ResetHistoryError;

/**
 * The start message of the method "VersionInfo"
 * Send INC message request to MCAN to get version
 * Send INC Message to V850
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VersionInfoStart;

/**
 * The result message of the method "VersionInfo"
 * Send INC message request to MCAN to get version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VersionInfoResult;

/**
 * The abort error message of the method "VersionInfo"
 * Send INC message request to MCAN to get version
 */
typedef ::asf::cca::CcaTypes::DefaultError VersionInfoAbortError;

/**
 * The error message of 'VersionInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError VersionInfoError;


/**
 * The status message of the property "TimeZone"
 */
class TimeZoneStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TimeZoneStatus ();

    /**
     * Copy constructor
     */
    inline  TimeZoneStatus (const TimeZoneStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TimeZoneStatus (uint16 u16Index_, const ::std::string& szDescription_);

    /**
     * Destructor
     */
    inline virtual  ~TimeZoneStatus();

    /**
     * Assignment operator
     */
    inline TimeZoneStatus& operator = (const TimeZoneStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TimeZoneStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TimeZoneStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TimeZoneStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TimeZoneStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16Index"

    static const int kU16Index = 0;

    /**
     * Clears the field "u16Index".
     *
     * The field will be set to its default value. The hasU16Index()
     * method will return false.
     */
    inline void clearU16Index();

    /**
     * Checks whether the field "u16Index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Index()). Otherwise it will return false.
     */
    inline bool hasU16Index () const;

    /**
     * Returns the value of the member "u16Index".
     *
     * Index of current time zone
     *
     * @return The value of the field "u16Index"
     */
    inline uint16 getU16Index () const;

    /**
     * Sets the value of the member "u16Index".
     *
     * Index of current time zone
     *
     * @param u16Index The value which will be set
     */
    inline void setU16Index (uint16 u16Index_);

    // API of field "szDescription"

    static const int kSzDescription = 1;

    /**
     * Clears the field "szDescription".
     *
     * The field will be set to its default value. The hasSzDescription()
     * method will return false.
     */
    inline void clearSzDescription();

    /**
     * Checks whether the field "szDescription" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDescription()). Otherwise it will return false.
     */
    inline bool hasSzDescription () const;

    /**
     * Returns the value of the member "szDescription".
     *
     * current time zone
     *
     * @return The value of the field "szDescription"
     */
    inline const ::std::string& getSzDescription () const;

    /**
     * Retrieves the value of the field "szDescription" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDescription".
     */
    inline ::std::string& getSzDescriptionMutable ();

    /**
     * Sets the value of the member "szDescription".
     *
     * current time zone
     *
     * @param szDescription The value which will be set
     */
    inline void setSzDescription (const ::std::string& szDescription_);

    /**
     * Sets the value of the member "szDescription".
     *
     * current time zone
     *
     * @param szDescription The value which will be set
     */
    inline void setSzDescription (const char* szDescription_);

    /**
     * Sets the value of the member "szDescription".
     *
     * current time zone
     *
     * @param szDescription The value which will be set
     */
    inline void setSzDescription (const char* value, size_t size);

    static const TimeZoneStatus &getDefaultInstance();

private:

    inline void set_has_u16Index ();

    inline void clear_has_u16Index ();

    inline void set_has_szDescription ();

    inline void clear_has_szDescription ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16Index;

    ::std::string _szDescription;

};

/**
 * The set message of the property "TimeZone"
 */
class TimeZoneSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TimeZoneSet ();

    /**
     * Copy constructor
     */
    inline  TimeZoneSet (const TimeZoneSet &rhs);

    /**
     * All fields constructor
     */
    inline  TimeZoneSet (uint16 u16Index_);

    /**
     * Destructor
     */
    inline virtual  ~TimeZoneSet();

    /**
     * Assignment operator
     */
    inline TimeZoneSet& operator = (const TimeZoneSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TimeZoneSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TimeZoneSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TimeZoneSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TimeZoneSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16Index"

    static const int kU16Index = 0;

    /**
     * Clears the field "u16Index".
     *
     * The field will be set to its default value. The hasU16Index()
     * method will return false.
     */
    inline void clearU16Index();

    /**
     * Checks whether the field "u16Index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Index()). Otherwise it will return false.
     */
    inline bool hasU16Index () const;

    /**
     * Returns the value of the member "u16Index".
     *
     * <p>use values obtained from method</p>
     * <p>GetAvailableTimeZones</p>
     *
     * @return The value of the field "u16Index"
     */
    inline uint16 getU16Index () const;

    /**
     * Sets the value of the member "u16Index".
     *
     * <p>use values obtained from method</p>
     * <p>GetAvailableTimeZones</p>
     *
     * @param u16Index The value which will be set
     */
    inline void setU16Index (uint16 u16Index_);

    static const TimeZoneSet &getDefaultInstance();

private:

    inline void set_has_u16Index ();

    inline void clear_has_u16Index ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16Index;

};

/**
 * The status message of the property "DaylightSavingTime"
 * <p>Property, indicating (or modifying), whether daylight saving time</p>
 * <p>(summer time) is On or Off</p>
 */
class DaylightSavingTimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DaylightSavingTimeStatus ();

    /**
     * Copy constructor
     */
    inline  DaylightSavingTimeStatus (const DaylightSavingTimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DaylightSavingTimeStatus (bool bDST_Status_, bool bDST_AutoAdjust_, ::clock_main_fi_types::VDCLK_TEN_DST_Setting enDST_Status_);

    /**
     * Destructor
     */
    inline virtual  ~DaylightSavingTimeStatus();

    /**
     * Assignment operator
     */
    inline DaylightSavingTimeStatus& operator = (const DaylightSavingTimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DaylightSavingTimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DaylightSavingTimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DaylightSavingTimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DaylightSavingTimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bDST_Status"

    static const int kBDST_Status = 0;

    /**
     * Clears the field "bDST_Status".
     *
     * The field will be set to its default value. The hasBDST_Status()
     * method will return false.
     */
    inline void clearBDST_Status();

    /**
     * Checks whether the field "bDST_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDST_Status()). Otherwise it will return false.
     */
    inline bool hasBDST_Status () const;

    /**
     * Returns the value of the member "bDST_Status".
     *
     * Flag, indicating whether DST is On or Off
     *
     * @return The value of the field "bDST_Status"
     */
    inline bool getBDST_Status () const;

    /**
     * Sets the value of the member "bDST_Status".
     *
     * Flag, indicating whether DST is On or Off
     *
     * @param bDST_Status The value which will be set
     */
    inline void setBDST_Status (bool bDST_Status_);

    // API of field "bDST_AutoAdjust"

    static const int kBDST_AutoAdjust = 1;

    /**
     * Clears the field "bDST_AutoAdjust".
     *
     * The field will be set to its default value. The hasBDST_AutoAdjust()
     * method will return false.
     */
    inline void clearBDST_AutoAdjust();

    /**
     * Checks whether the field "bDST_AutoAdjust" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDST_AutoAdjust()). Otherwise it will return false.
     */
    inline bool hasBDST_AutoAdjust () const;

    /**
     * Returns the value of the member "bDST_AutoAdjust".
     *
     * <p>- for future use -</p>
     * <p>(not supported by Nissan LCN;</p>
     * <p>returns always FALSE)</p>
     *
     * @return The value of the field "bDST_AutoAdjust"
     */
    inline bool getBDST_AutoAdjust () const;

    /**
     * Sets the value of the member "bDST_AutoAdjust".
     *
     * <p>- for future use -</p>
     * <p>(not supported by Nissan LCN;</p>
     * <p>returns always FALSE)</p>
     *
     * @param bDST_AutoAdjust The value which will be set
     */
    inline void setBDST_AutoAdjust (bool bDST_AutoAdjust_);

    // API of field "enDST_Status"

    static const int kEnDST_Status = 2;

    /**
     * Clears the field "enDST_Status".
     *
     * The field will be set to its default value. The hasEnDST_Status()
     * method will return false.
     */
    inline void clearEnDST_Status();

    /**
     * Checks whether the field "enDST_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDST_Status()). Otherwise it will return false.
     */
    inline bool hasEnDST_Status () const;

    /**
     * Returns the value of the member "enDST_Status".
     *
     * <p>Values indicating DST manual and auto status</p>
     * <p>Used for VWMIBE project</p>
     *
     * @return The value of the field "enDST_Status"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_DST_Setting getEnDST_Status () const;

    /**
     * Sets the value of the member "enDST_Status".
     *
     * <p>Values indicating DST manual and auto status</p>
     * <p>Used for VWMIBE project</p>
     *
     * @param enDST_Status The value which will be set
     */
    inline void setEnDST_Status (::clock_main_fi_types::VDCLK_TEN_DST_Setting enDST_Status_);

    static const DaylightSavingTimeStatus &getDefaultInstance();

private:

    inline void set_has_bDST_Status ();

    inline void clear_has_bDST_Status ();

    inline void set_has_bDST_AutoAdjust ();

    inline void clear_has_bDST_AutoAdjust ();

    inline void set_has_enDST_Status ();

    inline void clear_has_enDST_Status ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _bDST_Status;

    bool _bDST_AutoAdjust;

    ::clock_main_fi_types::VDCLK_TEN_DST_Setting _enDST_Status;

};

/**
 * The set message of the property "DaylightSavingTime"
 * <p>Property, indicating (or modifying), whether daylight saving time</p>
 * <p>(summer time) is On or Off</p>
 * Set daylight saving time (DST) on/off
 */
class DaylightSavingTimeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DaylightSavingTimeSet ();

    /**
     * Copy constructor
     */
    inline  DaylightSavingTimeSet (const DaylightSavingTimeSet &rhs);

    /**
     * All fields constructor
     */
    inline  DaylightSavingTimeSet (::clock_main_fi_types::VDCLK_TEN_DST_Setting enDST_Setting_);

    /**
     * Destructor
     */
    inline virtual  ~DaylightSavingTimeSet();

    /**
     * Assignment operator
     */
    inline DaylightSavingTimeSet& operator = (const DaylightSavingTimeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DaylightSavingTimeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DaylightSavingTimeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DaylightSavingTimeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DaylightSavingTimeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enDST_Setting"

    static const int kEnDST_Setting = 0;

    /**
     * Clears the field "enDST_Setting".
     *
     * The field will be set to its default value. The hasEnDST_Setting()
     * method will return false.
     */
    inline void clearEnDST_Setting();

    /**
     * Checks whether the field "enDST_Setting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDST_Setting()). Otherwise it will return false.
     */
    inline bool hasEnDST_Setting () const;

    /**
     * Returns the value of the member "enDST_Setting".
     *
     * <p></p>
     *
     * @return The value of the field "enDST_Setting"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_DST_Setting getEnDST_Setting () const;

    /**
     * Sets the value of the member "enDST_Setting".
     *
     * <p></p>
     *
     * @param enDST_Setting The value which will be set
     */
    inline void setEnDST_Setting (::clock_main_fi_types::VDCLK_TEN_DST_Setting enDST_Setting_);

    static const DaylightSavingTimeSet &getDefaultInstance();

private:

    inline void set_has_enDST_Setting ();

    inline void clear_has_enDST_Setting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_DST_Setting _enDST_Setting;

};

/**
 * The status message of the property "GPS_AutoSync"
 * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
 * <p>if GPS-signal is available. This property controls, whether it is</p>
 * <p>transparently visible to the user ( = Enabled) or compensated by</p>
 * <p>internal offset shifting ( = Disabled).</p>
 */
class GPS_AutoSyncStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GPS_AutoSyncStatus ();

    /**
     * Copy constructor
     */
    inline  GPS_AutoSyncStatus (const GPS_AutoSyncStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GPS_AutoSyncStatus (bool bEnabled_, bool bPositionBased_);

    /**
     * Destructor
     */
    inline virtual  ~GPS_AutoSyncStatus();

    /**
     * Assignment operator
     */
    inline GPS_AutoSyncStatus& operator = (const GPS_AutoSyncStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GPS_AutoSyncStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GPS_AutoSyncStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GPS_AutoSyncStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GPS_AutoSyncStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bEnabled"

    static const int kBEnabled = 0;

    /**
     * Clears the field "bEnabled".
     *
     * The field will be set to its default value. The hasBEnabled()
     * method will return false.
     */
    inline void clearBEnabled();

    /**
     * Checks whether the field "bEnabled" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEnabled()). Otherwise it will return false.
     */
    inline bool hasBEnabled () const;

    /**
     * Returns the value of the member "bEnabled".
     *
     * <p>TRUE  = enabled</p>
     * <p>FALSE = disabled (free run or controlled by IC)</p>
     *
     * @return The value of the field "bEnabled"
     */
    inline bool getBEnabled () const;

    /**
     * Sets the value of the member "bEnabled".
     *
     * <p>TRUE  = enabled</p>
     * <p>FALSE = disabled (free run or controlled by IC)</p>
     *
     * @param bEnabled The value which will be set
     */
    inline void setBEnabled (bool bEnabled_);

    // API of field "bPositionBased"

    static const int kBPositionBased = 1;

    /**
     * Clears the field "bPositionBased".
     *
     * The field will be set to its default value. The hasBPositionBased()
     * method will return false.
     */
    inline void clearBPositionBased();

    /**
     * Checks whether the field "bPositionBased" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPositionBased()). Otherwise it will return false.
     */
    inline bool hasBPositionBased () const;

    /**
     * Returns the value of the member "bPositionBased".
     *
     * <p>TRUE  = enable</p>
     * <p>FALSE = disable (no automatic GPS time zone setting)</p>
     * <p>This will not be set because manual time zone or</p>
     * <p>or manual time is active</p>
     *
     * @return The value of the field "bPositionBased"
     */
    inline bool getBPositionBased () const;

    /**
     * Sets the value of the member "bPositionBased".
     *
     * <p>TRUE  = enable</p>
     * <p>FALSE = disable (no automatic GPS time zone setting)</p>
     * <p>This will not be set because manual time zone or</p>
     * <p>or manual time is active</p>
     *
     * @param bPositionBased The value which will be set
     */
    inline void setBPositionBased (bool bPositionBased_);

    static const GPS_AutoSyncStatus &getDefaultInstance();

private:

    inline void set_has_bEnabled ();

    inline void clear_has_bEnabled ();

    inline void set_has_bPositionBased ();

    inline void clear_has_bPositionBased ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bEnabled;

    bool _bPositionBased;

};

/**
 * The set message of the property "GPS_AutoSync"
 * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
 * <p>if GPS-signal is available. This property controls, whether it is</p>
 * <p>transparently visible to the user ( = Enabled) or compensated by</p>
 * <p>internal offset shifting ( = Disabled).</p>
 * Enable/disable GPS_AutoSync
 */
class GPS_AutoSyncSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GPS_AutoSyncSet ();

    /**
     * Copy constructor
     */
    inline  GPS_AutoSyncSet (const GPS_AutoSyncSet &rhs);

    /**
     * All fields constructor
     */
    inline  GPS_AutoSyncSet (bool bEnabled_, bool bPositionBased_);

    /**
     * Destructor
     */
    inline virtual  ~GPS_AutoSyncSet();

    /**
     * Assignment operator
     */
    inline GPS_AutoSyncSet& operator = (const GPS_AutoSyncSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GPS_AutoSyncSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GPS_AutoSyncSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GPS_AutoSyncSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GPS_AutoSyncSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bEnabled"

    static const int kBEnabled = 0;

    /**
     * Clears the field "bEnabled".
     *
     * The field will be set to its default value. The hasBEnabled()
     * method will return false.
     */
    inline void clearBEnabled();

    /**
     * Checks whether the field "bEnabled" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEnabled()). Otherwise it will return false.
     */
    inline bool hasBEnabled () const;

    /**
     * Returns the value of the member "bEnabled".
     *
     * <p>TRUE  = enable</p>
     * <p>FALSE = disable (free run or controlled by IC)</p>
     *
     * @return The value of the field "bEnabled"
     */
    inline bool getBEnabled () const;

    /**
     * Sets the value of the member "bEnabled".
     *
     * <p>TRUE  = enable</p>
     * <p>FALSE = disable (free run or controlled by IC)</p>
     *
     * @param bEnabled The value which will be set
     */
    inline void setBEnabled (bool bEnabled_);

    // API of field "bPositionBased"

    static const int kBPositionBased = 1;

    /**
     * Clears the field "bPositionBased".
     *
     * The field will be set to its default value. The hasBPositionBased()
     * method will return false.
     */
    inline void clearBPositionBased();

    /**
     * Checks whether the field "bPositionBased" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPositionBased()). Otherwise it will return false.
     */
    inline bool hasBPositionBased () const;

    /**
     * Returns the value of the member "bPositionBased".
     *
     * <p>TRUE  = enable</p>
     * <p>FALSE = disable (no automatic GPS time zone setting)</p>
     * <p>This will not be set because manual time zone or</p>
     * <p>or manual time is active</p>
     *
     * @return The value of the field "bPositionBased"
     */
    inline bool getBPositionBased () const;

    /**
     * Sets the value of the member "bPositionBased".
     *
     * <p>TRUE  = enable</p>
     * <p>FALSE = disable (no automatic GPS time zone setting)</p>
     * <p>This will not be set because manual time zone or</p>
     * <p>or manual time is active</p>
     *
     * @param bPositionBased The value which will be set
     */
    inline void setBPositionBased (bool bPositionBased_);

    static const GPS_AutoSyncSet &getDefaultInstance();

private:

    inline void set_has_bEnabled ();

    inline void clear_has_bEnabled ();

    inline void set_has_bPositionBased ();

    inline void clear_has_bPositionBased ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bEnabled;

    bool _bPositionBased;

};

/**
 * The status message of the property "SyncMode"
 * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
 * <p>if GPS-signal is available. This property controls the source of local time:</p>
 * <p>GPS: UTC is transparently visible to the user</p>
 * <p>Manual: Compensated by internal offset shifting.</p>
 * <p>Auto: Set via received time on CAN.</p>
 * The Current the Sync-mode
 */
class SyncModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SyncModeStatus ();

    /**
     * Copy constructor
     */
    inline  SyncModeStatus (const SyncModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SyncModeStatus (::clock_main_fi_types::VDCLK_TEN_SyncMode enMode_);

    /**
     * Destructor
     */
    inline virtual  ~SyncModeStatus();

    /**
     * Assignment operator
     */
    inline SyncModeStatus& operator = (const SyncModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SyncModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SyncModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SyncModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SyncModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enMode"

    static const int kEnMode = 0;

    /**
     * Clears the field "enMode".
     *
     * The field will be set to its default value. The hasEnMode()
     * method will return false.
     */
    inline void clearEnMode();

    /**
     * Checks whether the field "enMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnMode()). Otherwise it will return false.
     */
    inline bool hasEnMode () const;

    /**
     * Returns the value of the member "enMode".
     *
     *
     *
     * @return The value of the field "enMode"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_SyncMode getEnMode () const;

    /**
     * Sets the value of the member "enMode".
     *
     *
     *
     * @param enMode The value which will be set
     */
    inline void setEnMode (::clock_main_fi_types::VDCLK_TEN_SyncMode enMode_);

    static const SyncModeStatus &getDefaultInstance();

private:

    inline void set_has_enMode ();

    inline void clear_has_enMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_SyncMode _enMode;

};

/**
 * The set message of the property "SyncMode"
 * <p>RNS-internal real-time clock is automatically synchronized to UTC,</p>
 * <p>if GPS-signal is available. This property controls the source of local time:</p>
 * <p>GPS: UTC is transparently visible to the user</p>
 * <p>Manual: Compensated by internal offset shifting.</p>
 * <p>Auto: Set via received time on CAN.</p>
 * Set the Sync-mode
 */
class SyncModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SyncModeSet ();

    /**
     * Copy constructor
     */
    inline  SyncModeSet (const SyncModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  SyncModeSet (::clock_main_fi_types::VDCLK_TEN_SyncMode enMode_);

    /**
     * Destructor
     */
    inline virtual  ~SyncModeSet();

    /**
     * Assignment operator
     */
    inline SyncModeSet& operator = (const SyncModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SyncModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SyncModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SyncModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SyncModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enMode"

    static const int kEnMode = 0;

    /**
     * Clears the field "enMode".
     *
     * The field will be set to its default value. The hasEnMode()
     * method will return false.
     */
    inline void clearEnMode();

    /**
     * Checks whether the field "enMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnMode()). Otherwise it will return false.
     */
    inline bool hasEnMode () const;

    /**
     * Returns the value of the member "enMode".
     *
     *
     *
     * @return The value of the field "enMode"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_SyncMode getEnMode () const;

    /**
     * Sets the value of the member "enMode".
     *
     *
     *
     * @param enMode The value which will be set
     */
    inline void setEnMode (::clock_main_fi_types::VDCLK_TEN_SyncMode enMode_);

    static const SyncModeSet &getDefaultInstance();

private:

    inline void set_has_enMode ();

    inline void clear_has_enMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_SyncMode _enMode;

};

/**
 * The status message of the property "GPS_WeekEpoch"
 * <p>GPS has a continuous runnning week counter which started 01.01.1980</p>
 * <p>This is a ten bit value (0...1023) which is increased each week by one.</p>
 * <p>To avoid the clock to be resetted to last date when an overflow</p>
 * <p>has been arrived this property indicates the current</p>
 * <p>epoch which has been reached until today.</p>
 * <p>This property can be set by Nissan garage via service menu.</p>
 */
class GPS_WeekEpochStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GPS_WeekEpochStatus ();

    /**
     * Copy constructor
     */
    inline  GPS_WeekEpochStatus (const GPS_WeekEpochStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GPS_WeekEpochStatus (::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH GPSepoch_);

    /**
     * Destructor
     */
    inline virtual  ~GPS_WeekEpochStatus();

    /**
     * Assignment operator
     */
    inline GPS_WeekEpochStatus& operator = (const GPS_WeekEpochStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GPS_WeekEpochStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GPS_WeekEpochStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GPS_WeekEpochStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GPS_WeekEpochStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GPSepoch"

    static const int kGPSepoch = 0;

    /**
     * Clears the field "GPSepoch".
     *
     * The field will be set to its default value. The hasGPSepoch()
     * method will return false.
     */
    inline void clearGPSepoch();

    /**
     * Checks whether the field "GPSepoch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGPSepoch()). Otherwise it will return false.
     */
    inline bool hasGPSepoch () const;

    /**
     * Returns the value of the member "GPSepoch".
     *
     * Current epoch of GPS week counter
     *
     * @return The value of the field "GPSepoch"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH getGPSepoch () const;

    /**
     * Sets the value of the member "GPSepoch".
     *
     * Current epoch of GPS week counter
     *
     * @param GPSepoch The value which will be set
     */
    inline void setGPSepoch (::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH GPSepoch_);

    static const GPS_WeekEpochStatus &getDefaultInstance();

private:

    inline void set_has_GPSepoch ();

    inline void clear_has_GPSepoch ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH _GPSepoch;

};

/**
 * The set message of the property "GPS_WeekEpoch"
 * <p>GPS has a continuous runnning week counter which started 01.01.1980</p>
 * <p>This is a ten bit value (0...1023) which is increased each week by one.</p>
 * <p>To avoid the clock to be resetted to last date when an overflow</p>
 * <p>has been arrived this property indicates the current</p>
 * <p>epoch which has been reached until today.</p>
 * <p>This property can be set by Nissan garage via service menu.</p>
 */
class GPS_WeekEpochSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GPS_WeekEpochSet ();

    /**
     * Copy constructor
     */
    inline  GPS_WeekEpochSet (const GPS_WeekEpochSet &rhs);

    /**
     * All fields constructor
     */
    inline  GPS_WeekEpochSet (::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH GPSepoch_);

    /**
     * Destructor
     */
    inline virtual  ~GPS_WeekEpochSet();

    /**
     * Assignment operator
     */
    inline GPS_WeekEpochSet& operator = (const GPS_WeekEpochSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GPS_WeekEpochSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GPS_WeekEpochSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GPS_WeekEpochSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GPS_WeekEpochSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GPSepoch"

    static const int kGPSepoch = 0;

    /**
     * Clears the field "GPSepoch".
     *
     * The field will be set to its default value. The hasGPSepoch()
     * method will return false.
     */
    inline void clearGPSepoch();

    /**
     * Checks whether the field "GPSepoch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGPSepoch()). Otherwise it will return false.
     */
    inline bool hasGPSepoch () const;

    /**
     * Returns the value of the member "GPSepoch".
     *
     * <p>set value of current GPS week cycle</p>
     *
     * @return The value of the field "GPSepoch"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH getGPSepoch () const;

    /**
     * Sets the value of the member "GPSepoch".
     *
     * <p>set value of current GPS week cycle</p>
     *
     * @param GPSepoch The value which will be set
     */
    inline void setGPSepoch (::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH GPSepoch_);

    static const GPS_WeekEpochSet &getDefaultInstance();

private:

    inline void set_has_GPSepoch ();

    inline void clear_has_GPSepoch ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH _GPSepoch;

};

/**
 * The status message of the property "LocalTimeOffset"
 * Provides Offset value to calculate the localtime from the System(UTC) time.
 */
class LocalTimeOffsetStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LocalTimeOffsetStatus ();

    /**
     * Copy constructor
     */
    inline  LocalTimeOffsetStatus (const LocalTimeOffsetStatus &rhs);

    /**
     * All fields constructor
     */
    inline  LocalTimeOffsetStatus (int64 s64Offset_ScalarValue_, bool bIsOffsetPostive_, int16 s16Offset_Year_, uint8 u8Offset_Month_, uint8 u8Offset_Day_, uint8 u8Offset_Hour_, uint8 u8Offset_Minute_, uint8 u8Offset_Second_, uint32 u32UTCTimeDate_ScalarValue_, int16 s16UTCTimeDate_Year_, uint8 u8UTCTimeDate_Month_, uint8 u8UTCTimeDate_Day_, uint8 u8UTCTimeDate_Hour_, uint8 u8UTCTimeDate_Minute_, uint8 u8UTCTimeDate_Second_, uint8 u8UTCTimeDate_Weekday_, ::clock_main_fi_types::VDCLK_TEN_GPSRTCTIMESTATE enGpsRtcTimeState_);

    /**
     * Destructor
     */
    inline virtual  ~LocalTimeOffsetStatus();

    /**
     * Assignment operator
     */
    inline LocalTimeOffsetStatus& operator = (const LocalTimeOffsetStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LocalTimeOffsetStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LocalTimeOffsetStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LocalTimeOffsetStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LocalTimeOffsetStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s64Offset_ScalarValue"

    static const int kS64Offset_ScalarValue = 0;

    /**
     * Clears the field "s64Offset_ScalarValue".
     *
     * The field will be set to its default value. The hasS64Offset_ScalarValue()
     * method will return false.
     */
    inline void clearS64Offset_ScalarValue();

    /**
     * Checks whether the field "s64Offset_ScalarValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS64Offset_ScalarValue()). Otherwise it will return false.
     */
    inline bool hasS64Offset_ScalarValue () const;

    /**
     * Returns the value of the member "s64Offset_ScalarValue".
     *
     * Offset value to calculate localtime from the UTC time.
     * In auto mode, offset is Timezone+DST.
     * In manual mode, offset is difference between UTC and manual(user set) time.
     * In Timezonemode, offset is userselected Tiemzone value + DST
     *
     * @return The value of the field "s64Offset_ScalarValue"
     */
    inline int64 getS64Offset_ScalarValue () const;

    /**
     * Sets the value of the member "s64Offset_ScalarValue".
     *
     * Offset value to calculate localtime from the UTC time.
     * In auto mode, offset is Timezone+DST.
     * In manual mode, offset is difference between UTC and manual(user set) time.
     * In Timezonemode, offset is userselected Tiemzone value + DST
     *
     * @param s64Offset_ScalarValue The value which will be set
     */
    inline void setS64Offset_ScalarValue (int64 s64Offset_ScalarValue_);

    // API of field "bIsOffsetPostive"

    static const int kBIsOffsetPostive = 1;

    /**
     * Clears the field "bIsOffsetPostive".
     *
     * The field will be set to its default value. The hasBIsOffsetPostive()
     * method will return false.
     */
    inline void clearBIsOffsetPostive();

    /**
     * Checks whether the field "bIsOffsetPostive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsOffsetPostive()). Otherwise it will return false.
     */
    inline bool hasBIsOffsetPostive () const;

    /**
     * Returns the value of the member "bIsOffsetPostive".
     *
     * Tells whether the offset is postive value or not.
     *
     * @return The value of the field "bIsOffsetPostive"
     */
    inline bool getBIsOffsetPostive () const;

    /**
     * Sets the value of the member "bIsOffsetPostive".
     *
     * Tells whether the offset is postive value or not.
     *
     * @param bIsOffsetPostive The value which will be set
     */
    inline void setBIsOffsetPostive (bool bIsOffsetPostive_);

    // API of field "s16Offset_Year"

    static const int kS16Offset_Year = 2;

    /**
     * Clears the field "s16Offset_Year".
     *
     * The field will be set to its default value. The hasS16Offset_Year()
     * method will return false.
     */
    inline void clearS16Offset_Year();

    /**
     * Checks whether the field "s16Offset_Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16Offset_Year()). Otherwise it will return false.
     */
    inline bool hasS16Offset_Year () const;

    /**
     * Returns the value of the member "s16Offset_Year".
     *
     * Provides the offsetseconds in number of years. [0-99]
     *
     * @return The value of the field "s16Offset_Year"
     */
    inline int16 getS16Offset_Year () const;

    /**
     * Sets the value of the member "s16Offset_Year".
     *
     * Provides the offsetseconds in number of years. [0-99]
     *
     * @param s16Offset_Year The value which will be set
     */
    inline void setS16Offset_Year (int16 s16Offset_Year_);

    // API of field "u8Offset_Month"

    static const int kU8Offset_Month = 3;

    /**
     * Clears the field "u8Offset_Month".
     *
     * The field will be set to its default value. The hasU8Offset_Month()
     * method will return false.
     */
    inline void clearU8Offset_Month();

    /**
     * Checks whether the field "u8Offset_Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Offset_Month()). Otherwise it will return false.
     */
    inline bool hasU8Offset_Month () const;

    /**
     * Returns the value of the member "u8Offset_Month".
     *
     * Provides the remaining offsetseconds(remaining offset= offset%(no of seconds per year)) in number of Months [0-12]
     *
     * @return The value of the field "u8Offset_Month"
     */
    inline uint8 getU8Offset_Month () const;

    /**
     * Sets the value of the member "u8Offset_Month".
     *
     * Provides the remaining offsetseconds(remaining offset= offset%(no of seconds per year)) in number of Months [0-12]
     *
     * @param u8Offset_Month The value which will be set
     */
    inline void setU8Offset_Month (uint8 u8Offset_Month_);

    // API of field "u8Offset_Day"

    static const int kU8Offset_Day = 4;

    /**
     * Clears the field "u8Offset_Day".
     *
     * The field will be set to its default value. The hasU8Offset_Day()
     * method will return false.
     */
    inline void clearU8Offset_Day();

    /**
     * Checks whether the field "u8Offset_Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Offset_Day()). Otherwise it will return false.
     */
    inline bool hasU8Offset_Day () const;

    /**
     * Returns the value of the member "u8Offset_Day".
     *
     * Provides remaining offsetseconds in days. [0-30]
     *
     * @return The value of the field "u8Offset_Day"
     */
    inline uint8 getU8Offset_Day () const;

    /**
     * Sets the value of the member "u8Offset_Day".
     *
     * Provides remaining offsetseconds in days. [0-30]
     *
     * @param u8Offset_Day The value which will be set
     */
    inline void setU8Offset_Day (uint8 u8Offset_Day_);

    // API of field "u8Offset_Hour"

    static const int kU8Offset_Hour = 5;

    /**
     * Clears the field "u8Offset_Hour".
     *
     * The field will be set to its default value. The hasU8Offset_Hour()
     * method will return false.
     */
    inline void clearU8Offset_Hour();

    /**
     * Checks whether the field "u8Offset_Hour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Offset_Hour()). Otherwise it will return false.
     */
    inline bool hasU8Offset_Hour () const;

    /**
     * Returns the value of the member "u8Offset_Hour".
     *
     * Providesremaining offsetseconds in Hours [0-24]
     *
     * @return The value of the field "u8Offset_Hour"
     */
    inline uint8 getU8Offset_Hour () const;

    /**
     * Sets the value of the member "u8Offset_Hour".
     *
     * Providesremaining offsetseconds in Hours [0-24]
     *
     * @param u8Offset_Hour The value which will be set
     */
    inline void setU8Offset_Hour (uint8 u8Offset_Hour_);

    // API of field "u8Offset_Minute"

    static const int kU8Offset_Minute = 6;

    /**
     * Clears the field "u8Offset_Minute".
     *
     * The field will be set to its default value. The hasU8Offset_Minute()
     * method will return false.
     */
    inline void clearU8Offset_Minute();

    /**
     * Checks whether the field "u8Offset_Minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Offset_Minute()). Otherwise it will return false.
     */
    inline bool hasU8Offset_Minute () const;

    /**
     * Returns the value of the member "u8Offset_Minute".
     *
     * Provides remaining offsetseconds in Minutes [ 0-60]
     *
     * @return The value of the field "u8Offset_Minute"
     */
    inline uint8 getU8Offset_Minute () const;

    /**
     * Sets the value of the member "u8Offset_Minute".
     *
     * Provides remaining offsetseconds in Minutes [ 0-60]
     *
     * @param u8Offset_Minute The value which will be set
     */
    inline void setU8Offset_Minute (uint8 u8Offset_Minute_);

    // API of field "u8Offset_Second"

    static const int kU8Offset_Second = 7;

    /**
     * Clears the field "u8Offset_Second".
     *
     * The field will be set to its default value. The hasU8Offset_Second()
     * method will return false.
     */
    inline void clearU8Offset_Second();

    /**
     * Checks whether the field "u8Offset_Second" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Offset_Second()). Otherwise it will return false.
     */
    inline bool hasU8Offset_Second () const;

    /**
     * Returns the value of the member "u8Offset_Second".
     *
     * Provides remaining offset in seconds
     *
     * @return The value of the field "u8Offset_Second"
     */
    inline uint8 getU8Offset_Second () const;

    /**
     * Sets the value of the member "u8Offset_Second".
     *
     * Provides remaining offset in seconds
     *
     * @param u8Offset_Second The value which will be set
     */
    inline void setU8Offset_Second (uint8 u8Offset_Second_);

    // API of field "u32UTCTimeDate_ScalarValue"

    static const int kU32UTCTimeDate_ScalarValue = 8;

    /**
     * Clears the field "u32UTCTimeDate_ScalarValue".
     *
     * The field will be set to its default value. The hasU32UTCTimeDate_ScalarValue()
     * method will return false.
     */
    inline void clearU32UTCTimeDate_ScalarValue();

    /**
     * Checks whether the field "u32UTCTimeDate_ScalarValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32UTCTimeDate_ScalarValue()). Otherwise it will return false.
     */
    inline bool hasU32UTCTimeDate_ScalarValue () const;

    /**
     * Returns the value of the member "u32UTCTimeDate_ScalarValue".
     *
     * scalar representation of time and date
     * - seconds elapsed since 2000-1-1, 0:00
     *
     * @return The value of the field "u32UTCTimeDate_ScalarValue"
     */
    inline uint32 getU32UTCTimeDate_ScalarValue () const;

    /**
     * Sets the value of the member "u32UTCTimeDate_ScalarValue".
     *
     * scalar representation of time and date
     * - seconds elapsed since 2000-1-1, 0:00
     *
     * @param u32UTCTimeDate_ScalarValue The value which will be set
     */
    inline void setU32UTCTimeDate_ScalarValue (uint32 u32UTCTimeDate_ScalarValue_);

    // API of field "s16UTCTimeDate_Year"

    static const int kS16UTCTimeDate_Year = 9;

    /**
     * Clears the field "s16UTCTimeDate_Year".
     *
     * The field will be set to its default value. The hasS16UTCTimeDate_Year()
     * method will return false.
     */
    inline void clearS16UTCTimeDate_Year();

    /**
     * Checks whether the field "s16UTCTimeDate_Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16UTCTimeDate_Year()). Otherwise it will return false.
     */
    inline bool hasS16UTCTimeDate_Year () const;

    /**
     * Returns the value of the member "s16UTCTimeDate_Year".
     *
     * Year fraction of the UTCTime Date, acccording to standard gregorian calendar
     *
     * @return The value of the field "s16UTCTimeDate_Year"
     */
    inline int16 getS16UTCTimeDate_Year () const;

    /**
     * Sets the value of the member "s16UTCTimeDate_Year".
     *
     * Year fraction of the UTCTime Date, acccording to standard gregorian calendar
     *
     * @param s16UTCTimeDate_Year The value which will be set
     */
    inline void setS16UTCTimeDate_Year (int16 s16UTCTimeDate_Year_);

    // API of field "u8UTCTimeDate_Month"

    static const int kU8UTCTimeDate_Month = 10;

    /**
     * Clears the field "u8UTCTimeDate_Month".
     *
     * The field will be set to its default value. The hasU8UTCTimeDate_Month()
     * method will return false.
     */
    inline void clearU8UTCTimeDate_Month();

    /**
     * Checks whether the field "u8UTCTimeDate_Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8UTCTimeDate_Month()). Otherwise it will return false.
     */
    inline bool hasU8UTCTimeDate_Month () const;

    /**
     * Returns the value of the member "u8UTCTimeDate_Month".
     *
     * Month fraction[1-12] of UTCTime Date.
     *
     * @return The value of the field "u8UTCTimeDate_Month"
     */
    inline uint8 getU8UTCTimeDate_Month () const;

    /**
     * Sets the value of the member "u8UTCTimeDate_Month".
     *
     * Month fraction[1-12] of UTCTime Date.
     *
     * @param u8UTCTimeDate_Month The value which will be set
     */
    inline void setU8UTCTimeDate_Month (uint8 u8UTCTimeDate_Month_);

    // API of field "u8UTCTimeDate_Day"

    static const int kU8UTCTimeDate_Day = 11;

    /**
     * Clears the field "u8UTCTimeDate_Day".
     *
     * The field will be set to its default value. The hasU8UTCTimeDate_Day()
     * method will return false.
     */
    inline void clearU8UTCTimeDate_Day();

    /**
     * Checks whether the field "u8UTCTimeDate_Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8UTCTimeDate_Day()). Otherwise it will return false.
     */
    inline bool hasU8UTCTimeDate_Day () const;

    /**
     * Returns the value of the member "u8UTCTimeDate_Day".
     *
     * Day fraction[1- monthlength] of UTC Time Date.
     *
     * @return The value of the field "u8UTCTimeDate_Day"
     */
    inline uint8 getU8UTCTimeDate_Day () const;

    /**
     * Sets the value of the member "u8UTCTimeDate_Day".
     *
     * Day fraction[1- monthlength] of UTC Time Date.
     *
     * @param u8UTCTimeDate_Day The value which will be set
     */
    inline void setU8UTCTimeDate_Day (uint8 u8UTCTimeDate_Day_);

    // API of field "u8UTCTimeDate_Hour"

    static const int kU8UTCTimeDate_Hour = 12;

    /**
     * Clears the field "u8UTCTimeDate_Hour".
     *
     * The field will be set to its default value. The hasU8UTCTimeDate_Hour()
     * method will return false.
     */
    inline void clearU8UTCTimeDate_Hour();

    /**
     * Checks whether the field "u8UTCTimeDate_Hour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8UTCTimeDate_Hour()). Otherwise it will return false.
     */
    inline bool hasU8UTCTimeDate_Hour () const;

    /**
     * Returns the value of the member "u8UTCTimeDate_Hour".
     *
     * Hour fraction[0-23] of UTCTime Date.
     *
     * @return The value of the field "u8UTCTimeDate_Hour"
     */
    inline uint8 getU8UTCTimeDate_Hour () const;

    /**
     * Sets the value of the member "u8UTCTimeDate_Hour".
     *
     * Hour fraction[0-23] of UTCTime Date.
     *
     * @param u8UTCTimeDate_Hour The value which will be set
     */
    inline void setU8UTCTimeDate_Hour (uint8 u8UTCTimeDate_Hour_);

    // API of field "u8UTCTimeDate_Minute"

    static const int kU8UTCTimeDate_Minute = 13;

    /**
     * Clears the field "u8UTCTimeDate_Minute".
     *
     * The field will be set to its default value. The hasU8UTCTimeDate_Minute()
     * method will return false.
     */
    inline void clearU8UTCTimeDate_Minute();

    /**
     * Checks whether the field "u8UTCTimeDate_Minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8UTCTimeDate_Minute()). Otherwise it will return false.
     */
    inline bool hasU8UTCTimeDate_Minute () const;

    /**
     * Returns the value of the member "u8UTCTimeDate_Minute".
     *
     * Minute fraction[0-59] of UTCTime Date.
     *
     * @return The value of the field "u8UTCTimeDate_Minute"
     */
    inline uint8 getU8UTCTimeDate_Minute () const;

    /**
     * Sets the value of the member "u8UTCTimeDate_Minute".
     *
     * Minute fraction[0-59] of UTCTime Date.
     *
     * @param u8UTCTimeDate_Minute The value which will be set
     */
    inline void setU8UTCTimeDate_Minute (uint8 u8UTCTimeDate_Minute_);

    // API of field "u8UTCTimeDate_Second"

    static const int kU8UTCTimeDate_Second = 14;

    /**
     * Clears the field "u8UTCTimeDate_Second".
     *
     * The field will be set to its default value. The hasU8UTCTimeDate_Second()
     * method will return false.
     */
    inline void clearU8UTCTimeDate_Second();

    /**
     * Checks whether the field "u8UTCTimeDate_Second" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8UTCTimeDate_Second()). Otherwise it will return false.
     */
    inline bool hasU8UTCTimeDate_Second () const;

    /**
     * Returns the value of the member "u8UTCTimeDate_Second".
     *
     * Second fraction[0-59] of UTCTime Date.
     *
     * @return The value of the field "u8UTCTimeDate_Second"
     */
    inline uint8 getU8UTCTimeDate_Second () const;

    /**
     * Sets the value of the member "u8UTCTimeDate_Second".
     *
     * Second fraction[0-59] of UTCTime Date.
     *
     * @param u8UTCTimeDate_Second The value which will be set
     */
    inline void setU8UTCTimeDate_Second (uint8 u8UTCTimeDate_Second_);

    // API of field "u8UTCTimeDate_Weekday"

    static const int kU8UTCTimeDate_Weekday = 15;

    /**
     * Clears the field "u8UTCTimeDate_Weekday".
     *
     * The field will be set to its default value. The hasU8UTCTimeDate_Weekday()
     * method will return false.
     */
    inline void clearU8UTCTimeDate_Weekday();

    /**
     * Checks whether the field "u8UTCTimeDate_Weekday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8UTCTimeDate_Weekday()). Otherwise it will return false.
     */
    inline bool hasU8UTCTimeDate_Weekday () const;

    /**
     * Returns the value of the member "u8UTCTimeDate_Weekday".
     *
     * Week day fraction [0-6] of UTCTime Date
     *
     * @return The value of the field "u8UTCTimeDate_Weekday"
     */
    inline uint8 getU8UTCTimeDate_Weekday () const;

    /**
     * Sets the value of the member "u8UTCTimeDate_Weekday".
     *
     * Week day fraction [0-6] of UTCTime Date
     *
     * @param u8UTCTimeDate_Weekday The value which will be set
     */
    inline void setU8UTCTimeDate_Weekday (uint8 u8UTCTimeDate_Weekday_);

    // API of field "enGpsRtcTimeState"

    static const int kEnGpsRtcTimeState = 16;

    /**
     * Clears the field "enGpsRtcTimeState".
     *
     * The field will be set to its default value. The hasEnGpsRtcTimeState()
     * method will return false.
     */
    inline void clearEnGpsRtcTimeState();

    /**
     * Checks whether the field "enGpsRtcTimeState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnGpsRtcTimeState()). Otherwise it will return false.
     */
    inline bool hasEnGpsRtcTimeState () const;

    /**
     * Returns the value of the member "enGpsRtcTimeState".
     *
     * Flag field indicating whether UTC time is valid or not. any combination of values from VDCLK_GPSRTCTIMESTATE.
     *
     * @return The value of the field "enGpsRtcTimeState"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_GPSRTCTIMESTATE getEnGpsRtcTimeState () const;

    /**
     * Sets the value of the member "enGpsRtcTimeState".
     *
     * Flag field indicating whether UTC time is valid or not. any combination of values from VDCLK_GPSRTCTIMESTATE.
     *
     * @param enGpsRtcTimeState The value which will be set
     */
    inline void setEnGpsRtcTimeState (::clock_main_fi_types::VDCLK_TEN_GPSRTCTIMESTATE enGpsRtcTimeState_);

    static const LocalTimeOffsetStatus &getDefaultInstance();

private:

    inline void set_has_s64Offset_ScalarValue ();

    inline void clear_has_s64Offset_ScalarValue ();

    inline void set_has_bIsOffsetPostive ();

    inline void clear_has_bIsOffsetPostive ();

    inline void set_has_s16Offset_Year ();

    inline void clear_has_s16Offset_Year ();

    inline void set_has_u8Offset_Month ();

    inline void clear_has_u8Offset_Month ();

    inline void set_has_u8Offset_Day ();

    inline void clear_has_u8Offset_Day ();

    inline void set_has_u8Offset_Hour ();

    inline void clear_has_u8Offset_Hour ();

    inline void set_has_u8Offset_Minute ();

    inline void clear_has_u8Offset_Minute ();

    inline void set_has_u8Offset_Second ();

    inline void clear_has_u8Offset_Second ();

    inline void set_has_u32UTCTimeDate_ScalarValue ();

    inline void clear_has_u32UTCTimeDate_ScalarValue ();

    inline void set_has_s16UTCTimeDate_Year ();

    inline void clear_has_s16UTCTimeDate_Year ();

    inline void set_has_u8UTCTimeDate_Month ();

    inline void clear_has_u8UTCTimeDate_Month ();

    inline void set_has_u8UTCTimeDate_Day ();

    inline void clear_has_u8UTCTimeDate_Day ();

    inline void set_has_u8UTCTimeDate_Hour ();

    inline void clear_has_u8UTCTimeDate_Hour ();

    inline void set_has_u8UTCTimeDate_Minute ();

    inline void clear_has_u8UTCTimeDate_Minute ();

    inline void set_has_u8UTCTimeDate_Second ();

    inline void clear_has_u8UTCTimeDate_Second ();

    inline void set_has_u8UTCTimeDate_Weekday ();

    inline void clear_has_u8UTCTimeDate_Weekday ();

    inline void set_has_enGpsRtcTimeState ();

    inline void clear_has_enGpsRtcTimeState ();

    uint32 _has_bits_[ (17 + 31) / 32];

    int64 _s64Offset_ScalarValue;

    bool _bIsOffsetPostive;

    int16 _s16Offset_Year;

    uint8 _u8Offset_Month;

    uint8 _u8Offset_Day;

    uint8 _u8Offset_Hour;

    uint8 _u8Offset_Minute;

    uint8 _u8Offset_Second;

    uint32 _u32UTCTimeDate_ScalarValue;

    int16 _s16UTCTimeDate_Year;

    uint8 _u8UTCTimeDate_Month;

    uint8 _u8UTCTimeDate_Day;

    uint8 _u8UTCTimeDate_Hour;

    uint8 _u8UTCTimeDate_Minute;

    uint8 _u8UTCTimeDate_Second;

    uint8 _u8UTCTimeDate_Weekday;

    ::clock_main_fi_types::VDCLK_TEN_GPSRTCTIMESTATE _enGpsRtcTimeState;

};

/**
 * The status message of the property "LocalTimeDate"
 * Current date and time. This is updated every second. Update period parameter is not handled. Use property LocalTimeDate_MinuteUpdate for getting update every minute.
 * The HMI application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
class LocalTimeDateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LocalTimeDateStatus ();

    /**
     * Copy constructor
     */
    inline  LocalTimeDateStatus (const LocalTimeDateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  LocalTimeDateStatus (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_, uint8 u8TimeDateStatus_, uint32 u32TimeDateValue_);

    /**
     * Destructor
     */
    inline virtual  ~LocalTimeDateStatus();

    /**
     * Assignment operator
     */
    inline LocalTimeDateStatus& operator = (const LocalTimeDateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LocalTimeDateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LocalTimeDateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LocalTimeDateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LocalTimeDateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16Year"

    static const int kS16Year = 0;

    /**
     * Clears the field "s16Year".
     *
     * The field will be set to its default value. The hasS16Year()
     * method will return false.
     */
    inline void clearS16Year();

    /**
     * Checks whether the field "s16Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16Year()). Otherwise it will return false.
     */
    inline bool hasS16Year () const;

    /**
     * Returns the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * Note: dates before 1582 are treated as extrapolated gregorian;
     * no Julian calendar or so.
     *
     * @return The value of the field "s16Year"
     */
    inline int16 getS16Year () const;

    /**
     * Sets the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * Note: dates before 1582 are treated as extrapolated gregorian;
     * no Julian calendar or so.
     *
     * @param s16Year The value which will be set
     */
    inline void setS16Year (int16 s16Year_);

    // API of field "u8Month"

    static const int kU8Month = 1;

    /**
     * Clears the field "u8Month".
     *
     * The field will be set to its default value. The hasU8Month()
     * method will return false.
     */
    inline void clearU8Month();

    /**
     * Checks whether the field "u8Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Month()). Otherwise it will return false.
     */
    inline bool hasU8Month () const;

    /**
     * Returns the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @return The value of the field "u8Month"
     */
    inline uint8 getU8Month () const;

    /**
     * Sets the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @param u8Month The value which will be set
     */
    inline void setU8Month (uint8 u8Month_);

    // API of field "u8Day"

    static const int kU8Day = 2;

    /**
     * Clears the field "u8Day".
     *
     * The field will be set to its default value. The hasU8Day()
     * method will return false.
     */
    inline void clearU8Day();

    /**
     * Checks whether the field "u8Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Day()). Otherwise it will return false.
     */
    inline bool hasU8Day () const;

    /**
     * Returns the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @return The value of the field "u8Day"
     */
    inline uint8 getU8Day () const;

    /**
     * Sets the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @param u8Day The value which will be set
     */
    inline void setU8Day (uint8 u8Day_);

    // API of field "u8Hours"

    static const int kU8Hours = 3;

    /**
     * Clears the field "u8Hours".
     *
     * The field will be set to its default value. The hasU8Hours()
     * method will return false.
     */
    inline void clearU8Hours();

    /**
     * Checks whether the field "u8Hours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hours()). Otherwise it will return false.
     */
    inline bool hasU8Hours () const;

    /**
     * Returns the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat setting).
     *
     * @return The value of the field "u8Hours"
     */
    inline uint8 getU8Hours () const;

    /**
     * Sets the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat setting).
     *
     * @param u8Hours The value which will be set
     */
    inline void setU8Hours (uint8 u8Hours_);

    // API of field "u8Minutes"

    static const int kU8Minutes = 4;

    /**
     * Clears the field "u8Minutes".
     *
     * The field will be set to its default value. The hasU8Minutes()
     * method will return false.
     */
    inline void clearU8Minutes();

    /**
     * Checks whether the field "u8Minutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Minutes()). Otherwise it will return false.
     */
    inline bool hasU8Minutes () const;

    /**
     * Returns the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @return The value of the field "u8Minutes"
     */
    inline uint8 getU8Minutes () const;

    /**
     * Sets the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @param u8Minutes The value which will be set
     */
    inline void setU8Minutes (uint8 u8Minutes_);

    // API of field "u8Seconds"

    static const int kU8Seconds = 5;

    /**
     * Clears the field "u8Seconds".
     *
     * The field will be set to its default value. The hasU8Seconds()
     * method will return false.
     */
    inline void clearU8Seconds();

    /**
     * Checks whether the field "u8Seconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Seconds()). Otherwise it will return false.
     */
    inline bool hasU8Seconds () const;

    /**
     * Returns the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @return The value of the field "u8Seconds"
     */
    inline uint8 getU8Seconds () const;

    /**
     * Sets the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @param u8Seconds The value which will be set
     */
    inline void setU8Seconds (uint8 u8Seconds_);

    // API of field "u8Weekday"

    static const int kU8Weekday = 6;

    /**
     * Clears the field "u8Weekday".
     *
     * The field will be set to its default value. The hasU8Weekday()
     * method will return false.
     */
    inline void clearU8Weekday();

    /**
     * Checks whether the field "u8Weekday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Weekday()). Otherwise it will return false.
     */
    inline bool hasU8Weekday () const;

    /**
     * Returns the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @return The value of the field "u8Weekday"
     */
    inline uint8 getU8Weekday () const;

    /**
     * Sets the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @param u8Weekday The value which will be set
     */
    inline void setU8Weekday (uint8 u8Weekday_);

    // API of field "u8TimeDateStatus"

    static const int kU8TimeDateStatus = 7;

    /**
     * Clears the field "u8TimeDateStatus".
     *
     * The field will be set to its default value. The hasU8TimeDateStatus()
     * method will return false.
     */
    inline void clearU8TimeDateStatus();

    /**
     * Checks whether the field "u8TimeDateStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TimeDateStatus()). Otherwise it will return false.
     */
    inline bool hasU8TimeDateStatus () const;

    /**
     * Returns the value of the member "u8TimeDateStatus".
     *
     * Bit field, containing
     * - validity information for time and date
     * - information, which fields have (to be) changed.
     * Valid: any combination of values from T_e8_VDCLK_TimeDateStatus
     * For VWMIBE Project, If the TimeDate is INVALID(Time and date are not received from BAP/CAN),then u8TimeDateStatus value would be zero. For other values, TimeDate is Valid.
     *
     * @return The value of the field "u8TimeDateStatus"
     */
    inline uint8 getU8TimeDateStatus () const;

    /**
     * Sets the value of the member "u8TimeDateStatus".
     *
     * Bit field, containing
     * - validity information for time and date
     * - information, which fields have (to be) changed.
     * Valid: any combination of values from T_e8_VDCLK_TimeDateStatus
     * For VWMIBE Project, If the TimeDate is INVALID(Time and date are not received from BAP/CAN),then u8TimeDateStatus value would be zero. For other values, TimeDate is Valid.
     *
     * @param u8TimeDateStatus The value which will be set
     */
    inline void setU8TimeDateStatus (uint8 u8TimeDateStatus_);

    // API of field "u32TimeDateValue"

    static const int kU32TimeDateValue = 8;

    /**
     * Clears the field "u32TimeDateValue".
     *
     * The field will be set to its default value. The hasU32TimeDateValue()
     * method will return false.
     */
    inline void clearU32TimeDateValue();

    /**
     * Checks whether the field "u32TimeDateValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TimeDateValue()). Otherwise it will return false.
     */
    inline bool hasU32TimeDateValue () const;

    /**
     * Returns the value of the member "u32TimeDateValue".
     *
     * scalar representation of time and date
     * - seconds elapsed since 2000-1-1, 0:00
     * - used for arithmetic calculations
     *
     * @return The value of the field "u32TimeDateValue"
     */
    inline uint32 getU32TimeDateValue () const;

    /**
     * Sets the value of the member "u32TimeDateValue".
     *
     * scalar representation of time and date
     * - seconds elapsed since 2000-1-1, 0:00
     * - used for arithmetic calculations
     *
     * @param u32TimeDateValue The value which will be set
     */
    inline void setU32TimeDateValue (uint32 u32TimeDateValue_);

    static const LocalTimeDateStatus &getDefaultInstance();

private:

    inline void set_has_s16Year ();

    inline void clear_has_s16Year ();

    inline void set_has_u8Month ();

    inline void clear_has_u8Month ();

    inline void set_has_u8Day ();

    inline void clear_has_u8Day ();

    inline void set_has_u8Hours ();

    inline void clear_has_u8Hours ();

    inline void set_has_u8Minutes ();

    inline void clear_has_u8Minutes ();

    inline void set_has_u8Seconds ();

    inline void clear_has_u8Seconds ();

    inline void set_has_u8Weekday ();

    inline void clear_has_u8Weekday ();

    inline void set_has_u8TimeDateStatus ();

    inline void clear_has_u8TimeDateStatus ();

    inline void set_has_u32TimeDateValue ();

    inline void clear_has_u32TimeDateValue ();

    uint32 _has_bits_[ (9 + 31) / 32];

    int16 _s16Year;

    uint8 _u8Month;

    uint8 _u8Day;

    uint8 _u8Hours;

    uint8 _u8Minutes;

    uint8 _u8Seconds;

    uint8 _u8Weekday;

    uint8 _u8TimeDateStatus;

    uint32 _u32TimeDateValue;

};

/**
 * The set message of the property "LocalTimeDate"
 * Current date and time. This is updated every second. Update period parameter is not handled. Use property LocalTimeDate_MinuteUpdate for getting update every minute.
 * The HMI application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
class LocalTimeDateSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LocalTimeDateSet ();

    /**
     * Copy constructor
     */
    inline  LocalTimeDateSet (const LocalTimeDateSet &rhs);

    /**
     * All fields constructor
     */
    inline  LocalTimeDateSet (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_, uint8 u8ChangeMask_);

    /**
     * Destructor
     */
    inline virtual  ~LocalTimeDateSet();

    /**
     * Assignment operator
     */
    inline LocalTimeDateSet& operator = (const LocalTimeDateSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LocalTimeDateSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LocalTimeDateSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LocalTimeDateSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LocalTimeDateSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16Year"

    static const int kS16Year = 0;

    /**
     * Clears the field "s16Year".
     *
     * The field will be set to its default value. The hasS16Year()
     * method will return false.
     */
    inline void clearS16Year();

    /**
     * Checks whether the field "s16Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16Year()). Otherwise it will return false.
     */
    inline bool hasS16Year () const;

    /**
     * Returns the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * (if set as short year (e.g. 05 instead of 2005)
     * outgoing notifications will also give short year)
     *
     * @return The value of the field "s16Year"
     */
    inline int16 getS16Year () const;

    /**
     * Sets the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * (if set as short year (e.g. 05 instead of 2005)
     * outgoing notifications will also give short year)
     *
     * @param s16Year The value which will be set
     */
    inline void setS16Year (int16 s16Year_);

    // API of field "u8Month"

    static const int kU8Month = 1;

    /**
     * Clears the field "u8Month".
     *
     * The field will be set to its default value. The hasU8Month()
     * method will return false.
     */
    inline void clearU8Month();

    /**
     * Checks whether the field "u8Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Month()). Otherwise it will return false.
     */
    inline bool hasU8Month () const;

    /**
     * Returns the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @return The value of the field "u8Month"
     */
    inline uint8 getU8Month () const;

    /**
     * Sets the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @param u8Month The value which will be set
     */
    inline void setU8Month (uint8 u8Month_);

    // API of field "u8Day"

    static const int kU8Day = 2;

    /**
     * Clears the field "u8Day".
     *
     * The field will be set to its default value. The hasU8Day()
     * method will return false.
     */
    inline void clearU8Day();

    /**
     * Checks whether the field "u8Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Day()). Otherwise it will return false.
     */
    inline bool hasU8Day () const;

    /**
     * Returns the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @return The value of the field "u8Day"
     */
    inline uint8 getU8Day () const;

    /**
     * Sets the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @param u8Day The value which will be set
     */
    inline void setU8Day (uint8 u8Day_);

    // API of field "u8Hours"

    static const int kU8Hours = 3;

    /**
     * Clears the field "u8Hours".
     *
     * The field will be set to its default value. The hasU8Hours()
     * method will return false.
     */
    inline void clearU8Hours();

    /**
     * Checks whether the field "u8Hours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hours()). Otherwise it will return false.
     */
    inline bool hasU8Hours () const;

    /**
     * Returns the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat).
     *
     * @return The value of the field "u8Hours"
     */
    inline uint8 getU8Hours () const;

    /**
     * Sets the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat).
     *
     * @param u8Hours The value which will be set
     */
    inline void setU8Hours (uint8 u8Hours_);

    // API of field "u8Minutes"

    static const int kU8Minutes = 4;

    /**
     * Clears the field "u8Minutes".
     *
     * The field will be set to its default value. The hasU8Minutes()
     * method will return false.
     */
    inline void clearU8Minutes();

    /**
     * Checks whether the field "u8Minutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Minutes()). Otherwise it will return false.
     */
    inline bool hasU8Minutes () const;

    /**
     * Returns the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @return The value of the field "u8Minutes"
     */
    inline uint8 getU8Minutes () const;

    /**
     * Sets the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @param u8Minutes The value which will be set
     */
    inline void setU8Minutes (uint8 u8Minutes_);

    // API of field "u8Seconds"

    static const int kU8Seconds = 5;

    /**
     * Clears the field "u8Seconds".
     *
     * The field will be set to its default value. The hasU8Seconds()
     * method will return false.
     */
    inline void clearU8Seconds();

    /**
     * Checks whether the field "u8Seconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Seconds()). Otherwise it will return false.
     */
    inline bool hasU8Seconds () const;

    /**
     * Returns the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @return The value of the field "u8Seconds"
     */
    inline uint8 getU8Seconds () const;

    /**
     * Sets the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @param u8Seconds The value which will be set
     */
    inline void setU8Seconds (uint8 u8Seconds_);

    // API of field "u8Weekday"

    static const int kU8Weekday = 6;

    /**
     * Clears the field "u8Weekday".
     *
     * The field will be set to its default value. The hasU8Weekday()
     * method will return false.
     */
    inline void clearU8Weekday();

    /**
     * Checks whether the field "u8Weekday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Weekday()). Otherwise it will return false.
     */
    inline bool hasU8Weekday () const;

    /**
     * Returns the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @return The value of the field "u8Weekday"
     */
    inline uint8 getU8Weekday () const;

    /**
     * Sets the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @param u8Weekday The value which will be set
     */
    inline void setU8Weekday (uint8 u8Weekday_);

    // API of field "u8ChangeMask"

    static const int kU8ChangeMask = 7;

    /**
     * Clears the field "u8ChangeMask".
     *
     * The field will be set to its default value. The hasU8ChangeMask()
     * method will return false.
     */
    inline void clearU8ChangeMask();

    /**
     * Checks whether the field "u8ChangeMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ChangeMask()). Otherwise it will return false.
     */
    inline bool hasU8ChangeMask () const;

    /**
     * Returns the value of the member "u8ChangeMask".
     *
     * mask for fields to be updated;
     * any combination of "VDCLK_EN_..Change" values
     * from T_e8_VDCLK_TimeDateStatus
     *
     * @return The value of the field "u8ChangeMask"
     */
    inline uint8 getU8ChangeMask () const;

    /**
     * Sets the value of the member "u8ChangeMask".
     *
     * mask for fields to be updated;
     * any combination of "VDCLK_EN_..Change" values
     * from T_e8_VDCLK_TimeDateStatus
     *
     * @param u8ChangeMask The value which will be set
     */
    inline void setU8ChangeMask (uint8 u8ChangeMask_);

    static const LocalTimeDateSet &getDefaultInstance();

private:

    inline void set_has_s16Year ();

    inline void clear_has_s16Year ();

    inline void set_has_u8Month ();

    inline void clear_has_u8Month ();

    inline void set_has_u8Day ();

    inline void clear_has_u8Day ();

    inline void set_has_u8Hours ();

    inline void clear_has_u8Hours ();

    inline void set_has_u8Minutes ();

    inline void clear_has_u8Minutes ();

    inline void set_has_u8Seconds ();

    inline void clear_has_u8Seconds ();

    inline void set_has_u8Weekday ();

    inline void clear_has_u8Weekday ();

    inline void set_has_u8ChangeMask ();

    inline void clear_has_u8ChangeMask ();

    uint32 _has_bits_[ (8 + 31) / 32];

    int16 _s16Year;

    uint8 _u8Month;

    uint8 _u8Day;

    uint8 _u8Hours;

    uint8 _u8Minutes;

    uint8 _u8Seconds;

    uint8 _u8Weekday;

    uint8 _u8ChangeMask;

};

/**
 * The upreg message of the property "LocalTimeDate"
 * Current date and time. This is updated every second. Update period parameter is not handled. Use property LocalTimeDate_MinuteUpdate for getting update every minute.
 * The HMI application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
class LocalTimeDateUpReg  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LocalTimeDateUpReg ();

    /**
     * Copy constructor
     */
    inline  LocalTimeDateUpReg (const LocalTimeDateUpReg &rhs);

    /**
     * All fields constructor
     */
    inline  LocalTimeDateUpReg (uint8 u8UpdatePeriod_);

    /**
     * Destructor
     */
    inline virtual  ~LocalTimeDateUpReg();

    /**
     * Assignment operator
     */
    inline LocalTimeDateUpReg& operator = (const LocalTimeDateUpReg& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LocalTimeDateUpReg& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LocalTimeDateUpReg& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LocalTimeDateUpReg& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LocalTimeDateUpReg& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8UpdatePeriod"

    static const int kU8UpdatePeriod = 0;

    /**
     * Clears the field "u8UpdatePeriod".
     *
     * The field will be set to its default value. The hasU8UpdatePeriod()
     * method will return false.
     */
    inline void clearU8UpdatePeriod();

    /**
     * Checks whether the field "u8UpdatePeriod" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8UpdatePeriod()). Otherwise it will return false.
     */
    inline bool hasU8UpdatePeriod () const;

    /**
     * Returns the value of the member "u8UpdatePeriod".
     *
     * This parameter is not handled. Use property LocalTimeDate_MinuteUpdate for getting update every minute.
     * Specify period of update notification (1=1/sec, 2=1/min, 3=1/h)
     *
     * @return The value of the field "u8UpdatePeriod"
     */
    inline uint8 getU8UpdatePeriod () const;

    /**
     * Sets the value of the member "u8UpdatePeriod".
     *
     * This parameter is not handled. Use property LocalTimeDate_MinuteUpdate for getting update every minute.
     * Specify period of update notification (1=1/sec, 2=1/min, 3=1/h)
     *
     * @param u8UpdatePeriod The value which will be set
     */
    inline void setU8UpdatePeriod (uint8 u8UpdatePeriod_);

    static const LocalTimeDateUpReg &getDefaultInstance();

private:

    inline void set_has_u8UpdatePeriod ();

    inline void clear_has_u8UpdatePeriod ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8UpdatePeriod;

};

/**
 * The relUpReg message of the property "LocalTimeDate"
 * Current date and time. This is updated every second. Update period parameter is not handled. Use property LocalTimeDate_MinuteUpdate for getting update every minute.
 * The HMI application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
class LocalTimeDateRelUpReg  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LocalTimeDateRelUpReg ();

    /**
     * Copy constructor
     */
    inline  LocalTimeDateRelUpReg (const LocalTimeDateRelUpReg &rhs);

    /**
     * All fields constructor
     */
    inline  LocalTimeDateRelUpReg (uint8 u8UpdatePeriod_);

    /**
     * Destructor
     */
    inline virtual  ~LocalTimeDateRelUpReg();

    /**
     * Assignment operator
     */
    inline LocalTimeDateRelUpReg& operator = (const LocalTimeDateRelUpReg& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LocalTimeDateRelUpReg& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LocalTimeDateRelUpReg& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LocalTimeDateRelUpReg& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LocalTimeDateRelUpReg& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8UpdatePeriod"

    static const int kU8UpdatePeriod = 0;

    /**
     * Clears the field "u8UpdatePeriod".
     *
     * The field will be set to its default value. The hasU8UpdatePeriod()
     * method will return false.
     */
    inline void clearU8UpdatePeriod();

    /**
     * Checks whether the field "u8UpdatePeriod" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8UpdatePeriod()). Otherwise it will return false.
     */
    inline bool hasU8UpdatePeriod () const;

    /**
     * Returns the value of the member "u8UpdatePeriod".
     *
     * Not used, but CCA requires same parameters as for UpReg.
     *
     * @return The value of the field "u8UpdatePeriod"
     */
    inline uint8 getU8UpdatePeriod () const;

    /**
     * Sets the value of the member "u8UpdatePeriod".
     *
     * Not used, but CCA requires same parameters as for UpReg.
     *
     * @param u8UpdatePeriod The value which will be set
     */
    inline void setU8UpdatePeriod (uint8 u8UpdatePeriod_);

    static const LocalTimeDateRelUpReg &getDefaultInstance();

private:

    inline void set_has_u8UpdatePeriod ();

    inline void clear_has_u8UpdatePeriod ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8UpdatePeriod;

};

/**
 * The status message of the property "TimeFormat"
 * European (24h) or American (12h a.m./p.m.) time format for use in HMI
 */
class TimeFormatStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TimeFormatStatus ();

    /**
     * Copy constructor
     */
    inline  TimeFormatStatus (const TimeFormatStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TimeFormatStatus (::clock_main_fi_types::VDCLK_TEN_TimeFormat enTimeFormat_);

    /**
     * Destructor
     */
    inline virtual  ~TimeFormatStatus();

    /**
     * Assignment operator
     */
    inline TimeFormatStatus& operator = (const TimeFormatStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TimeFormatStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TimeFormatStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TimeFormatStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TimeFormatStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enTimeFormat"

    static const int kEnTimeFormat = 0;

    /**
     * Clears the field "enTimeFormat".
     *
     * The field will be set to its default value. The hasEnTimeFormat()
     * method will return false.
     */
    inline void clearEnTimeFormat();

    /**
     * Checks whether the field "enTimeFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnTimeFormat()). Otherwise it will return false.
     */
    inline bool hasEnTimeFormat () const;

    /**
     * Returns the value of the member "enTimeFormat".
     *
     *
     *
     * @return The value of the field "enTimeFormat"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_TimeFormat getEnTimeFormat () const;

    /**
     * Sets the value of the member "enTimeFormat".
     *
     *
     *
     * @param enTimeFormat The value which will be set
     */
    inline void setEnTimeFormat (::clock_main_fi_types::VDCLK_TEN_TimeFormat enTimeFormat_);

    static const TimeFormatStatus &getDefaultInstance();

private:

    inline void set_has_enTimeFormat ();

    inline void clear_has_enTimeFormat ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_TimeFormat _enTimeFormat;

};

/**
 * The set message of the property "TimeFormat"
 * European (24h) or American (12h a.m./p.m.) time format for use in HMI
 */
class TimeFormatSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TimeFormatSet ();

    /**
     * Copy constructor
     */
    inline  TimeFormatSet (const TimeFormatSet &rhs);

    /**
     * All fields constructor
     */
    inline  TimeFormatSet (::clock_main_fi_types::VDCLK_TEN_TimeFormat enTimeFormat_);

    /**
     * Destructor
     */
    inline virtual  ~TimeFormatSet();

    /**
     * Assignment operator
     */
    inline TimeFormatSet& operator = (const TimeFormatSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TimeFormatSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TimeFormatSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TimeFormatSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TimeFormatSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enTimeFormat"

    static const int kEnTimeFormat = 0;

    /**
     * Clears the field "enTimeFormat".
     *
     * The field will be set to its default value. The hasEnTimeFormat()
     * method will return false.
     */
    inline void clearEnTimeFormat();

    /**
     * Checks whether the field "enTimeFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnTimeFormat()). Otherwise it will return false.
     */
    inline bool hasEnTimeFormat () const;

    /**
     * Returns the value of the member "enTimeFormat".
     *
     *
     *
     * @return The value of the field "enTimeFormat"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_TimeFormat getEnTimeFormat () const;

    /**
     * Sets the value of the member "enTimeFormat".
     *
     *
     *
     * @param enTimeFormat The value which will be set
     */
    inline void setEnTimeFormat (::clock_main_fi_types::VDCLK_TEN_TimeFormat enTimeFormat_);

    static const TimeFormatSet &getDefaultInstance();

private:

    inline void set_has_enTimeFormat ();

    inline void clear_has_enTimeFormat ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_TimeFormat _enTimeFormat;

};

/**
 * The status message of the property "DateFormat"
 * switch between date formats (for use by HMI):
 * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
 */
class DateFormatStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DateFormatStatus ();

    /**
     * Copy constructor
     */
    inline  DateFormatStatus (const DateFormatStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DateFormatStatus (::clock_main_fi_types::VDCLK_TEN_DateFormat enDateFormat_);

    /**
     * Destructor
     */
    inline virtual  ~DateFormatStatus();

    /**
     * Assignment operator
     */
    inline DateFormatStatus& operator = (const DateFormatStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DateFormatStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DateFormatStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DateFormatStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DateFormatStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enDateFormat"

    static const int kEnDateFormat = 0;

    /**
     * Clears the field "enDateFormat".
     *
     * The field will be set to its default value. The hasEnDateFormat()
     * method will return false.
     */
    inline void clearEnDateFormat();

    /**
     * Checks whether the field "enDateFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDateFormat()). Otherwise it will return false.
     */
    inline bool hasEnDateFormat () const;

    /**
     * Returns the value of the member "enDateFormat".
     *
     *
     *
     * @return The value of the field "enDateFormat"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_DateFormat getEnDateFormat () const;

    /**
     * Sets the value of the member "enDateFormat".
     *
     *
     *
     * @param enDateFormat The value which will be set
     */
    inline void setEnDateFormat (::clock_main_fi_types::VDCLK_TEN_DateFormat enDateFormat_);

    static const DateFormatStatus &getDefaultInstance();

private:

    inline void set_has_enDateFormat ();

    inline void clear_has_enDateFormat ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_DateFormat _enDateFormat;

};

/**
 * The set message of the property "DateFormat"
 * switch between date formats (for use by HMI):
 * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
 */
class DateFormatSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DateFormatSet ();

    /**
     * Copy constructor
     */
    inline  DateFormatSet (const DateFormatSet &rhs);

    /**
     * All fields constructor
     */
    inline  DateFormatSet (::clock_main_fi_types::VDCLK_TEN_DateFormat enDateFormat_);

    /**
     * Destructor
     */
    inline virtual  ~DateFormatSet();

    /**
     * Assignment operator
     */
    inline DateFormatSet& operator = (const DateFormatSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DateFormatSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DateFormatSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DateFormatSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DateFormatSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enDateFormat"

    static const int kEnDateFormat = 0;

    /**
     * Clears the field "enDateFormat".
     *
     * The field will be set to its default value. The hasEnDateFormat()
     * method will return false.
     */
    inline void clearEnDateFormat();

    /**
     * Checks whether the field "enDateFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDateFormat()). Otherwise it will return false.
     */
    inline bool hasEnDateFormat () const;

    /**
     * Returns the value of the member "enDateFormat".
     *
     *
     *
     * @return The value of the field "enDateFormat"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_DateFormat getEnDateFormat () const;

    /**
     * Sets the value of the member "enDateFormat".
     *
     *
     *
     * @param enDateFormat The value which will be set
     */
    inline void setEnDateFormat (::clock_main_fi_types::VDCLK_TEN_DateFormat enDateFormat_);

    static const DateFormatSet &getDefaultInstance();

private:

    inline void set_has_enDateFormat ();

    inline void clear_has_enDateFormat ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_DateFormat _enDateFormat;

};

/**
 * The status message of the property "ClockSourceStatus"
 * Status of different clock sources (system, master, GPS; read only).
 * Used by HMI to determine whether manual setting shall be enabled
 */
class ClockSourceStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClockSourceStatusStatus ();

    /**
     * Copy constructor
     */
    inline  ClockSourceStatusStatus (const ClockSourceStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ClockSourceStatusStatus (::clock_main_fi_types::VDCLK_TEN_ClockSourceStatus enSourcesValid_);

    /**
     * Destructor
     */
    inline virtual  ~ClockSourceStatusStatus();

    /**
     * Assignment operator
     */
    inline ClockSourceStatusStatus& operator = (const ClockSourceStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClockSourceStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClockSourceStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClockSourceStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClockSourceStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enSourcesValid"

    static const int kEnSourcesValid = 0;

    /**
     * Clears the field "enSourcesValid".
     *
     * The field will be set to its default value. The hasEnSourcesValid()
     * method will return false.
     */
    inline void clearEnSourcesValid();

    /**
     * Checks whether the field "enSourcesValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnSourcesValid()). Otherwise it will return false.
     */
    inline bool hasEnSourcesValid () const;

    /**
     * Returns the value of the member "enSourcesValid".
     *
     * Indicator, whether sources
     * of date and time are valid;
     *
     * @return The value of the field "enSourcesValid"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_ClockSourceStatus getEnSourcesValid () const;

    /**
     * Sets the value of the member "enSourcesValid".
     *
     * Indicator, whether sources
     * of date and time are valid;
     *
     * @param enSourcesValid The value which will be set
     */
    inline void setEnSourcesValid (::clock_main_fi_types::VDCLK_TEN_ClockSourceStatus enSourcesValid_);

    static const ClockSourceStatusStatus &getDefaultInstance();

private:

    inline void set_has_enSourcesValid ();

    inline void clear_has_enSourcesValid ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_ClockSourceStatus _enSourcesValid;

};

/**
 * The status message of the property "FormatSourceStatus"
 * Status of master signal dictating date and time format (read only).
 * Used by HMI to determine whether manual setting shall be enabled
 */
class FormatSourceStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FormatSourceStatusStatus ();

    /**
     * Copy constructor
     */
    inline  FormatSourceStatusStatus (const FormatSourceStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FormatSourceStatusStatus (::clock_main_fi_types::VDCLK_TEN_FormatSourceStatus enFormatSourceStatus_);

    /**
     * Destructor
     */
    inline virtual  ~FormatSourceStatusStatus();

    /**
     * Assignment operator
     */
    inline FormatSourceStatusStatus& operator = (const FormatSourceStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FormatSourceStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FormatSourceStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FormatSourceStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FormatSourceStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enFormatSourceStatus"

    static const int kEnFormatSourceStatus = 0;

    /**
     * Clears the field "enFormatSourceStatus".
     *
     * The field will be set to its default value. The hasEnFormatSourceStatus()
     * method will return false.
     */
    inline void clearEnFormatSourceStatus();

    /**
     * Checks whether the field "enFormatSourceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnFormatSourceStatus()). Otherwise it will return false.
     */
    inline bool hasEnFormatSourceStatus () const;

    /**
     * Returns the value of the member "enFormatSourceStatus".
     *
     * Flag field, indicating whether format dictating signals are valid;
     * any combination of values from T_e8_VDCLK_FormatSourceStatus
     *
     * @return The value of the field "enFormatSourceStatus"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_FormatSourceStatus getEnFormatSourceStatus () const;

    /**
     * Sets the value of the member "enFormatSourceStatus".
     *
     * Flag field, indicating whether format dictating signals are valid;
     * any combination of values from T_e8_VDCLK_FormatSourceStatus
     *
     * @param enFormatSourceStatus The value which will be set
     */
    inline void setEnFormatSourceStatus (::clock_main_fi_types::VDCLK_TEN_FormatSourceStatus enFormatSourceStatus_);

    static const FormatSourceStatusStatus &getDefaultInstance();

private:

    inline void set_has_enFormatSourceStatus ();

    inline void clear_has_enFormatSourceStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_FormatSourceStatus _enFormatSourceStatus;

};

/**
 * The status message of the property "LocalTimeDate_MinuteUpdate"
 * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
 * The client application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
class LocalTimeDate_MinuteUpdateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LocalTimeDate_MinuteUpdateStatus ();

    /**
     * Copy constructor
     */
    inline  LocalTimeDate_MinuteUpdateStatus (const LocalTimeDate_MinuteUpdateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  LocalTimeDate_MinuteUpdateStatus (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_, uint8 u8TimeDateStatus_, uint32 u32TimeDateValue_);

    /**
     * Destructor
     */
    inline virtual  ~LocalTimeDate_MinuteUpdateStatus();

    /**
     * Assignment operator
     */
    inline LocalTimeDate_MinuteUpdateStatus& operator = (const LocalTimeDate_MinuteUpdateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LocalTimeDate_MinuteUpdateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LocalTimeDate_MinuteUpdateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LocalTimeDate_MinuteUpdateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LocalTimeDate_MinuteUpdateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16Year"

    static const int kS16Year = 0;

    /**
     * Clears the field "s16Year".
     *
     * The field will be set to its default value. The hasS16Year()
     * method will return false.
     */
    inline void clearS16Year();

    /**
     * Checks whether the field "s16Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16Year()). Otherwise it will return false.
     */
    inline bool hasS16Year () const;

    /**
     * Returns the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * Note: dates before 1582 are treated as extrapolated gregorian;
     * no Julian calendar or so.
     *
     * @return The value of the field "s16Year"
     */
    inline int16 getS16Year () const;

    /**
     * Sets the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * Note: dates before 1582 are treated as extrapolated gregorian;
     * no Julian calendar or so.
     *
     * @param s16Year The value which will be set
     */
    inline void setS16Year (int16 s16Year_);

    // API of field "u8Month"

    static const int kU8Month = 1;

    /**
     * Clears the field "u8Month".
     *
     * The field will be set to its default value. The hasU8Month()
     * method will return false.
     */
    inline void clearU8Month();

    /**
     * Checks whether the field "u8Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Month()). Otherwise it will return false.
     */
    inline bool hasU8Month () const;

    /**
     * Returns the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @return The value of the field "u8Month"
     */
    inline uint8 getU8Month () const;

    /**
     * Sets the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @param u8Month The value which will be set
     */
    inline void setU8Month (uint8 u8Month_);

    // API of field "u8Day"

    static const int kU8Day = 2;

    /**
     * Clears the field "u8Day".
     *
     * The field will be set to its default value. The hasU8Day()
     * method will return false.
     */
    inline void clearU8Day();

    /**
     * Checks whether the field "u8Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Day()). Otherwise it will return false.
     */
    inline bool hasU8Day () const;

    /**
     * Returns the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @return The value of the field "u8Day"
     */
    inline uint8 getU8Day () const;

    /**
     * Sets the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @param u8Day The value which will be set
     */
    inline void setU8Day (uint8 u8Day_);

    // API of field "u8Hours"

    static const int kU8Hours = 3;

    /**
     * Clears the field "u8Hours".
     *
     * The field will be set to its default value. The hasU8Hours()
     * method will return false.
     */
    inline void clearU8Hours();

    /**
     * Checks whether the field "u8Hours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hours()). Otherwise it will return false.
     */
    inline bool hasU8Hours () const;

    /**
     * Returns the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat setting).
     *
     * @return The value of the field "u8Hours"
     */
    inline uint8 getU8Hours () const;

    /**
     * Sets the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat setting).
     *
     * @param u8Hours The value which will be set
     */
    inline void setU8Hours (uint8 u8Hours_);

    // API of field "u8Minutes"

    static const int kU8Minutes = 4;

    /**
     * Clears the field "u8Minutes".
     *
     * The field will be set to its default value. The hasU8Minutes()
     * method will return false.
     */
    inline void clearU8Minutes();

    /**
     * Checks whether the field "u8Minutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Minutes()). Otherwise it will return false.
     */
    inline bool hasU8Minutes () const;

    /**
     * Returns the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @return The value of the field "u8Minutes"
     */
    inline uint8 getU8Minutes () const;

    /**
     * Sets the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @param u8Minutes The value which will be set
     */
    inline void setU8Minutes (uint8 u8Minutes_);

    // API of field "u8Seconds"

    static const int kU8Seconds = 5;

    /**
     * Clears the field "u8Seconds".
     *
     * The field will be set to its default value. The hasU8Seconds()
     * method will return false.
     */
    inline void clearU8Seconds();

    /**
     * Checks whether the field "u8Seconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Seconds()). Otherwise it will return false.
     */
    inline bool hasU8Seconds () const;

    /**
     * Returns the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @return The value of the field "u8Seconds"
     */
    inline uint8 getU8Seconds () const;

    /**
     * Sets the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @param u8Seconds The value which will be set
     */
    inline void setU8Seconds (uint8 u8Seconds_);

    // API of field "u8Weekday"

    static const int kU8Weekday = 6;

    /**
     * Clears the field "u8Weekday".
     *
     * The field will be set to its default value. The hasU8Weekday()
     * method will return false.
     */
    inline void clearU8Weekday();

    /**
     * Checks whether the field "u8Weekday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Weekday()). Otherwise it will return false.
     */
    inline bool hasU8Weekday () const;

    /**
     * Returns the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @return The value of the field "u8Weekday"
     */
    inline uint8 getU8Weekday () const;

    /**
     * Sets the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @param u8Weekday The value which will be set
     */
    inline void setU8Weekday (uint8 u8Weekday_);

    // API of field "u8TimeDateStatus"

    static const int kU8TimeDateStatus = 7;

    /**
     * Clears the field "u8TimeDateStatus".
     *
     * The field will be set to its default value. The hasU8TimeDateStatus()
     * method will return false.
     */
    inline void clearU8TimeDateStatus();

    /**
     * Checks whether the field "u8TimeDateStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TimeDateStatus()). Otherwise it will return false.
     */
    inline bool hasU8TimeDateStatus () const;

    /**
     * Returns the value of the member "u8TimeDateStatus".
     *
     * Bit field, containing
     * - validity information for time and date
     * - information, which fields have (to be) changed.
     * Valid: any combination of values from T_e8_VDCLK_TimeDateStatus
     *
     * @return The value of the field "u8TimeDateStatus"
     */
    inline uint8 getU8TimeDateStatus () const;

    /**
     * Sets the value of the member "u8TimeDateStatus".
     *
     * Bit field, containing
     * - validity information for time and date
     * - information, which fields have (to be) changed.
     * Valid: any combination of values from T_e8_VDCLK_TimeDateStatus
     *
     * @param u8TimeDateStatus The value which will be set
     */
    inline void setU8TimeDateStatus (uint8 u8TimeDateStatus_);

    // API of field "u32TimeDateValue"

    static const int kU32TimeDateValue = 8;

    /**
     * Clears the field "u32TimeDateValue".
     *
     * The field will be set to its default value. The hasU32TimeDateValue()
     * method will return false.
     */
    inline void clearU32TimeDateValue();

    /**
     * Checks whether the field "u32TimeDateValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TimeDateValue()). Otherwise it will return false.
     */
    inline bool hasU32TimeDateValue () const;

    /**
     * Returns the value of the member "u32TimeDateValue".
     *
     * scalar representation of time and date
     * - seconds elapsed since 2000-1-1, 0:00
     * - used for arithmetic calculations
     *
     * @return The value of the field "u32TimeDateValue"
     */
    inline uint32 getU32TimeDateValue () const;

    /**
     * Sets the value of the member "u32TimeDateValue".
     *
     * scalar representation of time and date
     * - seconds elapsed since 2000-1-1, 0:00
     * - used for arithmetic calculations
     *
     * @param u32TimeDateValue The value which will be set
     */
    inline void setU32TimeDateValue (uint32 u32TimeDateValue_);

    static const LocalTimeDate_MinuteUpdateStatus &getDefaultInstance();

private:

    inline void set_has_s16Year ();

    inline void clear_has_s16Year ();

    inline void set_has_u8Month ();

    inline void clear_has_u8Month ();

    inline void set_has_u8Day ();

    inline void clear_has_u8Day ();

    inline void set_has_u8Hours ();

    inline void clear_has_u8Hours ();

    inline void set_has_u8Minutes ();

    inline void clear_has_u8Minutes ();

    inline void set_has_u8Seconds ();

    inline void clear_has_u8Seconds ();

    inline void set_has_u8Weekday ();

    inline void clear_has_u8Weekday ();

    inline void set_has_u8TimeDateStatus ();

    inline void clear_has_u8TimeDateStatus ();

    inline void set_has_u32TimeDateValue ();

    inline void clear_has_u32TimeDateValue ();

    uint32 _has_bits_[ (9 + 31) / 32];

    int16 _s16Year;

    uint8 _u8Month;

    uint8 _u8Day;

    uint8 _u8Hours;

    uint8 _u8Minutes;

    uint8 _u8Seconds;

    uint8 _u8Weekday;

    uint8 _u8TimeDateStatus;

    uint32 _u32TimeDateValue;

};

/**
 * The set message of the property "LocalTimeDate_MinuteUpdate"
 * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
 * The client application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
class LocalTimeDate_MinuteUpdateSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LocalTimeDate_MinuteUpdateSet ();

    /**
     * Copy constructor
     */
    inline  LocalTimeDate_MinuteUpdateSet (const LocalTimeDate_MinuteUpdateSet &rhs);

    /**
     * All fields constructor
     */
    inline  LocalTimeDate_MinuteUpdateSet (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_, uint8 u8ChangeMask_);

    /**
     * Destructor
     */
    inline virtual  ~LocalTimeDate_MinuteUpdateSet();

    /**
     * Assignment operator
     */
    inline LocalTimeDate_MinuteUpdateSet& operator = (const LocalTimeDate_MinuteUpdateSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LocalTimeDate_MinuteUpdateSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LocalTimeDate_MinuteUpdateSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LocalTimeDate_MinuteUpdateSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LocalTimeDate_MinuteUpdateSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16Year"

    static const int kS16Year = 0;

    /**
     * Clears the field "s16Year".
     *
     * The field will be set to its default value. The hasS16Year()
     * method will return false.
     */
    inline void clearS16Year();

    /**
     * Checks whether the field "s16Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16Year()). Otherwise it will return false.
     */
    inline bool hasS16Year () const;

    /**
     * Returns the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * (if set as short year (e.g. 05 instead of 2005)
     * outgoing notifications will also give short year)
     *
     * @return The value of the field "s16Year"
     */
    inline int16 getS16Year () const;

    /**
     * Sets the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * (if set as short year (e.g. 05 instead of 2005)
     * outgoing notifications will also give short year)
     *
     * @param s16Year The value which will be set
     */
    inline void setS16Year (int16 s16Year_);

    // API of field "u8Month"

    static const int kU8Month = 1;

    /**
     * Clears the field "u8Month".
     *
     * The field will be set to its default value. The hasU8Month()
     * method will return false.
     */
    inline void clearU8Month();

    /**
     * Checks whether the field "u8Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Month()). Otherwise it will return false.
     */
    inline bool hasU8Month () const;

    /**
     * Returns the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @return The value of the field "u8Month"
     */
    inline uint8 getU8Month () const;

    /**
     * Sets the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @param u8Month The value which will be set
     */
    inline void setU8Month (uint8 u8Month_);

    // API of field "u8Day"

    static const int kU8Day = 2;

    /**
     * Clears the field "u8Day".
     *
     * The field will be set to its default value. The hasU8Day()
     * method will return false.
     */
    inline void clearU8Day();

    /**
     * Checks whether the field "u8Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Day()). Otherwise it will return false.
     */
    inline bool hasU8Day () const;

    /**
     * Returns the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @return The value of the field "u8Day"
     */
    inline uint8 getU8Day () const;

    /**
     * Sets the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @param u8Day The value which will be set
     */
    inline void setU8Day (uint8 u8Day_);

    // API of field "u8Hours"

    static const int kU8Hours = 3;

    /**
     * Clears the field "u8Hours".
     *
     * The field will be set to its default value. The hasU8Hours()
     * method will return false.
     */
    inline void clearU8Hours();

    /**
     * Checks whether the field "u8Hours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hours()). Otherwise it will return false.
     */
    inline bool hasU8Hours () const;

    /**
     * Returns the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat).
     *
     * @return The value of the field "u8Hours"
     */
    inline uint8 getU8Hours () const;

    /**
     * Sets the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat).
     *
     * @param u8Hours The value which will be set
     */
    inline void setU8Hours (uint8 u8Hours_);

    // API of field "u8Minutes"

    static const int kU8Minutes = 4;

    /**
     * Clears the field "u8Minutes".
     *
     * The field will be set to its default value. The hasU8Minutes()
     * method will return false.
     */
    inline void clearU8Minutes();

    /**
     * Checks whether the field "u8Minutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Minutes()). Otherwise it will return false.
     */
    inline bool hasU8Minutes () const;

    /**
     * Returns the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @return The value of the field "u8Minutes"
     */
    inline uint8 getU8Minutes () const;

    /**
     * Sets the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @param u8Minutes The value which will be set
     */
    inline void setU8Minutes (uint8 u8Minutes_);

    // API of field "u8Seconds"

    static const int kU8Seconds = 5;

    /**
     * Clears the field "u8Seconds".
     *
     * The field will be set to its default value. The hasU8Seconds()
     * method will return false.
     */
    inline void clearU8Seconds();

    /**
     * Checks whether the field "u8Seconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Seconds()). Otherwise it will return false.
     */
    inline bool hasU8Seconds () const;

    /**
     * Returns the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @return The value of the field "u8Seconds"
     */
    inline uint8 getU8Seconds () const;

    /**
     * Sets the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @param u8Seconds The value which will be set
     */
    inline void setU8Seconds (uint8 u8Seconds_);

    // API of field "u8Weekday"

    static const int kU8Weekday = 6;

    /**
     * Clears the field "u8Weekday".
     *
     * The field will be set to its default value. The hasU8Weekday()
     * method will return false.
     */
    inline void clearU8Weekday();

    /**
     * Checks whether the field "u8Weekday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Weekday()). Otherwise it will return false.
     */
    inline bool hasU8Weekday () const;

    /**
     * Returns the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @return The value of the field "u8Weekday"
     */
    inline uint8 getU8Weekday () const;

    /**
     * Sets the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @param u8Weekday The value which will be set
     */
    inline void setU8Weekday (uint8 u8Weekday_);

    // API of field "u8ChangeMask"

    static const int kU8ChangeMask = 7;

    /**
     * Clears the field "u8ChangeMask".
     *
     * The field will be set to its default value. The hasU8ChangeMask()
     * method will return false.
     */
    inline void clearU8ChangeMask();

    /**
     * Checks whether the field "u8ChangeMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ChangeMask()). Otherwise it will return false.
     */
    inline bool hasU8ChangeMask () const;

    /**
     * Returns the value of the member "u8ChangeMask".
     *
     * mask for fields to be updated;
     * any combination of "VDCLK_EN_..Change" values
     * from T_e8_VDCLK_TimeDateStatus
     *
     * @return The value of the field "u8ChangeMask"
     */
    inline uint8 getU8ChangeMask () const;

    /**
     * Sets the value of the member "u8ChangeMask".
     *
     * mask for fields to be updated;
     * any combination of "VDCLK_EN_..Change" values
     * from T_e8_VDCLK_TimeDateStatus
     *
     * @param u8ChangeMask The value which will be set
     */
    inline void setU8ChangeMask (uint8 u8ChangeMask_);

    static const LocalTimeDate_MinuteUpdateSet &getDefaultInstance();

private:

    inline void set_has_s16Year ();

    inline void clear_has_s16Year ();

    inline void set_has_u8Month ();

    inline void clear_has_u8Month ();

    inline void set_has_u8Day ();

    inline void clear_has_u8Day ();

    inline void set_has_u8Hours ();

    inline void clear_has_u8Hours ();

    inline void set_has_u8Minutes ();

    inline void clear_has_u8Minutes ();

    inline void set_has_u8Seconds ();

    inline void clear_has_u8Seconds ();

    inline void set_has_u8Weekday ();

    inline void clear_has_u8Weekday ();

    inline void set_has_u8ChangeMask ();

    inline void clear_has_u8ChangeMask ();

    uint32 _has_bits_[ (8 + 31) / 32];

    int16 _s16Year;

    uint8 _u8Month;

    uint8 _u8Day;

    uint8 _u8Hours;

    uint8 _u8Minutes;

    uint8 _u8Seconds;

    uint8 _u8Weekday;

    uint8 _u8ChangeMask;

};

/**
 * The status message of the property "Region_TimeZone"
 */
class Region_TimeZoneStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Region_TimeZoneStatus ();

    /**
     * Copy constructor
     */
    inline  Region_TimeZoneStatus (const Region_TimeZoneStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Region_TimeZoneStatus (::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Status_, const ::std::string& szDescription_);

    /**
     * Destructor
     */
    inline virtual  ~Region_TimeZoneStatus();

    /**
     * Assignment operator
     */
    inline Region_TimeZoneStatus& operator = (const Region_TimeZoneStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Region_TimeZoneStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Region_TimeZoneStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Region_TimeZoneStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Region_TimeZoneStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enTIMEZONE_Status"

    static const int kEnTIMEZONE_Status = 0;

    /**
     * Clears the field "enTIMEZONE_Status".
     *
     * The field will be set to its default value. The hasEnTIMEZONE_Status()
     * method will return false.
     */
    inline void clearEnTIMEZONE_Status();

    /**
     * Checks whether the field "enTIMEZONE_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnTIMEZONE_Status()). Otherwise it will return false.
     */
    inline bool hasEnTIMEZONE_Status () const;

    /**
     * Returns the value of the member "enTIMEZONE_Status".
     *
     * Index of current time zone
     *
     * @return The value of the field "enTIMEZONE_Status"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting getEnTIMEZONE_Status () const;

    /**
     * Sets the value of the member "enTIMEZONE_Status".
     *
     * Index of current time zone
     *
     * @param enTIMEZONE_Status The value which will be set
     */
    inline void setEnTIMEZONE_Status (::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Status_);

    // API of field "szDescription"

    static const int kSzDescription = 1;

    /**
     * Clears the field "szDescription".
     *
     * The field will be set to its default value. The hasSzDescription()
     * method will return false.
     */
    inline void clearSzDescription();

    /**
     * Checks whether the field "szDescription" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDescription()). Otherwise it will return false.
     */
    inline bool hasSzDescription () const;

    /**
     * Returns the value of the member "szDescription".
     *
     * current time zone
     *
     * @return The value of the field "szDescription"
     */
    inline const ::std::string& getSzDescription () const;

    /**
     * Retrieves the value of the field "szDescription" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDescription".
     */
    inline ::std::string& getSzDescriptionMutable ();

    /**
     * Sets the value of the member "szDescription".
     *
     * current time zone
     *
     * @param szDescription The value which will be set
     */
    inline void setSzDescription (const ::std::string& szDescription_);

    /**
     * Sets the value of the member "szDescription".
     *
     * current time zone
     *
     * @param szDescription The value which will be set
     */
    inline void setSzDescription (const char* szDescription_);

    /**
     * Sets the value of the member "szDescription".
     *
     * current time zone
     *
     * @param szDescription The value which will be set
     */
    inline void setSzDescription (const char* value, size_t size);

    static const Region_TimeZoneStatus &getDefaultInstance();

private:

    inline void set_has_enTIMEZONE_Status ();

    inline void clear_has_enTIMEZONE_Status ();

    inline void set_has_szDescription ();

    inline void clear_has_szDescription ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting _enTIMEZONE_Status;

    ::std::string _szDescription;

};

/**
 * The set message of the property "Region_TimeZone"
 */
class Region_TimeZoneSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Region_TimeZoneSet ();

    /**
     * Copy constructor
     */
    inline  Region_TimeZoneSet (const Region_TimeZoneSet &rhs);

    /**
     * All fields constructor
     */
    inline  Region_TimeZoneSet (::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Settings_);

    /**
     * Destructor
     */
    inline virtual  ~Region_TimeZoneSet();

    /**
     * Assignment operator
     */
    inline Region_TimeZoneSet& operator = (const Region_TimeZoneSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Region_TimeZoneSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Region_TimeZoneSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Region_TimeZoneSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Region_TimeZoneSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enTIMEZONE_Settings"

    static const int kEnTIMEZONE_Settings = 0;

    /**
     * Clears the field "enTIMEZONE_Settings".
     *
     * The field will be set to its default value. The hasEnTIMEZONE_Settings()
     * method will return false.
     */
    inline void clearEnTIMEZONE_Settings();

    /**
     * Checks whether the field "enTIMEZONE_Settings" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnTIMEZONE_Settings()). Otherwise it will return false.
     */
    inline bool hasEnTIMEZONE_Settings () const;

    /**
     * Returns the value of the member "enTIMEZONE_Settings".
     *
     * <p>use values obtained from method</p>
     * <p>GetAvailableTimeZones</p>
     *
     * @return The value of the field "enTIMEZONE_Settings"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting getEnTIMEZONE_Settings () const;

    /**
     * Sets the value of the member "enTIMEZONE_Settings".
     *
     * <p>use values obtained from method</p>
     * <p>GetAvailableTimeZones</p>
     *
     * @param enTIMEZONE_Settings The value which will be set
     */
    inline void setEnTIMEZONE_Settings (::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Settings_);

    static const Region_TimeZoneSet &getDefaultInstance();

private:

    inline void set_has_enTIMEZONE_Settings ();

    inline void clear_has_enTIMEZONE_Settings ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting _enTIMEZONE_Settings;

};

/**
 * The status message of the property "Auto_TimeZoneOffset"
 */
class Auto_TimeZoneOffsetStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Auto_TimeZoneOffsetStatus ();

    /**
     * Copy constructor
     */
    inline  Auto_TimeZoneOffsetStatus (const Auto_TimeZoneOffsetStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Auto_TimeZoneOffsetStatus (int8 s8Offset_Hour_, int8 s8Offset_Minute_);

    /**
     * Destructor
     */
    inline virtual  ~Auto_TimeZoneOffsetStatus();

    /**
     * Assignment operator
     */
    inline Auto_TimeZoneOffsetStatus& operator = (const Auto_TimeZoneOffsetStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Auto_TimeZoneOffsetStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Auto_TimeZoneOffsetStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Auto_TimeZoneOffsetStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Auto_TimeZoneOffsetStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s8Offset_Hour"

    static const int kS8Offset_Hour = 0;

    /**
     * Clears the field "s8Offset_Hour".
     *
     * The field will be set to its default value. The hasS8Offset_Hour()
     * method will return false.
     */
    inline void clearS8Offset_Hour();

    /**
     * Checks whether the field "s8Offset_Hour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8Offset_Hour()). Otherwise it will return false.
     */
    inline bool hasS8Offset_Hour () const;

    /**
     * Returns the value of the member "s8Offset_Hour".
     *
     * Provides the offsetseconds in number of hours. [-12to +12]
     *
     * @return The value of the field "s8Offset_Hour"
     */
    inline int8 getS8Offset_Hour () const;

    /**
     * Sets the value of the member "s8Offset_Hour".
     *
     * Provides the offsetseconds in number of hours. [-12to +12]
     *
     * @param s8Offset_Hour The value which will be set
     */
    inline void setS8Offset_Hour (int8 s8Offset_Hour_);

    // API of field "s8Offset_Minute"

    static const int kS8Offset_Minute = 1;

    /**
     * Clears the field "s8Offset_Minute".
     *
     * The field will be set to its default value. The hasS8Offset_Minute()
     * method will return false.
     */
    inline void clearS8Offset_Minute();

    /**
     * Checks whether the field "s8Offset_Minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8Offset_Minute()). Otherwise it will return false.
     */
    inline bool hasS8Offset_Minute () const;

    /**
     * Returns the value of the member "s8Offset_Minute".
     *
     * Provides the offsetseconds in number of minutes. [-59to +59]
     *
     * @return The value of the field "s8Offset_Minute"
     */
    inline int8 getS8Offset_Minute () const;

    /**
     * Sets the value of the member "s8Offset_Minute".
     *
     * Provides the offsetseconds in number of minutes. [-59to +59]
     *
     * @param s8Offset_Minute The value which will be set
     */
    inline void setS8Offset_Minute (int8 s8Offset_Minute_);

    static const Auto_TimeZoneOffsetStatus &getDefaultInstance();

private:

    inline void set_has_s8Offset_Hour ();

    inline void clear_has_s8Offset_Hour ();

    inline void set_has_s8Offset_Minute ();

    inline void clear_has_s8Offset_Minute ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int8 _s8Offset_Hour;

    int8 _s8Offset_Minute;

};

/**
 * The set message of the property "Auto_TimeZoneOffset"
 */
class Auto_TimeZoneOffsetSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Auto_TimeZoneOffsetSet ();

    /**
     * Copy constructor
     */
    inline  Auto_TimeZoneOffsetSet (const Auto_TimeZoneOffsetSet &rhs);

    /**
     * All fields constructor
     */
    inline  Auto_TimeZoneOffsetSet (int8 s8Offset_Hour_, int8 s8Offset_Minute_);

    /**
     * Destructor
     */
    inline virtual  ~Auto_TimeZoneOffsetSet();

    /**
     * Assignment operator
     */
    inline Auto_TimeZoneOffsetSet& operator = (const Auto_TimeZoneOffsetSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Auto_TimeZoneOffsetSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Auto_TimeZoneOffsetSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Auto_TimeZoneOffsetSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Auto_TimeZoneOffsetSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s8Offset_Hour"

    static const int kS8Offset_Hour = 0;

    /**
     * Clears the field "s8Offset_Hour".
     *
     * The field will be set to its default value. The hasS8Offset_Hour()
     * method will return false.
     */
    inline void clearS8Offset_Hour();

    /**
     * Checks whether the field "s8Offset_Hour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8Offset_Hour()). Otherwise it will return false.
     */
    inline bool hasS8Offset_Hour () const;

    /**
     * Returns the value of the member "s8Offset_Hour".
     *
     * Provides the offsetseconds in number of hours. [-12to +12]
     *
     * @return The value of the field "s8Offset_Hour"
     */
    inline int8 getS8Offset_Hour () const;

    /**
     * Sets the value of the member "s8Offset_Hour".
     *
     * Provides the offsetseconds in number of hours. [-12to +12]
     *
     * @param s8Offset_Hour The value which will be set
     */
    inline void setS8Offset_Hour (int8 s8Offset_Hour_);

    // API of field "s8Offset_Minute"

    static const int kS8Offset_Minute = 1;

    /**
     * Clears the field "s8Offset_Minute".
     *
     * The field will be set to its default value. The hasS8Offset_Minute()
     * method will return false.
     */
    inline void clearS8Offset_Minute();

    /**
     * Checks whether the field "s8Offset_Minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8Offset_Minute()). Otherwise it will return false.
     */
    inline bool hasS8Offset_Minute () const;

    /**
     * Returns the value of the member "s8Offset_Minute".
     *
     * Provides the offsetseconds in number of minutes. [-59to +59]
     *
     * @return The value of the field "s8Offset_Minute"
     */
    inline int8 getS8Offset_Minute () const;

    /**
     * Sets the value of the member "s8Offset_Minute".
     *
     * Provides the offsetseconds in number of minutes. [-59to +59]
     *
     * @param s8Offset_Minute The value which will be set
     */
    inline void setS8Offset_Minute (int8 s8Offset_Minute_);

    static const Auto_TimeZoneOffsetSet &getDefaultInstance();

private:

    inline void set_has_s8Offset_Hour ();

    inline void clear_has_s8Offset_Hour ();

    inline void set_has_s8Offset_Minute ();

    inline void clear_has_s8Offset_Minute ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int8 _s8Offset_Hour;

    int8 _s8Offset_Minute;

};

/**
 * The status message of the property "NewDateFormat"
 * switch between date formats (for use by HMI):
 * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
 */
class NewDateFormatStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NewDateFormatStatus ();

    /**
     * Copy constructor
     */
    inline  NewDateFormatStatus (const NewDateFormatStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NewDateFormatStatus (::clock_main_fi_types::VDCLK_TEN_NewDateFormat enDateFormat_);

    /**
     * Destructor
     */
    inline virtual  ~NewDateFormatStatus();

    /**
     * Assignment operator
     */
    inline NewDateFormatStatus& operator = (const NewDateFormatStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NewDateFormatStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NewDateFormatStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NewDateFormatStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NewDateFormatStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enDateFormat"

    static const int kEnDateFormat = 0;

    /**
     * Clears the field "enDateFormat".
     *
     * The field will be set to its default value. The hasEnDateFormat()
     * method will return false.
     */
    inline void clearEnDateFormat();

    /**
     * Checks whether the field "enDateFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDateFormat()). Otherwise it will return false.
     */
    inline bool hasEnDateFormat () const;

    /**
     * Returns the value of the member "enDateFormat".
     *
     *
     *
     * @return The value of the field "enDateFormat"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_NewDateFormat getEnDateFormat () const;

    /**
     * Sets the value of the member "enDateFormat".
     *
     *
     *
     * @param enDateFormat The value which will be set
     */
    inline void setEnDateFormat (::clock_main_fi_types::VDCLK_TEN_NewDateFormat enDateFormat_);

    static const NewDateFormatStatus &getDefaultInstance();

private:

    inline void set_has_enDateFormat ();

    inline void clear_has_enDateFormat ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_NewDateFormat _enDateFormat;

};

/**
 * The set message of the property "NewDateFormat"
 * switch between date formats (for use by HMI):
 * dd_mm_yyyy (default for europe), mm_dd_yyyy (default for North America) or yyyy_mm_dd (default for China)
 */
class NewDateFormatSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NewDateFormatSet ();

    /**
     * Copy constructor
     */
    inline  NewDateFormatSet (const NewDateFormatSet &rhs);

    /**
     * All fields constructor
     */
    inline  NewDateFormatSet (::clock_main_fi_types::VDCLK_TEN_NewDateFormat enDateFormat_);

    /**
     * Destructor
     */
    inline virtual  ~NewDateFormatSet();

    /**
     * Assignment operator
     */
    inline NewDateFormatSet& operator = (const NewDateFormatSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NewDateFormatSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NewDateFormatSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NewDateFormatSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NewDateFormatSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enDateFormat"

    static const int kEnDateFormat = 0;

    /**
     * Clears the field "enDateFormat".
     *
     * The field will be set to its default value. The hasEnDateFormat()
     * method will return false.
     */
    inline void clearEnDateFormat();

    /**
     * Checks whether the field "enDateFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDateFormat()). Otherwise it will return false.
     */
    inline bool hasEnDateFormat () const;

    /**
     * Returns the value of the member "enDateFormat".
     *
     *
     *
     * @return The value of the field "enDateFormat"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_NewDateFormat getEnDateFormat () const;

    /**
     * Sets the value of the member "enDateFormat".
     *
     *
     *
     * @param enDateFormat The value which will be set
     */
    inline void setEnDateFormat (::clock_main_fi_types::VDCLK_TEN_NewDateFormat enDateFormat_);

    static const NewDateFormatSet &getDefaultInstance();

private:

    inline void set_has_enDateFormat ();

    inline void clear_has_enDateFormat ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_NewDateFormat _enDateFormat;

};

/**
 * The status message of the property "Connection"
 * This property gives information about the connection status to the various MCAN units.
 */
class ConnectionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  ConnectionStatus (const ConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectionStatus (const ::clock_main_fi_types::T_SWC_UnitConnectionStatus& SWCUnitConnectionStatus_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectionStatus();

    /**
     * Assignment operator
     */
    inline ConnectionStatus& operator = (const ConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SWCUnitConnectionStatus"

    static const int kSWCUnitConnectionStatus = 0;

    /**
     * Clears the field "SWCUnitConnectionStatus".
     *
     * The field will be set to its default value. The hasSWCUnitConnectionStatus()
     * method will return false.
     */
    inline void clearSWCUnitConnectionStatus();

    /**
     * Checks whether the field "SWCUnitConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSWCUnitConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasSWCUnitConnectionStatus () const;

    /**
     * Returns the value of the member "SWCUnitConnectionStatus".
     *
     * If the meaning of "SWCUnitConnectionStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SWCUnitConnectionStatus"
     */
    inline const ::clock_main_fi_types::T_SWC_UnitConnectionStatus& getSWCUnitConnectionStatus () const;

    /**
     * Retrieves the value of the field "SWCUnitConnectionStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SWCUnitConnectionStatus".
     */
    inline ::clock_main_fi_types::T_SWC_UnitConnectionStatus& getSWCUnitConnectionStatusMutable ();

    /**
     * Sets the value of the member "SWCUnitConnectionStatus".
     *
     * If the meaning of "SWCUnitConnectionStatus" isn't clear, then there should be a description here.
     *
     * @param SWCUnitConnectionStatus The value which will be set
     */
    inline void setSWCUnitConnectionStatus (const ::clock_main_fi_types::T_SWC_UnitConnectionStatus& SWCUnitConnectionStatus_);

    static const ConnectionStatus &getDefaultInstance();

private:

    inline void set_has_SWCUnitConnectionStatus ();

    inline void clear_has_SWCUnitConnectionStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::T_SWC_UnitConnectionStatus _SWCUnitConnectionStatus;

};

/**
 * The status message of the property "TimeZone_DSTAvailability"
 * This property gives information about the availability of timezones and DST for specific regions.
 */
class TimeZone_DSTAvailabilityStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TimeZone_DSTAvailabilityStatus ();

    /**
     * Copy constructor
     */
    inline  TimeZone_DSTAvailabilityStatus (const TimeZone_DSTAvailabilityStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TimeZone_DSTAvailabilityStatus (bool bTimeZone_DSTAvailabilityForRegion_);

    /**
     * Destructor
     */
    inline virtual  ~TimeZone_DSTAvailabilityStatus();

    /**
     * Assignment operator
     */
    inline TimeZone_DSTAvailabilityStatus& operator = (const TimeZone_DSTAvailabilityStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TimeZone_DSTAvailabilityStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TimeZone_DSTAvailabilityStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TimeZone_DSTAvailabilityStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TimeZone_DSTAvailabilityStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bTimeZone_DSTAvailabilityForRegion"

    static const int kBTimeZone_DSTAvailabilityForRegion = 0;

    /**
     * Clears the field "bTimeZone_DSTAvailabilityForRegion".
     *
     * The field will be set to its default value. The hasBTimeZone_DSTAvailabilityForRegion()
     * method will return false.
     */
    inline void clearBTimeZone_DSTAvailabilityForRegion();

    /**
     * Checks whether the field "bTimeZone_DSTAvailabilityForRegion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTimeZone_DSTAvailabilityForRegion()). Otherwise it will return false.
     */
    inline bool hasBTimeZone_DSTAvailabilityForRegion () const;

    /**
     * Returns the value of the member "bTimeZone_DSTAvailabilityForRegion".
     *
     * If the meaning of "bTimeZone_DSTAvailabilityForRegion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bTimeZone_DSTAvailabilityForRegion"
     */
    inline bool getBTimeZone_DSTAvailabilityForRegion () const;

    /**
     * Sets the value of the member "bTimeZone_DSTAvailabilityForRegion".
     *
     * If the meaning of "bTimeZone_DSTAvailabilityForRegion" isn't clear, then there should be a description here.
     *
     * @param bTimeZone_DSTAvailabilityForRegion The value which will be set
     */
    inline void setBTimeZone_DSTAvailabilityForRegion (bool bTimeZone_DSTAvailabilityForRegion_);

    static const TimeZone_DSTAvailabilityStatus &getDefaultInstance();

private:

    inline void set_has_bTimeZone_DSTAvailabilityForRegion ();

    inline void clear_has_bTimeZone_DSTAvailabilityForRegion ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bTimeZone_DSTAvailabilityForRegion;

};

/**
 * The status message of the property "HardwareVersion"
 * This property gives information about the hardware version of the various MCAN units.
 */
class HardwareVersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HardwareVersionStatus ();

    /**
     * Copy constructor
     */
    inline  HardwareVersionStatus (const HardwareVersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  HardwareVersionStatus (const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& arHardwareVersionList_);

    /**
     * Destructor
     */
    inline virtual  ~HardwareVersionStatus();

    /**
     * Assignment operator
     */
    inline HardwareVersionStatus& operator = (const HardwareVersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HardwareVersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HardwareVersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HardwareVersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HardwareVersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arHardwareVersionList"

    static const int kArHardwareVersionList = 0;

    /**
     * Clears the field "arHardwareVersionList".
     *
     * The field will be set to its default value. The hasArHardwareVersionList()
     * method will return false.
     */
    inline void clearArHardwareVersionList();

    /**
     * Checks whether the field "arHardwareVersionList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArHardwareVersionList()). Otherwise it will return false.
     */
    inline bool hasArHardwareVersionList () const;

    /**
     * Returns the value of the member "arHardwareVersionList".
     *
     * List with hardware version of each MCAN unit.
     *
     * @return The value of the field "arHardwareVersionList"
     */
    inline const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& getArHardwareVersionList () const;

    /**
     * Retrieves the value of the field "arHardwareVersionList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arHardwareVersionList".
     */
    inline ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& getArHardwareVersionListMutable ();

    /**
     * Sets the value of the member "arHardwareVersionList".
     *
     * List with hardware version of each MCAN unit.
     *
     * @param arHardwareVersionList The value which will be set
     */
    inline void setArHardwareVersionList (const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& arHardwareVersionList_);

    static const HardwareVersionStatus &getDefaultInstance();

private:

    static const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& getT_VdClock_UnitVersionList_DefaultInstance ();

    inline void set_has_arHardwareVersionList ();

    inline void clear_has_arHardwareVersionList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion > _arHardwareVersionList;

};

/**
 * The status message of the property "SoftwareVersion"
 * This property gives information about the software version of the various MCAN units.
 */
class SoftwareVersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SoftwareVersionStatus ();

    /**
     * Copy constructor
     */
    inline  SoftwareVersionStatus (const SoftwareVersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SoftwareVersionStatus (const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& arSoftwareVersionList_);

    /**
     * Destructor
     */
    inline virtual  ~SoftwareVersionStatus();

    /**
     * Assignment operator
     */
    inline SoftwareVersionStatus& operator = (const SoftwareVersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SoftwareVersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SoftwareVersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SoftwareVersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SoftwareVersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arSoftwareVersionList"

    static const int kArSoftwareVersionList = 0;

    /**
     * Clears the field "arSoftwareVersionList".
     *
     * The field will be set to its default value. The hasArSoftwareVersionList()
     * method will return false.
     */
    inline void clearArSoftwareVersionList();

    /**
     * Checks whether the field "arSoftwareVersionList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArSoftwareVersionList()). Otherwise it will return false.
     */
    inline bool hasArSoftwareVersionList () const;

    /**
     * Returns the value of the member "arSoftwareVersionList".
     *
     * List with software version of each MCAN unit.
     *
     * @return The value of the field "arSoftwareVersionList"
     */
    inline const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& getArSoftwareVersionList () const;

    /**
     * Retrieves the value of the field "arSoftwareVersionList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arSoftwareVersionList".
     */
    inline ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& getArSoftwareVersionListMutable ();

    /**
     * Sets the value of the member "arSoftwareVersionList".
     *
     * List with software version of each MCAN unit.
     *
     * @param arSoftwareVersionList The value which will be set
     */
    inline void setArSoftwareVersionList (const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& arSoftwareVersionList_);

    static const SoftwareVersionStatus &getDefaultInstance();

private:

    static const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& getT_VdClock_UnitVersionList_DefaultInstance ();

    inline void set_has_arSoftwareVersionList ();

    inline void clear_has_arSoftwareVersionList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion > _arSoftwareVersionList;

};

/**
 * The status message of the property "DebugMode_TimeDate"
 * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
 * The client application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
class DebugMode_TimeDateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DebugMode_TimeDateStatus ();

    /**
     * Copy constructor
     */
    inline  DebugMode_TimeDateStatus (const DebugMode_TimeDateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DebugMode_TimeDateStatus (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_, bool bdebugMode_);

    /**
     * Destructor
     */
    inline virtual  ~DebugMode_TimeDateStatus();

    /**
     * Assignment operator
     */
    inline DebugMode_TimeDateStatus& operator = (const DebugMode_TimeDateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DebugMode_TimeDateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DebugMode_TimeDateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DebugMode_TimeDateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DebugMode_TimeDateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16Year"

    static const int kS16Year = 0;

    /**
     * Clears the field "s16Year".
     *
     * The field will be set to its default value. The hasS16Year()
     * method will return false.
     */
    inline void clearS16Year();

    /**
     * Checks whether the field "s16Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16Year()). Otherwise it will return false.
     */
    inline bool hasS16Year () const;

    /**
     * Returns the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * Note: dates before 1582 are treated as extrapolated gregorian;
     * no Julian calendar or so.
     *
     * @return The value of the field "s16Year"
     */
    inline int16 getS16Year () const;

    /**
     * Sets the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * Note: dates before 1582 are treated as extrapolated gregorian;
     * no Julian calendar or so.
     *
     * @param s16Year The value which will be set
     */
    inline void setS16Year (int16 s16Year_);

    // API of field "u8Month"

    static const int kU8Month = 1;

    /**
     * Clears the field "u8Month".
     *
     * The field will be set to its default value. The hasU8Month()
     * method will return false.
     */
    inline void clearU8Month();

    /**
     * Checks whether the field "u8Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Month()). Otherwise it will return false.
     */
    inline bool hasU8Month () const;

    /**
     * Returns the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @return The value of the field "u8Month"
     */
    inline uint8 getU8Month () const;

    /**
     * Sets the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @param u8Month The value which will be set
     */
    inline void setU8Month (uint8 u8Month_);

    // API of field "u8Day"

    static const int kU8Day = 2;

    /**
     * Clears the field "u8Day".
     *
     * The field will be set to its default value. The hasU8Day()
     * method will return false.
     */
    inline void clearU8Day();

    /**
     * Checks whether the field "u8Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Day()). Otherwise it will return false.
     */
    inline bool hasU8Day () const;

    /**
     * Returns the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @return The value of the field "u8Day"
     */
    inline uint8 getU8Day () const;

    /**
     * Sets the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @param u8Day The value which will be set
     */
    inline void setU8Day (uint8 u8Day_);

    // API of field "u8Hours"

    static const int kU8Hours = 3;

    /**
     * Clears the field "u8Hours".
     *
     * The field will be set to its default value. The hasU8Hours()
     * method will return false.
     */
    inline void clearU8Hours();

    /**
     * Checks whether the field "u8Hours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hours()). Otherwise it will return false.
     */
    inline bool hasU8Hours () const;

    /**
     * Returns the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat setting).
     *
     * @return The value of the field "u8Hours"
     */
    inline uint8 getU8Hours () const;

    /**
     * Sets the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat setting).
     *
     * @param u8Hours The value which will be set
     */
    inline void setU8Hours (uint8 u8Hours_);

    // API of field "u8Minutes"

    static const int kU8Minutes = 4;

    /**
     * Clears the field "u8Minutes".
     *
     * The field will be set to its default value. The hasU8Minutes()
     * method will return false.
     */
    inline void clearU8Minutes();

    /**
     * Checks whether the field "u8Minutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Minutes()). Otherwise it will return false.
     */
    inline bool hasU8Minutes () const;

    /**
     * Returns the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @return The value of the field "u8Minutes"
     */
    inline uint8 getU8Minutes () const;

    /**
     * Sets the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @param u8Minutes The value which will be set
     */
    inline void setU8Minutes (uint8 u8Minutes_);

    // API of field "u8Seconds"

    static const int kU8Seconds = 5;

    /**
     * Clears the field "u8Seconds".
     *
     * The field will be set to its default value. The hasU8Seconds()
     * method will return false.
     */
    inline void clearU8Seconds();

    /**
     * Checks whether the field "u8Seconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Seconds()). Otherwise it will return false.
     */
    inline bool hasU8Seconds () const;

    /**
     * Returns the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @return The value of the field "u8Seconds"
     */
    inline uint8 getU8Seconds () const;

    /**
     * Sets the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @param u8Seconds The value which will be set
     */
    inline void setU8Seconds (uint8 u8Seconds_);

    // API of field "u8Weekday"

    static const int kU8Weekday = 6;

    /**
     * Clears the field "u8Weekday".
     *
     * The field will be set to its default value. The hasU8Weekday()
     * method will return false.
     */
    inline void clearU8Weekday();

    /**
     * Checks whether the field "u8Weekday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Weekday()). Otherwise it will return false.
     */
    inline bool hasU8Weekday () const;

    /**
     * Returns the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @return The value of the field "u8Weekday"
     */
    inline uint8 getU8Weekday () const;

    /**
     * Sets the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @param u8Weekday The value which will be set
     */
    inline void setU8Weekday (uint8 u8Weekday_);

    // API of field "bdebugMode"

    static const int kBdebugMode = 7;

    /**
     * Clears the field "bdebugMode".
     *
     * The field will be set to its default value. The hasBdebugMode()
     * method will return false.
     */
    inline void clearBdebugMode();

    /**
     * Checks whether the field "bdebugMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBdebugMode()). Otherwise it will return false.
     */
    inline bool hasBdebugMode () const;

    /**
     * Returns the value of the member "bdebugMode".
     *
     * Bit field, containing
     * - validity information for time and date
     * - information, which fields have (to be) changed.
     * Valid: any combination of values from T_e8_VDCLK_TimeDateStatus
     *
     * @return The value of the field "bdebugMode"
     */
    inline bool getBdebugMode () const;

    /**
     * Sets the value of the member "bdebugMode".
     *
     * Bit field, containing
     * - validity information for time and date
     * - information, which fields have (to be) changed.
     * Valid: any combination of values from T_e8_VDCLK_TimeDateStatus
     *
     * @param bdebugMode The value which will be set
     */
    inline void setBdebugMode (bool bdebugMode_);

    static const DebugMode_TimeDateStatus &getDefaultInstance();

private:

    inline void set_has_s16Year ();

    inline void clear_has_s16Year ();

    inline void set_has_u8Month ();

    inline void clear_has_u8Month ();

    inline void set_has_u8Day ();

    inline void clear_has_u8Day ();

    inline void set_has_u8Hours ();

    inline void clear_has_u8Hours ();

    inline void set_has_u8Minutes ();

    inline void clear_has_u8Minutes ();

    inline void set_has_u8Seconds ();

    inline void clear_has_u8Seconds ();

    inline void set_has_u8Weekday ();

    inline void clear_has_u8Weekday ();

    inline void set_has_bdebugMode ();

    inline void clear_has_bdebugMode ();

    uint32 _has_bits_[ (8 + 31) / 32];

    int16 _s16Year;

    uint8 _u8Month;

    uint8 _u8Day;

    uint8 _u8Hours;

    uint8 _u8Minutes;

    uint8 _u8Seconds;

    uint8 _u8Weekday;

    bool _bdebugMode;

};

/**
 * The set message of the property "DebugMode_TimeDate"
 * Current date and time. This is updated every minute.  Use property LocalTimeDate for getting update every second.
 * The client application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
class DebugMode_TimeDateSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DebugMode_TimeDateSet ();

    /**
     * Copy constructor
     */
    inline  DebugMode_TimeDateSet (const DebugMode_TimeDateSet &rhs);

    /**
     * All fields constructor
     */
    inline  DebugMode_TimeDateSet (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_, bool bdebugMode_, uint8 u8ChangeMask_);

    /**
     * Destructor
     */
    inline virtual  ~DebugMode_TimeDateSet();

    /**
     * Assignment operator
     */
    inline DebugMode_TimeDateSet& operator = (const DebugMode_TimeDateSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DebugMode_TimeDateSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DebugMode_TimeDateSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DebugMode_TimeDateSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DebugMode_TimeDateSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16Year"

    static const int kS16Year = 0;

    /**
     * Clears the field "s16Year".
     *
     * The field will be set to its default value. The hasS16Year()
     * method will return false.
     */
    inline void clearS16Year();

    /**
     * Checks whether the field "s16Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16Year()). Otherwise it will return false.
     */
    inline bool hasS16Year () const;

    /**
     * Returns the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * (if set as short year (e.g. 05 instead of 2005)
     * outgoing notifications will also give short year)
     *
     * @return The value of the field "s16Year"
     */
    inline int16 getS16Year () const;

    /**
     * Sets the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * (if set as short year (e.g. 05 instead of 2005)
     * outgoing notifications will also give short year)
     *
     * @param s16Year The value which will be set
     */
    inline void setS16Year (int16 s16Year_);

    // API of field "u8Month"

    static const int kU8Month = 1;

    /**
     * Clears the field "u8Month".
     *
     * The field will be set to its default value. The hasU8Month()
     * method will return false.
     */
    inline void clearU8Month();

    /**
     * Checks whether the field "u8Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Month()). Otherwise it will return false.
     */
    inline bool hasU8Month () const;

    /**
     * Returns the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @return The value of the field "u8Month"
     */
    inline uint8 getU8Month () const;

    /**
     * Sets the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @param u8Month The value which will be set
     */
    inline void setU8Month (uint8 u8Month_);

    // API of field "u8Day"

    static const int kU8Day = 2;

    /**
     * Clears the field "u8Day".
     *
     * The field will be set to its default value. The hasU8Day()
     * method will return false.
     */
    inline void clearU8Day();

    /**
     * Checks whether the field "u8Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Day()). Otherwise it will return false.
     */
    inline bool hasU8Day () const;

    /**
     * Returns the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @return The value of the field "u8Day"
     */
    inline uint8 getU8Day () const;

    /**
     * Sets the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @param u8Day The value which will be set
     */
    inline void setU8Day (uint8 u8Day_);

    // API of field "u8Hours"

    static const int kU8Hours = 3;

    /**
     * Clears the field "u8Hours".
     *
     * The field will be set to its default value. The hasU8Hours()
     * method will return false.
     */
    inline void clearU8Hours();

    /**
     * Checks whether the field "u8Hours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hours()). Otherwise it will return false.
     */
    inline bool hasU8Hours () const;

    /**
     * Returns the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat).
     *
     * @return The value of the field "u8Hours"
     */
    inline uint8 getU8Hours () const;

    /**
     * Sets the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat).
     *
     * @param u8Hours The value which will be set
     */
    inline void setU8Hours (uint8 u8Hours_);

    // API of field "u8Minutes"

    static const int kU8Minutes = 4;

    /**
     * Clears the field "u8Minutes".
     *
     * The field will be set to its default value. The hasU8Minutes()
     * method will return false.
     */
    inline void clearU8Minutes();

    /**
     * Checks whether the field "u8Minutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Minutes()). Otherwise it will return false.
     */
    inline bool hasU8Minutes () const;

    /**
     * Returns the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @return The value of the field "u8Minutes"
     */
    inline uint8 getU8Minutes () const;

    /**
     * Sets the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @param u8Minutes The value which will be set
     */
    inline void setU8Minutes (uint8 u8Minutes_);

    // API of field "u8Seconds"

    static const int kU8Seconds = 5;

    /**
     * Clears the field "u8Seconds".
     *
     * The field will be set to its default value. The hasU8Seconds()
     * method will return false.
     */
    inline void clearU8Seconds();

    /**
     * Checks whether the field "u8Seconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Seconds()). Otherwise it will return false.
     */
    inline bool hasU8Seconds () const;

    /**
     * Returns the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @return The value of the field "u8Seconds"
     */
    inline uint8 getU8Seconds () const;

    /**
     * Sets the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @param u8Seconds The value which will be set
     */
    inline void setU8Seconds (uint8 u8Seconds_);

    // API of field "u8Weekday"

    static const int kU8Weekday = 6;

    /**
     * Clears the field "u8Weekday".
     *
     * The field will be set to its default value. The hasU8Weekday()
     * method will return false.
     */
    inline void clearU8Weekday();

    /**
     * Checks whether the field "u8Weekday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Weekday()). Otherwise it will return false.
     */
    inline bool hasU8Weekday () const;

    /**
     * Returns the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @return The value of the field "u8Weekday"
     */
    inline uint8 getU8Weekday () const;

    /**
     * Sets the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @param u8Weekday The value which will be set
     */
    inline void setU8Weekday (uint8 u8Weekday_);

    // API of field "bdebugMode"

    static const int kBdebugMode = 7;

    /**
     * Clears the field "bdebugMode".
     *
     * The field will be set to its default value. The hasBdebugMode()
     * method will return false.
     */
    inline void clearBdebugMode();

    /**
     * Checks whether the field "bdebugMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBdebugMode()). Otherwise it will return false.
     */
    inline bool hasBdebugMode () const;

    /**
     * Returns the value of the member "bdebugMode".
     *
     * The weekday fraction [1-7] of time.
     *
     * @return The value of the field "bdebugMode"
     */
    inline bool getBdebugMode () const;

    /**
     * Sets the value of the member "bdebugMode".
     *
     * The weekday fraction [1-7] of time.
     *
     * @param bdebugMode The value which will be set
     */
    inline void setBdebugMode (bool bdebugMode_);

    // API of field "u8ChangeMask"

    static const int kU8ChangeMask = 8;

    /**
     * Clears the field "u8ChangeMask".
     *
     * The field will be set to its default value. The hasU8ChangeMask()
     * method will return false.
     */
    inline void clearU8ChangeMask();

    /**
     * Checks whether the field "u8ChangeMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ChangeMask()). Otherwise it will return false.
     */
    inline bool hasU8ChangeMask () const;

    /**
     * Returns the value of the member "u8ChangeMask".
     *
     * mask for fields to be updated;
     * any combination of "VDCLK_EN_..Change" values
     * from T_e8_VDCLK_TimeDateStatus
     *
     * @return The value of the field "u8ChangeMask"
     */
    inline uint8 getU8ChangeMask () const;

    /**
     * Sets the value of the member "u8ChangeMask".
     *
     * mask for fields to be updated;
     * any combination of "VDCLK_EN_..Change" values
     * from T_e8_VDCLK_TimeDateStatus
     *
     * @param u8ChangeMask The value which will be set
     */
    inline void setU8ChangeMask (uint8 u8ChangeMask_);

    static const DebugMode_TimeDateSet &getDefaultInstance();

private:

    inline void set_has_s16Year ();

    inline void clear_has_s16Year ();

    inline void set_has_u8Month ();

    inline void clear_has_u8Month ();

    inline void set_has_u8Day ();

    inline void clear_has_u8Day ();

    inline void set_has_u8Hours ();

    inline void clear_has_u8Hours ();

    inline void set_has_u8Minutes ();

    inline void clear_has_u8Minutes ();

    inline void set_has_u8Seconds ();

    inline void clear_has_u8Seconds ();

    inline void set_has_u8Weekday ();

    inline void clear_has_u8Weekday ();

    inline void set_has_bdebugMode ();

    inline void clear_has_bdebugMode ();

    inline void set_has_u8ChangeMask ();

    inline void clear_has_u8ChangeMask ();

    uint32 _has_bits_[ (9 + 31) / 32];

    int16 _s16Year;

    uint8 _u8Month;

    uint8 _u8Day;

    uint8 _u8Hours;

    uint8 _u8Minutes;

    uint8 _u8Seconds;

    uint8 _u8Weekday;

    bool _bdebugMode;

    uint8 _u8ChangeMask;

};

/**
 * The status message of the property "UTC_TimeDateUpdate"
 * Current date and time. This is updated every second.
 * The client application should use the following parameters:
 * FUNCID    = VDCLK_C_U16_FKTID_ ... ,
 * SERVICEID = CCA_C_U16_SRV_CLOCK,
 * APPID     = CCA_C_U16_APP_VD_CLOCK,
 * TARGETID    = CCA_C_U16_APP_UI
 */
class UTC_TimeDateUpdateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UTC_TimeDateUpdateStatus ();

    /**
     * Copy constructor
     */
    inline  UTC_TimeDateUpdateStatus (const UTC_TimeDateUpdateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  UTC_TimeDateUpdateStatus (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_, bool bTimeValidity_);

    /**
     * Destructor
     */
    inline virtual  ~UTC_TimeDateUpdateStatus();

    /**
     * Assignment operator
     */
    inline UTC_TimeDateUpdateStatus& operator = (const UTC_TimeDateUpdateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UTC_TimeDateUpdateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UTC_TimeDateUpdateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UTC_TimeDateUpdateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UTC_TimeDateUpdateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16Year"

    static const int kS16Year = 0;

    /**
     * Clears the field "s16Year".
     *
     * The field will be set to its default value. The hasS16Year()
     * method will return false.
     */
    inline void clearS16Year();

    /**
     * Checks whether the field "s16Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16Year()). Otherwise it will return false.
     */
    inline bool hasS16Year () const;

    /**
     * Returns the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * Note: dates before 1582 are treated as extrapolated gregorian;
     * no Julian calendar or so.
     *
     * @return The value of the field "s16Year"
     */
    inline int16 getS16Year () const;

    /**
     * Sets the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * Note: dates before 1582 are treated as extrapolated gregorian;
     * no Julian calendar or so.
     *
     * @param s16Year The value which will be set
     */
    inline void setS16Year (int16 s16Year_);

    // API of field "u8Month"

    static const int kU8Month = 1;

    /**
     * Clears the field "u8Month".
     *
     * The field will be set to its default value. The hasU8Month()
     * method will return false.
     */
    inline void clearU8Month();

    /**
     * Checks whether the field "u8Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Month()). Otherwise it will return false.
     */
    inline bool hasU8Month () const;

    /**
     * Returns the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @return The value of the field "u8Month"
     */
    inline uint8 getU8Month () const;

    /**
     * Sets the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @param u8Month The value which will be set
     */
    inline void setU8Month (uint8 u8Month_);

    // API of field "u8Day"

    static const int kU8Day = 2;

    /**
     * Clears the field "u8Day".
     *
     * The field will be set to its default value. The hasU8Day()
     * method will return false.
     */
    inline void clearU8Day();

    /**
     * Checks whether the field "u8Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Day()). Otherwise it will return false.
     */
    inline bool hasU8Day () const;

    /**
     * Returns the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @return The value of the field "u8Day"
     */
    inline uint8 getU8Day () const;

    /**
     * Sets the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date.
     *
     * @param u8Day The value which will be set
     */
    inline void setU8Day (uint8 u8Day_);

    // API of field "u8Hours"

    static const int kU8Hours = 3;

    /**
     * Clears the field "u8Hours".
     *
     * The field will be set to its default value. The hasU8Hours()
     * method will return false.
     */
    inline void clearU8Hours();

    /**
     * Checks whether the field "u8Hours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hours()). Otherwise it will return false.
     */
    inline bool hasU8Hours () const;

    /**
     * Returns the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat setting).
     *
     * @return The value of the field "u8Hours"
     */
    inline uint8 getU8Hours () const;

    /**
     * Sets the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time (24h format; independent of TimeFormat setting).
     *
     * @param u8Hours The value which will be set
     */
    inline void setU8Hours (uint8 u8Hours_);

    // API of field "u8Minutes"

    static const int kU8Minutes = 4;

    /**
     * Clears the field "u8Minutes".
     *
     * The field will be set to its default value. The hasU8Minutes()
     * method will return false.
     */
    inline void clearU8Minutes();

    /**
     * Checks whether the field "u8Minutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Minutes()). Otherwise it will return false.
     */
    inline bool hasU8Minutes () const;

    /**
     * Returns the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @return The value of the field "u8Minutes"
     */
    inline uint8 getU8Minutes () const;

    /**
     * Sets the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @param u8Minutes The value which will be set
     */
    inline void setU8Minutes (uint8 u8Minutes_);

    // API of field "u8Seconds"

    static const int kU8Seconds = 5;

    /**
     * Clears the field "u8Seconds".
     *
     * The field will be set to its default value. The hasU8Seconds()
     * method will return false.
     */
    inline void clearU8Seconds();

    /**
     * Checks whether the field "u8Seconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Seconds()). Otherwise it will return false.
     */
    inline bool hasU8Seconds () const;

    /**
     * Returns the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @return The value of the field "u8Seconds"
     */
    inline uint8 getU8Seconds () const;

    /**
     * Sets the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @param u8Seconds The value which will be set
     */
    inline void setU8Seconds (uint8 u8Seconds_);

    // API of field "u8Weekday"

    static const int kU8Weekday = 6;

    /**
     * Clears the field "u8Weekday".
     *
     * The field will be set to its default value. The hasU8Weekday()
     * method will return false.
     */
    inline void clearU8Weekday();

    /**
     * Checks whether the field "u8Weekday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Weekday()). Otherwise it will return false.
     */
    inline bool hasU8Weekday () const;

    /**
     * Returns the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @return The value of the field "u8Weekday"
     */
    inline uint8 getU8Weekday () const;

    /**
     * Sets the value of the member "u8Weekday".
     *
     * The weekday fraction [1-7] of time.
     *
     * @param u8Weekday The value which will be set
     */
    inline void setU8Weekday (uint8 u8Weekday_);

    // API of field "bTimeValidity"

    static const int kBTimeValidity = 7;

    /**
     * Clears the field "bTimeValidity".
     *
     * The field will be set to its default value. The hasBTimeValidity()
     * method will return false.
     */
    inline void clearBTimeValidity();

    /**
     * Checks whether the field "bTimeValidity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTimeValidity()). Otherwise it will return false.
     */
    inline bool hasBTimeValidity () const;

    /**
     * Returns the value of the member "bTimeValidity".
     *
     * Bit field, containing
     * - validity information for time and date
     * - information, which fields have (to be) changed.
     * Valid: any combination of values from T_e8_VDCLK_TimeDateStatus
     *
     * @return The value of the field "bTimeValidity"
     */
    inline bool getBTimeValidity () const;

    /**
     * Sets the value of the member "bTimeValidity".
     *
     * Bit field, containing
     * - validity information for time and date
     * - information, which fields have (to be) changed.
     * Valid: any combination of values from T_e8_VDCLK_TimeDateStatus
     *
     * @param bTimeValidity The value which will be set
     */
    inline void setBTimeValidity (bool bTimeValidity_);

    static const UTC_TimeDateUpdateStatus &getDefaultInstance();

private:

    inline void set_has_s16Year ();

    inline void clear_has_s16Year ();

    inline void set_has_u8Month ();

    inline void clear_has_u8Month ();

    inline void set_has_u8Day ();

    inline void clear_has_u8Day ();

    inline void set_has_u8Hours ();

    inline void clear_has_u8Hours ();

    inline void set_has_u8Minutes ();

    inline void clear_has_u8Minutes ();

    inline void set_has_u8Seconds ();

    inline void clear_has_u8Seconds ();

    inline void set_has_u8Weekday ();

    inline void clear_has_u8Weekday ();

    inline void set_has_bTimeValidity ();

    inline void clear_has_bTimeValidity ();

    uint32 _has_bits_[ (8 + 31) / 32];

    int16 _s16Year;

    uint8 _u8Month;

    uint8 _u8Day;

    uint8 _u8Hours;

    uint8 _u8Minutes;

    uint8 _u8Seconds;

    uint8 _u8Weekday;

    bool _bTimeValidity;

};

/**
 * The status message of the property "HUD_Activation"
 * <p>Property, indicating (or modifying), HUD activation</p>
 * <p>(summer time) is On or Off</p>
 */
class HUD_ActivationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HUD_ActivationStatus ();

    /**
     * Copy constructor
     */
    inline  HUD_ActivationStatus (const HUD_ActivationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  HUD_ActivationStatus (bool bHUD_Status_);

    /**
     * Destructor
     */
    inline virtual  ~HUD_ActivationStatus();

    /**
     * Assignment operator
     */
    inline HUD_ActivationStatus& operator = (const HUD_ActivationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HUD_ActivationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HUD_ActivationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HUD_ActivationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HUD_ActivationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bHUD_Status"

    static const int kBHUD_Status = 0;

    /**
     * Clears the field "bHUD_Status".
     *
     * The field will be set to its default value. The hasBHUD_Status()
     * method will return false.
     */
    inline void clearBHUD_Status();

    /**
     * Checks whether the field "bHUD_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBHUD_Status()). Otherwise it will return false.
     */
    inline bool hasBHUD_Status () const;

    /**
     * Returns the value of the member "bHUD_Status".
     *
     * Flag, indicating whether HUD is On or Off
     *
     * @return The value of the field "bHUD_Status"
     */
    inline bool getBHUD_Status () const;

    /**
     * Sets the value of the member "bHUD_Status".
     *
     * Flag, indicating whether HUD is On or Off
     *
     * @param bHUD_Status The value which will be set
     */
    inline void setBHUD_Status (bool bHUD_Status_);

    static const HUD_ActivationStatus &getDefaultInstance();

private:

    inline void set_has_bHUD_Status ();

    inline void clear_has_bHUD_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bHUD_Status;

};

/**
 * The set message of the property "HUD_Activation"
 * <p>Property, indicating (or modifying), HUD activation</p>
 * <p>(summer time) is On or Off</p>
 * Set HUD on/off
 */
class HUD_ActivationSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HUD_ActivationSet ();

    /**
     * Copy constructor
     */
    inline  HUD_ActivationSet (const HUD_ActivationSet &rhs);

    /**
     * All fields constructor
     */
    inline  HUD_ActivationSet (::clock_main_fi_types::VDCLK_TEN_HUD_ActivationSettings enHUD_Setting_);

    /**
     * Destructor
     */
    inline virtual  ~HUD_ActivationSet();

    /**
     * Assignment operator
     */
    inline HUD_ActivationSet& operator = (const HUD_ActivationSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HUD_ActivationSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HUD_ActivationSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HUD_ActivationSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HUD_ActivationSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enHUD_Setting"

    static const int kEnHUD_Setting = 0;

    /**
     * Clears the field "enHUD_Setting".
     *
     * The field will be set to its default value. The hasEnHUD_Setting()
     * method will return false.
     */
    inline void clearEnHUD_Setting();

    /**
     * Checks whether the field "enHUD_Setting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnHUD_Setting()). Otherwise it will return false.
     */
    inline bool hasEnHUD_Setting () const;

    /**
     * Returns the value of the member "enHUD_Setting".
     *
     * <p></p>
     *
     * @return The value of the field "enHUD_Setting"
     */
    inline ::clock_main_fi_types::VDCLK_TEN_HUD_ActivationSettings getEnHUD_Setting () const;

    /**
     * Sets the value of the member "enHUD_Setting".
     *
     * <p></p>
     *
     * @param enHUD_Setting The value which will be set
     */
    inline void setEnHUD_Setting (::clock_main_fi_types::VDCLK_TEN_HUD_ActivationSettings enHUD_Setting_);

    static const HUD_ActivationSet &getDefaultInstance();

private:

    inline void set_has_enHUD_Setting ();

    inline void clear_has_enHUD_Setting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::clock_main_fi_types::VDCLK_TEN_HUD_ActivationSettings _enHUD_Setting;

};

/**
 * The status message of the property "HUD_Postition"
 */
class HUD_PostitionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HUD_PostitionStatus ();

    /**
     * Copy constructor
     */
    inline  HUD_PostitionStatus (const HUD_PostitionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  HUD_PostitionStatus (uint8 u8Up_Position_, uint8 u8Down_Position_);

    /**
     * Destructor
     */
    inline virtual  ~HUD_PostitionStatus();

    /**
     * Assignment operator
     */
    inline HUD_PostitionStatus& operator = (const HUD_PostitionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HUD_PostitionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HUD_PostitionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HUD_PostitionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HUD_PostitionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Up_Position"

    static const int kU8Up_Position = 0;

    /**
     * Clears the field "u8Up_Position".
     *
     * The field will be set to its default value. The hasU8Up_Position()
     * method will return false.
     */
    inline void clearU8Up_Position();

    /**
     * Checks whether the field "u8Up_Position" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Up_Position()). Otherwise it will return false.
     */
    inline bool hasU8Up_Position () const;

    /**
     * Returns the value of the member "u8Up_Position".
     *
     * Provides the scalar value of the position of HUD in the upward movement
     *
     * @return The value of the field "u8Up_Position"
     */
    inline uint8 getU8Up_Position () const;

    /**
     * Sets the value of the member "u8Up_Position".
     *
     * Provides the scalar value of the position of HUD in the upward movement
     *
     * @param u8Up_Position The value which will be set
     */
    inline void setU8Up_Position (uint8 u8Up_Position_);

    // API of field "u8Down_Position"

    static const int kU8Down_Position = 1;

    /**
     * Clears the field "u8Down_Position".
     *
     * The field will be set to its default value. The hasU8Down_Position()
     * method will return false.
     */
    inline void clearU8Down_Position();

    /**
     * Checks whether the field "u8Down_Position" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Down_Position()). Otherwise it will return false.
     */
    inline bool hasU8Down_Position () const;

    /**
     * Returns the value of the member "u8Down_Position".
     *
     * Provides the scalar value of the position of HUD in the downward movement
     *
     * @return The value of the field "u8Down_Position"
     */
    inline uint8 getU8Down_Position () const;

    /**
     * Sets the value of the member "u8Down_Position".
     *
     * Provides the scalar value of the position of HUD in the downward movement
     *
     * @param u8Down_Position The value which will be set
     */
    inline void setU8Down_Position (uint8 u8Down_Position_);

    static const HUD_PostitionStatus &getDefaultInstance();

private:

    inline void set_has_u8Up_Position ();

    inline void clear_has_u8Up_Position ();

    inline void set_has_u8Down_Position ();

    inline void clear_has_u8Down_Position ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8Up_Position;

    uint8 _u8Down_Position;

};

/**
 * The set message of the property "HUD_Postition"
 */
class HUD_PostitionSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HUD_PostitionSet ();

    /**
     * Copy constructor
     */
    inline  HUD_PostitionSet (const HUD_PostitionSet &rhs);

    /**
     * All fields constructor
     */
    inline  HUD_PostitionSet (uint8 u8Up_Position_, uint8 u8Down_Position_);

    /**
     * Destructor
     */
    inline virtual  ~HUD_PostitionSet();

    /**
     * Assignment operator
     */
    inline HUD_PostitionSet& operator = (const HUD_PostitionSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HUD_PostitionSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HUD_PostitionSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HUD_PostitionSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HUD_PostitionSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Up_Position"

    static const int kU8Up_Position = 0;

    /**
     * Clears the field "u8Up_Position".
     *
     * The field will be set to its default value. The hasU8Up_Position()
     * method will return false.
     */
    inline void clearU8Up_Position();

    /**
     * Checks whether the field "u8Up_Position" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Up_Position()). Otherwise it will return false.
     */
    inline bool hasU8Up_Position () const;

    /**
     * Returns the value of the member "u8Up_Position".
     *
     * Sets scalar value of the position of HUD in the upward movement
     *
     * @return The value of the field "u8Up_Position"
     */
    inline uint8 getU8Up_Position () const;

    /**
     * Sets the value of the member "u8Up_Position".
     *
     * Sets scalar value of the position of HUD in the upward movement
     *
     * @param u8Up_Position The value which will be set
     */
    inline void setU8Up_Position (uint8 u8Up_Position_);

    // API of field "u8Down_Position"

    static const int kU8Down_Position = 1;

    /**
     * Clears the field "u8Down_Position".
     *
     * The field will be set to its default value. The hasU8Down_Position()
     * method will return false.
     */
    inline void clearU8Down_Position();

    /**
     * Checks whether the field "u8Down_Position" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Down_Position()). Otherwise it will return false.
     */
    inline bool hasU8Down_Position () const;

    /**
     * Returns the value of the member "u8Down_Position".
     *
     * Sets scalar value of the position of HUD in the downward movement
     *
     * @return The value of the field "u8Down_Position"
     */
    inline uint8 getU8Down_Position () const;

    /**
     * Sets the value of the member "u8Down_Position".
     *
     * Sets scalar value of the position of HUD in the downward movement
     *
     * @param u8Down_Position The value which will be set
     */
    inline void setU8Down_Position (uint8 u8Down_Position_);

    static const HUD_PostitionSet &getDefaultInstance();

private:

    inline void set_has_u8Up_Position ();

    inline void clear_has_u8Up_Position ();

    inline void set_has_u8Down_Position ();

    inline void clear_has_u8Down_Position ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8Up_Position;

    uint8 _u8Down_Position;

};

/**
 * The result message of the method "GetAvailableTimeZones"
 * Returns a list of available time zones for a given region
 */
class GetAvailableTimeZonesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAvailableTimeZonesResult ();

    /**
     * Copy constructor
     */
    inline  GetAvailableTimeZonesResult (const GetAvailableTimeZonesResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetAvailableTimeZonesResult (const ::std::vector< ::std::string >& aszDescriptions_, const ::std::vector< uint16 >& u16Indexes_);

    /**
     * Destructor
     */
    inline virtual  ~GetAvailableTimeZonesResult();

    /**
     * Assignment operator
     */
    inline GetAvailableTimeZonesResult& operator = (const GetAvailableTimeZonesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAvailableTimeZonesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAvailableTimeZonesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAvailableTimeZonesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAvailableTimeZonesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "aszDescriptions"

    static const int kAszDescriptions = 0;

    /**
     * Clears the field "aszDescriptions".
     *
     * The field will be set to its default value. The hasAszDescriptions()
     * method will return false.
     */
    inline void clearAszDescriptions();

    /**
     * Checks whether the field "aszDescriptions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAszDescriptions()). Otherwise it will return false.
     */
    inline bool hasAszDescriptions () const;

    /**
     * Returns the value of the member "aszDescriptions".
     *
     * <p>list of time zone descriptions.</p>
     * <p>Format: shh:mm location1, location2</p>
     * <p>s = sign,</p>
     * <p>hh = hours of offset to UTC</p>
     * <p>mm = minutes of offset to UTC</p>
     *
     * @return The value of the field "aszDescriptions"
     */
    inline const ::std::vector< ::std::string >& getAszDescriptions () const;

    /**
     * Retrieves the value of the field "aszDescriptions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "aszDescriptions".
     */
    inline ::std::vector< ::std::string >& getAszDescriptionsMutable ();

    /**
     * Sets the value of the member "aszDescriptions".
     *
     * <p>list of time zone descriptions.</p>
     * <p>Format: shh:mm location1, location2</p>
     * <p>s = sign,</p>
     * <p>hh = hours of offset to UTC</p>
     * <p>mm = minutes of offset to UTC</p>
     *
     * @param aszDescriptions The value which will be set
     */
    inline void setAszDescriptions (const ::std::vector< ::std::string >& aszDescriptions_);

    // API of field "u16Indexes"

    static const int kU16Indexes = 1;

    /**
     * Clears the field "u16Indexes".
     *
     * The field will be set to its default value. The hasU16Indexes()
     * method will return false.
     */
    inline void clearU16Indexes();

    /**
     * Checks whether the field "u16Indexes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Indexes()). Otherwise it will return false.
     */
    inline bool hasU16Indexes () const;

    /**
     * Returns the value of the member "u16Indexes".
     *
     * <p>list of indexes corresponding to TimeZoneList elements</p>
     *
     * @return The value of the field "u16Indexes"
     */
    inline const ::std::vector< uint16 >& getU16Indexes () const;

    /**
     * Retrieves the value of the field "u16Indexes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "u16Indexes".
     */
    inline ::std::vector< uint16 >& getU16IndexesMutable ();

    /**
     * Sets the value of the member "u16Indexes".
     *
     * <p>list of indexes corresponding to TimeZoneList elements</p>
     *
     * @param u16Indexes The value which will be set
     */
    inline void setU16Indexes (const ::std::vector< uint16 >& u16Indexes_);

    static const GetAvailableTimeZonesResult &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_aszDescriptions ();

    inline void clear_has_aszDescriptions ();

    inline void set_has_u16Indexes ();

    inline void clear_has_u16Indexes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ::std::string > _aszDescriptions;

    ::std::vector< uint16 > _u16Indexes;

};

/**
 * The start message of the method "GetTimeDateFromValue"
 * utility to transform a scalar date/time value
 * (seconds elapsed since begin of century)
 * into date and time fields (year, month, day, hours, minutes, seconds and weekday of current date)
 * (to be used e. g. to calculate estimated time of arrival).
 */
class GetTimeDateFromValueStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTimeDateFromValueStart ();

    /**
     * Copy constructor
     */
    inline  GetTimeDateFromValueStart (const GetTimeDateFromValueStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetTimeDateFromValueStart (uint32 u32TimeDateValue_, uint8 u8SourceDomain_, uint8 u8TargetDomain_);

    /**
     * Destructor
     */
    inline virtual  ~GetTimeDateFromValueStart();

    /**
     * Assignment operator
     */
    inline GetTimeDateFromValueStart& operator = (const GetTimeDateFromValueStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTimeDateFromValueStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTimeDateFromValueStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTimeDateFromValueStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTimeDateFromValueStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32TimeDateValue"

    static const int kU32TimeDateValue = 0;

    /**
     * Clears the field "u32TimeDateValue".
     *
     * The field will be set to its default value. The hasU32TimeDateValue()
     * method will return false.
     */
    inline void clearU32TimeDateValue();

    /**
     * Checks whether the field "u32TimeDateValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TimeDateValue()). Otherwise it will return false.
     */
    inline bool hasU32TimeDateValue () const;

    /**
     * Returns the value of the member "u32TimeDateValue".
     *
     * seconds elapsed since begin of century
     * valid:
     * 00000000h ... BC19137Fh (normal), spanning 100 years, beginnng 2000-1-1, 0:00
     * BC191380h ... CEE90B00h (overflow), spanning first decade of 2100 century
     * ED33FD00h ... FFFFFFFFh (underflow), interpreted negative, spanning last decade of 1900 century
     * invalid due to ambivalence:
     * CEE90B01h ... ED33FCFFh
     *
     * @return The value of the field "u32TimeDateValue"
     */
    inline uint32 getU32TimeDateValue () const;

    /**
     * Sets the value of the member "u32TimeDateValue".
     *
     * seconds elapsed since begin of century
     * valid:
     * 00000000h ... BC19137Fh (normal), spanning 100 years, beginnng 2000-1-1, 0:00
     * BC191380h ... CEE90B00h (overflow), spanning first decade of 2100 century
     * ED33FD00h ... FFFFFFFFh (underflow), interpreted negative, spanning last decade of 1900 century
     * invalid due to ambivalence:
     * CEE90B01h ... ED33FCFFh
     *
     * @param u32TimeDateValue The value which will be set
     */
    inline void setU32TimeDateValue (uint32 u32TimeDateValue_);

    // API of field "u8SourceDomain"

    static const int kU8SourceDomain = 1;

    /**
     * Clears the field "u8SourceDomain".
     *
     * The field will be set to its default value. The hasU8SourceDomain()
     * method will return false.
     */
    inline void clearU8SourceDomain();

    /**
     * Checks whether the field "u8SourceDomain" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceDomain()). Otherwise it will return false.
     */
    inline bool hasU8SourceDomain () const;

    /**
     * Returns the value of the member "u8SourceDomain".
     *
     * Domain (local or UTC/system RTC) of the given scalar time/date value
     * (optional, used for calculation across domains; if identical to enTargetDomain no conversion takes place)
     * 0 = UTC/system RTC, 1= Local time;
     * defaults to Local time
     *
     * @return The value of the field "u8SourceDomain"
     */
    inline uint8 getU8SourceDomain () const;

    /**
     * Sets the value of the member "u8SourceDomain".
     *
     * Domain (local or UTC/system RTC) of the given scalar time/date value
     * (optional, used for calculation across domains; if identical to enTargetDomain no conversion takes place)
     * 0 = UTC/system RTC, 1= Local time;
     * defaults to Local time
     *
     * @param u8SourceDomain The value which will be set
     */
    inline void setU8SourceDomain (uint8 u8SourceDomain_);

    // API of field "u8TargetDomain"

    static const int kU8TargetDomain = 2;

    /**
     * Clears the field "u8TargetDomain".
     *
     * The field will be set to its default value. The hasU8TargetDomain()
     * method will return false.
     */
    inline void clearU8TargetDomain();

    /**
     * Checks whether the field "u8TargetDomain" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TargetDomain()). Otherwise it will return false.
     */
    inline bool hasU8TargetDomain () const;

    /**
     * Returns the value of the member "u8TargetDomain".
     *
     * Domain (local or UTC/system RTC) of the expected result
     * (optional, used for calculation across domains;
     * if identical to enSourceDomain no conversion takes place)
     * 0 = UTC/system RTC, 1= Local time;
     * defaults to Local time
     *
     * @return The value of the field "u8TargetDomain"
     */
    inline uint8 getU8TargetDomain () const;

    /**
     * Sets the value of the member "u8TargetDomain".
     *
     * Domain (local or UTC/system RTC) of the expected result
     * (optional, used for calculation across domains;
     * if identical to enSourceDomain no conversion takes place)
     * 0 = UTC/system RTC, 1= Local time;
     * defaults to Local time
     *
     * @param u8TargetDomain The value which will be set
     */
    inline void setU8TargetDomain (uint8 u8TargetDomain_);

    static const GetTimeDateFromValueStart &getDefaultInstance();

private:

    inline void set_has_u32TimeDateValue ();

    inline void clear_has_u32TimeDateValue ();

    inline void set_has_u8SourceDomain ();

    inline void clear_has_u8SourceDomain ();

    inline void set_has_u8TargetDomain ();

    inline void clear_has_u8TargetDomain ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _u32TimeDateValue;

    uint8 _u8SourceDomain;

    uint8 _u8TargetDomain;

};

/**
 * The result message of the method "GetTimeDateFromValue"
 * utility to transform a scalar date/time value
 * (seconds elapsed since begin of century)
 * into date and time fields (year, month, day, hours, minutes, seconds and weekday of current date)
 * (to be used e. g. to calculate estimated time of arrival).
 */
class GetTimeDateFromValueResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTimeDateFromValueResult ();

    /**
     * Copy constructor
     */
    inline  GetTimeDateFromValueResult (const GetTimeDateFromValueResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetTimeDateFromValueResult (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_);

    /**
     * Destructor
     */
    inline virtual  ~GetTimeDateFromValueResult();

    /**
     * Assignment operator
     */
    inline GetTimeDateFromValueResult& operator = (const GetTimeDateFromValueResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTimeDateFromValueResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTimeDateFromValueResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTimeDateFromValueResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTimeDateFromValueResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16Year"

    static const int kS16Year = 0;

    /**
     * Clears the field "s16Year".
     *
     * The field will be set to its default value. The hasS16Year()
     * method will return false.
     */
    inline void clearS16Year();

    /**
     * Checks whether the field "s16Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16Year()). Otherwise it will return false.
     */
    inline bool hasS16Year () const;

    /**
     * Returns the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * (between 1990 and 2110)
     *
     * @return The value of the field "s16Year"
     */
    inline int16 getS16Year () const;

    /**
     * Sets the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * (between 1990 and 2110)
     *
     * @param s16Year The value which will be set
     */
    inline void setS16Year (int16 s16Year_);

    // API of field "u8Month"

    static const int kU8Month = 1;

    /**
     * Clears the field "u8Month".
     *
     * The field will be set to its default value. The hasU8Month()
     * method will return false.
     */
    inline void clearU8Month();

    /**
     * Checks whether the field "u8Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Month()). Otherwise it will return false.
     */
    inline bool hasU8Month () const;

    /**
     * Returns the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @return The value of the field "u8Month"
     */
    inline uint8 getU8Month () const;

    /**
     * Sets the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @param u8Month The value which will be set
     */
    inline void setU8Month (uint8 u8Month_);

    // API of field "u8Day"

    static const int kU8Day = 2;

    /**
     * Clears the field "u8Day".
     *
     * The field will be set to its default value. The hasU8Day()
     * method will return false.
     */
    inline void clearU8Day();

    /**
     * Checks whether the field "u8Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Day()). Otherwise it will return false.
     */
    inline bool hasU8Day () const;

    /**
     * Returns the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date
     *
     * @return The value of the field "u8Day"
     */
    inline uint8 getU8Day () const;

    /**
     * Sets the value of the member "u8Day".
     *
     * The day fraction [1 .. month length] of date
     *
     * @param u8Day The value which will be set
     */
    inline void setU8Day (uint8 u8Day_);

    // API of field "u8Hours"

    static const int kU8Hours = 3;

    /**
     * Clears the field "u8Hours".
     *
     * The field will be set to its default value. The hasU8Hours()
     * method will return false.
     */
    inline void clearU8Hours();

    /**
     * Checks whether the field "u8Hours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hours()). Otherwise it will return false.
     */
    inline bool hasU8Hours () const;

    /**
     * Returns the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time.
     * (independent of time format; 24h mode, no flag for am/pm).
     *
     * @return The value of the field "u8Hours"
     */
    inline uint8 getU8Hours () const;

    /**
     * Sets the value of the member "u8Hours".
     *
     * The hours fraction [0-23] of time.
     * (independent of time format; 24h mode, no flag for am/pm).
     *
     * @param u8Hours The value which will be set
     */
    inline void setU8Hours (uint8 u8Hours_);

    // API of field "u8Minutes"

    static const int kU8Minutes = 4;

    /**
     * Clears the field "u8Minutes".
     *
     * The field will be set to its default value. The hasU8Minutes()
     * method will return false.
     */
    inline void clearU8Minutes();

    /**
     * Checks whether the field "u8Minutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Minutes()). Otherwise it will return false.
     */
    inline bool hasU8Minutes () const;

    /**
     * Returns the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @return The value of the field "u8Minutes"
     */
    inline uint8 getU8Minutes () const;

    /**
     * Sets the value of the member "u8Minutes".
     *
     * The minutes fraction [0-59] of time.
     *
     * @param u8Minutes The value which will be set
     */
    inline void setU8Minutes (uint8 u8Minutes_);

    // API of field "u8Seconds"

    static const int kU8Seconds = 5;

    /**
     * Clears the field "u8Seconds".
     *
     * The field will be set to its default value. The hasU8Seconds()
     * method will return false.
     */
    inline void clearU8Seconds();

    /**
     * Checks whether the field "u8Seconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Seconds()). Otherwise it will return false.
     */
    inline bool hasU8Seconds () const;

    /**
     * Returns the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @return The value of the field "u8Seconds"
     */
    inline uint8 getU8Seconds () const;

    /**
     * Sets the value of the member "u8Seconds".
     *
     * The seconds fraction [0-59] of time.
     *
     * @param u8Seconds The value which will be set
     */
    inline void setU8Seconds (uint8 u8Seconds_);

    // API of field "u8Weekday"

    static const int kU8Weekday = 6;

    /**
     * Clears the field "u8Weekday".
     *
     * The field will be set to its default value. The hasU8Weekday()
     * method will return false.
     */
    inline void clearU8Weekday();

    /**
     * Checks whether the field "u8Weekday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Weekday()). Otherwise it will return false.
     */
    inline bool hasU8Weekday () const;

    /**
     * Returns the value of the member "u8Weekday".
     *
     * The weekday of the given date [0=Monday ... 6=Sunday].
     *
     * @return The value of the field "u8Weekday"
     */
    inline uint8 getU8Weekday () const;

    /**
     * Sets the value of the member "u8Weekday".
     *
     * The weekday of the given date [0=Monday ... 6=Sunday].
     *
     * @param u8Weekday The value which will be set
     */
    inline void setU8Weekday (uint8 u8Weekday_);

    static const GetTimeDateFromValueResult &getDefaultInstance();

private:

    inline void set_has_s16Year ();

    inline void clear_has_s16Year ();

    inline void set_has_u8Month ();

    inline void clear_has_u8Month ();

    inline void set_has_u8Day ();

    inline void clear_has_u8Day ();

    inline void set_has_u8Hours ();

    inline void clear_has_u8Hours ();

    inline void set_has_u8Minutes ();

    inline void clear_has_u8Minutes ();

    inline void set_has_u8Seconds ();

    inline void clear_has_u8Seconds ();

    inline void set_has_u8Weekday ();

    inline void clear_has_u8Weekday ();

    uint32 _has_bits_[ (7 + 31) / 32];

    int16 _s16Year;

    uint8 _u8Month;

    uint8 _u8Day;

    uint8 _u8Hours;

    uint8 _u8Minutes;

    uint8 _u8Seconds;

    uint8 _u8Weekday;

};

/**
 * The start message of the method "GetDaysPerMonth"
 * Calculates the number of days for a given month in a given year.
 * - takes into account leap years based on gregorian calendar.
 */
class GetDaysPerMonthStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDaysPerMonthStart ();

    /**
     * Copy constructor
     */
    inline  GetDaysPerMonthStart (const GetDaysPerMonthStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetDaysPerMonthStart (int16 s16Year_, uint8 u8Month_);

    /**
     * Destructor
     */
    inline virtual  ~GetDaysPerMonthStart();

    /**
     * Assignment operator
     */
    inline GetDaysPerMonthStart& operator = (const GetDaysPerMonthStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDaysPerMonthStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDaysPerMonthStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDaysPerMonthStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDaysPerMonthStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16Year"

    static const int kS16Year = 0;

    /**
     * Clears the field "s16Year".
     *
     * The field will be set to its default value. The hasS16Year()
     * method will return false.
     */
    inline void clearS16Year();

    /**
     * Checks whether the field "s16Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16Year()). Otherwise it will return false.
     */
    inline bool hasS16Year () const;

    /**
     * Returns the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * (between 2000 and 2100)
     *
     * @return The value of the field "s16Year"
     */
    inline int16 getS16Year () const;

    /**
     * Sets the value of the member "s16Year".
     *
     * The year fraction of date according to standard gregorian calendar.
     * (between 2000 and 2100)
     *
     * @param s16Year The value which will be set
     */
    inline void setS16Year (int16 s16Year_);

    // API of field "u8Month"

    static const int kU8Month = 1;

    /**
     * Clears the field "u8Month".
     *
     * The field will be set to its default value. The hasU8Month()
     * method will return false.
     */
    inline void clearU8Month();

    /**
     * Checks whether the field "u8Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Month()). Otherwise it will return false.
     */
    inline bool hasU8Month () const;

    /**
     * Returns the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @return The value of the field "u8Month"
     */
    inline uint8 getU8Month () const;

    /**
     * Sets the value of the member "u8Month".
     *
     * The month fraction [1 .. 12] (January .. December) of date.
     *
     * @param u8Month The value which will be set
     */
    inline void setU8Month (uint8 u8Month_);

    static const GetDaysPerMonthStart &getDefaultInstance();

private:

    inline void set_has_s16Year ();

    inline void clear_has_s16Year ();

    inline void set_has_u8Month ();

    inline void clear_has_u8Month ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _s16Year;

    uint8 _u8Month;

};

/**
 * The result message of the method "GetDaysPerMonth"
 * Calculates the number of days for a given month in a given year.
 * - takes into account leap years based on gregorian calendar.
 */
class GetDaysPerMonthResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDaysPerMonthResult ();

    /**
     * Copy constructor
     */
    inline  GetDaysPerMonthResult (const GetDaysPerMonthResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetDaysPerMonthResult (uint8 u8NumberOfDays_);

    /**
     * Destructor
     */
    inline virtual  ~GetDaysPerMonthResult();

    /**
     * Assignment operator
     */
    inline GetDaysPerMonthResult& operator = (const GetDaysPerMonthResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDaysPerMonthResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDaysPerMonthResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDaysPerMonthResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDaysPerMonthResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8NumberOfDays"

    static const int kU8NumberOfDays = 0;

    /**
     * Clears the field "u8NumberOfDays".
     *
     * The field will be set to its default value. The hasU8NumberOfDays()
     * method will return false.
     */
    inline void clearU8NumberOfDays();

    /**
     * Checks whether the field "u8NumberOfDays" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfDays()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfDays () const;

    /**
     * Returns the value of the member "u8NumberOfDays".
     *
     * Calculated number of days.
     *
     * @return The value of the field "u8NumberOfDays"
     */
    inline uint8 getU8NumberOfDays () const;

    /**
     * Sets the value of the member "u8NumberOfDays".
     *
     * Calculated number of days.
     *
     * @param u8NumberOfDays The value which will be set
     */
    inline void setU8NumberOfDays (uint8 u8NumberOfDays_);

    static const GetDaysPerMonthResult &getDefaultInstance();

private:

    inline void set_has_u8NumberOfDays ();

    inline void clear_has_u8NumberOfDays ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8NumberOfDays;

};

/**
 * The start message of the method "FID_S_DIAG_CONFIGURATION"
 * With this method the diagnosis component tells the CLOCK component
 * that it has to set its internal settings to its default values or that
 * it has to react on an update of the coding value or calibration items
 * Diagnosis sends this message in order to start the update process
 */
class FID_S_DIAG_CONFIGURATIONStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_S_DIAG_CONFIGURATIONStart ();

    /**
     * Copy constructor
     */
    inline  FID_S_DIAG_CONFIGURATIONStart (const FID_S_DIAG_CONFIGURATIONStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_S_DIAG_CONFIGURATIONStart (::diagnostics_main_fi_types::T_e8_DefSetGroups DefSetStateGroup_, ::diagnostics_main_fi_types::T_e8_DefSetMode DefSetStateMode_);

    /**
     * Destructor
     */
    inline virtual  ~FID_S_DIAG_CONFIGURATIONStart();

    /**
     * Assignment operator
     */
    inline FID_S_DIAG_CONFIGURATIONStart& operator = (const FID_S_DIAG_CONFIGURATIONStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_S_DIAG_CONFIGURATIONStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_S_DIAG_CONFIGURATIONStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_S_DIAG_CONFIGURATIONStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_S_DIAG_CONFIGURATIONStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetStateGroup"

    static const int kDefSetStateGroup = 0;

    /**
     * Clears the field "DefSetStateGroup".
     *
     * The field will be set to its default value. The hasDefSetStateGroup()
     * method will return false.
     */
    inline void clearDefSetStateGroup();

    /**
     * Checks whether the field "DefSetStateGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetStateGroup () const;

    /**
     * Returns the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     *
     * @return The value of the field "DefSetStateGroup"
     */
    inline ::diagnostics_main_fi_types::T_e8_DefSetGroups getDefSetStateGroup () const;

    /**
     * Sets the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     *
     * @param DefSetStateGroup The value which will be set
     */
    inline void setDefSetStateGroup (::diagnostics_main_fi_types::T_e8_DefSetGroups DefSetStateGroup_);

    // API of field "DefSetStateMode"

    static const int kDefSetStateMode = 1;

    /**
     * Clears the field "DefSetStateMode".
     *
     * The field will be set to its default value. The hasDefSetStateMode()
     * method will return false.
     */
    inline void clearDefSetStateMode();

    /**
     * Checks whether the field "DefSetStateMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateMode()). Otherwise it will return false.
     */
    inline bool hasDefSetStateMode () const;

    /**
     * Returns the value of the member "DefSetStateMode".
     *
     * TEF (production), USER (HMI), CODING or CALIBRATION
     *
     * @return The value of the field "DefSetStateMode"
     */
    inline ::diagnostics_main_fi_types::T_e8_DefSetMode getDefSetStateMode () const;

    /**
     * Sets the value of the member "DefSetStateMode".
     *
     * TEF (production), USER (HMI), CODING or CALIBRATION
     *
     * @param DefSetStateMode The value which will be set
     */
    inline void setDefSetStateMode (::diagnostics_main_fi_types::T_e8_DefSetMode DefSetStateMode_);

    static const FID_S_DIAG_CONFIGURATIONStart &getDefaultInstance();

private:

    inline void set_has_DefSetStateGroup ();

    inline void clear_has_DefSetStateGroup ();

    inline void set_has_DefSetStateMode ();

    inline void clear_has_DefSetStateMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::diagnostics_main_fi_types::T_e8_DefSetGroups _DefSetStateGroup;

    ::diagnostics_main_fi_types::T_e8_DefSetMode _DefSetStateMode;

};

/**
 * The result message of the method "FID_S_DIAG_CONFIGURATION"
 * With this method the diagnosis component tells the CLOCK component
 * that it has to set its internal settings to its default values or that
 * it has to react on an update of the coding value or calibration items
 * Message send back to diagnosis after the update process is completed
 */
class FID_S_DIAG_CONFIGURATIONResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_S_DIAG_CONFIGURATIONResult ();

    /**
     * Copy constructor
     */
    inline  FID_S_DIAG_CONFIGURATIONResult (const FID_S_DIAG_CONFIGURATIONResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_S_DIAG_CONFIGURATIONResult (::diagnostics_main_fi_types::T_e8_DefSetGroups DefSetStateGroup_, ::diagnostics_main_fi_types::T_e8_DefSetMode DefSetStateMode_, bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~FID_S_DIAG_CONFIGURATIONResult();

    /**
     * Assignment operator
     */
    inline FID_S_DIAG_CONFIGURATIONResult& operator = (const FID_S_DIAG_CONFIGURATIONResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_S_DIAG_CONFIGURATIONResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_S_DIAG_CONFIGURATIONResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_S_DIAG_CONFIGURATIONResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_S_DIAG_CONFIGURATIONResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetStateGroup"

    static const int kDefSetStateGroup = 0;

    /**
     * Clears the field "DefSetStateGroup".
     *
     * The field will be set to its default value. The hasDefSetStateGroup()
     * method will return false.
     */
    inline void clearDefSetStateGroup();

    /**
     * Checks whether the field "DefSetStateGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetStateGroup () const;

    /**
     * Returns the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     *
     * @return The value of the field "DefSetStateGroup"
     */
    inline ::diagnostics_main_fi_types::T_e8_DefSetGroups getDefSetStateGroup () const;

    /**
     * Sets the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     *
     * @param DefSetStateGroup The value which will be set
     */
    inline void setDefSetStateGroup (::diagnostics_main_fi_types::T_e8_DefSetGroups DefSetStateGroup_);

    // API of field "DefSetStateMode"

    static const int kDefSetStateMode = 1;

    /**
     * Clears the field "DefSetStateMode".
     *
     * The field will be set to its default value. The hasDefSetStateMode()
     * method will return false.
     */
    inline void clearDefSetStateMode();

    /**
     * Checks whether the field "DefSetStateMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateMode()). Otherwise it will return false.
     */
    inline bool hasDefSetStateMode () const;

    /**
     * Returns the value of the member "DefSetStateMode".
     *
     * TEF (production), USER (HMI), CODING or CALIBRATION
     *
     * @return The value of the field "DefSetStateMode"
     */
    inline ::diagnostics_main_fi_types::T_e8_DefSetMode getDefSetStateMode () const;

    /**
     * Sets the value of the member "DefSetStateMode".
     *
     * TEF (production), USER (HMI), CODING or CALIBRATION
     *
     * @param DefSetStateMode The value which will be set
     */
    inline void setDefSetStateMode (::diagnostics_main_fi_types::T_e8_DefSetMode DefSetStateMode_);

    // API of field "Status"

    static const int kStatus = 2;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Information that indicates, whether the update was successful or not
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Information that indicates, whether the update was successful or not
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const FID_S_DIAG_CONFIGURATIONResult &getDefaultInstance();

private:

    inline void set_has_DefSetStateGroup ();

    inline void clear_has_DefSetStateGroup ();

    inline void set_has_DefSetStateMode ();

    inline void clear_has_DefSetStateMode ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::diagnostics_main_fi_types::T_e8_DefSetGroups _DefSetStateGroup;

    ::diagnostics_main_fi_types::T_e8_DefSetMode _DefSetStateMode;

    bool _Status;

};

inline  TimeZoneStatus::TimeZoneStatus ()  :
    _u16Index (0u),
    _szDescription ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TimeZoneStatus::TimeZoneStatus (const TimeZoneStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u16Index (0u),
    _szDescription ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TimeZoneStatus::TimeZoneStatus (uint16 u16Index_, const ::std::string& szDescription_)  :
    _u16Index (u16Index_),
    _szDescription (szDescription_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TimeZoneStatus::~TimeZoneStatus() {
}

inline TimeZoneStatus& TimeZoneStatus::operator = (const TimeZoneStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU16Index()) {
            setU16Index(rhs.getU16Index());
        } else {
            clearU16Index();
        }
        if (rhs.hasSzDescription()) {
            setSzDescription(rhs.getSzDescription());
        } else {
            clearSzDescription();
        }
    }
    return *this;
}

inline bool TimeZoneStatus::operator == (const TimeZoneStatus& rhs) const {
    return (((!hasU16Index() && !rhs.hasU16Index()) || getU16Index() == rhs.getU16Index()) &&
        ((!hasSzDescription() && !rhs.hasSzDescription()) || getSzDescription() == rhs.getSzDescription()));
}

inline bool TimeZoneStatus::operator != (const TimeZoneStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool TimeZoneStatus::operator < (const TimeZoneStatus& rhs) const {
    if (hasU16Index() || rhs.hasU16Index()) {
        if (getU16Index() < rhs.getU16Index()) return true;
        if (getU16Index() > rhs.getU16Index()) return false;
    }
    if (hasSzDescription() || rhs.hasSzDescription()) {
        if (getSzDescription() < rhs.getSzDescription()) return true;
        if (getSzDescription() > rhs.getSzDescription()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TimeZoneStatus::clone() {
    return new TimeZoneStatus(*this);
}

inline bool TimeZoneStatus::operator > (const TimeZoneStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TimeZoneStatus::clear() {
    clearU16Index();
    clearSzDescription();
}

inline void TimeZoneStatus::clearU16Index() {
    if (hasU16Index()) {
         clear_has_u16Index();
        _u16Index = 0u;
     }
}

inline bool TimeZoneStatus::hasU16Index () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 TimeZoneStatus::getU16Index () const {
    return _u16Index;
}

inline void TimeZoneStatus::setU16Index (uint16 u16Index_) {
    set_has_u16Index();
    this->_u16Index = u16Index_;
}

inline void TimeZoneStatus::clearSzDescription() {
    if (hasSzDescription()) {
         clear_has_szDescription();
        _szDescription.clear();
     }
}

inline bool TimeZoneStatus::hasSzDescription () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& TimeZoneStatus::getSzDescription () const {
    return _szDescription;
}

inline ::std::string& TimeZoneStatus::getSzDescriptionMutable () {
    set_has_szDescription();
    return _szDescription;
}

inline void TimeZoneStatus::setSzDescription (const ::std::string& szDescription_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDescription();
    this->_szDescription = szDescription_;
}

inline void TimeZoneStatus::setSzDescription (const char* szDescription_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDescription();
    this->_szDescription.assign(szDescription_);
}

inline void TimeZoneStatus::setSzDescription (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDescription();
    this->_szDescription.assign(value, size);
}

inline void TimeZoneStatus::set_has_u16Index () {
    _has_bits_[0] |= 1u << 0;
}

inline void TimeZoneStatus::clear_has_u16Index () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void TimeZoneStatus::set_has_szDescription () {
    _has_bits_[0] |= 1u << 1;
}

inline void TimeZoneStatus::clear_has_szDescription () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  TimeZoneSet::TimeZoneSet ()  :
    _u16Index (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TimeZoneSet::TimeZoneSet (const TimeZoneSet &rhs)  :
    ::asf::core::Payload(rhs),
    _u16Index (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TimeZoneSet::TimeZoneSet (uint16 u16Index_)  :
    _u16Index (u16Index_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TimeZoneSet::~TimeZoneSet() {
}

inline TimeZoneSet& TimeZoneSet::operator = (const TimeZoneSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU16Index()) {
            setU16Index(rhs.getU16Index());
        } else {
            clearU16Index();
        }
    }
    return *this;
}

inline bool TimeZoneSet::operator == (const TimeZoneSet& rhs) const {
    return (((!hasU16Index() && !rhs.hasU16Index()) || getU16Index() == rhs.getU16Index()));
}

inline bool TimeZoneSet::operator != (const TimeZoneSet& rhs) const {
    return ! (*this == rhs);
}

inline bool TimeZoneSet::operator < (const TimeZoneSet& rhs) const {
    if (hasU16Index() || rhs.hasU16Index()) {
        if (getU16Index() < rhs.getU16Index()) return true;
        if (getU16Index() > rhs.getU16Index()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TimeZoneSet::clone() {
    return new TimeZoneSet(*this);
}

inline bool TimeZoneSet::operator > (const TimeZoneSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TimeZoneSet::clear() {
    clearU16Index();
}

inline void TimeZoneSet::clearU16Index() {
    if (hasU16Index()) {
         clear_has_u16Index();
        _u16Index = 0u;
     }
}

inline bool TimeZoneSet::hasU16Index () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 TimeZoneSet::getU16Index () const {
    return _u16Index;
}

inline void TimeZoneSet::setU16Index (uint16 u16Index_) {
    set_has_u16Index();
    this->_u16Index = u16Index_;
}

inline void TimeZoneSet::set_has_u16Index () {
    _has_bits_[0] |= 1u << 0;
}

inline void TimeZoneSet::clear_has_u16Index () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DaylightSavingTimeStatus::DaylightSavingTimeStatus ()  :
    _bDST_Status (false),
    _bDST_AutoAdjust (false),
    _enDST_Status (::clock_main_fi_types::VDCLK_TEN_DST_Setting__VDCLK_EN_DST_Auto_OFF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DaylightSavingTimeStatus::DaylightSavingTimeStatus (const DaylightSavingTimeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _bDST_Status (false),
    _bDST_AutoAdjust (false),
    _enDST_Status (::clock_main_fi_types::VDCLK_TEN_DST_Setting__VDCLK_EN_DST_Auto_OFF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DaylightSavingTimeStatus::DaylightSavingTimeStatus (bool bDST_Status_, bool bDST_AutoAdjust_, ::clock_main_fi_types::VDCLK_TEN_DST_Setting enDST_Status_)  :
    _bDST_Status (bDST_Status_),
    _bDST_AutoAdjust (bDST_AutoAdjust_),
    _enDST_Status (enDST_Status_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_DST_Setting_IsValid(enDST_Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDST_Status_, "VDCLK_TEN_DST_Setting", "enDST_Status", "DaylightSavingTimeStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DaylightSavingTimeStatus::~DaylightSavingTimeStatus() {
}

inline DaylightSavingTimeStatus& DaylightSavingTimeStatus::operator = (const DaylightSavingTimeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBDST_Status()) {
            setBDST_Status(rhs.getBDST_Status());
        } else {
            clearBDST_Status();
        }
        if (rhs.hasBDST_AutoAdjust()) {
            setBDST_AutoAdjust(rhs.getBDST_AutoAdjust());
        } else {
            clearBDST_AutoAdjust();
        }
        if (rhs.hasEnDST_Status()) {
            setEnDST_Status(rhs.getEnDST_Status());
        } else {
            clearEnDST_Status();
        }
    }
    return *this;
}

inline bool DaylightSavingTimeStatus::operator == (const DaylightSavingTimeStatus& rhs) const {
    return (((!hasBDST_Status() && !rhs.hasBDST_Status()) || getBDST_Status() == rhs.getBDST_Status()) &&
        ((!hasBDST_AutoAdjust() && !rhs.hasBDST_AutoAdjust()) || getBDST_AutoAdjust() == rhs.getBDST_AutoAdjust()) &&
        ((!hasEnDST_Status() && !rhs.hasEnDST_Status()) || getEnDST_Status() == rhs.getEnDST_Status()));
}

inline bool DaylightSavingTimeStatus::operator != (const DaylightSavingTimeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DaylightSavingTimeStatus::operator < (const DaylightSavingTimeStatus& rhs) const {
    if (hasBDST_Status() || rhs.hasBDST_Status()) {
        if (getBDST_Status() < rhs.getBDST_Status()) return true;
        if (getBDST_Status() > rhs.getBDST_Status()) return false;
    }
    if (hasBDST_AutoAdjust() || rhs.hasBDST_AutoAdjust()) {
        if (getBDST_AutoAdjust() < rhs.getBDST_AutoAdjust()) return true;
        if (getBDST_AutoAdjust() > rhs.getBDST_AutoAdjust()) return false;
    }
    if (hasEnDST_Status() || rhs.hasEnDST_Status()) {
        if ((uint32)getEnDST_Status() < (uint32)rhs.getEnDST_Status()) return true;
        if ((uint32)getEnDST_Status() > (uint32)rhs.getEnDST_Status()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DaylightSavingTimeStatus::clone() {
    return new DaylightSavingTimeStatus(*this);
}

inline bool DaylightSavingTimeStatus::operator > (const DaylightSavingTimeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DaylightSavingTimeStatus::clear() {
    clearBDST_Status();
    clearBDST_AutoAdjust();
    clearEnDST_Status();
}

inline void DaylightSavingTimeStatus::clearBDST_Status() {
    if (hasBDST_Status()) {
         clear_has_bDST_Status();
        _bDST_Status = false;
     }
}

inline bool DaylightSavingTimeStatus::hasBDST_Status () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DaylightSavingTimeStatus::getBDST_Status () const {
    return _bDST_Status;
}

inline void DaylightSavingTimeStatus::setBDST_Status (bool bDST_Status_) {
    set_has_bDST_Status();
    this->_bDST_Status = bDST_Status_;
}

inline void DaylightSavingTimeStatus::clearBDST_AutoAdjust() {
    if (hasBDST_AutoAdjust()) {
         clear_has_bDST_AutoAdjust();
        _bDST_AutoAdjust = false;
     }
}

inline bool DaylightSavingTimeStatus::hasBDST_AutoAdjust () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool DaylightSavingTimeStatus::getBDST_AutoAdjust () const {
    return _bDST_AutoAdjust;
}

inline void DaylightSavingTimeStatus::setBDST_AutoAdjust (bool bDST_AutoAdjust_) {
    set_has_bDST_AutoAdjust();
    this->_bDST_AutoAdjust = bDST_AutoAdjust_;
}

inline void DaylightSavingTimeStatus::clearEnDST_Status() {
    if (hasEnDST_Status()) {
         clear_has_enDST_Status();
        _enDST_Status = ::clock_main_fi_types::VDCLK_TEN_DST_Setting__VDCLK_EN_DST_Auto_OFF;
     }
}

inline bool DaylightSavingTimeStatus::hasEnDST_Status () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_DST_Setting DaylightSavingTimeStatus::getEnDST_Status () const {
    return _enDST_Status;
}

inline void DaylightSavingTimeStatus::setEnDST_Status (::clock_main_fi_types::VDCLK_TEN_DST_Setting enDST_Status_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_DST_Setting_IsValid(enDST_Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDST_Status_, "VDCLK_TEN_DST_Setting", "enDST_Status", "DaylightSavingTimeStatus");
    }
    #endif
    set_has_enDST_Status();
    this->_enDST_Status = enDST_Status_;
}

inline void DaylightSavingTimeStatus::set_has_bDST_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void DaylightSavingTimeStatus::clear_has_bDST_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DaylightSavingTimeStatus::set_has_bDST_AutoAdjust () {
    _has_bits_[0] |= 1u << 1;
}

inline void DaylightSavingTimeStatus::clear_has_bDST_AutoAdjust () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DaylightSavingTimeStatus::set_has_enDST_Status () {
    _has_bits_[0] |= 1u << 2;
}

inline void DaylightSavingTimeStatus::clear_has_enDST_Status () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  DaylightSavingTimeSet::DaylightSavingTimeSet ()  :
    _enDST_Setting (::clock_main_fi_types::VDCLK_TEN_DST_Setting__VDCLK_EN_DST_Auto_OFF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DaylightSavingTimeSet::DaylightSavingTimeSet (const DaylightSavingTimeSet &rhs)  :
    ::asf::core::Payload(rhs),
    _enDST_Setting (::clock_main_fi_types::VDCLK_TEN_DST_Setting__VDCLK_EN_DST_Auto_OFF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DaylightSavingTimeSet::DaylightSavingTimeSet (::clock_main_fi_types::VDCLK_TEN_DST_Setting enDST_Setting_)  :
    _enDST_Setting (enDST_Setting_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_DST_Setting_IsValid(enDST_Setting_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDST_Setting_, "VDCLK_TEN_DST_Setting", "enDST_Setting", "DaylightSavingTimeSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DaylightSavingTimeSet::~DaylightSavingTimeSet() {
}

inline DaylightSavingTimeSet& DaylightSavingTimeSet::operator = (const DaylightSavingTimeSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnDST_Setting()) {
            setEnDST_Setting(rhs.getEnDST_Setting());
        } else {
            clearEnDST_Setting();
        }
    }
    return *this;
}

inline bool DaylightSavingTimeSet::operator == (const DaylightSavingTimeSet& rhs) const {
    return (((!hasEnDST_Setting() && !rhs.hasEnDST_Setting()) || getEnDST_Setting() == rhs.getEnDST_Setting()));
}

inline bool DaylightSavingTimeSet::operator != (const DaylightSavingTimeSet& rhs) const {
    return ! (*this == rhs);
}

inline bool DaylightSavingTimeSet::operator < (const DaylightSavingTimeSet& rhs) const {
    if (hasEnDST_Setting() || rhs.hasEnDST_Setting()) {
        if ((uint32)getEnDST_Setting() < (uint32)rhs.getEnDST_Setting()) return true;
        if ((uint32)getEnDST_Setting() > (uint32)rhs.getEnDST_Setting()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DaylightSavingTimeSet::clone() {
    return new DaylightSavingTimeSet(*this);
}

inline bool DaylightSavingTimeSet::operator > (const DaylightSavingTimeSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DaylightSavingTimeSet::clear() {
    clearEnDST_Setting();
}

inline void DaylightSavingTimeSet::clearEnDST_Setting() {
    if (hasEnDST_Setting()) {
         clear_has_enDST_Setting();
        _enDST_Setting = ::clock_main_fi_types::VDCLK_TEN_DST_Setting__VDCLK_EN_DST_Auto_OFF;
     }
}

inline bool DaylightSavingTimeSet::hasEnDST_Setting () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_DST_Setting DaylightSavingTimeSet::getEnDST_Setting () const {
    return _enDST_Setting;
}

inline void DaylightSavingTimeSet::setEnDST_Setting (::clock_main_fi_types::VDCLK_TEN_DST_Setting enDST_Setting_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_DST_Setting_IsValid(enDST_Setting_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDST_Setting_, "VDCLK_TEN_DST_Setting", "enDST_Setting", "DaylightSavingTimeSet");
    }
    #endif
    set_has_enDST_Setting();
    this->_enDST_Setting = enDST_Setting_;
}

inline void DaylightSavingTimeSet::set_has_enDST_Setting () {
    _has_bits_[0] |= 1u << 0;
}

inline void DaylightSavingTimeSet::clear_has_enDST_Setting () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GPS_AutoSyncStatus::GPS_AutoSyncStatus ()  :
    _bEnabled (false),
    _bPositionBased (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GPS_AutoSyncStatus::GPS_AutoSyncStatus (const GPS_AutoSyncStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _bEnabled (false),
    _bPositionBased (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GPS_AutoSyncStatus::GPS_AutoSyncStatus (bool bEnabled_, bool bPositionBased_)  :
    _bEnabled (bEnabled_),
    _bPositionBased (bPositionBased_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GPS_AutoSyncStatus::~GPS_AutoSyncStatus() {
}

inline GPS_AutoSyncStatus& GPS_AutoSyncStatus::operator = (const GPS_AutoSyncStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBEnabled()) {
            setBEnabled(rhs.getBEnabled());
        } else {
            clearBEnabled();
        }
        if (rhs.hasBPositionBased()) {
            setBPositionBased(rhs.getBPositionBased());
        } else {
            clearBPositionBased();
        }
    }
    return *this;
}

inline bool GPS_AutoSyncStatus::operator == (const GPS_AutoSyncStatus& rhs) const {
    return (((!hasBEnabled() && !rhs.hasBEnabled()) || getBEnabled() == rhs.getBEnabled()) &&
        ((!hasBPositionBased() && !rhs.hasBPositionBased()) || getBPositionBased() == rhs.getBPositionBased()));
}

inline bool GPS_AutoSyncStatus::operator != (const GPS_AutoSyncStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool GPS_AutoSyncStatus::operator < (const GPS_AutoSyncStatus& rhs) const {
    if (hasBEnabled() || rhs.hasBEnabled()) {
        if (getBEnabled() < rhs.getBEnabled()) return true;
        if (getBEnabled() > rhs.getBEnabled()) return false;
    }
    if (hasBPositionBased() || rhs.hasBPositionBased()) {
        if (getBPositionBased() < rhs.getBPositionBased()) return true;
        if (getBPositionBased() > rhs.getBPositionBased()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GPS_AutoSyncStatus::clone() {
    return new GPS_AutoSyncStatus(*this);
}

inline bool GPS_AutoSyncStatus::operator > (const GPS_AutoSyncStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GPS_AutoSyncStatus::clear() {
    clearBEnabled();
    clearBPositionBased();
}

inline void GPS_AutoSyncStatus::clearBEnabled() {
    if (hasBEnabled()) {
         clear_has_bEnabled();
        _bEnabled = false;
     }
}

inline bool GPS_AutoSyncStatus::hasBEnabled () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool GPS_AutoSyncStatus::getBEnabled () const {
    return _bEnabled;
}

inline void GPS_AutoSyncStatus::setBEnabled (bool bEnabled_) {
    set_has_bEnabled();
    this->_bEnabled = bEnabled_;
}

inline void GPS_AutoSyncStatus::clearBPositionBased() {
    if (hasBPositionBased()) {
         clear_has_bPositionBased();
        _bPositionBased = false;
     }
}

inline bool GPS_AutoSyncStatus::hasBPositionBased () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool GPS_AutoSyncStatus::getBPositionBased () const {
    return _bPositionBased;
}

inline void GPS_AutoSyncStatus::setBPositionBased (bool bPositionBased_) {
    set_has_bPositionBased();
    this->_bPositionBased = bPositionBased_;
}

inline void GPS_AutoSyncStatus::set_has_bEnabled () {
    _has_bits_[0] |= 1u << 0;
}

inline void GPS_AutoSyncStatus::clear_has_bEnabled () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GPS_AutoSyncStatus::set_has_bPositionBased () {
    _has_bits_[0] |= 1u << 1;
}

inline void GPS_AutoSyncStatus::clear_has_bPositionBased () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GPS_AutoSyncSet::GPS_AutoSyncSet ()  :
    _bEnabled (false),
    _bPositionBased (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GPS_AutoSyncSet::GPS_AutoSyncSet (const GPS_AutoSyncSet &rhs)  :
    ::asf::core::Payload(rhs),
    _bEnabled (false),
    _bPositionBased (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GPS_AutoSyncSet::GPS_AutoSyncSet (bool bEnabled_, bool bPositionBased_)  :
    _bEnabled (bEnabled_),
    _bPositionBased (bPositionBased_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GPS_AutoSyncSet::~GPS_AutoSyncSet() {
}

inline GPS_AutoSyncSet& GPS_AutoSyncSet::operator = (const GPS_AutoSyncSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBEnabled()) {
            setBEnabled(rhs.getBEnabled());
        } else {
            clearBEnabled();
        }
        if (rhs.hasBPositionBased()) {
            setBPositionBased(rhs.getBPositionBased());
        } else {
            clearBPositionBased();
        }
    }
    return *this;
}

inline bool GPS_AutoSyncSet::operator == (const GPS_AutoSyncSet& rhs) const {
    return (((!hasBEnabled() && !rhs.hasBEnabled()) || getBEnabled() == rhs.getBEnabled()) &&
        ((!hasBPositionBased() && !rhs.hasBPositionBased()) || getBPositionBased() == rhs.getBPositionBased()));
}

inline bool GPS_AutoSyncSet::operator != (const GPS_AutoSyncSet& rhs) const {
    return ! (*this == rhs);
}

inline bool GPS_AutoSyncSet::operator < (const GPS_AutoSyncSet& rhs) const {
    if (hasBEnabled() || rhs.hasBEnabled()) {
        if (getBEnabled() < rhs.getBEnabled()) return true;
        if (getBEnabled() > rhs.getBEnabled()) return false;
    }
    if (hasBPositionBased() || rhs.hasBPositionBased()) {
        if (getBPositionBased() < rhs.getBPositionBased()) return true;
        if (getBPositionBased() > rhs.getBPositionBased()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GPS_AutoSyncSet::clone() {
    return new GPS_AutoSyncSet(*this);
}

inline bool GPS_AutoSyncSet::operator > (const GPS_AutoSyncSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GPS_AutoSyncSet::clear() {
    clearBEnabled();
    clearBPositionBased();
}

inline void GPS_AutoSyncSet::clearBEnabled() {
    if (hasBEnabled()) {
         clear_has_bEnabled();
        _bEnabled = false;
     }
}

inline bool GPS_AutoSyncSet::hasBEnabled () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool GPS_AutoSyncSet::getBEnabled () const {
    return _bEnabled;
}

inline void GPS_AutoSyncSet::setBEnabled (bool bEnabled_) {
    set_has_bEnabled();
    this->_bEnabled = bEnabled_;
}

inline void GPS_AutoSyncSet::clearBPositionBased() {
    if (hasBPositionBased()) {
         clear_has_bPositionBased();
        _bPositionBased = false;
     }
}

inline bool GPS_AutoSyncSet::hasBPositionBased () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool GPS_AutoSyncSet::getBPositionBased () const {
    return _bPositionBased;
}

inline void GPS_AutoSyncSet::setBPositionBased (bool bPositionBased_) {
    set_has_bPositionBased();
    this->_bPositionBased = bPositionBased_;
}

inline void GPS_AutoSyncSet::set_has_bEnabled () {
    _has_bits_[0] |= 1u << 0;
}

inline void GPS_AutoSyncSet::clear_has_bEnabled () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GPS_AutoSyncSet::set_has_bPositionBased () {
    _has_bits_[0] |= 1u << 1;
}

inline void GPS_AutoSyncSet::clear_has_bPositionBased () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SyncModeStatus::SyncModeStatus ()  :
    _enMode (::clock_main_fi_types::VDCLK_TEN_SyncMode__VDCLK_EN_Sync_CanOrManual)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SyncModeStatus::SyncModeStatus (const SyncModeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _enMode (::clock_main_fi_types::VDCLK_TEN_SyncMode__VDCLK_EN_Sync_CanOrManual)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SyncModeStatus::SyncModeStatus (::clock_main_fi_types::VDCLK_TEN_SyncMode enMode_)  :
    _enMode (enMode_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_SyncMode_IsValid(enMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enMode_, "VDCLK_TEN_SyncMode", "enMode", "SyncModeStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SyncModeStatus::~SyncModeStatus() {
}

inline SyncModeStatus& SyncModeStatus::operator = (const SyncModeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnMode()) {
            setEnMode(rhs.getEnMode());
        } else {
            clearEnMode();
        }
    }
    return *this;
}

inline bool SyncModeStatus::operator == (const SyncModeStatus& rhs) const {
    return (((!hasEnMode() && !rhs.hasEnMode()) || getEnMode() == rhs.getEnMode()));
}

inline bool SyncModeStatus::operator != (const SyncModeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SyncModeStatus::operator < (const SyncModeStatus& rhs) const {
    if (hasEnMode() || rhs.hasEnMode()) {
        if ((uint32)getEnMode() < (uint32)rhs.getEnMode()) return true;
        if ((uint32)getEnMode() > (uint32)rhs.getEnMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SyncModeStatus::clone() {
    return new SyncModeStatus(*this);
}

inline bool SyncModeStatus::operator > (const SyncModeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SyncModeStatus::clear() {
    clearEnMode();
}

inline void SyncModeStatus::clearEnMode() {
    if (hasEnMode()) {
         clear_has_enMode();
        _enMode = ::clock_main_fi_types::VDCLK_TEN_SyncMode__VDCLK_EN_Sync_CanOrManual;
     }
}

inline bool SyncModeStatus::hasEnMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_SyncMode SyncModeStatus::getEnMode () const {
    return _enMode;
}

inline void SyncModeStatus::setEnMode (::clock_main_fi_types::VDCLK_TEN_SyncMode enMode_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_SyncMode_IsValid(enMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enMode_, "VDCLK_TEN_SyncMode", "enMode", "SyncModeStatus");
    }
    #endif
    set_has_enMode();
    this->_enMode = enMode_;
}

inline void SyncModeStatus::set_has_enMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SyncModeStatus::clear_has_enMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SyncModeSet::SyncModeSet ()  :
    _enMode (::clock_main_fi_types::VDCLK_TEN_SyncMode__VDCLK_EN_Sync_CanOrManual)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SyncModeSet::SyncModeSet (const SyncModeSet &rhs)  :
    ::asf::core::Payload(rhs),
    _enMode (::clock_main_fi_types::VDCLK_TEN_SyncMode__VDCLK_EN_Sync_CanOrManual)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SyncModeSet::SyncModeSet (::clock_main_fi_types::VDCLK_TEN_SyncMode enMode_)  :
    _enMode (enMode_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_SyncMode_IsValid(enMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enMode_, "VDCLK_TEN_SyncMode", "enMode", "SyncModeSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SyncModeSet::~SyncModeSet() {
}

inline SyncModeSet& SyncModeSet::operator = (const SyncModeSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnMode()) {
            setEnMode(rhs.getEnMode());
        } else {
            clearEnMode();
        }
    }
    return *this;
}

inline bool SyncModeSet::operator == (const SyncModeSet& rhs) const {
    return (((!hasEnMode() && !rhs.hasEnMode()) || getEnMode() == rhs.getEnMode()));
}

inline bool SyncModeSet::operator != (const SyncModeSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SyncModeSet::operator < (const SyncModeSet& rhs) const {
    if (hasEnMode() || rhs.hasEnMode()) {
        if ((uint32)getEnMode() < (uint32)rhs.getEnMode()) return true;
        if ((uint32)getEnMode() > (uint32)rhs.getEnMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SyncModeSet::clone() {
    return new SyncModeSet(*this);
}

inline bool SyncModeSet::operator > (const SyncModeSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SyncModeSet::clear() {
    clearEnMode();
}

inline void SyncModeSet::clearEnMode() {
    if (hasEnMode()) {
         clear_has_enMode();
        _enMode = ::clock_main_fi_types::VDCLK_TEN_SyncMode__VDCLK_EN_Sync_CanOrManual;
     }
}

inline bool SyncModeSet::hasEnMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_SyncMode SyncModeSet::getEnMode () const {
    return _enMode;
}

inline void SyncModeSet::setEnMode (::clock_main_fi_types::VDCLK_TEN_SyncMode enMode_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_SyncMode_IsValid(enMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enMode_, "VDCLK_TEN_SyncMode", "enMode", "SyncModeSet");
    }
    #endif
    set_has_enMode();
    this->_enMode = enMode_;
}

inline void SyncModeSet::set_has_enMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SyncModeSet::clear_has_enMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GPS_WeekEpochStatus::GPS_WeekEpochStatus ()  :
    _GPSepoch (::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH__VDCLK_EN_GPS_EPOCH_1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GPS_WeekEpochStatus::GPS_WeekEpochStatus (const GPS_WeekEpochStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _GPSepoch (::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH__VDCLK_EN_GPS_EPOCH_1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GPS_WeekEpochStatus::GPS_WeekEpochStatus (::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH GPSepoch_)  :
    _GPSepoch (GPSepoch_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH_IsValid(GPSepoch_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GPSepoch_, "VDCLK_TEN_GPS_EPOCH", "GPSepoch", "GPS_WeekEpochStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GPS_WeekEpochStatus::~GPS_WeekEpochStatus() {
}

inline GPS_WeekEpochStatus& GPS_WeekEpochStatus::operator = (const GPS_WeekEpochStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGPSepoch()) {
            setGPSepoch(rhs.getGPSepoch());
        } else {
            clearGPSepoch();
        }
    }
    return *this;
}

inline bool GPS_WeekEpochStatus::operator == (const GPS_WeekEpochStatus& rhs) const {
    return (((!hasGPSepoch() && !rhs.hasGPSepoch()) || getGPSepoch() == rhs.getGPSepoch()));
}

inline bool GPS_WeekEpochStatus::operator != (const GPS_WeekEpochStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool GPS_WeekEpochStatus::operator < (const GPS_WeekEpochStatus& rhs) const {
    if (hasGPSepoch() || rhs.hasGPSepoch()) {
        if ((uint32)getGPSepoch() < (uint32)rhs.getGPSepoch()) return true;
        if ((uint32)getGPSepoch() > (uint32)rhs.getGPSepoch()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GPS_WeekEpochStatus::clone() {
    return new GPS_WeekEpochStatus(*this);
}

inline bool GPS_WeekEpochStatus::operator > (const GPS_WeekEpochStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GPS_WeekEpochStatus::clear() {
    clearGPSepoch();
}

inline void GPS_WeekEpochStatus::clearGPSepoch() {
    if (hasGPSepoch()) {
         clear_has_GPSepoch();
        _GPSepoch = ::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH__VDCLK_EN_GPS_EPOCH_1;
     }
}

inline bool GPS_WeekEpochStatus::hasGPSepoch () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH GPS_WeekEpochStatus::getGPSepoch () const {
    return _GPSepoch;
}

inline void GPS_WeekEpochStatus::setGPSepoch (::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH GPSepoch_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH_IsValid(GPSepoch_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GPSepoch_, "VDCLK_TEN_GPS_EPOCH", "GPSepoch", "GPS_WeekEpochStatus");
    }
    #endif
    set_has_GPSepoch();
    this->_GPSepoch = GPSepoch_;
}

inline void GPS_WeekEpochStatus::set_has_GPSepoch () {
    _has_bits_[0] |= 1u << 0;
}

inline void GPS_WeekEpochStatus::clear_has_GPSepoch () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GPS_WeekEpochSet::GPS_WeekEpochSet ()  :
    _GPSepoch (::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH__VDCLK_EN_GPS_EPOCH_1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GPS_WeekEpochSet::GPS_WeekEpochSet (const GPS_WeekEpochSet &rhs)  :
    ::asf::core::Payload(rhs),
    _GPSepoch (::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH__VDCLK_EN_GPS_EPOCH_1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GPS_WeekEpochSet::GPS_WeekEpochSet (::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH GPSepoch_)  :
    _GPSepoch (GPSepoch_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH_IsValid(GPSepoch_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GPSepoch_, "VDCLK_TEN_GPS_EPOCH", "GPSepoch", "GPS_WeekEpochSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GPS_WeekEpochSet::~GPS_WeekEpochSet() {
}

inline GPS_WeekEpochSet& GPS_WeekEpochSet::operator = (const GPS_WeekEpochSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGPSepoch()) {
            setGPSepoch(rhs.getGPSepoch());
        } else {
            clearGPSepoch();
        }
    }
    return *this;
}

inline bool GPS_WeekEpochSet::operator == (const GPS_WeekEpochSet& rhs) const {
    return (((!hasGPSepoch() && !rhs.hasGPSepoch()) || getGPSepoch() == rhs.getGPSepoch()));
}

inline bool GPS_WeekEpochSet::operator != (const GPS_WeekEpochSet& rhs) const {
    return ! (*this == rhs);
}

inline bool GPS_WeekEpochSet::operator < (const GPS_WeekEpochSet& rhs) const {
    if (hasGPSepoch() || rhs.hasGPSepoch()) {
        if ((uint32)getGPSepoch() < (uint32)rhs.getGPSepoch()) return true;
        if ((uint32)getGPSepoch() > (uint32)rhs.getGPSepoch()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GPS_WeekEpochSet::clone() {
    return new GPS_WeekEpochSet(*this);
}

inline bool GPS_WeekEpochSet::operator > (const GPS_WeekEpochSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GPS_WeekEpochSet::clear() {
    clearGPSepoch();
}

inline void GPS_WeekEpochSet::clearGPSepoch() {
    if (hasGPSepoch()) {
         clear_has_GPSepoch();
        _GPSepoch = ::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH__VDCLK_EN_GPS_EPOCH_1;
     }
}

inline bool GPS_WeekEpochSet::hasGPSepoch () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH GPS_WeekEpochSet::getGPSepoch () const {
    return _GPSepoch;
}

inline void GPS_WeekEpochSet::setGPSepoch (::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH GPSepoch_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_GPS_EPOCH_IsValid(GPSepoch_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GPSepoch_, "VDCLK_TEN_GPS_EPOCH", "GPSepoch", "GPS_WeekEpochSet");
    }
    #endif
    set_has_GPSepoch();
    this->_GPSepoch = GPSepoch_;
}

inline void GPS_WeekEpochSet::set_has_GPSepoch () {
    _has_bits_[0] |= 1u << 0;
}

inline void GPS_WeekEpochSet::clear_has_GPSepoch () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  LocalTimeOffsetStatus::LocalTimeOffsetStatus ()  :
    _s64Offset_ScalarValue (0),
    _bIsOffsetPostive (false),
    _s16Offset_Year (0),
    _u8Offset_Month (0u),
    _u8Offset_Day (0u),
    _u8Offset_Hour (0u),
    _u8Offset_Minute (0u),
    _u8Offset_Second (0u),
    _u32UTCTimeDate_ScalarValue (0u),
    _s16UTCTimeDate_Year (0),
    _u8UTCTimeDate_Month (0u),
    _u8UTCTimeDate_Day (0u),
    _u8UTCTimeDate_Hour (0u),
    _u8UTCTimeDate_Minute (0u),
    _u8UTCTimeDate_Second (0u),
    _u8UTCTimeDate_Weekday (0u),
    _enGpsRtcTimeState (::clock_main_fi_types::VDCLK_TEN_GPSRTCTIMESTATE__VDCLK_EN_RTCTIMESTATE_EVER_SYNC)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LocalTimeOffsetStatus::LocalTimeOffsetStatus (const LocalTimeOffsetStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _s64Offset_ScalarValue (0),
    _bIsOffsetPostive (false),
    _s16Offset_Year (0),
    _u8Offset_Month (0u),
    _u8Offset_Day (0u),
    _u8Offset_Hour (0u),
    _u8Offset_Minute (0u),
    _u8Offset_Second (0u),
    _u32UTCTimeDate_ScalarValue (0u),
    _s16UTCTimeDate_Year (0),
    _u8UTCTimeDate_Month (0u),
    _u8UTCTimeDate_Day (0u),
    _u8UTCTimeDate_Hour (0u),
    _u8UTCTimeDate_Minute (0u),
    _u8UTCTimeDate_Second (0u),
    _u8UTCTimeDate_Weekday (0u),
    _enGpsRtcTimeState (::clock_main_fi_types::VDCLK_TEN_GPSRTCTIMESTATE__VDCLK_EN_RTCTIMESTATE_EVER_SYNC)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LocalTimeOffsetStatus::LocalTimeOffsetStatus (int64 s64Offset_ScalarValue_, bool bIsOffsetPostive_, int16 s16Offset_Year_, uint8 u8Offset_Month_, uint8 u8Offset_Day_, uint8 u8Offset_Hour_, uint8 u8Offset_Minute_, uint8 u8Offset_Second_, uint32 u32UTCTimeDate_ScalarValue_, int16 s16UTCTimeDate_Year_, uint8 u8UTCTimeDate_Month_, uint8 u8UTCTimeDate_Day_, uint8 u8UTCTimeDate_Hour_, uint8 u8UTCTimeDate_Minute_, uint8 u8UTCTimeDate_Second_, uint8 u8UTCTimeDate_Weekday_, ::clock_main_fi_types::VDCLK_TEN_GPSRTCTIMESTATE enGpsRtcTimeState_)  :
    _s64Offset_ScalarValue (s64Offset_ScalarValue_),
    _bIsOffsetPostive (bIsOffsetPostive_),
    _s16Offset_Year (s16Offset_Year_),
    _u8Offset_Month (u8Offset_Month_),
    _u8Offset_Day (u8Offset_Day_),
    _u8Offset_Hour (u8Offset_Hour_),
    _u8Offset_Minute (u8Offset_Minute_),
    _u8Offset_Second (u8Offset_Second_),
    _u32UTCTimeDate_ScalarValue (u32UTCTimeDate_ScalarValue_),
    _s16UTCTimeDate_Year (s16UTCTimeDate_Year_),
    _u8UTCTimeDate_Month (u8UTCTimeDate_Month_),
    _u8UTCTimeDate_Day (u8UTCTimeDate_Day_),
    _u8UTCTimeDate_Hour (u8UTCTimeDate_Hour_),
    _u8UTCTimeDate_Minute (u8UTCTimeDate_Minute_),
    _u8UTCTimeDate_Second (u8UTCTimeDate_Second_),
    _u8UTCTimeDate_Weekday (u8UTCTimeDate_Weekday_),
    _enGpsRtcTimeState (enGpsRtcTimeState_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_GPSRTCTIMESTATE_IsValid(enGpsRtcTimeState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enGpsRtcTimeState_, "VDCLK_TEN_GPSRTCTIMESTATE", "enGpsRtcTimeState", "LocalTimeOffsetStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LocalTimeOffsetStatus::~LocalTimeOffsetStatus() {
}

inline LocalTimeOffsetStatus& LocalTimeOffsetStatus::operator = (const LocalTimeOffsetStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS64Offset_ScalarValue()) {
            setS64Offset_ScalarValue(rhs.getS64Offset_ScalarValue());
        } else {
            clearS64Offset_ScalarValue();
        }
        if (rhs.hasBIsOffsetPostive()) {
            setBIsOffsetPostive(rhs.getBIsOffsetPostive());
        } else {
            clearBIsOffsetPostive();
        }
        if (rhs.hasS16Offset_Year()) {
            setS16Offset_Year(rhs.getS16Offset_Year());
        } else {
            clearS16Offset_Year();
        }
        if (rhs.hasU8Offset_Month()) {
            setU8Offset_Month(rhs.getU8Offset_Month());
        } else {
            clearU8Offset_Month();
        }
        if (rhs.hasU8Offset_Day()) {
            setU8Offset_Day(rhs.getU8Offset_Day());
        } else {
            clearU8Offset_Day();
        }
        if (rhs.hasU8Offset_Hour()) {
            setU8Offset_Hour(rhs.getU8Offset_Hour());
        } else {
            clearU8Offset_Hour();
        }
        if (rhs.hasU8Offset_Minute()) {
            setU8Offset_Minute(rhs.getU8Offset_Minute());
        } else {
            clearU8Offset_Minute();
        }
        if (rhs.hasU8Offset_Second()) {
            setU8Offset_Second(rhs.getU8Offset_Second());
        } else {
            clearU8Offset_Second();
        }
        if (rhs.hasU32UTCTimeDate_ScalarValue()) {
            setU32UTCTimeDate_ScalarValue(rhs.getU32UTCTimeDate_ScalarValue());
        } else {
            clearU32UTCTimeDate_ScalarValue();
        }
        if (rhs.hasS16UTCTimeDate_Year()) {
            setS16UTCTimeDate_Year(rhs.getS16UTCTimeDate_Year());
        } else {
            clearS16UTCTimeDate_Year();
        }
        if (rhs.hasU8UTCTimeDate_Month()) {
            setU8UTCTimeDate_Month(rhs.getU8UTCTimeDate_Month());
        } else {
            clearU8UTCTimeDate_Month();
        }
        if (rhs.hasU8UTCTimeDate_Day()) {
            setU8UTCTimeDate_Day(rhs.getU8UTCTimeDate_Day());
        } else {
            clearU8UTCTimeDate_Day();
        }
        if (rhs.hasU8UTCTimeDate_Hour()) {
            setU8UTCTimeDate_Hour(rhs.getU8UTCTimeDate_Hour());
        } else {
            clearU8UTCTimeDate_Hour();
        }
        if (rhs.hasU8UTCTimeDate_Minute()) {
            setU8UTCTimeDate_Minute(rhs.getU8UTCTimeDate_Minute());
        } else {
            clearU8UTCTimeDate_Minute();
        }
        if (rhs.hasU8UTCTimeDate_Second()) {
            setU8UTCTimeDate_Second(rhs.getU8UTCTimeDate_Second());
        } else {
            clearU8UTCTimeDate_Second();
        }
        if (rhs.hasU8UTCTimeDate_Weekday()) {
            setU8UTCTimeDate_Weekday(rhs.getU8UTCTimeDate_Weekday());
        } else {
            clearU8UTCTimeDate_Weekday();
        }
        if (rhs.hasEnGpsRtcTimeState()) {
            setEnGpsRtcTimeState(rhs.getEnGpsRtcTimeState());
        } else {
            clearEnGpsRtcTimeState();
        }
    }
    return *this;
}

inline bool LocalTimeOffsetStatus::operator == (const LocalTimeOffsetStatus& rhs) const {
    return (((!hasS64Offset_ScalarValue() && !rhs.hasS64Offset_ScalarValue()) || getS64Offset_ScalarValue() == rhs.getS64Offset_ScalarValue()) &&
        ((!hasBIsOffsetPostive() && !rhs.hasBIsOffsetPostive()) || getBIsOffsetPostive() == rhs.getBIsOffsetPostive()) &&
        ((!hasS16Offset_Year() && !rhs.hasS16Offset_Year()) || getS16Offset_Year() == rhs.getS16Offset_Year()) &&
        ((!hasU8Offset_Month() && !rhs.hasU8Offset_Month()) || getU8Offset_Month() == rhs.getU8Offset_Month()) &&
        ((!hasU8Offset_Day() && !rhs.hasU8Offset_Day()) || getU8Offset_Day() == rhs.getU8Offset_Day()) &&
        ((!hasU8Offset_Hour() && !rhs.hasU8Offset_Hour()) || getU8Offset_Hour() == rhs.getU8Offset_Hour()) &&
        ((!hasU8Offset_Minute() && !rhs.hasU8Offset_Minute()) || getU8Offset_Minute() == rhs.getU8Offset_Minute()) &&
        ((!hasU8Offset_Second() && !rhs.hasU8Offset_Second()) || getU8Offset_Second() == rhs.getU8Offset_Second()) &&
        ((!hasU32UTCTimeDate_ScalarValue() && !rhs.hasU32UTCTimeDate_ScalarValue()) || getU32UTCTimeDate_ScalarValue() == rhs.getU32UTCTimeDate_ScalarValue()) &&
        ((!hasS16UTCTimeDate_Year() && !rhs.hasS16UTCTimeDate_Year()) || getS16UTCTimeDate_Year() == rhs.getS16UTCTimeDate_Year()) &&
        ((!hasU8UTCTimeDate_Month() && !rhs.hasU8UTCTimeDate_Month()) || getU8UTCTimeDate_Month() == rhs.getU8UTCTimeDate_Month()) &&
        ((!hasU8UTCTimeDate_Day() && !rhs.hasU8UTCTimeDate_Day()) || getU8UTCTimeDate_Day() == rhs.getU8UTCTimeDate_Day()) &&
        ((!hasU8UTCTimeDate_Hour() && !rhs.hasU8UTCTimeDate_Hour()) || getU8UTCTimeDate_Hour() == rhs.getU8UTCTimeDate_Hour()) &&
        ((!hasU8UTCTimeDate_Minute() && !rhs.hasU8UTCTimeDate_Minute()) || getU8UTCTimeDate_Minute() == rhs.getU8UTCTimeDate_Minute()) &&
        ((!hasU8UTCTimeDate_Second() && !rhs.hasU8UTCTimeDate_Second()) || getU8UTCTimeDate_Second() == rhs.getU8UTCTimeDate_Second()) &&
        ((!hasU8UTCTimeDate_Weekday() && !rhs.hasU8UTCTimeDate_Weekday()) || getU8UTCTimeDate_Weekday() == rhs.getU8UTCTimeDate_Weekday()) &&
        ((!hasEnGpsRtcTimeState() && !rhs.hasEnGpsRtcTimeState()) || getEnGpsRtcTimeState() == rhs.getEnGpsRtcTimeState()));
}

inline bool LocalTimeOffsetStatus::operator != (const LocalTimeOffsetStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool LocalTimeOffsetStatus::operator < (const LocalTimeOffsetStatus& rhs) const {
    if (hasS64Offset_ScalarValue() || rhs.hasS64Offset_ScalarValue()) {
        if (getS64Offset_ScalarValue() < rhs.getS64Offset_ScalarValue()) return true;
        if (getS64Offset_ScalarValue() > rhs.getS64Offset_ScalarValue()) return false;
    }
    if (hasBIsOffsetPostive() || rhs.hasBIsOffsetPostive()) {
        if (getBIsOffsetPostive() < rhs.getBIsOffsetPostive()) return true;
        if (getBIsOffsetPostive() > rhs.getBIsOffsetPostive()) return false;
    }
    if (hasS16Offset_Year() || rhs.hasS16Offset_Year()) {
        if (getS16Offset_Year() < rhs.getS16Offset_Year()) return true;
        if (getS16Offset_Year() > rhs.getS16Offset_Year()) return false;
    }
    if (hasU8Offset_Month() || rhs.hasU8Offset_Month()) {
        if (getU8Offset_Month() < rhs.getU8Offset_Month()) return true;
        if (getU8Offset_Month() > rhs.getU8Offset_Month()) return false;
    }
    if (hasU8Offset_Day() || rhs.hasU8Offset_Day()) {
        if (getU8Offset_Day() < rhs.getU8Offset_Day()) return true;
        if (getU8Offset_Day() > rhs.getU8Offset_Day()) return false;
    }
    if (hasU8Offset_Hour() || rhs.hasU8Offset_Hour()) {
        if (getU8Offset_Hour() < rhs.getU8Offset_Hour()) return true;
        if (getU8Offset_Hour() > rhs.getU8Offset_Hour()) return false;
    }
    if (hasU8Offset_Minute() || rhs.hasU8Offset_Minute()) {
        if (getU8Offset_Minute() < rhs.getU8Offset_Minute()) return true;
        if (getU8Offset_Minute() > rhs.getU8Offset_Minute()) return false;
    }
    if (hasU8Offset_Second() || rhs.hasU8Offset_Second()) {
        if (getU8Offset_Second() < rhs.getU8Offset_Second()) return true;
        if (getU8Offset_Second() > rhs.getU8Offset_Second()) return false;
    }
    if (hasU32UTCTimeDate_ScalarValue() || rhs.hasU32UTCTimeDate_ScalarValue()) {
        if (getU32UTCTimeDate_ScalarValue() < rhs.getU32UTCTimeDate_ScalarValue()) return true;
        if (getU32UTCTimeDate_ScalarValue() > rhs.getU32UTCTimeDate_ScalarValue()) return false;
    }
    if (hasS16UTCTimeDate_Year() || rhs.hasS16UTCTimeDate_Year()) {
        if (getS16UTCTimeDate_Year() < rhs.getS16UTCTimeDate_Year()) return true;
        if (getS16UTCTimeDate_Year() > rhs.getS16UTCTimeDate_Year()) return false;
    }
    if (hasU8UTCTimeDate_Month() || rhs.hasU8UTCTimeDate_Month()) {
        if (getU8UTCTimeDate_Month() < rhs.getU8UTCTimeDate_Month()) return true;
        if (getU8UTCTimeDate_Month() > rhs.getU8UTCTimeDate_Month()) return false;
    }
    if (hasU8UTCTimeDate_Day() || rhs.hasU8UTCTimeDate_Day()) {
        if (getU8UTCTimeDate_Day() < rhs.getU8UTCTimeDate_Day()) return true;
        if (getU8UTCTimeDate_Day() > rhs.getU8UTCTimeDate_Day()) return false;
    }
    if (hasU8UTCTimeDate_Hour() || rhs.hasU8UTCTimeDate_Hour()) {
        if (getU8UTCTimeDate_Hour() < rhs.getU8UTCTimeDate_Hour()) return true;
        if (getU8UTCTimeDate_Hour() > rhs.getU8UTCTimeDate_Hour()) return false;
    }
    if (hasU8UTCTimeDate_Minute() || rhs.hasU8UTCTimeDate_Minute()) {
        if (getU8UTCTimeDate_Minute() < rhs.getU8UTCTimeDate_Minute()) return true;
        if (getU8UTCTimeDate_Minute() > rhs.getU8UTCTimeDate_Minute()) return false;
    }
    if (hasU8UTCTimeDate_Second() || rhs.hasU8UTCTimeDate_Second()) {
        if (getU8UTCTimeDate_Second() < rhs.getU8UTCTimeDate_Second()) return true;
        if (getU8UTCTimeDate_Second() > rhs.getU8UTCTimeDate_Second()) return false;
    }
    if (hasU8UTCTimeDate_Weekday() || rhs.hasU8UTCTimeDate_Weekday()) {
        if (getU8UTCTimeDate_Weekday() < rhs.getU8UTCTimeDate_Weekday()) return true;
        if (getU8UTCTimeDate_Weekday() > rhs.getU8UTCTimeDate_Weekday()) return false;
    }
    if (hasEnGpsRtcTimeState() || rhs.hasEnGpsRtcTimeState()) {
        if ((uint32)getEnGpsRtcTimeState() < (uint32)rhs.getEnGpsRtcTimeState()) return true;
        if ((uint32)getEnGpsRtcTimeState() > (uint32)rhs.getEnGpsRtcTimeState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LocalTimeOffsetStatus::clone() {
    return new LocalTimeOffsetStatus(*this);
}

inline bool LocalTimeOffsetStatus::operator > (const LocalTimeOffsetStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LocalTimeOffsetStatus::clear() {
    clearS64Offset_ScalarValue();
    clearBIsOffsetPostive();
    clearS16Offset_Year();
    clearU8Offset_Month();
    clearU8Offset_Day();
    clearU8Offset_Hour();
    clearU8Offset_Minute();
    clearU8Offset_Second();
    clearU32UTCTimeDate_ScalarValue();
    clearS16UTCTimeDate_Year();
    clearU8UTCTimeDate_Month();
    clearU8UTCTimeDate_Day();
    clearU8UTCTimeDate_Hour();
    clearU8UTCTimeDate_Minute();
    clearU8UTCTimeDate_Second();
    clearU8UTCTimeDate_Weekday();
    clearEnGpsRtcTimeState();
}

inline void LocalTimeOffsetStatus::clearS64Offset_ScalarValue() {
    if (hasS64Offset_ScalarValue()) {
         clear_has_s64Offset_ScalarValue();
        _s64Offset_ScalarValue = 0;
     }
}

inline bool LocalTimeOffsetStatus::hasS64Offset_ScalarValue () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int64 LocalTimeOffsetStatus::getS64Offset_ScalarValue () const {
    return _s64Offset_ScalarValue;
}

inline void LocalTimeOffsetStatus::setS64Offset_ScalarValue (int64 s64Offset_ScalarValue_) {
    set_has_s64Offset_ScalarValue();
    this->_s64Offset_ScalarValue = s64Offset_ScalarValue_;
}

inline void LocalTimeOffsetStatus::clearBIsOffsetPostive() {
    if (hasBIsOffsetPostive()) {
         clear_has_bIsOffsetPostive();
        _bIsOffsetPostive = false;
     }
}

inline bool LocalTimeOffsetStatus::hasBIsOffsetPostive () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool LocalTimeOffsetStatus::getBIsOffsetPostive () const {
    return _bIsOffsetPostive;
}

inline void LocalTimeOffsetStatus::setBIsOffsetPostive (bool bIsOffsetPostive_) {
    set_has_bIsOffsetPostive();
    this->_bIsOffsetPostive = bIsOffsetPostive_;
}

inline void LocalTimeOffsetStatus::clearS16Offset_Year() {
    if (hasS16Offset_Year()) {
         clear_has_s16Offset_Year();
        _s16Offset_Year = 0;
     }
}

inline bool LocalTimeOffsetStatus::hasS16Offset_Year () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int16 LocalTimeOffsetStatus::getS16Offset_Year () const {
    return _s16Offset_Year;
}

inline void LocalTimeOffsetStatus::setS16Offset_Year (int16 s16Offset_Year_) {
    set_has_s16Offset_Year();
    this->_s16Offset_Year = s16Offset_Year_;
}

inline void LocalTimeOffsetStatus::clearU8Offset_Month() {
    if (hasU8Offset_Month()) {
         clear_has_u8Offset_Month();
        _u8Offset_Month = 0u;
     }
}

inline bool LocalTimeOffsetStatus::hasU8Offset_Month () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 LocalTimeOffsetStatus::getU8Offset_Month () const {
    return _u8Offset_Month;
}

inline void LocalTimeOffsetStatus::setU8Offset_Month (uint8 u8Offset_Month_) {
    set_has_u8Offset_Month();
    this->_u8Offset_Month = u8Offset_Month_;
}

inline void LocalTimeOffsetStatus::clearU8Offset_Day() {
    if (hasU8Offset_Day()) {
         clear_has_u8Offset_Day();
        _u8Offset_Day = 0u;
     }
}

inline bool LocalTimeOffsetStatus::hasU8Offset_Day () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 LocalTimeOffsetStatus::getU8Offset_Day () const {
    return _u8Offset_Day;
}

inline void LocalTimeOffsetStatus::setU8Offset_Day (uint8 u8Offset_Day_) {
    set_has_u8Offset_Day();
    this->_u8Offset_Day = u8Offset_Day_;
}

inline void LocalTimeOffsetStatus::clearU8Offset_Hour() {
    if (hasU8Offset_Hour()) {
         clear_has_u8Offset_Hour();
        _u8Offset_Hour = 0u;
     }
}

inline bool LocalTimeOffsetStatus::hasU8Offset_Hour () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 LocalTimeOffsetStatus::getU8Offset_Hour () const {
    return _u8Offset_Hour;
}

inline void LocalTimeOffsetStatus::setU8Offset_Hour (uint8 u8Offset_Hour_) {
    set_has_u8Offset_Hour();
    this->_u8Offset_Hour = u8Offset_Hour_;
}

inline void LocalTimeOffsetStatus::clearU8Offset_Minute() {
    if (hasU8Offset_Minute()) {
         clear_has_u8Offset_Minute();
        _u8Offset_Minute = 0u;
     }
}

inline bool LocalTimeOffsetStatus::hasU8Offset_Minute () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 LocalTimeOffsetStatus::getU8Offset_Minute () const {
    return _u8Offset_Minute;
}

inline void LocalTimeOffsetStatus::setU8Offset_Minute (uint8 u8Offset_Minute_) {
    set_has_u8Offset_Minute();
    this->_u8Offset_Minute = u8Offset_Minute_;
}

inline void LocalTimeOffsetStatus::clearU8Offset_Second() {
    if (hasU8Offset_Second()) {
         clear_has_u8Offset_Second();
        _u8Offset_Second = 0u;
     }
}

inline bool LocalTimeOffsetStatus::hasU8Offset_Second () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 LocalTimeOffsetStatus::getU8Offset_Second () const {
    return _u8Offset_Second;
}

inline void LocalTimeOffsetStatus::setU8Offset_Second (uint8 u8Offset_Second_) {
    set_has_u8Offset_Second();
    this->_u8Offset_Second = u8Offset_Second_;
}

inline void LocalTimeOffsetStatus::clearU32UTCTimeDate_ScalarValue() {
    if (hasU32UTCTimeDate_ScalarValue()) {
         clear_has_u32UTCTimeDate_ScalarValue();
        _u32UTCTimeDate_ScalarValue = 0u;
     }
}

inline bool LocalTimeOffsetStatus::hasU32UTCTimeDate_ScalarValue () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint32 LocalTimeOffsetStatus::getU32UTCTimeDate_ScalarValue () const {
    return _u32UTCTimeDate_ScalarValue;
}

inline void LocalTimeOffsetStatus::setU32UTCTimeDate_ScalarValue (uint32 u32UTCTimeDate_ScalarValue_) {
    set_has_u32UTCTimeDate_ScalarValue();
    this->_u32UTCTimeDate_ScalarValue = u32UTCTimeDate_ScalarValue_;
}

inline void LocalTimeOffsetStatus::clearS16UTCTimeDate_Year() {
    if (hasS16UTCTimeDate_Year()) {
         clear_has_s16UTCTimeDate_Year();
        _s16UTCTimeDate_Year = 0;
     }
}

inline bool LocalTimeOffsetStatus::hasS16UTCTimeDate_Year () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline int16 LocalTimeOffsetStatus::getS16UTCTimeDate_Year () const {
    return _s16UTCTimeDate_Year;
}

inline void LocalTimeOffsetStatus::setS16UTCTimeDate_Year (int16 s16UTCTimeDate_Year_) {
    set_has_s16UTCTimeDate_Year();
    this->_s16UTCTimeDate_Year = s16UTCTimeDate_Year_;
}

inline void LocalTimeOffsetStatus::clearU8UTCTimeDate_Month() {
    if (hasU8UTCTimeDate_Month()) {
         clear_has_u8UTCTimeDate_Month();
        _u8UTCTimeDate_Month = 0u;
     }
}

inline bool LocalTimeOffsetStatus::hasU8UTCTimeDate_Month () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint8 LocalTimeOffsetStatus::getU8UTCTimeDate_Month () const {
    return _u8UTCTimeDate_Month;
}

inline void LocalTimeOffsetStatus::setU8UTCTimeDate_Month (uint8 u8UTCTimeDate_Month_) {
    set_has_u8UTCTimeDate_Month();
    this->_u8UTCTimeDate_Month = u8UTCTimeDate_Month_;
}

inline void LocalTimeOffsetStatus::clearU8UTCTimeDate_Day() {
    if (hasU8UTCTimeDate_Day()) {
         clear_has_u8UTCTimeDate_Day();
        _u8UTCTimeDate_Day = 0u;
     }
}

inline bool LocalTimeOffsetStatus::hasU8UTCTimeDate_Day () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline uint8 LocalTimeOffsetStatus::getU8UTCTimeDate_Day () const {
    return _u8UTCTimeDate_Day;
}

inline void LocalTimeOffsetStatus::setU8UTCTimeDate_Day (uint8 u8UTCTimeDate_Day_) {
    set_has_u8UTCTimeDate_Day();
    this->_u8UTCTimeDate_Day = u8UTCTimeDate_Day_;
}

inline void LocalTimeOffsetStatus::clearU8UTCTimeDate_Hour() {
    if (hasU8UTCTimeDate_Hour()) {
         clear_has_u8UTCTimeDate_Hour();
        _u8UTCTimeDate_Hour = 0u;
     }
}

inline bool LocalTimeOffsetStatus::hasU8UTCTimeDate_Hour () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint8 LocalTimeOffsetStatus::getU8UTCTimeDate_Hour () const {
    return _u8UTCTimeDate_Hour;
}

inline void LocalTimeOffsetStatus::setU8UTCTimeDate_Hour (uint8 u8UTCTimeDate_Hour_) {
    set_has_u8UTCTimeDate_Hour();
    this->_u8UTCTimeDate_Hour = u8UTCTimeDate_Hour_;
}

inline void LocalTimeOffsetStatus::clearU8UTCTimeDate_Minute() {
    if (hasU8UTCTimeDate_Minute()) {
         clear_has_u8UTCTimeDate_Minute();
        _u8UTCTimeDate_Minute = 0u;
     }
}

inline bool LocalTimeOffsetStatus::hasU8UTCTimeDate_Minute () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint8 LocalTimeOffsetStatus::getU8UTCTimeDate_Minute () const {
    return _u8UTCTimeDate_Minute;
}

inline void LocalTimeOffsetStatus::setU8UTCTimeDate_Minute (uint8 u8UTCTimeDate_Minute_) {
    set_has_u8UTCTimeDate_Minute();
    this->_u8UTCTimeDate_Minute = u8UTCTimeDate_Minute_;
}

inline void LocalTimeOffsetStatus::clearU8UTCTimeDate_Second() {
    if (hasU8UTCTimeDate_Second()) {
         clear_has_u8UTCTimeDate_Second();
        _u8UTCTimeDate_Second = 0u;
     }
}

inline bool LocalTimeOffsetStatus::hasU8UTCTimeDate_Second () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline uint8 LocalTimeOffsetStatus::getU8UTCTimeDate_Second () const {
    return _u8UTCTimeDate_Second;
}

inline void LocalTimeOffsetStatus::setU8UTCTimeDate_Second (uint8 u8UTCTimeDate_Second_) {
    set_has_u8UTCTimeDate_Second();
    this->_u8UTCTimeDate_Second = u8UTCTimeDate_Second_;
}

inline void LocalTimeOffsetStatus::clearU8UTCTimeDate_Weekday() {
    if (hasU8UTCTimeDate_Weekday()) {
         clear_has_u8UTCTimeDate_Weekday();
        _u8UTCTimeDate_Weekday = 0u;
     }
}

inline bool LocalTimeOffsetStatus::hasU8UTCTimeDate_Weekday () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint8 LocalTimeOffsetStatus::getU8UTCTimeDate_Weekday () const {
    return _u8UTCTimeDate_Weekday;
}

inline void LocalTimeOffsetStatus::setU8UTCTimeDate_Weekday (uint8 u8UTCTimeDate_Weekday_) {
    set_has_u8UTCTimeDate_Weekday();
    this->_u8UTCTimeDate_Weekday = u8UTCTimeDate_Weekday_;
}

inline void LocalTimeOffsetStatus::clearEnGpsRtcTimeState() {
    if (hasEnGpsRtcTimeState()) {
         clear_has_enGpsRtcTimeState();
        _enGpsRtcTimeState = ::clock_main_fi_types::VDCLK_TEN_GPSRTCTIMESTATE__VDCLK_EN_RTCTIMESTATE_EVER_SYNC;
     }
}

inline bool LocalTimeOffsetStatus::hasEnGpsRtcTimeState () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_GPSRTCTIMESTATE LocalTimeOffsetStatus::getEnGpsRtcTimeState () const {
    return _enGpsRtcTimeState;
}

inline void LocalTimeOffsetStatus::setEnGpsRtcTimeState (::clock_main_fi_types::VDCLK_TEN_GPSRTCTIMESTATE enGpsRtcTimeState_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_GPSRTCTIMESTATE_IsValid(enGpsRtcTimeState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enGpsRtcTimeState_, "VDCLK_TEN_GPSRTCTIMESTATE", "enGpsRtcTimeState", "LocalTimeOffsetStatus");
    }
    #endif
    set_has_enGpsRtcTimeState();
    this->_enGpsRtcTimeState = enGpsRtcTimeState_;
}

inline void LocalTimeOffsetStatus::set_has_s64Offset_ScalarValue () {
    _has_bits_[0] |= 1u << 0;
}

inline void LocalTimeOffsetStatus::clear_has_s64Offset_ScalarValue () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LocalTimeOffsetStatus::set_has_bIsOffsetPostive () {
    _has_bits_[0] |= 1u << 1;
}

inline void LocalTimeOffsetStatus::clear_has_bIsOffsetPostive () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void LocalTimeOffsetStatus::set_has_s16Offset_Year () {
    _has_bits_[0] |= 1u << 2;
}

inline void LocalTimeOffsetStatus::clear_has_s16Offset_Year () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void LocalTimeOffsetStatus::set_has_u8Offset_Month () {
    _has_bits_[0] |= 1u << 3;
}

inline void LocalTimeOffsetStatus::clear_has_u8Offset_Month () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void LocalTimeOffsetStatus::set_has_u8Offset_Day () {
    _has_bits_[0] |= 1u << 4;
}

inline void LocalTimeOffsetStatus::clear_has_u8Offset_Day () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void LocalTimeOffsetStatus::set_has_u8Offset_Hour () {
    _has_bits_[0] |= 1u << 5;
}

inline void LocalTimeOffsetStatus::clear_has_u8Offset_Hour () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void LocalTimeOffsetStatus::set_has_u8Offset_Minute () {
    _has_bits_[0] |= 1u << 6;
}

inline void LocalTimeOffsetStatus::clear_has_u8Offset_Minute () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void LocalTimeOffsetStatus::set_has_u8Offset_Second () {
    _has_bits_[0] |= 1u << 7;
}

inline void LocalTimeOffsetStatus::clear_has_u8Offset_Second () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void LocalTimeOffsetStatus::set_has_u32UTCTimeDate_ScalarValue () {
    _has_bits_[0] |= 1u << 8;
}

inline void LocalTimeOffsetStatus::clear_has_u32UTCTimeDate_ScalarValue () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void LocalTimeOffsetStatus::set_has_s16UTCTimeDate_Year () {
    _has_bits_[0] |= 1u << 9;
}

inline void LocalTimeOffsetStatus::clear_has_s16UTCTimeDate_Year () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void LocalTimeOffsetStatus::set_has_u8UTCTimeDate_Month () {
    _has_bits_[0] |= 1u << 10;
}

inline void LocalTimeOffsetStatus::clear_has_u8UTCTimeDate_Month () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void LocalTimeOffsetStatus::set_has_u8UTCTimeDate_Day () {
    _has_bits_[0] |= 1u << 11;
}

inline void LocalTimeOffsetStatus::clear_has_u8UTCTimeDate_Day () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void LocalTimeOffsetStatus::set_has_u8UTCTimeDate_Hour () {
    _has_bits_[0] |= 1u << 12;
}

inline void LocalTimeOffsetStatus::clear_has_u8UTCTimeDate_Hour () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void LocalTimeOffsetStatus::set_has_u8UTCTimeDate_Minute () {
    _has_bits_[0] |= 1u << 13;
}

inline void LocalTimeOffsetStatus::clear_has_u8UTCTimeDate_Minute () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void LocalTimeOffsetStatus::set_has_u8UTCTimeDate_Second () {
    _has_bits_[0] |= 1u << 14;
}

inline void LocalTimeOffsetStatus::clear_has_u8UTCTimeDate_Second () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void LocalTimeOffsetStatus::set_has_u8UTCTimeDate_Weekday () {
    _has_bits_[0] |= 1u << 15;
}

inline void LocalTimeOffsetStatus::clear_has_u8UTCTimeDate_Weekday () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void LocalTimeOffsetStatus::set_has_enGpsRtcTimeState () {
    _has_bits_[0] |= 1u << 16;
}

inline void LocalTimeOffsetStatus::clear_has_enGpsRtcTimeState () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline  LocalTimeDateStatus::LocalTimeDateStatus ()  :
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u),
    _u8TimeDateStatus (0u),
    _u32TimeDateValue (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LocalTimeDateStatus::LocalTimeDateStatus (const LocalTimeDateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u),
    _u8TimeDateStatus (0u),
    _u32TimeDateValue (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LocalTimeDateStatus::LocalTimeDateStatus (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_, uint8 u8TimeDateStatus_, uint32 u32TimeDateValue_)  :
    _s16Year (s16Year_),
    _u8Month (u8Month_),
    _u8Day (u8Day_),
    _u8Hours (u8Hours_),
    _u8Minutes (u8Minutes_),
    _u8Seconds (u8Seconds_),
    _u8Weekday (u8Weekday_),
    _u8TimeDateStatus (u8TimeDateStatus_),
    _u32TimeDateValue (u32TimeDateValue_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LocalTimeDateStatus::~LocalTimeDateStatus() {
}

inline LocalTimeDateStatus& LocalTimeDateStatus::operator = (const LocalTimeDateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS16Year()) {
            setS16Year(rhs.getS16Year());
        } else {
            clearS16Year();
        }
        if (rhs.hasU8Month()) {
            setU8Month(rhs.getU8Month());
        } else {
            clearU8Month();
        }
        if (rhs.hasU8Day()) {
            setU8Day(rhs.getU8Day());
        } else {
            clearU8Day();
        }
        if (rhs.hasU8Hours()) {
            setU8Hours(rhs.getU8Hours());
        } else {
            clearU8Hours();
        }
        if (rhs.hasU8Minutes()) {
            setU8Minutes(rhs.getU8Minutes());
        } else {
            clearU8Minutes();
        }
        if (rhs.hasU8Seconds()) {
            setU8Seconds(rhs.getU8Seconds());
        } else {
            clearU8Seconds();
        }
        if (rhs.hasU8Weekday()) {
            setU8Weekday(rhs.getU8Weekday());
        } else {
            clearU8Weekday();
        }
        if (rhs.hasU8TimeDateStatus()) {
            setU8TimeDateStatus(rhs.getU8TimeDateStatus());
        } else {
            clearU8TimeDateStatus();
        }
        if (rhs.hasU32TimeDateValue()) {
            setU32TimeDateValue(rhs.getU32TimeDateValue());
        } else {
            clearU32TimeDateValue();
        }
    }
    return *this;
}

inline bool LocalTimeDateStatus::operator == (const LocalTimeDateStatus& rhs) const {
    return (((!hasS16Year() && !rhs.hasS16Year()) || getS16Year() == rhs.getS16Year()) &&
        ((!hasU8Month() && !rhs.hasU8Month()) || getU8Month() == rhs.getU8Month()) &&
        ((!hasU8Day() && !rhs.hasU8Day()) || getU8Day() == rhs.getU8Day()) &&
        ((!hasU8Hours() && !rhs.hasU8Hours()) || getU8Hours() == rhs.getU8Hours()) &&
        ((!hasU8Minutes() && !rhs.hasU8Minutes()) || getU8Minutes() == rhs.getU8Minutes()) &&
        ((!hasU8Seconds() && !rhs.hasU8Seconds()) || getU8Seconds() == rhs.getU8Seconds()) &&
        ((!hasU8Weekday() && !rhs.hasU8Weekday()) || getU8Weekday() == rhs.getU8Weekday()) &&
        ((!hasU8TimeDateStatus() && !rhs.hasU8TimeDateStatus()) || getU8TimeDateStatus() == rhs.getU8TimeDateStatus()) &&
        ((!hasU32TimeDateValue() && !rhs.hasU32TimeDateValue()) || getU32TimeDateValue() == rhs.getU32TimeDateValue()));
}

inline bool LocalTimeDateStatus::operator != (const LocalTimeDateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool LocalTimeDateStatus::operator < (const LocalTimeDateStatus& rhs) const {
    if (hasS16Year() || rhs.hasS16Year()) {
        if (getS16Year() < rhs.getS16Year()) return true;
        if (getS16Year() > rhs.getS16Year()) return false;
    }
    if (hasU8Month() || rhs.hasU8Month()) {
        if (getU8Month() < rhs.getU8Month()) return true;
        if (getU8Month() > rhs.getU8Month()) return false;
    }
    if (hasU8Day() || rhs.hasU8Day()) {
        if (getU8Day() < rhs.getU8Day()) return true;
        if (getU8Day() > rhs.getU8Day()) return false;
    }
    if (hasU8Hours() || rhs.hasU8Hours()) {
        if (getU8Hours() < rhs.getU8Hours()) return true;
        if (getU8Hours() > rhs.getU8Hours()) return false;
    }
    if (hasU8Minutes() || rhs.hasU8Minutes()) {
        if (getU8Minutes() < rhs.getU8Minutes()) return true;
        if (getU8Minutes() > rhs.getU8Minutes()) return false;
    }
    if (hasU8Seconds() || rhs.hasU8Seconds()) {
        if (getU8Seconds() < rhs.getU8Seconds()) return true;
        if (getU8Seconds() > rhs.getU8Seconds()) return false;
    }
    if (hasU8Weekday() || rhs.hasU8Weekday()) {
        if (getU8Weekday() < rhs.getU8Weekday()) return true;
        if (getU8Weekday() > rhs.getU8Weekday()) return false;
    }
    if (hasU8TimeDateStatus() || rhs.hasU8TimeDateStatus()) {
        if (getU8TimeDateStatus() < rhs.getU8TimeDateStatus()) return true;
        if (getU8TimeDateStatus() > rhs.getU8TimeDateStatus()) return false;
    }
    if (hasU32TimeDateValue() || rhs.hasU32TimeDateValue()) {
        if (getU32TimeDateValue() < rhs.getU32TimeDateValue()) return true;
        if (getU32TimeDateValue() > rhs.getU32TimeDateValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LocalTimeDateStatus::clone() {
    return new LocalTimeDateStatus(*this);
}

inline bool LocalTimeDateStatus::operator > (const LocalTimeDateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LocalTimeDateStatus::clear() {
    clearS16Year();
    clearU8Month();
    clearU8Day();
    clearU8Hours();
    clearU8Minutes();
    clearU8Seconds();
    clearU8Weekday();
    clearU8TimeDateStatus();
    clearU32TimeDateValue();
}

inline void LocalTimeDateStatus::clearS16Year() {
    if (hasS16Year()) {
         clear_has_s16Year();
        _s16Year = 0;
     }
}

inline bool LocalTimeDateStatus::hasS16Year () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 LocalTimeDateStatus::getS16Year () const {
    return _s16Year;
}

inline void LocalTimeDateStatus::setS16Year (int16 s16Year_) {
    set_has_s16Year();
    this->_s16Year = s16Year_;
}

inline void LocalTimeDateStatus::clearU8Month() {
    if (hasU8Month()) {
         clear_has_u8Month();
        _u8Month = 0u;
     }
}

inline bool LocalTimeDateStatus::hasU8Month () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 LocalTimeDateStatus::getU8Month () const {
    return _u8Month;
}

inline void LocalTimeDateStatus::setU8Month (uint8 u8Month_) {
    set_has_u8Month();
    this->_u8Month = u8Month_;
}

inline void LocalTimeDateStatus::clearU8Day() {
    if (hasU8Day()) {
         clear_has_u8Day();
        _u8Day = 0u;
     }
}

inline bool LocalTimeDateStatus::hasU8Day () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 LocalTimeDateStatus::getU8Day () const {
    return _u8Day;
}

inline void LocalTimeDateStatus::setU8Day (uint8 u8Day_) {
    set_has_u8Day();
    this->_u8Day = u8Day_;
}

inline void LocalTimeDateStatus::clearU8Hours() {
    if (hasU8Hours()) {
         clear_has_u8Hours();
        _u8Hours = 0u;
     }
}

inline bool LocalTimeDateStatus::hasU8Hours () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 LocalTimeDateStatus::getU8Hours () const {
    return _u8Hours;
}

inline void LocalTimeDateStatus::setU8Hours (uint8 u8Hours_) {
    set_has_u8Hours();
    this->_u8Hours = u8Hours_;
}

inline void LocalTimeDateStatus::clearU8Minutes() {
    if (hasU8Minutes()) {
         clear_has_u8Minutes();
        _u8Minutes = 0u;
     }
}

inline bool LocalTimeDateStatus::hasU8Minutes () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 LocalTimeDateStatus::getU8Minutes () const {
    return _u8Minutes;
}

inline void LocalTimeDateStatus::setU8Minutes (uint8 u8Minutes_) {
    set_has_u8Minutes();
    this->_u8Minutes = u8Minutes_;
}

inline void LocalTimeDateStatus::clearU8Seconds() {
    if (hasU8Seconds()) {
         clear_has_u8Seconds();
        _u8Seconds = 0u;
     }
}

inline bool LocalTimeDateStatus::hasU8Seconds () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 LocalTimeDateStatus::getU8Seconds () const {
    return _u8Seconds;
}

inline void LocalTimeDateStatus::setU8Seconds (uint8 u8Seconds_) {
    set_has_u8Seconds();
    this->_u8Seconds = u8Seconds_;
}

inline void LocalTimeDateStatus::clearU8Weekday() {
    if (hasU8Weekday()) {
         clear_has_u8Weekday();
        _u8Weekday = 0u;
     }
}

inline bool LocalTimeDateStatus::hasU8Weekday () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 LocalTimeDateStatus::getU8Weekday () const {
    return _u8Weekday;
}

inline void LocalTimeDateStatus::setU8Weekday (uint8 u8Weekday_) {
    set_has_u8Weekday();
    this->_u8Weekday = u8Weekday_;
}

inline void LocalTimeDateStatus::clearU8TimeDateStatus() {
    if (hasU8TimeDateStatus()) {
         clear_has_u8TimeDateStatus();
        _u8TimeDateStatus = 0u;
     }
}

inline bool LocalTimeDateStatus::hasU8TimeDateStatus () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 LocalTimeDateStatus::getU8TimeDateStatus () const {
    return _u8TimeDateStatus;
}

inline void LocalTimeDateStatus::setU8TimeDateStatus (uint8 u8TimeDateStatus_) {
    set_has_u8TimeDateStatus();
    this->_u8TimeDateStatus = u8TimeDateStatus_;
}

inline void LocalTimeDateStatus::clearU32TimeDateValue() {
    if (hasU32TimeDateValue()) {
         clear_has_u32TimeDateValue();
        _u32TimeDateValue = 0u;
     }
}

inline bool LocalTimeDateStatus::hasU32TimeDateValue () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint32 LocalTimeDateStatus::getU32TimeDateValue () const {
    return _u32TimeDateValue;
}

inline void LocalTimeDateStatus::setU32TimeDateValue (uint32 u32TimeDateValue_) {
    set_has_u32TimeDateValue();
    this->_u32TimeDateValue = u32TimeDateValue_;
}

inline void LocalTimeDateStatus::set_has_s16Year () {
    _has_bits_[0] |= 1u << 0;
}

inline void LocalTimeDateStatus::clear_has_s16Year () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LocalTimeDateStatus::set_has_u8Month () {
    _has_bits_[0] |= 1u << 1;
}

inline void LocalTimeDateStatus::clear_has_u8Month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void LocalTimeDateStatus::set_has_u8Day () {
    _has_bits_[0] |= 1u << 2;
}

inline void LocalTimeDateStatus::clear_has_u8Day () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void LocalTimeDateStatus::set_has_u8Hours () {
    _has_bits_[0] |= 1u << 3;
}

inline void LocalTimeDateStatus::clear_has_u8Hours () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void LocalTimeDateStatus::set_has_u8Minutes () {
    _has_bits_[0] |= 1u << 4;
}

inline void LocalTimeDateStatus::clear_has_u8Minutes () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void LocalTimeDateStatus::set_has_u8Seconds () {
    _has_bits_[0] |= 1u << 5;
}

inline void LocalTimeDateStatus::clear_has_u8Seconds () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void LocalTimeDateStatus::set_has_u8Weekday () {
    _has_bits_[0] |= 1u << 6;
}

inline void LocalTimeDateStatus::clear_has_u8Weekday () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void LocalTimeDateStatus::set_has_u8TimeDateStatus () {
    _has_bits_[0] |= 1u << 7;
}

inline void LocalTimeDateStatus::clear_has_u8TimeDateStatus () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void LocalTimeDateStatus::set_has_u32TimeDateValue () {
    _has_bits_[0] |= 1u << 8;
}

inline void LocalTimeDateStatus::clear_has_u32TimeDateValue () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  LocalTimeDateSet::LocalTimeDateSet ()  :
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u),
    _u8ChangeMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LocalTimeDateSet::LocalTimeDateSet (const LocalTimeDateSet &rhs)  :
    ::asf::core::Payload(rhs),
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u),
    _u8ChangeMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LocalTimeDateSet::LocalTimeDateSet (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_, uint8 u8ChangeMask_)  :
    _s16Year (s16Year_),
    _u8Month (u8Month_),
    _u8Day (u8Day_),
    _u8Hours (u8Hours_),
    _u8Minutes (u8Minutes_),
    _u8Seconds (u8Seconds_),
    _u8Weekday (u8Weekday_),
    _u8ChangeMask (u8ChangeMask_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LocalTimeDateSet::~LocalTimeDateSet() {
}

inline LocalTimeDateSet& LocalTimeDateSet::operator = (const LocalTimeDateSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS16Year()) {
            setS16Year(rhs.getS16Year());
        } else {
            clearS16Year();
        }
        if (rhs.hasU8Month()) {
            setU8Month(rhs.getU8Month());
        } else {
            clearU8Month();
        }
        if (rhs.hasU8Day()) {
            setU8Day(rhs.getU8Day());
        } else {
            clearU8Day();
        }
        if (rhs.hasU8Hours()) {
            setU8Hours(rhs.getU8Hours());
        } else {
            clearU8Hours();
        }
        if (rhs.hasU8Minutes()) {
            setU8Minutes(rhs.getU8Minutes());
        } else {
            clearU8Minutes();
        }
        if (rhs.hasU8Seconds()) {
            setU8Seconds(rhs.getU8Seconds());
        } else {
            clearU8Seconds();
        }
        if (rhs.hasU8Weekday()) {
            setU8Weekday(rhs.getU8Weekday());
        } else {
            clearU8Weekday();
        }
        if (rhs.hasU8ChangeMask()) {
            setU8ChangeMask(rhs.getU8ChangeMask());
        } else {
            clearU8ChangeMask();
        }
    }
    return *this;
}

inline bool LocalTimeDateSet::operator == (const LocalTimeDateSet& rhs) const {
    return (((!hasS16Year() && !rhs.hasS16Year()) || getS16Year() == rhs.getS16Year()) &&
        ((!hasU8Month() && !rhs.hasU8Month()) || getU8Month() == rhs.getU8Month()) &&
        ((!hasU8Day() && !rhs.hasU8Day()) || getU8Day() == rhs.getU8Day()) &&
        ((!hasU8Hours() && !rhs.hasU8Hours()) || getU8Hours() == rhs.getU8Hours()) &&
        ((!hasU8Minutes() && !rhs.hasU8Minutes()) || getU8Minutes() == rhs.getU8Minutes()) &&
        ((!hasU8Seconds() && !rhs.hasU8Seconds()) || getU8Seconds() == rhs.getU8Seconds()) &&
        ((!hasU8Weekday() && !rhs.hasU8Weekday()) || getU8Weekday() == rhs.getU8Weekday()) &&
        ((!hasU8ChangeMask() && !rhs.hasU8ChangeMask()) || getU8ChangeMask() == rhs.getU8ChangeMask()));
}

inline bool LocalTimeDateSet::operator != (const LocalTimeDateSet& rhs) const {
    return ! (*this == rhs);
}

inline bool LocalTimeDateSet::operator < (const LocalTimeDateSet& rhs) const {
    if (hasS16Year() || rhs.hasS16Year()) {
        if (getS16Year() < rhs.getS16Year()) return true;
        if (getS16Year() > rhs.getS16Year()) return false;
    }
    if (hasU8Month() || rhs.hasU8Month()) {
        if (getU8Month() < rhs.getU8Month()) return true;
        if (getU8Month() > rhs.getU8Month()) return false;
    }
    if (hasU8Day() || rhs.hasU8Day()) {
        if (getU8Day() < rhs.getU8Day()) return true;
        if (getU8Day() > rhs.getU8Day()) return false;
    }
    if (hasU8Hours() || rhs.hasU8Hours()) {
        if (getU8Hours() < rhs.getU8Hours()) return true;
        if (getU8Hours() > rhs.getU8Hours()) return false;
    }
    if (hasU8Minutes() || rhs.hasU8Minutes()) {
        if (getU8Minutes() < rhs.getU8Minutes()) return true;
        if (getU8Minutes() > rhs.getU8Minutes()) return false;
    }
    if (hasU8Seconds() || rhs.hasU8Seconds()) {
        if (getU8Seconds() < rhs.getU8Seconds()) return true;
        if (getU8Seconds() > rhs.getU8Seconds()) return false;
    }
    if (hasU8Weekday() || rhs.hasU8Weekday()) {
        if (getU8Weekday() < rhs.getU8Weekday()) return true;
        if (getU8Weekday() > rhs.getU8Weekday()) return false;
    }
    if (hasU8ChangeMask() || rhs.hasU8ChangeMask()) {
        if (getU8ChangeMask() < rhs.getU8ChangeMask()) return true;
        if (getU8ChangeMask() > rhs.getU8ChangeMask()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LocalTimeDateSet::clone() {
    return new LocalTimeDateSet(*this);
}

inline bool LocalTimeDateSet::operator > (const LocalTimeDateSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LocalTimeDateSet::clear() {
    clearS16Year();
    clearU8Month();
    clearU8Day();
    clearU8Hours();
    clearU8Minutes();
    clearU8Seconds();
    clearU8Weekday();
    clearU8ChangeMask();
}

inline void LocalTimeDateSet::clearS16Year() {
    if (hasS16Year()) {
         clear_has_s16Year();
        _s16Year = 0;
     }
}

inline bool LocalTimeDateSet::hasS16Year () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 LocalTimeDateSet::getS16Year () const {
    return _s16Year;
}

inline void LocalTimeDateSet::setS16Year (int16 s16Year_) {
    set_has_s16Year();
    this->_s16Year = s16Year_;
}

inline void LocalTimeDateSet::clearU8Month() {
    if (hasU8Month()) {
         clear_has_u8Month();
        _u8Month = 0u;
     }
}

inline bool LocalTimeDateSet::hasU8Month () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 LocalTimeDateSet::getU8Month () const {
    return _u8Month;
}

inline void LocalTimeDateSet::setU8Month (uint8 u8Month_) {
    set_has_u8Month();
    this->_u8Month = u8Month_;
}

inline void LocalTimeDateSet::clearU8Day() {
    if (hasU8Day()) {
         clear_has_u8Day();
        _u8Day = 0u;
     }
}

inline bool LocalTimeDateSet::hasU8Day () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 LocalTimeDateSet::getU8Day () const {
    return _u8Day;
}

inline void LocalTimeDateSet::setU8Day (uint8 u8Day_) {
    set_has_u8Day();
    this->_u8Day = u8Day_;
}

inline void LocalTimeDateSet::clearU8Hours() {
    if (hasU8Hours()) {
         clear_has_u8Hours();
        _u8Hours = 0u;
     }
}

inline bool LocalTimeDateSet::hasU8Hours () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 LocalTimeDateSet::getU8Hours () const {
    return _u8Hours;
}

inline void LocalTimeDateSet::setU8Hours (uint8 u8Hours_) {
    set_has_u8Hours();
    this->_u8Hours = u8Hours_;
}

inline void LocalTimeDateSet::clearU8Minutes() {
    if (hasU8Minutes()) {
         clear_has_u8Minutes();
        _u8Minutes = 0u;
     }
}

inline bool LocalTimeDateSet::hasU8Minutes () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 LocalTimeDateSet::getU8Minutes () const {
    return _u8Minutes;
}

inline void LocalTimeDateSet::setU8Minutes (uint8 u8Minutes_) {
    set_has_u8Minutes();
    this->_u8Minutes = u8Minutes_;
}

inline void LocalTimeDateSet::clearU8Seconds() {
    if (hasU8Seconds()) {
         clear_has_u8Seconds();
        _u8Seconds = 0u;
     }
}

inline bool LocalTimeDateSet::hasU8Seconds () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 LocalTimeDateSet::getU8Seconds () const {
    return _u8Seconds;
}

inline void LocalTimeDateSet::setU8Seconds (uint8 u8Seconds_) {
    set_has_u8Seconds();
    this->_u8Seconds = u8Seconds_;
}

inline void LocalTimeDateSet::clearU8Weekday() {
    if (hasU8Weekday()) {
         clear_has_u8Weekday();
        _u8Weekday = 0u;
     }
}

inline bool LocalTimeDateSet::hasU8Weekday () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 LocalTimeDateSet::getU8Weekday () const {
    return _u8Weekday;
}

inline void LocalTimeDateSet::setU8Weekday (uint8 u8Weekday_) {
    set_has_u8Weekday();
    this->_u8Weekday = u8Weekday_;
}

inline void LocalTimeDateSet::clearU8ChangeMask() {
    if (hasU8ChangeMask()) {
         clear_has_u8ChangeMask();
        _u8ChangeMask = 0u;
     }
}

inline bool LocalTimeDateSet::hasU8ChangeMask () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 LocalTimeDateSet::getU8ChangeMask () const {
    return _u8ChangeMask;
}

inline void LocalTimeDateSet::setU8ChangeMask (uint8 u8ChangeMask_) {
    set_has_u8ChangeMask();
    this->_u8ChangeMask = u8ChangeMask_;
}

inline void LocalTimeDateSet::set_has_s16Year () {
    _has_bits_[0] |= 1u << 0;
}

inline void LocalTimeDateSet::clear_has_s16Year () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LocalTimeDateSet::set_has_u8Month () {
    _has_bits_[0] |= 1u << 1;
}

inline void LocalTimeDateSet::clear_has_u8Month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void LocalTimeDateSet::set_has_u8Day () {
    _has_bits_[0] |= 1u << 2;
}

inline void LocalTimeDateSet::clear_has_u8Day () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void LocalTimeDateSet::set_has_u8Hours () {
    _has_bits_[0] |= 1u << 3;
}

inline void LocalTimeDateSet::clear_has_u8Hours () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void LocalTimeDateSet::set_has_u8Minutes () {
    _has_bits_[0] |= 1u << 4;
}

inline void LocalTimeDateSet::clear_has_u8Minutes () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void LocalTimeDateSet::set_has_u8Seconds () {
    _has_bits_[0] |= 1u << 5;
}

inline void LocalTimeDateSet::clear_has_u8Seconds () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void LocalTimeDateSet::set_has_u8Weekday () {
    _has_bits_[0] |= 1u << 6;
}

inline void LocalTimeDateSet::clear_has_u8Weekday () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void LocalTimeDateSet::set_has_u8ChangeMask () {
    _has_bits_[0] |= 1u << 7;
}

inline void LocalTimeDateSet::clear_has_u8ChangeMask () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  LocalTimeDateUpReg::LocalTimeDateUpReg ()  :
    _u8UpdatePeriod (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LocalTimeDateUpReg::LocalTimeDateUpReg (const LocalTimeDateUpReg &rhs)  :
    ::asf::core::Payload(rhs),
    _u8UpdatePeriod (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LocalTimeDateUpReg::LocalTimeDateUpReg (uint8 u8UpdatePeriod_)  :
    _u8UpdatePeriod (u8UpdatePeriod_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LocalTimeDateUpReg::~LocalTimeDateUpReg() {
}

inline LocalTimeDateUpReg& LocalTimeDateUpReg::operator = (const LocalTimeDateUpReg& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8UpdatePeriod()) {
            setU8UpdatePeriod(rhs.getU8UpdatePeriod());
        } else {
            clearU8UpdatePeriod();
        }
    }
    return *this;
}

inline bool LocalTimeDateUpReg::operator == (const LocalTimeDateUpReg& rhs) const {
    return (((!hasU8UpdatePeriod() && !rhs.hasU8UpdatePeriod()) || getU8UpdatePeriod() == rhs.getU8UpdatePeriod()));
}

inline bool LocalTimeDateUpReg::operator != (const LocalTimeDateUpReg& rhs) const {
    return ! (*this == rhs);
}

inline bool LocalTimeDateUpReg::operator < (const LocalTimeDateUpReg& rhs) const {
    if (hasU8UpdatePeriod() || rhs.hasU8UpdatePeriod()) {
        if (getU8UpdatePeriod() < rhs.getU8UpdatePeriod()) return true;
        if (getU8UpdatePeriod() > rhs.getU8UpdatePeriod()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LocalTimeDateUpReg::clone() {
    return new LocalTimeDateUpReg(*this);
}

inline bool LocalTimeDateUpReg::operator > (const LocalTimeDateUpReg& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LocalTimeDateUpReg::clear() {
    clearU8UpdatePeriod();
}

inline void LocalTimeDateUpReg::clearU8UpdatePeriod() {
    if (hasU8UpdatePeriod()) {
         clear_has_u8UpdatePeriod();
        _u8UpdatePeriod = 0u;
     }
}

inline bool LocalTimeDateUpReg::hasU8UpdatePeriod () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 LocalTimeDateUpReg::getU8UpdatePeriod () const {
    return _u8UpdatePeriod;
}

inline void LocalTimeDateUpReg::setU8UpdatePeriod (uint8 u8UpdatePeriod_) {
    set_has_u8UpdatePeriod();
    this->_u8UpdatePeriod = u8UpdatePeriod_;
}

inline void LocalTimeDateUpReg::set_has_u8UpdatePeriod () {
    _has_bits_[0] |= 1u << 0;
}

inline void LocalTimeDateUpReg::clear_has_u8UpdatePeriod () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  LocalTimeDateRelUpReg::LocalTimeDateRelUpReg ()  :
    _u8UpdatePeriod (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LocalTimeDateRelUpReg::LocalTimeDateRelUpReg (const LocalTimeDateRelUpReg &rhs)  :
    ::asf::core::Payload(rhs),
    _u8UpdatePeriod (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LocalTimeDateRelUpReg::LocalTimeDateRelUpReg (uint8 u8UpdatePeriod_)  :
    _u8UpdatePeriod (u8UpdatePeriod_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LocalTimeDateRelUpReg::~LocalTimeDateRelUpReg() {
}

inline LocalTimeDateRelUpReg& LocalTimeDateRelUpReg::operator = (const LocalTimeDateRelUpReg& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8UpdatePeriod()) {
            setU8UpdatePeriod(rhs.getU8UpdatePeriod());
        } else {
            clearU8UpdatePeriod();
        }
    }
    return *this;
}

inline bool LocalTimeDateRelUpReg::operator == (const LocalTimeDateRelUpReg& rhs) const {
    return (((!hasU8UpdatePeriod() && !rhs.hasU8UpdatePeriod()) || getU8UpdatePeriod() == rhs.getU8UpdatePeriod()));
}

inline bool LocalTimeDateRelUpReg::operator != (const LocalTimeDateRelUpReg& rhs) const {
    return ! (*this == rhs);
}

inline bool LocalTimeDateRelUpReg::operator < (const LocalTimeDateRelUpReg& rhs) const {
    if (hasU8UpdatePeriod() || rhs.hasU8UpdatePeriod()) {
        if (getU8UpdatePeriod() < rhs.getU8UpdatePeriod()) return true;
        if (getU8UpdatePeriod() > rhs.getU8UpdatePeriod()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LocalTimeDateRelUpReg::clone() {
    return new LocalTimeDateRelUpReg(*this);
}

inline bool LocalTimeDateRelUpReg::operator > (const LocalTimeDateRelUpReg& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LocalTimeDateRelUpReg::clear() {
    clearU8UpdatePeriod();
}

inline void LocalTimeDateRelUpReg::clearU8UpdatePeriod() {
    if (hasU8UpdatePeriod()) {
         clear_has_u8UpdatePeriod();
        _u8UpdatePeriod = 0u;
     }
}

inline bool LocalTimeDateRelUpReg::hasU8UpdatePeriod () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 LocalTimeDateRelUpReg::getU8UpdatePeriod () const {
    return _u8UpdatePeriod;
}

inline void LocalTimeDateRelUpReg::setU8UpdatePeriod (uint8 u8UpdatePeriod_) {
    set_has_u8UpdatePeriod();
    this->_u8UpdatePeriod = u8UpdatePeriod_;
}

inline void LocalTimeDateRelUpReg::set_has_u8UpdatePeriod () {
    _has_bits_[0] |= 1u << 0;
}

inline void LocalTimeDateRelUpReg::clear_has_u8UpdatePeriod () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TimeFormatStatus::TimeFormatStatus ()  :
    _enTimeFormat (::clock_main_fi_types::VDCLK_TEN_TimeFormat__VDCLK_EN_TF_Mode12)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TimeFormatStatus::TimeFormatStatus (const TimeFormatStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _enTimeFormat (::clock_main_fi_types::VDCLK_TEN_TimeFormat__VDCLK_EN_TF_Mode12)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TimeFormatStatus::TimeFormatStatus (::clock_main_fi_types::VDCLK_TEN_TimeFormat enTimeFormat_)  :
    _enTimeFormat (enTimeFormat_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_TimeFormat_IsValid(enTimeFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTimeFormat_, "VDCLK_TEN_TimeFormat", "enTimeFormat", "TimeFormatStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TimeFormatStatus::~TimeFormatStatus() {
}

inline TimeFormatStatus& TimeFormatStatus::operator = (const TimeFormatStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnTimeFormat()) {
            setEnTimeFormat(rhs.getEnTimeFormat());
        } else {
            clearEnTimeFormat();
        }
    }
    return *this;
}

inline bool TimeFormatStatus::operator == (const TimeFormatStatus& rhs) const {
    return (((!hasEnTimeFormat() && !rhs.hasEnTimeFormat()) || getEnTimeFormat() == rhs.getEnTimeFormat()));
}

inline bool TimeFormatStatus::operator != (const TimeFormatStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool TimeFormatStatus::operator < (const TimeFormatStatus& rhs) const {
    if (hasEnTimeFormat() || rhs.hasEnTimeFormat()) {
        if ((uint32)getEnTimeFormat() < (uint32)rhs.getEnTimeFormat()) return true;
        if ((uint32)getEnTimeFormat() > (uint32)rhs.getEnTimeFormat()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TimeFormatStatus::clone() {
    return new TimeFormatStatus(*this);
}

inline bool TimeFormatStatus::operator > (const TimeFormatStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TimeFormatStatus::clear() {
    clearEnTimeFormat();
}

inline void TimeFormatStatus::clearEnTimeFormat() {
    if (hasEnTimeFormat()) {
         clear_has_enTimeFormat();
        _enTimeFormat = ::clock_main_fi_types::VDCLK_TEN_TimeFormat__VDCLK_EN_TF_Mode12;
     }
}

inline bool TimeFormatStatus::hasEnTimeFormat () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_TimeFormat TimeFormatStatus::getEnTimeFormat () const {
    return _enTimeFormat;
}

inline void TimeFormatStatus::setEnTimeFormat (::clock_main_fi_types::VDCLK_TEN_TimeFormat enTimeFormat_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_TimeFormat_IsValid(enTimeFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTimeFormat_, "VDCLK_TEN_TimeFormat", "enTimeFormat", "TimeFormatStatus");
    }
    #endif
    set_has_enTimeFormat();
    this->_enTimeFormat = enTimeFormat_;
}

inline void TimeFormatStatus::set_has_enTimeFormat () {
    _has_bits_[0] |= 1u << 0;
}

inline void TimeFormatStatus::clear_has_enTimeFormat () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TimeFormatSet::TimeFormatSet ()  :
    _enTimeFormat (::clock_main_fi_types::VDCLK_TEN_TimeFormat__VDCLK_EN_TF_Mode12)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TimeFormatSet::TimeFormatSet (const TimeFormatSet &rhs)  :
    ::asf::core::Payload(rhs),
    _enTimeFormat (::clock_main_fi_types::VDCLK_TEN_TimeFormat__VDCLK_EN_TF_Mode12)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TimeFormatSet::TimeFormatSet (::clock_main_fi_types::VDCLK_TEN_TimeFormat enTimeFormat_)  :
    _enTimeFormat (enTimeFormat_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_TimeFormat_IsValid(enTimeFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTimeFormat_, "VDCLK_TEN_TimeFormat", "enTimeFormat", "TimeFormatSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TimeFormatSet::~TimeFormatSet() {
}

inline TimeFormatSet& TimeFormatSet::operator = (const TimeFormatSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnTimeFormat()) {
            setEnTimeFormat(rhs.getEnTimeFormat());
        } else {
            clearEnTimeFormat();
        }
    }
    return *this;
}

inline bool TimeFormatSet::operator == (const TimeFormatSet& rhs) const {
    return (((!hasEnTimeFormat() && !rhs.hasEnTimeFormat()) || getEnTimeFormat() == rhs.getEnTimeFormat()));
}

inline bool TimeFormatSet::operator != (const TimeFormatSet& rhs) const {
    return ! (*this == rhs);
}

inline bool TimeFormatSet::operator < (const TimeFormatSet& rhs) const {
    if (hasEnTimeFormat() || rhs.hasEnTimeFormat()) {
        if ((uint32)getEnTimeFormat() < (uint32)rhs.getEnTimeFormat()) return true;
        if ((uint32)getEnTimeFormat() > (uint32)rhs.getEnTimeFormat()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TimeFormatSet::clone() {
    return new TimeFormatSet(*this);
}

inline bool TimeFormatSet::operator > (const TimeFormatSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TimeFormatSet::clear() {
    clearEnTimeFormat();
}

inline void TimeFormatSet::clearEnTimeFormat() {
    if (hasEnTimeFormat()) {
         clear_has_enTimeFormat();
        _enTimeFormat = ::clock_main_fi_types::VDCLK_TEN_TimeFormat__VDCLK_EN_TF_Mode12;
     }
}

inline bool TimeFormatSet::hasEnTimeFormat () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_TimeFormat TimeFormatSet::getEnTimeFormat () const {
    return _enTimeFormat;
}

inline void TimeFormatSet::setEnTimeFormat (::clock_main_fi_types::VDCLK_TEN_TimeFormat enTimeFormat_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_TimeFormat_IsValid(enTimeFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTimeFormat_, "VDCLK_TEN_TimeFormat", "enTimeFormat", "TimeFormatSet");
    }
    #endif
    set_has_enTimeFormat();
    this->_enTimeFormat = enTimeFormat_;
}

inline void TimeFormatSet::set_has_enTimeFormat () {
    _has_bits_[0] |= 1u << 0;
}

inline void TimeFormatSet::clear_has_enTimeFormat () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DateFormatStatus::DateFormatStatus ()  :
    _enDateFormat (::clock_main_fi_types::VDCLK_TEN_DateFormat__VDCLK_EN_DF_dd_mm_yyyy_dash)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DateFormatStatus::DateFormatStatus (const DateFormatStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _enDateFormat (::clock_main_fi_types::VDCLK_TEN_DateFormat__VDCLK_EN_DF_dd_mm_yyyy_dash)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DateFormatStatus::DateFormatStatus (::clock_main_fi_types::VDCLK_TEN_DateFormat enDateFormat_)  :
    _enDateFormat (enDateFormat_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_DateFormat_IsValid(enDateFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDateFormat_, "VDCLK_TEN_DateFormat", "enDateFormat", "DateFormatStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DateFormatStatus::~DateFormatStatus() {
}

inline DateFormatStatus& DateFormatStatus::operator = (const DateFormatStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnDateFormat()) {
            setEnDateFormat(rhs.getEnDateFormat());
        } else {
            clearEnDateFormat();
        }
    }
    return *this;
}

inline bool DateFormatStatus::operator == (const DateFormatStatus& rhs) const {
    return (((!hasEnDateFormat() && !rhs.hasEnDateFormat()) || getEnDateFormat() == rhs.getEnDateFormat()));
}

inline bool DateFormatStatus::operator != (const DateFormatStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DateFormatStatus::operator < (const DateFormatStatus& rhs) const {
    if (hasEnDateFormat() || rhs.hasEnDateFormat()) {
        if ((uint32)getEnDateFormat() < (uint32)rhs.getEnDateFormat()) return true;
        if ((uint32)getEnDateFormat() > (uint32)rhs.getEnDateFormat()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DateFormatStatus::clone() {
    return new DateFormatStatus(*this);
}

inline bool DateFormatStatus::operator > (const DateFormatStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DateFormatStatus::clear() {
    clearEnDateFormat();
}

inline void DateFormatStatus::clearEnDateFormat() {
    if (hasEnDateFormat()) {
         clear_has_enDateFormat();
        _enDateFormat = ::clock_main_fi_types::VDCLK_TEN_DateFormat__VDCLK_EN_DF_dd_mm_yyyy_dash;
     }
}

inline bool DateFormatStatus::hasEnDateFormat () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_DateFormat DateFormatStatus::getEnDateFormat () const {
    return _enDateFormat;
}

inline void DateFormatStatus::setEnDateFormat (::clock_main_fi_types::VDCLK_TEN_DateFormat enDateFormat_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_DateFormat_IsValid(enDateFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDateFormat_, "VDCLK_TEN_DateFormat", "enDateFormat", "DateFormatStatus");
    }
    #endif
    set_has_enDateFormat();
    this->_enDateFormat = enDateFormat_;
}

inline void DateFormatStatus::set_has_enDateFormat () {
    _has_bits_[0] |= 1u << 0;
}

inline void DateFormatStatus::clear_has_enDateFormat () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DateFormatSet::DateFormatSet ()  :
    _enDateFormat (::clock_main_fi_types::VDCLK_TEN_DateFormat__VDCLK_EN_DF_dd_mm_yyyy_dash)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DateFormatSet::DateFormatSet (const DateFormatSet &rhs)  :
    ::asf::core::Payload(rhs),
    _enDateFormat (::clock_main_fi_types::VDCLK_TEN_DateFormat__VDCLK_EN_DF_dd_mm_yyyy_dash)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DateFormatSet::DateFormatSet (::clock_main_fi_types::VDCLK_TEN_DateFormat enDateFormat_)  :
    _enDateFormat (enDateFormat_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_DateFormat_IsValid(enDateFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDateFormat_, "VDCLK_TEN_DateFormat", "enDateFormat", "DateFormatSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DateFormatSet::~DateFormatSet() {
}

inline DateFormatSet& DateFormatSet::operator = (const DateFormatSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnDateFormat()) {
            setEnDateFormat(rhs.getEnDateFormat());
        } else {
            clearEnDateFormat();
        }
    }
    return *this;
}

inline bool DateFormatSet::operator == (const DateFormatSet& rhs) const {
    return (((!hasEnDateFormat() && !rhs.hasEnDateFormat()) || getEnDateFormat() == rhs.getEnDateFormat()));
}

inline bool DateFormatSet::operator != (const DateFormatSet& rhs) const {
    return ! (*this == rhs);
}

inline bool DateFormatSet::operator < (const DateFormatSet& rhs) const {
    if (hasEnDateFormat() || rhs.hasEnDateFormat()) {
        if ((uint32)getEnDateFormat() < (uint32)rhs.getEnDateFormat()) return true;
        if ((uint32)getEnDateFormat() > (uint32)rhs.getEnDateFormat()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DateFormatSet::clone() {
    return new DateFormatSet(*this);
}

inline bool DateFormatSet::operator > (const DateFormatSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DateFormatSet::clear() {
    clearEnDateFormat();
}

inline void DateFormatSet::clearEnDateFormat() {
    if (hasEnDateFormat()) {
         clear_has_enDateFormat();
        _enDateFormat = ::clock_main_fi_types::VDCLK_TEN_DateFormat__VDCLK_EN_DF_dd_mm_yyyy_dash;
     }
}

inline bool DateFormatSet::hasEnDateFormat () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_DateFormat DateFormatSet::getEnDateFormat () const {
    return _enDateFormat;
}

inline void DateFormatSet::setEnDateFormat (::clock_main_fi_types::VDCLK_TEN_DateFormat enDateFormat_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_DateFormat_IsValid(enDateFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDateFormat_, "VDCLK_TEN_DateFormat", "enDateFormat", "DateFormatSet");
    }
    #endif
    set_has_enDateFormat();
    this->_enDateFormat = enDateFormat_;
}

inline void DateFormatSet::set_has_enDateFormat () {
    _has_bits_[0] |= 1u << 0;
}

inline void DateFormatSet::clear_has_enDateFormat () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ClockSourceStatusStatus::ClockSourceStatusStatus ()  :
    _enSourcesValid (::clock_main_fi_types::VDCLK_TEN_ClockSourceStatus__VDCLK_EN_CSS_MasterTimeOnly)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClockSourceStatusStatus::ClockSourceStatusStatus (const ClockSourceStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _enSourcesValid (::clock_main_fi_types::VDCLK_TEN_ClockSourceStatus__VDCLK_EN_CSS_MasterTimeOnly)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClockSourceStatusStatus::ClockSourceStatusStatus (::clock_main_fi_types::VDCLK_TEN_ClockSourceStatus enSourcesValid_)  :
    _enSourcesValid (enSourcesValid_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_ClockSourceStatus_IsValid(enSourcesValid_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enSourcesValid_, "VDCLK_TEN_ClockSourceStatus", "enSourcesValid", "ClockSourceStatusStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ClockSourceStatusStatus::~ClockSourceStatusStatus() {
}

inline ClockSourceStatusStatus& ClockSourceStatusStatus::operator = (const ClockSourceStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnSourcesValid()) {
            setEnSourcesValid(rhs.getEnSourcesValid());
        } else {
            clearEnSourcesValid();
        }
    }
    return *this;
}

inline bool ClockSourceStatusStatus::operator == (const ClockSourceStatusStatus& rhs) const {
    return (((!hasEnSourcesValid() && !rhs.hasEnSourcesValid()) || getEnSourcesValid() == rhs.getEnSourcesValid()));
}

inline bool ClockSourceStatusStatus::operator != (const ClockSourceStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool ClockSourceStatusStatus::operator < (const ClockSourceStatusStatus& rhs) const {
    if (hasEnSourcesValid() || rhs.hasEnSourcesValid()) {
        if ((uint32)getEnSourcesValid() < (uint32)rhs.getEnSourcesValid()) return true;
        if ((uint32)getEnSourcesValid() > (uint32)rhs.getEnSourcesValid()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ClockSourceStatusStatus::clone() {
    return new ClockSourceStatusStatus(*this);
}

inline bool ClockSourceStatusStatus::operator > (const ClockSourceStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClockSourceStatusStatus::clear() {
    clearEnSourcesValid();
}

inline void ClockSourceStatusStatus::clearEnSourcesValid() {
    if (hasEnSourcesValid()) {
         clear_has_enSourcesValid();
        _enSourcesValid = ::clock_main_fi_types::VDCLK_TEN_ClockSourceStatus__VDCLK_EN_CSS_MasterTimeOnly;
     }
}

inline bool ClockSourceStatusStatus::hasEnSourcesValid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_ClockSourceStatus ClockSourceStatusStatus::getEnSourcesValid () const {
    return _enSourcesValid;
}

inline void ClockSourceStatusStatus::setEnSourcesValid (::clock_main_fi_types::VDCLK_TEN_ClockSourceStatus enSourcesValid_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_ClockSourceStatus_IsValid(enSourcesValid_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enSourcesValid_, "VDCLK_TEN_ClockSourceStatus", "enSourcesValid", "ClockSourceStatusStatus");
    }
    #endif
    set_has_enSourcesValid();
    this->_enSourcesValid = enSourcesValid_;
}

inline void ClockSourceStatusStatus::set_has_enSourcesValid () {
    _has_bits_[0] |= 1u << 0;
}

inline void ClockSourceStatusStatus::clear_has_enSourcesValid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FormatSourceStatusStatus::FormatSourceStatusStatus ()  :
    _enFormatSourceStatus (::clock_main_fi_types::VDCLK_TEN_FormatSourceStatus__VDCLK_EN_FSS_MasterTimeOnly)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FormatSourceStatusStatus::FormatSourceStatusStatus (const FormatSourceStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _enFormatSourceStatus (::clock_main_fi_types::VDCLK_TEN_FormatSourceStatus__VDCLK_EN_FSS_MasterTimeOnly)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FormatSourceStatusStatus::FormatSourceStatusStatus (::clock_main_fi_types::VDCLK_TEN_FormatSourceStatus enFormatSourceStatus_)  :
    _enFormatSourceStatus (enFormatSourceStatus_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_FormatSourceStatus_IsValid(enFormatSourceStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enFormatSourceStatus_, "VDCLK_TEN_FormatSourceStatus", "enFormatSourceStatus", "FormatSourceStatusStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FormatSourceStatusStatus::~FormatSourceStatusStatus() {
}

inline FormatSourceStatusStatus& FormatSourceStatusStatus::operator = (const FormatSourceStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnFormatSourceStatus()) {
            setEnFormatSourceStatus(rhs.getEnFormatSourceStatus());
        } else {
            clearEnFormatSourceStatus();
        }
    }
    return *this;
}

inline bool FormatSourceStatusStatus::operator == (const FormatSourceStatusStatus& rhs) const {
    return (((!hasEnFormatSourceStatus() && !rhs.hasEnFormatSourceStatus()) || getEnFormatSourceStatus() == rhs.getEnFormatSourceStatus()));
}

inline bool FormatSourceStatusStatus::operator != (const FormatSourceStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FormatSourceStatusStatus::operator < (const FormatSourceStatusStatus& rhs) const {
    if (hasEnFormatSourceStatus() || rhs.hasEnFormatSourceStatus()) {
        if ((uint32)getEnFormatSourceStatus() < (uint32)rhs.getEnFormatSourceStatus()) return true;
        if ((uint32)getEnFormatSourceStatus() > (uint32)rhs.getEnFormatSourceStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FormatSourceStatusStatus::clone() {
    return new FormatSourceStatusStatus(*this);
}

inline bool FormatSourceStatusStatus::operator > (const FormatSourceStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FormatSourceStatusStatus::clear() {
    clearEnFormatSourceStatus();
}

inline void FormatSourceStatusStatus::clearEnFormatSourceStatus() {
    if (hasEnFormatSourceStatus()) {
         clear_has_enFormatSourceStatus();
        _enFormatSourceStatus = ::clock_main_fi_types::VDCLK_TEN_FormatSourceStatus__VDCLK_EN_FSS_MasterTimeOnly;
     }
}

inline bool FormatSourceStatusStatus::hasEnFormatSourceStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_FormatSourceStatus FormatSourceStatusStatus::getEnFormatSourceStatus () const {
    return _enFormatSourceStatus;
}

inline void FormatSourceStatusStatus::setEnFormatSourceStatus (::clock_main_fi_types::VDCLK_TEN_FormatSourceStatus enFormatSourceStatus_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_FormatSourceStatus_IsValid(enFormatSourceStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enFormatSourceStatus_, "VDCLK_TEN_FormatSourceStatus", "enFormatSourceStatus", "FormatSourceStatusStatus");
    }
    #endif
    set_has_enFormatSourceStatus();
    this->_enFormatSourceStatus = enFormatSourceStatus_;
}

inline void FormatSourceStatusStatus::set_has_enFormatSourceStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void FormatSourceStatusStatus::clear_has_enFormatSourceStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  LocalTimeDate_MinuteUpdateStatus::LocalTimeDate_MinuteUpdateStatus ()  :
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u),
    _u8TimeDateStatus (0u),
    _u32TimeDateValue (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LocalTimeDate_MinuteUpdateStatus::LocalTimeDate_MinuteUpdateStatus (const LocalTimeDate_MinuteUpdateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u),
    _u8TimeDateStatus (0u),
    _u32TimeDateValue (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LocalTimeDate_MinuteUpdateStatus::LocalTimeDate_MinuteUpdateStatus (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_, uint8 u8TimeDateStatus_, uint32 u32TimeDateValue_)  :
    _s16Year (s16Year_),
    _u8Month (u8Month_),
    _u8Day (u8Day_),
    _u8Hours (u8Hours_),
    _u8Minutes (u8Minutes_),
    _u8Seconds (u8Seconds_),
    _u8Weekday (u8Weekday_),
    _u8TimeDateStatus (u8TimeDateStatus_),
    _u32TimeDateValue (u32TimeDateValue_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LocalTimeDate_MinuteUpdateStatus::~LocalTimeDate_MinuteUpdateStatus() {
}

inline LocalTimeDate_MinuteUpdateStatus& LocalTimeDate_MinuteUpdateStatus::operator = (const LocalTimeDate_MinuteUpdateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS16Year()) {
            setS16Year(rhs.getS16Year());
        } else {
            clearS16Year();
        }
        if (rhs.hasU8Month()) {
            setU8Month(rhs.getU8Month());
        } else {
            clearU8Month();
        }
        if (rhs.hasU8Day()) {
            setU8Day(rhs.getU8Day());
        } else {
            clearU8Day();
        }
        if (rhs.hasU8Hours()) {
            setU8Hours(rhs.getU8Hours());
        } else {
            clearU8Hours();
        }
        if (rhs.hasU8Minutes()) {
            setU8Minutes(rhs.getU8Minutes());
        } else {
            clearU8Minutes();
        }
        if (rhs.hasU8Seconds()) {
            setU8Seconds(rhs.getU8Seconds());
        } else {
            clearU8Seconds();
        }
        if (rhs.hasU8Weekday()) {
            setU8Weekday(rhs.getU8Weekday());
        } else {
            clearU8Weekday();
        }
        if (rhs.hasU8TimeDateStatus()) {
            setU8TimeDateStatus(rhs.getU8TimeDateStatus());
        } else {
            clearU8TimeDateStatus();
        }
        if (rhs.hasU32TimeDateValue()) {
            setU32TimeDateValue(rhs.getU32TimeDateValue());
        } else {
            clearU32TimeDateValue();
        }
    }
    return *this;
}

inline bool LocalTimeDate_MinuteUpdateStatus::operator == (const LocalTimeDate_MinuteUpdateStatus& rhs) const {
    return (((!hasS16Year() && !rhs.hasS16Year()) || getS16Year() == rhs.getS16Year()) &&
        ((!hasU8Month() && !rhs.hasU8Month()) || getU8Month() == rhs.getU8Month()) &&
        ((!hasU8Day() && !rhs.hasU8Day()) || getU8Day() == rhs.getU8Day()) &&
        ((!hasU8Hours() && !rhs.hasU8Hours()) || getU8Hours() == rhs.getU8Hours()) &&
        ((!hasU8Minutes() && !rhs.hasU8Minutes()) || getU8Minutes() == rhs.getU8Minutes()) &&
        ((!hasU8Seconds() && !rhs.hasU8Seconds()) || getU8Seconds() == rhs.getU8Seconds()) &&
        ((!hasU8Weekday() && !rhs.hasU8Weekday()) || getU8Weekday() == rhs.getU8Weekday()) &&
        ((!hasU8TimeDateStatus() && !rhs.hasU8TimeDateStatus()) || getU8TimeDateStatus() == rhs.getU8TimeDateStatus()) &&
        ((!hasU32TimeDateValue() && !rhs.hasU32TimeDateValue()) || getU32TimeDateValue() == rhs.getU32TimeDateValue()));
}

inline bool LocalTimeDate_MinuteUpdateStatus::operator != (const LocalTimeDate_MinuteUpdateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool LocalTimeDate_MinuteUpdateStatus::operator < (const LocalTimeDate_MinuteUpdateStatus& rhs) const {
    if (hasS16Year() || rhs.hasS16Year()) {
        if (getS16Year() < rhs.getS16Year()) return true;
        if (getS16Year() > rhs.getS16Year()) return false;
    }
    if (hasU8Month() || rhs.hasU8Month()) {
        if (getU8Month() < rhs.getU8Month()) return true;
        if (getU8Month() > rhs.getU8Month()) return false;
    }
    if (hasU8Day() || rhs.hasU8Day()) {
        if (getU8Day() < rhs.getU8Day()) return true;
        if (getU8Day() > rhs.getU8Day()) return false;
    }
    if (hasU8Hours() || rhs.hasU8Hours()) {
        if (getU8Hours() < rhs.getU8Hours()) return true;
        if (getU8Hours() > rhs.getU8Hours()) return false;
    }
    if (hasU8Minutes() || rhs.hasU8Minutes()) {
        if (getU8Minutes() < rhs.getU8Minutes()) return true;
        if (getU8Minutes() > rhs.getU8Minutes()) return false;
    }
    if (hasU8Seconds() || rhs.hasU8Seconds()) {
        if (getU8Seconds() < rhs.getU8Seconds()) return true;
        if (getU8Seconds() > rhs.getU8Seconds()) return false;
    }
    if (hasU8Weekday() || rhs.hasU8Weekday()) {
        if (getU8Weekday() < rhs.getU8Weekday()) return true;
        if (getU8Weekday() > rhs.getU8Weekday()) return false;
    }
    if (hasU8TimeDateStatus() || rhs.hasU8TimeDateStatus()) {
        if (getU8TimeDateStatus() < rhs.getU8TimeDateStatus()) return true;
        if (getU8TimeDateStatus() > rhs.getU8TimeDateStatus()) return false;
    }
    if (hasU32TimeDateValue() || rhs.hasU32TimeDateValue()) {
        if (getU32TimeDateValue() < rhs.getU32TimeDateValue()) return true;
        if (getU32TimeDateValue() > rhs.getU32TimeDateValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LocalTimeDate_MinuteUpdateStatus::clone() {
    return new LocalTimeDate_MinuteUpdateStatus(*this);
}

inline bool LocalTimeDate_MinuteUpdateStatus::operator > (const LocalTimeDate_MinuteUpdateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LocalTimeDate_MinuteUpdateStatus::clear() {
    clearS16Year();
    clearU8Month();
    clearU8Day();
    clearU8Hours();
    clearU8Minutes();
    clearU8Seconds();
    clearU8Weekday();
    clearU8TimeDateStatus();
    clearU32TimeDateValue();
}

inline void LocalTimeDate_MinuteUpdateStatus::clearS16Year() {
    if (hasS16Year()) {
         clear_has_s16Year();
        _s16Year = 0;
     }
}

inline bool LocalTimeDate_MinuteUpdateStatus::hasS16Year () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 LocalTimeDate_MinuteUpdateStatus::getS16Year () const {
    return _s16Year;
}

inline void LocalTimeDate_MinuteUpdateStatus::setS16Year (int16 s16Year_) {
    set_has_s16Year();
    this->_s16Year = s16Year_;
}

inline void LocalTimeDate_MinuteUpdateStatus::clearU8Month() {
    if (hasU8Month()) {
         clear_has_u8Month();
        _u8Month = 0u;
     }
}

inline bool LocalTimeDate_MinuteUpdateStatus::hasU8Month () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 LocalTimeDate_MinuteUpdateStatus::getU8Month () const {
    return _u8Month;
}

inline void LocalTimeDate_MinuteUpdateStatus::setU8Month (uint8 u8Month_) {
    set_has_u8Month();
    this->_u8Month = u8Month_;
}

inline void LocalTimeDate_MinuteUpdateStatus::clearU8Day() {
    if (hasU8Day()) {
         clear_has_u8Day();
        _u8Day = 0u;
     }
}

inline bool LocalTimeDate_MinuteUpdateStatus::hasU8Day () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 LocalTimeDate_MinuteUpdateStatus::getU8Day () const {
    return _u8Day;
}

inline void LocalTimeDate_MinuteUpdateStatus::setU8Day (uint8 u8Day_) {
    set_has_u8Day();
    this->_u8Day = u8Day_;
}

inline void LocalTimeDate_MinuteUpdateStatus::clearU8Hours() {
    if (hasU8Hours()) {
         clear_has_u8Hours();
        _u8Hours = 0u;
     }
}

inline bool LocalTimeDate_MinuteUpdateStatus::hasU8Hours () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 LocalTimeDate_MinuteUpdateStatus::getU8Hours () const {
    return _u8Hours;
}

inline void LocalTimeDate_MinuteUpdateStatus::setU8Hours (uint8 u8Hours_) {
    set_has_u8Hours();
    this->_u8Hours = u8Hours_;
}

inline void LocalTimeDate_MinuteUpdateStatus::clearU8Minutes() {
    if (hasU8Minutes()) {
         clear_has_u8Minutes();
        _u8Minutes = 0u;
     }
}

inline bool LocalTimeDate_MinuteUpdateStatus::hasU8Minutes () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 LocalTimeDate_MinuteUpdateStatus::getU8Minutes () const {
    return _u8Minutes;
}

inline void LocalTimeDate_MinuteUpdateStatus::setU8Minutes (uint8 u8Minutes_) {
    set_has_u8Minutes();
    this->_u8Minutes = u8Minutes_;
}

inline void LocalTimeDate_MinuteUpdateStatus::clearU8Seconds() {
    if (hasU8Seconds()) {
         clear_has_u8Seconds();
        _u8Seconds = 0u;
     }
}

inline bool LocalTimeDate_MinuteUpdateStatus::hasU8Seconds () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 LocalTimeDate_MinuteUpdateStatus::getU8Seconds () const {
    return _u8Seconds;
}

inline void LocalTimeDate_MinuteUpdateStatus::setU8Seconds (uint8 u8Seconds_) {
    set_has_u8Seconds();
    this->_u8Seconds = u8Seconds_;
}

inline void LocalTimeDate_MinuteUpdateStatus::clearU8Weekday() {
    if (hasU8Weekday()) {
         clear_has_u8Weekday();
        _u8Weekday = 0u;
     }
}

inline bool LocalTimeDate_MinuteUpdateStatus::hasU8Weekday () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 LocalTimeDate_MinuteUpdateStatus::getU8Weekday () const {
    return _u8Weekday;
}

inline void LocalTimeDate_MinuteUpdateStatus::setU8Weekday (uint8 u8Weekday_) {
    set_has_u8Weekday();
    this->_u8Weekday = u8Weekday_;
}

inline void LocalTimeDate_MinuteUpdateStatus::clearU8TimeDateStatus() {
    if (hasU8TimeDateStatus()) {
         clear_has_u8TimeDateStatus();
        _u8TimeDateStatus = 0u;
     }
}

inline bool LocalTimeDate_MinuteUpdateStatus::hasU8TimeDateStatus () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 LocalTimeDate_MinuteUpdateStatus::getU8TimeDateStatus () const {
    return _u8TimeDateStatus;
}

inline void LocalTimeDate_MinuteUpdateStatus::setU8TimeDateStatus (uint8 u8TimeDateStatus_) {
    set_has_u8TimeDateStatus();
    this->_u8TimeDateStatus = u8TimeDateStatus_;
}

inline void LocalTimeDate_MinuteUpdateStatus::clearU32TimeDateValue() {
    if (hasU32TimeDateValue()) {
         clear_has_u32TimeDateValue();
        _u32TimeDateValue = 0u;
     }
}

inline bool LocalTimeDate_MinuteUpdateStatus::hasU32TimeDateValue () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint32 LocalTimeDate_MinuteUpdateStatus::getU32TimeDateValue () const {
    return _u32TimeDateValue;
}

inline void LocalTimeDate_MinuteUpdateStatus::setU32TimeDateValue (uint32 u32TimeDateValue_) {
    set_has_u32TimeDateValue();
    this->_u32TimeDateValue = u32TimeDateValue_;
}

inline void LocalTimeDate_MinuteUpdateStatus::set_has_s16Year () {
    _has_bits_[0] |= 1u << 0;
}

inline void LocalTimeDate_MinuteUpdateStatus::clear_has_s16Year () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LocalTimeDate_MinuteUpdateStatus::set_has_u8Month () {
    _has_bits_[0] |= 1u << 1;
}

inline void LocalTimeDate_MinuteUpdateStatus::clear_has_u8Month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void LocalTimeDate_MinuteUpdateStatus::set_has_u8Day () {
    _has_bits_[0] |= 1u << 2;
}

inline void LocalTimeDate_MinuteUpdateStatus::clear_has_u8Day () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void LocalTimeDate_MinuteUpdateStatus::set_has_u8Hours () {
    _has_bits_[0] |= 1u << 3;
}

inline void LocalTimeDate_MinuteUpdateStatus::clear_has_u8Hours () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void LocalTimeDate_MinuteUpdateStatus::set_has_u8Minutes () {
    _has_bits_[0] |= 1u << 4;
}

inline void LocalTimeDate_MinuteUpdateStatus::clear_has_u8Minutes () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void LocalTimeDate_MinuteUpdateStatus::set_has_u8Seconds () {
    _has_bits_[0] |= 1u << 5;
}

inline void LocalTimeDate_MinuteUpdateStatus::clear_has_u8Seconds () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void LocalTimeDate_MinuteUpdateStatus::set_has_u8Weekday () {
    _has_bits_[0] |= 1u << 6;
}

inline void LocalTimeDate_MinuteUpdateStatus::clear_has_u8Weekday () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void LocalTimeDate_MinuteUpdateStatus::set_has_u8TimeDateStatus () {
    _has_bits_[0] |= 1u << 7;
}

inline void LocalTimeDate_MinuteUpdateStatus::clear_has_u8TimeDateStatus () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void LocalTimeDate_MinuteUpdateStatus::set_has_u32TimeDateValue () {
    _has_bits_[0] |= 1u << 8;
}

inline void LocalTimeDate_MinuteUpdateStatus::clear_has_u32TimeDateValue () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  LocalTimeDate_MinuteUpdateSet::LocalTimeDate_MinuteUpdateSet ()  :
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u),
    _u8ChangeMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LocalTimeDate_MinuteUpdateSet::LocalTimeDate_MinuteUpdateSet (const LocalTimeDate_MinuteUpdateSet &rhs)  :
    ::asf::core::Payload(rhs),
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u),
    _u8ChangeMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LocalTimeDate_MinuteUpdateSet::LocalTimeDate_MinuteUpdateSet (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_, uint8 u8ChangeMask_)  :
    _s16Year (s16Year_),
    _u8Month (u8Month_),
    _u8Day (u8Day_),
    _u8Hours (u8Hours_),
    _u8Minutes (u8Minutes_),
    _u8Seconds (u8Seconds_),
    _u8Weekday (u8Weekday_),
    _u8ChangeMask (u8ChangeMask_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LocalTimeDate_MinuteUpdateSet::~LocalTimeDate_MinuteUpdateSet() {
}

inline LocalTimeDate_MinuteUpdateSet& LocalTimeDate_MinuteUpdateSet::operator = (const LocalTimeDate_MinuteUpdateSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS16Year()) {
            setS16Year(rhs.getS16Year());
        } else {
            clearS16Year();
        }
        if (rhs.hasU8Month()) {
            setU8Month(rhs.getU8Month());
        } else {
            clearU8Month();
        }
        if (rhs.hasU8Day()) {
            setU8Day(rhs.getU8Day());
        } else {
            clearU8Day();
        }
        if (rhs.hasU8Hours()) {
            setU8Hours(rhs.getU8Hours());
        } else {
            clearU8Hours();
        }
        if (rhs.hasU8Minutes()) {
            setU8Minutes(rhs.getU8Minutes());
        } else {
            clearU8Minutes();
        }
        if (rhs.hasU8Seconds()) {
            setU8Seconds(rhs.getU8Seconds());
        } else {
            clearU8Seconds();
        }
        if (rhs.hasU8Weekday()) {
            setU8Weekday(rhs.getU8Weekday());
        } else {
            clearU8Weekday();
        }
        if (rhs.hasU8ChangeMask()) {
            setU8ChangeMask(rhs.getU8ChangeMask());
        } else {
            clearU8ChangeMask();
        }
    }
    return *this;
}

inline bool LocalTimeDate_MinuteUpdateSet::operator == (const LocalTimeDate_MinuteUpdateSet& rhs) const {
    return (((!hasS16Year() && !rhs.hasS16Year()) || getS16Year() == rhs.getS16Year()) &&
        ((!hasU8Month() && !rhs.hasU8Month()) || getU8Month() == rhs.getU8Month()) &&
        ((!hasU8Day() && !rhs.hasU8Day()) || getU8Day() == rhs.getU8Day()) &&
        ((!hasU8Hours() && !rhs.hasU8Hours()) || getU8Hours() == rhs.getU8Hours()) &&
        ((!hasU8Minutes() && !rhs.hasU8Minutes()) || getU8Minutes() == rhs.getU8Minutes()) &&
        ((!hasU8Seconds() && !rhs.hasU8Seconds()) || getU8Seconds() == rhs.getU8Seconds()) &&
        ((!hasU8Weekday() && !rhs.hasU8Weekday()) || getU8Weekday() == rhs.getU8Weekday()) &&
        ((!hasU8ChangeMask() && !rhs.hasU8ChangeMask()) || getU8ChangeMask() == rhs.getU8ChangeMask()));
}

inline bool LocalTimeDate_MinuteUpdateSet::operator != (const LocalTimeDate_MinuteUpdateSet& rhs) const {
    return ! (*this == rhs);
}

inline bool LocalTimeDate_MinuteUpdateSet::operator < (const LocalTimeDate_MinuteUpdateSet& rhs) const {
    if (hasS16Year() || rhs.hasS16Year()) {
        if (getS16Year() < rhs.getS16Year()) return true;
        if (getS16Year() > rhs.getS16Year()) return false;
    }
    if (hasU8Month() || rhs.hasU8Month()) {
        if (getU8Month() < rhs.getU8Month()) return true;
        if (getU8Month() > rhs.getU8Month()) return false;
    }
    if (hasU8Day() || rhs.hasU8Day()) {
        if (getU8Day() < rhs.getU8Day()) return true;
        if (getU8Day() > rhs.getU8Day()) return false;
    }
    if (hasU8Hours() || rhs.hasU8Hours()) {
        if (getU8Hours() < rhs.getU8Hours()) return true;
        if (getU8Hours() > rhs.getU8Hours()) return false;
    }
    if (hasU8Minutes() || rhs.hasU8Minutes()) {
        if (getU8Minutes() < rhs.getU8Minutes()) return true;
        if (getU8Minutes() > rhs.getU8Minutes()) return false;
    }
    if (hasU8Seconds() || rhs.hasU8Seconds()) {
        if (getU8Seconds() < rhs.getU8Seconds()) return true;
        if (getU8Seconds() > rhs.getU8Seconds()) return false;
    }
    if (hasU8Weekday() || rhs.hasU8Weekday()) {
        if (getU8Weekday() < rhs.getU8Weekday()) return true;
        if (getU8Weekday() > rhs.getU8Weekday()) return false;
    }
    if (hasU8ChangeMask() || rhs.hasU8ChangeMask()) {
        if (getU8ChangeMask() < rhs.getU8ChangeMask()) return true;
        if (getU8ChangeMask() > rhs.getU8ChangeMask()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LocalTimeDate_MinuteUpdateSet::clone() {
    return new LocalTimeDate_MinuteUpdateSet(*this);
}

inline bool LocalTimeDate_MinuteUpdateSet::operator > (const LocalTimeDate_MinuteUpdateSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LocalTimeDate_MinuteUpdateSet::clear() {
    clearS16Year();
    clearU8Month();
    clearU8Day();
    clearU8Hours();
    clearU8Minutes();
    clearU8Seconds();
    clearU8Weekday();
    clearU8ChangeMask();
}

inline void LocalTimeDate_MinuteUpdateSet::clearS16Year() {
    if (hasS16Year()) {
         clear_has_s16Year();
        _s16Year = 0;
     }
}

inline bool LocalTimeDate_MinuteUpdateSet::hasS16Year () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 LocalTimeDate_MinuteUpdateSet::getS16Year () const {
    return _s16Year;
}

inline void LocalTimeDate_MinuteUpdateSet::setS16Year (int16 s16Year_) {
    set_has_s16Year();
    this->_s16Year = s16Year_;
}

inline void LocalTimeDate_MinuteUpdateSet::clearU8Month() {
    if (hasU8Month()) {
         clear_has_u8Month();
        _u8Month = 0u;
     }
}

inline bool LocalTimeDate_MinuteUpdateSet::hasU8Month () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 LocalTimeDate_MinuteUpdateSet::getU8Month () const {
    return _u8Month;
}

inline void LocalTimeDate_MinuteUpdateSet::setU8Month (uint8 u8Month_) {
    set_has_u8Month();
    this->_u8Month = u8Month_;
}

inline void LocalTimeDate_MinuteUpdateSet::clearU8Day() {
    if (hasU8Day()) {
         clear_has_u8Day();
        _u8Day = 0u;
     }
}

inline bool LocalTimeDate_MinuteUpdateSet::hasU8Day () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 LocalTimeDate_MinuteUpdateSet::getU8Day () const {
    return _u8Day;
}

inline void LocalTimeDate_MinuteUpdateSet::setU8Day (uint8 u8Day_) {
    set_has_u8Day();
    this->_u8Day = u8Day_;
}

inline void LocalTimeDate_MinuteUpdateSet::clearU8Hours() {
    if (hasU8Hours()) {
         clear_has_u8Hours();
        _u8Hours = 0u;
     }
}

inline bool LocalTimeDate_MinuteUpdateSet::hasU8Hours () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 LocalTimeDate_MinuteUpdateSet::getU8Hours () const {
    return _u8Hours;
}

inline void LocalTimeDate_MinuteUpdateSet::setU8Hours (uint8 u8Hours_) {
    set_has_u8Hours();
    this->_u8Hours = u8Hours_;
}

inline void LocalTimeDate_MinuteUpdateSet::clearU8Minutes() {
    if (hasU8Minutes()) {
         clear_has_u8Minutes();
        _u8Minutes = 0u;
     }
}

inline bool LocalTimeDate_MinuteUpdateSet::hasU8Minutes () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 LocalTimeDate_MinuteUpdateSet::getU8Minutes () const {
    return _u8Minutes;
}

inline void LocalTimeDate_MinuteUpdateSet::setU8Minutes (uint8 u8Minutes_) {
    set_has_u8Minutes();
    this->_u8Minutes = u8Minutes_;
}

inline void LocalTimeDate_MinuteUpdateSet::clearU8Seconds() {
    if (hasU8Seconds()) {
         clear_has_u8Seconds();
        _u8Seconds = 0u;
     }
}

inline bool LocalTimeDate_MinuteUpdateSet::hasU8Seconds () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 LocalTimeDate_MinuteUpdateSet::getU8Seconds () const {
    return _u8Seconds;
}

inline void LocalTimeDate_MinuteUpdateSet::setU8Seconds (uint8 u8Seconds_) {
    set_has_u8Seconds();
    this->_u8Seconds = u8Seconds_;
}

inline void LocalTimeDate_MinuteUpdateSet::clearU8Weekday() {
    if (hasU8Weekday()) {
         clear_has_u8Weekday();
        _u8Weekday = 0u;
     }
}

inline bool LocalTimeDate_MinuteUpdateSet::hasU8Weekday () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 LocalTimeDate_MinuteUpdateSet::getU8Weekday () const {
    return _u8Weekday;
}

inline void LocalTimeDate_MinuteUpdateSet::setU8Weekday (uint8 u8Weekday_) {
    set_has_u8Weekday();
    this->_u8Weekday = u8Weekday_;
}

inline void LocalTimeDate_MinuteUpdateSet::clearU8ChangeMask() {
    if (hasU8ChangeMask()) {
         clear_has_u8ChangeMask();
        _u8ChangeMask = 0u;
     }
}

inline bool LocalTimeDate_MinuteUpdateSet::hasU8ChangeMask () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 LocalTimeDate_MinuteUpdateSet::getU8ChangeMask () const {
    return _u8ChangeMask;
}

inline void LocalTimeDate_MinuteUpdateSet::setU8ChangeMask (uint8 u8ChangeMask_) {
    set_has_u8ChangeMask();
    this->_u8ChangeMask = u8ChangeMask_;
}

inline void LocalTimeDate_MinuteUpdateSet::set_has_s16Year () {
    _has_bits_[0] |= 1u << 0;
}

inline void LocalTimeDate_MinuteUpdateSet::clear_has_s16Year () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LocalTimeDate_MinuteUpdateSet::set_has_u8Month () {
    _has_bits_[0] |= 1u << 1;
}

inline void LocalTimeDate_MinuteUpdateSet::clear_has_u8Month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void LocalTimeDate_MinuteUpdateSet::set_has_u8Day () {
    _has_bits_[0] |= 1u << 2;
}

inline void LocalTimeDate_MinuteUpdateSet::clear_has_u8Day () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void LocalTimeDate_MinuteUpdateSet::set_has_u8Hours () {
    _has_bits_[0] |= 1u << 3;
}

inline void LocalTimeDate_MinuteUpdateSet::clear_has_u8Hours () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void LocalTimeDate_MinuteUpdateSet::set_has_u8Minutes () {
    _has_bits_[0] |= 1u << 4;
}

inline void LocalTimeDate_MinuteUpdateSet::clear_has_u8Minutes () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void LocalTimeDate_MinuteUpdateSet::set_has_u8Seconds () {
    _has_bits_[0] |= 1u << 5;
}

inline void LocalTimeDate_MinuteUpdateSet::clear_has_u8Seconds () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void LocalTimeDate_MinuteUpdateSet::set_has_u8Weekday () {
    _has_bits_[0] |= 1u << 6;
}

inline void LocalTimeDate_MinuteUpdateSet::clear_has_u8Weekday () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void LocalTimeDate_MinuteUpdateSet::set_has_u8ChangeMask () {
    _has_bits_[0] |= 1u << 7;
}

inline void LocalTimeDate_MinuteUpdateSet::clear_has_u8ChangeMask () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  Region_TimeZoneStatus::Region_TimeZoneStatus ()  :
    _enTIMEZONE_Status (::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting__VDCLK_EN_Abu_Dhabi),
    _szDescription ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Region_TimeZoneStatus::Region_TimeZoneStatus (const Region_TimeZoneStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _enTIMEZONE_Status (::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting__VDCLK_EN_Abu_Dhabi),
    _szDescription ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Region_TimeZoneStatus::Region_TimeZoneStatus (::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Status_, const ::std::string& szDescription_)  :
    _enTIMEZONE_Status (enTIMEZONE_Status_),
    _szDescription (szDescription_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting_IsValid(enTIMEZONE_Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTIMEZONE_Status_, "VDCLK_TEN_TIMEZONE_Setting", "enTIMEZONE_Status", "Region_TimeZoneStatus");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Region_TimeZoneStatus::~Region_TimeZoneStatus() {
}

inline Region_TimeZoneStatus& Region_TimeZoneStatus::operator = (const Region_TimeZoneStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnTIMEZONE_Status()) {
            setEnTIMEZONE_Status(rhs.getEnTIMEZONE_Status());
        } else {
            clearEnTIMEZONE_Status();
        }
        if (rhs.hasSzDescription()) {
            setSzDescription(rhs.getSzDescription());
        } else {
            clearSzDescription();
        }
    }
    return *this;
}

inline bool Region_TimeZoneStatus::operator == (const Region_TimeZoneStatus& rhs) const {
    return (((!hasEnTIMEZONE_Status() && !rhs.hasEnTIMEZONE_Status()) || getEnTIMEZONE_Status() == rhs.getEnTIMEZONE_Status()) &&
        ((!hasSzDescription() && !rhs.hasSzDescription()) || getSzDescription() == rhs.getSzDescription()));
}

inline bool Region_TimeZoneStatus::operator != (const Region_TimeZoneStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Region_TimeZoneStatus::operator < (const Region_TimeZoneStatus& rhs) const {
    if (hasEnTIMEZONE_Status() || rhs.hasEnTIMEZONE_Status()) {
        if ((uint32)getEnTIMEZONE_Status() < (uint32)rhs.getEnTIMEZONE_Status()) return true;
        if ((uint32)getEnTIMEZONE_Status() > (uint32)rhs.getEnTIMEZONE_Status()) return false;
    }
    if (hasSzDescription() || rhs.hasSzDescription()) {
        if (getSzDescription() < rhs.getSzDescription()) return true;
        if (getSzDescription() > rhs.getSzDescription()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Region_TimeZoneStatus::clone() {
    return new Region_TimeZoneStatus(*this);
}

inline bool Region_TimeZoneStatus::operator > (const Region_TimeZoneStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Region_TimeZoneStatus::clear() {
    clearEnTIMEZONE_Status();
    clearSzDescription();
}

inline void Region_TimeZoneStatus::clearEnTIMEZONE_Status() {
    if (hasEnTIMEZONE_Status()) {
         clear_has_enTIMEZONE_Status();
        _enTIMEZONE_Status = ::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting__VDCLK_EN_Abu_Dhabi;
     }
}

inline bool Region_TimeZoneStatus::hasEnTIMEZONE_Status () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting Region_TimeZoneStatus::getEnTIMEZONE_Status () const {
    return _enTIMEZONE_Status;
}

inline void Region_TimeZoneStatus::setEnTIMEZONE_Status (::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Status_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting_IsValid(enTIMEZONE_Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTIMEZONE_Status_, "VDCLK_TEN_TIMEZONE_Setting", "enTIMEZONE_Status", "Region_TimeZoneStatus");
    }
    #endif
    set_has_enTIMEZONE_Status();
    this->_enTIMEZONE_Status = enTIMEZONE_Status_;
}

inline void Region_TimeZoneStatus::clearSzDescription() {
    if (hasSzDescription()) {
         clear_has_szDescription();
        _szDescription.clear();
     }
}

inline bool Region_TimeZoneStatus::hasSzDescription () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& Region_TimeZoneStatus::getSzDescription () const {
    return _szDescription;
}

inline ::std::string& Region_TimeZoneStatus::getSzDescriptionMutable () {
    set_has_szDescription();
    return _szDescription;
}

inline void Region_TimeZoneStatus::setSzDescription (const ::std::string& szDescription_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDescription();
    this->_szDescription = szDescription_;
}

inline void Region_TimeZoneStatus::setSzDescription (const char* szDescription_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDescription();
    this->_szDescription.assign(szDescription_);
}

inline void Region_TimeZoneStatus::setSzDescription (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDescription();
    this->_szDescription.assign(value, size);
}

inline void Region_TimeZoneStatus::set_has_enTIMEZONE_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void Region_TimeZoneStatus::clear_has_enTIMEZONE_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Region_TimeZoneStatus::set_has_szDescription () {
    _has_bits_[0] |= 1u << 1;
}

inline void Region_TimeZoneStatus::clear_has_szDescription () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Region_TimeZoneSet::Region_TimeZoneSet ()  :
    _enTIMEZONE_Settings (::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting__VDCLK_EN_Abu_Dhabi)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Region_TimeZoneSet::Region_TimeZoneSet (const Region_TimeZoneSet &rhs)  :
    ::asf::core::Payload(rhs),
    _enTIMEZONE_Settings (::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting__VDCLK_EN_Abu_Dhabi)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Region_TimeZoneSet::Region_TimeZoneSet (::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Settings_)  :
    _enTIMEZONE_Settings (enTIMEZONE_Settings_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting_IsValid(enTIMEZONE_Settings_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTIMEZONE_Settings_, "VDCLK_TEN_TIMEZONE_Setting", "enTIMEZONE_Settings", "Region_TimeZoneSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Region_TimeZoneSet::~Region_TimeZoneSet() {
}

inline Region_TimeZoneSet& Region_TimeZoneSet::operator = (const Region_TimeZoneSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnTIMEZONE_Settings()) {
            setEnTIMEZONE_Settings(rhs.getEnTIMEZONE_Settings());
        } else {
            clearEnTIMEZONE_Settings();
        }
    }
    return *this;
}

inline bool Region_TimeZoneSet::operator == (const Region_TimeZoneSet& rhs) const {
    return (((!hasEnTIMEZONE_Settings() && !rhs.hasEnTIMEZONE_Settings()) || getEnTIMEZONE_Settings() == rhs.getEnTIMEZONE_Settings()));
}

inline bool Region_TimeZoneSet::operator != (const Region_TimeZoneSet& rhs) const {
    return ! (*this == rhs);
}

inline bool Region_TimeZoneSet::operator < (const Region_TimeZoneSet& rhs) const {
    if (hasEnTIMEZONE_Settings() || rhs.hasEnTIMEZONE_Settings()) {
        if ((uint32)getEnTIMEZONE_Settings() < (uint32)rhs.getEnTIMEZONE_Settings()) return true;
        if ((uint32)getEnTIMEZONE_Settings() > (uint32)rhs.getEnTIMEZONE_Settings()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Region_TimeZoneSet::clone() {
    return new Region_TimeZoneSet(*this);
}

inline bool Region_TimeZoneSet::operator > (const Region_TimeZoneSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Region_TimeZoneSet::clear() {
    clearEnTIMEZONE_Settings();
}

inline void Region_TimeZoneSet::clearEnTIMEZONE_Settings() {
    if (hasEnTIMEZONE_Settings()) {
         clear_has_enTIMEZONE_Settings();
        _enTIMEZONE_Settings = ::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting__VDCLK_EN_Abu_Dhabi;
     }
}

inline bool Region_TimeZoneSet::hasEnTIMEZONE_Settings () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting Region_TimeZoneSet::getEnTIMEZONE_Settings () const {
    return _enTIMEZONE_Settings;
}

inline void Region_TimeZoneSet::setEnTIMEZONE_Settings (::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Settings_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_TIMEZONE_Setting_IsValid(enTIMEZONE_Settings_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTIMEZONE_Settings_, "VDCLK_TEN_TIMEZONE_Setting", "enTIMEZONE_Settings", "Region_TimeZoneSet");
    }
    #endif
    set_has_enTIMEZONE_Settings();
    this->_enTIMEZONE_Settings = enTIMEZONE_Settings_;
}

inline void Region_TimeZoneSet::set_has_enTIMEZONE_Settings () {
    _has_bits_[0] |= 1u << 0;
}

inline void Region_TimeZoneSet::clear_has_enTIMEZONE_Settings () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Auto_TimeZoneOffsetStatus::Auto_TimeZoneOffsetStatus ()  :
    _s8Offset_Hour (0),
    _s8Offset_Minute (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Auto_TimeZoneOffsetStatus::Auto_TimeZoneOffsetStatus (const Auto_TimeZoneOffsetStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _s8Offset_Hour (0),
    _s8Offset_Minute (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Auto_TimeZoneOffsetStatus::Auto_TimeZoneOffsetStatus (int8 s8Offset_Hour_, int8 s8Offset_Minute_)  :
    _s8Offset_Hour (s8Offset_Hour_),
    _s8Offset_Minute (s8Offset_Minute_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Auto_TimeZoneOffsetStatus::~Auto_TimeZoneOffsetStatus() {
}

inline Auto_TimeZoneOffsetStatus& Auto_TimeZoneOffsetStatus::operator = (const Auto_TimeZoneOffsetStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS8Offset_Hour()) {
            setS8Offset_Hour(rhs.getS8Offset_Hour());
        } else {
            clearS8Offset_Hour();
        }
        if (rhs.hasS8Offset_Minute()) {
            setS8Offset_Minute(rhs.getS8Offset_Minute());
        } else {
            clearS8Offset_Minute();
        }
    }
    return *this;
}

inline bool Auto_TimeZoneOffsetStatus::operator == (const Auto_TimeZoneOffsetStatus& rhs) const {
    return (((!hasS8Offset_Hour() && !rhs.hasS8Offset_Hour()) || getS8Offset_Hour() == rhs.getS8Offset_Hour()) &&
        ((!hasS8Offset_Minute() && !rhs.hasS8Offset_Minute()) || getS8Offset_Minute() == rhs.getS8Offset_Minute()));
}

inline bool Auto_TimeZoneOffsetStatus::operator != (const Auto_TimeZoneOffsetStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Auto_TimeZoneOffsetStatus::operator < (const Auto_TimeZoneOffsetStatus& rhs) const {
    if (hasS8Offset_Hour() || rhs.hasS8Offset_Hour()) {
        if (getS8Offset_Hour() < rhs.getS8Offset_Hour()) return true;
        if (getS8Offset_Hour() > rhs.getS8Offset_Hour()) return false;
    }
    if (hasS8Offset_Minute() || rhs.hasS8Offset_Minute()) {
        if (getS8Offset_Minute() < rhs.getS8Offset_Minute()) return true;
        if (getS8Offset_Minute() > rhs.getS8Offset_Minute()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Auto_TimeZoneOffsetStatus::clone() {
    return new Auto_TimeZoneOffsetStatus(*this);
}

inline bool Auto_TimeZoneOffsetStatus::operator > (const Auto_TimeZoneOffsetStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Auto_TimeZoneOffsetStatus::clear() {
    clearS8Offset_Hour();
    clearS8Offset_Minute();
}

inline void Auto_TimeZoneOffsetStatus::clearS8Offset_Hour() {
    if (hasS8Offset_Hour()) {
         clear_has_s8Offset_Hour();
        _s8Offset_Hour = 0;
     }
}

inline bool Auto_TimeZoneOffsetStatus::hasS8Offset_Hour () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int8 Auto_TimeZoneOffsetStatus::getS8Offset_Hour () const {
    return _s8Offset_Hour;
}

inline void Auto_TimeZoneOffsetStatus::setS8Offset_Hour (int8 s8Offset_Hour_) {
    set_has_s8Offset_Hour();
    this->_s8Offset_Hour = s8Offset_Hour_;
}

inline void Auto_TimeZoneOffsetStatus::clearS8Offset_Minute() {
    if (hasS8Offset_Minute()) {
         clear_has_s8Offset_Minute();
        _s8Offset_Minute = 0;
     }
}

inline bool Auto_TimeZoneOffsetStatus::hasS8Offset_Minute () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int8 Auto_TimeZoneOffsetStatus::getS8Offset_Minute () const {
    return _s8Offset_Minute;
}

inline void Auto_TimeZoneOffsetStatus::setS8Offset_Minute (int8 s8Offset_Minute_) {
    set_has_s8Offset_Minute();
    this->_s8Offset_Minute = s8Offset_Minute_;
}

inline void Auto_TimeZoneOffsetStatus::set_has_s8Offset_Hour () {
    _has_bits_[0] |= 1u << 0;
}

inline void Auto_TimeZoneOffsetStatus::clear_has_s8Offset_Hour () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Auto_TimeZoneOffsetStatus::set_has_s8Offset_Minute () {
    _has_bits_[0] |= 1u << 1;
}

inline void Auto_TimeZoneOffsetStatus::clear_has_s8Offset_Minute () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Auto_TimeZoneOffsetSet::Auto_TimeZoneOffsetSet ()  :
    _s8Offset_Hour (0),
    _s8Offset_Minute (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Auto_TimeZoneOffsetSet::Auto_TimeZoneOffsetSet (const Auto_TimeZoneOffsetSet &rhs)  :
    ::asf::core::Payload(rhs),
    _s8Offset_Hour (0),
    _s8Offset_Minute (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Auto_TimeZoneOffsetSet::Auto_TimeZoneOffsetSet (int8 s8Offset_Hour_, int8 s8Offset_Minute_)  :
    _s8Offset_Hour (s8Offset_Hour_),
    _s8Offset_Minute (s8Offset_Minute_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Auto_TimeZoneOffsetSet::~Auto_TimeZoneOffsetSet() {
}

inline Auto_TimeZoneOffsetSet& Auto_TimeZoneOffsetSet::operator = (const Auto_TimeZoneOffsetSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS8Offset_Hour()) {
            setS8Offset_Hour(rhs.getS8Offset_Hour());
        } else {
            clearS8Offset_Hour();
        }
        if (rhs.hasS8Offset_Minute()) {
            setS8Offset_Minute(rhs.getS8Offset_Minute());
        } else {
            clearS8Offset_Minute();
        }
    }
    return *this;
}

inline bool Auto_TimeZoneOffsetSet::operator == (const Auto_TimeZoneOffsetSet& rhs) const {
    return (((!hasS8Offset_Hour() && !rhs.hasS8Offset_Hour()) || getS8Offset_Hour() == rhs.getS8Offset_Hour()) &&
        ((!hasS8Offset_Minute() && !rhs.hasS8Offset_Minute()) || getS8Offset_Minute() == rhs.getS8Offset_Minute()));
}

inline bool Auto_TimeZoneOffsetSet::operator != (const Auto_TimeZoneOffsetSet& rhs) const {
    return ! (*this == rhs);
}

inline bool Auto_TimeZoneOffsetSet::operator < (const Auto_TimeZoneOffsetSet& rhs) const {
    if (hasS8Offset_Hour() || rhs.hasS8Offset_Hour()) {
        if (getS8Offset_Hour() < rhs.getS8Offset_Hour()) return true;
        if (getS8Offset_Hour() > rhs.getS8Offset_Hour()) return false;
    }
    if (hasS8Offset_Minute() || rhs.hasS8Offset_Minute()) {
        if (getS8Offset_Minute() < rhs.getS8Offset_Minute()) return true;
        if (getS8Offset_Minute() > rhs.getS8Offset_Minute()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Auto_TimeZoneOffsetSet::clone() {
    return new Auto_TimeZoneOffsetSet(*this);
}

inline bool Auto_TimeZoneOffsetSet::operator > (const Auto_TimeZoneOffsetSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Auto_TimeZoneOffsetSet::clear() {
    clearS8Offset_Hour();
    clearS8Offset_Minute();
}

inline void Auto_TimeZoneOffsetSet::clearS8Offset_Hour() {
    if (hasS8Offset_Hour()) {
         clear_has_s8Offset_Hour();
        _s8Offset_Hour = 0;
     }
}

inline bool Auto_TimeZoneOffsetSet::hasS8Offset_Hour () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int8 Auto_TimeZoneOffsetSet::getS8Offset_Hour () const {
    return _s8Offset_Hour;
}

inline void Auto_TimeZoneOffsetSet::setS8Offset_Hour (int8 s8Offset_Hour_) {
    set_has_s8Offset_Hour();
    this->_s8Offset_Hour = s8Offset_Hour_;
}

inline void Auto_TimeZoneOffsetSet::clearS8Offset_Minute() {
    if (hasS8Offset_Minute()) {
         clear_has_s8Offset_Minute();
        _s8Offset_Minute = 0;
     }
}

inline bool Auto_TimeZoneOffsetSet::hasS8Offset_Minute () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int8 Auto_TimeZoneOffsetSet::getS8Offset_Minute () const {
    return _s8Offset_Minute;
}

inline void Auto_TimeZoneOffsetSet::setS8Offset_Minute (int8 s8Offset_Minute_) {
    set_has_s8Offset_Minute();
    this->_s8Offset_Minute = s8Offset_Minute_;
}

inline void Auto_TimeZoneOffsetSet::set_has_s8Offset_Hour () {
    _has_bits_[0] |= 1u << 0;
}

inline void Auto_TimeZoneOffsetSet::clear_has_s8Offset_Hour () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Auto_TimeZoneOffsetSet::set_has_s8Offset_Minute () {
    _has_bits_[0] |= 1u << 1;
}

inline void Auto_TimeZoneOffsetSet::clear_has_s8Offset_Minute () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  NewDateFormatStatus::NewDateFormatStatus ()  :
    _enDateFormat (::clock_main_fi_types::VDCLK_TEN_NewDateFormat__VDCLK_EN_DF_dd_mm_yyyy_Dash)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NewDateFormatStatus::NewDateFormatStatus (const NewDateFormatStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _enDateFormat (::clock_main_fi_types::VDCLK_TEN_NewDateFormat__VDCLK_EN_DF_dd_mm_yyyy_Dash)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NewDateFormatStatus::NewDateFormatStatus (::clock_main_fi_types::VDCLK_TEN_NewDateFormat enDateFormat_)  :
    _enDateFormat (enDateFormat_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_NewDateFormat_IsValid(enDateFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDateFormat_, "VDCLK_TEN_NewDateFormat", "enDateFormat", "NewDateFormatStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NewDateFormatStatus::~NewDateFormatStatus() {
}

inline NewDateFormatStatus& NewDateFormatStatus::operator = (const NewDateFormatStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnDateFormat()) {
            setEnDateFormat(rhs.getEnDateFormat());
        } else {
            clearEnDateFormat();
        }
    }
    return *this;
}

inline bool NewDateFormatStatus::operator == (const NewDateFormatStatus& rhs) const {
    return (((!hasEnDateFormat() && !rhs.hasEnDateFormat()) || getEnDateFormat() == rhs.getEnDateFormat()));
}

inline bool NewDateFormatStatus::operator != (const NewDateFormatStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool NewDateFormatStatus::operator < (const NewDateFormatStatus& rhs) const {
    if (hasEnDateFormat() || rhs.hasEnDateFormat()) {
        if ((uint32)getEnDateFormat() < (uint32)rhs.getEnDateFormat()) return true;
        if ((uint32)getEnDateFormat() > (uint32)rhs.getEnDateFormat()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NewDateFormatStatus::clone() {
    return new NewDateFormatStatus(*this);
}

inline bool NewDateFormatStatus::operator > (const NewDateFormatStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NewDateFormatStatus::clear() {
    clearEnDateFormat();
}

inline void NewDateFormatStatus::clearEnDateFormat() {
    if (hasEnDateFormat()) {
         clear_has_enDateFormat();
        _enDateFormat = ::clock_main_fi_types::VDCLK_TEN_NewDateFormat__VDCLK_EN_DF_dd_mm_yyyy_Dash;
     }
}

inline bool NewDateFormatStatus::hasEnDateFormat () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_NewDateFormat NewDateFormatStatus::getEnDateFormat () const {
    return _enDateFormat;
}

inline void NewDateFormatStatus::setEnDateFormat (::clock_main_fi_types::VDCLK_TEN_NewDateFormat enDateFormat_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_NewDateFormat_IsValid(enDateFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDateFormat_, "VDCLK_TEN_NewDateFormat", "enDateFormat", "NewDateFormatStatus");
    }
    #endif
    set_has_enDateFormat();
    this->_enDateFormat = enDateFormat_;
}

inline void NewDateFormatStatus::set_has_enDateFormat () {
    _has_bits_[0] |= 1u << 0;
}

inline void NewDateFormatStatus::clear_has_enDateFormat () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NewDateFormatSet::NewDateFormatSet ()  :
    _enDateFormat (::clock_main_fi_types::VDCLK_TEN_NewDateFormat__VDCLK_EN_DF_dd_mm_yyyy_Dash)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NewDateFormatSet::NewDateFormatSet (const NewDateFormatSet &rhs)  :
    ::asf::core::Payload(rhs),
    _enDateFormat (::clock_main_fi_types::VDCLK_TEN_NewDateFormat__VDCLK_EN_DF_dd_mm_yyyy_Dash)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NewDateFormatSet::NewDateFormatSet (::clock_main_fi_types::VDCLK_TEN_NewDateFormat enDateFormat_)  :
    _enDateFormat (enDateFormat_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_NewDateFormat_IsValid(enDateFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDateFormat_, "VDCLK_TEN_NewDateFormat", "enDateFormat", "NewDateFormatSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NewDateFormatSet::~NewDateFormatSet() {
}

inline NewDateFormatSet& NewDateFormatSet::operator = (const NewDateFormatSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnDateFormat()) {
            setEnDateFormat(rhs.getEnDateFormat());
        } else {
            clearEnDateFormat();
        }
    }
    return *this;
}

inline bool NewDateFormatSet::operator == (const NewDateFormatSet& rhs) const {
    return (((!hasEnDateFormat() && !rhs.hasEnDateFormat()) || getEnDateFormat() == rhs.getEnDateFormat()));
}

inline bool NewDateFormatSet::operator != (const NewDateFormatSet& rhs) const {
    return ! (*this == rhs);
}

inline bool NewDateFormatSet::operator < (const NewDateFormatSet& rhs) const {
    if (hasEnDateFormat() || rhs.hasEnDateFormat()) {
        if ((uint32)getEnDateFormat() < (uint32)rhs.getEnDateFormat()) return true;
        if ((uint32)getEnDateFormat() > (uint32)rhs.getEnDateFormat()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NewDateFormatSet::clone() {
    return new NewDateFormatSet(*this);
}

inline bool NewDateFormatSet::operator > (const NewDateFormatSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NewDateFormatSet::clear() {
    clearEnDateFormat();
}

inline void NewDateFormatSet::clearEnDateFormat() {
    if (hasEnDateFormat()) {
         clear_has_enDateFormat();
        _enDateFormat = ::clock_main_fi_types::VDCLK_TEN_NewDateFormat__VDCLK_EN_DF_dd_mm_yyyy_Dash;
     }
}

inline bool NewDateFormatSet::hasEnDateFormat () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_NewDateFormat NewDateFormatSet::getEnDateFormat () const {
    return _enDateFormat;
}

inline void NewDateFormatSet::setEnDateFormat (::clock_main_fi_types::VDCLK_TEN_NewDateFormat enDateFormat_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_NewDateFormat_IsValid(enDateFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDateFormat_, "VDCLK_TEN_NewDateFormat", "enDateFormat", "NewDateFormatSet");
    }
    #endif
    set_has_enDateFormat();
    this->_enDateFormat = enDateFormat_;
}

inline void NewDateFormatSet::set_has_enDateFormat () {
    _has_bits_[0] |= 1u << 0;
}

inline void NewDateFormatSet::clear_has_enDateFormat () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ConnectionStatus::ConnectionStatus ()  :
    _SWCUnitConnectionStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectionStatus::ConnectionStatus (const ConnectionStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _SWCUnitConnectionStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectionStatus::ConnectionStatus (const ::clock_main_fi_types::T_SWC_UnitConnectionStatus& SWCUnitConnectionStatus_)  :
    _SWCUnitConnectionStatus (SWCUnitConnectionStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConnectionStatus::~ConnectionStatus() {
}

inline ConnectionStatus& ConnectionStatus::operator = (const ConnectionStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSWCUnitConnectionStatus()) {
            setSWCUnitConnectionStatus(rhs.getSWCUnitConnectionStatus());
        } else {
            clearSWCUnitConnectionStatus();
        }
    }
    return *this;
}

inline bool ConnectionStatus::operator == (const ConnectionStatus& rhs) const {
    return (((!hasSWCUnitConnectionStatus() && !rhs.hasSWCUnitConnectionStatus()) || getSWCUnitConnectionStatus() == rhs.getSWCUnitConnectionStatus()));
}

inline bool ConnectionStatus::operator != (const ConnectionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectionStatus::operator < (const ConnectionStatus& rhs) const {
    if (hasSWCUnitConnectionStatus() || rhs.hasSWCUnitConnectionStatus()) {
        if (getSWCUnitConnectionStatus() < rhs.getSWCUnitConnectionStatus()) return true;
        if (getSWCUnitConnectionStatus() > rhs.getSWCUnitConnectionStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConnectionStatus::clone() {
    return new ConnectionStatus(*this);
}

inline bool ConnectionStatus::operator > (const ConnectionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectionStatus::clear() {
    clearSWCUnitConnectionStatus();
}

inline void ConnectionStatus::clearSWCUnitConnectionStatus() {
    if (hasSWCUnitConnectionStatus()) {
         clear_has_SWCUnitConnectionStatus();
        _SWCUnitConnectionStatus.clear();
     }
}

inline bool ConnectionStatus::hasSWCUnitConnectionStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::clock_main_fi_types::T_SWC_UnitConnectionStatus& ConnectionStatus::getSWCUnitConnectionStatus () const {
    return _SWCUnitConnectionStatus;
}

inline ::clock_main_fi_types::T_SWC_UnitConnectionStatus& ConnectionStatus::getSWCUnitConnectionStatusMutable () {
    set_has_SWCUnitConnectionStatus();
    return _SWCUnitConnectionStatus;
}

inline void ConnectionStatus::setSWCUnitConnectionStatus (const ::clock_main_fi_types::T_SWC_UnitConnectionStatus& SWCUnitConnectionStatus_) {
    set_has_SWCUnitConnectionStatus();
    this->_SWCUnitConnectionStatus = SWCUnitConnectionStatus_;
}

inline void ConnectionStatus::set_has_SWCUnitConnectionStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConnectionStatus::clear_has_SWCUnitConnectionStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TimeZone_DSTAvailabilityStatus::TimeZone_DSTAvailabilityStatus ()  :
    _bTimeZone_DSTAvailabilityForRegion (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TimeZone_DSTAvailabilityStatus::TimeZone_DSTAvailabilityStatus (const TimeZone_DSTAvailabilityStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _bTimeZone_DSTAvailabilityForRegion (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TimeZone_DSTAvailabilityStatus::TimeZone_DSTAvailabilityStatus (bool bTimeZone_DSTAvailabilityForRegion_)  :
    _bTimeZone_DSTAvailabilityForRegion (bTimeZone_DSTAvailabilityForRegion_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TimeZone_DSTAvailabilityStatus::~TimeZone_DSTAvailabilityStatus() {
}

inline TimeZone_DSTAvailabilityStatus& TimeZone_DSTAvailabilityStatus::operator = (const TimeZone_DSTAvailabilityStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBTimeZone_DSTAvailabilityForRegion()) {
            setBTimeZone_DSTAvailabilityForRegion(rhs.getBTimeZone_DSTAvailabilityForRegion());
        } else {
            clearBTimeZone_DSTAvailabilityForRegion();
        }
    }
    return *this;
}

inline bool TimeZone_DSTAvailabilityStatus::operator == (const TimeZone_DSTAvailabilityStatus& rhs) const {
    return (((!hasBTimeZone_DSTAvailabilityForRegion() && !rhs.hasBTimeZone_DSTAvailabilityForRegion()) || getBTimeZone_DSTAvailabilityForRegion() == rhs.getBTimeZone_DSTAvailabilityForRegion()));
}

inline bool TimeZone_DSTAvailabilityStatus::operator != (const TimeZone_DSTAvailabilityStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool TimeZone_DSTAvailabilityStatus::operator < (const TimeZone_DSTAvailabilityStatus& rhs) const {
    if (hasBTimeZone_DSTAvailabilityForRegion() || rhs.hasBTimeZone_DSTAvailabilityForRegion()) {
        if (getBTimeZone_DSTAvailabilityForRegion() < rhs.getBTimeZone_DSTAvailabilityForRegion()) return true;
        if (getBTimeZone_DSTAvailabilityForRegion() > rhs.getBTimeZone_DSTAvailabilityForRegion()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TimeZone_DSTAvailabilityStatus::clone() {
    return new TimeZone_DSTAvailabilityStatus(*this);
}

inline bool TimeZone_DSTAvailabilityStatus::operator > (const TimeZone_DSTAvailabilityStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TimeZone_DSTAvailabilityStatus::clear() {
    clearBTimeZone_DSTAvailabilityForRegion();
}

inline void TimeZone_DSTAvailabilityStatus::clearBTimeZone_DSTAvailabilityForRegion() {
    if (hasBTimeZone_DSTAvailabilityForRegion()) {
         clear_has_bTimeZone_DSTAvailabilityForRegion();
        _bTimeZone_DSTAvailabilityForRegion = false;
     }
}

inline bool TimeZone_DSTAvailabilityStatus::hasBTimeZone_DSTAvailabilityForRegion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool TimeZone_DSTAvailabilityStatus::getBTimeZone_DSTAvailabilityForRegion () const {
    return _bTimeZone_DSTAvailabilityForRegion;
}

inline void TimeZone_DSTAvailabilityStatus::setBTimeZone_DSTAvailabilityForRegion (bool bTimeZone_DSTAvailabilityForRegion_) {
    set_has_bTimeZone_DSTAvailabilityForRegion();
    this->_bTimeZone_DSTAvailabilityForRegion = bTimeZone_DSTAvailabilityForRegion_;
}

inline void TimeZone_DSTAvailabilityStatus::set_has_bTimeZone_DSTAvailabilityForRegion () {
    _has_bits_[0] |= 1u << 0;
}

inline void TimeZone_DSTAvailabilityStatus::clear_has_bTimeZone_DSTAvailabilityForRegion () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  HardwareVersionStatus::HardwareVersionStatus ()  :
    _arHardwareVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HardwareVersionStatus::HardwareVersionStatus (const HardwareVersionStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _arHardwareVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HardwareVersionStatus::HardwareVersionStatus (const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& arHardwareVersionList_)  :
    _arHardwareVersionList (arHardwareVersionList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HardwareVersionStatus::~HardwareVersionStatus() {
}

inline HardwareVersionStatus& HardwareVersionStatus::operator = (const HardwareVersionStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArHardwareVersionList()) {
            setArHardwareVersionList(rhs.getArHardwareVersionList());
        } else {
            clearArHardwareVersionList();
        }
    }
    return *this;
}

inline bool HardwareVersionStatus::operator == (const HardwareVersionStatus& rhs) const {
    return (((!hasArHardwareVersionList() && !rhs.hasArHardwareVersionList()) || getArHardwareVersionList() == rhs.getArHardwareVersionList()));
}

inline bool HardwareVersionStatus::operator != (const HardwareVersionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool HardwareVersionStatus::operator < (const HardwareVersionStatus& rhs) const {
    if (hasArHardwareVersionList() || rhs.hasArHardwareVersionList()) {
        if (getArHardwareVersionList() < rhs.getArHardwareVersionList()) return true;
        if (getArHardwareVersionList() > rhs.getArHardwareVersionList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HardwareVersionStatus::clone() {
    return new HardwareVersionStatus(*this);
}

inline bool HardwareVersionStatus::operator > (const HardwareVersionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HardwareVersionStatus::clear() {
    clearArHardwareVersionList();
}

inline void HardwareVersionStatus::clearArHardwareVersionList() {
    if (hasArHardwareVersionList()) {
         clear_has_arHardwareVersionList();
        _arHardwareVersionList.clear();
     }
}

inline bool HardwareVersionStatus::hasArHardwareVersionList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& HardwareVersionStatus::getArHardwareVersionList () const {
    return _arHardwareVersionList;
}

inline ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& HardwareVersionStatus::getArHardwareVersionListMutable () {
    set_has_arHardwareVersionList();
    return _arHardwareVersionList;
}

inline void HardwareVersionStatus::setArHardwareVersionList (const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& arHardwareVersionList_) {
    set_has_arHardwareVersionList();
    this->_arHardwareVersionList = arHardwareVersionList_;
}

inline void HardwareVersionStatus::set_has_arHardwareVersionList () {
    _has_bits_[0] |= 1u << 0;
}

inline void HardwareVersionStatus::clear_has_arHardwareVersionList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SoftwareVersionStatus::SoftwareVersionStatus ()  :
    _arSoftwareVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SoftwareVersionStatus::SoftwareVersionStatus (const SoftwareVersionStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _arSoftwareVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SoftwareVersionStatus::SoftwareVersionStatus (const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& arSoftwareVersionList_)  :
    _arSoftwareVersionList (arSoftwareVersionList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SoftwareVersionStatus::~SoftwareVersionStatus() {
}

inline SoftwareVersionStatus& SoftwareVersionStatus::operator = (const SoftwareVersionStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArSoftwareVersionList()) {
            setArSoftwareVersionList(rhs.getArSoftwareVersionList());
        } else {
            clearArSoftwareVersionList();
        }
    }
    return *this;
}

inline bool SoftwareVersionStatus::operator == (const SoftwareVersionStatus& rhs) const {
    return (((!hasArSoftwareVersionList() && !rhs.hasArSoftwareVersionList()) || getArSoftwareVersionList() == rhs.getArSoftwareVersionList()));
}

inline bool SoftwareVersionStatus::operator != (const SoftwareVersionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SoftwareVersionStatus::operator < (const SoftwareVersionStatus& rhs) const {
    if (hasArSoftwareVersionList() || rhs.hasArSoftwareVersionList()) {
        if (getArSoftwareVersionList() < rhs.getArSoftwareVersionList()) return true;
        if (getArSoftwareVersionList() > rhs.getArSoftwareVersionList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SoftwareVersionStatus::clone() {
    return new SoftwareVersionStatus(*this);
}

inline bool SoftwareVersionStatus::operator > (const SoftwareVersionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SoftwareVersionStatus::clear() {
    clearArSoftwareVersionList();
}

inline void SoftwareVersionStatus::clearArSoftwareVersionList() {
    if (hasArSoftwareVersionList()) {
         clear_has_arSoftwareVersionList();
        _arSoftwareVersionList.clear();
     }
}

inline bool SoftwareVersionStatus::hasArSoftwareVersionList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& SoftwareVersionStatus::getArSoftwareVersionList () const {
    return _arSoftwareVersionList;
}

inline ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& SoftwareVersionStatus::getArSoftwareVersionListMutable () {
    set_has_arSoftwareVersionList();
    return _arSoftwareVersionList;
}

inline void SoftwareVersionStatus::setArSoftwareVersionList (const ::std::vector< ::clock_main_fi_types::T_VdClock_UnitVersion >& arSoftwareVersionList_) {
    set_has_arSoftwareVersionList();
    this->_arSoftwareVersionList = arSoftwareVersionList_;
}

inline void SoftwareVersionStatus::set_has_arSoftwareVersionList () {
    _has_bits_[0] |= 1u << 0;
}

inline void SoftwareVersionStatus::clear_has_arSoftwareVersionList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DebugMode_TimeDateStatus::DebugMode_TimeDateStatus ()  :
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u),
    _bdebugMode (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DebugMode_TimeDateStatus::DebugMode_TimeDateStatus (const DebugMode_TimeDateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u),
    _bdebugMode (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DebugMode_TimeDateStatus::DebugMode_TimeDateStatus (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_, bool bdebugMode_)  :
    _s16Year (s16Year_),
    _u8Month (u8Month_),
    _u8Day (u8Day_),
    _u8Hours (u8Hours_),
    _u8Minutes (u8Minutes_),
    _u8Seconds (u8Seconds_),
    _u8Weekday (u8Weekday_),
    _bdebugMode (bdebugMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DebugMode_TimeDateStatus::~DebugMode_TimeDateStatus() {
}

inline DebugMode_TimeDateStatus& DebugMode_TimeDateStatus::operator = (const DebugMode_TimeDateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS16Year()) {
            setS16Year(rhs.getS16Year());
        } else {
            clearS16Year();
        }
        if (rhs.hasU8Month()) {
            setU8Month(rhs.getU8Month());
        } else {
            clearU8Month();
        }
        if (rhs.hasU8Day()) {
            setU8Day(rhs.getU8Day());
        } else {
            clearU8Day();
        }
        if (rhs.hasU8Hours()) {
            setU8Hours(rhs.getU8Hours());
        } else {
            clearU8Hours();
        }
        if (rhs.hasU8Minutes()) {
            setU8Minutes(rhs.getU8Minutes());
        } else {
            clearU8Minutes();
        }
        if (rhs.hasU8Seconds()) {
            setU8Seconds(rhs.getU8Seconds());
        } else {
            clearU8Seconds();
        }
        if (rhs.hasU8Weekday()) {
            setU8Weekday(rhs.getU8Weekday());
        } else {
            clearU8Weekday();
        }
        if (rhs.hasBdebugMode()) {
            setBdebugMode(rhs.getBdebugMode());
        } else {
            clearBdebugMode();
        }
    }
    return *this;
}

inline bool DebugMode_TimeDateStatus::operator == (const DebugMode_TimeDateStatus& rhs) const {
    return (((!hasS16Year() && !rhs.hasS16Year()) || getS16Year() == rhs.getS16Year()) &&
        ((!hasU8Month() && !rhs.hasU8Month()) || getU8Month() == rhs.getU8Month()) &&
        ((!hasU8Day() && !rhs.hasU8Day()) || getU8Day() == rhs.getU8Day()) &&
        ((!hasU8Hours() && !rhs.hasU8Hours()) || getU8Hours() == rhs.getU8Hours()) &&
        ((!hasU8Minutes() && !rhs.hasU8Minutes()) || getU8Minutes() == rhs.getU8Minutes()) &&
        ((!hasU8Seconds() && !rhs.hasU8Seconds()) || getU8Seconds() == rhs.getU8Seconds()) &&
        ((!hasU8Weekday() && !rhs.hasU8Weekday()) || getU8Weekday() == rhs.getU8Weekday()) &&
        ((!hasBdebugMode() && !rhs.hasBdebugMode()) || getBdebugMode() == rhs.getBdebugMode()));
}

inline bool DebugMode_TimeDateStatus::operator != (const DebugMode_TimeDateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DebugMode_TimeDateStatus::operator < (const DebugMode_TimeDateStatus& rhs) const {
    if (hasS16Year() || rhs.hasS16Year()) {
        if (getS16Year() < rhs.getS16Year()) return true;
        if (getS16Year() > rhs.getS16Year()) return false;
    }
    if (hasU8Month() || rhs.hasU8Month()) {
        if (getU8Month() < rhs.getU8Month()) return true;
        if (getU8Month() > rhs.getU8Month()) return false;
    }
    if (hasU8Day() || rhs.hasU8Day()) {
        if (getU8Day() < rhs.getU8Day()) return true;
        if (getU8Day() > rhs.getU8Day()) return false;
    }
    if (hasU8Hours() || rhs.hasU8Hours()) {
        if (getU8Hours() < rhs.getU8Hours()) return true;
        if (getU8Hours() > rhs.getU8Hours()) return false;
    }
    if (hasU8Minutes() || rhs.hasU8Minutes()) {
        if (getU8Minutes() < rhs.getU8Minutes()) return true;
        if (getU8Minutes() > rhs.getU8Minutes()) return false;
    }
    if (hasU8Seconds() || rhs.hasU8Seconds()) {
        if (getU8Seconds() < rhs.getU8Seconds()) return true;
        if (getU8Seconds() > rhs.getU8Seconds()) return false;
    }
    if (hasU8Weekday() || rhs.hasU8Weekday()) {
        if (getU8Weekday() < rhs.getU8Weekday()) return true;
        if (getU8Weekday() > rhs.getU8Weekday()) return false;
    }
    if (hasBdebugMode() || rhs.hasBdebugMode()) {
        if (getBdebugMode() < rhs.getBdebugMode()) return true;
        if (getBdebugMode() > rhs.getBdebugMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DebugMode_TimeDateStatus::clone() {
    return new DebugMode_TimeDateStatus(*this);
}

inline bool DebugMode_TimeDateStatus::operator > (const DebugMode_TimeDateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DebugMode_TimeDateStatus::clear() {
    clearS16Year();
    clearU8Month();
    clearU8Day();
    clearU8Hours();
    clearU8Minutes();
    clearU8Seconds();
    clearU8Weekday();
    clearBdebugMode();
}

inline void DebugMode_TimeDateStatus::clearS16Year() {
    if (hasS16Year()) {
         clear_has_s16Year();
        _s16Year = 0;
     }
}

inline bool DebugMode_TimeDateStatus::hasS16Year () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 DebugMode_TimeDateStatus::getS16Year () const {
    return _s16Year;
}

inline void DebugMode_TimeDateStatus::setS16Year (int16 s16Year_) {
    set_has_s16Year();
    this->_s16Year = s16Year_;
}

inline void DebugMode_TimeDateStatus::clearU8Month() {
    if (hasU8Month()) {
         clear_has_u8Month();
        _u8Month = 0u;
     }
}

inline bool DebugMode_TimeDateStatus::hasU8Month () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 DebugMode_TimeDateStatus::getU8Month () const {
    return _u8Month;
}

inline void DebugMode_TimeDateStatus::setU8Month (uint8 u8Month_) {
    set_has_u8Month();
    this->_u8Month = u8Month_;
}

inline void DebugMode_TimeDateStatus::clearU8Day() {
    if (hasU8Day()) {
         clear_has_u8Day();
        _u8Day = 0u;
     }
}

inline bool DebugMode_TimeDateStatus::hasU8Day () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 DebugMode_TimeDateStatus::getU8Day () const {
    return _u8Day;
}

inline void DebugMode_TimeDateStatus::setU8Day (uint8 u8Day_) {
    set_has_u8Day();
    this->_u8Day = u8Day_;
}

inline void DebugMode_TimeDateStatus::clearU8Hours() {
    if (hasU8Hours()) {
         clear_has_u8Hours();
        _u8Hours = 0u;
     }
}

inline bool DebugMode_TimeDateStatus::hasU8Hours () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 DebugMode_TimeDateStatus::getU8Hours () const {
    return _u8Hours;
}

inline void DebugMode_TimeDateStatus::setU8Hours (uint8 u8Hours_) {
    set_has_u8Hours();
    this->_u8Hours = u8Hours_;
}

inline void DebugMode_TimeDateStatus::clearU8Minutes() {
    if (hasU8Minutes()) {
         clear_has_u8Minutes();
        _u8Minutes = 0u;
     }
}

inline bool DebugMode_TimeDateStatus::hasU8Minutes () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 DebugMode_TimeDateStatus::getU8Minutes () const {
    return _u8Minutes;
}

inline void DebugMode_TimeDateStatus::setU8Minutes (uint8 u8Minutes_) {
    set_has_u8Minutes();
    this->_u8Minutes = u8Minutes_;
}

inline void DebugMode_TimeDateStatus::clearU8Seconds() {
    if (hasU8Seconds()) {
         clear_has_u8Seconds();
        _u8Seconds = 0u;
     }
}

inline bool DebugMode_TimeDateStatus::hasU8Seconds () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 DebugMode_TimeDateStatus::getU8Seconds () const {
    return _u8Seconds;
}

inline void DebugMode_TimeDateStatus::setU8Seconds (uint8 u8Seconds_) {
    set_has_u8Seconds();
    this->_u8Seconds = u8Seconds_;
}

inline void DebugMode_TimeDateStatus::clearU8Weekday() {
    if (hasU8Weekday()) {
         clear_has_u8Weekday();
        _u8Weekday = 0u;
     }
}

inline bool DebugMode_TimeDateStatus::hasU8Weekday () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 DebugMode_TimeDateStatus::getU8Weekday () const {
    return _u8Weekday;
}

inline void DebugMode_TimeDateStatus::setU8Weekday (uint8 u8Weekday_) {
    set_has_u8Weekday();
    this->_u8Weekday = u8Weekday_;
}

inline void DebugMode_TimeDateStatus::clearBdebugMode() {
    if (hasBdebugMode()) {
         clear_has_bdebugMode();
        _bdebugMode = false;
     }
}

inline bool DebugMode_TimeDateStatus::hasBdebugMode () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool DebugMode_TimeDateStatus::getBdebugMode () const {
    return _bdebugMode;
}

inline void DebugMode_TimeDateStatus::setBdebugMode (bool bdebugMode_) {
    set_has_bdebugMode();
    this->_bdebugMode = bdebugMode_;
}

inline void DebugMode_TimeDateStatus::set_has_s16Year () {
    _has_bits_[0] |= 1u << 0;
}

inline void DebugMode_TimeDateStatus::clear_has_s16Year () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DebugMode_TimeDateStatus::set_has_u8Month () {
    _has_bits_[0] |= 1u << 1;
}

inline void DebugMode_TimeDateStatus::clear_has_u8Month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DebugMode_TimeDateStatus::set_has_u8Day () {
    _has_bits_[0] |= 1u << 2;
}

inline void DebugMode_TimeDateStatus::clear_has_u8Day () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DebugMode_TimeDateStatus::set_has_u8Hours () {
    _has_bits_[0] |= 1u << 3;
}

inline void DebugMode_TimeDateStatus::clear_has_u8Hours () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void DebugMode_TimeDateStatus::set_has_u8Minutes () {
    _has_bits_[0] |= 1u << 4;
}

inline void DebugMode_TimeDateStatus::clear_has_u8Minutes () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void DebugMode_TimeDateStatus::set_has_u8Seconds () {
    _has_bits_[0] |= 1u << 5;
}

inline void DebugMode_TimeDateStatus::clear_has_u8Seconds () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void DebugMode_TimeDateStatus::set_has_u8Weekday () {
    _has_bits_[0] |= 1u << 6;
}

inline void DebugMode_TimeDateStatus::clear_has_u8Weekday () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void DebugMode_TimeDateStatus::set_has_bdebugMode () {
    _has_bits_[0] |= 1u << 7;
}

inline void DebugMode_TimeDateStatus::clear_has_bdebugMode () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  DebugMode_TimeDateSet::DebugMode_TimeDateSet ()  :
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u),
    _bdebugMode (false),
    _u8ChangeMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DebugMode_TimeDateSet::DebugMode_TimeDateSet (const DebugMode_TimeDateSet &rhs)  :
    ::asf::core::Payload(rhs),
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u),
    _bdebugMode (false),
    _u8ChangeMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DebugMode_TimeDateSet::DebugMode_TimeDateSet (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_, bool bdebugMode_, uint8 u8ChangeMask_)  :
    _s16Year (s16Year_),
    _u8Month (u8Month_),
    _u8Day (u8Day_),
    _u8Hours (u8Hours_),
    _u8Minutes (u8Minutes_),
    _u8Seconds (u8Seconds_),
    _u8Weekday (u8Weekday_),
    _bdebugMode (bdebugMode_),
    _u8ChangeMask (u8ChangeMask_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DebugMode_TimeDateSet::~DebugMode_TimeDateSet() {
}

inline DebugMode_TimeDateSet& DebugMode_TimeDateSet::operator = (const DebugMode_TimeDateSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS16Year()) {
            setS16Year(rhs.getS16Year());
        } else {
            clearS16Year();
        }
        if (rhs.hasU8Month()) {
            setU8Month(rhs.getU8Month());
        } else {
            clearU8Month();
        }
        if (rhs.hasU8Day()) {
            setU8Day(rhs.getU8Day());
        } else {
            clearU8Day();
        }
        if (rhs.hasU8Hours()) {
            setU8Hours(rhs.getU8Hours());
        } else {
            clearU8Hours();
        }
        if (rhs.hasU8Minutes()) {
            setU8Minutes(rhs.getU8Minutes());
        } else {
            clearU8Minutes();
        }
        if (rhs.hasU8Seconds()) {
            setU8Seconds(rhs.getU8Seconds());
        } else {
            clearU8Seconds();
        }
        if (rhs.hasU8Weekday()) {
            setU8Weekday(rhs.getU8Weekday());
        } else {
            clearU8Weekday();
        }
        if (rhs.hasBdebugMode()) {
            setBdebugMode(rhs.getBdebugMode());
        } else {
            clearBdebugMode();
        }
        if (rhs.hasU8ChangeMask()) {
            setU8ChangeMask(rhs.getU8ChangeMask());
        } else {
            clearU8ChangeMask();
        }
    }
    return *this;
}

inline bool DebugMode_TimeDateSet::operator == (const DebugMode_TimeDateSet& rhs) const {
    return (((!hasS16Year() && !rhs.hasS16Year()) || getS16Year() == rhs.getS16Year()) &&
        ((!hasU8Month() && !rhs.hasU8Month()) || getU8Month() == rhs.getU8Month()) &&
        ((!hasU8Day() && !rhs.hasU8Day()) || getU8Day() == rhs.getU8Day()) &&
        ((!hasU8Hours() && !rhs.hasU8Hours()) || getU8Hours() == rhs.getU8Hours()) &&
        ((!hasU8Minutes() && !rhs.hasU8Minutes()) || getU8Minutes() == rhs.getU8Minutes()) &&
        ((!hasU8Seconds() && !rhs.hasU8Seconds()) || getU8Seconds() == rhs.getU8Seconds()) &&
        ((!hasU8Weekday() && !rhs.hasU8Weekday()) || getU8Weekday() == rhs.getU8Weekday()) &&
        ((!hasBdebugMode() && !rhs.hasBdebugMode()) || getBdebugMode() == rhs.getBdebugMode()) &&
        ((!hasU8ChangeMask() && !rhs.hasU8ChangeMask()) || getU8ChangeMask() == rhs.getU8ChangeMask()));
}

inline bool DebugMode_TimeDateSet::operator != (const DebugMode_TimeDateSet& rhs) const {
    return ! (*this == rhs);
}

inline bool DebugMode_TimeDateSet::operator < (const DebugMode_TimeDateSet& rhs) const {
    if (hasS16Year() || rhs.hasS16Year()) {
        if (getS16Year() < rhs.getS16Year()) return true;
        if (getS16Year() > rhs.getS16Year()) return false;
    }
    if (hasU8Month() || rhs.hasU8Month()) {
        if (getU8Month() < rhs.getU8Month()) return true;
        if (getU8Month() > rhs.getU8Month()) return false;
    }
    if (hasU8Day() || rhs.hasU8Day()) {
        if (getU8Day() < rhs.getU8Day()) return true;
        if (getU8Day() > rhs.getU8Day()) return false;
    }
    if (hasU8Hours() || rhs.hasU8Hours()) {
        if (getU8Hours() < rhs.getU8Hours()) return true;
        if (getU8Hours() > rhs.getU8Hours()) return false;
    }
    if (hasU8Minutes() || rhs.hasU8Minutes()) {
        if (getU8Minutes() < rhs.getU8Minutes()) return true;
        if (getU8Minutes() > rhs.getU8Minutes()) return false;
    }
    if (hasU8Seconds() || rhs.hasU8Seconds()) {
        if (getU8Seconds() < rhs.getU8Seconds()) return true;
        if (getU8Seconds() > rhs.getU8Seconds()) return false;
    }
    if (hasU8Weekday() || rhs.hasU8Weekday()) {
        if (getU8Weekday() < rhs.getU8Weekday()) return true;
        if (getU8Weekday() > rhs.getU8Weekday()) return false;
    }
    if (hasBdebugMode() || rhs.hasBdebugMode()) {
        if (getBdebugMode() < rhs.getBdebugMode()) return true;
        if (getBdebugMode() > rhs.getBdebugMode()) return false;
    }
    if (hasU8ChangeMask() || rhs.hasU8ChangeMask()) {
        if (getU8ChangeMask() < rhs.getU8ChangeMask()) return true;
        if (getU8ChangeMask() > rhs.getU8ChangeMask()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DebugMode_TimeDateSet::clone() {
    return new DebugMode_TimeDateSet(*this);
}

inline bool DebugMode_TimeDateSet::operator > (const DebugMode_TimeDateSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DebugMode_TimeDateSet::clear() {
    clearS16Year();
    clearU8Month();
    clearU8Day();
    clearU8Hours();
    clearU8Minutes();
    clearU8Seconds();
    clearU8Weekday();
    clearBdebugMode();
    clearU8ChangeMask();
}

inline void DebugMode_TimeDateSet::clearS16Year() {
    if (hasS16Year()) {
         clear_has_s16Year();
        _s16Year = 0;
     }
}

inline bool DebugMode_TimeDateSet::hasS16Year () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 DebugMode_TimeDateSet::getS16Year () const {
    return _s16Year;
}

inline void DebugMode_TimeDateSet::setS16Year (int16 s16Year_) {
    set_has_s16Year();
    this->_s16Year = s16Year_;
}

inline void DebugMode_TimeDateSet::clearU8Month() {
    if (hasU8Month()) {
         clear_has_u8Month();
        _u8Month = 0u;
     }
}

inline bool DebugMode_TimeDateSet::hasU8Month () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 DebugMode_TimeDateSet::getU8Month () const {
    return _u8Month;
}

inline void DebugMode_TimeDateSet::setU8Month (uint8 u8Month_) {
    set_has_u8Month();
    this->_u8Month = u8Month_;
}

inline void DebugMode_TimeDateSet::clearU8Day() {
    if (hasU8Day()) {
         clear_has_u8Day();
        _u8Day = 0u;
     }
}

inline bool DebugMode_TimeDateSet::hasU8Day () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 DebugMode_TimeDateSet::getU8Day () const {
    return _u8Day;
}

inline void DebugMode_TimeDateSet::setU8Day (uint8 u8Day_) {
    set_has_u8Day();
    this->_u8Day = u8Day_;
}

inline void DebugMode_TimeDateSet::clearU8Hours() {
    if (hasU8Hours()) {
         clear_has_u8Hours();
        _u8Hours = 0u;
     }
}

inline bool DebugMode_TimeDateSet::hasU8Hours () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 DebugMode_TimeDateSet::getU8Hours () const {
    return _u8Hours;
}

inline void DebugMode_TimeDateSet::setU8Hours (uint8 u8Hours_) {
    set_has_u8Hours();
    this->_u8Hours = u8Hours_;
}

inline void DebugMode_TimeDateSet::clearU8Minutes() {
    if (hasU8Minutes()) {
         clear_has_u8Minutes();
        _u8Minutes = 0u;
     }
}

inline bool DebugMode_TimeDateSet::hasU8Minutes () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 DebugMode_TimeDateSet::getU8Minutes () const {
    return _u8Minutes;
}

inline void DebugMode_TimeDateSet::setU8Minutes (uint8 u8Minutes_) {
    set_has_u8Minutes();
    this->_u8Minutes = u8Minutes_;
}

inline void DebugMode_TimeDateSet::clearU8Seconds() {
    if (hasU8Seconds()) {
         clear_has_u8Seconds();
        _u8Seconds = 0u;
     }
}

inline bool DebugMode_TimeDateSet::hasU8Seconds () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 DebugMode_TimeDateSet::getU8Seconds () const {
    return _u8Seconds;
}

inline void DebugMode_TimeDateSet::setU8Seconds (uint8 u8Seconds_) {
    set_has_u8Seconds();
    this->_u8Seconds = u8Seconds_;
}

inline void DebugMode_TimeDateSet::clearU8Weekday() {
    if (hasU8Weekday()) {
         clear_has_u8Weekday();
        _u8Weekday = 0u;
     }
}

inline bool DebugMode_TimeDateSet::hasU8Weekday () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 DebugMode_TimeDateSet::getU8Weekday () const {
    return _u8Weekday;
}

inline void DebugMode_TimeDateSet::setU8Weekday (uint8 u8Weekday_) {
    set_has_u8Weekday();
    this->_u8Weekday = u8Weekday_;
}

inline void DebugMode_TimeDateSet::clearBdebugMode() {
    if (hasBdebugMode()) {
         clear_has_bdebugMode();
        _bdebugMode = false;
     }
}

inline bool DebugMode_TimeDateSet::hasBdebugMode () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool DebugMode_TimeDateSet::getBdebugMode () const {
    return _bdebugMode;
}

inline void DebugMode_TimeDateSet::setBdebugMode (bool bdebugMode_) {
    set_has_bdebugMode();
    this->_bdebugMode = bdebugMode_;
}

inline void DebugMode_TimeDateSet::clearU8ChangeMask() {
    if (hasU8ChangeMask()) {
         clear_has_u8ChangeMask();
        _u8ChangeMask = 0u;
     }
}

inline bool DebugMode_TimeDateSet::hasU8ChangeMask () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint8 DebugMode_TimeDateSet::getU8ChangeMask () const {
    return _u8ChangeMask;
}

inline void DebugMode_TimeDateSet::setU8ChangeMask (uint8 u8ChangeMask_) {
    set_has_u8ChangeMask();
    this->_u8ChangeMask = u8ChangeMask_;
}

inline void DebugMode_TimeDateSet::set_has_s16Year () {
    _has_bits_[0] |= 1u << 0;
}

inline void DebugMode_TimeDateSet::clear_has_s16Year () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DebugMode_TimeDateSet::set_has_u8Month () {
    _has_bits_[0] |= 1u << 1;
}

inline void DebugMode_TimeDateSet::clear_has_u8Month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DebugMode_TimeDateSet::set_has_u8Day () {
    _has_bits_[0] |= 1u << 2;
}

inline void DebugMode_TimeDateSet::clear_has_u8Day () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DebugMode_TimeDateSet::set_has_u8Hours () {
    _has_bits_[0] |= 1u << 3;
}

inline void DebugMode_TimeDateSet::clear_has_u8Hours () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void DebugMode_TimeDateSet::set_has_u8Minutes () {
    _has_bits_[0] |= 1u << 4;
}

inline void DebugMode_TimeDateSet::clear_has_u8Minutes () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void DebugMode_TimeDateSet::set_has_u8Seconds () {
    _has_bits_[0] |= 1u << 5;
}

inline void DebugMode_TimeDateSet::clear_has_u8Seconds () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void DebugMode_TimeDateSet::set_has_u8Weekday () {
    _has_bits_[0] |= 1u << 6;
}

inline void DebugMode_TimeDateSet::clear_has_u8Weekday () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void DebugMode_TimeDateSet::set_has_bdebugMode () {
    _has_bits_[0] |= 1u << 7;
}

inline void DebugMode_TimeDateSet::clear_has_bdebugMode () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void DebugMode_TimeDateSet::set_has_u8ChangeMask () {
    _has_bits_[0] |= 1u << 8;
}

inline void DebugMode_TimeDateSet::clear_has_u8ChangeMask () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  UTC_TimeDateUpdateStatus::UTC_TimeDateUpdateStatus ()  :
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u),
    _bTimeValidity (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UTC_TimeDateUpdateStatus::UTC_TimeDateUpdateStatus (const UTC_TimeDateUpdateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u),
    _bTimeValidity (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UTC_TimeDateUpdateStatus::UTC_TimeDateUpdateStatus (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_, bool bTimeValidity_)  :
    _s16Year (s16Year_),
    _u8Month (u8Month_),
    _u8Day (u8Day_),
    _u8Hours (u8Hours_),
    _u8Minutes (u8Minutes_),
    _u8Seconds (u8Seconds_),
    _u8Weekday (u8Weekday_),
    _bTimeValidity (bTimeValidity_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UTC_TimeDateUpdateStatus::~UTC_TimeDateUpdateStatus() {
}

inline UTC_TimeDateUpdateStatus& UTC_TimeDateUpdateStatus::operator = (const UTC_TimeDateUpdateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS16Year()) {
            setS16Year(rhs.getS16Year());
        } else {
            clearS16Year();
        }
        if (rhs.hasU8Month()) {
            setU8Month(rhs.getU8Month());
        } else {
            clearU8Month();
        }
        if (rhs.hasU8Day()) {
            setU8Day(rhs.getU8Day());
        } else {
            clearU8Day();
        }
        if (rhs.hasU8Hours()) {
            setU8Hours(rhs.getU8Hours());
        } else {
            clearU8Hours();
        }
        if (rhs.hasU8Minutes()) {
            setU8Minutes(rhs.getU8Minutes());
        } else {
            clearU8Minutes();
        }
        if (rhs.hasU8Seconds()) {
            setU8Seconds(rhs.getU8Seconds());
        } else {
            clearU8Seconds();
        }
        if (rhs.hasU8Weekday()) {
            setU8Weekday(rhs.getU8Weekday());
        } else {
            clearU8Weekday();
        }
        if (rhs.hasBTimeValidity()) {
            setBTimeValidity(rhs.getBTimeValidity());
        } else {
            clearBTimeValidity();
        }
    }
    return *this;
}

inline bool UTC_TimeDateUpdateStatus::operator == (const UTC_TimeDateUpdateStatus& rhs) const {
    return (((!hasS16Year() && !rhs.hasS16Year()) || getS16Year() == rhs.getS16Year()) &&
        ((!hasU8Month() && !rhs.hasU8Month()) || getU8Month() == rhs.getU8Month()) &&
        ((!hasU8Day() && !rhs.hasU8Day()) || getU8Day() == rhs.getU8Day()) &&
        ((!hasU8Hours() && !rhs.hasU8Hours()) || getU8Hours() == rhs.getU8Hours()) &&
        ((!hasU8Minutes() && !rhs.hasU8Minutes()) || getU8Minutes() == rhs.getU8Minutes()) &&
        ((!hasU8Seconds() && !rhs.hasU8Seconds()) || getU8Seconds() == rhs.getU8Seconds()) &&
        ((!hasU8Weekday() && !rhs.hasU8Weekday()) || getU8Weekday() == rhs.getU8Weekday()) &&
        ((!hasBTimeValidity() && !rhs.hasBTimeValidity()) || getBTimeValidity() == rhs.getBTimeValidity()));
}

inline bool UTC_TimeDateUpdateStatus::operator != (const UTC_TimeDateUpdateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool UTC_TimeDateUpdateStatus::operator < (const UTC_TimeDateUpdateStatus& rhs) const {
    if (hasS16Year() || rhs.hasS16Year()) {
        if (getS16Year() < rhs.getS16Year()) return true;
        if (getS16Year() > rhs.getS16Year()) return false;
    }
    if (hasU8Month() || rhs.hasU8Month()) {
        if (getU8Month() < rhs.getU8Month()) return true;
        if (getU8Month() > rhs.getU8Month()) return false;
    }
    if (hasU8Day() || rhs.hasU8Day()) {
        if (getU8Day() < rhs.getU8Day()) return true;
        if (getU8Day() > rhs.getU8Day()) return false;
    }
    if (hasU8Hours() || rhs.hasU8Hours()) {
        if (getU8Hours() < rhs.getU8Hours()) return true;
        if (getU8Hours() > rhs.getU8Hours()) return false;
    }
    if (hasU8Minutes() || rhs.hasU8Minutes()) {
        if (getU8Minutes() < rhs.getU8Minutes()) return true;
        if (getU8Minutes() > rhs.getU8Minutes()) return false;
    }
    if (hasU8Seconds() || rhs.hasU8Seconds()) {
        if (getU8Seconds() < rhs.getU8Seconds()) return true;
        if (getU8Seconds() > rhs.getU8Seconds()) return false;
    }
    if (hasU8Weekday() || rhs.hasU8Weekday()) {
        if (getU8Weekday() < rhs.getU8Weekday()) return true;
        if (getU8Weekday() > rhs.getU8Weekday()) return false;
    }
    if (hasBTimeValidity() || rhs.hasBTimeValidity()) {
        if (getBTimeValidity() < rhs.getBTimeValidity()) return true;
        if (getBTimeValidity() > rhs.getBTimeValidity()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UTC_TimeDateUpdateStatus::clone() {
    return new UTC_TimeDateUpdateStatus(*this);
}

inline bool UTC_TimeDateUpdateStatus::operator > (const UTC_TimeDateUpdateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UTC_TimeDateUpdateStatus::clear() {
    clearS16Year();
    clearU8Month();
    clearU8Day();
    clearU8Hours();
    clearU8Minutes();
    clearU8Seconds();
    clearU8Weekday();
    clearBTimeValidity();
}

inline void UTC_TimeDateUpdateStatus::clearS16Year() {
    if (hasS16Year()) {
         clear_has_s16Year();
        _s16Year = 0;
     }
}

inline bool UTC_TimeDateUpdateStatus::hasS16Year () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 UTC_TimeDateUpdateStatus::getS16Year () const {
    return _s16Year;
}

inline void UTC_TimeDateUpdateStatus::setS16Year (int16 s16Year_) {
    set_has_s16Year();
    this->_s16Year = s16Year_;
}

inline void UTC_TimeDateUpdateStatus::clearU8Month() {
    if (hasU8Month()) {
         clear_has_u8Month();
        _u8Month = 0u;
     }
}

inline bool UTC_TimeDateUpdateStatus::hasU8Month () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 UTC_TimeDateUpdateStatus::getU8Month () const {
    return _u8Month;
}

inline void UTC_TimeDateUpdateStatus::setU8Month (uint8 u8Month_) {
    set_has_u8Month();
    this->_u8Month = u8Month_;
}

inline void UTC_TimeDateUpdateStatus::clearU8Day() {
    if (hasU8Day()) {
         clear_has_u8Day();
        _u8Day = 0u;
     }
}

inline bool UTC_TimeDateUpdateStatus::hasU8Day () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 UTC_TimeDateUpdateStatus::getU8Day () const {
    return _u8Day;
}

inline void UTC_TimeDateUpdateStatus::setU8Day (uint8 u8Day_) {
    set_has_u8Day();
    this->_u8Day = u8Day_;
}

inline void UTC_TimeDateUpdateStatus::clearU8Hours() {
    if (hasU8Hours()) {
         clear_has_u8Hours();
        _u8Hours = 0u;
     }
}

inline bool UTC_TimeDateUpdateStatus::hasU8Hours () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 UTC_TimeDateUpdateStatus::getU8Hours () const {
    return _u8Hours;
}

inline void UTC_TimeDateUpdateStatus::setU8Hours (uint8 u8Hours_) {
    set_has_u8Hours();
    this->_u8Hours = u8Hours_;
}

inline void UTC_TimeDateUpdateStatus::clearU8Minutes() {
    if (hasU8Minutes()) {
         clear_has_u8Minutes();
        _u8Minutes = 0u;
     }
}

inline bool UTC_TimeDateUpdateStatus::hasU8Minutes () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 UTC_TimeDateUpdateStatus::getU8Minutes () const {
    return _u8Minutes;
}

inline void UTC_TimeDateUpdateStatus::setU8Minutes (uint8 u8Minutes_) {
    set_has_u8Minutes();
    this->_u8Minutes = u8Minutes_;
}

inline void UTC_TimeDateUpdateStatus::clearU8Seconds() {
    if (hasU8Seconds()) {
         clear_has_u8Seconds();
        _u8Seconds = 0u;
     }
}

inline bool UTC_TimeDateUpdateStatus::hasU8Seconds () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 UTC_TimeDateUpdateStatus::getU8Seconds () const {
    return _u8Seconds;
}

inline void UTC_TimeDateUpdateStatus::setU8Seconds (uint8 u8Seconds_) {
    set_has_u8Seconds();
    this->_u8Seconds = u8Seconds_;
}

inline void UTC_TimeDateUpdateStatus::clearU8Weekday() {
    if (hasU8Weekday()) {
         clear_has_u8Weekday();
        _u8Weekday = 0u;
     }
}

inline bool UTC_TimeDateUpdateStatus::hasU8Weekday () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 UTC_TimeDateUpdateStatus::getU8Weekday () const {
    return _u8Weekday;
}

inline void UTC_TimeDateUpdateStatus::setU8Weekday (uint8 u8Weekday_) {
    set_has_u8Weekday();
    this->_u8Weekday = u8Weekday_;
}

inline void UTC_TimeDateUpdateStatus::clearBTimeValidity() {
    if (hasBTimeValidity()) {
         clear_has_bTimeValidity();
        _bTimeValidity = false;
     }
}

inline bool UTC_TimeDateUpdateStatus::hasBTimeValidity () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool UTC_TimeDateUpdateStatus::getBTimeValidity () const {
    return _bTimeValidity;
}

inline void UTC_TimeDateUpdateStatus::setBTimeValidity (bool bTimeValidity_) {
    set_has_bTimeValidity();
    this->_bTimeValidity = bTimeValidity_;
}

inline void UTC_TimeDateUpdateStatus::set_has_s16Year () {
    _has_bits_[0] |= 1u << 0;
}

inline void UTC_TimeDateUpdateStatus::clear_has_s16Year () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UTC_TimeDateUpdateStatus::set_has_u8Month () {
    _has_bits_[0] |= 1u << 1;
}

inline void UTC_TimeDateUpdateStatus::clear_has_u8Month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void UTC_TimeDateUpdateStatus::set_has_u8Day () {
    _has_bits_[0] |= 1u << 2;
}

inline void UTC_TimeDateUpdateStatus::clear_has_u8Day () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void UTC_TimeDateUpdateStatus::set_has_u8Hours () {
    _has_bits_[0] |= 1u << 3;
}

inline void UTC_TimeDateUpdateStatus::clear_has_u8Hours () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void UTC_TimeDateUpdateStatus::set_has_u8Minutes () {
    _has_bits_[0] |= 1u << 4;
}

inline void UTC_TimeDateUpdateStatus::clear_has_u8Minutes () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void UTC_TimeDateUpdateStatus::set_has_u8Seconds () {
    _has_bits_[0] |= 1u << 5;
}

inline void UTC_TimeDateUpdateStatus::clear_has_u8Seconds () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void UTC_TimeDateUpdateStatus::set_has_u8Weekday () {
    _has_bits_[0] |= 1u << 6;
}

inline void UTC_TimeDateUpdateStatus::clear_has_u8Weekday () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void UTC_TimeDateUpdateStatus::set_has_bTimeValidity () {
    _has_bits_[0] |= 1u << 7;
}

inline void UTC_TimeDateUpdateStatus::clear_has_bTimeValidity () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  HUD_ActivationStatus::HUD_ActivationStatus ()  :
    _bHUD_Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HUD_ActivationStatus::HUD_ActivationStatus (const HUD_ActivationStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _bHUD_Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HUD_ActivationStatus::HUD_ActivationStatus (bool bHUD_Status_)  :
    _bHUD_Status (bHUD_Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HUD_ActivationStatus::~HUD_ActivationStatus() {
}

inline HUD_ActivationStatus& HUD_ActivationStatus::operator = (const HUD_ActivationStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBHUD_Status()) {
            setBHUD_Status(rhs.getBHUD_Status());
        } else {
            clearBHUD_Status();
        }
    }
    return *this;
}

inline bool HUD_ActivationStatus::operator == (const HUD_ActivationStatus& rhs) const {
    return (((!hasBHUD_Status() && !rhs.hasBHUD_Status()) || getBHUD_Status() == rhs.getBHUD_Status()));
}

inline bool HUD_ActivationStatus::operator != (const HUD_ActivationStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool HUD_ActivationStatus::operator < (const HUD_ActivationStatus& rhs) const {
    if (hasBHUD_Status() || rhs.hasBHUD_Status()) {
        if (getBHUD_Status() < rhs.getBHUD_Status()) return true;
        if (getBHUD_Status() > rhs.getBHUD_Status()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HUD_ActivationStatus::clone() {
    return new HUD_ActivationStatus(*this);
}

inline bool HUD_ActivationStatus::operator > (const HUD_ActivationStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HUD_ActivationStatus::clear() {
    clearBHUD_Status();
}

inline void HUD_ActivationStatus::clearBHUD_Status() {
    if (hasBHUD_Status()) {
         clear_has_bHUD_Status();
        _bHUD_Status = false;
     }
}

inline bool HUD_ActivationStatus::hasBHUD_Status () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool HUD_ActivationStatus::getBHUD_Status () const {
    return _bHUD_Status;
}

inline void HUD_ActivationStatus::setBHUD_Status (bool bHUD_Status_) {
    set_has_bHUD_Status();
    this->_bHUD_Status = bHUD_Status_;
}

inline void HUD_ActivationStatus::set_has_bHUD_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void HUD_ActivationStatus::clear_has_bHUD_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  HUD_ActivationSet::HUD_ActivationSet ()  :
    _enHUD_Setting (::clock_main_fi_types::VDCLK_TEN_HUD_ActivationSettings__VDCLK_EN_HUD_OFF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HUD_ActivationSet::HUD_ActivationSet (const HUD_ActivationSet &rhs)  :
    ::asf::core::Payload(rhs),
    _enHUD_Setting (::clock_main_fi_types::VDCLK_TEN_HUD_ActivationSettings__VDCLK_EN_HUD_OFF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HUD_ActivationSet::HUD_ActivationSet (::clock_main_fi_types::VDCLK_TEN_HUD_ActivationSettings enHUD_Setting_)  :
    _enHUD_Setting (enHUD_Setting_)
{
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_HUD_ActivationSettings_IsValid(enHUD_Setting_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enHUD_Setting_, "VDCLK_TEN_HUD_ActivationSettings", "enHUD_Setting", "HUD_ActivationSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HUD_ActivationSet::~HUD_ActivationSet() {
}

inline HUD_ActivationSet& HUD_ActivationSet::operator = (const HUD_ActivationSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnHUD_Setting()) {
            setEnHUD_Setting(rhs.getEnHUD_Setting());
        } else {
            clearEnHUD_Setting();
        }
    }
    return *this;
}

inline bool HUD_ActivationSet::operator == (const HUD_ActivationSet& rhs) const {
    return (((!hasEnHUD_Setting() && !rhs.hasEnHUD_Setting()) || getEnHUD_Setting() == rhs.getEnHUD_Setting()));
}

inline bool HUD_ActivationSet::operator != (const HUD_ActivationSet& rhs) const {
    return ! (*this == rhs);
}

inline bool HUD_ActivationSet::operator < (const HUD_ActivationSet& rhs) const {
    if (hasEnHUD_Setting() || rhs.hasEnHUD_Setting()) {
        if ((uint32)getEnHUD_Setting() < (uint32)rhs.getEnHUD_Setting()) return true;
        if ((uint32)getEnHUD_Setting() > (uint32)rhs.getEnHUD_Setting()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HUD_ActivationSet::clone() {
    return new HUD_ActivationSet(*this);
}

inline bool HUD_ActivationSet::operator > (const HUD_ActivationSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HUD_ActivationSet::clear() {
    clearEnHUD_Setting();
}

inline void HUD_ActivationSet::clearEnHUD_Setting() {
    if (hasEnHUD_Setting()) {
         clear_has_enHUD_Setting();
        _enHUD_Setting = ::clock_main_fi_types::VDCLK_TEN_HUD_ActivationSettings__VDCLK_EN_HUD_OFF;
     }
}

inline bool HUD_ActivationSet::hasEnHUD_Setting () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::clock_main_fi_types::VDCLK_TEN_HUD_ActivationSettings HUD_ActivationSet::getEnHUD_Setting () const {
    return _enHUD_Setting;
}

inline void HUD_ActivationSet::setEnHUD_Setting (::clock_main_fi_types::VDCLK_TEN_HUD_ActivationSettings enHUD_Setting_) {
    #ifndef NDEBUG
    if (!(::clock_main_fi_types::VDCLK_TEN_HUD_ActivationSettings_IsValid(enHUD_Setting_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enHUD_Setting_, "VDCLK_TEN_HUD_ActivationSettings", "enHUD_Setting", "HUD_ActivationSet");
    }
    #endif
    set_has_enHUD_Setting();
    this->_enHUD_Setting = enHUD_Setting_;
}

inline void HUD_ActivationSet::set_has_enHUD_Setting () {
    _has_bits_[0] |= 1u << 0;
}

inline void HUD_ActivationSet::clear_has_enHUD_Setting () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  HUD_PostitionStatus::HUD_PostitionStatus ()  :
    _u8Up_Position (0u),
    _u8Down_Position (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HUD_PostitionStatus::HUD_PostitionStatus (const HUD_PostitionStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u8Up_Position (0u),
    _u8Down_Position (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HUD_PostitionStatus::HUD_PostitionStatus (uint8 u8Up_Position_, uint8 u8Down_Position_)  :
    _u8Up_Position (u8Up_Position_),
    _u8Down_Position (u8Down_Position_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HUD_PostitionStatus::~HUD_PostitionStatus() {
}

inline HUD_PostitionStatus& HUD_PostitionStatus::operator = (const HUD_PostitionStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8Up_Position()) {
            setU8Up_Position(rhs.getU8Up_Position());
        } else {
            clearU8Up_Position();
        }
        if (rhs.hasU8Down_Position()) {
            setU8Down_Position(rhs.getU8Down_Position());
        } else {
            clearU8Down_Position();
        }
    }
    return *this;
}

inline bool HUD_PostitionStatus::operator == (const HUD_PostitionStatus& rhs) const {
    return (((!hasU8Up_Position() && !rhs.hasU8Up_Position()) || getU8Up_Position() == rhs.getU8Up_Position()) &&
        ((!hasU8Down_Position() && !rhs.hasU8Down_Position()) || getU8Down_Position() == rhs.getU8Down_Position()));
}

inline bool HUD_PostitionStatus::operator != (const HUD_PostitionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool HUD_PostitionStatus::operator < (const HUD_PostitionStatus& rhs) const {
    if (hasU8Up_Position() || rhs.hasU8Up_Position()) {
        if (getU8Up_Position() < rhs.getU8Up_Position()) return true;
        if (getU8Up_Position() > rhs.getU8Up_Position()) return false;
    }
    if (hasU8Down_Position() || rhs.hasU8Down_Position()) {
        if (getU8Down_Position() < rhs.getU8Down_Position()) return true;
        if (getU8Down_Position() > rhs.getU8Down_Position()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HUD_PostitionStatus::clone() {
    return new HUD_PostitionStatus(*this);
}

inline bool HUD_PostitionStatus::operator > (const HUD_PostitionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HUD_PostitionStatus::clear() {
    clearU8Up_Position();
    clearU8Down_Position();
}

inline void HUD_PostitionStatus::clearU8Up_Position() {
    if (hasU8Up_Position()) {
         clear_has_u8Up_Position();
        _u8Up_Position = 0u;
     }
}

inline bool HUD_PostitionStatus::hasU8Up_Position () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 HUD_PostitionStatus::getU8Up_Position () const {
    return _u8Up_Position;
}

inline void HUD_PostitionStatus::setU8Up_Position (uint8 u8Up_Position_) {
    set_has_u8Up_Position();
    this->_u8Up_Position = u8Up_Position_;
}

inline void HUD_PostitionStatus::clearU8Down_Position() {
    if (hasU8Down_Position()) {
         clear_has_u8Down_Position();
        _u8Down_Position = 0u;
     }
}

inline bool HUD_PostitionStatus::hasU8Down_Position () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 HUD_PostitionStatus::getU8Down_Position () const {
    return _u8Down_Position;
}

inline void HUD_PostitionStatus::setU8Down_Position (uint8 u8Down_Position_) {
    set_has_u8Down_Position();
    this->_u8Down_Position = u8Down_Position_;
}

inline void HUD_PostitionStatus::set_has_u8Up_Position () {
    _has_bits_[0] |= 1u << 0;
}

inline void HUD_PostitionStatus::clear_has_u8Up_Position () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void HUD_PostitionStatus::set_has_u8Down_Position () {
    _has_bits_[0] |= 1u << 1;
}

inline void HUD_PostitionStatus::clear_has_u8Down_Position () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  HUD_PostitionSet::HUD_PostitionSet ()  :
    _u8Up_Position (0u),
    _u8Down_Position (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HUD_PostitionSet::HUD_PostitionSet (const HUD_PostitionSet &rhs)  :
    ::asf::core::Payload(rhs),
    _u8Up_Position (0u),
    _u8Down_Position (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HUD_PostitionSet::HUD_PostitionSet (uint8 u8Up_Position_, uint8 u8Down_Position_)  :
    _u8Up_Position (u8Up_Position_),
    _u8Down_Position (u8Down_Position_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HUD_PostitionSet::~HUD_PostitionSet() {
}

inline HUD_PostitionSet& HUD_PostitionSet::operator = (const HUD_PostitionSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8Up_Position()) {
            setU8Up_Position(rhs.getU8Up_Position());
        } else {
            clearU8Up_Position();
        }
        if (rhs.hasU8Down_Position()) {
            setU8Down_Position(rhs.getU8Down_Position());
        } else {
            clearU8Down_Position();
        }
    }
    return *this;
}

inline bool HUD_PostitionSet::operator == (const HUD_PostitionSet& rhs) const {
    return (((!hasU8Up_Position() && !rhs.hasU8Up_Position()) || getU8Up_Position() == rhs.getU8Up_Position()) &&
        ((!hasU8Down_Position() && !rhs.hasU8Down_Position()) || getU8Down_Position() == rhs.getU8Down_Position()));
}

inline bool HUD_PostitionSet::operator != (const HUD_PostitionSet& rhs) const {
    return ! (*this == rhs);
}

inline bool HUD_PostitionSet::operator < (const HUD_PostitionSet& rhs) const {
    if (hasU8Up_Position() || rhs.hasU8Up_Position()) {
        if (getU8Up_Position() < rhs.getU8Up_Position()) return true;
        if (getU8Up_Position() > rhs.getU8Up_Position()) return false;
    }
    if (hasU8Down_Position() || rhs.hasU8Down_Position()) {
        if (getU8Down_Position() < rhs.getU8Down_Position()) return true;
        if (getU8Down_Position() > rhs.getU8Down_Position()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HUD_PostitionSet::clone() {
    return new HUD_PostitionSet(*this);
}

inline bool HUD_PostitionSet::operator > (const HUD_PostitionSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HUD_PostitionSet::clear() {
    clearU8Up_Position();
    clearU8Down_Position();
}

inline void HUD_PostitionSet::clearU8Up_Position() {
    if (hasU8Up_Position()) {
         clear_has_u8Up_Position();
        _u8Up_Position = 0u;
     }
}

inline bool HUD_PostitionSet::hasU8Up_Position () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 HUD_PostitionSet::getU8Up_Position () const {
    return _u8Up_Position;
}

inline void HUD_PostitionSet::setU8Up_Position (uint8 u8Up_Position_) {
    set_has_u8Up_Position();
    this->_u8Up_Position = u8Up_Position_;
}

inline void HUD_PostitionSet::clearU8Down_Position() {
    if (hasU8Down_Position()) {
         clear_has_u8Down_Position();
        _u8Down_Position = 0u;
     }
}

inline bool HUD_PostitionSet::hasU8Down_Position () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 HUD_PostitionSet::getU8Down_Position () const {
    return _u8Down_Position;
}

inline void HUD_PostitionSet::setU8Down_Position (uint8 u8Down_Position_) {
    set_has_u8Down_Position();
    this->_u8Down_Position = u8Down_Position_;
}

inline void HUD_PostitionSet::set_has_u8Up_Position () {
    _has_bits_[0] |= 1u << 0;
}

inline void HUD_PostitionSet::clear_has_u8Up_Position () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void HUD_PostitionSet::set_has_u8Down_Position () {
    _has_bits_[0] |= 1u << 1;
}

inline void HUD_PostitionSet::clear_has_u8Down_Position () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetAvailableTimeZonesResult::GetAvailableTimeZonesResult ()  :
    _aszDescriptions (),
    _u16Indexes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAvailableTimeZonesResult::GetAvailableTimeZonesResult (const GetAvailableTimeZonesResult &rhs)  :
    ::asf::core::Payload(rhs),
    _aszDescriptions (),
    _u16Indexes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAvailableTimeZonesResult::GetAvailableTimeZonesResult (const ::std::vector< ::std::string >& aszDescriptions_, const ::std::vector< uint16 >& u16Indexes_)  :
    _aszDescriptions (aszDescriptions_),
    _u16Indexes (u16Indexes_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAvailableTimeZonesResult::~GetAvailableTimeZonesResult() {
}

inline GetAvailableTimeZonesResult& GetAvailableTimeZonesResult::operator = (const GetAvailableTimeZonesResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAszDescriptions()) {
            setAszDescriptions(rhs.getAszDescriptions());
        } else {
            clearAszDescriptions();
        }
        if (rhs.hasU16Indexes()) {
            setU16Indexes(rhs.getU16Indexes());
        } else {
            clearU16Indexes();
        }
    }
    return *this;
}

inline bool GetAvailableTimeZonesResult::operator == (const GetAvailableTimeZonesResult& rhs) const {
    return (((!hasAszDescriptions() && !rhs.hasAszDescriptions()) || getAszDescriptions() == rhs.getAszDescriptions()) &&
        ((!hasU16Indexes() && !rhs.hasU16Indexes()) || getU16Indexes() == rhs.getU16Indexes()));
}

inline bool GetAvailableTimeZonesResult::operator != (const GetAvailableTimeZonesResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAvailableTimeZonesResult::operator < (const GetAvailableTimeZonesResult& rhs) const {
    if (hasAszDescriptions() || rhs.hasAszDescriptions()) {
        if (getAszDescriptions() < rhs.getAszDescriptions()) return true;
        if (getAszDescriptions() > rhs.getAszDescriptions()) return false;
    }
    if (hasU16Indexes() || rhs.hasU16Indexes()) {
        if (getU16Indexes() < rhs.getU16Indexes()) return true;
        if (getU16Indexes() > rhs.getU16Indexes()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetAvailableTimeZonesResult::clone() {
    return new GetAvailableTimeZonesResult(*this);
}

inline bool GetAvailableTimeZonesResult::operator > (const GetAvailableTimeZonesResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAvailableTimeZonesResult::clear() {
    clearAszDescriptions();
    clearU16Indexes();
}

inline void GetAvailableTimeZonesResult::clearAszDescriptions() {
    if (hasAszDescriptions()) {
         clear_has_aszDescriptions();
        _aszDescriptions.clear();
     }
}

inline bool GetAvailableTimeZonesResult::hasAszDescriptions () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& GetAvailableTimeZonesResult::getAszDescriptions () const {
    return _aszDescriptions;
}

inline ::std::vector< ::std::string >& GetAvailableTimeZonesResult::getAszDescriptionsMutable () {
    set_has_aszDescriptions();
    return _aszDescriptions;
}

inline void GetAvailableTimeZonesResult::setAszDescriptions (const ::std::vector< ::std::string >& aszDescriptions_) {
    set_has_aszDescriptions();
    this->_aszDescriptions = aszDescriptions_;
}

inline void GetAvailableTimeZonesResult::clearU16Indexes() {
    if (hasU16Indexes()) {
         clear_has_u16Indexes();
        _u16Indexes.clear();
     }
}

inline bool GetAvailableTimeZonesResult::hasU16Indexes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint16 >& GetAvailableTimeZonesResult::getU16Indexes () const {
    return _u16Indexes;
}

inline ::std::vector< uint16 >& GetAvailableTimeZonesResult::getU16IndexesMutable () {
    set_has_u16Indexes();
    return _u16Indexes;
}

inline void GetAvailableTimeZonesResult::setU16Indexes (const ::std::vector< uint16 >& u16Indexes_) {
    set_has_u16Indexes();
    this->_u16Indexes = u16Indexes_;
}

inline void GetAvailableTimeZonesResult::set_has_aszDescriptions () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAvailableTimeZonesResult::clear_has_aszDescriptions () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetAvailableTimeZonesResult::set_has_u16Indexes () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetAvailableTimeZonesResult::clear_has_u16Indexes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetTimeDateFromValueStart::GetTimeDateFromValueStart ()  :
    _u32TimeDateValue (0u),
    _u8SourceDomain (1u),
    _u8TargetDomain (1u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTimeDateFromValueStart::GetTimeDateFromValueStart (const GetTimeDateFromValueStart &rhs)  :
    ::asf::core::Payload(rhs),
    _u32TimeDateValue (0u),
    _u8SourceDomain (1u),
    _u8TargetDomain (1u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTimeDateFromValueStart::GetTimeDateFromValueStart (uint32 u32TimeDateValue_, uint8 u8SourceDomain_, uint8 u8TargetDomain_)  :
    _u32TimeDateValue (u32TimeDateValue_),
    _u8SourceDomain (u8SourceDomain_),
    _u8TargetDomain (u8TargetDomain_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTimeDateFromValueStart::~GetTimeDateFromValueStart() {
}

inline GetTimeDateFromValueStart& GetTimeDateFromValueStart::operator = (const GetTimeDateFromValueStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU32TimeDateValue()) {
            setU32TimeDateValue(rhs.getU32TimeDateValue());
        } else {
            clearU32TimeDateValue();
        }
        if (rhs.hasU8SourceDomain()) {
            setU8SourceDomain(rhs.getU8SourceDomain());
        } else {
            clearU8SourceDomain();
        }
        if (rhs.hasU8TargetDomain()) {
            setU8TargetDomain(rhs.getU8TargetDomain());
        } else {
            clearU8TargetDomain();
        }
    }
    return *this;
}

inline bool GetTimeDateFromValueStart::operator == (const GetTimeDateFromValueStart& rhs) const {
    return (((!hasU32TimeDateValue() && !rhs.hasU32TimeDateValue()) || getU32TimeDateValue() == rhs.getU32TimeDateValue()) &&
        ((!hasU8SourceDomain() && !rhs.hasU8SourceDomain()) || getU8SourceDomain() == rhs.getU8SourceDomain()) &&
        ((!hasU8TargetDomain() && !rhs.hasU8TargetDomain()) || getU8TargetDomain() == rhs.getU8TargetDomain()));
}

inline bool GetTimeDateFromValueStart::operator != (const GetTimeDateFromValueStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTimeDateFromValueStart::operator < (const GetTimeDateFromValueStart& rhs) const {
    if (hasU32TimeDateValue() || rhs.hasU32TimeDateValue()) {
        if (getU32TimeDateValue() < rhs.getU32TimeDateValue()) return true;
        if (getU32TimeDateValue() > rhs.getU32TimeDateValue()) return false;
    }
    if (hasU8SourceDomain() || rhs.hasU8SourceDomain()) {
        if (getU8SourceDomain() < rhs.getU8SourceDomain()) return true;
        if (getU8SourceDomain() > rhs.getU8SourceDomain()) return false;
    }
    if (hasU8TargetDomain() || rhs.hasU8TargetDomain()) {
        if (getU8TargetDomain() < rhs.getU8TargetDomain()) return true;
        if (getU8TargetDomain() > rhs.getU8TargetDomain()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetTimeDateFromValueStart::clone() {
    return new GetTimeDateFromValueStart(*this);
}

inline bool GetTimeDateFromValueStart::operator > (const GetTimeDateFromValueStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTimeDateFromValueStart::clear() {
    clearU32TimeDateValue();
    clearU8SourceDomain();
    clearU8TargetDomain();
}

inline void GetTimeDateFromValueStart::clearU32TimeDateValue() {
    if (hasU32TimeDateValue()) {
         clear_has_u32TimeDateValue();
        _u32TimeDateValue = 0u;
     }
}

inline bool GetTimeDateFromValueStart::hasU32TimeDateValue () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetTimeDateFromValueStart::getU32TimeDateValue () const {
    return _u32TimeDateValue;
}

inline void GetTimeDateFromValueStart::setU32TimeDateValue (uint32 u32TimeDateValue_) {
    set_has_u32TimeDateValue();
    this->_u32TimeDateValue = u32TimeDateValue_;
}

inline void GetTimeDateFromValueStart::clearU8SourceDomain() {
    if (hasU8SourceDomain()) {
         clear_has_u8SourceDomain();
        _u8SourceDomain = 1u;
     }
}

inline bool GetTimeDateFromValueStart::hasU8SourceDomain () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 GetTimeDateFromValueStart::getU8SourceDomain () const {
    return _u8SourceDomain;
}

inline void GetTimeDateFromValueStart::setU8SourceDomain (uint8 u8SourceDomain_) {
    set_has_u8SourceDomain();
    this->_u8SourceDomain = u8SourceDomain_;
}

inline void GetTimeDateFromValueStart::clearU8TargetDomain() {
    if (hasU8TargetDomain()) {
         clear_has_u8TargetDomain();
        _u8TargetDomain = 1u;
     }
}

inline bool GetTimeDateFromValueStart::hasU8TargetDomain () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 GetTimeDateFromValueStart::getU8TargetDomain () const {
    return _u8TargetDomain;
}

inline void GetTimeDateFromValueStart::setU8TargetDomain (uint8 u8TargetDomain_) {
    set_has_u8TargetDomain();
    this->_u8TargetDomain = u8TargetDomain_;
}

inline void GetTimeDateFromValueStart::set_has_u32TimeDateValue () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTimeDateFromValueStart::clear_has_u32TimeDateValue () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetTimeDateFromValueStart::set_has_u8SourceDomain () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetTimeDateFromValueStart::clear_has_u8SourceDomain () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetTimeDateFromValueStart::set_has_u8TargetDomain () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetTimeDateFromValueStart::clear_has_u8TargetDomain () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetTimeDateFromValueResult::GetTimeDateFromValueResult ()  :
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTimeDateFromValueResult::GetTimeDateFromValueResult (const GetTimeDateFromValueResult &rhs)  :
    ::asf::core::Payload(rhs),
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hours (0u),
    _u8Minutes (0u),
    _u8Seconds (0u),
    _u8Weekday (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTimeDateFromValueResult::GetTimeDateFromValueResult (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hours_, uint8 u8Minutes_, uint8 u8Seconds_, uint8 u8Weekday_)  :
    _s16Year (s16Year_),
    _u8Month (u8Month_),
    _u8Day (u8Day_),
    _u8Hours (u8Hours_),
    _u8Minutes (u8Minutes_),
    _u8Seconds (u8Seconds_),
    _u8Weekday (u8Weekday_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTimeDateFromValueResult::~GetTimeDateFromValueResult() {
}

inline GetTimeDateFromValueResult& GetTimeDateFromValueResult::operator = (const GetTimeDateFromValueResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS16Year()) {
            setS16Year(rhs.getS16Year());
        } else {
            clearS16Year();
        }
        if (rhs.hasU8Month()) {
            setU8Month(rhs.getU8Month());
        } else {
            clearU8Month();
        }
        if (rhs.hasU8Day()) {
            setU8Day(rhs.getU8Day());
        } else {
            clearU8Day();
        }
        if (rhs.hasU8Hours()) {
            setU8Hours(rhs.getU8Hours());
        } else {
            clearU8Hours();
        }
        if (rhs.hasU8Minutes()) {
            setU8Minutes(rhs.getU8Minutes());
        } else {
            clearU8Minutes();
        }
        if (rhs.hasU8Seconds()) {
            setU8Seconds(rhs.getU8Seconds());
        } else {
            clearU8Seconds();
        }
        if (rhs.hasU8Weekday()) {
            setU8Weekday(rhs.getU8Weekday());
        } else {
            clearU8Weekday();
        }
    }
    return *this;
}

inline bool GetTimeDateFromValueResult::operator == (const GetTimeDateFromValueResult& rhs) const {
    return (((!hasS16Year() && !rhs.hasS16Year()) || getS16Year() == rhs.getS16Year()) &&
        ((!hasU8Month() && !rhs.hasU8Month()) || getU8Month() == rhs.getU8Month()) &&
        ((!hasU8Day() && !rhs.hasU8Day()) || getU8Day() == rhs.getU8Day()) &&
        ((!hasU8Hours() && !rhs.hasU8Hours()) || getU8Hours() == rhs.getU8Hours()) &&
        ((!hasU8Minutes() && !rhs.hasU8Minutes()) || getU8Minutes() == rhs.getU8Minutes()) &&
        ((!hasU8Seconds() && !rhs.hasU8Seconds()) || getU8Seconds() == rhs.getU8Seconds()) &&
        ((!hasU8Weekday() && !rhs.hasU8Weekday()) || getU8Weekday() == rhs.getU8Weekday()));
}

inline bool GetTimeDateFromValueResult::operator != (const GetTimeDateFromValueResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTimeDateFromValueResult::operator < (const GetTimeDateFromValueResult& rhs) const {
    if (hasS16Year() || rhs.hasS16Year()) {
        if (getS16Year() < rhs.getS16Year()) return true;
        if (getS16Year() > rhs.getS16Year()) return false;
    }
    if (hasU8Month() || rhs.hasU8Month()) {
        if (getU8Month() < rhs.getU8Month()) return true;
        if (getU8Month() > rhs.getU8Month()) return false;
    }
    if (hasU8Day() || rhs.hasU8Day()) {
        if (getU8Day() < rhs.getU8Day()) return true;
        if (getU8Day() > rhs.getU8Day()) return false;
    }
    if (hasU8Hours() || rhs.hasU8Hours()) {
        if (getU8Hours() < rhs.getU8Hours()) return true;
        if (getU8Hours() > rhs.getU8Hours()) return false;
    }
    if (hasU8Minutes() || rhs.hasU8Minutes()) {
        if (getU8Minutes() < rhs.getU8Minutes()) return true;
        if (getU8Minutes() > rhs.getU8Minutes()) return false;
    }
    if (hasU8Seconds() || rhs.hasU8Seconds()) {
        if (getU8Seconds() < rhs.getU8Seconds()) return true;
        if (getU8Seconds() > rhs.getU8Seconds()) return false;
    }
    if (hasU8Weekday() || rhs.hasU8Weekday()) {
        if (getU8Weekday() < rhs.getU8Weekday()) return true;
        if (getU8Weekday() > rhs.getU8Weekday()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetTimeDateFromValueResult::clone() {
    return new GetTimeDateFromValueResult(*this);
}

inline bool GetTimeDateFromValueResult::operator > (const GetTimeDateFromValueResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTimeDateFromValueResult::clear() {
    clearS16Year();
    clearU8Month();
    clearU8Day();
    clearU8Hours();
    clearU8Minutes();
    clearU8Seconds();
    clearU8Weekday();
}

inline void GetTimeDateFromValueResult::clearS16Year() {
    if (hasS16Year()) {
         clear_has_s16Year();
        _s16Year = 0;
     }
}

inline bool GetTimeDateFromValueResult::hasS16Year () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetTimeDateFromValueResult::getS16Year () const {
    return _s16Year;
}

inline void GetTimeDateFromValueResult::setS16Year (int16 s16Year_) {
    set_has_s16Year();
    this->_s16Year = s16Year_;
}

inline void GetTimeDateFromValueResult::clearU8Month() {
    if (hasU8Month()) {
         clear_has_u8Month();
        _u8Month = 0u;
     }
}

inline bool GetTimeDateFromValueResult::hasU8Month () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 GetTimeDateFromValueResult::getU8Month () const {
    return _u8Month;
}

inline void GetTimeDateFromValueResult::setU8Month (uint8 u8Month_) {
    set_has_u8Month();
    this->_u8Month = u8Month_;
}

inline void GetTimeDateFromValueResult::clearU8Day() {
    if (hasU8Day()) {
         clear_has_u8Day();
        _u8Day = 0u;
     }
}

inline bool GetTimeDateFromValueResult::hasU8Day () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 GetTimeDateFromValueResult::getU8Day () const {
    return _u8Day;
}

inline void GetTimeDateFromValueResult::setU8Day (uint8 u8Day_) {
    set_has_u8Day();
    this->_u8Day = u8Day_;
}

inline void GetTimeDateFromValueResult::clearU8Hours() {
    if (hasU8Hours()) {
         clear_has_u8Hours();
        _u8Hours = 0u;
     }
}

inline bool GetTimeDateFromValueResult::hasU8Hours () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 GetTimeDateFromValueResult::getU8Hours () const {
    return _u8Hours;
}

inline void GetTimeDateFromValueResult::setU8Hours (uint8 u8Hours_) {
    set_has_u8Hours();
    this->_u8Hours = u8Hours_;
}

inline void GetTimeDateFromValueResult::clearU8Minutes() {
    if (hasU8Minutes()) {
         clear_has_u8Minutes();
        _u8Minutes = 0u;
     }
}

inline bool GetTimeDateFromValueResult::hasU8Minutes () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 GetTimeDateFromValueResult::getU8Minutes () const {
    return _u8Minutes;
}

inline void GetTimeDateFromValueResult::setU8Minutes (uint8 u8Minutes_) {
    set_has_u8Minutes();
    this->_u8Minutes = u8Minutes_;
}

inline void GetTimeDateFromValueResult::clearU8Seconds() {
    if (hasU8Seconds()) {
         clear_has_u8Seconds();
        _u8Seconds = 0u;
     }
}

inline bool GetTimeDateFromValueResult::hasU8Seconds () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 GetTimeDateFromValueResult::getU8Seconds () const {
    return _u8Seconds;
}

inline void GetTimeDateFromValueResult::setU8Seconds (uint8 u8Seconds_) {
    set_has_u8Seconds();
    this->_u8Seconds = u8Seconds_;
}

inline void GetTimeDateFromValueResult::clearU8Weekday() {
    if (hasU8Weekday()) {
         clear_has_u8Weekday();
        _u8Weekday = 0u;
     }
}

inline bool GetTimeDateFromValueResult::hasU8Weekday () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 GetTimeDateFromValueResult::getU8Weekday () const {
    return _u8Weekday;
}

inline void GetTimeDateFromValueResult::setU8Weekday (uint8 u8Weekday_) {
    set_has_u8Weekday();
    this->_u8Weekday = u8Weekday_;
}

inline void GetTimeDateFromValueResult::set_has_s16Year () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTimeDateFromValueResult::clear_has_s16Year () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetTimeDateFromValueResult::set_has_u8Month () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetTimeDateFromValueResult::clear_has_u8Month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetTimeDateFromValueResult::set_has_u8Day () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetTimeDateFromValueResult::clear_has_u8Day () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetTimeDateFromValueResult::set_has_u8Hours () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetTimeDateFromValueResult::clear_has_u8Hours () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void GetTimeDateFromValueResult::set_has_u8Minutes () {
    _has_bits_[0] |= 1u << 4;
}

inline void GetTimeDateFromValueResult::clear_has_u8Minutes () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void GetTimeDateFromValueResult::set_has_u8Seconds () {
    _has_bits_[0] |= 1u << 5;
}

inline void GetTimeDateFromValueResult::clear_has_u8Seconds () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void GetTimeDateFromValueResult::set_has_u8Weekday () {
    _has_bits_[0] |= 1u << 6;
}

inline void GetTimeDateFromValueResult::clear_has_u8Weekday () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  GetDaysPerMonthStart::GetDaysPerMonthStart ()  :
    _s16Year (0),
    _u8Month (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetDaysPerMonthStart::GetDaysPerMonthStart (const GetDaysPerMonthStart &rhs)  :
    ::asf::core::Payload(rhs),
    _s16Year (0),
    _u8Month (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetDaysPerMonthStart::GetDaysPerMonthStart (int16 s16Year_, uint8 u8Month_)  :
    _s16Year (s16Year_),
    _u8Month (u8Month_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetDaysPerMonthStart::~GetDaysPerMonthStart() {
}

inline GetDaysPerMonthStart& GetDaysPerMonthStart::operator = (const GetDaysPerMonthStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS16Year()) {
            setS16Year(rhs.getS16Year());
        } else {
            clearS16Year();
        }
        if (rhs.hasU8Month()) {
            setU8Month(rhs.getU8Month());
        } else {
            clearU8Month();
        }
    }
    return *this;
}

inline bool GetDaysPerMonthStart::operator == (const GetDaysPerMonthStart& rhs) const {
    return (((!hasS16Year() && !rhs.hasS16Year()) || getS16Year() == rhs.getS16Year()) &&
        ((!hasU8Month() && !rhs.hasU8Month()) || getU8Month() == rhs.getU8Month()));
}

inline bool GetDaysPerMonthStart::operator != (const GetDaysPerMonthStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetDaysPerMonthStart::operator < (const GetDaysPerMonthStart& rhs) const {
    if (hasS16Year() || rhs.hasS16Year()) {
        if (getS16Year() < rhs.getS16Year()) return true;
        if (getS16Year() > rhs.getS16Year()) return false;
    }
    if (hasU8Month() || rhs.hasU8Month()) {
        if (getU8Month() < rhs.getU8Month()) return true;
        if (getU8Month() > rhs.getU8Month()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetDaysPerMonthStart::clone() {
    return new GetDaysPerMonthStart(*this);
}

inline bool GetDaysPerMonthStart::operator > (const GetDaysPerMonthStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetDaysPerMonthStart::clear() {
    clearS16Year();
    clearU8Month();
}

inline void GetDaysPerMonthStart::clearS16Year() {
    if (hasS16Year()) {
         clear_has_s16Year();
        _s16Year = 0;
     }
}

inline bool GetDaysPerMonthStart::hasS16Year () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetDaysPerMonthStart::getS16Year () const {
    return _s16Year;
}

inline void GetDaysPerMonthStart::setS16Year (int16 s16Year_) {
    set_has_s16Year();
    this->_s16Year = s16Year_;
}

inline void GetDaysPerMonthStart::clearU8Month() {
    if (hasU8Month()) {
         clear_has_u8Month();
        _u8Month = 0u;
     }
}

inline bool GetDaysPerMonthStart::hasU8Month () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 GetDaysPerMonthStart::getU8Month () const {
    return _u8Month;
}

inline void GetDaysPerMonthStart::setU8Month (uint8 u8Month_) {
    set_has_u8Month();
    this->_u8Month = u8Month_;
}

inline void GetDaysPerMonthStart::set_has_s16Year () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetDaysPerMonthStart::clear_has_s16Year () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetDaysPerMonthStart::set_has_u8Month () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetDaysPerMonthStart::clear_has_u8Month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetDaysPerMonthResult::GetDaysPerMonthResult ()  :
    _u8NumberOfDays (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetDaysPerMonthResult::GetDaysPerMonthResult (const GetDaysPerMonthResult &rhs)  :
    ::asf::core::Payload(rhs),
    _u8NumberOfDays (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetDaysPerMonthResult::GetDaysPerMonthResult (uint8 u8NumberOfDays_)  :
    _u8NumberOfDays (u8NumberOfDays_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetDaysPerMonthResult::~GetDaysPerMonthResult() {
}

inline GetDaysPerMonthResult& GetDaysPerMonthResult::operator = (const GetDaysPerMonthResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8NumberOfDays()) {
            setU8NumberOfDays(rhs.getU8NumberOfDays());
        } else {
            clearU8NumberOfDays();
        }
    }
    return *this;
}

inline bool GetDaysPerMonthResult::operator == (const GetDaysPerMonthResult& rhs) const {
    return (((!hasU8NumberOfDays() && !rhs.hasU8NumberOfDays()) || getU8NumberOfDays() == rhs.getU8NumberOfDays()));
}

inline bool GetDaysPerMonthResult::operator != (const GetDaysPerMonthResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetDaysPerMonthResult::operator < (const GetDaysPerMonthResult& rhs) const {
    if (hasU8NumberOfDays() || rhs.hasU8NumberOfDays()) {
        if (getU8NumberOfDays() < rhs.getU8NumberOfDays()) return true;
        if (getU8NumberOfDays() > rhs.getU8NumberOfDays()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetDaysPerMonthResult::clone() {
    return new GetDaysPerMonthResult(*this);
}

inline bool GetDaysPerMonthResult::operator > (const GetDaysPerMonthResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetDaysPerMonthResult::clear() {
    clearU8NumberOfDays();
}

inline void GetDaysPerMonthResult::clearU8NumberOfDays() {
    if (hasU8NumberOfDays()) {
         clear_has_u8NumberOfDays();
        _u8NumberOfDays = 0u;
     }
}

inline bool GetDaysPerMonthResult::hasU8NumberOfDays () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetDaysPerMonthResult::getU8NumberOfDays () const {
    return _u8NumberOfDays;
}

inline void GetDaysPerMonthResult::setU8NumberOfDays (uint8 u8NumberOfDays_) {
    set_has_u8NumberOfDays();
    this->_u8NumberOfDays = u8NumberOfDays_;
}

inline void GetDaysPerMonthResult::set_has_u8NumberOfDays () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetDaysPerMonthResult::clear_has_u8NumberOfDays () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_S_DIAG_CONFIGURATIONStart::FID_S_DIAG_CONFIGURATIONStart ()  :
    _DefSetStateGroup (::diagnostics_main_fi_types::T_e8_DefSetGroups__DEFSET_GROUP_UNDEFIEND),
    _DefSetStateMode (::diagnostics_main_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_S_DIAG_CONFIGURATIONStart::FID_S_DIAG_CONFIGURATIONStart (const FID_S_DIAG_CONFIGURATIONStart &rhs)  :
    ::asf::core::Payload(rhs),
    _DefSetStateGroup (::diagnostics_main_fi_types::T_e8_DefSetGroups__DEFSET_GROUP_UNDEFIEND),
    _DefSetStateMode (::diagnostics_main_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_S_DIAG_CONFIGURATIONStart::FID_S_DIAG_CONFIGURATIONStart (::diagnostics_main_fi_types::T_e8_DefSetGroups DefSetStateGroup_, ::diagnostics_main_fi_types::T_e8_DefSetMode DefSetStateMode_)  :
    _DefSetStateGroup (DefSetStateGroup_),
    _DefSetStateMode (DefSetStateMode_)
{
    #ifndef NDEBUG
    if (!(::diagnostics_main_fi_types::T_e8_DefSetGroups_IsValid(DefSetStateGroup_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateGroup_, "T_e8_DefSetGroups", "DefSetStateGroup", "FID_S_DIAG_CONFIGURATIONStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::diagnostics_main_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "FID_S_DIAG_CONFIGURATIONStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_S_DIAG_CONFIGURATIONStart::~FID_S_DIAG_CONFIGURATIONStart() {
}

inline FID_S_DIAG_CONFIGURATIONStart& FID_S_DIAG_CONFIGURATIONStart::operator = (const FID_S_DIAG_CONFIGURATIONStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefSetStateGroup()) {
            setDefSetStateGroup(rhs.getDefSetStateGroup());
        } else {
            clearDefSetStateGroup();
        }
        if (rhs.hasDefSetStateMode()) {
            setDefSetStateMode(rhs.getDefSetStateMode());
        } else {
            clearDefSetStateMode();
        }
    }
    return *this;
}

inline bool FID_S_DIAG_CONFIGURATIONStart::operator == (const FID_S_DIAG_CONFIGURATIONStart& rhs) const {
    return (((!hasDefSetStateGroup() && !rhs.hasDefSetStateGroup()) || getDefSetStateGroup() == rhs.getDefSetStateGroup()) &&
        ((!hasDefSetStateMode() && !rhs.hasDefSetStateMode()) || getDefSetStateMode() == rhs.getDefSetStateMode()));
}

inline bool FID_S_DIAG_CONFIGURATIONStart::operator != (const FID_S_DIAG_CONFIGURATIONStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_S_DIAG_CONFIGURATIONStart::operator < (const FID_S_DIAG_CONFIGURATIONStart& rhs) const {
    if (hasDefSetStateGroup() || rhs.hasDefSetStateGroup()) {
        if ((uint32)getDefSetStateGroup() < (uint32)rhs.getDefSetStateGroup()) return true;
        if ((uint32)getDefSetStateGroup() > (uint32)rhs.getDefSetStateGroup()) return false;
    }
    if (hasDefSetStateMode() || rhs.hasDefSetStateMode()) {
        if ((uint32)getDefSetStateMode() < (uint32)rhs.getDefSetStateMode()) return true;
        if ((uint32)getDefSetStateMode() > (uint32)rhs.getDefSetStateMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_S_DIAG_CONFIGURATIONStart::clone() {
    return new FID_S_DIAG_CONFIGURATIONStart(*this);
}

inline bool FID_S_DIAG_CONFIGURATIONStart::operator > (const FID_S_DIAG_CONFIGURATIONStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_S_DIAG_CONFIGURATIONStart::clear() {
    clearDefSetStateGroup();
    clearDefSetStateMode();
}

inline void FID_S_DIAG_CONFIGURATIONStart::clearDefSetStateGroup() {
    if (hasDefSetStateGroup()) {
         clear_has_DefSetStateGroup();
        _DefSetStateGroup = ::diagnostics_main_fi_types::T_e8_DefSetGroups__DEFSET_GROUP_UNDEFIEND;
     }
}

inline bool FID_S_DIAG_CONFIGURATIONStart::hasDefSetStateGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::diagnostics_main_fi_types::T_e8_DefSetGroups FID_S_DIAG_CONFIGURATIONStart::getDefSetStateGroup () const {
    return _DefSetStateGroup;
}

inline void FID_S_DIAG_CONFIGURATIONStart::setDefSetStateGroup (::diagnostics_main_fi_types::T_e8_DefSetGroups DefSetStateGroup_) {
    #ifndef NDEBUG
    if (!(::diagnostics_main_fi_types::T_e8_DefSetGroups_IsValid(DefSetStateGroup_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateGroup_, "T_e8_DefSetGroups", "DefSetStateGroup", "FID_S_DIAG_CONFIGURATIONStart");
    }
    #endif
    set_has_DefSetStateGroup();
    this->_DefSetStateGroup = DefSetStateGroup_;
}

inline void FID_S_DIAG_CONFIGURATIONStart::clearDefSetStateMode() {
    if (hasDefSetStateMode()) {
         clear_has_DefSetStateMode();
        _DefSetStateMode = ::diagnostics_main_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF;
     }
}

inline bool FID_S_DIAG_CONFIGURATIONStart::hasDefSetStateMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::diagnostics_main_fi_types::T_e8_DefSetMode FID_S_DIAG_CONFIGURATIONStart::getDefSetStateMode () const {
    return _DefSetStateMode;
}

inline void FID_S_DIAG_CONFIGURATIONStart::setDefSetStateMode (::diagnostics_main_fi_types::T_e8_DefSetMode DefSetStateMode_) {
    #ifndef NDEBUG
    if (!(::diagnostics_main_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "FID_S_DIAG_CONFIGURATIONStart");
    }
    #endif
    set_has_DefSetStateMode();
    this->_DefSetStateMode = DefSetStateMode_;
}

inline void FID_S_DIAG_CONFIGURATIONStart::set_has_DefSetStateGroup () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_S_DIAG_CONFIGURATIONStart::clear_has_DefSetStateGroup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_S_DIAG_CONFIGURATIONStart::set_has_DefSetStateMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_S_DIAG_CONFIGURATIONStart::clear_has_DefSetStateMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_S_DIAG_CONFIGURATIONResult::FID_S_DIAG_CONFIGURATIONResult ()  :
    _DefSetStateGroup (::diagnostics_main_fi_types::T_e8_DefSetGroups__DEFSET_GROUP_UNDEFIEND),
    _DefSetStateMode (::diagnostics_main_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_S_DIAG_CONFIGURATIONResult::FID_S_DIAG_CONFIGURATIONResult (const FID_S_DIAG_CONFIGURATIONResult &rhs)  :
    ::asf::core::Payload(rhs),
    _DefSetStateGroup (::diagnostics_main_fi_types::T_e8_DefSetGroups__DEFSET_GROUP_UNDEFIEND),
    _DefSetStateMode (::diagnostics_main_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_S_DIAG_CONFIGURATIONResult::FID_S_DIAG_CONFIGURATIONResult (::diagnostics_main_fi_types::T_e8_DefSetGroups DefSetStateGroup_, ::diagnostics_main_fi_types::T_e8_DefSetMode DefSetStateMode_, bool Status_)  :
    _DefSetStateGroup (DefSetStateGroup_),
    _DefSetStateMode (DefSetStateMode_),
    _Status (Status_)
{
    #ifndef NDEBUG
    if (!(::diagnostics_main_fi_types::T_e8_DefSetGroups_IsValid(DefSetStateGroup_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateGroup_, "T_e8_DefSetGroups", "DefSetStateGroup", "FID_S_DIAG_CONFIGURATIONResult");
    }
    #endif
    #ifndef NDEBUG
    if (!(::diagnostics_main_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "FID_S_DIAG_CONFIGURATIONResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_S_DIAG_CONFIGURATIONResult::~FID_S_DIAG_CONFIGURATIONResult() {
}

inline FID_S_DIAG_CONFIGURATIONResult& FID_S_DIAG_CONFIGURATIONResult::operator = (const FID_S_DIAG_CONFIGURATIONResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefSetStateGroup()) {
            setDefSetStateGroup(rhs.getDefSetStateGroup());
        } else {
            clearDefSetStateGroup();
        }
        if (rhs.hasDefSetStateMode()) {
            setDefSetStateMode(rhs.getDefSetStateMode());
        } else {
            clearDefSetStateMode();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool FID_S_DIAG_CONFIGURATIONResult::operator == (const FID_S_DIAG_CONFIGURATIONResult& rhs) const {
    return (((!hasDefSetStateGroup() && !rhs.hasDefSetStateGroup()) || getDefSetStateGroup() == rhs.getDefSetStateGroup()) &&
        ((!hasDefSetStateMode() && !rhs.hasDefSetStateMode()) || getDefSetStateMode() == rhs.getDefSetStateMode()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool FID_S_DIAG_CONFIGURATIONResult::operator != (const FID_S_DIAG_CONFIGURATIONResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_S_DIAG_CONFIGURATIONResult::operator < (const FID_S_DIAG_CONFIGURATIONResult& rhs) const {
    if (hasDefSetStateGroup() || rhs.hasDefSetStateGroup()) {
        if ((uint32)getDefSetStateGroup() < (uint32)rhs.getDefSetStateGroup()) return true;
        if ((uint32)getDefSetStateGroup() > (uint32)rhs.getDefSetStateGroup()) return false;
    }
    if (hasDefSetStateMode() || rhs.hasDefSetStateMode()) {
        if ((uint32)getDefSetStateMode() < (uint32)rhs.getDefSetStateMode()) return true;
        if ((uint32)getDefSetStateMode() > (uint32)rhs.getDefSetStateMode()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_S_DIAG_CONFIGURATIONResult::clone() {
    return new FID_S_DIAG_CONFIGURATIONResult(*this);
}

inline bool FID_S_DIAG_CONFIGURATIONResult::operator > (const FID_S_DIAG_CONFIGURATIONResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_S_DIAG_CONFIGURATIONResult::clear() {
    clearDefSetStateGroup();
    clearDefSetStateMode();
    clearStatus();
}

inline void FID_S_DIAG_CONFIGURATIONResult::clearDefSetStateGroup() {
    if (hasDefSetStateGroup()) {
         clear_has_DefSetStateGroup();
        _DefSetStateGroup = ::diagnostics_main_fi_types::T_e8_DefSetGroups__DEFSET_GROUP_UNDEFIEND;
     }
}

inline bool FID_S_DIAG_CONFIGURATIONResult::hasDefSetStateGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::diagnostics_main_fi_types::T_e8_DefSetGroups FID_S_DIAG_CONFIGURATIONResult::getDefSetStateGroup () const {
    return _DefSetStateGroup;
}

inline void FID_S_DIAG_CONFIGURATIONResult::setDefSetStateGroup (::diagnostics_main_fi_types::T_e8_DefSetGroups DefSetStateGroup_) {
    #ifndef NDEBUG
    if (!(::diagnostics_main_fi_types::T_e8_DefSetGroups_IsValid(DefSetStateGroup_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateGroup_, "T_e8_DefSetGroups", "DefSetStateGroup", "FID_S_DIAG_CONFIGURATIONResult");
    }
    #endif
    set_has_DefSetStateGroup();
    this->_DefSetStateGroup = DefSetStateGroup_;
}

inline void FID_S_DIAG_CONFIGURATIONResult::clearDefSetStateMode() {
    if (hasDefSetStateMode()) {
         clear_has_DefSetStateMode();
        _DefSetStateMode = ::diagnostics_main_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF;
     }
}

inline bool FID_S_DIAG_CONFIGURATIONResult::hasDefSetStateMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::diagnostics_main_fi_types::T_e8_DefSetMode FID_S_DIAG_CONFIGURATIONResult::getDefSetStateMode () const {
    return _DefSetStateMode;
}

inline void FID_S_DIAG_CONFIGURATIONResult::setDefSetStateMode (::diagnostics_main_fi_types::T_e8_DefSetMode DefSetStateMode_) {
    #ifndef NDEBUG
    if (!(::diagnostics_main_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "FID_S_DIAG_CONFIGURATIONResult");
    }
    #endif
    set_has_DefSetStateMode();
    this->_DefSetStateMode = DefSetStateMode_;
}

inline void FID_S_DIAG_CONFIGURATIONResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool FID_S_DIAG_CONFIGURATIONResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool FID_S_DIAG_CONFIGURATIONResult::getStatus () const {
    return _Status;
}

inline void FID_S_DIAG_CONFIGURATIONResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void FID_S_DIAG_CONFIGURATIONResult::set_has_DefSetStateGroup () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_S_DIAG_CONFIGURATIONResult::clear_has_DefSetStateGroup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_S_DIAG_CONFIGURATIONResult::set_has_DefSetStateMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_S_DIAG_CONFIGURATIONResult::clear_has_DefSetStateMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FID_S_DIAG_CONFIGURATIONResult::set_has_Status () {
    _has_bits_[0] |= 1u << 2;
}

inline void FID_S_DIAG_CONFIGURATIONResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace clock_main_fi

#endif // CLOCK_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
