/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "fi_typesConst.h"
#include "sds_sds2hmi_common_typesConst.h"
#include "sds_sds2hmi_common_typesJsonPrivate.h"
#include "sds_speechdp_fi_types.h"
#include "sds_speechdp_fi_typesConst.h"
#include "sds_speechdp_fi_typesJson.h"
#include "sds_speechdp_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "T_AvailableLanguage"

void serializeJson (const ::sds_speechdp_fi_types::T_AvailableLanguage& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLanguageID()) {
        yajl_gen_string(g, (const unsigned char*)  "LanguageID" , 10);
        serializeJson(value.getLanguageID(), g, options);
    }
    if (!isSparse || value.hasStorageDevice()) {
        yajl_gen_string(g, (const unsigned char*)  "StorageDevice" , 13);
        const char* s = ::sds_speechdp_fi_types::T_e8_StorageDevice_Name(value.getStorageDevice());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStorageDevice());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_AvailableLanguage& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_VoiceType"

void serializeJson (const ::sds_speechdp_fi_types::T_VoiceType& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLanguageID()) {
        yajl_gen_string(g, (const unsigned char*)  "LanguageID" , 10);
        serializeJson(value.getLanguageID(), g, options);
    }
    if (!isSparse || value.hasVoiceName()) {
        yajl_gen_string(g, (const unsigned char*)  "VoiceName" , 9);
        const char *s = value.getVoiceName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasVoiceGender()) {
        yajl_gen_string(g, (const unsigned char*)  "VoiceGender" , 11);
        const char* s = ::sds_speechdp_fi_types::T_e8_VoiceGender_Name(value.getVoiceGender());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getVoiceGender());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_VoiceType& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_VoiceDescription"

void serializeJson (const ::sds_speechdp_fi_types::T_VoiceDescription& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVoiceType()) {
        yajl_gen_string(g, (const unsigned char*)  "VoiceType" , 9);
        serializeJson(value.getVoiceType(), g, options);
    }
    if (!isSparse || value.hasStorageDevice()) {
        yajl_gen_string(g, (const unsigned char*)  "StorageDevice" , 13);
        const char* s = ::sds_speechdp_fi_types::T_e8_StorageDevice_Name(value.getStorageDevice());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStorageDevice());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_VoiceDescription& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DictionaryGroup"

void serializeJson (const ::sds_speechdp_fi_types::T_DictionaryGroup& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDictFileName()) {
        yajl_gen_string(g, (const unsigned char*)  "DictFileName" , 12);
        const char *s = value.getDictFileName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasNumNames()) {
        yajl_gen_string(g, (const unsigned char*)  "NumNames" , 8);
        yajl_gen_integer(g, (long long)value.getNumNames());
    }
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "Name" , 4);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o1 = value.getName();
        {
            ::std::vector< ::std::string >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                const char *s = (*o0).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_DictionaryGroup& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AvailableCountry"

void serializeJson (const ::sds_speechdp_fi_types::T_AvailableCountry& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLanguageID()) {
        yajl_gen_string(g, (const unsigned char*)  "LanguageID" , 10);
        serializeJson(value.getLanguageID(), g, options);
    }
    if (!isSparse || value.hasCountryCode()) {
        yajl_gen_string(g, (const unsigned char*)  "CountryCode" , 11);
        const char* s = ::fi_types::T_e16_ISOCountryCode_Name(value.getCountryCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCountryCode());
    }
    if (!isSparse || value.hasState()) {
        yajl_gen_string(g, (const unsigned char*)  "State" , 5);
        const char *s = value.getState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMajorVersion_SBS_NAV()) {
        yajl_gen_string(g, (const unsigned char*)  "MajorVersion_SBS_NAV" , 20);
        yajl_gen_integer(g, (long long)value.getMajorVersion_SBS_NAV());
    }
    if (!isSparse || value.hasMinorVersion_SBS_NAV()) {
        yajl_gen_string(g, (const unsigned char*)  "MinorVersion_SBS_NAV" , 20);
        yajl_gen_integer(g, (long long)value.getMinorVersion_SBS_NAV());
    }
    if (!isSparse || value.hasBoschCreateDate()) {
        yajl_gen_string(g, (const unsigned char*)  "BoschCreateDate" , 15);
        const char *s = value.getBoschCreateDate().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_AvailableCountry& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TTSTunningFile"

void serializeJson (const ::sds_speechdp_fi_types::T_TTSTunningFile& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasType()) {
        yajl_gen_string(g, (const unsigned char*)  "Type" , 4);
        const char* s = ::sds_speechdp_fi_types::T_e8_TTSFileType_Name(value.getType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getType());
    }
    if (!isSparse || value.hasFilename()) {
        yajl_gen_string(g, (const unsigned char*)  "Filename" , 8);
        const char *s = value.getFilename().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_TTSTunningFile& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TTSVoiceFile"

void serializeJson (const ::sds_speechdp_fi_types::T_TTSVoiceFile& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFilename()) {
        yajl_gen_string(g, (const unsigned char*)  "Filename" , 8);
        const char *s = value.getFilename().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasLogicalName()) {
        yajl_gen_string(g, (const unsigned char*)  "LogicalName" , 11);
        const char *s = value.getLogicalName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_TTSVoiceFile& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_ContextFile"

void serializeJson (const ::sds_speechdp_fi_types::T_ContextFile& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasType()) {
        yajl_gen_string(g, (const unsigned char*)  "Type" , 4);
        const char* s = ::sds_speechdp_fi_types::T_e8_ContextFileType_Name(value.getType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getType());
    }
    if (!isSparse || value.hasFilename()) {
        yajl_gen_string(g, (const unsigned char*)  "Filename" , 8);
        const char *s = value.getFilename().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_ContextFile& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SemBufferFile"

void serializeJson (const ::sds_speechdp_fi_types::T_SemBufferFile& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasType()) {
        yajl_gen_string(g, (const unsigned char*)  "Type" , 4);
        const char* s = ::sds_speechdp_fi_types::T_e8_SemBufferFileType_Name(value.getType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getType());
    }
    if (!isSparse || value.hasFilename()) {
        yajl_gen_string(g, (const unsigned char*)  "Filename" , 8);
        const char *s = value.getFilename().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_SemBufferFile& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_ConnectDevice"

void serializeJson (const ::sds_speechdp_fi_types::T_ConnectDevice& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceID()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceID" , 8);
        yajl_gen_integer(g, (long long)value.getDeviceID());
    }
    if (!isSparse || value.hasTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "Timestamp" , 9);
        yajl_gen_integer(g, (long long)value.getTimestamp());
    }
    if (!isSparse || value.hasGnDbTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "GnDbTimestamp" , 13);
        yajl_gen_integer(g, (long long)value.getGnDbTimestamp());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_ConnectDevice& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DynamicContextFile"

void serializeJson (const ::sds_speechdp_fi_types::T_DynamicContextFile& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLogicalName()) {
        yajl_gen_string(g, (const unsigned char*)  "LogicalName" , 11);
        const char *s = value.getLogicalName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasFilename()) {
        yajl_gen_string(g, (const unsigned char*)  "Filename" , 8);
        const char *s = value.getFilename().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_DynamicContextFile& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TranscriptionFile"

void serializeJson (const ::sds_speechdp_fi_types::T_TranscriptionFile& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasType()) {
        yajl_gen_string(g, (const unsigned char*)  "Type" , 4);
        const char* s = ::sds_speechdp_fi_types::T_e8_TranscriptionFileType_Name(value.getType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getType());
    }
    if (!isSparse || value.hasFilename()) {
        yajl_gen_string(g, (const unsigned char*)  "Filename" , 8);
        const char *s = value.getFilename().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_TranscriptionFile& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_UserAudioFile"

void serializeJson (const ::sds_speechdp_fi_types::T_UserAudioFile& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUserwordID()) {
        yajl_gen_string(g, (const unsigned char*)  "UserwordID" , 10);
        yajl_gen_integer(g, (long long)value.getUserwordID());
    }
    if (!isSparse || value.hasFilename()) {
        yajl_gen_string(g, (const unsigned char*)  "Filename" , 8);
        const char *s = value.getFilename().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_UserAudioFile& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SpeakerInfoType"

void serializeJson (const ::sds_speechdp_fi_types::T_SpeakerInfoType& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLanguageID()) {
        yajl_gen_string(g, (const unsigned char*)  "LanguageID" , 10);
        serializeJson(value.getLanguageID(), g, options);
    }
    if (!isSparse || value.hasSpeaker()) {
        yajl_gen_string(g, (const unsigned char*)  "Speaker" , 7);
        const char *s = value.getSpeaker().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasGender()) {
        yajl_gen_string(g, (const unsigned char*)  "Gender" , 6);
        const char* s = ::sds_speechdp_fi_types::T_e8_VoiceGender_Name(value.getGender());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getGender());
    }
    if (!isSparse || value.hasSupportInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "SupportInfo" , 11);
        const char* s = ::sds_speechdp_fi_types::T_e8_SpeechSupportInfoType_Name(value.getSupportInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSupportInfo());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_SpeakerInfoType& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DynamicCtxStatus"

void serializeJson (const ::sds_speechdp_fi_types::T_DynamicCtxStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDomainID()) {
        yajl_gen_string(g, (const unsigned char*)  "DomainID" , 8);
        const char* s = ::sds_sds2hmi_common_types::T_e8_Domain_Name(value.getDomainID());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDomainID());
    }
    if (!isSparse || value.hasDeviceID()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceID" , 8);
        yajl_gen_integer(g, (long long)value.getDeviceID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_DynamicCtxStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DynamicDataContextMetaFile"

void serializeJson (const ::sds_speechdp_fi_types::T_DynamicDataContextMetaFile& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDomainDeviceID()) {
        yajl_gen_string(g, (const unsigned char*)  "DomainDeviceID" , 14);
        serializeJson(value.getDomainDeviceID(), g, options);
    }
    if (!isSparse || value.hasDeviceMetaFile()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceMetaFile" , 14);
        const char *s = value.getDeviceMetaFile().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_DynamicDataContextMetaFile& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_CityWithStreets"

void serializeJson (const ::sds_speechdp_fi_types::T_CityWithStreets& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCityID()) {
        yajl_gen_string(g, (const unsigned char*)  "CityID" , 6);
        yajl_gen_integer(g, (long long)value.getCityID());
    }
    if (!isSparse || value.hasStreetAvailability()) {
        yajl_gen_string(g, (const unsigned char*)  "StreetAvailability" , 18);
        yajl_gen_bool(g, (bool)value.getStreetAvailability());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_CityWithStreets& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_WordWithPhoneme"

void serializeJson (const ::sds_speechdp_fi_types::T_WordWithPhoneme& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWord()) {
        yajl_gen_string(g, (const unsigned char*)  "Word" , 4);
        const char *s = value.getWord().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPhonemeFound()) {
        yajl_gen_string(g, (const unsigned char*)  "PhonemeFound" , 12);
        const char *s = value.getPhonemeFound().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_WordWithPhoneme& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_VcData"

void serializeJson (const ::sds_speechdp_fi_types::T_VcData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSection()) {
        yajl_gen_string(g, (const unsigned char*)  "Section" , 7);
        const char *s = value.getSection().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasFilePath()) {
        yajl_gen_string(g, (const unsigned char*)  "FilePath" , 8);
        const char *s = value.getFilePath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_VcData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_BlobData"

void serializeJson (const ::sds_speechdp_fi_types::T_BlobData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasURId()) {
        yajl_gen_string(g, (const unsigned char*)  "URId" , 4);
        yajl_gen_integer(g, (long long)value.getURId());
    }
    if (!isSparse || value.hasFileLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "FileLocation" , 12);
        const char *s = value.getFileLocation().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasFileSize()) {
        yajl_gen_string(g, (const unsigned char*)  "FileSize" , 8);
        yajl_gen_integer(g, (long long)value.getFileSize());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_speechdp_fi_types::T_BlobData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_AvailableLanguage& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_VoiceType& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_VoiceDescription& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_DictionaryGroup& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_AvailableCountry& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_TTSTunningFile& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_TTSVoiceFile& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_ContextFile& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_SemBufferFile& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_ConnectDevice& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_DynamicContextFile& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_TranscriptionFile& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_UserAudioFile& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_SpeakerInfoType& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_DynamicCtxStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_DynamicDataContextMetaFile& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_CityWithStreets& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_WordWithPhoneme& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_VcData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types
using namespace ::asf::stream::json;

namespace sds_speechdp_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sds_speechdp_fi_types::T_BlobData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_speechdp_fi_types

