#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_SPEECHDP_FI_TYPES_H
#define SDS_SPEECHDP_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_typesConst.h"
#include "sds_sds2hmi_common_types.h"
#include "sds_sds2hmi_common_typesConst.h"
#include "sds_speechdp_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types sds_speechdp_fi_types
 */

namespace sds_speechdp_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_AvailableLanguage;

class T_VoiceType;

class T_VoiceDescription;

class T_DictionaryGroup;

class T_AvailableCountry;

class T_TTSTunningFile;

class T_TTSVoiceFile;

class T_ContextFile;

class T_SemBufferFile;

class T_ConnectDevice;

class T_DynamicContextFile;

class T_TranscriptionFile;

class T_UserAudioFile;

class T_SpeakerInfoType;

class T_DynamicCtxStatus;

class T_DynamicDataContextMetaFile;

class T_CityWithStreets;

class T_WordWithPhoneme;

class T_VcData;

class T_BlobData;

// type definitions
/**
 * If the meaning of "T_I2SNameIDs" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint32 > T_I2SNameIDs;


/**
 * Structure type representing the language ID and the storage device for an available language.
 */
class T_AvailableLanguage {
public:

    /**
     * Default constructor
     */
    inline  T_AvailableLanguage ();

    /**
     * Copy constructor
     */
    inline  T_AvailableLanguage (const T_AvailableLanguage &rhs);

    /**
     * All fields constructor
     */
    inline  T_AvailableLanguage (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_, T_e8_StorageDevice StorageDevice_);

    /**
     * Destructor
     */
    inline  ~T_AvailableLanguage();

    /**
     * Assignment operator
     */
    inline T_AvailableLanguage& operator = (const T_AvailableLanguage& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AvailableLanguage& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AvailableLanguage& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AvailableLanguage& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AvailableLanguage& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LanguageID"

    static const int kLanguageID = 0;

    /**
     * Clears the field "LanguageID".
     *
     * The field will be set to its default value. The hasLanguageID()
     * method will return false.
     */
    inline void clearLanguageID();

    /**
     * Checks whether the field "LanguageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageID()). Otherwise it will return false.
     */
    inline bool hasLanguageID () const;

    /**
     * Returns the value of the member "LanguageID".
     *
     * The LanguageCode and the CountryCode for an available language.
     *
     * @return The value of the field "LanguageID"
     */
    inline const ::sds_sds2hmi_common_types::T_SDSLanguageID& getLanguageID () const;

    /**
     * Retrieves the value of the field "LanguageID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LanguageID".
     */
    inline ::sds_sds2hmi_common_types::T_SDSLanguageID& getLanguageIDMutable ();

    /**
     * Sets the value of the member "LanguageID".
     *
     * The LanguageCode and the CountryCode for an available language.
     *
     * @param LanguageID The value which will be set
     */
    inline void setLanguageID (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_);

    // API of field "StorageDevice"

    static const int kStorageDevice = 1;

    /**
     * Clears the field "StorageDevice".
     *
     * The field will be set to its default value. The hasStorageDevice()
     * method will return false.
     */
    inline void clearStorageDevice();

    /**
     * Checks whether the field "StorageDevice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStorageDevice()). Otherwise it will return false.
     */
    inline bool hasStorageDevice () const;

    /**
     * Returns the value of the member "StorageDevice".
     *
     * The storage device for an available language.
     *
     * @return The value of the field "StorageDevice"
     */
    inline T_e8_StorageDevice getStorageDevice () const;

    /**
     * Sets the value of the member "StorageDevice".
     *
     * The storage device for an available language.
     *
     * @param StorageDevice The value which will be set
     */
    inline void setStorageDevice (T_e8_StorageDevice StorageDevice_);

    static const T_AvailableLanguage &getDefaultInstance();

private:

    inline void set_has_LanguageID ();

    inline void clear_has_LanguageID ();

    inline void set_has_StorageDevice ();

    inline void clear_has_StorageDevice ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sds_sds2hmi_common_types::T_SDSLanguageID _LanguageID;

    T_e8_StorageDevice _StorageDevice;

};

/**
 * Structure type representing the language ID, the name and some additional information about the voice.
 */
class T_VoiceType {
public:

    /**
     * Default constructor
     */
    inline  T_VoiceType ();

    /**
     * Copy constructor
     */
    inline  T_VoiceType (const T_VoiceType &rhs);

    /**
     * All fields constructor
     */
    inline  T_VoiceType (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_, const ::std::string& VoiceName_, T_e8_VoiceGender VoiceGender_);

    /**
     * Destructor
     */
    inline  ~T_VoiceType();

    /**
     * Assignment operator
     */
    inline T_VoiceType& operator = (const T_VoiceType& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_VoiceType& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_VoiceType& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_VoiceType& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_VoiceType& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LanguageID"

    static const int kLanguageID = 0;

    /**
     * Clears the field "LanguageID".
     *
     * The field will be set to its default value. The hasLanguageID()
     * method will return false.
     */
    inline void clearLanguageID();

    /**
     * Checks whether the field "LanguageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageID()). Otherwise it will return false.
     */
    inline bool hasLanguageID () const;

    /**
     * Returns the value of the member "LanguageID".
     *
     * The LanguageCode and the CountryCode.
     *
     * @return The value of the field "LanguageID"
     */
    inline const ::sds_sds2hmi_common_types::T_SDSLanguageID& getLanguageID () const;

    /**
     * Retrieves the value of the field "LanguageID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LanguageID".
     */
    inline ::sds_sds2hmi_common_types::T_SDSLanguageID& getLanguageIDMutable ();

    /**
     * Sets the value of the member "LanguageID".
     *
     * The LanguageCode and the CountryCode.
     *
     * @param LanguageID The value which will be set
     */
    inline void setLanguageID (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_);

    // API of field "VoiceName"

    static const int kVoiceName = 1;

    /**
     * Clears the field "VoiceName".
     *
     * The field will be set to its default value. The hasVoiceName()
     * method will return false.
     */
    inline void clearVoiceName();

    /**
     * Checks whether the field "VoiceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceName()). Otherwise it will return false.
     */
    inline bool hasVoiceName () const;

    /**
     * Returns the value of the member "VoiceName".
     *
     * The name of the voice.
     *
     * @return The value of the field "VoiceName"
     */
    inline const ::std::string& getVoiceName () const;

    /**
     * Retrieves the value of the field "VoiceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VoiceName".
     */
    inline ::std::string& getVoiceNameMutable ();

    /**
     * Sets the value of the member "VoiceName".
     *
     * The name of the voice.
     *
     * @param VoiceName The value which will be set
     */
    inline void setVoiceName (const ::std::string& VoiceName_);

    /**
     * Sets the value of the member "VoiceName".
     *
     * The name of the voice.
     *
     * @param VoiceName The value which will be set
     */
    inline void setVoiceName (const char* VoiceName_);

    /**
     * Sets the value of the member "VoiceName".
     *
     * The name of the voice.
     *
     * @param VoiceName The value which will be set
     */
    inline void setVoiceName (const char* value, size_t size);

    // API of field "VoiceGender"

    static const int kVoiceGender = 2;

    /**
     * Clears the field "VoiceGender".
     *
     * The field will be set to its default value. The hasVoiceGender()
     * method will return false.
     */
    inline void clearVoiceGender();

    /**
     * Checks whether the field "VoiceGender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceGender()). Otherwise it will return false.
     */
    inline bool hasVoiceGender () const;

    /**
     * Returns the value of the member "VoiceGender".
     *
     * Some additional information about the voice.
     *
     * @return The value of the field "VoiceGender"
     */
    inline T_e8_VoiceGender getVoiceGender () const;

    /**
     * Sets the value of the member "VoiceGender".
     *
     * Some additional information about the voice.
     *
     * @param VoiceGender The value which will be set
     */
    inline void setVoiceGender (T_e8_VoiceGender VoiceGender_);

    static const T_VoiceType &getDefaultInstance();

private:

    inline void set_has_LanguageID ();

    inline void clear_has_LanguageID ();

    inline void set_has_VoiceName ();

    inline void clear_has_VoiceName ();

    inline void set_has_VoiceGender ();

    inline void clear_has_VoiceGender ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::sds_sds2hmi_common_types::T_SDSLanguageID _LanguageID;

    ::std::string _VoiceName;

    T_e8_VoiceGender _VoiceGender;

};

/**
 * Structure type representing the type and the storage device of a voice.
 */
class T_VoiceDescription {
public:

    /**
     * Default constructor
     */
    inline  T_VoiceDescription ();

    /**
     * Copy constructor
     */
    inline  T_VoiceDescription (const T_VoiceDescription &rhs);

    /**
     * All fields constructor
     */
    inline  T_VoiceDescription (const T_VoiceType& VoiceType_, T_e8_StorageDevice StorageDevice_);

    /**
     * Destructor
     */
    inline  ~T_VoiceDescription();

    /**
     * Assignment operator
     */
    inline T_VoiceDescription& operator = (const T_VoiceDescription& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_VoiceDescription& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_VoiceDescription& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_VoiceDescription& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_VoiceDescription& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VoiceType"

    static const int kVoiceType = 0;

    /**
     * Clears the field "VoiceType".
     *
     * The field will be set to its default value. The hasVoiceType()
     * method will return false.
     */
    inline void clearVoiceType();

    /**
     * Checks whether the field "VoiceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceType()). Otherwise it will return false.
     */
    inline bool hasVoiceType () const;

    /**
     * Returns the value of the member "VoiceType".
     *
     * The type of the voice containing information about the language ID, the name and some options.
     *
     * @return The value of the field "VoiceType"
     */
    inline const T_VoiceType& getVoiceType () const;

    /**
     * Retrieves the value of the field "VoiceType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VoiceType".
     */
    inline T_VoiceType& getVoiceTypeMutable ();

    /**
     * Sets the value of the member "VoiceType".
     *
     * The type of the voice containing information about the language ID, the name and some options.
     *
     * @param VoiceType The value which will be set
     */
    inline void setVoiceType (const T_VoiceType& VoiceType_);

    // API of field "StorageDevice"

    static const int kStorageDevice = 1;

    /**
     * Clears the field "StorageDevice".
     *
     * The field will be set to its default value. The hasStorageDevice()
     * method will return false.
     */
    inline void clearStorageDevice();

    /**
     * Checks whether the field "StorageDevice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStorageDevice()). Otherwise it will return false.
     */
    inline bool hasStorageDevice () const;

    /**
     * Returns the value of the member "StorageDevice".
     *
     * The storage device of the voice.
     *
     * @return The value of the field "StorageDevice"
     */
    inline T_e8_StorageDevice getStorageDevice () const;

    /**
     * Sets the value of the member "StorageDevice".
     *
     * The storage device of the voice.
     *
     * @param StorageDevice The value which will be set
     */
    inline void setStorageDevice (T_e8_StorageDevice StorageDevice_);

    static const T_VoiceDescription &getDefaultInstance();

private:

    inline void set_has_VoiceType ();

    inline void clear_has_VoiceType ();

    inline void set_has_StorageDevice ();

    inline void clear_has_StorageDevice ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_VoiceType _VoiceType;

    T_e8_StorageDevice _StorageDevice;

};

/**
 * Structure type representing the content of a dictionary file.
 */
class T_DictionaryGroup {
public:

    /**
     * Default constructor
     */
    inline  T_DictionaryGroup ();

    /**
     * Copy constructor
     */
    inline  T_DictionaryGroup (const T_DictionaryGroup &rhs);

    /**
     * All fields constructor
     */
    inline  T_DictionaryGroup (const ::std::string& DictFileName_, uint16 NumNames_, const ::std::vector< ::std::string >& Name_);

    /**
     * Destructor
     */
    inline  ~T_DictionaryGroup();

    /**
     * Assignment operator
     */
    inline T_DictionaryGroup& operator = (const T_DictionaryGroup& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DictionaryGroup& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DictionaryGroup& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DictionaryGroup& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DictionaryGroup& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DictFileName"

    static const int kDictFileName = 0;

    /**
     * Clears the field "DictFileName".
     *
     * The field will be set to its default value. The hasDictFileName()
     * method will return false.
     */
    inline void clearDictFileName();

    /**
     * Checks whether the field "DictFileName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDictFileName()). Otherwise it will return false.
     */
    inline bool hasDictFileName () const;

    /**
     * Returns the value of the member "DictFileName".
     *
     * The name of the dictionary file.
     *
     * @return The value of the field "DictFileName"
     */
    inline const ::std::string& getDictFileName () const;

    /**
     * Retrieves the value of the field "DictFileName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DictFileName".
     */
    inline ::std::string& getDictFileNameMutable ();

    /**
     * Sets the value of the member "DictFileName".
     *
     * The name of the dictionary file.
     *
     * @param DictFileName The value which will be set
     */
    inline void setDictFileName (const ::std::string& DictFileName_);

    /**
     * Sets the value of the member "DictFileName".
     *
     * The name of the dictionary file.
     *
     * @param DictFileName The value which will be set
     */
    inline void setDictFileName (const char* DictFileName_);

    /**
     * Sets the value of the member "DictFileName".
     *
     * The name of the dictionary file.
     *
     * @param DictFileName The value which will be set
     */
    inline void setDictFileName (const char* value, size_t size);

    // API of field "NumNames"

    static const int kNumNames = 1;

    /**
     * Clears the field "NumNames".
     *
     * The field will be set to its default value. The hasNumNames()
     * method will return false.
     */
    inline void clearNumNames();

    /**
     * Checks whether the field "NumNames" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumNames()). Otherwise it will return false.
     */
    inline bool hasNumNames () const;

    /**
     * Returns the value of the member "NumNames".
     *
     * The number of entries in this dictionary file.
     *
     * @return The value of the field "NumNames"
     */
    inline uint16 getNumNames () const;

    /**
     * Sets the value of the member "NumNames".
     *
     * The number of entries in this dictionary file.
     *
     * @param NumNames The value which will be set
     */
    inline void setNumNames (uint16 NumNames_);

    // API of field "Name"

    static const int kName = 2;

    /**
     * Clears the field "Name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "Name".
     *
     * A list of names which are contained in the dictionary.
     *
     * @return The value of the field "Name"
     */
    inline const ::std::vector< ::std::string >& getName () const;

    /**
     * Retrieves the value of the field "Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Name".
     */
    inline ::std::vector< ::std::string >& getNameMutable ();

    /**
     * Sets the value of the member "Name".
     *
     * A list of names which are contained in the dictionary.
     *
     * @param Name The value which will be set
     */
    inline void setName (const ::std::vector< ::std::string >& Name_);

    static const T_DictionaryGroup &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_DictFileName ();

    inline void clear_has_DictFileName ();

    inline void set_has_NumNames ();

    inline void clear_has_NumNames ();

    inline void set_has_Name ();

    inline void clear_has_Name ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _DictFileName;

    uint16 _NumNames;

    ::std::vector< ::std::string > _Name;

};

/**
 * Structure type representing the available country data.
 */
class T_AvailableCountry {
public:

    /**
     * Default constructor
     */
    inline  T_AvailableCountry ();

    /**
     * Copy constructor
     */
    inline  T_AvailableCountry (const T_AvailableCountry &rhs);

    /**
     * All fields constructor
     */
    inline  T_AvailableCountry (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_, ::fi_types::T_e16_ISOCountryCode CountryCode_, const ::std::string& State_, uint16 MajorVersion_SBS_NAV_, uint16 MinorVersion_SBS_NAV_, const ::std::string& BoschCreateDate_);

    /**
     * Destructor
     */
    inline  ~T_AvailableCountry();

    /**
     * Assignment operator
     */
    inline T_AvailableCountry& operator = (const T_AvailableCountry& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AvailableCountry& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AvailableCountry& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AvailableCountry& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AvailableCountry& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LanguageID"

    static const int kLanguageID = 0;

    /**
     * Clears the field "LanguageID".
     *
     * The field will be set to its default value. The hasLanguageID()
     * method will return false.
     */
    inline void clearLanguageID();

    /**
     * Checks whether the field "LanguageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageID()). Otherwise it will return false.
     */
    inline bool hasLanguageID () const;

    /**
     * Returns the value of the member "LanguageID".
     *
     * The LanguageCode for an available language.
     *
     * @return The value of the field "LanguageID"
     */
    inline const ::sds_sds2hmi_common_types::T_SDSLanguageID& getLanguageID () const;

    /**
     * Retrieves the value of the field "LanguageID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LanguageID".
     */
    inline ::sds_sds2hmi_common_types::T_SDSLanguageID& getLanguageIDMutable ();

    /**
     * Sets the value of the member "LanguageID".
     *
     * The LanguageCode for an available language.
     *
     * @param LanguageID The value which will be set
     */
    inline void setLanguageID (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_);

    // API of field "CountryCode"

    static const int kCountryCode = 1;

    /**
     * Clears the field "CountryCode".
     *
     * The field will be set to its default value. The hasCountryCode()
     * method will return false.
     */
    inline void clearCountryCode();

    /**
     * Checks whether the field "CountryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryCode()). Otherwise it will return false.
     */
    inline bool hasCountryCode () const;

    /**
     * Returns the value of the member "CountryCode".
     *
     * The CountryCode for an available language.
     *
     * @return The value of the field "CountryCode"
     */
    inline ::fi_types::T_e16_ISOCountryCode getCountryCode () const;

    /**
     * Sets the value of the member "CountryCode".
     *
     * The CountryCode for an available language.
     *
     * @param CountryCode The value which will be set
     */
    inline void setCountryCode (::fi_types::T_e16_ISOCountryCode CountryCode_);

    // API of field "State"

    static const int kState = 2;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * Used in future for the North American Market. Indicates the state name (e.g. California).
     *
     * @return The value of the field "State"
     */
    inline const ::std::string& getState () const;

    /**
     * Retrieves the value of the field "State" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "State".
     */
    inline ::std::string& getStateMutable ();

    /**
     * Sets the value of the member "State".
     *
     * Used in future for the North American Market. Indicates the state name (e.g. California).
     *
     * @param State The value which will be set
     */
    inline void setState (const ::std::string& State_);

    /**
     * Sets the value of the member "State".
     *
     * Used in future for the North American Market. Indicates the state name (e.g. California).
     *
     * @param State The value which will be set
     */
    inline void setState (const char* State_);

    /**
     * Sets the value of the member "State".
     *
     * Used in future for the North American Market. Indicates the state name (e.g. California).
     *
     * @param State The value which will be set
     */
    inline void setState (const char* value, size_t size);

    // API of field "MajorVersion_SBS_NAV"

    static const int kMajorVersion_SBS_NAV = 3;

    /**
     * Clears the field "MajorVersion_SBS_NAV".
     *
     * The field will be set to its default value. The hasMajorVersion_SBS_NAV()
     * method will return false.
     */
    inline void clearMajorVersion_SBS_NAV();

    /**
     * Checks whether the field "MajorVersion_SBS_NAV" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMajorVersion_SBS_NAV()). Otherwise it will return false.
     */
    inline bool hasMajorVersion_SBS_NAV () const;

    /**
     * Returns the value of the member "MajorVersion_SBS_NAV".
     *
     * The major version number of navi SDS data.
     *
     * @return The value of the field "MajorVersion_SBS_NAV"
     */
    inline uint16 getMajorVersion_SBS_NAV () const;

    /**
     * Sets the value of the member "MajorVersion_SBS_NAV".
     *
     * The major version number of navi SDS data.
     *
     * @param MajorVersion_SBS_NAV The value which will be set
     */
    inline void setMajorVersion_SBS_NAV (uint16 MajorVersion_SBS_NAV_);

    // API of field "MinorVersion_SBS_NAV"

    static const int kMinorVersion_SBS_NAV = 4;

    /**
     * Clears the field "MinorVersion_SBS_NAV".
     *
     * The field will be set to its default value. The hasMinorVersion_SBS_NAV()
     * method will return false.
     */
    inline void clearMinorVersion_SBS_NAV();

    /**
     * Checks whether the field "MinorVersion_SBS_NAV" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinorVersion_SBS_NAV()). Otherwise it will return false.
     */
    inline bool hasMinorVersion_SBS_NAV () const;

    /**
     * Returns the value of the member "MinorVersion_SBS_NAV".
     *
     * The minor version number of navi SDS data.
     *
     * @return The value of the field "MinorVersion_SBS_NAV"
     */
    inline uint16 getMinorVersion_SBS_NAV () const;

    /**
     * Sets the value of the member "MinorVersion_SBS_NAV".
     *
     * The minor version number of navi SDS data.
     *
     * @param MinorVersion_SBS_NAV The value which will be set
     */
    inline void setMinorVersion_SBS_NAV (uint16 MinorVersion_SBS_NAV_);

    // API of field "BoschCreateDate"

    static const int kBoschCreateDate = 5;

    /**
     * Clears the field "BoschCreateDate".
     *
     * The field will be set to its default value. The hasBoschCreateDate()
     * method will return false.
     */
    inline void clearBoschCreateDate();

    /**
     * Checks whether the field "BoschCreateDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBoschCreateDate()). Otherwise it will return false.
     */
    inline bool hasBoschCreateDate () const;

    /**
     * Returns the value of the member "BoschCreateDate".
     *
     * The BoschCreateDate of the navi SDS data.
     *
     * @return The value of the field "BoschCreateDate"
     */
    inline const ::std::string& getBoschCreateDate () const;

    /**
     * Retrieves the value of the field "BoschCreateDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BoschCreateDate".
     */
    inline ::std::string& getBoschCreateDateMutable ();

    /**
     * Sets the value of the member "BoschCreateDate".
     *
     * The BoschCreateDate of the navi SDS data.
     *
     * @param BoschCreateDate The value which will be set
     */
    inline void setBoschCreateDate (const ::std::string& BoschCreateDate_);

    /**
     * Sets the value of the member "BoschCreateDate".
     *
     * The BoschCreateDate of the navi SDS data.
     *
     * @param BoschCreateDate The value which will be set
     */
    inline void setBoschCreateDate (const char* BoschCreateDate_);

    /**
     * Sets the value of the member "BoschCreateDate".
     *
     * The BoschCreateDate of the navi SDS data.
     *
     * @param BoschCreateDate The value which will be set
     */
    inline void setBoschCreateDate (const char* value, size_t size);

    static const T_AvailableCountry &getDefaultInstance();

private:

    inline void set_has_LanguageID ();

    inline void clear_has_LanguageID ();

    inline void set_has_CountryCode ();

    inline void clear_has_CountryCode ();

    inline void set_has_State ();

    inline void clear_has_State ();

    inline void set_has_MajorVersion_SBS_NAV ();

    inline void clear_has_MajorVersion_SBS_NAV ();

    inline void set_has_MinorVersion_SBS_NAV ();

    inline void clear_has_MinorVersion_SBS_NAV ();

    inline void set_has_BoschCreateDate ();

    inline void clear_has_BoschCreateDate ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::sds_sds2hmi_common_types::T_SDSLanguageID _LanguageID;

    ::fi_types::T_e16_ISOCountryCode _CountryCode;

    ::std::string _State;

    uint16 _MajorVersion_SBS_NAV;

    uint16 _MinorVersion_SBS_NAV;

    ::std::string _BoschCreateDate;

};

/**
 * Structure type representing the TTS Voice data.
 */
class T_TTSTunningFile {
public:

    /**
     * Default constructor
     */
    inline  T_TTSTunningFile ();

    /**
     * Copy constructor
     */
    inline  T_TTSTunningFile (const T_TTSTunningFile &rhs);

    /**
     * All fields constructor
     */
    inline  T_TTSTunningFile (T_e8_TTSFileType Type_, const ::std::string& Filename_);

    /**
     * Destructor
     */
    inline  ~T_TTSTunningFile();

    /**
     * Assignment operator
     */
    inline T_TTSTunningFile& operator = (const T_TTSTunningFile& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TTSTunningFile& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TTSTunningFile& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TTSTunningFile& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TTSTunningFile& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Type"

    static const int kType = 0;

    /**
     * Clears the field "Type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "Type".
     *
     * The type of the file.
     *
     * @return The value of the field "Type"
     */
    inline T_e8_TTSFileType getType () const;

    /**
     * Sets the value of the member "Type".
     *
     * The type of the file.
     *
     * @param Type The value which will be set
     */
    inline void setType (T_e8_TTSFileType Type_);

    // API of field "Filename"

    static const int kFilename = 1;

    /**
     * Clears the field "Filename".
     *
     * The field will be set to its default value. The hasFilename()
     * method will return false.
     */
    inline void clearFilename();

    /**
     * Checks whether the field "Filename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilename()). Otherwise it will return false.
     */
    inline bool hasFilename () const;

    /**
     * Returns the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @return The value of the field "Filename"
     */
    inline const ::std::string& getFilename () const;

    /**
     * Retrieves the value of the field "Filename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Filename".
     */
    inline ::std::string& getFilenameMutable ();

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const ::std::string& Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* value, size_t size);

    static const T_TTSTunningFile &getDefaultInstance();

private:

    inline void set_has_Type ();

    inline void clear_has_Type ();

    inline void set_has_Filename ();

    inline void clear_has_Filename ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_TTSFileType _Type;

    ::std::string _Filename;

};

/**
 * Structure type representing the TTS Voice data.
 */
class T_TTSVoiceFile {
public:

    /**
     * Default constructor
     */
    inline  T_TTSVoiceFile ();

    /**
     * Copy constructor
     */
    inline  T_TTSVoiceFile (const T_TTSVoiceFile &rhs);

    /**
     * All fields constructor
     */
    inline  T_TTSVoiceFile (const ::std::string& Filename_, const ::std::string& LogicalName_);

    /**
     * Destructor
     */
    inline  ~T_TTSVoiceFile();

    /**
     * Assignment operator
     */
    inline T_TTSVoiceFile& operator = (const T_TTSVoiceFile& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TTSVoiceFile& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TTSVoiceFile& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TTSVoiceFile& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TTSVoiceFile& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Filename"

    static const int kFilename = 0;

    /**
     * Clears the field "Filename".
     *
     * The field will be set to its default value. The hasFilename()
     * method will return false.
     */
    inline void clearFilename();

    /**
     * Checks whether the field "Filename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilename()). Otherwise it will return false.
     */
    inline bool hasFilename () const;

    /**
     * Returns the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @return The value of the field "Filename"
     */
    inline const ::std::string& getFilename () const;

    /**
     * Retrieves the value of the field "Filename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Filename".
     */
    inline ::std::string& getFilenameMutable ();

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const ::std::string& Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* value, size_t size);

    // API of field "LogicalName"

    static const int kLogicalName = 1;

    /**
     * Clears the field "LogicalName".
     *
     * The field will be set to its default value. The hasLogicalName()
     * method will return false.
     */
    inline void clearLogicalName();

    /**
     * Checks whether the field "LogicalName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLogicalName()). Otherwise it will return false.
     */
    inline bool hasLogicalName () const;

    /**
     * Returns the value of the member "LogicalName".
     *
     * Orignial File name of TTS Voice Files.
     *
     * @return The value of the field "LogicalName"
     */
    inline const ::std::string& getLogicalName () const;

    /**
     * Retrieves the value of the field "LogicalName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LogicalName".
     */
    inline ::std::string& getLogicalNameMutable ();

    /**
     * Sets the value of the member "LogicalName".
     *
     * Orignial File name of TTS Voice Files.
     *
     * @param LogicalName The value which will be set
     */
    inline void setLogicalName (const ::std::string& LogicalName_);

    /**
     * Sets the value of the member "LogicalName".
     *
     * Orignial File name of TTS Voice Files.
     *
     * @param LogicalName The value which will be set
     */
    inline void setLogicalName (const char* LogicalName_);

    /**
     * Sets the value of the member "LogicalName".
     *
     * Orignial File name of TTS Voice Files.
     *
     * @param LogicalName The value which will be set
     */
    inline void setLogicalName (const char* value, size_t size);

    static const T_TTSVoiceFile &getDefaultInstance();

private:

    inline void set_has_Filename ();

    inline void clear_has_Filename ();

    inline void set_has_LogicalName ();

    inline void clear_has_LogicalName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _Filename;

    ::std::string _LogicalName;

};

/**
 * Structure type representing the context files for the Vocon.
 */
class T_ContextFile {
public:

    /**
     * Default constructor
     */
    inline  T_ContextFile ();

    /**
     * Copy constructor
     */
    inline  T_ContextFile (const T_ContextFile &rhs);

    /**
     * All fields constructor
     */
    inline  T_ContextFile (T_e8_ContextFileType Type_, const ::std::string& Filename_);

    /**
     * Destructor
     */
    inline  ~T_ContextFile();

    /**
     * Assignment operator
     */
    inline T_ContextFile& operator = (const T_ContextFile& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ContextFile& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ContextFile& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ContextFile& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ContextFile& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Type"

    static const int kType = 0;

    /**
     * Clears the field "Type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "Type".
     *
     * The type of the file.
     *
     * @return The value of the field "Type"
     */
    inline T_e8_ContextFileType getType () const;

    /**
     * Sets the value of the member "Type".
     *
     * The type of the file.
     *
     * @param Type The value which will be set
     */
    inline void setType (T_e8_ContextFileType Type_);

    // API of field "Filename"

    static const int kFilename = 1;

    /**
     * Clears the field "Filename".
     *
     * The field will be set to its default value. The hasFilename()
     * method will return false.
     */
    inline void clearFilename();

    /**
     * Checks whether the field "Filename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilename()). Otherwise it will return false.
     */
    inline bool hasFilename () const;

    /**
     * Returns the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @return The value of the field "Filename"
     */
    inline const ::std::string& getFilename () const;

    /**
     * Retrieves the value of the field "Filename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Filename".
     */
    inline ::std::string& getFilenameMutable ();

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const ::std::string& Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* value, size_t size);

    static const T_ContextFile &getDefaultInstance();

private:

    inline void set_has_Type ();

    inline void clear_has_Type ();

    inline void set_has_Filename ();

    inline void clear_has_Filename ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_ContextFileType _Type;

    ::std::string _Filename;

};

/**
 * Structure type representing the SEM buffer files for the Vocon.
 */
class T_SemBufferFile {
public:

    /**
     * Default constructor
     */
    inline  T_SemBufferFile ();

    /**
     * Copy constructor
     */
    inline  T_SemBufferFile (const T_SemBufferFile &rhs);

    /**
     * All fields constructor
     */
    inline  T_SemBufferFile (T_e8_SemBufferFileType Type_, const ::std::string& Filename_);

    /**
     * Destructor
     */
    inline  ~T_SemBufferFile();

    /**
     * Assignment operator
     */
    inline T_SemBufferFile& operator = (const T_SemBufferFile& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SemBufferFile& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SemBufferFile& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SemBufferFile& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SemBufferFile& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Type"

    static const int kType = 0;

    /**
     * Clears the field "Type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "Type".
     *
     * The type of the file.
     *
     * @return The value of the field "Type"
     */
    inline T_e8_SemBufferFileType getType () const;

    /**
     * Sets the value of the member "Type".
     *
     * The type of the file.
     *
     * @param Type The value which will be set
     */
    inline void setType (T_e8_SemBufferFileType Type_);

    // API of field "Filename"

    static const int kFilename = 1;

    /**
     * Clears the field "Filename".
     *
     * The field will be set to its default value. The hasFilename()
     * method will return false.
     */
    inline void clearFilename();

    /**
     * Checks whether the field "Filename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilename()). Otherwise it will return false.
     */
    inline bool hasFilename () const;

    /**
     * Returns the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @return The value of the field "Filename"
     */
    inline const ::std::string& getFilename () const;

    /**
     * Retrieves the value of the field "Filename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Filename".
     */
    inline ::std::string& getFilenameMutable ();

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const ::std::string& Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* value, size_t size);

    static const T_SemBufferFile &getDefaultInstance();

private:

    inline void set_has_Type ();

    inline void clear_has_Type ();

    inline void set_has_Filename ();

    inline void clear_has_Filename ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_SemBufferFileType _Type;

    ::std::string _Filename;

};

/**
 * Structure type describing the connected devices.
 */
class T_ConnectDevice {
public:

    /**
     * Default constructor
     */
    inline  T_ConnectDevice ();

    /**
     * Copy constructor
     */
    inline  T_ConnectDevice (const T_ConnectDevice &rhs);

    /**
     * All fields constructor
     */
    inline  T_ConnectDevice (uint32 DeviceID_, uint32 Timestamp_, uint32 GnDbTimestamp_);

    /**
     * Destructor
     */
    inline  ~T_ConnectDevice();

    /**
     * Assignment operator
     */
    inline T_ConnectDevice& operator = (const T_ConnectDevice& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ConnectDevice& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ConnectDevice& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ConnectDevice& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ConnectDevice& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceID"

    static const int kDeviceID = 0;

    /**
     * Clears the field "DeviceID".
     *
     * The field will be set to its default value. The hasDeviceID()
     * method will return false.
     */
    inline void clearDeviceID();

    /**
     * Checks whether the field "DeviceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceID()). Otherwise it will return false.
     */
    inline bool hasDeviceID () const;

    /**
     * Returns the value of the member "DeviceID".
     *
     * Unique id of the device.
     *
     * @return The value of the field "DeviceID"
     */
    inline uint32 getDeviceID () const;

    /**
     * Sets the value of the member "DeviceID".
     *
     * Unique id of the device.
     *
     * @param DeviceID The value which will be set
     */
    inline void setDeviceID (uint32 DeviceID_);

    // API of field "Timestamp"

    static const int kTimestamp = 1;

    /**
     * Clears the field "Timestamp".
     *
     * The field will be set to its default value. The hasTimestamp()
     * method will return false.
     */
    inline void clearTimestamp();

    /**
     * Checks whether the field "Timestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimestamp()). Otherwise it will return false.
     */
    inline bool hasTimestamp () const;

    /**
     * Returns the value of the member "Timestamp".
     *
     * Database timestamp.
     *
     * @return The value of the field "Timestamp"
     */
    inline uint32 getTimestamp () const;

    /**
     * Sets the value of the member "Timestamp".
     *
     * Database timestamp.
     *
     * @param Timestamp The value which will be set
     */
    inline void setTimestamp (uint32 Timestamp_);

    // API of field "GnDbTimestamp"

    static const int kGnDbTimestamp = 2;

    /**
     * Clears the field "GnDbTimestamp".
     *
     * The field will be set to its default value. The hasGnDbTimestamp()
     * method will return false.
     */
    inline void clearGnDbTimestamp();

    /**
     * Checks whether the field "GnDbTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnDbTimestamp()). Otherwise it will return false.
     */
    inline bool hasGnDbTimestamp () const;

    /**
     * Returns the value of the member "GnDbTimestamp".
     *
     * Gracenote Database timestamp.
     *
     * @return The value of the field "GnDbTimestamp"
     */
    inline uint32 getGnDbTimestamp () const;

    /**
     * Sets the value of the member "GnDbTimestamp".
     *
     * Gracenote Database timestamp.
     *
     * @param GnDbTimestamp The value which will be set
     */
    inline void setGnDbTimestamp (uint32 GnDbTimestamp_);

    static const T_ConnectDevice &getDefaultInstance();

private:

    inline void set_has_DeviceID ();

    inline void clear_has_DeviceID ();

    inline void set_has_Timestamp ();

    inline void clear_has_Timestamp ();

    inline void set_has_GnDbTimestamp ();

    inline void clear_has_GnDbTimestamp ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceID;

    uint32 _Timestamp;

    uint32 _GnDbTimestamp;

};

/**
 * Structure type describing the dynamic context files for connected devices.
 */
class T_DynamicContextFile {
public:

    /**
     * Default constructor
     */
    inline  T_DynamicContextFile ();

    /**
     * Copy constructor
     */
    inline  T_DynamicContextFile (const T_DynamicContextFile &rhs);

    /**
     * All fields constructor
     */
    inline  T_DynamicContextFile (const ::std::string& LogicalName_, const ::std::string& Filename_);

    /**
     * Destructor
     */
    inline  ~T_DynamicContextFile();

    /**
     * Assignment operator
     */
    inline T_DynamicContextFile& operator = (const T_DynamicContextFile& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DynamicContextFile& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DynamicContextFile& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DynamicContextFile& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DynamicContextFile& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LogicalName"

    static const int kLogicalName = 0;

    /**
     * Clears the field "LogicalName".
     *
     * The field will be set to its default value. The hasLogicalName()
     * method will return false.
     */
    inline void clearLogicalName();

    /**
     * Checks whether the field "LogicalName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLogicalName()). Otherwise it will return false.
     */
    inline bool hasLogicalName () const;

    /**
     * Returns the value of the member "LogicalName".
     *
     * Logical name of the context.
     *
     * @return The value of the field "LogicalName"
     */
    inline const ::std::string& getLogicalName () const;

    /**
     * Retrieves the value of the field "LogicalName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LogicalName".
     */
    inline ::std::string& getLogicalNameMutable ();

    /**
     * Sets the value of the member "LogicalName".
     *
     * Logical name of the context.
     *
     * @param LogicalName The value which will be set
     */
    inline void setLogicalName (const ::std::string& LogicalName_);

    /**
     * Sets the value of the member "LogicalName".
     *
     * Logical name of the context.
     *
     * @param LogicalName The value which will be set
     */
    inline void setLogicalName (const char* LogicalName_);

    /**
     * Sets the value of the member "LogicalName".
     *
     * Logical name of the context.
     *
     * @param LogicalName The value which will be set
     */
    inline void setLogicalName (const char* value, size_t size);

    // API of field "Filename"

    static const int kFilename = 1;

    /**
     * Clears the field "Filename".
     *
     * The field will be set to its default value. The hasFilename()
     * method will return false.
     */
    inline void clearFilename();

    /**
     * Checks whether the field "Filename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilename()). Otherwise it will return false.
     */
    inline bool hasFilename () const;

    /**
     * Returns the value of the member "Filename".
     *
     * File name containing the full path.
     *
     * @return The value of the field "Filename"
     */
    inline const ::std::string& getFilename () const;

    /**
     * Retrieves the value of the field "Filename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Filename".
     */
    inline ::std::string& getFilenameMutable ();

    /**
     * Sets the value of the member "Filename".
     *
     * File name containing the full path.
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const ::std::string& Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * File name containing the full path.
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * File name containing the full path.
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* value, size_t size);

    static const T_DynamicContextFile &getDefaultInstance();

private:

    inline void set_has_LogicalName ();

    inline void clear_has_LogicalName ();

    inline void set_has_Filename ();

    inline void clear_has_Filename ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _LogicalName;

    ::std::string _Filename;

};

/**
 * Structure type representing the files for the TranscriptionService.
 */
class T_TranscriptionFile {
public:

    /**
     * Default constructor
     */
    inline  T_TranscriptionFile ();

    /**
     * Copy constructor
     */
    inline  T_TranscriptionFile (const T_TranscriptionFile &rhs);

    /**
     * All fields constructor
     */
    inline  T_TranscriptionFile (T_e8_TranscriptionFileType Type_, const ::std::string& Filename_);

    /**
     * Destructor
     */
    inline  ~T_TranscriptionFile();

    /**
     * Assignment operator
     */
    inline T_TranscriptionFile& operator = (const T_TranscriptionFile& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TranscriptionFile& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TranscriptionFile& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TranscriptionFile& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TranscriptionFile& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Type"

    static const int kType = 0;

    /**
     * Clears the field "Type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "Type".
     *
     * The type of the file.
     *
     * @return The value of the field "Type"
     */
    inline T_e8_TranscriptionFileType getType () const;

    /**
     * Sets the value of the member "Type".
     *
     * The type of the file.
     *
     * @param Type The value which will be set
     */
    inline void setType (T_e8_TranscriptionFileType Type_);

    // API of field "Filename"

    static const int kFilename = 1;

    /**
     * Clears the field "Filename".
     *
     * The field will be set to its default value. The hasFilename()
     * method will return false.
     */
    inline void clearFilename();

    /**
     * Checks whether the field "Filename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilename()). Otherwise it will return false.
     */
    inline bool hasFilename () const;

    /**
     * Returns the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @return The value of the field "Filename"
     */
    inline const ::std::string& getFilename () const;

    /**
     * Retrieves the value of the field "Filename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Filename".
     */
    inline ::std::string& getFilenameMutable ();

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const ::std::string& Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* value, size_t size);

    static const T_TranscriptionFile &getDefaultInstance();

private:

    inline void set_has_Type ();

    inline void clear_has_Type ();

    inline void set_has_Filename ();

    inline void clear_has_Filename ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_TranscriptionFileType _Type;

    ::std::string _Filename;

};

/**
 * Structure type representing the audio file of an userword.
 */
class T_UserAudioFile {
public:

    /**
     * Default constructor
     */
    inline  T_UserAudioFile ();

    /**
     * Copy constructor
     */
    inline  T_UserAudioFile (const T_UserAudioFile &rhs);

    /**
     * All fields constructor
     */
    inline  T_UserAudioFile (uint32 UserwordID_, const ::std::string& Filename_);

    /**
     * Destructor
     */
    inline  ~T_UserAudioFile();

    /**
     * Assignment operator
     */
    inline T_UserAudioFile& operator = (const T_UserAudioFile& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_UserAudioFile& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_UserAudioFile& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_UserAudioFile& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_UserAudioFile& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UserwordID"

    static const int kUserwordID = 0;

    /**
     * Clears the field "UserwordID".
     *
     * The field will be set to its default value. The hasUserwordID()
     * method will return false.
     */
    inline void clearUserwordID();

    /**
     * Checks whether the field "UserwordID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserwordID()). Otherwise it will return false.
     */
    inline bool hasUserwordID () const;

    /**
     * Returns the value of the member "UserwordID".
     *
     * The userword Id.
     *
     * @return The value of the field "UserwordID"
     */
    inline uint32 getUserwordID () const;

    /**
     * Sets the value of the member "UserwordID".
     *
     * The userword Id.
     *
     * @param UserwordID The value which will be set
     */
    inline void setUserwordID (uint32 UserwordID_);

    // API of field "Filename"

    static const int kFilename = 1;

    /**
     * Clears the field "Filename".
     *
     * The field will be set to its default value. The hasFilename()
     * method will return false.
     */
    inline void clearFilename();

    /**
     * Checks whether the field "Filename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilename()). Otherwise it will return false.
     */
    inline bool hasFilename () const;

    /**
     * Returns the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @return The value of the field "Filename"
     */
    inline const ::std::string& getFilename () const;

    /**
     * Retrieves the value of the field "Filename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Filename".
     */
    inline ::std::string& getFilenameMutable ();

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const ::std::string& Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * The filename (containing the complete path).
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* value, size_t size);

    static const T_UserAudioFile &getDefaultInstance();

private:

    inline void set_has_UserwordID ();

    inline void clear_has_UserwordID ();

    inline void set_has_Filename ();

    inline void clear_has_Filename ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _UserwordID;

    ::std::string _Filename;

};

/**
 * Structure type representing the language ID, the name string and speaker support information about the speaker.
 */
class T_SpeakerInfoType {
public:

    /**
     * Default constructor
     */
    inline  T_SpeakerInfoType ();

    /**
     * Copy constructor
     */
    inline  T_SpeakerInfoType (const T_SpeakerInfoType &rhs);

    /**
     * All fields constructor
     */
    inline  T_SpeakerInfoType (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_, const ::std::string& Speaker_, T_e8_VoiceGender Gender_, T_e8_SpeechSupportInfoType SupportInfo_);

    /**
     * Destructor
     */
    inline  ~T_SpeakerInfoType();

    /**
     * Assignment operator
     */
    inline T_SpeakerInfoType& operator = (const T_SpeakerInfoType& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SpeakerInfoType& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SpeakerInfoType& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SpeakerInfoType& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SpeakerInfoType& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LanguageID"

    static const int kLanguageID = 0;

    /**
     * Clears the field "LanguageID".
     *
     * The field will be set to its default value. The hasLanguageID()
     * method will return false.
     */
    inline void clearLanguageID();

    /**
     * Checks whether the field "LanguageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageID()). Otherwise it will return false.
     */
    inline bool hasLanguageID () const;

    /**
     * Returns the value of the member "LanguageID".
     *
     * The LanguageCode and the CountryCode.
     *
     * @return The value of the field "LanguageID"
     */
    inline const ::sds_sds2hmi_common_types::T_SDSLanguageID& getLanguageID () const;

    /**
     * Retrieves the value of the field "LanguageID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LanguageID".
     */
    inline ::sds_sds2hmi_common_types::T_SDSLanguageID& getLanguageIDMutable ();

    /**
     * Sets the value of the member "LanguageID".
     *
     * The LanguageCode and the CountryCode.
     *
     * @param LanguageID The value which will be set
     */
    inline void setLanguageID (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_);

    // API of field "Speaker"

    static const int kSpeaker = 1;

    /**
     * Clears the field "Speaker".
     *
     * The field will be set to its default value. The hasSpeaker()
     * method will return false.
     */
    inline void clearSpeaker();

    /**
     * Checks whether the field "Speaker" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeaker()). Otherwise it will return false.
     */
    inline bool hasSpeaker () const;

    /**
     * Returns the value of the member "Speaker".
     *
     * The name of the speaker.
     *
     * @return The value of the field "Speaker"
     */
    inline const ::std::string& getSpeaker () const;

    /**
     * Retrieves the value of the field "Speaker" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Speaker".
     */
    inline ::std::string& getSpeakerMutable ();

    /**
     * Sets the value of the member "Speaker".
     *
     * The name of the speaker.
     *
     * @param Speaker The value which will be set
     */
    inline void setSpeaker (const ::std::string& Speaker_);

    /**
     * Sets the value of the member "Speaker".
     *
     * The name of the speaker.
     *
     * @param Speaker The value which will be set
     */
    inline void setSpeaker (const char* Speaker_);

    /**
     * Sets the value of the member "Speaker".
     *
     * The name of the speaker.
     *
     * @param Speaker The value which will be set
     */
    inline void setSpeaker (const char* value, size_t size);

    // API of field "Gender"

    static const int kGender = 2;

    /**
     * Clears the field "Gender".
     *
     * The field will be set to its default value. The hasGender()
     * method will return false.
     */
    inline void clearGender();

    /**
     * Checks whether the field "Gender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGender()). Otherwise it will return false.
     */
    inline bool hasGender () const;

    /**
     * Returns the value of the member "Gender".
     *
     * Some additional information about the speaker.
     *
     * @return The value of the field "Gender"
     */
    inline T_e8_VoiceGender getGender () const;

    /**
     * Sets the value of the member "Gender".
     *
     * Some additional information about the speaker.
     *
     * @param Gender The value which will be set
     */
    inline void setGender (T_e8_VoiceGender Gender_);

    // API of field "SupportInfo"

    static const int kSupportInfo = 3;

    /**
     * Clears the field "SupportInfo".
     *
     * The field will be set to its default value. The hasSupportInfo()
     * method will return false.
     */
    inline void clearSupportInfo();

    /**
     * Checks whether the field "SupportInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupportInfo()). Otherwise it will return false.
     */
    inline bool hasSupportInfo () const;

    /**
     * Returns the value of the member "SupportInfo".
     *
     * Speech support of the speaker.
     *
     * @return The value of the field "SupportInfo"
     */
    inline T_e8_SpeechSupportInfoType getSupportInfo () const;

    /**
     * Sets the value of the member "SupportInfo".
     *
     * Speech support of the speaker.
     *
     * @param SupportInfo The value which will be set
     */
    inline void setSupportInfo (T_e8_SpeechSupportInfoType SupportInfo_);

    static const T_SpeakerInfoType &getDefaultInstance();

private:

    inline void set_has_LanguageID ();

    inline void clear_has_LanguageID ();

    inline void set_has_Speaker ();

    inline void clear_has_Speaker ();

    inline void set_has_Gender ();

    inline void clear_has_Gender ();

    inline void set_has_SupportInfo ();

    inline void clear_has_SupportInfo ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::sds_sds2hmi_common_types::T_SDSLanguageID _LanguageID;

    ::std::string _Speaker;

    T_e8_VoiceGender _Gender;

    T_e8_SpeechSupportInfoType _SupportInfo;

};

/**
 * contains the domain ID and device ID.
 */
class T_DynamicCtxStatus {
public:

    /**
     * Default constructor
     */
    inline  T_DynamicCtxStatus ();

    /**
     * Copy constructor
     */
    inline  T_DynamicCtxStatus (const T_DynamicCtxStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_DynamicCtxStatus (::sds_sds2hmi_common_types::T_e8_Domain DomainID_, uint32 DeviceID_);

    /**
     * Destructor
     */
    inline  ~T_DynamicCtxStatus();

    /**
     * Assignment operator
     */
    inline T_DynamicCtxStatus& operator = (const T_DynamicCtxStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DynamicCtxStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DynamicCtxStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DynamicCtxStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DynamicCtxStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DomainID"

    static const int kDomainID = 0;

    /**
     * Clears the field "DomainID".
     *
     * The field will be set to its default value. The hasDomainID()
     * method will return false.
     */
    inline void clearDomainID();

    /**
     * Checks whether the field "DomainID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDomainID()). Otherwise it will return false.
     */
    inline bool hasDomainID () const;

    /**
     * Returns the value of the member "DomainID".
     *
     * the domain ID
     *
     * @return The value of the field "DomainID"
     */
    inline ::sds_sds2hmi_common_types::T_e8_Domain getDomainID () const;

    /**
     * Sets the value of the member "DomainID".
     *
     * the domain ID
     *
     * @param DomainID The value which will be set
     */
    inline void setDomainID (::sds_sds2hmi_common_types::T_e8_Domain DomainID_);

    // API of field "DeviceID"

    static const int kDeviceID = 1;

    /**
     * Clears the field "DeviceID".
     *
     * The field will be set to its default value. The hasDeviceID()
     * method will return false.
     */
    inline void clearDeviceID();

    /**
     * Checks whether the field "DeviceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceID()). Otherwise it will return false.
     */
    inline bool hasDeviceID () const;

    /**
     * Returns the value of the member "DeviceID".
     *
     * the device ID
     *
     * @return The value of the field "DeviceID"
     */
    inline uint32 getDeviceID () const;

    /**
     * Sets the value of the member "DeviceID".
     *
     * the device ID
     *
     * @param DeviceID The value which will be set
     */
    inline void setDeviceID (uint32 DeviceID_);

    static const T_DynamicCtxStatus &getDefaultInstance();

private:

    inline void set_has_DomainID ();

    inline void clear_has_DomainID ();

    inline void set_has_DeviceID ();

    inline void clear_has_DeviceID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sds_sds2hmi_common_types::T_e8_Domain _DomainID;

    uint32 _DeviceID;

};

/**
 * contains the domain and device id specific context file.
 */
class T_DynamicDataContextMetaFile {
public:

    /**
     * Default constructor
     */
    inline  T_DynamicDataContextMetaFile ();

    /**
     * Copy constructor
     */
    inline  T_DynamicDataContextMetaFile (const T_DynamicDataContextMetaFile &rhs);

    /**
     * All fields constructor
     */
    inline  T_DynamicDataContextMetaFile (const T_DynamicCtxStatus& DomainDeviceID_, const ::std::string& DeviceMetaFile_);

    /**
     * Destructor
     */
    inline  ~T_DynamicDataContextMetaFile();

    /**
     * Assignment operator
     */
    inline T_DynamicDataContextMetaFile& operator = (const T_DynamicDataContextMetaFile& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DynamicDataContextMetaFile& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DynamicDataContextMetaFile& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DynamicDataContextMetaFile& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DynamicDataContextMetaFile& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DomainDeviceID"

    static const int kDomainDeviceID = 0;

    /**
     * Clears the field "DomainDeviceID".
     *
     * The field will be set to its default value. The hasDomainDeviceID()
     * method will return false.
     */
    inline void clearDomainDeviceID();

    /**
     * Checks whether the field "DomainDeviceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDomainDeviceID()). Otherwise it will return false.
     */
    inline bool hasDomainDeviceID () const;

    /**
     * Returns the value of the member "DomainDeviceID".
     *
     * the domain and device ID
     *
     * @return The value of the field "DomainDeviceID"
     */
    inline const T_DynamicCtxStatus& getDomainDeviceID () const;

    /**
     * Retrieves the value of the field "DomainDeviceID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DomainDeviceID".
     */
    inline T_DynamicCtxStatus& getDomainDeviceIDMutable ();

    /**
     * Sets the value of the member "DomainDeviceID".
     *
     * the domain and device ID
     *
     * @param DomainDeviceID The value which will be set
     */
    inline void setDomainDeviceID (const T_DynamicCtxStatus& DomainDeviceID_);

    // API of field "DeviceMetaFile"

    static const int kDeviceMetaFile = 1;

    /**
     * Clears the field "DeviceMetaFile".
     *
     * The field will be set to its default value. The hasDeviceMetaFile()
     * method will return false.
     */
    inline void clearDeviceMetaFile();

    /**
     * Checks whether the field "DeviceMetaFile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceMetaFile()). Otherwise it will return false.
     */
    inline bool hasDeviceMetaFile () const;

    /**
     * Returns the value of the member "DeviceMetaFile".
     *
     * The meta file for the requested domain and device which contains all informations needed by the Recognizer.
     *
     * @return The value of the field "DeviceMetaFile"
     */
    inline const ::std::string& getDeviceMetaFile () const;

    /**
     * Retrieves the value of the field "DeviceMetaFile" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceMetaFile".
     */
    inline ::std::string& getDeviceMetaFileMutable ();

    /**
     * Sets the value of the member "DeviceMetaFile".
     *
     * The meta file for the requested domain and device which contains all informations needed by the Recognizer.
     *
     * @param DeviceMetaFile The value which will be set
     */
    inline void setDeviceMetaFile (const ::std::string& DeviceMetaFile_);

    /**
     * Sets the value of the member "DeviceMetaFile".
     *
     * The meta file for the requested domain and device which contains all informations needed by the Recognizer.
     *
     * @param DeviceMetaFile The value which will be set
     */
    inline void setDeviceMetaFile (const char* DeviceMetaFile_);

    /**
     * Sets the value of the member "DeviceMetaFile".
     *
     * The meta file for the requested domain and device which contains all informations needed by the Recognizer.
     *
     * @param DeviceMetaFile The value which will be set
     */
    inline void setDeviceMetaFile (const char* value, size_t size);

    static const T_DynamicDataContextMetaFile &getDefaultInstance();

private:

    inline void set_has_DomainDeviceID ();

    inline void clear_has_DomainDeviceID ();

    inline void set_has_DeviceMetaFile ();

    inline void clear_has_DeviceMetaFile ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_DynamicCtxStatus _DomainDeviceID;

    ::std::string _DeviceMetaFile;

};

/**
 * contains the city index and a boolean indicated the availability of streets inside the respective city.
 */
class T_CityWithStreets {
public:

    /**
     * Default constructor
     */
    inline  T_CityWithStreets ();

    /**
     * Copy constructor
     */
    inline  T_CityWithStreets (const T_CityWithStreets &rhs);

    /**
     * All fields constructor
     */
    inline  T_CityWithStreets (uint32 CityID_, bool StreetAvailability_);

    /**
     * Destructor
     */
    inline  ~T_CityWithStreets();

    /**
     * Assignment operator
     */
    inline T_CityWithStreets& operator = (const T_CityWithStreets& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CityWithStreets& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CityWithStreets& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CityWithStreets& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CityWithStreets& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CityID"

    static const int kCityID = 0;

    /**
     * Clears the field "CityID".
     *
     * The field will be set to its default value. The hasCityID()
     * method will return false.
     */
    inline void clearCityID();

    /**
     * Checks whether the field "CityID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCityID()). Otherwise it will return false.
     */
    inline bool hasCityID () const;

    /**
     * Returns the value of the member "CityID".
     *
     * the index of city
     *
     * @return The value of the field "CityID"
     */
    inline uint32 getCityID () const;

    /**
     * Sets the value of the member "CityID".
     *
     * the index of city
     *
     * @param CityID The value which will be set
     */
    inline void setCityID (uint32 CityID_);

    // API of field "StreetAvailability"

    static const int kStreetAvailability = 1;

    /**
     * Clears the field "StreetAvailability".
     *
     * The field will be set to its default value. The hasStreetAvailability()
     * method will return false.
     */
    inline void clearStreetAvailability();

    /**
     * Checks whether the field "StreetAvailability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStreetAvailability()). Otherwise it will return false.
     */
    inline bool hasStreetAvailability () const;

    /**
     * Returns the value of the member "StreetAvailability".
     *
     * True, if city has streets.otherwise false.
     *
     * @return The value of the field "StreetAvailability"
     */
    inline bool getStreetAvailability () const;

    /**
     * Sets the value of the member "StreetAvailability".
     *
     * True, if city has streets.otherwise false.
     *
     * @param StreetAvailability The value which will be set
     */
    inline void setStreetAvailability (bool StreetAvailability_);

    static const T_CityWithStreets &getDefaultInstance();

private:

    inline void set_has_CityID ();

    inline void clear_has_CityID ();

    inline void set_has_StreetAvailability ();

    inline void clear_has_StreetAvailability ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _CityID;

    bool _StreetAvailability;

};

/**
 * contains the word and the respective phoneme.
 */
class T_WordWithPhoneme {
public:

    /**
     * Default constructor
     */
    inline  T_WordWithPhoneme ();

    /**
     * Copy constructor
     */
    inline  T_WordWithPhoneme (const T_WordWithPhoneme &rhs);

    /**
     * All fields constructor
     */
    inline  T_WordWithPhoneme (const ::std::string& Word_, const ::std::string& PhonemeFound_);

    /**
     * Destructor
     */
    inline  ~T_WordWithPhoneme();

    /**
     * Assignment operator
     */
    inline T_WordWithPhoneme& operator = (const T_WordWithPhoneme& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_WordWithPhoneme& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_WordWithPhoneme& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_WordWithPhoneme& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_WordWithPhoneme& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Word"

    static const int kWord = 0;

    /**
     * Clears the field "Word".
     *
     * The field will be set to its default value. The hasWord()
     * method will return false.
     */
    inline void clearWord();

    /**
     * Checks whether the field "Word" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWord()). Otherwise it will return false.
     */
    inline bool hasWord () const;

    /**
     * Returns the value of the member "Word".
     *
     * the input word
     *
     * @return The value of the field "Word"
     */
    inline const ::std::string& getWord () const;

    /**
     * Retrieves the value of the field "Word" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Word".
     */
    inline ::std::string& getWordMutable ();

    /**
     * Sets the value of the member "Word".
     *
     * the input word
     *
     * @param Word The value which will be set
     */
    inline void setWord (const ::std::string& Word_);

    /**
     * Sets the value of the member "Word".
     *
     * the input word
     *
     * @param Word The value which will be set
     */
    inline void setWord (const char* Word_);

    /**
     * Sets the value of the member "Word".
     *
     * the input word
     *
     * @param Word The value which will be set
     */
    inline void setWord (const char* value, size_t size);

    // API of field "PhonemeFound"

    static const int kPhonemeFound = 1;

    /**
     * Clears the field "PhonemeFound".
     *
     * The field will be set to its default value. The hasPhonemeFound()
     * method will return false.
     */
    inline void clearPhonemeFound();

    /**
     * Checks whether the field "PhonemeFound" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonemeFound()). Otherwise it will return false.
     */
    inline bool hasPhonemeFound () const;

    /**
     * Returns the value of the member "PhonemeFound".
     *
     * the found phoneme. It could be empty string if there is no phoneme available.
     *
     * @return The value of the field "PhonemeFound"
     */
    inline const ::std::string& getPhonemeFound () const;

    /**
     * Retrieves the value of the field "PhonemeFound" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhonemeFound".
     */
    inline ::std::string& getPhonemeFoundMutable ();

    /**
     * Sets the value of the member "PhonemeFound".
     *
     * the found phoneme. It could be empty string if there is no phoneme available.
     *
     * @param PhonemeFound The value which will be set
     */
    inline void setPhonemeFound (const ::std::string& PhonemeFound_);

    /**
     * Sets the value of the member "PhonemeFound".
     *
     * the found phoneme. It could be empty string if there is no phoneme available.
     *
     * @param PhonemeFound The value which will be set
     */
    inline void setPhonemeFound (const char* PhonemeFound_);

    /**
     * Sets the value of the member "PhonemeFound".
     *
     * the found phoneme. It could be empty string if there is no phoneme available.
     *
     * @param PhonemeFound The value which will be set
     */
    inline void setPhonemeFound (const char* value, size_t size);

    static const T_WordWithPhoneme &getDefaultInstance();

private:

    inline void set_has_Word ();

    inline void clear_has_Word ();

    inline void set_has_PhonemeFound ();

    inline void clear_has_PhonemeFound ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _Word;

    ::std::string _PhonemeFound;

};

/**
 * contains file path and related section name in SDB.
 */
class T_VcData {
public:

    /**
     * Default constructor
     */
    inline  T_VcData ();

    /**
     * Copy constructor
     */
    inline  T_VcData (const T_VcData &rhs);

    /**
     * All fields constructor
     */
    inline  T_VcData (const ::std::string& Section_, const ::std::string& FilePath_);

    /**
     * Destructor
     */
    inline  ~T_VcData();

    /**
     * Assignment operator
     */
    inline T_VcData& operator = (const T_VcData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_VcData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_VcData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_VcData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_VcData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Section"

    static const int kSection = 0;

    /**
     * Clears the field "Section".
     *
     * The field will be set to its default value. The hasSection()
     * method will return false.
     */
    inline void clearSection();

    /**
     * Checks whether the field "Section" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSection()). Otherwise it will return false.
     */
    inline bool hasSection () const;

    /**
     * Returns the value of the member "Section".
     *
     * the name of section where the vc config data resides.
     *
     * @return The value of the field "Section"
     */
    inline const ::std::string& getSection () const;

    /**
     * Retrieves the value of the field "Section" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Section".
     */
    inline ::std::string& getSectionMutable ();

    /**
     * Sets the value of the member "Section".
     *
     * the name of section where the vc config data resides.
     *
     * @param Section The value which will be set
     */
    inline void setSection (const ::std::string& Section_);

    /**
     * Sets the value of the member "Section".
     *
     * the name of section where the vc config data resides.
     *
     * @param Section The value which will be set
     */
    inline void setSection (const char* Section_);

    /**
     * Sets the value of the member "Section".
     *
     * the name of section where the vc config data resides.
     *
     * @param Section The value which will be set
     */
    inline void setSection (const char* value, size_t size);

    // API of field "FilePath"

    static const int kFilePath = 1;

    /**
     * Clears the field "FilePath".
     *
     * The field will be set to its default value. The hasFilePath()
     * method will return false.
     */
    inline void clearFilePath();

    /**
     * Checks whether the field "FilePath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilePath()). Otherwise it will return false.
     */
    inline bool hasFilePath () const;

    /**
     * Returns the value of the member "FilePath".
     *
     * location of file.
     *
     * @return The value of the field "FilePath"
     */
    inline const ::std::string& getFilePath () const;

    /**
     * Retrieves the value of the field "FilePath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FilePath".
     */
    inline ::std::string& getFilePathMutable ();

    /**
     * Sets the value of the member "FilePath".
     *
     * location of file.
     *
     * @param FilePath The value which will be set
     */
    inline void setFilePath (const ::std::string& FilePath_);

    /**
     * Sets the value of the member "FilePath".
     *
     * location of file.
     *
     * @param FilePath The value which will be set
     */
    inline void setFilePath (const char* FilePath_);

    /**
     * Sets the value of the member "FilePath".
     *
     * location of file.
     *
     * @param FilePath The value which will be set
     */
    inline void setFilePath (const char* value, size_t size);

    static const T_VcData &getDefaultInstance();

private:

    inline void set_has_Section ();

    inline void clear_has_Section ();

    inline void set_has_FilePath ();

    inline void clear_has_FilePath ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _Section;

    ::std::string _FilePath;

};

/**
 * Structure to inform the Recognizer about the locations of the saved context data. The data will transfered by shared memory.
 */
class T_BlobData {
public:

    /**
     * Default constructor
     */
    inline  T_BlobData ();

    /**
     * Copy constructor
     */
    inline  T_BlobData (const T_BlobData &rhs);

    /**
     * All fields constructor
     */
    inline  T_BlobData (uint16 URId_, const ::std::string& FileLocation_, uint32 FileSize_);

    /**
     * Destructor
     */
    inline  ~T_BlobData();

    /**
     * Assignment operator
     */
    inline T_BlobData& operator = (const T_BlobData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BlobData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BlobData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BlobData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BlobData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "URId"

    static const int kURId = 0;

    /**
     * Clears the field "URId".
     *
     * The field will be set to its default value. The hasURId()
     * method will return false.
     */
    inline void clearURId();

    /**
     * Checks whether the field "URId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setURId()). Otherwise it will return false.
     */
    inline bool hasURId () const;

    /**
     * Returns the value of the member "URId".
     *
     * the id of update region which the context concernes.
     *
     * @return The value of the field "URId"
     */
    inline uint16 getURId () const;

    /**
     * Sets the value of the member "URId".
     *
     * the id of update region which the context concernes.
     *
     * @param URId The value which will be set
     */
    inline void setURId (uint16 URId_);

    // API of field "FileLocation"

    static const int kFileLocation = 1;

    /**
     * Clears the field "FileLocation".
     *
     * The field will be set to its default value. The hasFileLocation()
     * method will return false.
     */
    inline void clearFileLocation();

    /**
     * Checks whether the field "FileLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFileLocation()). Otherwise it will return false.
     */
    inline bool hasFileLocation () const;

    /**
     * Returns the value of the member "FileLocation".
     *
     * Location of the saved context data in the shared memory.
     *
     * @return The value of the field "FileLocation"
     */
    inline const ::std::string& getFileLocation () const;

    /**
     * Retrieves the value of the field "FileLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FileLocation".
     */
    inline ::std::string& getFileLocationMutable ();

    /**
     * Sets the value of the member "FileLocation".
     *
     * Location of the saved context data in the shared memory.
     *
     * @param FileLocation The value which will be set
     */
    inline void setFileLocation (const ::std::string& FileLocation_);

    /**
     * Sets the value of the member "FileLocation".
     *
     * Location of the saved context data in the shared memory.
     *
     * @param FileLocation The value which will be set
     */
    inline void setFileLocation (const char* FileLocation_);

    /**
     * Sets the value of the member "FileLocation".
     *
     * Location of the saved context data in the shared memory.
     *
     * @param FileLocation The value which will be set
     */
    inline void setFileLocation (const char* value, size_t size);

    // API of field "FileSize"

    static const int kFileSize = 2;

    /**
     * Clears the field "FileSize".
     *
     * The field will be set to its default value. The hasFileSize()
     * method will return false.
     */
    inline void clearFileSize();

    /**
     * Checks whether the field "FileSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFileSize()). Otherwise it will return false.
     */
    inline bool hasFileSize () const;

    /**
     * Returns the value of the member "FileSize".
     *
     * Size of the transmitted shared memory in Bytes In GEN3 maxi. of shared memory is 138MB.
     *
     * @return The value of the field "FileSize"
     */
    inline uint32 getFileSize () const;

    /**
     * Sets the value of the member "FileSize".
     *
     * Size of the transmitted shared memory in Bytes In GEN3 maxi. of shared memory is 138MB.
     *
     * @param FileSize The value which will be set
     */
    inline void setFileSize (uint32 FileSize_);

    static const T_BlobData &getDefaultInstance();

private:

    inline void set_has_URId ();

    inline void clear_has_URId ();

    inline void set_has_FileLocation ();

    inline void clear_has_FileLocation ();

    inline void set_has_FileSize ();

    inline void clear_has_FileSize ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _URId;

    ::std::string _FileLocation;

    uint32 _FileSize;

};

inline  T_AvailableLanguage::T_AvailableLanguage ()  :
    _LanguageID (),
    _StorageDevice (::sds_speechdp_fi_types::T_e8_StorageDevice__PermanentStorageDevice)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AvailableLanguage::T_AvailableLanguage (const T_AvailableLanguage &rhs)  :
    _LanguageID (),
    _StorageDevice (::sds_speechdp_fi_types::T_e8_StorageDevice__PermanentStorageDevice)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AvailableLanguage::T_AvailableLanguage (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_, T_e8_StorageDevice StorageDevice_)  :
    _LanguageID (LanguageID_),
    _StorageDevice (StorageDevice_)
{
    #ifndef NDEBUG
    if (!(T_e8_StorageDevice_IsValid(StorageDevice_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StorageDevice_, "T_e8_StorageDevice", "StorageDevice", "T_AvailableLanguage");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AvailableLanguage::~T_AvailableLanguage() {
}

inline T_AvailableLanguage& T_AvailableLanguage::operator = (const T_AvailableLanguage& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLanguageID()) {
            setLanguageID(rhs.getLanguageID());
        } else {
            clearLanguageID();
        }
        if (rhs.hasStorageDevice()) {
            setStorageDevice(rhs.getStorageDevice());
        } else {
            clearStorageDevice();
        }
    }
    return *this;
}

inline bool T_AvailableLanguage::operator == (const T_AvailableLanguage& rhs) const {
    return (((!hasLanguageID() && !rhs.hasLanguageID()) || getLanguageID() == rhs.getLanguageID()) &&
        ((!hasStorageDevice() && !rhs.hasStorageDevice()) || getStorageDevice() == rhs.getStorageDevice()));
}

inline bool T_AvailableLanguage::operator != (const T_AvailableLanguage& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AvailableLanguage::operator < (const T_AvailableLanguage& rhs) const {
    if (hasLanguageID() || rhs.hasLanguageID()) {
        if (getLanguageID() < rhs.getLanguageID()) return true;
        if (getLanguageID() > rhs.getLanguageID()) return false;
    }
    if (hasStorageDevice() || rhs.hasStorageDevice()) {
        if ((uint32)getStorageDevice() < (uint32)rhs.getStorageDevice()) return true;
        if ((uint32)getStorageDevice() > (uint32)rhs.getStorageDevice()) return false;
    }
    return false;
}

inline bool T_AvailableLanguage::operator > (const T_AvailableLanguage& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AvailableLanguage::clear() {
    clearLanguageID();
    clearStorageDevice();
}

inline void T_AvailableLanguage::clearLanguageID() {
    if (hasLanguageID()) {
         clear_has_LanguageID();
        _LanguageID.clear();
     }
}

inline bool T_AvailableLanguage::hasLanguageID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_sds2hmi_common_types::T_SDSLanguageID& T_AvailableLanguage::getLanguageID () const {
    return _LanguageID;
}

inline ::sds_sds2hmi_common_types::T_SDSLanguageID& T_AvailableLanguage::getLanguageIDMutable () {
    set_has_LanguageID();
    return _LanguageID;
}

inline void T_AvailableLanguage::setLanguageID (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_) {
    set_has_LanguageID();
    this->_LanguageID = LanguageID_;
}

inline void T_AvailableLanguage::clearStorageDevice() {
    if (hasStorageDevice()) {
         clear_has_StorageDevice();
        _StorageDevice = ::sds_speechdp_fi_types::T_e8_StorageDevice__PermanentStorageDevice;
     }
}

inline bool T_AvailableLanguage::hasStorageDevice () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_StorageDevice T_AvailableLanguage::getStorageDevice () const {
    return _StorageDevice;
}

inline void T_AvailableLanguage::setStorageDevice (T_e8_StorageDevice StorageDevice_) {
    #ifndef NDEBUG
    if (!(T_e8_StorageDevice_IsValid(StorageDevice_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StorageDevice_, "T_e8_StorageDevice", "StorageDevice", "T_AvailableLanguage");
    }
    #endif
    set_has_StorageDevice();
    this->_StorageDevice = StorageDevice_;
}

inline void T_AvailableLanguage::set_has_LanguageID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AvailableLanguage::clear_has_LanguageID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AvailableLanguage::set_has_StorageDevice () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AvailableLanguage::clear_has_StorageDevice () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_VoiceType::T_VoiceType ()  :
    _LanguageID (),
    _VoiceName (),
    _VoiceGender (::sds_speechdp_fi_types::T_e8_VoiceGender__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_VoiceType::T_VoiceType (const T_VoiceType &rhs)  :
    _LanguageID (),
    _VoiceName (),
    _VoiceGender (::sds_speechdp_fi_types::T_e8_VoiceGender__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_VoiceType::T_VoiceType (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_, const ::std::string& VoiceName_, T_e8_VoiceGender VoiceGender_)  :
    _LanguageID (LanguageID_),
    _VoiceName (VoiceName_),
    _VoiceGender (VoiceGender_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VoiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_VoiceGender_IsValid(VoiceGender_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoiceGender_, "T_e8_VoiceGender", "VoiceGender", "T_VoiceType");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_VoiceType::~T_VoiceType() {
}

inline T_VoiceType& T_VoiceType::operator = (const T_VoiceType& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLanguageID()) {
            setLanguageID(rhs.getLanguageID());
        } else {
            clearLanguageID();
        }
        if (rhs.hasVoiceName()) {
            setVoiceName(rhs.getVoiceName());
        } else {
            clearVoiceName();
        }
        if (rhs.hasVoiceGender()) {
            setVoiceGender(rhs.getVoiceGender());
        } else {
            clearVoiceGender();
        }
    }
    return *this;
}

inline bool T_VoiceType::operator == (const T_VoiceType& rhs) const {
    return (((!hasLanguageID() && !rhs.hasLanguageID()) || getLanguageID() == rhs.getLanguageID()) &&
        ((!hasVoiceName() && !rhs.hasVoiceName()) || getVoiceName() == rhs.getVoiceName()) &&
        ((!hasVoiceGender() && !rhs.hasVoiceGender()) || getVoiceGender() == rhs.getVoiceGender()));
}

inline bool T_VoiceType::operator != (const T_VoiceType& rhs) const {
    return ! (*this == rhs);
}

inline bool T_VoiceType::operator < (const T_VoiceType& rhs) const {
    if (hasLanguageID() || rhs.hasLanguageID()) {
        if (getLanguageID() < rhs.getLanguageID()) return true;
        if (getLanguageID() > rhs.getLanguageID()) return false;
    }
    if (hasVoiceName() || rhs.hasVoiceName()) {
        if (getVoiceName() < rhs.getVoiceName()) return true;
        if (getVoiceName() > rhs.getVoiceName()) return false;
    }
    if (hasVoiceGender() || rhs.hasVoiceGender()) {
        if ((uint32)getVoiceGender() < (uint32)rhs.getVoiceGender()) return true;
        if ((uint32)getVoiceGender() > (uint32)rhs.getVoiceGender()) return false;
    }
    return false;
}

inline bool T_VoiceType::operator > (const T_VoiceType& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_VoiceType::clear() {
    clearLanguageID();
    clearVoiceName();
    clearVoiceGender();
}

inline void T_VoiceType::clearLanguageID() {
    if (hasLanguageID()) {
         clear_has_LanguageID();
        _LanguageID.clear();
     }
}

inline bool T_VoiceType::hasLanguageID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_sds2hmi_common_types::T_SDSLanguageID& T_VoiceType::getLanguageID () const {
    return _LanguageID;
}

inline ::sds_sds2hmi_common_types::T_SDSLanguageID& T_VoiceType::getLanguageIDMutable () {
    set_has_LanguageID();
    return _LanguageID;
}

inline void T_VoiceType::setLanguageID (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_) {
    set_has_LanguageID();
    this->_LanguageID = LanguageID_;
}

inline void T_VoiceType::clearVoiceName() {
    if (hasVoiceName()) {
         clear_has_VoiceName();
        _VoiceName.clear();
     }
}

inline bool T_VoiceType::hasVoiceName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_VoiceType::getVoiceName () const {
    return _VoiceName;
}

inline ::std::string& T_VoiceType::getVoiceNameMutable () {
    set_has_VoiceName();
    return _VoiceName;
}

inline void T_VoiceType::setVoiceName (const ::std::string& VoiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VoiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VoiceName();
    this->_VoiceName = VoiceName_;
}

inline void T_VoiceType::setVoiceName (const char* VoiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (VoiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VoiceName();
    this->_VoiceName.assign(VoiceName_);
}

inline void T_VoiceType::setVoiceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_VoiceName();
    this->_VoiceName.assign(value, size);
}

inline void T_VoiceType::clearVoiceGender() {
    if (hasVoiceGender()) {
         clear_has_VoiceGender();
        _VoiceGender = ::sds_speechdp_fi_types::T_e8_VoiceGender__Unknown;
     }
}

inline bool T_VoiceType::hasVoiceGender () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_VoiceGender T_VoiceType::getVoiceGender () const {
    return _VoiceGender;
}

inline void T_VoiceType::setVoiceGender (T_e8_VoiceGender VoiceGender_) {
    #ifndef NDEBUG
    if (!(T_e8_VoiceGender_IsValid(VoiceGender_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoiceGender_, "T_e8_VoiceGender", "VoiceGender", "T_VoiceType");
    }
    #endif
    set_has_VoiceGender();
    this->_VoiceGender = VoiceGender_;
}

inline void T_VoiceType::set_has_LanguageID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_VoiceType::clear_has_LanguageID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_VoiceType::set_has_VoiceName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_VoiceType::clear_has_VoiceName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_VoiceType::set_has_VoiceGender () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_VoiceType::clear_has_VoiceGender () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_VoiceDescription::T_VoiceDescription ()  :
    _VoiceType (),
    _StorageDevice (::sds_speechdp_fi_types::T_e8_StorageDevice__PermanentStorageDevice)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_VoiceDescription::T_VoiceDescription (const T_VoiceDescription &rhs)  :
    _VoiceType (),
    _StorageDevice (::sds_speechdp_fi_types::T_e8_StorageDevice__PermanentStorageDevice)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_VoiceDescription::T_VoiceDescription (const T_VoiceType& VoiceType_, T_e8_StorageDevice StorageDevice_)  :
    _VoiceType (VoiceType_),
    _StorageDevice (StorageDevice_)
{
    #ifndef NDEBUG
    if (!(T_e8_StorageDevice_IsValid(StorageDevice_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StorageDevice_, "T_e8_StorageDevice", "StorageDevice", "T_VoiceDescription");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_VoiceDescription::~T_VoiceDescription() {
}

inline T_VoiceDescription& T_VoiceDescription::operator = (const T_VoiceDescription& rhs) {
    if( this != &rhs ) {
        if (rhs.hasVoiceType()) {
            setVoiceType(rhs.getVoiceType());
        } else {
            clearVoiceType();
        }
        if (rhs.hasStorageDevice()) {
            setStorageDevice(rhs.getStorageDevice());
        } else {
            clearStorageDevice();
        }
    }
    return *this;
}

inline bool T_VoiceDescription::operator == (const T_VoiceDescription& rhs) const {
    return (((!hasVoiceType() && !rhs.hasVoiceType()) || getVoiceType() == rhs.getVoiceType()) &&
        ((!hasStorageDevice() && !rhs.hasStorageDevice()) || getStorageDevice() == rhs.getStorageDevice()));
}

inline bool T_VoiceDescription::operator != (const T_VoiceDescription& rhs) const {
    return ! (*this == rhs);
}

inline bool T_VoiceDescription::operator < (const T_VoiceDescription& rhs) const {
    if (hasVoiceType() || rhs.hasVoiceType()) {
        if (getVoiceType() < rhs.getVoiceType()) return true;
        if (getVoiceType() > rhs.getVoiceType()) return false;
    }
    if (hasStorageDevice() || rhs.hasStorageDevice()) {
        if ((uint32)getStorageDevice() < (uint32)rhs.getStorageDevice()) return true;
        if ((uint32)getStorageDevice() > (uint32)rhs.getStorageDevice()) return false;
    }
    return false;
}

inline bool T_VoiceDescription::operator > (const T_VoiceDescription& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_VoiceDescription::clear() {
    clearVoiceType();
    clearStorageDevice();
}

inline void T_VoiceDescription::clearVoiceType() {
    if (hasVoiceType()) {
         clear_has_VoiceType();
        _VoiceType.clear();
     }
}

inline bool T_VoiceDescription::hasVoiceType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_VoiceType& T_VoiceDescription::getVoiceType () const {
    return _VoiceType;
}

inline T_VoiceType& T_VoiceDescription::getVoiceTypeMutable () {
    set_has_VoiceType();
    return _VoiceType;
}

inline void T_VoiceDescription::setVoiceType (const T_VoiceType& VoiceType_) {
    set_has_VoiceType();
    this->_VoiceType = VoiceType_;
}

inline void T_VoiceDescription::clearStorageDevice() {
    if (hasStorageDevice()) {
         clear_has_StorageDevice();
        _StorageDevice = ::sds_speechdp_fi_types::T_e8_StorageDevice__PermanentStorageDevice;
     }
}

inline bool T_VoiceDescription::hasStorageDevice () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_StorageDevice T_VoiceDescription::getStorageDevice () const {
    return _StorageDevice;
}

inline void T_VoiceDescription::setStorageDevice (T_e8_StorageDevice StorageDevice_) {
    #ifndef NDEBUG
    if (!(T_e8_StorageDevice_IsValid(StorageDevice_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StorageDevice_, "T_e8_StorageDevice", "StorageDevice", "T_VoiceDescription");
    }
    #endif
    set_has_StorageDevice();
    this->_StorageDevice = StorageDevice_;
}

inline void T_VoiceDescription::set_has_VoiceType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_VoiceDescription::clear_has_VoiceType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_VoiceDescription::set_has_StorageDevice () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_VoiceDescription::clear_has_StorageDevice () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_DictionaryGroup::T_DictionaryGroup ()  :
    _DictFileName (),
    _NumNames (0u),
    _Name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DictionaryGroup::T_DictionaryGroup (const T_DictionaryGroup &rhs)  :
    _DictFileName (),
    _NumNames (0u),
    _Name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DictionaryGroup::T_DictionaryGroup (const ::std::string& DictFileName_, uint16 NumNames_, const ::std::vector< ::std::string >& Name_)  :
    _DictFileName (DictFileName_),
    _NumNames (NumNames_),
    _Name (Name_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DictFileName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DictionaryGroup::~T_DictionaryGroup() {
}

inline T_DictionaryGroup& T_DictionaryGroup::operator = (const T_DictionaryGroup& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDictFileName()) {
            setDictFileName(rhs.getDictFileName());
        } else {
            clearDictFileName();
        }
        if (rhs.hasNumNames()) {
            setNumNames(rhs.getNumNames());
        } else {
            clearNumNames();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
    }
    return *this;
}

inline bool T_DictionaryGroup::operator == (const T_DictionaryGroup& rhs) const {
    return (((!hasDictFileName() && !rhs.hasDictFileName()) || getDictFileName() == rhs.getDictFileName()) &&
        ((!hasNumNames() && !rhs.hasNumNames()) || getNumNames() == rhs.getNumNames()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()));
}

inline bool T_DictionaryGroup::operator != (const T_DictionaryGroup& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DictionaryGroup::operator < (const T_DictionaryGroup& rhs) const {
    if (hasDictFileName() || rhs.hasDictFileName()) {
        if (getDictFileName() < rhs.getDictFileName()) return true;
        if (getDictFileName() > rhs.getDictFileName()) return false;
    }
    if (hasNumNames() || rhs.hasNumNames()) {
        if (getNumNames() < rhs.getNumNames()) return true;
        if (getNumNames() > rhs.getNumNames()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    return false;
}

inline bool T_DictionaryGroup::operator > (const T_DictionaryGroup& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DictionaryGroup::clear() {
    clearDictFileName();
    clearNumNames();
    clearName();
}

inline void T_DictionaryGroup::clearDictFileName() {
    if (hasDictFileName()) {
         clear_has_DictFileName();
        _DictFileName.clear();
     }
}

inline bool T_DictionaryGroup::hasDictFileName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_DictionaryGroup::getDictFileName () const {
    return _DictFileName;
}

inline ::std::string& T_DictionaryGroup::getDictFileNameMutable () {
    set_has_DictFileName();
    return _DictFileName;
}

inline void T_DictionaryGroup::setDictFileName (const ::std::string& DictFileName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DictFileName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DictFileName();
    this->_DictFileName = DictFileName_;
}

inline void T_DictionaryGroup::setDictFileName (const char* DictFileName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DictFileName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DictFileName();
    this->_DictFileName.assign(DictFileName_);
}

inline void T_DictionaryGroup::setDictFileName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DictFileName();
    this->_DictFileName.assign(value, size);
}

inline void T_DictionaryGroup::clearNumNames() {
    if (hasNumNames()) {
         clear_has_NumNames();
        _NumNames = 0u;
     }
}

inline bool T_DictionaryGroup::hasNumNames () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_DictionaryGroup::getNumNames () const {
    return _NumNames;
}

inline void T_DictionaryGroup::setNumNames (uint16 NumNames_) {
    set_has_NumNames();
    this->_NumNames = NumNames_;
}

inline void T_DictionaryGroup::clearName() {
    if (hasName()) {
         clear_has_Name();
        _Name.clear();
     }
}

inline bool T_DictionaryGroup::hasName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< ::std::string >& T_DictionaryGroup::getName () const {
    return _Name;
}

inline ::std::vector< ::std::string >& T_DictionaryGroup::getNameMutable () {
    set_has_Name();
    return _Name;
}

inline void T_DictionaryGroup::setName (const ::std::vector< ::std::string >& Name_) {
    set_has_Name();
    this->_Name = Name_;
}

inline void T_DictionaryGroup::set_has_DictFileName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DictionaryGroup::clear_has_DictFileName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DictionaryGroup::set_has_NumNames () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DictionaryGroup::clear_has_NumNames () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DictionaryGroup::set_has_Name () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DictionaryGroup::clear_has_Name () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_AvailableCountry::T_AvailableCountry ()  :
    _LanguageID (),
    _CountryCode (::fi_types::T_e16_ISOCountryCode__ISO_ALPHA_3_UNDEFINED),
    _State (),
    _MajorVersion_SBS_NAV (0u),
    _MinorVersion_SBS_NAV (0u),
    _BoschCreateDate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AvailableCountry::T_AvailableCountry (const T_AvailableCountry &rhs)  :
    _LanguageID (),
    _CountryCode (::fi_types::T_e16_ISOCountryCode__ISO_ALPHA_3_UNDEFINED),
    _State (),
    _MajorVersion_SBS_NAV (0u),
    _MinorVersion_SBS_NAV (0u),
    _BoschCreateDate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AvailableCountry::T_AvailableCountry (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_, ::fi_types::T_e16_ISOCountryCode CountryCode_, const ::std::string& State_, uint16 MajorVersion_SBS_NAV_, uint16 MinorVersion_SBS_NAV_, const ::std::string& BoschCreateDate_)  :
    _LanguageID (LanguageID_),
    _CountryCode (CountryCode_),
    _State (State_),
    _MajorVersion_SBS_NAV (MajorVersion_SBS_NAV_),
    _MinorVersion_SBS_NAV (MinorVersion_SBS_NAV_),
    _BoschCreateDate (BoschCreateDate_)
{
    #ifndef NDEBUG
    if (!(::fi_types::T_e16_ISOCountryCode_IsValid(CountryCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", CountryCode_, "T_e16_ISOCountryCode", "CountryCode", "T_AvailableCountry");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BoschCreateDate_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AvailableCountry::~T_AvailableCountry() {
}

inline T_AvailableCountry& T_AvailableCountry::operator = (const T_AvailableCountry& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLanguageID()) {
            setLanguageID(rhs.getLanguageID());
        } else {
            clearLanguageID();
        }
        if (rhs.hasCountryCode()) {
            setCountryCode(rhs.getCountryCode());
        } else {
            clearCountryCode();
        }
        if (rhs.hasState()) {
            setState(rhs.getState());
        } else {
            clearState();
        }
        if (rhs.hasMajorVersion_SBS_NAV()) {
            setMajorVersion_SBS_NAV(rhs.getMajorVersion_SBS_NAV());
        } else {
            clearMajorVersion_SBS_NAV();
        }
        if (rhs.hasMinorVersion_SBS_NAV()) {
            setMinorVersion_SBS_NAV(rhs.getMinorVersion_SBS_NAV());
        } else {
            clearMinorVersion_SBS_NAV();
        }
        if (rhs.hasBoschCreateDate()) {
            setBoschCreateDate(rhs.getBoschCreateDate());
        } else {
            clearBoschCreateDate();
        }
    }
    return *this;
}

inline bool T_AvailableCountry::operator == (const T_AvailableCountry& rhs) const {
    return (((!hasLanguageID() && !rhs.hasLanguageID()) || getLanguageID() == rhs.getLanguageID()) &&
        ((!hasCountryCode() && !rhs.hasCountryCode()) || getCountryCode() == rhs.getCountryCode()) &&
        ((!hasState() && !rhs.hasState()) || getState() == rhs.getState()) &&
        ((!hasMajorVersion_SBS_NAV() && !rhs.hasMajorVersion_SBS_NAV()) || getMajorVersion_SBS_NAV() == rhs.getMajorVersion_SBS_NAV()) &&
        ((!hasMinorVersion_SBS_NAV() && !rhs.hasMinorVersion_SBS_NAV()) || getMinorVersion_SBS_NAV() == rhs.getMinorVersion_SBS_NAV()) &&
        ((!hasBoschCreateDate() && !rhs.hasBoschCreateDate()) || getBoschCreateDate() == rhs.getBoschCreateDate()));
}

inline bool T_AvailableCountry::operator != (const T_AvailableCountry& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AvailableCountry::operator < (const T_AvailableCountry& rhs) const {
    if (hasLanguageID() || rhs.hasLanguageID()) {
        if (getLanguageID() < rhs.getLanguageID()) return true;
        if (getLanguageID() > rhs.getLanguageID()) return false;
    }
    if (hasCountryCode() || rhs.hasCountryCode()) {
        if ((uint32)getCountryCode() < (uint32)rhs.getCountryCode()) return true;
        if ((uint32)getCountryCode() > (uint32)rhs.getCountryCode()) return false;
    }
    if (hasState() || rhs.hasState()) {
        if (getState() < rhs.getState()) return true;
        if (getState() > rhs.getState()) return false;
    }
    if (hasMajorVersion_SBS_NAV() || rhs.hasMajorVersion_SBS_NAV()) {
        if (getMajorVersion_SBS_NAV() < rhs.getMajorVersion_SBS_NAV()) return true;
        if (getMajorVersion_SBS_NAV() > rhs.getMajorVersion_SBS_NAV()) return false;
    }
    if (hasMinorVersion_SBS_NAV() || rhs.hasMinorVersion_SBS_NAV()) {
        if (getMinorVersion_SBS_NAV() < rhs.getMinorVersion_SBS_NAV()) return true;
        if (getMinorVersion_SBS_NAV() > rhs.getMinorVersion_SBS_NAV()) return false;
    }
    if (hasBoschCreateDate() || rhs.hasBoschCreateDate()) {
        if (getBoschCreateDate() < rhs.getBoschCreateDate()) return true;
        if (getBoschCreateDate() > rhs.getBoschCreateDate()) return false;
    }
    return false;
}

inline bool T_AvailableCountry::operator > (const T_AvailableCountry& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AvailableCountry::clear() {
    clearLanguageID();
    clearCountryCode();
    clearState();
    clearMajorVersion_SBS_NAV();
    clearMinorVersion_SBS_NAV();
    clearBoschCreateDate();
}

inline void T_AvailableCountry::clearLanguageID() {
    if (hasLanguageID()) {
         clear_has_LanguageID();
        _LanguageID.clear();
     }
}

inline bool T_AvailableCountry::hasLanguageID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_sds2hmi_common_types::T_SDSLanguageID& T_AvailableCountry::getLanguageID () const {
    return _LanguageID;
}

inline ::sds_sds2hmi_common_types::T_SDSLanguageID& T_AvailableCountry::getLanguageIDMutable () {
    set_has_LanguageID();
    return _LanguageID;
}

inline void T_AvailableCountry::setLanguageID (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_) {
    set_has_LanguageID();
    this->_LanguageID = LanguageID_;
}

inline void T_AvailableCountry::clearCountryCode() {
    if (hasCountryCode()) {
         clear_has_CountryCode();
        _CountryCode = ::fi_types::T_e16_ISOCountryCode__ISO_ALPHA_3_UNDEFINED;
     }
}

inline bool T_AvailableCountry::hasCountryCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::fi_types::T_e16_ISOCountryCode T_AvailableCountry::getCountryCode () const {
    return _CountryCode;
}

inline void T_AvailableCountry::setCountryCode (::fi_types::T_e16_ISOCountryCode CountryCode_) {
    #ifndef NDEBUG
    if (!(::fi_types::T_e16_ISOCountryCode_IsValid(CountryCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", CountryCode_, "T_e16_ISOCountryCode", "CountryCode", "T_AvailableCountry");
    }
    #endif
    set_has_CountryCode();
    this->_CountryCode = CountryCode_;
}

inline void T_AvailableCountry::clearState() {
    if (hasState()) {
         clear_has_State();
        _State.clear();
     }
}

inline bool T_AvailableCountry::hasState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_AvailableCountry::getState () const {
    return _State;
}

inline ::std::string& T_AvailableCountry::getStateMutable () {
    set_has_State();
    return _State;
}

inline void T_AvailableCountry::setState (const ::std::string& State_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State = State_;
}

inline void T_AvailableCountry::setState (const char* State_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State.assign(State_);
}

inline void T_AvailableCountry::setState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State.assign(value, size);
}

inline void T_AvailableCountry::clearMajorVersion_SBS_NAV() {
    if (hasMajorVersion_SBS_NAV()) {
         clear_has_MajorVersion_SBS_NAV();
        _MajorVersion_SBS_NAV = 0u;
     }
}

inline bool T_AvailableCountry::hasMajorVersion_SBS_NAV () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_AvailableCountry::getMajorVersion_SBS_NAV () const {
    return _MajorVersion_SBS_NAV;
}

inline void T_AvailableCountry::setMajorVersion_SBS_NAV (uint16 MajorVersion_SBS_NAV_) {
    set_has_MajorVersion_SBS_NAV();
    this->_MajorVersion_SBS_NAV = MajorVersion_SBS_NAV_;
}

inline void T_AvailableCountry::clearMinorVersion_SBS_NAV() {
    if (hasMinorVersion_SBS_NAV()) {
         clear_has_MinorVersion_SBS_NAV();
        _MinorVersion_SBS_NAV = 0u;
     }
}

inline bool T_AvailableCountry::hasMinorVersion_SBS_NAV () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 T_AvailableCountry::getMinorVersion_SBS_NAV () const {
    return _MinorVersion_SBS_NAV;
}

inline void T_AvailableCountry::setMinorVersion_SBS_NAV (uint16 MinorVersion_SBS_NAV_) {
    set_has_MinorVersion_SBS_NAV();
    this->_MinorVersion_SBS_NAV = MinorVersion_SBS_NAV_;
}

inline void T_AvailableCountry::clearBoschCreateDate() {
    if (hasBoschCreateDate()) {
         clear_has_BoschCreateDate();
        _BoschCreateDate.clear();
     }
}

inline bool T_AvailableCountry::hasBoschCreateDate () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_AvailableCountry::getBoschCreateDate () const {
    return _BoschCreateDate;
}

inline ::std::string& T_AvailableCountry::getBoschCreateDateMutable () {
    set_has_BoschCreateDate();
    return _BoschCreateDate;
}

inline void T_AvailableCountry::setBoschCreateDate (const ::std::string& BoschCreateDate_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BoschCreateDate_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BoschCreateDate();
    this->_BoschCreateDate = BoschCreateDate_;
}

inline void T_AvailableCountry::setBoschCreateDate (const char* BoschCreateDate_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BoschCreateDate_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BoschCreateDate();
    this->_BoschCreateDate.assign(BoschCreateDate_);
}

inline void T_AvailableCountry::setBoschCreateDate (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BoschCreateDate();
    this->_BoschCreateDate.assign(value, size);
}

inline void T_AvailableCountry::set_has_LanguageID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AvailableCountry::clear_has_LanguageID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AvailableCountry::set_has_CountryCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AvailableCountry::clear_has_CountryCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AvailableCountry::set_has_State () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AvailableCountry::clear_has_State () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_AvailableCountry::set_has_MajorVersion_SBS_NAV () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_AvailableCountry::clear_has_MajorVersion_SBS_NAV () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_AvailableCountry::set_has_MinorVersion_SBS_NAV () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_AvailableCountry::clear_has_MinorVersion_SBS_NAV () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_AvailableCountry::set_has_BoschCreateDate () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_AvailableCountry::clear_has_BoschCreateDate () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_TTSTunningFile::T_TTSTunningFile ()  :
    _Type (::sds_speechdp_fi_types::T_e8_TTSFileType__Unknown),
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TTSTunningFile::T_TTSTunningFile (const T_TTSTunningFile &rhs)  :
    _Type (::sds_speechdp_fi_types::T_e8_TTSFileType__Unknown),
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TTSTunningFile::T_TTSTunningFile (T_e8_TTSFileType Type_, const ::std::string& Filename_)  :
    _Type (Type_),
    _Filename (Filename_)
{
    #ifndef NDEBUG
    if (!(T_e8_TTSFileType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8_TTSFileType", "Type", "T_TTSTunningFile");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TTSTunningFile::~T_TTSTunningFile() {
}

inline T_TTSTunningFile& T_TTSTunningFile::operator = (const T_TTSTunningFile& rhs) {
    if( this != &rhs ) {
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
        if (rhs.hasFilename()) {
            setFilename(rhs.getFilename());
        } else {
            clearFilename();
        }
    }
    return *this;
}

inline bool T_TTSTunningFile::operator == (const T_TTSTunningFile& rhs) const {
    return (((!hasType() && !rhs.hasType()) || getType() == rhs.getType()) &&
        ((!hasFilename() && !rhs.hasFilename()) || getFilename() == rhs.getFilename()));
}

inline bool T_TTSTunningFile::operator != (const T_TTSTunningFile& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TTSTunningFile::operator < (const T_TTSTunningFile& rhs) const {
    if (hasType() || rhs.hasType()) {
        if ((uint32)getType() < (uint32)rhs.getType()) return true;
        if ((uint32)getType() > (uint32)rhs.getType()) return false;
    }
    if (hasFilename() || rhs.hasFilename()) {
        if (getFilename() < rhs.getFilename()) return true;
        if (getFilename() > rhs.getFilename()) return false;
    }
    return false;
}

inline bool T_TTSTunningFile::operator > (const T_TTSTunningFile& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TTSTunningFile::clear() {
    clearType();
    clearFilename();
}

inline void T_TTSTunningFile::clearType() {
    if (hasType()) {
         clear_has_Type();
        _Type = ::sds_speechdp_fi_types::T_e8_TTSFileType__Unknown;
     }
}

inline bool T_TTSTunningFile::hasType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TTSFileType T_TTSTunningFile::getType () const {
    return _Type;
}

inline void T_TTSTunningFile::setType (T_e8_TTSFileType Type_) {
    #ifndef NDEBUG
    if (!(T_e8_TTSFileType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8_TTSFileType", "Type", "T_TTSTunningFile");
    }
    #endif
    set_has_Type();
    this->_Type = Type_;
}

inline void T_TTSTunningFile::clearFilename() {
    if (hasFilename()) {
         clear_has_Filename();
        _Filename.clear();
     }
}

inline bool T_TTSTunningFile::hasFilename () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_TTSTunningFile::getFilename () const {
    return _Filename;
}

inline ::std::string& T_TTSTunningFile::getFilenameMutable () {
    set_has_Filename();
    return _Filename;
}

inline void T_TTSTunningFile::setFilename (const ::std::string& Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename = Filename_;
}

inline void T_TTSTunningFile::setFilename (const char* Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(Filename_);
}

inline void T_TTSTunningFile::setFilename (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(value, size);
}

inline void T_TTSTunningFile::set_has_Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TTSTunningFile::clear_has_Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TTSTunningFile::set_has_Filename () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TTSTunningFile::clear_has_Filename () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TTSVoiceFile::T_TTSVoiceFile ()  :
    _Filename (),
    _LogicalName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TTSVoiceFile::T_TTSVoiceFile (const T_TTSVoiceFile &rhs)  :
    _Filename (),
    _LogicalName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TTSVoiceFile::T_TTSVoiceFile (const ::std::string& Filename_, const ::std::string& LogicalName_)  :
    _Filename (Filename_),
    _LogicalName (LogicalName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LogicalName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TTSVoiceFile::~T_TTSVoiceFile() {
}

inline T_TTSVoiceFile& T_TTSVoiceFile::operator = (const T_TTSVoiceFile& rhs) {
    if( this != &rhs ) {
        if (rhs.hasFilename()) {
            setFilename(rhs.getFilename());
        } else {
            clearFilename();
        }
        if (rhs.hasLogicalName()) {
            setLogicalName(rhs.getLogicalName());
        } else {
            clearLogicalName();
        }
    }
    return *this;
}

inline bool T_TTSVoiceFile::operator == (const T_TTSVoiceFile& rhs) const {
    return (((!hasFilename() && !rhs.hasFilename()) || getFilename() == rhs.getFilename()) &&
        ((!hasLogicalName() && !rhs.hasLogicalName()) || getLogicalName() == rhs.getLogicalName()));
}

inline bool T_TTSVoiceFile::operator != (const T_TTSVoiceFile& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TTSVoiceFile::operator < (const T_TTSVoiceFile& rhs) const {
    if (hasFilename() || rhs.hasFilename()) {
        if (getFilename() < rhs.getFilename()) return true;
        if (getFilename() > rhs.getFilename()) return false;
    }
    if (hasLogicalName() || rhs.hasLogicalName()) {
        if (getLogicalName() < rhs.getLogicalName()) return true;
        if (getLogicalName() > rhs.getLogicalName()) return false;
    }
    return false;
}

inline bool T_TTSVoiceFile::operator > (const T_TTSVoiceFile& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TTSVoiceFile::clear() {
    clearFilename();
    clearLogicalName();
}

inline void T_TTSVoiceFile::clearFilename() {
    if (hasFilename()) {
         clear_has_Filename();
        _Filename.clear();
     }
}

inline bool T_TTSVoiceFile::hasFilename () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_TTSVoiceFile::getFilename () const {
    return _Filename;
}

inline ::std::string& T_TTSVoiceFile::getFilenameMutable () {
    set_has_Filename();
    return _Filename;
}

inline void T_TTSVoiceFile::setFilename (const ::std::string& Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename = Filename_;
}

inline void T_TTSVoiceFile::setFilename (const char* Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(Filename_);
}

inline void T_TTSVoiceFile::setFilename (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(value, size);
}

inline void T_TTSVoiceFile::clearLogicalName() {
    if (hasLogicalName()) {
         clear_has_LogicalName();
        _LogicalName.clear();
     }
}

inline bool T_TTSVoiceFile::hasLogicalName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_TTSVoiceFile::getLogicalName () const {
    return _LogicalName;
}

inline ::std::string& T_TTSVoiceFile::getLogicalNameMutable () {
    set_has_LogicalName();
    return _LogicalName;
}

inline void T_TTSVoiceFile::setLogicalName (const ::std::string& LogicalName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LogicalName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LogicalName();
    this->_LogicalName = LogicalName_;
}

inline void T_TTSVoiceFile::setLogicalName (const char* LogicalName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LogicalName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LogicalName();
    this->_LogicalName.assign(LogicalName_);
}

inline void T_TTSVoiceFile::setLogicalName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LogicalName();
    this->_LogicalName.assign(value, size);
}

inline void T_TTSVoiceFile::set_has_Filename () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TTSVoiceFile::clear_has_Filename () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TTSVoiceFile::set_has_LogicalName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TTSVoiceFile::clear_has_LogicalName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_ContextFile::T_ContextFile ()  :
    _Type (::sds_speechdp_fi_types::T_e8_ContextFileType__Unknown),
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ContextFile::T_ContextFile (const T_ContextFile &rhs)  :
    _Type (::sds_speechdp_fi_types::T_e8_ContextFileType__Unknown),
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ContextFile::T_ContextFile (T_e8_ContextFileType Type_, const ::std::string& Filename_)  :
    _Type (Type_),
    _Filename (Filename_)
{
    #ifndef NDEBUG
    if (!(T_e8_ContextFileType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8_ContextFileType", "Type", "T_ContextFile");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ContextFile::~T_ContextFile() {
}

inline T_ContextFile& T_ContextFile::operator = (const T_ContextFile& rhs) {
    if( this != &rhs ) {
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
        if (rhs.hasFilename()) {
            setFilename(rhs.getFilename());
        } else {
            clearFilename();
        }
    }
    return *this;
}

inline bool T_ContextFile::operator == (const T_ContextFile& rhs) const {
    return (((!hasType() && !rhs.hasType()) || getType() == rhs.getType()) &&
        ((!hasFilename() && !rhs.hasFilename()) || getFilename() == rhs.getFilename()));
}

inline bool T_ContextFile::operator != (const T_ContextFile& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ContextFile::operator < (const T_ContextFile& rhs) const {
    if (hasType() || rhs.hasType()) {
        if ((uint32)getType() < (uint32)rhs.getType()) return true;
        if ((uint32)getType() > (uint32)rhs.getType()) return false;
    }
    if (hasFilename() || rhs.hasFilename()) {
        if (getFilename() < rhs.getFilename()) return true;
        if (getFilename() > rhs.getFilename()) return false;
    }
    return false;
}

inline bool T_ContextFile::operator > (const T_ContextFile& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ContextFile::clear() {
    clearType();
    clearFilename();
}

inline void T_ContextFile::clearType() {
    if (hasType()) {
         clear_has_Type();
        _Type = ::sds_speechdp_fi_types::T_e8_ContextFileType__Unknown;
     }
}

inline bool T_ContextFile::hasType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_ContextFileType T_ContextFile::getType () const {
    return _Type;
}

inline void T_ContextFile::setType (T_e8_ContextFileType Type_) {
    #ifndef NDEBUG
    if (!(T_e8_ContextFileType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8_ContextFileType", "Type", "T_ContextFile");
    }
    #endif
    set_has_Type();
    this->_Type = Type_;
}

inline void T_ContextFile::clearFilename() {
    if (hasFilename()) {
         clear_has_Filename();
        _Filename.clear();
     }
}

inline bool T_ContextFile::hasFilename () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_ContextFile::getFilename () const {
    return _Filename;
}

inline ::std::string& T_ContextFile::getFilenameMutable () {
    set_has_Filename();
    return _Filename;
}

inline void T_ContextFile::setFilename (const ::std::string& Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename = Filename_;
}

inline void T_ContextFile::setFilename (const char* Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(Filename_);
}

inline void T_ContextFile::setFilename (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(value, size);
}

inline void T_ContextFile::set_has_Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ContextFile::clear_has_Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ContextFile::set_has_Filename () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ContextFile::clear_has_Filename () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SemBufferFile::T_SemBufferFile ()  :
    _Type (::sds_speechdp_fi_types::T_e8_SemBufferFileType__Unknown),
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SemBufferFile::T_SemBufferFile (const T_SemBufferFile &rhs)  :
    _Type (::sds_speechdp_fi_types::T_e8_SemBufferFileType__Unknown),
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SemBufferFile::T_SemBufferFile (T_e8_SemBufferFileType Type_, const ::std::string& Filename_)  :
    _Type (Type_),
    _Filename (Filename_)
{
    #ifndef NDEBUG
    if (!(T_e8_SemBufferFileType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8_SemBufferFileType", "Type", "T_SemBufferFile");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SemBufferFile::~T_SemBufferFile() {
}

inline T_SemBufferFile& T_SemBufferFile::operator = (const T_SemBufferFile& rhs) {
    if( this != &rhs ) {
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
        if (rhs.hasFilename()) {
            setFilename(rhs.getFilename());
        } else {
            clearFilename();
        }
    }
    return *this;
}

inline bool T_SemBufferFile::operator == (const T_SemBufferFile& rhs) const {
    return (((!hasType() && !rhs.hasType()) || getType() == rhs.getType()) &&
        ((!hasFilename() && !rhs.hasFilename()) || getFilename() == rhs.getFilename()));
}

inline bool T_SemBufferFile::operator != (const T_SemBufferFile& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SemBufferFile::operator < (const T_SemBufferFile& rhs) const {
    if (hasType() || rhs.hasType()) {
        if ((uint32)getType() < (uint32)rhs.getType()) return true;
        if ((uint32)getType() > (uint32)rhs.getType()) return false;
    }
    if (hasFilename() || rhs.hasFilename()) {
        if (getFilename() < rhs.getFilename()) return true;
        if (getFilename() > rhs.getFilename()) return false;
    }
    return false;
}

inline bool T_SemBufferFile::operator > (const T_SemBufferFile& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SemBufferFile::clear() {
    clearType();
    clearFilename();
}

inline void T_SemBufferFile::clearType() {
    if (hasType()) {
         clear_has_Type();
        _Type = ::sds_speechdp_fi_types::T_e8_SemBufferFileType__Unknown;
     }
}

inline bool T_SemBufferFile::hasType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_SemBufferFileType T_SemBufferFile::getType () const {
    return _Type;
}

inline void T_SemBufferFile::setType (T_e8_SemBufferFileType Type_) {
    #ifndef NDEBUG
    if (!(T_e8_SemBufferFileType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8_SemBufferFileType", "Type", "T_SemBufferFile");
    }
    #endif
    set_has_Type();
    this->_Type = Type_;
}

inline void T_SemBufferFile::clearFilename() {
    if (hasFilename()) {
         clear_has_Filename();
        _Filename.clear();
     }
}

inline bool T_SemBufferFile::hasFilename () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_SemBufferFile::getFilename () const {
    return _Filename;
}

inline ::std::string& T_SemBufferFile::getFilenameMutable () {
    set_has_Filename();
    return _Filename;
}

inline void T_SemBufferFile::setFilename (const ::std::string& Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename = Filename_;
}

inline void T_SemBufferFile::setFilename (const char* Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(Filename_);
}

inline void T_SemBufferFile::setFilename (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(value, size);
}

inline void T_SemBufferFile::set_has_Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SemBufferFile::clear_has_Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SemBufferFile::set_has_Filename () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SemBufferFile::clear_has_Filename () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_ConnectDevice::T_ConnectDevice ()  :
    _DeviceID (0u),
    _Timestamp (0u),
    _GnDbTimestamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ConnectDevice::T_ConnectDevice (const T_ConnectDevice &rhs)  :
    _DeviceID (0u),
    _Timestamp (0u),
    _GnDbTimestamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ConnectDevice::T_ConnectDevice (uint32 DeviceID_, uint32 Timestamp_, uint32 GnDbTimestamp_)  :
    _DeviceID (DeviceID_),
    _Timestamp (Timestamp_),
    _GnDbTimestamp (GnDbTimestamp_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ConnectDevice::~T_ConnectDevice() {
}

inline T_ConnectDevice& T_ConnectDevice::operator = (const T_ConnectDevice& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDeviceID()) {
            setDeviceID(rhs.getDeviceID());
        } else {
            clearDeviceID();
        }
        if (rhs.hasTimestamp()) {
            setTimestamp(rhs.getTimestamp());
        } else {
            clearTimestamp();
        }
        if (rhs.hasGnDbTimestamp()) {
            setGnDbTimestamp(rhs.getGnDbTimestamp());
        } else {
            clearGnDbTimestamp();
        }
    }
    return *this;
}

inline bool T_ConnectDevice::operator == (const T_ConnectDevice& rhs) const {
    return (((!hasDeviceID() && !rhs.hasDeviceID()) || getDeviceID() == rhs.getDeviceID()) &&
        ((!hasTimestamp() && !rhs.hasTimestamp()) || getTimestamp() == rhs.getTimestamp()) &&
        ((!hasGnDbTimestamp() && !rhs.hasGnDbTimestamp()) || getGnDbTimestamp() == rhs.getGnDbTimestamp()));
}

inline bool T_ConnectDevice::operator != (const T_ConnectDevice& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ConnectDevice::operator < (const T_ConnectDevice& rhs) const {
    if (hasDeviceID() || rhs.hasDeviceID()) {
        if (getDeviceID() < rhs.getDeviceID()) return true;
        if (getDeviceID() > rhs.getDeviceID()) return false;
    }
    if (hasTimestamp() || rhs.hasTimestamp()) {
        if (getTimestamp() < rhs.getTimestamp()) return true;
        if (getTimestamp() > rhs.getTimestamp()) return false;
    }
    if (hasGnDbTimestamp() || rhs.hasGnDbTimestamp()) {
        if (getGnDbTimestamp() < rhs.getGnDbTimestamp()) return true;
        if (getGnDbTimestamp() > rhs.getGnDbTimestamp()) return false;
    }
    return false;
}

inline bool T_ConnectDevice::operator > (const T_ConnectDevice& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ConnectDevice::clear() {
    clearDeviceID();
    clearTimestamp();
    clearGnDbTimestamp();
}

inline void T_ConnectDevice::clearDeviceID() {
    if (hasDeviceID()) {
         clear_has_DeviceID();
        _DeviceID = 0u;
     }
}

inline bool T_ConnectDevice::hasDeviceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_ConnectDevice::getDeviceID () const {
    return _DeviceID;
}

inline void T_ConnectDevice::setDeviceID (uint32 DeviceID_) {
    set_has_DeviceID();
    this->_DeviceID = DeviceID_;
}

inline void T_ConnectDevice::clearTimestamp() {
    if (hasTimestamp()) {
         clear_has_Timestamp();
        _Timestamp = 0u;
     }
}

inline bool T_ConnectDevice::hasTimestamp () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_ConnectDevice::getTimestamp () const {
    return _Timestamp;
}

inline void T_ConnectDevice::setTimestamp (uint32 Timestamp_) {
    set_has_Timestamp();
    this->_Timestamp = Timestamp_;
}

inline void T_ConnectDevice::clearGnDbTimestamp() {
    if (hasGnDbTimestamp()) {
         clear_has_GnDbTimestamp();
        _GnDbTimestamp = 0u;
     }
}

inline bool T_ConnectDevice::hasGnDbTimestamp () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_ConnectDevice::getGnDbTimestamp () const {
    return _GnDbTimestamp;
}

inline void T_ConnectDevice::setGnDbTimestamp (uint32 GnDbTimestamp_) {
    set_has_GnDbTimestamp();
    this->_GnDbTimestamp = GnDbTimestamp_;
}

inline void T_ConnectDevice::set_has_DeviceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ConnectDevice::clear_has_DeviceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ConnectDevice::set_has_Timestamp () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ConnectDevice::clear_has_Timestamp () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ConnectDevice::set_has_GnDbTimestamp () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ConnectDevice::clear_has_GnDbTimestamp () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_DynamicContextFile::T_DynamicContextFile ()  :
    _LogicalName (),
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DynamicContextFile::T_DynamicContextFile (const T_DynamicContextFile &rhs)  :
    _LogicalName (),
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DynamicContextFile::T_DynamicContextFile (const ::std::string& LogicalName_, const ::std::string& Filename_)  :
    _LogicalName (LogicalName_),
    _Filename (Filename_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LogicalName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DynamicContextFile::~T_DynamicContextFile() {
}

inline T_DynamicContextFile& T_DynamicContextFile::operator = (const T_DynamicContextFile& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLogicalName()) {
            setLogicalName(rhs.getLogicalName());
        } else {
            clearLogicalName();
        }
        if (rhs.hasFilename()) {
            setFilename(rhs.getFilename());
        } else {
            clearFilename();
        }
    }
    return *this;
}

inline bool T_DynamicContextFile::operator == (const T_DynamicContextFile& rhs) const {
    return (((!hasLogicalName() && !rhs.hasLogicalName()) || getLogicalName() == rhs.getLogicalName()) &&
        ((!hasFilename() && !rhs.hasFilename()) || getFilename() == rhs.getFilename()));
}

inline bool T_DynamicContextFile::operator != (const T_DynamicContextFile& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DynamicContextFile::operator < (const T_DynamicContextFile& rhs) const {
    if (hasLogicalName() || rhs.hasLogicalName()) {
        if (getLogicalName() < rhs.getLogicalName()) return true;
        if (getLogicalName() > rhs.getLogicalName()) return false;
    }
    if (hasFilename() || rhs.hasFilename()) {
        if (getFilename() < rhs.getFilename()) return true;
        if (getFilename() > rhs.getFilename()) return false;
    }
    return false;
}

inline bool T_DynamicContextFile::operator > (const T_DynamicContextFile& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DynamicContextFile::clear() {
    clearLogicalName();
    clearFilename();
}

inline void T_DynamicContextFile::clearLogicalName() {
    if (hasLogicalName()) {
         clear_has_LogicalName();
        _LogicalName.clear();
     }
}

inline bool T_DynamicContextFile::hasLogicalName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_DynamicContextFile::getLogicalName () const {
    return _LogicalName;
}

inline ::std::string& T_DynamicContextFile::getLogicalNameMutable () {
    set_has_LogicalName();
    return _LogicalName;
}

inline void T_DynamicContextFile::setLogicalName (const ::std::string& LogicalName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LogicalName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LogicalName();
    this->_LogicalName = LogicalName_;
}

inline void T_DynamicContextFile::setLogicalName (const char* LogicalName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (LogicalName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LogicalName();
    this->_LogicalName.assign(LogicalName_);
}

inline void T_DynamicContextFile::setLogicalName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_LogicalName();
    this->_LogicalName.assign(value, size);
}

inline void T_DynamicContextFile::clearFilename() {
    if (hasFilename()) {
         clear_has_Filename();
        _Filename.clear();
     }
}

inline bool T_DynamicContextFile::hasFilename () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_DynamicContextFile::getFilename () const {
    return _Filename;
}

inline ::std::string& T_DynamicContextFile::getFilenameMutable () {
    set_has_Filename();
    return _Filename;
}

inline void T_DynamicContextFile::setFilename (const ::std::string& Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename = Filename_;
}

inline void T_DynamicContextFile::setFilename (const char* Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(Filename_);
}

inline void T_DynamicContextFile::setFilename (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(value, size);
}

inline void T_DynamicContextFile::set_has_LogicalName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DynamicContextFile::clear_has_LogicalName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DynamicContextFile::set_has_Filename () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DynamicContextFile::clear_has_Filename () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TranscriptionFile::T_TranscriptionFile ()  :
    _Type (::sds_speechdp_fi_types::T_e8_TranscriptionFileType__UNKNOWN),
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TranscriptionFile::T_TranscriptionFile (const T_TranscriptionFile &rhs)  :
    _Type (::sds_speechdp_fi_types::T_e8_TranscriptionFileType__UNKNOWN),
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TranscriptionFile::T_TranscriptionFile (T_e8_TranscriptionFileType Type_, const ::std::string& Filename_)  :
    _Type (Type_),
    _Filename (Filename_)
{
    #ifndef NDEBUG
    if (!(T_e8_TranscriptionFileType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8_TranscriptionFileType", "Type", "T_TranscriptionFile");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TranscriptionFile::~T_TranscriptionFile() {
}

inline T_TranscriptionFile& T_TranscriptionFile::operator = (const T_TranscriptionFile& rhs) {
    if( this != &rhs ) {
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
        if (rhs.hasFilename()) {
            setFilename(rhs.getFilename());
        } else {
            clearFilename();
        }
    }
    return *this;
}

inline bool T_TranscriptionFile::operator == (const T_TranscriptionFile& rhs) const {
    return (((!hasType() && !rhs.hasType()) || getType() == rhs.getType()) &&
        ((!hasFilename() && !rhs.hasFilename()) || getFilename() == rhs.getFilename()));
}

inline bool T_TranscriptionFile::operator != (const T_TranscriptionFile& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TranscriptionFile::operator < (const T_TranscriptionFile& rhs) const {
    if (hasType() || rhs.hasType()) {
        if ((uint32)getType() < (uint32)rhs.getType()) return true;
        if ((uint32)getType() > (uint32)rhs.getType()) return false;
    }
    if (hasFilename() || rhs.hasFilename()) {
        if (getFilename() < rhs.getFilename()) return true;
        if (getFilename() > rhs.getFilename()) return false;
    }
    return false;
}

inline bool T_TranscriptionFile::operator > (const T_TranscriptionFile& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TranscriptionFile::clear() {
    clearType();
    clearFilename();
}

inline void T_TranscriptionFile::clearType() {
    if (hasType()) {
         clear_has_Type();
        _Type = ::sds_speechdp_fi_types::T_e8_TranscriptionFileType__UNKNOWN;
     }
}

inline bool T_TranscriptionFile::hasType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TranscriptionFileType T_TranscriptionFile::getType () const {
    return _Type;
}

inline void T_TranscriptionFile::setType (T_e8_TranscriptionFileType Type_) {
    #ifndef NDEBUG
    if (!(T_e8_TranscriptionFileType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8_TranscriptionFileType", "Type", "T_TranscriptionFile");
    }
    #endif
    set_has_Type();
    this->_Type = Type_;
}

inline void T_TranscriptionFile::clearFilename() {
    if (hasFilename()) {
         clear_has_Filename();
        _Filename.clear();
     }
}

inline bool T_TranscriptionFile::hasFilename () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_TranscriptionFile::getFilename () const {
    return _Filename;
}

inline ::std::string& T_TranscriptionFile::getFilenameMutable () {
    set_has_Filename();
    return _Filename;
}

inline void T_TranscriptionFile::setFilename (const ::std::string& Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename = Filename_;
}

inline void T_TranscriptionFile::setFilename (const char* Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(Filename_);
}

inline void T_TranscriptionFile::setFilename (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(value, size);
}

inline void T_TranscriptionFile::set_has_Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TranscriptionFile::clear_has_Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TranscriptionFile::set_has_Filename () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TranscriptionFile::clear_has_Filename () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_UserAudioFile::T_UserAudioFile ()  :
    _UserwordID (0u),
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_UserAudioFile::T_UserAudioFile (const T_UserAudioFile &rhs)  :
    _UserwordID (0u),
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_UserAudioFile::T_UserAudioFile (uint32 UserwordID_, const ::std::string& Filename_)  :
    _UserwordID (UserwordID_),
    _Filename (Filename_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_UserAudioFile::~T_UserAudioFile() {
}

inline T_UserAudioFile& T_UserAudioFile::operator = (const T_UserAudioFile& rhs) {
    if( this != &rhs ) {
        if (rhs.hasUserwordID()) {
            setUserwordID(rhs.getUserwordID());
        } else {
            clearUserwordID();
        }
        if (rhs.hasFilename()) {
            setFilename(rhs.getFilename());
        } else {
            clearFilename();
        }
    }
    return *this;
}

inline bool T_UserAudioFile::operator == (const T_UserAudioFile& rhs) const {
    return (((!hasUserwordID() && !rhs.hasUserwordID()) || getUserwordID() == rhs.getUserwordID()) &&
        ((!hasFilename() && !rhs.hasFilename()) || getFilename() == rhs.getFilename()));
}

inline bool T_UserAudioFile::operator != (const T_UserAudioFile& rhs) const {
    return ! (*this == rhs);
}

inline bool T_UserAudioFile::operator < (const T_UserAudioFile& rhs) const {
    if (hasUserwordID() || rhs.hasUserwordID()) {
        if (getUserwordID() < rhs.getUserwordID()) return true;
        if (getUserwordID() > rhs.getUserwordID()) return false;
    }
    if (hasFilename() || rhs.hasFilename()) {
        if (getFilename() < rhs.getFilename()) return true;
        if (getFilename() > rhs.getFilename()) return false;
    }
    return false;
}

inline bool T_UserAudioFile::operator > (const T_UserAudioFile& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_UserAudioFile::clear() {
    clearUserwordID();
    clearFilename();
}

inline void T_UserAudioFile::clearUserwordID() {
    if (hasUserwordID()) {
         clear_has_UserwordID();
        _UserwordID = 0u;
     }
}

inline bool T_UserAudioFile::hasUserwordID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_UserAudioFile::getUserwordID () const {
    return _UserwordID;
}

inline void T_UserAudioFile::setUserwordID (uint32 UserwordID_) {
    set_has_UserwordID();
    this->_UserwordID = UserwordID_;
}

inline void T_UserAudioFile::clearFilename() {
    if (hasFilename()) {
         clear_has_Filename();
        _Filename.clear();
     }
}

inline bool T_UserAudioFile::hasFilename () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_UserAudioFile::getFilename () const {
    return _Filename;
}

inline ::std::string& T_UserAudioFile::getFilenameMutable () {
    set_has_Filename();
    return _Filename;
}

inline void T_UserAudioFile::setFilename (const ::std::string& Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename = Filename_;
}

inline void T_UserAudioFile::setFilename (const char* Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(Filename_);
}

inline void T_UserAudioFile::setFilename (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(value, size);
}

inline void T_UserAudioFile::set_has_UserwordID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_UserAudioFile::clear_has_UserwordID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_UserAudioFile::set_has_Filename () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_UserAudioFile::clear_has_Filename () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SpeakerInfoType::T_SpeakerInfoType ()  :
    _LanguageID (),
    _Speaker (),
    _Gender (::sds_speechdp_fi_types::T_e8_VoiceGender__Unknown),
    _SupportInfo (::sds_speechdp_fi_types::T_e8_SpeechSupportInfoType__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SpeakerInfoType::T_SpeakerInfoType (const T_SpeakerInfoType &rhs)  :
    _LanguageID (),
    _Speaker (),
    _Gender (::sds_speechdp_fi_types::T_e8_VoiceGender__Unknown),
    _SupportInfo (::sds_speechdp_fi_types::T_e8_SpeechSupportInfoType__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SpeakerInfoType::T_SpeakerInfoType (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_, const ::std::string& Speaker_, T_e8_VoiceGender Gender_, T_e8_SpeechSupportInfoType SupportInfo_)  :
    _LanguageID (LanguageID_),
    _Speaker (Speaker_),
    _Gender (Gender_),
    _SupportInfo (SupportInfo_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Speaker_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_VoiceGender_IsValid(Gender_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Gender_, "T_e8_VoiceGender", "Gender", "T_SpeakerInfoType");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SpeechSupportInfoType_IsValid(SupportInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SupportInfo_, "T_e8_SpeechSupportInfoType", "SupportInfo", "T_SpeakerInfoType");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SpeakerInfoType::~T_SpeakerInfoType() {
}

inline T_SpeakerInfoType& T_SpeakerInfoType::operator = (const T_SpeakerInfoType& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLanguageID()) {
            setLanguageID(rhs.getLanguageID());
        } else {
            clearLanguageID();
        }
        if (rhs.hasSpeaker()) {
            setSpeaker(rhs.getSpeaker());
        } else {
            clearSpeaker();
        }
        if (rhs.hasGender()) {
            setGender(rhs.getGender());
        } else {
            clearGender();
        }
        if (rhs.hasSupportInfo()) {
            setSupportInfo(rhs.getSupportInfo());
        } else {
            clearSupportInfo();
        }
    }
    return *this;
}

inline bool T_SpeakerInfoType::operator == (const T_SpeakerInfoType& rhs) const {
    return (((!hasLanguageID() && !rhs.hasLanguageID()) || getLanguageID() == rhs.getLanguageID()) &&
        ((!hasSpeaker() && !rhs.hasSpeaker()) || getSpeaker() == rhs.getSpeaker()) &&
        ((!hasGender() && !rhs.hasGender()) || getGender() == rhs.getGender()) &&
        ((!hasSupportInfo() && !rhs.hasSupportInfo()) || getSupportInfo() == rhs.getSupportInfo()));
}

inline bool T_SpeakerInfoType::operator != (const T_SpeakerInfoType& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SpeakerInfoType::operator < (const T_SpeakerInfoType& rhs) const {
    if (hasLanguageID() || rhs.hasLanguageID()) {
        if (getLanguageID() < rhs.getLanguageID()) return true;
        if (getLanguageID() > rhs.getLanguageID()) return false;
    }
    if (hasSpeaker() || rhs.hasSpeaker()) {
        if (getSpeaker() < rhs.getSpeaker()) return true;
        if (getSpeaker() > rhs.getSpeaker()) return false;
    }
    if (hasGender() || rhs.hasGender()) {
        if ((uint32)getGender() < (uint32)rhs.getGender()) return true;
        if ((uint32)getGender() > (uint32)rhs.getGender()) return false;
    }
    if (hasSupportInfo() || rhs.hasSupportInfo()) {
        if ((uint32)getSupportInfo() < (uint32)rhs.getSupportInfo()) return true;
        if ((uint32)getSupportInfo() > (uint32)rhs.getSupportInfo()) return false;
    }
    return false;
}

inline bool T_SpeakerInfoType::operator > (const T_SpeakerInfoType& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SpeakerInfoType::clear() {
    clearLanguageID();
    clearSpeaker();
    clearGender();
    clearSupportInfo();
}

inline void T_SpeakerInfoType::clearLanguageID() {
    if (hasLanguageID()) {
         clear_has_LanguageID();
        _LanguageID.clear();
     }
}

inline bool T_SpeakerInfoType::hasLanguageID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_sds2hmi_common_types::T_SDSLanguageID& T_SpeakerInfoType::getLanguageID () const {
    return _LanguageID;
}

inline ::sds_sds2hmi_common_types::T_SDSLanguageID& T_SpeakerInfoType::getLanguageIDMutable () {
    set_has_LanguageID();
    return _LanguageID;
}

inline void T_SpeakerInfoType::setLanguageID (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_) {
    set_has_LanguageID();
    this->_LanguageID = LanguageID_;
}

inline void T_SpeakerInfoType::clearSpeaker() {
    if (hasSpeaker()) {
         clear_has_Speaker();
        _Speaker.clear();
     }
}

inline bool T_SpeakerInfoType::hasSpeaker () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_SpeakerInfoType::getSpeaker () const {
    return _Speaker;
}

inline ::std::string& T_SpeakerInfoType::getSpeakerMutable () {
    set_has_Speaker();
    return _Speaker;
}

inline void T_SpeakerInfoType::setSpeaker (const ::std::string& Speaker_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Speaker_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Speaker();
    this->_Speaker = Speaker_;
}

inline void T_SpeakerInfoType::setSpeaker (const char* Speaker_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Speaker_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Speaker();
    this->_Speaker.assign(Speaker_);
}

inline void T_SpeakerInfoType::setSpeaker (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Speaker();
    this->_Speaker.assign(value, size);
}

inline void T_SpeakerInfoType::clearGender() {
    if (hasGender()) {
         clear_has_Gender();
        _Gender = ::sds_speechdp_fi_types::T_e8_VoiceGender__Unknown;
     }
}

inline bool T_SpeakerInfoType::hasGender () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_VoiceGender T_SpeakerInfoType::getGender () const {
    return _Gender;
}

inline void T_SpeakerInfoType::setGender (T_e8_VoiceGender Gender_) {
    #ifndef NDEBUG
    if (!(T_e8_VoiceGender_IsValid(Gender_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Gender_, "T_e8_VoiceGender", "Gender", "T_SpeakerInfoType");
    }
    #endif
    set_has_Gender();
    this->_Gender = Gender_;
}

inline void T_SpeakerInfoType::clearSupportInfo() {
    if (hasSupportInfo()) {
         clear_has_SupportInfo();
        _SupportInfo = ::sds_speechdp_fi_types::T_e8_SpeechSupportInfoType__UNKNOWN;
     }
}

inline bool T_SpeakerInfoType::hasSupportInfo () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_SpeechSupportInfoType T_SpeakerInfoType::getSupportInfo () const {
    return _SupportInfo;
}

inline void T_SpeakerInfoType::setSupportInfo (T_e8_SpeechSupportInfoType SupportInfo_) {
    #ifndef NDEBUG
    if (!(T_e8_SpeechSupportInfoType_IsValid(SupportInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SupportInfo_, "T_e8_SpeechSupportInfoType", "SupportInfo", "T_SpeakerInfoType");
    }
    #endif
    set_has_SupportInfo();
    this->_SupportInfo = SupportInfo_;
}

inline void T_SpeakerInfoType::set_has_LanguageID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SpeakerInfoType::clear_has_LanguageID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SpeakerInfoType::set_has_Speaker () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SpeakerInfoType::clear_has_Speaker () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SpeakerInfoType::set_has_Gender () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SpeakerInfoType::clear_has_Gender () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SpeakerInfoType::set_has_SupportInfo () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SpeakerInfoType::clear_has_SupportInfo () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_DynamicCtxStatus::T_DynamicCtxStatus ()  :
    _DomainID (::sds_sds2hmi_common_types::T_e8_Domain__UNKNOWN),
    _DeviceID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DynamicCtxStatus::T_DynamicCtxStatus (const T_DynamicCtxStatus &rhs)  :
    _DomainID (::sds_sds2hmi_common_types::T_e8_Domain__UNKNOWN),
    _DeviceID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DynamicCtxStatus::T_DynamicCtxStatus (::sds_sds2hmi_common_types::T_e8_Domain DomainID_, uint32 DeviceID_)  :
    _DomainID (DomainID_),
    _DeviceID (DeviceID_)
{
    #ifndef NDEBUG
    if (!(::sds_sds2hmi_common_types::T_e8_Domain_IsValid(DomainID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DomainID_, "T_e8_Domain", "DomainID", "T_DynamicCtxStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DynamicCtxStatus::~T_DynamicCtxStatus() {
}

inline T_DynamicCtxStatus& T_DynamicCtxStatus::operator = (const T_DynamicCtxStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDomainID()) {
            setDomainID(rhs.getDomainID());
        } else {
            clearDomainID();
        }
        if (rhs.hasDeviceID()) {
            setDeviceID(rhs.getDeviceID());
        } else {
            clearDeviceID();
        }
    }
    return *this;
}

inline bool T_DynamicCtxStatus::operator == (const T_DynamicCtxStatus& rhs) const {
    return (((!hasDomainID() && !rhs.hasDomainID()) || getDomainID() == rhs.getDomainID()) &&
        ((!hasDeviceID() && !rhs.hasDeviceID()) || getDeviceID() == rhs.getDeviceID()));
}

inline bool T_DynamicCtxStatus::operator != (const T_DynamicCtxStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DynamicCtxStatus::operator < (const T_DynamicCtxStatus& rhs) const {
    if (hasDomainID() || rhs.hasDomainID()) {
        if ((uint32)getDomainID() < (uint32)rhs.getDomainID()) return true;
        if ((uint32)getDomainID() > (uint32)rhs.getDomainID()) return false;
    }
    if (hasDeviceID() || rhs.hasDeviceID()) {
        if (getDeviceID() < rhs.getDeviceID()) return true;
        if (getDeviceID() > rhs.getDeviceID()) return false;
    }
    return false;
}

inline bool T_DynamicCtxStatus::operator > (const T_DynamicCtxStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DynamicCtxStatus::clear() {
    clearDomainID();
    clearDeviceID();
}

inline void T_DynamicCtxStatus::clearDomainID() {
    if (hasDomainID()) {
         clear_has_DomainID();
        _DomainID = ::sds_sds2hmi_common_types::T_e8_Domain__UNKNOWN;
     }
}

inline bool T_DynamicCtxStatus::hasDomainID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sds_sds2hmi_common_types::T_e8_Domain T_DynamicCtxStatus::getDomainID () const {
    return _DomainID;
}

inline void T_DynamicCtxStatus::setDomainID (::sds_sds2hmi_common_types::T_e8_Domain DomainID_) {
    #ifndef NDEBUG
    if (!(::sds_sds2hmi_common_types::T_e8_Domain_IsValid(DomainID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DomainID_, "T_e8_Domain", "DomainID", "T_DynamicCtxStatus");
    }
    #endif
    set_has_DomainID();
    this->_DomainID = DomainID_;
}

inline void T_DynamicCtxStatus::clearDeviceID() {
    if (hasDeviceID()) {
         clear_has_DeviceID();
        _DeviceID = 0u;
     }
}

inline bool T_DynamicCtxStatus::hasDeviceID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_DynamicCtxStatus::getDeviceID () const {
    return _DeviceID;
}

inline void T_DynamicCtxStatus::setDeviceID (uint32 DeviceID_) {
    set_has_DeviceID();
    this->_DeviceID = DeviceID_;
}

inline void T_DynamicCtxStatus::set_has_DomainID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DynamicCtxStatus::clear_has_DomainID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DynamicCtxStatus::set_has_DeviceID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DynamicCtxStatus::clear_has_DeviceID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_DynamicDataContextMetaFile::T_DynamicDataContextMetaFile ()  :
    _DomainDeviceID (),
    _DeviceMetaFile ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DynamicDataContextMetaFile::T_DynamicDataContextMetaFile (const T_DynamicDataContextMetaFile &rhs)  :
    _DomainDeviceID (),
    _DeviceMetaFile ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DynamicDataContextMetaFile::T_DynamicDataContextMetaFile (const T_DynamicCtxStatus& DomainDeviceID_, const ::std::string& DeviceMetaFile_)  :
    _DomainDeviceID (DomainDeviceID_),
    _DeviceMetaFile (DeviceMetaFile_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceMetaFile_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DynamicDataContextMetaFile::~T_DynamicDataContextMetaFile() {
}

inline T_DynamicDataContextMetaFile& T_DynamicDataContextMetaFile::operator = (const T_DynamicDataContextMetaFile& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDomainDeviceID()) {
            setDomainDeviceID(rhs.getDomainDeviceID());
        } else {
            clearDomainDeviceID();
        }
        if (rhs.hasDeviceMetaFile()) {
            setDeviceMetaFile(rhs.getDeviceMetaFile());
        } else {
            clearDeviceMetaFile();
        }
    }
    return *this;
}

inline bool T_DynamicDataContextMetaFile::operator == (const T_DynamicDataContextMetaFile& rhs) const {
    return (((!hasDomainDeviceID() && !rhs.hasDomainDeviceID()) || getDomainDeviceID() == rhs.getDomainDeviceID()) &&
        ((!hasDeviceMetaFile() && !rhs.hasDeviceMetaFile()) || getDeviceMetaFile() == rhs.getDeviceMetaFile()));
}

inline bool T_DynamicDataContextMetaFile::operator != (const T_DynamicDataContextMetaFile& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DynamicDataContextMetaFile::operator < (const T_DynamicDataContextMetaFile& rhs) const {
    if (hasDomainDeviceID() || rhs.hasDomainDeviceID()) {
        if (getDomainDeviceID() < rhs.getDomainDeviceID()) return true;
        if (getDomainDeviceID() > rhs.getDomainDeviceID()) return false;
    }
    if (hasDeviceMetaFile() || rhs.hasDeviceMetaFile()) {
        if (getDeviceMetaFile() < rhs.getDeviceMetaFile()) return true;
        if (getDeviceMetaFile() > rhs.getDeviceMetaFile()) return false;
    }
    return false;
}

inline bool T_DynamicDataContextMetaFile::operator > (const T_DynamicDataContextMetaFile& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DynamicDataContextMetaFile::clear() {
    clearDomainDeviceID();
    clearDeviceMetaFile();
}

inline void T_DynamicDataContextMetaFile::clearDomainDeviceID() {
    if (hasDomainDeviceID()) {
         clear_has_DomainDeviceID();
        _DomainDeviceID.clear();
     }
}

inline bool T_DynamicDataContextMetaFile::hasDomainDeviceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_DynamicCtxStatus& T_DynamicDataContextMetaFile::getDomainDeviceID () const {
    return _DomainDeviceID;
}

inline T_DynamicCtxStatus& T_DynamicDataContextMetaFile::getDomainDeviceIDMutable () {
    set_has_DomainDeviceID();
    return _DomainDeviceID;
}

inline void T_DynamicDataContextMetaFile::setDomainDeviceID (const T_DynamicCtxStatus& DomainDeviceID_) {
    set_has_DomainDeviceID();
    this->_DomainDeviceID = DomainDeviceID_;
}

inline void T_DynamicDataContextMetaFile::clearDeviceMetaFile() {
    if (hasDeviceMetaFile()) {
         clear_has_DeviceMetaFile();
        _DeviceMetaFile.clear();
     }
}

inline bool T_DynamicDataContextMetaFile::hasDeviceMetaFile () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_DynamicDataContextMetaFile::getDeviceMetaFile () const {
    return _DeviceMetaFile;
}

inline ::std::string& T_DynamicDataContextMetaFile::getDeviceMetaFileMutable () {
    set_has_DeviceMetaFile();
    return _DeviceMetaFile;
}

inline void T_DynamicDataContextMetaFile::setDeviceMetaFile (const ::std::string& DeviceMetaFile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceMetaFile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceMetaFile();
    this->_DeviceMetaFile = DeviceMetaFile_;
}

inline void T_DynamicDataContextMetaFile::setDeviceMetaFile (const char* DeviceMetaFile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceMetaFile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceMetaFile();
    this->_DeviceMetaFile.assign(DeviceMetaFile_);
}

inline void T_DynamicDataContextMetaFile::setDeviceMetaFile (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceMetaFile();
    this->_DeviceMetaFile.assign(value, size);
}

inline void T_DynamicDataContextMetaFile::set_has_DomainDeviceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DynamicDataContextMetaFile::clear_has_DomainDeviceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DynamicDataContextMetaFile::set_has_DeviceMetaFile () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DynamicDataContextMetaFile::clear_has_DeviceMetaFile () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_CityWithStreets::T_CityWithStreets ()  :
    _CityID (0u),
    _StreetAvailability (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CityWithStreets::T_CityWithStreets (const T_CityWithStreets &rhs)  :
    _CityID (0u),
    _StreetAvailability (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CityWithStreets::T_CityWithStreets (uint32 CityID_, bool StreetAvailability_)  :
    _CityID (CityID_),
    _StreetAvailability (StreetAvailability_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CityWithStreets::~T_CityWithStreets() {
}

inline T_CityWithStreets& T_CityWithStreets::operator = (const T_CityWithStreets& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCityID()) {
            setCityID(rhs.getCityID());
        } else {
            clearCityID();
        }
        if (rhs.hasStreetAvailability()) {
            setStreetAvailability(rhs.getStreetAvailability());
        } else {
            clearStreetAvailability();
        }
    }
    return *this;
}

inline bool T_CityWithStreets::operator == (const T_CityWithStreets& rhs) const {
    return (((!hasCityID() && !rhs.hasCityID()) || getCityID() == rhs.getCityID()) &&
        ((!hasStreetAvailability() && !rhs.hasStreetAvailability()) || getStreetAvailability() == rhs.getStreetAvailability()));
}

inline bool T_CityWithStreets::operator != (const T_CityWithStreets& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CityWithStreets::operator < (const T_CityWithStreets& rhs) const {
    if (hasCityID() || rhs.hasCityID()) {
        if (getCityID() < rhs.getCityID()) return true;
        if (getCityID() > rhs.getCityID()) return false;
    }
    if (hasStreetAvailability() || rhs.hasStreetAvailability()) {
        if (getStreetAvailability() < rhs.getStreetAvailability()) return true;
        if (getStreetAvailability() > rhs.getStreetAvailability()) return false;
    }
    return false;
}

inline bool T_CityWithStreets::operator > (const T_CityWithStreets& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CityWithStreets::clear() {
    clearCityID();
    clearStreetAvailability();
}

inline void T_CityWithStreets::clearCityID() {
    if (hasCityID()) {
         clear_has_CityID();
        _CityID = 0u;
     }
}

inline bool T_CityWithStreets::hasCityID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_CityWithStreets::getCityID () const {
    return _CityID;
}

inline void T_CityWithStreets::setCityID (uint32 CityID_) {
    set_has_CityID();
    this->_CityID = CityID_;
}

inline void T_CityWithStreets::clearStreetAvailability() {
    if (hasStreetAvailability()) {
         clear_has_StreetAvailability();
        _StreetAvailability = false;
     }
}

inline bool T_CityWithStreets::hasStreetAvailability () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_CityWithStreets::getStreetAvailability () const {
    return _StreetAvailability;
}

inline void T_CityWithStreets::setStreetAvailability (bool StreetAvailability_) {
    set_has_StreetAvailability();
    this->_StreetAvailability = StreetAvailability_;
}

inline void T_CityWithStreets::set_has_CityID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CityWithStreets::clear_has_CityID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_CityWithStreets::set_has_StreetAvailability () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_CityWithStreets::clear_has_StreetAvailability () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_WordWithPhoneme::T_WordWithPhoneme ()  :
    _Word (),
    _PhonemeFound ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_WordWithPhoneme::T_WordWithPhoneme (const T_WordWithPhoneme &rhs)  :
    _Word (),
    _PhonemeFound ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_WordWithPhoneme::T_WordWithPhoneme (const ::std::string& Word_, const ::std::string& PhonemeFound_)  :
    _Word (Word_),
    _PhonemeFound (PhonemeFound_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Word_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PhonemeFound_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_WordWithPhoneme::~T_WordWithPhoneme() {
}

inline T_WordWithPhoneme& T_WordWithPhoneme::operator = (const T_WordWithPhoneme& rhs) {
    if( this != &rhs ) {
        if (rhs.hasWord()) {
            setWord(rhs.getWord());
        } else {
            clearWord();
        }
        if (rhs.hasPhonemeFound()) {
            setPhonemeFound(rhs.getPhonemeFound());
        } else {
            clearPhonemeFound();
        }
    }
    return *this;
}

inline bool T_WordWithPhoneme::operator == (const T_WordWithPhoneme& rhs) const {
    return (((!hasWord() && !rhs.hasWord()) || getWord() == rhs.getWord()) &&
        ((!hasPhonemeFound() && !rhs.hasPhonemeFound()) || getPhonemeFound() == rhs.getPhonemeFound()));
}

inline bool T_WordWithPhoneme::operator != (const T_WordWithPhoneme& rhs) const {
    return ! (*this == rhs);
}

inline bool T_WordWithPhoneme::operator < (const T_WordWithPhoneme& rhs) const {
    if (hasWord() || rhs.hasWord()) {
        if (getWord() < rhs.getWord()) return true;
        if (getWord() > rhs.getWord()) return false;
    }
    if (hasPhonemeFound() || rhs.hasPhonemeFound()) {
        if (getPhonemeFound() < rhs.getPhonemeFound()) return true;
        if (getPhonemeFound() > rhs.getPhonemeFound()) return false;
    }
    return false;
}

inline bool T_WordWithPhoneme::operator > (const T_WordWithPhoneme& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_WordWithPhoneme::clear() {
    clearWord();
    clearPhonemeFound();
}

inline void T_WordWithPhoneme::clearWord() {
    if (hasWord()) {
         clear_has_Word();
        _Word.clear();
     }
}

inline bool T_WordWithPhoneme::hasWord () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_WordWithPhoneme::getWord () const {
    return _Word;
}

inline ::std::string& T_WordWithPhoneme::getWordMutable () {
    set_has_Word();
    return _Word;
}

inline void T_WordWithPhoneme::setWord (const ::std::string& Word_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Word_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Word();
    this->_Word = Word_;
}

inline void T_WordWithPhoneme::setWord (const char* Word_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Word_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Word();
    this->_Word.assign(Word_);
}

inline void T_WordWithPhoneme::setWord (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Word();
    this->_Word.assign(value, size);
}

inline void T_WordWithPhoneme::clearPhonemeFound() {
    if (hasPhonemeFound()) {
         clear_has_PhonemeFound();
        _PhonemeFound.clear();
     }
}

inline bool T_WordWithPhoneme::hasPhonemeFound () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_WordWithPhoneme::getPhonemeFound () const {
    return _PhonemeFound;
}

inline ::std::string& T_WordWithPhoneme::getPhonemeFoundMutable () {
    set_has_PhonemeFound();
    return _PhonemeFound;
}

inline void T_WordWithPhoneme::setPhonemeFound (const ::std::string& PhonemeFound_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PhonemeFound_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PhonemeFound();
    this->_PhonemeFound = PhonemeFound_;
}

inline void T_WordWithPhoneme::setPhonemeFound (const char* PhonemeFound_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PhonemeFound_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PhonemeFound();
    this->_PhonemeFound.assign(PhonemeFound_);
}

inline void T_WordWithPhoneme::setPhonemeFound (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PhonemeFound();
    this->_PhonemeFound.assign(value, size);
}

inline void T_WordWithPhoneme::set_has_Word () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_WordWithPhoneme::clear_has_Word () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_WordWithPhoneme::set_has_PhonemeFound () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_WordWithPhoneme::clear_has_PhonemeFound () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_VcData::T_VcData ()  :
    _Section (),
    _FilePath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_VcData::T_VcData (const T_VcData &rhs)  :
    _Section (),
    _FilePath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_VcData::T_VcData (const ::std::string& Section_, const ::std::string& FilePath_)  :
    _Section (Section_),
    _FilePath (FilePath_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Section_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FilePath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_VcData::~T_VcData() {
}

inline T_VcData& T_VcData::operator = (const T_VcData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSection()) {
            setSection(rhs.getSection());
        } else {
            clearSection();
        }
        if (rhs.hasFilePath()) {
            setFilePath(rhs.getFilePath());
        } else {
            clearFilePath();
        }
    }
    return *this;
}

inline bool T_VcData::operator == (const T_VcData& rhs) const {
    return (((!hasSection() && !rhs.hasSection()) || getSection() == rhs.getSection()) &&
        ((!hasFilePath() && !rhs.hasFilePath()) || getFilePath() == rhs.getFilePath()));
}

inline bool T_VcData::operator != (const T_VcData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_VcData::operator < (const T_VcData& rhs) const {
    if (hasSection() || rhs.hasSection()) {
        if (getSection() < rhs.getSection()) return true;
        if (getSection() > rhs.getSection()) return false;
    }
    if (hasFilePath() || rhs.hasFilePath()) {
        if (getFilePath() < rhs.getFilePath()) return true;
        if (getFilePath() > rhs.getFilePath()) return false;
    }
    return false;
}

inline bool T_VcData::operator > (const T_VcData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_VcData::clear() {
    clearSection();
    clearFilePath();
}

inline void T_VcData::clearSection() {
    if (hasSection()) {
         clear_has_Section();
        _Section.clear();
     }
}

inline bool T_VcData::hasSection () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_VcData::getSection () const {
    return _Section;
}

inline ::std::string& T_VcData::getSectionMutable () {
    set_has_Section();
    return _Section;
}

inline void T_VcData::setSection (const ::std::string& Section_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Section_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Section();
    this->_Section = Section_;
}

inline void T_VcData::setSection (const char* Section_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Section_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Section();
    this->_Section.assign(Section_);
}

inline void T_VcData::setSection (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Section();
    this->_Section.assign(value, size);
}

inline void T_VcData::clearFilePath() {
    if (hasFilePath()) {
         clear_has_FilePath();
        _FilePath.clear();
     }
}

inline bool T_VcData::hasFilePath () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_VcData::getFilePath () const {
    return _FilePath;
}

inline ::std::string& T_VcData::getFilePathMutable () {
    set_has_FilePath();
    return _FilePath;
}

inline void T_VcData::setFilePath (const ::std::string& FilePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FilePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FilePath();
    this->_FilePath = FilePath_;
}

inline void T_VcData::setFilePath (const char* FilePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FilePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FilePath();
    this->_FilePath.assign(FilePath_);
}

inline void T_VcData::setFilePath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FilePath();
    this->_FilePath.assign(value, size);
}

inline void T_VcData::set_has_Section () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_VcData::clear_has_Section () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_VcData::set_has_FilePath () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_VcData::clear_has_FilePath () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_BlobData::T_BlobData ()  :
    _URId (0u),
    _FileLocation (),
    _FileSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BlobData::T_BlobData (const T_BlobData &rhs)  :
    _URId (0u),
    _FileLocation (),
    _FileSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BlobData::T_BlobData (uint16 URId_, const ::std::string& FileLocation_, uint32 FileSize_)  :
    _URId (URId_),
    _FileLocation (FileLocation_),
    _FileSize (FileSize_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FileLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BlobData::~T_BlobData() {
}

inline T_BlobData& T_BlobData::operator = (const T_BlobData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasURId()) {
            setURId(rhs.getURId());
        } else {
            clearURId();
        }
        if (rhs.hasFileLocation()) {
            setFileLocation(rhs.getFileLocation());
        } else {
            clearFileLocation();
        }
        if (rhs.hasFileSize()) {
            setFileSize(rhs.getFileSize());
        } else {
            clearFileSize();
        }
    }
    return *this;
}

inline bool T_BlobData::operator == (const T_BlobData& rhs) const {
    return (((!hasURId() && !rhs.hasURId()) || getURId() == rhs.getURId()) &&
        ((!hasFileLocation() && !rhs.hasFileLocation()) || getFileLocation() == rhs.getFileLocation()) &&
        ((!hasFileSize() && !rhs.hasFileSize()) || getFileSize() == rhs.getFileSize()));
}

inline bool T_BlobData::operator != (const T_BlobData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BlobData::operator < (const T_BlobData& rhs) const {
    if (hasURId() || rhs.hasURId()) {
        if (getURId() < rhs.getURId()) return true;
        if (getURId() > rhs.getURId()) return false;
    }
    if (hasFileLocation() || rhs.hasFileLocation()) {
        if (getFileLocation() < rhs.getFileLocation()) return true;
        if (getFileLocation() > rhs.getFileLocation()) return false;
    }
    if (hasFileSize() || rhs.hasFileSize()) {
        if (getFileSize() < rhs.getFileSize()) return true;
        if (getFileSize() > rhs.getFileSize()) return false;
    }
    return false;
}

inline bool T_BlobData::operator > (const T_BlobData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BlobData::clear() {
    clearURId();
    clearFileLocation();
    clearFileSize();
}

inline void T_BlobData::clearURId() {
    if (hasURId()) {
         clear_has_URId();
        _URId = 0u;
     }
}

inline bool T_BlobData::hasURId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_BlobData::getURId () const {
    return _URId;
}

inline void T_BlobData::setURId (uint16 URId_) {
    set_has_URId();
    this->_URId = URId_;
}

inline void T_BlobData::clearFileLocation() {
    if (hasFileLocation()) {
         clear_has_FileLocation();
        _FileLocation.clear();
     }
}

inline bool T_BlobData::hasFileLocation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_BlobData::getFileLocation () const {
    return _FileLocation;
}

inline ::std::string& T_BlobData::getFileLocationMutable () {
    set_has_FileLocation();
    return _FileLocation;
}

inline void T_BlobData::setFileLocation (const ::std::string& FileLocation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FileLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FileLocation();
    this->_FileLocation = FileLocation_;
}

inline void T_BlobData::setFileLocation (const char* FileLocation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FileLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FileLocation();
    this->_FileLocation.assign(FileLocation_);
}

inline void T_BlobData::setFileLocation (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FileLocation();
    this->_FileLocation.assign(value, size);
}

inline void T_BlobData::clearFileSize() {
    if (hasFileSize()) {
         clear_has_FileSize();
        _FileSize = 0u;
     }
}

inline bool T_BlobData::hasFileSize () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_BlobData::getFileSize () const {
    return _FileSize;
}

inline void T_BlobData::setFileSize (uint32 FileSize_) {
    set_has_FileSize();
    this->_FileSize = FileSize_;
}

inline void T_BlobData::set_has_URId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BlobData::clear_has_URId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BlobData::set_has_FileLocation () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BlobData::clear_has_FileLocation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BlobData::set_has_FileSize () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BlobData::clear_has_FileSize () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace sds_speechdp_fi_types

#endif // SDS_SPEECHDP_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
