/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "fi_typesConst.h"
#include "sds_sds2hmi_common_types.h"
#include "sds_sds2hmi_common_typesConst.h"
#include "sds_sds2hmi_common_typesJson.h"
#include "sds_sds2hmi_common_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "T_SDSLanguageID"

void serializeJson (const ::sds_sds2hmi_common_types::T_SDSLanguageID& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasISO639_3_SDSLanguageCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ISO639_3_SDSLanguageCode" , 24);
        const char* s = ::sds_sds2hmi_common_types::T_e16_ISO639_3_SDSLanguageCode_Name(value.getISO639_3_SDSLanguageCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getISO639_3_SDSLanguageCode());
    }
    if (!isSparse || value.hasISO3166_CountryCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ISO3166_CountryCode" , 19);
        const char* s = ::fi_types::T_e16_ISOCountryCode_Name(value.getISO3166_CountryCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getISO3166_CountryCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_sds2hmi_common_types::T_SDSLanguageID& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_ConnectedDeviceStatus"

void serializeJson (const ::sds_sds2hmi_common_types::T_ConnectedDeviceStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32DeviceId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DeviceId" , 11);
        yajl_gen_integer(g, (long long)value.getU32DeviceId());
    }
    if (!isSparse || value.hasTenDomain()) {
        yajl_gen_string(g, (const unsigned char*)  "tenDomain" , 9);
        const char* s = ::sds_sds2hmi_common_types::T_e8_Domain_Name(value.getTenDomain());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTenDomain());
    }
    if (!isSparse || value.hasUpdateStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "UpdateStatus" , 12);
        const char* s = ::sds_sds2hmi_common_types::T_e8_ConnectedDeviceUpdateStatus_Name(value.getUpdateStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getUpdateStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_sds2hmi_common_types::T_ConnectedDeviceStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_NDSLanguageID"

void serializeJson (const ::sds_sds2hmi_common_types::T_NDSLanguageID& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLanguageCode()) {
        yajl_gen_string(g, (const unsigned char*)  "LanguageCode" , 12);
        yajl_gen_integer(g, (long long)value.getLanguageCode());
    }
    if (!isSparse || value.hasISO_CountryCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ISO_CountryCode" , 15);
        const char *s = value.getISO_CountryCode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasISO_LanguageCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ISO_LanguageCode" , 16);
        const char *s = value.getISO_LanguageCode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasScriptCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ScriptCode" , 10);
        const char *s = value.getScriptCode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_sds2hmi_common_types::T_NDSLanguageID& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_NDSID"

void serializeJson (const ::sds_sds2hmi_common_types::T_NDSID& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16UpdateRegionId()) {
        yajl_gen_string(g, (const unsigned char*)  "u16UpdateRegionId" , 17);
        yajl_gen_integer(g, (long long)value.getU16UpdateRegionId());
    }
    if (!isSparse || value.hasU32ProductId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ProductId" , 12);
        yajl_gen_integer(g, (long long)value.getU32ProductId());
    }
    if (!isSparse || value.hasU8SupplierId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8SupplierId" , 12);
        yajl_gen_integer(g, (long long)value.getU8SupplierId());
    }
    if (!isSparse || value.hasU32NDSId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NDSId" , 8);
        yajl_gen_integer(g, (long long)value.getU32NDSId());
    }
    if (!isSparse || value.hasENDSFeatureType()) {
        yajl_gen_string(g, (const unsigned char*)  "eNDSFeatureType" , 15);
        const char* s = ::sds_sds2hmi_common_types::T_e8_NDSFeatureType_Name(value.getENDSFeatureType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getENDSFeatureType());
    }
    if (!isSparse || value.hasPOIRootRegionID()) {
        yajl_gen_string(g, (const unsigned char*)  "POIRootRegionID" , 15);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getPOIRootRegionID(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasGlobalXRefId()) {
        yajl_gen_string(g, (const unsigned char*)  "GlobalXRefId" , 12);
        yajl_gen_integer(g, (long long)value.getGlobalXRefId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_sds2hmi_common_types::T_NDSID& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_StreetAvailability"

void serializeJson (const ::sds_sds2hmi_common_types::T_StreetAvailability& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCity_Id()) {
        yajl_gen_string(g, (const unsigned char*)  "City_Id" , 7);
        serializeJson(value.getCity_Id(), g, options);
    }
    if (!isSparse || value.hasAvailability()) {
        yajl_gen_string(g, (const unsigned char*)  "Availability" , 12);
        yajl_gen_bool(g, (bool)value.getAvailability());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_sds2hmi_common_types::T_StreetAvailability& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_PhonemeForLanguage"

void serializeJson (const ::sds_sds2hmi_common_types::T_PhonemeForLanguage& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLanguage()) {
        yajl_gen_string(g, (const unsigned char*)  "Language" , 8);
        serializeJson(value.getLanguage(), g, options);
    }
    if (!isSparse || value.hasPhoneme()) {
        yajl_gen_string(g, (const unsigned char*)  "Phoneme" , 7);
        const char *s = value.getPhoneme().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_sds2hmi_common_types::T_PhonemeForLanguage& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_StringAndPhoneme"

void serializeJson (const ::sds_sds2hmi_common_types::T_StringAndPhoneme& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNDSId()) {
        yajl_gen_string(g, (const unsigned char*)  "NDSId" , 5);
        serializeJson(value.getNDSId(), g, options);
    }
    if (!isSparse || value.hasOrthographyList()) {
        yajl_gen_string(g, (const unsigned char*)  "OrthographyList" , 15);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o1 = value.getOrthographyList();
        {
            ::std::vector< ::std::string >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                const char *s = (*o0).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasPhonemeAndLanguageList()) {
        yajl_gen_string(g, (const unsigned char*)  "PhonemeAndLanguageList" , 22);
        yajl_gen_array_open(g);
        const ::std::vector< ::sds_sds2hmi_common_types::T_PhonemeForLanguage >& o3 = value.getPhonemeAndLanguageList();
        {
            ::std::vector< ::sds_sds2hmi_common_types::T_PhonemeForLanguage >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasDestItemtype()) {
        yajl_gen_string(g, (const unsigned char*)  "DestItemtype" , 12);
        const char* s = ::sds_sds2hmi_common_types::T_e8_SDSDestinationType_Name(value.getDestItemtype());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDestItemtype());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_sds2hmi_common_types::T_StringAndPhoneme& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_StatePhoneme"

void serializeJson (const ::sds_sds2hmi_common_types::T_StatePhoneme& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStateId()) {
        yajl_gen_string(g, (const unsigned char*)  "StateId" , 7);
        serializeJson(value.getStateId(), g, options);
    }
    if (!isSparse || value.hasPhonemeList()) {
        yajl_gen_string(g, (const unsigned char*)  "PhonemeList" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o5 = value.getPhonemeList();
        {
            ::std::vector< ::std::string >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                const char *s = (*o4).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasOrthographyList()) {
        yajl_gen_string(g, (const unsigned char*)  "OrthographyList" , 15);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o7 = value.getOrthographyList();
        {
            ::std::vector< ::std::string >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                const char *s = (*o6).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_sds2hmi_common_types::T_StatePhoneme& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_CountryPhoneme"

void serializeJson (const ::sds_sds2hmi_common_types::T_CountryPhoneme& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCountryId()) {
        yajl_gen_string(g, (const unsigned char*)  "CountryId" , 9);
        serializeJson(value.getCountryId(), g, options);
    }
    if (!isSparse || value.hasPhonemeList()) {
        yajl_gen_string(g, (const unsigned char*)  "PhonemeList" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o9 = value.getPhonemeList();
        {
            ::std::vector< ::std::string >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                const char *s = (*o8).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasOrthographyList()) {
        yajl_gen_string(g, (const unsigned char*)  "OrthographyList" , 15);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o11 = value.getOrthographyList();
        {
            ::std::vector< ::std::string >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                const char *s = (*o10).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasStateList()) {
        yajl_gen_string(g, (const unsigned char*)  "StateList" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::sds_sds2hmi_common_types::T_StatePhoneme >& o13 = value.getStateList();
        {
            ::std::vector< ::sds_sds2hmi_common_types::T_StatePhoneme >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                serializeJson((*o12), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasCountryCode()) {
        yajl_gen_string(g, (const unsigned char*)  "CountryCode" , 11);
        const char* s = ::fi_types::T_e16_ISOCountryCode_Name(value.getCountryCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCountryCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_sds2hmi_common_types::T_CountryPhoneme& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_CityId"

void serializeJson (const ::sds_sds2hmi_common_types::T_CityId& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCity_ID_()) {
        yajl_gen_string(g, (const unsigned char*)  "City_ID_" , 8);
        serializeJson(value.getCity_ID_(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_sds2hmi_common_types::T_CityId& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_ECNR_ASR_Mode_Status"

void serializeJson (const ::sds_sds2hmi_common_types::T_ECNR_ASR_Mode_Status& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMode_Enable()) {
        yajl_gen_string(g, (const unsigned char*)  "Mode_Enable" , 11);
        yajl_gen_bool(g, (bool)value.getMode_Enable());
    }
    if (!isSparse || value.hasMode_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "Mode_Status" , 11);
        const char* s = ::sds_sds2hmi_common_types::T_e32_SSE_ASR_Mode_Name(value.getMode_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getMode_Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_sds2hmi_common_types::T_ECNR_ASR_Mode_Status& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace sds_sds2hmi_common_types {

std::ostream& operator<<(std::ostream& o, const ::sds_sds2hmi_common_types::T_SDSLanguageID& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_sds2hmi_common_types
using namespace ::asf::stream::json;

namespace sds_sds2hmi_common_types {

std::ostream& operator<<(std::ostream& o, const ::sds_sds2hmi_common_types::T_ConnectedDeviceStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_sds2hmi_common_types
using namespace ::asf::stream::json;

namespace sds_sds2hmi_common_types {

std::ostream& operator<<(std::ostream& o, const ::sds_sds2hmi_common_types::T_NDSLanguageID& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_sds2hmi_common_types
using namespace ::asf::stream::json;

namespace sds_sds2hmi_common_types {

std::ostream& operator<<(std::ostream& o, const ::sds_sds2hmi_common_types::T_NDSID& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_sds2hmi_common_types
using namespace ::asf::stream::json;

namespace sds_sds2hmi_common_types {

std::ostream& operator<<(std::ostream& o, const ::sds_sds2hmi_common_types::T_StreetAvailability& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_sds2hmi_common_types
using namespace ::asf::stream::json;

namespace sds_sds2hmi_common_types {

std::ostream& operator<<(std::ostream& o, const ::sds_sds2hmi_common_types::T_PhonemeForLanguage& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_sds2hmi_common_types
using namespace ::asf::stream::json;

namespace sds_sds2hmi_common_types {

std::ostream& operator<<(std::ostream& o, const ::sds_sds2hmi_common_types::T_StringAndPhoneme& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_sds2hmi_common_types
using namespace ::asf::stream::json;

namespace sds_sds2hmi_common_types {

std::ostream& operator<<(std::ostream& o, const ::sds_sds2hmi_common_types::T_StatePhoneme& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_sds2hmi_common_types
using namespace ::asf::stream::json;

namespace sds_sds2hmi_common_types {

std::ostream& operator<<(std::ostream& o, const ::sds_sds2hmi_common_types::T_CountryPhoneme& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_sds2hmi_common_types
using namespace ::asf::stream::json;

namespace sds_sds2hmi_common_types {

std::ostream& operator<<(std::ostream& o, const ::sds_sds2hmi_common_types::T_CityId& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_sds2hmi_common_types
using namespace ::asf::stream::json;

namespace sds_sds2hmi_common_types {

std::ostream& operator<<(std::ostream& o, const ::sds_sds2hmi_common_types::T_ECNR_ASR_Mode_Status& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sds_sds2hmi_common_types

