#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_SDS2HMI_COMMON_TYPES_H
#define SDS_SDS2HMI_COMMON_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_typesConst.h"
#include "sds_sds2hmi_common_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types sds_sds2hmi_common_types
 */

namespace sds_sds2hmi_common_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_SDSLanguageID;

class T_ConnectedDeviceStatus;

class T_NDSLanguageID;

class T_NDSID;

class T_StreetAvailability;

class T_PhonemeForLanguage;

class T_StringAndPhoneme;

class T_StatePhoneme;

class T_CountryPhoneme;

class T_CityId;

class T_ECNR_ASR_Mode_Status;


/**
 * Represents language in SDS
 */
class T_SDSLanguageID {
public:

    /**
     * Default constructor
     */
    inline  T_SDSLanguageID ();

    /**
     * Copy constructor
     */
    inline  T_SDSLanguageID (const T_SDSLanguageID &rhs);

    /**
     * All fields constructor
     */
    inline  T_SDSLanguageID (T_e16_ISO639_3_SDSLanguageCode ISO639_3_SDSLanguageCode_, ::fi_types::T_e16_ISOCountryCode ISO3166_CountryCode_);

    /**
     * Destructor
     */
    inline  ~T_SDSLanguageID();

    /**
     * Assignment operator
     */
    inline T_SDSLanguageID& operator = (const T_SDSLanguageID& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SDSLanguageID& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SDSLanguageID& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SDSLanguageID& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SDSLanguageID& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ISO639_3_SDSLanguageCode"

    static const int kISO639_3_SDSLanguageCode = 0;

    /**
     * Clears the field "ISO639_3_SDSLanguageCode".
     *
     * The field will be set to its default value. The hasISO639_3_SDSLanguageCode()
     * method will return false.
     */
    inline void clearISO639_3_SDSLanguageCode();

    /**
     * Checks whether the field "ISO639_3_SDSLanguageCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setISO639_3_SDSLanguageCode()). Otherwise it will return false.
     */
    inline bool hasISO639_3_SDSLanguageCode () const;

    /**
     * Returns the value of the member "ISO639_3_SDSLanguageCode".
     *
     * The ISO 639-3, three letter language code encoded as 16-Bit value.(code : A=1 to Z=26).
     * Eg: e=00101, n=01110, g=00111. concatenating, eng = 001010111000111 = 5575
     *
     * @return The value of the field "ISO639_3_SDSLanguageCode"
     */
    inline T_e16_ISO639_3_SDSLanguageCode getISO639_3_SDSLanguageCode () const;

    /**
     * Sets the value of the member "ISO639_3_SDSLanguageCode".
     *
     * The ISO 639-3, three letter language code encoded as 16-Bit value.(code : A=1 to Z=26).
     * Eg: e=00101, n=01110, g=00111. concatenating, eng = 001010111000111 = 5575
     *
     * @param ISO639_3_SDSLanguageCode The value which will be set
     */
    inline void setISO639_3_SDSLanguageCode (T_e16_ISO639_3_SDSLanguageCode ISO639_3_SDSLanguageCode_);

    // API of field "ISO3166_CountryCode"

    static const int kISO3166_CountryCode = 1;

    /**
     * Clears the field "ISO3166_CountryCode".
     *
     * The field will be set to its default value. The hasISO3166_CountryCode()
     * method will return false.
     */
    inline void clearISO3166_CountryCode();

    /**
     * Checks whether the field "ISO3166_CountryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setISO3166_CountryCode()). Otherwise it will return false.
     */
    inline bool hasISO3166_CountryCode () const;

    /**
     * Returns the value of the member "ISO3166_CountryCode".
     *
     * ISO 3166 country code (used only in case where country specific language variants are used, e.g. English US and EnglishGB). (0 = do not care)
     *
     * @return The value of the field "ISO3166_CountryCode"
     */
    inline ::fi_types::T_e16_ISOCountryCode getISO3166_CountryCode () const;

    /**
     * Sets the value of the member "ISO3166_CountryCode".
     *
     * ISO 3166 country code (used only in case where country specific language variants are used, e.g. English US and EnglishGB). (0 = do not care)
     *
     * @param ISO3166_CountryCode The value which will be set
     */
    inline void setISO3166_CountryCode (::fi_types::T_e16_ISOCountryCode ISO3166_CountryCode_);

    static const T_SDSLanguageID &getDefaultInstance();

private:

    inline void set_has_ISO639_3_SDSLanguageCode ();

    inline void clear_has_ISO639_3_SDSLanguageCode ();

    inline void set_has_ISO3166_CountryCode ();

    inline void clear_has_ISO3166_CountryCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e16_ISO639_3_SDSLanguageCode _ISO639_3_SDSLanguageCode;

    ::fi_types::T_e16_ISOCountryCode _ISO3166_CountryCode;

};

/**
 * The structure contains the device ID and its connection status
 */
class T_ConnectedDeviceStatus {
public:

    /**
     * Default constructor
     */
    inline  T_ConnectedDeviceStatus ();

    /**
     * Copy constructor
     */
    inline  T_ConnectedDeviceStatus (const T_ConnectedDeviceStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_ConnectedDeviceStatus (uint32 u32DeviceId_, T_e8_Domain tenDomain_, T_e8_ConnectedDeviceUpdateStatus UpdateStatus_);

    /**
     * Destructor
     */
    inline  ~T_ConnectedDeviceStatus();

    /**
     * Assignment operator
     */
    inline T_ConnectedDeviceStatus& operator = (const T_ConnectedDeviceStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ConnectedDeviceStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ConnectedDeviceStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ConnectedDeviceStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ConnectedDeviceStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32DeviceId"

    static const int kU32DeviceId = 0;

    /**
     * Clears the field "u32DeviceId".
     *
     * The field will be set to its default value. The hasU32DeviceId()
     * method will return false.
     */
    inline void clearU32DeviceId();

    /**
     * Checks whether the field "u32DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DeviceId()). Otherwise it will return false.
     */
    inline bool hasU32DeviceId () const;

    /**
     * Returns the value of the member "u32DeviceId".
     *
     * Unique device ID for a device
     *
     * @return The value of the field "u32DeviceId"
     */
    inline uint32 getU32DeviceId () const;

    /**
     * Sets the value of the member "u32DeviceId".
     *
     * Unique device ID for a device
     *
     * @param u32DeviceId The value which will be set
     */
    inline void setU32DeviceId (uint32 u32DeviceId_);

    // API of field "tenDomain"

    static const int kTenDomain = 1;

    /**
     * Clears the field "tenDomain".
     *
     * The field will be set to its default value. The hasTenDomain()
     * method will return false.
     */
    inline void clearTenDomain();

    /**
     * Checks whether the field "tenDomain" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTenDomain()). Otherwise it will return false.
     */
    inline bool hasTenDomain () const;

    /**
     * Returns the value of the member "tenDomain".
     *
     * Domain of the device
     *
     * @return The value of the field "tenDomain"
     */
    inline T_e8_Domain getTenDomain () const;

    /**
     * Sets the value of the member "tenDomain".
     *
     * Domain of the device
     *
     * @param tenDomain The value which will be set
     */
    inline void setTenDomain (T_e8_Domain tenDomain_);

    // API of field "UpdateStatus"

    static const int kUpdateStatus = 2;

    /**
     * Clears the field "UpdateStatus".
     *
     * The field will be set to its default value. The hasUpdateStatus()
     * method will return false.
     */
    inline void clearUpdateStatus();

    /**
     * Checks whether the field "UpdateStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateStatus()). Otherwise it will return false.
     */
    inline bool hasUpdateStatus () const;

    /**
     * Returns the value of the member "UpdateStatus".
     *
     * Status of device
     *
     * @return The value of the field "UpdateStatus"
     */
    inline T_e8_ConnectedDeviceUpdateStatus getUpdateStatus () const;

    /**
     * Sets the value of the member "UpdateStatus".
     *
     * Status of device
     *
     * @param UpdateStatus The value which will be set
     */
    inline void setUpdateStatus (T_e8_ConnectedDeviceUpdateStatus UpdateStatus_);

    static const T_ConnectedDeviceStatus &getDefaultInstance();

private:

    inline void set_has_u32DeviceId ();

    inline void clear_has_u32DeviceId ();

    inline void set_has_tenDomain ();

    inline void clear_has_tenDomain ();

    inline void set_has_UpdateStatus ();

    inline void clear_has_UpdateStatus ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _u32DeviceId;

    T_e8_Domain _tenDomain;

    T_e8_ConnectedDeviceUpdateStatus _UpdateStatus;

};

/**
 * Language identifier in NDS.
 */
class T_NDSLanguageID {
public:

    /**
     * Default constructor
     */
    inline  T_NDSLanguageID ();

    /**
     * Copy constructor
     */
    inline  T_NDSLanguageID (const T_NDSLanguageID &rhs);

    /**
     * All fields constructor
     */
    inline  T_NDSLanguageID (uint16 LanguageCode_, const ::std::string& ISO_CountryCode_, const ::std::string& ISO_LanguageCode_, const ::std::string& ScriptCode_);

    /**
     * Destructor
     */
    inline  ~T_NDSLanguageID();

    /**
     * Assignment operator
     */
    inline T_NDSLanguageID& operator = (const T_NDSLanguageID& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_NDSLanguageID& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_NDSLanguageID& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_NDSLanguageID& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_NDSLanguageID& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LanguageCode"

    static const int kLanguageCode = 0;

    /**
     * Clears the field "LanguageCode".
     *
     * The field will be set to its default value. The hasLanguageCode()
     * method will return false.
     */
    inline void clearLanguageCode();

    /**
     * Checks whether the field "LanguageCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageCode()). Otherwise it will return false.
     */
    inline bool hasLanguageCode () const;

    /**
     * Returns the value of the member "LanguageCode".
     *
     * NDS internal language code.
     *
     * @return The value of the field "LanguageCode"
     */
    inline uint16 getLanguageCode () const;

    /**
     * Sets the value of the member "LanguageCode".
     *
     * NDS internal language code.
     *
     * @param LanguageCode The value which will be set
     */
    inline void setLanguageCode (uint16 LanguageCode_);

    // API of field "ISO_CountryCode"

    static const int kISO_CountryCode = 1;

    /**
     * Clears the field "ISO_CountryCode".
     *
     * The field will be set to its default value. The hasISO_CountryCode()
     * method will return false.
     */
    inline void clearISO_CountryCode();

    /**
     * Checks whether the field "ISO_CountryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setISO_CountryCode()). Otherwise it will return false.
     */
    inline bool hasISO_CountryCode () const;

    /**
     * Returns the value of the member "ISO_CountryCode".
     *
     * ISO 3166-1 alpha-3 code in three upper case characters.
     *
     * @return The value of the field "ISO_CountryCode"
     */
    inline const ::std::string& getISO_CountryCode () const;

    /**
     * Retrieves the value of the field "ISO_CountryCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ISO_CountryCode".
     */
    inline ::std::string& getISO_CountryCodeMutable ();

    /**
     * Sets the value of the member "ISO_CountryCode".
     *
     * ISO 3166-1 alpha-3 code in three upper case characters.
     *
     * @param ISO_CountryCode The value which will be set
     */
    inline void setISO_CountryCode (const ::std::string& ISO_CountryCode_);

    /**
     * Sets the value of the member "ISO_CountryCode".
     *
     * ISO 3166-1 alpha-3 code in three upper case characters.
     *
     * @param ISO_CountryCode The value which will be set
     */
    inline void setISO_CountryCode (const char* ISO_CountryCode_);

    /**
     * Sets the value of the member "ISO_CountryCode".
     *
     * ISO 3166-1 alpha-3 code in three upper case characters.
     *
     * @param ISO_CountryCode The value which will be set
     */
    inline void setISO_CountryCode (const char* value, size_t size);

    // API of field "ISO_LanguageCode"

    static const int kISO_LanguageCode = 2;

    /**
     * Clears the field "ISO_LanguageCode".
     *
     * The field will be set to its default value. The hasISO_LanguageCode()
     * method will return false.
     */
    inline void clearISO_LanguageCode();

    /**
     * Checks whether the field "ISO_LanguageCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setISO_LanguageCode()). Otherwise it will return false.
     */
    inline bool hasISO_LanguageCode () const;

    /**
     * Returns the value of the member "ISO_LanguageCode".
     *
     * ISO 639-3 in three lower case characters.
     *
     * @return The value of the field "ISO_LanguageCode"
     */
    inline const ::std::string& getISO_LanguageCode () const;

    /**
     * Retrieves the value of the field "ISO_LanguageCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ISO_LanguageCode".
     */
    inline ::std::string& getISO_LanguageCodeMutable ();

    /**
     * Sets the value of the member "ISO_LanguageCode".
     *
     * ISO 639-3 in three lower case characters.
     *
     * @param ISO_LanguageCode The value which will be set
     */
    inline void setISO_LanguageCode (const ::std::string& ISO_LanguageCode_);

    /**
     * Sets the value of the member "ISO_LanguageCode".
     *
     * ISO 639-3 in three lower case characters.
     *
     * @param ISO_LanguageCode The value which will be set
     */
    inline void setISO_LanguageCode (const char* ISO_LanguageCode_);

    /**
     * Sets the value of the member "ISO_LanguageCode".
     *
     * ISO 639-3 in three lower case characters.
     *
     * @param ISO_LanguageCode The value which will be set
     */
    inline void setISO_LanguageCode (const char* value, size_t size);

    // API of field "ScriptCode"

    static const int kScriptCode = 3;

    /**
     * Clears the field "ScriptCode".
     *
     * The field will be set to its default value. The hasScriptCode()
     * method will return false.
     */
    inline void clearScriptCode();

    /**
     * Checks whether the field "ScriptCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScriptCode()). Otherwise it will return false.
     */
    inline bool hasScriptCode () const;

    /**
     * Returns the value of the member "ScriptCode".
     *
     * ISO 15924 script code. First letter upper case and remaining in lower case.
     * Eg: Latn, Cyrl
     *
     * @return The value of the field "ScriptCode"
     */
    inline const ::std::string& getScriptCode () const;

    /**
     * Retrieves the value of the field "ScriptCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ScriptCode".
     */
    inline ::std::string& getScriptCodeMutable ();

    /**
     * Sets the value of the member "ScriptCode".
     *
     * ISO 15924 script code. First letter upper case and remaining in lower case.
     * Eg: Latn, Cyrl
     *
     * @param ScriptCode The value which will be set
     */
    inline void setScriptCode (const ::std::string& ScriptCode_);

    /**
     * Sets the value of the member "ScriptCode".
     *
     * ISO 15924 script code. First letter upper case and remaining in lower case.
     * Eg: Latn, Cyrl
     *
     * @param ScriptCode The value which will be set
     */
    inline void setScriptCode (const char* ScriptCode_);

    /**
     * Sets the value of the member "ScriptCode".
     *
     * ISO 15924 script code. First letter upper case and remaining in lower case.
     * Eg: Latn, Cyrl
     *
     * @param ScriptCode The value which will be set
     */
    inline void setScriptCode (const char* value, size_t size);

    static const T_NDSLanguageID &getDefaultInstance();

private:

    inline void set_has_LanguageCode ();

    inline void clear_has_LanguageCode ();

    inline void set_has_ISO_CountryCode ();

    inline void clear_has_ISO_CountryCode ();

    inline void set_has_ISO_LanguageCode ();

    inline void clear_has_ISO_LanguageCode ();

    inline void set_has_ScriptCode ();

    inline void clear_has_ScriptCode ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint16 _LanguageCode;

    ::std::string _ISO_CountryCode;

    ::std::string _ISO_LanguageCode;

    ::std::string _ScriptCode;

};

/**
 * Name object Id in NDS.
 */
class T_NDSID {
public:

    /**
     * Default constructor
     */
    inline  T_NDSID ();

    /**
     * Copy constructor
     */
    inline  T_NDSID (const T_NDSID &rhs);

    /**
     * All fields constructor
     */
    inline  T_NDSID (uint16 u16UpdateRegionId_, uint32 u32ProductId_, uint8 u8SupplierId_, uint32 u32NDSId_, T_e8_NDSFeatureType eNDSFeatureType_, uint64 POIRootRegionID_, uint32 GlobalXRefId_);

    /**
     * Destructor
     */
    inline  ~T_NDSID();

    /**
     * Assignment operator
     */
    inline T_NDSID& operator = (const T_NDSID& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_NDSID& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_NDSID& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_NDSID& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_NDSID& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16UpdateRegionId"

    static const int kU16UpdateRegionId = 0;

    /**
     * Clears the field "u16UpdateRegionId".
     *
     * The field will be set to its default value. The hasU16UpdateRegionId()
     * method will return false.
     */
    inline void clearU16UpdateRegionId();

    /**
     * Checks whether the field "u16UpdateRegionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16UpdateRegionId()). Otherwise it will return false.
     */
    inline bool hasU16UpdateRegionId () const;

    /**
     * Returns the value of the member "u16UpdateRegionId".
     *
     * index of NDS update region.The inform can be found in type T_UpdateRegion of type T_SDSProduct.
     *
     * @return The value of the field "u16UpdateRegionId"
     */
    inline uint16 getU16UpdateRegionId () const;

    /**
     * Sets the value of the member "u16UpdateRegionId".
     *
     * index of NDS update region.The inform can be found in type T_UpdateRegion of type T_SDSProduct.
     *
     * @param u16UpdateRegionId The value which will be set
     */
    inline void setU16UpdateRegionId (uint16 u16UpdateRegionId_);

    // API of field "u32ProductId"

    static const int kU32ProductId = 1;

    /**
     * Clears the field "u32ProductId".
     *
     * The field will be set to its default value. The hasU32ProductId()
     * method will return false.
     */
    inline void clearU32ProductId();

    /**
     * Checks whether the field "u32ProductId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ProductId()). Otherwise it will return false.
     */
    inline bool hasU32ProductId () const;

    /**
     * Returns the value of the member "u32ProductId".
     *
     * product index of dataset.The value can be found in type T_SDSProduct.
     *
     * @return The value of the field "u32ProductId"
     */
    inline uint32 getU32ProductId () const;

    /**
     * Sets the value of the member "u32ProductId".
     *
     * product index of dataset.The value can be found in type T_SDSProduct.
     *
     * @param u32ProductId The value which will be set
     */
    inline void setU32ProductId (uint32 u32ProductId_);

    // API of field "u8SupplierId"

    static const int kU8SupplierId = 2;

    /**
     * Clears the field "u8SupplierId".
     *
     * The field will be set to its default value. The hasU8SupplierId()
     * method will return false.
     */
    inline void clearU8SupplierId();

    /**
     * Checks whether the field "u8SupplierId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SupplierId()). Otherwise it will return false.
     */
    inline bool hasU8SupplierId () const;

    /**
     * Returns the value of the member "u8SupplierId".
     *
     * supplier index of dataset.The value can be found in type T_SDSProduct.
     *
     * @return The value of the field "u8SupplierId"
     */
    inline uint8 getU8SupplierId () const;

    /**
     * Sets the value of the member "u8SupplierId".
     *
     * supplier index of dataset.The value can be found in type T_SDSProduct.
     *
     * @param u8SupplierId The value which will be set
     */
    inline void setU8SupplierId (uint8 u8SupplierId_);

    // API of field "u32NDSId"

    static const int kU32NDSId = 3;

    /**
     * Clears the field "u32NDSId".
     *
     * The field will be set to its default value. The hasU32NDSId()
     * method will return false.
     */
    inline void clearU32NDSId();

    /**
     * Checks whether the field "u32NDSId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NDSId()). Otherwise it will return false.
     */
    inline bool hasU32NDSId () const;

    /**
     * Returns the value of the member "u32NDSId".
     *
     * NDS id. Name object index.
     *
     * @return The value of the field "u32NDSId"
     */
    inline uint32 getU32NDSId () const;

    /**
     * Sets the value of the member "u32NDSId".
     *
     * NDS id. Name object index.
     *
     * @param u32NDSId The value which will be set
     */
    inline void setU32NDSId (uint32 u32NDSId_);

    // API of field "eNDSFeatureType"

    static const int kENDSFeatureType = 4;

    /**
     * Clears the field "eNDSFeatureType".
     *
     * The field will be set to its default value. The hasENDSFeatureType()
     * method will return false.
     */
    inline void clearENDSFeatureType();

    /**
     * Checks whether the field "eNDSFeatureType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setENDSFeatureType()). Otherwise it will return false.
     */
    inline bool hasENDSFeatureType () const;

    /**
     * Returns the value of the member "eNDSFeatureType".
     *
     * indicates which data the NDS building block represents.
     *
     * @return The value of the field "eNDSFeatureType"
     */
    inline T_e8_NDSFeatureType getENDSFeatureType () const;

    /**
     * Sets the value of the member "eNDSFeatureType".
     *
     * indicates which data the NDS building block represents.
     *
     * @param eNDSFeatureType The value which will be set
     */
    inline void setENDSFeatureType (T_e8_NDSFeatureType eNDSFeatureType_);

    // API of field "POIRootRegionID"

    static const int kPOIRootRegionID = 5;

    /**
     * Clears the field "POIRootRegionID".
     *
     * The field will be set to its default value. The hasPOIRootRegionID()
     * method will return false.
     */
    inline void clearPOIRootRegionID();

    /**
     * Checks whether the field "POIRootRegionID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPOIRootRegionID()). Otherwise it will return false.
     */
    inline bool hasPOIRootRegionID () const;

    /**
     * Returns the value of the member "POIRootRegionID".
     *
     * To get specific POI Name context out of NDS ASR Data.
     *
     * @return The value of the field "POIRootRegionID"
     */
    inline uint64 getPOIRootRegionID () const;

    /**
     * Sets the value of the member "POIRootRegionID".
     *
     * To get specific POI Name context out of NDS ASR Data.
     *
     * @param POIRootRegionID The value which will be set
     */
    inline void setPOIRootRegionID (uint64 POIRootRegionID_);

    // API of field "GlobalXRefId"

    static const int kGlobalXRefId = 6;

    /**
     * Clears the field "GlobalXRefId".
     *
     * The field will be set to its default value. The hasGlobalXRefId()
     * method will return false.
     */
    inline void clearGlobalXRefId();

    /**
     * Checks whether the field "GlobalXRefId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGlobalXRefId()). Otherwise it will return false.
     */
    inline bool hasGlobalXRefId () const;

    /**
     * Returns the value of the member "GlobalXRefId".
     *
     * For identifying contexts split into different update region-ids.
     *
     * @return The value of the field "GlobalXRefId"
     */
    inline uint32 getGlobalXRefId () const;

    /**
     * Sets the value of the member "GlobalXRefId".
     *
     * For identifying contexts split into different update region-ids.
     *
     * @param GlobalXRefId The value which will be set
     */
    inline void setGlobalXRefId (uint32 GlobalXRefId_);

    static const T_NDSID &getDefaultInstance();

private:

    inline void set_has_u16UpdateRegionId ();

    inline void clear_has_u16UpdateRegionId ();

    inline void set_has_u32ProductId ();

    inline void clear_has_u32ProductId ();

    inline void set_has_u8SupplierId ();

    inline void clear_has_u8SupplierId ();

    inline void set_has_u32NDSId ();

    inline void clear_has_u32NDSId ();

    inline void set_has_eNDSFeatureType ();

    inline void clear_has_eNDSFeatureType ();

    inline void set_has_POIRootRegionID ();

    inline void clear_has_POIRootRegionID ();

    inline void set_has_GlobalXRefId ();

    inline void clear_has_GlobalXRefId ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint16 _u16UpdateRegionId;

    uint32 _u32ProductId;

    uint8 _u8SupplierId;

    uint32 _u32NDSId;

    T_e8_NDSFeatureType _eNDSFeatureType;

    uint64 _POIRootRegionID;

    uint32 _GlobalXRefId;

};

/**
 * contains the city index and a boolean indicated the availability of streets inside the respective city.
 */
class T_StreetAvailability {
public:

    /**
     * Default constructor
     */
    inline  T_StreetAvailability ();

    /**
     * Copy constructor
     */
    inline  T_StreetAvailability (const T_StreetAvailability &rhs);

    /**
     * All fields constructor
     */
    inline  T_StreetAvailability (const T_NDSID& City_Id_, bool Availability_);

    /**
     * Destructor
     */
    inline  ~T_StreetAvailability();

    /**
     * Assignment operator
     */
    inline T_StreetAvailability& operator = (const T_StreetAvailability& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_StreetAvailability& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_StreetAvailability& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_StreetAvailability& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_StreetAvailability& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "City_Id"

    static const int kCity_Id = 0;

    /**
     * Clears the field "City_Id".
     *
     * The field will be set to its default value. The hasCity_Id()
     * method will return false.
     */
    inline void clearCity_Id();

    /**
     * Checks whether the field "City_Id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCity_Id()). Otherwise it will return false.
     */
    inline bool hasCity_Id () const;

    /**
     * Returns the value of the member "City_Id".
     *
     * The city Id
     *
     * @return The value of the field "City_Id"
     */
    inline const T_NDSID& getCity_Id () const;

    /**
     * Retrieves the value of the field "City_Id" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "City_Id".
     */
    inline T_NDSID& getCity_IdMutable ();

    /**
     * Sets the value of the member "City_Id".
     *
     * The city Id
     *
     * @param City_Id The value which will be set
     */
    inline void setCity_Id (const T_NDSID& City_Id_);

    // API of field "Availability"

    static const int kAvailability = 1;

    /**
     * Clears the field "Availability".
     *
     * The field will be set to its default value. The hasAvailability()
     * method will return false.
     */
    inline void clearAvailability();

    /**
     * Checks whether the field "Availability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailability()). Otherwise it will return false.
     */
    inline bool hasAvailability () const;

    /**
     * Returns the value of the member "Availability".
     *
     * True, if street is available. false otherwise.
     *
     * @return The value of the field "Availability"
     */
    inline bool getAvailability () const;

    /**
     * Sets the value of the member "Availability".
     *
     * True, if street is available. false otherwise.
     *
     * @param Availability The value which will be set
     */
    inline void setAvailability (bool Availability_);

    static const T_StreetAvailability &getDefaultInstance();

private:

    inline void set_has_City_Id ();

    inline void clear_has_City_Id ();

    inline void set_has_Availability ();

    inline void clear_has_Availability ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_NDSID _City_Id;

    bool _Availability;

};

/**
 * Phoneme for a given language
 */
class T_PhonemeForLanguage {
public:

    /**
     * Default constructor
     */
    inline  T_PhonemeForLanguage ();

    /**
     * Copy constructor
     */
    inline  T_PhonemeForLanguage (const T_PhonemeForLanguage &rhs);

    /**
     * All fields constructor
     */
    inline  T_PhonemeForLanguage (const T_NDSLanguageID& Language_, const ::std::string& Phoneme_);

    /**
     * Destructor
     */
    inline  ~T_PhonemeForLanguage();

    /**
     * Assignment operator
     */
    inline T_PhonemeForLanguage& operator = (const T_PhonemeForLanguage& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PhonemeForLanguage& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PhonemeForLanguage& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PhonemeForLanguage& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PhonemeForLanguage& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Language"

    static const int kLanguage = 0;

    /**
     * Clears the field "Language".
     *
     * The field will be set to its default value. The hasLanguage()
     * method will return false.
     */
    inline void clearLanguage();

    /**
     * Checks whether the field "Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguage()). Otherwise it will return false.
     */
    inline bool hasLanguage () const;

    /**
     * Returns the value of the member "Language".
     *
     * NDS language Id
     *
     * @return The value of the field "Language"
     */
    inline const T_NDSLanguageID& getLanguage () const;

    /**
     * Retrieves the value of the field "Language" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Language".
     */
    inline T_NDSLanguageID& getLanguageMutable ();

    /**
     * Sets the value of the member "Language".
     *
     * NDS language Id
     *
     * @param Language The value which will be set
     */
    inline void setLanguage (const T_NDSLanguageID& Language_);

    // API of field "Phoneme"

    static const int kPhoneme = 1;

    /**
     * Clears the field "Phoneme".
     *
     * The field will be set to its default value. The hasPhoneme()
     * method will return false.
     */
    inline void clearPhoneme();

    /**
     * Checks whether the field "Phoneme" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneme()). Otherwise it will return false.
     */
    inline bool hasPhoneme () const;

    /**
     * Returns the value of the member "Phoneme".
     *
     * Phoneme
     *
     * @return The value of the field "Phoneme"
     */
    inline const ::std::string& getPhoneme () const;

    /**
     * Retrieves the value of the field "Phoneme" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Phoneme".
     */
    inline ::std::string& getPhonemeMutable ();

    /**
     * Sets the value of the member "Phoneme".
     *
     * Phoneme
     *
     * @param Phoneme The value which will be set
     */
    inline void setPhoneme (const ::std::string& Phoneme_);

    /**
     * Sets the value of the member "Phoneme".
     *
     * Phoneme
     *
     * @param Phoneme The value which will be set
     */
    inline void setPhoneme (const char* Phoneme_);

    /**
     * Sets the value of the member "Phoneme".
     *
     * Phoneme
     *
     * @param Phoneme The value which will be set
     */
    inline void setPhoneme (const char* value, size_t size);

    static const T_PhonemeForLanguage &getDefaultInstance();

private:

    inline void set_has_Language ();

    inline void clear_has_Language ();

    inline void set_has_Phoneme ();

    inline void clear_has_Phoneme ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_NDSLanguageID _Language;

    ::std::string _Phoneme;

};

/**
 * orthography and Phoneme for requested Id
 */
class T_StringAndPhoneme {
public:

    /**
     * Default constructor
     */
    inline  T_StringAndPhoneme ();

    /**
     * Copy constructor
     */
    inline  T_StringAndPhoneme (const T_StringAndPhoneme &rhs);

    /**
     * All fields constructor
     */
    inline  T_StringAndPhoneme (const T_NDSID& NDSId_, const ::std::vector< ::std::string >& OrthographyList_, const ::std::vector< T_PhonemeForLanguage >& PhonemeAndLanguageList_, T_e8_SDSDestinationType DestItemtype_);

    /**
     * Destructor
     */
    inline  ~T_StringAndPhoneme();

    /**
     * Assignment operator
     */
    inline T_StringAndPhoneme& operator = (const T_StringAndPhoneme& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_StringAndPhoneme& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_StringAndPhoneme& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_StringAndPhoneme& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_StringAndPhoneme& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NDSId"

    static const int kNDSId = 0;

    /**
     * Clears the field "NDSId".
     *
     * The field will be set to its default value. The hasNDSId()
     * method will return false.
     */
    inline void clearNDSId();

    /**
     * Checks whether the field "NDSId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNDSId()). Otherwise it will return false.
     */
    inline bool hasNDSId () const;

    /**
     * Returns the value of the member "NDSId".
     *
     * The Id of destination element
     *
     * @return The value of the field "NDSId"
     */
    inline const T_NDSID& getNDSId () const;

    /**
     * Retrieves the value of the field "NDSId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NDSId".
     */
    inline T_NDSID& getNDSIdMutable ();

    /**
     * Sets the value of the member "NDSId".
     *
     * The Id of destination element
     *
     * @param NDSId The value which will be set
     */
    inline void setNDSId (const T_NDSID& NDSId_);

    // API of field "OrthographyList"

    static const int kOrthographyList = 1;

    /**
     * Clears the field "OrthographyList".
     *
     * The field will be set to its default value. The hasOrthographyList()
     * method will return false.
     */
    inline void clearOrthographyList();

    /**
     * Checks whether the field "OrthographyList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOrthographyList()). Otherwise it will return false.
     */
    inline bool hasOrthographyList () const;

    /**
     * Returns the value of the member "OrthographyList".
     *
     * list of Orthography for the requested Id.
     *
     * @return The value of the field "OrthographyList"
     */
    inline const ::std::vector< ::std::string >& getOrthographyList () const;

    /**
     * Retrieves the value of the field "OrthographyList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OrthographyList".
     */
    inline ::std::vector< ::std::string >& getOrthographyListMutable ();

    /**
     * Sets the value of the member "OrthographyList".
     *
     * list of Orthography for the requested Id.
     *
     * @param OrthographyList The value which will be set
     */
    inline void setOrthographyList (const ::std::vector< ::std::string >& OrthographyList_);

    // API of field "PhonemeAndLanguageList"

    static const int kPhonemeAndLanguageList = 2;

    /**
     * Clears the field "PhonemeAndLanguageList".
     *
     * The field will be set to its default value. The hasPhonemeAndLanguageList()
     * method will return false.
     */
    inline void clearPhonemeAndLanguageList();

    /**
     * Checks whether the field "PhonemeAndLanguageList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonemeAndLanguageList()). Otherwise it will return false.
     */
    inline bool hasPhonemeAndLanguageList () const;

    /**
     * Returns the value of the member "PhonemeAndLanguageList".
     *
     * list of Phonemes for the requested Id with matching language.
     *
     * @return The value of the field "PhonemeAndLanguageList"
     */
    inline const ::std::vector< T_PhonemeForLanguage >& getPhonemeAndLanguageList () const;

    /**
     * Retrieves the value of the field "PhonemeAndLanguageList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhonemeAndLanguageList".
     */
    inline ::std::vector< T_PhonemeForLanguage >& getPhonemeAndLanguageListMutable ();

    /**
     * Sets the value of the member "PhonemeAndLanguageList".
     *
     * list of Phonemes for the requested Id with matching language.
     *
     * @param PhonemeAndLanguageList The value which will be set
     */
    inline void setPhonemeAndLanguageList (const ::std::vector< T_PhonemeForLanguage >& PhonemeAndLanguageList_);

    // API of field "DestItemtype"

    static const int kDestItemtype = 3;

    /**
     * Clears the field "DestItemtype".
     *
     * The field will be set to its default value. The hasDestItemtype()
     * method will return false.
     */
    inline void clearDestItemtype();

    /**
     * Checks whether the field "DestItemtype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestItemtype()). Otherwise it will return false.
     */
    inline bool hasDestItemtype () const;

    /**
     * Returns the value of the member "DestItemtype".
     *
     * Type of the detination element corresponding to NDSId requested.
     *
     * @return The value of the field "DestItemtype"
     */
    inline T_e8_SDSDestinationType getDestItemtype () const;

    /**
     * Sets the value of the member "DestItemtype".
     *
     * Type of the detination element corresponding to NDSId requested.
     *
     * @param DestItemtype The value which will be set
     */
    inline void setDestItemtype (T_e8_SDSDestinationType DestItemtype_);

    static const T_StringAndPhoneme &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    static const ::std::vector< T_PhonemeForLanguage >& getT_PhonemeForLanguageList_DefaultInstance ();

    inline void set_has_NDSId ();

    inline void clear_has_NDSId ();

    inline void set_has_OrthographyList ();

    inline void clear_has_OrthographyList ();

    inline void set_has_PhonemeAndLanguageList ();

    inline void clear_has_PhonemeAndLanguageList ();

    inline void set_has_DestItemtype ();

    inline void clear_has_DestItemtype ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_NDSID _NDSId;

    ::std::vector< ::std::string > _OrthographyList;

    ::std::vector< T_PhonemeForLanguage > _PhonemeAndLanguageList;

    T_e8_SDSDestinationType _DestItemtype;

};

/**
 * State information covered by the navi data
 */
class T_StatePhoneme {
public:

    /**
     * Default constructor
     */
    inline  T_StatePhoneme ();

    /**
     * Copy constructor
     */
    inline  T_StatePhoneme (const T_StatePhoneme &rhs);

    /**
     * All fields constructor
     */
    inline  T_StatePhoneme (const T_NDSID& StateId_, const ::std::vector< ::std::string >& PhonemeList_, const ::std::vector< ::std::string >& OrthographyList_);

    /**
     * Destructor
     */
    inline  ~T_StatePhoneme();

    /**
     * Assignment operator
     */
    inline T_StatePhoneme& operator = (const T_StatePhoneme& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_StatePhoneme& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_StatePhoneme& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_StatePhoneme& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_StatePhoneme& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StateId"

    static const int kStateId = 0;

    /**
     * Clears the field "StateId".
     *
     * The field will be set to its default value. The hasStateId()
     * method will return false.
     */
    inline void clearStateId();

    /**
     * Checks whether the field "StateId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStateId()). Otherwise it will return false.
     */
    inline bool hasStateId () const;

    /**
     * Returns the value of the member "StateId".
     *
     * The Id of destination element
     *
     * @return The value of the field "StateId"
     */
    inline const T_NDSID& getStateId () const;

    /**
     * Retrieves the value of the field "StateId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StateId".
     */
    inline T_NDSID& getStateIdMutable ();

    /**
     * Sets the value of the member "StateId".
     *
     * The Id of destination element
     *
     * @param StateId The value which will be set
     */
    inline void setStateId (const T_NDSID& StateId_);

    // API of field "PhonemeList"

    static const int kPhonemeList = 1;

    /**
     * Clears the field "PhonemeList".
     *
     * The field will be set to its default value. The hasPhonemeList()
     * method will return false.
     */
    inline void clearPhonemeList();

    /**
     * Checks whether the field "PhonemeList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonemeList()). Otherwise it will return false.
     */
    inline bool hasPhonemeList () const;

    /**
     * Returns the value of the member "PhonemeList".
     *
     * List of phonemes for the state-name.
     *
     * @return The value of the field "PhonemeList"
     */
    inline const ::std::vector< ::std::string >& getPhonemeList () const;

    /**
     * Retrieves the value of the field "PhonemeList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhonemeList".
     */
    inline ::std::vector< ::std::string >& getPhonemeListMutable ();

    /**
     * Sets the value of the member "PhonemeList".
     *
     * List of phonemes for the state-name.
     *
     * @param PhonemeList The value which will be set
     */
    inline void setPhonemeList (const ::std::vector< ::std::string >& PhonemeList_);

    // API of field "OrthographyList"

    static const int kOrthographyList = 2;

    /**
     * Clears the field "OrthographyList".
     *
     * The field will be set to its default value. The hasOrthographyList()
     * method will return false.
     */
    inline void clearOrthographyList();

    /**
     * Checks whether the field "OrthographyList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOrthographyList()). Otherwise it will return false.
     */
    inline bool hasOrthographyList () const;

    /**
     * Returns the value of the member "OrthographyList".
     *
     * List of orthography for the state-name.
     *
     * @return The value of the field "OrthographyList"
     */
    inline const ::std::vector< ::std::string >& getOrthographyList () const;

    /**
     * Retrieves the value of the field "OrthographyList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OrthographyList".
     */
    inline ::std::vector< ::std::string >& getOrthographyListMutable ();

    /**
     * Sets the value of the member "OrthographyList".
     *
     * List of orthography for the state-name.
     *
     * @param OrthographyList The value which will be set
     */
    inline void setOrthographyList (const ::std::vector< ::std::string >& OrthographyList_);

    static const T_StatePhoneme &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_StateId ();

    inline void clear_has_StateId ();

    inline void set_has_PhonemeList ();

    inline void clear_has_PhonemeList ();

    inline void set_has_OrthographyList ();

    inline void clear_has_OrthographyList ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_NDSID _StateId;

    ::std::vector< ::std::string > _PhonemeList;

    ::std::vector< ::std::string > _OrthographyList;

};

/**
 * Country information covered by the navi data
 */
class T_CountryPhoneme {
public:

    /**
     * Default constructor
     */
    inline  T_CountryPhoneme ();

    /**
     * Copy constructor
     */
    inline  T_CountryPhoneme (const T_CountryPhoneme &rhs);

    /**
     * All fields constructor
     */
    inline  T_CountryPhoneme (const T_NDSID& CountryId_, const ::std::vector< ::std::string >& PhonemeList_, const ::std::vector< ::std::string >& OrthographyList_, const ::std::vector< T_StatePhoneme >& StateList_, ::fi_types::T_e16_ISOCountryCode CountryCode_);

    /**
     * Destructor
     */
    inline  ~T_CountryPhoneme();

    /**
     * Assignment operator
     */
    inline T_CountryPhoneme& operator = (const T_CountryPhoneme& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CountryPhoneme& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CountryPhoneme& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CountryPhoneme& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CountryPhoneme& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CountryId"

    static const int kCountryId = 0;

    /**
     * Clears the field "CountryId".
     *
     * The field will be set to its default value. The hasCountryId()
     * method will return false.
     */
    inline void clearCountryId();

    /**
     * Checks whether the field "CountryId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryId()). Otherwise it will return false.
     */
    inline bool hasCountryId () const;

    /**
     * Returns the value of the member "CountryId".
     *
     * The Id of destination element
     *
     * @return The value of the field "CountryId"
     */
    inline const T_NDSID& getCountryId () const;

    /**
     * Retrieves the value of the field "CountryId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CountryId".
     */
    inline T_NDSID& getCountryIdMutable ();

    /**
     * Sets the value of the member "CountryId".
     *
     * The Id of destination element
     *
     * @param CountryId The value which will be set
     */
    inline void setCountryId (const T_NDSID& CountryId_);

    // API of field "PhonemeList"

    static const int kPhonemeList = 1;

    /**
     * Clears the field "PhonemeList".
     *
     * The field will be set to its default value. The hasPhonemeList()
     * method will return false.
     */
    inline void clearPhonemeList();

    /**
     * Checks whether the field "PhonemeList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonemeList()). Otherwise it will return false.
     */
    inline bool hasPhonemeList () const;

    /**
     * Returns the value of the member "PhonemeList".
     *
     * List of phonemes for the country-name.
     *
     * @return The value of the field "PhonemeList"
     */
    inline const ::std::vector< ::std::string >& getPhonemeList () const;

    /**
     * Retrieves the value of the field "PhonemeList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhonemeList".
     */
    inline ::std::vector< ::std::string >& getPhonemeListMutable ();

    /**
     * Sets the value of the member "PhonemeList".
     *
     * List of phonemes for the country-name.
     *
     * @param PhonemeList The value which will be set
     */
    inline void setPhonemeList (const ::std::vector< ::std::string >& PhonemeList_);

    // API of field "OrthographyList"

    static const int kOrthographyList = 2;

    /**
     * Clears the field "OrthographyList".
     *
     * The field will be set to its default value. The hasOrthographyList()
     * method will return false.
     */
    inline void clearOrthographyList();

    /**
     * Checks whether the field "OrthographyList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOrthographyList()). Otherwise it will return false.
     */
    inline bool hasOrthographyList () const;

    /**
     * Returns the value of the member "OrthographyList".
     *
     * List of orthography for the country-name.
     *
     * @return The value of the field "OrthographyList"
     */
    inline const ::std::vector< ::std::string >& getOrthographyList () const;

    /**
     * Retrieves the value of the field "OrthographyList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OrthographyList".
     */
    inline ::std::vector< ::std::string >& getOrthographyListMutable ();

    /**
     * Sets the value of the member "OrthographyList".
     *
     * List of orthography for the country-name.
     *
     * @param OrthographyList The value which will be set
     */
    inline void setOrthographyList (const ::std::vector< ::std::string >& OrthographyList_);

    // API of field "StateList"

    static const int kStateList = 3;

    /**
     * Clears the field "StateList".
     *
     * The field will be set to its default value. The hasStateList()
     * method will return false.
     */
    inline void clearStateList();

    /**
     * Checks whether the field "StateList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStateList()). Otherwise it will return false.
     */
    inline bool hasStateList () const;

    /**
     * Returns the value of the member "StateList".
     *
     * IList of states belonging to the country.
     *
     * @return The value of the field "StateList"
     */
    inline const ::std::vector< T_StatePhoneme >& getStateList () const;

    /**
     * Retrieves the value of the field "StateList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StateList".
     */
    inline ::std::vector< T_StatePhoneme >& getStateListMutable ();

    /**
     * Sets the value of the member "StateList".
     *
     * IList of states belonging to the country.
     *
     * @param StateList The value which will be set
     */
    inline void setStateList (const ::std::vector< T_StatePhoneme >& StateList_);

    // API of field "CountryCode"

    static const int kCountryCode = 4;

    /**
     * Clears the field "CountryCode".
     *
     * The field will be set to its default value. The hasCountryCode()
     * method will return false.
     */
    inline void clearCountryCode();

    /**
     * Checks whether the field "CountryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryCode()). Otherwise it will return false.
     */
    inline bool hasCountryCode () const;

    /**
     * Returns the value of the member "CountryCode".
     *
     * ISO code of the country
     *
     * @return The value of the field "CountryCode"
     */
    inline ::fi_types::T_e16_ISOCountryCode getCountryCode () const;

    /**
     * Sets the value of the member "CountryCode".
     *
     * ISO code of the country
     *
     * @param CountryCode The value which will be set
     */
    inline void setCountryCode (::fi_types::T_e16_ISOCountryCode CountryCode_);

    static const T_CountryPhoneme &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    static const ::std::vector< T_StatePhoneme >& getT_StatePhonemeList_DefaultInstance ();

    inline void set_has_CountryId ();

    inline void clear_has_CountryId ();

    inline void set_has_PhonemeList ();

    inline void clear_has_PhonemeList ();

    inline void set_has_OrthographyList ();

    inline void clear_has_OrthographyList ();

    inline void set_has_StateList ();

    inline void clear_has_StateList ();

    inline void set_has_CountryCode ();

    inline void clear_has_CountryCode ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_NDSID _CountryId;

    ::std::vector< ::std::string > _PhonemeList;

    ::std::vector< ::std::string > _OrthographyList;

    ::std::vector< T_StatePhoneme > _StateList;

    ::fi_types::T_e16_ISOCountryCode _CountryCode;

};

/**
 * City information covered by the navi data
 */
class T_CityId {
public:

    /**
     * Default constructor
     */
    inline  T_CityId ();

    /**
     * Copy constructor
     */
    inline  T_CityId (const T_CityId &rhs);

    /**
     * All fields constructor
     */
    inline  T_CityId (const T_NDSID& City_ID__);

    /**
     * Destructor
     */
    inline  ~T_CityId();

    /**
     * Assignment operator
     */
    inline T_CityId& operator = (const T_CityId& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CityId& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CityId& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CityId& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CityId& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "City_ID_"

    static const int kCity_ID_ = 0;

    /**
     * Clears the field "City_ID_".
     *
     * The field will be set to its default value. The hasCity_ID_()
     * method will return false.
     */
    inline void clearCity_ID_();

    /**
     * Checks whether the field "City_ID_" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCity_ID_()). Otherwise it will return false.
     */
    inline bool hasCity_ID_ () const;

    /**
     * Returns the value of the member "City_ID_".
     *
     * The Id of destination element
     *
     * @return The value of the field "City_ID_"
     */
    inline const T_NDSID& getCity_ID_ () const;

    /**
     * Retrieves the value of the field "City_ID_" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "City_ID_".
     */
    inline T_NDSID& getCity_ID_Mutable ();

    /**
     * Sets the value of the member "City_ID_".
     *
     * The Id of destination element
     *
     * @param City_ID_ The value which will be set
     */
    inline void setCity_ID_ (const T_NDSID& City_ID__);

    static const T_CityId &getDefaultInstance();

private:

    inline void set_has_City_ID_ ();

    inline void clear_has_City_ID_ ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_NDSID _City_ID_;

};

class T_ECNR_ASR_Mode_Status {
public:

    /**
     * Default constructor
     */
    inline  T_ECNR_ASR_Mode_Status ();

    /**
     * Copy constructor
     */
    inline  T_ECNR_ASR_Mode_Status (const T_ECNR_ASR_Mode_Status &rhs);

    /**
     * All fields constructor
     */
    inline  T_ECNR_ASR_Mode_Status (bool Mode_Enable_, T_e32_SSE_ASR_Mode Mode_Status_);

    /**
     * Destructor
     */
    inline  ~T_ECNR_ASR_Mode_Status();

    /**
     * Assignment operator
     */
    inline T_ECNR_ASR_Mode_Status& operator = (const T_ECNR_ASR_Mode_Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ECNR_ASR_Mode_Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ECNR_ASR_Mode_Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ECNR_ASR_Mode_Status& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ECNR_ASR_Mode_Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Mode_Enable"

    static const int kMode_Enable = 0;

    /**
     * Clears the field "Mode_Enable".
     *
     * The field will be set to its default value. The hasMode_Enable()
     * method will return false.
     */
    inline void clearMode_Enable();

    /**
     * Checks whether the field "Mode_Enable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode_Enable()). Otherwise it will return false.
     */
    inline bool hasMode_Enable () const;

    /**
     * Returns the value of the member "Mode_Enable".
     *
     * TRUE is ECNR mode is enabled.
     *
     * @return The value of the field "Mode_Enable"
     */
    inline bool getMode_Enable () const;

    /**
     * Sets the value of the member "Mode_Enable".
     *
     * TRUE is ECNR mode is enabled.
     *
     * @param Mode_Enable The value which will be set
     */
    inline void setMode_Enable (bool Mode_Enable_);

    // API of field "Mode_Status"

    static const int kMode_Status = 1;

    /**
     * Clears the field "Mode_Status".
     *
     * The field will be set to its default value. The hasMode_Status()
     * method will return false.
     */
    inline void clearMode_Status();

    /**
     * Checks whether the field "Mode_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode_Status()). Otherwise it will return false.
     */
    inline bool hasMode_Status () const;

    /**
     * Returns the value of the member "Mode_Status".
     *
     *
     *
     * @return The value of the field "Mode_Status"
     */
    inline T_e32_SSE_ASR_Mode getMode_Status () const;

    /**
     * Sets the value of the member "Mode_Status".
     *
     *
     *
     * @param Mode_Status The value which will be set
     */
    inline void setMode_Status (T_e32_SSE_ASR_Mode Mode_Status_);

    static const T_ECNR_ASR_Mode_Status &getDefaultInstance();

private:

    inline void set_has_Mode_Enable ();

    inline void clear_has_Mode_Enable ();

    inline void set_has_Mode_Status ();

    inline void clear_has_Mode_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _Mode_Enable;

    T_e32_SSE_ASR_Mode _Mode_Status;

};

inline  T_SDSLanguageID::T_SDSLanguageID ()  :
    _ISO639_3_SDSLanguageCode (::sds_sds2hmi_common_types::T_e16_ISO639_3_SDSLanguageCode__ISO_639_3_Invalid),
    _ISO3166_CountryCode (::fi_types::T_e16_ISOCountryCode__ISO_ALPHA_3_UNDEFINED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SDSLanguageID::T_SDSLanguageID (const T_SDSLanguageID &rhs)  :
    _ISO639_3_SDSLanguageCode (::sds_sds2hmi_common_types::T_e16_ISO639_3_SDSLanguageCode__ISO_639_3_Invalid),
    _ISO3166_CountryCode (::fi_types::T_e16_ISOCountryCode__ISO_ALPHA_3_UNDEFINED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SDSLanguageID::T_SDSLanguageID (T_e16_ISO639_3_SDSLanguageCode ISO639_3_SDSLanguageCode_, ::fi_types::T_e16_ISOCountryCode ISO3166_CountryCode_)  :
    _ISO639_3_SDSLanguageCode (ISO639_3_SDSLanguageCode_),
    _ISO3166_CountryCode (ISO3166_CountryCode_)
{
    #ifndef NDEBUG
    if (!(T_e16_ISO639_3_SDSLanguageCode_IsValid(ISO639_3_SDSLanguageCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ISO639_3_SDSLanguageCode_, "T_e16_ISO639_3_SDSLanguageCode", "ISO639_3_SDSLanguageCode", "T_SDSLanguageID");
    }
    #endif
    #ifndef NDEBUG
    if (!(::fi_types::T_e16_ISOCountryCode_IsValid(ISO3166_CountryCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ISO3166_CountryCode_, "T_e16_ISOCountryCode", "ISO3166_CountryCode", "T_SDSLanguageID");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SDSLanguageID::~T_SDSLanguageID() {
}

inline T_SDSLanguageID& T_SDSLanguageID::operator = (const T_SDSLanguageID& rhs) {
    if( this != &rhs ) {
        if (rhs.hasISO639_3_SDSLanguageCode()) {
            setISO639_3_SDSLanguageCode(rhs.getISO639_3_SDSLanguageCode());
        } else {
            clearISO639_3_SDSLanguageCode();
        }
        if (rhs.hasISO3166_CountryCode()) {
            setISO3166_CountryCode(rhs.getISO3166_CountryCode());
        } else {
            clearISO3166_CountryCode();
        }
    }
    return *this;
}

inline bool T_SDSLanguageID::operator == (const T_SDSLanguageID& rhs) const {
    return (((!hasISO639_3_SDSLanguageCode() && !rhs.hasISO639_3_SDSLanguageCode()) || getISO639_3_SDSLanguageCode() == rhs.getISO639_3_SDSLanguageCode()) &&
        ((!hasISO3166_CountryCode() && !rhs.hasISO3166_CountryCode()) || getISO3166_CountryCode() == rhs.getISO3166_CountryCode()));
}

inline bool T_SDSLanguageID::operator != (const T_SDSLanguageID& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SDSLanguageID::operator < (const T_SDSLanguageID& rhs) const {
    if (hasISO639_3_SDSLanguageCode() || rhs.hasISO639_3_SDSLanguageCode()) {
        if ((uint32)getISO639_3_SDSLanguageCode() < (uint32)rhs.getISO639_3_SDSLanguageCode()) return true;
        if ((uint32)getISO639_3_SDSLanguageCode() > (uint32)rhs.getISO639_3_SDSLanguageCode()) return false;
    }
    if (hasISO3166_CountryCode() || rhs.hasISO3166_CountryCode()) {
        if ((uint32)getISO3166_CountryCode() < (uint32)rhs.getISO3166_CountryCode()) return true;
        if ((uint32)getISO3166_CountryCode() > (uint32)rhs.getISO3166_CountryCode()) return false;
    }
    return false;
}

inline bool T_SDSLanguageID::operator > (const T_SDSLanguageID& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SDSLanguageID::clear() {
    clearISO639_3_SDSLanguageCode();
    clearISO3166_CountryCode();
}

inline void T_SDSLanguageID::clearISO639_3_SDSLanguageCode() {
    if (hasISO639_3_SDSLanguageCode()) {
         clear_has_ISO639_3_SDSLanguageCode();
        _ISO639_3_SDSLanguageCode = ::sds_sds2hmi_common_types::T_e16_ISO639_3_SDSLanguageCode__ISO_639_3_Invalid;
     }
}

inline bool T_SDSLanguageID::hasISO639_3_SDSLanguageCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e16_ISO639_3_SDSLanguageCode T_SDSLanguageID::getISO639_3_SDSLanguageCode () const {
    return _ISO639_3_SDSLanguageCode;
}

inline void T_SDSLanguageID::setISO639_3_SDSLanguageCode (T_e16_ISO639_3_SDSLanguageCode ISO639_3_SDSLanguageCode_) {
    #ifndef NDEBUG
    if (!(T_e16_ISO639_3_SDSLanguageCode_IsValid(ISO639_3_SDSLanguageCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ISO639_3_SDSLanguageCode_, "T_e16_ISO639_3_SDSLanguageCode", "ISO639_3_SDSLanguageCode", "T_SDSLanguageID");
    }
    #endif
    set_has_ISO639_3_SDSLanguageCode();
    this->_ISO639_3_SDSLanguageCode = ISO639_3_SDSLanguageCode_;
}

inline void T_SDSLanguageID::clearISO3166_CountryCode() {
    if (hasISO3166_CountryCode()) {
         clear_has_ISO3166_CountryCode();
        _ISO3166_CountryCode = ::fi_types::T_e16_ISOCountryCode__ISO_ALPHA_3_UNDEFINED;
     }
}

inline bool T_SDSLanguageID::hasISO3166_CountryCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::fi_types::T_e16_ISOCountryCode T_SDSLanguageID::getISO3166_CountryCode () const {
    return _ISO3166_CountryCode;
}

inline void T_SDSLanguageID::setISO3166_CountryCode (::fi_types::T_e16_ISOCountryCode ISO3166_CountryCode_) {
    #ifndef NDEBUG
    if (!(::fi_types::T_e16_ISOCountryCode_IsValid(ISO3166_CountryCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ISO3166_CountryCode_, "T_e16_ISOCountryCode", "ISO3166_CountryCode", "T_SDSLanguageID");
    }
    #endif
    set_has_ISO3166_CountryCode();
    this->_ISO3166_CountryCode = ISO3166_CountryCode_;
}

inline void T_SDSLanguageID::set_has_ISO639_3_SDSLanguageCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SDSLanguageID::clear_has_ISO639_3_SDSLanguageCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SDSLanguageID::set_has_ISO3166_CountryCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SDSLanguageID::clear_has_ISO3166_CountryCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_ConnectedDeviceStatus::T_ConnectedDeviceStatus ()  :
    _u32DeviceId (0u),
    _tenDomain (::sds_sds2hmi_common_types::T_e8_Domain__UNKNOWN),
    _UpdateStatus (::sds_sds2hmi_common_types::T_e8_ConnectedDeviceUpdateStatus__DeviceUnavailable)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ConnectedDeviceStatus::T_ConnectedDeviceStatus (const T_ConnectedDeviceStatus &rhs)  :
    _u32DeviceId (0u),
    _tenDomain (::sds_sds2hmi_common_types::T_e8_Domain__UNKNOWN),
    _UpdateStatus (::sds_sds2hmi_common_types::T_e8_ConnectedDeviceUpdateStatus__DeviceUnavailable)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ConnectedDeviceStatus::T_ConnectedDeviceStatus (uint32 u32DeviceId_, T_e8_Domain tenDomain_, T_e8_ConnectedDeviceUpdateStatus UpdateStatus_)  :
    _u32DeviceId (u32DeviceId_),
    _tenDomain (tenDomain_),
    _UpdateStatus (UpdateStatus_)
{
    #ifndef NDEBUG
    if (!(T_e8_Domain_IsValid(tenDomain_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tenDomain_, "T_e8_Domain", "tenDomain", "T_ConnectedDeviceStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_ConnectedDeviceUpdateStatus_IsValid(UpdateStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", UpdateStatus_, "T_e8_ConnectedDeviceUpdateStatus", "UpdateStatus", "T_ConnectedDeviceStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ConnectedDeviceStatus::~T_ConnectedDeviceStatus() {
}

inline T_ConnectedDeviceStatus& T_ConnectedDeviceStatus::operator = (const T_ConnectedDeviceStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32DeviceId()) {
            setU32DeviceId(rhs.getU32DeviceId());
        } else {
            clearU32DeviceId();
        }
        if (rhs.hasTenDomain()) {
            setTenDomain(rhs.getTenDomain());
        } else {
            clearTenDomain();
        }
        if (rhs.hasUpdateStatus()) {
            setUpdateStatus(rhs.getUpdateStatus());
        } else {
            clearUpdateStatus();
        }
    }
    return *this;
}

inline bool T_ConnectedDeviceStatus::operator == (const T_ConnectedDeviceStatus& rhs) const {
    return (((!hasU32DeviceId() && !rhs.hasU32DeviceId()) || getU32DeviceId() == rhs.getU32DeviceId()) &&
        ((!hasTenDomain() && !rhs.hasTenDomain()) || getTenDomain() == rhs.getTenDomain()) &&
        ((!hasUpdateStatus() && !rhs.hasUpdateStatus()) || getUpdateStatus() == rhs.getUpdateStatus()));
}

inline bool T_ConnectedDeviceStatus::operator != (const T_ConnectedDeviceStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ConnectedDeviceStatus::operator < (const T_ConnectedDeviceStatus& rhs) const {
    if (hasU32DeviceId() || rhs.hasU32DeviceId()) {
        if (getU32DeviceId() < rhs.getU32DeviceId()) return true;
        if (getU32DeviceId() > rhs.getU32DeviceId()) return false;
    }
    if (hasTenDomain() || rhs.hasTenDomain()) {
        if ((uint32)getTenDomain() < (uint32)rhs.getTenDomain()) return true;
        if ((uint32)getTenDomain() > (uint32)rhs.getTenDomain()) return false;
    }
    if (hasUpdateStatus() || rhs.hasUpdateStatus()) {
        if ((uint32)getUpdateStatus() < (uint32)rhs.getUpdateStatus()) return true;
        if ((uint32)getUpdateStatus() > (uint32)rhs.getUpdateStatus()) return false;
    }
    return false;
}

inline bool T_ConnectedDeviceStatus::operator > (const T_ConnectedDeviceStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ConnectedDeviceStatus::clear() {
    clearU32DeviceId();
    clearTenDomain();
    clearUpdateStatus();
}

inline void T_ConnectedDeviceStatus::clearU32DeviceId() {
    if (hasU32DeviceId()) {
         clear_has_u32DeviceId();
        _u32DeviceId = 0u;
     }
}

inline bool T_ConnectedDeviceStatus::hasU32DeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_ConnectedDeviceStatus::getU32DeviceId () const {
    return _u32DeviceId;
}

inline void T_ConnectedDeviceStatus::setU32DeviceId (uint32 u32DeviceId_) {
    set_has_u32DeviceId();
    this->_u32DeviceId = u32DeviceId_;
}

inline void T_ConnectedDeviceStatus::clearTenDomain() {
    if (hasTenDomain()) {
         clear_has_tenDomain();
        _tenDomain = ::sds_sds2hmi_common_types::T_e8_Domain__UNKNOWN;
     }
}

inline bool T_ConnectedDeviceStatus::hasTenDomain () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Domain T_ConnectedDeviceStatus::getTenDomain () const {
    return _tenDomain;
}

inline void T_ConnectedDeviceStatus::setTenDomain (T_e8_Domain tenDomain_) {
    #ifndef NDEBUG
    if (!(T_e8_Domain_IsValid(tenDomain_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tenDomain_, "T_e8_Domain", "tenDomain", "T_ConnectedDeviceStatus");
    }
    #endif
    set_has_tenDomain();
    this->_tenDomain = tenDomain_;
}

inline void T_ConnectedDeviceStatus::clearUpdateStatus() {
    if (hasUpdateStatus()) {
         clear_has_UpdateStatus();
        _UpdateStatus = ::sds_sds2hmi_common_types::T_e8_ConnectedDeviceUpdateStatus__DeviceUnavailable;
     }
}

inline bool T_ConnectedDeviceStatus::hasUpdateStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_ConnectedDeviceUpdateStatus T_ConnectedDeviceStatus::getUpdateStatus () const {
    return _UpdateStatus;
}

inline void T_ConnectedDeviceStatus::setUpdateStatus (T_e8_ConnectedDeviceUpdateStatus UpdateStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_ConnectedDeviceUpdateStatus_IsValid(UpdateStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", UpdateStatus_, "T_e8_ConnectedDeviceUpdateStatus", "UpdateStatus", "T_ConnectedDeviceStatus");
    }
    #endif
    set_has_UpdateStatus();
    this->_UpdateStatus = UpdateStatus_;
}

inline void T_ConnectedDeviceStatus::set_has_u32DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ConnectedDeviceStatus::clear_has_u32DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ConnectedDeviceStatus::set_has_tenDomain () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ConnectedDeviceStatus::clear_has_tenDomain () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ConnectedDeviceStatus::set_has_UpdateStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ConnectedDeviceStatus::clear_has_UpdateStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_NDSLanguageID::T_NDSLanguageID ()  :
    _LanguageCode (0u),
    _ISO_CountryCode (),
    _ISO_LanguageCode (),
    _ScriptCode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_NDSLanguageID::T_NDSLanguageID (const T_NDSLanguageID &rhs)  :
    _LanguageCode (0u),
    _ISO_CountryCode (),
    _ISO_LanguageCode (),
    _ScriptCode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_NDSLanguageID::T_NDSLanguageID (uint16 LanguageCode_, const ::std::string& ISO_CountryCode_, const ::std::string& ISO_LanguageCode_, const ::std::string& ScriptCode_)  :
    _LanguageCode (LanguageCode_),
    _ISO_CountryCode (ISO_CountryCode_),
    _ISO_LanguageCode (ISO_LanguageCode_),
    _ScriptCode (ScriptCode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ISO_CountryCode_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ISO_LanguageCode_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ScriptCode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_NDSLanguageID::~T_NDSLanguageID() {
}

inline T_NDSLanguageID& T_NDSLanguageID::operator = (const T_NDSLanguageID& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLanguageCode()) {
            setLanguageCode(rhs.getLanguageCode());
        } else {
            clearLanguageCode();
        }
        if (rhs.hasISO_CountryCode()) {
            setISO_CountryCode(rhs.getISO_CountryCode());
        } else {
            clearISO_CountryCode();
        }
        if (rhs.hasISO_LanguageCode()) {
            setISO_LanguageCode(rhs.getISO_LanguageCode());
        } else {
            clearISO_LanguageCode();
        }
        if (rhs.hasScriptCode()) {
            setScriptCode(rhs.getScriptCode());
        } else {
            clearScriptCode();
        }
    }
    return *this;
}

inline bool T_NDSLanguageID::operator == (const T_NDSLanguageID& rhs) const {
    return (((!hasLanguageCode() && !rhs.hasLanguageCode()) || getLanguageCode() == rhs.getLanguageCode()) &&
        ((!hasISO_CountryCode() && !rhs.hasISO_CountryCode()) || getISO_CountryCode() == rhs.getISO_CountryCode()) &&
        ((!hasISO_LanguageCode() && !rhs.hasISO_LanguageCode()) || getISO_LanguageCode() == rhs.getISO_LanguageCode()) &&
        ((!hasScriptCode() && !rhs.hasScriptCode()) || getScriptCode() == rhs.getScriptCode()));
}

inline bool T_NDSLanguageID::operator != (const T_NDSLanguageID& rhs) const {
    return ! (*this == rhs);
}

inline bool T_NDSLanguageID::operator < (const T_NDSLanguageID& rhs) const {
    if (hasLanguageCode() || rhs.hasLanguageCode()) {
        if (getLanguageCode() < rhs.getLanguageCode()) return true;
        if (getLanguageCode() > rhs.getLanguageCode()) return false;
    }
    if (hasISO_CountryCode() || rhs.hasISO_CountryCode()) {
        if (getISO_CountryCode() < rhs.getISO_CountryCode()) return true;
        if (getISO_CountryCode() > rhs.getISO_CountryCode()) return false;
    }
    if (hasISO_LanguageCode() || rhs.hasISO_LanguageCode()) {
        if (getISO_LanguageCode() < rhs.getISO_LanguageCode()) return true;
        if (getISO_LanguageCode() > rhs.getISO_LanguageCode()) return false;
    }
    if (hasScriptCode() || rhs.hasScriptCode()) {
        if (getScriptCode() < rhs.getScriptCode()) return true;
        if (getScriptCode() > rhs.getScriptCode()) return false;
    }
    return false;
}

inline bool T_NDSLanguageID::operator > (const T_NDSLanguageID& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_NDSLanguageID::clear() {
    clearLanguageCode();
    clearISO_CountryCode();
    clearISO_LanguageCode();
    clearScriptCode();
}

inline void T_NDSLanguageID::clearLanguageCode() {
    if (hasLanguageCode()) {
         clear_has_LanguageCode();
        _LanguageCode = 0u;
     }
}

inline bool T_NDSLanguageID::hasLanguageCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_NDSLanguageID::getLanguageCode () const {
    return _LanguageCode;
}

inline void T_NDSLanguageID::setLanguageCode (uint16 LanguageCode_) {
    set_has_LanguageCode();
    this->_LanguageCode = LanguageCode_;
}

inline void T_NDSLanguageID::clearISO_CountryCode() {
    if (hasISO_CountryCode()) {
         clear_has_ISO_CountryCode();
        _ISO_CountryCode.clear();
     }
}

inline bool T_NDSLanguageID::hasISO_CountryCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_NDSLanguageID::getISO_CountryCode () const {
    return _ISO_CountryCode;
}

inline ::std::string& T_NDSLanguageID::getISO_CountryCodeMutable () {
    set_has_ISO_CountryCode();
    return _ISO_CountryCode;
}

inline void T_NDSLanguageID::setISO_CountryCode (const ::std::string& ISO_CountryCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ISO_CountryCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ISO_CountryCode();
    this->_ISO_CountryCode = ISO_CountryCode_;
}

inline void T_NDSLanguageID::setISO_CountryCode (const char* ISO_CountryCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ISO_CountryCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ISO_CountryCode();
    this->_ISO_CountryCode.assign(ISO_CountryCode_);
}

inline void T_NDSLanguageID::setISO_CountryCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ISO_CountryCode();
    this->_ISO_CountryCode.assign(value, size);
}

inline void T_NDSLanguageID::clearISO_LanguageCode() {
    if (hasISO_LanguageCode()) {
         clear_has_ISO_LanguageCode();
        _ISO_LanguageCode.clear();
     }
}

inline bool T_NDSLanguageID::hasISO_LanguageCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_NDSLanguageID::getISO_LanguageCode () const {
    return _ISO_LanguageCode;
}

inline ::std::string& T_NDSLanguageID::getISO_LanguageCodeMutable () {
    set_has_ISO_LanguageCode();
    return _ISO_LanguageCode;
}

inline void T_NDSLanguageID::setISO_LanguageCode (const ::std::string& ISO_LanguageCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ISO_LanguageCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ISO_LanguageCode();
    this->_ISO_LanguageCode = ISO_LanguageCode_;
}

inline void T_NDSLanguageID::setISO_LanguageCode (const char* ISO_LanguageCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ISO_LanguageCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ISO_LanguageCode();
    this->_ISO_LanguageCode.assign(ISO_LanguageCode_);
}

inline void T_NDSLanguageID::setISO_LanguageCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ISO_LanguageCode();
    this->_ISO_LanguageCode.assign(value, size);
}

inline void T_NDSLanguageID::clearScriptCode() {
    if (hasScriptCode()) {
         clear_has_ScriptCode();
        _ScriptCode.clear();
     }
}

inline bool T_NDSLanguageID::hasScriptCode () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_NDSLanguageID::getScriptCode () const {
    return _ScriptCode;
}

inline ::std::string& T_NDSLanguageID::getScriptCodeMutable () {
    set_has_ScriptCode();
    return _ScriptCode;
}

inline void T_NDSLanguageID::setScriptCode (const ::std::string& ScriptCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ScriptCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ScriptCode();
    this->_ScriptCode = ScriptCode_;
}

inline void T_NDSLanguageID::setScriptCode (const char* ScriptCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ScriptCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ScriptCode();
    this->_ScriptCode.assign(ScriptCode_);
}

inline void T_NDSLanguageID::setScriptCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ScriptCode();
    this->_ScriptCode.assign(value, size);
}

inline void T_NDSLanguageID::set_has_LanguageCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_NDSLanguageID::clear_has_LanguageCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_NDSLanguageID::set_has_ISO_CountryCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_NDSLanguageID::clear_has_ISO_CountryCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_NDSLanguageID::set_has_ISO_LanguageCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_NDSLanguageID::clear_has_ISO_LanguageCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_NDSLanguageID::set_has_ScriptCode () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_NDSLanguageID::clear_has_ScriptCode () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_NDSID::T_NDSID ()  :
    _u16UpdateRegionId (0u),
    _u32ProductId (0u),
    _u8SupplierId (0u),
    _u32NDSId (0u),
    _eNDSFeatureType (::sds_sds2hmi_common_types::T_e8_NDSFeatureType__NAMEOBJECT),
    _POIRootRegionID (0u),
    _GlobalXRefId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_NDSID::T_NDSID (const T_NDSID &rhs)  :
    _u16UpdateRegionId (0u),
    _u32ProductId (0u),
    _u8SupplierId (0u),
    _u32NDSId (0u),
    _eNDSFeatureType (::sds_sds2hmi_common_types::T_e8_NDSFeatureType__NAMEOBJECT),
    _POIRootRegionID (0u),
    _GlobalXRefId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_NDSID::T_NDSID (uint16 u16UpdateRegionId_, uint32 u32ProductId_, uint8 u8SupplierId_, uint32 u32NDSId_, T_e8_NDSFeatureType eNDSFeatureType_, uint64 POIRootRegionID_, uint32 GlobalXRefId_)  :
    _u16UpdateRegionId (u16UpdateRegionId_),
    _u32ProductId (u32ProductId_),
    _u8SupplierId (u8SupplierId_),
    _u32NDSId (u32NDSId_),
    _eNDSFeatureType (eNDSFeatureType_),
    _POIRootRegionID (POIRootRegionID_),
    _GlobalXRefId (GlobalXRefId_)
{
    #ifndef NDEBUG
    if (!(T_e8_NDSFeatureType_IsValid(eNDSFeatureType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eNDSFeatureType_, "T_e8_NDSFeatureType", "eNDSFeatureType", "T_NDSID");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_NDSID::~T_NDSID() {
}

inline T_NDSID& T_NDSID::operator = (const T_NDSID& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16UpdateRegionId()) {
            setU16UpdateRegionId(rhs.getU16UpdateRegionId());
        } else {
            clearU16UpdateRegionId();
        }
        if (rhs.hasU32ProductId()) {
            setU32ProductId(rhs.getU32ProductId());
        } else {
            clearU32ProductId();
        }
        if (rhs.hasU8SupplierId()) {
            setU8SupplierId(rhs.getU8SupplierId());
        } else {
            clearU8SupplierId();
        }
        if (rhs.hasU32NDSId()) {
            setU32NDSId(rhs.getU32NDSId());
        } else {
            clearU32NDSId();
        }
        if (rhs.hasENDSFeatureType()) {
            setENDSFeatureType(rhs.getENDSFeatureType());
        } else {
            clearENDSFeatureType();
        }
        if (rhs.hasPOIRootRegionID()) {
            setPOIRootRegionID(rhs.getPOIRootRegionID());
        } else {
            clearPOIRootRegionID();
        }
        if (rhs.hasGlobalXRefId()) {
            setGlobalXRefId(rhs.getGlobalXRefId());
        } else {
            clearGlobalXRefId();
        }
    }
    return *this;
}

inline bool T_NDSID::operator == (const T_NDSID& rhs) const {
    return (((!hasU16UpdateRegionId() && !rhs.hasU16UpdateRegionId()) || getU16UpdateRegionId() == rhs.getU16UpdateRegionId()) &&
        ((!hasU32ProductId() && !rhs.hasU32ProductId()) || getU32ProductId() == rhs.getU32ProductId()) &&
        ((!hasU8SupplierId() && !rhs.hasU8SupplierId()) || getU8SupplierId() == rhs.getU8SupplierId()) &&
        ((!hasU32NDSId() && !rhs.hasU32NDSId()) || getU32NDSId() == rhs.getU32NDSId()) &&
        ((!hasENDSFeatureType() && !rhs.hasENDSFeatureType()) || getENDSFeatureType() == rhs.getENDSFeatureType()) &&
        ((!hasPOIRootRegionID() && !rhs.hasPOIRootRegionID()) || getPOIRootRegionID() == rhs.getPOIRootRegionID()) &&
        ((!hasGlobalXRefId() && !rhs.hasGlobalXRefId()) || getGlobalXRefId() == rhs.getGlobalXRefId()));
}

inline bool T_NDSID::operator != (const T_NDSID& rhs) const {
    return ! (*this == rhs);
}

inline bool T_NDSID::operator < (const T_NDSID& rhs) const {
    if (hasU16UpdateRegionId() || rhs.hasU16UpdateRegionId()) {
        if (getU16UpdateRegionId() < rhs.getU16UpdateRegionId()) return true;
        if (getU16UpdateRegionId() > rhs.getU16UpdateRegionId()) return false;
    }
    if (hasU32ProductId() || rhs.hasU32ProductId()) {
        if (getU32ProductId() < rhs.getU32ProductId()) return true;
        if (getU32ProductId() > rhs.getU32ProductId()) return false;
    }
    if (hasU8SupplierId() || rhs.hasU8SupplierId()) {
        if (getU8SupplierId() < rhs.getU8SupplierId()) return true;
        if (getU8SupplierId() > rhs.getU8SupplierId()) return false;
    }
    if (hasU32NDSId() || rhs.hasU32NDSId()) {
        if (getU32NDSId() < rhs.getU32NDSId()) return true;
        if (getU32NDSId() > rhs.getU32NDSId()) return false;
    }
    if (hasENDSFeatureType() || rhs.hasENDSFeatureType()) {
        if ((uint32)getENDSFeatureType() < (uint32)rhs.getENDSFeatureType()) return true;
        if ((uint32)getENDSFeatureType() > (uint32)rhs.getENDSFeatureType()) return false;
    }
    if (hasPOIRootRegionID() || rhs.hasPOIRootRegionID()) {
        if (getPOIRootRegionID() < rhs.getPOIRootRegionID()) return true;
        if (getPOIRootRegionID() > rhs.getPOIRootRegionID()) return false;
    }
    if (hasGlobalXRefId() || rhs.hasGlobalXRefId()) {
        if (getGlobalXRefId() < rhs.getGlobalXRefId()) return true;
        if (getGlobalXRefId() > rhs.getGlobalXRefId()) return false;
    }
    return false;
}

inline bool T_NDSID::operator > (const T_NDSID& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_NDSID::clear() {
    clearU16UpdateRegionId();
    clearU32ProductId();
    clearU8SupplierId();
    clearU32NDSId();
    clearENDSFeatureType();
    clearPOIRootRegionID();
    clearGlobalXRefId();
}

inline void T_NDSID::clearU16UpdateRegionId() {
    if (hasU16UpdateRegionId()) {
         clear_has_u16UpdateRegionId();
        _u16UpdateRegionId = 0u;
     }
}

inline bool T_NDSID::hasU16UpdateRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_NDSID::getU16UpdateRegionId () const {
    return _u16UpdateRegionId;
}

inline void T_NDSID::setU16UpdateRegionId (uint16 u16UpdateRegionId_) {
    set_has_u16UpdateRegionId();
    this->_u16UpdateRegionId = u16UpdateRegionId_;
}

inline void T_NDSID::clearU32ProductId() {
    if (hasU32ProductId()) {
         clear_has_u32ProductId();
        _u32ProductId = 0u;
     }
}

inline bool T_NDSID::hasU32ProductId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_NDSID::getU32ProductId () const {
    return _u32ProductId;
}

inline void T_NDSID::setU32ProductId (uint32 u32ProductId_) {
    set_has_u32ProductId();
    this->_u32ProductId = u32ProductId_;
}

inline void T_NDSID::clearU8SupplierId() {
    if (hasU8SupplierId()) {
         clear_has_u8SupplierId();
        _u8SupplierId = 0u;
     }
}

inline bool T_NDSID::hasU8SupplierId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_NDSID::getU8SupplierId () const {
    return _u8SupplierId;
}

inline void T_NDSID::setU8SupplierId (uint8 u8SupplierId_) {
    set_has_u8SupplierId();
    this->_u8SupplierId = u8SupplierId_;
}

inline void T_NDSID::clearU32NDSId() {
    if (hasU32NDSId()) {
         clear_has_u32NDSId();
        _u32NDSId = 0u;
     }
}

inline bool T_NDSID::hasU32NDSId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_NDSID::getU32NDSId () const {
    return _u32NDSId;
}

inline void T_NDSID::setU32NDSId (uint32 u32NDSId_) {
    set_has_u32NDSId();
    this->_u32NDSId = u32NDSId_;
}

inline void T_NDSID::clearENDSFeatureType() {
    if (hasENDSFeatureType()) {
         clear_has_eNDSFeatureType();
        _eNDSFeatureType = ::sds_sds2hmi_common_types::T_e8_NDSFeatureType__NAMEOBJECT;
     }
}

inline bool T_NDSID::hasENDSFeatureType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_NDSFeatureType T_NDSID::getENDSFeatureType () const {
    return _eNDSFeatureType;
}

inline void T_NDSID::setENDSFeatureType (T_e8_NDSFeatureType eNDSFeatureType_) {
    #ifndef NDEBUG
    if (!(T_e8_NDSFeatureType_IsValid(eNDSFeatureType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eNDSFeatureType_, "T_e8_NDSFeatureType", "eNDSFeatureType", "T_NDSID");
    }
    #endif
    set_has_eNDSFeatureType();
    this->_eNDSFeatureType = eNDSFeatureType_;
}

inline void T_NDSID::clearPOIRootRegionID() {
    if (hasPOIRootRegionID()) {
         clear_has_POIRootRegionID();
        _POIRootRegionID = 0u;
     }
}

inline bool T_NDSID::hasPOIRootRegionID () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint64 T_NDSID::getPOIRootRegionID () const {
    return _POIRootRegionID;
}

inline void T_NDSID::setPOIRootRegionID (uint64 POIRootRegionID_) {
    set_has_POIRootRegionID();
    this->_POIRootRegionID = POIRootRegionID_;
}

inline void T_NDSID::clearGlobalXRefId() {
    if (hasGlobalXRefId()) {
         clear_has_GlobalXRefId();
        _GlobalXRefId = 0u;
     }
}

inline bool T_NDSID::hasGlobalXRefId () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint32 T_NDSID::getGlobalXRefId () const {
    return _GlobalXRefId;
}

inline void T_NDSID::setGlobalXRefId (uint32 GlobalXRefId_) {
    set_has_GlobalXRefId();
    this->_GlobalXRefId = GlobalXRefId_;
}

inline void T_NDSID::set_has_u16UpdateRegionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_NDSID::clear_has_u16UpdateRegionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_NDSID::set_has_u32ProductId () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_NDSID::clear_has_u32ProductId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_NDSID::set_has_u8SupplierId () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_NDSID::clear_has_u8SupplierId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_NDSID::set_has_u32NDSId () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_NDSID::clear_has_u32NDSId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_NDSID::set_has_eNDSFeatureType () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_NDSID::clear_has_eNDSFeatureType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_NDSID::set_has_POIRootRegionID () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_NDSID::clear_has_POIRootRegionID () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_NDSID::set_has_GlobalXRefId () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_NDSID::clear_has_GlobalXRefId () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_StreetAvailability::T_StreetAvailability ()  :
    _City_Id (),
    _Availability (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_StreetAvailability::T_StreetAvailability (const T_StreetAvailability &rhs)  :
    _City_Id (),
    _Availability (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_StreetAvailability::T_StreetAvailability (const T_NDSID& City_Id_, bool Availability_)  :
    _City_Id (City_Id_),
    _Availability (Availability_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_StreetAvailability::~T_StreetAvailability() {
}

inline T_StreetAvailability& T_StreetAvailability::operator = (const T_StreetAvailability& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCity_Id()) {
            setCity_Id(rhs.getCity_Id());
        } else {
            clearCity_Id();
        }
        if (rhs.hasAvailability()) {
            setAvailability(rhs.getAvailability());
        } else {
            clearAvailability();
        }
    }
    return *this;
}

inline bool T_StreetAvailability::operator == (const T_StreetAvailability& rhs) const {
    return (((!hasCity_Id() && !rhs.hasCity_Id()) || getCity_Id() == rhs.getCity_Id()) &&
        ((!hasAvailability() && !rhs.hasAvailability()) || getAvailability() == rhs.getAvailability()));
}

inline bool T_StreetAvailability::operator != (const T_StreetAvailability& rhs) const {
    return ! (*this == rhs);
}

inline bool T_StreetAvailability::operator < (const T_StreetAvailability& rhs) const {
    if (hasCity_Id() || rhs.hasCity_Id()) {
        if (getCity_Id() < rhs.getCity_Id()) return true;
        if (getCity_Id() > rhs.getCity_Id()) return false;
    }
    if (hasAvailability() || rhs.hasAvailability()) {
        if (getAvailability() < rhs.getAvailability()) return true;
        if (getAvailability() > rhs.getAvailability()) return false;
    }
    return false;
}

inline bool T_StreetAvailability::operator > (const T_StreetAvailability& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_StreetAvailability::clear() {
    clearCity_Id();
    clearAvailability();
}

inline void T_StreetAvailability::clearCity_Id() {
    if (hasCity_Id()) {
         clear_has_City_Id();
        _City_Id.clear();
     }
}

inline bool T_StreetAvailability::hasCity_Id () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_NDSID& T_StreetAvailability::getCity_Id () const {
    return _City_Id;
}

inline T_NDSID& T_StreetAvailability::getCity_IdMutable () {
    set_has_City_Id();
    return _City_Id;
}

inline void T_StreetAvailability::setCity_Id (const T_NDSID& City_Id_) {
    set_has_City_Id();
    this->_City_Id = City_Id_;
}

inline void T_StreetAvailability::clearAvailability() {
    if (hasAvailability()) {
         clear_has_Availability();
        _Availability = false;
     }
}

inline bool T_StreetAvailability::hasAvailability () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_StreetAvailability::getAvailability () const {
    return _Availability;
}

inline void T_StreetAvailability::setAvailability (bool Availability_) {
    set_has_Availability();
    this->_Availability = Availability_;
}

inline void T_StreetAvailability::set_has_City_Id () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_StreetAvailability::clear_has_City_Id () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_StreetAvailability::set_has_Availability () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_StreetAvailability::clear_has_Availability () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_PhonemeForLanguage::T_PhonemeForLanguage ()  :
    _Language (),
    _Phoneme ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PhonemeForLanguage::T_PhonemeForLanguage (const T_PhonemeForLanguage &rhs)  :
    _Language (),
    _Phoneme ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PhonemeForLanguage::T_PhonemeForLanguage (const T_NDSLanguageID& Language_, const ::std::string& Phoneme_)  :
    _Language (Language_),
    _Phoneme (Phoneme_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Phoneme_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PhonemeForLanguage::~T_PhonemeForLanguage() {
}

inline T_PhonemeForLanguage& T_PhonemeForLanguage::operator = (const T_PhonemeForLanguage& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLanguage()) {
            setLanguage(rhs.getLanguage());
        } else {
            clearLanguage();
        }
        if (rhs.hasPhoneme()) {
            setPhoneme(rhs.getPhoneme());
        } else {
            clearPhoneme();
        }
    }
    return *this;
}

inline bool T_PhonemeForLanguage::operator == (const T_PhonemeForLanguage& rhs) const {
    return (((!hasLanguage() && !rhs.hasLanguage()) || getLanguage() == rhs.getLanguage()) &&
        ((!hasPhoneme() && !rhs.hasPhoneme()) || getPhoneme() == rhs.getPhoneme()));
}

inline bool T_PhonemeForLanguage::operator != (const T_PhonemeForLanguage& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PhonemeForLanguage::operator < (const T_PhonemeForLanguage& rhs) const {
    if (hasLanguage() || rhs.hasLanguage()) {
        if (getLanguage() < rhs.getLanguage()) return true;
        if (getLanguage() > rhs.getLanguage()) return false;
    }
    if (hasPhoneme() || rhs.hasPhoneme()) {
        if (getPhoneme() < rhs.getPhoneme()) return true;
        if (getPhoneme() > rhs.getPhoneme()) return false;
    }
    return false;
}

inline bool T_PhonemeForLanguage::operator > (const T_PhonemeForLanguage& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PhonemeForLanguage::clear() {
    clearLanguage();
    clearPhoneme();
}

inline void T_PhonemeForLanguage::clearLanguage() {
    if (hasLanguage()) {
         clear_has_Language();
        _Language.clear();
     }
}

inline bool T_PhonemeForLanguage::hasLanguage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_NDSLanguageID& T_PhonemeForLanguage::getLanguage () const {
    return _Language;
}

inline T_NDSLanguageID& T_PhonemeForLanguage::getLanguageMutable () {
    set_has_Language();
    return _Language;
}

inline void T_PhonemeForLanguage::setLanguage (const T_NDSLanguageID& Language_) {
    set_has_Language();
    this->_Language = Language_;
}

inline void T_PhonemeForLanguage::clearPhoneme() {
    if (hasPhoneme()) {
         clear_has_Phoneme();
        _Phoneme.clear();
     }
}

inline bool T_PhonemeForLanguage::hasPhoneme () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_PhonemeForLanguage::getPhoneme () const {
    return _Phoneme;
}

inline ::std::string& T_PhonemeForLanguage::getPhonemeMutable () {
    set_has_Phoneme();
    return _Phoneme;
}

inline void T_PhonemeForLanguage::setPhoneme (const ::std::string& Phoneme_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Phoneme_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Phoneme();
    this->_Phoneme = Phoneme_;
}

inline void T_PhonemeForLanguage::setPhoneme (const char* Phoneme_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Phoneme_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Phoneme();
    this->_Phoneme.assign(Phoneme_);
}

inline void T_PhonemeForLanguage::setPhoneme (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Phoneme();
    this->_Phoneme.assign(value, size);
}

inline void T_PhonemeForLanguage::set_has_Language () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PhonemeForLanguage::clear_has_Language () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PhonemeForLanguage::set_has_Phoneme () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PhonemeForLanguage::clear_has_Phoneme () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_StringAndPhoneme::T_StringAndPhoneme ()  :
    _NDSId (),
    _OrthographyList (),
    _PhonemeAndLanguageList (),
    _DestItemtype (::sds_sds2hmi_common_types::T_e8_SDSDestinationType__Reserved)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_StringAndPhoneme::T_StringAndPhoneme (const T_StringAndPhoneme &rhs)  :
    _NDSId (),
    _OrthographyList (),
    _PhonemeAndLanguageList (),
    _DestItemtype (::sds_sds2hmi_common_types::T_e8_SDSDestinationType__Reserved)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_StringAndPhoneme::T_StringAndPhoneme (const T_NDSID& NDSId_, const ::std::vector< ::std::string >& OrthographyList_, const ::std::vector< T_PhonemeForLanguage >& PhonemeAndLanguageList_, T_e8_SDSDestinationType DestItemtype_)  :
    _NDSId (NDSId_),
    _OrthographyList (OrthographyList_),
    _PhonemeAndLanguageList (PhonemeAndLanguageList_),
    _DestItemtype (DestItemtype_)
{
    #ifndef NDEBUG
    if (!(T_e8_SDSDestinationType_IsValid(DestItemtype_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DestItemtype_, "T_e8_SDSDestinationType", "DestItemtype", "T_StringAndPhoneme");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_StringAndPhoneme::~T_StringAndPhoneme() {
}

inline T_StringAndPhoneme& T_StringAndPhoneme::operator = (const T_StringAndPhoneme& rhs) {
    if( this != &rhs ) {
        if (rhs.hasNDSId()) {
            setNDSId(rhs.getNDSId());
        } else {
            clearNDSId();
        }
        if (rhs.hasOrthographyList()) {
            setOrthographyList(rhs.getOrthographyList());
        } else {
            clearOrthographyList();
        }
        if (rhs.hasPhonemeAndLanguageList()) {
            setPhonemeAndLanguageList(rhs.getPhonemeAndLanguageList());
        } else {
            clearPhonemeAndLanguageList();
        }
        if (rhs.hasDestItemtype()) {
            setDestItemtype(rhs.getDestItemtype());
        } else {
            clearDestItemtype();
        }
    }
    return *this;
}

inline bool T_StringAndPhoneme::operator == (const T_StringAndPhoneme& rhs) const {
    return (((!hasNDSId() && !rhs.hasNDSId()) || getNDSId() == rhs.getNDSId()) &&
        ((!hasOrthographyList() && !rhs.hasOrthographyList()) || getOrthographyList() == rhs.getOrthographyList()) &&
        ((!hasPhonemeAndLanguageList() && !rhs.hasPhonemeAndLanguageList()) || getPhonemeAndLanguageList() == rhs.getPhonemeAndLanguageList()) &&
        ((!hasDestItemtype() && !rhs.hasDestItemtype()) || getDestItemtype() == rhs.getDestItemtype()));
}

inline bool T_StringAndPhoneme::operator != (const T_StringAndPhoneme& rhs) const {
    return ! (*this == rhs);
}

inline bool T_StringAndPhoneme::operator < (const T_StringAndPhoneme& rhs) const {
    if (hasNDSId() || rhs.hasNDSId()) {
        if (getNDSId() < rhs.getNDSId()) return true;
        if (getNDSId() > rhs.getNDSId()) return false;
    }
    if (hasOrthographyList() || rhs.hasOrthographyList()) {
        if (getOrthographyList() < rhs.getOrthographyList()) return true;
        if (getOrthographyList() > rhs.getOrthographyList()) return false;
    }
    if (hasPhonemeAndLanguageList() || rhs.hasPhonemeAndLanguageList()) {
        if (getPhonemeAndLanguageList() < rhs.getPhonemeAndLanguageList()) return true;
        if (getPhonemeAndLanguageList() > rhs.getPhonemeAndLanguageList()) return false;
    }
    if (hasDestItemtype() || rhs.hasDestItemtype()) {
        if ((uint32)getDestItemtype() < (uint32)rhs.getDestItemtype()) return true;
        if ((uint32)getDestItemtype() > (uint32)rhs.getDestItemtype()) return false;
    }
    return false;
}

inline bool T_StringAndPhoneme::operator > (const T_StringAndPhoneme& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_StringAndPhoneme::clear() {
    clearNDSId();
    clearOrthographyList();
    clearPhonemeAndLanguageList();
    clearDestItemtype();
}

inline void T_StringAndPhoneme::clearNDSId() {
    if (hasNDSId()) {
         clear_has_NDSId();
        _NDSId.clear();
     }
}

inline bool T_StringAndPhoneme::hasNDSId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_NDSID& T_StringAndPhoneme::getNDSId () const {
    return _NDSId;
}

inline T_NDSID& T_StringAndPhoneme::getNDSIdMutable () {
    set_has_NDSId();
    return _NDSId;
}

inline void T_StringAndPhoneme::setNDSId (const T_NDSID& NDSId_) {
    set_has_NDSId();
    this->_NDSId = NDSId_;
}

inline void T_StringAndPhoneme::clearOrthographyList() {
    if (hasOrthographyList()) {
         clear_has_OrthographyList();
        _OrthographyList.clear();
     }
}

inline bool T_StringAndPhoneme::hasOrthographyList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::std::string >& T_StringAndPhoneme::getOrthographyList () const {
    return _OrthographyList;
}

inline ::std::vector< ::std::string >& T_StringAndPhoneme::getOrthographyListMutable () {
    set_has_OrthographyList();
    return _OrthographyList;
}

inline void T_StringAndPhoneme::setOrthographyList (const ::std::vector< ::std::string >& OrthographyList_) {
    set_has_OrthographyList();
    this->_OrthographyList = OrthographyList_;
}

inline void T_StringAndPhoneme::clearPhonemeAndLanguageList() {
    if (hasPhonemeAndLanguageList()) {
         clear_has_PhonemeAndLanguageList();
        _PhonemeAndLanguageList.clear();
     }
}

inline bool T_StringAndPhoneme::hasPhonemeAndLanguageList () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< T_PhonemeForLanguage >& T_StringAndPhoneme::getPhonemeAndLanguageList () const {
    return _PhonemeAndLanguageList;
}

inline ::std::vector< T_PhonemeForLanguage >& T_StringAndPhoneme::getPhonemeAndLanguageListMutable () {
    set_has_PhonemeAndLanguageList();
    return _PhonemeAndLanguageList;
}

inline void T_StringAndPhoneme::setPhonemeAndLanguageList (const ::std::vector< T_PhonemeForLanguage >& PhonemeAndLanguageList_) {
    set_has_PhonemeAndLanguageList();
    this->_PhonemeAndLanguageList = PhonemeAndLanguageList_;
}

inline void T_StringAndPhoneme::clearDestItemtype() {
    if (hasDestItemtype()) {
         clear_has_DestItemtype();
        _DestItemtype = ::sds_sds2hmi_common_types::T_e8_SDSDestinationType__Reserved;
     }
}

inline bool T_StringAndPhoneme::hasDestItemtype () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_SDSDestinationType T_StringAndPhoneme::getDestItemtype () const {
    return _DestItemtype;
}

inline void T_StringAndPhoneme::setDestItemtype (T_e8_SDSDestinationType DestItemtype_) {
    #ifndef NDEBUG
    if (!(T_e8_SDSDestinationType_IsValid(DestItemtype_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DestItemtype_, "T_e8_SDSDestinationType", "DestItemtype", "T_StringAndPhoneme");
    }
    #endif
    set_has_DestItemtype();
    this->_DestItemtype = DestItemtype_;
}

inline void T_StringAndPhoneme::set_has_NDSId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_StringAndPhoneme::clear_has_NDSId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_StringAndPhoneme::set_has_OrthographyList () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_StringAndPhoneme::clear_has_OrthographyList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_StringAndPhoneme::set_has_PhonemeAndLanguageList () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_StringAndPhoneme::clear_has_PhonemeAndLanguageList () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_StringAndPhoneme::set_has_DestItemtype () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_StringAndPhoneme::clear_has_DestItemtype () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_StatePhoneme::T_StatePhoneme ()  :
    _StateId (),
    _PhonemeList (),
    _OrthographyList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_StatePhoneme::T_StatePhoneme (const T_StatePhoneme &rhs)  :
    _StateId (),
    _PhonemeList (),
    _OrthographyList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_StatePhoneme::T_StatePhoneme (const T_NDSID& StateId_, const ::std::vector< ::std::string >& PhonemeList_, const ::std::vector< ::std::string >& OrthographyList_)  :
    _StateId (StateId_),
    _PhonemeList (PhonemeList_),
    _OrthographyList (OrthographyList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_StatePhoneme::~T_StatePhoneme() {
}

inline T_StatePhoneme& T_StatePhoneme::operator = (const T_StatePhoneme& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStateId()) {
            setStateId(rhs.getStateId());
        } else {
            clearStateId();
        }
        if (rhs.hasPhonemeList()) {
            setPhonemeList(rhs.getPhonemeList());
        } else {
            clearPhonemeList();
        }
        if (rhs.hasOrthographyList()) {
            setOrthographyList(rhs.getOrthographyList());
        } else {
            clearOrthographyList();
        }
    }
    return *this;
}

inline bool T_StatePhoneme::operator == (const T_StatePhoneme& rhs) const {
    return (((!hasStateId() && !rhs.hasStateId()) || getStateId() == rhs.getStateId()) &&
        ((!hasPhonemeList() && !rhs.hasPhonemeList()) || getPhonemeList() == rhs.getPhonemeList()) &&
        ((!hasOrthographyList() && !rhs.hasOrthographyList()) || getOrthographyList() == rhs.getOrthographyList()));
}

inline bool T_StatePhoneme::operator != (const T_StatePhoneme& rhs) const {
    return ! (*this == rhs);
}

inline bool T_StatePhoneme::operator < (const T_StatePhoneme& rhs) const {
    if (hasStateId() || rhs.hasStateId()) {
        if (getStateId() < rhs.getStateId()) return true;
        if (getStateId() > rhs.getStateId()) return false;
    }
    if (hasPhonemeList() || rhs.hasPhonemeList()) {
        if (getPhonemeList() < rhs.getPhonemeList()) return true;
        if (getPhonemeList() > rhs.getPhonemeList()) return false;
    }
    if (hasOrthographyList() || rhs.hasOrthographyList()) {
        if (getOrthographyList() < rhs.getOrthographyList()) return true;
        if (getOrthographyList() > rhs.getOrthographyList()) return false;
    }
    return false;
}

inline bool T_StatePhoneme::operator > (const T_StatePhoneme& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_StatePhoneme::clear() {
    clearStateId();
    clearPhonemeList();
    clearOrthographyList();
}

inline void T_StatePhoneme::clearStateId() {
    if (hasStateId()) {
         clear_has_StateId();
        _StateId.clear();
     }
}

inline bool T_StatePhoneme::hasStateId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_NDSID& T_StatePhoneme::getStateId () const {
    return _StateId;
}

inline T_NDSID& T_StatePhoneme::getStateIdMutable () {
    set_has_StateId();
    return _StateId;
}

inline void T_StatePhoneme::setStateId (const T_NDSID& StateId_) {
    set_has_StateId();
    this->_StateId = StateId_;
}

inline void T_StatePhoneme::clearPhonemeList() {
    if (hasPhonemeList()) {
         clear_has_PhonemeList();
        _PhonemeList.clear();
     }
}

inline bool T_StatePhoneme::hasPhonemeList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::std::string >& T_StatePhoneme::getPhonemeList () const {
    return _PhonemeList;
}

inline ::std::vector< ::std::string >& T_StatePhoneme::getPhonemeListMutable () {
    set_has_PhonemeList();
    return _PhonemeList;
}

inline void T_StatePhoneme::setPhonemeList (const ::std::vector< ::std::string >& PhonemeList_) {
    set_has_PhonemeList();
    this->_PhonemeList = PhonemeList_;
}

inline void T_StatePhoneme::clearOrthographyList() {
    if (hasOrthographyList()) {
         clear_has_OrthographyList();
        _OrthographyList.clear();
     }
}

inline bool T_StatePhoneme::hasOrthographyList () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< ::std::string >& T_StatePhoneme::getOrthographyList () const {
    return _OrthographyList;
}

inline ::std::vector< ::std::string >& T_StatePhoneme::getOrthographyListMutable () {
    set_has_OrthographyList();
    return _OrthographyList;
}

inline void T_StatePhoneme::setOrthographyList (const ::std::vector< ::std::string >& OrthographyList_) {
    set_has_OrthographyList();
    this->_OrthographyList = OrthographyList_;
}

inline void T_StatePhoneme::set_has_StateId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_StatePhoneme::clear_has_StateId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_StatePhoneme::set_has_PhonemeList () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_StatePhoneme::clear_has_PhonemeList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_StatePhoneme::set_has_OrthographyList () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_StatePhoneme::clear_has_OrthographyList () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_CountryPhoneme::T_CountryPhoneme ()  :
    _CountryId (),
    _PhonemeList (),
    _OrthographyList (),
    _StateList (),
    _CountryCode (::fi_types::T_e16_ISOCountryCode__ISO_ALPHA_3_UNDEFINED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CountryPhoneme::T_CountryPhoneme (const T_CountryPhoneme &rhs)  :
    _CountryId (),
    _PhonemeList (),
    _OrthographyList (),
    _StateList (),
    _CountryCode (::fi_types::T_e16_ISOCountryCode__ISO_ALPHA_3_UNDEFINED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CountryPhoneme::T_CountryPhoneme (const T_NDSID& CountryId_, const ::std::vector< ::std::string >& PhonemeList_, const ::std::vector< ::std::string >& OrthographyList_, const ::std::vector< T_StatePhoneme >& StateList_, ::fi_types::T_e16_ISOCountryCode CountryCode_)  :
    _CountryId (CountryId_),
    _PhonemeList (PhonemeList_),
    _OrthographyList (OrthographyList_),
    _StateList (StateList_),
    _CountryCode (CountryCode_)
{
    #ifndef NDEBUG
    if (!(::fi_types::T_e16_ISOCountryCode_IsValid(CountryCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", CountryCode_, "T_e16_ISOCountryCode", "CountryCode", "T_CountryPhoneme");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CountryPhoneme::~T_CountryPhoneme() {
}

inline T_CountryPhoneme& T_CountryPhoneme::operator = (const T_CountryPhoneme& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCountryId()) {
            setCountryId(rhs.getCountryId());
        } else {
            clearCountryId();
        }
        if (rhs.hasPhonemeList()) {
            setPhonemeList(rhs.getPhonemeList());
        } else {
            clearPhonemeList();
        }
        if (rhs.hasOrthographyList()) {
            setOrthographyList(rhs.getOrthographyList());
        } else {
            clearOrthographyList();
        }
        if (rhs.hasStateList()) {
            setStateList(rhs.getStateList());
        } else {
            clearStateList();
        }
        if (rhs.hasCountryCode()) {
            setCountryCode(rhs.getCountryCode());
        } else {
            clearCountryCode();
        }
    }
    return *this;
}

inline bool T_CountryPhoneme::operator == (const T_CountryPhoneme& rhs) const {
    return (((!hasCountryId() && !rhs.hasCountryId()) || getCountryId() == rhs.getCountryId()) &&
        ((!hasPhonemeList() && !rhs.hasPhonemeList()) || getPhonemeList() == rhs.getPhonemeList()) &&
        ((!hasOrthographyList() && !rhs.hasOrthographyList()) || getOrthographyList() == rhs.getOrthographyList()) &&
        ((!hasStateList() && !rhs.hasStateList()) || getStateList() == rhs.getStateList()) &&
        ((!hasCountryCode() && !rhs.hasCountryCode()) || getCountryCode() == rhs.getCountryCode()));
}

inline bool T_CountryPhoneme::operator != (const T_CountryPhoneme& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CountryPhoneme::operator < (const T_CountryPhoneme& rhs) const {
    if (hasCountryId() || rhs.hasCountryId()) {
        if (getCountryId() < rhs.getCountryId()) return true;
        if (getCountryId() > rhs.getCountryId()) return false;
    }
    if (hasPhonemeList() || rhs.hasPhonemeList()) {
        if (getPhonemeList() < rhs.getPhonemeList()) return true;
        if (getPhonemeList() > rhs.getPhonemeList()) return false;
    }
    if (hasOrthographyList() || rhs.hasOrthographyList()) {
        if (getOrthographyList() < rhs.getOrthographyList()) return true;
        if (getOrthographyList() > rhs.getOrthographyList()) return false;
    }
    if (hasStateList() || rhs.hasStateList()) {
        if (getStateList() < rhs.getStateList()) return true;
        if (getStateList() > rhs.getStateList()) return false;
    }
    if (hasCountryCode() || rhs.hasCountryCode()) {
        if ((uint32)getCountryCode() < (uint32)rhs.getCountryCode()) return true;
        if ((uint32)getCountryCode() > (uint32)rhs.getCountryCode()) return false;
    }
    return false;
}

inline bool T_CountryPhoneme::operator > (const T_CountryPhoneme& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CountryPhoneme::clear() {
    clearCountryId();
    clearPhonemeList();
    clearOrthographyList();
    clearStateList();
    clearCountryCode();
}

inline void T_CountryPhoneme::clearCountryId() {
    if (hasCountryId()) {
         clear_has_CountryId();
        _CountryId.clear();
     }
}

inline bool T_CountryPhoneme::hasCountryId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_NDSID& T_CountryPhoneme::getCountryId () const {
    return _CountryId;
}

inline T_NDSID& T_CountryPhoneme::getCountryIdMutable () {
    set_has_CountryId();
    return _CountryId;
}

inline void T_CountryPhoneme::setCountryId (const T_NDSID& CountryId_) {
    set_has_CountryId();
    this->_CountryId = CountryId_;
}

inline void T_CountryPhoneme::clearPhonemeList() {
    if (hasPhonemeList()) {
         clear_has_PhonemeList();
        _PhonemeList.clear();
     }
}

inline bool T_CountryPhoneme::hasPhonemeList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::std::string >& T_CountryPhoneme::getPhonemeList () const {
    return _PhonemeList;
}

inline ::std::vector< ::std::string >& T_CountryPhoneme::getPhonemeListMutable () {
    set_has_PhonemeList();
    return _PhonemeList;
}

inline void T_CountryPhoneme::setPhonemeList (const ::std::vector< ::std::string >& PhonemeList_) {
    set_has_PhonemeList();
    this->_PhonemeList = PhonemeList_;
}

inline void T_CountryPhoneme::clearOrthographyList() {
    if (hasOrthographyList()) {
         clear_has_OrthographyList();
        _OrthographyList.clear();
     }
}

inline bool T_CountryPhoneme::hasOrthographyList () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< ::std::string >& T_CountryPhoneme::getOrthographyList () const {
    return _OrthographyList;
}

inline ::std::vector< ::std::string >& T_CountryPhoneme::getOrthographyListMutable () {
    set_has_OrthographyList();
    return _OrthographyList;
}

inline void T_CountryPhoneme::setOrthographyList (const ::std::vector< ::std::string >& OrthographyList_) {
    set_has_OrthographyList();
    this->_OrthographyList = OrthographyList_;
}

inline void T_CountryPhoneme::clearStateList() {
    if (hasStateList()) {
         clear_has_StateList();
        _StateList.clear();
     }
}

inline bool T_CountryPhoneme::hasStateList () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< T_StatePhoneme >& T_CountryPhoneme::getStateList () const {
    return _StateList;
}

inline ::std::vector< T_StatePhoneme >& T_CountryPhoneme::getStateListMutable () {
    set_has_StateList();
    return _StateList;
}

inline void T_CountryPhoneme::setStateList (const ::std::vector< T_StatePhoneme >& StateList_) {
    set_has_StateList();
    this->_StateList = StateList_;
}

inline void T_CountryPhoneme::clearCountryCode() {
    if (hasCountryCode()) {
         clear_has_CountryCode();
        _CountryCode = ::fi_types::T_e16_ISOCountryCode__ISO_ALPHA_3_UNDEFINED;
     }
}

inline bool T_CountryPhoneme::hasCountryCode () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline ::fi_types::T_e16_ISOCountryCode T_CountryPhoneme::getCountryCode () const {
    return _CountryCode;
}

inline void T_CountryPhoneme::setCountryCode (::fi_types::T_e16_ISOCountryCode CountryCode_) {
    #ifndef NDEBUG
    if (!(::fi_types::T_e16_ISOCountryCode_IsValid(CountryCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", CountryCode_, "T_e16_ISOCountryCode", "CountryCode", "T_CountryPhoneme");
    }
    #endif
    set_has_CountryCode();
    this->_CountryCode = CountryCode_;
}

inline void T_CountryPhoneme::set_has_CountryId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CountryPhoneme::clear_has_CountryId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_CountryPhoneme::set_has_PhonemeList () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_CountryPhoneme::clear_has_PhonemeList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_CountryPhoneme::set_has_OrthographyList () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_CountryPhoneme::clear_has_OrthographyList () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_CountryPhoneme::set_has_StateList () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_CountryPhoneme::clear_has_StateList () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_CountryPhoneme::set_has_CountryCode () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_CountryPhoneme::clear_has_CountryCode () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_CityId::T_CityId ()  :
    _City_ID_ ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CityId::T_CityId (const T_CityId &rhs)  :
    _City_ID_ ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CityId::T_CityId (const T_NDSID& City_ID__)  :
    _City_ID_ (City_ID__)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CityId::~T_CityId() {
}

inline T_CityId& T_CityId::operator = (const T_CityId& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCity_ID_()) {
            setCity_ID_(rhs.getCity_ID_());
        } else {
            clearCity_ID_();
        }
    }
    return *this;
}

inline bool T_CityId::operator == (const T_CityId& rhs) const {
    return (((!hasCity_ID_() && !rhs.hasCity_ID_()) || getCity_ID_() == rhs.getCity_ID_()));
}

inline bool T_CityId::operator != (const T_CityId& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CityId::operator < (const T_CityId& rhs) const {
    if (hasCity_ID_() || rhs.hasCity_ID_()) {
        if (getCity_ID_() < rhs.getCity_ID_()) return true;
        if (getCity_ID_() > rhs.getCity_ID_()) return false;
    }
    return false;
}

inline bool T_CityId::operator > (const T_CityId& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CityId::clear() {
    clearCity_ID_();
}

inline void T_CityId::clearCity_ID_() {
    if (hasCity_ID_()) {
         clear_has_City_ID_();
        _City_ID_.clear();
     }
}

inline bool T_CityId::hasCity_ID_ () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_NDSID& T_CityId::getCity_ID_ () const {
    return _City_ID_;
}

inline T_NDSID& T_CityId::getCity_ID_Mutable () {
    set_has_City_ID_();
    return _City_ID_;
}

inline void T_CityId::setCity_ID_ (const T_NDSID& City_ID__) {
    set_has_City_ID_();
    this->_City_ID_ = City_ID__;
}

inline void T_CityId::set_has_City_ID_ () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CityId::clear_has_City_ID_ () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  T_ECNR_ASR_Mode_Status::T_ECNR_ASR_Mode_Status ()  :
    _Mode_Enable (false),
    _Mode_Status (::sds_sds2hmi_common_types::T_e32_SSE_ASR_Mode__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ECNR_ASR_Mode_Status::T_ECNR_ASR_Mode_Status (const T_ECNR_ASR_Mode_Status &rhs)  :
    _Mode_Enable (false),
    _Mode_Status (::sds_sds2hmi_common_types::T_e32_SSE_ASR_Mode__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ECNR_ASR_Mode_Status::T_ECNR_ASR_Mode_Status (bool Mode_Enable_, T_e32_SSE_ASR_Mode Mode_Status_)  :
    _Mode_Enable (Mode_Enable_),
    _Mode_Status (Mode_Status_)
{
    #ifndef NDEBUG
    if (!(T_e32_SSE_ASR_Mode_IsValid(Mode_Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Mode_Status_, "T_e32_SSE_ASR_Mode", "Mode_Status", "T_ECNR_ASR_Mode_Status");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ECNR_ASR_Mode_Status::~T_ECNR_ASR_Mode_Status() {
}

inline T_ECNR_ASR_Mode_Status& T_ECNR_ASR_Mode_Status::operator = (const T_ECNR_ASR_Mode_Status& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMode_Enable()) {
            setMode_Enable(rhs.getMode_Enable());
        } else {
            clearMode_Enable();
        }
        if (rhs.hasMode_Status()) {
            setMode_Status(rhs.getMode_Status());
        } else {
            clearMode_Status();
        }
    }
    return *this;
}

inline bool T_ECNR_ASR_Mode_Status::operator == (const T_ECNR_ASR_Mode_Status& rhs) const {
    return (((!hasMode_Enable() && !rhs.hasMode_Enable()) || getMode_Enable() == rhs.getMode_Enable()) &&
        ((!hasMode_Status() && !rhs.hasMode_Status()) || getMode_Status() == rhs.getMode_Status()));
}

inline bool T_ECNR_ASR_Mode_Status::operator != (const T_ECNR_ASR_Mode_Status& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ECNR_ASR_Mode_Status::operator < (const T_ECNR_ASR_Mode_Status& rhs) const {
    if (hasMode_Enable() || rhs.hasMode_Enable()) {
        if (getMode_Enable() < rhs.getMode_Enable()) return true;
        if (getMode_Enable() > rhs.getMode_Enable()) return false;
    }
    if (hasMode_Status() || rhs.hasMode_Status()) {
        if ((uint32)getMode_Status() < (uint32)rhs.getMode_Status()) return true;
        if ((uint32)getMode_Status() > (uint32)rhs.getMode_Status()) return false;
    }
    return false;
}

inline bool T_ECNR_ASR_Mode_Status::operator > (const T_ECNR_ASR_Mode_Status& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ECNR_ASR_Mode_Status::clear() {
    clearMode_Enable();
    clearMode_Status();
}

inline void T_ECNR_ASR_Mode_Status::clearMode_Enable() {
    if (hasMode_Enable()) {
         clear_has_Mode_Enable();
        _Mode_Enable = false;
     }
}

inline bool T_ECNR_ASR_Mode_Status::hasMode_Enable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_ECNR_ASR_Mode_Status::getMode_Enable () const {
    return _Mode_Enable;
}

inline void T_ECNR_ASR_Mode_Status::setMode_Enable (bool Mode_Enable_) {
    set_has_Mode_Enable();
    this->_Mode_Enable = Mode_Enable_;
}

inline void T_ECNR_ASR_Mode_Status::clearMode_Status() {
    if (hasMode_Status()) {
         clear_has_Mode_Status();
        _Mode_Status = ::sds_sds2hmi_common_types::T_e32_SSE_ASR_Mode__UNKNOWN;
     }
}

inline bool T_ECNR_ASR_Mode_Status::hasMode_Status () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e32_SSE_ASR_Mode T_ECNR_ASR_Mode_Status::getMode_Status () const {
    return _Mode_Status;
}

inline void T_ECNR_ASR_Mode_Status::setMode_Status (T_e32_SSE_ASR_Mode Mode_Status_) {
    #ifndef NDEBUG
    if (!(T_e32_SSE_ASR_Mode_IsValid(Mode_Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Mode_Status_, "T_e32_SSE_ASR_Mode", "Mode_Status", "T_ECNR_ASR_Mode_Status");
    }
    #endif
    set_has_Mode_Status();
    this->_Mode_Status = Mode_Status_;
}

inline void T_ECNR_ASR_Mode_Status::set_has_Mode_Enable () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ECNR_ASR_Mode_Status::clear_has_Mode_Enable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ECNR_ASR_Mode_Status::set_has_Mode_Status () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ECNR_ASR_Mode_Status::clear_has_Mode_Status () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace sds_sds2hmi_common_types

#endif // SDS_SDS2HMI_COMMON_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
