#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ACR_FI_TYPES_H
#define ACR_FI_TYPES_H

#include "acr_fi_typesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types acr_fi_types
 */

namespace acr_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_AudioChannelAdvice;

class T_b8_AudioFormat;

class T_b8_AudioOutputLocation;

class T_b16_RequestAddInfo;

class T_ChannelRequestStatus;

class T_InstancesPerCategory;

class T_InstancesPerCategoryList;

// type definitions
/**
 * If the meaning of "T_ChannelRequestStatusList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_ChannelRequestStatus > T_ChannelRequestStatusList;


/**
 * This structure is part of the parameter used by the method
 * VoiceAdvice.
 */
class T_AudioChannelAdvice {
public:

    /**
     * Default constructor
     */
    inline  T_AudioChannelAdvice ();

    /**
     * Copy constructor
     */
    inline  T_AudioChannelAdvice (const T_AudioChannelAdvice &rhs);

    /**
     * All fields constructor
     */
    inline  T_AudioChannelAdvice (T_e8_AudioChannelAdvice ChannelAdvice_, uint8 Index_, const ::std::string& Device_);

    /**
     * Destructor
     */
    inline  ~T_AudioChannelAdvice();

    /**
     * Assignment operator
     */
    inline T_AudioChannelAdvice& operator = (const T_AudioChannelAdvice& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AudioChannelAdvice& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AudioChannelAdvice& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AudioChannelAdvice& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AudioChannelAdvice& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelAdvice"

    static const int kChannelAdvice = 0;

    /**
     * Clears the field "ChannelAdvice".
     *
     * The field will be set to its default value. The hasChannelAdvice()
     * method will return false.
     */
    inline void clearChannelAdvice();

    /**
     * Checks whether the field "ChannelAdvice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelAdvice()). Otherwise it will return false.
     */
    inline bool hasChannelAdvice () const;

    /**
     * Returns the value of the member "ChannelAdvice".
     *
     *
     *
     * @return The value of the field "ChannelAdvice"
     */
    inline T_e8_AudioChannelAdvice getChannelAdvice () const;

    /**
     * Sets the value of the member "ChannelAdvice".
     *
     *
     *
     * @param ChannelAdvice The value which will be set
     */
    inline void setChannelAdvice (T_e8_AudioChannelAdvice ChannelAdvice_);

    // API of field "Index"

    static const int kIndex = 1;

    /**
     * Clears the field "Index".
     *
     * The field will be set to its default value. The hasIndex()
     * method will return false.
     */
    inline void clearIndex();

    /**
     * Checks whether the field "Index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndex()). Otherwise it will return false.
     */
    inline bool hasIndex () const;

    /**
     * Returns the value of the member "Index".
     *
     * This parameter will be increased by the server for
     * every new channel request.  By this, different
     * current channel requests can be differentiated.
     *
     * @return The value of the field "Index"
     */
    inline uint8 getIndex () const;

    /**
     * Sets the value of the member "Index".
     *
     * This parameter will be increased by the server for
     * every new channel request.  By this, different
     * current channel requests can be differentiated.
     *
     * @param Index The value which will be set
     */
    inline void setIndex (uint8 Index_);

    // API of field "Device"

    static const int kDevice = 2;

    /**
     * Clears the field "Device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "Device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "Device".
     *
     *
     *
     * @return The value of the field "Device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "Device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "Device".
     *
     *
     *
     * @param Device The value which will be set
     */
    inline void setDevice (const ::std::string& Device_);

    /**
     * Sets the value of the member "Device".
     *
     *
     *
     * @param Device The value which will be set
     */
    inline void setDevice (const char* Device_);

    /**
     * Sets the value of the member "Device".
     *
     *
     *
     * @param Device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const T_AudioChannelAdvice &getDefaultInstance();

private:

    inline void set_has_ChannelAdvice ();

    inline void clear_has_ChannelAdvice ();

    inline void set_has_Index ();

    inline void clear_has_Index ();

    inline void set_has_Device ();

    inline void clear_has_Device ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_AudioChannelAdvice _ChannelAdvice;

    uint8 _Index;

    ::std::string _Device;

};

/**
 * A client may name the required audioformat.
 * As it is possible, that more than one format may
 * be requested, this parameter is a bitfield and not an enum.
 * The definition of this entire bitfield is tbd.
 */
class T_b8_AudioFormat {
public:

    /**
     * Default constructor
     */
    inline  T_b8_AudioFormat ();

    /**
     * Copy constructor
     */
    inline  T_b8_AudioFormat (const T_b8_AudioFormat &c);

    /**
     * Field constructor
     */
    inline  T_b8_AudioFormat (bool PCM, bool AMR, bool AMR_WB, bool MP3);

    /**
     * Assignment operator
     */
    inline T_b8_AudioFormat& operator = (const T_b8_AudioFormat& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_AudioFormat& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_AudioFormat& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_AudioFormat& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_AudioFormat& rhs) const;

    /**
     * Sets the value of the member "PCM".
     *
     * If the meaning of "PCM" isn't clear, then there should be a description here.
     *
     * @param PCM The value which will be set
     */
    inline void setPCM (bool PCM);

    /**
     * Returns the value of the member "PCM".
     *
     * If the meaning of "PCM" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PCM"
     */
    inline bool getPCM () const;

    /**
     * Sets the value of the member "AMR".
     *
     * If the meaning of "AMR" isn't clear, then there should be a description here.
     *
     * @param AMR The value which will be set
     */
    inline void setAMR (bool AMR);

    /**
     * Returns the value of the member "AMR".
     *
     * If the meaning of "AMR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AMR"
     */
    inline bool getAMR () const;

    /**
     * Sets the value of the member "AMR_WB".
     *
     * If the meaning of "AMR_WB" isn't clear, then there should be a description here.
     *
     * @param AMR_WB The value which will be set
     */
    inline void setAMR_WB (bool AMR_WB);

    /**
     * Returns the value of the member "AMR_WB".
     *
     * If the meaning of "AMR_WB" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AMR_WB"
     */
    inline bool getAMR_WB () const;

    /**
     * Sets the value of the member "MP3".
     *
     * If the meaning of "MP3" isn't clear, then there should be a description here.
     *
     * @param MP3 The value which will be set
     */
    inline void setMP3 (bool MP3);

    /**
     * Returns the value of the member "MP3".
     *
     * If the meaning of "MP3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MP3"
     */
    inline bool getMP3 () const;

    static const T_b8_AudioFormat &getDefaultInstance();

private:

    bool _PCM:1;

    bool _AMR:1;

    bool _AMR_WB:1;

    bool _MP3:1;

};

/**
 * A client may name a special output location, where the
 * audiooutput must be done.  The definition of this entire
 * enum is tbd.
 */
class T_b8_AudioOutputLocation {
public:

    /**
     * Default constructor
     */
    inline  T_b8_AudioOutputLocation ();

    /**
     * Copy constructor
     */
    inline  T_b8_AudioOutputLocation (const T_b8_AudioOutputLocation &c);

    /**
     * Field constructor
     */
    inline  T_b8_AudioOutputLocation (bool Standard, bool FrontLeft, bool FrontRight, bool BackRight, bool BackLeft);

    /**
     * Assignment operator
     */
    inline T_b8_AudioOutputLocation& operator = (const T_b8_AudioOutputLocation& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_AudioOutputLocation& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_AudioOutputLocation& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_AudioOutputLocation& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_AudioOutputLocation& rhs) const;

    /**
     * Sets the value of the member "Standard".
     *
     * If the meaning of "Standard" isn't clear, then there should be a description here.
     *
     * @param Standard The value which will be set
     */
    inline void setStandard (bool Standard);

    /**
     * Returns the value of the member "Standard".
     *
     * If the meaning of "Standard" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Standard"
     */
    inline bool getStandard () const;

    /**
     * Sets the value of the member "FrontLeft".
     *
     * If the meaning of "FrontLeft" isn't clear, then there should be a description here.
     *
     * @param FrontLeft The value which will be set
     */
    inline void setFrontLeft (bool FrontLeft);

    /**
     * Returns the value of the member "FrontLeft".
     *
     * If the meaning of "FrontLeft" isn't clear, then there should be a description here.
     *
     * @return The value of the field "FrontLeft"
     */
    inline bool getFrontLeft () const;

    /**
     * Sets the value of the member "FrontRight".
     *
     * If the meaning of "FrontRight" isn't clear, then there should be a description here.
     *
     * @param FrontRight The value which will be set
     */
    inline void setFrontRight (bool FrontRight);

    /**
     * Returns the value of the member "FrontRight".
     *
     * If the meaning of "FrontRight" isn't clear, then there should be a description here.
     *
     * @return The value of the field "FrontRight"
     */
    inline bool getFrontRight () const;

    /**
     * Sets the value of the member "BackRight".
     *
     * If the meaning of "BackRight" isn't clear, then there should be a description here.
     *
     * @param BackRight The value which will be set
     */
    inline void setBackRight (bool BackRight);

    /**
     * Returns the value of the member "BackRight".
     *
     * If the meaning of "BackRight" isn't clear, then there should be a description here.
     *
     * @return The value of the field "BackRight"
     */
    inline bool getBackRight () const;

    /**
     * Sets the value of the member "BackLeft".
     *
     * If the meaning of "BackLeft" isn't clear, then there should be a description here.
     *
     * @param BackLeft The value which will be set
     */
    inline void setBackLeft (bool BackLeft);

    /**
     * Returns the value of the member "BackLeft".
     *
     * If the meaning of "BackLeft" isn't clear, then there should be a description here.
     *
     * @return The value of the field "BackLeft"
     */
    inline bool getBackLeft () const;

    static const T_b8_AudioOutputLocation &getDefaultInstance();

private:

    bool _Standard:1;

    bool _FrontLeft:1;

    bool _FrontRight:1;

    bool _BackRight:1;

    bool _BackLeft:1;

};

/**
 * This bitfield provides additional information for a given
 * channel request.
 */
class T_b16_RequestAddInfo {
public:

    /**
     * Default constructor
     */
    inline  T_b16_RequestAddInfo ();

    /**
     * Copy constructor
     */
    inline  T_b16_RequestAddInfo (const T_b16_RequestAddInfo &c);

    /**
     * Field constructor
     */
    inline  T_b16_RequestAddInfo (bool User, bool Unknown);

    /**
     * Assignment operator
     */
    inline T_b16_RequestAddInfo& operator = (const T_b16_RequestAddInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b16_RequestAddInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b16_RequestAddInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b16_RequestAddInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b16_RequestAddInfo& rhs) const;

    /**
     * Sets the value of the member "User".
     *
     * If the meaning of "User" isn't clear, then there should be a description here.
     *
     * @param User The value which will be set
     */
    inline void setUser (bool User);

    /**
     * Returns the value of the member "User".
     *
     * If the meaning of "User" isn't clear, then there should be a description here.
     *
     * @return The value of the field "User"
     */
    inline bool getUser () const;

    /**
     * Sets the value of the member "Unknown".
     *
     * If the meaning of "Unknown" isn't clear, then there should be a description here.
     *
     * @param Unknown The value which will be set
     */
    inline void setUnknown (bool Unknown);

    /**
     * Returns the value of the member "Unknown".
     *
     * If the meaning of "Unknown" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Unknown"
     */
    inline bool getUnknown () const;

    static const T_b16_RequestAddInfo &getDefaultInstance();

private:

    bool _User:1;

    bool _Unknown:1;

};

/**
 * This structure is the parameter used in the property
 * ChannelRequest.  This parameter indicates the status
 * acording to the defined category.
 */
class T_ChannelRequestStatus {
public:

    /**
     * Default constructor
     */
    inline  T_ChannelRequestStatus ();

    /**
     * Copy constructor
     */
    inline  T_ChannelRequestStatus (const T_ChannelRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_ChannelRequestStatus (T_e8_VoiceCategory Category_, uint8 Index_, T_e8_CatStatus Status_, const T_b8_AudioFormat& AudioFormat_, const T_b8_AudioOutputLocation& AudioOutputLocation_, const T_b16_RequestAddInfo& RequestAddInfo_);

    /**
     * Destructor
     */
    inline  ~T_ChannelRequestStatus();

    /**
     * Assignment operator
     */
    inline T_ChannelRequestStatus& operator = (const T_ChannelRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ChannelRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ChannelRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ChannelRequestStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ChannelRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Category"

    static const int kCategory = 0;

    /**
     * Clears the field "Category".
     *
     * The field will be set to its default value. The hasCategory()
     * method will return false.
     */
    inline void clearCategory();

    /**
     * Checks whether the field "Category" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategory()). Otherwise it will return false.
     */
    inline bool hasCategory () const;

    /**
     * Returns the value of the member "Category".
     *
     *
     *
     * @return The value of the field "Category"
     */
    inline T_e8_VoiceCategory getCategory () const;

    /**
     * Sets the value of the member "Category".
     *
     *
     *
     * @param Category The value which will be set
     */
    inline void setCategory (T_e8_VoiceCategory Category_);

    // API of field "Index"

    static const int kIndex = 1;

    /**
     * Clears the field "Index".
     *
     * The field will be set to its default value. The hasIndex()
     * method will return false.
     */
    inline void clearIndex();

    /**
     * Checks whether the field "Index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndex()). Otherwise it will return false.
     */
    inline bool hasIndex () const;

    /**
     * Returns the value of the member "Index".
     *
     *
     *
     * @return The value of the field "Index"
     */
    inline uint8 getIndex () const;

    /**
     * Sets the value of the member "Index".
     *
     *
     *
     * @param Index The value which will be set
     */
    inline void setIndex (uint8 Index_);

    // API of field "Status"

    static const int kStatus = 2;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     *
     *
     * @return The value of the field "Status"
     */
    inline T_e8_CatStatus getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     *
     *
     * @param Status The value which will be set
     */
    inline void setStatus (T_e8_CatStatus Status_);

    // API of field "AudioFormat"

    static const int kAudioFormat = 3;

    /**
     * Clears the field "AudioFormat".
     *
     * The field will be set to its default value. The hasAudioFormat()
     * method will return false.
     */
    inline void clearAudioFormat();

    /**
     * Checks whether the field "AudioFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioFormat()). Otherwise it will return false.
     */
    inline bool hasAudioFormat () const;

    /**
     * Returns the value of the member "AudioFormat".
     *
     *
     *
     * @return The value of the field "AudioFormat"
     */
    inline const T_b8_AudioFormat& getAudioFormat () const;

    /**
     * Retrieves the value of the field "AudioFormat" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AudioFormat".
     */
    inline T_b8_AudioFormat& getAudioFormatMutable ();

    /**
     * Sets the value of the member "AudioFormat".
     *
     *
     *
     * @param AudioFormat The value which will be set
     */
    inline void setAudioFormat (const T_b8_AudioFormat& AudioFormat_);

    // API of field "AudioOutputLocation"

    static const int kAudioOutputLocation = 4;

    /**
     * Clears the field "AudioOutputLocation".
     *
     * The field will be set to its default value. The hasAudioOutputLocation()
     * method will return false.
     */
    inline void clearAudioOutputLocation();

    /**
     * Checks whether the field "AudioOutputLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioOutputLocation()). Otherwise it will return false.
     */
    inline bool hasAudioOutputLocation () const;

    /**
     * Returns the value of the member "AudioOutputLocation".
     *
     *
     *
     * @return The value of the field "AudioOutputLocation"
     */
    inline const T_b8_AudioOutputLocation& getAudioOutputLocation () const;

    /**
     * Retrieves the value of the field "AudioOutputLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AudioOutputLocation".
     */
    inline T_b8_AudioOutputLocation& getAudioOutputLocationMutable ();

    /**
     * Sets the value of the member "AudioOutputLocation".
     *
     *
     *
     * @param AudioOutputLocation The value which will be set
     */
    inline void setAudioOutputLocation (const T_b8_AudioOutputLocation& AudioOutputLocation_);

    // API of field "RequestAddInfo"

    static const int kRequestAddInfo = 5;

    /**
     * Clears the field "RequestAddInfo".
     *
     * The field will be set to its default value. The hasRequestAddInfo()
     * method will return false.
     */
    inline void clearRequestAddInfo();

    /**
     * Checks whether the field "RequestAddInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestAddInfo()). Otherwise it will return false.
     */
    inline bool hasRequestAddInfo () const;

    /**
     * Returns the value of the member "RequestAddInfo".
     *
     * Additional information for the request
     *
     * @return The value of the field "RequestAddInfo"
     */
    inline const T_b16_RequestAddInfo& getRequestAddInfo () const;

    /**
     * Retrieves the value of the field "RequestAddInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RequestAddInfo".
     */
    inline T_b16_RequestAddInfo& getRequestAddInfoMutable ();

    /**
     * Sets the value of the member "RequestAddInfo".
     *
     * Additional information for the request
     *
     * @param RequestAddInfo The value which will be set
     */
    inline void setRequestAddInfo (const T_b16_RequestAddInfo& RequestAddInfo_);

    static const T_ChannelRequestStatus &getDefaultInstance();

private:

    inline void set_has_Category ();

    inline void clear_has_Category ();

    inline void set_has_Index ();

    inline void clear_has_Index ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    inline void set_has_AudioFormat ();

    inline void clear_has_AudioFormat ();

    inline void set_has_AudioOutputLocation ();

    inline void clear_has_AudioOutputLocation ();

    inline void set_has_RequestAddInfo ();

    inline void clear_has_RequestAddInfo ();

    uint32 _has_bits_[ (6 + 31) / 32];

    T_e8_VoiceCategory _Category;

    uint8 _Index;

    T_e8_CatStatus _Status;

    T_b8_AudioFormat _AudioFormat;

    T_b8_AudioOutputLocation _AudioOutputLocation;

    T_b16_RequestAddInfo _RequestAddInfo;

};

/**
 * A component using this service may have the possibility to
 * have multiple instances running at the same time.  To give
 * the AudioManagement the possibility to assign the
 * audiochannels according to this number, the number of
 * possible instances per category are defined here.
 */
class T_InstancesPerCategory {
public:

    /**
     * Default constructor
     */
    inline  T_InstancesPerCategory ();

    /**
     * Copy constructor
     */
    inline  T_InstancesPerCategory (const T_InstancesPerCategory &rhs);

    /**
     * All fields constructor
     */
    inline  T_InstancesPerCategory (T_e8_VoiceCategory VoiceCategory_, uint8 NumberOfInstances_);

    /**
     * Destructor
     */
    inline  ~T_InstancesPerCategory();

    /**
     * Assignment operator
     */
    inline T_InstancesPerCategory& operator = (const T_InstancesPerCategory& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_InstancesPerCategory& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_InstancesPerCategory& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_InstancesPerCategory& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_InstancesPerCategory& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VoiceCategory"

    static const int kVoiceCategory = 0;

    /**
     * Clears the field "VoiceCategory".
     *
     * The field will be set to its default value. The hasVoiceCategory()
     * method will return false.
     */
    inline void clearVoiceCategory();

    /**
     * Checks whether the field "VoiceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceCategory()). Otherwise it will return false.
     */
    inline bool hasVoiceCategory () const;

    /**
     * Returns the value of the member "VoiceCategory".
     *
     *
     *
     * @return The value of the field "VoiceCategory"
     */
    inline T_e8_VoiceCategory getVoiceCategory () const;

    /**
     * Sets the value of the member "VoiceCategory".
     *
     *
     *
     * @param VoiceCategory The value which will be set
     */
    inline void setVoiceCategory (T_e8_VoiceCategory VoiceCategory_);

    // API of field "NumberOfInstances"

    static const int kNumberOfInstances = 1;

    /**
     * Clears the field "NumberOfInstances".
     *
     * The field will be set to its default value. The hasNumberOfInstances()
     * method will return false.
     */
    inline void clearNumberOfInstances();

    /**
     * Checks whether the field "NumberOfInstances" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumberOfInstances()). Otherwise it will return false.
     */
    inline bool hasNumberOfInstances () const;

    /**
     * Returns the value of the member "NumberOfInstances".
     *
     *
     *
     * @return The value of the field "NumberOfInstances"
     */
    inline uint8 getNumberOfInstances () const;

    /**
     * Sets the value of the member "NumberOfInstances".
     *
     *
     *
     * @param NumberOfInstances The value which will be set
     */
    inline void setNumberOfInstances (uint8 NumberOfInstances_);

    static const T_InstancesPerCategory &getDefaultInstance();

private:

    inline void set_has_VoiceCategory ();

    inline void clear_has_VoiceCategory ();

    inline void set_has_NumberOfInstances ();

    inline void clear_has_NumberOfInstances ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_VoiceCategory _VoiceCategory;

    uint8 _NumberOfInstances;

};

/**
 * This structure combines the list of number of instances
 * per category with the maximum number of instances overall.
 */
class T_InstancesPerCategoryList {
public:

    /**
     * Default constructor
     */
    inline  T_InstancesPerCategoryList ();

    /**
     * Copy constructor
     */
    inline  T_InstancesPerCategoryList (const T_InstancesPerCategoryList &rhs);

    /**
     * All fields constructor
     */
    inline  T_InstancesPerCategoryList (const ::std::vector< T_InstancesPerCategory >& InstancesPerCategory_, uint8 MaxAmountInstances_);

    /**
     * Destructor
     */
    inline  ~T_InstancesPerCategoryList();

    /**
     * Assignment operator
     */
    inline T_InstancesPerCategoryList& operator = (const T_InstancesPerCategoryList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_InstancesPerCategoryList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_InstancesPerCategoryList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_InstancesPerCategoryList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_InstancesPerCategoryList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InstancesPerCategory"

    static const int kInstancesPerCategory = 0;

    /**
     * Clears the field "InstancesPerCategory".
     *
     * The field will be set to its default value. The hasInstancesPerCategory()
     * method will return false.
     */
    inline void clearInstancesPerCategory();

    /**
     * Checks whether the field "InstancesPerCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstancesPerCategory()). Otherwise it will return false.
     */
    inline bool hasInstancesPerCategory () const;

    /**
     * Returns the value of the member "InstancesPerCategory".
     *
     *
     *
     * @return The value of the field "InstancesPerCategory"
     */
    inline const ::std::vector< T_InstancesPerCategory >& getInstancesPerCategory () const;

    /**
     * Retrieves the value of the field "InstancesPerCategory" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "InstancesPerCategory".
     */
    inline ::std::vector< T_InstancesPerCategory >& getInstancesPerCategoryMutable ();

    /**
     * Sets the value of the member "InstancesPerCategory".
     *
     *
     *
     * @param InstancesPerCategory The value which will be set
     */
    inline void setInstancesPerCategory (const ::std::vector< T_InstancesPerCategory >& InstancesPerCategory_);

    // API of field "MaxAmountInstances"

    static const int kMaxAmountInstances = 1;

    /**
     * Clears the field "MaxAmountInstances".
     *
     * The field will be set to its default value. The hasMaxAmountInstances()
     * method will return false.
     */
    inline void clearMaxAmountInstances();

    /**
     * Checks whether the field "MaxAmountInstances" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxAmountInstances()). Otherwise it will return false.
     */
    inline bool hasMaxAmountInstances () const;

    /**
     * Returns the value of the member "MaxAmountInstances".
     *
     *
     *
     * @return The value of the field "MaxAmountInstances"
     */
    inline uint8 getMaxAmountInstances () const;

    /**
     * Sets the value of the member "MaxAmountInstances".
     *
     *
     *
     * @param MaxAmountInstances The value which will be set
     */
    inline void setMaxAmountInstances (uint8 MaxAmountInstances_);

    static const T_InstancesPerCategoryList &getDefaultInstance();

private:

    static const ::std::vector< T_InstancesPerCategory >& getT_InstancesPerCategoryList_DefaultInstance ();

    inline void set_has_InstancesPerCategory ();

    inline void clear_has_InstancesPerCategory ();

    inline void set_has_MaxAmountInstances ();

    inline void clear_has_MaxAmountInstances ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< T_InstancesPerCategory > _InstancesPerCategory;

    uint8 _MaxAmountInstances;

};

inline  T_AudioChannelAdvice::T_AudioChannelAdvice ()  :
    _ChannelAdvice (::acr_fi_types::T_e8_AudioChannelAdvice__Start),
    _Index (0u),
    _Device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AudioChannelAdvice::T_AudioChannelAdvice (const T_AudioChannelAdvice &rhs)  :
    _ChannelAdvice (::acr_fi_types::T_e8_AudioChannelAdvice__Start),
    _Index (0u),
    _Device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AudioChannelAdvice::T_AudioChannelAdvice (T_e8_AudioChannelAdvice ChannelAdvice_, uint8 Index_, const ::std::string& Device_)  :
    _ChannelAdvice (ChannelAdvice_),
    _Index (Index_),
    _Device (Device_)
{
    #ifndef NDEBUG
    if (!(T_e8_AudioChannelAdvice_IsValid(ChannelAdvice_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChannelAdvice_, "T_e8_AudioChannelAdvice", "ChannelAdvice", "T_AudioChannelAdvice");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AudioChannelAdvice::~T_AudioChannelAdvice() {
}

inline T_AudioChannelAdvice& T_AudioChannelAdvice::operator = (const T_AudioChannelAdvice& rhs) {
    if( this != &rhs ) {
        if (rhs.hasChannelAdvice()) {
            setChannelAdvice(rhs.getChannelAdvice());
        } else {
            clearChannelAdvice();
        }
        if (rhs.hasIndex()) {
            setIndex(rhs.getIndex());
        } else {
            clearIndex();
        }
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool T_AudioChannelAdvice::operator == (const T_AudioChannelAdvice& rhs) const {
    return (((!hasChannelAdvice() && !rhs.hasChannelAdvice()) || getChannelAdvice() == rhs.getChannelAdvice()) &&
        ((!hasIndex() && !rhs.hasIndex()) || getIndex() == rhs.getIndex()) &&
        ((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool T_AudioChannelAdvice::operator != (const T_AudioChannelAdvice& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AudioChannelAdvice::operator < (const T_AudioChannelAdvice& rhs) const {
    if (hasChannelAdvice() || rhs.hasChannelAdvice()) {
        if ((uint32)getChannelAdvice() < (uint32)rhs.getChannelAdvice()) return true;
        if ((uint32)getChannelAdvice() > (uint32)rhs.getChannelAdvice()) return false;
    }
    if (hasIndex() || rhs.hasIndex()) {
        if (getIndex() < rhs.getIndex()) return true;
        if (getIndex() > rhs.getIndex()) return false;
    }
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline bool T_AudioChannelAdvice::operator > (const T_AudioChannelAdvice& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AudioChannelAdvice::clear() {
    clearChannelAdvice();
    clearIndex();
    clearDevice();
}

inline void T_AudioChannelAdvice::clearChannelAdvice() {
    if (hasChannelAdvice()) {
         clear_has_ChannelAdvice();
        _ChannelAdvice = ::acr_fi_types::T_e8_AudioChannelAdvice__Start;
     }
}

inline bool T_AudioChannelAdvice::hasChannelAdvice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_AudioChannelAdvice T_AudioChannelAdvice::getChannelAdvice () const {
    return _ChannelAdvice;
}

inline void T_AudioChannelAdvice::setChannelAdvice (T_e8_AudioChannelAdvice ChannelAdvice_) {
    #ifndef NDEBUG
    if (!(T_e8_AudioChannelAdvice_IsValid(ChannelAdvice_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChannelAdvice_, "T_e8_AudioChannelAdvice", "ChannelAdvice", "T_AudioChannelAdvice");
    }
    #endif
    set_has_ChannelAdvice();
    this->_ChannelAdvice = ChannelAdvice_;
}

inline void T_AudioChannelAdvice::clearIndex() {
    if (hasIndex()) {
         clear_has_Index();
        _Index = 0u;
     }
}

inline bool T_AudioChannelAdvice::hasIndex () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_AudioChannelAdvice::getIndex () const {
    return _Index;
}

inline void T_AudioChannelAdvice::setIndex (uint8 Index_) {
    set_has_Index();
    this->_Index = Index_;
}

inline void T_AudioChannelAdvice::clearDevice() {
    if (hasDevice()) {
         clear_has_Device();
        _Device.clear();
     }
}

inline bool T_AudioChannelAdvice::hasDevice () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_AudioChannelAdvice::getDevice () const {
    return _Device;
}

inline ::std::string& T_AudioChannelAdvice::getDeviceMutable () {
    set_has_Device();
    return _Device;
}

inline void T_AudioChannelAdvice::setDevice (const ::std::string& Device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Device();
    this->_Device = Device_;
}

inline void T_AudioChannelAdvice::setDevice (const char* Device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Device();
    this->_Device.assign(Device_);
}

inline void T_AudioChannelAdvice::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Device();
    this->_Device.assign(value, size);
}

inline void T_AudioChannelAdvice::set_has_ChannelAdvice () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AudioChannelAdvice::clear_has_ChannelAdvice () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AudioChannelAdvice::set_has_Index () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AudioChannelAdvice::clear_has_Index () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AudioChannelAdvice::set_has_Device () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AudioChannelAdvice::clear_has_Device () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_b8_AudioFormat::T_b8_AudioFormat ()  :
    _PCM (false),
    _AMR (false),
    _AMR_WB (false),
    _MP3 (false)
{
}

inline  T_b8_AudioFormat::T_b8_AudioFormat (const T_b8_AudioFormat &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_AudioFormat::T_b8_AudioFormat (bool PCM, bool AMR, bool AMR_WB, bool MP3) :
    _PCM (PCM),
    _AMR (AMR),
    _AMR_WB (AMR_WB),
    _MP3 (MP3)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_AudioFormat& T_b8_AudioFormat::operator = (const T_b8_AudioFormat& rhs) {
    if( this != &rhs ) {
        _PCM = rhs._PCM;
        _AMR = rhs._AMR;
        _AMR_WB = rhs._AMR_WB;
        _MP3 = rhs._MP3;
    }
    return *this;
}

inline bool T_b8_AudioFormat::operator == (const T_b8_AudioFormat& rhs) const {
    return (_PCM == rhs._PCM &&
        _AMR == rhs._AMR &&
        _AMR_WB == rhs._AMR_WB &&
        _MP3 == rhs._MP3);
}

inline bool T_b8_AudioFormat::operator != (const T_b8_AudioFormat& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_AudioFormat::operator < (const T_b8_AudioFormat& rhs) const {
    if (getPCM() < rhs.getPCM()) return true;
    if (getPCM() > rhs.getPCM()) return false;

    if (getAMR() < rhs.getAMR()) return true;
    if (getAMR() > rhs.getAMR()) return false;

    if (getAMR_WB() < rhs.getAMR_WB()) return true;
    if (getAMR_WB() > rhs.getAMR_WB()) return false;

    if (getMP3() < rhs.getMP3()) return true;
    if (getMP3() > rhs.getMP3()) return false;

    return false;
}

inline bool T_b8_AudioFormat::operator > (const T_b8_AudioFormat& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_AudioFormat::setPCM (bool PCM) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_PCM = PCM;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_AudioFormat::getPCM () const {
    return _PCM;
}

inline void T_b8_AudioFormat::setAMR (bool AMR) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_AMR = AMR;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_AudioFormat::getAMR () const {
    return _AMR;
}

inline void T_b8_AudioFormat::setAMR_WB (bool AMR_WB) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_AMR_WB = AMR_WB;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_AudioFormat::getAMR_WB () const {
    return _AMR_WB;
}

inline void T_b8_AudioFormat::setMP3 (bool MP3) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_MP3 = MP3;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_AudioFormat::getMP3 () const {
    return _MP3;
}

inline  T_b8_AudioOutputLocation::T_b8_AudioOutputLocation ()  :
    _Standard (false),
    _FrontLeft (false),
    _FrontRight (false),
    _BackRight (false),
    _BackLeft (false)
{
}

inline  T_b8_AudioOutputLocation::T_b8_AudioOutputLocation (const T_b8_AudioOutputLocation &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_AudioOutputLocation::T_b8_AudioOutputLocation (bool Standard, bool FrontLeft, bool FrontRight, bool BackRight, bool BackLeft) :
    _Standard (Standard),
    _FrontLeft (FrontLeft),
    _FrontRight (FrontRight),
    _BackRight (BackRight),
    _BackLeft (BackLeft)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_AudioOutputLocation& T_b8_AudioOutputLocation::operator = (const T_b8_AudioOutputLocation& rhs) {
    if( this != &rhs ) {
        _Standard = rhs._Standard;
        _FrontLeft = rhs._FrontLeft;
        _FrontRight = rhs._FrontRight;
        _BackRight = rhs._BackRight;
        _BackLeft = rhs._BackLeft;
    }
    return *this;
}

inline bool T_b8_AudioOutputLocation::operator == (const T_b8_AudioOutputLocation& rhs) const {
    return (_Standard == rhs._Standard &&
        _FrontLeft == rhs._FrontLeft &&
        _FrontRight == rhs._FrontRight &&
        _BackRight == rhs._BackRight &&
        _BackLeft == rhs._BackLeft);
}

inline bool T_b8_AudioOutputLocation::operator != (const T_b8_AudioOutputLocation& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_AudioOutputLocation::operator < (const T_b8_AudioOutputLocation& rhs) const {
    if (getStandard() < rhs.getStandard()) return true;
    if (getStandard() > rhs.getStandard()) return false;

    if (getFrontLeft() < rhs.getFrontLeft()) return true;
    if (getFrontLeft() > rhs.getFrontLeft()) return false;

    if (getFrontRight() < rhs.getFrontRight()) return true;
    if (getFrontRight() > rhs.getFrontRight()) return false;

    if (getBackRight() < rhs.getBackRight()) return true;
    if (getBackRight() > rhs.getBackRight()) return false;

    if (getBackLeft() < rhs.getBackLeft()) return true;
    if (getBackLeft() > rhs.getBackLeft()) return false;

    return false;
}

inline bool T_b8_AudioOutputLocation::operator > (const T_b8_AudioOutputLocation& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_AudioOutputLocation::setStandard (bool Standard) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_Standard = Standard;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_AudioOutputLocation::getStandard () const {
    return _Standard;
}

inline void T_b8_AudioOutputLocation::setFrontLeft (bool FrontLeft) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_FrontLeft = FrontLeft;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_AudioOutputLocation::getFrontLeft () const {
    return _FrontLeft;
}

inline void T_b8_AudioOutputLocation::setFrontRight (bool FrontRight) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_FrontRight = FrontRight;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_AudioOutputLocation::getFrontRight () const {
    return _FrontRight;
}

inline void T_b8_AudioOutputLocation::setBackRight (bool BackRight) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_BackRight = BackRight;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_AudioOutputLocation::getBackRight () const {
    return _BackRight;
}

inline void T_b8_AudioOutputLocation::setBackLeft (bool BackLeft) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_BackLeft = BackLeft;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_AudioOutputLocation::getBackLeft () const {
    return _BackLeft;
}

inline  T_b16_RequestAddInfo::T_b16_RequestAddInfo ()  :
    _User (false),
    _Unknown (false)
{
}

inline  T_b16_RequestAddInfo::T_b16_RequestAddInfo (const T_b16_RequestAddInfo &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b16_RequestAddInfo::T_b16_RequestAddInfo (bool User, bool Unknown) :
    _User (User),
    _Unknown (Unknown)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b16_RequestAddInfo& T_b16_RequestAddInfo::operator = (const T_b16_RequestAddInfo& rhs) {
    if( this != &rhs ) {
        _User = rhs._User;
        _Unknown = rhs._Unknown;
    }
    return *this;
}

inline bool T_b16_RequestAddInfo::operator == (const T_b16_RequestAddInfo& rhs) const {
    return (_User == rhs._User &&
        _Unknown == rhs._Unknown);
}

inline bool T_b16_RequestAddInfo::operator != (const T_b16_RequestAddInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b16_RequestAddInfo::operator < (const T_b16_RequestAddInfo& rhs) const {
    if (getUser() < rhs.getUser()) return true;
    if (getUser() > rhs.getUser()) return false;

    if (getUnknown() < rhs.getUnknown()) return true;
    if (getUnknown() > rhs.getUnknown()) return false;

    return false;
}

inline bool T_b16_RequestAddInfo::operator > (const T_b16_RequestAddInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b16_RequestAddInfo::setUser (bool User) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_User = User;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_RequestAddInfo::getUser () const {
    return _User;
}

inline void T_b16_RequestAddInfo::setUnknown (bool Unknown) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_Unknown = Unknown;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b16_RequestAddInfo::getUnknown () const {
    return _Unknown;
}

inline  T_ChannelRequestStatus::T_ChannelRequestStatus ()  :
    _Category (::acr_fi_types::T_e8_VoiceCategory__DrivingRecommendation),
    _Index (0u),
    _Status (::acr_fi_types::T_e8_CatStatus__Silent),
    _AudioFormat (),
    _AudioOutputLocation (),
    _RequestAddInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ChannelRequestStatus::T_ChannelRequestStatus (const T_ChannelRequestStatus &rhs)  :
    _Category (::acr_fi_types::T_e8_VoiceCategory__DrivingRecommendation),
    _Index (0u),
    _Status (::acr_fi_types::T_e8_CatStatus__Silent),
    _AudioFormat (),
    _AudioOutputLocation (),
    _RequestAddInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ChannelRequestStatus::T_ChannelRequestStatus (T_e8_VoiceCategory Category_, uint8 Index_, T_e8_CatStatus Status_, const T_b8_AudioFormat& AudioFormat_, const T_b8_AudioOutputLocation& AudioOutputLocation_, const T_b16_RequestAddInfo& RequestAddInfo_)  :
    _Category (Category_),
    _Index (Index_),
    _Status (Status_),
    _AudioFormat (AudioFormat_),
    _AudioOutputLocation (AudioOutputLocation_),
    _RequestAddInfo (RequestAddInfo_)
{
    #ifndef NDEBUG
    if (!(T_e8_VoiceCategory_IsValid(Category_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Category_, "T_e8_VoiceCategory", "Category", "T_ChannelRequestStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_CatStatus_IsValid(Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_CatStatus", "Status", "T_ChannelRequestStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ChannelRequestStatus::~T_ChannelRequestStatus() {
}

inline T_ChannelRequestStatus& T_ChannelRequestStatus::operator = (const T_ChannelRequestStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCategory()) {
            setCategory(rhs.getCategory());
        } else {
            clearCategory();
        }
        if (rhs.hasIndex()) {
            setIndex(rhs.getIndex());
        } else {
            clearIndex();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasAudioFormat()) {
            setAudioFormat(rhs.getAudioFormat());
        } else {
            clearAudioFormat();
        }
        if (rhs.hasAudioOutputLocation()) {
            setAudioOutputLocation(rhs.getAudioOutputLocation());
        } else {
            clearAudioOutputLocation();
        }
        if (rhs.hasRequestAddInfo()) {
            setRequestAddInfo(rhs.getRequestAddInfo());
        } else {
            clearRequestAddInfo();
        }
    }
    return *this;
}

inline bool T_ChannelRequestStatus::operator == (const T_ChannelRequestStatus& rhs) const {
    return (((!hasCategory() && !rhs.hasCategory()) || getCategory() == rhs.getCategory()) &&
        ((!hasIndex() && !rhs.hasIndex()) || getIndex() == rhs.getIndex()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasAudioFormat() && !rhs.hasAudioFormat()) || getAudioFormat() == rhs.getAudioFormat()) &&
        ((!hasAudioOutputLocation() && !rhs.hasAudioOutputLocation()) || getAudioOutputLocation() == rhs.getAudioOutputLocation()) &&
        ((!hasRequestAddInfo() && !rhs.hasRequestAddInfo()) || getRequestAddInfo() == rhs.getRequestAddInfo()));
}

inline bool T_ChannelRequestStatus::operator != (const T_ChannelRequestStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ChannelRequestStatus::operator < (const T_ChannelRequestStatus& rhs) const {
    if (hasCategory() || rhs.hasCategory()) {
        if ((uint32)getCategory() < (uint32)rhs.getCategory()) return true;
        if ((uint32)getCategory() > (uint32)rhs.getCategory()) return false;
    }
    if (hasIndex() || rhs.hasIndex()) {
        if (getIndex() < rhs.getIndex()) return true;
        if (getIndex() > rhs.getIndex()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    if (hasAudioFormat() || rhs.hasAudioFormat()) {
        if (getAudioFormat() < rhs.getAudioFormat()) return true;
        if (getAudioFormat() > rhs.getAudioFormat()) return false;
    }
    if (hasAudioOutputLocation() || rhs.hasAudioOutputLocation()) {
        if (getAudioOutputLocation() < rhs.getAudioOutputLocation()) return true;
        if (getAudioOutputLocation() > rhs.getAudioOutputLocation()) return false;
    }
    if (hasRequestAddInfo() || rhs.hasRequestAddInfo()) {
        if (getRequestAddInfo() < rhs.getRequestAddInfo()) return true;
        if (getRequestAddInfo() > rhs.getRequestAddInfo()) return false;
    }
    return false;
}

inline bool T_ChannelRequestStatus::operator > (const T_ChannelRequestStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ChannelRequestStatus::clear() {
    clearCategory();
    clearIndex();
    clearStatus();
    clearAudioFormat();
    clearAudioOutputLocation();
    clearRequestAddInfo();
}

inline void T_ChannelRequestStatus::clearCategory() {
    if (hasCategory()) {
         clear_has_Category();
        _Category = ::acr_fi_types::T_e8_VoiceCategory__DrivingRecommendation;
     }
}

inline bool T_ChannelRequestStatus::hasCategory () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_VoiceCategory T_ChannelRequestStatus::getCategory () const {
    return _Category;
}

inline void T_ChannelRequestStatus::setCategory (T_e8_VoiceCategory Category_) {
    #ifndef NDEBUG
    if (!(T_e8_VoiceCategory_IsValid(Category_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Category_, "T_e8_VoiceCategory", "Category", "T_ChannelRequestStatus");
    }
    #endif
    set_has_Category();
    this->_Category = Category_;
}

inline void T_ChannelRequestStatus::clearIndex() {
    if (hasIndex()) {
         clear_has_Index();
        _Index = 0u;
     }
}

inline bool T_ChannelRequestStatus::hasIndex () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_ChannelRequestStatus::getIndex () const {
    return _Index;
}

inline void T_ChannelRequestStatus::setIndex (uint8 Index_) {
    set_has_Index();
    this->_Index = Index_;
}

inline void T_ChannelRequestStatus::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::acr_fi_types::T_e8_CatStatus__Silent;
     }
}

inline bool T_ChannelRequestStatus::hasStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_CatStatus T_ChannelRequestStatus::getStatus () const {
    return _Status;
}

inline void T_ChannelRequestStatus::setStatus (T_e8_CatStatus Status_) {
    #ifndef NDEBUG
    if (!(T_e8_CatStatus_IsValid(Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_CatStatus", "Status", "T_ChannelRequestStatus");
    }
    #endif
    set_has_Status();
    this->_Status = Status_;
}

inline void T_ChannelRequestStatus::clearAudioFormat() {
    if (hasAudioFormat()) {
         clear_has_AudioFormat();
        _AudioFormat = T_b8_AudioFormat ();
     }
}

inline bool T_ChannelRequestStatus::hasAudioFormat () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_b8_AudioFormat& T_ChannelRequestStatus::getAudioFormat () const {
    return _AudioFormat;
}

inline T_b8_AudioFormat& T_ChannelRequestStatus::getAudioFormatMutable () {
    set_has_AudioFormat();
    return _AudioFormat;
}

inline void T_ChannelRequestStatus::setAudioFormat (const T_b8_AudioFormat& AudioFormat_) {
    set_has_AudioFormat();
    this->_AudioFormat = AudioFormat_;
}

inline void T_ChannelRequestStatus::clearAudioOutputLocation() {
    if (hasAudioOutputLocation()) {
         clear_has_AudioOutputLocation();
        _AudioOutputLocation = T_b8_AudioOutputLocation ();
     }
}

inline bool T_ChannelRequestStatus::hasAudioOutputLocation () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const T_b8_AudioOutputLocation& T_ChannelRequestStatus::getAudioOutputLocation () const {
    return _AudioOutputLocation;
}

inline T_b8_AudioOutputLocation& T_ChannelRequestStatus::getAudioOutputLocationMutable () {
    set_has_AudioOutputLocation();
    return _AudioOutputLocation;
}

inline void T_ChannelRequestStatus::setAudioOutputLocation (const T_b8_AudioOutputLocation& AudioOutputLocation_) {
    set_has_AudioOutputLocation();
    this->_AudioOutputLocation = AudioOutputLocation_;
}

inline void T_ChannelRequestStatus::clearRequestAddInfo() {
    if (hasRequestAddInfo()) {
         clear_has_RequestAddInfo();
        _RequestAddInfo = T_b16_RequestAddInfo ();
     }
}

inline bool T_ChannelRequestStatus::hasRequestAddInfo () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const T_b16_RequestAddInfo& T_ChannelRequestStatus::getRequestAddInfo () const {
    return _RequestAddInfo;
}

inline T_b16_RequestAddInfo& T_ChannelRequestStatus::getRequestAddInfoMutable () {
    set_has_RequestAddInfo();
    return _RequestAddInfo;
}

inline void T_ChannelRequestStatus::setRequestAddInfo (const T_b16_RequestAddInfo& RequestAddInfo_) {
    set_has_RequestAddInfo();
    this->_RequestAddInfo = RequestAddInfo_;
}

inline void T_ChannelRequestStatus::set_has_Category () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ChannelRequestStatus::clear_has_Category () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ChannelRequestStatus::set_has_Index () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ChannelRequestStatus::clear_has_Index () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ChannelRequestStatus::set_has_Status () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ChannelRequestStatus::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_ChannelRequestStatus::set_has_AudioFormat () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_ChannelRequestStatus::clear_has_AudioFormat () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_ChannelRequestStatus::set_has_AudioOutputLocation () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_ChannelRequestStatus::clear_has_AudioOutputLocation () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_ChannelRequestStatus::set_has_RequestAddInfo () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_ChannelRequestStatus::clear_has_RequestAddInfo () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_InstancesPerCategory::T_InstancesPerCategory ()  :
    _VoiceCategory (::acr_fi_types::T_e8_VoiceCategory__DrivingRecommendation),
    _NumberOfInstances (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_InstancesPerCategory::T_InstancesPerCategory (const T_InstancesPerCategory &rhs)  :
    _VoiceCategory (::acr_fi_types::T_e8_VoiceCategory__DrivingRecommendation),
    _NumberOfInstances (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_InstancesPerCategory::T_InstancesPerCategory (T_e8_VoiceCategory VoiceCategory_, uint8 NumberOfInstances_)  :
    _VoiceCategory (VoiceCategory_),
    _NumberOfInstances (NumberOfInstances_)
{
    #ifndef NDEBUG
    if (!(T_e8_VoiceCategory_IsValid(VoiceCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoiceCategory_, "T_e8_VoiceCategory", "VoiceCategory", "T_InstancesPerCategory");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_InstancesPerCategory::~T_InstancesPerCategory() {
}

inline T_InstancesPerCategory& T_InstancesPerCategory::operator = (const T_InstancesPerCategory& rhs) {
    if( this != &rhs ) {
        if (rhs.hasVoiceCategory()) {
            setVoiceCategory(rhs.getVoiceCategory());
        } else {
            clearVoiceCategory();
        }
        if (rhs.hasNumberOfInstances()) {
            setNumberOfInstances(rhs.getNumberOfInstances());
        } else {
            clearNumberOfInstances();
        }
    }
    return *this;
}

inline bool T_InstancesPerCategory::operator == (const T_InstancesPerCategory& rhs) const {
    return (((!hasVoiceCategory() && !rhs.hasVoiceCategory()) || getVoiceCategory() == rhs.getVoiceCategory()) &&
        ((!hasNumberOfInstances() && !rhs.hasNumberOfInstances()) || getNumberOfInstances() == rhs.getNumberOfInstances()));
}

inline bool T_InstancesPerCategory::operator != (const T_InstancesPerCategory& rhs) const {
    return ! (*this == rhs);
}

inline bool T_InstancesPerCategory::operator < (const T_InstancesPerCategory& rhs) const {
    if (hasVoiceCategory() || rhs.hasVoiceCategory()) {
        if ((uint32)getVoiceCategory() < (uint32)rhs.getVoiceCategory()) return true;
        if ((uint32)getVoiceCategory() > (uint32)rhs.getVoiceCategory()) return false;
    }
    if (hasNumberOfInstances() || rhs.hasNumberOfInstances()) {
        if (getNumberOfInstances() < rhs.getNumberOfInstances()) return true;
        if (getNumberOfInstances() > rhs.getNumberOfInstances()) return false;
    }
    return false;
}

inline bool T_InstancesPerCategory::operator > (const T_InstancesPerCategory& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_InstancesPerCategory::clear() {
    clearVoiceCategory();
    clearNumberOfInstances();
}

inline void T_InstancesPerCategory::clearVoiceCategory() {
    if (hasVoiceCategory()) {
         clear_has_VoiceCategory();
        _VoiceCategory = ::acr_fi_types::T_e8_VoiceCategory__DrivingRecommendation;
     }
}

inline bool T_InstancesPerCategory::hasVoiceCategory () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_VoiceCategory T_InstancesPerCategory::getVoiceCategory () const {
    return _VoiceCategory;
}

inline void T_InstancesPerCategory::setVoiceCategory (T_e8_VoiceCategory VoiceCategory_) {
    #ifndef NDEBUG
    if (!(T_e8_VoiceCategory_IsValid(VoiceCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VoiceCategory_, "T_e8_VoiceCategory", "VoiceCategory", "T_InstancesPerCategory");
    }
    #endif
    set_has_VoiceCategory();
    this->_VoiceCategory = VoiceCategory_;
}

inline void T_InstancesPerCategory::clearNumberOfInstances() {
    if (hasNumberOfInstances()) {
         clear_has_NumberOfInstances();
        _NumberOfInstances = 0u;
     }
}

inline bool T_InstancesPerCategory::hasNumberOfInstances () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_InstancesPerCategory::getNumberOfInstances () const {
    return _NumberOfInstances;
}

inline void T_InstancesPerCategory::setNumberOfInstances (uint8 NumberOfInstances_) {
    set_has_NumberOfInstances();
    this->_NumberOfInstances = NumberOfInstances_;
}

inline void T_InstancesPerCategory::set_has_VoiceCategory () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_InstancesPerCategory::clear_has_VoiceCategory () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_InstancesPerCategory::set_has_NumberOfInstances () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_InstancesPerCategory::clear_has_NumberOfInstances () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_InstancesPerCategoryList::T_InstancesPerCategoryList ()  :
    _InstancesPerCategory (),
    _MaxAmountInstances (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_InstancesPerCategoryList::T_InstancesPerCategoryList (const T_InstancesPerCategoryList &rhs)  :
    _InstancesPerCategory (),
    _MaxAmountInstances (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_InstancesPerCategoryList::T_InstancesPerCategoryList (const ::std::vector< T_InstancesPerCategory >& InstancesPerCategory_, uint8 MaxAmountInstances_)  :
    _InstancesPerCategory (InstancesPerCategory_),
    _MaxAmountInstances (MaxAmountInstances_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_InstancesPerCategoryList::~T_InstancesPerCategoryList() {
}

inline T_InstancesPerCategoryList& T_InstancesPerCategoryList::operator = (const T_InstancesPerCategoryList& rhs) {
    if( this != &rhs ) {
        if (rhs.hasInstancesPerCategory()) {
            setInstancesPerCategory(rhs.getInstancesPerCategory());
        } else {
            clearInstancesPerCategory();
        }
        if (rhs.hasMaxAmountInstances()) {
            setMaxAmountInstances(rhs.getMaxAmountInstances());
        } else {
            clearMaxAmountInstances();
        }
    }
    return *this;
}

inline bool T_InstancesPerCategoryList::operator == (const T_InstancesPerCategoryList& rhs) const {
    return (((!hasInstancesPerCategory() && !rhs.hasInstancesPerCategory()) || getInstancesPerCategory() == rhs.getInstancesPerCategory()) &&
        ((!hasMaxAmountInstances() && !rhs.hasMaxAmountInstances()) || getMaxAmountInstances() == rhs.getMaxAmountInstances()));
}

inline bool T_InstancesPerCategoryList::operator != (const T_InstancesPerCategoryList& rhs) const {
    return ! (*this == rhs);
}

inline bool T_InstancesPerCategoryList::operator < (const T_InstancesPerCategoryList& rhs) const {
    if (hasInstancesPerCategory() || rhs.hasInstancesPerCategory()) {
        if (getInstancesPerCategory() < rhs.getInstancesPerCategory()) return true;
        if (getInstancesPerCategory() > rhs.getInstancesPerCategory()) return false;
    }
    if (hasMaxAmountInstances() || rhs.hasMaxAmountInstances()) {
        if (getMaxAmountInstances() < rhs.getMaxAmountInstances()) return true;
        if (getMaxAmountInstances() > rhs.getMaxAmountInstances()) return false;
    }
    return false;
}

inline bool T_InstancesPerCategoryList::operator > (const T_InstancesPerCategoryList& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_InstancesPerCategoryList::clear() {
    clearInstancesPerCategory();
    clearMaxAmountInstances();
}

inline void T_InstancesPerCategoryList::clearInstancesPerCategory() {
    if (hasInstancesPerCategory()) {
         clear_has_InstancesPerCategory();
        _InstancesPerCategory.clear();
     }
}

inline bool T_InstancesPerCategoryList::hasInstancesPerCategory () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< T_InstancesPerCategory >& T_InstancesPerCategoryList::getInstancesPerCategory () const {
    return _InstancesPerCategory;
}

inline ::std::vector< T_InstancesPerCategory >& T_InstancesPerCategoryList::getInstancesPerCategoryMutable () {
    set_has_InstancesPerCategory();
    return _InstancesPerCategory;
}

inline void T_InstancesPerCategoryList::setInstancesPerCategory (const ::std::vector< T_InstancesPerCategory >& InstancesPerCategory_) {
    set_has_InstancesPerCategory();
    this->_InstancesPerCategory = InstancesPerCategory_;
}

inline void T_InstancesPerCategoryList::clearMaxAmountInstances() {
    if (hasMaxAmountInstances()) {
         clear_has_MaxAmountInstances();
        _MaxAmountInstances = 0u;
     }
}

inline bool T_InstancesPerCategoryList::hasMaxAmountInstances () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_InstancesPerCategoryList::getMaxAmountInstances () const {
    return _MaxAmountInstances;
}

inline void T_InstancesPerCategoryList::setMaxAmountInstances (uint8 MaxAmountInstances_) {
    set_has_MaxAmountInstances();
    this->_MaxAmountInstances = MaxAmountInstances_;
}

inline void T_InstancesPerCategoryList::set_has_InstancesPerCategory () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_InstancesPerCategoryList::clear_has_InstancesPerCategory () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_InstancesPerCategoryList::set_has_MaxAmountInstances () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_InstancesPerCategoryList::clear_has_MaxAmountInstances () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace acr_fi_types

#endif // ACR_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
