/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "SDS_TTS_FICca.h"
#include "SDS_TTS_FIJson.h"
#include "SDS_TTS_FIProxy.h"
#include "acr_fi_types.h"
#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "sds_sds2hmi_common_types.h"
#include "sds_speechdp_fi_types.h"
#include "sds_tts_fi_types.h"
#include "sds_tts_fi_typesConst.h"
#include <string>
#include <vector>

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace SDS_TTS_FI {

/*static*/ ::asf::core::Logger SDS_TTS_FIProxy::_logger ("/SDS_TTS_FI/SDS_TTS_FIProxy");


class SDS_TTS_FIProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    SDS_TTS_FIProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<SDS_TTS_FIProxy> proxy = ::boost::static_pointer_cast<SDS_TTS_FIProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_SynthesizeSpeak: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultFirst: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SynthesizeSpeakResultFirst);
                                setActAndLogResultFirst(message, "SynthesizeSpeak", reinterpret_cast<act_t>(this), _logger);
                                ((SynthesizeSpeakCallbackIF*) _callback)->onSynthesizeSpeakResultFirst (proxy, ::boost::static_pointer_cast<SynthesizeSpeakResultFirst>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return false;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultMiddle: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SynthesizeSpeakResultMiddle);
                                setActAndLogResultMiddle(message, "SynthesizeSpeak", reinterpret_cast<act_t>(this), _logger);
                                ((SynthesizeSpeakCallbackIF*) _callback)->onSynthesizeSpeakResultMiddle (proxy, ::boost::static_pointer_cast<SynthesizeSpeakResultMiddle>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return false;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultLast: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SynthesizeSpeakResultLast);
                                setActAndLogResultLast(message, "SynthesizeSpeak", reinterpret_cast<act_t>(this), _logger);
                                ((SynthesizeSpeakCallbackIF*) _callback)->onSynthesizeSpeakResultLast (proxy, ::boost::static_pointer_cast<SynthesizeSpeakResultLast>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SynthesizeSpeakError);
                                setActAndLogError(message, "SynthesizeSpeak", reinterpret_cast<act_t>(this), _logger);
                                ((SynthesizeSpeakCallbackIF*) _callback)->onSynthesizeSpeakError (proxy, ::boost::static_pointer_cast<SynthesizeSpeakError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SynthesizeWrite: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultFirst: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SynthesizeWriteResultFirst);
                                setActAndLogResultFirst(message, "SynthesizeWrite", reinterpret_cast<act_t>(this), _logger);
                                ((SynthesizeWriteCallbackIF*) _callback)->onSynthesizeWriteResultFirst (proxy, ::boost::static_pointer_cast<SynthesizeWriteResultFirst>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return false;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultMiddle: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SynthesizeWriteResultMiddle);
                                setActAndLogResultMiddle(message, "SynthesizeWrite", reinterpret_cast<act_t>(this), _logger);
                                ((SynthesizeWriteCallbackIF*) _callback)->onSynthesizeWriteResultMiddle (proxy, ::boost::static_pointer_cast<SynthesizeWriteResultMiddle>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return false;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultLast: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SynthesizeWriteResultLast);
                                setActAndLogResultLast(message, "SynthesizeWrite", reinterpret_cast<act_t>(this), _logger);
                                ((SynthesizeWriteCallbackIF*) _callback)->onSynthesizeWriteResultLast (proxy, ::boost::static_pointer_cast<SynthesizeWriteResultLast>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SynthesizeWriteError);
                                setActAndLogError(message, "SynthesizeWrite", reinterpret_cast<act_t>(this), _logger);
                                ((SynthesizeWriteCallbackIF*) _callback)->onSynthesizeWriteError (proxy, ::boost::static_pointer_cast<SynthesizeWriteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SynthesizeSpeakWithExtension: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultFirst: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SynthesizeSpeakWithExtensionResultFirst);
                                setActAndLogResultFirst(message, "SynthesizeSpeakWithExtension", reinterpret_cast<act_t>(this), _logger);
                                ((SynthesizeSpeakWithExtensionCallbackIF*) _callback)->onSynthesizeSpeakWithExtensionResultFirst (proxy, ::boost::static_pointer_cast<SynthesizeSpeakWithExtensionResultFirst>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return false;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultMiddle: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SynthesizeSpeakWithExtensionResultMiddle);
                                setActAndLogResultMiddle(message, "SynthesizeSpeakWithExtension", reinterpret_cast<act_t>(this), _logger);
                                ((SynthesizeSpeakWithExtensionCallbackIF*) _callback)->onSynthesizeSpeakWithExtensionResultMiddle (proxy, ::boost::static_pointer_cast<SynthesizeSpeakWithExtensionResultMiddle>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return false;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultLast: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SynthesizeSpeakWithExtensionResultLast);
                                setActAndLogResultLast(message, "SynthesizeSpeakWithExtension", reinterpret_cast<act_t>(this), _logger);
                                ((SynthesizeSpeakWithExtensionCallbackIF*) _callback)->onSynthesizeSpeakWithExtensionResultLast (proxy, ::boost::static_pointer_cast<SynthesizeSpeakWithExtensionResultLast>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SynthesizeSpeakWithExtensionError);
                                setActAndLogError(message, "SynthesizeSpeakWithExtension", reinterpret_cast<act_t>(this), _logger);
                                ((SynthesizeSpeakWithExtensionCallbackIF*) _callback)->onSynthesizeSpeakWithExtensionError (proxy, ::boost::static_pointer_cast<SynthesizeSpeakWithExtensionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_PrepareVoiceOutput: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::PrepareVoiceOutputResult);
                                setActAndLogResult(message, "PrepareVoiceOutput", reinterpret_cast<act_t>(this), _logger);
                                ((PrepareVoiceOutputCallbackIF*) _callback)->onPrepareVoiceOutputResult (proxy, ::boost::static_pointer_cast<PrepareVoiceOutputResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::PrepareVoiceOutputError);
                                setActAndLogError(message, "PrepareVoiceOutput", reinterpret_cast<act_t>(this), _logger);
                                ((PrepareVoiceOutputCallbackIF*) _callback)->onPrepareVoiceOutputError (proxy, ::boost::static_pointer_cast<PrepareVoiceOutputError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ReleaseData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::ReleaseDataResult);
                                setActAndLogResult(message, "ReleaseData", reinterpret_cast<act_t>(this), _logger);
                                ((ReleaseDataCallbackIF*) _callback)->onReleaseDataResult (proxy, ::boost::static_pointer_cast<ReleaseDataResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::ReleaseDataError);
                                setActAndLogError(message, "ReleaseData", reinterpret_cast<act_t>(this), _logger);
                                ((ReleaseDataCallbackIF*) _callback)->onReleaseDataError (proxy, ::boost::static_pointer_cast<ReleaseDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetVoice: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SetVoiceResult);
                                setActAndLogResult(message, "SetVoice", reinterpret_cast<act_t>(this), _logger);
                                ((SetVoiceCallbackIF*) _callback)->onSetVoiceResult (proxy, ::boost::static_pointer_cast<SetVoiceResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SetVoiceError);
                                setActAndLogError(message, "SetVoice", reinterpret_cast<act_t>(this), _logger);
                                ((SetVoiceCallbackIF*) _callback)->onSetVoiceError (proxy, ::boost::static_pointer_cast<SetVoiceError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AbortPrompt: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::AbortPromptResult);
                                setActAndLogResult(message, "AbortPrompt", reinterpret_cast<act_t>(this), _logger);
                                ((AbortPromptCallbackIF*) _callback)->onAbortPromptResult (proxy, ::boost::static_pointer_cast<AbortPromptResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::AbortPromptError);
                                setActAndLogError(message, "AbortPrompt", reinterpret_cast<act_t>(this), _logger);
                                ((AbortPromptCallbackIF*) _callback)->onAbortPromptError (proxy, ::boost::static_pointer_cast<AbortPromptError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_PausePrompt: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::PausePromptResult);
                                setActAndLogResult(message, "PausePrompt", reinterpret_cast<act_t>(this), _logger);
                                ((PausePromptCallbackIF*) _callback)->onPausePromptResult (proxy, ::boost::static_pointer_cast<PausePromptResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::PausePromptError);
                                setActAndLogError(message, "PausePrompt", reinterpret_cast<act_t>(this), _logger);
                                ((PausePromptCallbackIF*) _callback)->onPausePromptError (proxy, ::boost::static_pointer_cast<PausePromptError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ContinuePrompt: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::ContinuePromptResult);
                                setActAndLogResult(message, "ContinuePrompt", reinterpret_cast<act_t>(this), _logger);
                                ((ContinuePromptCallbackIF*) _callback)->onContinuePromptResult (proxy, ::boost::static_pointer_cast<ContinuePromptResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::ContinuePromptError);
                                setActAndLogError(message, "ContinuePrompt", reinterpret_cast<act_t>(this), _logger);
                                ((ContinuePromptCallbackIF*) _callback)->onContinuePromptError (proxy, ::boost::static_pointer_cast<ContinuePromptError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AbortPromptWithExtension: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::AbortPromptWithExtensionResult);
                                setActAndLogResult(message, "AbortPromptWithExtension", reinterpret_cast<act_t>(this), _logger);
                                ((AbortPromptWithExtensionCallbackIF*) _callback)->onAbortPromptWithExtensionResult (proxy, ::boost::static_pointer_cast<AbortPromptWithExtensionResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::AbortPromptWithExtensionError);
                                setActAndLogError(message, "AbortPromptWithExtension", reinterpret_cast<act_t>(this), _logger);
                                ((AbortPromptWithExtensionCallbackIF*) _callback)->onAbortPromptWithExtensionError (proxy, ::boost::static_pointer_cast<AbortPromptWithExtensionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_PausePromptWithExtension: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::PausePromptWithExtensionResult);
                                setActAndLogResult(message, "PausePromptWithExtension", reinterpret_cast<act_t>(this), _logger);
                                ((PausePromptWithExtensionCallbackIF*) _callback)->onPausePromptWithExtensionResult (proxy, ::boost::static_pointer_cast<PausePromptWithExtensionResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::PausePromptWithExtensionError);
                                setActAndLogError(message, "PausePromptWithExtension", reinterpret_cast<act_t>(this), _logger);
                                ((PausePromptWithExtensionCallbackIF*) _callback)->onPausePromptWithExtensionError (proxy, ::boost::static_pointer_cast<PausePromptWithExtensionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ContinuePromptWithExtension: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::ContinuePromptWithExtensionResult);
                                setActAndLogResult(message, "ContinuePromptWithExtension", reinterpret_cast<act_t>(this), _logger);
                                ((ContinuePromptWithExtensionCallbackIF*) _callback)->onContinuePromptWithExtensionResult (proxy, ::boost::static_pointer_cast<ContinuePromptWithExtensionResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::ContinuePromptWithExtensionError);
                                setActAndLogError(message, "ContinuePromptWithExtension", reinterpret_cast<act_t>(this), _logger);
                                ((ContinuePromptWithExtensionCallbackIF*) _callback)->onContinuePromptWithExtensionError (proxy, ::boost::static_pointer_cast<ContinuePromptWithExtensionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RequestPhoneme: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::RequestPhonemeResult);
                                setActAndLogResult(message, "RequestPhoneme", reinterpret_cast<act_t>(this), _logger);
                                ((RequestPhonemeCallbackIF*) _callback)->onRequestPhonemeResult (proxy, ::boost::static_pointer_cast<RequestPhonemeResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::RequestPhonemeError);
                                setActAndLogError(message, "RequestPhoneme", reinterpret_cast<act_t>(this), _logger);
                                ((RequestPhonemeCallbackIF*) _callback)->onRequestPhonemeError (proxy, ::boost::static_pointer_cast<RequestPhonemeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_LoadTuningFiles: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::LoadTuningFilesResult);
                                setActAndLogResult(message, "LoadTuningFiles", reinterpret_cast<act_t>(this), _logger);
                                ((LoadTuningFilesCallbackIF*) _callback)->onLoadTuningFilesResult (proxy, ::boost::static_pointer_cast<LoadTuningFilesResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::LoadTuningFilesError);
                                setActAndLogError(message, "LoadTuningFiles", reinterpret_cast<act_t>(this), _logger);
                                ((LoadTuningFilesCallbackIF*) _callback)->onLoadTuningFilesError (proxy, ::boost::static_pointer_cast<LoadTuningFilesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetDefaultSpeechRate: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SetDefaultSpeechRateResult);
                                setActAndLogResult(message, "SetDefaultSpeechRate", reinterpret_cast<act_t>(this), _logger);
                                ((SetDefaultSpeechRateCallbackIF*) _callback)->onSetDefaultSpeechRateResult (proxy, ::boost::static_pointer_cast<SetDefaultSpeechRateResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::SetDefaultSpeechRateError);
                                setActAndLogError(message, "SetDefaultSpeechRate", reinterpret_cast<act_t>(this), _logger);
                                ((SetDefaultSpeechRateCallbackIF*) _callback)->onSetDefaultSpeechRateError (proxy, ::boost::static_pointer_cast<SetDefaultSpeechRateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DoSynthesisForSpeak: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoSynthesisForSpeakResult);
                                setActAndLogResult(message, "DoSynthesisForSpeak", reinterpret_cast<act_t>(this), _logger);
                                ((DoSynthesisForSpeakCallbackIF*) _callback)->onDoSynthesisForSpeakResult (proxy, ::boost::static_pointer_cast<DoSynthesisForSpeakResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoSynthesisForSpeakError);
                                setActAndLogError(message, "DoSynthesisForSpeak", reinterpret_cast<act_t>(this), _logger);
                                ((DoSynthesisForSpeakCallbackIF*) _callback)->onDoSynthesisForSpeakError (proxy, ::boost::static_pointer_cast<DoSynthesisForSpeakError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DoPrepareAudioOutput: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoPrepareAudioOutputResult);
                                setActAndLogResult(message, "DoPrepareAudioOutput", reinterpret_cast<act_t>(this), _logger);
                                ((DoPrepareAudioOutputCallbackIF*) _callback)->onDoPrepareAudioOutputResult (proxy, ::boost::static_pointer_cast<DoPrepareAudioOutputResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoPrepareAudioOutputError);
                                setActAndLogError(message, "DoPrepareAudioOutput", reinterpret_cast<act_t>(this), _logger);
                                ((DoPrepareAudioOutputCallbackIF*) _callback)->onDoPrepareAudioOutputError (proxy, ::boost::static_pointer_cast<DoPrepareAudioOutputError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DoAudioOutputSpeak: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultFirst: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoAudioOutputSpeakResultFirst);
                                setActAndLogResultFirst(message, "DoAudioOutputSpeak", reinterpret_cast<act_t>(this), _logger);
                                ((DoAudioOutputSpeakCallbackIF*) _callback)->onDoAudioOutputSpeakResultFirst (proxy, ::boost::static_pointer_cast<DoAudioOutputSpeakResultFirst>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return false;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultMiddle: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoAudioOutputSpeakResultMiddle);
                                setActAndLogResultMiddle(message, "DoAudioOutputSpeak", reinterpret_cast<act_t>(this), _logger);
                                ((DoAudioOutputSpeakCallbackIF*) _callback)->onDoAudioOutputSpeakResultMiddle (proxy, ::boost::static_pointer_cast<DoAudioOutputSpeakResultMiddle>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return false;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultLast: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoAudioOutputSpeakResultLast);
                                setActAndLogResultLast(message, "DoAudioOutputSpeak", reinterpret_cast<act_t>(this), _logger);
                                ((DoAudioOutputSpeakCallbackIF*) _callback)->onDoAudioOutputSpeakResultLast (proxy, ::boost::static_pointer_cast<DoAudioOutputSpeakResultLast>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoAudioOutputSpeakError);
                                setActAndLogError(message, "DoAudioOutputSpeak", reinterpret_cast<act_t>(this), _logger);
                                ((DoAudioOutputSpeakCallbackIF*) _callback)->onDoAudioOutputSpeakError (proxy, ::boost::static_pointer_cast<DoAudioOutputSpeakError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DoUpRegToProperties: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoUpRegToPropertiesResult);
                                setActAndLogResult(message, "DoUpRegToProperties", reinterpret_cast<act_t>(this), _logger);
                                ((DoUpRegToPropertiesCallbackIF*) _callback)->onDoUpRegToPropertiesResult (proxy, ::boost::static_pointer_cast<DoUpRegToPropertiesResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoUpRegToPropertiesError);
                                setActAndLogError(message, "DoUpRegToProperties", reinterpret_cast<act_t>(this), _logger);
                                ((DoUpRegToPropertiesCallbackIF*) _callback)->onDoUpRegToPropertiesError (proxy, ::boost::static_pointer_cast<DoUpRegToPropertiesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DoSynthesisForWrite: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoSynthesisForWriteResult);
                                setActAndLogResult(message, "DoSynthesisForWrite", reinterpret_cast<act_t>(this), _logger);
                                ((DoSynthesisForWriteCallbackIF*) _callback)->onDoSynthesisForWriteResult (proxy, ::boost::static_pointer_cast<DoSynthesisForWriteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoSynthesisForWriteError);
                                setActAndLogError(message, "DoSynthesisForWrite", reinterpret_cast<act_t>(this), _logger);
                                ((DoSynthesisForWriteCallbackIF*) _callback)->onDoSynthesisForWriteError (proxy, ::boost::static_pointer_cast<DoSynthesisForWriteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DoAudioOutputWrite: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultFirst: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoAudioOutputWriteResultFirst);
                                setActAndLogResultFirst(message, "DoAudioOutputWrite", reinterpret_cast<act_t>(this), _logger);
                                ((DoAudioOutputWriteCallbackIF*) _callback)->onDoAudioOutputWriteResultFirst (proxy, ::boost::static_pointer_cast<DoAudioOutputWriteResultFirst>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return false;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultMiddle: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoAudioOutputWriteResultMiddle);
                                setActAndLogResultMiddle(message, "DoAudioOutputWrite", reinterpret_cast<act_t>(this), _logger);
                                ((DoAudioOutputWriteCallbackIF*) _callback)->onDoAudioOutputWriteResultMiddle (proxy, ::boost::static_pointer_cast<DoAudioOutputWriteResultMiddle>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return false;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultLast: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoAudioOutputWriteResultLast);
                                setActAndLogResultLast(message, "DoAudioOutputWrite", reinterpret_cast<act_t>(this), _logger);
                                ((DoAudioOutputWriteCallbackIF*) _callback)->onDoAudioOutputWriteResultLast (proxy, ::boost::static_pointer_cast<DoAudioOutputWriteResultLast>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoAudioOutputWriteError);
                                setActAndLogError(message, "DoAudioOutputWrite", reinterpret_cast<act_t>(this), _logger);
                                ((DoAudioOutputWriteCallbackIF*) _callback)->onDoAudioOutputWriteError (proxy, ::boost::static_pointer_cast<DoAudioOutputWriteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DoSynthesisForSpeakWithExtention: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoSynthesisForSpeakWithExtentionResult);
                                setActAndLogResult(message, "DoSynthesisForSpeakWithExtention", reinterpret_cast<act_t>(this), _logger);
                                ((DoSynthesisForSpeakWithExtentionCallbackIF*) _callback)->onDoSynthesisForSpeakWithExtentionResult (proxy, ::boost::static_pointer_cast<DoSynthesisForSpeakWithExtentionResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoSynthesisForSpeakWithExtentionError);
                                setActAndLogError(message, "DoSynthesisForSpeakWithExtention", reinterpret_cast<act_t>(this), _logger);
                                ((DoSynthesisForSpeakWithExtentionCallbackIF*) _callback)->onDoSynthesisForSpeakWithExtentionError (proxy, ::boost::static_pointer_cast<DoSynthesisForSpeakWithExtentionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DoReleaseData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoReleaseDataResult);
                                setActAndLogResult(message, "DoReleaseData", reinterpret_cast<act_t>(this), _logger);
                                ((DoReleaseDataCallbackIF*) _callback)->onDoReleaseDataResult (proxy, ::boost::static_pointer_cast<DoReleaseDataResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoReleaseDataError);
                                setActAndLogError(message, "DoReleaseData", reinterpret_cast<act_t>(this), _logger);
                                ((DoReleaseDataCallbackIF*) _callback)->onDoReleaseDataError (proxy, ::boost::static_pointer_cast<DoReleaseDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DoReleaseAudioDevice: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoReleaseAudioDeviceResult);
                                setActAndLogResult(message, "DoReleaseAudioDevice", reinterpret_cast<act_t>(this), _logger);
                                ((DoReleaseAudioDeviceCallbackIF*) _callback)->onDoReleaseAudioDeviceResult (proxy, ::boost::static_pointer_cast<DoReleaseAudioDeviceResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoReleaseAudioDeviceError);
                                setActAndLogError(message, "DoReleaseAudioDevice", reinterpret_cast<act_t>(this), _logger);
                                ((DoReleaseAudioDeviceCallbackIF*) _callback)->onDoReleaseAudioDeviceError (proxy, ::boost::static_pointer_cast<DoReleaseAudioDeviceError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DoRequestPhoneme: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoRequestPhonemeResult);
                                setActAndLogResult(message, "DoRequestPhoneme", reinterpret_cast<act_t>(this), _logger);
                                ((DoRequestPhonemeCallbackIF*) _callback)->onDoRequestPhonemeResult (proxy, ::boost::static_pointer_cast<DoRequestPhonemeResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoRequestPhonemeError);
                                setActAndLogError(message, "DoRequestPhoneme", reinterpret_cast<act_t>(this), _logger);
                                ((DoRequestPhonemeCallbackIF*) _callback)->onDoRequestPhonemeError (proxy, ::boost::static_pointer_cast<DoRequestPhonemeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DoAudioOutputSpeakWithExtension: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultFirst: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionResultFirst);
                                setActAndLogResultFirst(message, "DoAudioOutputSpeakWithExtension", reinterpret_cast<act_t>(this), _logger);
                                ((DoAudioOutputSpeakWithExtensionCallbackIF*) _callback)->onDoAudioOutputSpeakWithExtensionResultFirst (proxy, ::boost::static_pointer_cast<DoAudioOutputSpeakWithExtensionResultFirst>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return false;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultMiddle: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionResultMiddle);
                                setActAndLogResultMiddle(message, "DoAudioOutputSpeakWithExtension", reinterpret_cast<act_t>(this), _logger);
                                ((DoAudioOutputSpeakWithExtensionCallbackIF*) _callback)->onDoAudioOutputSpeakWithExtensionResultMiddle (proxy, ::boost::static_pointer_cast<DoAudioOutputSpeakWithExtensionResultMiddle>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return false;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResultLast: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionResultLast);
                                setActAndLogResultLast(message, "DoAudioOutputSpeakWithExtension", reinterpret_cast<act_t>(this), _logger);
                                ((DoAudioOutputSpeakWithExtensionCallbackIF*) _callback)->onDoAudioOutputSpeakWithExtensionResultLast (proxy, ::boost::static_pointer_cast<DoAudioOutputSpeakWithExtensionResultLast>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionError);
                                setActAndLogError(message, "DoAudioOutputSpeakWithExtension", reinterpret_cast<act_t>(this), _logger);
                                ((DoAudioOutputSpeakWithExtensionCallbackIF*) _callback)->onDoAudioOutputSpeakWithExtensionError (proxy, ::boost::static_pointer_cast<DoAudioOutputSpeakWithExtensionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Voice: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::VoiceStatus);
                                setActAndLogStatus(message, "Voice", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<VoiceStatus> payload = ::boost::static_pointer_cast<VoiceStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< VoiceStatus >& refNullableStatus = proxy->_voice;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((VoiceCallbackIF*) _callback)->onVoiceStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((VoiceCallbackIF*) _callback)->onVoiceStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::VoiceError);
                                setActAndLogError(message, "Voice", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((VoiceCallbackIF*) _callback)->onVoiceError(proxy, ::boost::static_pointer_cast<VoiceError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AvailableVoices: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::AvailableVoicesStatus);
                                setActAndLogStatus(message, "AvailableVoices", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AvailableVoicesStatus> payload = ::boost::static_pointer_cast<AvailableVoicesStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AvailableVoicesStatus >& refNullableStatus = proxy->_availableVoices;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AvailableVoicesCallbackIF*) _callback)->onAvailableVoicesStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AvailableVoicesCallbackIF*) _callback)->onAvailableVoicesStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::AvailableVoicesError);
                                setActAndLogError(message, "AvailableVoices", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AvailableVoicesCallbackIF*) _callback)->onAvailableVoicesError(proxy, ::boost::static_pointer_cast<AvailableVoicesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_TTSVersionInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::TTSVersionInfoStatus);
                                setActAndLogStatus(message, "TTSVersionInfo", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<TTSVersionInfoStatus> payload = ::boost::static_pointer_cast<TTSVersionInfoStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< TTSVersionInfoStatus >& refNullableStatus = proxy->_tTSVersionInfo;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((TTSVersionInfoCallbackIF*) _callback)->onTTSVersionInfoStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((TTSVersionInfoCallbackIF*) _callback)->onTTSVersionInfoStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::TTSVersionInfoError);
                                setActAndLogError(message, "TTSVersionInfo", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((TTSVersionInfoCallbackIF*) _callback)->onTTSVersionInfoError(proxy, ::boost::static_pointer_cast<TTSVersionInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_TTSStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::TTSStatusStatus);
                                setActAndLogStatus(message, "TTSStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<TTSStatusStatus> payload = ::boost::static_pointer_cast<TTSStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< TTSStatusStatus >& refNullableStatus = proxy->_tTSStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((TTSStatusCallbackIF*) _callback)->onTTSStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((TTSStatusCallbackIF*) _callback)->onTTSStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::TTSStatusError);
                                setActAndLogError(message, "TTSStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((TTSStatusCallbackIF*) _callback)->onTTSStatusError(proxy, ::boost::static_pointer_cast<TTSStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DownloadComplete: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DownloadCompleteStatus);
                                setActAndLogStatus(message, "DownloadComplete", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DownloadCompleteStatus> payload = ::boost::static_pointer_cast<DownloadCompleteStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DownloadCompleteStatus >& refNullableStatus = proxy->_downloadComplete;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DownloadCompleteCallbackIF*) _callback)->onDownloadCompleteStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DownloadCompleteCallbackIF*) _callback)->onDownloadCompleteStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::DownloadCompleteError);
                                setActAndLogError(message, "DownloadComplete", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DownloadCompleteCallbackIF*) _callback)->onDownloadCompleteError(proxy, ::boost::static_pointer_cast<DownloadCompleteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_TTSPlaybackSpacing: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::TTSPlaybackSpacingStatus);
                                setActAndLogStatus(message, "TTSPlaybackSpacing", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<TTSPlaybackSpacingStatus> payload = ::boost::static_pointer_cast<TTSPlaybackSpacingStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< TTSPlaybackSpacingStatus >& refNullableStatus = proxy->_tTSPlaybackSpacing;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((TTSPlaybackSpacingCallbackIF*) _callback)->onTTSPlaybackSpacingStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((TTSPlaybackSpacingCallbackIF*) _callback)->onTTSPlaybackSpacingStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SDS_TTS_FI::TTSPlaybackSpacingError);
                                setActAndLogError(message, "TTSPlaybackSpacing", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((TTSPlaybackSpacingCallbackIF*) _callback)->onTTSPlaybackSpacingError(proxy, ::boost::static_pointer_cast<TTSPlaybackSpacingError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<SDS_TTS_FIProxy> proxy = ::boost::static_pointer_cast<SDS_TTS_FIProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_SynthesizeSpeak: {
                ::boost::shared_ptr< SynthesizeSpeakError > payload (new SynthesizeSpeakError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SynthesizeSpeak", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SynthesizeSpeakCallbackIF*) _callback)->onSynthesizeSpeakError (proxy, payload);
                return true;
            }
            case FID_SynthesizeWrite: {
                ::boost::shared_ptr< SynthesizeWriteError > payload (new SynthesizeWriteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SynthesizeWrite", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SynthesizeWriteCallbackIF*) _callback)->onSynthesizeWriteError (proxy, payload);
                return true;
            }
            case FID_SynthesizeSpeakWithExtension: {
                ::boost::shared_ptr< SynthesizeSpeakWithExtensionError > payload (new SynthesizeSpeakWithExtensionError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SynthesizeSpeakWithExtension", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SynthesizeSpeakWithExtensionCallbackIF*) _callback)->onSynthesizeSpeakWithExtensionError (proxy, payload);
                return true;
            }
            case FID_PrepareVoiceOutput: {
                ::boost::shared_ptr< PrepareVoiceOutputError > payload (new PrepareVoiceOutputError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PrepareVoiceOutput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((PrepareVoiceOutputCallbackIF*) _callback)->onPrepareVoiceOutputError (proxy, payload);
                return true;
            }
            case FID_ReleaseData: {
                ::boost::shared_ptr< ReleaseDataError > payload (new ReleaseDataError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReleaseData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ReleaseDataCallbackIF*) _callback)->onReleaseDataError (proxy, payload);
                return true;
            }
            case FID_SetVoice: {
                ::boost::shared_ptr< SetVoiceError > payload (new SetVoiceError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetVoice", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetVoiceCallbackIF*) _callback)->onSetVoiceError (proxy, payload);
                return true;
            }
            case FID_AbortPrompt: {
                ::boost::shared_ptr< AbortPromptError > payload (new AbortPromptError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AbortPrompt", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AbortPromptCallbackIF*) _callback)->onAbortPromptError (proxy, payload);
                return true;
            }
            case FID_PausePrompt: {
                ::boost::shared_ptr< PausePromptError > payload (new PausePromptError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PausePrompt", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((PausePromptCallbackIF*) _callback)->onPausePromptError (proxy, payload);
                return true;
            }
            case FID_ContinuePrompt: {
                ::boost::shared_ptr< ContinuePromptError > payload (new ContinuePromptError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ContinuePrompt", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ContinuePromptCallbackIF*) _callback)->onContinuePromptError (proxy, payload);
                return true;
            }
            case FID_AbortPromptWithExtension: {
                ::boost::shared_ptr< AbortPromptWithExtensionError > payload (new AbortPromptWithExtensionError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AbortPromptWithExtension", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AbortPromptWithExtensionCallbackIF*) _callback)->onAbortPromptWithExtensionError (proxy, payload);
                return true;
            }
            case FID_PausePromptWithExtension: {
                ::boost::shared_ptr< PausePromptWithExtensionError > payload (new PausePromptWithExtensionError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PausePromptWithExtension", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((PausePromptWithExtensionCallbackIF*) _callback)->onPausePromptWithExtensionError (proxy, payload);
                return true;
            }
            case FID_ContinuePromptWithExtension: {
                ::boost::shared_ptr< ContinuePromptWithExtensionError > payload (new ContinuePromptWithExtensionError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ContinuePromptWithExtension", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ContinuePromptWithExtensionCallbackIF*) _callback)->onContinuePromptWithExtensionError (proxy, payload);
                return true;
            }
            case FID_RequestPhoneme: {
                ::boost::shared_ptr< RequestPhonemeError > payload (new RequestPhonemeError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestPhoneme", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((RequestPhonemeCallbackIF*) _callback)->onRequestPhonemeError (proxy, payload);
                return true;
            }
            case FID_LoadTuningFiles: {
                ::boost::shared_ptr< LoadTuningFilesError > payload (new LoadTuningFilesError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "LoadTuningFiles", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((LoadTuningFilesCallbackIF*) _callback)->onLoadTuningFilesError (proxy, payload);
                return true;
            }
            case FID_SetDefaultSpeechRate: {
                ::boost::shared_ptr< SetDefaultSpeechRateError > payload (new SetDefaultSpeechRateError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetDefaultSpeechRate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetDefaultSpeechRateCallbackIF*) _callback)->onSetDefaultSpeechRateError (proxy, payload);
                return true;
            }
            case FID_DoSynthesisForSpeak: {
                ::boost::shared_ptr< DoSynthesisForSpeakError > payload (new DoSynthesisForSpeakError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoSynthesisForSpeak", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DoSynthesisForSpeakCallbackIF*) _callback)->onDoSynthesisForSpeakError (proxy, payload);
                return true;
            }
            case FID_DoPrepareAudioOutput: {
                ::boost::shared_ptr< DoPrepareAudioOutputError > payload (new DoPrepareAudioOutputError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoPrepareAudioOutput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DoPrepareAudioOutputCallbackIF*) _callback)->onDoPrepareAudioOutputError (proxy, payload);
                return true;
            }
            case FID_DoAudioOutputSpeak: {
                ::boost::shared_ptr< DoAudioOutputSpeakError > payload (new DoAudioOutputSpeakError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoAudioOutputSpeak", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DoAudioOutputSpeakCallbackIF*) _callback)->onDoAudioOutputSpeakError (proxy, payload);
                return true;
            }
            case FID_DoUpRegToProperties: {
                ::boost::shared_ptr< DoUpRegToPropertiesError > payload (new DoUpRegToPropertiesError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoUpRegToProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DoUpRegToPropertiesCallbackIF*) _callback)->onDoUpRegToPropertiesError (proxy, payload);
                return true;
            }
            case FID_DoSynthesisForWrite: {
                ::boost::shared_ptr< DoSynthesisForWriteError > payload (new DoSynthesisForWriteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoSynthesisForWrite", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DoSynthesisForWriteCallbackIF*) _callback)->onDoSynthesisForWriteError (proxy, payload);
                return true;
            }
            case FID_DoAudioOutputWrite: {
                ::boost::shared_ptr< DoAudioOutputWriteError > payload (new DoAudioOutputWriteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoAudioOutputWrite", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DoAudioOutputWriteCallbackIF*) _callback)->onDoAudioOutputWriteError (proxy, payload);
                return true;
            }
            case FID_DoSynthesisForSpeakWithExtention: {
                ::boost::shared_ptr< DoSynthesisForSpeakWithExtentionError > payload (new DoSynthesisForSpeakWithExtentionError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoSynthesisForSpeakWithExtention", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DoSynthesisForSpeakWithExtentionCallbackIF*) _callback)->onDoSynthesisForSpeakWithExtentionError (proxy, payload);
                return true;
            }
            case FID_DoReleaseData: {
                ::boost::shared_ptr< DoReleaseDataError > payload (new DoReleaseDataError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoReleaseData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DoReleaseDataCallbackIF*) _callback)->onDoReleaseDataError (proxy, payload);
                return true;
            }
            case FID_DoReleaseAudioDevice: {
                ::boost::shared_ptr< DoReleaseAudioDeviceError > payload (new DoReleaseAudioDeviceError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoReleaseAudioDevice", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DoReleaseAudioDeviceCallbackIF*) _callback)->onDoReleaseAudioDeviceError (proxy, payload);
                return true;
            }
            case FID_DoRequestPhoneme: {
                ::boost::shared_ptr< DoRequestPhonemeError > payload (new DoRequestPhonemeError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoRequestPhoneme", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DoRequestPhonemeCallbackIF*) _callback)->onDoRequestPhonemeError (proxy, payload);
                return true;
            }
            case FID_DoAudioOutputSpeakWithExtension: {
                ::boost::shared_ptr< DoAudioOutputSpeakWithExtensionError > payload (new DoAudioOutputSpeakWithExtensionError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoAudioOutputSpeakWithExtension", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DoAudioOutputSpeakWithExtensionCallbackIF*) _callback)->onDoAudioOutputSpeakWithExtensionError (proxy, payload);
                return true;
            }
            case FID_Voice: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< VoiceError > payload (new VoiceError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Voice", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((VoiceCallbackIF*) _callback)->onVoiceError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AvailableVoices: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AvailableVoicesError > payload (new AvailableVoicesError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AvailableVoices", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AvailableVoicesCallbackIF*) _callback)->onAvailableVoicesError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_TTSVersionInfo: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< TTSVersionInfoError > payload (new TTSVersionInfoError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TTSVersionInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((TTSVersionInfoCallbackIF*) _callback)->onTTSVersionInfoError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_TTSStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< TTSStatusError > payload (new TTSStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TTSStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((TTSStatusCallbackIF*) _callback)->onTTSStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DownloadComplete: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< DownloadCompleteError > payload (new DownloadCompleteError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DownloadComplete", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DownloadCompleteCallbackIF*) _callback)->onDownloadCompleteError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_TTSPlaybackSpacing: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< TTSPlaybackSpacingError > payload (new TTSPlaybackSpacingError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TTSPlaybackSpacing", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((TTSPlaybackSpacingCallbackIF*) _callback)->onTTSPlaybackSpacingError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SDS_TTS_FIProxyCallback::_logger (SDS_TTS_FIProxy::_logger);

/*static*/ ::boost::shared_ptr< SDS_TTS_FIProxy > SDS_TTS_FIProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< SDS_TTS_FIProxy >  proxyNew(new SDS_TTS_FIProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< SDS_TTS_FIProxy > SDS_TTS_FIProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< SDS_TTS_FIProxy >  proxyNew(new SDS_TTS_FIProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< SDS_TTS_FIProxy > SDS_TTS_FIProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<SDS_TTS_FIProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< SDS_TTS_FIProxy >  proxyNew(new SDS_TTS_FIProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

SDS_TTS_FIProxy::SDS_TTS_FIProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

SDS_TTS_FIProxy::~SDS_TTS_FIProxy()
{
    LOG_INFO ("Entering ~SDS_TTS_FIProxy");
    sendRelUpRegAll ();
}

act_t SDS_TTS_FIProxy::sendSynthesizeSpeakStart(SynthesizeSpeakCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_TextStyleOption textStyle, const ::acr_fi_types::T_b8_AudioOutputLocation& audioOutputLocation, ::sds_tts_fi_types::T_e8_StatusInfoOption statusInfo, uint32 expDate, bool lastPackage) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SynthesizeSpeak);
        ::boost::shared_ptr< SynthesizeSpeakStart > payload (new SynthesizeSpeakStart());
        payload->setTextAndTags(textAndTags);
        payload->setTextStyle(textStyle);
        payload->setAudioOutputLocation(audioOutputLocation);
        payload->setStatusInfo(statusInfo);
        payload->setExpDate(expDate);
        payload->setLastPackage(lastPackage);
        CCA_MESSAGE(ccaMessage,header,SynthesizeSpeakStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SynthesizeSpeak", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SynthesizeSpeak);
        ::boost::shared_ptr< SynthesizeSpeakError > payload (new SynthesizeSpeakError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SynthesizeSpeakError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SynthesizeSpeak", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendSynthesizeWriteStart(SynthesizeWriteCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_TextStyleOption textStyle, ::sds_tts_fi_types::T_e8_BufferingOption buffering, uint32 expDate, bool lastPackage, const ::acr_fi_types::T_b8_AudioFormat& compression) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SynthesizeWrite);
        ::boost::shared_ptr< SynthesizeWriteStart > payload (new SynthesizeWriteStart());
        payload->setTextAndTags(textAndTags);
        payload->setTextStyle(textStyle);
        payload->setBuffering(buffering);
        payload->setExpDate(expDate);
        payload->setLastPackage(lastPackage);
        payload->setCompression(compression);
        CCA_MESSAGE(ccaMessage,header,SynthesizeWriteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SynthesizeWrite", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SynthesizeWrite);
        ::boost::shared_ptr< SynthesizeWriteError > payload (new SynthesizeWriteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SynthesizeWriteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SynthesizeWrite", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendSynthesizeSpeakWithExtensionStart(SynthesizeSpeakWithExtensionCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_AudioSourceID textStyle, const ::sds_sds2hmi_common_types::T_SDSLanguageID& languageID, const ::acr_fi_types::T_b8_AudioOutputLocation& audioOutputLocation, ::sds_tts_fi_types::T_e8_StatusInfoOption statusInfo, uint32 expDate, bool lastPackage, uint8 index, ::sds_tts_fi_types::T_e8SequenceCategory speechSequence) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SynthesizeSpeakWithExtension);
        ::boost::shared_ptr< SynthesizeSpeakWithExtensionStart > payload (new SynthesizeSpeakWithExtensionStart());
        payload->setTextAndTags(textAndTags);
        payload->setTextStyle(textStyle);
        payload->setLanguageID(languageID);
        payload->setAudioOutputLocation(audioOutputLocation);
        payload->setStatusInfo(statusInfo);
        payload->setExpDate(expDate);
        payload->setLastPackage(lastPackage);
        payload->setIndex(index);
        payload->setSpeechSequence(speechSequence);
        CCA_MESSAGE(ccaMessage,header,SynthesizeSpeakWithExtensionStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SynthesizeSpeakWithExtension", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SynthesizeSpeakWithExtension);
        ::boost::shared_ptr< SynthesizeSpeakWithExtensionError > payload (new SynthesizeSpeakWithExtensionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SynthesizeSpeakWithExtensionError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SynthesizeSpeakWithExtension", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendPrepareVoiceOutputStart(PrepareVoiceOutputCallbackIF& cb, const ::std::string& device) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_PrepareVoiceOutput);
        ::boost::shared_ptr< PrepareVoiceOutputStart > payload (new PrepareVoiceOutputStart());
        payload->setDevice(device);
        CCA_MESSAGE(ccaMessage,header,PrepareVoiceOutputStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "PrepareVoiceOutput", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PrepareVoiceOutput);
        ::boost::shared_ptr< PrepareVoiceOutputError > payload (new PrepareVoiceOutputError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PrepareVoiceOutputError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "PrepareVoiceOutput", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendReleaseDataStart(ReleaseDataCallbackIF& cb, ::sds_tts_fi_types::T_e8_ReleaseTypeTTS releaseType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ReleaseData);
        ::boost::shared_ptr< ReleaseDataStart > payload (new ReleaseDataStart());
        payload->setReleaseType(releaseType);
        CCA_MESSAGE(ccaMessage,header,ReleaseDataStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ReleaseData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ReleaseData);
        ::boost::shared_ptr< ReleaseDataError > payload (new ReleaseDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ReleaseDataError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ReleaseData", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendSetVoiceStart(SetVoiceCallbackIF& cb, const ::sds_speechdp_fi_types::T_VoiceType& tTSVoice) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetVoice);
        ::boost::shared_ptr< SetVoiceStart > payload (new SetVoiceStart());
        payload->setTTSVoice(tTSVoice);
        CCA_MESSAGE(ccaMessage,header,SetVoiceStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetVoice", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetVoice);
        ::boost::shared_ptr< SetVoiceError > payload (new SetVoiceError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetVoiceError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetVoice", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendAbortPromptStart(AbortPromptCallbackIF& cb, ::sds_tts_fi_types::T_e8_PromptAbortOption abortPromptOption) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AbortPrompt);
        ::boost::shared_ptr< AbortPromptStart > payload (new AbortPromptStart());
        payload->setAbortPromptOption(abortPromptOption);
        CCA_MESSAGE(ccaMessage,header,AbortPromptStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AbortPrompt", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AbortPrompt);
        ::boost::shared_ptr< AbortPromptError > payload (new AbortPromptError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AbortPromptError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AbortPrompt", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendPausePromptStart(PausePromptCallbackIF& cb, ::sds_tts_fi_types::T_e8_PromptAbortOption pausePromptOption) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_PausePrompt);
        ::boost::shared_ptr< PausePromptStart > payload (new PausePromptStart());
        payload->setPausePromptOption(pausePromptOption);
        CCA_MESSAGE(ccaMessage,header,PausePromptStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "PausePrompt", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PausePrompt);
        ::boost::shared_ptr< PausePromptError > payload (new PausePromptError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PausePromptError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "PausePrompt", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendContinuePromptStart(ContinuePromptCallbackIF& cb, uint8 dummy) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ContinuePrompt);
        ::boost::shared_ptr< ContinuePromptStart > payload (new ContinuePromptStart());
        payload->setDummy(dummy);
        CCA_MESSAGE(ccaMessage,header,ContinuePromptStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ContinuePrompt", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ContinuePrompt);
        ::boost::shared_ptr< ContinuePromptError > payload (new ContinuePromptError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ContinuePromptError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ContinuePrompt", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendAbortPromptWithExtensionStart(AbortPromptWithExtensionCallbackIF& cb, ::sds_tts_fi_types::T_e8_PromptAbortOption abortPromptOption) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AbortPromptWithExtension);
        ::boost::shared_ptr< AbortPromptWithExtensionStart > payload (new AbortPromptWithExtensionStart());
        payload->setAbortPromptOption(abortPromptOption);
        CCA_MESSAGE(ccaMessage,header,AbortPromptWithExtensionStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AbortPromptWithExtension", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AbortPromptWithExtension);
        ::boost::shared_ptr< AbortPromptWithExtensionError > payload (new AbortPromptWithExtensionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AbortPromptWithExtensionError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AbortPromptWithExtension", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendPausePromptWithExtensionStart(PausePromptWithExtensionCallbackIF& cb, ::sds_tts_fi_types::T_e8_PromptAbortOption pausePromptOption) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_PausePromptWithExtension);
        ::boost::shared_ptr< PausePromptWithExtensionStart > payload (new PausePromptWithExtensionStart());
        payload->setPausePromptOption(pausePromptOption);
        CCA_MESSAGE(ccaMessage,header,PausePromptWithExtensionStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "PausePromptWithExtension", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PausePromptWithExtension);
        ::boost::shared_ptr< PausePromptWithExtensionError > payload (new PausePromptWithExtensionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PausePromptWithExtensionError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "PausePromptWithExtension", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendContinuePromptWithExtensionStart(ContinuePromptWithExtensionCallbackIF& cb, uint8 dummy) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ContinuePromptWithExtension);
        ::boost::shared_ptr< ContinuePromptWithExtensionStart > payload (new ContinuePromptWithExtensionStart());
        payload->setDummy(dummy);
        CCA_MESSAGE(ccaMessage,header,ContinuePromptWithExtensionStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ContinuePromptWithExtension", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ContinuePromptWithExtension);
        ::boost::shared_ptr< ContinuePromptWithExtensionError > payload (new ContinuePromptWithExtensionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ContinuePromptWithExtensionError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ContinuePromptWithExtension", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendRequestPhonemeStart(RequestPhonemeCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_TextStyleOption textStyle) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_RequestPhoneme);
        ::boost::shared_ptr< RequestPhonemeStart > payload (new RequestPhonemeStart());
        payload->setTextAndTags(textAndTags);
        payload->setTextStyle(textStyle);
        CCA_MESSAGE(ccaMessage,header,RequestPhonemeStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "RequestPhoneme", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RequestPhoneme);
        ::boost::shared_ptr< RequestPhonemeError > payload (new RequestPhonemeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RequestPhonemeError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "RequestPhoneme", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendLoadTuningFilesStart(LoadTuningFilesCallbackIF& cb, const ::std::vector< ::sds_tts_fi_types::T_TTSTuningFile >& tTSTunFiles, ::sds_tts_fi_types::T_e8_TTSDomain tTSDomain, const ::std::string& tTSVersion) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_LoadTuningFiles);
        ::boost::shared_ptr< LoadTuningFilesStart > payload (new LoadTuningFilesStart());
        payload->setTTSTunFiles(tTSTunFiles);
        payload->setTTSDomain(tTSDomain);
        payload->setTTSVersion(tTSVersion);
        CCA_MESSAGE(ccaMessage,header,LoadTuningFilesStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "LoadTuningFiles", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_LoadTuningFiles);
        ::boost::shared_ptr< LoadTuningFilesError > payload (new LoadTuningFilesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LoadTuningFilesError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "LoadTuningFiles", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendSetDefaultSpeechRateStart(SetDefaultSpeechRateCallbackIF& cb, uint16 rate) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetDefaultSpeechRate);
        ::boost::shared_ptr< SetDefaultSpeechRateStart > payload (new SetDefaultSpeechRateStart());
        payload->setRate(rate);
        CCA_MESSAGE(ccaMessage,header,SetDefaultSpeechRateStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetDefaultSpeechRate", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetDefaultSpeechRate);
        ::boost::shared_ptr< SetDefaultSpeechRateError > payload (new SetDefaultSpeechRateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetDefaultSpeechRateError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetDefaultSpeechRate", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendDoSynthesisForSpeakStart(DoSynthesisForSpeakCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_TextStyleOption textStyle, ::sds_tts_fi_types::T_e8_StatusInfoOption statusInfo, bool lastPackage) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DoSynthesisForSpeak);
        ::boost::shared_ptr< DoSynthesisForSpeakStart > payload (new DoSynthesisForSpeakStart());
        payload->setTextAndTags(textAndTags);
        payload->setTextStyle(textStyle);
        payload->setStatusInfo(statusInfo);
        payload->setLastPackage(lastPackage);
        CCA_MESSAGE(ccaMessage,header,DoSynthesisForSpeakStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DoSynthesisForSpeak", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoSynthesisForSpeak);
        ::boost::shared_ptr< DoSynthesisForSpeakError > payload (new DoSynthesisForSpeakError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoSynthesisForSpeakError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DoSynthesisForSpeak", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendDoPrepareAudioOutputStart(DoPrepareAudioOutputCallbackIF& cb, const ::std::string& deviceName) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DoPrepareAudioOutput);
        ::boost::shared_ptr< DoPrepareAudioOutputStart > payload (new DoPrepareAudioOutputStart());
        payload->setDeviceName(deviceName);
        CCA_MESSAGE(ccaMessage,header,DoPrepareAudioOutputStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DoPrepareAudioOutput", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoPrepareAudioOutput);
        ::boost::shared_ptr< DoPrepareAudioOutputError > payload (new DoPrepareAudioOutputError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoPrepareAudioOutputError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DoPrepareAudioOutput", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendDoAudioOutputSpeakStart(DoAudioOutputSpeakCallbackIF& cb, ::sds_tts_fi_types::T_e8_StatusInfoOption statusInfo, const ::acr_fi_types::T_b8_AudioOutputLocation& audioOutputLocation) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DoAudioOutputSpeak);
        ::boost::shared_ptr< DoAudioOutputSpeakStart > payload (new DoAudioOutputSpeakStart());
        payload->setStatusInfo(statusInfo);
        payload->setAudioOutputLocation(audioOutputLocation);
        CCA_MESSAGE(ccaMessage,header,DoAudioOutputSpeakStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DoAudioOutputSpeak", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoAudioOutputSpeak);
        ::boost::shared_ptr< DoAudioOutputSpeakError > payload (new DoAudioOutputSpeakError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoAudioOutputSpeakError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DoAudioOutputSpeak", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendDoUpRegToPropertiesStart(DoUpRegToPropertiesCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DoUpRegToProperties);
        ::boost::shared_ptr< DoUpRegToPropertiesStart > payload (new DoUpRegToPropertiesStart());
        CCA_MESSAGE(ccaMessage,header,DoUpRegToPropertiesStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DoUpRegToProperties", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoUpRegToProperties);
        ::boost::shared_ptr< DoUpRegToPropertiesError > payload (new DoUpRegToPropertiesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoUpRegToPropertiesError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DoUpRegToProperties", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendDoSynthesisForWriteStart(DoSynthesisForWriteCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_TextStyleOption textStyle, bool lastPackage) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DoSynthesisForWrite);
        ::boost::shared_ptr< DoSynthesisForWriteStart > payload (new DoSynthesisForWriteStart());
        payload->setTextAndTags(textAndTags);
        payload->setTextStyle(textStyle);
        payload->setLastPackage(lastPackage);
        CCA_MESSAGE(ccaMessage,header,DoSynthesisForWriteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DoSynthesisForWrite", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoSynthesisForWrite);
        ::boost::shared_ptr< DoSynthesisForWriteError > payload (new DoSynthesisForWriteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoSynthesisForWriteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DoSynthesisForWrite", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendDoAudioOutputWriteStart(DoAudioOutputWriteCallbackIF& cb, ::sds_tts_fi_types::T_e8_BufferingOption buffering, const ::acr_fi_types::T_b8_AudioFormat& compression) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DoAudioOutputWrite);
        ::boost::shared_ptr< DoAudioOutputWriteStart > payload (new DoAudioOutputWriteStart());
        payload->setBuffering(buffering);
        payload->setCompression(compression);
        CCA_MESSAGE(ccaMessage,header,DoAudioOutputWriteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DoAudioOutputWrite", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoAudioOutputWrite);
        ::boost::shared_ptr< DoAudioOutputWriteError > payload (new DoAudioOutputWriteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoAudioOutputWriteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DoAudioOutputWrite", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendDoSynthesisForSpeakWithExtentionStart(DoSynthesisForSpeakWithExtentionCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_AudioSourceID textStyle, ::sds_tts_fi_types::T_e8_StatusInfoOption statusInfo, bool lastPackage) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DoSynthesisForSpeakWithExtention);
        ::boost::shared_ptr< DoSynthesisForSpeakWithExtentionStart > payload (new DoSynthesisForSpeakWithExtentionStart());
        payload->setTextAndTags(textAndTags);
        payload->setTextStyle(textStyle);
        payload->setStatusInfo(statusInfo);
        payload->setLastPackage(lastPackage);
        CCA_MESSAGE(ccaMessage,header,DoSynthesisForSpeakWithExtentionStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DoSynthesisForSpeakWithExtention", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoSynthesisForSpeakWithExtention);
        ::boost::shared_ptr< DoSynthesisForSpeakWithExtentionError > payload (new DoSynthesisForSpeakWithExtentionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoSynthesisForSpeakWithExtentionError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DoSynthesisForSpeakWithExtention", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendDoReleaseDataStart(DoReleaseDataCallbackIF& cb, ::sds_tts_fi_types::T_e8_ReleaseTypeTTS releaseType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DoReleaseData);
        ::boost::shared_ptr< DoReleaseDataStart > payload (new DoReleaseDataStart());
        payload->setReleaseType(releaseType);
        CCA_MESSAGE(ccaMessage,header,DoReleaseDataStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DoReleaseData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoReleaseData);
        ::boost::shared_ptr< DoReleaseDataError > payload (new DoReleaseDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoReleaseDataError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DoReleaseData", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendDoReleaseAudioDeviceStart(DoReleaseAudioDeviceCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DoReleaseAudioDevice);
        ::boost::shared_ptr< DoReleaseAudioDeviceStart > payload (new DoReleaseAudioDeviceStart());
        CCA_MESSAGE(ccaMessage,header,DoReleaseAudioDeviceStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DoReleaseAudioDevice", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoReleaseAudioDevice);
        ::boost::shared_ptr< DoReleaseAudioDeviceError > payload (new DoReleaseAudioDeviceError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoReleaseAudioDeviceError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DoReleaseAudioDevice", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendDoRequestPhonemeStart(DoRequestPhonemeCallbackIF& cb, const ::std::string& textAndTags, ::sds_tts_fi_types::T_e8_TextStyleOption textStyle) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DoRequestPhoneme);
        ::boost::shared_ptr< DoRequestPhonemeStart > payload (new DoRequestPhonemeStart());
        payload->setTextAndTags(textAndTags);
        payload->setTextStyle(textStyle);
        CCA_MESSAGE(ccaMessage,header,DoRequestPhonemeStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DoRequestPhoneme", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoRequestPhoneme);
        ::boost::shared_ptr< DoRequestPhonemeError > payload (new DoRequestPhonemeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoRequestPhonemeError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DoRequestPhoneme", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendDoAudioOutputSpeakWithExtensionStart(DoAudioOutputSpeakWithExtensionCallbackIF& cb, ::sds_tts_fi_types::T_e8_StatusInfoOption statusInfo, const ::acr_fi_types::T_b8_AudioOutputLocation& audioOutputLocation) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DoAudioOutputSpeakWithExtension);
        ::boost::shared_ptr< DoAudioOutputSpeakWithExtensionStart > payload (new DoAudioOutputSpeakWithExtensionStart());
        payload->setStatusInfo(statusInfo);
        payload->setAudioOutputLocation(audioOutputLocation);
        CCA_MESSAGE(ccaMessage,header,DoAudioOutputSpeakWithExtensionStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DoAudioOutputSpeakWithExtension", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoAudioOutputSpeakWithExtension);
        ::boost::shared_ptr< DoAudioOutputSpeakWithExtensionError > payload (new DoAudioOutputSpeakWithExtensionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoAudioOutputSpeakWithExtensionError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DoAudioOutputSpeakWithExtension", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendVoiceUpReg(VoiceCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Voice);
        ::boost::shared_ptr< VoiceUpReg > payload (new VoiceUpReg());
        CCA_MESSAGE(ccaMessage,header,VoiceUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< VoiceRelUpReg > payloadRelUpRegHeap (new VoiceRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Voice, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SDS_TTS_FI::VoiceRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Voice, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Voice", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Voice", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasVoice()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Voice, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< VoiceStatus > payloadLoopback (new VoiceStatus(getVoice()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,VoiceStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Voice);
        ::boost::shared_ptr< VoiceError > payload (new VoiceError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VoiceError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Voice", &cb);
    }
}

bool SDS_TTS_FIProxy::sendVoiceRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Voice,"Voice");
}

void SDS_TTS_FIProxy::sendVoiceRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Voice);
}

const VoiceStatus& SDS_TTS_FIProxy::getVoice() const {
    return _voice.get();
}

bool SDS_TTS_FIProxy::hasVoice() const {
    return _voice.hasValue();
}

act_t SDS_TTS_FIProxy::sendVoiceGet(VoiceCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Voice);
        ::boost::shared_ptr< VoiceGet > payload (new VoiceGet());
        CCA_MESSAGE(ccaMessage,header,VoiceGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Voice", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Voice);
        ::boost::shared_ptr< VoiceError > payload (new VoiceError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VoiceError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Voice", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendAvailableVoicesUpReg(AvailableVoicesCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AvailableVoices);
        ::boost::shared_ptr< AvailableVoicesUpReg > payload (new AvailableVoicesUpReg());
        CCA_MESSAGE(ccaMessage,header,AvailableVoicesUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AvailableVoicesRelUpReg > payloadRelUpRegHeap (new AvailableVoicesRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AvailableVoices, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SDS_TTS_FI::AvailableVoicesRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AvailableVoices, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AvailableVoices", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AvailableVoices", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAvailableVoices()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AvailableVoices, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AvailableVoicesStatus > payloadLoopback (new AvailableVoicesStatus(getAvailableVoices()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AvailableVoicesStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AvailableVoices);
        ::boost::shared_ptr< AvailableVoicesError > payload (new AvailableVoicesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AvailableVoicesError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AvailableVoices", &cb);
    }
}

bool SDS_TTS_FIProxy::sendAvailableVoicesRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AvailableVoices,"AvailableVoices");
}

void SDS_TTS_FIProxy::sendAvailableVoicesRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AvailableVoices);
}

const AvailableVoicesStatus& SDS_TTS_FIProxy::getAvailableVoices() const {
    return _availableVoices.get();
}

bool SDS_TTS_FIProxy::hasAvailableVoices() const {
    return _availableVoices.hasValue();
}

act_t SDS_TTS_FIProxy::sendAvailableVoicesGet(AvailableVoicesCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AvailableVoices);
        ::boost::shared_ptr< AvailableVoicesGet > payload (new AvailableVoicesGet());
        CCA_MESSAGE(ccaMessage,header,AvailableVoicesGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AvailableVoices", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AvailableVoices);
        ::boost::shared_ptr< AvailableVoicesError > payload (new AvailableVoicesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AvailableVoicesError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AvailableVoices", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendTTSVersionInfoUpReg(TTSVersionInfoCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_TTSVersionInfo);
        ::boost::shared_ptr< TTSVersionInfoUpReg > payload (new TTSVersionInfoUpReg());
        CCA_MESSAGE(ccaMessage,header,TTSVersionInfoUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< TTSVersionInfoRelUpReg > payloadRelUpRegHeap (new TTSVersionInfoRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_TTSVersionInfo, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SDS_TTS_FI::TTSVersionInfoRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_TTSVersionInfo, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "TTSVersionInfo", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "TTSVersionInfo", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasTTSVersionInfo()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_TTSVersionInfo, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< TTSVersionInfoStatus > payloadLoopback (new TTSVersionInfoStatus(getTTSVersionInfo()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,TTSVersionInfoStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TTSVersionInfo);
        ::boost::shared_ptr< TTSVersionInfoError > payload (new TTSVersionInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TTSVersionInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "TTSVersionInfo", &cb);
    }
}

bool SDS_TTS_FIProxy::sendTTSVersionInfoRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_TTSVersionInfo,"TTSVersionInfo");
}

void SDS_TTS_FIProxy::sendTTSVersionInfoRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_TTSVersionInfo);
}

const TTSVersionInfoStatus& SDS_TTS_FIProxy::getTTSVersionInfo() const {
    return _tTSVersionInfo.get();
}

bool SDS_TTS_FIProxy::hasTTSVersionInfo() const {
    return _tTSVersionInfo.hasValue();
}

act_t SDS_TTS_FIProxy::sendTTSVersionInfoGet(TTSVersionInfoCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_TTSVersionInfo);
        ::boost::shared_ptr< TTSVersionInfoGet > payload (new TTSVersionInfoGet());
        CCA_MESSAGE(ccaMessage,header,TTSVersionInfoGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "TTSVersionInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TTSVersionInfo);
        ::boost::shared_ptr< TTSVersionInfoError > payload (new TTSVersionInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TTSVersionInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "TTSVersionInfo", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendTTSStatusUpReg(TTSStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_TTSStatus);
        ::boost::shared_ptr< TTSStatusUpReg > payload (new TTSStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,TTSStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< TTSStatusRelUpReg > payloadRelUpRegHeap (new TTSStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_TTSStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SDS_TTS_FI::TTSStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_TTSStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "TTSStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "TTSStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasTTSStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_TTSStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< TTSStatusStatus > payloadLoopback (new TTSStatusStatus(getTTSStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,TTSStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TTSStatus);
        ::boost::shared_ptr< TTSStatusError > payload (new TTSStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TTSStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "TTSStatus", &cb);
    }
}

bool SDS_TTS_FIProxy::sendTTSStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_TTSStatus,"TTSStatus");
}

void SDS_TTS_FIProxy::sendTTSStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_TTSStatus);
}

const TTSStatusStatus& SDS_TTS_FIProxy::getTTSStatus() const {
    return _tTSStatus.get();
}

bool SDS_TTS_FIProxy::hasTTSStatus() const {
    return _tTSStatus.hasValue();
}

act_t SDS_TTS_FIProxy::sendTTSStatusGet(TTSStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_TTSStatus);
        ::boost::shared_ptr< TTSStatusGet > payload (new TTSStatusGet());
        CCA_MESSAGE(ccaMessage,header,TTSStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "TTSStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TTSStatus);
        ::boost::shared_ptr< TTSStatusError > payload (new TTSStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TTSStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "TTSStatus", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendDownloadCompleteUpReg(DownloadCompleteCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DownloadComplete);
        ::boost::shared_ptr< DownloadCompleteUpReg > payload (new DownloadCompleteUpReg());
        CCA_MESSAGE(ccaMessage,header,DownloadCompleteUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DownloadCompleteRelUpReg > payloadRelUpRegHeap (new DownloadCompleteRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DownloadComplete, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SDS_TTS_FI::DownloadCompleteRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DownloadComplete, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DownloadComplete", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DownloadComplete", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDownloadComplete()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DownloadComplete, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DownloadCompleteStatus > payloadLoopback (new DownloadCompleteStatus(getDownloadComplete()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DownloadCompleteStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DownloadComplete);
        ::boost::shared_ptr< DownloadCompleteError > payload (new DownloadCompleteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DownloadCompleteError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DownloadComplete", &cb);
    }
}

bool SDS_TTS_FIProxy::sendDownloadCompleteRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DownloadComplete,"DownloadComplete");
}

void SDS_TTS_FIProxy::sendDownloadCompleteRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DownloadComplete);
}

const DownloadCompleteStatus& SDS_TTS_FIProxy::getDownloadComplete() const {
    return _downloadComplete.get();
}

bool SDS_TTS_FIProxy::hasDownloadComplete() const {
    return _downloadComplete.hasValue();
}

act_t SDS_TTS_FIProxy::sendDownloadCompleteGet(DownloadCompleteCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DownloadComplete);
        ::boost::shared_ptr< DownloadCompleteGet > payload (new DownloadCompleteGet());
        CCA_MESSAGE(ccaMessage,header,DownloadCompleteGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DownloadComplete", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DownloadComplete);
        ::boost::shared_ptr< DownloadCompleteError > payload (new DownloadCompleteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DownloadCompleteError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DownloadComplete", &cb);
    }
}

act_t SDS_TTS_FIProxy::sendTTSPlaybackSpacingUpReg(TTSPlaybackSpacingCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_TTSPlaybackSpacing);
        ::boost::shared_ptr< TTSPlaybackSpacingUpReg > payload (new TTSPlaybackSpacingUpReg());
        CCA_MESSAGE(ccaMessage,header,TTSPlaybackSpacingUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< TTSPlaybackSpacingRelUpReg > payloadRelUpRegHeap (new TTSPlaybackSpacingRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_TTSPlaybackSpacing, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SDS_TTS_FI::TTSPlaybackSpacingRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_TTSPlaybackSpacing, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "TTSPlaybackSpacing", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "TTSPlaybackSpacing", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasTTSPlaybackSpacing()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_TTSPlaybackSpacing, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< TTSPlaybackSpacingStatus > payloadLoopback (new TTSPlaybackSpacingStatus(getTTSPlaybackSpacing()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,TTSPlaybackSpacingStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TTSPlaybackSpacing);
        ::boost::shared_ptr< TTSPlaybackSpacingError > payload (new TTSPlaybackSpacingError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TTSPlaybackSpacingError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "TTSPlaybackSpacing", &cb);
    }
}

bool SDS_TTS_FIProxy::sendTTSPlaybackSpacingRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_TTSPlaybackSpacing,"TTSPlaybackSpacing");
}

void SDS_TTS_FIProxy::sendTTSPlaybackSpacingRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_TTSPlaybackSpacing);
}

const TTSPlaybackSpacingStatus& SDS_TTS_FIProxy::getTTSPlaybackSpacing() const {
    return _tTSPlaybackSpacing.get();
}

bool SDS_TTS_FIProxy::hasTTSPlaybackSpacing() const {
    return _tTSPlaybackSpacing.hasValue();
}

act_t SDS_TTS_FIProxy::sendTTSPlaybackSpacingSet(TTSPlaybackSpacingCallbackIF& cb, uint8 playbackSpacing) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_TTSPlaybackSpacing);
        ::boost::shared_ptr< TTSPlaybackSpacingSet > payload (new TTSPlaybackSpacingSet());
        payload->setPlaybackSpacing(playbackSpacing);
        CCA_MESSAGE(ccaMessage,header,TTSPlaybackSpacingSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "TTSPlaybackSpacing", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TTSPlaybackSpacing);
        ::boost::shared_ptr< TTSPlaybackSpacingError > payload (new TTSPlaybackSpacingError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TTSPlaybackSpacingError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "TTSPlaybackSpacing", &cb);
    }
}


void SDS_TTS_FIProxy::clearAllProperties ()
{
    _voice = ::asf::core::nullable<VoiceStatus>();
    _availableVoices = ::asf::core::nullable<AvailableVoicesStatus>();
    _tTSVersionInfo = ::asf::core::nullable<TTSVersionInfoStatus>();
    _tTSStatus = ::asf::core::nullable<TTSStatusStatus>();
    _downloadComplete = ::asf::core::nullable<DownloadCompleteStatus>();
    _tTSPlaybackSpacing = ::asf::core::nullable<TTSPlaybackSpacingStatus>();
}

void SDS_TTS_FIProxy::sendRelUpRegAll()
{
    sendVoiceRelUpRegAll();
    sendAvailableVoicesRelUpRegAll();
    sendTTSVersionInfoRelUpRegAll();
    sendTTSStatusRelUpRegAll();
    sendDownloadCompleteRelUpRegAll();
    sendTTSPlaybackSpacingRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > SDS_TTS_FIProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new SDS_TTS_FIProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace SDS_TTS_FI
