/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "SDS_TTS_FI.h"
#include "SDS_TTS_FIConst.h"
#include "SDS_TTS_FIJson.h"
#include "acr_fi_typesJsonPrivate.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/stream/json.h"
#include "sds_sds2hmi_common_typesJsonPrivate.h"
#include "sds_speechdp_fi_types.h"
#include "sds_speechdp_fi_typesJsonPrivate.h"
#include "sds_tts_fi_types.h"
#include "sds_tts_fi_typesConst.h"
#include "sds_tts_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "SynthesizeSpeakStart"

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTextAndTags()) {
        yajl_gen_string(g, (const unsigned char*)  "TextAndTags" , 11);
        const char *s = value.getTextAndTags().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTextStyle()) {
        yajl_gen_string(g, (const unsigned char*)  "TextStyle" , 9);
        const char* s = ::sds_tts_fi_types::T_e8_TextStyleOption_Name(value.getTextStyle());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTextStyle());
    }
    if (!isSparse || value.hasAudioOutputLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "AudioOutputLocation" , 19);
        serializeJson(value.getAudioOutputLocation(), g, options);
    }
    if (!isSparse || value.hasStatusInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "StatusInfo" , 10);
        const char* s = ::sds_tts_fi_types::T_e8_StatusInfoOption_Name(value.getStatusInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatusInfo());
    }
    if (!isSparse || value.hasExpDate()) {
        yajl_gen_string(g, (const unsigned char*)  "ExpDate" , 7);
        yajl_gen_integer(g, (long long)value.getExpDate());
    }
    if (!isSparse || value.hasLastPackage()) {
        yajl_gen_string(g, (const unsigned char*)  "LastPackage" , 11);
        yajl_gen_bool(g, (bool)value.getLastPackage());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SynthesizeSpeakResultFirst"

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakResultFirst& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "JobProgress" , 11);
        serializeJson(value.getJobProgress(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakResultFirst& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SynthesizeSpeakResultMiddle"

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakResultMiddle& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "JobProgress" , 11);
        serializeJson(value.getJobProgress(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakResultMiddle& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SynthesizeSpeakResultLast"

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakResultLast& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "JobProgress" , 11);
        serializeJson(value.getJobProgress(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakResultLast& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SynthesizeSpeakError"

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::SynthesizeSpeakError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::SynthesizeSpeakErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::SynthesizeSpeakError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::SynthesizeSpeakError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SynthesizeWriteStart"

void serializeJson (const ::SDS_TTS_FI::SynthesizeWriteStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTextAndTags()) {
        yajl_gen_string(g, (const unsigned char*)  "TextAndTags" , 11);
        const char *s = value.getTextAndTags().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTextStyle()) {
        yajl_gen_string(g, (const unsigned char*)  "TextStyle" , 9);
        const char* s = ::sds_tts_fi_types::T_e8_TextStyleOption_Name(value.getTextStyle());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTextStyle());
    }
    if (!isSparse || value.hasBuffering()) {
        yajl_gen_string(g, (const unsigned char*)  "Buffering" , 9);
        const char* s = ::sds_tts_fi_types::T_e8_BufferingOption_Name(value.getBuffering());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getBuffering());
    }
    if (!isSparse || value.hasExpDate()) {
        yajl_gen_string(g, (const unsigned char*)  "ExpDate" , 7);
        yajl_gen_integer(g, (long long)value.getExpDate());
    }
    if (!isSparse || value.hasLastPackage()) {
        yajl_gen_string(g, (const unsigned char*)  "LastPackage" , 11);
        yajl_gen_bool(g, (bool)value.getLastPackage());
    }
    if (!isSparse || value.hasCompression()) {
        yajl_gen_string(g, (const unsigned char*)  "Compression" , 11);
        serializeJson(value.getCompression(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::SynthesizeWriteStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SynthesizeWriteResultFirst"

void serializeJson (const ::SDS_TTS_FI::SynthesizeWriteResultFirst& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBufferingProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "BufferingProgress" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& o1 = value.getBufferingProgress();
        {
            ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::SynthesizeWriteResultFirst& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SynthesizeWriteResultMiddle"

void serializeJson (const ::SDS_TTS_FI::SynthesizeWriteResultMiddle& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBufferingProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "BufferingProgress" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& o3 = value.getBufferingProgress();
        {
            ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::SynthesizeWriteResultMiddle& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SynthesizeWriteResultLast"

void serializeJson (const ::SDS_TTS_FI::SynthesizeWriteResultLast& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBufferingProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "BufferingProgress" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& o5 = value.getBufferingProgress();
        {
            ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::SynthesizeWriteResultLast& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SynthesizeWriteError"

void serializeJson (const ::SDS_TTS_FI::SynthesizeWriteError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::SynthesizeWriteError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::SynthesizeWriteErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::SynthesizeWriteError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::SynthesizeWriteError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SynthesizeSpeakWithExtensionStart"

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakWithExtensionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTextAndTags()) {
        yajl_gen_string(g, (const unsigned char*)  "TextAndTags" , 11);
        const char *s = value.getTextAndTags().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTextStyle()) {
        yajl_gen_string(g, (const unsigned char*)  "TextStyle" , 9);
        const char* s = ::sds_tts_fi_types::T_e8_AudioSourceID_Name(value.getTextStyle());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTextStyle());
    }
    if (!isSparse || value.hasLanguageID()) {
        yajl_gen_string(g, (const unsigned char*)  "LanguageID" , 10);
        serializeJson(value.getLanguageID(), g, options);
    }
    if (!isSparse || value.hasAudioOutputLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "AudioOutputLocation" , 19);
        serializeJson(value.getAudioOutputLocation(), g, options);
    }
    if (!isSparse || value.hasStatusInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "StatusInfo" , 10);
        const char* s = ::sds_tts_fi_types::T_e8_StatusInfoOption_Name(value.getStatusInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatusInfo());
    }
    if (!isSparse || value.hasExpDate()) {
        yajl_gen_string(g, (const unsigned char*)  "ExpDate" , 7);
        yajl_gen_integer(g, (long long)value.getExpDate());
    }
    if (!isSparse || value.hasLastPackage()) {
        yajl_gen_string(g, (const unsigned char*)  "LastPackage" , 11);
        yajl_gen_bool(g, (bool)value.getLastPackage());
    }
    if (!isSparse || value.hasIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "Index" , 5);
        yajl_gen_integer(g, (long long)value.getIndex());
    }
    if (!isSparse || value.hasSpeechSequence()) {
        yajl_gen_string(g, (const unsigned char*)  "SpeechSequence" , 14);
        const char* s = ::sds_tts_fi_types::T_e8SequenceCategory_Name(value.getSpeechSequence());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSpeechSequence());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakWithExtensionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SynthesizeSpeakWithExtensionResultFirst"

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakWithExtensionResultFirst& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "JobProgress" , 11);
        serializeJson(value.getJobProgress(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakWithExtensionResultFirst& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SynthesizeSpeakWithExtensionResultMiddle"

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakWithExtensionResultMiddle& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "JobProgress" , 11);
        serializeJson(value.getJobProgress(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakWithExtensionResultMiddle& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SynthesizeSpeakWithExtensionResultLast"

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakWithExtensionResultLast& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "JobProgress" , 11);
        serializeJson(value.getJobProgress(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakWithExtensionResultLast& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SynthesizeSpeakWithExtensionError"

void serializeJson (const ::SDS_TTS_FI::SynthesizeSpeakWithExtensionError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::SynthesizeSpeakWithExtensionError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::SynthesizeSpeakWithExtensionErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::SynthesizeSpeakWithExtensionError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::SynthesizeSpeakWithExtensionError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PrepareVoiceOutputStart"

void serializeJson (const ::SDS_TTS_FI::PrepareVoiceOutputStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDevice()) {
        yajl_gen_string(g, (const unsigned char*)  "Device" , 6);
        const char *s = value.getDevice().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::PrepareVoiceOutputStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PrepareVoiceOutputError"

void serializeJson (const ::SDS_TTS_FI::PrepareVoiceOutputError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::PrepareVoiceOutputError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::PrepareVoiceOutputErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::PrepareVoiceOutputError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::PrepareVoiceOutputError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReleaseDataStart"

void serializeJson (const ::SDS_TTS_FI::ReleaseDataStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasReleaseType()) {
        yajl_gen_string(g, (const unsigned char*)  "ReleaseType" , 11);
        const char* s = ::sds_tts_fi_types::T_e8_ReleaseTypeTTS_Name(value.getReleaseType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getReleaseType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::ReleaseDataStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReleaseDataError"

void serializeJson (const ::SDS_TTS_FI::ReleaseDataError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::ReleaseDataError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::ReleaseDataErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::ReleaseDataError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::ReleaseDataError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetVoiceStart"

void serializeJson (const ::SDS_TTS_FI::SetVoiceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTTSVoice()) {
        yajl_gen_string(g, (const unsigned char*)  "TTSVoice" , 8);
        serializeJson(value.getTTSVoice(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::SetVoiceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetVoiceError"

void serializeJson (const ::SDS_TTS_FI::SetVoiceError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::SetVoiceError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::SetVoiceErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::SetVoiceError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::SetVoiceError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AbortPromptStart"

void serializeJson (const ::SDS_TTS_FI::AbortPromptStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAbortPromptOption()) {
        yajl_gen_string(g, (const unsigned char*)  "AbortPromptOption" , 17);
        const char* s = ::sds_tts_fi_types::T_e8_PromptAbortOption_Name(value.getAbortPromptOption());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAbortPromptOption());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::AbortPromptStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AbortPromptError"

void serializeJson (const ::SDS_TTS_FI::AbortPromptError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::AbortPromptError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::AbortPromptErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::AbortPromptError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::AbortPromptError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PausePromptStart"

void serializeJson (const ::SDS_TTS_FI::PausePromptStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPausePromptOption()) {
        yajl_gen_string(g, (const unsigned char*)  "PausePromptOption" , 17);
        const char* s = ::sds_tts_fi_types::T_e8_PromptAbortOption_Name(value.getPausePromptOption());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getPausePromptOption());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::PausePromptStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PausePromptError"

void serializeJson (const ::SDS_TTS_FI::PausePromptError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::PausePromptError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::PausePromptErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::PausePromptError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::PausePromptError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ContinuePromptStart"

void serializeJson (const ::SDS_TTS_FI::ContinuePromptStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDummy()) {
        yajl_gen_string(g, (const unsigned char*)  "Dummy" , 5);
        yajl_gen_integer(g, (long long)value.getDummy());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::ContinuePromptStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ContinuePromptError"

void serializeJson (const ::SDS_TTS_FI::ContinuePromptError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::ContinuePromptError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::ContinuePromptErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::ContinuePromptError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::ContinuePromptError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AbortPromptWithExtensionStart"

void serializeJson (const ::SDS_TTS_FI::AbortPromptWithExtensionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAbortPromptOption()) {
        yajl_gen_string(g, (const unsigned char*)  "AbortPromptOption" , 17);
        const char* s = ::sds_tts_fi_types::T_e8_PromptAbortOption_Name(value.getAbortPromptOption());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAbortPromptOption());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::AbortPromptWithExtensionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AbortPromptWithExtensionError"

void serializeJson (const ::SDS_TTS_FI::AbortPromptWithExtensionError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::AbortPromptWithExtensionError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::AbortPromptWithExtensionErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::AbortPromptWithExtensionError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::AbortPromptWithExtensionError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PausePromptWithExtensionStart"

void serializeJson (const ::SDS_TTS_FI::PausePromptWithExtensionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPausePromptOption()) {
        yajl_gen_string(g, (const unsigned char*)  "PausePromptOption" , 17);
        const char* s = ::sds_tts_fi_types::T_e8_PromptAbortOption_Name(value.getPausePromptOption());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getPausePromptOption());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::PausePromptWithExtensionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PausePromptWithExtensionError"

void serializeJson (const ::SDS_TTS_FI::PausePromptWithExtensionError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::PausePromptWithExtensionError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::PausePromptWithExtensionErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::PausePromptWithExtensionError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::PausePromptWithExtensionError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ContinuePromptWithExtensionStart"

void serializeJson (const ::SDS_TTS_FI::ContinuePromptWithExtensionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDummy()) {
        yajl_gen_string(g, (const unsigned char*)  "Dummy" , 5);
        yajl_gen_integer(g, (long long)value.getDummy());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::ContinuePromptWithExtensionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ContinuePromptWithExtensionError"

void serializeJson (const ::SDS_TTS_FI::ContinuePromptWithExtensionError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::ContinuePromptWithExtensionError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::ContinuePromptWithExtensionErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::ContinuePromptWithExtensionError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::ContinuePromptWithExtensionError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestPhonemeStart"

void serializeJson (const ::SDS_TTS_FI::RequestPhonemeStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTextAndTags()) {
        yajl_gen_string(g, (const unsigned char*)  "TextAndTags" , 11);
        const char *s = value.getTextAndTags().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTextStyle()) {
        yajl_gen_string(g, (const unsigned char*)  "TextStyle" , 9);
        const char* s = ::sds_tts_fi_types::T_e8_TextStyleOption_Name(value.getTextStyle());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTextStyle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::RequestPhonemeStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestPhonemeResult"

void serializeJson (const ::SDS_TTS_FI::RequestPhonemeResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPhonemeList()) {
        yajl_gen_string(g, (const unsigned char*)  "PhonemeList" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& o7 = value.getPhonemeList();
        {
            ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::RequestPhonemeResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestPhonemeError"

void serializeJson (const ::SDS_TTS_FI::RequestPhonemeError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::RequestPhonemeError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::RequestPhonemeErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::RequestPhonemeError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::RequestPhonemeError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LoadTuningFilesStart"

void serializeJson (const ::SDS_TTS_FI::LoadTuningFilesStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTTSTunFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "TTSTunFiles" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::sds_tts_fi_types::T_TTSTuningFile >& o9 = value.getTTSTunFiles();
        {
            ::std::vector< ::sds_tts_fi_types::T_TTSTuningFile >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                serializeJson((*o8), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasTTSDomain()) {
        yajl_gen_string(g, (const unsigned char*)  "TTSDomain" , 9);
        const char* s = ::sds_tts_fi_types::T_e8_TTSDomain_Name(value.getTTSDomain());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTTSDomain());
    }
    if (!isSparse || value.hasTTSVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "TTSVersion" , 10);
        const char *s = value.getTTSVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::LoadTuningFilesStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LoadTuningFilesError"

void serializeJson (const ::SDS_TTS_FI::LoadTuningFilesError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::LoadTuningFilesError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::LoadTuningFilesErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::LoadTuningFilesError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::LoadTuningFilesError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDefaultSpeechRateStart"

void serializeJson (const ::SDS_TTS_FI::SetDefaultSpeechRateStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRate()) {
        yajl_gen_string(g, (const unsigned char*)  "Rate" , 4);
        yajl_gen_integer(g, (long long)value.getRate());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::SetDefaultSpeechRateStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoSynthesisForSpeakStart"

void serializeJson (const ::SDS_TTS_FI::DoSynthesisForSpeakStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTextAndTags()) {
        yajl_gen_string(g, (const unsigned char*)  "TextAndTags" , 11);
        const char *s = value.getTextAndTags().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTextStyle()) {
        yajl_gen_string(g, (const unsigned char*)  "TextStyle" , 9);
        const char* s = ::sds_tts_fi_types::T_e8_TextStyleOption_Name(value.getTextStyle());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTextStyle());
    }
    if (!isSparse || value.hasStatusInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "StatusInfo" , 10);
        const char* s = ::sds_tts_fi_types::T_e8_StatusInfoOption_Name(value.getStatusInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatusInfo());
    }
    if (!isSparse || value.hasLastPackage()) {
        yajl_gen_string(g, (const unsigned char*)  "LastPackage" , 11);
        yajl_gen_bool(g, (bool)value.getLastPackage());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoSynthesisForSpeakStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoPrepareAudioOutputStart"

void serializeJson (const ::SDS_TTS_FI::DoPrepareAudioOutputStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceName()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceName" , 10);
        const char *s = value.getDeviceName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoPrepareAudioOutputStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoPrepareAudioOutputError"

void serializeJson (const ::SDS_TTS_FI::DoPrepareAudioOutputError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::DoPrepareAudioOutputError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::DoPrepareAudioOutputErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::DoPrepareAudioOutputError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::DoPrepareAudioOutputError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoAudioOutputSpeakStart"

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatusInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "StatusInfo" , 10);
        const char* s = ::sds_tts_fi_types::T_e8_StatusInfoOption_Name(value.getStatusInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatusInfo());
    }
    if (!isSparse || value.hasAudioOutputLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "AudioOutputLocation" , 19);
        serializeJson(value.getAudioOutputLocation(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoAudioOutputSpeakResultFirst"

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakResultFirst& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "JobProgress" , 11);
        serializeJson(value.getJobProgress(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakResultFirst& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoAudioOutputSpeakResultMiddle"

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakResultMiddle& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "JobProgress" , 11);
        serializeJson(value.getJobProgress(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakResultMiddle& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoAudioOutputSpeakResultLast"

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakResultLast& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "JobProgress" , 11);
        serializeJson(value.getJobProgress(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakResultLast& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoSynthesisForWriteStart"

void serializeJson (const ::SDS_TTS_FI::DoSynthesisForWriteStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTextAndTags()) {
        yajl_gen_string(g, (const unsigned char*)  "TextAndTags" , 11);
        const char *s = value.getTextAndTags().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTextStyle()) {
        yajl_gen_string(g, (const unsigned char*)  "TextStyle" , 9);
        const char* s = ::sds_tts_fi_types::T_e8_TextStyleOption_Name(value.getTextStyle());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTextStyle());
    }
    if (!isSparse || value.hasLastPackage()) {
        yajl_gen_string(g, (const unsigned char*)  "LastPackage" , 11);
        yajl_gen_bool(g, (bool)value.getLastPackage());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoSynthesisForWriteStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoAudioOutputWriteStart"

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputWriteStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBuffering()) {
        yajl_gen_string(g, (const unsigned char*)  "Buffering" , 9);
        const char* s = ::sds_tts_fi_types::T_e8_BufferingOption_Name(value.getBuffering());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getBuffering());
    }
    if (!isSparse || value.hasCompression()) {
        yajl_gen_string(g, (const unsigned char*)  "Compression" , 11);
        serializeJson(value.getCompression(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputWriteStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoAudioOutputWriteResultFirst"

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputWriteResultFirst& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBufferingProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "BufferingProgress" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& o11 = value.getBufferingProgress();
        {
            ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                serializeJson((*o10), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputWriteResultFirst& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoAudioOutputWriteResultMiddle"

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputWriteResultMiddle& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBufferingProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "BufferingProgress" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& o13 = value.getBufferingProgress();
        {
            ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                serializeJson((*o12), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputWriteResultMiddle& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoAudioOutputWriteResultLast"

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputWriteResultLast& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBufferingProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "BufferingProgress" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& o15 = value.getBufferingProgress();
        {
            ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                serializeJson((*o14), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputWriteResultLast& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoSynthesisForSpeakWithExtentionStart"

void serializeJson (const ::SDS_TTS_FI::DoSynthesisForSpeakWithExtentionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTextAndTags()) {
        yajl_gen_string(g, (const unsigned char*)  "TextAndTags" , 11);
        const char *s = value.getTextAndTags().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTextStyle()) {
        yajl_gen_string(g, (const unsigned char*)  "TextStyle" , 9);
        const char* s = ::sds_tts_fi_types::T_e8_AudioSourceID_Name(value.getTextStyle());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTextStyle());
    }
    if (!isSparse || value.hasStatusInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "StatusInfo" , 10);
        const char* s = ::sds_tts_fi_types::T_e8_StatusInfoOption_Name(value.getStatusInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatusInfo());
    }
    if (!isSparse || value.hasLastPackage()) {
        yajl_gen_string(g, (const unsigned char*)  "LastPackage" , 11);
        yajl_gen_bool(g, (bool)value.getLastPackage());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoSynthesisForSpeakWithExtentionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoReleaseDataStart"

void serializeJson (const ::SDS_TTS_FI::DoReleaseDataStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasReleaseType()) {
        yajl_gen_string(g, (const unsigned char*)  "ReleaseType" , 11);
        const char* s = ::sds_tts_fi_types::T_e8_ReleaseTypeTTS_Name(value.getReleaseType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getReleaseType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoReleaseDataStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoReleaseDataError"

void serializeJson (const ::SDS_TTS_FI::DoReleaseDataError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::DoReleaseDataError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::DoReleaseDataErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::DoReleaseDataError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::DoReleaseDataError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoRequestPhonemeStart"

void serializeJson (const ::SDS_TTS_FI::DoRequestPhonemeStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTextAndTags()) {
        yajl_gen_string(g, (const unsigned char*)  "TextAndTags" , 11);
        const char *s = value.getTextAndTags().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTextStyle()) {
        yajl_gen_string(g, (const unsigned char*)  "TextStyle" , 9);
        const char* s = ::sds_tts_fi_types::T_e8_TextStyleOption_Name(value.getTextStyle());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTextStyle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoRequestPhonemeStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoRequestPhonemeResult"

void serializeJson (const ::SDS_TTS_FI::DoRequestPhonemeResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPhonemeList()) {
        yajl_gen_string(g, (const unsigned char*)  "PhonemeList" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& o17 = value.getPhonemeList();
        {
            ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                serializeJson((*o16), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoRequestPhonemeResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoRequestPhonemeError"

void serializeJson (const ::SDS_TTS_FI::DoRequestPhonemeError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::DoRequestPhonemeError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::DoRequestPhonemeErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::DoRequestPhonemeError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::DoRequestPhonemeError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoAudioOutputSpeakWithExtensionStart"

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatusInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "StatusInfo" , 10);
        const char* s = ::sds_tts_fi_types::T_e8_StatusInfoOption_Name(value.getStatusInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatusInfo());
    }
    if (!isSparse || value.hasAudioOutputLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "AudioOutputLocation" , 19);
        serializeJson(value.getAudioOutputLocation(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoAudioOutputSpeakWithExtensionResultFirst"

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionResultFirst& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "JobProgress" , 11);
        serializeJson(value.getJobProgress(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionResultFirst& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoAudioOutputSpeakWithExtensionResultMiddle"

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionResultMiddle& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "JobProgress" , 11);
        serializeJson(value.getJobProgress(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionResultMiddle& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoAudioOutputSpeakWithExtensionResultLast"

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionResultLast& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJobProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "JobProgress" , 11);
        serializeJson(value.getJobProgress(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionResultLast& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VoiceStatus"

void serializeJson (const ::SDS_TTS_FI::VoiceStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTTSVoice()) {
        yajl_gen_string(g, (const unsigned char*)  "TTSVoice" , 8);
        serializeJson(value.getTTSVoice(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::VoiceStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AvailableVoicesStatus"

void serializeJson (const ::SDS_TTS_FI::AvailableVoicesStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAvailableTTSVoices()) {
        yajl_gen_string(g, (const unsigned char*)  "AvailableTTSVoices" , 18);
        yajl_gen_array_open(g);
        const ::std::vector< ::sds_speechdp_fi_types::T_VoiceType >& o19 = value.getAvailableTTSVoices();
        {
            ::std::vector< ::sds_speechdp_fi_types::T_VoiceType >::const_iterator o18;
            for (o18 = o19.begin(); o18 != o19.end(); ++o18) {
                serializeJson((*o18), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::AvailableVoicesStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TTSVersionInfoStatus"

void serializeJson (const ::SDS_TTS_FI::TTSVersionInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTTSVersionInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "TTSVersionInfo" , 14);
        serializeJson(value.getTTSVersionInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::TTSVersionInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TTSStatusStatus"

void serializeJson (const ::SDS_TTS_FI::TTSStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTTSStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "TTSStatus" , 9);
        const char* s = ::sds_tts_fi_types::T_e8_TTSStatus_Name(value.getTTSStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTTSStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::TTSStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DownloadCompleteStatus"

void serializeJson (const ::SDS_TTS_FI::DownloadCompleteStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasComplete()) {
        yajl_gen_string(g, (const unsigned char*)  "Complete" , 8);
        yajl_gen_bool(g, (bool)value.getComplete());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::DownloadCompleteStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DownloadCompleteError"

void serializeJson (const ::SDS_TTS_FI::DownloadCompleteError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::SDS_TTS_FI::DownloadCompleteError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            const char* s = ::SDS_TTS_FI::DownloadCompleteErrorCode_Name(value.getCcaErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getCcaErrorCode());
            break;
        }
    case ::SDS_TTS_FI::DownloadCompleteError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::SDS_TTS_FI::DownloadCompleteError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TTSPlaybackSpacingStatus"

void serializeJson (const ::SDS_TTS_FI::TTSPlaybackSpacingStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPlaybackSpacing()) {
        yajl_gen_string(g, (const unsigned char*)  "PlaybackSpacing" , 15);
        yajl_gen_integer(g, (long long)value.getPlaybackSpacing());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::TTSPlaybackSpacingStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TTSPlaybackSpacingSet"

void serializeJson (const ::SDS_TTS_FI::TTSPlaybackSpacingSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPlaybackSpacing()) {
        yajl_gen_string(g, (const unsigned char*)  "PlaybackSpacing" , 15);
        yajl_gen_integer(g, (long long)value.getPlaybackSpacing());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SDS_TTS_FI::TTSPlaybackSpacingSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SynthesizeSpeakStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SynthesizeSpeakResultFirst& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SynthesizeSpeakResultMiddle& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SynthesizeSpeakResultLast& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SynthesizeSpeakError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SynthesizeWriteStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SynthesizeWriteResultFirst& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SynthesizeWriteResultMiddle& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SynthesizeWriteResultLast& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SynthesizeWriteError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SynthesizeSpeakWithExtensionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SynthesizeSpeakWithExtensionResultFirst& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SynthesizeSpeakWithExtensionResultMiddle& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SynthesizeSpeakWithExtensionResultLast& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SynthesizeSpeakWithExtensionError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::PrepareVoiceOutputStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::PrepareVoiceOutputError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::ReleaseDataStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::ReleaseDataError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SetVoiceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SetVoiceError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::AbortPromptStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::AbortPromptError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::PausePromptStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::PausePromptError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::ContinuePromptStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::ContinuePromptError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::AbortPromptWithExtensionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::AbortPromptWithExtensionError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::PausePromptWithExtensionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::PausePromptWithExtensionError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::ContinuePromptWithExtensionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::ContinuePromptWithExtensionError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::RequestPhonemeStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::RequestPhonemeResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::RequestPhonemeError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::LoadTuningFilesStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::LoadTuningFilesError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::SetDefaultSpeechRateStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoSynthesisForSpeakStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoPrepareAudioOutputStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoPrepareAudioOutputError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoAudioOutputSpeakStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoAudioOutputSpeakResultFirst& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoAudioOutputSpeakResultMiddle& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoAudioOutputSpeakResultLast& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoSynthesisForWriteStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoAudioOutputWriteStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoAudioOutputWriteResultFirst& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoAudioOutputWriteResultMiddle& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoAudioOutputWriteResultLast& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoSynthesisForSpeakWithExtentionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoReleaseDataStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoReleaseDataError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoRequestPhonemeStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoRequestPhonemeResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoRequestPhonemeError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionResultFirst& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionResultMiddle& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DoAudioOutputSpeakWithExtensionResultLast& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::VoiceStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::AvailableVoicesStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::TTSVersionInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::TTSStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DownloadCompleteStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::DownloadCompleteError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::TTSPlaybackSpacingStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI
using namespace ::asf::stream::json;

namespace SDS_TTS_FI {

std::ostream& operator<<(std::ostream& o, const ::SDS_TTS_FI::TTSPlaybackSpacingSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SDS_TTS_FI

