/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_TTS_FICONST_H
#define SDS_TTS_FICONST_H

#include <cstddef>

/**
 * CCA Functional Interface 'SDS_TTS_FI'
 *
 * Fullname: TTS Functional Interface
 *
 * Version: $Revision:$
 *
 * Author: Joachim Schneider, Chethan R
 *
 * Date: $Date:22.06.2016$
 *
 * Department: Bosch SoftTec / PJ-CF44
 *
 * Title: TTS_FI
 *
 * <b>Description of 'SDS_TTS_FI':</b>
 *
 * This document defines the functional interface of the FC_TTS including further specifications of the FC_TTS.
 */

namespace SDS_TTS_FI {

/**
 * The error codes of 'SynthesizeSpeak'
 */
enum SynthesizeSpeakErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakErrorCode__RelUpRegFailure,
    /**
     * If the used dictionary is corrupt or can not be read.
     */
    SynthesizeSpeakErrorCode__DictionaryCorrupt = 24577u,
    /**
     * If the available memory for processing this job is too small.
     */
    SynthesizeSpeakErrorCode__NotEnoughMemoryAvailable = 24578u,
    /**
     * If the String is bigger than the specified size.
     */
    SynthesizeSpeakErrorCode__TransmittedStringTooBig = 24579u,
    /**
     * If there is no memory left in the shared memory.
     */
    SynthesizeSpeakErrorCode__NoSharedMemoryAvailable = 24580u,
    /**
     * If the wanted language (change of tts-language) is not available.
     */
    SynthesizeSpeakErrorCode__LanguageNotAvailable = 24583u,
    /**
     * If the wanted language is not on memory but on CD or DVD.
     */
    SynthesizeSpeakErrorCode__LanguageNotOnMemory = 24584u,
    /**
     * If the wanted compression-format for the audio-output is not known or valid.
     */
    SynthesizeSpeakErrorCode__InvalidCompressionFormat = 24585u,
    /**
     * If the used memory is corrupt or can not be read.
     */
    SynthesizeSpeakErrorCode__MemoryCorrupt = 24587u,
    /**
     * Some methods are labeled with an expiration date. If the job could not be started, before this exp. date has expired, this error will be sent.
     */
    SynthesizeSpeakErrorCode__JobExpired = 24589u,
    /**
     * If the job has been aborted.
     */
    SynthesizeSpeakErrorCode__JobAborted = 24593u,
    /**
     * If a SynthesizeSpeak-job is coming in, but the audio device was not opened in advance by using PrepareVoiceOutput .
     */
    SynthesizeSpeakErrorCode__AudioDeviceNotOpen = 24597u

};

bool SynthesizeSpeakErrorCode_Parse (const char *str, size_t length, SynthesizeSpeakErrorCode &value);

const char* SynthesizeSpeakErrorCode_Name (SynthesizeSpeakErrorCode value);

bool SynthesizeSpeakErrorCode_IsValid (SynthesizeSpeakErrorCode value);

/**
 * The error codes of 'SynthesizeWrite'
 */
enum SynthesizeWriteErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    SynthesizeWriteErrorCode__RelUpRegFailure,
    /**
     * If the used dictionary is corrupt or can not be read.
     */
    SynthesizeWriteErrorCode__DictionaryCorrupt = 24577u,
    /**
     * If the available memory for processing this job is too small.
     */
    SynthesizeWriteErrorCode__NotEnoughMemoryAvailable = 24578u,
    /**
     * If the String is bigger than the specified size.
     */
    SynthesizeWriteErrorCode__TransmittedStringTooBig = 24579u,
    /**
     * If there is no memory left in the shared memory.
     */
    SynthesizeWriteErrorCode__NoSharedMemoryAvailable = 24580u,
    /**
     * If the wanted language (change of tts-language) is not available.
     */
    SynthesizeWriteErrorCode__LanguageNotAvailable = 24583u,
    /**
     * If the wanted language is not on memory but on CD or DVD.
     */
    SynthesizeWriteErrorCode__LanguageNotOnMemory = 24584u,
    /**
     * If the wanted compression-format for the audio-output is not known or valid.
     */
    SynthesizeWriteErrorCode__InvalidCompressionFormat = 24585u,
    /**
     * If the used memory is corrupt or can not be read.
     */
    SynthesizeWriteErrorCode__MemoryCorrupt = 24587u,
    /**
     * Some methods are labeled with an expiration date. If the job could not be started, before this exp. date has expired, this error will be sent.
     */
    SynthesizeWriteErrorCode__JobExpired = 24589u

};

bool SynthesizeWriteErrorCode_Parse (const char *str, size_t length, SynthesizeWriteErrorCode &value);

const char* SynthesizeWriteErrorCode_Name (SynthesizeWriteErrorCode value);

bool SynthesizeWriteErrorCode_IsValid (SynthesizeWriteErrorCode value);

/**
 * The error codes of 'SynthesizeSpeakWithExtension'
 */
enum SynthesizeSpeakWithExtensionErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    SynthesizeSpeakWithExtensionErrorCode__RelUpRegFailure,
    /**
     * If the used dictionary is corrupt or can not be read.
     */
    SynthesizeSpeakWithExtensionErrorCode__DictionaryCorrupt = 24577u,
    /**
     * If the available memory for processing this job is too small.
     */
    SynthesizeSpeakWithExtensionErrorCode__NotEnoughMemoryAvailable = 24578u,
    /**
     * If the String is bigger than the specified size.
     */
    SynthesizeSpeakWithExtensionErrorCode__TransmittedStringTooBig = 24579u,
    /**
     * If there is no memory left in the shared memory.
     */
    SynthesizeSpeakWithExtensionErrorCode__NoSharedMemoryAvailable = 24580u,
    /**
     * If the wanted language (change of tts-language) is not available.
     */
    SynthesizeSpeakWithExtensionErrorCode__LanguageNotAvailable = 24583u,
    /**
     * If the wanted language is not on memory but on CD or DVD.
     */
    SynthesizeSpeakWithExtensionErrorCode__LanguageNotOnMemory = 24584u,
    /**
     * If the wanted compression-format for the audio-output is not known or valid.
     */
    SynthesizeSpeakWithExtensionErrorCode__InvalidCompressionFormat = 24585u,
    /**
     * If the used memory is corrupt or can not be read.
     */
    SynthesizeSpeakWithExtensionErrorCode__MemoryCorrupt = 24587u,
    /**
     * Some methods are labeled with an expiration date. If the job could not be started, before this exp. date has expired, this error will be sent.
     */
    SynthesizeSpeakWithExtensionErrorCode__JobExpired = 24589u,
    /**
     * If the job has been aborted.
     */
    SynthesizeSpeakWithExtensionErrorCode__JobAborted = 24593u,
    /**
     * If a SynthesizeSpeak-job is coming in, but the audio device was not opened in advance by using PrepareVoiceOutput .
     */
    SynthesizeSpeakWithExtensionErrorCode__AudioDeviceNotOpen = 24597u,
    /**
     * If the audio doesn't assign the channel to output synthsized text.
     */
    SynthesizeSpeakWithExtensionErrorCode__NoAudioChannelAssigned = 24603u,
    /**
     * If the language code of synthsized text is not identical with the one which TTS uses.
     */
    SynthesizeSpeakWithExtensionErrorCode__LanguageCodeNotCorrect = 24604u

};

bool SynthesizeSpeakWithExtensionErrorCode_Parse (const char *str, size_t length, SynthesizeSpeakWithExtensionErrorCode &value);

const char* SynthesizeSpeakWithExtensionErrorCode_Name (SynthesizeSpeakWithExtensionErrorCode value);

bool SynthesizeSpeakWithExtensionErrorCode_IsValid (SynthesizeSpeakWithExtensionErrorCode value);

/**
 * The error codes of 'PrepareVoiceOutput'
 */
enum PrepareVoiceOutputErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    PrepareVoiceOutputErrorCode__RelUpRegFailure,
    /**
     * If the audio device is busy.
     */
    PrepareVoiceOutputErrorCode__AudioDeviceBusy = 24592u,
    /**
     * If the job has been aborted.
     */
    PrepareVoiceOutputErrorCode__JobAborted = 24593u,
    /**
     * If a request to the FC TTS comes and the TTS engine is not initialized.
     */
    PrepareVoiceOutputErrorCode__EngineNotInitialized = 24599u

};

bool PrepareVoiceOutputErrorCode_Parse (const char *str, size_t length, PrepareVoiceOutputErrorCode &value);

const char* PrepareVoiceOutputErrorCode_Name (PrepareVoiceOutputErrorCode value);

bool PrepareVoiceOutputErrorCode_IsValid (PrepareVoiceOutputErrorCode value);

/**
 * The error codes of 'ReleaseData'
 */
enum ReleaseDataErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    ReleaseDataErrorCode__RelUpRegFailure,
    /**
     * The requested LanguageID is not supported
     */
    ReleaseDataErrorCode__InvalidLanguageID = 261u,
    /**
     * If the wanted language (change of tts-language) is not available.
     */
    ReleaseDataErrorCode__LanguageNotAvailable = 24583u,
    /**
     * If the wanted language is not on memory but on CD or DVD.
     */
    ReleaseDataErrorCode__LanguageNotOnMemory = 24584u,
    /**
     * If a release of the TTS-relevant data could not be done or completed.
     */
    ReleaseDataErrorCode__TTSNotReleased = 24591u,
    /**
     * Action currently not possible as a job is running.
     */
    ReleaseDataErrorCode__CurrentlySynthesizing = 24596u

};

bool ReleaseDataErrorCode_Parse (const char *str, size_t length, ReleaseDataErrorCode &value);

const char* ReleaseDataErrorCode_Name (ReleaseDataErrorCode value);

bool ReleaseDataErrorCode_IsValid (ReleaseDataErrorCode value);

/**
 * The error codes of 'SetVoice'
 */
enum SetVoiceErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    SetVoiceErrorCode__RelUpRegFailure,
    /**
     * If the wanted voice (change of tts-voice) is not available.
     */
    SetVoiceErrorCode__VoiceNotAvailable = 24581u,
    /**
     * If the wanted voice is not on memory but on CD or DVD.
     */
    SetVoiceErrorCode__VoiceNotOnMemory = 24582u,
    /**
     * If a release of the TTS-relevant data could not be done or completed.
     */
    SetVoiceErrorCode__TTSNotReleased = 24591u

};

bool SetVoiceErrorCode_Parse (const char *str, size_t length, SetVoiceErrorCode &value);

const char* SetVoiceErrorCode_Name (SetVoiceErrorCode value);

bool SetVoiceErrorCode_IsValid (SetVoiceErrorCode value);

/**
 * The error codes of 'AbortPrompt'
 */
enum AbortPromptErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    AbortPromptErrorCode__RelUpRegFailure,
    /**
     * The amount of data to handle this method exceeded the available ressources of the navigation module. This can happen if very large Result data streams have to be created.
     */
    AbortPromptErrorCode__TooMuchInputData = 257u,
    /**
     * If the used memory is corrupt or can not be read.
     */
    AbortPromptErrorCode__MemoryCorrupt = 24587u,
    /**
     * If no job is currently beeing processed, when an AbortPrompt-Message comes in.
     */
    AbortPromptErrorCode__NoJobRunning = 24594u

};

bool AbortPromptErrorCode_Parse (const char *str, size_t length, AbortPromptErrorCode &value);

const char* AbortPromptErrorCode_Name (AbortPromptErrorCode value);

bool AbortPromptErrorCode_IsValid (AbortPromptErrorCode value);

/**
 * The error codes of 'PausePrompt'
 */
enum PausePromptErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    PausePromptErrorCode__RelUpRegFailure,
    /**
     * The amount of data to handle this method exceeded the available ressources of the navigation module. This can happen if very large Result data streams have to be created.
     */
    PausePromptErrorCode__TooMuchInputData = 257u,
    /**
     * If the used memory is corrupt or can not be read.
     */
    PausePromptErrorCode__MemoryCorrupt = 24587u

};

bool PausePromptErrorCode_Parse (const char *str, size_t length, PausePromptErrorCode &value);

const char* PausePromptErrorCode_Name (PausePromptErrorCode value);

bool PausePromptErrorCode_IsValid (PausePromptErrorCode value);

/**
 * The error codes of 'ContinuePrompt'
 */
enum ContinuePromptErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    ContinuePromptErrorCode__RelUpRegFailure,
    /**
     * The amount of data to handle this method exceeded the available ressources of the navigation module. This can happen if very large Result data streams have to be created.
     */
    ContinuePromptErrorCode__TooMuchInputData = 257u,
    /**
     * If the used memory is corrupt or can not be read.
     */
    ContinuePromptErrorCode__MemoryCorrupt = 24587u

};

bool ContinuePromptErrorCode_Parse (const char *str, size_t length, ContinuePromptErrorCode &value);

const char* ContinuePromptErrorCode_Name (ContinuePromptErrorCode value);

bool ContinuePromptErrorCode_IsValid (ContinuePromptErrorCode value);

/**
 * The error codes of 'AbortPromptWithExtension'
 */
enum AbortPromptWithExtensionErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    AbortPromptWithExtensionErrorCode__RelUpRegFailure,
    /**
     * The amount of data to handle this method exceeded the available ressources of the navigation module. This can happen if very large Result data streams have to be created.
     */
    AbortPromptWithExtensionErrorCode__TooMuchInputData = 257u,
    /**
     * If the used memory is corrupt or can not be read.
     */
    AbortPromptWithExtensionErrorCode__MemoryCorrupt = 24587u,
    /**
     * If no job is currently beeing processed, when an AbortPrompt-Message comes in.
     */
    AbortPromptWithExtensionErrorCode__NoJobRunning = 24594u

};

bool AbortPromptWithExtensionErrorCode_Parse (const char *str, size_t length, AbortPromptWithExtensionErrorCode &value);

const char* AbortPromptWithExtensionErrorCode_Name (AbortPromptWithExtensionErrorCode value);

bool AbortPromptWithExtensionErrorCode_IsValid (AbortPromptWithExtensionErrorCode value);

/**
 * The error codes of 'PausePromptWithExtension'
 */
enum PausePromptWithExtensionErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    PausePromptWithExtensionErrorCode__RelUpRegFailure,
    /**
     * The amount of data to handle this method exceeded the available ressources of the navigation module. This can happen if very large Result data streams have to be created.
     */
    PausePromptWithExtensionErrorCode__TooMuchInputData = 257u,
    /**
     * If the used memory is corrupt or can not be read.
     */
    PausePromptWithExtensionErrorCode__MemoryCorrupt = 24587u

};

bool PausePromptWithExtensionErrorCode_Parse (const char *str, size_t length, PausePromptWithExtensionErrorCode &value);

const char* PausePromptWithExtensionErrorCode_Name (PausePromptWithExtensionErrorCode value);

bool PausePromptWithExtensionErrorCode_IsValid (PausePromptWithExtensionErrorCode value);

/**
 * The error codes of 'ContinuePromptWithExtension'
 */
enum ContinuePromptWithExtensionErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    ContinuePromptWithExtensionErrorCode__RelUpRegFailure,
    /**
     * The amount of data to handle this method exceeded the available ressources of the navigation module. This can happen if very large Result data streams have to be created.
     */
    ContinuePromptWithExtensionErrorCode__TooMuchInputData = 257u,
    /**
     * If the used memory is corrupt or can not be read.
     */
    ContinuePromptWithExtensionErrorCode__MemoryCorrupt = 24587u

};

bool ContinuePromptWithExtensionErrorCode_Parse (const char *str, size_t length, ContinuePromptWithExtensionErrorCode &value);

const char* ContinuePromptWithExtensionErrorCode_Name (ContinuePromptWithExtensionErrorCode value);

bool ContinuePromptWithExtensionErrorCode_IsValid (ContinuePromptWithExtensionErrorCode value);

/**
 * The error codes of 'RequestPhoneme'
 */
enum RequestPhonemeErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    RequestPhonemeErrorCode__RelUpRegFailure,
    /**
     * If the used dictionary is corrupt or can not be read.
     */
    RequestPhonemeErrorCode__DictionaryCorrupt = 24577u,
    /**
     * If the wanted language (change of tts-language) is not available.
     */
    RequestPhonemeErrorCode__LanguageNotAvailable = 24583u,
    /**
     * If the wanted language is not on memory but on CD or DVD.
     */
    RequestPhonemeErrorCode__LanguageNotOnMemory = 24584u,
    /**
     * If the used dictionary is corrupt or can not be read.
     */
    RequestPhonemeErrorCode__PhonemeNotAvailable = 24600u

};

bool RequestPhonemeErrorCode_Parse (const char *str, size_t length, RequestPhonemeErrorCode &value);

const char* RequestPhonemeErrorCode_Name (RequestPhonemeErrorCode value);

bool RequestPhonemeErrorCode_IsValid (RequestPhonemeErrorCode value);

/**
 * The error codes of 'LoadTuningFiles'
 */
enum LoadTuningFilesErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    LoadTuningFilesErrorCode__RelUpRegFailure,
    /**
     * The Tuning received tuning files are not compatible with the configured TTS Engine version.
     */
    LoadTuningFilesErrorCode__TuningFilesNotCompatible = 24601u,
    /**
     * If the received domain is not known to TTS.
     */
    LoadTuningFilesErrorCode__DomainNotAvailable = 24602u

};

bool LoadTuningFilesErrorCode_Parse (const char *str, size_t length, LoadTuningFilesErrorCode &value);

const char* LoadTuningFilesErrorCode_Name (LoadTuningFilesErrorCode value);

bool LoadTuningFilesErrorCode_IsValid (LoadTuningFilesErrorCode value);

/**
 * The error codes of 'DoPrepareAudioOutput'
 */
enum DoPrepareAudioOutputErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    DoPrepareAudioOutputErrorCode__RelUpRegFailure,
    /**
     * If the audio device is busy.
     */
    DoPrepareAudioOutputErrorCode__AudioDeviceBusy = 24592u

};

bool DoPrepareAudioOutputErrorCode_Parse (const char *str, size_t length, DoPrepareAudioOutputErrorCode &value);

const char* DoPrepareAudioOutputErrorCode_Name (DoPrepareAudioOutputErrorCode value);

bool DoPrepareAudioOutputErrorCode_IsValid (DoPrepareAudioOutputErrorCode value);

/**
 * The error codes of 'DoReleaseData'
 */
enum DoReleaseDataErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    DoReleaseDataErrorCode__RelUpRegFailure,
    /**
     * If a release of the TTS-relevant data could not be done or completed.
     */
    DoReleaseDataErrorCode__TTSNotReleased = 24591u,
    /**
     * Action currently not possible as a job is running.
     */
    DoReleaseDataErrorCode__CurrentlySynthesizing = 24596u

};

bool DoReleaseDataErrorCode_Parse (const char *str, size_t length, DoReleaseDataErrorCode &value);

const char* DoReleaseDataErrorCode_Name (DoReleaseDataErrorCode value);

bool DoReleaseDataErrorCode_IsValid (DoReleaseDataErrorCode value);

/**
 * The error codes of 'DoRequestPhoneme'
 */
enum DoRequestPhonemeErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    DoRequestPhonemeErrorCode__RelUpRegFailure,
    /**
     * If the used dictionary is corrupt or can not be read.
     */
    DoRequestPhonemeErrorCode__DictionaryCorrupt = 24577u,
    /**
     * If the wanted language (change of tts-language) is not available.
     */
    DoRequestPhonemeErrorCode__LanguageNotAvailable = 24583u,
    /**
     * If the wanted language is not on memory but on CD or DVD.
     */
    DoRequestPhonemeErrorCode__LanguageNotOnMemory = 24584u,
    /**
     * If the used dictionary is corrupt or can not be read.
     */
    DoRequestPhonemeErrorCode__PhonemeNotAvailable = 24600u

};

bool DoRequestPhonemeErrorCode_Parse (const char *str, size_t length, DoRequestPhonemeErrorCode &value);

const char* DoRequestPhonemeErrorCode_Name (DoRequestPhonemeErrorCode value);

bool DoRequestPhonemeErrorCode_IsValid (DoRequestPhonemeErrorCode value);

/**
 * The error codes of 'DownloadComplete'
 */
enum DownloadCompleteErrorCode {

    /**
     * If the meaning of "Unspecified" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__Unspecified,
    /**
     * If the meaning of "UnknownSvcId" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__UnknownSvcId,
    /**
     * If the meaning of "UnknownFctId" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__UnknownFctId,
    /**
     * If the meaning of "InvalidOpCode" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__InvalidOpCode,
    /**
     * If the meaning of "InvalidCCAType" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__InvalidCCAType,
    /**
     * If the meaning of "ParameterOutOfRange" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__ParameterOutOfRange,
    /**
     * If the meaning of "UnknownRegId" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__UnknownRegId,
    /**
     * If the meaning of "VersionNotSupported" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__VersionNotSupported,
    /**
     * If the meaning of "ParameterMissing" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__ParameterMissing,
    /**
     * If the meaning of "ParameterTooMany" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__ParameterTooMany,
    /**
     * If the meaning of "Busy" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__Busy,
    /**
     * If the meaning of "TemporaryNotAvailable" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__TemporaryNotAvailable,
    /**
     * If the meaning of "OpCodeNotSupported" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__OpCodeNotSupported,
    /**
     * If the meaning of "InternalFailure" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__InternalFailure,
    /**
     * If the meaning of "UpRegFailure" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__UpRegFailure,
    /**
     * If the meaning of "RelUpRegFailure" isn't clear, then there should be a description here.
     */
    DownloadCompleteErrorCode__RelUpRegFailure,
    /**
     * The requested information is not available.
     */
    DownloadCompleteErrorCode__InformationNotAvailable = 24595u

};

bool DownloadCompleteErrorCode_Parse (const char *str, size_t length, DownloadCompleteErrorCode &value);

const char* DownloadCompleteErrorCode_Name (DownloadCompleteErrorCode value);

bool DownloadCompleteErrorCode_IsValid (DownloadCompleteErrorCode value);

} // namespace SDS_TTS_FI

#endif // SDS_TTS_FICONST_H
