#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_TTS_FI_H
#define SDS_TTS_FI_H

#include "SDS_TTS_FIConst.h"
#include "acr_fi_types.h"
#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "sds_sds2hmi_common_types.h"
#include "sds_speechdp_fi_types.h"
#include "sds_tts_fi_types.h"
#include "sds_tts_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'SDS_TTS_FI'
 *
 * Fullname: TTS Functional Interface
 *
 * Version: $Revision:$
 *
 * Author: Joachim Schneider, Chethan R
 *
 * Date: $Date:22.06.2016$
 *
 * Department: Bosch SoftTec / PJ-CF44
 *
 * Title: TTS_FI
 *
 * <b>Description of 'SDS_TTS_FI':</b>
 *
 * This document defines the functional interface of the FC_TTS including further specifications of the FC_TTS.
 */

namespace SDS_TTS_FI {

static const int SERVICE_ID = 514;

static const int FID_SynthesizeSpeak = 8449;

static const int FID_SynthesizeWrite = 8450;

static const int FID_SynthesizeSpeakWithExtension = 8453;

static const int FID_PrepareVoiceOutput = 8451;

static const int FID_ReleaseData = 8452;

static const int FID_SetVoice = 8454;

static const int FID_AbortPrompt = 8456;

static const int FID_PausePrompt = 8457;

static const int FID_ContinuePrompt = 8458;

static const int FID_AbortPromptWithExtension = 8463;

static const int FID_PausePromptWithExtension = 8464;

static const int FID_ContinuePromptWithExtension = 8465;

static const int FID_RequestPhoneme = 8459;

static const int FID_LoadTuningFiles = 8460;

static const int FID_SetDefaultSpeechRate = 8461;

static const int FID_DoSynthesisForSpeak = 8481;

static const int FID_DoPrepareAudioOutput = 8482;

static const int FID_DoAudioOutputSpeak = 8483;

static const int FID_DoUpRegToProperties = 8484;

static const int FID_DoSynthesisForWrite = 8485;

static const int FID_DoAudioOutputWrite = 8486;

static const int FID_DoSynthesisForSpeakWithExtention = 8487;

static const int FID_DoReleaseData = 8488;

static const int FID_DoReleaseAudioDevice = 8489;

static const int FID_DoRequestPhoneme = 8490;

static const int FID_DoAudioOutputSpeakWithExtension = 8491;

static const int FID_Voice = 8706;

static const int FID_AvailableVoices = 8707;

static const int FID_TTSVersionInfo = 8708;

static const int FID_TTSStatus = 8709;

static const int FID_DownloadComplete = 8710;

static const int FID_TTSPlaybackSpacing = 8711;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 6;

static const int VERSION_MINOR = 2;

static const int VERSION_PATCH = 0;

// forward declarations
class SynthesizeSpeakStart;

class SynthesizeSpeakResultFirst;

class SynthesizeSpeakResultMiddle;

class SynthesizeSpeakResultLast;

class SynthesizeSpeakError;

class SynthesizeWriteStart;

class SynthesizeWriteResultFirst;

class SynthesizeWriteResultMiddle;

class SynthesizeWriteResultLast;

class SynthesizeWriteError;

class SynthesizeSpeakWithExtensionStart;

class SynthesizeSpeakWithExtensionResultFirst;

class SynthesizeSpeakWithExtensionResultMiddle;

class SynthesizeSpeakWithExtensionResultLast;

class SynthesizeSpeakWithExtensionError;

class PrepareVoiceOutputStart;

class PrepareVoiceOutputError;

class ReleaseDataStart;

class ReleaseDataError;

class SetVoiceStart;

class SetVoiceError;

class AbortPromptStart;

class AbortPromptError;

class PausePromptStart;

class PausePromptError;

class ContinuePromptStart;

class ContinuePromptError;

class AbortPromptWithExtensionStart;

class AbortPromptWithExtensionError;

class PausePromptWithExtensionStart;

class PausePromptWithExtensionError;

class ContinuePromptWithExtensionStart;

class ContinuePromptWithExtensionError;

class RequestPhonemeStart;

class RequestPhonemeResult;

class RequestPhonemeError;

class LoadTuningFilesStart;

class LoadTuningFilesError;

class SetDefaultSpeechRateStart;

class DoSynthesisForSpeakStart;

class DoPrepareAudioOutputStart;

class DoPrepareAudioOutputError;

class DoAudioOutputSpeakStart;

class DoAudioOutputSpeakResultFirst;

class DoAudioOutputSpeakResultMiddle;

class DoAudioOutputSpeakResultLast;

class DoSynthesisForWriteStart;

class DoAudioOutputWriteStart;

class DoAudioOutputWriteResultFirst;

class DoAudioOutputWriteResultMiddle;

class DoAudioOutputWriteResultLast;

class DoSynthesisForSpeakWithExtentionStart;

class DoReleaseDataStart;

class DoReleaseDataError;

class DoRequestPhonemeStart;

class DoRequestPhonemeResult;

class DoRequestPhonemeError;

class DoAudioOutputSpeakWithExtensionStart;

class DoAudioOutputSpeakWithExtensionResultFirst;

class DoAudioOutputSpeakWithExtensionResultMiddle;

class DoAudioOutputSpeakWithExtensionResultLast;

class VoiceStatus;

class AvailableVoicesStatus;

class TTSVersionInfoStatus;

class TTSStatusStatus;

class DownloadCompleteStatus;

class DownloadCompleteError;

class TTSPlaybackSpacingStatus;

class TTSPlaybackSpacingSet;

// type definitions
/**
 * The abort error message of the method "SynthesizeSpeak"
 * <p>This method is used to synthesize text. The synthesised data
 * is played via the audiomanagement with the available dev/acousticout.
 * For every incoming job, the property "ChannelRequest" from the ACR_FI
 * is used to request the audiochannel from the AudioManagement. If the
 * AudioManagement sends back the method "VoiceAdvice" for the
 * corresponding job, the synthesis will be executed.</p>
 * Test requirement : "partly test"
 */
typedef ::asf::cca::CcaTypes::DefaultError SynthesizeSpeakAbortError;

/**
 * The abort error message of the method "SynthesizeWrite"
 * <p>This method is used to synthesize text and to write it into buffers.
 * The buffers will be written to shared memory and the path is transmitted to the client.
 * The jobs are listed in a queue without any priority (at the moment).
 * The jobs in the list will be synthesized in FIFO fashion.</p>
 * Test requirement : "partly test"
 */
typedef ::asf::cca::CcaTypes::DefaultError SynthesizeWriteAbortError;

/**
 * The abort error message of the method "SynthesizeSpeakWithExtension"
 * <p>This method is used to synthesize text. The synthesised data
 * is played via the audiomanagement with the available dev/acousticout.
 * SDS will request the audio channel from the AudioManagement. In case that AM
 * doesn't assign the channel , an error will be returned</p>
 * Test requirement : "partly test"
 */
typedef ::asf::cca::CcaTypes::DefaultError SynthesizeSpeakWithExtensionAbortError;

/**
 * The result message of the method "PrepareVoiceOutput"
 * <p>Method will be called by client to let the FC TTS prepare the audio
 * device in advance of a synthesis. As a result of this method, the
 * FC TTS will request the audiomanagement for the audio channel via
 * ACR_FI ChannelRequest. if VoiceAdvice is received by FC TTS, the
 * audio device will be opened and the parameters set accordingly.
 * if this is done completely and the Method is answered by the
 * Methodresult, the client may then send the SynthesizeSpeak-Method.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PrepareVoiceOutputResult;

/**
 * The abort error message of the method "PrepareVoiceOutput"
 * <p>Method will be called by client to let the FC TTS prepare the audio
 * device in advance of a synthesis. As a result of this method, the
 * FC TTS will request the audiomanagement for the audio channel via
 * ACR_FI ChannelRequest. if VoiceAdvice is received by FC TTS, the
 * audio device will be opened and the parameters set accordingly.
 * if this is done completely and the Method is answered by the
 * Methodresult, the client may then send the SynthesizeSpeak-Method.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultError PrepareVoiceOutputAbortError;

/**
 * The result message of the method "ReleaseData"
 * <p>All language-dependent software and memory must be unitialized and
 * released as a preparative action befor an upload of a language afterwards.
 * All data/dictionaries will be unloaded and devices closed.
 * A running job will be aborted and the job-queue deleted.</p>
 * Test requirement : "in progress"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReleaseDataResult;

/**
 * The abort error message of the method "ReleaseData"
 * <p>All language-dependent software and memory must be unitialized and
 * released as a preparative action befor an upload of a language afterwards.
 * All data/dictionaries will be unloaded and devices closed.
 * A running job will be aborted and the job-queue deleted.</p>
 * Test requirement : "in progress"
 */
typedef ::asf::cca::CcaTypes::DefaultError ReleaseDataAbortError;

/**
 * The result message of the method "SetVoice"
 * <p>Changes the voice of the TTS within the used language.</p>
 * Test requirement : "in progress"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetVoiceResult;

/**
 * The abort error message of the method "SetVoice"
 * <p>Changes the voice of the TTS within the used language.</p>
 * Test requirement : "in progress"
 */
typedef ::asf::cca::CcaTypes::DefaultError SetVoiceAbortError;

/**
 * The result message of the method "AbortPrompt"
 * <p>This Method provides an opportunity for the prompter, to stop the synthesis at a given point.
 * The job will be aborted and not continued at any time. The client will be informed.
 * If he want the synthesis to be done again, he has to start a new job.</p>
 * Test requirement : "partly test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AbortPromptResult;

/**
 * The abort error message of the method "AbortPrompt"
 * <p>This Method provides an opportunity for the prompter, to stop the synthesis at a given point.
 * The job will be aborted and not continued at any time. The client will be informed.
 * If he want the synthesis to be done again, he has to start a new job.</p>
 * Test requirement : "partly test"
 */
typedef ::asf::cca::CcaTypes::DefaultError AbortPromptAbortError;

/**
 * The result message of the method "PausePrompt"
 * <p>This Method provides an opportunity for the prompter, to pause the synthesis at a given point.
 * The job will be continued at the same point it has stopped, when the Method "ContinuePrompt" is used.</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PausePromptResult;

/**
 * The abort error message of the method "PausePrompt"
 * <p>This Method provides an opportunity for the prompter, to pause the synthesis at a given point.
 * The job will be continued at the same point it has stopped, when the Method "ContinuePrompt" is used.</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultError PausePromptAbortError;

/**
 * The result message of the method "ContinuePrompt"
 * <p>This Method is the corresponding one to the "PausePrompt"-Method
 * and to "AbortPrompt". The FC TTS will not do any synthesis, until
 * this method is used after an "AbortPromot" or "PausePrompt".</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ContinuePromptResult;

/**
 * The abort error message of the method "ContinuePrompt"
 * <p>This Method is the corresponding one to the "PausePrompt"-Method
 * and to "AbortPrompt". The FC TTS will not do any synthesis, until
 * this method is used after an "AbortPromot" or "PausePrompt".</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultError ContinuePromptAbortError;

/**
 * The result message of the method "AbortPromptWithExtension"
 * <p>This Method provides an opportunity for the prompter, to stop the synthesis at a given point.
 * The job will be aborted and not continued at any time. The client will be informed.
 * If he want the synthesis to be done again, he has to start a new job.</p>
 * Abort prompt which is started by SynthesizeSpeakWithExtension.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AbortPromptWithExtensionResult;

/**
 * The abort error message of the method "AbortPromptWithExtension"
 * <p>This Method provides an opportunity for the prompter, to stop the synthesis at a given point.
 * The job will be aborted and not continued at any time. The client will be informed.
 * If he want the synthesis to be done again, he has to start a new job.</p>
 * Abort prompt which is started by SynthesizeSpeakWithExtension.
 */
typedef ::asf::cca::CcaTypes::DefaultError AbortPromptWithExtensionAbortError;

/**
 * The result message of the method "PausePromptWithExtension"
 * <p>This Method provides an opportunity for the prompter, to pause the synthesis at a given point.
 * The job will be continued at the same point it has stopped, when the Method "ContinuePrompt" is used.</p>
 * Pause prompt which is started by SynthesizeSpeakWithExtension.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PausePromptWithExtensionResult;

/**
 * The abort error message of the method "PausePromptWithExtension"
 * <p>This Method provides an opportunity for the prompter, to pause the synthesis at a given point.
 * The job will be continued at the same point it has stopped, when the Method "ContinuePrompt" is used.</p>
 * Pause prompt which is started by SynthesizeSpeakWithExtension.
 */
typedef ::asf::cca::CcaTypes::DefaultError PausePromptWithExtensionAbortError;

/**
 * The result message of the method "ContinuePromptWithExtension"
 * <p>This Method is the corresponding one to the "PausePromptWithExtension"-Method.
 * The FC TTS will not do any synthesis, until "PausePromptWithExtension".</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ContinuePromptWithExtensionResult;

/**
 * The abort error message of the method "ContinuePromptWithExtension"
 * <p>This Method is the corresponding one to the "PausePromptWithExtension"-Method.
 * The FC TTS will not do any synthesis, until "PausePromptWithExtension".</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultError ContinuePromptWithExtensionAbortError;

/**
 * The abort error message of the method "RequestPhoneme"
 * <p>This Method is used to request a phoneme representation for the
 * given SourceText by means of database request (e.g. via FC_SDP)
 * according to the provided tagging (<dict>). The result combines the provided FileID (<file id=...>) with the phoneme representation in the PhonemeList</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestPhonemeAbortError;

/**
 * The result message of the method "LoadTuningFiles"
 * <p>This method is used by the client to request TTS to load the tuning for a particular domain by providing it.</p>
 * <p>On this request TTS shall only buffer the file paths and actual loading of these tuning files will be done only when the</p>
 * <p>SynthesizeSpeak request is received with correct domain</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LoadTuningFilesResult;

/**
 * The abort error message of the method "LoadTuningFiles"
 * <p>This method is used by the client to request TTS to load the tuning for a particular domain by providing it.</p>
 * <p>On this request TTS shall only buffer the file paths and actual loading of these tuning files will be done only when the</p>
 * <p>SynthesizeSpeak request is received with correct domain</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError LoadTuningFilesAbortError;

/**
 * The result message of the method "SetDefaultSpeechRate"
 * <p>Changes the speech rate of the Vocalizer Engine.</p>
 * <p>This method is internal to SDS only and should not be called by any external TTS clients !!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetDefaultSpeechRateResult;

/**
 * The abort error message of the method "SetDefaultSpeechRate"
 * <p>Changes the speech rate of the Vocalizer Engine.</p>
 * <p>This method is internal to SDS only and should not be called by any external TTS clients !!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SetDefaultSpeechRateAbortError;

/**
 * The error message of 'SetDefaultSpeechRate'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetDefaultSpeechRateError;

/**
 * The result message of the method "DoSynthesisForSpeak"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of the 2 not used parameters AudioOutputLocation and ExpDate).</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DoSynthesisForSpeakResult;

/**
 * The abort error message of the method "DoSynthesisForSpeak"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of the 2 not used parameters AudioOutputLocation and ExpDate).</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultError DoSynthesisForSpeakAbortError;

/**
 * The error message of 'DoSynthesisForSpeak'
 */
typedef ::asf::cca::CcaTypes::DefaultError DoSynthesisForSpeakError;

/**
 * The result message of the method "DoPrepareAudioOutput"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * This method is used to initiate all necessary steps to do an audio
 * output with the Audio output device (e.g. Open Device...).</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DoPrepareAudioOutputResult;

/**
 * The abort error message of the method "DoPrepareAudioOutput"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * This method is used to initiate all necessary steps to do an audio
 * output with the Audio output device (e.g. Open Device...).</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultError DoPrepareAudioOutputAbortError;

/**
 * The abort error message of the method "DoAudioOutputSpeak"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of not used parameters).</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultError DoAudioOutputSpeakAbortError;

/**
 * The error message of 'DoAudioOutputSpeak'
 */
typedef ::asf::cca::CcaTypes::DefaultError DoAudioOutputSpeakError;

/**
 * The start message of the method "DoUpRegToProperties"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * This method is used to inform all (work-)threads, that the
 * application is gone to normal. At this point, every Thread
 * has to register on the TTS-Properties, as they are organized
 * as membervariables of the MsgControlThread.</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DoUpRegToPropertiesStart;

/**
 * The result message of the method "DoUpRegToProperties"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * This method is used to inform all (work-)threads, that the
 * application is gone to normal. At this point, every Thread
 * has to register on the TTS-Properties, as they are organized
 * as membervariables of the MsgControlThread.</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DoUpRegToPropertiesResult;

/**
 * The abort error message of the method "DoUpRegToProperties"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * This method is used to inform all (work-)threads, that the
 * application is gone to normal. At this point, every Thread
 * has to register on the TTS-Properties, as they are organized
 * as membervariables of the MsgControlThread.</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultError DoUpRegToPropertiesAbortError;

/**
 * The error message of 'DoUpRegToProperties'
 */
typedef ::asf::cca::CcaTypes::DefaultError DoUpRegToPropertiesError;

/**
 * The result message of the method "DoSynthesisForWrite"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeWrite
 * (except of not used parameter ExpDate).</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DoSynthesisForWriteResult;

/**
 * The abort error message of the method "DoSynthesisForWrite"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeWrite
 * (except of not used parameter ExpDate).</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultError DoSynthesisForWriteAbortError;

/**
 * The error message of 'DoSynthesisForWrite'
 */
typedef ::asf::cca::CcaTypes::DefaultError DoSynthesisForWriteError;

/**
 * The abort error message of the method "DoAudioOutputWrite"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeWrite
 * (except of not used parameters).</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultError DoAudioOutputWriteAbortError;

/**
 * The error message of 'DoAudioOutputWrite'
 */
typedef ::asf::cca::CcaTypes::DefaultError DoAudioOutputWriteError;

/**
 * The result message of the method "DoSynthesisForSpeakWithExtention"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of the 2 not used parameters AudioOutputLocation and ExpDate).</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DoSynthesisForSpeakWithExtentionResult;

/**
 * The abort error message of the method "DoSynthesisForSpeakWithExtention"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of the 2 not used parameters AudioOutputLocation and ExpDate).</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultError DoSynthesisForSpeakWithExtentionAbortError;

/**
 * The error message of 'DoSynthesisForSpeakWithExtention'
 */
typedef ::asf::cca::CcaTypes::DefaultError DoSynthesisForSpeakWithExtentionError;

/**
 * The result message of the method "DoReleaseData"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method ReleaseData.</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DoReleaseDataResult;

/**
 * The abort error message of the method "DoReleaseData"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method ReleaseData.</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultError DoReleaseDataAbortError;

/**
 * The start message of the method "DoReleaseAudioDevice"
 * <p>Method for internal communication of FC TTS.
 * This method is called, if the audiodevice has already been opened and
 * set up for audio output and a PromptAbort came to the FC TTS in
 * the meantime.</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DoReleaseAudioDeviceStart;

/**
 * The result message of the method "DoReleaseAudioDevice"
 * <p>Method for internal communication of FC TTS.
 * This method is called, if the audiodevice has already been opened and
 * set up for audio output and a PromptAbort came to the FC TTS in
 * the meantime.</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DoReleaseAudioDeviceResult;

/**
 * The abort error message of the method "DoReleaseAudioDevice"
 * <p>Method for internal communication of FC TTS.
 * This method is called, if the audiodevice has already been opened and
 * set up for audio output and a PromptAbort came to the FC TTS in
 * the meantime.</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultError DoReleaseAudioDeviceAbortError;

/**
 * The error message of 'DoReleaseAudioDevice'
 */
typedef ::asf::cca::CcaTypes::DefaultError DoReleaseAudioDeviceError;

/**
 * The abort error message of the method "DoRequestPhoneme"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method ReleaseData.</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultError DoRequestPhonemeAbortError;

/**
 * The abort error message of the method "DoAudioOutputSpeakWithExtension"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of not used parameters).</p>
 * Test requirement : "no test"
 */
typedef ::asf::cca::CcaTypes::DefaultError DoAudioOutputSpeakWithExtensionAbortError;

/**
 * The error message of 'DoAudioOutputSpeakWithExtension'
 */
typedef ::asf::cca::CcaTypes::DefaultError DoAudioOutputSpeakWithExtensionError;

/**
 * The get message of the property "Voice"
 * <p>This property can be used to check, which voice is currently used. The type is defined by the
 * Speech Data Provider and contains information about language, country, gender and name of the voice.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoiceGet;

/**
 * The upreg message of the property "Voice"
 * <p>This property can be used to check, which voice is currently used. The type is defined by the
 * Speech Data Provider and contains information about language, country, gender and name of the voice.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoiceUpReg;

/**
 * The relUpReg message of the property "Voice"
 * <p>This property can be used to check, which voice is currently used. The type is defined by the
 * Speech Data Provider and contains information about language, country, gender and name of the voice.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoiceRelUpReg;

/**
 * The error message of 'Voice'
 */
typedef ::asf::cca::CcaTypes::DefaultError VoiceError;

/**
 * The get message of the property "AvailableVoices"
 * <p>This property can be used to check, which different voices are available for the used language</p>
 * Test requirement : "partly test"
 * This property will currenty only be filled with the content "0 voices available",
 * although the implementation of the property is complete (by concept).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AvailableVoicesGet;

/**
 * The upreg message of the property "AvailableVoices"
 * <p>This property can be used to check, which different voices are available for the used language</p>
 * Test requirement : "partly test"
 * This property will currenty only be filled with the content "0 voices available",
 * although the implementation of the property is complete (by concept).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AvailableVoicesUpReg;

/**
 * The relUpReg message of the property "AvailableVoices"
 * <p>This property can be used to check, which different voices are available for the used language</p>
 * Test requirement : "partly test"
 * This property will currenty only be filled with the content "0 voices available",
 * although the implementation of the property is complete (by concept).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AvailableVoicesRelUpReg;

/**
 * The error message of 'AvailableVoices'
 */
typedef ::asf::cca::CcaTypes::DefaultError AvailableVoicesError;

/**
 * The get message of the property "TTSVersionInfo"
 * <p>This property can be used to check, which tts-engine and which version of the tts-module is currently used/running.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TTSVersionInfoGet;

/**
 * The upreg message of the property "TTSVersionInfo"
 * <p>This property can be used to check, which tts-engine and which version of the tts-module is currently used/running.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TTSVersionInfoUpReg;

/**
 * The relUpReg message of the property "TTSVersionInfo"
 * <p>This property can be used to check, which tts-engine and which version of the tts-module is currently used/running.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TTSVersionInfoRelUpReg;

/**
 * The error message of 'TTSVersionInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError TTSVersionInfoError;

/**
 * The get message of the property "TTSStatus"
 * <p>This property can be used to check, in which status the tts-synthesis is.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TTSStatusGet;

/**
 * The upreg message of the property "TTSStatus"
 * <p>This property can be used to check, in which status the tts-synthesis is.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TTSStatusUpReg;

/**
 * The relUpReg message of the property "TTSStatus"
 * <p>This property can be used to check, in which status the tts-synthesis is.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TTSStatusRelUpReg;

/**
 * The error message of 'TTSStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError TTSStatusError;

/**
 * The get message of the property "DownloadComplete"
 * <p>The client is informed by this property about finishing of download.
 * After receiving ReleaseData for language change the FC TTS sets this property to FALSE.
 * FC VoiceControl forces the SDP via DownloadSDSLanguage to copy the new data from media (e.g. DVD or CD-ROM)
 * into  flash. After download complete and successfull the FC TTS sets this property to TRUE.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadCompleteGet;

/**
 * The upreg message of the property "DownloadComplete"
 * <p>The client is informed by this property about finishing of download.
 * After receiving ReleaseData for language change the FC TTS sets this property to FALSE.
 * FC VoiceControl forces the SDP via DownloadSDSLanguage to copy the new data from media (e.g. DVD or CD-ROM)
 * into  flash. After download complete and successfull the FC TTS sets this property to TRUE.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadCompleteUpReg;

/**
 * The relUpReg message of the property "DownloadComplete"
 * <p>The client is informed by this property about finishing of download.
 * After receiving ReleaseData for language change the FC TTS sets this property to FALSE.
 * FC VoiceControl forces the SDP via DownloadSDSLanguage to copy the new data from media (e.g. DVD or CD-ROM)
 * into  flash. After download complete and successfull the FC TTS sets this property to TRUE.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadCompleteRelUpReg;

/**
 * The upreg message of the property "TTSPlaybackSpacing"
 * <p>This property can be used to change the playback spacing.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TTSPlaybackSpacingUpReg;

/**
 * The relUpReg message of the property "TTSPlaybackSpacing"
 * <p>This property can be used to change the playback spacing.</p>
 * Test requirement : "full test"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TTSPlaybackSpacingRelUpReg;

/**
 * The error message of 'TTSPlaybackSpacing'
 */
typedef ::asf::cca::CcaTypes::DefaultError TTSPlaybackSpacingError;


/**
 * The start message of the method "SynthesizeSpeak"
 * <p>This method is used to synthesize text. The synthesised data
 * is played via the audiomanagement with the available dev/acousticout.
 * For every incoming job, the property "ChannelRequest" from the ACR_FI
 * is used to request the audiochannel from the AudioManagement. If the
 * AudioManagement sends back the method "VoiceAdvice" for the
 * corresponding job, the synthesis will be executed.</p>
 * Test requirement : "partly test"
 */
class SynthesizeSpeakStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SynthesizeSpeakStart ();

    /**
     * Copy constructor
     */
    inline  SynthesizeSpeakStart (const SynthesizeSpeakStart &rhs);

    /**
     * All fields constructor
     */
    inline  SynthesizeSpeakStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_, const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_, ::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_, uint32 ExpDate_, bool LastPackage_);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeSpeakStart();

    /**
     * Assignment operator
     */
    inline SynthesizeSpeakStart& operator = (const SynthesizeSpeakStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeSpeakStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeSpeakStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeSpeakStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeSpeakStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TextAndTags"

    static const int kTextAndTags = 0;

    /**
     * Clears the field "TextAndTags".
     *
     * The field will be set to its default value. The hasTextAndTags()
     * method will return false.
     */
    inline void clearTextAndTags();

    /**
     * Checks whether the field "TextAndTags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextAndTags()). Otherwise it will return false.
     */
    inline bool hasTextAndTags () const;

    /**
     * Returns the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionally,
     * tags can be used within the string to give some extra
     * information. The possible tags for this method are:
     * <p>the tag <rate=>specifies the rate of the synthesis to be used,</p>
     * <p>the tag <vol=> specifies the volume of the synthesis to be used.</p>
     * <p>The tag <ttsdom=> specifies the domain for which tuning files are to be loaded.
     * Possible values are: 0:none, 1:navi, 2:sds</p>
     * <p>Example: <ttsdom=navi></p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p></p>
     * Test requirement : "full test"
     *
     * @return The value of the field "TextAndTags"
     */
    inline const ::std::string& getTextAndTags () const;

    /**
     * Retrieves the value of the field "TextAndTags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TextAndTags".
     */
    inline ::std::string& getTextAndTagsMutable ();

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionally,
     * tags can be used within the string to give some extra
     * information. The possible tags for this method are:
     * <p>the tag <rate=>specifies the rate of the synthesis to be used,</p>
     * <p>the tag <vol=> specifies the volume of the synthesis to be used.</p>
     * <p>The tag <ttsdom=> specifies the domain for which tuning files are to be loaded.
     * Possible values are: 0:none, 1:navi, 2:sds</p>
     * <p>Example: <ttsdom=navi></p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p></p>
     * Test requirement : "full test"
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const ::std::string& TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionally,
     * tags can be used within the string to give some extra
     * information. The possible tags for this method are:
     * <p>the tag <rate=>specifies the rate of the synthesis to be used,</p>
     * <p>the tag <vol=> specifies the volume of the synthesis to be used.</p>
     * <p>The tag <ttsdom=> specifies the domain for which tuning files are to be loaded.
     * Possible values are: 0:none, 1:navi, 2:sds</p>
     * <p>Example: <ttsdom=navi></p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p></p>
     * Test requirement : "full test"
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionally,
     * tags can be used within the string to give some extra
     * information. The possible tags for this method are:
     * <p>the tag <rate=>specifies the rate of the synthesis to be used,</p>
     * <p>the tag <vol=> specifies the volume of the synthesis to be used.</p>
     * <p>The tag <ttsdom=> specifies the domain for which tuning files are to be loaded.
     * Possible values are: 0:none, 1:navi, 2:sds</p>
     * <p>Example: <ttsdom=navi></p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p></p>
     * Test requirement : "full test"
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* value, size_t size);

    // API of field "TextStyle"

    static const int kTextStyle = 1;

    /**
     * Clears the field "TextStyle".
     *
     * The field will be set to its default value. The hasTextStyle()
     * method will return false.
     */
    inline void clearTextStyle();

    /**
     * Checks whether the field "TextStyle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextStyle()). Otherwise it will return false.
     */
    inline bool hasTextStyle () const;

    /**
     * Returns the value of the member "TextStyle".
     *
     * <p>This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).</p>
     * Test requirement : "full test"
     *
     * @return The value of the field "TextStyle"
     */
    inline ::sds_tts_fi_types::T_e8_TextStyleOption getTextStyle () const;

    /**
     * Sets the value of the member "TextStyle".
     *
     * <p>This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).</p>
     * Test requirement : "full test"
     *
     * @param TextStyle The value which will be set
     */
    inline void setTextStyle (::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_);

    // API of field "AudioOutputLocation"

    static const int kAudioOutputLocation = 2;

    /**
     * Clears the field "AudioOutputLocation".
     *
     * The field will be set to its default value. The hasAudioOutputLocation()
     * method will return false.
     */
    inline void clearAudioOutputLocation();

    /**
     * Checks whether the field "AudioOutputLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioOutputLocation()). Otherwise it will return false.
     */
    inline bool hasAudioOutputLocation () const;

    /**
     * Returns the value of the member "AudioOutputLocation".
     *
     * <p>This parameter can be used to define the outputlocation.
     * This parameter may be used, if a client needs a playback at one
     * special outputlocation (e.g. if the synthesis of an email has
     * been haptically initiated for the rear-left-headphones).
     * The type is defined in the ACR_FI as a bitfield. Most of the time,
     * the standard=0 will be used.</p>
     * Test requirement : "no test"
     *
     * @return The value of the field "AudioOutputLocation"
     */
    inline const ::acr_fi_types::T_b8_AudioOutputLocation& getAudioOutputLocation () const;

    /**
     * Retrieves the value of the field "AudioOutputLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AudioOutputLocation".
     */
    inline ::acr_fi_types::T_b8_AudioOutputLocation& getAudioOutputLocationMutable ();

    /**
     * Sets the value of the member "AudioOutputLocation".
     *
     * <p>This parameter can be used to define the outputlocation.
     * This parameter may be used, if a client needs a playback at one
     * special outputlocation (e.g. if the synthesis of an email has
     * been haptically initiated for the rear-left-headphones).
     * The type is defined in the ACR_FI as a bitfield. Most of the time,
     * the standard=0 will be used.</p>
     * Test requirement : "no test"
     *
     * @param AudioOutputLocation The value which will be set
     */
    inline void setAudioOutputLocation (const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_);

    // API of field "StatusInfo"

    static const int kStatusInfo = 3;

    /**
     * Clears the field "StatusInfo".
     *
     * The field will be set to its default value. The hasStatusInfo()
     * method will return false.
     */
    inline void clearStatusInfo();

    /**
     * Checks whether the field "StatusInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusInfo()). Otherwise it will return false.
     */
    inline bool hasStatusInfo () const;

    /**
     * Returns the value of the member "StatusInfo".
     *
     * <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     * Test requirement : "full test"
     *
     * @return The value of the field "StatusInfo"
     */
    inline ::sds_tts_fi_types::T_e8_StatusInfoOption getStatusInfo () const;

    /**
     * Sets the value of the member "StatusInfo".
     *
     * <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     * Test requirement : "full test"
     *
     * @param StatusInfo The value which will be set
     */
    inline void setStatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_);

    // API of field "ExpDate"

    static const int kExpDate = 4;

    /**
     * Clears the field "ExpDate".
     *
     * The field will be set to its default value. The hasExpDate()
     * method will return false.
     */
    inline void clearExpDate();

    /**
     * Checks whether the field "ExpDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExpDate()). Otherwise it will return false.
     */
    inline bool hasExpDate () const;

    /**
     * Returns the value of the member "ExpDate".
     *
     * <p>Client defines the maximum last of the job in ms.
     * When the time has passed, the job will be deleted
     * from the queue and the client will be informed.</p>
     * <p>If a client uses the possibility to transmit jobs/strings in
     * multiple packages, only the exp. date of the first job will
     * be examined, as the expiration date referres to the start
     * of a job.</p>
     * Test requirement : "full test"
     *
     * @return The value of the field "ExpDate"
     */
    inline uint32 getExpDate () const;

    /**
     * Sets the value of the member "ExpDate".
     *
     * <p>Client defines the maximum last of the job in ms.
     * When the time has passed, the job will be deleted
     * from the queue and the client will be informed.</p>
     * <p>If a client uses the possibility to transmit jobs/strings in
     * multiple packages, only the exp. date of the first job will
     * be examined, as the expiration date referres to the start
     * of a job.</p>
     * Test requirement : "full test"
     *
     * @param ExpDate The value which will be set
     */
    inline void setExpDate (uint32 ExpDate_);

    // API of field "LastPackage"

    static const int kLastPackage = 5;

    /**
     * Clears the field "LastPackage".
     *
     * The field will be set to its default value. The hasLastPackage()
     * method will return false.
     */
    inline void clearLastPackage();

    /**
     * Checks whether the field "LastPackage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastPackage()). Otherwise it will return false.
     */
    inline bool hasLastPackage () const;

    /**
     * Returns the value of the member "LastPackage".
     *
     * <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue not sent at that time.
     * Already queued jobparts of this job will be deleted by the FC TTS.</p>
     * Test requirement : "no test"
     *
     * @return The value of the field "LastPackage"
     */
    inline bool getLastPackage () const;

    /**
     * Sets the value of the member "LastPackage".
     *
     * <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue not sent at that time.
     * Already queued jobparts of this job will be deleted by the FC TTS.</p>
     * Test requirement : "no test"
     *
     * @param LastPackage The value which will be set
     */
    inline void setLastPackage (bool LastPackage_);

    static const SynthesizeSpeakStart &getDefaultInstance();

private:

    inline void set_has_TextAndTags ();

    inline void clear_has_TextAndTags ();

    inline void set_has_TextStyle ();

    inline void clear_has_TextStyle ();

    inline void set_has_AudioOutputLocation ();

    inline void clear_has_AudioOutputLocation ();

    inline void set_has_StatusInfo ();

    inline void clear_has_StatusInfo ();

    inline void set_has_ExpDate ();

    inline void clear_has_ExpDate ();

    inline void set_has_LastPackage ();

    inline void clear_has_LastPackage ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::std::string _TextAndTags;

    ::sds_tts_fi_types::T_e8_TextStyleOption _TextStyle;

    ::acr_fi_types::T_b8_AudioOutputLocation _AudioOutputLocation;

    ::sds_tts_fi_types::T_e8_StatusInfoOption _StatusInfo;

    uint32 _ExpDate;

    bool _LastPackage;

};

/**
 * The result first message of the method "SynthesizeSpeak"
 * <p>This method is used to synthesize text. The synthesised data
 * is played via the audiomanagement with the available dev/acousticout.
 * For every incoming job, the property "ChannelRequest" from the ACR_FI
 * is used to request the audiochannel from the AudioManagement. If the
 * AudioManagement sends back the method "VoiceAdvice" for the
 * corresponding job, the synthesis will be executed.</p>
 * Test requirement : "partly test"
 */
class SynthesizeSpeakResultFirst  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SynthesizeSpeakResultFirst ();

    /**
     * Copy constructor
     */
    inline  SynthesizeSpeakResultFirst (const SynthesizeSpeakResultFirst &rhs);

    /**
     * All fields constructor
     */
    inline  SynthesizeSpeakResultFirst (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeSpeakResultFirst();

    /**
     * Assignment operator
     */
    inline SynthesizeSpeakResultFirst& operator = (const SynthesizeSpeakResultFirst& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeSpeakResultFirst& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeSpeakResultFirst& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeSpeakResultFirst& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeSpeakResultFirst& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobProgress"

    static const int kJobProgress = 0;

    /**
     * Clears the field "JobProgress".
     *
     * The field will be set to its default value. The hasJobProgress()
     * method will return false.
     */
    inline void clearJobProgress();

    /**
     * Checks whether the field "JobProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobProgress()). Otherwise it will return false.
     */
    inline bool hasJobProgress () const;

    /**
     * Returns the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus.</p>
     * <p>With this message, the client will be informed, that the job has been started,</p>
     * <p>even if he didn't want to be informed about the job progress.</p>
     * <p>If the job is not executed immediately (e.g. due to priority),
     * the client will be informed, that the job has been queued.</p>
     *
     * @return The value of the field "JobProgress"
     */
    inline const ::sds_tts_fi_types::T_SpeakProgress& getJobProgress () const;

    /**
     * Retrieves the value of the field "JobProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JobProgress".
     */
    inline ::sds_tts_fi_types::T_SpeakProgress& getJobProgressMutable ();

    /**
     * Sets the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus.</p>
     * <p>With this message, the client will be informed, that the job has been started,</p>
     * <p>even if he didn't want to be informed about the job progress.</p>
     * <p>If the job is not executed immediately (e.g. due to priority),
     * the client will be informed, that the job has been queued.</p>
     *
     * @param JobProgress The value which will be set
     */
    inline void setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    static const SynthesizeSpeakResultFirst &getDefaultInstance();

private:

    inline void set_has_JobProgress ();

    inline void clear_has_JobProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_SpeakProgress _JobProgress;

};

/**
 * The result middle message of the method "SynthesizeSpeak"
 * <p>This method is used to synthesize text. The synthesised data
 * is played via the audiomanagement with the available dev/acousticout.
 * For every incoming job, the property "ChannelRequest" from the ACR_FI
 * is used to request the audiochannel from the AudioManagement. If the
 * AudioManagement sends back the method "VoiceAdvice" for the
 * corresponding job, the synthesis will be executed.</p>
 * Test requirement : "partly test"
 */
class SynthesizeSpeakResultMiddle  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SynthesizeSpeakResultMiddle ();

    /**
     * Copy constructor
     */
    inline  SynthesizeSpeakResultMiddle (const SynthesizeSpeakResultMiddle &rhs);

    /**
     * All fields constructor
     */
    inline  SynthesizeSpeakResultMiddle (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeSpeakResultMiddle();

    /**
     * Assignment operator
     */
    inline SynthesizeSpeakResultMiddle& operator = (const SynthesizeSpeakResultMiddle& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeSpeakResultMiddle& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeSpeakResultMiddle& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeSpeakResultMiddle& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeSpeakResultMiddle& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobProgress"

    static const int kJobProgress = 0;

    /**
     * Clears the field "JobProgress".
     *
     * The field will be set to its default value. The hasJobProgress()
     * method will return false.
     */
    inline void clearJobProgress();

    /**
     * Checks whether the field "JobProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobProgress()). Otherwise it will return false.
     */
    inline bool hasJobProgress () const;

    /**
     * Returns the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / progress of synthesis.</p>
     * <p>If the job has been queued before (e.g. due to priority), now the client
     * will be informed, that the job has been started now.</p>
     *
     * @return The value of the field "JobProgress"
     */
    inline const ::sds_tts_fi_types::T_SpeakProgress& getJobProgress () const;

    /**
     * Retrieves the value of the field "JobProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JobProgress".
     */
    inline ::sds_tts_fi_types::T_SpeakProgress& getJobProgressMutable ();

    /**
     * Sets the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / progress of synthesis.</p>
     * <p>If the job has been queued before (e.g. due to priority), now the client
     * will be informed, that the job has been started now.</p>
     *
     * @param JobProgress The value which will be set
     */
    inline void setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    static const SynthesizeSpeakResultMiddle &getDefaultInstance();

private:

    inline void set_has_JobProgress ();

    inline void clear_has_JobProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_SpeakProgress _JobProgress;

};

/**
 * The result last message of the method "SynthesizeSpeak"
 * <p>This method is used to synthesize text. The synthesised data
 * is played via the audiomanagement with the available dev/acousticout.
 * For every incoming job, the property "ChannelRequest" from the ACR_FI
 * is used to request the audiochannel from the AudioManagement. If the
 * AudioManagement sends back the method "VoiceAdvice" for the
 * corresponding job, the synthesis will be executed.</p>
 * Test requirement : "partly test"
 */
class SynthesizeSpeakResultLast  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SynthesizeSpeakResultLast ();

    /**
     * Copy constructor
     */
    inline  SynthesizeSpeakResultLast (const SynthesizeSpeakResultLast &rhs);

    /**
     * All fields constructor
     */
    inline  SynthesizeSpeakResultLast (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeSpeakResultLast();

    /**
     * Assignment operator
     */
    inline SynthesizeSpeakResultLast& operator = (const SynthesizeSpeakResultLast& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeSpeakResultLast& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeSpeakResultLast& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeSpeakResultLast& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeSpeakResultLast& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobProgress"

    static const int kJobProgress = 0;

    /**
     * Clears the field "JobProgress".
     *
     * The field will be set to its default value. The hasJobProgress()
     * method will return false.
     */
    inline void clearJobProgress();

    /**
     * Checks whether the field "JobProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobProgress()). Otherwise it will return false.
     */
    inline bool hasJobProgress () const;

    /**
     * Returns the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / number of spoken words or sentences.</p>
     * <p>With this message, the client will be informed, that the job has been finished,</p>
     * <p>even if he didn't want to be informed about the job progress.</p>
     *
     * @return The value of the field "JobProgress"
     */
    inline const ::sds_tts_fi_types::T_SpeakProgress& getJobProgress () const;

    /**
     * Retrieves the value of the field "JobProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JobProgress".
     */
    inline ::sds_tts_fi_types::T_SpeakProgress& getJobProgressMutable ();

    /**
     * Sets the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / number of spoken words or sentences.</p>
     * <p>With this message, the client will be informed, that the job has been finished,</p>
     * <p>even if he didn't want to be informed about the job progress.</p>
     *
     * @param JobProgress The value which will be set
     */
    inline void setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    static const SynthesizeSpeakResultLast &getDefaultInstance();

private:

    inline void set_has_JobProgress ();

    inline void clear_has_JobProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_SpeakProgress _JobProgress;

};

/**
 * The error message of 'SynthesizeSpeak'
 */
class SynthesizeSpeakError  : public ::asf::core::Payload {
public:

    enum SynthesizeSpeakErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SynthesizeSpeakError ();

   /**
     * Copy constructor
     */
    inline  SynthesizeSpeakError (const SynthesizeSpeakError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeSpeakError();

    /**
     * Assigns a new value to this object.
     */
    inline SynthesizeSpeakError& operator = (const SynthesizeSpeakError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeSpeakError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeSpeakError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeSpeakError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeSpeakError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SynthesizeSpeakError::SynthesizeSpeakErrorField getField () const;

    inline void setField(SynthesizeSpeakError::SynthesizeSpeakErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SynthesizeSpeakErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SynthesizeSpeakErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline SynthesizeSpeakErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SynthesizeSpeakErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (SynthesizeSpeakErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SynthesizeSpeakError &getDefaultInstance();

private:

    inline void cloneData (const SynthesizeSpeakError& rhs);

    inline void deleteData ();

    SynthesizeSpeakErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SynthesizeWrite"
 * <p>This method is used to synthesize text and to write it into buffers.
 * The buffers will be written to shared memory and the path is transmitted to the client.
 * The jobs are listed in a queue without any priority (at the moment).
 * The jobs in the list will be synthesized in FIFO fashion.</p>
 * Test requirement : "partly test"
 */
class SynthesizeWriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SynthesizeWriteStart ();

    /**
     * Copy constructor
     */
    inline  SynthesizeWriteStart (const SynthesizeWriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  SynthesizeWriteStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_, ::sds_tts_fi_types::T_e8_BufferingOption Buffering_, uint32 ExpDate_, bool LastPackage_, const ::acr_fi_types::T_b8_AudioFormat& Compression_);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeWriteStart();

    /**
     * Assignment operator
     */
    inline SynthesizeWriteStart& operator = (const SynthesizeWriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeWriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeWriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeWriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeWriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TextAndTags"

    static const int kTextAndTags = 0;

    /**
     * Clears the field "TextAndTags".
     *
     * The field will be set to its default value. The hasTextAndTags()
     * method will return false.
     */
    inline void clearTextAndTags();

    /**
     * Checks whether the field "TextAndTags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextAndTags()). Otherwise it will return false.
     */
    inline bool hasTextAndTags () const;

    /**
     * Returns the value of the member "TextAndTags".
     *
     * <p>In addition to the design of this string and the rate,vol and dict tags described in the SynthesizeSpeak-Method,
     * this method has one more tag <file>
     * The  tag <file id=...>Text</file> indicates, what parts of the string must be synthesized and saved to shared memory.
     * Only the Text between the <file id=...>Text</file> will be synthesized.
     * The (client-specific) ID within the file-tag is transmitted by the client and will be sent back with the MethodResult.</p>
     * Test requirement : "full test"
     *
     * @return The value of the field "TextAndTags"
     */
    inline const ::std::string& getTextAndTags () const;

    /**
     * Retrieves the value of the field "TextAndTags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TextAndTags".
     */
    inline ::std::string& getTextAndTagsMutable ();

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>In addition to the design of this string and the rate,vol and dict tags described in the SynthesizeSpeak-Method,
     * this method has one more tag <file>
     * The  tag <file id=...>Text</file> indicates, what parts of the string must be synthesized and saved to shared memory.
     * Only the Text between the <file id=...>Text</file> will be synthesized.
     * The (client-specific) ID within the file-tag is transmitted by the client and will be sent back with the MethodResult.</p>
     * Test requirement : "full test"
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const ::std::string& TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>In addition to the design of this string and the rate,vol and dict tags described in the SynthesizeSpeak-Method,
     * this method has one more tag <file>
     * The  tag <file id=...>Text</file> indicates, what parts of the string must be synthesized and saved to shared memory.
     * Only the Text between the <file id=...>Text</file> will be synthesized.
     * The (client-specific) ID within the file-tag is transmitted by the client and will be sent back with the MethodResult.</p>
     * Test requirement : "full test"
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>In addition to the design of this string and the rate,vol and dict tags described in the SynthesizeSpeak-Method,
     * this method has one more tag <file>
     * The  tag <file id=...>Text</file> indicates, what parts of the string must be synthesized and saved to shared memory.
     * Only the Text between the <file id=...>Text</file> will be synthesized.
     * The (client-specific) ID within the file-tag is transmitted by the client and will be sent back with the MethodResult.</p>
     * Test requirement : "full test"
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* value, size_t size);

    // API of field "TextStyle"

    static const int kTextStyle = 1;

    /**
     * Clears the field "TextStyle".
     *
     * The field will be set to its default value. The hasTextStyle()
     * method will return false.
     */
    inline void clearTextStyle();

    /**
     * Checks whether the field "TextStyle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextStyle()). Otherwise it will return false.
     */
    inline bool hasTextStyle () const;

    /**
     * Returns the value of the member "TextStyle".
     *
     * <p>This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).</p>
     * Test requirement : "full test"
     *
     * @return The value of the field "TextStyle"
     */
    inline ::sds_tts_fi_types::T_e8_TextStyleOption getTextStyle () const;

    /**
     * Sets the value of the member "TextStyle".
     *
     * <p>This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).</p>
     * Test requirement : "full test"
     *
     * @param TextStyle The value which will be set
     */
    inline void setTextStyle (::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_);

    // API of field "Buffering"

    static const int kBuffering = 2;

    /**
     * Clears the field "Buffering".
     *
     * The field will be set to its default value. The hasBuffering()
     * method will return false.
     */
    inline void clearBuffering();

    /**
     * Checks whether the field "Buffering" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBuffering()). Otherwise it will return false.
     */
    inline bool hasBuffering () const;

    /**
     * Returns the value of the member "Buffering".
     *
     * <p>Defines the mode, how the client wants a file-block to be transmitted. At the time, two different
     * options are designed: Write one file-block to one buffer or write one file-block to multiple buffers of a defined size.
     * The size of this buffer is defined in the registry.</p>
     * Test requirement : "partly test"
     *
     * @return The value of the field "Buffering"
     */
    inline ::sds_tts_fi_types::T_e8_BufferingOption getBuffering () const;

    /**
     * Sets the value of the member "Buffering".
     *
     * <p>Defines the mode, how the client wants a file-block to be transmitted. At the time, two different
     * options are designed: Write one file-block to one buffer or write one file-block to multiple buffers of a defined size.
     * The size of this buffer is defined in the registry.</p>
     * Test requirement : "partly test"
     *
     * @param Buffering The value which will be set
     */
    inline void setBuffering (::sds_tts_fi_types::T_e8_BufferingOption Buffering_);

    // API of field "ExpDate"

    static const int kExpDate = 3;

    /**
     * Clears the field "ExpDate".
     *
     * The field will be set to its default value. The hasExpDate()
     * method will return false.
     */
    inline void clearExpDate();

    /**
     * Checks whether the field "ExpDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExpDate()). Otherwise it will return false.
     */
    inline bool hasExpDate () const;

    /**
     * Returns the value of the member "ExpDate".
     *
     * <p>Client defines the maximum last of the job in ms.
     * When the time has passed, the job will be deleted from the queue and the client will be informed.</p>
     * Test requirement : "no test"
     *
     * @return The value of the field "ExpDate"
     */
    inline uint32 getExpDate () const;

    /**
     * Sets the value of the member "ExpDate".
     *
     * <p>Client defines the maximum last of the job in ms.
     * When the time has passed, the job will be deleted from the queue and the client will be informed.</p>
     * Test requirement : "no test"
     *
     * @param ExpDate The value which will be set
     */
    inline void setExpDate (uint32 ExpDate_);

    // API of field "LastPackage"

    static const int kLastPackage = 4;

    /**
     * Clears the field "LastPackage".
     *
     * The field will be set to its default value. The hasLastPackage()
     * method will return false.
     */
    inline void clearLastPackage();

    /**
     * Checks whether the field "LastPackage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastPackage()). Otherwise it will return false.
     */
    inline bool hasLastPackage () const;

    /**
     * Returns the value of the member "LastPackage".
     *
     * <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue.</p>
     * Test requirement : "no test"
     *
     * @return The value of the field "LastPackage"
     */
    inline bool getLastPackage () const;

    /**
     * Sets the value of the member "LastPackage".
     *
     * <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue.</p>
     * Test requirement : "no test"
     *
     * @param LastPackage The value which will be set
     */
    inline void setLastPackage (bool LastPackage_);

    // API of field "Compression"

    static const int kCompression = 5;

    /**
     * Clears the field "Compression".
     *
     * The field will be set to its default value. The hasCompression()
     * method will return false.
     */
    inline void clearCompression();

    /**
     * Checks whether the field "Compression" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCompression()). Otherwise it will return false.
     */
    inline bool hasCompression () const;

    /**
     * Returns the value of the member "Compression".
     *
     * <p>Kind of audio format to be used.</p>
     * Test requirement : "full test"
     *
     * @return The value of the field "Compression"
     */
    inline const ::acr_fi_types::T_b8_AudioFormat& getCompression () const;

    /**
     * Retrieves the value of the field "Compression" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Compression".
     */
    inline ::acr_fi_types::T_b8_AudioFormat& getCompressionMutable ();

    /**
     * Sets the value of the member "Compression".
     *
     * <p>Kind of audio format to be used.</p>
     * Test requirement : "full test"
     *
     * @param Compression The value which will be set
     */
    inline void setCompression (const ::acr_fi_types::T_b8_AudioFormat& Compression_);

    static const SynthesizeWriteStart &getDefaultInstance();

private:

    inline void set_has_TextAndTags ();

    inline void clear_has_TextAndTags ();

    inline void set_has_TextStyle ();

    inline void clear_has_TextStyle ();

    inline void set_has_Buffering ();

    inline void clear_has_Buffering ();

    inline void set_has_ExpDate ();

    inline void clear_has_ExpDate ();

    inline void set_has_LastPackage ();

    inline void clear_has_LastPackage ();

    inline void set_has_Compression ();

    inline void clear_has_Compression ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::std::string _TextAndTags;

    ::sds_tts_fi_types::T_e8_TextStyleOption _TextStyle;

    ::sds_tts_fi_types::T_e8_BufferingOption _Buffering;

    uint32 _ExpDate;

    bool _LastPackage;

    ::acr_fi_types::T_b8_AudioFormat _Compression;

};

/**
 * The result first message of the method "SynthesizeWrite"
 * <p>This method is used to synthesize text and to write it into buffers.
 * The buffers will be written to shared memory and the path is transmitted to the client.
 * The jobs are listed in a queue without any priority (at the moment).
 * The jobs in the list will be synthesized in FIFO fashion.</p>
 * Test requirement : "partly test"
 */
class SynthesizeWriteResultFirst  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SynthesizeWriteResultFirst ();

    /**
     * Copy constructor
     */
    inline  SynthesizeWriteResultFirst (const SynthesizeWriteResultFirst &rhs);

    /**
     * All fields constructor
     */
    inline  SynthesizeWriteResultFirst (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeWriteResultFirst();

    /**
     * Assignment operator
     */
    inline SynthesizeWriteResultFirst& operator = (const SynthesizeWriteResultFirst& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeWriteResultFirst& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeWriteResultFirst& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeWriteResultFirst& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeWriteResultFirst& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BufferingProgress"

    static const int kBufferingProgress = 0;

    /**
     * Clears the field "BufferingProgress".
     *
     * The field will be set to its default value. The hasBufferingProgress()
     * method will return false.
     */
    inline void clearBufferingProgress();

    /**
     * Checks whether the field "BufferingProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBufferingProgress()). Otherwise it will return false.
     */
    inline bool hasBufferingProgress () const;

    /**
     * Returns the value of the member "BufferingProgress".
     *
     * <p>Feedback to the client about the jobstatus and the location of the buffers.</p>
     * <p>List of basetype is necessary due to the usage of the streaming-mechanism.</p>
     *
     * @return The value of the field "BufferingProgress"
     */
    inline const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getBufferingProgress () const;

    /**
     * Retrieves the value of the field "BufferingProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BufferingProgress".
     */
    inline ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getBufferingProgressMutable ();

    /**
     * Sets the value of the member "BufferingProgress".
     *
     * <p>Feedback to the client about the jobstatus and the location of the buffers.</p>
     * <p>List of basetype is necessary due to the usage of the streaming-mechanism.</p>
     *
     * @param BufferingProgress The value which will be set
     */
    inline void setBufferingProgress (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_);

    static const SynthesizeWriteResultFirst &getDefaultInstance();

private:

    static const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getT_BufferingProgressList_DefaultInstance ();

    inline void set_has_BufferingProgress ();

    inline void clear_has_BufferingProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sds_tts_fi_types::T_BufferingProgress > _BufferingProgress;

};

/**
 * The result middle message of the method "SynthesizeWrite"
 * <p>This method is used to synthesize text and to write it into buffers.
 * The buffers will be written to shared memory and the path is transmitted to the client.
 * The jobs are listed in a queue without any priority (at the moment).
 * The jobs in the list will be synthesized in FIFO fashion.</p>
 * Test requirement : "partly test"
 */
class SynthesizeWriteResultMiddle  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SynthesizeWriteResultMiddle ();

    /**
     * Copy constructor
     */
    inline  SynthesizeWriteResultMiddle (const SynthesizeWriteResultMiddle &rhs);

    /**
     * All fields constructor
     */
    inline  SynthesizeWriteResultMiddle (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeWriteResultMiddle();

    /**
     * Assignment operator
     */
    inline SynthesizeWriteResultMiddle& operator = (const SynthesizeWriteResultMiddle& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeWriteResultMiddle& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeWriteResultMiddle& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeWriteResultMiddle& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeWriteResultMiddle& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BufferingProgress"

    static const int kBufferingProgress = 0;

    /**
     * Clears the field "BufferingProgress".
     *
     * The field will be set to its default value. The hasBufferingProgress()
     * method will return false.
     */
    inline void clearBufferingProgress();

    /**
     * Checks whether the field "BufferingProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBufferingProgress()). Otherwise it will return false.
     */
    inline bool hasBufferingProgress () const;

    /**
     * Returns the value of the member "BufferingProgress".
     *
     * <p>Feedback to the client about the jobstatus and the location of the buffers.</p>
     * <p>List of basetype is necessary due to the usage of the streaming-mechanism.</p>
     *
     * @return The value of the field "BufferingProgress"
     */
    inline const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getBufferingProgress () const;

    /**
     * Retrieves the value of the field "BufferingProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BufferingProgress".
     */
    inline ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getBufferingProgressMutable ();

    /**
     * Sets the value of the member "BufferingProgress".
     *
     * <p>Feedback to the client about the jobstatus and the location of the buffers.</p>
     * <p>List of basetype is necessary due to the usage of the streaming-mechanism.</p>
     *
     * @param BufferingProgress The value which will be set
     */
    inline void setBufferingProgress (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_);

    static const SynthesizeWriteResultMiddle &getDefaultInstance();

private:

    static const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getT_BufferingProgressList_DefaultInstance ();

    inline void set_has_BufferingProgress ();

    inline void clear_has_BufferingProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sds_tts_fi_types::T_BufferingProgress > _BufferingProgress;

};

/**
 * The result last message of the method "SynthesizeWrite"
 * <p>This method is used to synthesize text and to write it into buffers.
 * The buffers will be written to shared memory and the path is transmitted to the client.
 * The jobs are listed in a queue without any priority (at the moment).
 * The jobs in the list will be synthesized in FIFO fashion.</p>
 * Test requirement : "partly test"
 */
class SynthesizeWriteResultLast  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SynthesizeWriteResultLast ();

    /**
     * Copy constructor
     */
    inline  SynthesizeWriteResultLast (const SynthesizeWriteResultLast &rhs);

    /**
     * All fields constructor
     */
    inline  SynthesizeWriteResultLast (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeWriteResultLast();

    /**
     * Assignment operator
     */
    inline SynthesizeWriteResultLast& operator = (const SynthesizeWriteResultLast& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeWriteResultLast& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeWriteResultLast& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeWriteResultLast& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeWriteResultLast& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BufferingProgress"

    static const int kBufferingProgress = 0;

    /**
     * Clears the field "BufferingProgress".
     *
     * The field will be set to its default value. The hasBufferingProgress()
     * method will return false.
     */
    inline void clearBufferingProgress();

    /**
     * Checks whether the field "BufferingProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBufferingProgress()). Otherwise it will return false.
     */
    inline bool hasBufferingProgress () const;

    /**
     * Returns the value of the member "BufferingProgress".
     *
     * <p>Feedback to the client about the jobstatus and the location of the buffers.</p>
     * <p>List of basetype is necessary due to the usage of the streaming-mechanism.</p>
     *
     * @return The value of the field "BufferingProgress"
     */
    inline const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getBufferingProgress () const;

    /**
     * Retrieves the value of the field "BufferingProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BufferingProgress".
     */
    inline ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getBufferingProgressMutable ();

    /**
     * Sets the value of the member "BufferingProgress".
     *
     * <p>Feedback to the client about the jobstatus and the location of the buffers.</p>
     * <p>List of basetype is necessary due to the usage of the streaming-mechanism.</p>
     *
     * @param BufferingProgress The value which will be set
     */
    inline void setBufferingProgress (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_);

    static const SynthesizeWriteResultLast &getDefaultInstance();

private:

    static const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getT_BufferingProgressList_DefaultInstance ();

    inline void set_has_BufferingProgress ();

    inline void clear_has_BufferingProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sds_tts_fi_types::T_BufferingProgress > _BufferingProgress;

};

/**
 * The error message of 'SynthesizeWrite'
 */
class SynthesizeWriteError  : public ::asf::core::Payload {
public:

    enum SynthesizeWriteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SynthesizeWriteError ();

   /**
     * Copy constructor
     */
    inline  SynthesizeWriteError (const SynthesizeWriteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeWriteError();

    /**
     * Assigns a new value to this object.
     */
    inline SynthesizeWriteError& operator = (const SynthesizeWriteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeWriteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeWriteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeWriteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeWriteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SynthesizeWriteError::SynthesizeWriteErrorField getField () const;

    inline void setField(SynthesizeWriteError::SynthesizeWriteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SynthesizeWriteErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SynthesizeWriteErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline SynthesizeWriteErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SynthesizeWriteErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (SynthesizeWriteErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SynthesizeWriteError &getDefaultInstance();

private:

    inline void cloneData (const SynthesizeWriteError& rhs);

    inline void deleteData ();

    SynthesizeWriteErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SynthesizeSpeakWithExtension"
 * <p>This method is used to synthesize text. The synthesised data
 * is played via the audiomanagement with the available dev/acousticout.
 * SDS will request the audio channel from the AudioManagement. In case that AM
 * doesn't assign the channel , an error will be returned</p>
 * Test requirement : "partly test"
 */
class SynthesizeSpeakWithExtensionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SynthesizeSpeakWithExtensionStart ();

    /**
     * Copy constructor
     */
    inline  SynthesizeSpeakWithExtensionStart (const SynthesizeSpeakWithExtensionStart &rhs);

    /**
     * All fields constructor
     */
    inline  SynthesizeSpeakWithExtensionStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_AudioSourceID TextStyle_, const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_, const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_, ::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_, uint32 ExpDate_, bool LastPackage_, uint8 Index_, ::sds_tts_fi_types::T_e8SequenceCategory SpeechSequence_);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeSpeakWithExtensionStart();

    /**
     * Assignment operator
     */
    inline SynthesizeSpeakWithExtensionStart& operator = (const SynthesizeSpeakWithExtensionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeSpeakWithExtensionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeSpeakWithExtensionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeSpeakWithExtensionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeSpeakWithExtensionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TextAndTags"

    static const int kTextAndTags = 0;

    /**
     * Clears the field "TextAndTags".
     *
     * The field will be set to its default value. The hasTextAndTags()
     * method will return false.
     */
    inline void clearTextAndTags();

    /**
     * Checks whether the field "TextAndTags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextAndTags()). Otherwise it will return false.
     */
    inline bool hasTextAndTags () const;

    /**
     * Returns the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionally,
     * tags can be used within the string to give some extra
     * information. The possible tags for this method are:
     * <p>the tag <rate=>specifies the rate of the synthesis to be used,</p>
     * <p>the tag <vol=> specifies the volume of the synthesis to be used.</p>
     * <p>The tag <ttsdom=> specifies the domain for which tuning files are to be loaded.
     * Possible values are: 0:none, 1:navi, 2:sds</p>
     * <p>Example: <ttsdom=navi></p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p></p>
     * Test requirement : "full test"
     *
     * @return The value of the field "TextAndTags"
     */
    inline const ::std::string& getTextAndTags () const;

    /**
     * Retrieves the value of the field "TextAndTags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TextAndTags".
     */
    inline ::std::string& getTextAndTagsMutable ();

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionally,
     * tags can be used within the string to give some extra
     * information. The possible tags for this method are:
     * <p>the tag <rate=>specifies the rate of the synthesis to be used,</p>
     * <p>the tag <vol=> specifies the volume of the synthesis to be used.</p>
     * <p>The tag <ttsdom=> specifies the domain for which tuning files are to be loaded.
     * Possible values are: 0:none, 1:navi, 2:sds</p>
     * <p>Example: <ttsdom=navi></p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p></p>
     * Test requirement : "full test"
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const ::std::string& TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionally,
     * tags can be used within the string to give some extra
     * information. The possible tags for this method are:
     * <p>the tag <rate=>specifies the rate of the synthesis to be used,</p>
     * <p>the tag <vol=> specifies the volume of the synthesis to be used.</p>
     * <p>The tag <ttsdom=> specifies the domain for which tuning files are to be loaded.
     * Possible values are: 0:none, 1:navi, 2:sds</p>
     * <p>Example: <ttsdom=navi></p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p></p>
     * Test requirement : "full test"
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionally,
     * tags can be used within the string to give some extra
     * information. The possible tags for this method are:
     * <p>the tag <rate=>specifies the rate of the synthesis to be used,</p>
     * <p>the tag <vol=> specifies the volume of the synthesis to be used.</p>
     * <p>The tag <ttsdom=> specifies the domain for which tuning files are to be loaded.
     * Possible values are: 0:none, 1:navi, 2:sds</p>
     * <p>Example: <ttsdom=navi></p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p></p>
     * Test requirement : "full test"
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* value, size_t size);

    // API of field "TextStyle"

    static const int kTextStyle = 1;

    /**
     * Clears the field "TextStyle".
     *
     * The field will be set to its default value. The hasTextStyle()
     * method will return false.
     */
    inline void clearTextStyle();

    /**
     * Checks whether the field "TextStyle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextStyle()). Otherwise it will return false.
     */
    inline bool hasTextStyle () const;

    /**
     * Returns the value of the member "TextStyle".
     *
     * <p>This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).</p>
     * Test requirement : "full test"
     *
     * @return The value of the field "TextStyle"
     */
    inline ::sds_tts_fi_types::T_e8_AudioSourceID getTextStyle () const;

    /**
     * Sets the value of the member "TextStyle".
     *
     * <p>This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).</p>
     * Test requirement : "full test"
     *
     * @param TextStyle The value which will be set
     */
    inline void setTextStyle (::sds_tts_fi_types::T_e8_AudioSourceID TextStyle_);

    // API of field "LanguageID"

    static const int kLanguageID = 2;

    /**
     * Clears the field "LanguageID".
     *
     * The field will be set to its default value. The hasLanguageID()
     * method will return false.
     */
    inline void clearLanguageID();

    /**
     * Checks whether the field "LanguageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageID()). Otherwise it will return false.
     */
    inline bool hasLanguageID () const;

    /**
     * Returns the value of the member "LanguageID".
     *
     * <p>The languagecode which text presents.The method re-
     * turns error if the language code is not identical with the
     * one which SDS uses.</p>
     *
     * @return The value of the field "LanguageID"
     */
    inline const ::sds_sds2hmi_common_types::T_SDSLanguageID& getLanguageID () const;

    /**
     * Retrieves the value of the field "LanguageID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LanguageID".
     */
    inline ::sds_sds2hmi_common_types::T_SDSLanguageID& getLanguageIDMutable ();

    /**
     * Sets the value of the member "LanguageID".
     *
     * <p>The languagecode which text presents.The method re-
     * turns error if the language code is not identical with the
     * one which SDS uses.</p>
     *
     * @param LanguageID The value which will be set
     */
    inline void setLanguageID (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_);

    // API of field "AudioOutputLocation"

    static const int kAudioOutputLocation = 3;

    /**
     * Clears the field "AudioOutputLocation".
     *
     * The field will be set to its default value. The hasAudioOutputLocation()
     * method will return false.
     */
    inline void clearAudioOutputLocation();

    /**
     * Checks whether the field "AudioOutputLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioOutputLocation()). Otherwise it will return false.
     */
    inline bool hasAudioOutputLocation () const;

    /**
     * Returns the value of the member "AudioOutputLocation".
     *
     * <p>This parameter can be used to define the outputlocation.
     * This parameter may be used, if a client needs a playback at one
     * special outputlocation (e.g. if the synthesis of an email has
     * been haptically initiated for the rear-left-headphones).
     * The type is defined in the ACR_FI as a bitfield. Most of the time,
     * the standard=0 will be used.</p>
     * Test requirement : "no test"
     *
     * @return The value of the field "AudioOutputLocation"
     */
    inline const ::acr_fi_types::T_b8_AudioOutputLocation& getAudioOutputLocation () const;

    /**
     * Retrieves the value of the field "AudioOutputLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AudioOutputLocation".
     */
    inline ::acr_fi_types::T_b8_AudioOutputLocation& getAudioOutputLocationMutable ();

    /**
     * Sets the value of the member "AudioOutputLocation".
     *
     * <p>This parameter can be used to define the outputlocation.
     * This parameter may be used, if a client needs a playback at one
     * special outputlocation (e.g. if the synthesis of an email has
     * been haptically initiated for the rear-left-headphones).
     * The type is defined in the ACR_FI as a bitfield. Most of the time,
     * the standard=0 will be used.</p>
     * Test requirement : "no test"
     *
     * @param AudioOutputLocation The value which will be set
     */
    inline void setAudioOutputLocation (const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_);

    // API of field "StatusInfo"

    static const int kStatusInfo = 4;

    /**
     * Clears the field "StatusInfo".
     *
     * The field will be set to its default value. The hasStatusInfo()
     * method will return false.
     */
    inline void clearStatusInfo();

    /**
     * Checks whether the field "StatusInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusInfo()). Otherwise it will return false.
     */
    inline bool hasStatusInfo () const;

    /**
     * Returns the value of the member "StatusInfo".
     *
     * <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     * Test requirement : "full test"
     *
     * @return The value of the field "StatusInfo"
     */
    inline ::sds_tts_fi_types::T_e8_StatusInfoOption getStatusInfo () const;

    /**
     * Sets the value of the member "StatusInfo".
     *
     * <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     * Test requirement : "full test"
     *
     * @param StatusInfo The value which will be set
     */
    inline void setStatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_);

    // API of field "ExpDate"

    static const int kExpDate = 5;

    /**
     * Clears the field "ExpDate".
     *
     * The field will be set to its default value. The hasExpDate()
     * method will return false.
     */
    inline void clearExpDate();

    /**
     * Checks whether the field "ExpDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExpDate()). Otherwise it will return false.
     */
    inline bool hasExpDate () const;

    /**
     * Returns the value of the member "ExpDate".
     *
     * <p>Client defines the maximum last of the job in ms.
     * When the time has passed, the job will be deleted
     * from the queue and the client will be informed.</p>
     * <p>If a client uses the possibility to transmit jobs/strings in
     * multiple packages, only the exp. date of the first job will
     * be examined, as the expiration date referres to the start
     * of a job.</p>
     * Test requirement : "full test"
     *
     * @return The value of the field "ExpDate"
     */
    inline uint32 getExpDate () const;

    /**
     * Sets the value of the member "ExpDate".
     *
     * <p>Client defines the maximum last of the job in ms.
     * When the time has passed, the job will be deleted
     * from the queue and the client will be informed.</p>
     * <p>If a client uses the possibility to transmit jobs/strings in
     * multiple packages, only the exp. date of the first job will
     * be examined, as the expiration date referres to the start
     * of a job.</p>
     * Test requirement : "full test"
     *
     * @param ExpDate The value which will be set
     */
    inline void setExpDate (uint32 ExpDate_);

    // API of field "LastPackage"

    static const int kLastPackage = 6;

    /**
     * Clears the field "LastPackage".
     *
     * The field will be set to its default value. The hasLastPackage()
     * method will return false.
     */
    inline void clearLastPackage();

    /**
     * Checks whether the field "LastPackage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastPackage()). Otherwise it will return false.
     */
    inline bool hasLastPackage () const;

    /**
     * Returns the value of the member "LastPackage".
     *
     * <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue not sent at that time.
     * Already queued jobparts of this job will be deleted by the FC TTS.</p>
     * Test requirement : "no test"
     *
     * @return The value of the field "LastPackage"
     */
    inline bool getLastPackage () const;

    /**
     * Sets the value of the member "LastPackage".
     *
     * <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue not sent at that time.
     * Already queued jobparts of this job will be deleted by the FC TTS.</p>
     * Test requirement : "no test"
     *
     * @param LastPackage The value which will be set
     */
    inline void setLastPackage (bool LastPackage_);

    // API of field "Index"

    static const int kIndex = 7;

    /**
     * Clears the field "Index".
     *
     * The field will be set to its default value. The hasIndex()
     * method will return false.
     */
    inline void clearIndex();

    /**
     * Checks whether the field "Index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndex()). Otherwise it will return false.
     */
    inline bool hasIndex () const;

    /**
     * Returns the value of the member "Index".
     *
     * <p>inform TTS how many times the request has been sent for the particular text string.</p>
     *
     * @return The value of the field "Index"
     */
    inline uint8 getIndex () const;

    /**
     * Sets the value of the member "Index".
     *
     * <p>inform TTS how many times the request has been sent for the particular text string.</p>
     *
     * @param Index The value which will be set
     */
    inline void setIndex (uint8 Index_);

    // API of field "SpeechSequence"

    static const int kSpeechSequence = 8;

    /**
     * Clears the field "SpeechSequence".
     *
     * The field will be set to its default value. The hasSpeechSequence()
     * method will return false.
     */
    inline void clearSpeechSequence();

    /**
     * Checks whether the field "SpeechSequence" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeechSequence()). Otherwise it will return false.
     */
    inline bool hasSpeechSequence () const;

    /**
     * Returns the value of the member "SpeechSequence".
     *
     * <p>The parameter SpeechSequence defines when the sentence should be spoken.</p>
     * <p>FC_TTS uses the sequence inform to sort the incoming requests in the queue</p>
     *
     * @return The value of the field "SpeechSequence"
     */
    inline ::sds_tts_fi_types::T_e8SequenceCategory getSpeechSequence () const;

    /**
     * Sets the value of the member "SpeechSequence".
     *
     * <p>The parameter SpeechSequence defines when the sentence should be spoken.</p>
     * <p>FC_TTS uses the sequence inform to sort the incoming requests in the queue</p>
     *
     * @param SpeechSequence The value which will be set
     */
    inline void setSpeechSequence (::sds_tts_fi_types::T_e8SequenceCategory SpeechSequence_);

    static const SynthesizeSpeakWithExtensionStart &getDefaultInstance();

private:

    inline void set_has_TextAndTags ();

    inline void clear_has_TextAndTags ();

    inline void set_has_TextStyle ();

    inline void clear_has_TextStyle ();

    inline void set_has_LanguageID ();

    inline void clear_has_LanguageID ();

    inline void set_has_AudioOutputLocation ();

    inline void clear_has_AudioOutputLocation ();

    inline void set_has_StatusInfo ();

    inline void clear_has_StatusInfo ();

    inline void set_has_ExpDate ();

    inline void clear_has_ExpDate ();

    inline void set_has_LastPackage ();

    inline void clear_has_LastPackage ();

    inline void set_has_Index ();

    inline void clear_has_Index ();

    inline void set_has_SpeechSequence ();

    inline void clear_has_SpeechSequence ();

    uint32 _has_bits_[ (9 + 31) / 32];

    ::std::string _TextAndTags;

    ::sds_tts_fi_types::T_e8_AudioSourceID _TextStyle;

    ::sds_sds2hmi_common_types::T_SDSLanguageID _LanguageID;

    ::acr_fi_types::T_b8_AudioOutputLocation _AudioOutputLocation;

    ::sds_tts_fi_types::T_e8_StatusInfoOption _StatusInfo;

    uint32 _ExpDate;

    bool _LastPackage;

    uint8 _Index;

    ::sds_tts_fi_types::T_e8SequenceCategory _SpeechSequence;

};

/**
 * The result first message of the method "SynthesizeSpeakWithExtension"
 * <p>This method is used to synthesize text. The synthesised data
 * is played via the audiomanagement with the available dev/acousticout.
 * SDS will request the audio channel from the AudioManagement. In case that AM
 * doesn't assign the channel , an error will be returned</p>
 * Test requirement : "partly test"
 */
class SynthesizeSpeakWithExtensionResultFirst  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SynthesizeSpeakWithExtensionResultFirst ();

    /**
     * Copy constructor
     */
    inline  SynthesizeSpeakWithExtensionResultFirst (const SynthesizeSpeakWithExtensionResultFirst &rhs);

    /**
     * All fields constructor
     */
    inline  SynthesizeSpeakWithExtensionResultFirst (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeSpeakWithExtensionResultFirst();

    /**
     * Assignment operator
     */
    inline SynthesizeSpeakWithExtensionResultFirst& operator = (const SynthesizeSpeakWithExtensionResultFirst& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeSpeakWithExtensionResultFirst& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeSpeakWithExtensionResultFirst& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeSpeakWithExtensionResultFirst& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeSpeakWithExtensionResultFirst& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobProgress"

    static const int kJobProgress = 0;

    /**
     * Clears the field "JobProgress".
     *
     * The field will be set to its default value. The hasJobProgress()
     * method will return false.
     */
    inline void clearJobProgress();

    /**
     * Checks whether the field "JobProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobProgress()). Otherwise it will return false.
     */
    inline bool hasJobProgress () const;

    /**
     * Returns the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus.</p>
     * <p>With this message, the client will be informed, that the job has been started,</p>
     * <p>even if he didn't want to be informed about the job progress.</p>
     * <p>If the job is not executed immediately (e.g. due to priority),
     * the client will be informed, that the job has been queued.</p>
     *
     * @return The value of the field "JobProgress"
     */
    inline const ::sds_tts_fi_types::T_SpeakProgress& getJobProgress () const;

    /**
     * Retrieves the value of the field "JobProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JobProgress".
     */
    inline ::sds_tts_fi_types::T_SpeakProgress& getJobProgressMutable ();

    /**
     * Sets the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus.</p>
     * <p>With this message, the client will be informed, that the job has been started,</p>
     * <p>even if he didn't want to be informed about the job progress.</p>
     * <p>If the job is not executed immediately (e.g. due to priority),
     * the client will be informed, that the job has been queued.</p>
     *
     * @param JobProgress The value which will be set
     */
    inline void setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    static const SynthesizeSpeakWithExtensionResultFirst &getDefaultInstance();

private:

    inline void set_has_JobProgress ();

    inline void clear_has_JobProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_SpeakProgress _JobProgress;

};

/**
 * The result middle message of the method "SynthesizeSpeakWithExtension"
 * <p>This method is used to synthesize text. The synthesised data
 * is played via the audiomanagement with the available dev/acousticout.
 * SDS will request the audio channel from the AudioManagement. In case that AM
 * doesn't assign the channel , an error will be returned</p>
 * Test requirement : "partly test"
 */
class SynthesizeSpeakWithExtensionResultMiddle  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SynthesizeSpeakWithExtensionResultMiddle ();

    /**
     * Copy constructor
     */
    inline  SynthesizeSpeakWithExtensionResultMiddle (const SynthesizeSpeakWithExtensionResultMiddle &rhs);

    /**
     * All fields constructor
     */
    inline  SynthesizeSpeakWithExtensionResultMiddle (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeSpeakWithExtensionResultMiddle();

    /**
     * Assignment operator
     */
    inline SynthesizeSpeakWithExtensionResultMiddle& operator = (const SynthesizeSpeakWithExtensionResultMiddle& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeSpeakWithExtensionResultMiddle& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeSpeakWithExtensionResultMiddle& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeSpeakWithExtensionResultMiddle& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeSpeakWithExtensionResultMiddle& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobProgress"

    static const int kJobProgress = 0;

    /**
     * Clears the field "JobProgress".
     *
     * The field will be set to its default value. The hasJobProgress()
     * method will return false.
     */
    inline void clearJobProgress();

    /**
     * Checks whether the field "JobProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobProgress()). Otherwise it will return false.
     */
    inline bool hasJobProgress () const;

    /**
     * Returns the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / progress of synthesis.</p>
     * <p>If the job has been queued before (e.g. due to priority), now the client
     * will be informed, that the job has been started now.</p>
     *
     * @return The value of the field "JobProgress"
     */
    inline const ::sds_tts_fi_types::T_SpeakProgress& getJobProgress () const;

    /**
     * Retrieves the value of the field "JobProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JobProgress".
     */
    inline ::sds_tts_fi_types::T_SpeakProgress& getJobProgressMutable ();

    /**
     * Sets the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / progress of synthesis.</p>
     * <p>If the job has been queued before (e.g. due to priority), now the client
     * will be informed, that the job has been started now.</p>
     *
     * @param JobProgress The value which will be set
     */
    inline void setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    static const SynthesizeSpeakWithExtensionResultMiddle &getDefaultInstance();

private:

    inline void set_has_JobProgress ();

    inline void clear_has_JobProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_SpeakProgress _JobProgress;

};

/**
 * The result last message of the method "SynthesizeSpeakWithExtension"
 * <p>This method is used to synthesize text. The synthesised data
 * is played via the audiomanagement with the available dev/acousticout.
 * SDS will request the audio channel from the AudioManagement. In case that AM
 * doesn't assign the channel , an error will be returned</p>
 * Test requirement : "partly test"
 */
class SynthesizeSpeakWithExtensionResultLast  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SynthesizeSpeakWithExtensionResultLast ();

    /**
     * Copy constructor
     */
    inline  SynthesizeSpeakWithExtensionResultLast (const SynthesizeSpeakWithExtensionResultLast &rhs);

    /**
     * All fields constructor
     */
    inline  SynthesizeSpeakWithExtensionResultLast (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeSpeakWithExtensionResultLast();

    /**
     * Assignment operator
     */
    inline SynthesizeSpeakWithExtensionResultLast& operator = (const SynthesizeSpeakWithExtensionResultLast& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeSpeakWithExtensionResultLast& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeSpeakWithExtensionResultLast& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeSpeakWithExtensionResultLast& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeSpeakWithExtensionResultLast& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobProgress"

    static const int kJobProgress = 0;

    /**
     * Clears the field "JobProgress".
     *
     * The field will be set to its default value. The hasJobProgress()
     * method will return false.
     */
    inline void clearJobProgress();

    /**
     * Checks whether the field "JobProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobProgress()). Otherwise it will return false.
     */
    inline bool hasJobProgress () const;

    /**
     * Returns the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / number of spoken words or sentences.</p>
     * <p>With this message, the client will be informed, that the job has been finished,</p>
     * <p>even if he didn't want to be informed about the job progress.</p>
     *
     * @return The value of the field "JobProgress"
     */
    inline const ::sds_tts_fi_types::T_SpeakProgress& getJobProgress () const;

    /**
     * Retrieves the value of the field "JobProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JobProgress".
     */
    inline ::sds_tts_fi_types::T_SpeakProgress& getJobProgressMutable ();

    /**
     * Sets the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / number of spoken words or sentences.</p>
     * <p>With this message, the client will be informed, that the job has been finished,</p>
     * <p>even if he didn't want to be informed about the job progress.</p>
     *
     * @param JobProgress The value which will be set
     */
    inline void setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    static const SynthesizeSpeakWithExtensionResultLast &getDefaultInstance();

private:

    inline void set_has_JobProgress ();

    inline void clear_has_JobProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_SpeakProgress _JobProgress;

};

/**
 * The error message of 'SynthesizeSpeakWithExtension'
 */
class SynthesizeSpeakWithExtensionError  : public ::asf::core::Payload {
public:

    enum SynthesizeSpeakWithExtensionErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SynthesizeSpeakWithExtensionError ();

   /**
     * Copy constructor
     */
    inline  SynthesizeSpeakWithExtensionError (const SynthesizeSpeakWithExtensionError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeSpeakWithExtensionError();

    /**
     * Assigns a new value to this object.
     */
    inline SynthesizeSpeakWithExtensionError& operator = (const SynthesizeSpeakWithExtensionError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeSpeakWithExtensionError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeSpeakWithExtensionError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeSpeakWithExtensionError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeSpeakWithExtensionError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SynthesizeSpeakWithExtensionError::SynthesizeSpeakWithExtensionErrorField getField () const;

    inline void setField(SynthesizeSpeakWithExtensionError::SynthesizeSpeakWithExtensionErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SynthesizeSpeakWithExtensionErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SynthesizeSpeakWithExtensionErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline SynthesizeSpeakWithExtensionErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SynthesizeSpeakWithExtensionErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (SynthesizeSpeakWithExtensionErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SynthesizeSpeakWithExtensionError &getDefaultInstance();

private:

    inline void cloneData (const SynthesizeSpeakWithExtensionError& rhs);

    inline void deleteData ();

    SynthesizeSpeakWithExtensionErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "PrepareVoiceOutput"
 * <p>Method will be called by client to let the FC TTS prepare the audio
 * device in advance of a synthesis. As a result of this method, the
 * FC TTS will request the audiomanagement for the audio channel via
 * ACR_FI ChannelRequest. if VoiceAdvice is received by FC TTS, the
 * audio device will be opened and the parameters set accordingly.
 * if this is done completely and the Method is answered by the
 * Methodresult, the client may then send the SynthesizeSpeak-Method.</p>
 * Test requirement : "full test"
 */
class PrepareVoiceOutputStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PrepareVoiceOutputStart ();

    /**
     * Copy constructor
     */
    inline  PrepareVoiceOutputStart (const PrepareVoiceOutputStart &rhs);

    /**
     * All fields constructor
     */
    inline  PrepareVoiceOutputStart (const ::std::string& Device_);

    /**
     * Destructor
     */
    inline virtual  ~PrepareVoiceOutputStart();

    /**
     * Assignment operator
     */
    inline PrepareVoiceOutputStart& operator = (const PrepareVoiceOutputStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PrepareVoiceOutputStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PrepareVoiceOutputStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PrepareVoiceOutputStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PrepareVoiceOutputStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Device"

    static const int kDevice = 0;

    /**
     * Clears the field "Device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "Device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "Device".
     *
     * <p>Parameter contains actual / configured AcousticOut Device Path.
     * If this parameter is empty, default path /dev/acousticout/speech
     * shall be used by TTS for speechoutput.</p>
     *
     * @return The value of the field "Device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "Device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "Device".
     *
     * <p>Parameter contains actual / configured AcousticOut Device Path.
     * If this parameter is empty, default path /dev/acousticout/speech
     * shall be used by TTS for speechoutput.</p>
     *
     * @param Device The value which will be set
     */
    inline void setDevice (const ::std::string& Device_);

    /**
     * Sets the value of the member "Device".
     *
     * <p>Parameter contains actual / configured AcousticOut Device Path.
     * If this parameter is empty, default path /dev/acousticout/speech
     * shall be used by TTS for speechoutput.</p>
     *
     * @param Device The value which will be set
     */
    inline void setDevice (const char* Device_);

    /**
     * Sets the value of the member "Device".
     *
     * <p>Parameter contains actual / configured AcousticOut Device Path.
     * If this parameter is empty, default path /dev/acousticout/speech
     * shall be used by TTS for speechoutput.</p>
     *
     * @param Device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const PrepareVoiceOutputStart &getDefaultInstance();

private:

    inline void set_has_Device ();

    inline void clear_has_Device ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Device;

};

/**
 * The error message of 'PrepareVoiceOutput'
 */
class PrepareVoiceOutputError  : public ::asf::core::Payload {
public:

    enum PrepareVoiceOutputErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  PrepareVoiceOutputError ();

   /**
     * Copy constructor
     */
    inline  PrepareVoiceOutputError (const PrepareVoiceOutputError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~PrepareVoiceOutputError();

    /**
     * Assigns a new value to this object.
     */
    inline PrepareVoiceOutputError& operator = (const PrepareVoiceOutputError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PrepareVoiceOutputError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PrepareVoiceOutputError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PrepareVoiceOutputError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PrepareVoiceOutputError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline PrepareVoiceOutputError::PrepareVoiceOutputErrorField getField () const;

    inline void setField(PrepareVoiceOutputError::PrepareVoiceOutputErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "PrepareVoiceOutputErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "PrepareVoiceOutputErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline PrepareVoiceOutputErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "PrepareVoiceOutputErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (PrepareVoiceOutputErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const PrepareVoiceOutputError &getDefaultInstance();

private:

    inline void cloneData (const PrepareVoiceOutputError& rhs);

    inline void deleteData ();

    PrepareVoiceOutputErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ReleaseData"
 * <p>All language-dependent software and memory must be unitialized and
 * released as a preparative action befor an upload of a language afterwards.
 * All data/dictionaries will be unloaded and devices closed.
 * A running job will be aborted and the job-queue deleted.</p>
 * Test requirement : "in progress"
 */
class ReleaseDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReleaseDataStart ();

    /**
     * Copy constructor
     */
    inline  ReleaseDataStart (const ReleaseDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  ReleaseDataStart (::sds_tts_fi_types::T_e8_ReleaseTypeTTS ReleaseType_);

    /**
     * Destructor
     */
    inline virtual  ~ReleaseDataStart();

    /**
     * Assignment operator
     */
    inline ReleaseDataStart& operator = (const ReleaseDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ReleaseType"

    static const int kReleaseType = 0;

    /**
     * Clears the field "ReleaseType".
     *
     * The field will be set to its default value. The hasReleaseType()
     * method will return false.
     */
    inline void clearReleaseType();

    /**
     * Checks whether the field "ReleaseType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReleaseType()). Otherwise it will return false.
     */
    inline bool hasReleaseType () const;

    /**
     * Returns the value of the member "ReleaseType".
     *
     * The type of data, which will not be needed any more/will be changed.
     *
     * @return The value of the field "ReleaseType"
     */
    inline ::sds_tts_fi_types::T_e8_ReleaseTypeTTS getReleaseType () const;

    /**
     * Sets the value of the member "ReleaseType".
     *
     * The type of data, which will not be needed any more/will be changed.
     *
     * @param ReleaseType The value which will be set
     */
    inline void setReleaseType (::sds_tts_fi_types::T_e8_ReleaseTypeTTS ReleaseType_);

    static const ReleaseDataStart &getDefaultInstance();

private:

    inline void set_has_ReleaseType ();

    inline void clear_has_ReleaseType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_e8_ReleaseTypeTTS _ReleaseType;

};

/**
 * The error message of 'ReleaseData'
 */
class ReleaseDataError  : public ::asf::core::Payload {
public:

    enum ReleaseDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ReleaseDataError ();

   /**
     * Copy constructor
     */
    inline  ReleaseDataError (const ReleaseDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ReleaseDataError();

    /**
     * Assigns a new value to this object.
     */
    inline ReleaseDataError& operator = (const ReleaseDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ReleaseDataError::ReleaseDataErrorField getField () const;

    inline void setField(ReleaseDataError::ReleaseDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ReleaseDataErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ReleaseDataErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ReleaseDataErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ReleaseDataErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (ReleaseDataErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ReleaseDataError &getDefaultInstance();

private:

    inline void cloneData (const ReleaseDataError& rhs);

    inline void deleteData ();

    ReleaseDataErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetVoice"
 * <p>Changes the voice of the TTS within the used language.</p>
 * Test requirement : "in progress"
 */
class SetVoiceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVoiceStart ();

    /**
     * Copy constructor
     */
    inline  SetVoiceStart (const SetVoiceStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetVoiceStart (const ::sds_speechdp_fi_types::T_VoiceType& TTSVoice_);

    /**
     * Destructor
     */
    inline virtual  ~SetVoiceStart();

    /**
     * Assignment operator
     */
    inline SetVoiceStart& operator = (const SetVoiceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVoiceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVoiceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVoiceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVoiceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TTSVoice"

    static const int kTTSVoice = 0;

    /**
     * Clears the field "TTSVoice".
     *
     * The field will be set to its default value. The hasTTSVoice()
     * method will return false.
     */
    inline void clearTTSVoice();

    /**
     * Checks whether the field "TTSVoice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTSVoice()). Otherwise it will return false.
     */
    inline bool hasTTSVoice () const;

    /**
     * Returns the value of the member "TTSVoice".
     *
     * Parameter contains all information about the voice to be loaded.
     *
     * @return The value of the field "TTSVoice"
     */
    inline const ::sds_speechdp_fi_types::T_VoiceType& getTTSVoice () const;

    /**
     * Retrieves the value of the field "TTSVoice" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TTSVoice".
     */
    inline ::sds_speechdp_fi_types::T_VoiceType& getTTSVoiceMutable ();

    /**
     * Sets the value of the member "TTSVoice".
     *
     * Parameter contains all information about the voice to be loaded.
     *
     * @param TTSVoice The value which will be set
     */
    inline void setTTSVoice (const ::sds_speechdp_fi_types::T_VoiceType& TTSVoice_);

    static const SetVoiceStart &getDefaultInstance();

private:

    inline void set_has_TTSVoice ();

    inline void clear_has_TTSVoice ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_speechdp_fi_types::T_VoiceType _TTSVoice;

};

/**
 * The error message of 'SetVoice'
 */
class SetVoiceError  : public ::asf::core::Payload {
public:

    enum SetVoiceErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetVoiceError ();

   /**
     * Copy constructor
     */
    inline  SetVoiceError (const SetVoiceError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetVoiceError();

    /**
     * Assigns a new value to this object.
     */
    inline SetVoiceError& operator = (const SetVoiceError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVoiceError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVoiceError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVoiceError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVoiceError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetVoiceError::SetVoiceErrorField getField () const;

    inline void setField(SetVoiceError::SetVoiceErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetVoiceErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetVoiceErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline SetVoiceErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetVoiceErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (SetVoiceErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetVoiceError &getDefaultInstance();

private:

    inline void cloneData (const SetVoiceError& rhs);

    inline void deleteData ();

    SetVoiceErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AbortPrompt"
 * <p>This Method provides an opportunity for the prompter, to stop the synthesis at a given point.
 * The job will be aborted and not continued at any time. The client will be informed.
 * If he want the synthesis to be done again, he has to start a new job.</p>
 * Test requirement : "partly test"
 */
class AbortPromptStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AbortPromptStart ();

    /**
     * Copy constructor
     */
    inline  AbortPromptStart (const AbortPromptStart &rhs);

    /**
     * All fields constructor
     */
    inline  AbortPromptStart (::sds_tts_fi_types::T_e8_PromptAbortOption AbortPromptOption_);

    /**
     * Destructor
     */
    inline virtual  ~AbortPromptStart();

    /**
     * Assignment operator
     */
    inline AbortPromptStart& operator = (const AbortPromptStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AbortPromptStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AbortPromptStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AbortPromptStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AbortPromptStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AbortPromptOption"

    static const int kAbortPromptOption = 0;

    /**
     * Clears the field "AbortPromptOption".
     *
     * The field will be set to its default value. The hasAbortPromptOption()
     * method will return false.
     */
    inline void clearAbortPromptOption();

    /**
     * Checks whether the field "AbortPromptOption" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAbortPromptOption()). Otherwise it will return false.
     */
    inline bool hasAbortPromptOption () const;

    /**
     * Returns the value of the member "AbortPromptOption".
     *
     * Test requirement : "partly test"
     *
     * @return The value of the field "AbortPromptOption"
     */
    inline ::sds_tts_fi_types::T_e8_PromptAbortOption getAbortPromptOption () const;

    /**
     * Sets the value of the member "AbortPromptOption".
     *
     * Test requirement : "partly test"
     *
     * @param AbortPromptOption The value which will be set
     */
    inline void setAbortPromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption AbortPromptOption_);

    static const AbortPromptStart &getDefaultInstance();

private:

    inline void set_has_AbortPromptOption ();

    inline void clear_has_AbortPromptOption ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_e8_PromptAbortOption _AbortPromptOption;

};

/**
 * The error message of 'AbortPrompt'
 */
class AbortPromptError  : public ::asf::core::Payload {
public:

    enum AbortPromptErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AbortPromptError ();

   /**
     * Copy constructor
     */
    inline  AbortPromptError (const AbortPromptError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AbortPromptError();

    /**
     * Assigns a new value to this object.
     */
    inline AbortPromptError& operator = (const AbortPromptError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AbortPromptError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AbortPromptError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AbortPromptError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AbortPromptError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AbortPromptError::AbortPromptErrorField getField () const;

    inline void setField(AbortPromptError::AbortPromptErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AbortPromptErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AbortPromptErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline AbortPromptErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AbortPromptErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (AbortPromptErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AbortPromptError &getDefaultInstance();

private:

    inline void cloneData (const AbortPromptError& rhs);

    inline void deleteData ();

    AbortPromptErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "PausePrompt"
 * <p>This Method provides an opportunity for the prompter, to pause the synthesis at a given point.
 * The job will be continued at the same point it has stopped, when the Method "ContinuePrompt" is used.</p>
 * Test requirement : "no test"
 */
class PausePromptStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PausePromptStart ();

    /**
     * Copy constructor
     */
    inline  PausePromptStart (const PausePromptStart &rhs);

    /**
     * All fields constructor
     */
    inline  PausePromptStart (::sds_tts_fi_types::T_e8_PromptAbortOption PausePromptOption_);

    /**
     * Destructor
     */
    inline virtual  ~PausePromptStart();

    /**
     * Assignment operator
     */
    inline PausePromptStart& operator = (const PausePromptStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PausePromptStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PausePromptStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PausePromptStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PausePromptStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PausePromptOption"

    static const int kPausePromptOption = 0;

    /**
     * Clears the field "PausePromptOption".
     *
     * The field will be set to its default value. The hasPausePromptOption()
     * method will return false.
     */
    inline void clearPausePromptOption();

    /**
     * Checks whether the field "PausePromptOption" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPausePromptOption()). Otherwise it will return false.
     */
    inline bool hasPausePromptOption () const;

    /**
     * Returns the value of the member "PausePromptOption".
     *
     * If the meaning of "PausePromptOption" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PausePromptOption"
     */
    inline ::sds_tts_fi_types::T_e8_PromptAbortOption getPausePromptOption () const;

    /**
     * Sets the value of the member "PausePromptOption".
     *
     * If the meaning of "PausePromptOption" isn't clear, then there should be a description here.
     *
     * @param PausePromptOption The value which will be set
     */
    inline void setPausePromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption PausePromptOption_);

    static const PausePromptStart &getDefaultInstance();

private:

    inline void set_has_PausePromptOption ();

    inline void clear_has_PausePromptOption ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_e8_PromptAbortOption _PausePromptOption;

};

/**
 * The error message of 'PausePrompt'
 */
class PausePromptError  : public ::asf::core::Payload {
public:

    enum PausePromptErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  PausePromptError ();

   /**
     * Copy constructor
     */
    inline  PausePromptError (const PausePromptError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~PausePromptError();

    /**
     * Assigns a new value to this object.
     */
    inline PausePromptError& operator = (const PausePromptError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PausePromptError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PausePromptError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PausePromptError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PausePromptError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline PausePromptError::PausePromptErrorField getField () const;

    inline void setField(PausePromptError::PausePromptErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "PausePromptErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "PausePromptErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline PausePromptErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "PausePromptErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (PausePromptErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const PausePromptError &getDefaultInstance();

private:

    inline void cloneData (const PausePromptError& rhs);

    inline void deleteData ();

    PausePromptErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ContinuePrompt"
 * <p>This Method is the corresponding one to the "PausePrompt"-Method
 * and to "AbortPrompt". The FC TTS will not do any synthesis, until
 * this method is used after an "AbortPromot" or "PausePrompt".</p>
 * Test requirement : "no test"
 */
class ContinuePromptStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ContinuePromptStart ();

    /**
     * Copy constructor
     */
    inline  ContinuePromptStart (const ContinuePromptStart &rhs);

    /**
     * All fields constructor
     */
    inline  ContinuePromptStart (uint8 Dummy_);

    /**
     * Destructor
     */
    inline virtual  ~ContinuePromptStart();

    /**
     * Assignment operator
     */
    inline ContinuePromptStart& operator = (const ContinuePromptStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ContinuePromptStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ContinuePromptStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ContinuePromptStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ContinuePromptStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dummy"

    static const int kDummy = 0;

    /**
     * Clears the field "Dummy".
     *
     * The field will be set to its default value. The hasDummy()
     * method will return false.
     */
    inline void clearDummy();

    /**
     * Checks whether the field "Dummy" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDummy()). Otherwise it will return false.
     */
    inline bool hasDummy () const;

    /**
     * Returns the value of the member "Dummy".
     *
     * If the meaning of "Dummy" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dummy"
     */
    inline uint8 getDummy () const;

    /**
     * Sets the value of the member "Dummy".
     *
     * If the meaning of "Dummy" isn't clear, then there should be a description here.
     *
     * @param Dummy The value which will be set
     */
    inline void setDummy (uint8 Dummy_);

    static const ContinuePromptStart &getDefaultInstance();

private:

    inline void set_has_Dummy ();

    inline void clear_has_Dummy ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Dummy;

};

/**
 * The error message of 'ContinuePrompt'
 */
class ContinuePromptError  : public ::asf::core::Payload {
public:

    enum ContinuePromptErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ContinuePromptError ();

   /**
     * Copy constructor
     */
    inline  ContinuePromptError (const ContinuePromptError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ContinuePromptError();

    /**
     * Assigns a new value to this object.
     */
    inline ContinuePromptError& operator = (const ContinuePromptError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ContinuePromptError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ContinuePromptError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ContinuePromptError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ContinuePromptError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ContinuePromptError::ContinuePromptErrorField getField () const;

    inline void setField(ContinuePromptError::ContinuePromptErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ContinuePromptErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ContinuePromptErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ContinuePromptErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ContinuePromptErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (ContinuePromptErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ContinuePromptError &getDefaultInstance();

private:

    inline void cloneData (const ContinuePromptError& rhs);

    inline void deleteData ();

    ContinuePromptErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AbortPromptWithExtension"
 * <p>This Method provides an opportunity for the prompter, to stop the synthesis at a given point.
 * The job will be aborted and not continued at any time. The client will be informed.
 * If he want the synthesis to be done again, he has to start a new job.</p>
 * Abort prompt which is started by SynthesizeSpeakWithExtension.
 */
class AbortPromptWithExtensionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AbortPromptWithExtensionStart ();

    /**
     * Copy constructor
     */
    inline  AbortPromptWithExtensionStart (const AbortPromptWithExtensionStart &rhs);

    /**
     * All fields constructor
     */
    inline  AbortPromptWithExtensionStart (::sds_tts_fi_types::T_e8_PromptAbortOption AbortPromptOption_);

    /**
     * Destructor
     */
    inline virtual  ~AbortPromptWithExtensionStart();

    /**
     * Assignment operator
     */
    inline AbortPromptWithExtensionStart& operator = (const AbortPromptWithExtensionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AbortPromptWithExtensionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AbortPromptWithExtensionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AbortPromptWithExtensionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AbortPromptWithExtensionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AbortPromptOption"

    static const int kAbortPromptOption = 0;

    /**
     * Clears the field "AbortPromptOption".
     *
     * The field will be set to its default value. The hasAbortPromptOption()
     * method will return false.
     */
    inline void clearAbortPromptOption();

    /**
     * Checks whether the field "AbortPromptOption" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAbortPromptOption()). Otherwise it will return false.
     */
    inline bool hasAbortPromptOption () const;

    /**
     * Returns the value of the member "AbortPromptOption".
     *
     * Test requirement : "partly test"
     *
     * @return The value of the field "AbortPromptOption"
     */
    inline ::sds_tts_fi_types::T_e8_PromptAbortOption getAbortPromptOption () const;

    /**
     * Sets the value of the member "AbortPromptOption".
     *
     * Test requirement : "partly test"
     *
     * @param AbortPromptOption The value which will be set
     */
    inline void setAbortPromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption AbortPromptOption_);

    static const AbortPromptWithExtensionStart &getDefaultInstance();

private:

    inline void set_has_AbortPromptOption ();

    inline void clear_has_AbortPromptOption ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_e8_PromptAbortOption _AbortPromptOption;

};

/**
 * The error message of 'AbortPromptWithExtension'
 */
class AbortPromptWithExtensionError  : public ::asf::core::Payload {
public:

    enum AbortPromptWithExtensionErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AbortPromptWithExtensionError ();

   /**
     * Copy constructor
     */
    inline  AbortPromptWithExtensionError (const AbortPromptWithExtensionError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AbortPromptWithExtensionError();

    /**
     * Assigns a new value to this object.
     */
    inline AbortPromptWithExtensionError& operator = (const AbortPromptWithExtensionError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AbortPromptWithExtensionError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AbortPromptWithExtensionError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AbortPromptWithExtensionError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AbortPromptWithExtensionError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AbortPromptWithExtensionError::AbortPromptWithExtensionErrorField getField () const;

    inline void setField(AbortPromptWithExtensionError::AbortPromptWithExtensionErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AbortPromptWithExtensionErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AbortPromptWithExtensionErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline AbortPromptWithExtensionErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AbortPromptWithExtensionErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (AbortPromptWithExtensionErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AbortPromptWithExtensionError &getDefaultInstance();

private:

    inline void cloneData (const AbortPromptWithExtensionError& rhs);

    inline void deleteData ();

    AbortPromptWithExtensionErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "PausePromptWithExtension"
 * <p>This Method provides an opportunity for the prompter, to pause the synthesis at a given point.
 * The job will be continued at the same point it has stopped, when the Method "ContinuePrompt" is used.</p>
 * Pause prompt which is started by SynthesizeSpeakWithExtension.
 */
class PausePromptWithExtensionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PausePromptWithExtensionStart ();

    /**
     * Copy constructor
     */
    inline  PausePromptWithExtensionStart (const PausePromptWithExtensionStart &rhs);

    /**
     * All fields constructor
     */
    inline  PausePromptWithExtensionStart (::sds_tts_fi_types::T_e8_PromptAbortOption PausePromptOption_);

    /**
     * Destructor
     */
    inline virtual  ~PausePromptWithExtensionStart();

    /**
     * Assignment operator
     */
    inline PausePromptWithExtensionStart& operator = (const PausePromptWithExtensionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PausePromptWithExtensionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PausePromptWithExtensionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PausePromptWithExtensionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PausePromptWithExtensionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PausePromptOption"

    static const int kPausePromptOption = 0;

    /**
     * Clears the field "PausePromptOption".
     *
     * The field will be set to its default value. The hasPausePromptOption()
     * method will return false.
     */
    inline void clearPausePromptOption();

    /**
     * Checks whether the field "PausePromptOption" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPausePromptOption()). Otherwise it will return false.
     */
    inline bool hasPausePromptOption () const;

    /**
     * Returns the value of the member "PausePromptOption".
     *
     * If the meaning of "PausePromptOption" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PausePromptOption"
     */
    inline ::sds_tts_fi_types::T_e8_PromptAbortOption getPausePromptOption () const;

    /**
     * Sets the value of the member "PausePromptOption".
     *
     * If the meaning of "PausePromptOption" isn't clear, then there should be a description here.
     *
     * @param PausePromptOption The value which will be set
     */
    inline void setPausePromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption PausePromptOption_);

    static const PausePromptWithExtensionStart &getDefaultInstance();

private:

    inline void set_has_PausePromptOption ();

    inline void clear_has_PausePromptOption ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_e8_PromptAbortOption _PausePromptOption;

};

/**
 * The error message of 'PausePromptWithExtension'
 */
class PausePromptWithExtensionError  : public ::asf::core::Payload {
public:

    enum PausePromptWithExtensionErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  PausePromptWithExtensionError ();

   /**
     * Copy constructor
     */
    inline  PausePromptWithExtensionError (const PausePromptWithExtensionError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~PausePromptWithExtensionError();

    /**
     * Assigns a new value to this object.
     */
    inline PausePromptWithExtensionError& operator = (const PausePromptWithExtensionError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PausePromptWithExtensionError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PausePromptWithExtensionError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PausePromptWithExtensionError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PausePromptWithExtensionError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline PausePromptWithExtensionError::PausePromptWithExtensionErrorField getField () const;

    inline void setField(PausePromptWithExtensionError::PausePromptWithExtensionErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "PausePromptWithExtensionErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "PausePromptWithExtensionErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline PausePromptWithExtensionErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "PausePromptWithExtensionErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (PausePromptWithExtensionErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const PausePromptWithExtensionError &getDefaultInstance();

private:

    inline void cloneData (const PausePromptWithExtensionError& rhs);

    inline void deleteData ();

    PausePromptWithExtensionErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ContinuePromptWithExtension"
 * <p>This Method is the corresponding one to the "PausePromptWithExtension"-Method.
 * The FC TTS will not do any synthesis, until "PausePromptWithExtension".</p>
 * Test requirement : "no test"
 */
class ContinuePromptWithExtensionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ContinuePromptWithExtensionStart ();

    /**
     * Copy constructor
     */
    inline  ContinuePromptWithExtensionStart (const ContinuePromptWithExtensionStart &rhs);

    /**
     * All fields constructor
     */
    inline  ContinuePromptWithExtensionStart (uint8 Dummy_);

    /**
     * Destructor
     */
    inline virtual  ~ContinuePromptWithExtensionStart();

    /**
     * Assignment operator
     */
    inline ContinuePromptWithExtensionStart& operator = (const ContinuePromptWithExtensionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ContinuePromptWithExtensionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ContinuePromptWithExtensionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ContinuePromptWithExtensionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ContinuePromptWithExtensionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dummy"

    static const int kDummy = 0;

    /**
     * Clears the field "Dummy".
     *
     * The field will be set to its default value. The hasDummy()
     * method will return false.
     */
    inline void clearDummy();

    /**
     * Checks whether the field "Dummy" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDummy()). Otherwise it will return false.
     */
    inline bool hasDummy () const;

    /**
     * Returns the value of the member "Dummy".
     *
     * If the meaning of "Dummy" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dummy"
     */
    inline uint8 getDummy () const;

    /**
     * Sets the value of the member "Dummy".
     *
     * If the meaning of "Dummy" isn't clear, then there should be a description here.
     *
     * @param Dummy The value which will be set
     */
    inline void setDummy (uint8 Dummy_);

    static const ContinuePromptWithExtensionStart &getDefaultInstance();

private:

    inline void set_has_Dummy ();

    inline void clear_has_Dummy ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Dummy;

};

/**
 * The error message of 'ContinuePromptWithExtension'
 */
class ContinuePromptWithExtensionError  : public ::asf::core::Payload {
public:

    enum ContinuePromptWithExtensionErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ContinuePromptWithExtensionError ();

   /**
     * Copy constructor
     */
    inline  ContinuePromptWithExtensionError (const ContinuePromptWithExtensionError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ContinuePromptWithExtensionError();

    /**
     * Assigns a new value to this object.
     */
    inline ContinuePromptWithExtensionError& operator = (const ContinuePromptWithExtensionError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ContinuePromptWithExtensionError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ContinuePromptWithExtensionError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ContinuePromptWithExtensionError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ContinuePromptWithExtensionError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ContinuePromptWithExtensionError::ContinuePromptWithExtensionErrorField getField () const;

    inline void setField(ContinuePromptWithExtensionError::ContinuePromptWithExtensionErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ContinuePromptWithExtensionErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ContinuePromptWithExtensionErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ContinuePromptWithExtensionErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ContinuePromptWithExtensionErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (ContinuePromptWithExtensionErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ContinuePromptWithExtensionError &getDefaultInstance();

private:

    inline void cloneData (const ContinuePromptWithExtensionError& rhs);

    inline void deleteData ();

    ContinuePromptWithExtensionErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RequestPhoneme"
 * <p>This Method is used to request a phoneme representation for the
 * given SourceText by means of database request (e.g. via FC_SDP)
 * according to the provided tagging (<dict>). The result combines the provided FileID (<file id=...>) with the phoneme representation in the PhonemeList</p>
 */
class RequestPhonemeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestPhonemeStart ();

    /**
     * Copy constructor
     */
    inline  RequestPhonemeStart (const RequestPhonemeStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestPhonemeStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_);

    /**
     * Destructor
     */
    inline virtual  ~RequestPhonemeStart();

    /**
     * Assignment operator
     */
    inline RequestPhonemeStart& operator = (const RequestPhonemeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPhonemeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPhonemeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPhonemeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPhonemeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TextAndTags"

    static const int kTextAndTags = 0;

    /**
     * Clears the field "TextAndTags".
     *
     * The field will be set to its default value. The hasTextAndTags()
     * method will return false.
     */
    inline void clearTextAndTags();

    /**
     * Checks whether the field "TextAndTags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextAndTags()). Otherwise it will return false.
     */
    inline bool hasTextAndTags () const;

    /**
     * Returns the value of the member "TextAndTags".
     *
     * <p>Element containing Text and ID for phoneme substitution:
     * <file id=...> <dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict> </file></p>
     * <p>Also multiple occurences of this file/dict combination are allowed
     * (<file id=...> <dict ... >String</dict> </file> <file id=...> <dict ... >String</dict> </file>)</p>
     * <p>The  tag <file id=...>Text</file> surrounds the string which has to be converted to phonemes.
     * The (client-specific) ID within the file-tag is transmitted by the client and will be sent back with the MethodResult.</p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p>
     *
     * @return The value of the field "TextAndTags"
     */
    inline const ::std::string& getTextAndTags () const;

    /**
     * Retrieves the value of the field "TextAndTags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TextAndTags".
     */
    inline ::std::string& getTextAndTagsMutable ();

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>Element containing Text and ID for phoneme substitution:
     * <file id=...> <dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict> </file></p>
     * <p>Also multiple occurences of this file/dict combination are allowed
     * (<file id=...> <dict ... >String</dict> </file> <file id=...> <dict ... >String</dict> </file>)</p>
     * <p>The  tag <file id=...>Text</file> surrounds the string which has to be converted to phonemes.
     * The (client-specific) ID within the file-tag is transmitted by the client and will be sent back with the MethodResult.</p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p>
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const ::std::string& TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>Element containing Text and ID for phoneme substitution:
     * <file id=...> <dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict> </file></p>
     * <p>Also multiple occurences of this file/dict combination are allowed
     * (<file id=...> <dict ... >String</dict> </file> <file id=...> <dict ... >String</dict> </file>)</p>
     * <p>The  tag <file id=...>Text</file> surrounds the string which has to be converted to phonemes.
     * The (client-specific) ID within the file-tag is transmitted by the client and will be sent back with the MethodResult.</p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p>
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>Element containing Text and ID for phoneme substitution:
     * <file id=...> <dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict> </file></p>
     * <p>Also multiple occurences of this file/dict combination are allowed
     * (<file id=...> <dict ... >String</dict> </file> <file id=...> <dict ... >String</dict> </file>)</p>
     * <p>The  tag <file id=...>Text</file> surrounds the string which has to be converted to phonemes.
     * The (client-specific) ID within the file-tag is transmitted by the client and will be sent back with the MethodResult.</p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p>
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* value, size_t size);

    // API of field "TextStyle"

    static const int kTextStyle = 1;

    /**
     * Clears the field "TextStyle".
     *
     * The field will be set to its default value. The hasTextStyle()
     * method will return false.
     */
    inline void clearTextStyle();

    /**
     * Checks whether the field "TextStyle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextStyle()). Otherwise it will return false.
     */
    inline bool hasTextStyle () const;

    /**
     * Returns the value of the member "TextStyle".
     *
     * This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).
     *
     * @return The value of the field "TextStyle"
     */
    inline ::sds_tts_fi_types::T_e8_TextStyleOption getTextStyle () const;

    /**
     * Sets the value of the member "TextStyle".
     *
     * This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).
     *
     * @param TextStyle The value which will be set
     */
    inline void setTextStyle (::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_);

    static const RequestPhonemeStart &getDefaultInstance();

private:

    inline void set_has_TextAndTags ();

    inline void clear_has_TextAndTags ();

    inline void set_has_TextStyle ();

    inline void clear_has_TextStyle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _TextAndTags;

    ::sds_tts_fi_types::T_e8_TextStyleOption _TextStyle;

};

/**
 * The result message of the method "RequestPhoneme"
 * <p>This Method is used to request a phoneme representation for the
 * given SourceText by means of database request (e.g. via FC_SDP)
 * according to the provided tagging (<dict>). The result combines the provided FileID (<file id=...>) with the phoneme representation in the PhonemeList</p>
 */
class RequestPhonemeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestPhonemeResult ();

    /**
     * Copy constructor
     */
    inline  RequestPhonemeResult (const RequestPhonemeResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestPhonemeResult (const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& PhonemeList_);

    /**
     * Destructor
     */
    inline virtual  ~RequestPhonemeResult();

    /**
     * Assignment operator
     */
    inline RequestPhonemeResult& operator = (const RequestPhonemeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPhonemeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPhonemeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPhonemeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPhonemeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhonemeList"

    static const int kPhonemeList = 0;

    /**
     * Clears the field "PhonemeList".
     *
     * The field will be set to its default value. The hasPhonemeList()
     * method will return false.
     */
    inline void clearPhonemeList();

    /**
     * Checks whether the field "PhonemeList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonemeList()). Otherwise it will return false.
     */
    inline bool hasPhonemeList () const;

    /**
     * Returns the value of the member "PhonemeList".
     *
     * <p>The PhonemeList contains the phoneme substitutions combined with the fileID they are requested for.</p>
     *
     * @return The value of the field "PhonemeList"
     */
    inline const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& getPhonemeList () const;

    /**
     * Retrieves the value of the field "PhonemeList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhonemeList".
     */
    inline ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& getPhonemeListMutable ();

    /**
     * Sets the value of the member "PhonemeList".
     *
     * <p>The PhonemeList contains the phoneme substitutions combined with the fileID they are requested for.</p>
     *
     * @param PhonemeList The value which will be set
     */
    inline void setPhonemeList (const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& PhonemeList_);

    static const RequestPhonemeResult &getDefaultInstance();

private:

    static const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& getT_TTSPhonemeResultList_DefaultInstance ();

    inline void set_has_PhonemeList ();

    inline void clear_has_PhonemeList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult > _PhonemeList;

};

/**
 * The error message of 'RequestPhoneme'
 */
class RequestPhonemeError  : public ::asf::core::Payload {
public:

    enum RequestPhonemeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RequestPhonemeError ();

   /**
     * Copy constructor
     */
    inline  RequestPhonemeError (const RequestPhonemeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RequestPhonemeError();

    /**
     * Assigns a new value to this object.
     */
    inline RequestPhonemeError& operator = (const RequestPhonemeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPhonemeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPhonemeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPhonemeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPhonemeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RequestPhonemeError::RequestPhonemeErrorField getField () const;

    inline void setField(RequestPhonemeError::RequestPhonemeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RequestPhonemeErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RequestPhonemeErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline RequestPhonemeErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RequestPhonemeErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (RequestPhonemeErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RequestPhonemeError &getDefaultInstance();

private:

    inline void cloneData (const RequestPhonemeError& rhs);

    inline void deleteData ();

    RequestPhonemeErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "LoadTuningFiles"
 * <p>This method is used by the client to request TTS to load the tuning for a particular domain by providing it.</p>
 * <p>On this request TTS shall only buffer the file paths and actual loading of these tuning files will be done only when the</p>
 * <p>SynthesizeSpeak request is received with correct domain</p>
 */
class LoadTuningFilesStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LoadTuningFilesStart ();

    /**
     * Copy constructor
     */
    inline  LoadTuningFilesStart (const LoadTuningFilesStart &rhs);

    /**
     * All fields constructor
     */
    inline  LoadTuningFilesStart (const ::std::vector< ::sds_tts_fi_types::T_TTSTuningFile >& TTSTunFiles_, ::sds_tts_fi_types::T_e8_TTSDomain TTSDomain_, const ::std::string& TTSVersion_);

    /**
     * Destructor
     */
    inline virtual  ~LoadTuningFilesStart();

    /**
     * Assignment operator
     */
    inline LoadTuningFilesStart& operator = (const LoadTuningFilesStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoadTuningFilesStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoadTuningFilesStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoadTuningFilesStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoadTuningFilesStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TTSTunFiles"

    static const int kTTSTunFiles = 0;

    /**
     * Clears the field "TTSTunFiles".
     *
     * The field will be set to its default value. The hasTTSTunFiles()
     * method will return false.
     */
    inline void clearTTSTunFiles();

    /**
     * Checks whether the field "TTSTunFiles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTSTunFiles()). Otherwise it will return false.
     */
    inline bool hasTTSTunFiles () const;

    /**
     * Returns the value of the member "TTSTunFiles".
     *
     * List of TTS Tuning data files for the current system language.
     *
     * @return The value of the field "TTSTunFiles"
     */
    inline const ::std::vector< ::sds_tts_fi_types::T_TTSTuningFile >& getTTSTunFiles () const;

    /**
     * Retrieves the value of the field "TTSTunFiles" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TTSTunFiles".
     */
    inline ::std::vector< ::sds_tts_fi_types::T_TTSTuningFile >& getTTSTunFilesMutable ();

    /**
     * Sets the value of the member "TTSTunFiles".
     *
     * List of TTS Tuning data files for the current system language.
     *
     * @param TTSTunFiles The value which will be set
     */
    inline void setTTSTunFiles (const ::std::vector< ::sds_tts_fi_types::T_TTSTuningFile >& TTSTunFiles_);

    // API of field "TTSDomain"

    static const int kTTSDomain = 1;

    /**
     * Clears the field "TTSDomain".
     *
     * The field will be set to its default value. The hasTTSDomain()
     * method will return false.
     */
    inline void clearTTSDomain();

    /**
     * Checks whether the field "TTSDomain" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTSDomain()). Otherwise it will return false.
     */
    inline bool hasTTSDomain () const;

    /**
     * Returns the value of the member "TTSDomain".
     *
     * Domain related to the TTS Tuning files.
     *
     * @return The value of the field "TTSDomain"
     */
    inline ::sds_tts_fi_types::T_e8_TTSDomain getTTSDomain () const;

    /**
     * Sets the value of the member "TTSDomain".
     *
     * Domain related to the TTS Tuning files.
     *
     * @param TTSDomain The value which will be set
     */
    inline void setTTSDomain (::sds_tts_fi_types::T_e8_TTSDomain TTSDomain_);

    // API of field "TTSVersion"

    static const int kTTSVersion = 2;

    /**
     * Clears the field "TTSVersion".
     *
     * The field will be set to its default value. The hasTTSVersion()
     * method will return false.
     */
    inline void clearTTSVersion();

    /**
     * Checks whether the field "TTSVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTSVersion()). Otherwise it will return false.
     */
    inline bool hasTTSVersion () const;

    /**
     * Returns the value of the member "TTSVersion".
     *
     * TTS Engine version to which the tuning files are compatible.
     * Expected format is EngineType Version (Major Num).(Minor Num).
     * e.g. "VAUTO 5.4" or "VE 1.3".
     *
     * @return The value of the field "TTSVersion"
     */
    inline const ::std::string& getTTSVersion () const;

    /**
     * Retrieves the value of the field "TTSVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TTSVersion".
     */
    inline ::std::string& getTTSVersionMutable ();

    /**
     * Sets the value of the member "TTSVersion".
     *
     * TTS Engine version to which the tuning files are compatible.
     * Expected format is EngineType Version (Major Num).(Minor Num).
     * e.g. "VAUTO 5.4" or "VE 1.3".
     *
     * @param TTSVersion The value which will be set
     */
    inline void setTTSVersion (const ::std::string& TTSVersion_);

    /**
     * Sets the value of the member "TTSVersion".
     *
     * TTS Engine version to which the tuning files are compatible.
     * Expected format is EngineType Version (Major Num).(Minor Num).
     * e.g. "VAUTO 5.4" or "VE 1.3".
     *
     * @param TTSVersion The value which will be set
     */
    inline void setTTSVersion (const char* TTSVersion_);

    /**
     * Sets the value of the member "TTSVersion".
     *
     * TTS Engine version to which the tuning files are compatible.
     * Expected format is EngineType Version (Major Num).(Minor Num).
     * e.g. "VAUTO 5.4" or "VE 1.3".
     *
     * @param TTSVersion The value which will be set
     */
    inline void setTTSVersion (const char* value, size_t size);

    static const LoadTuningFilesStart &getDefaultInstance();

private:

    static const ::std::vector< ::sds_tts_fi_types::T_TTSTuningFile >& getT_TTSTuningFileList_DefaultInstance ();

    inline void set_has_TTSTunFiles ();

    inline void clear_has_TTSTunFiles ();

    inline void set_has_TTSDomain ();

    inline void clear_has_TTSDomain ();

    inline void set_has_TTSVersion ();

    inline void clear_has_TTSVersion ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< ::sds_tts_fi_types::T_TTSTuningFile > _TTSTunFiles;

    ::sds_tts_fi_types::T_e8_TTSDomain _TTSDomain;

    ::std::string _TTSVersion;

};

/**
 * The error message of 'LoadTuningFiles'
 */
class LoadTuningFilesError  : public ::asf::core::Payload {
public:

    enum LoadTuningFilesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  LoadTuningFilesError ();

   /**
     * Copy constructor
     */
    inline  LoadTuningFilesError (const LoadTuningFilesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~LoadTuningFilesError();

    /**
     * Assigns a new value to this object.
     */
    inline LoadTuningFilesError& operator = (const LoadTuningFilesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoadTuningFilesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoadTuningFilesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoadTuningFilesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoadTuningFilesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline LoadTuningFilesError::LoadTuningFilesErrorField getField () const;

    inline void setField(LoadTuningFilesError::LoadTuningFilesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "LoadTuningFilesErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "LoadTuningFilesErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline LoadTuningFilesErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "LoadTuningFilesErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (LoadTuningFilesErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const LoadTuningFilesError &getDefaultInstance();

private:

    inline void cloneData (const LoadTuningFilesError& rhs);

    inline void deleteData ();

    LoadTuningFilesErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetDefaultSpeechRate"
 * <p>Changes the speech rate of the Vocalizer Engine.</p>
 * <p>This method is internal to SDS only and should not be called by any external TTS clients !!</p>
 */
class SetDefaultSpeechRateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDefaultSpeechRateStart ();

    /**
     * Copy constructor
     */
    inline  SetDefaultSpeechRateStart (const SetDefaultSpeechRateStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetDefaultSpeechRateStart (uint16 Rate_);

    /**
     * Destructor
     */
    inline virtual  ~SetDefaultSpeechRateStart();

    /**
     * Assignment operator
     */
    inline SetDefaultSpeechRateStart& operator = (const SetDefaultSpeechRateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDefaultSpeechRateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDefaultSpeechRateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDefaultSpeechRateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDefaultSpeechRateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Rate"

    static const int kRate = 0;

    /**
     * Clears the field "Rate".
     *
     * The field will be set to its default value. The hasRate()
     * method will return false.
     */
    inline void clearRate();

    /**
     * Checks whether the field "Rate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRate()). Otherwise it will return false.
     */
    inline bool hasRate () const;

    /**
     * Returns the value of the member "Rate".
     *
     * <p>Parameter defines / contains Speech rate value.</p>
     * <p>The value can be in the range [50..400] where 50 being 2x slower and 400 being 4x faster of the normal speech.</p>
     * <p>Default value : 100</p>
     *
     * @return The value of the field "Rate"
     */
    inline uint16 getRate () const;

    /**
     * Sets the value of the member "Rate".
     *
     * <p>Parameter defines / contains Speech rate value.</p>
     * <p>The value can be in the range [50..400] where 50 being 2x slower and 400 being 4x faster of the normal speech.</p>
     * <p>Default value : 100</p>
     *
     * @param Rate The value which will be set
     */
    inline void setRate (uint16 Rate_);

    static const SetDefaultSpeechRateStart &getDefaultInstance();

private:

    inline void set_has_Rate ();

    inline void clear_has_Rate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Rate;

};

/**
 * The start message of the method "DoSynthesisForSpeak"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of the 2 not used parameters AudioOutputLocation and ExpDate).</p>
 * Test requirement : "no test"
 */
class DoSynthesisForSpeakStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoSynthesisForSpeakStart ();

    /**
     * Copy constructor
     */
    inline  DoSynthesisForSpeakStart (const DoSynthesisForSpeakStart &rhs);

    /**
     * All fields constructor
     */
    inline  DoSynthesisForSpeakStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_, ::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_, bool LastPackage_);

    /**
     * Destructor
     */
    inline virtual  ~DoSynthesisForSpeakStart();

    /**
     * Assignment operator
     */
    inline DoSynthesisForSpeakStart& operator = (const DoSynthesisForSpeakStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoSynthesisForSpeakStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoSynthesisForSpeakStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoSynthesisForSpeakStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoSynthesisForSpeakStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TextAndTags"

    static const int kTextAndTags = 0;

    /**
     * Clears the field "TextAndTags".
     *
     * The field will be set to its default value. The hasTextAndTags()
     * method will return false.
     */
    inline void clearTextAndTags();

    /**
     * Checks whether the field "TextAndTags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextAndTags()). Otherwise it will return false.
     */
    inline bool hasTextAndTags () const;

    /**
     * Returns the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionaly,
     * a tags can be used within the string to give some extra
     * information. For this method, the tag is <dict>:
     * The dict-tag can be used to give information about the
     * dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... country=... lang=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type the
     * dest-parameter is (SelectionCriterionType or SpeechAppDictType).</p>
     * <p>Destcat has to be used according to the definition in the sp_speechdp_fi.
     * Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType) respectively sp_speechdp_fi (SpeechAppDictType).</p>
     * <p>The parameters country and language must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     *
     * @return The value of the field "TextAndTags"
     */
    inline const ::std::string& getTextAndTags () const;

    /**
     * Retrieves the value of the field "TextAndTags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TextAndTags".
     */
    inline ::std::string& getTextAndTagsMutable ();

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionaly,
     * a tags can be used within the string to give some extra
     * information. For this method, the tag is <dict>:
     * The dict-tag can be used to give information about the
     * dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... country=... lang=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type the
     * dest-parameter is (SelectionCriterionType or SpeechAppDictType).</p>
     * <p>Destcat has to be used according to the definition in the sp_speechdp_fi.
     * Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType) respectively sp_speechdp_fi (SpeechAppDictType).</p>
     * <p>The parameters country and language must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const ::std::string& TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionaly,
     * a tags can be used within the string to give some extra
     * information. For this method, the tag is <dict>:
     * The dict-tag can be used to give information about the
     * dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... country=... lang=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type the
     * dest-parameter is (SelectionCriterionType or SpeechAppDictType).</p>
     * <p>Destcat has to be used according to the definition in the sp_speechdp_fi.
     * Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType) respectively sp_speechdp_fi (SpeechAppDictType).</p>
     * <p>The parameters country and language must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionaly,
     * a tags can be used within the string to give some extra
     * information. For this method, the tag is <dict>:
     * The dict-tag can be used to give information about the
     * dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... country=... lang=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type the
     * dest-parameter is (SelectionCriterionType or SpeechAppDictType).</p>
     * <p>Destcat has to be used according to the definition in the sp_speechdp_fi.
     * Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType) respectively sp_speechdp_fi (SpeechAppDictType).</p>
     * <p>The parameters country and language must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* value, size_t size);

    // API of field "TextStyle"

    static const int kTextStyle = 1;

    /**
     * Clears the field "TextStyle".
     *
     * The field will be set to its default value. The hasTextStyle()
     * method will return false.
     */
    inline void clearTextStyle();

    /**
     * Checks whether the field "TextStyle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextStyle()). Otherwise it will return false.
     */
    inline bool hasTextStyle () const;

    /**
     * Returns the value of the member "TextStyle".
     *
     * This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).
     *
     * @return The value of the field "TextStyle"
     */
    inline ::sds_tts_fi_types::T_e8_TextStyleOption getTextStyle () const;

    /**
     * Sets the value of the member "TextStyle".
     *
     * This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).
     *
     * @param TextStyle The value which will be set
     */
    inline void setTextStyle (::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_);

    // API of field "StatusInfo"

    static const int kStatusInfo = 2;

    /**
     * Clears the field "StatusInfo".
     *
     * The field will be set to its default value. The hasStatusInfo()
     * method will return false.
     */
    inline void clearStatusInfo();

    /**
     * Checks whether the field "StatusInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusInfo()). Otherwise it will return false.
     */
    inline bool hasStatusInfo () const;

    /**
     * Returns the value of the member "StatusInfo".
     *
     * <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     *
     * @return The value of the field "StatusInfo"
     */
    inline ::sds_tts_fi_types::T_e8_StatusInfoOption getStatusInfo () const;

    /**
     * Sets the value of the member "StatusInfo".
     *
     * <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     *
     * @param StatusInfo The value which will be set
     */
    inline void setStatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_);

    // API of field "LastPackage"

    static const int kLastPackage = 3;

    /**
     * Clears the field "LastPackage".
     *
     * The field will be set to its default value. The hasLastPackage()
     * method will return false.
     */
    inline void clearLastPackage();

    /**
     * Checks whether the field "LastPackage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastPackage()). Otherwise it will return false.
     */
    inline bool hasLastPackage () const;

    /**
     * Returns the value of the member "LastPackage".
     *
     * <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue not sent at that time.
     * Already queued jobparts of this job will be deleted by the FC TTS.</p>
     *
     * @return The value of the field "LastPackage"
     */
    inline bool getLastPackage () const;

    /**
     * Sets the value of the member "LastPackage".
     *
     * <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue not sent at that time.
     * Already queued jobparts of this job will be deleted by the FC TTS.</p>
     *
     * @param LastPackage The value which will be set
     */
    inline void setLastPackage (bool LastPackage_);

    static const DoSynthesisForSpeakStart &getDefaultInstance();

private:

    inline void set_has_TextAndTags ();

    inline void clear_has_TextAndTags ();

    inline void set_has_TextStyle ();

    inline void clear_has_TextStyle ();

    inline void set_has_StatusInfo ();

    inline void clear_has_StatusInfo ();

    inline void set_has_LastPackage ();

    inline void clear_has_LastPackage ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _TextAndTags;

    ::sds_tts_fi_types::T_e8_TextStyleOption _TextStyle;

    ::sds_tts_fi_types::T_e8_StatusInfoOption _StatusInfo;

    bool _LastPackage;

};

/**
 * The start message of the method "DoPrepareAudioOutput"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * This method is used to initiate all necessary steps to do an audio
 * output with the Audio output device (e.g. Open Device...).</p>
 * Test requirement : "no test"
 */
class DoPrepareAudioOutputStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoPrepareAudioOutputStart ();

    /**
     * Copy constructor
     */
    inline  DoPrepareAudioOutputStart (const DoPrepareAudioOutputStart &rhs);

    /**
     * All fields constructor
     */
    inline  DoPrepareAudioOutputStart (const ::std::string& DeviceName_);

    /**
     * Destructor
     */
    inline virtual  ~DoPrepareAudioOutputStart();

    /**
     * Assignment operator
     */
    inline DoPrepareAudioOutputStart& operator = (const DoPrepareAudioOutputStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoPrepareAudioOutputStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoPrepareAudioOutputStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoPrepareAudioOutputStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoPrepareAudioOutputStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceName"

    static const int kDeviceName = 0;

    /**
     * Clears the field "DeviceName".
     *
     * The field will be set to its default value. The hasDeviceName()
     * method will return false.
     */
    inline void clearDeviceName();

    /**
     * Checks whether the field "DeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceName()). Otherwise it will return false.
     */
    inline bool hasDeviceName () const;

    /**
     * Returns the value of the member "DeviceName".
     *
     * <p>Devicename given by VoiceAdvice-Method by Audiomanagement
     * will be forwarded to the AudioOutputThread.</p>
     *
     * @return The value of the field "DeviceName"
     */
    inline const ::std::string& getDeviceName () const;

    /**
     * Retrieves the value of the field "DeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceName".
     */
    inline ::std::string& getDeviceNameMutable ();

    /**
     * Sets the value of the member "DeviceName".
     *
     * <p>Devicename given by VoiceAdvice-Method by Audiomanagement
     * will be forwarded to the AudioOutputThread.</p>
     *
     * @param DeviceName The value which will be set
     */
    inline void setDeviceName (const ::std::string& DeviceName_);

    /**
     * Sets the value of the member "DeviceName".
     *
     * <p>Devicename given by VoiceAdvice-Method by Audiomanagement
     * will be forwarded to the AudioOutputThread.</p>
     *
     * @param DeviceName The value which will be set
     */
    inline void setDeviceName (const char* DeviceName_);

    /**
     * Sets the value of the member "DeviceName".
     *
     * <p>Devicename given by VoiceAdvice-Method by Audiomanagement
     * will be forwarded to the AudioOutputThread.</p>
     *
     * @param DeviceName The value which will be set
     */
    inline void setDeviceName (const char* value, size_t size);

    static const DoPrepareAudioOutputStart &getDefaultInstance();

private:

    inline void set_has_DeviceName ();

    inline void clear_has_DeviceName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _DeviceName;

};

/**
 * The error message of 'DoPrepareAudioOutput'
 */
class DoPrepareAudioOutputError  : public ::asf::core::Payload {
public:

    enum DoPrepareAudioOutputErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DoPrepareAudioOutputError ();

   /**
     * Copy constructor
     */
    inline  DoPrepareAudioOutputError (const DoPrepareAudioOutputError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DoPrepareAudioOutputError();

    /**
     * Assigns a new value to this object.
     */
    inline DoPrepareAudioOutputError& operator = (const DoPrepareAudioOutputError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoPrepareAudioOutputError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoPrepareAudioOutputError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoPrepareAudioOutputError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoPrepareAudioOutputError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DoPrepareAudioOutputError::DoPrepareAudioOutputErrorField getField () const;

    inline void setField(DoPrepareAudioOutputError::DoPrepareAudioOutputErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DoPrepareAudioOutputErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DoPrepareAudioOutputErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline DoPrepareAudioOutputErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DoPrepareAudioOutputErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (DoPrepareAudioOutputErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DoPrepareAudioOutputError &getDefaultInstance();

private:

    inline void cloneData (const DoPrepareAudioOutputError& rhs);

    inline void deleteData ();

    DoPrepareAudioOutputErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DoAudioOutputSpeak"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of not used parameters).</p>
 * Test requirement : "no test"
 */
class DoAudioOutputSpeakStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoAudioOutputSpeakStart ();

    /**
     * Copy constructor
     */
    inline  DoAudioOutputSpeakStart (const DoAudioOutputSpeakStart &rhs);

    /**
     * All fields constructor
     */
    inline  DoAudioOutputSpeakStart (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_, const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_);

    /**
     * Destructor
     */
    inline virtual  ~DoAudioOutputSpeakStart();

    /**
     * Assignment operator
     */
    inline DoAudioOutputSpeakStart& operator = (const DoAudioOutputSpeakStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoAudioOutputSpeakStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoAudioOutputSpeakStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoAudioOutputSpeakStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoAudioOutputSpeakStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StatusInfo"

    static const int kStatusInfo = 0;

    /**
     * Clears the field "StatusInfo".
     *
     * The field will be set to its default value. The hasStatusInfo()
     * method will return false.
     */
    inline void clearStatusInfo();

    /**
     * Checks whether the field "StatusInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusInfo()). Otherwise it will return false.
     */
    inline bool hasStatusInfo () const;

    /**
     * Returns the value of the member "StatusInfo".
     *
     * <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     *
     * @return The value of the field "StatusInfo"
     */
    inline ::sds_tts_fi_types::T_e8_StatusInfoOption getStatusInfo () const;

    /**
     * Sets the value of the member "StatusInfo".
     *
     * <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     *
     * @param StatusInfo The value which will be set
     */
    inline void setStatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_);

    // API of field "AudioOutputLocation"

    static const int kAudioOutputLocation = 1;

    /**
     * Clears the field "AudioOutputLocation".
     *
     * The field will be set to its default value. The hasAudioOutputLocation()
     * method will return false.
     */
    inline void clearAudioOutputLocation();

    /**
     * Checks whether the field "AudioOutputLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioOutputLocation()). Otherwise it will return false.
     */
    inline bool hasAudioOutputLocation () const;

    /**
     * Returns the value of the member "AudioOutputLocation".
     *
     * This parameter can be used to define the ouputlocation.
     * This parameter may be used, if a client needs a playback at one
     * special outputlocation (e.g. if the synthesis of an email has
     * been haptically initiated for the rear-left-headphones).
     * The type is defined in the ACR_FI as a bitfield. Most of the time,
     * the standard=0 will be used.
     *
     * @return The value of the field "AudioOutputLocation"
     */
    inline const ::acr_fi_types::T_b8_AudioOutputLocation& getAudioOutputLocation () const;

    /**
     * Retrieves the value of the field "AudioOutputLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AudioOutputLocation".
     */
    inline ::acr_fi_types::T_b8_AudioOutputLocation& getAudioOutputLocationMutable ();

    /**
     * Sets the value of the member "AudioOutputLocation".
     *
     * This parameter can be used to define the ouputlocation.
     * This parameter may be used, if a client needs a playback at one
     * special outputlocation (e.g. if the synthesis of an email has
     * been haptically initiated for the rear-left-headphones).
     * The type is defined in the ACR_FI as a bitfield. Most of the time,
     * the standard=0 will be used.
     *
     * @param AudioOutputLocation The value which will be set
     */
    inline void setAudioOutputLocation (const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_);

    static const DoAudioOutputSpeakStart &getDefaultInstance();

private:

    inline void set_has_StatusInfo ();

    inline void clear_has_StatusInfo ();

    inline void set_has_AudioOutputLocation ();

    inline void clear_has_AudioOutputLocation ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sds_tts_fi_types::T_e8_StatusInfoOption _StatusInfo;

    ::acr_fi_types::T_b8_AudioOutputLocation _AudioOutputLocation;

};

/**
 * The result first message of the method "DoAudioOutputSpeak"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of not used parameters).</p>
 * Test requirement : "no test"
 */
class DoAudioOutputSpeakResultFirst  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoAudioOutputSpeakResultFirst ();

    /**
     * Copy constructor
     */
    inline  DoAudioOutputSpeakResultFirst (const DoAudioOutputSpeakResultFirst &rhs);

    /**
     * All fields constructor
     */
    inline  DoAudioOutputSpeakResultFirst (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    /**
     * Destructor
     */
    inline virtual  ~DoAudioOutputSpeakResultFirst();

    /**
     * Assignment operator
     */
    inline DoAudioOutputSpeakResultFirst& operator = (const DoAudioOutputSpeakResultFirst& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoAudioOutputSpeakResultFirst& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoAudioOutputSpeakResultFirst& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoAudioOutputSpeakResultFirst& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoAudioOutputSpeakResultFirst& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobProgress"

    static const int kJobProgress = 0;

    /**
     * Clears the field "JobProgress".
     *
     * The field will be set to its default value. The hasJobProgress()
     * method will return false.
     */
    inline void clearJobProgress();

    /**
     * Checks whether the field "JobProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobProgress()). Otherwise it will return false.
     */
    inline bool hasJobProgress () const;

    /**
     * Returns the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / progress of synthesis.</p>
     * <p>If the job has been queued before (e.g. due to priority), now the client
     * will be informed, that the job has been started now.</p>
     *
     * @return The value of the field "JobProgress"
     */
    inline const ::sds_tts_fi_types::T_SpeakProgress& getJobProgress () const;

    /**
     * Retrieves the value of the field "JobProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JobProgress".
     */
    inline ::sds_tts_fi_types::T_SpeakProgress& getJobProgressMutable ();

    /**
     * Sets the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / progress of synthesis.</p>
     * <p>If the job has been queued before (e.g. due to priority), now the client
     * will be informed, that the job has been started now.</p>
     *
     * @param JobProgress The value which will be set
     */
    inline void setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    static const DoAudioOutputSpeakResultFirst &getDefaultInstance();

private:

    inline void set_has_JobProgress ();

    inline void clear_has_JobProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_SpeakProgress _JobProgress;

};

/**
 * The result middle message of the method "DoAudioOutputSpeak"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of not used parameters).</p>
 * Test requirement : "no test"
 */
class DoAudioOutputSpeakResultMiddle  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoAudioOutputSpeakResultMiddle ();

    /**
     * Copy constructor
     */
    inline  DoAudioOutputSpeakResultMiddle (const DoAudioOutputSpeakResultMiddle &rhs);

    /**
     * All fields constructor
     */
    inline  DoAudioOutputSpeakResultMiddle (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    /**
     * Destructor
     */
    inline virtual  ~DoAudioOutputSpeakResultMiddle();

    /**
     * Assignment operator
     */
    inline DoAudioOutputSpeakResultMiddle& operator = (const DoAudioOutputSpeakResultMiddle& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoAudioOutputSpeakResultMiddle& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoAudioOutputSpeakResultMiddle& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoAudioOutputSpeakResultMiddle& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoAudioOutputSpeakResultMiddle& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobProgress"

    static const int kJobProgress = 0;

    /**
     * Clears the field "JobProgress".
     *
     * The field will be set to its default value. The hasJobProgress()
     * method will return false.
     */
    inline void clearJobProgress();

    /**
     * Checks whether the field "JobProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobProgress()). Otherwise it will return false.
     */
    inline bool hasJobProgress () const;

    /**
     * Returns the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / progress of synthesis.</p>
     * <p>If the job has been queued before (e.g. due to priority), now the client
     * will be informed, that the job has been started now.</p>
     *
     * @return The value of the field "JobProgress"
     */
    inline const ::sds_tts_fi_types::T_SpeakProgress& getJobProgress () const;

    /**
     * Retrieves the value of the field "JobProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JobProgress".
     */
    inline ::sds_tts_fi_types::T_SpeakProgress& getJobProgressMutable ();

    /**
     * Sets the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / progress of synthesis.</p>
     * <p>If the job has been queued before (e.g. due to priority), now the client
     * will be informed, that the job has been started now.</p>
     *
     * @param JobProgress The value which will be set
     */
    inline void setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    static const DoAudioOutputSpeakResultMiddle &getDefaultInstance();

private:

    inline void set_has_JobProgress ();

    inline void clear_has_JobProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_SpeakProgress _JobProgress;

};

/**
 * The result last message of the method "DoAudioOutputSpeak"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of not used parameters).</p>
 * Test requirement : "no test"
 */
class DoAudioOutputSpeakResultLast  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoAudioOutputSpeakResultLast ();

    /**
     * Copy constructor
     */
    inline  DoAudioOutputSpeakResultLast (const DoAudioOutputSpeakResultLast &rhs);

    /**
     * All fields constructor
     */
    inline  DoAudioOutputSpeakResultLast (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    /**
     * Destructor
     */
    inline virtual  ~DoAudioOutputSpeakResultLast();

    /**
     * Assignment operator
     */
    inline DoAudioOutputSpeakResultLast& operator = (const DoAudioOutputSpeakResultLast& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoAudioOutputSpeakResultLast& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoAudioOutputSpeakResultLast& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoAudioOutputSpeakResultLast& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoAudioOutputSpeakResultLast& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobProgress"

    static const int kJobProgress = 0;

    /**
     * Clears the field "JobProgress".
     *
     * The field will be set to its default value. The hasJobProgress()
     * method will return false.
     */
    inline void clearJobProgress();

    /**
     * Checks whether the field "JobProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobProgress()). Otherwise it will return false.
     */
    inline bool hasJobProgress () const;

    /**
     * Returns the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / number of spoken words or sentences.</p>
     * <p>With this message, the client will be informed, that the job has been finished,</p>
     * <p>even if he didn't want to be informed about the job progress.</p>
     *
     * @return The value of the field "JobProgress"
     */
    inline const ::sds_tts_fi_types::T_SpeakProgress& getJobProgress () const;

    /**
     * Retrieves the value of the field "JobProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JobProgress".
     */
    inline ::sds_tts_fi_types::T_SpeakProgress& getJobProgressMutable ();

    /**
     * Sets the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / number of spoken words or sentences.</p>
     * <p>With this message, the client will be informed, that the job has been finished,</p>
     * <p>even if he didn't want to be informed about the job progress.</p>
     *
     * @param JobProgress The value which will be set
     */
    inline void setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    static const DoAudioOutputSpeakResultLast &getDefaultInstance();

private:

    inline void set_has_JobProgress ();

    inline void clear_has_JobProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_SpeakProgress _JobProgress;

};

/**
 * The start message of the method "DoSynthesisForWrite"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeWrite
 * (except of not used parameter ExpDate).</p>
 * Test requirement : "no test"
 */
class DoSynthesisForWriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoSynthesisForWriteStart ();

    /**
     * Copy constructor
     */
    inline  DoSynthesisForWriteStart (const DoSynthesisForWriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  DoSynthesisForWriteStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_, bool LastPackage_);

    /**
     * Destructor
     */
    inline virtual  ~DoSynthesisForWriteStart();

    /**
     * Assignment operator
     */
    inline DoSynthesisForWriteStart& operator = (const DoSynthesisForWriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoSynthesisForWriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoSynthesisForWriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoSynthesisForWriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoSynthesisForWriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TextAndTags"

    static const int kTextAndTags = 0;

    /**
     * Clears the field "TextAndTags".
     *
     * The field will be set to its default value. The hasTextAndTags()
     * method will return false.
     */
    inline void clearTextAndTags();

    /**
     * Checks whether the field "TextAndTags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextAndTags()). Otherwise it will return false.
     */
    inline bool hasTextAndTags () const;

    /**
     * Returns the value of the member "TextAndTags".
     *
     * In addition to the design of this string and the dic-tag described in the SynthesizeSpeak-Method,
     * this method has one more tag. Thus, this method provides two tags, which are <dict> and <file>:
     * The dict-tag is used in the same way as with SynthesizeSpeak.
     * The second tag <file>Text</file> indicates, what parts of the string must be saved to shared memory.
     *
     * @return The value of the field "TextAndTags"
     */
    inline const ::std::string& getTextAndTags () const;

    /**
     * Retrieves the value of the field "TextAndTags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TextAndTags".
     */
    inline ::std::string& getTextAndTagsMutable ();

    /**
     * Sets the value of the member "TextAndTags".
     *
     * In addition to the design of this string and the dic-tag described in the SynthesizeSpeak-Method,
     * this method has one more tag. Thus, this method provides two tags, which are <dict> and <file>:
     * The dict-tag is used in the same way as with SynthesizeSpeak.
     * The second tag <file>Text</file> indicates, what parts of the string must be saved to shared memory.
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const ::std::string& TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * In addition to the design of this string and the dic-tag described in the SynthesizeSpeak-Method,
     * this method has one more tag. Thus, this method provides two tags, which are <dict> and <file>:
     * The dict-tag is used in the same way as with SynthesizeSpeak.
     * The second tag <file>Text</file> indicates, what parts of the string must be saved to shared memory.
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * In addition to the design of this string and the dic-tag described in the SynthesizeSpeak-Method,
     * this method has one more tag. Thus, this method provides two tags, which are <dict> and <file>:
     * The dict-tag is used in the same way as with SynthesizeSpeak.
     * The second tag <file>Text</file> indicates, what parts of the string must be saved to shared memory.
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* value, size_t size);

    // API of field "TextStyle"

    static const int kTextStyle = 1;

    /**
     * Clears the field "TextStyle".
     *
     * The field will be set to its default value. The hasTextStyle()
     * method will return false.
     */
    inline void clearTextStyle();

    /**
     * Checks whether the field "TextStyle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextStyle()). Otherwise it will return false.
     */
    inline bool hasTextStyle () const;

    /**
     * Returns the value of the member "TextStyle".
     *
     * This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).
     *
     * @return The value of the field "TextStyle"
     */
    inline ::sds_tts_fi_types::T_e8_TextStyleOption getTextStyle () const;

    /**
     * Sets the value of the member "TextStyle".
     *
     * This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).
     *
     * @param TextStyle The value which will be set
     */
    inline void setTextStyle (::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_);

    // API of field "LastPackage"

    static const int kLastPackage = 2;

    /**
     * Clears the field "LastPackage".
     *
     * The field will be set to its default value. The hasLastPackage()
     * method will return false.
     */
    inline void clearLastPackage();

    /**
     * Checks whether the field "LastPackage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastPackage()). Otherwise it will return false.
     */
    inline bool hasLastPackage () const;

    /**
     * Returns the value of the member "LastPackage".
     *
     * <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue.</p>
     *
     * @return The value of the field "LastPackage"
     */
    inline bool getLastPackage () const;

    /**
     * Sets the value of the member "LastPackage".
     *
     * <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue.</p>
     *
     * @param LastPackage The value which will be set
     */
    inline void setLastPackage (bool LastPackage_);

    static const DoSynthesisForWriteStart &getDefaultInstance();

private:

    inline void set_has_TextAndTags ();

    inline void clear_has_TextAndTags ();

    inline void set_has_TextStyle ();

    inline void clear_has_TextStyle ();

    inline void set_has_LastPackage ();

    inline void clear_has_LastPackage ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _TextAndTags;

    ::sds_tts_fi_types::T_e8_TextStyleOption _TextStyle;

    bool _LastPackage;

};

/**
 * The start message of the method "DoAudioOutputWrite"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeWrite
 * (except of not used parameters).</p>
 * Test requirement : "no test"
 */
class DoAudioOutputWriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoAudioOutputWriteStart ();

    /**
     * Copy constructor
     */
    inline  DoAudioOutputWriteStart (const DoAudioOutputWriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  DoAudioOutputWriteStart (::sds_tts_fi_types::T_e8_BufferingOption Buffering_, const ::acr_fi_types::T_b8_AudioFormat& Compression_);

    /**
     * Destructor
     */
    inline virtual  ~DoAudioOutputWriteStart();

    /**
     * Assignment operator
     */
    inline DoAudioOutputWriteStart& operator = (const DoAudioOutputWriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoAudioOutputWriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoAudioOutputWriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoAudioOutputWriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoAudioOutputWriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Buffering"

    static const int kBuffering = 0;

    /**
     * Clears the field "Buffering".
     *
     * The field will be set to its default value. The hasBuffering()
     * method will return false.
     */
    inline void clearBuffering();

    /**
     * Checks whether the field "Buffering" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBuffering()). Otherwise it will return false.
     */
    inline bool hasBuffering () const;

    /**
     * Returns the value of the member "Buffering".
     *
     * Defines the mode, how the client wants a file-block to be transmitted. At the time, two different
     * options are designed: Write one file-block to one buffer or write one file-block to multiple buffers of a defined size.
     * The size of this buffer is defined in the registry.
     *
     * @return The value of the field "Buffering"
     */
    inline ::sds_tts_fi_types::T_e8_BufferingOption getBuffering () const;

    /**
     * Sets the value of the member "Buffering".
     *
     * Defines the mode, how the client wants a file-block to be transmitted. At the time, two different
     * options are designed: Write one file-block to one buffer or write one file-block to multiple buffers of a defined size.
     * The size of this buffer is defined in the registry.
     *
     * @param Buffering The value which will be set
     */
    inline void setBuffering (::sds_tts_fi_types::T_e8_BufferingOption Buffering_);

    // API of field "Compression"

    static const int kCompression = 1;

    /**
     * Clears the field "Compression".
     *
     * The field will be set to its default value. The hasCompression()
     * method will return false.
     */
    inline void clearCompression();

    /**
     * Checks whether the field "Compression" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCompression()). Otherwise it will return false.
     */
    inline bool hasCompression () const;

    /**
     * Returns the value of the member "Compression".
     *
     * Kind of audio format to be used.
     *
     * @return The value of the field "Compression"
     */
    inline const ::acr_fi_types::T_b8_AudioFormat& getCompression () const;

    /**
     * Retrieves the value of the field "Compression" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Compression".
     */
    inline ::acr_fi_types::T_b8_AudioFormat& getCompressionMutable ();

    /**
     * Sets the value of the member "Compression".
     *
     * Kind of audio format to be used.
     *
     * @param Compression The value which will be set
     */
    inline void setCompression (const ::acr_fi_types::T_b8_AudioFormat& Compression_);

    static const DoAudioOutputWriteStart &getDefaultInstance();

private:

    inline void set_has_Buffering ();

    inline void clear_has_Buffering ();

    inline void set_has_Compression ();

    inline void clear_has_Compression ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sds_tts_fi_types::T_e8_BufferingOption _Buffering;

    ::acr_fi_types::T_b8_AudioFormat _Compression;

};

/**
 * The result first message of the method "DoAudioOutputWrite"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeWrite
 * (except of not used parameters).</p>
 * Test requirement : "no test"
 */
class DoAudioOutputWriteResultFirst  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoAudioOutputWriteResultFirst ();

    /**
     * Copy constructor
     */
    inline  DoAudioOutputWriteResultFirst (const DoAudioOutputWriteResultFirst &rhs);

    /**
     * All fields constructor
     */
    inline  DoAudioOutputWriteResultFirst (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_);

    /**
     * Destructor
     */
    inline virtual  ~DoAudioOutputWriteResultFirst();

    /**
     * Assignment operator
     */
    inline DoAudioOutputWriteResultFirst& operator = (const DoAudioOutputWriteResultFirst& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoAudioOutputWriteResultFirst& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoAudioOutputWriteResultFirst& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoAudioOutputWriteResultFirst& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoAudioOutputWriteResultFirst& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BufferingProgress"

    static const int kBufferingProgress = 0;

    /**
     * Clears the field "BufferingProgress".
     *
     * The field will be set to its default value. The hasBufferingProgress()
     * method will return false.
     */
    inline void clearBufferingProgress();

    /**
     * Checks whether the field "BufferingProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBufferingProgress()). Otherwise it will return false.
     */
    inline bool hasBufferingProgress () const;

    /**
     * Returns the value of the member "BufferingProgress".
     *
     * <p>Feedback to the client about the jobstatus and the location of the buffers.</p>
     * <p>List of basetype is necessary due to the usage of the streaming-mechanism.</p>
     *
     * @return The value of the field "BufferingProgress"
     */
    inline const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getBufferingProgress () const;

    /**
     * Retrieves the value of the field "BufferingProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BufferingProgress".
     */
    inline ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getBufferingProgressMutable ();

    /**
     * Sets the value of the member "BufferingProgress".
     *
     * <p>Feedback to the client about the jobstatus and the location of the buffers.</p>
     * <p>List of basetype is necessary due to the usage of the streaming-mechanism.</p>
     *
     * @param BufferingProgress The value which will be set
     */
    inline void setBufferingProgress (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_);

    static const DoAudioOutputWriteResultFirst &getDefaultInstance();

private:

    static const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getT_BufferingProgressList_DefaultInstance ();

    inline void set_has_BufferingProgress ();

    inline void clear_has_BufferingProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sds_tts_fi_types::T_BufferingProgress > _BufferingProgress;

};

/**
 * The result middle message of the method "DoAudioOutputWrite"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeWrite
 * (except of not used parameters).</p>
 * Test requirement : "no test"
 */
class DoAudioOutputWriteResultMiddle  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoAudioOutputWriteResultMiddle ();

    /**
     * Copy constructor
     */
    inline  DoAudioOutputWriteResultMiddle (const DoAudioOutputWriteResultMiddle &rhs);

    /**
     * All fields constructor
     */
    inline  DoAudioOutputWriteResultMiddle (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_);

    /**
     * Destructor
     */
    inline virtual  ~DoAudioOutputWriteResultMiddle();

    /**
     * Assignment operator
     */
    inline DoAudioOutputWriteResultMiddle& operator = (const DoAudioOutputWriteResultMiddle& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoAudioOutputWriteResultMiddle& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoAudioOutputWriteResultMiddle& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoAudioOutputWriteResultMiddle& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoAudioOutputWriteResultMiddle& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BufferingProgress"

    static const int kBufferingProgress = 0;

    /**
     * Clears the field "BufferingProgress".
     *
     * The field will be set to its default value. The hasBufferingProgress()
     * method will return false.
     */
    inline void clearBufferingProgress();

    /**
     * Checks whether the field "BufferingProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBufferingProgress()). Otherwise it will return false.
     */
    inline bool hasBufferingProgress () const;

    /**
     * Returns the value of the member "BufferingProgress".
     *
     * <p>Feedback to the client about the jobstatus and the location of the buffers.</p>
     * <p>List of basetype is necessary due to the usage of the streaming-mechanism.</p>
     *
     * @return The value of the field "BufferingProgress"
     */
    inline const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getBufferingProgress () const;

    /**
     * Retrieves the value of the field "BufferingProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BufferingProgress".
     */
    inline ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getBufferingProgressMutable ();

    /**
     * Sets the value of the member "BufferingProgress".
     *
     * <p>Feedback to the client about the jobstatus and the location of the buffers.</p>
     * <p>List of basetype is necessary due to the usage of the streaming-mechanism.</p>
     *
     * @param BufferingProgress The value which will be set
     */
    inline void setBufferingProgress (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_);

    static const DoAudioOutputWriteResultMiddle &getDefaultInstance();

private:

    static const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getT_BufferingProgressList_DefaultInstance ();

    inline void set_has_BufferingProgress ();

    inline void clear_has_BufferingProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sds_tts_fi_types::T_BufferingProgress > _BufferingProgress;

};

/**
 * The result last message of the method "DoAudioOutputWrite"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeWrite
 * (except of not used parameters).</p>
 * Test requirement : "no test"
 */
class DoAudioOutputWriteResultLast  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoAudioOutputWriteResultLast ();

    /**
     * Copy constructor
     */
    inline  DoAudioOutputWriteResultLast (const DoAudioOutputWriteResultLast &rhs);

    /**
     * All fields constructor
     */
    inline  DoAudioOutputWriteResultLast (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_);

    /**
     * Destructor
     */
    inline virtual  ~DoAudioOutputWriteResultLast();

    /**
     * Assignment operator
     */
    inline DoAudioOutputWriteResultLast& operator = (const DoAudioOutputWriteResultLast& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoAudioOutputWriteResultLast& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoAudioOutputWriteResultLast& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoAudioOutputWriteResultLast& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoAudioOutputWriteResultLast& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BufferingProgress"

    static const int kBufferingProgress = 0;

    /**
     * Clears the field "BufferingProgress".
     *
     * The field will be set to its default value. The hasBufferingProgress()
     * method will return false.
     */
    inline void clearBufferingProgress();

    /**
     * Checks whether the field "BufferingProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBufferingProgress()). Otherwise it will return false.
     */
    inline bool hasBufferingProgress () const;

    /**
     * Returns the value of the member "BufferingProgress".
     *
     * <p>Feedback to the client about the jobstatus and the location of the buffers.</p>
     * <p>List of basetype is necessary due to the usage of the streaming-mechanism.</p>
     *
     * @return The value of the field "BufferingProgress"
     */
    inline const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getBufferingProgress () const;

    /**
     * Retrieves the value of the field "BufferingProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BufferingProgress".
     */
    inline ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getBufferingProgressMutable ();

    /**
     * Sets the value of the member "BufferingProgress".
     *
     * <p>Feedback to the client about the jobstatus and the location of the buffers.</p>
     * <p>List of basetype is necessary due to the usage of the streaming-mechanism.</p>
     *
     * @param BufferingProgress The value which will be set
     */
    inline void setBufferingProgress (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_);

    static const DoAudioOutputWriteResultLast &getDefaultInstance();

private:

    static const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& getT_BufferingProgressList_DefaultInstance ();

    inline void set_has_BufferingProgress ();

    inline void clear_has_BufferingProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sds_tts_fi_types::T_BufferingProgress > _BufferingProgress;

};

/**
 * The start message of the method "DoSynthesisForSpeakWithExtention"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of the 2 not used parameters AudioOutputLocation and ExpDate).</p>
 * Test requirement : "no test"
 */
class DoSynthesisForSpeakWithExtentionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoSynthesisForSpeakWithExtentionStart ();

    /**
     * Copy constructor
     */
    inline  DoSynthesisForSpeakWithExtentionStart (const DoSynthesisForSpeakWithExtentionStart &rhs);

    /**
     * All fields constructor
     */
    inline  DoSynthesisForSpeakWithExtentionStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_AudioSourceID TextStyle_, ::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_, bool LastPackage_);

    /**
     * Destructor
     */
    inline virtual  ~DoSynthesisForSpeakWithExtentionStart();

    /**
     * Assignment operator
     */
    inline DoSynthesisForSpeakWithExtentionStart& operator = (const DoSynthesisForSpeakWithExtentionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoSynthesisForSpeakWithExtentionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoSynthesisForSpeakWithExtentionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoSynthesisForSpeakWithExtentionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoSynthesisForSpeakWithExtentionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TextAndTags"

    static const int kTextAndTags = 0;

    /**
     * Clears the field "TextAndTags".
     *
     * The field will be set to its default value. The hasTextAndTags()
     * method will return false.
     */
    inline void clearTextAndTags();

    /**
     * Checks whether the field "TextAndTags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextAndTags()). Otherwise it will return false.
     */
    inline bool hasTextAndTags () const;

    /**
     * Returns the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionaly,
     * a tags can be used within the string to give some extra
     * information. For this method, the tag is <dict>:
     * The dict-tag can be used to give information about the
     * dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... country=... lang=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type the
     * dest-parameter is (SelectionCriterionType or SpeechAppDictType).</p>
     * <p>Destcat has to be used according to the definition in the sp_speechdp_fi.
     * Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType) respectively sp_speechdp_fi (SpeechAppDictType).</p>
     * <p>The parameters country and language must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     *
     * @return The value of the field "TextAndTags"
     */
    inline const ::std::string& getTextAndTags () const;

    /**
     * Retrieves the value of the field "TextAndTags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TextAndTags".
     */
    inline ::std::string& getTextAndTagsMutable ();

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionaly,
     * a tags can be used within the string to give some extra
     * information. For this method, the tag is <dict>:
     * The dict-tag can be used to give information about the
     * dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... country=... lang=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type the
     * dest-parameter is (SelectionCriterionType or SpeechAppDictType).</p>
     * <p>Destcat has to be used according to the definition in the sp_speechdp_fi.
     * Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType) respectively sp_speechdp_fi (SpeechAppDictType).</p>
     * <p>The parameters country and language must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const ::std::string& TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionaly,
     * a tags can be used within the string to give some extra
     * information. For this method, the tag is <dict>:
     * The dict-tag can be used to give information about the
     * dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... country=... lang=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type the
     * dest-parameter is (SelectionCriterionType or SpeechAppDictType).</p>
     * <p>Destcat has to be used according to the definition in the sp_speechdp_fi.
     * Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType) respectively sp_speechdp_fi (SpeechAppDictType).</p>
     * <p>The parameters country and language must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionaly,
     * a tags can be used within the string to give some extra
     * information. For this method, the tag is <dict>:
     * The dict-tag can be used to give information about the
     * dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... country=... lang=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type the
     * dest-parameter is (SelectionCriterionType or SpeechAppDictType).</p>
     * <p>Destcat has to be used according to the definition in the sp_speechdp_fi.
     * Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType) respectively sp_speechdp_fi (SpeechAppDictType).</p>
     * <p>The parameters country and language must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* value, size_t size);

    // API of field "TextStyle"

    static const int kTextStyle = 1;

    /**
     * Clears the field "TextStyle".
     *
     * The field will be set to its default value. The hasTextStyle()
     * method will return false.
     */
    inline void clearTextStyle();

    /**
     * Checks whether the field "TextStyle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextStyle()). Otherwise it will return false.
     */
    inline bool hasTextStyle () const;

    /**
     * Returns the value of the member "TextStyle".
     *
     * This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).
     *
     * @return The value of the field "TextStyle"
     */
    inline ::sds_tts_fi_types::T_e8_AudioSourceID getTextStyle () const;

    /**
     * Sets the value of the member "TextStyle".
     *
     * This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).
     *
     * @param TextStyle The value which will be set
     */
    inline void setTextStyle (::sds_tts_fi_types::T_e8_AudioSourceID TextStyle_);

    // API of field "StatusInfo"

    static const int kStatusInfo = 2;

    /**
     * Clears the field "StatusInfo".
     *
     * The field will be set to its default value. The hasStatusInfo()
     * method will return false.
     */
    inline void clearStatusInfo();

    /**
     * Checks whether the field "StatusInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusInfo()). Otherwise it will return false.
     */
    inline bool hasStatusInfo () const;

    /**
     * Returns the value of the member "StatusInfo".
     *
     * <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     *
     * @return The value of the field "StatusInfo"
     */
    inline ::sds_tts_fi_types::T_e8_StatusInfoOption getStatusInfo () const;

    /**
     * Sets the value of the member "StatusInfo".
     *
     * <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     *
     * @param StatusInfo The value which will be set
     */
    inline void setStatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_);

    // API of field "LastPackage"

    static const int kLastPackage = 3;

    /**
     * Clears the field "LastPackage".
     *
     * The field will be set to its default value. The hasLastPackage()
     * method will return false.
     */
    inline void clearLastPackage();

    /**
     * Checks whether the field "LastPackage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastPackage()). Otherwise it will return false.
     */
    inline bool hasLastPackage () const;

    /**
     * Returns the value of the member "LastPackage".
     *
     * <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue not sent at that time.
     * Already queued jobparts of this job will be deleted by the FC TTS.</p>
     *
     * @return The value of the field "LastPackage"
     */
    inline bool getLastPackage () const;

    /**
     * Sets the value of the member "LastPackage".
     *
     * <p>Client informs the TTS-server, if this job contains text which is divided into multiple jobs.</p>
     * <p>True: This is only or last Job, False: Other parts of same text will follow.</p>
     * <p>This parameter gives the possibility, to divide large texts into small jobs.</p>
     * <p>Other jobs have to wait (if not with higher priority), until parameter is set to True.</p>
     * <p>If a higher priority job cancels the running job, the client will be informed about it.
     * At this time, the client has to delete the rest of his own queue not sent at that time.
     * Already queued jobparts of this job will be deleted by the FC TTS.</p>
     *
     * @param LastPackage The value which will be set
     */
    inline void setLastPackage (bool LastPackage_);

    static const DoSynthesisForSpeakWithExtentionStart &getDefaultInstance();

private:

    inline void set_has_TextAndTags ();

    inline void clear_has_TextAndTags ();

    inline void set_has_TextStyle ();

    inline void clear_has_TextStyle ();

    inline void set_has_StatusInfo ();

    inline void clear_has_StatusInfo ();

    inline void set_has_LastPackage ();

    inline void clear_has_LastPackage ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _TextAndTags;

    ::sds_tts_fi_types::T_e8_AudioSourceID _TextStyle;

    ::sds_tts_fi_types::T_e8_StatusInfoOption _StatusInfo;

    bool _LastPackage;

};

/**
 * The start message of the method "DoReleaseData"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method ReleaseData.</p>
 * Test requirement : "no test"
 */
class DoReleaseDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoReleaseDataStart ();

    /**
     * Copy constructor
     */
    inline  DoReleaseDataStart (const DoReleaseDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  DoReleaseDataStart (::sds_tts_fi_types::T_e8_ReleaseTypeTTS ReleaseType_);

    /**
     * Destructor
     */
    inline virtual  ~DoReleaseDataStart();

    /**
     * Assignment operator
     */
    inline DoReleaseDataStart& operator = (const DoReleaseDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoReleaseDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoReleaseDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoReleaseDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoReleaseDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ReleaseType"

    static const int kReleaseType = 0;

    /**
     * Clears the field "ReleaseType".
     *
     * The field will be set to its default value. The hasReleaseType()
     * method will return false.
     */
    inline void clearReleaseType();

    /**
     * Checks whether the field "ReleaseType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReleaseType()). Otherwise it will return false.
     */
    inline bool hasReleaseType () const;

    /**
     * Returns the value of the member "ReleaseType".
     *
     * The type of data, which will not be needed any more/will be changed.
     *
     * @return The value of the field "ReleaseType"
     */
    inline ::sds_tts_fi_types::T_e8_ReleaseTypeTTS getReleaseType () const;

    /**
     * Sets the value of the member "ReleaseType".
     *
     * The type of data, which will not be needed any more/will be changed.
     *
     * @param ReleaseType The value which will be set
     */
    inline void setReleaseType (::sds_tts_fi_types::T_e8_ReleaseTypeTTS ReleaseType_);

    static const DoReleaseDataStart &getDefaultInstance();

private:

    inline void set_has_ReleaseType ();

    inline void clear_has_ReleaseType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_e8_ReleaseTypeTTS _ReleaseType;

};

/**
 * The error message of 'DoReleaseData'
 */
class DoReleaseDataError  : public ::asf::core::Payload {
public:

    enum DoReleaseDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DoReleaseDataError ();

   /**
     * Copy constructor
     */
    inline  DoReleaseDataError (const DoReleaseDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DoReleaseDataError();

    /**
     * Assigns a new value to this object.
     */
    inline DoReleaseDataError& operator = (const DoReleaseDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoReleaseDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoReleaseDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoReleaseDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoReleaseDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DoReleaseDataError::DoReleaseDataErrorField getField () const;

    inline void setField(DoReleaseDataError::DoReleaseDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DoReleaseDataErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DoReleaseDataErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline DoReleaseDataErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DoReleaseDataErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (DoReleaseDataErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DoReleaseDataError &getDefaultInstance();

private:

    inline void cloneData (const DoReleaseDataError& rhs);

    inline void deleteData ();

    DoReleaseDataErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DoRequestPhoneme"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method ReleaseData.</p>
 * Test requirement : "no test"
 */
class DoRequestPhonemeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoRequestPhonemeStart ();

    /**
     * Copy constructor
     */
    inline  DoRequestPhonemeStart (const DoRequestPhonemeStart &rhs);

    /**
     * All fields constructor
     */
    inline  DoRequestPhonemeStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_);

    /**
     * Destructor
     */
    inline virtual  ~DoRequestPhonemeStart();

    /**
     * Assignment operator
     */
    inline DoRequestPhonemeStart& operator = (const DoRequestPhonemeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoRequestPhonemeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoRequestPhonemeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoRequestPhonemeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoRequestPhonemeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TextAndTags"

    static const int kTextAndTags = 0;

    /**
     * Clears the field "TextAndTags".
     *
     * The field will be set to its default value. The hasTextAndTags()
     * method will return false.
     */
    inline void clearTextAndTags();

    /**
     * Checks whether the field "TextAndTags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextAndTags()). Otherwise it will return false.
     */
    inline bool hasTextAndTags () const;

    /**
     * Returns the value of the member "TextAndTags".
     *
     * <p>Element containing Text and ID for phoneme substitution:
     * <file id=...> <dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict> </file></p>
     * <p>Also multiple occurences of this file/dict combination are allowed
     * (<file id=...> <dict ... >String</dict> </file> <file id=...> <dict ... >String</dict> </file>)</p>
     * <p>The  tag <file id=...>Text</file> surrounds the string which has to be converted to phonemes.
     * The (client-specific) ID within the file-tag is transmitted by the client and will be sent back with the MethodResult.</p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p>
     *
     * @return The value of the field "TextAndTags"
     */
    inline const ::std::string& getTextAndTags () const;

    /**
     * Retrieves the value of the field "TextAndTags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TextAndTags".
     */
    inline ::std::string& getTextAndTagsMutable ();

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>Element containing Text and ID for phoneme substitution:
     * <file id=...> <dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict> </file></p>
     * <p>Also multiple occurences of this file/dict combination are allowed
     * (<file id=...> <dict ... >String</dict> </file> <file id=...> <dict ... >String</dict> </file>)</p>
     * <p>The  tag <file id=...>Text</file> surrounds the string which has to be converted to phonemes.
     * The (client-specific) ID within the file-tag is transmitted by the client and will be sent back with the MethodResult.</p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p>
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const ::std::string& TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>Element containing Text and ID for phoneme substitution:
     * <file id=...> <dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict> </file></p>
     * <p>Also multiple occurences of this file/dict combination are allowed
     * (<file id=...> <dict ... >String</dict> </file> <file id=...> <dict ... >String</dict> </file>)</p>
     * <p>The  tag <file id=...>Text</file> surrounds the string which has to be converted to phonemes.
     * The (client-specific) ID within the file-tag is transmitted by the client and will be sent back with the MethodResult.</p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p>
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>Element containing Text and ID for phoneme substitution:
     * <file id=...> <dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict> </file></p>
     * <p>Also multiple occurences of this file/dict combination are allowed
     * (<file id=...> <dict ... >String</dict> </file> <file id=...> <dict ... >String</dict> </file>)</p>
     * <p>The  tag <file id=...>Text</file> surrounds the string which has to be converted to phonemes.
     * The (client-specific) ID within the file-tag is transmitted by the client and will be sent back with the MethodResult.</p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p>
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* value, size_t size);

    // API of field "TextStyle"

    static const int kTextStyle = 1;

    /**
     * Clears the field "TextStyle".
     *
     * The field will be set to its default value. The hasTextStyle()
     * method will return false.
     */
    inline void clearTextStyle();

    /**
     * Checks whether the field "TextStyle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextStyle()). Otherwise it will return false.
     */
    inline bool hasTextStyle () const;

    /**
     * Returns the value of the member "TextStyle".
     *
     * This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).
     *
     * @return The value of the field "TextStyle"
     */
    inline ::sds_tts_fi_types::T_e8_TextStyleOption getTextStyle () const;

    /**
     * Sets the value of the member "TextStyle".
     *
     * This parameter describes the kind of text transmitted (email,
     * sms, dicts (dict-tags included) and plain (plain text)).
     *
     * @param TextStyle The value which will be set
     */
    inline void setTextStyle (::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_);

    static const DoRequestPhonemeStart &getDefaultInstance();

private:

    inline void set_has_TextAndTags ();

    inline void clear_has_TextAndTags ();

    inline void set_has_TextStyle ();

    inline void clear_has_TextStyle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _TextAndTags;

    ::sds_tts_fi_types::T_e8_TextStyleOption _TextStyle;

};

/**
 * The result message of the method "DoRequestPhoneme"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method ReleaseData.</p>
 * Test requirement : "no test"
 */
class DoRequestPhonemeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoRequestPhonemeResult ();

    /**
     * Copy constructor
     */
    inline  DoRequestPhonemeResult (const DoRequestPhonemeResult &rhs);

    /**
     * All fields constructor
     */
    inline  DoRequestPhonemeResult (const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& PhonemeList_);

    /**
     * Destructor
     */
    inline virtual  ~DoRequestPhonemeResult();

    /**
     * Assignment operator
     */
    inline DoRequestPhonemeResult& operator = (const DoRequestPhonemeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoRequestPhonemeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoRequestPhonemeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoRequestPhonemeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoRequestPhonemeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhonemeList"

    static const int kPhonemeList = 0;

    /**
     * Clears the field "PhonemeList".
     *
     * The field will be set to its default value. The hasPhonemeList()
     * method will return false.
     */
    inline void clearPhonemeList();

    /**
     * Checks whether the field "PhonemeList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonemeList()). Otherwise it will return false.
     */
    inline bool hasPhonemeList () const;

    /**
     * Returns the value of the member "PhonemeList".
     *
     * <p>The PhonemeList contains the phoneme substitutions combined with the fileID they are requested for.</p>
     *
     * @return The value of the field "PhonemeList"
     */
    inline const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& getPhonemeList () const;

    /**
     * Retrieves the value of the field "PhonemeList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhonemeList".
     */
    inline ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& getPhonemeListMutable ();

    /**
     * Sets the value of the member "PhonemeList".
     *
     * <p>The PhonemeList contains the phoneme substitutions combined with the fileID they are requested for.</p>
     *
     * @param PhonemeList The value which will be set
     */
    inline void setPhonemeList (const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& PhonemeList_);

    static const DoRequestPhonemeResult &getDefaultInstance();

private:

    static const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& getT_TTSPhonemeResultList_DefaultInstance ();

    inline void set_has_PhonemeList ();

    inline void clear_has_PhonemeList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult > _PhonemeList;

};

/**
 * The error message of 'DoRequestPhoneme'
 */
class DoRequestPhonemeError  : public ::asf::core::Payload {
public:

    enum DoRequestPhonemeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DoRequestPhonemeError ();

   /**
     * Copy constructor
     */
    inline  DoRequestPhonemeError (const DoRequestPhonemeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DoRequestPhonemeError();

    /**
     * Assigns a new value to this object.
     */
    inline DoRequestPhonemeError& operator = (const DoRequestPhonemeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoRequestPhonemeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoRequestPhonemeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoRequestPhonemeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoRequestPhonemeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DoRequestPhonemeError::DoRequestPhonemeErrorField getField () const;

    inline void setField(DoRequestPhonemeError::DoRequestPhonemeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DoRequestPhonemeErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DoRequestPhonemeErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline DoRequestPhonemeErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DoRequestPhonemeErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (DoRequestPhonemeErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DoRequestPhonemeError &getDefaultInstance();

private:

    inline void cloneData (const DoRequestPhonemeError& rhs);

    inline void deleteData ();

    DoRequestPhonemeErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DoAudioOutputSpeakWithExtension"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of not used parameters).</p>
 * Test requirement : "no test"
 */
class DoAudioOutputSpeakWithExtensionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoAudioOutputSpeakWithExtensionStart ();

    /**
     * Copy constructor
     */
    inline  DoAudioOutputSpeakWithExtensionStart (const DoAudioOutputSpeakWithExtensionStart &rhs);

    /**
     * All fields constructor
     */
    inline  DoAudioOutputSpeakWithExtensionStart (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_, const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_);

    /**
     * Destructor
     */
    inline virtual  ~DoAudioOutputSpeakWithExtensionStart();

    /**
     * Assignment operator
     */
    inline DoAudioOutputSpeakWithExtensionStart& operator = (const DoAudioOutputSpeakWithExtensionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoAudioOutputSpeakWithExtensionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoAudioOutputSpeakWithExtensionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoAudioOutputSpeakWithExtensionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoAudioOutputSpeakWithExtensionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StatusInfo"

    static const int kStatusInfo = 0;

    /**
     * Clears the field "StatusInfo".
     *
     * The field will be set to its default value. The hasStatusInfo()
     * method will return false.
     */
    inline void clearStatusInfo();

    /**
     * Checks whether the field "StatusInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusInfo()). Otherwise it will return false.
     */
    inline bool hasStatusInfo () const;

    /**
     * Returns the value of the member "StatusInfo".
     *
     * <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     *
     * @return The value of the field "StatusInfo"
     */
    inline ::sds_tts_fi_types::T_e8_StatusInfoOption getStatusInfo () const;

    /**
     * Sets the value of the member "StatusInfo".
     *
     * <p>Defines the method, how the client wants to be informed
     * about the progress of the job.
     * Possible methods: "No information", "each spoken word",
     * "each spoken sentence", "word and sentence".</p>
     * <p>If a client uses "No information", all information described
     * in the type "T_e8_JobStatus" will be transmitted anyway.
     * Only information about the spoken words and sentences will
     * be suppressed.</p>
     *
     * @param StatusInfo The value which will be set
     */
    inline void setStatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_);

    // API of field "AudioOutputLocation"

    static const int kAudioOutputLocation = 1;

    /**
     * Clears the field "AudioOutputLocation".
     *
     * The field will be set to its default value. The hasAudioOutputLocation()
     * method will return false.
     */
    inline void clearAudioOutputLocation();

    /**
     * Checks whether the field "AudioOutputLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioOutputLocation()). Otherwise it will return false.
     */
    inline bool hasAudioOutputLocation () const;

    /**
     * Returns the value of the member "AudioOutputLocation".
     *
     * This parameter can be used to define the ouputlocation.
     * This parameter may be used, if a client needs a playback at one
     * special outputlocation (e.g. if the synthesis of an email has
     * been haptically initiated for the rear-left-headphones).
     * The type is defined in the ACR_FI as a bitfield. Most of the time,
     * the standard=0 will be used.
     *
     * @return The value of the field "AudioOutputLocation"
     */
    inline const ::acr_fi_types::T_b8_AudioOutputLocation& getAudioOutputLocation () const;

    /**
     * Retrieves the value of the field "AudioOutputLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AudioOutputLocation".
     */
    inline ::acr_fi_types::T_b8_AudioOutputLocation& getAudioOutputLocationMutable ();

    /**
     * Sets the value of the member "AudioOutputLocation".
     *
     * This parameter can be used to define the ouputlocation.
     * This parameter may be used, if a client needs a playback at one
     * special outputlocation (e.g. if the synthesis of an email has
     * been haptically initiated for the rear-left-headphones).
     * The type is defined in the ACR_FI as a bitfield. Most of the time,
     * the standard=0 will be used.
     *
     * @param AudioOutputLocation The value which will be set
     */
    inline void setAudioOutputLocation (const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_);

    static const DoAudioOutputSpeakWithExtensionStart &getDefaultInstance();

private:

    inline void set_has_StatusInfo ();

    inline void clear_has_StatusInfo ();

    inline void set_has_AudioOutputLocation ();

    inline void clear_has_AudioOutputLocation ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sds_tts_fi_types::T_e8_StatusInfoOption _StatusInfo;

    ::acr_fi_types::T_b8_AudioOutputLocation _AudioOutputLocation;

};

/**
 * The result first message of the method "DoAudioOutputSpeakWithExtension"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of not used parameters).</p>
 * Test requirement : "no test"
 */
class DoAudioOutputSpeakWithExtensionResultFirst  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoAudioOutputSpeakWithExtensionResultFirst ();

    /**
     * Copy constructor
     */
    inline  DoAudioOutputSpeakWithExtensionResultFirst (const DoAudioOutputSpeakWithExtensionResultFirst &rhs);

    /**
     * All fields constructor
     */
    inline  DoAudioOutputSpeakWithExtensionResultFirst (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    /**
     * Destructor
     */
    inline virtual  ~DoAudioOutputSpeakWithExtensionResultFirst();

    /**
     * Assignment operator
     */
    inline DoAudioOutputSpeakWithExtensionResultFirst& operator = (const DoAudioOutputSpeakWithExtensionResultFirst& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoAudioOutputSpeakWithExtensionResultFirst& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoAudioOutputSpeakWithExtensionResultFirst& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoAudioOutputSpeakWithExtensionResultFirst& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoAudioOutputSpeakWithExtensionResultFirst& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobProgress"

    static const int kJobProgress = 0;

    /**
     * Clears the field "JobProgress".
     *
     * The field will be set to its default value. The hasJobProgress()
     * method will return false.
     */
    inline void clearJobProgress();

    /**
     * Checks whether the field "JobProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobProgress()). Otherwise it will return false.
     */
    inline bool hasJobProgress () const;

    /**
     * Returns the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / progress of synthesis.</p>
     * <p>If the job has been queued before (e.g. due to priority), now the client
     * will be informed, that the job has been started now.</p>
     *
     * @return The value of the field "JobProgress"
     */
    inline const ::sds_tts_fi_types::T_SpeakProgress& getJobProgress () const;

    /**
     * Retrieves the value of the field "JobProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JobProgress".
     */
    inline ::sds_tts_fi_types::T_SpeakProgress& getJobProgressMutable ();

    /**
     * Sets the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / progress of synthesis.</p>
     * <p>If the job has been queued before (e.g. due to priority), now the client
     * will be informed, that the job has been started now.</p>
     *
     * @param JobProgress The value which will be set
     */
    inline void setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    static const DoAudioOutputSpeakWithExtensionResultFirst &getDefaultInstance();

private:

    inline void set_has_JobProgress ();

    inline void clear_has_JobProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_SpeakProgress _JobProgress;

};

/**
 * The result middle message of the method "DoAudioOutputSpeakWithExtension"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of not used parameters).</p>
 * Test requirement : "no test"
 */
class DoAudioOutputSpeakWithExtensionResultMiddle  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoAudioOutputSpeakWithExtensionResultMiddle ();

    /**
     * Copy constructor
     */
    inline  DoAudioOutputSpeakWithExtensionResultMiddle (const DoAudioOutputSpeakWithExtensionResultMiddle &rhs);

    /**
     * All fields constructor
     */
    inline  DoAudioOutputSpeakWithExtensionResultMiddle (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    /**
     * Destructor
     */
    inline virtual  ~DoAudioOutputSpeakWithExtensionResultMiddle();

    /**
     * Assignment operator
     */
    inline DoAudioOutputSpeakWithExtensionResultMiddle& operator = (const DoAudioOutputSpeakWithExtensionResultMiddle& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoAudioOutputSpeakWithExtensionResultMiddle& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoAudioOutputSpeakWithExtensionResultMiddle& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoAudioOutputSpeakWithExtensionResultMiddle& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoAudioOutputSpeakWithExtensionResultMiddle& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobProgress"

    static const int kJobProgress = 0;

    /**
     * Clears the field "JobProgress".
     *
     * The field will be set to its default value. The hasJobProgress()
     * method will return false.
     */
    inline void clearJobProgress();

    /**
     * Checks whether the field "JobProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobProgress()). Otherwise it will return false.
     */
    inline bool hasJobProgress () const;

    /**
     * Returns the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / progress of synthesis.</p>
     * <p>If the job has been queued before (e.g. due to priority), now the client
     * will be informed, that the job has been started now.</p>
     *
     * @return The value of the field "JobProgress"
     */
    inline const ::sds_tts_fi_types::T_SpeakProgress& getJobProgress () const;

    /**
     * Retrieves the value of the field "JobProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JobProgress".
     */
    inline ::sds_tts_fi_types::T_SpeakProgress& getJobProgressMutable ();

    /**
     * Sets the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / progress of synthesis.</p>
     * <p>If the job has been queued before (e.g. due to priority), now the client
     * will be informed, that the job has been started now.</p>
     *
     * @param JobProgress The value which will be set
     */
    inline void setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    static const DoAudioOutputSpeakWithExtensionResultMiddle &getDefaultInstance();

private:

    inline void set_has_JobProgress ();

    inline void clear_has_JobProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_SpeakProgress _JobProgress;

};

/**
 * The result last message of the method "DoAudioOutputSpeakWithExtension"
 * <p>Method for internal communication of FC TTS.
 * This method is for internal use only!
 * The used parameters are identical to those of the method SynthesizeSpeak
 * (except of not used parameters).</p>
 * Test requirement : "no test"
 */
class DoAudioOutputSpeakWithExtensionResultLast  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoAudioOutputSpeakWithExtensionResultLast ();

    /**
     * Copy constructor
     */
    inline  DoAudioOutputSpeakWithExtensionResultLast (const DoAudioOutputSpeakWithExtensionResultLast &rhs);

    /**
     * All fields constructor
     */
    inline  DoAudioOutputSpeakWithExtensionResultLast (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    /**
     * Destructor
     */
    inline virtual  ~DoAudioOutputSpeakWithExtensionResultLast();

    /**
     * Assignment operator
     */
    inline DoAudioOutputSpeakWithExtensionResultLast& operator = (const DoAudioOutputSpeakWithExtensionResultLast& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoAudioOutputSpeakWithExtensionResultLast& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoAudioOutputSpeakWithExtensionResultLast& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoAudioOutputSpeakWithExtensionResultLast& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoAudioOutputSpeakWithExtensionResultLast& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "JobProgress"

    static const int kJobProgress = 0;

    /**
     * Clears the field "JobProgress".
     *
     * The field will be set to its default value. The hasJobProgress()
     * method will return false.
     */
    inline void clearJobProgress();

    /**
     * Checks whether the field "JobProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobProgress()). Otherwise it will return false.
     */
    inline bool hasJobProgress () const;

    /**
     * Returns the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / number of spoken words or sentences.</p>
     * <p>With this message, the client will be informed, that the job has been finished,</p>
     * <p>even if he didn't want to be informed about the job progress.</p>
     *
     * @return The value of the field "JobProgress"
     */
    inline const ::sds_tts_fi_types::T_SpeakProgress& getJobProgress () const;

    /**
     * Retrieves the value of the field "JobProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JobProgress".
     */
    inline ::sds_tts_fi_types::T_SpeakProgress& getJobProgressMutable ();

    /**
     * Sets the value of the member "JobProgress".
     *
     * <p>Feedback to the client about the jobstatus / number of spoken words or sentences.</p>
     * <p>With this message, the client will be informed, that the job has been finished,</p>
     * <p>even if he didn't want to be informed about the job progress.</p>
     *
     * @param JobProgress The value which will be set
     */
    inline void setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_);

    static const DoAudioOutputSpeakWithExtensionResultLast &getDefaultInstance();

private:

    inline void set_has_JobProgress ();

    inline void clear_has_JobProgress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_SpeakProgress _JobProgress;

};

/**
 * The status message of the property "Voice"
 * <p>This property can be used to check, which voice is currently used. The type is defined by the
 * Speech Data Provider and contains information about language, country, gender and name of the voice.</p>
 * Test requirement : "full test"
 */
class VoiceStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoiceStatus ();

    /**
     * Copy constructor
     */
    inline  VoiceStatus (const VoiceStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VoiceStatus (const ::sds_tts_fi_types::T_TTSVoiceInfo& TTSVoice_);

    /**
     * Destructor
     */
    inline virtual  ~VoiceStatus();

    /**
     * Assignment operator
     */
    inline VoiceStatus& operator = (const VoiceStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TTSVoice"

    static const int kTTSVoice = 0;

    /**
     * Clears the field "TTSVoice".
     *
     * The field will be set to its default value. The hasTTSVoice()
     * method will return false.
     */
    inline void clearTTSVoice();

    /**
     * Checks whether the field "TTSVoice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTSVoice()). Otherwise it will return false.
     */
    inline bool hasTTSVoice () const;

    /**
     * Returns the value of the member "TTSVoice".
     *
     * This parameter contains information about the currently used TTS-voice.
     *
     * @return The value of the field "TTSVoice"
     */
    inline const ::sds_tts_fi_types::T_TTSVoiceInfo& getTTSVoice () const;

    /**
     * Retrieves the value of the field "TTSVoice" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TTSVoice".
     */
    inline ::sds_tts_fi_types::T_TTSVoiceInfo& getTTSVoiceMutable ();

    /**
     * Sets the value of the member "TTSVoice".
     *
     * This parameter contains information about the currently used TTS-voice.
     *
     * @param TTSVoice The value which will be set
     */
    inline void setTTSVoice (const ::sds_tts_fi_types::T_TTSVoiceInfo& TTSVoice_);

    static const VoiceStatus &getDefaultInstance();

private:

    inline void set_has_TTSVoice ();

    inline void clear_has_TTSVoice ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_TTSVoiceInfo _TTSVoice;

};

/**
 * The status message of the property "AvailableVoices"
 * <p>This property can be used to check, which different voices are available for the used language</p>
 * Test requirement : "partly test"
 * This property will currenty only be filled with the content "0 voices available",
 * although the implementation of the property is complete (by concept).
 */
class AvailableVoicesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AvailableVoicesStatus ();

    /**
     * Copy constructor
     */
    inline  AvailableVoicesStatus (const AvailableVoicesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AvailableVoicesStatus (const ::sds_tts_fi_types::T_AvailableTTSVoices& AvailableTTSVoices_);

    /**
     * Destructor
     */
    inline virtual  ~AvailableVoicesStatus();

    /**
     * Assignment operator
     */
    inline AvailableVoicesStatus& operator = (const AvailableVoicesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AvailableVoicesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AvailableVoicesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AvailableVoicesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AvailableVoicesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AvailableTTSVoices"

    static const int kAvailableTTSVoices = 0;

    /**
     * Clears the field "AvailableTTSVoices".
     *
     * The field will be set to its default value. The hasAvailableTTSVoices()
     * method will return false.
     */
    inline void clearAvailableTTSVoices();

    /**
     * Checks whether the field "AvailableTTSVoices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailableTTSVoices()). Otherwise it will return false.
     */
    inline bool hasAvailableTTSVoices () const;

    /**
     * Returns the value of the member "AvailableTTSVoices".
     *
     * Structure of available voices for TTS.
     *
     * @return The value of the field "AvailableTTSVoices"
     */
    inline const ::sds_tts_fi_types::T_AvailableTTSVoices& getAvailableTTSVoices () const;

    /**
     * Retrieves the value of the field "AvailableTTSVoices" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AvailableTTSVoices".
     */
    inline ::sds_tts_fi_types::T_AvailableTTSVoices& getAvailableTTSVoicesMutable ();

    /**
     * Sets the value of the member "AvailableTTSVoices".
     *
     * Structure of available voices for TTS.
     *
     * @param AvailableTTSVoices The value which will be set
     */
    inline void setAvailableTTSVoices (const ::sds_tts_fi_types::T_AvailableTTSVoices& AvailableTTSVoices_);

    static const AvailableVoicesStatus &getDefaultInstance();

private:

    static const ::std::vector< ::sds_speechdp_fi_types::T_VoiceType >& getT_VoiceTypeList_DefaultInstance ();

    inline void set_has_AvailableTTSVoices ();

    inline void clear_has_AvailableTTSVoices ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_AvailableTTSVoices _AvailableTTSVoices;

};

/**
 * The status message of the property "TTSVersionInfo"
 * <p>This property can be used to check, which tts-engine and which version of the tts-module is currently used/running.</p>
 * Test requirement : "full test"
 */
class TTSVersionInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TTSVersionInfoStatus ();

    /**
     * Copy constructor
     */
    inline  TTSVersionInfoStatus (const TTSVersionInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TTSVersionInfoStatus (const ::sds_tts_fi_types::T_TTSVersionInfo& TTSVersionInfo_);

    /**
     * Destructor
     */
    inline virtual  ~TTSVersionInfoStatus();

    /**
     * Assignment operator
     */
    inline TTSVersionInfoStatus& operator = (const TTSVersionInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TTSVersionInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TTSVersionInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TTSVersionInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TTSVersionInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TTSVersionInfo"

    static const int kTTSVersionInfo = 0;

    /**
     * Clears the field "TTSVersionInfo".
     *
     * The field will be set to its default value. The hasTTSVersionInfo()
     * method will return false.
     */
    inline void clearTTSVersionInfo();

    /**
     * Checks whether the field "TTSVersionInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTSVersionInfo()). Otherwise it will return false.
     */
    inline bool hasTTSVersionInfo () const;

    /**
     * Returns the value of the member "TTSVersionInfo".
     *
     * Specifies the build version information of the tts-engine
     *
     * @return The value of the field "TTSVersionInfo"
     */
    inline const ::sds_tts_fi_types::T_TTSVersionInfo& getTTSVersionInfo () const;

    /**
     * Retrieves the value of the field "TTSVersionInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TTSVersionInfo".
     */
    inline ::sds_tts_fi_types::T_TTSVersionInfo& getTTSVersionInfoMutable ();

    /**
     * Sets the value of the member "TTSVersionInfo".
     *
     * Specifies the build version information of the tts-engine
     *
     * @param TTSVersionInfo The value which will be set
     */
    inline void setTTSVersionInfo (const ::sds_tts_fi_types::T_TTSVersionInfo& TTSVersionInfo_);

    static const TTSVersionInfoStatus &getDefaultInstance();

private:

    inline void set_has_TTSVersionInfo ();

    inline void clear_has_TTSVersionInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_TTSVersionInfo _TTSVersionInfo;

};

/**
 * The status message of the property "TTSStatus"
 * <p>This property can be used to check, in which status the tts-synthesis is.</p>
 * Test requirement : "full test"
 */
class TTSStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TTSStatusStatus ();

    /**
     * Copy constructor
     */
    inline  TTSStatusStatus (const TTSStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TTSStatusStatus (::sds_tts_fi_types::T_e8_TTSStatus TTSStatus_);

    /**
     * Destructor
     */
    inline virtual  ~TTSStatusStatus();

    /**
     * Assignment operator
     */
    inline TTSStatusStatus& operator = (const TTSStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TTSStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TTSStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TTSStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TTSStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TTSStatus"

    static const int kTTSStatus = 0;

    /**
     * Clears the field "TTSStatus".
     *
     * The field will be set to its default value. The hasTTSStatus()
     * method will return false.
     */
    inline void clearTTSStatus();

    /**
     * Checks whether the field "TTSStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTSStatus()). Otherwise it will return false.
     */
    inline bool hasTTSStatus () const;

    /**
     * Returns the value of the member "TTSStatus".
     *
     * <p>Feedback about the status of the tts. Possible are:</p>
     * <p>Initialization</p>
     * <p>Idle</p>
     * <p>ConfigFailed</p>
     * <p>Synthesizing</p>
     * <p>Done</p>
     * <p>Aborting</p>
     * <p>Paused</p>
     *
     * @return The value of the field "TTSStatus"
     */
    inline ::sds_tts_fi_types::T_e8_TTSStatus getTTSStatus () const;

    /**
     * Sets the value of the member "TTSStatus".
     *
     * <p>Feedback about the status of the tts. Possible are:</p>
     * <p>Initialization</p>
     * <p>Idle</p>
     * <p>ConfigFailed</p>
     * <p>Synthesizing</p>
     * <p>Done</p>
     * <p>Aborting</p>
     * <p>Paused</p>
     *
     * @param TTSStatus The value which will be set
     */
    inline void setTTSStatus (::sds_tts_fi_types::T_e8_TTSStatus TTSStatus_);

    static const TTSStatusStatus &getDefaultInstance();

private:

    inline void set_has_TTSStatus ();

    inline void clear_has_TTSStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sds_tts_fi_types::T_e8_TTSStatus _TTSStatus;

};

/**
 * The status message of the property "DownloadComplete"
 * <p>The client is informed by this property about finishing of download.
 * After receiving ReleaseData for language change the FC TTS sets this property to FALSE.
 * FC VoiceControl forces the SDP via DownloadSDSLanguage to copy the new data from media (e.g. DVD or CD-ROM)
 * into  flash. After download complete and successfull the FC TTS sets this property to TRUE.</p>
 * Test requirement : "full test"
 */
class DownloadCompleteStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DownloadCompleteStatus ();

    /**
     * Copy constructor
     */
    inline  DownloadCompleteStatus (const DownloadCompleteStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DownloadCompleteStatus (bool Complete_);

    /**
     * Destructor
     */
    inline virtual  ~DownloadCompleteStatus();

    /**
     * Assignment operator
     */
    inline DownloadCompleteStatus& operator = (const DownloadCompleteStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DownloadCompleteStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DownloadCompleteStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DownloadCompleteStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DownloadCompleteStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Complete"

    static const int kComplete = 0;

    /**
     * Clears the field "Complete".
     *
     * The field will be set to its default value. The hasComplete()
     * method will return false.
     */
    inline void clearComplete();

    /**
     * Checks whether the field "Complete" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setComplete()). Otherwise it will return false.
     */
    inline bool hasComplete () const;

    /**
     * Returns the value of the member "Complete".
     *
     * TRUE download finished. FALSE download not finished, start of Download initiated.
     *
     * @return The value of the field "Complete"
     */
    inline bool getComplete () const;

    /**
     * Sets the value of the member "Complete".
     *
     * TRUE download finished. FALSE download not finished, start of Download initiated.
     *
     * @param Complete The value which will be set
     */
    inline void setComplete (bool Complete_);

    static const DownloadCompleteStatus &getDefaultInstance();

private:

    inline void set_has_Complete ();

    inline void clear_has_Complete ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Complete;

};

/**
 * The error message of 'DownloadComplete'
 */
class DownloadCompleteError  : public ::asf::core::Payload {
public:

    enum DownloadCompleteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DownloadCompleteError ();

   /**
     * Copy constructor
     */
    inline  DownloadCompleteError (const DownloadCompleteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DownloadCompleteError();

    /**
     * Assigns a new value to this object.
     */
    inline DownloadCompleteError& operator = (const DownloadCompleteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DownloadCompleteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DownloadCompleteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DownloadCompleteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DownloadCompleteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DownloadCompleteError::DownloadCompleteErrorField getField () const;

    inline void setField(DownloadCompleteError::DownloadCompleteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DownloadCompleteErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DownloadCompleteErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline DownloadCompleteErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DownloadCompleteErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (DownloadCompleteErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DownloadCompleteError &getDefaultInstance();

private:

    inline void cloneData (const DownloadCompleteError& rhs);

    inline void deleteData ();

    DownloadCompleteErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "TTSPlaybackSpacing"
 * <p>This property can be used to change the playback spacing.</p>
 * Test requirement : "full test"
 */
class TTSPlaybackSpacingStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TTSPlaybackSpacingStatus ();

    /**
     * Copy constructor
     */
    inline  TTSPlaybackSpacingStatus (const TTSPlaybackSpacingStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TTSPlaybackSpacingStatus (uint8 PlaybackSpacing_);

    /**
     * Destructor
     */
    inline virtual  ~TTSPlaybackSpacingStatus();

    /**
     * Assignment operator
     */
    inline TTSPlaybackSpacingStatus& operator = (const TTSPlaybackSpacingStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TTSPlaybackSpacingStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TTSPlaybackSpacingStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TTSPlaybackSpacingStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TTSPlaybackSpacingStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PlaybackSpacing"

    static const int kPlaybackSpacing = 0;

    /**
     * Clears the field "PlaybackSpacing".
     *
     * The field will be set to its default value. The hasPlaybackSpacing()
     * method will return false.
     */
    inline void clearPlaybackSpacing();

    /**
     * Checks whether the field "PlaybackSpacing" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPlaybackSpacing()). Otherwise it will return false.
     */
    inline bool hasPlaybackSpacing () const;

    /**
     * Returns the value of the member "PlaybackSpacing".
     *
     * Wait period inserted between two text units (e.g. sentences), on a
     * scale from 0 to 9. Each unit is equivalent to 200ms of silence.
     *
     * @return The value of the field "PlaybackSpacing"
     */
    inline uint8 getPlaybackSpacing () const;

    /**
     * Sets the value of the member "PlaybackSpacing".
     *
     * Wait period inserted between two text units (e.g. sentences), on a
     * scale from 0 to 9. Each unit is equivalent to 200ms of silence.
     *
     * @param PlaybackSpacing The value which will be set
     */
    inline void setPlaybackSpacing (uint8 PlaybackSpacing_);

    static const TTSPlaybackSpacingStatus &getDefaultInstance();

private:

    inline void set_has_PlaybackSpacing ();

    inline void clear_has_PlaybackSpacing ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PlaybackSpacing;

};

/**
 * The set message of the property "TTSPlaybackSpacing"
 * <p>This property can be used to change the playback spacing.</p>
 * Test requirement : "full test"
 */
class TTSPlaybackSpacingSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TTSPlaybackSpacingSet ();

    /**
     * Copy constructor
     */
    inline  TTSPlaybackSpacingSet (const TTSPlaybackSpacingSet &rhs);

    /**
     * All fields constructor
     */
    inline  TTSPlaybackSpacingSet (uint8 PlaybackSpacing_);

    /**
     * Destructor
     */
    inline virtual  ~TTSPlaybackSpacingSet();

    /**
     * Assignment operator
     */
    inline TTSPlaybackSpacingSet& operator = (const TTSPlaybackSpacingSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TTSPlaybackSpacingSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TTSPlaybackSpacingSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TTSPlaybackSpacingSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TTSPlaybackSpacingSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PlaybackSpacing"

    static const int kPlaybackSpacing = 0;

    /**
     * Clears the field "PlaybackSpacing".
     *
     * The field will be set to its default value. The hasPlaybackSpacing()
     * method will return false.
     */
    inline void clearPlaybackSpacing();

    /**
     * Checks whether the field "PlaybackSpacing" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPlaybackSpacing()). Otherwise it will return false.
     */
    inline bool hasPlaybackSpacing () const;

    /**
     * Returns the value of the member "PlaybackSpacing".
     *
     * Wait period inserted between two text units (e.g. sentences), on a
     * scale from 0 to 9. Each unit is equivalent to 200ms of silence.
     *
     * @return The value of the field "PlaybackSpacing"
     */
    inline uint8 getPlaybackSpacing () const;

    /**
     * Sets the value of the member "PlaybackSpacing".
     *
     * Wait period inserted between two text units (e.g. sentences), on a
     * scale from 0 to 9. Each unit is equivalent to 200ms of silence.
     *
     * @param PlaybackSpacing The value which will be set
     */
    inline void setPlaybackSpacing (uint8 PlaybackSpacing_);

    static const TTSPlaybackSpacingSet &getDefaultInstance();

private:

    inline void set_has_PlaybackSpacing ();

    inline void clear_has_PlaybackSpacing ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PlaybackSpacing;

};

inline  SynthesizeSpeakStart::SynthesizeSpeakStart ()  :
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_TextStyleOption__Unknown),
    _AudioOutputLocation (),
    _StatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo),
    _ExpDate (0u),
    _LastPackage (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SynthesizeSpeakStart::SynthesizeSpeakStart (const SynthesizeSpeakStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_TextStyleOption__Unknown),
    _AudioOutputLocation (),
    _StatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo),
    _ExpDate (0u),
    _LastPackage (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SynthesizeSpeakStart::SynthesizeSpeakStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_, const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_, ::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_, uint32 ExpDate_, bool LastPackage_)  :
    _TextAndTags (TextAndTags_),
    _TextStyle (TextStyle_),
    _AudioOutputLocation (AudioOutputLocation_),
    _StatusInfo (StatusInfo_),
    _ExpDate (ExpDate_),
    _LastPackage (LastPackage_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TextStyleOption_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_TextStyleOption", "TextStyle", "SynthesizeSpeakStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_StatusInfoOption_IsValid(StatusInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusInfo_, "T_e8_StatusInfoOption", "StatusInfo", "SynthesizeSpeakStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SynthesizeSpeakStart::~SynthesizeSpeakStart() {
}

inline SynthesizeSpeakStart& SynthesizeSpeakStart::operator = (const SynthesizeSpeakStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTextAndTags()) {
            setTextAndTags(rhs.getTextAndTags());
        } else {
            clearTextAndTags();
        }
        if (rhs.hasTextStyle()) {
            setTextStyle(rhs.getTextStyle());
        } else {
            clearTextStyle();
        }
        if (rhs.hasAudioOutputLocation()) {
            setAudioOutputLocation(rhs.getAudioOutputLocation());
        } else {
            clearAudioOutputLocation();
        }
        if (rhs.hasStatusInfo()) {
            setStatusInfo(rhs.getStatusInfo());
        } else {
            clearStatusInfo();
        }
        if (rhs.hasExpDate()) {
            setExpDate(rhs.getExpDate());
        } else {
            clearExpDate();
        }
        if (rhs.hasLastPackage()) {
            setLastPackage(rhs.getLastPackage());
        } else {
            clearLastPackage();
        }
    }
    return *this;
}

inline bool SynthesizeSpeakStart::operator == (const SynthesizeSpeakStart& rhs) const {
    return (((!hasTextAndTags() && !rhs.hasTextAndTags()) || getTextAndTags() == rhs.getTextAndTags()) &&
        ((!hasTextStyle() && !rhs.hasTextStyle()) || getTextStyle() == rhs.getTextStyle()) &&
        ((!hasAudioOutputLocation() && !rhs.hasAudioOutputLocation()) || getAudioOutputLocation() == rhs.getAudioOutputLocation()) &&
        ((!hasStatusInfo() && !rhs.hasStatusInfo()) || getStatusInfo() == rhs.getStatusInfo()) &&
        ((!hasExpDate() && !rhs.hasExpDate()) || getExpDate() == rhs.getExpDate()) &&
        ((!hasLastPackage() && !rhs.hasLastPackage()) || getLastPackage() == rhs.getLastPackage()));
}

inline bool SynthesizeSpeakStart::operator != (const SynthesizeSpeakStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SynthesizeSpeakStart::operator < (const SynthesizeSpeakStart& rhs) const {
    if (hasTextAndTags() || rhs.hasTextAndTags()) {
        if (getTextAndTags() < rhs.getTextAndTags()) return true;
        if (getTextAndTags() > rhs.getTextAndTags()) return false;
    }
    if (hasTextStyle() || rhs.hasTextStyle()) {
        if ((uint32)getTextStyle() < (uint32)rhs.getTextStyle()) return true;
        if ((uint32)getTextStyle() > (uint32)rhs.getTextStyle()) return false;
    }
    if (hasAudioOutputLocation() || rhs.hasAudioOutputLocation()) {
        if (getAudioOutputLocation() < rhs.getAudioOutputLocation()) return true;
        if (getAudioOutputLocation() > rhs.getAudioOutputLocation()) return false;
    }
    if (hasStatusInfo() || rhs.hasStatusInfo()) {
        if ((uint32)getStatusInfo() < (uint32)rhs.getStatusInfo()) return true;
        if ((uint32)getStatusInfo() > (uint32)rhs.getStatusInfo()) return false;
    }
    if (hasExpDate() || rhs.hasExpDate()) {
        if (getExpDate() < rhs.getExpDate()) return true;
        if (getExpDate() > rhs.getExpDate()) return false;
    }
    if (hasLastPackage() || rhs.hasLastPackage()) {
        if (getLastPackage() < rhs.getLastPackage()) return true;
        if (getLastPackage() > rhs.getLastPackage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SynthesizeSpeakStart::clone() {
    return new SynthesizeSpeakStart(*this);
}

inline bool SynthesizeSpeakStart::operator > (const SynthesizeSpeakStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SynthesizeSpeakStart::clear() {
    clearTextAndTags();
    clearTextStyle();
    clearAudioOutputLocation();
    clearStatusInfo();
    clearExpDate();
    clearLastPackage();
}

inline void SynthesizeSpeakStart::clearTextAndTags() {
    if (hasTextAndTags()) {
         clear_has_TextAndTags();
        _TextAndTags.clear();
     }
}

inline bool SynthesizeSpeakStart::hasTextAndTags () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SynthesizeSpeakStart::getTextAndTags () const {
    return _TextAndTags;
}

inline ::std::string& SynthesizeSpeakStart::getTextAndTagsMutable () {
    set_has_TextAndTags();
    return _TextAndTags;
}

inline void SynthesizeSpeakStart::setTextAndTags (const ::std::string& TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags = TextAndTags_;
}

inline void SynthesizeSpeakStart::setTextAndTags (const char* TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(TextAndTags_);
}

inline void SynthesizeSpeakStart::setTextAndTags (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(value, size);
}

inline void SynthesizeSpeakStart::clearTextStyle() {
    if (hasTextStyle()) {
         clear_has_TextStyle();
        _TextStyle = ::sds_tts_fi_types::T_e8_TextStyleOption__Unknown;
     }
}

inline bool SynthesizeSpeakStart::hasTextStyle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sds_tts_fi_types::T_e8_TextStyleOption SynthesizeSpeakStart::getTextStyle () const {
    return _TextStyle;
}

inline void SynthesizeSpeakStart::setTextStyle (::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TextStyleOption_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_TextStyleOption", "TextStyle", "SynthesizeSpeakStart");
    }
    #endif
    set_has_TextStyle();
    this->_TextStyle = TextStyle_;
}

inline void SynthesizeSpeakStart::clearAudioOutputLocation() {
    if (hasAudioOutputLocation()) {
         clear_has_AudioOutputLocation();
        _AudioOutputLocation = ::acr_fi_types::T_b8_AudioOutputLocation ();
     }
}

inline bool SynthesizeSpeakStart::hasAudioOutputLocation () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::acr_fi_types::T_b8_AudioOutputLocation& SynthesizeSpeakStart::getAudioOutputLocation () const {
    return _AudioOutputLocation;
}

inline ::acr_fi_types::T_b8_AudioOutputLocation& SynthesizeSpeakStart::getAudioOutputLocationMutable () {
    set_has_AudioOutputLocation();
    return _AudioOutputLocation;
}

inline void SynthesizeSpeakStart::setAudioOutputLocation (const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_) {
    set_has_AudioOutputLocation();
    this->_AudioOutputLocation = AudioOutputLocation_;
}

inline void SynthesizeSpeakStart::clearStatusInfo() {
    if (hasStatusInfo()) {
         clear_has_StatusInfo();
        _StatusInfo = ::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo;
     }
}

inline bool SynthesizeSpeakStart::hasStatusInfo () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::sds_tts_fi_types::T_e8_StatusInfoOption SynthesizeSpeakStart::getStatusInfo () const {
    return _StatusInfo;
}

inline void SynthesizeSpeakStart::setStatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_StatusInfoOption_IsValid(StatusInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusInfo_, "T_e8_StatusInfoOption", "StatusInfo", "SynthesizeSpeakStart");
    }
    #endif
    set_has_StatusInfo();
    this->_StatusInfo = StatusInfo_;
}

inline void SynthesizeSpeakStart::clearExpDate() {
    if (hasExpDate()) {
         clear_has_ExpDate();
        _ExpDate = 0u;
     }
}

inline bool SynthesizeSpeakStart::hasExpDate () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 SynthesizeSpeakStart::getExpDate () const {
    return _ExpDate;
}

inline void SynthesizeSpeakStart::setExpDate (uint32 ExpDate_) {
    set_has_ExpDate();
    this->_ExpDate = ExpDate_;
}

inline void SynthesizeSpeakStart::clearLastPackage() {
    if (hasLastPackage()) {
         clear_has_LastPackage();
        _LastPackage = false;
     }
}

inline bool SynthesizeSpeakStart::hasLastPackage () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool SynthesizeSpeakStart::getLastPackage () const {
    return _LastPackage;
}

inline void SynthesizeSpeakStart::setLastPackage (bool LastPackage_) {
    set_has_LastPackage();
    this->_LastPackage = LastPackage_;
}

inline void SynthesizeSpeakStart::set_has_TextAndTags () {
    _has_bits_[0] |= 1u << 0;
}

inline void SynthesizeSpeakStart::clear_has_TextAndTags () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SynthesizeSpeakStart::set_has_TextStyle () {
    _has_bits_[0] |= 1u << 1;
}

inline void SynthesizeSpeakStart::clear_has_TextStyle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SynthesizeSpeakStart::set_has_AudioOutputLocation () {
    _has_bits_[0] |= 1u << 2;
}

inline void SynthesizeSpeakStart::clear_has_AudioOutputLocation () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SynthesizeSpeakStart::set_has_StatusInfo () {
    _has_bits_[0] |= 1u << 3;
}

inline void SynthesizeSpeakStart::clear_has_StatusInfo () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SynthesizeSpeakStart::set_has_ExpDate () {
    _has_bits_[0] |= 1u << 4;
}

inline void SynthesizeSpeakStart::clear_has_ExpDate () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void SynthesizeSpeakStart::set_has_LastPackage () {
    _has_bits_[0] |= 1u << 5;
}

inline void SynthesizeSpeakStart::clear_has_LastPackage () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  SynthesizeSpeakResultFirst::SynthesizeSpeakResultFirst ()  :
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SynthesizeSpeakResultFirst::SynthesizeSpeakResultFirst (const SynthesizeSpeakResultFirst &rhs)  :
    ::asf::core::Payload(rhs),
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SynthesizeSpeakResultFirst::SynthesizeSpeakResultFirst (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_)  :
    _JobProgress (JobProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SynthesizeSpeakResultFirst::~SynthesizeSpeakResultFirst() {
}

inline SynthesizeSpeakResultFirst& SynthesizeSpeakResultFirst::operator = (const SynthesizeSpeakResultFirst& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobProgress()) {
            setJobProgress(rhs.getJobProgress());
        } else {
            clearJobProgress();
        }
    }
    return *this;
}

inline bool SynthesizeSpeakResultFirst::operator == (const SynthesizeSpeakResultFirst& rhs) const {
    return (((!hasJobProgress() && !rhs.hasJobProgress()) || getJobProgress() == rhs.getJobProgress()));
}

inline bool SynthesizeSpeakResultFirst::operator != (const SynthesizeSpeakResultFirst& rhs) const {
    return ! (*this == rhs);
}

inline bool SynthesizeSpeakResultFirst::operator < (const SynthesizeSpeakResultFirst& rhs) const {
    if (hasJobProgress() || rhs.hasJobProgress()) {
        if (getJobProgress() < rhs.getJobProgress()) return true;
        if (getJobProgress() > rhs.getJobProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SynthesizeSpeakResultFirst::clone() {
    return new SynthesizeSpeakResultFirst(*this);
}

inline bool SynthesizeSpeakResultFirst::operator > (const SynthesizeSpeakResultFirst& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SynthesizeSpeakResultFirst::clear() {
    clearJobProgress();
}

inline void SynthesizeSpeakResultFirst::clearJobProgress() {
    if (hasJobProgress()) {
         clear_has_JobProgress();
        _JobProgress.clear();
     }
}

inline bool SynthesizeSpeakResultFirst::hasJobProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_tts_fi_types::T_SpeakProgress& SynthesizeSpeakResultFirst::getJobProgress () const {
    return _JobProgress;
}

inline ::sds_tts_fi_types::T_SpeakProgress& SynthesizeSpeakResultFirst::getJobProgressMutable () {
    set_has_JobProgress();
    return _JobProgress;
}

inline void SynthesizeSpeakResultFirst::setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_) {
    set_has_JobProgress();
    this->_JobProgress = JobProgress_;
}

inline void SynthesizeSpeakResultFirst::set_has_JobProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void SynthesizeSpeakResultFirst::clear_has_JobProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SynthesizeSpeakResultMiddle::SynthesizeSpeakResultMiddle ()  :
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SynthesizeSpeakResultMiddle::SynthesizeSpeakResultMiddle (const SynthesizeSpeakResultMiddle &rhs)  :
    ::asf::core::Payload(rhs),
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SynthesizeSpeakResultMiddle::SynthesizeSpeakResultMiddle (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_)  :
    _JobProgress (JobProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SynthesizeSpeakResultMiddle::~SynthesizeSpeakResultMiddle() {
}

inline SynthesizeSpeakResultMiddle& SynthesizeSpeakResultMiddle::operator = (const SynthesizeSpeakResultMiddle& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobProgress()) {
            setJobProgress(rhs.getJobProgress());
        } else {
            clearJobProgress();
        }
    }
    return *this;
}

inline bool SynthesizeSpeakResultMiddle::operator == (const SynthesizeSpeakResultMiddle& rhs) const {
    return (((!hasJobProgress() && !rhs.hasJobProgress()) || getJobProgress() == rhs.getJobProgress()));
}

inline bool SynthesizeSpeakResultMiddle::operator != (const SynthesizeSpeakResultMiddle& rhs) const {
    return ! (*this == rhs);
}

inline bool SynthesizeSpeakResultMiddle::operator < (const SynthesizeSpeakResultMiddle& rhs) const {
    if (hasJobProgress() || rhs.hasJobProgress()) {
        if (getJobProgress() < rhs.getJobProgress()) return true;
        if (getJobProgress() > rhs.getJobProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SynthesizeSpeakResultMiddle::clone() {
    return new SynthesizeSpeakResultMiddle(*this);
}

inline bool SynthesizeSpeakResultMiddle::operator > (const SynthesizeSpeakResultMiddle& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SynthesizeSpeakResultMiddle::clear() {
    clearJobProgress();
}

inline void SynthesizeSpeakResultMiddle::clearJobProgress() {
    if (hasJobProgress()) {
         clear_has_JobProgress();
        _JobProgress.clear();
     }
}

inline bool SynthesizeSpeakResultMiddle::hasJobProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_tts_fi_types::T_SpeakProgress& SynthesizeSpeakResultMiddle::getJobProgress () const {
    return _JobProgress;
}

inline ::sds_tts_fi_types::T_SpeakProgress& SynthesizeSpeakResultMiddle::getJobProgressMutable () {
    set_has_JobProgress();
    return _JobProgress;
}

inline void SynthesizeSpeakResultMiddle::setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_) {
    set_has_JobProgress();
    this->_JobProgress = JobProgress_;
}

inline void SynthesizeSpeakResultMiddle::set_has_JobProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void SynthesizeSpeakResultMiddle::clear_has_JobProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SynthesizeSpeakResultLast::SynthesizeSpeakResultLast ()  :
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SynthesizeSpeakResultLast::SynthesizeSpeakResultLast (const SynthesizeSpeakResultLast &rhs)  :
    ::asf::core::Payload(rhs),
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SynthesizeSpeakResultLast::SynthesizeSpeakResultLast (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_)  :
    _JobProgress (JobProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SynthesizeSpeakResultLast::~SynthesizeSpeakResultLast() {
}

inline SynthesizeSpeakResultLast& SynthesizeSpeakResultLast::operator = (const SynthesizeSpeakResultLast& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobProgress()) {
            setJobProgress(rhs.getJobProgress());
        } else {
            clearJobProgress();
        }
    }
    return *this;
}

inline bool SynthesizeSpeakResultLast::operator == (const SynthesizeSpeakResultLast& rhs) const {
    return (((!hasJobProgress() && !rhs.hasJobProgress()) || getJobProgress() == rhs.getJobProgress()));
}

inline bool SynthesizeSpeakResultLast::operator != (const SynthesizeSpeakResultLast& rhs) const {
    return ! (*this == rhs);
}

inline bool SynthesizeSpeakResultLast::operator < (const SynthesizeSpeakResultLast& rhs) const {
    if (hasJobProgress() || rhs.hasJobProgress()) {
        if (getJobProgress() < rhs.getJobProgress()) return true;
        if (getJobProgress() > rhs.getJobProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SynthesizeSpeakResultLast::clone() {
    return new SynthesizeSpeakResultLast(*this);
}

inline bool SynthesizeSpeakResultLast::operator > (const SynthesizeSpeakResultLast& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SynthesizeSpeakResultLast::clear() {
    clearJobProgress();
}

inline void SynthesizeSpeakResultLast::clearJobProgress() {
    if (hasJobProgress()) {
         clear_has_JobProgress();
        _JobProgress.clear();
     }
}

inline bool SynthesizeSpeakResultLast::hasJobProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_tts_fi_types::T_SpeakProgress& SynthesizeSpeakResultLast::getJobProgress () const {
    return _JobProgress;
}

inline ::sds_tts_fi_types::T_SpeakProgress& SynthesizeSpeakResultLast::getJobProgressMutable () {
    set_has_JobProgress();
    return _JobProgress;
}

inline void SynthesizeSpeakResultLast::setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_) {
    set_has_JobProgress();
    this->_JobProgress = JobProgress_;
}

inline void SynthesizeSpeakResultLast::set_has_JobProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void SynthesizeSpeakResultLast::clear_has_JobProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SynthesizeSpeakError::SynthesizeSpeakError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::SynthesizeSpeakErrorCode__Unspecified;
}

inline  SynthesizeSpeakError::SynthesizeSpeakError (const SynthesizeSpeakError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::SynthesizeSpeakErrorCode__Unspecified;
    *this = rhs;
}

inline  SynthesizeSpeakError::~SynthesizeSpeakError() {
    deleteData ();
}

inline SynthesizeSpeakError& SynthesizeSpeakError::operator = (const SynthesizeSpeakError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SynthesizeSpeakError::operator == (const SynthesizeSpeakError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SynthesizeSpeakError::operator != (const SynthesizeSpeakError& rhs) const {
    return ! (*this == rhs);
}

inline bool SynthesizeSpeakError::operator < (const SynthesizeSpeakError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SynthesizeSpeakError::operator > (const SynthesizeSpeakError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SynthesizeSpeakError::SynthesizeSpeakErrorField SynthesizeSpeakError::getField () const {
    return __field;
}

inline void SynthesizeSpeakError::setField(SynthesizeSpeakError::SynthesizeSpeakErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::SynthesizeSpeakErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SynthesizeSpeakError::clone() {
    return new SynthesizeSpeakError(*this);
}

inline bool SynthesizeSpeakError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline SynthesizeSpeakErrorCode SynthesizeSpeakError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SynthesizeSpeakError", getField());
    }
    return (SynthesizeSpeakErrorCode) _data.ccaErrorCode_;
}

inline void SynthesizeSpeakError::setCcaErrorCode (SynthesizeSpeakErrorCode value) {
    #ifndef NDEBUG
    if (!(SynthesizeSpeakErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SynthesizeSpeakErrorCode", "ccaErrorCode", "SynthesizeSpeakError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool SynthesizeSpeakError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SynthesizeSpeakError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SynthesizeSpeakError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SynthesizeSpeakError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SynthesizeSpeakError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SynthesizeSpeakError::cloneData (const SynthesizeSpeakError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SynthesizeSpeakError::deleteData () {
}

inline  SynthesizeWriteStart::SynthesizeWriteStart ()  :
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_TextStyleOption__Unknown),
    _Buffering (::sds_tts_fi_types::T_e8_BufferingOption__Unknown),
    _ExpDate (0u),
    _LastPackage (false),
    _Compression ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SynthesizeWriteStart::SynthesizeWriteStart (const SynthesizeWriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_TextStyleOption__Unknown),
    _Buffering (::sds_tts_fi_types::T_e8_BufferingOption__Unknown),
    _ExpDate (0u),
    _LastPackage (false),
    _Compression ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SynthesizeWriteStart::SynthesizeWriteStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_, ::sds_tts_fi_types::T_e8_BufferingOption Buffering_, uint32 ExpDate_, bool LastPackage_, const ::acr_fi_types::T_b8_AudioFormat& Compression_)  :
    _TextAndTags (TextAndTags_),
    _TextStyle (TextStyle_),
    _Buffering (Buffering_),
    _ExpDate (ExpDate_),
    _LastPackage (LastPackage_),
    _Compression (Compression_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TextStyleOption_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_TextStyleOption", "TextStyle", "SynthesizeWriteStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_BufferingOption_IsValid(Buffering_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Buffering_, "T_e8_BufferingOption", "Buffering", "SynthesizeWriteStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SynthesizeWriteStart::~SynthesizeWriteStart() {
}

inline SynthesizeWriteStart& SynthesizeWriteStart::operator = (const SynthesizeWriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTextAndTags()) {
            setTextAndTags(rhs.getTextAndTags());
        } else {
            clearTextAndTags();
        }
        if (rhs.hasTextStyle()) {
            setTextStyle(rhs.getTextStyle());
        } else {
            clearTextStyle();
        }
        if (rhs.hasBuffering()) {
            setBuffering(rhs.getBuffering());
        } else {
            clearBuffering();
        }
        if (rhs.hasExpDate()) {
            setExpDate(rhs.getExpDate());
        } else {
            clearExpDate();
        }
        if (rhs.hasLastPackage()) {
            setLastPackage(rhs.getLastPackage());
        } else {
            clearLastPackage();
        }
        if (rhs.hasCompression()) {
            setCompression(rhs.getCompression());
        } else {
            clearCompression();
        }
    }
    return *this;
}

inline bool SynthesizeWriteStart::operator == (const SynthesizeWriteStart& rhs) const {
    return (((!hasTextAndTags() && !rhs.hasTextAndTags()) || getTextAndTags() == rhs.getTextAndTags()) &&
        ((!hasTextStyle() && !rhs.hasTextStyle()) || getTextStyle() == rhs.getTextStyle()) &&
        ((!hasBuffering() && !rhs.hasBuffering()) || getBuffering() == rhs.getBuffering()) &&
        ((!hasExpDate() && !rhs.hasExpDate()) || getExpDate() == rhs.getExpDate()) &&
        ((!hasLastPackage() && !rhs.hasLastPackage()) || getLastPackage() == rhs.getLastPackage()) &&
        ((!hasCompression() && !rhs.hasCompression()) || getCompression() == rhs.getCompression()));
}

inline bool SynthesizeWriteStart::operator != (const SynthesizeWriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SynthesizeWriteStart::operator < (const SynthesizeWriteStart& rhs) const {
    if (hasTextAndTags() || rhs.hasTextAndTags()) {
        if (getTextAndTags() < rhs.getTextAndTags()) return true;
        if (getTextAndTags() > rhs.getTextAndTags()) return false;
    }
    if (hasTextStyle() || rhs.hasTextStyle()) {
        if ((uint32)getTextStyle() < (uint32)rhs.getTextStyle()) return true;
        if ((uint32)getTextStyle() > (uint32)rhs.getTextStyle()) return false;
    }
    if (hasBuffering() || rhs.hasBuffering()) {
        if ((uint32)getBuffering() < (uint32)rhs.getBuffering()) return true;
        if ((uint32)getBuffering() > (uint32)rhs.getBuffering()) return false;
    }
    if (hasExpDate() || rhs.hasExpDate()) {
        if (getExpDate() < rhs.getExpDate()) return true;
        if (getExpDate() > rhs.getExpDate()) return false;
    }
    if (hasLastPackage() || rhs.hasLastPackage()) {
        if (getLastPackage() < rhs.getLastPackage()) return true;
        if (getLastPackage() > rhs.getLastPackage()) return false;
    }
    if (hasCompression() || rhs.hasCompression()) {
        if (getCompression() < rhs.getCompression()) return true;
        if (getCompression() > rhs.getCompression()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SynthesizeWriteStart::clone() {
    return new SynthesizeWriteStart(*this);
}

inline bool SynthesizeWriteStart::operator > (const SynthesizeWriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SynthesizeWriteStart::clear() {
    clearTextAndTags();
    clearTextStyle();
    clearBuffering();
    clearExpDate();
    clearLastPackage();
    clearCompression();
}

inline void SynthesizeWriteStart::clearTextAndTags() {
    if (hasTextAndTags()) {
         clear_has_TextAndTags();
        _TextAndTags.clear();
     }
}

inline bool SynthesizeWriteStart::hasTextAndTags () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SynthesizeWriteStart::getTextAndTags () const {
    return _TextAndTags;
}

inline ::std::string& SynthesizeWriteStart::getTextAndTagsMutable () {
    set_has_TextAndTags();
    return _TextAndTags;
}

inline void SynthesizeWriteStart::setTextAndTags (const ::std::string& TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags = TextAndTags_;
}

inline void SynthesizeWriteStart::setTextAndTags (const char* TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(TextAndTags_);
}

inline void SynthesizeWriteStart::setTextAndTags (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(value, size);
}

inline void SynthesizeWriteStart::clearTextStyle() {
    if (hasTextStyle()) {
         clear_has_TextStyle();
        _TextStyle = ::sds_tts_fi_types::T_e8_TextStyleOption__Unknown;
     }
}

inline bool SynthesizeWriteStart::hasTextStyle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sds_tts_fi_types::T_e8_TextStyleOption SynthesizeWriteStart::getTextStyle () const {
    return _TextStyle;
}

inline void SynthesizeWriteStart::setTextStyle (::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TextStyleOption_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_TextStyleOption", "TextStyle", "SynthesizeWriteStart");
    }
    #endif
    set_has_TextStyle();
    this->_TextStyle = TextStyle_;
}

inline void SynthesizeWriteStart::clearBuffering() {
    if (hasBuffering()) {
         clear_has_Buffering();
        _Buffering = ::sds_tts_fi_types::T_e8_BufferingOption__Unknown;
     }
}

inline bool SynthesizeWriteStart::hasBuffering () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::sds_tts_fi_types::T_e8_BufferingOption SynthesizeWriteStart::getBuffering () const {
    return _Buffering;
}

inline void SynthesizeWriteStart::setBuffering (::sds_tts_fi_types::T_e8_BufferingOption Buffering_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_BufferingOption_IsValid(Buffering_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Buffering_, "T_e8_BufferingOption", "Buffering", "SynthesizeWriteStart");
    }
    #endif
    set_has_Buffering();
    this->_Buffering = Buffering_;
}

inline void SynthesizeWriteStart::clearExpDate() {
    if (hasExpDate()) {
         clear_has_ExpDate();
        _ExpDate = 0u;
     }
}

inline bool SynthesizeWriteStart::hasExpDate () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 SynthesizeWriteStart::getExpDate () const {
    return _ExpDate;
}

inline void SynthesizeWriteStart::setExpDate (uint32 ExpDate_) {
    set_has_ExpDate();
    this->_ExpDate = ExpDate_;
}

inline void SynthesizeWriteStart::clearLastPackage() {
    if (hasLastPackage()) {
         clear_has_LastPackage();
        _LastPackage = false;
     }
}

inline bool SynthesizeWriteStart::hasLastPackage () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool SynthesizeWriteStart::getLastPackage () const {
    return _LastPackage;
}

inline void SynthesizeWriteStart::setLastPackage (bool LastPackage_) {
    set_has_LastPackage();
    this->_LastPackage = LastPackage_;
}

inline void SynthesizeWriteStart::clearCompression() {
    if (hasCompression()) {
         clear_has_Compression();
        _Compression = ::acr_fi_types::T_b8_AudioFormat ();
     }
}

inline bool SynthesizeWriteStart::hasCompression () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::acr_fi_types::T_b8_AudioFormat& SynthesizeWriteStart::getCompression () const {
    return _Compression;
}

inline ::acr_fi_types::T_b8_AudioFormat& SynthesizeWriteStart::getCompressionMutable () {
    set_has_Compression();
    return _Compression;
}

inline void SynthesizeWriteStart::setCompression (const ::acr_fi_types::T_b8_AudioFormat& Compression_) {
    set_has_Compression();
    this->_Compression = Compression_;
}

inline void SynthesizeWriteStart::set_has_TextAndTags () {
    _has_bits_[0] |= 1u << 0;
}

inline void SynthesizeWriteStart::clear_has_TextAndTags () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SynthesizeWriteStart::set_has_TextStyle () {
    _has_bits_[0] |= 1u << 1;
}

inline void SynthesizeWriteStart::clear_has_TextStyle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SynthesizeWriteStart::set_has_Buffering () {
    _has_bits_[0] |= 1u << 2;
}

inline void SynthesizeWriteStart::clear_has_Buffering () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SynthesizeWriteStart::set_has_ExpDate () {
    _has_bits_[0] |= 1u << 3;
}

inline void SynthesizeWriteStart::clear_has_ExpDate () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SynthesizeWriteStart::set_has_LastPackage () {
    _has_bits_[0] |= 1u << 4;
}

inline void SynthesizeWriteStart::clear_has_LastPackage () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void SynthesizeWriteStart::set_has_Compression () {
    _has_bits_[0] |= 1u << 5;
}

inline void SynthesizeWriteStart::clear_has_Compression () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  SynthesizeWriteResultFirst::SynthesizeWriteResultFirst ()  :
    _BufferingProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SynthesizeWriteResultFirst::SynthesizeWriteResultFirst (const SynthesizeWriteResultFirst &rhs)  :
    ::asf::core::Payload(rhs),
    _BufferingProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SynthesizeWriteResultFirst::SynthesizeWriteResultFirst (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_)  :
    _BufferingProgress (BufferingProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SynthesizeWriteResultFirst::~SynthesizeWriteResultFirst() {
}

inline SynthesizeWriteResultFirst& SynthesizeWriteResultFirst::operator = (const SynthesizeWriteResultFirst& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBufferingProgress()) {
            setBufferingProgress(rhs.getBufferingProgress());
        } else {
            clearBufferingProgress();
        }
    }
    return *this;
}

inline bool SynthesizeWriteResultFirst::operator == (const SynthesizeWriteResultFirst& rhs) const {
    return (((!hasBufferingProgress() && !rhs.hasBufferingProgress()) || getBufferingProgress() == rhs.getBufferingProgress()));
}

inline bool SynthesizeWriteResultFirst::operator != (const SynthesizeWriteResultFirst& rhs) const {
    return ! (*this == rhs);
}

inline bool SynthesizeWriteResultFirst::operator < (const SynthesizeWriteResultFirst& rhs) const {
    if (hasBufferingProgress() || rhs.hasBufferingProgress()) {
        if (getBufferingProgress() < rhs.getBufferingProgress()) return true;
        if (getBufferingProgress() > rhs.getBufferingProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SynthesizeWriteResultFirst::clone() {
    return new SynthesizeWriteResultFirst(*this);
}

inline bool SynthesizeWriteResultFirst::operator > (const SynthesizeWriteResultFirst& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SynthesizeWriteResultFirst::clear() {
    clearBufferingProgress();
}

inline void SynthesizeWriteResultFirst::clearBufferingProgress() {
    if (hasBufferingProgress()) {
         clear_has_BufferingProgress();
        _BufferingProgress.clear();
     }
}

inline bool SynthesizeWriteResultFirst::hasBufferingProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& SynthesizeWriteResultFirst::getBufferingProgress () const {
    return _BufferingProgress;
}

inline ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& SynthesizeWriteResultFirst::getBufferingProgressMutable () {
    set_has_BufferingProgress();
    return _BufferingProgress;
}

inline void SynthesizeWriteResultFirst::setBufferingProgress (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_) {
    set_has_BufferingProgress();
    this->_BufferingProgress = BufferingProgress_;
}

inline void SynthesizeWriteResultFirst::set_has_BufferingProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void SynthesizeWriteResultFirst::clear_has_BufferingProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SynthesizeWriteResultMiddle::SynthesizeWriteResultMiddle ()  :
    _BufferingProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SynthesizeWriteResultMiddle::SynthesizeWriteResultMiddle (const SynthesizeWriteResultMiddle &rhs)  :
    ::asf::core::Payload(rhs),
    _BufferingProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SynthesizeWriteResultMiddle::SynthesizeWriteResultMiddle (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_)  :
    _BufferingProgress (BufferingProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SynthesizeWriteResultMiddle::~SynthesizeWriteResultMiddle() {
}

inline SynthesizeWriteResultMiddle& SynthesizeWriteResultMiddle::operator = (const SynthesizeWriteResultMiddle& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBufferingProgress()) {
            setBufferingProgress(rhs.getBufferingProgress());
        } else {
            clearBufferingProgress();
        }
    }
    return *this;
}

inline bool SynthesizeWriteResultMiddle::operator == (const SynthesizeWriteResultMiddle& rhs) const {
    return (((!hasBufferingProgress() && !rhs.hasBufferingProgress()) || getBufferingProgress() == rhs.getBufferingProgress()));
}

inline bool SynthesizeWriteResultMiddle::operator != (const SynthesizeWriteResultMiddle& rhs) const {
    return ! (*this == rhs);
}

inline bool SynthesizeWriteResultMiddle::operator < (const SynthesizeWriteResultMiddle& rhs) const {
    if (hasBufferingProgress() || rhs.hasBufferingProgress()) {
        if (getBufferingProgress() < rhs.getBufferingProgress()) return true;
        if (getBufferingProgress() > rhs.getBufferingProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SynthesizeWriteResultMiddle::clone() {
    return new SynthesizeWriteResultMiddle(*this);
}

inline bool SynthesizeWriteResultMiddle::operator > (const SynthesizeWriteResultMiddle& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SynthesizeWriteResultMiddle::clear() {
    clearBufferingProgress();
}

inline void SynthesizeWriteResultMiddle::clearBufferingProgress() {
    if (hasBufferingProgress()) {
         clear_has_BufferingProgress();
        _BufferingProgress.clear();
     }
}

inline bool SynthesizeWriteResultMiddle::hasBufferingProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& SynthesizeWriteResultMiddle::getBufferingProgress () const {
    return _BufferingProgress;
}

inline ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& SynthesizeWriteResultMiddle::getBufferingProgressMutable () {
    set_has_BufferingProgress();
    return _BufferingProgress;
}

inline void SynthesizeWriteResultMiddle::setBufferingProgress (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_) {
    set_has_BufferingProgress();
    this->_BufferingProgress = BufferingProgress_;
}

inline void SynthesizeWriteResultMiddle::set_has_BufferingProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void SynthesizeWriteResultMiddle::clear_has_BufferingProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SynthesizeWriteResultLast::SynthesizeWriteResultLast ()  :
    _BufferingProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SynthesizeWriteResultLast::SynthesizeWriteResultLast (const SynthesizeWriteResultLast &rhs)  :
    ::asf::core::Payload(rhs),
    _BufferingProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SynthesizeWriteResultLast::SynthesizeWriteResultLast (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_)  :
    _BufferingProgress (BufferingProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SynthesizeWriteResultLast::~SynthesizeWriteResultLast() {
}

inline SynthesizeWriteResultLast& SynthesizeWriteResultLast::operator = (const SynthesizeWriteResultLast& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBufferingProgress()) {
            setBufferingProgress(rhs.getBufferingProgress());
        } else {
            clearBufferingProgress();
        }
    }
    return *this;
}

inline bool SynthesizeWriteResultLast::operator == (const SynthesizeWriteResultLast& rhs) const {
    return (((!hasBufferingProgress() && !rhs.hasBufferingProgress()) || getBufferingProgress() == rhs.getBufferingProgress()));
}

inline bool SynthesizeWriteResultLast::operator != (const SynthesizeWriteResultLast& rhs) const {
    return ! (*this == rhs);
}

inline bool SynthesizeWriteResultLast::operator < (const SynthesizeWriteResultLast& rhs) const {
    if (hasBufferingProgress() || rhs.hasBufferingProgress()) {
        if (getBufferingProgress() < rhs.getBufferingProgress()) return true;
        if (getBufferingProgress() > rhs.getBufferingProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SynthesizeWriteResultLast::clone() {
    return new SynthesizeWriteResultLast(*this);
}

inline bool SynthesizeWriteResultLast::operator > (const SynthesizeWriteResultLast& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SynthesizeWriteResultLast::clear() {
    clearBufferingProgress();
}

inline void SynthesizeWriteResultLast::clearBufferingProgress() {
    if (hasBufferingProgress()) {
         clear_has_BufferingProgress();
        _BufferingProgress.clear();
     }
}

inline bool SynthesizeWriteResultLast::hasBufferingProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& SynthesizeWriteResultLast::getBufferingProgress () const {
    return _BufferingProgress;
}

inline ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& SynthesizeWriteResultLast::getBufferingProgressMutable () {
    set_has_BufferingProgress();
    return _BufferingProgress;
}

inline void SynthesizeWriteResultLast::setBufferingProgress (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_) {
    set_has_BufferingProgress();
    this->_BufferingProgress = BufferingProgress_;
}

inline void SynthesizeWriteResultLast::set_has_BufferingProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void SynthesizeWriteResultLast::clear_has_BufferingProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SynthesizeWriteError::SynthesizeWriteError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::SynthesizeWriteErrorCode__Unspecified;
}

inline  SynthesizeWriteError::SynthesizeWriteError (const SynthesizeWriteError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::SynthesizeWriteErrorCode__Unspecified;
    *this = rhs;
}

inline  SynthesizeWriteError::~SynthesizeWriteError() {
    deleteData ();
}

inline SynthesizeWriteError& SynthesizeWriteError::operator = (const SynthesizeWriteError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SynthesizeWriteError::operator == (const SynthesizeWriteError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SynthesizeWriteError::operator != (const SynthesizeWriteError& rhs) const {
    return ! (*this == rhs);
}

inline bool SynthesizeWriteError::operator < (const SynthesizeWriteError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SynthesizeWriteError::operator > (const SynthesizeWriteError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SynthesizeWriteError::SynthesizeWriteErrorField SynthesizeWriteError::getField () const {
    return __field;
}

inline void SynthesizeWriteError::setField(SynthesizeWriteError::SynthesizeWriteErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::SynthesizeWriteErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SynthesizeWriteError::clone() {
    return new SynthesizeWriteError(*this);
}

inline bool SynthesizeWriteError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline SynthesizeWriteErrorCode SynthesizeWriteError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SynthesizeWriteError", getField());
    }
    return (SynthesizeWriteErrorCode) _data.ccaErrorCode_;
}

inline void SynthesizeWriteError::setCcaErrorCode (SynthesizeWriteErrorCode value) {
    #ifndef NDEBUG
    if (!(SynthesizeWriteErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SynthesizeWriteErrorCode", "ccaErrorCode", "SynthesizeWriteError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool SynthesizeWriteError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SynthesizeWriteError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SynthesizeWriteError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SynthesizeWriteError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SynthesizeWriteError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SynthesizeWriteError::cloneData (const SynthesizeWriteError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SynthesizeWriteError::deleteData () {
}

inline  SynthesizeSpeakWithExtensionStart::SynthesizeSpeakWithExtensionStart ()  :
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_AudioSourceID__Debug_Retrigger),
    _LanguageID (),
    _AudioOutputLocation (),
    _StatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo),
    _ExpDate (0u),
    _LastPackage (false),
    _Index (0u),
    _SpeechSequence (::sds_tts_fi_types::T_e8SequenceCategory__Immediate)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SynthesizeSpeakWithExtensionStart::SynthesizeSpeakWithExtensionStart (const SynthesizeSpeakWithExtensionStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_AudioSourceID__Debug_Retrigger),
    _LanguageID (),
    _AudioOutputLocation (),
    _StatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo),
    _ExpDate (0u),
    _LastPackage (false),
    _Index (0u),
    _SpeechSequence (::sds_tts_fi_types::T_e8SequenceCategory__Immediate)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SynthesizeSpeakWithExtensionStart::SynthesizeSpeakWithExtensionStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_AudioSourceID TextStyle_, const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_, const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_, ::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_, uint32 ExpDate_, bool LastPackage_, uint8 Index_, ::sds_tts_fi_types::T_e8SequenceCategory SpeechSequence_)  :
    _TextAndTags (TextAndTags_),
    _TextStyle (TextStyle_),
    _LanguageID (LanguageID_),
    _AudioOutputLocation (AudioOutputLocation_),
    _StatusInfo (StatusInfo_),
    _ExpDate (ExpDate_),
    _LastPackage (LastPackage_),
    _Index (Index_),
    _SpeechSequence (SpeechSequence_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_AudioSourceID_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_AudioSourceID", "TextStyle", "SynthesizeSpeakWithExtensionStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_StatusInfoOption_IsValid(StatusInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusInfo_, "T_e8_StatusInfoOption", "StatusInfo", "SynthesizeSpeakWithExtensionStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8SequenceCategory_IsValid(SpeechSequence_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SpeechSequence_, "T_e8SequenceCategory", "SpeechSequence", "SynthesizeSpeakWithExtensionStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SynthesizeSpeakWithExtensionStart::~SynthesizeSpeakWithExtensionStart() {
}

inline SynthesizeSpeakWithExtensionStart& SynthesizeSpeakWithExtensionStart::operator = (const SynthesizeSpeakWithExtensionStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTextAndTags()) {
            setTextAndTags(rhs.getTextAndTags());
        } else {
            clearTextAndTags();
        }
        if (rhs.hasTextStyle()) {
            setTextStyle(rhs.getTextStyle());
        } else {
            clearTextStyle();
        }
        if (rhs.hasLanguageID()) {
            setLanguageID(rhs.getLanguageID());
        } else {
            clearLanguageID();
        }
        if (rhs.hasAudioOutputLocation()) {
            setAudioOutputLocation(rhs.getAudioOutputLocation());
        } else {
            clearAudioOutputLocation();
        }
        if (rhs.hasStatusInfo()) {
            setStatusInfo(rhs.getStatusInfo());
        } else {
            clearStatusInfo();
        }
        if (rhs.hasExpDate()) {
            setExpDate(rhs.getExpDate());
        } else {
            clearExpDate();
        }
        if (rhs.hasLastPackage()) {
            setLastPackage(rhs.getLastPackage());
        } else {
            clearLastPackage();
        }
        if (rhs.hasIndex()) {
            setIndex(rhs.getIndex());
        } else {
            clearIndex();
        }
        if (rhs.hasSpeechSequence()) {
            setSpeechSequence(rhs.getSpeechSequence());
        } else {
            clearSpeechSequence();
        }
    }
    return *this;
}

inline bool SynthesizeSpeakWithExtensionStart::operator == (const SynthesizeSpeakWithExtensionStart& rhs) const {
    return (((!hasTextAndTags() && !rhs.hasTextAndTags()) || getTextAndTags() == rhs.getTextAndTags()) &&
        ((!hasTextStyle() && !rhs.hasTextStyle()) || getTextStyle() == rhs.getTextStyle()) &&
        ((!hasLanguageID() && !rhs.hasLanguageID()) || getLanguageID() == rhs.getLanguageID()) &&
        ((!hasAudioOutputLocation() && !rhs.hasAudioOutputLocation()) || getAudioOutputLocation() == rhs.getAudioOutputLocation()) &&
        ((!hasStatusInfo() && !rhs.hasStatusInfo()) || getStatusInfo() == rhs.getStatusInfo()) &&
        ((!hasExpDate() && !rhs.hasExpDate()) || getExpDate() == rhs.getExpDate()) &&
        ((!hasLastPackage() && !rhs.hasLastPackage()) || getLastPackage() == rhs.getLastPackage()) &&
        ((!hasIndex() && !rhs.hasIndex()) || getIndex() == rhs.getIndex()) &&
        ((!hasSpeechSequence() && !rhs.hasSpeechSequence()) || getSpeechSequence() == rhs.getSpeechSequence()));
}

inline bool SynthesizeSpeakWithExtensionStart::operator != (const SynthesizeSpeakWithExtensionStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SynthesizeSpeakWithExtensionStart::operator < (const SynthesizeSpeakWithExtensionStart& rhs) const {
    if (hasTextAndTags() || rhs.hasTextAndTags()) {
        if (getTextAndTags() < rhs.getTextAndTags()) return true;
        if (getTextAndTags() > rhs.getTextAndTags()) return false;
    }
    if (hasTextStyle() || rhs.hasTextStyle()) {
        if ((uint32)getTextStyle() < (uint32)rhs.getTextStyle()) return true;
        if ((uint32)getTextStyle() > (uint32)rhs.getTextStyle()) return false;
    }
    if (hasLanguageID() || rhs.hasLanguageID()) {
        if (getLanguageID() < rhs.getLanguageID()) return true;
        if (getLanguageID() > rhs.getLanguageID()) return false;
    }
    if (hasAudioOutputLocation() || rhs.hasAudioOutputLocation()) {
        if (getAudioOutputLocation() < rhs.getAudioOutputLocation()) return true;
        if (getAudioOutputLocation() > rhs.getAudioOutputLocation()) return false;
    }
    if (hasStatusInfo() || rhs.hasStatusInfo()) {
        if ((uint32)getStatusInfo() < (uint32)rhs.getStatusInfo()) return true;
        if ((uint32)getStatusInfo() > (uint32)rhs.getStatusInfo()) return false;
    }
    if (hasExpDate() || rhs.hasExpDate()) {
        if (getExpDate() < rhs.getExpDate()) return true;
        if (getExpDate() > rhs.getExpDate()) return false;
    }
    if (hasLastPackage() || rhs.hasLastPackage()) {
        if (getLastPackage() < rhs.getLastPackage()) return true;
        if (getLastPackage() > rhs.getLastPackage()) return false;
    }
    if (hasIndex() || rhs.hasIndex()) {
        if (getIndex() < rhs.getIndex()) return true;
        if (getIndex() > rhs.getIndex()) return false;
    }
    if (hasSpeechSequence() || rhs.hasSpeechSequence()) {
        if ((uint32)getSpeechSequence() < (uint32)rhs.getSpeechSequence()) return true;
        if ((uint32)getSpeechSequence() > (uint32)rhs.getSpeechSequence()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SynthesizeSpeakWithExtensionStart::clone() {
    return new SynthesizeSpeakWithExtensionStart(*this);
}

inline bool SynthesizeSpeakWithExtensionStart::operator > (const SynthesizeSpeakWithExtensionStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SynthesizeSpeakWithExtensionStart::clear() {
    clearTextAndTags();
    clearTextStyle();
    clearLanguageID();
    clearAudioOutputLocation();
    clearStatusInfo();
    clearExpDate();
    clearLastPackage();
    clearIndex();
    clearSpeechSequence();
}

inline void SynthesizeSpeakWithExtensionStart::clearTextAndTags() {
    if (hasTextAndTags()) {
         clear_has_TextAndTags();
        _TextAndTags.clear();
     }
}

inline bool SynthesizeSpeakWithExtensionStart::hasTextAndTags () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SynthesizeSpeakWithExtensionStart::getTextAndTags () const {
    return _TextAndTags;
}

inline ::std::string& SynthesizeSpeakWithExtensionStart::getTextAndTagsMutable () {
    set_has_TextAndTags();
    return _TextAndTags;
}

inline void SynthesizeSpeakWithExtensionStart::setTextAndTags (const ::std::string& TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags = TextAndTags_;
}

inline void SynthesizeSpeakWithExtensionStart::setTextAndTags (const char* TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(TextAndTags_);
}

inline void SynthesizeSpeakWithExtensionStart::setTextAndTags (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(value, size);
}

inline void SynthesizeSpeakWithExtensionStart::clearTextStyle() {
    if (hasTextStyle()) {
         clear_has_TextStyle();
        _TextStyle = ::sds_tts_fi_types::T_e8_AudioSourceID__Debug_Retrigger;
     }
}

inline bool SynthesizeSpeakWithExtensionStart::hasTextStyle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sds_tts_fi_types::T_e8_AudioSourceID SynthesizeSpeakWithExtensionStart::getTextStyle () const {
    return _TextStyle;
}

inline void SynthesizeSpeakWithExtensionStart::setTextStyle (::sds_tts_fi_types::T_e8_AudioSourceID TextStyle_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_AudioSourceID_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_AudioSourceID", "TextStyle", "SynthesizeSpeakWithExtensionStart");
    }
    #endif
    set_has_TextStyle();
    this->_TextStyle = TextStyle_;
}

inline void SynthesizeSpeakWithExtensionStart::clearLanguageID() {
    if (hasLanguageID()) {
         clear_has_LanguageID();
        _LanguageID.clear();
     }
}

inline bool SynthesizeSpeakWithExtensionStart::hasLanguageID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::sds_sds2hmi_common_types::T_SDSLanguageID& SynthesizeSpeakWithExtensionStart::getLanguageID () const {
    return _LanguageID;
}

inline ::sds_sds2hmi_common_types::T_SDSLanguageID& SynthesizeSpeakWithExtensionStart::getLanguageIDMutable () {
    set_has_LanguageID();
    return _LanguageID;
}

inline void SynthesizeSpeakWithExtensionStart::setLanguageID (const ::sds_sds2hmi_common_types::T_SDSLanguageID& LanguageID_) {
    set_has_LanguageID();
    this->_LanguageID = LanguageID_;
}

inline void SynthesizeSpeakWithExtensionStart::clearAudioOutputLocation() {
    if (hasAudioOutputLocation()) {
         clear_has_AudioOutputLocation();
        _AudioOutputLocation = ::acr_fi_types::T_b8_AudioOutputLocation ();
     }
}

inline bool SynthesizeSpeakWithExtensionStart::hasAudioOutputLocation () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::acr_fi_types::T_b8_AudioOutputLocation& SynthesizeSpeakWithExtensionStart::getAudioOutputLocation () const {
    return _AudioOutputLocation;
}

inline ::acr_fi_types::T_b8_AudioOutputLocation& SynthesizeSpeakWithExtensionStart::getAudioOutputLocationMutable () {
    set_has_AudioOutputLocation();
    return _AudioOutputLocation;
}

inline void SynthesizeSpeakWithExtensionStart::setAudioOutputLocation (const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_) {
    set_has_AudioOutputLocation();
    this->_AudioOutputLocation = AudioOutputLocation_;
}

inline void SynthesizeSpeakWithExtensionStart::clearStatusInfo() {
    if (hasStatusInfo()) {
         clear_has_StatusInfo();
        _StatusInfo = ::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo;
     }
}

inline bool SynthesizeSpeakWithExtensionStart::hasStatusInfo () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline ::sds_tts_fi_types::T_e8_StatusInfoOption SynthesizeSpeakWithExtensionStart::getStatusInfo () const {
    return _StatusInfo;
}

inline void SynthesizeSpeakWithExtensionStart::setStatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_StatusInfoOption_IsValid(StatusInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusInfo_, "T_e8_StatusInfoOption", "StatusInfo", "SynthesizeSpeakWithExtensionStart");
    }
    #endif
    set_has_StatusInfo();
    this->_StatusInfo = StatusInfo_;
}

inline void SynthesizeSpeakWithExtensionStart::clearExpDate() {
    if (hasExpDate()) {
         clear_has_ExpDate();
        _ExpDate = 0u;
     }
}

inline bool SynthesizeSpeakWithExtensionStart::hasExpDate () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 SynthesizeSpeakWithExtensionStart::getExpDate () const {
    return _ExpDate;
}

inline void SynthesizeSpeakWithExtensionStart::setExpDate (uint32 ExpDate_) {
    set_has_ExpDate();
    this->_ExpDate = ExpDate_;
}

inline void SynthesizeSpeakWithExtensionStart::clearLastPackage() {
    if (hasLastPackage()) {
         clear_has_LastPackage();
        _LastPackage = false;
     }
}

inline bool SynthesizeSpeakWithExtensionStart::hasLastPackage () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool SynthesizeSpeakWithExtensionStart::getLastPackage () const {
    return _LastPackage;
}

inline void SynthesizeSpeakWithExtensionStart::setLastPackage (bool LastPackage_) {
    set_has_LastPackage();
    this->_LastPackage = LastPackage_;
}

inline void SynthesizeSpeakWithExtensionStart::clearIndex() {
    if (hasIndex()) {
         clear_has_Index();
        _Index = 0u;
     }
}

inline bool SynthesizeSpeakWithExtensionStart::hasIndex () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 SynthesizeSpeakWithExtensionStart::getIndex () const {
    return _Index;
}

inline void SynthesizeSpeakWithExtensionStart::setIndex (uint8 Index_) {
    set_has_Index();
    this->_Index = Index_;
}

inline void SynthesizeSpeakWithExtensionStart::clearSpeechSequence() {
    if (hasSpeechSequence()) {
         clear_has_SpeechSequence();
        _SpeechSequence = ::sds_tts_fi_types::T_e8SequenceCategory__Immediate;
     }
}

inline bool SynthesizeSpeakWithExtensionStart::hasSpeechSequence () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline ::sds_tts_fi_types::T_e8SequenceCategory SynthesizeSpeakWithExtensionStart::getSpeechSequence () const {
    return _SpeechSequence;
}

inline void SynthesizeSpeakWithExtensionStart::setSpeechSequence (::sds_tts_fi_types::T_e8SequenceCategory SpeechSequence_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8SequenceCategory_IsValid(SpeechSequence_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SpeechSequence_, "T_e8SequenceCategory", "SpeechSequence", "SynthesizeSpeakWithExtensionStart");
    }
    #endif
    set_has_SpeechSequence();
    this->_SpeechSequence = SpeechSequence_;
}

inline void SynthesizeSpeakWithExtensionStart::set_has_TextAndTags () {
    _has_bits_[0] |= 1u << 0;
}

inline void SynthesizeSpeakWithExtensionStart::clear_has_TextAndTags () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SynthesizeSpeakWithExtensionStart::set_has_TextStyle () {
    _has_bits_[0] |= 1u << 1;
}

inline void SynthesizeSpeakWithExtensionStart::clear_has_TextStyle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SynthesizeSpeakWithExtensionStart::set_has_LanguageID () {
    _has_bits_[0] |= 1u << 2;
}

inline void SynthesizeSpeakWithExtensionStart::clear_has_LanguageID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SynthesizeSpeakWithExtensionStart::set_has_AudioOutputLocation () {
    _has_bits_[0] |= 1u << 3;
}

inline void SynthesizeSpeakWithExtensionStart::clear_has_AudioOutputLocation () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SynthesizeSpeakWithExtensionStart::set_has_StatusInfo () {
    _has_bits_[0] |= 1u << 4;
}

inline void SynthesizeSpeakWithExtensionStart::clear_has_StatusInfo () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void SynthesizeSpeakWithExtensionStart::set_has_ExpDate () {
    _has_bits_[0] |= 1u << 5;
}

inline void SynthesizeSpeakWithExtensionStart::clear_has_ExpDate () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void SynthesizeSpeakWithExtensionStart::set_has_LastPackage () {
    _has_bits_[0] |= 1u << 6;
}

inline void SynthesizeSpeakWithExtensionStart::clear_has_LastPackage () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void SynthesizeSpeakWithExtensionStart::set_has_Index () {
    _has_bits_[0] |= 1u << 7;
}

inline void SynthesizeSpeakWithExtensionStart::clear_has_Index () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void SynthesizeSpeakWithExtensionStart::set_has_SpeechSequence () {
    _has_bits_[0] |= 1u << 8;
}

inline void SynthesizeSpeakWithExtensionStart::clear_has_SpeechSequence () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  SynthesizeSpeakWithExtensionResultFirst::SynthesizeSpeakWithExtensionResultFirst ()  :
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SynthesizeSpeakWithExtensionResultFirst::SynthesizeSpeakWithExtensionResultFirst (const SynthesizeSpeakWithExtensionResultFirst &rhs)  :
    ::asf::core::Payload(rhs),
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SynthesizeSpeakWithExtensionResultFirst::SynthesizeSpeakWithExtensionResultFirst (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_)  :
    _JobProgress (JobProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SynthesizeSpeakWithExtensionResultFirst::~SynthesizeSpeakWithExtensionResultFirst() {
}

inline SynthesizeSpeakWithExtensionResultFirst& SynthesizeSpeakWithExtensionResultFirst::operator = (const SynthesizeSpeakWithExtensionResultFirst& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobProgress()) {
            setJobProgress(rhs.getJobProgress());
        } else {
            clearJobProgress();
        }
    }
    return *this;
}

inline bool SynthesizeSpeakWithExtensionResultFirst::operator == (const SynthesizeSpeakWithExtensionResultFirst& rhs) const {
    return (((!hasJobProgress() && !rhs.hasJobProgress()) || getJobProgress() == rhs.getJobProgress()));
}

inline bool SynthesizeSpeakWithExtensionResultFirst::operator != (const SynthesizeSpeakWithExtensionResultFirst& rhs) const {
    return ! (*this == rhs);
}

inline bool SynthesizeSpeakWithExtensionResultFirst::operator < (const SynthesizeSpeakWithExtensionResultFirst& rhs) const {
    if (hasJobProgress() || rhs.hasJobProgress()) {
        if (getJobProgress() < rhs.getJobProgress()) return true;
        if (getJobProgress() > rhs.getJobProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SynthesizeSpeakWithExtensionResultFirst::clone() {
    return new SynthesizeSpeakWithExtensionResultFirst(*this);
}

inline bool SynthesizeSpeakWithExtensionResultFirst::operator > (const SynthesizeSpeakWithExtensionResultFirst& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SynthesizeSpeakWithExtensionResultFirst::clear() {
    clearJobProgress();
}

inline void SynthesizeSpeakWithExtensionResultFirst::clearJobProgress() {
    if (hasJobProgress()) {
         clear_has_JobProgress();
        _JobProgress.clear();
     }
}

inline bool SynthesizeSpeakWithExtensionResultFirst::hasJobProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_tts_fi_types::T_SpeakProgress& SynthesizeSpeakWithExtensionResultFirst::getJobProgress () const {
    return _JobProgress;
}

inline ::sds_tts_fi_types::T_SpeakProgress& SynthesizeSpeakWithExtensionResultFirst::getJobProgressMutable () {
    set_has_JobProgress();
    return _JobProgress;
}

inline void SynthesizeSpeakWithExtensionResultFirst::setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_) {
    set_has_JobProgress();
    this->_JobProgress = JobProgress_;
}

inline void SynthesizeSpeakWithExtensionResultFirst::set_has_JobProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void SynthesizeSpeakWithExtensionResultFirst::clear_has_JobProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SynthesizeSpeakWithExtensionResultMiddle::SynthesizeSpeakWithExtensionResultMiddle ()  :
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SynthesizeSpeakWithExtensionResultMiddle::SynthesizeSpeakWithExtensionResultMiddle (const SynthesizeSpeakWithExtensionResultMiddle &rhs)  :
    ::asf::core::Payload(rhs),
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SynthesizeSpeakWithExtensionResultMiddle::SynthesizeSpeakWithExtensionResultMiddle (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_)  :
    _JobProgress (JobProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SynthesizeSpeakWithExtensionResultMiddle::~SynthesizeSpeakWithExtensionResultMiddle() {
}

inline SynthesizeSpeakWithExtensionResultMiddle& SynthesizeSpeakWithExtensionResultMiddle::operator = (const SynthesizeSpeakWithExtensionResultMiddle& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobProgress()) {
            setJobProgress(rhs.getJobProgress());
        } else {
            clearJobProgress();
        }
    }
    return *this;
}

inline bool SynthesizeSpeakWithExtensionResultMiddle::operator == (const SynthesizeSpeakWithExtensionResultMiddle& rhs) const {
    return (((!hasJobProgress() && !rhs.hasJobProgress()) || getJobProgress() == rhs.getJobProgress()));
}

inline bool SynthesizeSpeakWithExtensionResultMiddle::operator != (const SynthesizeSpeakWithExtensionResultMiddle& rhs) const {
    return ! (*this == rhs);
}

inline bool SynthesizeSpeakWithExtensionResultMiddle::operator < (const SynthesizeSpeakWithExtensionResultMiddle& rhs) const {
    if (hasJobProgress() || rhs.hasJobProgress()) {
        if (getJobProgress() < rhs.getJobProgress()) return true;
        if (getJobProgress() > rhs.getJobProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SynthesizeSpeakWithExtensionResultMiddle::clone() {
    return new SynthesizeSpeakWithExtensionResultMiddle(*this);
}

inline bool SynthesizeSpeakWithExtensionResultMiddle::operator > (const SynthesizeSpeakWithExtensionResultMiddle& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SynthesizeSpeakWithExtensionResultMiddle::clear() {
    clearJobProgress();
}

inline void SynthesizeSpeakWithExtensionResultMiddle::clearJobProgress() {
    if (hasJobProgress()) {
         clear_has_JobProgress();
        _JobProgress.clear();
     }
}

inline bool SynthesizeSpeakWithExtensionResultMiddle::hasJobProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_tts_fi_types::T_SpeakProgress& SynthesizeSpeakWithExtensionResultMiddle::getJobProgress () const {
    return _JobProgress;
}

inline ::sds_tts_fi_types::T_SpeakProgress& SynthesizeSpeakWithExtensionResultMiddle::getJobProgressMutable () {
    set_has_JobProgress();
    return _JobProgress;
}

inline void SynthesizeSpeakWithExtensionResultMiddle::setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_) {
    set_has_JobProgress();
    this->_JobProgress = JobProgress_;
}

inline void SynthesizeSpeakWithExtensionResultMiddle::set_has_JobProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void SynthesizeSpeakWithExtensionResultMiddle::clear_has_JobProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SynthesizeSpeakWithExtensionResultLast::SynthesizeSpeakWithExtensionResultLast ()  :
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SynthesizeSpeakWithExtensionResultLast::SynthesizeSpeakWithExtensionResultLast (const SynthesizeSpeakWithExtensionResultLast &rhs)  :
    ::asf::core::Payload(rhs),
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SynthesizeSpeakWithExtensionResultLast::SynthesizeSpeakWithExtensionResultLast (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_)  :
    _JobProgress (JobProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SynthesizeSpeakWithExtensionResultLast::~SynthesizeSpeakWithExtensionResultLast() {
}

inline SynthesizeSpeakWithExtensionResultLast& SynthesizeSpeakWithExtensionResultLast::operator = (const SynthesizeSpeakWithExtensionResultLast& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobProgress()) {
            setJobProgress(rhs.getJobProgress());
        } else {
            clearJobProgress();
        }
    }
    return *this;
}

inline bool SynthesizeSpeakWithExtensionResultLast::operator == (const SynthesizeSpeakWithExtensionResultLast& rhs) const {
    return (((!hasJobProgress() && !rhs.hasJobProgress()) || getJobProgress() == rhs.getJobProgress()));
}

inline bool SynthesizeSpeakWithExtensionResultLast::operator != (const SynthesizeSpeakWithExtensionResultLast& rhs) const {
    return ! (*this == rhs);
}

inline bool SynthesizeSpeakWithExtensionResultLast::operator < (const SynthesizeSpeakWithExtensionResultLast& rhs) const {
    if (hasJobProgress() || rhs.hasJobProgress()) {
        if (getJobProgress() < rhs.getJobProgress()) return true;
        if (getJobProgress() > rhs.getJobProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SynthesizeSpeakWithExtensionResultLast::clone() {
    return new SynthesizeSpeakWithExtensionResultLast(*this);
}

inline bool SynthesizeSpeakWithExtensionResultLast::operator > (const SynthesizeSpeakWithExtensionResultLast& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SynthesizeSpeakWithExtensionResultLast::clear() {
    clearJobProgress();
}

inline void SynthesizeSpeakWithExtensionResultLast::clearJobProgress() {
    if (hasJobProgress()) {
         clear_has_JobProgress();
        _JobProgress.clear();
     }
}

inline bool SynthesizeSpeakWithExtensionResultLast::hasJobProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_tts_fi_types::T_SpeakProgress& SynthesizeSpeakWithExtensionResultLast::getJobProgress () const {
    return _JobProgress;
}

inline ::sds_tts_fi_types::T_SpeakProgress& SynthesizeSpeakWithExtensionResultLast::getJobProgressMutable () {
    set_has_JobProgress();
    return _JobProgress;
}

inline void SynthesizeSpeakWithExtensionResultLast::setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_) {
    set_has_JobProgress();
    this->_JobProgress = JobProgress_;
}

inline void SynthesizeSpeakWithExtensionResultLast::set_has_JobProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void SynthesizeSpeakWithExtensionResultLast::clear_has_JobProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SynthesizeSpeakWithExtensionError::SynthesizeSpeakWithExtensionError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::SynthesizeSpeakWithExtensionErrorCode__Unspecified;
}

inline  SynthesizeSpeakWithExtensionError::SynthesizeSpeakWithExtensionError (const SynthesizeSpeakWithExtensionError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::SynthesizeSpeakWithExtensionErrorCode__Unspecified;
    *this = rhs;
}

inline  SynthesizeSpeakWithExtensionError::~SynthesizeSpeakWithExtensionError() {
    deleteData ();
}

inline SynthesizeSpeakWithExtensionError& SynthesizeSpeakWithExtensionError::operator = (const SynthesizeSpeakWithExtensionError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SynthesizeSpeakWithExtensionError::operator == (const SynthesizeSpeakWithExtensionError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SynthesizeSpeakWithExtensionError::operator != (const SynthesizeSpeakWithExtensionError& rhs) const {
    return ! (*this == rhs);
}

inline bool SynthesizeSpeakWithExtensionError::operator < (const SynthesizeSpeakWithExtensionError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SynthesizeSpeakWithExtensionError::operator > (const SynthesizeSpeakWithExtensionError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SynthesizeSpeakWithExtensionError::SynthesizeSpeakWithExtensionErrorField SynthesizeSpeakWithExtensionError::getField () const {
    return __field;
}

inline void SynthesizeSpeakWithExtensionError::setField(SynthesizeSpeakWithExtensionError::SynthesizeSpeakWithExtensionErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::SynthesizeSpeakWithExtensionErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SynthesizeSpeakWithExtensionError::clone() {
    return new SynthesizeSpeakWithExtensionError(*this);
}

inline bool SynthesizeSpeakWithExtensionError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline SynthesizeSpeakWithExtensionErrorCode SynthesizeSpeakWithExtensionError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SynthesizeSpeakWithExtensionError", getField());
    }
    return (SynthesizeSpeakWithExtensionErrorCode) _data.ccaErrorCode_;
}

inline void SynthesizeSpeakWithExtensionError::setCcaErrorCode (SynthesizeSpeakWithExtensionErrorCode value) {
    #ifndef NDEBUG
    if (!(SynthesizeSpeakWithExtensionErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SynthesizeSpeakWithExtensionErrorCode", "ccaErrorCode", "SynthesizeSpeakWithExtensionError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool SynthesizeSpeakWithExtensionError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SynthesizeSpeakWithExtensionError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SynthesizeSpeakWithExtensionError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SynthesizeSpeakWithExtensionError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SynthesizeSpeakWithExtensionError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SynthesizeSpeakWithExtensionError::cloneData (const SynthesizeSpeakWithExtensionError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SynthesizeSpeakWithExtensionError::deleteData () {
}

inline  PrepareVoiceOutputStart::PrepareVoiceOutputStart ()  :
    _Device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PrepareVoiceOutputStart::PrepareVoiceOutputStart (const PrepareVoiceOutputStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PrepareVoiceOutputStart::PrepareVoiceOutputStart (const ::std::string& Device_)  :
    _Device (Device_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PrepareVoiceOutputStart::~PrepareVoiceOutputStart() {
}

inline PrepareVoiceOutputStart& PrepareVoiceOutputStart::operator = (const PrepareVoiceOutputStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool PrepareVoiceOutputStart::operator == (const PrepareVoiceOutputStart& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool PrepareVoiceOutputStart::operator != (const PrepareVoiceOutputStart& rhs) const {
    return ! (*this == rhs);
}

inline bool PrepareVoiceOutputStart::operator < (const PrepareVoiceOutputStart& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PrepareVoiceOutputStart::clone() {
    return new PrepareVoiceOutputStart(*this);
}

inline bool PrepareVoiceOutputStart::operator > (const PrepareVoiceOutputStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PrepareVoiceOutputStart::clear() {
    clearDevice();
}

inline void PrepareVoiceOutputStart::clearDevice() {
    if (hasDevice()) {
         clear_has_Device();
        _Device.clear();
     }
}

inline bool PrepareVoiceOutputStart::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PrepareVoiceOutputStart::getDevice () const {
    return _Device;
}

inline ::std::string& PrepareVoiceOutputStart::getDeviceMutable () {
    set_has_Device();
    return _Device;
}

inline void PrepareVoiceOutputStart::setDevice (const ::std::string& Device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Device();
    this->_Device = Device_;
}

inline void PrepareVoiceOutputStart::setDevice (const char* Device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Device();
    this->_Device.assign(Device_);
}

inline void PrepareVoiceOutputStart::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Device();
    this->_Device.assign(value, size);
}

inline void PrepareVoiceOutputStart::set_has_Device () {
    _has_bits_[0] |= 1u << 0;
}

inline void PrepareVoiceOutputStart::clear_has_Device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PrepareVoiceOutputError::PrepareVoiceOutputError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::PrepareVoiceOutputErrorCode__Unspecified;
}

inline  PrepareVoiceOutputError::PrepareVoiceOutputError (const PrepareVoiceOutputError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::PrepareVoiceOutputErrorCode__Unspecified;
    *this = rhs;
}

inline  PrepareVoiceOutputError::~PrepareVoiceOutputError() {
    deleteData ();
}

inline PrepareVoiceOutputError& PrepareVoiceOutputError::operator = (const PrepareVoiceOutputError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool PrepareVoiceOutputError::operator == (const PrepareVoiceOutputError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool PrepareVoiceOutputError::operator != (const PrepareVoiceOutputError& rhs) const {
    return ! (*this == rhs);
}

inline bool PrepareVoiceOutputError::operator < (const PrepareVoiceOutputError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool PrepareVoiceOutputError::operator > (const PrepareVoiceOutputError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline PrepareVoiceOutputError::PrepareVoiceOutputErrorField PrepareVoiceOutputError::getField () const {
    return __field;
}

inline void PrepareVoiceOutputError::setField(PrepareVoiceOutputError::PrepareVoiceOutputErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::PrepareVoiceOutputErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* PrepareVoiceOutputError::clone() {
    return new PrepareVoiceOutputError(*this);
}

inline bool PrepareVoiceOutputError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline PrepareVoiceOutputErrorCode PrepareVoiceOutputError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "PrepareVoiceOutputError", getField());
    }
    return (PrepareVoiceOutputErrorCode) _data.ccaErrorCode_;
}

inline void PrepareVoiceOutputError::setCcaErrorCode (PrepareVoiceOutputErrorCode value) {
    #ifndef NDEBUG
    if (!(PrepareVoiceOutputErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "PrepareVoiceOutputErrorCode", "ccaErrorCode", "PrepareVoiceOutputError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool PrepareVoiceOutputError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode PrepareVoiceOutputError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "PrepareVoiceOutputError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void PrepareVoiceOutputError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "PrepareVoiceOutputError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void PrepareVoiceOutputError::cloneData (const PrepareVoiceOutputError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void PrepareVoiceOutputError::deleteData () {
}

inline  ReleaseDataStart::ReleaseDataStart ()  :
    _ReleaseType (::sds_tts_fi_types::T_e8_ReleaseTypeTTS__VoiceChange)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReleaseDataStart::ReleaseDataStart (const ReleaseDataStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ReleaseType (::sds_tts_fi_types::T_e8_ReleaseTypeTTS__VoiceChange)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReleaseDataStart::ReleaseDataStart (::sds_tts_fi_types::T_e8_ReleaseTypeTTS ReleaseType_)  :
    _ReleaseType (ReleaseType_)
{
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_ReleaseTypeTTS_IsValid(ReleaseType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ReleaseType_, "T_e8_ReleaseTypeTTS", "ReleaseType", "ReleaseDataStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReleaseDataStart::~ReleaseDataStart() {
}

inline ReleaseDataStart& ReleaseDataStart::operator = (const ReleaseDataStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasReleaseType()) {
            setReleaseType(rhs.getReleaseType());
        } else {
            clearReleaseType();
        }
    }
    return *this;
}

inline bool ReleaseDataStart::operator == (const ReleaseDataStart& rhs) const {
    return (((!hasReleaseType() && !rhs.hasReleaseType()) || getReleaseType() == rhs.getReleaseType()));
}

inline bool ReleaseDataStart::operator != (const ReleaseDataStart& rhs) const {
    return ! (*this == rhs);
}

inline bool ReleaseDataStart::operator < (const ReleaseDataStart& rhs) const {
    if (hasReleaseType() || rhs.hasReleaseType()) {
        if ((uint32)getReleaseType() < (uint32)rhs.getReleaseType()) return true;
        if ((uint32)getReleaseType() > (uint32)rhs.getReleaseType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReleaseDataStart::clone() {
    return new ReleaseDataStart(*this);
}

inline bool ReleaseDataStart::operator > (const ReleaseDataStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReleaseDataStart::clear() {
    clearReleaseType();
}

inline void ReleaseDataStart::clearReleaseType() {
    if (hasReleaseType()) {
         clear_has_ReleaseType();
        _ReleaseType = ::sds_tts_fi_types::T_e8_ReleaseTypeTTS__VoiceChange;
     }
}

inline bool ReleaseDataStart::hasReleaseType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sds_tts_fi_types::T_e8_ReleaseTypeTTS ReleaseDataStart::getReleaseType () const {
    return _ReleaseType;
}

inline void ReleaseDataStart::setReleaseType (::sds_tts_fi_types::T_e8_ReleaseTypeTTS ReleaseType_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_ReleaseTypeTTS_IsValid(ReleaseType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ReleaseType_, "T_e8_ReleaseTypeTTS", "ReleaseType", "ReleaseDataStart");
    }
    #endif
    set_has_ReleaseType();
    this->_ReleaseType = ReleaseType_;
}

inline void ReleaseDataStart::set_has_ReleaseType () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReleaseDataStart::clear_has_ReleaseType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReleaseDataError::ReleaseDataError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::ReleaseDataErrorCode__Unspecified;
}

inline  ReleaseDataError::ReleaseDataError (const ReleaseDataError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::ReleaseDataErrorCode__Unspecified;
    *this = rhs;
}

inline  ReleaseDataError::~ReleaseDataError() {
    deleteData ();
}

inline ReleaseDataError& ReleaseDataError::operator = (const ReleaseDataError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool ReleaseDataError::operator == (const ReleaseDataError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool ReleaseDataError::operator != (const ReleaseDataError& rhs) const {
    return ! (*this == rhs);
}

inline bool ReleaseDataError::operator < (const ReleaseDataError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool ReleaseDataError::operator > (const ReleaseDataError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline ReleaseDataError::ReleaseDataErrorField ReleaseDataError::getField () const {
    return __field;
}

inline void ReleaseDataError::setField(ReleaseDataError::ReleaseDataErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::ReleaseDataErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* ReleaseDataError::clone() {
    return new ReleaseDataError(*this);
}

inline bool ReleaseDataError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline ReleaseDataErrorCode ReleaseDataError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "ReleaseDataError", getField());
    }
    return (ReleaseDataErrorCode) _data.ccaErrorCode_;
}

inline void ReleaseDataError::setCcaErrorCode (ReleaseDataErrorCode value) {
    #ifndef NDEBUG
    if (!(ReleaseDataErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "ReleaseDataErrorCode", "ccaErrorCode", "ReleaseDataError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool ReleaseDataError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode ReleaseDataError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "ReleaseDataError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void ReleaseDataError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "ReleaseDataError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void ReleaseDataError::cloneData (const ReleaseDataError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void ReleaseDataError::deleteData () {
}

inline  SetVoiceStart::SetVoiceStart ()  :
    _TTSVoice ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetVoiceStart::SetVoiceStart (const SetVoiceStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TTSVoice ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetVoiceStart::SetVoiceStart (const ::sds_speechdp_fi_types::T_VoiceType& TTSVoice_)  :
    _TTSVoice (TTSVoice_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetVoiceStart::~SetVoiceStart() {
}

inline SetVoiceStart& SetVoiceStart::operator = (const SetVoiceStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTTSVoice()) {
            setTTSVoice(rhs.getTTSVoice());
        } else {
            clearTTSVoice();
        }
    }
    return *this;
}

inline bool SetVoiceStart::operator == (const SetVoiceStart& rhs) const {
    return (((!hasTTSVoice() && !rhs.hasTTSVoice()) || getTTSVoice() == rhs.getTTSVoice()));
}

inline bool SetVoiceStart::operator != (const SetVoiceStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetVoiceStart::operator < (const SetVoiceStart& rhs) const {
    if (hasTTSVoice() || rhs.hasTTSVoice()) {
        if (getTTSVoice() < rhs.getTTSVoice()) return true;
        if (getTTSVoice() > rhs.getTTSVoice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetVoiceStart::clone() {
    return new SetVoiceStart(*this);
}

inline bool SetVoiceStart::operator > (const SetVoiceStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetVoiceStart::clear() {
    clearTTSVoice();
}

inline void SetVoiceStart::clearTTSVoice() {
    if (hasTTSVoice()) {
         clear_has_TTSVoice();
        _TTSVoice.clear();
     }
}

inline bool SetVoiceStart::hasTTSVoice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_speechdp_fi_types::T_VoiceType& SetVoiceStart::getTTSVoice () const {
    return _TTSVoice;
}

inline ::sds_speechdp_fi_types::T_VoiceType& SetVoiceStart::getTTSVoiceMutable () {
    set_has_TTSVoice();
    return _TTSVoice;
}

inline void SetVoiceStart::setTTSVoice (const ::sds_speechdp_fi_types::T_VoiceType& TTSVoice_) {
    set_has_TTSVoice();
    this->_TTSVoice = TTSVoice_;
}

inline void SetVoiceStart::set_has_TTSVoice () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetVoiceStart::clear_has_TTSVoice () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetVoiceError::SetVoiceError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::SetVoiceErrorCode__Unspecified;
}

inline  SetVoiceError::SetVoiceError (const SetVoiceError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::SetVoiceErrorCode__Unspecified;
    *this = rhs;
}

inline  SetVoiceError::~SetVoiceError() {
    deleteData ();
}

inline SetVoiceError& SetVoiceError::operator = (const SetVoiceError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SetVoiceError::operator == (const SetVoiceError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SetVoiceError::operator != (const SetVoiceError& rhs) const {
    return ! (*this == rhs);
}

inline bool SetVoiceError::operator < (const SetVoiceError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SetVoiceError::operator > (const SetVoiceError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SetVoiceError::SetVoiceErrorField SetVoiceError::getField () const {
    return __field;
}

inline void SetVoiceError::setField(SetVoiceError::SetVoiceErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::SetVoiceErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SetVoiceError::clone() {
    return new SetVoiceError(*this);
}

inline bool SetVoiceError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline SetVoiceErrorCode SetVoiceError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetVoiceError", getField());
    }
    return (SetVoiceErrorCode) _data.ccaErrorCode_;
}

inline void SetVoiceError::setCcaErrorCode (SetVoiceErrorCode value) {
    #ifndef NDEBUG
    if (!(SetVoiceErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SetVoiceErrorCode", "ccaErrorCode", "SetVoiceError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool SetVoiceError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SetVoiceError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SetVoiceError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SetVoiceError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SetVoiceError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SetVoiceError::cloneData (const SetVoiceError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SetVoiceError::deleteData () {
}

inline  AbortPromptStart::AbortPromptStart ()  :
    _AbortPromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AbortPromptStart::AbortPromptStart (const AbortPromptStart &rhs)  :
    ::asf::core::Payload(rhs),
    _AbortPromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AbortPromptStart::AbortPromptStart (::sds_tts_fi_types::T_e8_PromptAbortOption AbortPromptOption_)  :
    _AbortPromptOption (AbortPromptOption_)
{
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_PromptAbortOption_IsValid(AbortPromptOption_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AbortPromptOption_, "T_e8_PromptAbortOption", "AbortPromptOption", "AbortPromptStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AbortPromptStart::~AbortPromptStart() {
}

inline AbortPromptStart& AbortPromptStart::operator = (const AbortPromptStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAbortPromptOption()) {
            setAbortPromptOption(rhs.getAbortPromptOption());
        } else {
            clearAbortPromptOption();
        }
    }
    return *this;
}

inline bool AbortPromptStart::operator == (const AbortPromptStart& rhs) const {
    return (((!hasAbortPromptOption() && !rhs.hasAbortPromptOption()) || getAbortPromptOption() == rhs.getAbortPromptOption()));
}

inline bool AbortPromptStart::operator != (const AbortPromptStart& rhs) const {
    return ! (*this == rhs);
}

inline bool AbortPromptStart::operator < (const AbortPromptStart& rhs) const {
    if (hasAbortPromptOption() || rhs.hasAbortPromptOption()) {
        if ((uint32)getAbortPromptOption() < (uint32)rhs.getAbortPromptOption()) return true;
        if ((uint32)getAbortPromptOption() > (uint32)rhs.getAbortPromptOption()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AbortPromptStart::clone() {
    return new AbortPromptStart(*this);
}

inline bool AbortPromptStart::operator > (const AbortPromptStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AbortPromptStart::clear() {
    clearAbortPromptOption();
}

inline void AbortPromptStart::clearAbortPromptOption() {
    if (hasAbortPromptOption()) {
         clear_has_AbortPromptOption();
        _AbortPromptOption = ::sds_tts_fi_types::T_e8_PromptAbortOption__Unknown;
     }
}

inline bool AbortPromptStart::hasAbortPromptOption () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sds_tts_fi_types::T_e8_PromptAbortOption AbortPromptStart::getAbortPromptOption () const {
    return _AbortPromptOption;
}

inline void AbortPromptStart::setAbortPromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption AbortPromptOption_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_PromptAbortOption_IsValid(AbortPromptOption_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AbortPromptOption_, "T_e8_PromptAbortOption", "AbortPromptOption", "AbortPromptStart");
    }
    #endif
    set_has_AbortPromptOption();
    this->_AbortPromptOption = AbortPromptOption_;
}

inline void AbortPromptStart::set_has_AbortPromptOption () {
    _has_bits_[0] |= 1u << 0;
}

inline void AbortPromptStart::clear_has_AbortPromptOption () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AbortPromptError::AbortPromptError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::AbortPromptErrorCode__Unspecified;
}

inline  AbortPromptError::AbortPromptError (const AbortPromptError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::AbortPromptErrorCode__Unspecified;
    *this = rhs;
}

inline  AbortPromptError::~AbortPromptError() {
    deleteData ();
}

inline AbortPromptError& AbortPromptError::operator = (const AbortPromptError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool AbortPromptError::operator == (const AbortPromptError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool AbortPromptError::operator != (const AbortPromptError& rhs) const {
    return ! (*this == rhs);
}

inline bool AbortPromptError::operator < (const AbortPromptError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool AbortPromptError::operator > (const AbortPromptError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline AbortPromptError::AbortPromptErrorField AbortPromptError::getField () const {
    return __field;
}

inline void AbortPromptError::setField(AbortPromptError::AbortPromptErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::AbortPromptErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* AbortPromptError::clone() {
    return new AbortPromptError(*this);
}

inline bool AbortPromptError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline AbortPromptErrorCode AbortPromptError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AbortPromptError", getField());
    }
    return (AbortPromptErrorCode) _data.ccaErrorCode_;
}

inline void AbortPromptError::setCcaErrorCode (AbortPromptErrorCode value) {
    #ifndef NDEBUG
    if (!(AbortPromptErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "AbortPromptErrorCode", "ccaErrorCode", "AbortPromptError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool AbortPromptError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode AbortPromptError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "AbortPromptError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void AbortPromptError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "AbortPromptError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void AbortPromptError::cloneData (const AbortPromptError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void AbortPromptError::deleteData () {
}

inline  PausePromptStart::PausePromptStart ()  :
    _PausePromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PausePromptStart::PausePromptStart (const PausePromptStart &rhs)  :
    ::asf::core::Payload(rhs),
    _PausePromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PausePromptStart::PausePromptStart (::sds_tts_fi_types::T_e8_PromptAbortOption PausePromptOption_)  :
    _PausePromptOption (PausePromptOption_)
{
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_PromptAbortOption_IsValid(PausePromptOption_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PausePromptOption_, "T_e8_PromptAbortOption", "PausePromptOption", "PausePromptStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PausePromptStart::~PausePromptStart() {
}

inline PausePromptStart& PausePromptStart::operator = (const PausePromptStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPausePromptOption()) {
            setPausePromptOption(rhs.getPausePromptOption());
        } else {
            clearPausePromptOption();
        }
    }
    return *this;
}

inline bool PausePromptStart::operator == (const PausePromptStart& rhs) const {
    return (((!hasPausePromptOption() && !rhs.hasPausePromptOption()) || getPausePromptOption() == rhs.getPausePromptOption()));
}

inline bool PausePromptStart::operator != (const PausePromptStart& rhs) const {
    return ! (*this == rhs);
}

inline bool PausePromptStart::operator < (const PausePromptStart& rhs) const {
    if (hasPausePromptOption() || rhs.hasPausePromptOption()) {
        if ((uint32)getPausePromptOption() < (uint32)rhs.getPausePromptOption()) return true;
        if ((uint32)getPausePromptOption() > (uint32)rhs.getPausePromptOption()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PausePromptStart::clone() {
    return new PausePromptStart(*this);
}

inline bool PausePromptStart::operator > (const PausePromptStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PausePromptStart::clear() {
    clearPausePromptOption();
}

inline void PausePromptStart::clearPausePromptOption() {
    if (hasPausePromptOption()) {
         clear_has_PausePromptOption();
        _PausePromptOption = ::sds_tts_fi_types::T_e8_PromptAbortOption__Unknown;
     }
}

inline bool PausePromptStart::hasPausePromptOption () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sds_tts_fi_types::T_e8_PromptAbortOption PausePromptStart::getPausePromptOption () const {
    return _PausePromptOption;
}

inline void PausePromptStart::setPausePromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption PausePromptOption_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_PromptAbortOption_IsValid(PausePromptOption_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PausePromptOption_, "T_e8_PromptAbortOption", "PausePromptOption", "PausePromptStart");
    }
    #endif
    set_has_PausePromptOption();
    this->_PausePromptOption = PausePromptOption_;
}

inline void PausePromptStart::set_has_PausePromptOption () {
    _has_bits_[0] |= 1u << 0;
}

inline void PausePromptStart::clear_has_PausePromptOption () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PausePromptError::PausePromptError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::PausePromptErrorCode__Unspecified;
}

inline  PausePromptError::PausePromptError (const PausePromptError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::PausePromptErrorCode__Unspecified;
    *this = rhs;
}

inline  PausePromptError::~PausePromptError() {
    deleteData ();
}

inline PausePromptError& PausePromptError::operator = (const PausePromptError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool PausePromptError::operator == (const PausePromptError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool PausePromptError::operator != (const PausePromptError& rhs) const {
    return ! (*this == rhs);
}

inline bool PausePromptError::operator < (const PausePromptError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool PausePromptError::operator > (const PausePromptError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline PausePromptError::PausePromptErrorField PausePromptError::getField () const {
    return __field;
}

inline void PausePromptError::setField(PausePromptError::PausePromptErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::PausePromptErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* PausePromptError::clone() {
    return new PausePromptError(*this);
}

inline bool PausePromptError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline PausePromptErrorCode PausePromptError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "PausePromptError", getField());
    }
    return (PausePromptErrorCode) _data.ccaErrorCode_;
}

inline void PausePromptError::setCcaErrorCode (PausePromptErrorCode value) {
    #ifndef NDEBUG
    if (!(PausePromptErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "PausePromptErrorCode", "ccaErrorCode", "PausePromptError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool PausePromptError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode PausePromptError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "PausePromptError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void PausePromptError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "PausePromptError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void PausePromptError::cloneData (const PausePromptError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void PausePromptError::deleteData () {
}

inline  ContinuePromptStart::ContinuePromptStart ()  :
    _Dummy (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ContinuePromptStart::ContinuePromptStart (const ContinuePromptStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Dummy (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ContinuePromptStart::ContinuePromptStart (uint8 Dummy_)  :
    _Dummy (Dummy_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ContinuePromptStart::~ContinuePromptStart() {
}

inline ContinuePromptStart& ContinuePromptStart::operator = (const ContinuePromptStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDummy()) {
            setDummy(rhs.getDummy());
        } else {
            clearDummy();
        }
    }
    return *this;
}

inline bool ContinuePromptStart::operator == (const ContinuePromptStart& rhs) const {
    return (((!hasDummy() && !rhs.hasDummy()) || getDummy() == rhs.getDummy()));
}

inline bool ContinuePromptStart::operator != (const ContinuePromptStart& rhs) const {
    return ! (*this == rhs);
}

inline bool ContinuePromptStart::operator < (const ContinuePromptStart& rhs) const {
    if (hasDummy() || rhs.hasDummy()) {
        if (getDummy() < rhs.getDummy()) return true;
        if (getDummy() > rhs.getDummy()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ContinuePromptStart::clone() {
    return new ContinuePromptStart(*this);
}

inline bool ContinuePromptStart::operator > (const ContinuePromptStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ContinuePromptStart::clear() {
    clearDummy();
}

inline void ContinuePromptStart::clearDummy() {
    if (hasDummy()) {
         clear_has_Dummy();
        _Dummy = 0u;
     }
}

inline bool ContinuePromptStart::hasDummy () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ContinuePromptStart::getDummy () const {
    return _Dummy;
}

inline void ContinuePromptStart::setDummy (uint8 Dummy_) {
    set_has_Dummy();
    this->_Dummy = Dummy_;
}

inline void ContinuePromptStart::set_has_Dummy () {
    _has_bits_[0] |= 1u << 0;
}

inline void ContinuePromptStart::clear_has_Dummy () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ContinuePromptError::ContinuePromptError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::ContinuePromptErrorCode__Unspecified;
}

inline  ContinuePromptError::ContinuePromptError (const ContinuePromptError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::ContinuePromptErrorCode__Unspecified;
    *this = rhs;
}

inline  ContinuePromptError::~ContinuePromptError() {
    deleteData ();
}

inline ContinuePromptError& ContinuePromptError::operator = (const ContinuePromptError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool ContinuePromptError::operator == (const ContinuePromptError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool ContinuePromptError::operator != (const ContinuePromptError& rhs) const {
    return ! (*this == rhs);
}

inline bool ContinuePromptError::operator < (const ContinuePromptError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool ContinuePromptError::operator > (const ContinuePromptError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline ContinuePromptError::ContinuePromptErrorField ContinuePromptError::getField () const {
    return __field;
}

inline void ContinuePromptError::setField(ContinuePromptError::ContinuePromptErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::ContinuePromptErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* ContinuePromptError::clone() {
    return new ContinuePromptError(*this);
}

inline bool ContinuePromptError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline ContinuePromptErrorCode ContinuePromptError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "ContinuePromptError", getField());
    }
    return (ContinuePromptErrorCode) _data.ccaErrorCode_;
}

inline void ContinuePromptError::setCcaErrorCode (ContinuePromptErrorCode value) {
    #ifndef NDEBUG
    if (!(ContinuePromptErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "ContinuePromptErrorCode", "ccaErrorCode", "ContinuePromptError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool ContinuePromptError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode ContinuePromptError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "ContinuePromptError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void ContinuePromptError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "ContinuePromptError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void ContinuePromptError::cloneData (const ContinuePromptError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void ContinuePromptError::deleteData () {
}

inline  AbortPromptWithExtensionStart::AbortPromptWithExtensionStart ()  :
    _AbortPromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AbortPromptWithExtensionStart::AbortPromptWithExtensionStart (const AbortPromptWithExtensionStart &rhs)  :
    ::asf::core::Payload(rhs),
    _AbortPromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AbortPromptWithExtensionStart::AbortPromptWithExtensionStart (::sds_tts_fi_types::T_e8_PromptAbortOption AbortPromptOption_)  :
    _AbortPromptOption (AbortPromptOption_)
{
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_PromptAbortOption_IsValid(AbortPromptOption_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AbortPromptOption_, "T_e8_PromptAbortOption", "AbortPromptOption", "AbortPromptWithExtensionStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AbortPromptWithExtensionStart::~AbortPromptWithExtensionStart() {
}

inline AbortPromptWithExtensionStart& AbortPromptWithExtensionStart::operator = (const AbortPromptWithExtensionStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAbortPromptOption()) {
            setAbortPromptOption(rhs.getAbortPromptOption());
        } else {
            clearAbortPromptOption();
        }
    }
    return *this;
}

inline bool AbortPromptWithExtensionStart::operator == (const AbortPromptWithExtensionStart& rhs) const {
    return (((!hasAbortPromptOption() && !rhs.hasAbortPromptOption()) || getAbortPromptOption() == rhs.getAbortPromptOption()));
}

inline bool AbortPromptWithExtensionStart::operator != (const AbortPromptWithExtensionStart& rhs) const {
    return ! (*this == rhs);
}

inline bool AbortPromptWithExtensionStart::operator < (const AbortPromptWithExtensionStart& rhs) const {
    if (hasAbortPromptOption() || rhs.hasAbortPromptOption()) {
        if ((uint32)getAbortPromptOption() < (uint32)rhs.getAbortPromptOption()) return true;
        if ((uint32)getAbortPromptOption() > (uint32)rhs.getAbortPromptOption()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AbortPromptWithExtensionStart::clone() {
    return new AbortPromptWithExtensionStart(*this);
}

inline bool AbortPromptWithExtensionStart::operator > (const AbortPromptWithExtensionStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AbortPromptWithExtensionStart::clear() {
    clearAbortPromptOption();
}

inline void AbortPromptWithExtensionStart::clearAbortPromptOption() {
    if (hasAbortPromptOption()) {
         clear_has_AbortPromptOption();
        _AbortPromptOption = ::sds_tts_fi_types::T_e8_PromptAbortOption__Unknown;
     }
}

inline bool AbortPromptWithExtensionStart::hasAbortPromptOption () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sds_tts_fi_types::T_e8_PromptAbortOption AbortPromptWithExtensionStart::getAbortPromptOption () const {
    return _AbortPromptOption;
}

inline void AbortPromptWithExtensionStart::setAbortPromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption AbortPromptOption_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_PromptAbortOption_IsValid(AbortPromptOption_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AbortPromptOption_, "T_e8_PromptAbortOption", "AbortPromptOption", "AbortPromptWithExtensionStart");
    }
    #endif
    set_has_AbortPromptOption();
    this->_AbortPromptOption = AbortPromptOption_;
}

inline void AbortPromptWithExtensionStart::set_has_AbortPromptOption () {
    _has_bits_[0] |= 1u << 0;
}

inline void AbortPromptWithExtensionStart::clear_has_AbortPromptOption () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AbortPromptWithExtensionError::AbortPromptWithExtensionError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::AbortPromptWithExtensionErrorCode__Unspecified;
}

inline  AbortPromptWithExtensionError::AbortPromptWithExtensionError (const AbortPromptWithExtensionError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::AbortPromptWithExtensionErrorCode__Unspecified;
    *this = rhs;
}

inline  AbortPromptWithExtensionError::~AbortPromptWithExtensionError() {
    deleteData ();
}

inline AbortPromptWithExtensionError& AbortPromptWithExtensionError::operator = (const AbortPromptWithExtensionError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool AbortPromptWithExtensionError::operator == (const AbortPromptWithExtensionError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool AbortPromptWithExtensionError::operator != (const AbortPromptWithExtensionError& rhs) const {
    return ! (*this == rhs);
}

inline bool AbortPromptWithExtensionError::operator < (const AbortPromptWithExtensionError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool AbortPromptWithExtensionError::operator > (const AbortPromptWithExtensionError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline AbortPromptWithExtensionError::AbortPromptWithExtensionErrorField AbortPromptWithExtensionError::getField () const {
    return __field;
}

inline void AbortPromptWithExtensionError::setField(AbortPromptWithExtensionError::AbortPromptWithExtensionErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::AbortPromptWithExtensionErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* AbortPromptWithExtensionError::clone() {
    return new AbortPromptWithExtensionError(*this);
}

inline bool AbortPromptWithExtensionError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline AbortPromptWithExtensionErrorCode AbortPromptWithExtensionError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AbortPromptWithExtensionError", getField());
    }
    return (AbortPromptWithExtensionErrorCode) _data.ccaErrorCode_;
}

inline void AbortPromptWithExtensionError::setCcaErrorCode (AbortPromptWithExtensionErrorCode value) {
    #ifndef NDEBUG
    if (!(AbortPromptWithExtensionErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "AbortPromptWithExtensionErrorCode", "ccaErrorCode", "AbortPromptWithExtensionError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool AbortPromptWithExtensionError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode AbortPromptWithExtensionError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "AbortPromptWithExtensionError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void AbortPromptWithExtensionError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "AbortPromptWithExtensionError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void AbortPromptWithExtensionError::cloneData (const AbortPromptWithExtensionError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void AbortPromptWithExtensionError::deleteData () {
}

inline  PausePromptWithExtensionStart::PausePromptWithExtensionStart ()  :
    _PausePromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PausePromptWithExtensionStart::PausePromptWithExtensionStart (const PausePromptWithExtensionStart &rhs)  :
    ::asf::core::Payload(rhs),
    _PausePromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PausePromptWithExtensionStart::PausePromptWithExtensionStart (::sds_tts_fi_types::T_e8_PromptAbortOption PausePromptOption_)  :
    _PausePromptOption (PausePromptOption_)
{
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_PromptAbortOption_IsValid(PausePromptOption_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PausePromptOption_, "T_e8_PromptAbortOption", "PausePromptOption", "PausePromptWithExtensionStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PausePromptWithExtensionStart::~PausePromptWithExtensionStart() {
}

inline PausePromptWithExtensionStart& PausePromptWithExtensionStart::operator = (const PausePromptWithExtensionStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPausePromptOption()) {
            setPausePromptOption(rhs.getPausePromptOption());
        } else {
            clearPausePromptOption();
        }
    }
    return *this;
}

inline bool PausePromptWithExtensionStart::operator == (const PausePromptWithExtensionStart& rhs) const {
    return (((!hasPausePromptOption() && !rhs.hasPausePromptOption()) || getPausePromptOption() == rhs.getPausePromptOption()));
}

inline bool PausePromptWithExtensionStart::operator != (const PausePromptWithExtensionStart& rhs) const {
    return ! (*this == rhs);
}

inline bool PausePromptWithExtensionStart::operator < (const PausePromptWithExtensionStart& rhs) const {
    if (hasPausePromptOption() || rhs.hasPausePromptOption()) {
        if ((uint32)getPausePromptOption() < (uint32)rhs.getPausePromptOption()) return true;
        if ((uint32)getPausePromptOption() > (uint32)rhs.getPausePromptOption()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PausePromptWithExtensionStart::clone() {
    return new PausePromptWithExtensionStart(*this);
}

inline bool PausePromptWithExtensionStart::operator > (const PausePromptWithExtensionStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PausePromptWithExtensionStart::clear() {
    clearPausePromptOption();
}

inline void PausePromptWithExtensionStart::clearPausePromptOption() {
    if (hasPausePromptOption()) {
         clear_has_PausePromptOption();
        _PausePromptOption = ::sds_tts_fi_types::T_e8_PromptAbortOption__Unknown;
     }
}

inline bool PausePromptWithExtensionStart::hasPausePromptOption () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sds_tts_fi_types::T_e8_PromptAbortOption PausePromptWithExtensionStart::getPausePromptOption () const {
    return _PausePromptOption;
}

inline void PausePromptWithExtensionStart::setPausePromptOption (::sds_tts_fi_types::T_e8_PromptAbortOption PausePromptOption_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_PromptAbortOption_IsValid(PausePromptOption_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PausePromptOption_, "T_e8_PromptAbortOption", "PausePromptOption", "PausePromptWithExtensionStart");
    }
    #endif
    set_has_PausePromptOption();
    this->_PausePromptOption = PausePromptOption_;
}

inline void PausePromptWithExtensionStart::set_has_PausePromptOption () {
    _has_bits_[0] |= 1u << 0;
}

inline void PausePromptWithExtensionStart::clear_has_PausePromptOption () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PausePromptWithExtensionError::PausePromptWithExtensionError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::PausePromptWithExtensionErrorCode__Unspecified;
}

inline  PausePromptWithExtensionError::PausePromptWithExtensionError (const PausePromptWithExtensionError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::PausePromptWithExtensionErrorCode__Unspecified;
    *this = rhs;
}

inline  PausePromptWithExtensionError::~PausePromptWithExtensionError() {
    deleteData ();
}

inline PausePromptWithExtensionError& PausePromptWithExtensionError::operator = (const PausePromptWithExtensionError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool PausePromptWithExtensionError::operator == (const PausePromptWithExtensionError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool PausePromptWithExtensionError::operator != (const PausePromptWithExtensionError& rhs) const {
    return ! (*this == rhs);
}

inline bool PausePromptWithExtensionError::operator < (const PausePromptWithExtensionError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool PausePromptWithExtensionError::operator > (const PausePromptWithExtensionError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline PausePromptWithExtensionError::PausePromptWithExtensionErrorField PausePromptWithExtensionError::getField () const {
    return __field;
}

inline void PausePromptWithExtensionError::setField(PausePromptWithExtensionError::PausePromptWithExtensionErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::PausePromptWithExtensionErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* PausePromptWithExtensionError::clone() {
    return new PausePromptWithExtensionError(*this);
}

inline bool PausePromptWithExtensionError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline PausePromptWithExtensionErrorCode PausePromptWithExtensionError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "PausePromptWithExtensionError", getField());
    }
    return (PausePromptWithExtensionErrorCode) _data.ccaErrorCode_;
}

inline void PausePromptWithExtensionError::setCcaErrorCode (PausePromptWithExtensionErrorCode value) {
    #ifndef NDEBUG
    if (!(PausePromptWithExtensionErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "PausePromptWithExtensionErrorCode", "ccaErrorCode", "PausePromptWithExtensionError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool PausePromptWithExtensionError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode PausePromptWithExtensionError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "PausePromptWithExtensionError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void PausePromptWithExtensionError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "PausePromptWithExtensionError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void PausePromptWithExtensionError::cloneData (const PausePromptWithExtensionError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void PausePromptWithExtensionError::deleteData () {
}

inline  ContinuePromptWithExtensionStart::ContinuePromptWithExtensionStart ()  :
    _Dummy (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ContinuePromptWithExtensionStart::ContinuePromptWithExtensionStart (const ContinuePromptWithExtensionStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Dummy (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ContinuePromptWithExtensionStart::ContinuePromptWithExtensionStart (uint8 Dummy_)  :
    _Dummy (Dummy_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ContinuePromptWithExtensionStart::~ContinuePromptWithExtensionStart() {
}

inline ContinuePromptWithExtensionStart& ContinuePromptWithExtensionStart::operator = (const ContinuePromptWithExtensionStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDummy()) {
            setDummy(rhs.getDummy());
        } else {
            clearDummy();
        }
    }
    return *this;
}

inline bool ContinuePromptWithExtensionStart::operator == (const ContinuePromptWithExtensionStart& rhs) const {
    return (((!hasDummy() && !rhs.hasDummy()) || getDummy() == rhs.getDummy()));
}

inline bool ContinuePromptWithExtensionStart::operator != (const ContinuePromptWithExtensionStart& rhs) const {
    return ! (*this == rhs);
}

inline bool ContinuePromptWithExtensionStart::operator < (const ContinuePromptWithExtensionStart& rhs) const {
    if (hasDummy() || rhs.hasDummy()) {
        if (getDummy() < rhs.getDummy()) return true;
        if (getDummy() > rhs.getDummy()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ContinuePromptWithExtensionStart::clone() {
    return new ContinuePromptWithExtensionStart(*this);
}

inline bool ContinuePromptWithExtensionStart::operator > (const ContinuePromptWithExtensionStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ContinuePromptWithExtensionStart::clear() {
    clearDummy();
}

inline void ContinuePromptWithExtensionStart::clearDummy() {
    if (hasDummy()) {
         clear_has_Dummy();
        _Dummy = 0u;
     }
}

inline bool ContinuePromptWithExtensionStart::hasDummy () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ContinuePromptWithExtensionStart::getDummy () const {
    return _Dummy;
}

inline void ContinuePromptWithExtensionStart::setDummy (uint8 Dummy_) {
    set_has_Dummy();
    this->_Dummy = Dummy_;
}

inline void ContinuePromptWithExtensionStart::set_has_Dummy () {
    _has_bits_[0] |= 1u << 0;
}

inline void ContinuePromptWithExtensionStart::clear_has_Dummy () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ContinuePromptWithExtensionError::ContinuePromptWithExtensionError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::ContinuePromptWithExtensionErrorCode__Unspecified;
}

inline  ContinuePromptWithExtensionError::ContinuePromptWithExtensionError (const ContinuePromptWithExtensionError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::ContinuePromptWithExtensionErrorCode__Unspecified;
    *this = rhs;
}

inline  ContinuePromptWithExtensionError::~ContinuePromptWithExtensionError() {
    deleteData ();
}

inline ContinuePromptWithExtensionError& ContinuePromptWithExtensionError::operator = (const ContinuePromptWithExtensionError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool ContinuePromptWithExtensionError::operator == (const ContinuePromptWithExtensionError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool ContinuePromptWithExtensionError::operator != (const ContinuePromptWithExtensionError& rhs) const {
    return ! (*this == rhs);
}

inline bool ContinuePromptWithExtensionError::operator < (const ContinuePromptWithExtensionError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool ContinuePromptWithExtensionError::operator > (const ContinuePromptWithExtensionError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline ContinuePromptWithExtensionError::ContinuePromptWithExtensionErrorField ContinuePromptWithExtensionError::getField () const {
    return __field;
}

inline void ContinuePromptWithExtensionError::setField(ContinuePromptWithExtensionError::ContinuePromptWithExtensionErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::ContinuePromptWithExtensionErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* ContinuePromptWithExtensionError::clone() {
    return new ContinuePromptWithExtensionError(*this);
}

inline bool ContinuePromptWithExtensionError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline ContinuePromptWithExtensionErrorCode ContinuePromptWithExtensionError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "ContinuePromptWithExtensionError", getField());
    }
    return (ContinuePromptWithExtensionErrorCode) _data.ccaErrorCode_;
}

inline void ContinuePromptWithExtensionError::setCcaErrorCode (ContinuePromptWithExtensionErrorCode value) {
    #ifndef NDEBUG
    if (!(ContinuePromptWithExtensionErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "ContinuePromptWithExtensionErrorCode", "ccaErrorCode", "ContinuePromptWithExtensionError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool ContinuePromptWithExtensionError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode ContinuePromptWithExtensionError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "ContinuePromptWithExtensionError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void ContinuePromptWithExtensionError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "ContinuePromptWithExtensionError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void ContinuePromptWithExtensionError::cloneData (const ContinuePromptWithExtensionError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void ContinuePromptWithExtensionError::deleteData () {
}

inline  RequestPhonemeStart::RequestPhonemeStart ()  :
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_TextStyleOption__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestPhonemeStart::RequestPhonemeStart (const RequestPhonemeStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_TextStyleOption__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestPhonemeStart::RequestPhonemeStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_)  :
    _TextAndTags (TextAndTags_),
    _TextStyle (TextStyle_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TextStyleOption_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_TextStyleOption", "TextStyle", "RequestPhonemeStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestPhonemeStart::~RequestPhonemeStart() {
}

inline RequestPhonemeStart& RequestPhonemeStart::operator = (const RequestPhonemeStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTextAndTags()) {
            setTextAndTags(rhs.getTextAndTags());
        } else {
            clearTextAndTags();
        }
        if (rhs.hasTextStyle()) {
            setTextStyle(rhs.getTextStyle());
        } else {
            clearTextStyle();
        }
    }
    return *this;
}

inline bool RequestPhonemeStart::operator == (const RequestPhonemeStart& rhs) const {
    return (((!hasTextAndTags() && !rhs.hasTextAndTags()) || getTextAndTags() == rhs.getTextAndTags()) &&
        ((!hasTextStyle() && !rhs.hasTextStyle()) || getTextStyle() == rhs.getTextStyle()));
}

inline bool RequestPhonemeStart::operator != (const RequestPhonemeStart& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestPhonemeStart::operator < (const RequestPhonemeStart& rhs) const {
    if (hasTextAndTags() || rhs.hasTextAndTags()) {
        if (getTextAndTags() < rhs.getTextAndTags()) return true;
        if (getTextAndTags() > rhs.getTextAndTags()) return false;
    }
    if (hasTextStyle() || rhs.hasTextStyle()) {
        if ((uint32)getTextStyle() < (uint32)rhs.getTextStyle()) return true;
        if ((uint32)getTextStyle() > (uint32)rhs.getTextStyle()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestPhonemeStart::clone() {
    return new RequestPhonemeStart(*this);
}

inline bool RequestPhonemeStart::operator > (const RequestPhonemeStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestPhonemeStart::clear() {
    clearTextAndTags();
    clearTextStyle();
}

inline void RequestPhonemeStart::clearTextAndTags() {
    if (hasTextAndTags()) {
         clear_has_TextAndTags();
        _TextAndTags.clear();
     }
}

inline bool RequestPhonemeStart::hasTextAndTags () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RequestPhonemeStart::getTextAndTags () const {
    return _TextAndTags;
}

inline ::std::string& RequestPhonemeStart::getTextAndTagsMutable () {
    set_has_TextAndTags();
    return _TextAndTags;
}

inline void RequestPhonemeStart::setTextAndTags (const ::std::string& TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags = TextAndTags_;
}

inline void RequestPhonemeStart::setTextAndTags (const char* TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(TextAndTags_);
}

inline void RequestPhonemeStart::setTextAndTags (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(value, size);
}

inline void RequestPhonemeStart::clearTextStyle() {
    if (hasTextStyle()) {
         clear_has_TextStyle();
        _TextStyle = ::sds_tts_fi_types::T_e8_TextStyleOption__Unknown;
     }
}

inline bool RequestPhonemeStart::hasTextStyle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sds_tts_fi_types::T_e8_TextStyleOption RequestPhonemeStart::getTextStyle () const {
    return _TextStyle;
}

inline void RequestPhonemeStart::setTextStyle (::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TextStyleOption_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_TextStyleOption", "TextStyle", "RequestPhonemeStart");
    }
    #endif
    set_has_TextStyle();
    this->_TextStyle = TextStyle_;
}

inline void RequestPhonemeStart::set_has_TextAndTags () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestPhonemeStart::clear_has_TextAndTags () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RequestPhonemeStart::set_has_TextStyle () {
    _has_bits_[0] |= 1u << 1;
}

inline void RequestPhonemeStart::clear_has_TextStyle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RequestPhonemeResult::RequestPhonemeResult ()  :
    _PhonemeList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestPhonemeResult::RequestPhonemeResult (const RequestPhonemeResult &rhs)  :
    ::asf::core::Payload(rhs),
    _PhonemeList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestPhonemeResult::RequestPhonemeResult (const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& PhonemeList_)  :
    _PhonemeList (PhonemeList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestPhonemeResult::~RequestPhonemeResult() {
}

inline RequestPhonemeResult& RequestPhonemeResult::operator = (const RequestPhonemeResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhonemeList()) {
            setPhonemeList(rhs.getPhonemeList());
        } else {
            clearPhonemeList();
        }
    }
    return *this;
}

inline bool RequestPhonemeResult::operator == (const RequestPhonemeResult& rhs) const {
    return (((!hasPhonemeList() && !rhs.hasPhonemeList()) || getPhonemeList() == rhs.getPhonemeList()));
}

inline bool RequestPhonemeResult::operator != (const RequestPhonemeResult& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestPhonemeResult::operator < (const RequestPhonemeResult& rhs) const {
    if (hasPhonemeList() || rhs.hasPhonemeList()) {
        if (getPhonemeList() < rhs.getPhonemeList()) return true;
        if (getPhonemeList() > rhs.getPhonemeList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestPhonemeResult::clone() {
    return new RequestPhonemeResult(*this);
}

inline bool RequestPhonemeResult::operator > (const RequestPhonemeResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestPhonemeResult::clear() {
    clearPhonemeList();
}

inline void RequestPhonemeResult::clearPhonemeList() {
    if (hasPhonemeList()) {
         clear_has_PhonemeList();
        _PhonemeList.clear();
     }
}

inline bool RequestPhonemeResult::hasPhonemeList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& RequestPhonemeResult::getPhonemeList () const {
    return _PhonemeList;
}

inline ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& RequestPhonemeResult::getPhonemeListMutable () {
    set_has_PhonemeList();
    return _PhonemeList;
}

inline void RequestPhonemeResult::setPhonemeList (const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& PhonemeList_) {
    set_has_PhonemeList();
    this->_PhonemeList = PhonemeList_;
}

inline void RequestPhonemeResult::set_has_PhonemeList () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestPhonemeResult::clear_has_PhonemeList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestPhonemeError::RequestPhonemeError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::RequestPhonemeErrorCode__Unspecified;
}

inline  RequestPhonemeError::RequestPhonemeError (const RequestPhonemeError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::RequestPhonemeErrorCode__Unspecified;
    *this = rhs;
}

inline  RequestPhonemeError::~RequestPhonemeError() {
    deleteData ();
}

inline RequestPhonemeError& RequestPhonemeError::operator = (const RequestPhonemeError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool RequestPhonemeError::operator == (const RequestPhonemeError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool RequestPhonemeError::operator != (const RequestPhonemeError& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestPhonemeError::operator < (const RequestPhonemeError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool RequestPhonemeError::operator > (const RequestPhonemeError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline RequestPhonemeError::RequestPhonemeErrorField RequestPhonemeError::getField () const {
    return __field;
}

inline void RequestPhonemeError::setField(RequestPhonemeError::RequestPhonemeErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::RequestPhonemeErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* RequestPhonemeError::clone() {
    return new RequestPhonemeError(*this);
}

inline bool RequestPhonemeError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline RequestPhonemeErrorCode RequestPhonemeError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "RequestPhonemeError", getField());
    }
    return (RequestPhonemeErrorCode) _data.ccaErrorCode_;
}

inline void RequestPhonemeError::setCcaErrorCode (RequestPhonemeErrorCode value) {
    #ifndef NDEBUG
    if (!(RequestPhonemeErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "RequestPhonemeErrorCode", "ccaErrorCode", "RequestPhonemeError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool RequestPhonemeError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode RequestPhonemeError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "RequestPhonemeError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void RequestPhonemeError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "RequestPhonemeError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void RequestPhonemeError::cloneData (const RequestPhonemeError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void RequestPhonemeError::deleteData () {
}

inline  LoadTuningFilesStart::LoadTuningFilesStart ()  :
    _TTSTunFiles (),
    _TTSDomain (::sds_tts_fi_types::T_e8_TTSDomain__Unused),
    _TTSVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LoadTuningFilesStart::LoadTuningFilesStart (const LoadTuningFilesStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TTSTunFiles (),
    _TTSDomain (::sds_tts_fi_types::T_e8_TTSDomain__Unused),
    _TTSVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LoadTuningFilesStart::LoadTuningFilesStart (const ::std::vector< ::sds_tts_fi_types::T_TTSTuningFile >& TTSTunFiles_, ::sds_tts_fi_types::T_e8_TTSDomain TTSDomain_, const ::std::string& TTSVersion_)  :
    _TTSTunFiles (TTSTunFiles_),
    _TTSDomain (TTSDomain_),
    _TTSVersion (TTSVersion_)
{
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TTSDomain_IsValid(TTSDomain_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TTSDomain_, "T_e8_TTSDomain", "TTSDomain", "LoadTuningFilesStart");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LoadTuningFilesStart::~LoadTuningFilesStart() {
}

inline LoadTuningFilesStart& LoadTuningFilesStart::operator = (const LoadTuningFilesStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTTSTunFiles()) {
            setTTSTunFiles(rhs.getTTSTunFiles());
        } else {
            clearTTSTunFiles();
        }
        if (rhs.hasTTSDomain()) {
            setTTSDomain(rhs.getTTSDomain());
        } else {
            clearTTSDomain();
        }
        if (rhs.hasTTSVersion()) {
            setTTSVersion(rhs.getTTSVersion());
        } else {
            clearTTSVersion();
        }
    }
    return *this;
}

inline bool LoadTuningFilesStart::operator == (const LoadTuningFilesStart& rhs) const {
    return (((!hasTTSTunFiles() && !rhs.hasTTSTunFiles()) || getTTSTunFiles() == rhs.getTTSTunFiles()) &&
        ((!hasTTSDomain() && !rhs.hasTTSDomain()) || getTTSDomain() == rhs.getTTSDomain()) &&
        ((!hasTTSVersion() && !rhs.hasTTSVersion()) || getTTSVersion() == rhs.getTTSVersion()));
}

inline bool LoadTuningFilesStart::operator != (const LoadTuningFilesStart& rhs) const {
    return ! (*this == rhs);
}

inline bool LoadTuningFilesStart::operator < (const LoadTuningFilesStart& rhs) const {
    if (hasTTSTunFiles() || rhs.hasTTSTunFiles()) {
        if (getTTSTunFiles() < rhs.getTTSTunFiles()) return true;
        if (getTTSTunFiles() > rhs.getTTSTunFiles()) return false;
    }
    if (hasTTSDomain() || rhs.hasTTSDomain()) {
        if ((uint32)getTTSDomain() < (uint32)rhs.getTTSDomain()) return true;
        if ((uint32)getTTSDomain() > (uint32)rhs.getTTSDomain()) return false;
    }
    if (hasTTSVersion() || rhs.hasTTSVersion()) {
        if (getTTSVersion() < rhs.getTTSVersion()) return true;
        if (getTTSVersion() > rhs.getTTSVersion()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LoadTuningFilesStart::clone() {
    return new LoadTuningFilesStart(*this);
}

inline bool LoadTuningFilesStart::operator > (const LoadTuningFilesStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LoadTuningFilesStart::clear() {
    clearTTSTunFiles();
    clearTTSDomain();
    clearTTSVersion();
}

inline void LoadTuningFilesStart::clearTTSTunFiles() {
    if (hasTTSTunFiles()) {
         clear_has_TTSTunFiles();
        _TTSTunFiles.clear();
     }
}

inline bool LoadTuningFilesStart::hasTTSTunFiles () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::sds_tts_fi_types::T_TTSTuningFile >& LoadTuningFilesStart::getTTSTunFiles () const {
    return _TTSTunFiles;
}

inline ::std::vector< ::sds_tts_fi_types::T_TTSTuningFile >& LoadTuningFilesStart::getTTSTunFilesMutable () {
    set_has_TTSTunFiles();
    return _TTSTunFiles;
}

inline void LoadTuningFilesStart::setTTSTunFiles (const ::std::vector< ::sds_tts_fi_types::T_TTSTuningFile >& TTSTunFiles_) {
    set_has_TTSTunFiles();
    this->_TTSTunFiles = TTSTunFiles_;
}

inline void LoadTuningFilesStart::clearTTSDomain() {
    if (hasTTSDomain()) {
         clear_has_TTSDomain();
        _TTSDomain = ::sds_tts_fi_types::T_e8_TTSDomain__Unused;
     }
}

inline bool LoadTuningFilesStart::hasTTSDomain () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sds_tts_fi_types::T_e8_TTSDomain LoadTuningFilesStart::getTTSDomain () const {
    return _TTSDomain;
}

inline void LoadTuningFilesStart::setTTSDomain (::sds_tts_fi_types::T_e8_TTSDomain TTSDomain_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TTSDomain_IsValid(TTSDomain_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TTSDomain_, "T_e8_TTSDomain", "TTSDomain", "LoadTuningFilesStart");
    }
    #endif
    set_has_TTSDomain();
    this->_TTSDomain = TTSDomain_;
}

inline void LoadTuningFilesStart::clearTTSVersion() {
    if (hasTTSVersion()) {
         clear_has_TTSVersion();
        _TTSVersion.clear();
     }
}

inline bool LoadTuningFilesStart::hasTTSVersion () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& LoadTuningFilesStart::getTTSVersion () const {
    return _TTSVersion;
}

inline ::std::string& LoadTuningFilesStart::getTTSVersionMutable () {
    set_has_TTSVersion();
    return _TTSVersion;
}

inline void LoadTuningFilesStart::setTTSVersion (const ::std::string& TTSVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSVersion();
    this->_TTSVersion = TTSVersion_;
}

inline void LoadTuningFilesStart::setTTSVersion (const char* TTSVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TTSVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSVersion();
    this->_TTSVersion.assign(TTSVersion_);
}

inline void LoadTuningFilesStart::setTTSVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TTSVersion();
    this->_TTSVersion.assign(value, size);
}

inline void LoadTuningFilesStart::set_has_TTSTunFiles () {
    _has_bits_[0] |= 1u << 0;
}

inline void LoadTuningFilesStart::clear_has_TTSTunFiles () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LoadTuningFilesStart::set_has_TTSDomain () {
    _has_bits_[0] |= 1u << 1;
}

inline void LoadTuningFilesStart::clear_has_TTSDomain () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void LoadTuningFilesStart::set_has_TTSVersion () {
    _has_bits_[0] |= 1u << 2;
}

inline void LoadTuningFilesStart::clear_has_TTSVersion () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  LoadTuningFilesError::LoadTuningFilesError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::LoadTuningFilesErrorCode__Unspecified;
}

inline  LoadTuningFilesError::LoadTuningFilesError (const LoadTuningFilesError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::LoadTuningFilesErrorCode__Unspecified;
    *this = rhs;
}

inline  LoadTuningFilesError::~LoadTuningFilesError() {
    deleteData ();
}

inline LoadTuningFilesError& LoadTuningFilesError::operator = (const LoadTuningFilesError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool LoadTuningFilesError::operator == (const LoadTuningFilesError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool LoadTuningFilesError::operator != (const LoadTuningFilesError& rhs) const {
    return ! (*this == rhs);
}

inline bool LoadTuningFilesError::operator < (const LoadTuningFilesError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool LoadTuningFilesError::operator > (const LoadTuningFilesError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline LoadTuningFilesError::LoadTuningFilesErrorField LoadTuningFilesError::getField () const {
    return __field;
}

inline void LoadTuningFilesError::setField(LoadTuningFilesError::LoadTuningFilesErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::LoadTuningFilesErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* LoadTuningFilesError::clone() {
    return new LoadTuningFilesError(*this);
}

inline bool LoadTuningFilesError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline LoadTuningFilesErrorCode LoadTuningFilesError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "LoadTuningFilesError", getField());
    }
    return (LoadTuningFilesErrorCode) _data.ccaErrorCode_;
}

inline void LoadTuningFilesError::setCcaErrorCode (LoadTuningFilesErrorCode value) {
    #ifndef NDEBUG
    if (!(LoadTuningFilesErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "LoadTuningFilesErrorCode", "ccaErrorCode", "LoadTuningFilesError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool LoadTuningFilesError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode LoadTuningFilesError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "LoadTuningFilesError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void LoadTuningFilesError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "LoadTuningFilesError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void LoadTuningFilesError::cloneData (const LoadTuningFilesError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void LoadTuningFilesError::deleteData () {
}

inline  SetDefaultSpeechRateStart::SetDefaultSpeechRateStart ()  :
    _Rate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetDefaultSpeechRateStart::SetDefaultSpeechRateStart (const SetDefaultSpeechRateStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Rate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetDefaultSpeechRateStart::SetDefaultSpeechRateStart (uint16 Rate_)  :
    _Rate (Rate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetDefaultSpeechRateStart::~SetDefaultSpeechRateStart() {
}

inline SetDefaultSpeechRateStart& SetDefaultSpeechRateStart::operator = (const SetDefaultSpeechRateStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRate()) {
            setRate(rhs.getRate());
        } else {
            clearRate();
        }
    }
    return *this;
}

inline bool SetDefaultSpeechRateStart::operator == (const SetDefaultSpeechRateStart& rhs) const {
    return (((!hasRate() && !rhs.hasRate()) || getRate() == rhs.getRate()));
}

inline bool SetDefaultSpeechRateStart::operator != (const SetDefaultSpeechRateStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetDefaultSpeechRateStart::operator < (const SetDefaultSpeechRateStart& rhs) const {
    if (hasRate() || rhs.hasRate()) {
        if (getRate() < rhs.getRate()) return true;
        if (getRate() > rhs.getRate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetDefaultSpeechRateStart::clone() {
    return new SetDefaultSpeechRateStart(*this);
}

inline bool SetDefaultSpeechRateStart::operator > (const SetDefaultSpeechRateStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetDefaultSpeechRateStart::clear() {
    clearRate();
}

inline void SetDefaultSpeechRateStart::clearRate() {
    if (hasRate()) {
         clear_has_Rate();
        _Rate = 0u;
     }
}

inline bool SetDefaultSpeechRateStart::hasRate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SetDefaultSpeechRateStart::getRate () const {
    return _Rate;
}

inline void SetDefaultSpeechRateStart::setRate (uint16 Rate_) {
    set_has_Rate();
    this->_Rate = Rate_;
}

inline void SetDefaultSpeechRateStart::set_has_Rate () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetDefaultSpeechRateStart::clear_has_Rate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoSynthesisForSpeakStart::DoSynthesisForSpeakStart ()  :
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_TextStyleOption__Unknown),
    _StatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo),
    _LastPackage (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoSynthesisForSpeakStart::DoSynthesisForSpeakStart (const DoSynthesisForSpeakStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_TextStyleOption__Unknown),
    _StatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo),
    _LastPackage (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoSynthesisForSpeakStart::DoSynthesisForSpeakStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_, ::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_, bool LastPackage_)  :
    _TextAndTags (TextAndTags_),
    _TextStyle (TextStyle_),
    _StatusInfo (StatusInfo_),
    _LastPackage (LastPackage_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TextStyleOption_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_TextStyleOption", "TextStyle", "DoSynthesisForSpeakStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_StatusInfoOption_IsValid(StatusInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusInfo_, "T_e8_StatusInfoOption", "StatusInfo", "DoSynthesisForSpeakStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoSynthesisForSpeakStart::~DoSynthesisForSpeakStart() {
}

inline DoSynthesisForSpeakStart& DoSynthesisForSpeakStart::operator = (const DoSynthesisForSpeakStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTextAndTags()) {
            setTextAndTags(rhs.getTextAndTags());
        } else {
            clearTextAndTags();
        }
        if (rhs.hasTextStyle()) {
            setTextStyle(rhs.getTextStyle());
        } else {
            clearTextStyle();
        }
        if (rhs.hasStatusInfo()) {
            setStatusInfo(rhs.getStatusInfo());
        } else {
            clearStatusInfo();
        }
        if (rhs.hasLastPackage()) {
            setLastPackage(rhs.getLastPackage());
        } else {
            clearLastPackage();
        }
    }
    return *this;
}

inline bool DoSynthesisForSpeakStart::operator == (const DoSynthesisForSpeakStart& rhs) const {
    return (((!hasTextAndTags() && !rhs.hasTextAndTags()) || getTextAndTags() == rhs.getTextAndTags()) &&
        ((!hasTextStyle() && !rhs.hasTextStyle()) || getTextStyle() == rhs.getTextStyle()) &&
        ((!hasStatusInfo() && !rhs.hasStatusInfo()) || getStatusInfo() == rhs.getStatusInfo()) &&
        ((!hasLastPackage() && !rhs.hasLastPackage()) || getLastPackage() == rhs.getLastPackage()));
}

inline bool DoSynthesisForSpeakStart::operator != (const DoSynthesisForSpeakStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DoSynthesisForSpeakStart::operator < (const DoSynthesisForSpeakStart& rhs) const {
    if (hasTextAndTags() || rhs.hasTextAndTags()) {
        if (getTextAndTags() < rhs.getTextAndTags()) return true;
        if (getTextAndTags() > rhs.getTextAndTags()) return false;
    }
    if (hasTextStyle() || rhs.hasTextStyle()) {
        if ((uint32)getTextStyle() < (uint32)rhs.getTextStyle()) return true;
        if ((uint32)getTextStyle() > (uint32)rhs.getTextStyle()) return false;
    }
    if (hasStatusInfo() || rhs.hasStatusInfo()) {
        if ((uint32)getStatusInfo() < (uint32)rhs.getStatusInfo()) return true;
        if ((uint32)getStatusInfo() > (uint32)rhs.getStatusInfo()) return false;
    }
    if (hasLastPackage() || rhs.hasLastPackage()) {
        if (getLastPackage() < rhs.getLastPackage()) return true;
        if (getLastPackage() > rhs.getLastPackage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoSynthesisForSpeakStart::clone() {
    return new DoSynthesisForSpeakStart(*this);
}

inline bool DoSynthesisForSpeakStart::operator > (const DoSynthesisForSpeakStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoSynthesisForSpeakStart::clear() {
    clearTextAndTags();
    clearTextStyle();
    clearStatusInfo();
    clearLastPackage();
}

inline void DoSynthesisForSpeakStart::clearTextAndTags() {
    if (hasTextAndTags()) {
         clear_has_TextAndTags();
        _TextAndTags.clear();
     }
}

inline bool DoSynthesisForSpeakStart::hasTextAndTags () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DoSynthesisForSpeakStart::getTextAndTags () const {
    return _TextAndTags;
}

inline ::std::string& DoSynthesisForSpeakStart::getTextAndTagsMutable () {
    set_has_TextAndTags();
    return _TextAndTags;
}

inline void DoSynthesisForSpeakStart::setTextAndTags (const ::std::string& TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags = TextAndTags_;
}

inline void DoSynthesisForSpeakStart::setTextAndTags (const char* TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(TextAndTags_);
}

inline void DoSynthesisForSpeakStart::setTextAndTags (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(value, size);
}

inline void DoSynthesisForSpeakStart::clearTextStyle() {
    if (hasTextStyle()) {
         clear_has_TextStyle();
        _TextStyle = ::sds_tts_fi_types::T_e8_TextStyleOption__Unknown;
     }
}

inline bool DoSynthesisForSpeakStart::hasTextStyle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sds_tts_fi_types::T_e8_TextStyleOption DoSynthesisForSpeakStart::getTextStyle () const {
    return _TextStyle;
}

inline void DoSynthesisForSpeakStart::setTextStyle (::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TextStyleOption_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_TextStyleOption", "TextStyle", "DoSynthesisForSpeakStart");
    }
    #endif
    set_has_TextStyle();
    this->_TextStyle = TextStyle_;
}

inline void DoSynthesisForSpeakStart::clearStatusInfo() {
    if (hasStatusInfo()) {
         clear_has_StatusInfo();
        _StatusInfo = ::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo;
     }
}

inline bool DoSynthesisForSpeakStart::hasStatusInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::sds_tts_fi_types::T_e8_StatusInfoOption DoSynthesisForSpeakStart::getStatusInfo () const {
    return _StatusInfo;
}

inline void DoSynthesisForSpeakStart::setStatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_StatusInfoOption_IsValid(StatusInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusInfo_, "T_e8_StatusInfoOption", "StatusInfo", "DoSynthesisForSpeakStart");
    }
    #endif
    set_has_StatusInfo();
    this->_StatusInfo = StatusInfo_;
}

inline void DoSynthesisForSpeakStart::clearLastPackage() {
    if (hasLastPackage()) {
         clear_has_LastPackage();
        _LastPackage = false;
     }
}

inline bool DoSynthesisForSpeakStart::hasLastPackage () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool DoSynthesisForSpeakStart::getLastPackage () const {
    return _LastPackage;
}

inline void DoSynthesisForSpeakStart::setLastPackage (bool LastPackage_) {
    set_has_LastPackage();
    this->_LastPackage = LastPackage_;
}

inline void DoSynthesisForSpeakStart::set_has_TextAndTags () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoSynthesisForSpeakStart::clear_has_TextAndTags () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DoSynthesisForSpeakStart::set_has_TextStyle () {
    _has_bits_[0] |= 1u << 1;
}

inline void DoSynthesisForSpeakStart::clear_has_TextStyle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DoSynthesisForSpeakStart::set_has_StatusInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void DoSynthesisForSpeakStart::clear_has_StatusInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DoSynthesisForSpeakStart::set_has_LastPackage () {
    _has_bits_[0] |= 1u << 3;
}

inline void DoSynthesisForSpeakStart::clear_has_LastPackage () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  DoPrepareAudioOutputStart::DoPrepareAudioOutputStart ()  :
    _DeviceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoPrepareAudioOutputStart::DoPrepareAudioOutputStart (const DoPrepareAudioOutputStart &rhs)  :
    ::asf::core::Payload(rhs),
    _DeviceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoPrepareAudioOutputStart::DoPrepareAudioOutputStart (const ::std::string& DeviceName_)  :
    _DeviceName (DeviceName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoPrepareAudioOutputStart::~DoPrepareAudioOutputStart() {
}

inline DoPrepareAudioOutputStart& DoPrepareAudioOutputStart::operator = (const DoPrepareAudioOutputStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceName()) {
            setDeviceName(rhs.getDeviceName());
        } else {
            clearDeviceName();
        }
    }
    return *this;
}

inline bool DoPrepareAudioOutputStart::operator == (const DoPrepareAudioOutputStart& rhs) const {
    return (((!hasDeviceName() && !rhs.hasDeviceName()) || getDeviceName() == rhs.getDeviceName()));
}

inline bool DoPrepareAudioOutputStart::operator != (const DoPrepareAudioOutputStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DoPrepareAudioOutputStart::operator < (const DoPrepareAudioOutputStart& rhs) const {
    if (hasDeviceName() || rhs.hasDeviceName()) {
        if (getDeviceName() < rhs.getDeviceName()) return true;
        if (getDeviceName() > rhs.getDeviceName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoPrepareAudioOutputStart::clone() {
    return new DoPrepareAudioOutputStart(*this);
}

inline bool DoPrepareAudioOutputStart::operator > (const DoPrepareAudioOutputStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoPrepareAudioOutputStart::clear() {
    clearDeviceName();
}

inline void DoPrepareAudioOutputStart::clearDeviceName() {
    if (hasDeviceName()) {
         clear_has_DeviceName();
        _DeviceName.clear();
     }
}

inline bool DoPrepareAudioOutputStart::hasDeviceName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DoPrepareAudioOutputStart::getDeviceName () const {
    return _DeviceName;
}

inline ::std::string& DoPrepareAudioOutputStart::getDeviceNameMutable () {
    set_has_DeviceName();
    return _DeviceName;
}

inline void DoPrepareAudioOutputStart::setDeviceName (const ::std::string& DeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceName();
    this->_DeviceName = DeviceName_;
}

inline void DoPrepareAudioOutputStart::setDeviceName (const char* DeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceName();
    this->_DeviceName.assign(DeviceName_);
}

inline void DoPrepareAudioOutputStart::setDeviceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceName();
    this->_DeviceName.assign(value, size);
}

inline void DoPrepareAudioOutputStart::set_has_DeviceName () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoPrepareAudioOutputStart::clear_has_DeviceName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoPrepareAudioOutputError::DoPrepareAudioOutputError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::DoPrepareAudioOutputErrorCode__Unspecified;
}

inline  DoPrepareAudioOutputError::DoPrepareAudioOutputError (const DoPrepareAudioOutputError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::DoPrepareAudioOutputErrorCode__Unspecified;
    *this = rhs;
}

inline  DoPrepareAudioOutputError::~DoPrepareAudioOutputError() {
    deleteData ();
}

inline DoPrepareAudioOutputError& DoPrepareAudioOutputError::operator = (const DoPrepareAudioOutputError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool DoPrepareAudioOutputError::operator == (const DoPrepareAudioOutputError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool DoPrepareAudioOutputError::operator != (const DoPrepareAudioOutputError& rhs) const {
    return ! (*this == rhs);
}

inline bool DoPrepareAudioOutputError::operator < (const DoPrepareAudioOutputError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool DoPrepareAudioOutputError::operator > (const DoPrepareAudioOutputError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline DoPrepareAudioOutputError::DoPrepareAudioOutputErrorField DoPrepareAudioOutputError::getField () const {
    return __field;
}

inline void DoPrepareAudioOutputError::setField(DoPrepareAudioOutputError::DoPrepareAudioOutputErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::DoPrepareAudioOutputErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* DoPrepareAudioOutputError::clone() {
    return new DoPrepareAudioOutputError(*this);
}

inline bool DoPrepareAudioOutputError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline DoPrepareAudioOutputErrorCode DoPrepareAudioOutputError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "DoPrepareAudioOutputError", getField());
    }
    return (DoPrepareAudioOutputErrorCode) _data.ccaErrorCode_;
}

inline void DoPrepareAudioOutputError::setCcaErrorCode (DoPrepareAudioOutputErrorCode value) {
    #ifndef NDEBUG
    if (!(DoPrepareAudioOutputErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "DoPrepareAudioOutputErrorCode", "ccaErrorCode", "DoPrepareAudioOutputError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool DoPrepareAudioOutputError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode DoPrepareAudioOutputError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "DoPrepareAudioOutputError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void DoPrepareAudioOutputError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "DoPrepareAudioOutputError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void DoPrepareAudioOutputError::cloneData (const DoPrepareAudioOutputError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void DoPrepareAudioOutputError::deleteData () {
}

inline  DoAudioOutputSpeakStart::DoAudioOutputSpeakStart ()  :
    _StatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo),
    _AudioOutputLocation ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakStart::DoAudioOutputSpeakStart (const DoAudioOutputSpeakStart &rhs)  :
    ::asf::core::Payload(rhs),
    _StatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo),
    _AudioOutputLocation ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoAudioOutputSpeakStart::DoAudioOutputSpeakStart (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_, const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_)  :
    _StatusInfo (StatusInfo_),
    _AudioOutputLocation (AudioOutputLocation_)
{
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_StatusInfoOption_IsValid(StatusInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusInfo_, "T_e8_StatusInfoOption", "StatusInfo", "DoAudioOutputSpeakStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakStart::~DoAudioOutputSpeakStart() {
}

inline DoAudioOutputSpeakStart& DoAudioOutputSpeakStart::operator = (const DoAudioOutputSpeakStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatusInfo()) {
            setStatusInfo(rhs.getStatusInfo());
        } else {
            clearStatusInfo();
        }
        if (rhs.hasAudioOutputLocation()) {
            setAudioOutputLocation(rhs.getAudioOutputLocation());
        } else {
            clearAudioOutputLocation();
        }
    }
    return *this;
}

inline bool DoAudioOutputSpeakStart::operator == (const DoAudioOutputSpeakStart& rhs) const {
    return (((!hasStatusInfo() && !rhs.hasStatusInfo()) || getStatusInfo() == rhs.getStatusInfo()) &&
        ((!hasAudioOutputLocation() && !rhs.hasAudioOutputLocation()) || getAudioOutputLocation() == rhs.getAudioOutputLocation()));
}

inline bool DoAudioOutputSpeakStart::operator != (const DoAudioOutputSpeakStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DoAudioOutputSpeakStart::operator < (const DoAudioOutputSpeakStart& rhs) const {
    if (hasStatusInfo() || rhs.hasStatusInfo()) {
        if ((uint32)getStatusInfo() < (uint32)rhs.getStatusInfo()) return true;
        if ((uint32)getStatusInfo() > (uint32)rhs.getStatusInfo()) return false;
    }
    if (hasAudioOutputLocation() || rhs.hasAudioOutputLocation()) {
        if (getAudioOutputLocation() < rhs.getAudioOutputLocation()) return true;
        if (getAudioOutputLocation() > rhs.getAudioOutputLocation()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoAudioOutputSpeakStart::clone() {
    return new DoAudioOutputSpeakStart(*this);
}

inline bool DoAudioOutputSpeakStart::operator > (const DoAudioOutputSpeakStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoAudioOutputSpeakStart::clear() {
    clearStatusInfo();
    clearAudioOutputLocation();
}

inline void DoAudioOutputSpeakStart::clearStatusInfo() {
    if (hasStatusInfo()) {
         clear_has_StatusInfo();
        _StatusInfo = ::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo;
     }
}

inline bool DoAudioOutputSpeakStart::hasStatusInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sds_tts_fi_types::T_e8_StatusInfoOption DoAudioOutputSpeakStart::getStatusInfo () const {
    return _StatusInfo;
}

inline void DoAudioOutputSpeakStart::setStatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_StatusInfoOption_IsValid(StatusInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusInfo_, "T_e8_StatusInfoOption", "StatusInfo", "DoAudioOutputSpeakStart");
    }
    #endif
    set_has_StatusInfo();
    this->_StatusInfo = StatusInfo_;
}

inline void DoAudioOutputSpeakStart::clearAudioOutputLocation() {
    if (hasAudioOutputLocation()) {
         clear_has_AudioOutputLocation();
        _AudioOutputLocation = ::acr_fi_types::T_b8_AudioOutputLocation ();
     }
}

inline bool DoAudioOutputSpeakStart::hasAudioOutputLocation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::acr_fi_types::T_b8_AudioOutputLocation& DoAudioOutputSpeakStart::getAudioOutputLocation () const {
    return _AudioOutputLocation;
}

inline ::acr_fi_types::T_b8_AudioOutputLocation& DoAudioOutputSpeakStart::getAudioOutputLocationMutable () {
    set_has_AudioOutputLocation();
    return _AudioOutputLocation;
}

inline void DoAudioOutputSpeakStart::setAudioOutputLocation (const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_) {
    set_has_AudioOutputLocation();
    this->_AudioOutputLocation = AudioOutputLocation_;
}

inline void DoAudioOutputSpeakStart::set_has_StatusInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoAudioOutputSpeakStart::clear_has_StatusInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DoAudioOutputSpeakStart::set_has_AudioOutputLocation () {
    _has_bits_[0] |= 1u << 1;
}

inline void DoAudioOutputSpeakStart::clear_has_AudioOutputLocation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DoAudioOutputSpeakResultFirst::DoAudioOutputSpeakResultFirst ()  :
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakResultFirst::DoAudioOutputSpeakResultFirst (const DoAudioOutputSpeakResultFirst &rhs)  :
    ::asf::core::Payload(rhs),
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoAudioOutputSpeakResultFirst::DoAudioOutputSpeakResultFirst (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_)  :
    _JobProgress (JobProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakResultFirst::~DoAudioOutputSpeakResultFirst() {
}

inline DoAudioOutputSpeakResultFirst& DoAudioOutputSpeakResultFirst::operator = (const DoAudioOutputSpeakResultFirst& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobProgress()) {
            setJobProgress(rhs.getJobProgress());
        } else {
            clearJobProgress();
        }
    }
    return *this;
}

inline bool DoAudioOutputSpeakResultFirst::operator == (const DoAudioOutputSpeakResultFirst& rhs) const {
    return (((!hasJobProgress() && !rhs.hasJobProgress()) || getJobProgress() == rhs.getJobProgress()));
}

inline bool DoAudioOutputSpeakResultFirst::operator != (const DoAudioOutputSpeakResultFirst& rhs) const {
    return ! (*this == rhs);
}

inline bool DoAudioOutputSpeakResultFirst::operator < (const DoAudioOutputSpeakResultFirst& rhs) const {
    if (hasJobProgress() || rhs.hasJobProgress()) {
        if (getJobProgress() < rhs.getJobProgress()) return true;
        if (getJobProgress() > rhs.getJobProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoAudioOutputSpeakResultFirst::clone() {
    return new DoAudioOutputSpeakResultFirst(*this);
}

inline bool DoAudioOutputSpeakResultFirst::operator > (const DoAudioOutputSpeakResultFirst& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoAudioOutputSpeakResultFirst::clear() {
    clearJobProgress();
}

inline void DoAudioOutputSpeakResultFirst::clearJobProgress() {
    if (hasJobProgress()) {
         clear_has_JobProgress();
        _JobProgress.clear();
     }
}

inline bool DoAudioOutputSpeakResultFirst::hasJobProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_tts_fi_types::T_SpeakProgress& DoAudioOutputSpeakResultFirst::getJobProgress () const {
    return _JobProgress;
}

inline ::sds_tts_fi_types::T_SpeakProgress& DoAudioOutputSpeakResultFirst::getJobProgressMutable () {
    set_has_JobProgress();
    return _JobProgress;
}

inline void DoAudioOutputSpeakResultFirst::setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_) {
    set_has_JobProgress();
    this->_JobProgress = JobProgress_;
}

inline void DoAudioOutputSpeakResultFirst::set_has_JobProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoAudioOutputSpeakResultFirst::clear_has_JobProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoAudioOutputSpeakResultMiddle::DoAudioOutputSpeakResultMiddle ()  :
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakResultMiddle::DoAudioOutputSpeakResultMiddle (const DoAudioOutputSpeakResultMiddle &rhs)  :
    ::asf::core::Payload(rhs),
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoAudioOutputSpeakResultMiddle::DoAudioOutputSpeakResultMiddle (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_)  :
    _JobProgress (JobProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakResultMiddle::~DoAudioOutputSpeakResultMiddle() {
}

inline DoAudioOutputSpeakResultMiddle& DoAudioOutputSpeakResultMiddle::operator = (const DoAudioOutputSpeakResultMiddle& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobProgress()) {
            setJobProgress(rhs.getJobProgress());
        } else {
            clearJobProgress();
        }
    }
    return *this;
}

inline bool DoAudioOutputSpeakResultMiddle::operator == (const DoAudioOutputSpeakResultMiddle& rhs) const {
    return (((!hasJobProgress() && !rhs.hasJobProgress()) || getJobProgress() == rhs.getJobProgress()));
}

inline bool DoAudioOutputSpeakResultMiddle::operator != (const DoAudioOutputSpeakResultMiddle& rhs) const {
    return ! (*this == rhs);
}

inline bool DoAudioOutputSpeakResultMiddle::operator < (const DoAudioOutputSpeakResultMiddle& rhs) const {
    if (hasJobProgress() || rhs.hasJobProgress()) {
        if (getJobProgress() < rhs.getJobProgress()) return true;
        if (getJobProgress() > rhs.getJobProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoAudioOutputSpeakResultMiddle::clone() {
    return new DoAudioOutputSpeakResultMiddle(*this);
}

inline bool DoAudioOutputSpeakResultMiddle::operator > (const DoAudioOutputSpeakResultMiddle& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoAudioOutputSpeakResultMiddle::clear() {
    clearJobProgress();
}

inline void DoAudioOutputSpeakResultMiddle::clearJobProgress() {
    if (hasJobProgress()) {
         clear_has_JobProgress();
        _JobProgress.clear();
     }
}

inline bool DoAudioOutputSpeakResultMiddle::hasJobProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_tts_fi_types::T_SpeakProgress& DoAudioOutputSpeakResultMiddle::getJobProgress () const {
    return _JobProgress;
}

inline ::sds_tts_fi_types::T_SpeakProgress& DoAudioOutputSpeakResultMiddle::getJobProgressMutable () {
    set_has_JobProgress();
    return _JobProgress;
}

inline void DoAudioOutputSpeakResultMiddle::setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_) {
    set_has_JobProgress();
    this->_JobProgress = JobProgress_;
}

inline void DoAudioOutputSpeakResultMiddle::set_has_JobProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoAudioOutputSpeakResultMiddle::clear_has_JobProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoAudioOutputSpeakResultLast::DoAudioOutputSpeakResultLast ()  :
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakResultLast::DoAudioOutputSpeakResultLast (const DoAudioOutputSpeakResultLast &rhs)  :
    ::asf::core::Payload(rhs),
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoAudioOutputSpeakResultLast::DoAudioOutputSpeakResultLast (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_)  :
    _JobProgress (JobProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakResultLast::~DoAudioOutputSpeakResultLast() {
}

inline DoAudioOutputSpeakResultLast& DoAudioOutputSpeakResultLast::operator = (const DoAudioOutputSpeakResultLast& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobProgress()) {
            setJobProgress(rhs.getJobProgress());
        } else {
            clearJobProgress();
        }
    }
    return *this;
}

inline bool DoAudioOutputSpeakResultLast::operator == (const DoAudioOutputSpeakResultLast& rhs) const {
    return (((!hasJobProgress() && !rhs.hasJobProgress()) || getJobProgress() == rhs.getJobProgress()));
}

inline bool DoAudioOutputSpeakResultLast::operator != (const DoAudioOutputSpeakResultLast& rhs) const {
    return ! (*this == rhs);
}

inline bool DoAudioOutputSpeakResultLast::operator < (const DoAudioOutputSpeakResultLast& rhs) const {
    if (hasJobProgress() || rhs.hasJobProgress()) {
        if (getJobProgress() < rhs.getJobProgress()) return true;
        if (getJobProgress() > rhs.getJobProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoAudioOutputSpeakResultLast::clone() {
    return new DoAudioOutputSpeakResultLast(*this);
}

inline bool DoAudioOutputSpeakResultLast::operator > (const DoAudioOutputSpeakResultLast& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoAudioOutputSpeakResultLast::clear() {
    clearJobProgress();
}

inline void DoAudioOutputSpeakResultLast::clearJobProgress() {
    if (hasJobProgress()) {
         clear_has_JobProgress();
        _JobProgress.clear();
     }
}

inline bool DoAudioOutputSpeakResultLast::hasJobProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_tts_fi_types::T_SpeakProgress& DoAudioOutputSpeakResultLast::getJobProgress () const {
    return _JobProgress;
}

inline ::sds_tts_fi_types::T_SpeakProgress& DoAudioOutputSpeakResultLast::getJobProgressMutable () {
    set_has_JobProgress();
    return _JobProgress;
}

inline void DoAudioOutputSpeakResultLast::setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_) {
    set_has_JobProgress();
    this->_JobProgress = JobProgress_;
}

inline void DoAudioOutputSpeakResultLast::set_has_JobProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoAudioOutputSpeakResultLast::clear_has_JobProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoSynthesisForWriteStart::DoSynthesisForWriteStart ()  :
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_TextStyleOption__Unknown),
    _LastPackage (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoSynthesisForWriteStart::DoSynthesisForWriteStart (const DoSynthesisForWriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_TextStyleOption__Unknown),
    _LastPackage (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoSynthesisForWriteStart::DoSynthesisForWriteStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_, bool LastPackage_)  :
    _TextAndTags (TextAndTags_),
    _TextStyle (TextStyle_),
    _LastPackage (LastPackage_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TextStyleOption_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_TextStyleOption", "TextStyle", "DoSynthesisForWriteStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoSynthesisForWriteStart::~DoSynthesisForWriteStart() {
}

inline DoSynthesisForWriteStart& DoSynthesisForWriteStart::operator = (const DoSynthesisForWriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTextAndTags()) {
            setTextAndTags(rhs.getTextAndTags());
        } else {
            clearTextAndTags();
        }
        if (rhs.hasTextStyle()) {
            setTextStyle(rhs.getTextStyle());
        } else {
            clearTextStyle();
        }
        if (rhs.hasLastPackage()) {
            setLastPackage(rhs.getLastPackage());
        } else {
            clearLastPackage();
        }
    }
    return *this;
}

inline bool DoSynthesisForWriteStart::operator == (const DoSynthesisForWriteStart& rhs) const {
    return (((!hasTextAndTags() && !rhs.hasTextAndTags()) || getTextAndTags() == rhs.getTextAndTags()) &&
        ((!hasTextStyle() && !rhs.hasTextStyle()) || getTextStyle() == rhs.getTextStyle()) &&
        ((!hasLastPackage() && !rhs.hasLastPackage()) || getLastPackage() == rhs.getLastPackage()));
}

inline bool DoSynthesisForWriteStart::operator != (const DoSynthesisForWriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DoSynthesisForWriteStart::operator < (const DoSynthesisForWriteStart& rhs) const {
    if (hasTextAndTags() || rhs.hasTextAndTags()) {
        if (getTextAndTags() < rhs.getTextAndTags()) return true;
        if (getTextAndTags() > rhs.getTextAndTags()) return false;
    }
    if (hasTextStyle() || rhs.hasTextStyle()) {
        if ((uint32)getTextStyle() < (uint32)rhs.getTextStyle()) return true;
        if ((uint32)getTextStyle() > (uint32)rhs.getTextStyle()) return false;
    }
    if (hasLastPackage() || rhs.hasLastPackage()) {
        if (getLastPackage() < rhs.getLastPackage()) return true;
        if (getLastPackage() > rhs.getLastPackage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoSynthesisForWriteStart::clone() {
    return new DoSynthesisForWriteStart(*this);
}

inline bool DoSynthesisForWriteStart::operator > (const DoSynthesisForWriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoSynthesisForWriteStart::clear() {
    clearTextAndTags();
    clearTextStyle();
    clearLastPackage();
}

inline void DoSynthesisForWriteStart::clearTextAndTags() {
    if (hasTextAndTags()) {
         clear_has_TextAndTags();
        _TextAndTags.clear();
     }
}

inline bool DoSynthesisForWriteStart::hasTextAndTags () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DoSynthesisForWriteStart::getTextAndTags () const {
    return _TextAndTags;
}

inline ::std::string& DoSynthesisForWriteStart::getTextAndTagsMutable () {
    set_has_TextAndTags();
    return _TextAndTags;
}

inline void DoSynthesisForWriteStart::setTextAndTags (const ::std::string& TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags = TextAndTags_;
}

inline void DoSynthesisForWriteStart::setTextAndTags (const char* TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(TextAndTags_);
}

inline void DoSynthesisForWriteStart::setTextAndTags (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(value, size);
}

inline void DoSynthesisForWriteStart::clearTextStyle() {
    if (hasTextStyle()) {
         clear_has_TextStyle();
        _TextStyle = ::sds_tts_fi_types::T_e8_TextStyleOption__Unknown;
     }
}

inline bool DoSynthesisForWriteStart::hasTextStyle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sds_tts_fi_types::T_e8_TextStyleOption DoSynthesisForWriteStart::getTextStyle () const {
    return _TextStyle;
}

inline void DoSynthesisForWriteStart::setTextStyle (::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TextStyleOption_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_TextStyleOption", "TextStyle", "DoSynthesisForWriteStart");
    }
    #endif
    set_has_TextStyle();
    this->_TextStyle = TextStyle_;
}

inline void DoSynthesisForWriteStart::clearLastPackage() {
    if (hasLastPackage()) {
         clear_has_LastPackage();
        _LastPackage = false;
     }
}

inline bool DoSynthesisForWriteStart::hasLastPackage () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool DoSynthesisForWriteStart::getLastPackage () const {
    return _LastPackage;
}

inline void DoSynthesisForWriteStart::setLastPackage (bool LastPackage_) {
    set_has_LastPackage();
    this->_LastPackage = LastPackage_;
}

inline void DoSynthesisForWriteStart::set_has_TextAndTags () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoSynthesisForWriteStart::clear_has_TextAndTags () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DoSynthesisForWriteStart::set_has_TextStyle () {
    _has_bits_[0] |= 1u << 1;
}

inline void DoSynthesisForWriteStart::clear_has_TextStyle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DoSynthesisForWriteStart::set_has_LastPackage () {
    _has_bits_[0] |= 1u << 2;
}

inline void DoSynthesisForWriteStart::clear_has_LastPackage () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  DoAudioOutputWriteStart::DoAudioOutputWriteStart ()  :
    _Buffering (::sds_tts_fi_types::T_e8_BufferingOption__Unknown),
    _Compression ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoAudioOutputWriteStart::DoAudioOutputWriteStart (const DoAudioOutputWriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Buffering (::sds_tts_fi_types::T_e8_BufferingOption__Unknown),
    _Compression ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoAudioOutputWriteStart::DoAudioOutputWriteStart (::sds_tts_fi_types::T_e8_BufferingOption Buffering_, const ::acr_fi_types::T_b8_AudioFormat& Compression_)  :
    _Buffering (Buffering_),
    _Compression (Compression_)
{
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_BufferingOption_IsValid(Buffering_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Buffering_, "T_e8_BufferingOption", "Buffering", "DoAudioOutputWriteStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoAudioOutputWriteStart::~DoAudioOutputWriteStart() {
}

inline DoAudioOutputWriteStart& DoAudioOutputWriteStart::operator = (const DoAudioOutputWriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBuffering()) {
            setBuffering(rhs.getBuffering());
        } else {
            clearBuffering();
        }
        if (rhs.hasCompression()) {
            setCompression(rhs.getCompression());
        } else {
            clearCompression();
        }
    }
    return *this;
}

inline bool DoAudioOutputWriteStart::operator == (const DoAudioOutputWriteStart& rhs) const {
    return (((!hasBuffering() && !rhs.hasBuffering()) || getBuffering() == rhs.getBuffering()) &&
        ((!hasCompression() && !rhs.hasCompression()) || getCompression() == rhs.getCompression()));
}

inline bool DoAudioOutputWriteStart::operator != (const DoAudioOutputWriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DoAudioOutputWriteStart::operator < (const DoAudioOutputWriteStart& rhs) const {
    if (hasBuffering() || rhs.hasBuffering()) {
        if ((uint32)getBuffering() < (uint32)rhs.getBuffering()) return true;
        if ((uint32)getBuffering() > (uint32)rhs.getBuffering()) return false;
    }
    if (hasCompression() || rhs.hasCompression()) {
        if (getCompression() < rhs.getCompression()) return true;
        if (getCompression() > rhs.getCompression()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoAudioOutputWriteStart::clone() {
    return new DoAudioOutputWriteStart(*this);
}

inline bool DoAudioOutputWriteStart::operator > (const DoAudioOutputWriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoAudioOutputWriteStart::clear() {
    clearBuffering();
    clearCompression();
}

inline void DoAudioOutputWriteStart::clearBuffering() {
    if (hasBuffering()) {
         clear_has_Buffering();
        _Buffering = ::sds_tts_fi_types::T_e8_BufferingOption__Unknown;
     }
}

inline bool DoAudioOutputWriteStart::hasBuffering () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sds_tts_fi_types::T_e8_BufferingOption DoAudioOutputWriteStart::getBuffering () const {
    return _Buffering;
}

inline void DoAudioOutputWriteStart::setBuffering (::sds_tts_fi_types::T_e8_BufferingOption Buffering_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_BufferingOption_IsValid(Buffering_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Buffering_, "T_e8_BufferingOption", "Buffering", "DoAudioOutputWriteStart");
    }
    #endif
    set_has_Buffering();
    this->_Buffering = Buffering_;
}

inline void DoAudioOutputWriteStart::clearCompression() {
    if (hasCompression()) {
         clear_has_Compression();
        _Compression = ::acr_fi_types::T_b8_AudioFormat ();
     }
}

inline bool DoAudioOutputWriteStart::hasCompression () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::acr_fi_types::T_b8_AudioFormat& DoAudioOutputWriteStart::getCompression () const {
    return _Compression;
}

inline ::acr_fi_types::T_b8_AudioFormat& DoAudioOutputWriteStart::getCompressionMutable () {
    set_has_Compression();
    return _Compression;
}

inline void DoAudioOutputWriteStart::setCompression (const ::acr_fi_types::T_b8_AudioFormat& Compression_) {
    set_has_Compression();
    this->_Compression = Compression_;
}

inline void DoAudioOutputWriteStart::set_has_Buffering () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoAudioOutputWriteStart::clear_has_Buffering () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DoAudioOutputWriteStart::set_has_Compression () {
    _has_bits_[0] |= 1u << 1;
}

inline void DoAudioOutputWriteStart::clear_has_Compression () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DoAudioOutputWriteResultFirst::DoAudioOutputWriteResultFirst ()  :
    _BufferingProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoAudioOutputWriteResultFirst::DoAudioOutputWriteResultFirst (const DoAudioOutputWriteResultFirst &rhs)  :
    ::asf::core::Payload(rhs),
    _BufferingProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoAudioOutputWriteResultFirst::DoAudioOutputWriteResultFirst (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_)  :
    _BufferingProgress (BufferingProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoAudioOutputWriteResultFirst::~DoAudioOutputWriteResultFirst() {
}

inline DoAudioOutputWriteResultFirst& DoAudioOutputWriteResultFirst::operator = (const DoAudioOutputWriteResultFirst& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBufferingProgress()) {
            setBufferingProgress(rhs.getBufferingProgress());
        } else {
            clearBufferingProgress();
        }
    }
    return *this;
}

inline bool DoAudioOutputWriteResultFirst::operator == (const DoAudioOutputWriteResultFirst& rhs) const {
    return (((!hasBufferingProgress() && !rhs.hasBufferingProgress()) || getBufferingProgress() == rhs.getBufferingProgress()));
}

inline bool DoAudioOutputWriteResultFirst::operator != (const DoAudioOutputWriteResultFirst& rhs) const {
    return ! (*this == rhs);
}

inline bool DoAudioOutputWriteResultFirst::operator < (const DoAudioOutputWriteResultFirst& rhs) const {
    if (hasBufferingProgress() || rhs.hasBufferingProgress()) {
        if (getBufferingProgress() < rhs.getBufferingProgress()) return true;
        if (getBufferingProgress() > rhs.getBufferingProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoAudioOutputWriteResultFirst::clone() {
    return new DoAudioOutputWriteResultFirst(*this);
}

inline bool DoAudioOutputWriteResultFirst::operator > (const DoAudioOutputWriteResultFirst& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoAudioOutputWriteResultFirst::clear() {
    clearBufferingProgress();
}

inline void DoAudioOutputWriteResultFirst::clearBufferingProgress() {
    if (hasBufferingProgress()) {
         clear_has_BufferingProgress();
        _BufferingProgress.clear();
     }
}

inline bool DoAudioOutputWriteResultFirst::hasBufferingProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& DoAudioOutputWriteResultFirst::getBufferingProgress () const {
    return _BufferingProgress;
}

inline ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& DoAudioOutputWriteResultFirst::getBufferingProgressMutable () {
    set_has_BufferingProgress();
    return _BufferingProgress;
}

inline void DoAudioOutputWriteResultFirst::setBufferingProgress (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_) {
    set_has_BufferingProgress();
    this->_BufferingProgress = BufferingProgress_;
}

inline void DoAudioOutputWriteResultFirst::set_has_BufferingProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoAudioOutputWriteResultFirst::clear_has_BufferingProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoAudioOutputWriteResultMiddle::DoAudioOutputWriteResultMiddle ()  :
    _BufferingProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoAudioOutputWriteResultMiddle::DoAudioOutputWriteResultMiddle (const DoAudioOutputWriteResultMiddle &rhs)  :
    ::asf::core::Payload(rhs),
    _BufferingProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoAudioOutputWriteResultMiddle::DoAudioOutputWriteResultMiddle (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_)  :
    _BufferingProgress (BufferingProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoAudioOutputWriteResultMiddle::~DoAudioOutputWriteResultMiddle() {
}

inline DoAudioOutputWriteResultMiddle& DoAudioOutputWriteResultMiddle::operator = (const DoAudioOutputWriteResultMiddle& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBufferingProgress()) {
            setBufferingProgress(rhs.getBufferingProgress());
        } else {
            clearBufferingProgress();
        }
    }
    return *this;
}

inline bool DoAudioOutputWriteResultMiddle::operator == (const DoAudioOutputWriteResultMiddle& rhs) const {
    return (((!hasBufferingProgress() && !rhs.hasBufferingProgress()) || getBufferingProgress() == rhs.getBufferingProgress()));
}

inline bool DoAudioOutputWriteResultMiddle::operator != (const DoAudioOutputWriteResultMiddle& rhs) const {
    return ! (*this == rhs);
}

inline bool DoAudioOutputWriteResultMiddle::operator < (const DoAudioOutputWriteResultMiddle& rhs) const {
    if (hasBufferingProgress() || rhs.hasBufferingProgress()) {
        if (getBufferingProgress() < rhs.getBufferingProgress()) return true;
        if (getBufferingProgress() > rhs.getBufferingProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoAudioOutputWriteResultMiddle::clone() {
    return new DoAudioOutputWriteResultMiddle(*this);
}

inline bool DoAudioOutputWriteResultMiddle::operator > (const DoAudioOutputWriteResultMiddle& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoAudioOutputWriteResultMiddle::clear() {
    clearBufferingProgress();
}

inline void DoAudioOutputWriteResultMiddle::clearBufferingProgress() {
    if (hasBufferingProgress()) {
         clear_has_BufferingProgress();
        _BufferingProgress.clear();
     }
}

inline bool DoAudioOutputWriteResultMiddle::hasBufferingProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& DoAudioOutputWriteResultMiddle::getBufferingProgress () const {
    return _BufferingProgress;
}

inline ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& DoAudioOutputWriteResultMiddle::getBufferingProgressMutable () {
    set_has_BufferingProgress();
    return _BufferingProgress;
}

inline void DoAudioOutputWriteResultMiddle::setBufferingProgress (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_) {
    set_has_BufferingProgress();
    this->_BufferingProgress = BufferingProgress_;
}

inline void DoAudioOutputWriteResultMiddle::set_has_BufferingProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoAudioOutputWriteResultMiddle::clear_has_BufferingProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoAudioOutputWriteResultLast::DoAudioOutputWriteResultLast ()  :
    _BufferingProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoAudioOutputWriteResultLast::DoAudioOutputWriteResultLast (const DoAudioOutputWriteResultLast &rhs)  :
    ::asf::core::Payload(rhs),
    _BufferingProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoAudioOutputWriteResultLast::DoAudioOutputWriteResultLast (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_)  :
    _BufferingProgress (BufferingProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoAudioOutputWriteResultLast::~DoAudioOutputWriteResultLast() {
}

inline DoAudioOutputWriteResultLast& DoAudioOutputWriteResultLast::operator = (const DoAudioOutputWriteResultLast& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBufferingProgress()) {
            setBufferingProgress(rhs.getBufferingProgress());
        } else {
            clearBufferingProgress();
        }
    }
    return *this;
}

inline bool DoAudioOutputWriteResultLast::operator == (const DoAudioOutputWriteResultLast& rhs) const {
    return (((!hasBufferingProgress() && !rhs.hasBufferingProgress()) || getBufferingProgress() == rhs.getBufferingProgress()));
}

inline bool DoAudioOutputWriteResultLast::operator != (const DoAudioOutputWriteResultLast& rhs) const {
    return ! (*this == rhs);
}

inline bool DoAudioOutputWriteResultLast::operator < (const DoAudioOutputWriteResultLast& rhs) const {
    if (hasBufferingProgress() || rhs.hasBufferingProgress()) {
        if (getBufferingProgress() < rhs.getBufferingProgress()) return true;
        if (getBufferingProgress() > rhs.getBufferingProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoAudioOutputWriteResultLast::clone() {
    return new DoAudioOutputWriteResultLast(*this);
}

inline bool DoAudioOutputWriteResultLast::operator > (const DoAudioOutputWriteResultLast& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoAudioOutputWriteResultLast::clear() {
    clearBufferingProgress();
}

inline void DoAudioOutputWriteResultLast::clearBufferingProgress() {
    if (hasBufferingProgress()) {
         clear_has_BufferingProgress();
        _BufferingProgress.clear();
     }
}

inline bool DoAudioOutputWriteResultLast::hasBufferingProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& DoAudioOutputWriteResultLast::getBufferingProgress () const {
    return _BufferingProgress;
}

inline ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& DoAudioOutputWriteResultLast::getBufferingProgressMutable () {
    set_has_BufferingProgress();
    return _BufferingProgress;
}

inline void DoAudioOutputWriteResultLast::setBufferingProgress (const ::std::vector< ::sds_tts_fi_types::T_BufferingProgress >& BufferingProgress_) {
    set_has_BufferingProgress();
    this->_BufferingProgress = BufferingProgress_;
}

inline void DoAudioOutputWriteResultLast::set_has_BufferingProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoAudioOutputWriteResultLast::clear_has_BufferingProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoSynthesisForSpeakWithExtentionStart::DoSynthesisForSpeakWithExtentionStart ()  :
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_AudioSourceID__Debug_Retrigger),
    _StatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo),
    _LastPackage (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoSynthesisForSpeakWithExtentionStart::DoSynthesisForSpeakWithExtentionStart (const DoSynthesisForSpeakWithExtentionStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_AudioSourceID__Debug_Retrigger),
    _StatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo),
    _LastPackage (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoSynthesisForSpeakWithExtentionStart::DoSynthesisForSpeakWithExtentionStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_AudioSourceID TextStyle_, ::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_, bool LastPackage_)  :
    _TextAndTags (TextAndTags_),
    _TextStyle (TextStyle_),
    _StatusInfo (StatusInfo_),
    _LastPackage (LastPackage_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_AudioSourceID_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_AudioSourceID", "TextStyle", "DoSynthesisForSpeakWithExtentionStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_StatusInfoOption_IsValid(StatusInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusInfo_, "T_e8_StatusInfoOption", "StatusInfo", "DoSynthesisForSpeakWithExtentionStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoSynthesisForSpeakWithExtentionStart::~DoSynthesisForSpeakWithExtentionStart() {
}

inline DoSynthesisForSpeakWithExtentionStart& DoSynthesisForSpeakWithExtentionStart::operator = (const DoSynthesisForSpeakWithExtentionStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTextAndTags()) {
            setTextAndTags(rhs.getTextAndTags());
        } else {
            clearTextAndTags();
        }
        if (rhs.hasTextStyle()) {
            setTextStyle(rhs.getTextStyle());
        } else {
            clearTextStyle();
        }
        if (rhs.hasStatusInfo()) {
            setStatusInfo(rhs.getStatusInfo());
        } else {
            clearStatusInfo();
        }
        if (rhs.hasLastPackage()) {
            setLastPackage(rhs.getLastPackage());
        } else {
            clearLastPackage();
        }
    }
    return *this;
}

inline bool DoSynthesisForSpeakWithExtentionStart::operator == (const DoSynthesisForSpeakWithExtentionStart& rhs) const {
    return (((!hasTextAndTags() && !rhs.hasTextAndTags()) || getTextAndTags() == rhs.getTextAndTags()) &&
        ((!hasTextStyle() && !rhs.hasTextStyle()) || getTextStyle() == rhs.getTextStyle()) &&
        ((!hasStatusInfo() && !rhs.hasStatusInfo()) || getStatusInfo() == rhs.getStatusInfo()) &&
        ((!hasLastPackage() && !rhs.hasLastPackage()) || getLastPackage() == rhs.getLastPackage()));
}

inline bool DoSynthesisForSpeakWithExtentionStart::operator != (const DoSynthesisForSpeakWithExtentionStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DoSynthesisForSpeakWithExtentionStart::operator < (const DoSynthesisForSpeakWithExtentionStart& rhs) const {
    if (hasTextAndTags() || rhs.hasTextAndTags()) {
        if (getTextAndTags() < rhs.getTextAndTags()) return true;
        if (getTextAndTags() > rhs.getTextAndTags()) return false;
    }
    if (hasTextStyle() || rhs.hasTextStyle()) {
        if ((uint32)getTextStyle() < (uint32)rhs.getTextStyle()) return true;
        if ((uint32)getTextStyle() > (uint32)rhs.getTextStyle()) return false;
    }
    if (hasStatusInfo() || rhs.hasStatusInfo()) {
        if ((uint32)getStatusInfo() < (uint32)rhs.getStatusInfo()) return true;
        if ((uint32)getStatusInfo() > (uint32)rhs.getStatusInfo()) return false;
    }
    if (hasLastPackage() || rhs.hasLastPackage()) {
        if (getLastPackage() < rhs.getLastPackage()) return true;
        if (getLastPackage() > rhs.getLastPackage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoSynthesisForSpeakWithExtentionStart::clone() {
    return new DoSynthesisForSpeakWithExtentionStart(*this);
}

inline bool DoSynthesisForSpeakWithExtentionStart::operator > (const DoSynthesisForSpeakWithExtentionStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoSynthesisForSpeakWithExtentionStart::clear() {
    clearTextAndTags();
    clearTextStyle();
    clearStatusInfo();
    clearLastPackage();
}

inline void DoSynthesisForSpeakWithExtentionStart::clearTextAndTags() {
    if (hasTextAndTags()) {
         clear_has_TextAndTags();
        _TextAndTags.clear();
     }
}

inline bool DoSynthesisForSpeakWithExtentionStart::hasTextAndTags () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DoSynthesisForSpeakWithExtentionStart::getTextAndTags () const {
    return _TextAndTags;
}

inline ::std::string& DoSynthesisForSpeakWithExtentionStart::getTextAndTagsMutable () {
    set_has_TextAndTags();
    return _TextAndTags;
}

inline void DoSynthesisForSpeakWithExtentionStart::setTextAndTags (const ::std::string& TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags = TextAndTags_;
}

inline void DoSynthesisForSpeakWithExtentionStart::setTextAndTags (const char* TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(TextAndTags_);
}

inline void DoSynthesisForSpeakWithExtentionStart::setTextAndTags (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(value, size);
}

inline void DoSynthesisForSpeakWithExtentionStart::clearTextStyle() {
    if (hasTextStyle()) {
         clear_has_TextStyle();
        _TextStyle = ::sds_tts_fi_types::T_e8_AudioSourceID__Debug_Retrigger;
     }
}

inline bool DoSynthesisForSpeakWithExtentionStart::hasTextStyle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sds_tts_fi_types::T_e8_AudioSourceID DoSynthesisForSpeakWithExtentionStart::getTextStyle () const {
    return _TextStyle;
}

inline void DoSynthesisForSpeakWithExtentionStart::setTextStyle (::sds_tts_fi_types::T_e8_AudioSourceID TextStyle_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_AudioSourceID_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_AudioSourceID", "TextStyle", "DoSynthesisForSpeakWithExtentionStart");
    }
    #endif
    set_has_TextStyle();
    this->_TextStyle = TextStyle_;
}

inline void DoSynthesisForSpeakWithExtentionStart::clearStatusInfo() {
    if (hasStatusInfo()) {
         clear_has_StatusInfo();
        _StatusInfo = ::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo;
     }
}

inline bool DoSynthesisForSpeakWithExtentionStart::hasStatusInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::sds_tts_fi_types::T_e8_StatusInfoOption DoSynthesisForSpeakWithExtentionStart::getStatusInfo () const {
    return _StatusInfo;
}

inline void DoSynthesisForSpeakWithExtentionStart::setStatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_StatusInfoOption_IsValid(StatusInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusInfo_, "T_e8_StatusInfoOption", "StatusInfo", "DoSynthesisForSpeakWithExtentionStart");
    }
    #endif
    set_has_StatusInfo();
    this->_StatusInfo = StatusInfo_;
}

inline void DoSynthesisForSpeakWithExtentionStart::clearLastPackage() {
    if (hasLastPackage()) {
         clear_has_LastPackage();
        _LastPackage = false;
     }
}

inline bool DoSynthesisForSpeakWithExtentionStart::hasLastPackage () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool DoSynthesisForSpeakWithExtentionStart::getLastPackage () const {
    return _LastPackage;
}

inline void DoSynthesisForSpeakWithExtentionStart::setLastPackage (bool LastPackage_) {
    set_has_LastPackage();
    this->_LastPackage = LastPackage_;
}

inline void DoSynthesisForSpeakWithExtentionStart::set_has_TextAndTags () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoSynthesisForSpeakWithExtentionStart::clear_has_TextAndTags () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DoSynthesisForSpeakWithExtentionStart::set_has_TextStyle () {
    _has_bits_[0] |= 1u << 1;
}

inline void DoSynthesisForSpeakWithExtentionStart::clear_has_TextStyle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DoSynthesisForSpeakWithExtentionStart::set_has_StatusInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void DoSynthesisForSpeakWithExtentionStart::clear_has_StatusInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DoSynthesisForSpeakWithExtentionStart::set_has_LastPackage () {
    _has_bits_[0] |= 1u << 3;
}

inline void DoSynthesisForSpeakWithExtentionStart::clear_has_LastPackage () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  DoReleaseDataStart::DoReleaseDataStart ()  :
    _ReleaseType (::sds_tts_fi_types::T_e8_ReleaseTypeTTS__VoiceChange)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoReleaseDataStart::DoReleaseDataStart (const DoReleaseDataStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ReleaseType (::sds_tts_fi_types::T_e8_ReleaseTypeTTS__VoiceChange)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoReleaseDataStart::DoReleaseDataStart (::sds_tts_fi_types::T_e8_ReleaseTypeTTS ReleaseType_)  :
    _ReleaseType (ReleaseType_)
{
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_ReleaseTypeTTS_IsValid(ReleaseType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ReleaseType_, "T_e8_ReleaseTypeTTS", "ReleaseType", "DoReleaseDataStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoReleaseDataStart::~DoReleaseDataStart() {
}

inline DoReleaseDataStart& DoReleaseDataStart::operator = (const DoReleaseDataStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasReleaseType()) {
            setReleaseType(rhs.getReleaseType());
        } else {
            clearReleaseType();
        }
    }
    return *this;
}

inline bool DoReleaseDataStart::operator == (const DoReleaseDataStart& rhs) const {
    return (((!hasReleaseType() && !rhs.hasReleaseType()) || getReleaseType() == rhs.getReleaseType()));
}

inline bool DoReleaseDataStart::operator != (const DoReleaseDataStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DoReleaseDataStart::operator < (const DoReleaseDataStart& rhs) const {
    if (hasReleaseType() || rhs.hasReleaseType()) {
        if ((uint32)getReleaseType() < (uint32)rhs.getReleaseType()) return true;
        if ((uint32)getReleaseType() > (uint32)rhs.getReleaseType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoReleaseDataStart::clone() {
    return new DoReleaseDataStart(*this);
}

inline bool DoReleaseDataStart::operator > (const DoReleaseDataStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoReleaseDataStart::clear() {
    clearReleaseType();
}

inline void DoReleaseDataStart::clearReleaseType() {
    if (hasReleaseType()) {
         clear_has_ReleaseType();
        _ReleaseType = ::sds_tts_fi_types::T_e8_ReleaseTypeTTS__VoiceChange;
     }
}

inline bool DoReleaseDataStart::hasReleaseType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sds_tts_fi_types::T_e8_ReleaseTypeTTS DoReleaseDataStart::getReleaseType () const {
    return _ReleaseType;
}

inline void DoReleaseDataStart::setReleaseType (::sds_tts_fi_types::T_e8_ReleaseTypeTTS ReleaseType_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_ReleaseTypeTTS_IsValid(ReleaseType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ReleaseType_, "T_e8_ReleaseTypeTTS", "ReleaseType", "DoReleaseDataStart");
    }
    #endif
    set_has_ReleaseType();
    this->_ReleaseType = ReleaseType_;
}

inline void DoReleaseDataStart::set_has_ReleaseType () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoReleaseDataStart::clear_has_ReleaseType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoReleaseDataError::DoReleaseDataError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::DoReleaseDataErrorCode__Unspecified;
}

inline  DoReleaseDataError::DoReleaseDataError (const DoReleaseDataError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::DoReleaseDataErrorCode__Unspecified;
    *this = rhs;
}

inline  DoReleaseDataError::~DoReleaseDataError() {
    deleteData ();
}

inline DoReleaseDataError& DoReleaseDataError::operator = (const DoReleaseDataError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool DoReleaseDataError::operator == (const DoReleaseDataError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool DoReleaseDataError::operator != (const DoReleaseDataError& rhs) const {
    return ! (*this == rhs);
}

inline bool DoReleaseDataError::operator < (const DoReleaseDataError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool DoReleaseDataError::operator > (const DoReleaseDataError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline DoReleaseDataError::DoReleaseDataErrorField DoReleaseDataError::getField () const {
    return __field;
}

inline void DoReleaseDataError::setField(DoReleaseDataError::DoReleaseDataErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::DoReleaseDataErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* DoReleaseDataError::clone() {
    return new DoReleaseDataError(*this);
}

inline bool DoReleaseDataError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline DoReleaseDataErrorCode DoReleaseDataError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "DoReleaseDataError", getField());
    }
    return (DoReleaseDataErrorCode) _data.ccaErrorCode_;
}

inline void DoReleaseDataError::setCcaErrorCode (DoReleaseDataErrorCode value) {
    #ifndef NDEBUG
    if (!(DoReleaseDataErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "DoReleaseDataErrorCode", "ccaErrorCode", "DoReleaseDataError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool DoReleaseDataError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode DoReleaseDataError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "DoReleaseDataError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void DoReleaseDataError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "DoReleaseDataError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void DoReleaseDataError::cloneData (const DoReleaseDataError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void DoReleaseDataError::deleteData () {
}

inline  DoRequestPhonemeStart::DoRequestPhonemeStart ()  :
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_TextStyleOption__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoRequestPhonemeStart::DoRequestPhonemeStart (const DoRequestPhonemeStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TextAndTags (),
    _TextStyle (::sds_tts_fi_types::T_e8_TextStyleOption__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoRequestPhonemeStart::DoRequestPhonemeStart (const ::std::string& TextAndTags_, ::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_)  :
    _TextAndTags (TextAndTags_),
    _TextStyle (TextStyle_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TextStyleOption_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_TextStyleOption", "TextStyle", "DoRequestPhonemeStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoRequestPhonemeStart::~DoRequestPhonemeStart() {
}

inline DoRequestPhonemeStart& DoRequestPhonemeStart::operator = (const DoRequestPhonemeStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTextAndTags()) {
            setTextAndTags(rhs.getTextAndTags());
        } else {
            clearTextAndTags();
        }
        if (rhs.hasTextStyle()) {
            setTextStyle(rhs.getTextStyle());
        } else {
            clearTextStyle();
        }
    }
    return *this;
}

inline bool DoRequestPhonemeStart::operator == (const DoRequestPhonemeStart& rhs) const {
    return (((!hasTextAndTags() && !rhs.hasTextAndTags()) || getTextAndTags() == rhs.getTextAndTags()) &&
        ((!hasTextStyle() && !rhs.hasTextStyle()) || getTextStyle() == rhs.getTextStyle()));
}

inline bool DoRequestPhonemeStart::operator != (const DoRequestPhonemeStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DoRequestPhonemeStart::operator < (const DoRequestPhonemeStart& rhs) const {
    if (hasTextAndTags() || rhs.hasTextAndTags()) {
        if (getTextAndTags() < rhs.getTextAndTags()) return true;
        if (getTextAndTags() > rhs.getTextAndTags()) return false;
    }
    if (hasTextStyle() || rhs.hasTextStyle()) {
        if ((uint32)getTextStyle() < (uint32)rhs.getTextStyle()) return true;
        if ((uint32)getTextStyle() > (uint32)rhs.getTextStyle()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoRequestPhonemeStart::clone() {
    return new DoRequestPhonemeStart(*this);
}

inline bool DoRequestPhonemeStart::operator > (const DoRequestPhonemeStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoRequestPhonemeStart::clear() {
    clearTextAndTags();
    clearTextStyle();
}

inline void DoRequestPhonemeStart::clearTextAndTags() {
    if (hasTextAndTags()) {
         clear_has_TextAndTags();
        _TextAndTags.clear();
     }
}

inline bool DoRequestPhonemeStart::hasTextAndTags () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DoRequestPhonemeStart::getTextAndTags () const {
    return _TextAndTags;
}

inline ::std::string& DoRequestPhonemeStart::getTextAndTagsMutable () {
    set_has_TextAndTags();
    return _TextAndTags;
}

inline void DoRequestPhonemeStart::setTextAndTags (const ::std::string& TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags = TextAndTags_;
}

inline void DoRequestPhonemeStart::setTextAndTags (const char* TextAndTags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextAndTags_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(TextAndTags_);
}

inline void DoRequestPhonemeStart::setTextAndTags (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TextAndTags();
    this->_TextAndTags.assign(value, size);
}

inline void DoRequestPhonemeStart::clearTextStyle() {
    if (hasTextStyle()) {
         clear_has_TextStyle();
        _TextStyle = ::sds_tts_fi_types::T_e8_TextStyleOption__Unknown;
     }
}

inline bool DoRequestPhonemeStart::hasTextStyle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sds_tts_fi_types::T_e8_TextStyleOption DoRequestPhonemeStart::getTextStyle () const {
    return _TextStyle;
}

inline void DoRequestPhonemeStart::setTextStyle (::sds_tts_fi_types::T_e8_TextStyleOption TextStyle_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TextStyleOption_IsValid(TextStyle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TextStyle_, "T_e8_TextStyleOption", "TextStyle", "DoRequestPhonemeStart");
    }
    #endif
    set_has_TextStyle();
    this->_TextStyle = TextStyle_;
}

inline void DoRequestPhonemeStart::set_has_TextAndTags () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoRequestPhonemeStart::clear_has_TextAndTags () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DoRequestPhonemeStart::set_has_TextStyle () {
    _has_bits_[0] |= 1u << 1;
}

inline void DoRequestPhonemeStart::clear_has_TextStyle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DoRequestPhonemeResult::DoRequestPhonemeResult ()  :
    _PhonemeList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoRequestPhonemeResult::DoRequestPhonemeResult (const DoRequestPhonemeResult &rhs)  :
    ::asf::core::Payload(rhs),
    _PhonemeList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoRequestPhonemeResult::DoRequestPhonemeResult (const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& PhonemeList_)  :
    _PhonemeList (PhonemeList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoRequestPhonemeResult::~DoRequestPhonemeResult() {
}

inline DoRequestPhonemeResult& DoRequestPhonemeResult::operator = (const DoRequestPhonemeResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhonemeList()) {
            setPhonemeList(rhs.getPhonemeList());
        } else {
            clearPhonemeList();
        }
    }
    return *this;
}

inline bool DoRequestPhonemeResult::operator == (const DoRequestPhonemeResult& rhs) const {
    return (((!hasPhonemeList() && !rhs.hasPhonemeList()) || getPhonemeList() == rhs.getPhonemeList()));
}

inline bool DoRequestPhonemeResult::operator != (const DoRequestPhonemeResult& rhs) const {
    return ! (*this == rhs);
}

inline bool DoRequestPhonemeResult::operator < (const DoRequestPhonemeResult& rhs) const {
    if (hasPhonemeList() || rhs.hasPhonemeList()) {
        if (getPhonemeList() < rhs.getPhonemeList()) return true;
        if (getPhonemeList() > rhs.getPhonemeList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoRequestPhonemeResult::clone() {
    return new DoRequestPhonemeResult(*this);
}

inline bool DoRequestPhonemeResult::operator > (const DoRequestPhonemeResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoRequestPhonemeResult::clear() {
    clearPhonemeList();
}

inline void DoRequestPhonemeResult::clearPhonemeList() {
    if (hasPhonemeList()) {
         clear_has_PhonemeList();
        _PhonemeList.clear();
     }
}

inline bool DoRequestPhonemeResult::hasPhonemeList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& DoRequestPhonemeResult::getPhonemeList () const {
    return _PhonemeList;
}

inline ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& DoRequestPhonemeResult::getPhonemeListMutable () {
    set_has_PhonemeList();
    return _PhonemeList;
}

inline void DoRequestPhonemeResult::setPhonemeList (const ::std::vector< ::sds_tts_fi_types::T_TTSPhonemeResult >& PhonemeList_) {
    set_has_PhonemeList();
    this->_PhonemeList = PhonemeList_;
}

inline void DoRequestPhonemeResult::set_has_PhonemeList () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoRequestPhonemeResult::clear_has_PhonemeList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoRequestPhonemeError::DoRequestPhonemeError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::DoRequestPhonemeErrorCode__Unspecified;
}

inline  DoRequestPhonemeError::DoRequestPhonemeError (const DoRequestPhonemeError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::DoRequestPhonemeErrorCode__Unspecified;
    *this = rhs;
}

inline  DoRequestPhonemeError::~DoRequestPhonemeError() {
    deleteData ();
}

inline DoRequestPhonemeError& DoRequestPhonemeError::operator = (const DoRequestPhonemeError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool DoRequestPhonemeError::operator == (const DoRequestPhonemeError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool DoRequestPhonemeError::operator != (const DoRequestPhonemeError& rhs) const {
    return ! (*this == rhs);
}

inline bool DoRequestPhonemeError::operator < (const DoRequestPhonemeError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool DoRequestPhonemeError::operator > (const DoRequestPhonemeError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline DoRequestPhonemeError::DoRequestPhonemeErrorField DoRequestPhonemeError::getField () const {
    return __field;
}

inline void DoRequestPhonemeError::setField(DoRequestPhonemeError::DoRequestPhonemeErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::DoRequestPhonemeErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* DoRequestPhonemeError::clone() {
    return new DoRequestPhonemeError(*this);
}

inline bool DoRequestPhonemeError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline DoRequestPhonemeErrorCode DoRequestPhonemeError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "DoRequestPhonemeError", getField());
    }
    return (DoRequestPhonemeErrorCode) _data.ccaErrorCode_;
}

inline void DoRequestPhonemeError::setCcaErrorCode (DoRequestPhonemeErrorCode value) {
    #ifndef NDEBUG
    if (!(DoRequestPhonemeErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "DoRequestPhonemeErrorCode", "ccaErrorCode", "DoRequestPhonemeError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool DoRequestPhonemeError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode DoRequestPhonemeError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "DoRequestPhonemeError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void DoRequestPhonemeError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "DoRequestPhonemeError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void DoRequestPhonemeError::cloneData (const DoRequestPhonemeError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void DoRequestPhonemeError::deleteData () {
}

inline  DoAudioOutputSpeakWithExtensionStart::DoAudioOutputSpeakWithExtensionStart ()  :
    _StatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo),
    _AudioOutputLocation ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakWithExtensionStart::DoAudioOutputSpeakWithExtensionStart (const DoAudioOutputSpeakWithExtensionStart &rhs)  :
    ::asf::core::Payload(rhs),
    _StatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo),
    _AudioOutputLocation ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoAudioOutputSpeakWithExtensionStart::DoAudioOutputSpeakWithExtensionStart (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_, const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_)  :
    _StatusInfo (StatusInfo_),
    _AudioOutputLocation (AudioOutputLocation_)
{
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_StatusInfoOption_IsValid(StatusInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusInfo_, "T_e8_StatusInfoOption", "StatusInfo", "DoAudioOutputSpeakWithExtensionStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakWithExtensionStart::~DoAudioOutputSpeakWithExtensionStart() {
}

inline DoAudioOutputSpeakWithExtensionStart& DoAudioOutputSpeakWithExtensionStart::operator = (const DoAudioOutputSpeakWithExtensionStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatusInfo()) {
            setStatusInfo(rhs.getStatusInfo());
        } else {
            clearStatusInfo();
        }
        if (rhs.hasAudioOutputLocation()) {
            setAudioOutputLocation(rhs.getAudioOutputLocation());
        } else {
            clearAudioOutputLocation();
        }
    }
    return *this;
}

inline bool DoAudioOutputSpeakWithExtensionStart::operator == (const DoAudioOutputSpeakWithExtensionStart& rhs) const {
    return (((!hasStatusInfo() && !rhs.hasStatusInfo()) || getStatusInfo() == rhs.getStatusInfo()) &&
        ((!hasAudioOutputLocation() && !rhs.hasAudioOutputLocation()) || getAudioOutputLocation() == rhs.getAudioOutputLocation()));
}

inline bool DoAudioOutputSpeakWithExtensionStart::operator != (const DoAudioOutputSpeakWithExtensionStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DoAudioOutputSpeakWithExtensionStart::operator < (const DoAudioOutputSpeakWithExtensionStart& rhs) const {
    if (hasStatusInfo() || rhs.hasStatusInfo()) {
        if ((uint32)getStatusInfo() < (uint32)rhs.getStatusInfo()) return true;
        if ((uint32)getStatusInfo() > (uint32)rhs.getStatusInfo()) return false;
    }
    if (hasAudioOutputLocation() || rhs.hasAudioOutputLocation()) {
        if (getAudioOutputLocation() < rhs.getAudioOutputLocation()) return true;
        if (getAudioOutputLocation() > rhs.getAudioOutputLocation()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoAudioOutputSpeakWithExtensionStart::clone() {
    return new DoAudioOutputSpeakWithExtensionStart(*this);
}

inline bool DoAudioOutputSpeakWithExtensionStart::operator > (const DoAudioOutputSpeakWithExtensionStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoAudioOutputSpeakWithExtensionStart::clear() {
    clearStatusInfo();
    clearAudioOutputLocation();
}

inline void DoAudioOutputSpeakWithExtensionStart::clearStatusInfo() {
    if (hasStatusInfo()) {
         clear_has_StatusInfo();
        _StatusInfo = ::sds_tts_fi_types::T_e8_StatusInfoOption__NoInfo;
     }
}

inline bool DoAudioOutputSpeakWithExtensionStart::hasStatusInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sds_tts_fi_types::T_e8_StatusInfoOption DoAudioOutputSpeakWithExtensionStart::getStatusInfo () const {
    return _StatusInfo;
}

inline void DoAudioOutputSpeakWithExtensionStart::setStatusInfo (::sds_tts_fi_types::T_e8_StatusInfoOption StatusInfo_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_StatusInfoOption_IsValid(StatusInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusInfo_, "T_e8_StatusInfoOption", "StatusInfo", "DoAudioOutputSpeakWithExtensionStart");
    }
    #endif
    set_has_StatusInfo();
    this->_StatusInfo = StatusInfo_;
}

inline void DoAudioOutputSpeakWithExtensionStart::clearAudioOutputLocation() {
    if (hasAudioOutputLocation()) {
         clear_has_AudioOutputLocation();
        _AudioOutputLocation = ::acr_fi_types::T_b8_AudioOutputLocation ();
     }
}

inline bool DoAudioOutputSpeakWithExtensionStart::hasAudioOutputLocation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::acr_fi_types::T_b8_AudioOutputLocation& DoAudioOutputSpeakWithExtensionStart::getAudioOutputLocation () const {
    return _AudioOutputLocation;
}

inline ::acr_fi_types::T_b8_AudioOutputLocation& DoAudioOutputSpeakWithExtensionStart::getAudioOutputLocationMutable () {
    set_has_AudioOutputLocation();
    return _AudioOutputLocation;
}

inline void DoAudioOutputSpeakWithExtensionStart::setAudioOutputLocation (const ::acr_fi_types::T_b8_AudioOutputLocation& AudioOutputLocation_) {
    set_has_AudioOutputLocation();
    this->_AudioOutputLocation = AudioOutputLocation_;
}

inline void DoAudioOutputSpeakWithExtensionStart::set_has_StatusInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoAudioOutputSpeakWithExtensionStart::clear_has_StatusInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DoAudioOutputSpeakWithExtensionStart::set_has_AudioOutputLocation () {
    _has_bits_[0] |= 1u << 1;
}

inline void DoAudioOutputSpeakWithExtensionStart::clear_has_AudioOutputLocation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DoAudioOutputSpeakWithExtensionResultFirst::DoAudioOutputSpeakWithExtensionResultFirst ()  :
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakWithExtensionResultFirst::DoAudioOutputSpeakWithExtensionResultFirst (const DoAudioOutputSpeakWithExtensionResultFirst &rhs)  :
    ::asf::core::Payload(rhs),
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoAudioOutputSpeakWithExtensionResultFirst::DoAudioOutputSpeakWithExtensionResultFirst (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_)  :
    _JobProgress (JobProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakWithExtensionResultFirst::~DoAudioOutputSpeakWithExtensionResultFirst() {
}

inline DoAudioOutputSpeakWithExtensionResultFirst& DoAudioOutputSpeakWithExtensionResultFirst::operator = (const DoAudioOutputSpeakWithExtensionResultFirst& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobProgress()) {
            setJobProgress(rhs.getJobProgress());
        } else {
            clearJobProgress();
        }
    }
    return *this;
}

inline bool DoAudioOutputSpeakWithExtensionResultFirst::operator == (const DoAudioOutputSpeakWithExtensionResultFirst& rhs) const {
    return (((!hasJobProgress() && !rhs.hasJobProgress()) || getJobProgress() == rhs.getJobProgress()));
}

inline bool DoAudioOutputSpeakWithExtensionResultFirst::operator != (const DoAudioOutputSpeakWithExtensionResultFirst& rhs) const {
    return ! (*this == rhs);
}

inline bool DoAudioOutputSpeakWithExtensionResultFirst::operator < (const DoAudioOutputSpeakWithExtensionResultFirst& rhs) const {
    if (hasJobProgress() || rhs.hasJobProgress()) {
        if (getJobProgress() < rhs.getJobProgress()) return true;
        if (getJobProgress() > rhs.getJobProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoAudioOutputSpeakWithExtensionResultFirst::clone() {
    return new DoAudioOutputSpeakWithExtensionResultFirst(*this);
}

inline bool DoAudioOutputSpeakWithExtensionResultFirst::operator > (const DoAudioOutputSpeakWithExtensionResultFirst& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoAudioOutputSpeakWithExtensionResultFirst::clear() {
    clearJobProgress();
}

inline void DoAudioOutputSpeakWithExtensionResultFirst::clearJobProgress() {
    if (hasJobProgress()) {
         clear_has_JobProgress();
        _JobProgress.clear();
     }
}

inline bool DoAudioOutputSpeakWithExtensionResultFirst::hasJobProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_tts_fi_types::T_SpeakProgress& DoAudioOutputSpeakWithExtensionResultFirst::getJobProgress () const {
    return _JobProgress;
}

inline ::sds_tts_fi_types::T_SpeakProgress& DoAudioOutputSpeakWithExtensionResultFirst::getJobProgressMutable () {
    set_has_JobProgress();
    return _JobProgress;
}

inline void DoAudioOutputSpeakWithExtensionResultFirst::setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_) {
    set_has_JobProgress();
    this->_JobProgress = JobProgress_;
}

inline void DoAudioOutputSpeakWithExtensionResultFirst::set_has_JobProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoAudioOutputSpeakWithExtensionResultFirst::clear_has_JobProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoAudioOutputSpeakWithExtensionResultMiddle::DoAudioOutputSpeakWithExtensionResultMiddle ()  :
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakWithExtensionResultMiddle::DoAudioOutputSpeakWithExtensionResultMiddle (const DoAudioOutputSpeakWithExtensionResultMiddle &rhs)  :
    ::asf::core::Payload(rhs),
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoAudioOutputSpeakWithExtensionResultMiddle::DoAudioOutputSpeakWithExtensionResultMiddle (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_)  :
    _JobProgress (JobProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakWithExtensionResultMiddle::~DoAudioOutputSpeakWithExtensionResultMiddle() {
}

inline DoAudioOutputSpeakWithExtensionResultMiddle& DoAudioOutputSpeakWithExtensionResultMiddle::operator = (const DoAudioOutputSpeakWithExtensionResultMiddle& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobProgress()) {
            setJobProgress(rhs.getJobProgress());
        } else {
            clearJobProgress();
        }
    }
    return *this;
}

inline bool DoAudioOutputSpeakWithExtensionResultMiddle::operator == (const DoAudioOutputSpeakWithExtensionResultMiddle& rhs) const {
    return (((!hasJobProgress() && !rhs.hasJobProgress()) || getJobProgress() == rhs.getJobProgress()));
}

inline bool DoAudioOutputSpeakWithExtensionResultMiddle::operator != (const DoAudioOutputSpeakWithExtensionResultMiddle& rhs) const {
    return ! (*this == rhs);
}

inline bool DoAudioOutputSpeakWithExtensionResultMiddle::operator < (const DoAudioOutputSpeakWithExtensionResultMiddle& rhs) const {
    if (hasJobProgress() || rhs.hasJobProgress()) {
        if (getJobProgress() < rhs.getJobProgress()) return true;
        if (getJobProgress() > rhs.getJobProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoAudioOutputSpeakWithExtensionResultMiddle::clone() {
    return new DoAudioOutputSpeakWithExtensionResultMiddle(*this);
}

inline bool DoAudioOutputSpeakWithExtensionResultMiddle::operator > (const DoAudioOutputSpeakWithExtensionResultMiddle& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoAudioOutputSpeakWithExtensionResultMiddle::clear() {
    clearJobProgress();
}

inline void DoAudioOutputSpeakWithExtensionResultMiddle::clearJobProgress() {
    if (hasJobProgress()) {
         clear_has_JobProgress();
        _JobProgress.clear();
     }
}

inline bool DoAudioOutputSpeakWithExtensionResultMiddle::hasJobProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_tts_fi_types::T_SpeakProgress& DoAudioOutputSpeakWithExtensionResultMiddle::getJobProgress () const {
    return _JobProgress;
}

inline ::sds_tts_fi_types::T_SpeakProgress& DoAudioOutputSpeakWithExtensionResultMiddle::getJobProgressMutable () {
    set_has_JobProgress();
    return _JobProgress;
}

inline void DoAudioOutputSpeakWithExtensionResultMiddle::setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_) {
    set_has_JobProgress();
    this->_JobProgress = JobProgress_;
}

inline void DoAudioOutputSpeakWithExtensionResultMiddle::set_has_JobProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoAudioOutputSpeakWithExtensionResultMiddle::clear_has_JobProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoAudioOutputSpeakWithExtensionResultLast::DoAudioOutputSpeakWithExtensionResultLast ()  :
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakWithExtensionResultLast::DoAudioOutputSpeakWithExtensionResultLast (const DoAudioOutputSpeakWithExtensionResultLast &rhs)  :
    ::asf::core::Payload(rhs),
    _JobProgress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoAudioOutputSpeakWithExtensionResultLast::DoAudioOutputSpeakWithExtensionResultLast (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_)  :
    _JobProgress (JobProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoAudioOutputSpeakWithExtensionResultLast::~DoAudioOutputSpeakWithExtensionResultLast() {
}

inline DoAudioOutputSpeakWithExtensionResultLast& DoAudioOutputSpeakWithExtensionResultLast::operator = (const DoAudioOutputSpeakWithExtensionResultLast& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJobProgress()) {
            setJobProgress(rhs.getJobProgress());
        } else {
            clearJobProgress();
        }
    }
    return *this;
}

inline bool DoAudioOutputSpeakWithExtensionResultLast::operator == (const DoAudioOutputSpeakWithExtensionResultLast& rhs) const {
    return (((!hasJobProgress() && !rhs.hasJobProgress()) || getJobProgress() == rhs.getJobProgress()));
}

inline bool DoAudioOutputSpeakWithExtensionResultLast::operator != (const DoAudioOutputSpeakWithExtensionResultLast& rhs) const {
    return ! (*this == rhs);
}

inline bool DoAudioOutputSpeakWithExtensionResultLast::operator < (const DoAudioOutputSpeakWithExtensionResultLast& rhs) const {
    if (hasJobProgress() || rhs.hasJobProgress()) {
        if (getJobProgress() < rhs.getJobProgress()) return true;
        if (getJobProgress() > rhs.getJobProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoAudioOutputSpeakWithExtensionResultLast::clone() {
    return new DoAudioOutputSpeakWithExtensionResultLast(*this);
}

inline bool DoAudioOutputSpeakWithExtensionResultLast::operator > (const DoAudioOutputSpeakWithExtensionResultLast& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoAudioOutputSpeakWithExtensionResultLast::clear() {
    clearJobProgress();
}

inline void DoAudioOutputSpeakWithExtensionResultLast::clearJobProgress() {
    if (hasJobProgress()) {
         clear_has_JobProgress();
        _JobProgress.clear();
     }
}

inline bool DoAudioOutputSpeakWithExtensionResultLast::hasJobProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_tts_fi_types::T_SpeakProgress& DoAudioOutputSpeakWithExtensionResultLast::getJobProgress () const {
    return _JobProgress;
}

inline ::sds_tts_fi_types::T_SpeakProgress& DoAudioOutputSpeakWithExtensionResultLast::getJobProgressMutable () {
    set_has_JobProgress();
    return _JobProgress;
}

inline void DoAudioOutputSpeakWithExtensionResultLast::setJobProgress (const ::sds_tts_fi_types::T_SpeakProgress& JobProgress_) {
    set_has_JobProgress();
    this->_JobProgress = JobProgress_;
}

inline void DoAudioOutputSpeakWithExtensionResultLast::set_has_JobProgress () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoAudioOutputSpeakWithExtensionResultLast::clear_has_JobProgress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VoiceStatus::VoiceStatus ()  :
    _TTSVoice ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VoiceStatus::VoiceStatus (const VoiceStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _TTSVoice ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VoiceStatus::VoiceStatus (const ::sds_tts_fi_types::T_TTSVoiceInfo& TTSVoice_)  :
    _TTSVoice (TTSVoice_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VoiceStatus::~VoiceStatus() {
}

inline VoiceStatus& VoiceStatus::operator = (const VoiceStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTTSVoice()) {
            setTTSVoice(rhs.getTTSVoice());
        } else {
            clearTTSVoice();
        }
    }
    return *this;
}

inline bool VoiceStatus::operator == (const VoiceStatus& rhs) const {
    return (((!hasTTSVoice() && !rhs.hasTTSVoice()) || getTTSVoice() == rhs.getTTSVoice()));
}

inline bool VoiceStatus::operator != (const VoiceStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool VoiceStatus::operator < (const VoiceStatus& rhs) const {
    if (hasTTSVoice() || rhs.hasTTSVoice()) {
        if (getTTSVoice() < rhs.getTTSVoice()) return true;
        if (getTTSVoice() > rhs.getTTSVoice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VoiceStatus::clone() {
    return new VoiceStatus(*this);
}

inline bool VoiceStatus::operator > (const VoiceStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VoiceStatus::clear() {
    clearTTSVoice();
}

inline void VoiceStatus::clearTTSVoice() {
    if (hasTTSVoice()) {
         clear_has_TTSVoice();
        _TTSVoice.clear();
     }
}

inline bool VoiceStatus::hasTTSVoice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_tts_fi_types::T_TTSVoiceInfo& VoiceStatus::getTTSVoice () const {
    return _TTSVoice;
}

inline ::sds_tts_fi_types::T_TTSVoiceInfo& VoiceStatus::getTTSVoiceMutable () {
    set_has_TTSVoice();
    return _TTSVoice;
}

inline void VoiceStatus::setTTSVoice (const ::sds_tts_fi_types::T_TTSVoiceInfo& TTSVoice_) {
    set_has_TTSVoice();
    this->_TTSVoice = TTSVoice_;
}

inline void VoiceStatus::set_has_TTSVoice () {
    _has_bits_[0] |= 1u << 0;
}

inline void VoiceStatus::clear_has_TTSVoice () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AvailableVoicesStatus::AvailableVoicesStatus ()  :
    _AvailableTTSVoices ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AvailableVoicesStatus::AvailableVoicesStatus (const AvailableVoicesStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _AvailableTTSVoices ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AvailableVoicesStatus::AvailableVoicesStatus (const ::sds_tts_fi_types::T_AvailableTTSVoices& AvailableTTSVoices_)  :
    _AvailableTTSVoices (AvailableTTSVoices_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AvailableVoicesStatus::~AvailableVoicesStatus() {
}

inline AvailableVoicesStatus& AvailableVoicesStatus::operator = (const AvailableVoicesStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAvailableTTSVoices()) {
            setAvailableTTSVoices(rhs.getAvailableTTSVoices());
        } else {
            clearAvailableTTSVoices();
        }
    }
    return *this;
}

inline bool AvailableVoicesStatus::operator == (const AvailableVoicesStatus& rhs) const {
    return (((!hasAvailableTTSVoices() && !rhs.hasAvailableTTSVoices()) || getAvailableTTSVoices() == rhs.getAvailableTTSVoices()));
}

inline bool AvailableVoicesStatus::operator != (const AvailableVoicesStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool AvailableVoicesStatus::operator < (const AvailableVoicesStatus& rhs) const {
    if (hasAvailableTTSVoices() || rhs.hasAvailableTTSVoices()) {
        if (getAvailableTTSVoices() < rhs.getAvailableTTSVoices()) return true;
        if (getAvailableTTSVoices() > rhs.getAvailableTTSVoices()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AvailableVoicesStatus::clone() {
    return new AvailableVoicesStatus(*this);
}

inline bool AvailableVoicesStatus::operator > (const AvailableVoicesStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AvailableVoicesStatus::clear() {
    clearAvailableTTSVoices();
}

inline void AvailableVoicesStatus::clearAvailableTTSVoices() {
    if (hasAvailableTTSVoices()) {
         clear_has_AvailableTTSVoices();
        _AvailableTTSVoices.clear();
     }
}

inline bool AvailableVoicesStatus::hasAvailableTTSVoices () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_tts_fi_types::T_AvailableTTSVoices& AvailableVoicesStatus::getAvailableTTSVoices () const {
    return _AvailableTTSVoices;
}

inline ::sds_tts_fi_types::T_AvailableTTSVoices& AvailableVoicesStatus::getAvailableTTSVoicesMutable () {
    set_has_AvailableTTSVoices();
    return _AvailableTTSVoices;
}

inline void AvailableVoicesStatus::setAvailableTTSVoices (const ::sds_tts_fi_types::T_AvailableTTSVoices& AvailableTTSVoices_) {
    set_has_AvailableTTSVoices();
    this->_AvailableTTSVoices = AvailableTTSVoices_;
}

inline void AvailableVoicesStatus::set_has_AvailableTTSVoices () {
    _has_bits_[0] |= 1u << 0;
}

inline void AvailableVoicesStatus::clear_has_AvailableTTSVoices () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TTSVersionInfoStatus::TTSVersionInfoStatus ()  :
    _TTSVersionInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TTSVersionInfoStatus::TTSVersionInfoStatus (const TTSVersionInfoStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _TTSVersionInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TTSVersionInfoStatus::TTSVersionInfoStatus (const ::sds_tts_fi_types::T_TTSVersionInfo& TTSVersionInfo_)  :
    _TTSVersionInfo (TTSVersionInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TTSVersionInfoStatus::~TTSVersionInfoStatus() {
}

inline TTSVersionInfoStatus& TTSVersionInfoStatus::operator = (const TTSVersionInfoStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTTSVersionInfo()) {
            setTTSVersionInfo(rhs.getTTSVersionInfo());
        } else {
            clearTTSVersionInfo();
        }
    }
    return *this;
}

inline bool TTSVersionInfoStatus::operator == (const TTSVersionInfoStatus& rhs) const {
    return (((!hasTTSVersionInfo() && !rhs.hasTTSVersionInfo()) || getTTSVersionInfo() == rhs.getTTSVersionInfo()));
}

inline bool TTSVersionInfoStatus::operator != (const TTSVersionInfoStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool TTSVersionInfoStatus::operator < (const TTSVersionInfoStatus& rhs) const {
    if (hasTTSVersionInfo() || rhs.hasTTSVersionInfo()) {
        if (getTTSVersionInfo() < rhs.getTTSVersionInfo()) return true;
        if (getTTSVersionInfo() > rhs.getTTSVersionInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TTSVersionInfoStatus::clone() {
    return new TTSVersionInfoStatus(*this);
}

inline bool TTSVersionInfoStatus::operator > (const TTSVersionInfoStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TTSVersionInfoStatus::clear() {
    clearTTSVersionInfo();
}

inline void TTSVersionInfoStatus::clearTTSVersionInfo() {
    if (hasTTSVersionInfo()) {
         clear_has_TTSVersionInfo();
        _TTSVersionInfo.clear();
     }
}

inline bool TTSVersionInfoStatus::hasTTSVersionInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sds_tts_fi_types::T_TTSVersionInfo& TTSVersionInfoStatus::getTTSVersionInfo () const {
    return _TTSVersionInfo;
}

inline ::sds_tts_fi_types::T_TTSVersionInfo& TTSVersionInfoStatus::getTTSVersionInfoMutable () {
    set_has_TTSVersionInfo();
    return _TTSVersionInfo;
}

inline void TTSVersionInfoStatus::setTTSVersionInfo (const ::sds_tts_fi_types::T_TTSVersionInfo& TTSVersionInfo_) {
    set_has_TTSVersionInfo();
    this->_TTSVersionInfo = TTSVersionInfo_;
}

inline void TTSVersionInfoStatus::set_has_TTSVersionInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void TTSVersionInfoStatus::clear_has_TTSVersionInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TTSStatusStatus::TTSStatusStatus ()  :
    _TTSStatus (::sds_tts_fi_types::T_e8_TTSStatus__Initialization)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TTSStatusStatus::TTSStatusStatus (const TTSStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _TTSStatus (::sds_tts_fi_types::T_e8_TTSStatus__Initialization)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TTSStatusStatus::TTSStatusStatus (::sds_tts_fi_types::T_e8_TTSStatus TTSStatus_)  :
    _TTSStatus (TTSStatus_)
{
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TTSStatus_IsValid(TTSStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TTSStatus_, "T_e8_TTSStatus", "TTSStatus", "TTSStatusStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TTSStatusStatus::~TTSStatusStatus() {
}

inline TTSStatusStatus& TTSStatusStatus::operator = (const TTSStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTTSStatus()) {
            setTTSStatus(rhs.getTTSStatus());
        } else {
            clearTTSStatus();
        }
    }
    return *this;
}

inline bool TTSStatusStatus::operator == (const TTSStatusStatus& rhs) const {
    return (((!hasTTSStatus() && !rhs.hasTTSStatus()) || getTTSStatus() == rhs.getTTSStatus()));
}

inline bool TTSStatusStatus::operator != (const TTSStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool TTSStatusStatus::operator < (const TTSStatusStatus& rhs) const {
    if (hasTTSStatus() || rhs.hasTTSStatus()) {
        if ((uint32)getTTSStatus() < (uint32)rhs.getTTSStatus()) return true;
        if ((uint32)getTTSStatus() > (uint32)rhs.getTTSStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TTSStatusStatus::clone() {
    return new TTSStatusStatus(*this);
}

inline bool TTSStatusStatus::operator > (const TTSStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TTSStatusStatus::clear() {
    clearTTSStatus();
}

inline void TTSStatusStatus::clearTTSStatus() {
    if (hasTTSStatus()) {
         clear_has_TTSStatus();
        _TTSStatus = ::sds_tts_fi_types::T_e8_TTSStatus__Initialization;
     }
}

inline bool TTSStatusStatus::hasTTSStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sds_tts_fi_types::T_e8_TTSStatus TTSStatusStatus::getTTSStatus () const {
    return _TTSStatus;
}

inline void TTSStatusStatus::setTTSStatus (::sds_tts_fi_types::T_e8_TTSStatus TTSStatus_) {
    #ifndef NDEBUG
    if (!(::sds_tts_fi_types::T_e8_TTSStatus_IsValid(TTSStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TTSStatus_, "T_e8_TTSStatus", "TTSStatus", "TTSStatusStatus");
    }
    #endif
    set_has_TTSStatus();
    this->_TTSStatus = TTSStatus_;
}

inline void TTSStatusStatus::set_has_TTSStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void TTSStatusStatus::clear_has_TTSStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DownloadCompleteStatus::DownloadCompleteStatus ()  :
    _Complete (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DownloadCompleteStatus::DownloadCompleteStatus (const DownloadCompleteStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Complete (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DownloadCompleteStatus::DownloadCompleteStatus (bool Complete_)  :
    _Complete (Complete_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DownloadCompleteStatus::~DownloadCompleteStatus() {
}

inline DownloadCompleteStatus& DownloadCompleteStatus::operator = (const DownloadCompleteStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasComplete()) {
            setComplete(rhs.getComplete());
        } else {
            clearComplete();
        }
    }
    return *this;
}

inline bool DownloadCompleteStatus::operator == (const DownloadCompleteStatus& rhs) const {
    return (((!hasComplete() && !rhs.hasComplete()) || getComplete() == rhs.getComplete()));
}

inline bool DownloadCompleteStatus::operator != (const DownloadCompleteStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DownloadCompleteStatus::operator < (const DownloadCompleteStatus& rhs) const {
    if (hasComplete() || rhs.hasComplete()) {
        if (getComplete() < rhs.getComplete()) return true;
        if (getComplete() > rhs.getComplete()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DownloadCompleteStatus::clone() {
    return new DownloadCompleteStatus(*this);
}

inline bool DownloadCompleteStatus::operator > (const DownloadCompleteStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DownloadCompleteStatus::clear() {
    clearComplete();
}

inline void DownloadCompleteStatus::clearComplete() {
    if (hasComplete()) {
         clear_has_Complete();
        _Complete = false;
     }
}

inline bool DownloadCompleteStatus::hasComplete () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DownloadCompleteStatus::getComplete () const {
    return _Complete;
}

inline void DownloadCompleteStatus::setComplete (bool Complete_) {
    set_has_Complete();
    this->_Complete = Complete_;
}

inline void DownloadCompleteStatus::set_has_Complete () {
    _has_bits_[0] |= 1u << 0;
}

inline void DownloadCompleteStatus::clear_has_Complete () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DownloadCompleteError::DownloadCompleteError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::DownloadCompleteErrorCode__Unspecified;
}

inline  DownloadCompleteError::DownloadCompleteError (const DownloadCompleteError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::SDS_TTS_FI::DownloadCompleteErrorCode__Unspecified;
    *this = rhs;
}

inline  DownloadCompleteError::~DownloadCompleteError() {
    deleteData ();
}

inline DownloadCompleteError& DownloadCompleteError::operator = (const DownloadCompleteError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool DownloadCompleteError::operator == (const DownloadCompleteError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool DownloadCompleteError::operator != (const DownloadCompleteError& rhs) const {
    return ! (*this == rhs);
}

inline bool DownloadCompleteError::operator < (const DownloadCompleteError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool DownloadCompleteError::operator > (const DownloadCompleteError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline DownloadCompleteError::DownloadCompleteErrorField DownloadCompleteError::getField () const {
    return __field;
}

inline void DownloadCompleteError::setField(DownloadCompleteError::DownloadCompleteErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::SDS_TTS_FI::DownloadCompleteErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* DownloadCompleteError::clone() {
    return new DownloadCompleteError(*this);
}

inline bool DownloadCompleteError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline DownloadCompleteErrorCode DownloadCompleteError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "DownloadCompleteError", getField());
    }
    return (DownloadCompleteErrorCode) _data.ccaErrorCode_;
}

inline void DownloadCompleteError::setCcaErrorCode (DownloadCompleteErrorCode value) {
    #ifndef NDEBUG
    if (!(DownloadCompleteErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "DownloadCompleteErrorCode", "ccaErrorCode", "DownloadCompleteError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool DownloadCompleteError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode DownloadCompleteError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "DownloadCompleteError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void DownloadCompleteError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "DownloadCompleteError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void DownloadCompleteError::cloneData (const DownloadCompleteError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void DownloadCompleteError::deleteData () {
}

inline  TTSPlaybackSpacingStatus::TTSPlaybackSpacingStatus ()  :
    _PlaybackSpacing (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TTSPlaybackSpacingStatus::TTSPlaybackSpacingStatus (const TTSPlaybackSpacingStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _PlaybackSpacing (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TTSPlaybackSpacingStatus::TTSPlaybackSpacingStatus (uint8 PlaybackSpacing_)  :
    _PlaybackSpacing (PlaybackSpacing_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TTSPlaybackSpacingStatus::~TTSPlaybackSpacingStatus() {
}

inline TTSPlaybackSpacingStatus& TTSPlaybackSpacingStatus::operator = (const TTSPlaybackSpacingStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPlaybackSpacing()) {
            setPlaybackSpacing(rhs.getPlaybackSpacing());
        } else {
            clearPlaybackSpacing();
        }
    }
    return *this;
}

inline bool TTSPlaybackSpacingStatus::operator == (const TTSPlaybackSpacingStatus& rhs) const {
    return (((!hasPlaybackSpacing() && !rhs.hasPlaybackSpacing()) || getPlaybackSpacing() == rhs.getPlaybackSpacing()));
}

inline bool TTSPlaybackSpacingStatus::operator != (const TTSPlaybackSpacingStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool TTSPlaybackSpacingStatus::operator < (const TTSPlaybackSpacingStatus& rhs) const {
    if (hasPlaybackSpacing() || rhs.hasPlaybackSpacing()) {
        if (getPlaybackSpacing() < rhs.getPlaybackSpacing()) return true;
        if (getPlaybackSpacing() > rhs.getPlaybackSpacing()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TTSPlaybackSpacingStatus::clone() {
    return new TTSPlaybackSpacingStatus(*this);
}

inline bool TTSPlaybackSpacingStatus::operator > (const TTSPlaybackSpacingStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TTSPlaybackSpacingStatus::clear() {
    clearPlaybackSpacing();
}

inline void TTSPlaybackSpacingStatus::clearPlaybackSpacing() {
    if (hasPlaybackSpacing()) {
         clear_has_PlaybackSpacing();
        _PlaybackSpacing = 0u;
     }
}

inline bool TTSPlaybackSpacingStatus::hasPlaybackSpacing () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 TTSPlaybackSpacingStatus::getPlaybackSpacing () const {
    return _PlaybackSpacing;
}

inline void TTSPlaybackSpacingStatus::setPlaybackSpacing (uint8 PlaybackSpacing_) {
    set_has_PlaybackSpacing();
    this->_PlaybackSpacing = PlaybackSpacing_;
}

inline void TTSPlaybackSpacingStatus::set_has_PlaybackSpacing () {
    _has_bits_[0] |= 1u << 0;
}

inline void TTSPlaybackSpacingStatus::clear_has_PlaybackSpacing () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TTSPlaybackSpacingSet::TTSPlaybackSpacingSet ()  :
    _PlaybackSpacing (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TTSPlaybackSpacingSet::TTSPlaybackSpacingSet (const TTSPlaybackSpacingSet &rhs)  :
    ::asf::core::Payload(rhs),
    _PlaybackSpacing (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TTSPlaybackSpacingSet::TTSPlaybackSpacingSet (uint8 PlaybackSpacing_)  :
    _PlaybackSpacing (PlaybackSpacing_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TTSPlaybackSpacingSet::~TTSPlaybackSpacingSet() {
}

inline TTSPlaybackSpacingSet& TTSPlaybackSpacingSet::operator = (const TTSPlaybackSpacingSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPlaybackSpacing()) {
            setPlaybackSpacing(rhs.getPlaybackSpacing());
        } else {
            clearPlaybackSpacing();
        }
    }
    return *this;
}

inline bool TTSPlaybackSpacingSet::operator == (const TTSPlaybackSpacingSet& rhs) const {
    return (((!hasPlaybackSpacing() && !rhs.hasPlaybackSpacing()) || getPlaybackSpacing() == rhs.getPlaybackSpacing()));
}

inline bool TTSPlaybackSpacingSet::operator != (const TTSPlaybackSpacingSet& rhs) const {
    return ! (*this == rhs);
}

inline bool TTSPlaybackSpacingSet::operator < (const TTSPlaybackSpacingSet& rhs) const {
    if (hasPlaybackSpacing() || rhs.hasPlaybackSpacing()) {
        if (getPlaybackSpacing() < rhs.getPlaybackSpacing()) return true;
        if (getPlaybackSpacing() > rhs.getPlaybackSpacing()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TTSPlaybackSpacingSet::clone() {
    return new TTSPlaybackSpacingSet(*this);
}

inline bool TTSPlaybackSpacingSet::operator > (const TTSPlaybackSpacingSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TTSPlaybackSpacingSet::clear() {
    clearPlaybackSpacing();
}

inline void TTSPlaybackSpacingSet::clearPlaybackSpacing() {
    if (hasPlaybackSpacing()) {
         clear_has_PlaybackSpacing();
        _PlaybackSpacing = 0u;
     }
}

inline bool TTSPlaybackSpacingSet::hasPlaybackSpacing () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 TTSPlaybackSpacingSet::getPlaybackSpacing () const {
    return _PlaybackSpacing;
}

inline void TTSPlaybackSpacingSet::setPlaybackSpacing (uint8 PlaybackSpacing_) {
    set_has_PlaybackSpacing();
    this->_PlaybackSpacing = PlaybackSpacing_;
}

inline void TTSPlaybackSpacingSet::set_has_PlaybackSpacing () {
    _has_bits_[0] |= 1u << 0;
}

inline void TTSPlaybackSpacingSet::clear_has_PlaybackSpacing () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace SDS_TTS_FI

#endif // SDS_TTS_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
