/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef AUX_MAIN_FIPROXY_H
#define AUX_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "aux_main_fi.h"
#include "aux_main_fi_typesConst.h"

namespace aux_main_fi {

class Aux_main_fiProxy;

class AvailibilityCallbackIF {
public:
    virtual ~AvailibilityCallbackIF() {}

    virtual void onAvailibilityError(const ::boost::shared_ptr< Aux_main_fiProxy >& proxy, const ::boost::shared_ptr< AvailibilityError >& error) = 0;

    virtual void onAvailibilityStatus(const ::boost::shared_ptr< Aux_main_fiProxy >& proxy, const ::boost::shared_ptr< AvailibilityStatus >& status) = 0;
};

class ConnectionStateCallbackIF {
public:
    virtual ~ConnectionStateCallbackIF() {}

    virtual void onConnectionStateError(const ::boost::shared_ptr< Aux_main_fiProxy >& proxy, const ::boost::shared_ptr< ConnectionStateError >& error) = 0;

    virtual void onConnectionStateStatus(const ::boost::shared_ptr< Aux_main_fiProxy >& proxy, const ::boost::shared_ptr< ConnectionStateStatus >& status) = 0;
};

class Aux_main_fiProxyCallback;

/**
 * Aux_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'aux_main_fi' (specified in file aux_main_fi.xml).
 *
 * CCA Functional Interface 'aux_main_fi'
 *
 * Fullname: Auxiliary jack component functional interface
 *
 * Version: $Revision:   1.0.0   $
 *
 * Author: CM-AI/EPB2 Schurig
 *
 * Date: $Date: 2015-29-04   $
 *
 * Department:
 *
 * Title: AUX_FI
 *
 * <b>Description of 'aux_main_fi':</b>
 *
 * This functional interface is designed for the auxiliary jack in the Renault/Nissan A-IVI project.
 * It will be used for the Renault company who wants to have the possibility to detect whether an
 * auxiliary jack has been connected or not to inform the HMI.
 */
class Aux_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Aux_main_fiProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Aux_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Aux_main_fiProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Aux_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Aux_main_fiProxy. The caller has to pass the
     * port name. The port name is defined in the "Car Multimedia Component"
     * model. With the help of the port name it is possible to address the
     * concrete proxy, which is defined in the CMC model description.
     */
    static ::boost::shared_ptr< Aux_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Aux_main_fiProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~Aux_main_fiProxy();

    // Property 'Availibility'

    /**
     * Notify on the property 'Availibility'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'Availibility'</b>:
     *
     * <p>Controls the availibility of an auxilary input</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAvailibilityUpReg(AvailibilityCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Availibility'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Availibility'</b>:
     *
     * <p>Controls the availibility of an auxilary input</p>
     *
     * @param act The act which was previously returned by the
     * sendAvailibilityUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAvailibilityRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Availibility'.
     */
    void sendAvailibilityRelUpRegAll ();

    /**
     * Returns the current value of the property 'Availibility' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAvailibility() returns true.
     *
     * @return the previously received value of the property 'Availibility'.
     */
    const AvailibilityStatus& getAvailibility() const;

    /**
     * Determines whether a status message for the property 'Availibility' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAvailibility() const;

    /**
     * Request the value of the property 'Availibility' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Availibility'</b>:
     *
     * <p>Controls the availibility of an auxilary input</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAvailibilityGet(AvailibilityCallbackIF& cb);

    /**
     * Set the value of the property 'Availibility'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'Availibility'</b>:
     *
     * <p>Controls the availibility of an auxilary input</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param enAUXNumber Number of aux input to set availablity
     *
     * @param enAUXAvailState set availibility of given auxilary input
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAvailibilitySet(AvailibilityCallbackIF& cb, uint8 enAUXNumber, ::aux_main_fi_types::T_e8_AUXAvailabilityState enAUXAvailState);

    // Property 'ConnectionState'

    /**
     * Notify on the property 'ConnectionState'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'ConnectionState'</b>:
     *
     * <p>Information about the current connection status</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectionStateUpReg(ConnectionStateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ConnectionState'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ConnectionState'</b>:
     *
     * <p>Information about the current connection status</p>
     *
     * @param act The act which was previously returned by the
     * sendConnectionStateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendConnectionStateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ConnectionState'.
     */
    void sendConnectionStateRelUpRegAll ();

    /**
     * Returns the current value of the property 'ConnectionState' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasConnectionState() returns true.
     *
     * @return the previously received value of the property 'ConnectionState'.
     */
    const ConnectionStateStatus& getConnectionState() const;

    /**
     * Determines whether a status message for the property 'ConnectionState' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConnectionState() const;

    /**
     * Request the value of the property 'ConnectionState' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'ConnectionState'</b>:
     *
     * <p>Information about the current connection status</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectionStateGet(ConnectionStateCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Aux_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'Availibility'

    ::asf::core::nullable< AvailibilityStatus > _availibility;

    // Property 'ConnectionState'

    ::asf::core::nullable< ConnectionStateStatus > _connectionState;

    DECLARE_CLASS_LOGGER();

    friend class Aux_main_fiProxyCallback;
};

} // namespace aux_main_fi

#endif // AUX_MAIN_FIPROXY_H
