/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "aux_main_fiCca.h"
#include "aux_main_fiJson.h"
#include "aux_main_fiProxy.h"
#include "aux_main_fi_typesConst.h"

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace aux_main_fi {

/*static*/ ::asf::core::Logger Aux_main_fiProxy::_logger ("/aux_main_fi/Aux_main_fiProxy");


class Aux_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Aux_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Aux_main_fiProxy> proxy = ::boost::static_pointer_cast<Aux_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_Availibility: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::aux_main_fi::AvailibilityStatus);
                                setActAndLogStatus(message, "Availibility", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AvailibilityStatus> payload = ::boost::static_pointer_cast<AvailibilityStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AvailibilityStatus >& refNullableStatus = proxy->_availibility;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AvailibilityCallbackIF*) _callback)->onAvailibilityStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AvailibilityCallbackIF*) _callback)->onAvailibilityStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::aux_main_fi::AvailibilityError);
                                setActAndLogError(message, "Availibility", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AvailibilityCallbackIF*) _callback)->onAvailibilityError(proxy, ::boost::static_pointer_cast<AvailibilityError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ConnectionState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::aux_main_fi::ConnectionStateStatus);
                                setActAndLogStatus(message, "ConnectionState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ConnectionStateStatus> payload = ::boost::static_pointer_cast<ConnectionStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ConnectionStateStatus >& refNullableStatus = proxy->_connectionState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ConnectionStateCallbackIF*) _callback)->onConnectionStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ConnectionStateCallbackIF*) _callback)->onConnectionStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::aux_main_fi::ConnectionStateError);
                                setActAndLogError(message, "ConnectionState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ConnectionStateCallbackIF*) _callback)->onConnectionStateError(proxy, ::boost::static_pointer_cast<ConnectionStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Aux_main_fiProxy> proxy = ::boost::static_pointer_cast<Aux_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_Availibility: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< AvailibilityError > payload (new AvailibilityError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Availibility", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AvailibilityCallbackIF*) _callback)->onAvailibilityError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ConnectionState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< ConnectionStateError > payload (new ConnectionStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ConnectionState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ConnectionStateCallbackIF*) _callback)->onConnectionStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Aux_main_fiProxyCallback::_logger (Aux_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Aux_main_fiProxy > Aux_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Aux_main_fiProxy >  proxyNew(new Aux_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Aux_main_fiProxy > Aux_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Aux_main_fiProxy >  proxyNew(new Aux_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Aux_main_fiProxy > Aux_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Aux_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Aux_main_fiProxy >  proxyNew(new Aux_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Aux_main_fiProxy::Aux_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Aux_main_fiProxy::~Aux_main_fiProxy()
{
    LOG_INFO ("Entering ~Aux_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Aux_main_fiProxy::sendAvailibilityUpReg(AvailibilityCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Availibility);
        ::boost::shared_ptr< AvailibilityUpReg > payload (new AvailibilityUpReg());
        CCA_MESSAGE(ccaMessage,header,AvailibilityUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AvailibilityRelUpReg > payloadRelUpRegHeap (new AvailibilityRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Availibility, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::aux_main_fi::AvailibilityRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Availibility, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Availibility", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Availibility", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAvailibility()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Availibility, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AvailibilityStatus > payloadLoopback (new AvailibilityStatus(getAvailibility()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AvailibilityStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Availibility);
        ::boost::shared_ptr< AvailibilityError > payload (new AvailibilityError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AvailibilityError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Availibility", &cb);
    }
}

bool Aux_main_fiProxy::sendAvailibilityRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Availibility,"Availibility");
}

void Aux_main_fiProxy::sendAvailibilityRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Availibility);
}

const AvailibilityStatus& Aux_main_fiProxy::getAvailibility() const {
    return _availibility.get();
}

bool Aux_main_fiProxy::hasAvailibility() const {
    return _availibility.hasValue();
}

act_t Aux_main_fiProxy::sendAvailibilityGet(AvailibilityCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Availibility);
        ::boost::shared_ptr< AvailibilityGet > payload (new AvailibilityGet());
        CCA_MESSAGE(ccaMessage,header,AvailibilityGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Availibility", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Availibility);
        ::boost::shared_ptr< AvailibilityError > payload (new AvailibilityError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AvailibilityError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Availibility", &cb);
    }
}

act_t Aux_main_fiProxy::sendAvailibilitySet(AvailibilityCallbackIF& cb, uint8 enAUXNumber, ::aux_main_fi_types::T_e8_AUXAvailabilityState enAUXAvailState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Availibility);
        ::boost::shared_ptr< AvailibilitySet > payload (new AvailibilitySet());
        payload->setEnAUXNumber(enAUXNumber);
        payload->setEnAUXAvailState(enAUXAvailState);
        CCA_MESSAGE(ccaMessage,header,AvailibilitySet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Availibility", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Availibility);
        ::boost::shared_ptr< AvailibilityError > payload (new AvailibilityError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AvailibilityError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Availibility", &cb);
    }
}

act_t Aux_main_fiProxy::sendConnectionStateUpReg(ConnectionStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ConnectionState);
        ::boost::shared_ptr< ConnectionStateUpReg > payload (new ConnectionStateUpReg());
        CCA_MESSAGE(ccaMessage,header,ConnectionStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ConnectionStateRelUpReg > payloadRelUpRegHeap (new ConnectionStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ConnectionState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::aux_main_fi::ConnectionStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ConnectionState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ConnectionState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ConnectionState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasConnectionState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ConnectionState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ConnectionStateStatus > payloadLoopback (new ConnectionStateStatus(getConnectionState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ConnectionStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ConnectionState);
        ::boost::shared_ptr< ConnectionStateError > payload (new ConnectionStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ConnectionStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ConnectionState", &cb);
    }
}

bool Aux_main_fiProxy::sendConnectionStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ConnectionState,"ConnectionState");
}

void Aux_main_fiProxy::sendConnectionStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ConnectionState);
}

const ConnectionStateStatus& Aux_main_fiProxy::getConnectionState() const {
    return _connectionState.get();
}

bool Aux_main_fiProxy::hasConnectionState() const {
    return _connectionState.hasValue();
}

act_t Aux_main_fiProxy::sendConnectionStateGet(ConnectionStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ConnectionState);
        ::boost::shared_ptr< ConnectionStateGet > payload (new ConnectionStateGet());
        CCA_MESSAGE(ccaMessage,header,ConnectionStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ConnectionState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ConnectionState);
        ::boost::shared_ptr< ConnectionStateError > payload (new ConnectionStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ConnectionStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ConnectionState", &cb);
    }
}


void Aux_main_fiProxy::clearAllProperties ()
{
    _availibility = ::asf::core::nullable<AvailibilityStatus>();
    _connectionState = ::asf::core::nullable<ConnectionStateStatus>();
}

void Aux_main_fiProxy::sendRelUpRegAll()
{
    sendAvailibilityRelUpRegAll();
    sendConnectionStateRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Aux_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Aux_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace aux_main_fi
