#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef AUX_MAIN_FI_H
#define AUX_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "aux_main_fi_types.h"
#include "aux_main_fi_typesConst.h"
#include <cstring>

/**
 * CCA Functional Interface 'aux_main_fi'
 *
 * Fullname: Auxiliary jack component functional interface
 *
 * Version: $Revision:   1.0.0   $
 *
 * Author: CM-AI/EPB2 Schurig
 *
 * Date: $Date: 2015-29-04   $
 *
 * Department:
 *
 * Title: AUX_FI
 *
 * <b>Description of 'aux_main_fi':</b>
 *
 * This functional interface is designed for the auxiliary jack in the Renault/Nissan A-IVI project.
 * It will be used for the Renault company who wants to have the possibility to detect whether an
 * auxiliary jack has been connected or not to inform the HMI.
 */

namespace aux_main_fi {

static const int SERVICE_ID = 177;

static const int FID_Availibility = 256;

static const int FID_ConnectionState = 257;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class AvailibilityStatus;

class AvailibilitySet;

class ConnectionStateStatus;

// type definitions
/**
 * The get message of the property "Availibility"
 * <p>Controls the availibility of an auxilary input</p>
 * returns availibility of auxilary inputs
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AvailibilityGet;

/**
 * The upreg message of the property "Availibility"
 * <p>Controls the availibility of an auxilary input</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AvailibilityUpReg;

/**
 * The relUpReg message of the property "Availibility"
 * <p>Controls the availibility of an auxilary input</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AvailibilityRelUpReg;

/**
 * The error message of 'Availibility'
 */
typedef ::asf::cca::CcaTypes::DefaultError AvailibilityError;

/**
 * The get message of the property "ConnectionState"
 * <p>Information about the current connection status</p>
 * (returns the current connection status)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectionStateGet;

/**
 * The upreg message of the property "ConnectionState"
 * <p>Information about the current connection status</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectionStateUpReg;

/**
 * The relUpReg message of the property "ConnectionState"
 * <p>Information about the current connection status</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectionStateRelUpReg;

/**
 * The error message of 'ConnectionState'
 */
typedef ::asf::cca::CcaTypes::DefaultError ConnectionStateError;


/**
 * The status message of the property "Availibility"
 * <p>Controls the availibility of an auxilary input</p>
 */
class AvailibilityStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AvailibilityStatus ();

    /**
     * Copy constructor
     */
    inline  AvailibilityStatus (const AvailibilityStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AvailibilityStatus (const ::aux_main_fi_types::T_AUX_States& oStates_);

    /**
     * Destructor
     */
    inline virtual  ~AvailibilityStatus();

    /**
     * Assignment operator
     */
    inline AvailibilityStatus& operator = (const AvailibilityStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AvailibilityStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AvailibilityStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AvailibilityStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AvailibilityStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oStates"

    static const int kOStates = 0;

    /**
     * Clears the field "oStates".
     *
     * The field will be set to its default value. The hasOStates()
     * method will return false.
     */
    inline void clearOStates();

    /**
     * Checks whether the field "oStates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOStates()). Otherwise it will return false.
     */
    inline bool hasOStates () const;

    /**
     * Returns the value of the member "oStates".
     *
     * Actual status of CD media
     *
     * @return The value of the field "oStates"
     */
    inline const ::aux_main_fi_types::T_AUX_States& getOStates () const;

    /**
     * Retrieves the value of the field "oStates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oStates".
     */
    inline ::aux_main_fi_types::T_AUX_States& getOStatesMutable ();

    /**
     * Sets the value of the member "oStates".
     *
     * Actual status of CD media
     *
     * @param oStates The value which will be set
     */
    inline void setOStates (const ::aux_main_fi_types::T_AUX_States& oStates_);

    static const AvailibilityStatus &getDefaultInstance();

private:

    inline void set_has_oStates ();

    inline void clear_has_oStates ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::aux_main_fi_types::T_AUX_States _oStates;

};

/**
 * The set message of the property "Availibility"
 * <p>Controls the availibility of an auxilary input</p>
 */
class AvailibilitySet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AvailibilitySet ();

    /**
     * Copy constructor
     */
    inline  AvailibilitySet (const AvailibilitySet &rhs);

    /**
     * All fields constructor
     */
    inline  AvailibilitySet (uint8 enAUXNumber_, ::aux_main_fi_types::T_e8_AUXAvailabilityState enAUXAvailState_);

    /**
     * Destructor
     */
    inline virtual  ~AvailibilitySet();

    /**
     * Assignment operator
     */
    inline AvailibilitySet& operator = (const AvailibilitySet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AvailibilitySet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AvailibilitySet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AvailibilitySet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AvailibilitySet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enAUXNumber"

    static const int kEnAUXNumber = 0;

    /**
     * Clears the field "enAUXNumber".
     *
     * The field will be set to its default value. The hasEnAUXNumber()
     * method will return false.
     */
    inline void clearEnAUXNumber();

    /**
     * Checks whether the field "enAUXNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnAUXNumber()). Otherwise it will return false.
     */
    inline bool hasEnAUXNumber () const;

    /**
     * Returns the value of the member "enAUXNumber".
     *
     * Number of aux input to set availablity
     *
     * @return The value of the field "enAUXNumber"
     */
    inline uint8 getEnAUXNumber () const;

    /**
     * Sets the value of the member "enAUXNumber".
     *
     * Number of aux input to set availablity
     *
     * @param enAUXNumber The value which will be set
     */
    inline void setEnAUXNumber (uint8 enAUXNumber_);

    // API of field "enAUXAvailState"

    static const int kEnAUXAvailState = 1;

    /**
     * Clears the field "enAUXAvailState".
     *
     * The field will be set to its default value. The hasEnAUXAvailState()
     * method will return false.
     */
    inline void clearEnAUXAvailState();

    /**
     * Checks whether the field "enAUXAvailState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnAUXAvailState()). Otherwise it will return false.
     */
    inline bool hasEnAUXAvailState () const;

    /**
     * Returns the value of the member "enAUXAvailState".
     *
     * set availibility of given auxilary input
     *
     * @return The value of the field "enAUXAvailState"
     */
    inline ::aux_main_fi_types::T_e8_AUXAvailabilityState getEnAUXAvailState () const;

    /**
     * Sets the value of the member "enAUXAvailState".
     *
     * set availibility of given auxilary input
     *
     * @param enAUXAvailState The value which will be set
     */
    inline void setEnAUXAvailState (::aux_main_fi_types::T_e8_AUXAvailabilityState enAUXAvailState_);

    static const AvailibilitySet &getDefaultInstance();

private:

    inline void set_has_enAUXNumber ();

    inline void clear_has_enAUXNumber ();

    inline void set_has_enAUXAvailState ();

    inline void clear_has_enAUXAvailState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _enAUXNumber;

    ::aux_main_fi_types::T_e8_AUXAvailabilityState _enAUXAvailState;

};

/**
 * The status message of the property "ConnectionState"
 * <p>Information about the current connection status</p>
 */
class ConnectionStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectionStateStatus ();

    /**
     * Copy constructor
     */
    inline  ConnectionStateStatus (const ConnectionStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectionStateStatus (const ::aux_main_fi_types::T_AUX_States& oStates_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectionStateStatus();

    /**
     * Assignment operator
     */
    inline ConnectionStateStatus& operator = (const ConnectionStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectionStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectionStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectionStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectionStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oStates"

    static const int kOStates = 0;

    /**
     * Clears the field "oStates".
     *
     * The field will be set to its default value. The hasOStates()
     * method will return false.
     */
    inline void clearOStates();

    /**
     * Checks whether the field "oStates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOStates()). Otherwise it will return false.
     */
    inline bool hasOStates () const;

    /**
     * Returns the value of the member "oStates".
     *
     * Actual status of CD media
     *
     * @return The value of the field "oStates"
     */
    inline const ::aux_main_fi_types::T_AUX_States& getOStates () const;

    /**
     * Retrieves the value of the field "oStates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oStates".
     */
    inline ::aux_main_fi_types::T_AUX_States& getOStatesMutable ();

    /**
     * Sets the value of the member "oStates".
     *
     * Actual status of CD media
     *
     * @param oStates The value which will be set
     */
    inline void setOStates (const ::aux_main_fi_types::T_AUX_States& oStates_);

    static const ConnectionStateStatus &getDefaultInstance();

private:

    inline void set_has_oStates ();

    inline void clear_has_oStates ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::aux_main_fi_types::T_AUX_States _oStates;

};

inline  AvailibilityStatus::AvailibilityStatus ()  :
    _oStates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AvailibilityStatus::AvailibilityStatus (const AvailibilityStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _oStates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AvailibilityStatus::AvailibilityStatus (const ::aux_main_fi_types::T_AUX_States& oStates_)  :
    _oStates (oStates_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AvailibilityStatus::~AvailibilityStatus() {
}

inline AvailibilityStatus& AvailibilityStatus::operator = (const AvailibilityStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOStates()) {
            setOStates(rhs.getOStates());
        } else {
            clearOStates();
        }
    }
    return *this;
}

inline bool AvailibilityStatus::operator == (const AvailibilityStatus& rhs) const {
    return (((!hasOStates() && !rhs.hasOStates()) || getOStates() == rhs.getOStates()));
}

inline bool AvailibilityStatus::operator != (const AvailibilityStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool AvailibilityStatus::operator < (const AvailibilityStatus& rhs) const {
    if (hasOStates() || rhs.hasOStates()) {
        if (getOStates() < rhs.getOStates()) return true;
        if (getOStates() > rhs.getOStates()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AvailibilityStatus::clone() {
    return new AvailibilityStatus(*this);
}

inline bool AvailibilityStatus::operator > (const AvailibilityStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AvailibilityStatus::clear() {
    clearOStates();
}

inline void AvailibilityStatus::clearOStates() {
    if (hasOStates()) {
         clear_has_oStates();
        _oStates.clear();
     }
}

inline bool AvailibilityStatus::hasOStates () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::aux_main_fi_types::T_AUX_States& AvailibilityStatus::getOStates () const {
    return _oStates;
}

inline ::aux_main_fi_types::T_AUX_States& AvailibilityStatus::getOStatesMutable () {
    set_has_oStates();
    return _oStates;
}

inline void AvailibilityStatus::setOStates (const ::aux_main_fi_types::T_AUX_States& oStates_) {
    set_has_oStates();
    this->_oStates = oStates_;
}

inline void AvailibilityStatus::set_has_oStates () {
    _has_bits_[0] |= 1u << 0;
}

inline void AvailibilityStatus::clear_has_oStates () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AvailibilitySet::AvailibilitySet ()  :
    _enAUXNumber (0u),
    _enAUXAvailState (::aux_main_fi_types::T_e8_AUXAvailabilityState__AUX_AVAIL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AvailibilitySet::AvailibilitySet (const AvailibilitySet &rhs)  :
    ::asf::core::Payload(rhs),
    _enAUXNumber (0u),
    _enAUXAvailState (::aux_main_fi_types::T_e8_AUXAvailabilityState__AUX_AVAIL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AvailibilitySet::AvailibilitySet (uint8 enAUXNumber_, ::aux_main_fi_types::T_e8_AUXAvailabilityState enAUXAvailState_)  :
    _enAUXNumber (enAUXNumber_),
    _enAUXAvailState (enAUXAvailState_)
{
    #ifndef NDEBUG
    if (!(::aux_main_fi_types::T_e8_AUXAvailabilityState_IsValid(enAUXAvailState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enAUXAvailState_, "T_e8_AUXAvailabilityState", "enAUXAvailState", "AvailibilitySet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AvailibilitySet::~AvailibilitySet() {
}

inline AvailibilitySet& AvailibilitySet::operator = (const AvailibilitySet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnAUXNumber()) {
            setEnAUXNumber(rhs.getEnAUXNumber());
        } else {
            clearEnAUXNumber();
        }
        if (rhs.hasEnAUXAvailState()) {
            setEnAUXAvailState(rhs.getEnAUXAvailState());
        } else {
            clearEnAUXAvailState();
        }
    }
    return *this;
}

inline bool AvailibilitySet::operator == (const AvailibilitySet& rhs) const {
    return (((!hasEnAUXNumber() && !rhs.hasEnAUXNumber()) || getEnAUXNumber() == rhs.getEnAUXNumber()) &&
        ((!hasEnAUXAvailState() && !rhs.hasEnAUXAvailState()) || getEnAUXAvailState() == rhs.getEnAUXAvailState()));
}

inline bool AvailibilitySet::operator != (const AvailibilitySet& rhs) const {
    return ! (*this == rhs);
}

inline bool AvailibilitySet::operator < (const AvailibilitySet& rhs) const {
    if (hasEnAUXNumber() || rhs.hasEnAUXNumber()) {
        if (getEnAUXNumber() < rhs.getEnAUXNumber()) return true;
        if (getEnAUXNumber() > rhs.getEnAUXNumber()) return false;
    }
    if (hasEnAUXAvailState() || rhs.hasEnAUXAvailState()) {
        if ((uint32)getEnAUXAvailState() < (uint32)rhs.getEnAUXAvailState()) return true;
        if ((uint32)getEnAUXAvailState() > (uint32)rhs.getEnAUXAvailState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AvailibilitySet::clone() {
    return new AvailibilitySet(*this);
}

inline bool AvailibilitySet::operator > (const AvailibilitySet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AvailibilitySet::clear() {
    clearEnAUXNumber();
    clearEnAUXAvailState();
}

inline void AvailibilitySet::clearEnAUXNumber() {
    if (hasEnAUXNumber()) {
         clear_has_enAUXNumber();
        _enAUXNumber = 0u;
     }
}

inline bool AvailibilitySet::hasEnAUXNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AvailibilitySet::getEnAUXNumber () const {
    return _enAUXNumber;
}

inline void AvailibilitySet::setEnAUXNumber (uint8 enAUXNumber_) {
    set_has_enAUXNumber();
    this->_enAUXNumber = enAUXNumber_;
}

inline void AvailibilitySet::clearEnAUXAvailState() {
    if (hasEnAUXAvailState()) {
         clear_has_enAUXAvailState();
        _enAUXAvailState = ::aux_main_fi_types::T_e8_AUXAvailabilityState__AUX_AVAIL;
     }
}

inline bool AvailibilitySet::hasEnAUXAvailState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::aux_main_fi_types::T_e8_AUXAvailabilityState AvailibilitySet::getEnAUXAvailState () const {
    return _enAUXAvailState;
}

inline void AvailibilitySet::setEnAUXAvailState (::aux_main_fi_types::T_e8_AUXAvailabilityState enAUXAvailState_) {
    #ifndef NDEBUG
    if (!(::aux_main_fi_types::T_e8_AUXAvailabilityState_IsValid(enAUXAvailState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enAUXAvailState_, "T_e8_AUXAvailabilityState", "enAUXAvailState", "AvailibilitySet");
    }
    #endif
    set_has_enAUXAvailState();
    this->_enAUXAvailState = enAUXAvailState_;
}

inline void AvailibilitySet::set_has_enAUXNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void AvailibilitySet::clear_has_enAUXNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AvailibilitySet::set_has_enAUXAvailState () {
    _has_bits_[0] |= 1u << 1;
}

inline void AvailibilitySet::clear_has_enAUXAvailState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ConnectionStateStatus::ConnectionStateStatus ()  :
    _oStates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectionStateStatus::ConnectionStateStatus (const ConnectionStateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _oStates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectionStateStatus::ConnectionStateStatus (const ::aux_main_fi_types::T_AUX_States& oStates_)  :
    _oStates (oStates_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConnectionStateStatus::~ConnectionStateStatus() {
}

inline ConnectionStateStatus& ConnectionStateStatus::operator = (const ConnectionStateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOStates()) {
            setOStates(rhs.getOStates());
        } else {
            clearOStates();
        }
    }
    return *this;
}

inline bool ConnectionStateStatus::operator == (const ConnectionStateStatus& rhs) const {
    return (((!hasOStates() && !rhs.hasOStates()) || getOStates() == rhs.getOStates()));
}

inline bool ConnectionStateStatus::operator != (const ConnectionStateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectionStateStatus::operator < (const ConnectionStateStatus& rhs) const {
    if (hasOStates() || rhs.hasOStates()) {
        if (getOStates() < rhs.getOStates()) return true;
        if (getOStates() > rhs.getOStates()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConnectionStateStatus::clone() {
    return new ConnectionStateStatus(*this);
}

inline bool ConnectionStateStatus::operator > (const ConnectionStateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectionStateStatus::clear() {
    clearOStates();
}

inline void ConnectionStateStatus::clearOStates() {
    if (hasOStates()) {
         clear_has_oStates();
        _oStates.clear();
     }
}

inline bool ConnectionStateStatus::hasOStates () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::aux_main_fi_types::T_AUX_States& ConnectionStateStatus::getOStates () const {
    return _oStates;
}

inline ::aux_main_fi_types::T_AUX_States& ConnectionStateStatus::getOStatesMutable () {
    set_has_oStates();
    return _oStates;
}

inline void ConnectionStateStatus::setOStates (const ::aux_main_fi_types::T_AUX_States& oStates_) {
    set_has_oStates();
    this->_oStates = oStates_;
}

inline void ConnectionStateStatus::set_has_oStates () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConnectionStateStatus::clear_has_oStates () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace aux_main_fi

#endif // AUX_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
