/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/dbus/DBusAssert.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DBusVariantDBus.h"
#include "org/freedesktop/DBus/Properties.h"
#include "org/freedesktop/DBus/PropertiesDBus.h"
#include <dbus/dbus.h>
#include <map>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of GetRequest

void serializeDBus (const ::org::freedesktop::DBus::Properties::GetRequest& in, DBusMessageIter* out) {
    const char* o0 = in.getInterface_name().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o0));
    const char* o1 = in.getProperty_name().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o1));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::DBus::Properties::GetRequest& out) {
    {
        ::std::string interface_nameValue;
        ::std::string &interface_nameTmpValue = interface_nameValue;
        {
            char* o2 = 0;
            dbus_message_iter_get_basic(in, &o2);
            interface_nameTmpValue.assign (o2);
        }
        out.setInterface_name(interface_nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string property_nameValue;
        ::std::string &property_nameTmpValue = property_nameValue;
        {
            char* o3 = 0;
            dbus_message_iter_get_basic(in, &o3);
            property_nameTmpValue.assign (o3);
        }
        out.setProperty_name(property_nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetResponse

void serializeDBus (const ::org::freedesktop::DBus::Properties::GetResponse& in, DBusMessageIter* out) {
    serializeDBus(in.getValue(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::DBus::Properties::GetResponse& out) {
    {
        ::asf::dbus::DBusVariant valueValue;
        {
            DBusMessageIter o4;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o4);

                    if (!deserializeDBus(&o4, valueValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setValue(valueValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetRequest

void serializeDBus (const ::org::freedesktop::DBus::Properties::SetRequest& in, DBusMessageIter* out) {
    const char* o5 = in.getInterface_name().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o5));
    const char* o6 = in.getProperty_name().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o6));
    serializeDBus(in.getValue(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::DBus::Properties::SetRequest& out) {
    {
        ::std::string interface_nameValue;
        ::std::string &interface_nameTmpValue = interface_nameValue;
        {
            char* o7 = 0;
            dbus_message_iter_get_basic(in, &o7);
            interface_nameTmpValue.assign (o7);
        }
        out.setInterface_name(interface_nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string property_nameValue;
        ::std::string &property_nameTmpValue = property_nameValue;
        {
            char* o8 = 0;
            dbus_message_iter_get_basic(in, &o8);
            property_nameTmpValue.assign (o8);
        }
        out.setProperty_name(property_nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::asf::dbus::DBusVariant valueValue;
        {
            DBusMessageIter o9;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o9);

                    if (!deserializeDBus(&o9, valueValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setValue(valueValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PropertiesChangedSignal

void serializeDBus (const ::org::freedesktop::DBus::Properties::PropertiesChangedSignal& in, DBusMessageIter* out) {
    const char* o10 = in.getInterface_name().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o10));
    DBusMessageIter o11ArrayIter;
    DBusMessageIter o12DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o11ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o13 = &in.getChanged_properties();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o14 = o13->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o15 = o13->begin(); o15 != o14; ++o15) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o11ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o12DictIter));
        const char* o16 = o15->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o12DictIter, DBUS_TYPE_STRING, &o16));
        serializeDBus(o15->second, &o12DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o11ArrayIter, &o12DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o11ArrayIter));
    DBusMessageIter o17ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o17ArrayIter));
    const ::std::vector< ::std::string >* o18 = &in.getInvalidated_properties();
    ::std::vector< ::std::string >::const_iterator o19 = o18->end();
    for (::std::vector< ::std::string >::const_iterator o20 = o18->begin(); o20 != o19; ++o20) {
        const char* o21 = (*o20).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o17ArrayIter, DBUS_TYPE_STRING, &o21));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o17ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::DBus::Properties::PropertiesChangedSignal& out) {
    {
        ::std::string interface_nameValue;
        ::std::string &interface_nameTmpValue = interface_nameValue;
        {
            char* o22 = 0;
            dbus_message_iter_get_basic(in, &o22);
            interface_nameTmpValue.assign (o22);
        }
        out.setInterface_name(interface_nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changed_propertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o23ArrayIter;
            DBusMessageIter o24DictIter;
            dbus_message_iter_recurse (in, &o23ArrayIter);

            if (dbus_message_iter_get_arg_type(&o23ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o25Key;
                    ::asf::dbus::DBusVariant o25Value;
                    dbus_message_iter_recurse (&o23ArrayIter, &o24DictIter);
                    {
                        char* o26 = 0;
                        dbus_message_iter_get_basic(&o24DictIter, &o26);
                        o25Key.assign (o26);
                    }
                    dbus_message_iter_next(&o24DictIter);
                    {
                        DBusMessageIter o27;
                        char* signature = dbus_message_iter_get_signature(&o24DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o24DictIter)) {
                                dbus_message_iter_recurse (&o24DictIter, &o27);

                                if (!deserializeDBus(&o27, o25Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    changed_propertiesValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o25Key, o25Value));
                } while (dbus_message_iter_next(&o23ArrayIter));
            }
        }
        out.setChanged_properties(changed_propertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::std::string > invalidated_propertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o28ArrayIter;
            dbus_message_iter_recurse (in, &o28ArrayIter);

            if(dbus_message_iter_get_arg_type(&o28ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o29;
                    {
                        char* o30 = 0;
                        dbus_message_iter_get_basic(&o28ArrayIter, &o30);
                        o29.assign (o30);
                    }
                    invalidated_propertiesValue.push_back(o29);
                } while (dbus_message_iter_next(&o28ArrayIter));
            }
        }
        out.setInvalidated_properties(invalidated_propertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

