/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WAPDMAN_MANAGERSTUB_H
#define ORG_BOSCH_WAPDMAN_MANAGERSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wapdman/Manager.h"
#include <string>
#include <vector>

namespace org {
namespace bosch {
namespace wapdman {
namespace Manager {

class ManagerStubDelegate;

class ManagerStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ManagerStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ManagerStub (const std::string& portName);

    /**
     * Create an instance of the ManagerStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ManagerStub (const std::string& portName, const std::string& objectPath);

    virtual ~ManagerStub();

    // signal 'AccessPointAdded'

    /**
     * Raise the signal 'AccessPointAdded' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'AccessPointAdded'</b>:
     *
     * If the meaning of "AccessPointAdded" isn't clear, then there should be a description here.
     */
    void sendAccessPointAddedSignal(const ::std::string& accesspoint);

    // signal 'AccessPointRemoved'

    /**
     * Raise the signal 'AccessPointRemoved' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'AccessPointRemoved'</b>:
     *
     * If the meaning of "AccessPointRemoved" isn't clear, then there should be a description here.
     */
    void sendAccessPointRemovedSignal(const ::std::string& accesspoint);

    // method 'FindAccessPoint'

    /**
     * The method onFindAccessPoint() is called by ASF when a client invokes
     * the method 'FindAccessPoint'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendFindAccessPoint() or sendFindAccessPointError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'FindAccessPoint'</b>:
     *
     * If the meaning of "FindAccessPoint" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onFindAccessPointRequest (const ::boost::shared_ptr< FindAccessPointRequest >& request) = 0;

    /**
     * The method sendFindAccessPointResponse() sends a response of a previous
     * method invocation of 'FindAccessPoint' back to the client.
     *
     * <b>Documentation of 'FindAccessPoint'</b>:
     *
     * If the meaning of "FindAccessPoint" isn't clear, then there should be a description here.
     *
     * @param accesspoint If the meaning of "accesspoint" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onFindAccessPoint(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendFindAccessPointResponse (const ::std::string& accesspoint, act_t act = 0);

    /**
     * The method sendFindAccessPointError() sends an error response of a
     * previous method invocation of 'FindAccessPoint' back to the client.
     *
     * <b>Documentation of 'FindAccessPoint'</b>:
     *
     * If the meaning of "FindAccessPoint" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onFindAccessPoint(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendFindAccessPointError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RegisterAgent'

    /**
     * The method onRegisterAgent() is called by ASF when a client invokes the
     * method 'RegisterAgent'. A subclass has to implement this method and
     * send back a response to the client either with the sendRegisterAgent()
     * or sendRegisterAgentError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'RegisterAgent'</b>:
     *
     * If the meaning of "RegisterAgent" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRegisterAgentRequest (const ::boost::shared_ptr< RegisterAgentRequest >& request) = 0;

    /**
     * The method sendRegisterAgentResponse() sends a response of a previous
     * method invocation of 'RegisterAgent' back to the client.
     *
     * <b>Documentation of 'RegisterAgent'</b>:
     *
     * If the meaning of "RegisterAgent" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRegisterAgent(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRegisterAgentResponse (act_t act = 0);

    /**
     * The method sendRegisterAgentError() sends an error response of a
     * previous method invocation of 'RegisterAgent' back to the client.
     *
     * <b>Documentation of 'RegisterAgent'</b>:
     *
     * If the meaning of "RegisterAgent" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRegisterAgent(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRegisterAgentError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'UnregisterAgent'

    /**
     * The method onUnregisterAgent() is called by ASF when a client invokes
     * the method 'UnregisterAgent'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendUnregisterAgent() or sendUnregisterAgentError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'UnregisterAgent'</b>:
     *
     * If the meaning of "UnregisterAgent" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUnregisterAgentRequest (const ::boost::shared_ptr< UnregisterAgentRequest >& request) = 0;

    /**
     * The method sendUnregisterAgentResponse() sends a response of a previous
     * method invocation of 'UnregisterAgent' back to the client.
     *
     * <b>Documentation of 'UnregisterAgent'</b>:
     *
     * If the meaning of "UnregisterAgent" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onUnregisterAgent(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendUnregisterAgentResponse (act_t act = 0);

    /**
     * The method sendUnregisterAgentError() sends an error response of a
     * previous method invocation of 'UnregisterAgent' back to the client.
     *
     * <b>Documentation of 'UnregisterAgent'</b>:
     *
     * If the meaning of "UnregisterAgent" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onUnregisterAgent(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendUnregisterAgentError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetAccessPoints'

    /**
     * The method onGetAccessPoints() is called by ASF when a client invokes
     * the method 'GetAccessPoints'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetAccessPoints() or sendGetAccessPointsError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'GetAccessPoints'</b>:
     *
     * If the meaning of "GetAccessPoints" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetAccessPointsRequest (const ::boost::shared_ptr< GetAccessPointsRequest >& request) = 0;

    /**
     * The method sendGetAccessPointsResponse() sends a response of a previous
     * method invocation of 'GetAccessPoints' back to the client.
     *
     * <b>Documentation of 'GetAccessPoints'</b>:
     *
     * If the meaning of "GetAccessPoints" isn't clear, then there should be a description here.
     *
     * @param accesspoints If the meaning of "accesspoints" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetAccessPoints(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetAccessPointsResponse (const ::std::vector< GetAccessPointsResponseAccesspointsStruct >& accesspoints, act_t act = 0);

    /**
     * The method sendGetAccessPointsError() sends an error response of a
     * previous method invocation of 'GetAccessPoints' back to the client.
     *
     * <b>Documentation of 'GetAccessPoints'</b>:
     *
     * If the meaning of "GetAccessPoints" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetAccessPoints(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetAccessPointsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class ManagerStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Manager
} // namespace wapdman
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WAPDMAN_MANAGERSTUB_H
