/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wapdman/Accesspoint.h"
#include "org/bosch/wapdman/AccesspointDBus.h"
#include "org/bosch/wapdman/AccesspointJson.h"
#include "org/bosch/wapdman/AccesspointProxy.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

DEFINE_CLASS_LOGGER("//org/bosch/wapdman/AccessPoint_12_34_45_67_89_AB/org/bosch/wapdman/Accesspoint", AccesspointProxy);

class AccesspointProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    AccesspointProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< AccesspointProxy >& proxyShared = ::boost::static_pointer_cast< AccesspointProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_AssociatedStationsChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AssociatedStationsChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AssociatedStationsChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<AssociatedStationsChangedSignal> payload = ::boost::static_pointer_cast<AssociatedStationsChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((AssociatedStationsChangedCallbackIF*) _callback)->onAssociatedStationsChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_AssociationRequestRejected:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AssociationRequestRejectedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AssociationRequestRejected", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<AssociationRequestRejectedSignal> payload = ::boost::static_pointer_cast<AssociationRequestRejectedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((AssociationRequestRejectedCallbackIF*) _callback)->onAssociationRequestRejectedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SSID:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SSIDError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SSID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SSIDError> payload = ::boost::static_pointer_cast<SSIDError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SSIDCallbackIF*) _callback)->onSSIDError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SSIDUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SSID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SSIDUpdate> payload = ::boost::static_pointer_cast<SSIDUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SSIDCallbackIF*) _callback)->onSSIDUpdate(proxyShared, payload);
                        proxyShared->_sSID = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_MacAddress:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MacAddressError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MacAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MacAddressError> payload = ::boost::static_pointer_cast<MacAddressError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MacAddressCallbackIF*) _callback)->onMacAddressError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MacAddressUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MacAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MacAddressUpdate> payload = ::boost::static_pointer_cast<MacAddressUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MacAddressCallbackIF*) _callback)->onMacAddressUpdate(proxyShared, payload);
                        proxyShared->_macAddress = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Interface:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InterfaceError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Interface", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InterfaceError> payload = ::boost::static_pointer_cast<InterfaceError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((InterfaceCallbackIF*) _callback)->onInterfaceError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InterfaceUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Interface", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InterfaceUpdate> payload = ::boost::static_pointer_cast<InterfaceUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((InterfaceCallbackIF*) _callback)->onInterfaceUpdate(proxyShared, payload);
                        proxyShared->_interface = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_BlackListedStations:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlackListedStationsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BlackListedStations", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlackListedStationsError> payload = ::boost::static_pointer_cast<BlackListedStationsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BlackListedStationsCallbackIF*) _callback)->onBlackListedStationsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlackListedStationsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BlackListedStations", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlackListedStationsUpdate> payload = ::boost::static_pointer_cast<BlackListedStationsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BlackListedStationsCallbackIF*) _callback)->onBlackListedStationsUpdate(proxyShared, payload);
                        proxyShared->_blackListedStations = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Powered:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PoweredError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Powered", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PoweredError> payload = ::boost::static_pointer_cast<PoweredError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PoweredCallbackIF*) _callback)->onPoweredError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PoweredUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Powered", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PoweredUpdate> payload = ::boost::static_pointer_cast<PoweredUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PoweredCallbackIF*) _callback)->onPoweredUpdate(proxyShared, payload);
                        proxyShared->_powered = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Hidden:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HiddenError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Hidden", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HiddenError> payload = ::boost::static_pointer_cast<HiddenError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((HiddenCallbackIF*) _callback)->onHiddenError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HiddenUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Hidden", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HiddenUpdate> payload = ::boost::static_pointer_cast<HiddenUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((HiddenCallbackIF*) _callback)->onHiddenUpdate(proxyShared, payload);
                        proxyShared->_hidden = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Security:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SecurityError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Security", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SecurityError> payload = ::boost::static_pointer_cast<SecurityError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SecurityCallbackIF*) _callback)->onSecurityError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SecurityUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Security", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SecurityUpdate> payload = ::boost::static_pointer_cast<SecurityUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SecurityCallbackIF*) _callback)->onSecurityUpdate(proxyShared, payload);
                        proxyShared->_security = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Passphrase:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PassphraseError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Passphrase", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PassphraseError> payload = ::boost::static_pointer_cast<PassphraseError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PassphraseCallbackIF*) _callback)->onPassphraseError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PassphraseUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Passphrase", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PassphraseUpdate> payload = ::boost::static_pointer_cast<PassphraseUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PassphraseCallbackIF*) _callback)->onPassphraseUpdate(proxyShared, payload);
                        proxyShared->_passphrase = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_MaximumStationsAllowed:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MaximumStationsAllowedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MaximumStationsAllowed", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MaximumStationsAllowedError> payload = ::boost::static_pointer_cast<MaximumStationsAllowedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MaximumStationsAllowedCallbackIF*) _callback)->onMaximumStationsAllowedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MaximumStationsAllowedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MaximumStationsAllowed", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MaximumStationsAllowedUpdate> payload = ::boost::static_pointer_cast<MaximumStationsAllowedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MaximumStationsAllowedCallbackIF*) _callback)->onMaximumStationsAllowedUpdate(proxyShared, payload);
                        proxyShared->_maximumStationsAllowed = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PowerState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PowerStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PowerState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PowerStateError> payload = ::boost::static_pointer_cast<PowerStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PowerStateCallbackIF*) _callback)->onPowerStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PowerStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PowerState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PowerStateUpdate> payload = ::boost::static_pointer_cast<PowerStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PowerStateCallbackIF*) _callback)->onPowerStateUpdate(proxyShared, payload);
                        proxyShared->_powerState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PowerFailureReason:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PowerFailureReasonError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PowerFailureReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PowerFailureReasonError> payload = ::boost::static_pointer_cast<PowerFailureReasonError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PowerFailureReasonCallbackIF*) _callback)->onPowerFailureReasonError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PowerFailureReasonUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PowerFailureReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PowerFailureReasonUpdate> payload = ::boost::static_pointer_cast<PowerFailureReasonUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PowerFailureReasonCallbackIF*) _callback)->onPowerFailureReasonUpdate(proxyShared, payload);
                        proxyShared->_powerFailureReason = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CurrentOperatingChannel:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CurrentOperatingChannelError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CurrentOperatingChannel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CurrentOperatingChannelError> payload = ::boost::static_pointer_cast<CurrentOperatingChannelError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CurrentOperatingChannelCallbackIF*) _callback)->onCurrentOperatingChannelError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CurrentOperatingChannelUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CurrentOperatingChannel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CurrentOperatingChannelUpdate> payload = ::boost::static_pointer_cast<CurrentOperatingChannelUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CurrentOperatingChannelCallbackIF*) _callback)->onCurrentOperatingChannelUpdate(proxyShared, payload);
                        proxyShared->_currentOperatingChannel = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CurrentHwMode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CurrentHwModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CurrentHwMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CurrentHwModeError> payload = ::boost::static_pointer_cast<CurrentHwModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CurrentHwModeCallbackIF*) _callback)->onCurrentHwModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CurrentHwModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CurrentHwMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CurrentHwModeUpdate> payload = ::boost::static_pointer_cast<CurrentHwModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CurrentHwModeCallbackIF*) _callback)->onCurrentHwModeUpdate(proxyShared, payload);
                        proxyShared->_currentHwMode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SupportedChannels:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SupportedChannelsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SupportedChannels", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SupportedChannelsError> payload = ::boost::static_pointer_cast<SupportedChannelsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SupportedChannelsCallbackIF*) _callback)->onSupportedChannelsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SupportedChannelsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SupportedChannels", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SupportedChannelsUpdate> payload = ::boost::static_pointer_cast<SupportedChannelsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SupportedChannelsCallbackIF*) _callback)->onSupportedChannelsUpdate(proxyShared, payload);
                        proxyShared->_supportedChannels = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_HWFeatures:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HWFeaturesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "HWFeatures", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HWFeaturesError> payload = ::boost::static_pointer_cast<HWFeaturesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((HWFeaturesCallbackIF*) _callback)->onHWFeaturesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HWFeaturesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "HWFeatures", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HWFeaturesUpdate> payload = ::boost::static_pointer_cast<HWFeaturesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((HWFeaturesCallbackIF*) _callback)->onHWFeaturesUpdate(proxyShared, payload);
                        proxyShared->_hWFeatures = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_VendorIEs:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VendorIEsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VendorIEs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VendorIEsError> payload = ::boost::static_pointer_cast<VendorIEsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((VendorIEsCallbackIF*) _callback)->onVendorIEsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VendorIEsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VendorIEs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VendorIEsUpdate> payload = ::boost::static_pointer_cast<VendorIEsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((VendorIEsCallbackIF*) _callback)->onVendorIEsUpdate(proxyShared, payload);
                        proxyShared->_vendorIEs = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_setSSID:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetSSIDError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetSSID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetSSIDError> payload = ::boost::static_pointer_cast<SetSSIDError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetSSIDCallbackIF*) _callback)->onSetSSIDError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetSSIDResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetSSID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetSSIDResponse> payload = ::boost::static_pointer_cast<SetSSIDResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetSSIDCallbackIF*) _callback)->onSetSSIDResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_DeAuthenticateStation:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DeAuthenticateStationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeAuthenticateStation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeAuthenticateStationError> payload = ::boost::static_pointer_cast<DeAuthenticateStationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeAuthenticateStationCallbackIF*) _callback)->onDeAuthenticateStationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeAuthenticateStationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeAuthenticateStation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeAuthenticateStationResponse> payload = ::boost::static_pointer_cast<DeAuthenticateStationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeAuthenticateStationCallbackIF*) _callback)->onDeAuthenticateStationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_BlacklistStation:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BlacklistStationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BlacklistStation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlacklistStationError> payload = ::boost::static_pointer_cast<BlacklistStationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BlacklistStationCallbackIF*) _callback)->onBlacklistStationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlacklistStationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BlacklistStation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlacklistStationResponse> payload = ::boost::static_pointer_cast<BlacklistStationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BlacklistStationCallbackIF*) _callback)->onBlacklistStationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetOperatingChannels:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetOperatingChannelsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetOperatingChannels", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetOperatingChannelsError> payload = ::boost::static_pointer_cast<SetOperatingChannelsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetOperatingChannelsCallbackIF*) _callback)->onSetOperatingChannelsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetOperatingChannelsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetOperatingChannels", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetOperatingChannelsResponse> payload = ::boost::static_pointer_cast<SetOperatingChannelsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetOperatingChannelsCallbackIF*) _callback)->onSetOperatingChannelsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_StartWPSPushButton:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartWPSPushButtonError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartWPSPushButton", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartWPSPushButtonError> payload = ::boost::static_pointer_cast<StartWPSPushButtonError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartWPSPushButtonCallbackIF*) _callback)->onStartWPSPushButtonError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartWPSPushButtonResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartWPSPushButton", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartWPSPushButtonResponse> payload = ::boost::static_pointer_cast<StartWPSPushButtonResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartWPSPushButtonCallbackIF*) _callback)->onStartWPSPushButtonResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_CancelWPS:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CancelWPSError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelWPS", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelWPSError> payload = ::boost::static_pointer_cast<CancelWPSError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelWPSCallbackIF*) _callback)->onCancelWPSError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelWPSResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelWPS", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelWPSResponse> payload = ::boost::static_pointer_cast<CancelWPSResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelWPSCallbackIF*) _callback)->onCancelWPSResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetAssociatedStations:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetAssociatedStationsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAssociatedStations", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetAssociatedStationsError> payload = ::boost::static_pointer_cast<GetAssociatedStationsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetAssociatedStationsCallbackIF*) _callback)->onGetAssociatedStationsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetAssociatedStationsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAssociatedStations", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetAssociatedStationsResponse> payload = ::boost::static_pointer_cast<GetAssociatedStationsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetAssociatedStationsCallbackIF*) _callback)->onGetAssociatedStationsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RegisterVendorService:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RegisterVendorServiceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterVendorService", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterVendorServiceError> payload = ::boost::static_pointer_cast<RegisterVendorServiceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterVendorServiceCallbackIF*) _callback)->onRegisterVendorServiceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterVendorServiceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterVendorService", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterVendorServiceResponse> payload = ::boost::static_pointer_cast<RegisterVendorServiceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterVendorServiceCallbackIF*) _callback)->onRegisterVendorServiceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UnregisterVendorService:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterVendorServiceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterVendorService", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnregisterVendorServiceError> payload = ::boost::static_pointer_cast<UnregisterVendorServiceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnregisterVendorServiceCallbackIF*) _callback)->onUnregisterVendorServiceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterVendorServiceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterVendorService", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnregisterVendorServiceResponse> payload = ::boost::static_pointer_cast<UnregisterVendorServiceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnregisterVendorServiceCallbackIF*) _callback)->onUnregisterVendorServiceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetDnsDhcpConf:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetDnsDhcpConfError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetDnsDhcpConf", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetDnsDhcpConfError> payload = ::boost::static_pointer_cast<GetDnsDhcpConfError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetDnsDhcpConfCallbackIF*) _callback)->onGetDnsDhcpConfError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetDnsDhcpConfResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetDnsDhcpConf", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetDnsDhcpConfResponse> payload = ::boost::static_pointer_cast<GetDnsDhcpConfResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetDnsDhcpConfCallbackIF*) _callback)->onGetDnsDhcpConfResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_AssociatedStationsChanged: {
                ::boost::shared_ptr< AssociatedStationsChangedError > payload = ::boost::shared_ptr< AssociatedStationsChangedError >
                (new AssociatedStationsChangedError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AssociatedStationsChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AssociatedStationsChangedCallbackIF*) _callback)->onAssociatedStationsChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AssociationRequestRejected: {
                ::boost::shared_ptr< AssociationRequestRejectedError > payload = ::boost::shared_ptr< AssociationRequestRejectedError >
                (new AssociationRequestRejectedError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AssociationRequestRejected", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AssociationRequestRejectedCallbackIF*) _callback)->onAssociationRequestRejectedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SSID: {
                ::boost::shared_ptr< SSIDError > payload = ::boost::shared_ptr< SSIDError >
                (new SSIDError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SSID", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SSIDCallbackIF*) _callback)->onSSIDError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MacAddress: {
                ::boost::shared_ptr< MacAddressError > payload = ::boost::shared_ptr< MacAddressError >
                (new MacAddressError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MacAddress", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MacAddressCallbackIF*) _callback)->onMacAddressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Interface: {
                ::boost::shared_ptr< InterfaceError > payload = ::boost::shared_ptr< InterfaceError >
                (new InterfaceError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Interface", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InterfaceCallbackIF*) _callback)->onInterfaceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BlackListedStations: {
                ::boost::shared_ptr< BlackListedStationsError > payload = ::boost::shared_ptr< BlackListedStationsError >
                (new BlackListedStationsError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BlackListedStations", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BlackListedStationsCallbackIF*) _callback)->onBlackListedStationsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Powered: {
                ::boost::shared_ptr< PoweredError > payload = ::boost::shared_ptr< PoweredError >
                (new PoweredError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Powered", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PoweredCallbackIF*) _callback)->onPoweredError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Hidden: {
                ::boost::shared_ptr< HiddenError > payload = ::boost::shared_ptr< HiddenError >
                (new HiddenError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Hidden", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HiddenCallbackIF*) _callback)->onHiddenError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Security: {
                ::boost::shared_ptr< SecurityError > payload = ::boost::shared_ptr< SecurityError >
                (new SecurityError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Security", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SecurityCallbackIF*) _callback)->onSecurityError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Passphrase: {
                ::boost::shared_ptr< PassphraseError > payload = ::boost::shared_ptr< PassphraseError >
                (new PassphraseError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Passphrase", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PassphraseCallbackIF*) _callback)->onPassphraseError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MaximumStationsAllowed: {
                ::boost::shared_ptr< MaximumStationsAllowedError > payload = ::boost::shared_ptr< MaximumStationsAllowedError >
                (new MaximumStationsAllowedError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MaximumStationsAllowed", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MaximumStationsAllowedCallbackIF*) _callback)->onMaximumStationsAllowedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PowerState: {
                ::boost::shared_ptr< PowerStateError > payload = ::boost::shared_ptr< PowerStateError >
                (new PowerStateError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PowerState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PowerStateCallbackIF*) _callback)->onPowerStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PowerFailureReason: {
                ::boost::shared_ptr< PowerFailureReasonError > payload = ::boost::shared_ptr< PowerFailureReasonError >
                (new PowerFailureReasonError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PowerFailureReason", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PowerFailureReasonCallbackIF*) _callback)->onPowerFailureReasonError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CurrentOperatingChannel: {
                ::boost::shared_ptr< CurrentOperatingChannelError > payload = ::boost::shared_ptr< CurrentOperatingChannelError >
                (new CurrentOperatingChannelError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CurrentOperatingChannel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CurrentOperatingChannelCallbackIF*) _callback)->onCurrentOperatingChannelError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CurrentHwMode: {
                ::boost::shared_ptr< CurrentHwModeError > payload = ::boost::shared_ptr< CurrentHwModeError >
                (new CurrentHwModeError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CurrentHwMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CurrentHwModeCallbackIF*) _callback)->onCurrentHwModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SupportedChannels: {
                ::boost::shared_ptr< SupportedChannelsError > payload = ::boost::shared_ptr< SupportedChannelsError >
                (new SupportedChannelsError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SupportedChannels", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SupportedChannelsCallbackIF*) _callback)->onSupportedChannelsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_HWFeatures: {
                ::boost::shared_ptr< HWFeaturesError > payload = ::boost::shared_ptr< HWFeaturesError >
                (new HWFeaturesError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "HWFeatures", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HWFeaturesCallbackIF*) _callback)->onHWFeaturesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_VendorIEs: {
                ::boost::shared_ptr< VendorIEsError > payload = ::boost::shared_ptr< VendorIEsError >
                (new VendorIEsError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "VendorIEs", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VendorIEsCallbackIF*) _callback)->onVendorIEsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setSSID: {
                ::boost::shared_ptr< SetSSIDError > payload = ::boost::shared_ptr< SetSSIDError >
                (new SetSSIDError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetSSID", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetSSIDCallbackIF*) _callback)->onSetSSIDError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DeAuthenticateStation: {
                ::boost::shared_ptr< DeAuthenticateStationError > payload = ::boost::shared_ptr< DeAuthenticateStationError >
                (new DeAuthenticateStationError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeAuthenticateStation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeAuthenticateStationCallbackIF*) _callback)->onDeAuthenticateStationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BlacklistStation: {
                ::boost::shared_ptr< BlacklistStationError > payload = ::boost::shared_ptr< BlacklistStationError >
                (new BlacklistStationError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BlacklistStation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BlacklistStationCallbackIF*) _callback)->onBlacklistStationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetOperatingChannels: {
                ::boost::shared_ptr< SetOperatingChannelsError > payload = ::boost::shared_ptr< SetOperatingChannelsError >
                (new SetOperatingChannelsError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetOperatingChannels", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetOperatingChannelsCallbackIF*) _callback)->onSetOperatingChannelsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartWPSPushButton: {
                ::boost::shared_ptr< StartWPSPushButtonError > payload = ::boost::shared_ptr< StartWPSPushButtonError >
                (new StartWPSPushButtonError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartWPSPushButton", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartWPSPushButtonCallbackIF*) _callback)->onStartWPSPushButtonError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CancelWPS: {
                ::boost::shared_ptr< CancelWPSError > payload = ::boost::shared_ptr< CancelWPSError >
                (new CancelWPSError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CancelWPS", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CancelWPSCallbackIF*) _callback)->onCancelWPSError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetAssociatedStations: {
                ::boost::shared_ptr< GetAssociatedStationsError > payload = ::boost::shared_ptr< GetAssociatedStationsError >
                (new GetAssociatedStationsError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetAssociatedStations", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetAssociatedStationsCallbackIF*) _callback)->onGetAssociatedStationsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RegisterVendorService: {
                ::boost::shared_ptr< RegisterVendorServiceError > payload = ::boost::shared_ptr< RegisterVendorServiceError >
                (new RegisterVendorServiceError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RegisterVendorService", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RegisterVendorServiceCallbackIF*) _callback)->onRegisterVendorServiceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnregisterVendorService: {
                ::boost::shared_ptr< UnregisterVendorServiceError > payload = ::boost::shared_ptr< UnregisterVendorServiceError >
                (new UnregisterVendorServiceError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnregisterVendorService", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnregisterVendorServiceCallbackIF*) _callback)->onUnregisterVendorServiceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetDnsDhcpConf: {
                ::boost::shared_ptr< GetDnsDhcpConfError > payload = ::boost::shared_ptr< GetDnsDhcpConfError >
                (new GetDnsDhcpConfError(DBUS_ERROR_NO_SERVER, "The DBus service Accesspoint is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetDnsDhcpConf", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AccesspointProxy> proxyShared = ::boost::static_pointer_cast<AccesspointProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetDnsDhcpConfCallbackIF*) _callback)->onGetDnsDhcpConfError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& AccesspointProxyCallback::_logger (AccesspointProxy::_logger);

AccesspointProxy::AccesspointProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.wapdman.Accesspoint", serviceAvailable, _logger) {
}

AccesspointProxy::~AccesspointProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< AccesspointProxy > AccesspointProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<AccesspointProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< AccesspointProxy > proxyNew(new AccesspointProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t AccesspointProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t AccesspointProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void AccesspointProxy::clearAllProperties ()
{
    _sSID = ::asf::core::nullable< SSIDUpdate >();
    _macAddress = ::asf::core::nullable< MacAddressUpdate >();
    _interface = ::asf::core::nullable< InterfaceUpdate >();
    _blackListedStations = ::asf::core::nullable< BlackListedStationsUpdate >();
    _powered = ::asf::core::nullable< PoweredUpdate >();
    _hidden = ::asf::core::nullable< HiddenUpdate >();
    _security = ::asf::core::nullable< SecurityUpdate >();
    _passphrase = ::asf::core::nullable< PassphraseUpdate >();
    _maximumStationsAllowed = ::asf::core::nullable< MaximumStationsAllowedUpdate >();
    _powerState = ::asf::core::nullable< PowerStateUpdate >();
    _powerFailureReason = ::asf::core::nullable< PowerFailureReasonUpdate >();
    _currentOperatingChannel = ::asf::core::nullable< CurrentOperatingChannelUpdate >();
    _currentHwMode = ::asf::core::nullable< CurrentHwModeUpdate >();
    _supportedChannels = ::asf::core::nullable< SupportedChannelsUpdate >();
    _hWFeatures = ::asf::core::nullable< HWFeaturesUpdate >();
    _vendorIEs = ::asf::core::nullable< VendorIEsUpdate >();
}

void AccesspointProxy::sendDeregisterAll () const
{
    sendSSIDDeregisterAll();
    sendMacAddressDeregisterAll();
    sendInterfaceDeregisterAll();
    sendBlackListedStationsDeregisterAll();
    sendPoweredDeregisterAll();
    sendHiddenDeregisterAll();
    sendSecurityDeregisterAll();
    sendPassphraseDeregisterAll();
    sendMaximumStationsAllowedDeregisterAll();
    sendPowerStateDeregisterAll();
    sendPowerFailureReasonDeregisterAll();
    sendCurrentOperatingChannelDeregisterAll();
    sendCurrentHwModeDeregisterAll();
    sendSupportedChannelsDeregisterAll();
    sendHWFeaturesDeregisterAll();
    sendVendorIEsDeregisterAll();
    sendAssociatedStationsChangedDeregisterAll();
    sendAssociationRequestRejectedDeregisterAll();
}

act_t AccesspointProxy::sendAssociatedStationsChangedRegister(AssociatedStationsChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "AssociatedStationsChanged");
    act_t act = addSignalCallback(ID_AssociatedStationsChanged, "AssociatedStationsChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AssociatedStationsChanged", &cb, act);
    return act;
}

bool AccesspointProxy::sendAssociatedStationsChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AssociatedStationsChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AssociatedStationsChanged", act, static_cast<int>(rv));
    return rv;
}

void AccesspointProxy::sendAssociatedStationsChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AssociatedStationsChanged");
    _dbusProxyDelegate->deregisterSignalCallback("AssociatedStationsChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t AccesspointProxy::sendAssociationRequestRejectedRegister(AssociationRequestRejectedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "AssociationRequestRejected");
    act_t act = addSignalCallback(ID_AssociationRequestRejected, "AssociationRequestRejected", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AssociationRequestRejected", &cb, act);
    return act;
}

bool AccesspointProxy::sendAssociationRequestRejectedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AssociationRequestRejected", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AssociationRequestRejected", act, static_cast<int>(rv));
    return rv;
}

void AccesspointProxy::sendAssociationRequestRejectedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AssociationRequestRejected");
    _dbusProxyDelegate->deregisterSignalCallback("AssociationRequestRejected", 0, _dbusDaemonProxy.get(), false);
}

act_t AccesspointProxy::sendSSIDRegister(SSIDCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SSID, "SSID", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SSID", &cb, act);
    return act;
}

bool AccesspointProxy::sendSSIDDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SSID", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SSID", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendSSIDGet(SSIDCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_SSID, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SSID", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SSID", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< uint8 >& AccesspointProxy::getSSID() const {
    return _sSID.get().getSSID();
}

bool AccesspointProxy::hasSSID() const {
    return _sSID.hasValue();
}

void AccesspointProxy::sendSSIDDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SSID");
    _dbusProxyDelegate->deregisterSignalCallback("SSID", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendMacAddressRegister(MacAddressCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_MacAddress, "MacAddress", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MacAddress", &cb, act);
    return act;
}

bool AccesspointProxy::sendMacAddressDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MacAddress", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MacAddress", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendMacAddressGet(MacAddressCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_MacAddress, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MacAddress", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("MacAddress", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& AccesspointProxy::getMacAddress() const {
    return _macAddress.get().getMacAddress();
}

bool AccesspointProxy::hasMacAddress() const {
    return _macAddress.hasValue();
}

void AccesspointProxy::sendMacAddressDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MacAddress");
    _dbusProxyDelegate->deregisterSignalCallback("MacAddress", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendInterfaceRegister(InterfaceCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Interface, "Interface", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Interface", &cb, act);
    return act;
}

bool AccesspointProxy::sendInterfaceDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Interface", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Interface", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendInterfaceGet(InterfaceCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_Interface, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Interface", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Interface", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& AccesspointProxy::getInterface() const {
    return _interface.get().getInterface();
}

bool AccesspointProxy::hasInterface() const {
    return _interface.hasValue();
}

void AccesspointProxy::sendInterfaceDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Interface");
    _dbusProxyDelegate->deregisterSignalCallback("Interface", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendBlackListedStationsRegister(BlackListedStationsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_BlackListedStations, "BlackListedStations", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BlackListedStations", &cb, act);
    return act;
}

bool AccesspointProxy::sendBlackListedStationsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BlackListedStations", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BlackListedStations", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendBlackListedStationsGet(BlackListedStationsCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_BlackListedStations, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BlackListedStations", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("BlackListedStations", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& AccesspointProxy::getBlackListedStations() const {
    return _blackListedStations.get().getBlackListedStations();
}

bool AccesspointProxy::hasBlackListedStations() const {
    return _blackListedStations.hasValue();
}

void AccesspointProxy::sendBlackListedStationsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BlackListedStations");
    _dbusProxyDelegate->deregisterSignalCallback("BlackListedStations", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendPoweredRegister(PoweredCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Powered, "Powered", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Powered", &cb, act);
    return act;
}

bool AccesspointProxy::sendPoweredDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Powered", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Powered", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendPoweredGet(PoweredCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_Powered, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Powered", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Powered", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void AccesspointProxy::sendPoweredSet(bool powered) {
    PoweredSet parameter(powered);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Powered");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Powered", propertyContent);
}

act_t AccesspointProxy::sendPoweredSet(PoweredCallbackIF& cb, bool powered) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_Powered, &cb);
    PoweredSet parameter(powered);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Powered", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Powered", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool AccesspointProxy::getPowered() const {
    return _powered.get().getPowered();
}

bool AccesspointProxy::hasPowered() const {
    return _powered.hasValue();
}

void AccesspointProxy::sendPoweredDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Powered");
    _dbusProxyDelegate->deregisterSignalCallback("Powered", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendHiddenRegister(HiddenCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Hidden, "Hidden", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Hidden", &cb, act);
    return act;
}

bool AccesspointProxy::sendHiddenDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Hidden", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Hidden", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendHiddenGet(HiddenCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_Hidden, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Hidden", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Hidden", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void AccesspointProxy::sendHiddenSet(bool hidden) {
    HiddenSet parameter(hidden);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Hidden");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Hidden", propertyContent);
}

act_t AccesspointProxy::sendHiddenSet(HiddenCallbackIF& cb, bool hidden) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_Hidden, &cb);
    HiddenSet parameter(hidden);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Hidden", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Hidden", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool AccesspointProxy::getHidden() const {
    return _hidden.get().getHidden();
}

bool AccesspointProxy::hasHidden() const {
    return _hidden.hasValue();
}

void AccesspointProxy::sendHiddenDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Hidden");
    _dbusProxyDelegate->deregisterSignalCallback("Hidden", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendSecurityRegister(SecurityCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Security, "Security", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Security", &cb, act);
    return act;
}

bool AccesspointProxy::sendSecurityDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Security", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Security", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendSecurityGet(SecurityCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_Security, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Security", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Security", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void AccesspointProxy::sendSecuritySet(const ::std::string& security) {
    SecuritySet parameter(security);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Security");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Security", propertyContent);
}

act_t AccesspointProxy::sendSecuritySet(SecurityCallbackIF& cb, const ::std::string& security) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_Security, &cb);
    SecuritySet parameter(security);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Security", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Security", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::string& AccesspointProxy::getSecurity() const {
    return _security.get().getSecurity();
}

bool AccesspointProxy::hasSecurity() const {
    return _security.hasValue();
}

void AccesspointProxy::sendSecurityDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Security");
    _dbusProxyDelegate->deregisterSignalCallback("Security", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendPassphraseRegister(PassphraseCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Passphrase, "Passphrase", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Passphrase", &cb, act);
    return act;
}

bool AccesspointProxy::sendPassphraseDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Passphrase", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Passphrase", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendPassphraseGet(PassphraseCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_Passphrase, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Passphrase", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Passphrase", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void AccesspointProxy::sendPassphraseSet(const ::std::string& passphrase) {
    PassphraseSet parameter(passphrase);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Passphrase");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Passphrase", propertyContent);
}

act_t AccesspointProxy::sendPassphraseSet(PassphraseCallbackIF& cb, const ::std::string& passphrase) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_Passphrase, &cb);
    PassphraseSet parameter(passphrase);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Passphrase", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Passphrase", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::string& AccesspointProxy::getPassphrase() const {
    return _passphrase.get().getPassphrase();
}

bool AccesspointProxy::hasPassphrase() const {
    return _passphrase.hasValue();
}

void AccesspointProxy::sendPassphraseDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Passphrase");
    _dbusProxyDelegate->deregisterSignalCallback("Passphrase", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendMaximumStationsAllowedRegister(MaximumStationsAllowedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_MaximumStationsAllowed, "MaximumStationsAllowed", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MaximumStationsAllowed", &cb, act);
    return act;
}

bool AccesspointProxy::sendMaximumStationsAllowedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MaximumStationsAllowed", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MaximumStationsAllowed", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendMaximumStationsAllowedGet(MaximumStationsAllowedCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_MaximumStationsAllowed, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MaximumStationsAllowed", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("MaximumStationsAllowed", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint16 AccesspointProxy::getMaximumStationsAllowed() const {
    return _maximumStationsAllowed.get().getMaximumStationsAllowed();
}

bool AccesspointProxy::hasMaximumStationsAllowed() const {
    return _maximumStationsAllowed.hasValue();
}

void AccesspointProxy::sendMaximumStationsAllowedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MaximumStationsAllowed");
    _dbusProxyDelegate->deregisterSignalCallback("MaximumStationsAllowed", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendPowerStateRegister(PowerStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PowerState, "PowerState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PowerState", &cb, act);
    return act;
}

bool AccesspointProxy::sendPowerStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PowerState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PowerState", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendPowerStateGet(PowerStateCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_PowerState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PowerState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PowerState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& AccesspointProxy::getPowerState() const {
    return _powerState.get().getPowerState();
}

bool AccesspointProxy::hasPowerState() const {
    return _powerState.hasValue();
}

void AccesspointProxy::sendPowerStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PowerState");
    _dbusProxyDelegate->deregisterSignalCallback("PowerState", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendPowerFailureReasonRegister(PowerFailureReasonCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PowerFailureReason, "PowerFailureReason", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PowerFailureReason", &cb, act);
    return act;
}

bool AccesspointProxy::sendPowerFailureReasonDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PowerFailureReason", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PowerFailureReason", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendPowerFailureReasonGet(PowerFailureReasonCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_PowerFailureReason, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PowerFailureReason", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PowerFailureReason", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& AccesspointProxy::getPowerFailureReason() const {
    return _powerFailureReason.get().getPowerFailureReason();
}

bool AccesspointProxy::hasPowerFailureReason() const {
    return _powerFailureReason.hasValue();
}

void AccesspointProxy::sendPowerFailureReasonDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PowerFailureReason");
    _dbusProxyDelegate->deregisterSignalCallback("PowerFailureReason", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendCurrentOperatingChannelRegister(CurrentOperatingChannelCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CurrentOperatingChannel, "CurrentOperatingChannel", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CurrentOperatingChannel", &cb, act);
    return act;
}

bool AccesspointProxy::sendCurrentOperatingChannelDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CurrentOperatingChannel", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CurrentOperatingChannel", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendCurrentOperatingChannelGet(CurrentOperatingChannelCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_CurrentOperatingChannel, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CurrentOperatingChannel", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CurrentOperatingChannel", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint16 AccesspointProxy::getCurrentOperatingChannel() const {
    return _currentOperatingChannel.get().getCurrentOperatingChannel();
}

bool AccesspointProxy::hasCurrentOperatingChannel() const {
    return _currentOperatingChannel.hasValue();
}

void AccesspointProxy::sendCurrentOperatingChannelDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CurrentOperatingChannel");
    _dbusProxyDelegate->deregisterSignalCallback("CurrentOperatingChannel", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendCurrentHwModeRegister(CurrentHwModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CurrentHwMode, "CurrentHwMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CurrentHwMode", &cb, act);
    return act;
}

bool AccesspointProxy::sendCurrentHwModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CurrentHwMode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CurrentHwMode", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendCurrentHwModeGet(CurrentHwModeCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_CurrentHwMode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CurrentHwMode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CurrentHwMode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& AccesspointProxy::getCurrentHwMode() const {
    return _currentHwMode.get().getCurrentHwMode();
}

bool AccesspointProxy::hasCurrentHwMode() const {
    return _currentHwMode.hasValue();
}

void AccesspointProxy::sendCurrentHwModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CurrentHwMode");
    _dbusProxyDelegate->deregisterSignalCallback("CurrentHwMode", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendSupportedChannelsRegister(SupportedChannelsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SupportedChannels, "SupportedChannels", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SupportedChannels", &cb, act);
    return act;
}

bool AccesspointProxy::sendSupportedChannelsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SupportedChannels", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SupportedChannels", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendSupportedChannelsGet(SupportedChannelsCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_SupportedChannels, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SupportedChannels", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SupportedChannels", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& AccesspointProxy::getSupportedChannels() const {
    return _supportedChannels.get().getSupportedChannels();
}

bool AccesspointProxy::hasSupportedChannels() const {
    return _supportedChannels.hasValue();
}

void AccesspointProxy::sendSupportedChannelsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SupportedChannels");
    _dbusProxyDelegate->deregisterSignalCallback("SupportedChannels", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendHWFeaturesRegister(HWFeaturesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_HWFeatures, "HWFeatures", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "HWFeatures", &cb, act);
    return act;
}

bool AccesspointProxy::sendHWFeaturesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("HWFeatures", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "HWFeatures", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendHWFeaturesGet(HWFeaturesCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_HWFeatures, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "HWFeatures", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("HWFeatures", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& AccesspointProxy::getHWFeatures() const {
    return _hWFeatures.get().getHWFeatures();
}

bool AccesspointProxy::hasHWFeatures() const {
    return _hWFeatures.hasValue();
}

void AccesspointProxy::sendHWFeaturesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "HWFeatures");
    _dbusProxyDelegate->deregisterSignalCallback("HWFeatures", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendVendorIEsRegister(VendorIEsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_VendorIEs, "VendorIEs", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "VendorIEs", &cb, act);
    return act;
}

bool AccesspointProxy::sendVendorIEsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("VendorIEs", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "VendorIEs", act, static_cast<int>(rv));
    return rv;
}

act_t AccesspointProxy::sendVendorIEsGet(VendorIEsCallbackIF& cb) {
    AccesspointProxyCallback* callback = new AccesspointProxyCallback(ID_VendorIEs, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "VendorIEs", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("VendorIEs", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< VendorIEsStruct >& AccesspointProxy::getVendorIEs() const {
    return _vendorIEs.get().getVendorIEs();
}

bool AccesspointProxy::hasVendorIEs() const {
    return _vendorIEs.hasValue();
}

void AccesspointProxy::sendVendorIEsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "VendorIEs");
    _dbusProxyDelegate->deregisterSignalCallback("VendorIEs", 0, _dbusDaemonProxy.get(), true);
}

act_t AccesspointProxy::sendSetSSIDRequest(SetSSIDCallbackIF& cb, const ::std::vector< uint8 >& ssid, bool utf_ssid) const {
    SetSSIDRequest* payload = new SetSSIDRequest();
    CHECK_ALLOCATION(payload);
    payload->setSsid(ssid);
    payload->setUtf_ssid(utf_ssid);
    DBUS_MESSAGE_CALL(dbusMessage, "setSSID", SetSSIDRequest, payload, true)
    act_t act = addMethodCallback(ID_setSSID, dbusMessage.getUniqueSerial(), "setSSID", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetSSID", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AccesspointProxy::sendDeAuthenticateStationRequest(DeAuthenticateStationCallbackIF& cb, const ::std::string& address) const {
    DeAuthenticateStationRequest* payload = new DeAuthenticateStationRequest();
    CHECK_ALLOCATION(payload);
    payload->setAddress(address);
    DBUS_MESSAGE_CALL(dbusMessage, "DeAuthenticateStation", DeAuthenticateStationRequest, payload, true)
    act_t act = addMethodCallback(ID_DeAuthenticateStation, dbusMessage.getUniqueSerial(), "DeAuthenticateStation", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DeAuthenticateStation", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AccesspointProxy::sendBlacklistStationRequest(BlacklistStationCallbackIF& cb, const ::std::string& address, bool allow) const {
    BlacklistStationRequest* payload = new BlacklistStationRequest();
    CHECK_ALLOCATION(payload);
    payload->setAddress(address);
    payload->setAllow(allow);
    DBUS_MESSAGE_CALL(dbusMessage, "BlacklistStation", BlacklistStationRequest, payload, true)
    act_t act = addMethodCallback(ID_BlacklistStation, dbusMessage.getUniqueSerial(), "BlacklistStation", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BlacklistStation", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AccesspointProxy::sendSetOperatingChannelsRequest(SetOperatingChannelsCallbackIF& cb, const ::std::vector< uint16 >& channels) const {
    SetOperatingChannelsRequest* payload = new SetOperatingChannelsRequest();
    CHECK_ALLOCATION(payload);
    payload->setChannels(channels);
    DBUS_MESSAGE_CALL(dbusMessage, "SetOperatingChannels", SetOperatingChannelsRequest, payload, true)
    act_t act = addMethodCallback(ID_SetOperatingChannels, dbusMessage.getUniqueSerial(), "SetOperatingChannels", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetOperatingChannels", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AccesspointProxy::sendStartWPSPushButtonRequest(StartWPSPushButtonCallbackIF& cb) const {
    StartWPSPushButtonRequest* payload = new StartWPSPushButtonRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "StartWPSPushButton", StartWPSPushButtonRequest, payload, true)
    act_t act = addMethodCallback(ID_StartWPSPushButton, dbusMessage.getUniqueSerial(), "StartWPSPushButton", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartWPSPushButton", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AccesspointProxy::sendCancelWPSRequest(CancelWPSCallbackIF& cb) const {
    CancelWPSRequest* payload = new CancelWPSRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "CancelWPS", CancelWPSRequest, payload, true)
    act_t act = addMethodCallback(ID_CancelWPS, dbusMessage.getUniqueSerial(), "CancelWPS", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CancelWPS", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AccesspointProxy::sendGetAssociatedStationsRequest(GetAssociatedStationsCallbackIF& cb) const {
    GetAssociatedStationsRequest* payload = new GetAssociatedStationsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetAssociatedStations", GetAssociatedStationsRequest, payload, true)
    act_t act = addMethodCallback(ID_GetAssociatedStations, dbusMessage.getUniqueSerial(), "GetAssociatedStations", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetAssociatedStations", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AccesspointProxy::sendRegisterVendorServiceRequest(RegisterVendorServiceCallbackIF& cb, const ::std::vector< ::std::vector< uint8 > >& iEs) const {
    RegisterVendorServiceRequest* payload = new RegisterVendorServiceRequest();
    CHECK_ALLOCATION(payload);
    payload->setIEs(iEs);
    DBUS_MESSAGE_CALL(dbusMessage, "RegisterVendorService", RegisterVendorServiceRequest, payload, true)
    act_t act = addMethodCallback(ID_RegisterVendorService, dbusMessage.getUniqueSerial(), "RegisterVendorService", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RegisterVendorService", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AccesspointProxy::sendUnregisterVendorServiceRequest(UnregisterVendorServiceCallbackIF& cb, const ::std::vector< ::std::vector< uint8 > >& iEs) const {
    UnregisterVendorServiceRequest* payload = new UnregisterVendorServiceRequest();
    CHECK_ALLOCATION(payload);
    payload->setIEs(iEs);
    DBUS_MESSAGE_CALL(dbusMessage, "UnregisterVendorService", UnregisterVendorServiceRequest, payload, true)
    act_t act = addMethodCallback(ID_UnregisterVendorService, dbusMessage.getUniqueSerial(), "UnregisterVendorService", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UnregisterVendorService", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AccesspointProxy::sendGetDnsDhcpConfRequest(GetDnsDhcpConfCallbackIF& cb) const {
    GetDnsDhcpConfRequest* payload = new GetDnsDhcpConfRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetDnsDhcpConf", GetDnsDhcpConfRequest, payload, true)
    act_t act = addMethodCallback(ID_GetDnsDhcpConf, dbusMessage.getUniqueSerial(), "GetDnsDhcpConf", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetDnsDhcpConf", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
