/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wapdman/Accesspoint/TetheringSettings.h"
#include "org/bosch/wapdman/Accesspoint/TetheringSettingsDBus.h"
#include "org/bosch/wapdman/Accesspoint/TetheringSettingsJson.h"
#include "org/bosch/wapdman/Accesspoint/TetheringSettingsProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {
namespace TetheringSettings {

DEFINE_CLASS_LOGGER("//org/bosch/wapdman/AccessPoint_12_34_45_67_89_AB/org/bosch/wapdman/Accesspoint/TetheringSettings", TetheringSettingsProxy);

class TetheringSettingsProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    TetheringSettingsProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< TetheringSettingsProxy >& proxyShared = ::boost::static_pointer_cast< TetheringSettingsProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_Tethering:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TetheringError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Tethering", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TetheringError> payload = ::boost::static_pointer_cast<TetheringError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TetheringCallbackIF*) _callback)->onTetheringError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TetheringUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Tethering", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TetheringUpdate> payload = ::boost::static_pointer_cast<TetheringUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TetheringCallbackIF*) _callback)->onTetheringUpdate(proxyShared, payload);
                        proxyShared->_tethering = *payload.get();
                        return true;
                    }
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_Tethering: {
                ::boost::shared_ptr< TetheringError > payload = ::boost::shared_ptr< TetheringError >
                (new TetheringError(DBUS_ERROR_NO_SERVER, "The DBus service TetheringSettings is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Tethering", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TetheringSettingsProxy> proxyShared = ::boost::static_pointer_cast<TetheringSettingsProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TetheringCallbackIF*) _callback)->onTetheringError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& TetheringSettingsProxyCallback::_logger (TetheringSettingsProxy::_logger);

TetheringSettingsProxy::TetheringSettingsProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.wapdman.Accesspoint.TetheringSettings", serviceAvailable, _logger) {
}

TetheringSettingsProxy::~TetheringSettingsProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< TetheringSettingsProxy > TetheringSettingsProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<TetheringSettingsProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< TetheringSettingsProxy > proxyNew(new TetheringSettingsProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t TetheringSettingsProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    TetheringSettingsProxyCallback* callback = new TetheringSettingsProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t TetheringSettingsProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    TetheringSettingsProxyCallback* callback = new TetheringSettingsProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void TetheringSettingsProxy::clearAllProperties ()
{
    _tethering = ::asf::core::nullable< TetheringUpdate >();
}

void TetheringSettingsProxy::sendDeregisterAll () const
{
    sendTetheringDeregisterAll();
}

act_t TetheringSettingsProxy::sendTetheringRegister(TetheringCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Tethering, "Tethering", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Tethering", &cb, act);
    return act;
}

bool TetheringSettingsProxy::sendTetheringDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Tethering", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Tethering", act, static_cast<int>(rv));
    return rv;
}

act_t TetheringSettingsProxy::sendTetheringGet(TetheringCallbackIF& cb) {
    TetheringSettingsProxyCallback* callback = new TetheringSettingsProxyCallback(ID_Tethering, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Tethering", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Tethering", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void TetheringSettingsProxy::sendTetheringSet(bool tethering) {
    TetheringSet parameter(tethering);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Tethering");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Tethering", propertyContent);
}

act_t TetheringSettingsProxy::sendTetheringSet(TetheringCallbackIF& cb, bool tethering) {
    TetheringSettingsProxyCallback* callback = new TetheringSettingsProxyCallback(ID_Tethering, &cb);
    TetheringSet parameter(tethering);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Tethering", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Tethering", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool TetheringSettingsProxy::getTethering() const {
    return _tethering.get().getTethering();
}

bool TetheringSettingsProxy::hasTethering() const {
    return _tethering.hasValue();
}

void TetheringSettingsProxy::sendTetheringDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Tethering");
    _dbusProxyDelegate->deregisterSignalCallback("Tethering", 0, _dbusDaemonProxy.get(), true);
}

} // namespace TetheringSettings
} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
