#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WAPDMAN_ACCESSPOINT_H
#define ORG_BOSCH_WAPDMAN_ACCESSPOINT_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * If the meaning of "Accesspoint" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

// method IDs
static const uint16 ID_setSSID = 0;
static const uint16 ID_DeAuthenticateStation = 1;
static const uint16 ID_BlacklistStation = 2;
static const uint16 ID_SetOperatingChannels = 3;
static const uint16 ID_StartWPSPushButton = 4;
static const uint16 ID_CancelWPS = 5;
static const uint16 ID_GetAssociatedStations = 6;
static const uint16 ID_RegisterVendorService = 7;
static const uint16 ID_UnregisterVendorService = 8;
static const uint16 ID_GetDnsDhcpConf = 9;

// signal IDs
static const uint16 ID_AssociatedStationsChanged = 10;
static const uint16 ID_AssociationRequestRejected = 11;

// property IDs
static const uint16 ID_SSID = 12;
static const uint16 ID_MacAddress = 13;
static const uint16 ID_Interface = 14;
static const uint16 ID_BlackListedStations = 15;
static const uint16 ID_Powered = 16;
static const uint16 ID_Hidden = 17;
static const uint16 ID_Security = 18;
static const uint16 ID_Passphrase = 19;
static const uint16 ID_MaximumStationsAllowed = 20;
static const uint16 ID_PowerState = 21;
static const uint16 ID_PowerFailureReason = 22;
static const uint16 ID_CurrentOperatingChannel = 23;
static const uint16 ID_CurrentHwMode = 24;
static const uint16 ID_SupportedChannels = 25;
static const uint16 ID_HWFeatures = 26;
static const uint16 ID_VendorIEs = 27;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class SetSSIDRequest;

class DeAuthenticateStationRequest;

class BlacklistStationRequest;

class SetOperatingChannelsRequest;

class GetAssociatedStationsResponseAssociatedstationsStruct;

class GetAssociatedStationsResponse;

class RegisterVendorServiceRequest;

class UnregisterVendorServiceRequest;

class GetDnsDhcpConfResponseDnsdhcpserverconfStruct;

class GetDnsDhcpConfResponse;

class SSIDUpdate;

class SSIDRegister;

class MacAddressUpdate;

class MacAddressRegister;

class InterfaceUpdate;

class InterfaceRegister;

class BlackListedStationsUpdate;

class BlackListedStationsRegister;

class PoweredUpdate;

class PoweredRegister;

class HiddenUpdate;

class HiddenRegister;

class SecurityUpdate;

class SecurityRegister;

class PassphraseUpdate;

class PassphraseRegister;

class MaximumStationsAllowedUpdate;

class MaximumStationsAllowedRegister;

class PowerStateUpdate;

class PowerStateRegister;

class PowerFailureReasonUpdate;

class PowerFailureReasonRegister;

class CurrentOperatingChannelUpdate;

class CurrentOperatingChannelRegister;

class CurrentHwModeUpdate;

class CurrentHwModeRegister;

class SupportedChannelsUpdate;

class SupportedChannelsRegister;

class HWFeaturesUpdate;

class HWFeaturesRegister;

class VendorIEsElem1Struct;

class VendorIEsStruct;

class VendorIEsUpdate;

class VendorIEsRegister;

class AssociatedStationsChangedSignalChangedstationsStruct;

class AssociatedStationsChangedSignal;

class AssociationRequestRejectedSignal;

// type definitions
/**
 * If the meaning of "SetSSIDResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetSSIDResponse;

/**
 * If the meaning of "SetSSIDError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetSSIDError;

/**
 * If the meaning of "DeAuthenticateStationResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DeAuthenticateStationResponse;

/**
 * If the meaning of "DeAuthenticateStationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeAuthenticateStationError;

/**
 * If the meaning of "BlacklistStationResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BlacklistStationResponse;

/**
 * If the meaning of "BlacklistStationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BlacklistStationError;

/**
 * If the meaning of "SetOperatingChannelsResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetOperatingChannelsResponse;

/**
 * If the meaning of "SetOperatingChannelsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetOperatingChannelsError;

/**
 * If the meaning of "StartWPSPushButtonRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartWPSPushButtonRequest;

/**
 * If the meaning of "StartWPSPushButtonResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartWPSPushButtonResponse;

/**
 * If the meaning of "StartWPSPushButtonError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartWPSPushButtonError;

/**
 * If the meaning of "CancelWPSRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelWPSRequest;

/**
 * If the meaning of "CancelWPSResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelWPSResponse;

/**
 * If the meaning of "CancelWPSError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CancelWPSError;

/**
 * If the meaning of "GetAssociatedStationsRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetAssociatedStationsRequest;

/**
 * If the meaning of "GetAssociatedStationsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetAssociatedStationsError;

/**
 * If the meaning of "RegisterVendorServiceResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RegisterVendorServiceResponse;

/**
 * If the meaning of "RegisterVendorServiceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RegisterVendorServiceError;

/**
 * If the meaning of "UnregisterVendorServiceResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UnregisterVendorServiceResponse;

/**
 * If the meaning of "UnregisterVendorServiceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnregisterVendorServiceError;

/**
 * If the meaning of "GetDnsDhcpConfRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetDnsDhcpConfRequest;

/**
 * If the meaning of "GetDnsDhcpConfError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetDnsDhcpConfError;

/**
 * If the meaning of "SSIDSet" isn't clear, then there should be a description here.
 */
typedef SSIDUpdate SSIDSet;

/**
 * If the meaning of "SSIDGet" isn't clear, then there should be a description here.
 */
typedef SSIDUpdate SSIDGet;

/**
 * If the meaning of "SSIDError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SSIDError;

/**
 * If the meaning of "MacAddressSet" isn't clear, then there should be a description here.
 */
typedef MacAddressUpdate MacAddressSet;

/**
 * If the meaning of "MacAddressGet" isn't clear, then there should be a description here.
 */
typedef MacAddressUpdate MacAddressGet;

/**
 * If the meaning of "MacAddressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MacAddressError;

/**
 * If the meaning of "InterfaceSet" isn't clear, then there should be a description here.
 */
typedef InterfaceUpdate InterfaceSet;

/**
 * If the meaning of "InterfaceGet" isn't clear, then there should be a description here.
 */
typedef InterfaceUpdate InterfaceGet;

/**
 * If the meaning of "InterfaceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError InterfaceError;

/**
 * If the meaning of "BlackListedStationsSet" isn't clear, then there should be a description here.
 */
typedef BlackListedStationsUpdate BlackListedStationsSet;

/**
 * If the meaning of "BlackListedStationsGet" isn't clear, then there should be a description here.
 */
typedef BlackListedStationsUpdate BlackListedStationsGet;

/**
 * If the meaning of "BlackListedStationsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BlackListedStationsError;

/**
 * If the meaning of "PoweredSet" isn't clear, then there should be a description here.
 */
typedef PoweredUpdate PoweredSet;

/**
 * If the meaning of "PoweredGet" isn't clear, then there should be a description here.
 */
typedef PoweredUpdate PoweredGet;

/**
 * If the meaning of "PoweredError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PoweredError;

/**
 * If the meaning of "HiddenSet" isn't clear, then there should be a description here.
 */
typedef HiddenUpdate HiddenSet;

/**
 * If the meaning of "HiddenGet" isn't clear, then there should be a description here.
 */
typedef HiddenUpdate HiddenGet;

/**
 * If the meaning of "HiddenError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HiddenError;

/**
 * If the meaning of "SecuritySet" isn't clear, then there should be a description here.
 */
typedef SecurityUpdate SecuritySet;

/**
 * If the meaning of "SecurityGet" isn't clear, then there should be a description here.
 */
typedef SecurityUpdate SecurityGet;

/**
 * If the meaning of "SecurityError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SecurityError;

/**
 * If the meaning of "PassphraseSet" isn't clear, then there should be a description here.
 */
typedef PassphraseUpdate PassphraseSet;

/**
 * If the meaning of "PassphraseGet" isn't clear, then there should be a description here.
 */
typedef PassphraseUpdate PassphraseGet;

/**
 * If the meaning of "PassphraseError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PassphraseError;

/**
 * If the meaning of "MaximumStationsAllowedSet" isn't clear, then there should be a description here.
 */
typedef MaximumStationsAllowedUpdate MaximumStationsAllowedSet;

/**
 * If the meaning of "MaximumStationsAllowedGet" isn't clear, then there should be a description here.
 */
typedef MaximumStationsAllowedUpdate MaximumStationsAllowedGet;

/**
 * If the meaning of "MaximumStationsAllowedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MaximumStationsAllowedError;

/**
 * If the meaning of "PowerStateSet" isn't clear, then there should be a description here.
 */
typedef PowerStateUpdate PowerStateSet;

/**
 * If the meaning of "PowerStateGet" isn't clear, then there should be a description here.
 */
typedef PowerStateUpdate PowerStateGet;

/**
 * If the meaning of "PowerStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PowerStateError;

/**
 * If the meaning of "PowerFailureReasonSet" isn't clear, then there should be a description here.
 */
typedef PowerFailureReasonUpdate PowerFailureReasonSet;

/**
 * If the meaning of "PowerFailureReasonGet" isn't clear, then there should be a description here.
 */
typedef PowerFailureReasonUpdate PowerFailureReasonGet;

/**
 * If the meaning of "PowerFailureReasonError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PowerFailureReasonError;

/**
 * If the meaning of "CurrentOperatingChannelSet" isn't clear, then there should be a description here.
 */
typedef CurrentOperatingChannelUpdate CurrentOperatingChannelSet;

/**
 * If the meaning of "CurrentOperatingChannelGet" isn't clear, then there should be a description here.
 */
typedef CurrentOperatingChannelUpdate CurrentOperatingChannelGet;

/**
 * If the meaning of "CurrentOperatingChannelError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CurrentOperatingChannelError;

/**
 * If the meaning of "CurrentHwModeSet" isn't clear, then there should be a description here.
 */
typedef CurrentHwModeUpdate CurrentHwModeSet;

/**
 * If the meaning of "CurrentHwModeGet" isn't clear, then there should be a description here.
 */
typedef CurrentHwModeUpdate CurrentHwModeGet;

/**
 * If the meaning of "CurrentHwModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CurrentHwModeError;

/**
 * If the meaning of "SupportedChannelsSet" isn't clear, then there should be a description here.
 */
typedef SupportedChannelsUpdate SupportedChannelsSet;

/**
 * If the meaning of "SupportedChannelsGet" isn't clear, then there should be a description here.
 */
typedef SupportedChannelsUpdate SupportedChannelsGet;

/**
 * If the meaning of "SupportedChannelsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SupportedChannelsError;

/**
 * If the meaning of "HWFeaturesSet" isn't clear, then there should be a description here.
 */
typedef HWFeaturesUpdate HWFeaturesSet;

/**
 * If the meaning of "HWFeaturesGet" isn't clear, then there should be a description here.
 */
typedef HWFeaturesUpdate HWFeaturesGet;

/**
 * If the meaning of "HWFeaturesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HWFeaturesError;

/**
 * If the meaning of "VendorIEsSet" isn't clear, then there should be a description here.
 */
typedef VendorIEsUpdate VendorIEsSet;

/**
 * If the meaning of "VendorIEsGet" isn't clear, then there should be a description here.
 */
typedef VendorIEsUpdate VendorIEsGet;

/**
 * If the meaning of "VendorIEsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VendorIEsError;

/**
 * If the meaning of "AssociatedStationsChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AssociatedStationsChangedError;

/**
 * If the meaning of "AssociationRequestRejectedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AssociationRequestRejectedError;


/**
 * If the meaning of "SetSSIDRequest" isn't clear, then there should be a description here.
 */
class SetSSIDRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetSSIDRequest ();

    /**
     * Copy constructor
     */
    inline  SetSSIDRequest (const SetSSIDRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetSSIDRequest (const ::std::vector< uint8 >& ssid_, bool utf_ssid_);

    /**
     * Destructor
     */
    inline virtual  ~SetSSIDRequest();

    /**
     * Assignment operator
     */
    inline SetSSIDRequest& operator = (const SetSSIDRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSSIDRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSSIDRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSSIDRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSSIDRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ssid"

    static const int kSsid = 0;

    /**
     * Clears the field "ssid".
     *
     * The field will be set to its default value. The hasSsid()
     * method will return false.
     */
    inline void clearSsid();

    /**
     * Checks whether the field "ssid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSsid()). Otherwise it will return false.
     */
    inline bool hasSsid () const;

    /**
     * Returns the value of the member "ssid".
     *
     * If the meaning of "ssid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ssid"
     */
    inline const ::std::vector< uint8 >& getSsid () const;

    /**
     * Retrieves the value of the field "ssid" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ssid".
     */
    inline ::std::vector< uint8 >& getSsidMutable ();

    /**
     * Sets the value of the member "ssid".
     *
     * If the meaning of "ssid" isn't clear, then there should be a description here.
     *
     * @param ssid The value which will be set
     */
    inline void setSsid (const ::std::vector< uint8 >& ssid_);

    // API of field "utf_ssid"

    static const int kUtf_ssid = 1;

    /**
     * Clears the field "utf_ssid".
     *
     * The field will be set to its default value. The hasUtf_ssid()
     * method will return false.
     */
    inline void clearUtf_ssid();

    /**
     * Checks whether the field "utf_ssid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUtf_ssid()). Otherwise it will return false.
     */
    inline bool hasUtf_ssid () const;

    /**
     * Returns the value of the member "utf_ssid".
     *
     * If the meaning of "utf_ssid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "utf_ssid"
     */
    inline bool getUtf_ssid () const;

    /**
     * Sets the value of the member "utf_ssid".
     *
     * If the meaning of "utf_ssid" isn't clear, then there should be a description here.
     *
     * @param utf_ssid The value which will be set
     */
    inline void setUtf_ssid (bool utf_ssid_);

    static const SetSSIDRequest &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_ssid ();

    inline void clear_has_ssid ();

    inline void set_has_utf_ssid ();

    inline void clear_has_utf_ssid ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< uint8 > _ssid;

    bool _utf_ssid;

};

/**
 * If the meaning of "DeAuthenticateStationRequest" isn't clear, then there should be a description here.
 */
class DeAuthenticateStationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeAuthenticateStationRequest ();

    /**
     * Copy constructor
     */
    inline  DeAuthenticateStationRequest (const DeAuthenticateStationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DeAuthenticateStationRequest (const ::std::string& address_);

    /**
     * Destructor
     */
    inline virtual  ~DeAuthenticateStationRequest();

    /**
     * Assignment operator
     */
    inline DeAuthenticateStationRequest& operator = (const DeAuthenticateStationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeAuthenticateStationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeAuthenticateStationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeAuthenticateStationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeAuthenticateStationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "address"

    static const int kAddress = 0;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::string& address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    static const DeAuthenticateStationRequest &getDefaultInstance();

private:

    inline void set_has_address ();

    inline void clear_has_address ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _address;

};

/**
 * If the meaning of "BlacklistStationRequest" isn't clear, then there should be a description here.
 */
class BlacklistStationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BlacklistStationRequest ();

    /**
     * Copy constructor
     */
    inline  BlacklistStationRequest (const BlacklistStationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  BlacklistStationRequest (const ::std::string& address_, bool allow_);

    /**
     * Destructor
     */
    inline virtual  ~BlacklistStationRequest();

    /**
     * Assignment operator
     */
    inline BlacklistStationRequest& operator = (const BlacklistStationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BlacklistStationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BlacklistStationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BlacklistStationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BlacklistStationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "address"

    static const int kAddress = 0;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::string& address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    // API of field "allow"

    static const int kAllow = 1;

    /**
     * Clears the field "allow".
     *
     * The field will be set to its default value. The hasAllow()
     * method will return false.
     */
    inline void clearAllow();

    /**
     * Checks whether the field "allow" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAllow()). Otherwise it will return false.
     */
    inline bool hasAllow () const;

    /**
     * Returns the value of the member "allow".
     *
     * If the meaning of "allow" isn't clear, then there should be a description here.
     *
     * @return The value of the field "allow"
     */
    inline bool getAllow () const;

    /**
     * Sets the value of the member "allow".
     *
     * If the meaning of "allow" isn't clear, then there should be a description here.
     *
     * @param allow The value which will be set
     */
    inline void setAllow (bool allow_);

    static const BlacklistStationRequest &getDefaultInstance();

private:

    inline void set_has_address ();

    inline void clear_has_address ();

    inline void set_has_allow ();

    inline void clear_has_allow ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _address;

    bool _allow;

};

/**
 * If the meaning of "SetOperatingChannelsRequest" isn't clear, then there should be a description here.
 */
class SetOperatingChannelsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetOperatingChannelsRequest ();

    /**
     * Copy constructor
     */
    inline  SetOperatingChannelsRequest (const SetOperatingChannelsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetOperatingChannelsRequest (const ::std::vector< uint16 >& channels_);

    /**
     * Destructor
     */
    inline virtual  ~SetOperatingChannelsRequest();

    /**
     * Assignment operator
     */
    inline SetOperatingChannelsRequest& operator = (const SetOperatingChannelsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetOperatingChannelsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetOperatingChannelsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetOperatingChannelsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetOperatingChannelsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "channels"

    static const int kChannels = 0;

    /**
     * Clears the field "channels".
     *
     * The field will be set to its default value. The hasChannels()
     * method will return false.
     */
    inline void clearChannels();

    /**
     * Checks whether the field "channels" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannels()). Otherwise it will return false.
     */
    inline bool hasChannels () const;

    /**
     * Returns the value of the member "channels".
     *
     * If the meaning of "channels" isn't clear, then there should be a description here.
     *
     * @return The value of the field "channels"
     */
    inline const ::std::vector< uint16 >& getChannels () const;

    /**
     * Retrieves the value of the field "channels" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "channels".
     */
    inline ::std::vector< uint16 >& getChannelsMutable ();

    /**
     * Sets the value of the member "channels".
     *
     * If the meaning of "channels" isn't clear, then there should be a description here.
     *
     * @param channels The value which will be set
     */
    inline void setChannels (const ::std::vector< uint16 >& channels_);

    static const SetOperatingChannelsRequest &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_channels ();

    inline void clear_has_channels ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint16 > _channels;

};

/**
 * If the meaning of "GetAssociatedStationsResponseAssociatedstationsStruct" isn't clear, then there should be a description here.
 */
class GetAssociatedStationsResponseAssociatedstationsStruct {
public:

    /**
     * Default constructor
     */
    inline  GetAssociatedStationsResponseAssociatedstationsStruct ();

    /**
     * Copy constructor
     */
    inline  GetAssociatedStationsResponseAssociatedstationsStruct (const GetAssociatedStationsResponseAssociatedstationsStruct &rhs);

    /**
     * All fields constructor
     */
    inline  GetAssociatedStationsResponseAssociatedstationsStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    /**
     * Destructor
     */
    inline  ~GetAssociatedStationsResponseAssociatedstationsStruct();

    /**
     * Assignment operator
     */
    inline GetAssociatedStationsResponseAssociatedstationsStruct& operator = (const GetAssociatedStationsResponseAssociatedstationsStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAssociatedStationsResponseAssociatedstationsStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAssociatedStationsResponseAssociatedstationsStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAssociatedStationsResponseAssociatedstationsStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAssociatedStationsResponseAssociatedstationsStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline const ::std::string& getElem1 () const;

    /**
     * Retrieves the value of the field "elem1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem1".
     */
    inline ::std::string& getElem1Mutable ();

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const ::std::string& elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* value, size_t size);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    static const GetAssociatedStationsResponseAssociatedstationsStruct &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _elem1;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _elem2;

};

/**
 * If the meaning of "GetAssociatedStationsResponse" isn't clear, then there should be a description here.
 */
class GetAssociatedStationsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAssociatedStationsResponse ();

    /**
     * Copy constructor
     */
    inline  GetAssociatedStationsResponse (const GetAssociatedStationsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetAssociatedStationsResponse (const ::std::vector< GetAssociatedStationsResponseAssociatedstationsStruct >& associatedstations_);

    /**
     * Destructor
     */
    inline virtual  ~GetAssociatedStationsResponse();

    /**
     * Assignment operator
     */
    inline GetAssociatedStationsResponse& operator = (const GetAssociatedStationsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAssociatedStationsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAssociatedStationsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAssociatedStationsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAssociatedStationsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "associatedstations"

    static const int kAssociatedstations = 0;

    /**
     * Clears the field "associatedstations".
     *
     * The field will be set to its default value. The hasAssociatedstations()
     * method will return false.
     */
    inline void clearAssociatedstations();

    /**
     * Checks whether the field "associatedstations" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAssociatedstations()). Otherwise it will return false.
     */
    inline bool hasAssociatedstations () const;

    /**
     * Returns the value of the member "associatedstations".
     *
     * If the meaning of "associatedstations" isn't clear, then there should be a description here.
     *
     * @return The value of the field "associatedstations"
     */
    inline const ::std::vector< GetAssociatedStationsResponseAssociatedstationsStruct >& getAssociatedstations () const;

    /**
     * Retrieves the value of the field "associatedstations" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "associatedstations".
     */
    inline ::std::vector< GetAssociatedStationsResponseAssociatedstationsStruct >& getAssociatedstationsMutable ();

    /**
     * Sets the value of the member "associatedstations".
     *
     * If the meaning of "associatedstations" isn't clear, then there should be a description here.
     *
     * @param associatedstations The value which will be set
     */
    inline void setAssociatedstations (const ::std::vector< GetAssociatedStationsResponseAssociatedstationsStruct >& associatedstations_);

    static const GetAssociatedStationsResponse &getDefaultInstance();

private:

    static const ::std::vector< GetAssociatedStationsResponseAssociatedstationsStruct >& getGetAssociatedStationsResponseAssociatedstationsStructList_DefaultInstance ();

    inline void set_has_associatedstations ();

    inline void clear_has_associatedstations ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< GetAssociatedStationsResponseAssociatedstationsStruct > _associatedstations;

};

/**
 * If the meaning of "RegisterVendorServiceRequest" isn't clear, then there should be a description here.
 */
class RegisterVendorServiceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterVendorServiceRequest ();

    /**
     * Copy constructor
     */
    inline  RegisterVendorServiceRequest (const RegisterVendorServiceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterVendorServiceRequest (const ::std::vector< ::std::vector< uint8 > >& IEs_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterVendorServiceRequest();

    /**
     * Assignment operator
     */
    inline RegisterVendorServiceRequest& operator = (const RegisterVendorServiceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterVendorServiceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterVendorServiceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterVendorServiceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterVendorServiceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IEs"

    static const int kIEs = 0;

    /**
     * Clears the field "IEs".
     *
     * The field will be set to its default value. The hasIEs()
     * method will return false.
     */
    inline void clearIEs();

    /**
     * Checks whether the field "IEs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIEs()). Otherwise it will return false.
     */
    inline bool hasIEs () const;

    /**
     * Returns the value of the member "IEs".
     *
     * If the meaning of "IEs" isn't clear, then there should be a description here.
     *
     * @return The value of the field "IEs"
     */
    inline const ::std::vector< ::std::vector< uint8 > >& getIEs () const;

    /**
     * Retrieves the value of the field "IEs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "IEs".
     */
    inline ::std::vector< ::std::vector< uint8 > >& getIEsMutable ();

    /**
     * Sets the value of the member "IEs".
     *
     * If the meaning of "IEs" isn't clear, then there should be a description here.
     *
     * @param IEs The value which will be set
     */
    inline void setIEs (const ::std::vector< ::std::vector< uint8 > >& IEs_);

    static const RegisterVendorServiceRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::vector< uint8 > >& getUint8List_List_DefaultInstance ();

    inline void set_has_IEs ();

    inline void clear_has_IEs ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::vector< uint8 > > _IEs;

};

/**
 * If the meaning of "UnregisterVendorServiceRequest" isn't clear, then there should be a description here.
 */
class UnregisterVendorServiceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnregisterVendorServiceRequest ();

    /**
     * Copy constructor
     */
    inline  UnregisterVendorServiceRequest (const UnregisterVendorServiceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UnregisterVendorServiceRequest (const ::std::vector< ::std::vector< uint8 > >& IEs_);

    /**
     * Destructor
     */
    inline virtual  ~UnregisterVendorServiceRequest();

    /**
     * Assignment operator
     */
    inline UnregisterVendorServiceRequest& operator = (const UnregisterVendorServiceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnregisterVendorServiceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnregisterVendorServiceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnregisterVendorServiceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnregisterVendorServiceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IEs"

    static const int kIEs = 0;

    /**
     * Clears the field "IEs".
     *
     * The field will be set to its default value. The hasIEs()
     * method will return false.
     */
    inline void clearIEs();

    /**
     * Checks whether the field "IEs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIEs()). Otherwise it will return false.
     */
    inline bool hasIEs () const;

    /**
     * Returns the value of the member "IEs".
     *
     * If the meaning of "IEs" isn't clear, then there should be a description here.
     *
     * @return The value of the field "IEs"
     */
    inline const ::std::vector< ::std::vector< uint8 > >& getIEs () const;

    /**
     * Retrieves the value of the field "IEs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "IEs".
     */
    inline ::std::vector< ::std::vector< uint8 > >& getIEsMutable ();

    /**
     * Sets the value of the member "IEs".
     *
     * If the meaning of "IEs" isn't clear, then there should be a description here.
     *
     * @param IEs The value which will be set
     */
    inline void setIEs (const ::std::vector< ::std::vector< uint8 > >& IEs_);

    static const UnregisterVendorServiceRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::vector< uint8 > >& getUint8List_List_DefaultInstance ();

    inline void set_has_IEs ();

    inline void clear_has_IEs ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::vector< uint8 > > _IEs;

};

/**
 * If the meaning of "GetDnsDhcpConfResponseDnsdhcpserverconfStruct" isn't clear, then there should be a description here.
 */
class GetDnsDhcpConfResponseDnsdhcpserverconfStruct {
public:

    /**
     * Default constructor
     */
    inline  GetDnsDhcpConfResponseDnsdhcpserverconfStruct ();

    /**
     * Copy constructor
     */
    inline  GetDnsDhcpConfResponseDnsdhcpserverconfStruct (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct &rhs);

    /**
     * All fields constructor
     */
    inline  GetDnsDhcpConfResponseDnsdhcpserverconfStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    /**
     * Destructor
     */
    inline  ~GetDnsDhcpConfResponseDnsdhcpserverconfStruct();

    /**
     * Assignment operator
     */
    inline GetDnsDhcpConfResponseDnsdhcpserverconfStruct& operator = (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline const ::std::string& getElem1 () const;

    /**
     * Retrieves the value of the field "elem1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem1".
     */
    inline ::std::string& getElem1Mutable ();

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const ::std::string& elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* value, size_t size);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    static const GetDnsDhcpConfResponseDnsdhcpserverconfStruct &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _elem1;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _elem2;

};

/**
 * If the meaning of "GetDnsDhcpConfResponse" isn't clear, then there should be a description here.
 */
class GetDnsDhcpConfResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDnsDhcpConfResponse ();

    /**
     * Copy constructor
     */
    inline  GetDnsDhcpConfResponse (const GetDnsDhcpConfResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetDnsDhcpConfResponse (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& dnsdhcpserverconf_);

    /**
     * Destructor
     */
    inline virtual  ~GetDnsDhcpConfResponse();

    /**
     * Assignment operator
     */
    inline GetDnsDhcpConfResponse& operator = (const GetDnsDhcpConfResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDnsDhcpConfResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDnsDhcpConfResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDnsDhcpConfResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDnsDhcpConfResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "dnsdhcpserverconf"

    static const int kDnsdhcpserverconf = 0;

    /**
     * Clears the field "dnsdhcpserverconf".
     *
     * The field will be set to its default value. The hasDnsdhcpserverconf()
     * method will return false.
     */
    inline void clearDnsdhcpserverconf();

    /**
     * Checks whether the field "dnsdhcpserverconf" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDnsdhcpserverconf()). Otherwise it will return false.
     */
    inline bool hasDnsdhcpserverconf () const;

    /**
     * Returns the value of the member "dnsdhcpserverconf".
     *
     * If the meaning of "dnsdhcpserverconf" isn't clear, then there should be a description here.
     *
     * @return The value of the field "dnsdhcpserverconf"
     */
    inline const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& getDnsdhcpserverconf () const;

    /**
     * Retrieves the value of the field "dnsdhcpserverconf" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dnsdhcpserverconf".
     */
    inline GetDnsDhcpConfResponseDnsdhcpserverconfStruct& getDnsdhcpserverconfMutable ();

    /**
     * Sets the value of the member "dnsdhcpserverconf".
     *
     * If the meaning of "dnsdhcpserverconf" isn't clear, then there should be a description here.
     *
     * @param dnsdhcpserverconf The value which will be set
     */
    inline void setDnsdhcpserverconf (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& dnsdhcpserverconf_);

    static const GetDnsDhcpConfResponse &getDefaultInstance();

private:

    inline void set_has_dnsdhcpserverconf ();

    inline void clear_has_dnsdhcpserverconf ();

    uint32 _has_bits_[ (1 + 31) / 32];

    GetDnsDhcpConfResponseDnsdhcpserverconfStruct _dnsdhcpserverconf;

};

/**
 * If the meaning of "SSIDUpdate" isn't clear, then there should be a description here.
 */
class SSIDUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SSIDUpdate ();

    /**
     * Copy constructor
     */
    inline  SSIDUpdate (const SSIDUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SSIDUpdate (const ::std::vector< uint8 >& SSID_);

    /**
     * Destructor
     */
    inline virtual  ~SSIDUpdate();

    /**
     * Assignment operator
     */
    inline SSIDUpdate& operator = (const SSIDUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SSIDUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SSIDUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SSIDUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SSIDUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SSID"

    static const int kSSID = 0;

    /**
     * Clears the field "SSID".
     *
     * The field will be set to its default value. The hasSSID()
     * method will return false.
     */
    inline void clearSSID();

    /**
     * Checks whether the field "SSID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSID()). Otherwise it will return false.
     */
    inline bool hasSSID () const;

    /**
     * Returns the value of the member "SSID".
     *
     * If the meaning of "SSID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SSID"
     */
    inline const ::std::vector< uint8 >& getSSID () const;

    /**
     * Retrieves the value of the field "SSID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SSID".
     */
    inline ::std::vector< uint8 >& getSSIDMutable ();

    /**
     * Sets the value of the member "SSID".
     *
     * If the meaning of "SSID" isn't clear, then there should be a description here.
     *
     * @param SSID The value which will be set
     */
    inline void setSSID (const ::std::vector< uint8 >& SSID_);

    static const SSIDUpdate &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_SSID ();

    inline void clear_has_SSID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _SSID;

};

/**
 * If the meaning of "SSIDRegister" isn't clear, then there should be a description here.
 */
class SSIDRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SSIDRegister ();

    /**
     * Copy constructor
     */
    inline  SSIDRegister (const SSIDRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SSIDRegister();

    /**
     * Assignment operator
     */
    inline SSIDRegister& operator = (const SSIDRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SSIDRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SSIDRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SSIDRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SSIDRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SSIDRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "MacAddressUpdate" isn't clear, then there should be a description here.
 */
class MacAddressUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MacAddressUpdate ();

    /**
     * Copy constructor
     */
    inline  MacAddressUpdate (const MacAddressUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MacAddressUpdate (const ::std::string& MacAddress_);

    /**
     * Destructor
     */
    inline virtual  ~MacAddressUpdate();

    /**
     * Assignment operator
     */
    inline MacAddressUpdate& operator = (const MacAddressUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MacAddressUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MacAddressUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MacAddressUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MacAddressUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MacAddress"

    static const int kMacAddress = 0;

    /**
     * Clears the field "MacAddress".
     *
     * The field will be set to its default value. The hasMacAddress()
     * method will return false.
     */
    inline void clearMacAddress();

    /**
     * Checks whether the field "MacAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMacAddress()). Otherwise it will return false.
     */
    inline bool hasMacAddress () const;

    /**
     * Returns the value of the member "MacAddress".
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MacAddress"
     */
    inline const ::std::string& getMacAddress () const;

    /**
     * Retrieves the value of the field "MacAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MacAddress".
     */
    inline ::std::string& getMacAddressMutable ();

    /**
     * Sets the value of the member "MacAddress".
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     *
     * @param MacAddress The value which will be set
     */
    inline void setMacAddress (const ::std::string& MacAddress_);

    /**
     * Sets the value of the member "MacAddress".
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     *
     * @param MacAddress The value which will be set
     */
    inline void setMacAddress (const char* MacAddress_);

    /**
     * Sets the value of the member "MacAddress".
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     *
     * @param MacAddress The value which will be set
     */
    inline void setMacAddress (const char* value, size_t size);

    static const MacAddressUpdate &getDefaultInstance();

private:

    inline void set_has_MacAddress ();

    inline void clear_has_MacAddress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _MacAddress;

};

/**
 * If the meaning of "MacAddressRegister" isn't clear, then there should be a description here.
 */
class MacAddressRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MacAddressRegister ();

    /**
     * Copy constructor
     */
    inline  MacAddressRegister (const MacAddressRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MacAddressRegister();

    /**
     * Assignment operator
     */
    inline MacAddressRegister& operator = (const MacAddressRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MacAddressRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MacAddressRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MacAddressRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MacAddressRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MacAddressRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "InterfaceUpdate" isn't clear, then there should be a description here.
 */
class InterfaceUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InterfaceUpdate ();

    /**
     * Copy constructor
     */
    inline  InterfaceUpdate (const InterfaceUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  InterfaceUpdate (const ::std::string& Interface_);

    /**
     * Destructor
     */
    inline virtual  ~InterfaceUpdate();

    /**
     * Assignment operator
     */
    inline InterfaceUpdate& operator = (const InterfaceUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InterfaceUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InterfaceUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InterfaceUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InterfaceUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Interface"

    static const int kInterface = 0;

    /**
     * Clears the field "Interface".
     *
     * The field will be set to its default value. The hasInterface()
     * method will return false.
     */
    inline void clearInterface();

    /**
     * Checks whether the field "Interface" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInterface()). Otherwise it will return false.
     */
    inline bool hasInterface () const;

    /**
     * Returns the value of the member "Interface".
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Interface"
     */
    inline const ::std::string& getInterface () const;

    /**
     * Retrieves the value of the field "Interface" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Interface".
     */
    inline ::std::string& getInterfaceMutable ();

    /**
     * Sets the value of the member "Interface".
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     *
     * @param Interface The value which will be set
     */
    inline void setInterface (const ::std::string& Interface_);

    /**
     * Sets the value of the member "Interface".
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     *
     * @param Interface The value which will be set
     */
    inline void setInterface (const char* Interface_);

    /**
     * Sets the value of the member "Interface".
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     *
     * @param Interface The value which will be set
     */
    inline void setInterface (const char* value, size_t size);

    static const InterfaceUpdate &getDefaultInstance();

private:

    inline void set_has_Interface ();

    inline void clear_has_Interface ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Interface;

};

/**
 * If the meaning of "InterfaceRegister" isn't clear, then there should be a description here.
 */
class InterfaceRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InterfaceRegister ();

    /**
     * Copy constructor
     */
    inline  InterfaceRegister (const InterfaceRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~InterfaceRegister();

    /**
     * Assignment operator
     */
    inline InterfaceRegister& operator = (const InterfaceRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InterfaceRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InterfaceRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InterfaceRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InterfaceRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const InterfaceRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "BlackListedStationsUpdate" isn't clear, then there should be a description here.
 */
class BlackListedStationsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BlackListedStationsUpdate ();

    /**
     * Copy constructor
     */
    inline  BlackListedStationsUpdate (const BlackListedStationsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  BlackListedStationsUpdate (const ::std::vector< ::std::string >& BlackListedStations_);

    /**
     * Destructor
     */
    inline virtual  ~BlackListedStationsUpdate();

    /**
     * Assignment operator
     */
    inline BlackListedStationsUpdate& operator = (const BlackListedStationsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BlackListedStationsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BlackListedStationsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BlackListedStationsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BlackListedStationsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BlackListedStations"

    static const int kBlackListedStations = 0;

    /**
     * Clears the field "BlackListedStations".
     *
     * The field will be set to its default value. The hasBlackListedStations()
     * method will return false.
     */
    inline void clearBlackListedStations();

    /**
     * Checks whether the field "BlackListedStations" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBlackListedStations()). Otherwise it will return false.
     */
    inline bool hasBlackListedStations () const;

    /**
     * Returns the value of the member "BlackListedStations".
     *
     * If the meaning of "BlackListedStations" isn't clear, then there should be a description here.
     *
     * @return The value of the field "BlackListedStations"
     */
    inline const ::std::vector< ::std::string >& getBlackListedStations () const;

    /**
     * Retrieves the value of the field "BlackListedStations" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BlackListedStations".
     */
    inline ::std::vector< ::std::string >& getBlackListedStationsMutable ();

    /**
     * Sets the value of the member "BlackListedStations".
     *
     * If the meaning of "BlackListedStations" isn't clear, then there should be a description here.
     *
     * @param BlackListedStations The value which will be set
     */
    inline void setBlackListedStations (const ::std::vector< ::std::string >& BlackListedStations_);

    static const BlackListedStationsUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_BlackListedStations ();

    inline void clear_has_BlackListedStations ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _BlackListedStations;

};

/**
 * If the meaning of "BlackListedStationsRegister" isn't clear, then there should be a description here.
 */
class BlackListedStationsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BlackListedStationsRegister ();

    /**
     * Copy constructor
     */
    inline  BlackListedStationsRegister (const BlackListedStationsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~BlackListedStationsRegister();

    /**
     * Assignment operator
     */
    inline BlackListedStationsRegister& operator = (const BlackListedStationsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BlackListedStationsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BlackListedStationsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BlackListedStationsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BlackListedStationsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const BlackListedStationsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PoweredUpdate" isn't clear, then there should be a description here.
 */
class PoweredUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PoweredUpdate ();

    /**
     * Copy constructor
     */
    inline  PoweredUpdate (const PoweredUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PoweredUpdate (bool Powered_);

    /**
     * Destructor
     */
    inline virtual  ~PoweredUpdate();

    /**
     * Assignment operator
     */
    inline PoweredUpdate& operator = (const PoweredUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PoweredUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PoweredUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PoweredUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PoweredUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Powered"

    static const int kPowered = 0;

    /**
     * Clears the field "Powered".
     *
     * The field will be set to its default value. The hasPowered()
     * method will return false.
     */
    inline void clearPowered();

    /**
     * Checks whether the field "Powered" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPowered()). Otherwise it will return false.
     */
    inline bool hasPowered () const;

    /**
     * Returns the value of the member "Powered".
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Powered"
     */
    inline bool getPowered () const;

    /**
     * Sets the value of the member "Powered".
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param Powered The value which will be set
     */
    inline void setPowered (bool Powered_);

    static const PoweredUpdate &getDefaultInstance();

private:

    inline void set_has_Powered ();

    inline void clear_has_Powered ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Powered;

};

/**
 * If the meaning of "PoweredRegister" isn't clear, then there should be a description here.
 */
class PoweredRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PoweredRegister ();

    /**
     * Copy constructor
     */
    inline  PoweredRegister (const PoweredRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PoweredRegister();

    /**
     * Assignment operator
     */
    inline PoweredRegister& operator = (const PoweredRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PoweredRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PoweredRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PoweredRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PoweredRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PoweredRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "HiddenUpdate" isn't clear, then there should be a description here.
 */
class HiddenUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HiddenUpdate ();

    /**
     * Copy constructor
     */
    inline  HiddenUpdate (const HiddenUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  HiddenUpdate (bool Hidden_);

    /**
     * Destructor
     */
    inline virtual  ~HiddenUpdate();

    /**
     * Assignment operator
     */
    inline HiddenUpdate& operator = (const HiddenUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HiddenUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HiddenUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HiddenUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HiddenUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Hidden"

    static const int kHidden = 0;

    /**
     * Clears the field "Hidden".
     *
     * The field will be set to its default value. The hasHidden()
     * method will return false.
     */
    inline void clearHidden();

    /**
     * Checks whether the field "Hidden" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHidden()). Otherwise it will return false.
     */
    inline bool hasHidden () const;

    /**
     * Returns the value of the member "Hidden".
     *
     * If the meaning of "Hidden" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Hidden"
     */
    inline bool getHidden () const;

    /**
     * Sets the value of the member "Hidden".
     *
     * If the meaning of "Hidden" isn't clear, then there should be a description here.
     *
     * @param Hidden The value which will be set
     */
    inline void setHidden (bool Hidden_);

    static const HiddenUpdate &getDefaultInstance();

private:

    inline void set_has_Hidden ();

    inline void clear_has_Hidden ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Hidden;

};

/**
 * If the meaning of "HiddenRegister" isn't clear, then there should be a description here.
 */
class HiddenRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HiddenRegister ();

    /**
     * Copy constructor
     */
    inline  HiddenRegister (const HiddenRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~HiddenRegister();

    /**
     * Assignment operator
     */
    inline HiddenRegister& operator = (const HiddenRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HiddenRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HiddenRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HiddenRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HiddenRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const HiddenRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "SecurityUpdate" isn't clear, then there should be a description here.
 */
class SecurityUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityUpdate ();

    /**
     * Copy constructor
     */
    inline  SecurityUpdate (const SecurityUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SecurityUpdate (const ::std::string& Security_);

    /**
     * Destructor
     */
    inline virtual  ~SecurityUpdate();

    /**
     * Assignment operator
     */
    inline SecurityUpdate& operator = (const SecurityUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Security"

    static const int kSecurity = 0;

    /**
     * Clears the field "Security".
     *
     * The field will be set to its default value. The hasSecurity()
     * method will return false.
     */
    inline void clearSecurity();

    /**
     * Checks whether the field "Security" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSecurity()). Otherwise it will return false.
     */
    inline bool hasSecurity () const;

    /**
     * Returns the value of the member "Security".
     *
     * If the meaning of "Security" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Security"
     */
    inline const ::std::string& getSecurity () const;

    /**
     * Retrieves the value of the field "Security" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Security".
     */
    inline ::std::string& getSecurityMutable ();

    /**
     * Sets the value of the member "Security".
     *
     * If the meaning of "Security" isn't clear, then there should be a description here.
     *
     * @param Security The value which will be set
     */
    inline void setSecurity (const ::std::string& Security_);

    /**
     * Sets the value of the member "Security".
     *
     * If the meaning of "Security" isn't clear, then there should be a description here.
     *
     * @param Security The value which will be set
     */
    inline void setSecurity (const char* Security_);

    /**
     * Sets the value of the member "Security".
     *
     * If the meaning of "Security" isn't clear, then there should be a description here.
     *
     * @param Security The value which will be set
     */
    inline void setSecurity (const char* value, size_t size);

    static const SecurityUpdate &getDefaultInstance();

private:

    inline void set_has_Security ();

    inline void clear_has_Security ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Security;

};

/**
 * If the meaning of "SecurityRegister" isn't clear, then there should be a description here.
 */
class SecurityRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityRegister ();

    /**
     * Copy constructor
     */
    inline  SecurityRegister (const SecurityRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SecurityRegister();

    /**
     * Assignment operator
     */
    inline SecurityRegister& operator = (const SecurityRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SecurityRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PassphraseUpdate" isn't clear, then there should be a description here.
 */
class PassphraseUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PassphraseUpdate ();

    /**
     * Copy constructor
     */
    inline  PassphraseUpdate (const PassphraseUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PassphraseUpdate (const ::std::string& Passphrase_);

    /**
     * Destructor
     */
    inline virtual  ~PassphraseUpdate();

    /**
     * Assignment operator
     */
    inline PassphraseUpdate& operator = (const PassphraseUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PassphraseUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PassphraseUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PassphraseUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PassphraseUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Passphrase"

    static const int kPassphrase = 0;

    /**
     * Clears the field "Passphrase".
     *
     * The field will be set to its default value. The hasPassphrase()
     * method will return false.
     */
    inline void clearPassphrase();

    /**
     * Checks whether the field "Passphrase" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPassphrase()). Otherwise it will return false.
     */
    inline bool hasPassphrase () const;

    /**
     * Returns the value of the member "Passphrase".
     *
     * If the meaning of "Passphrase" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Passphrase"
     */
    inline const ::std::string& getPassphrase () const;

    /**
     * Retrieves the value of the field "Passphrase" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Passphrase".
     */
    inline ::std::string& getPassphraseMutable ();

    /**
     * Sets the value of the member "Passphrase".
     *
     * If the meaning of "Passphrase" isn't clear, then there should be a description here.
     *
     * @param Passphrase The value which will be set
     */
    inline void setPassphrase (const ::std::string& Passphrase_);

    /**
     * Sets the value of the member "Passphrase".
     *
     * If the meaning of "Passphrase" isn't clear, then there should be a description here.
     *
     * @param Passphrase The value which will be set
     */
    inline void setPassphrase (const char* Passphrase_);

    /**
     * Sets the value of the member "Passphrase".
     *
     * If the meaning of "Passphrase" isn't clear, then there should be a description here.
     *
     * @param Passphrase The value which will be set
     */
    inline void setPassphrase (const char* value, size_t size);

    static const PassphraseUpdate &getDefaultInstance();

private:

    inline void set_has_Passphrase ();

    inline void clear_has_Passphrase ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Passphrase;

};

/**
 * If the meaning of "PassphraseRegister" isn't clear, then there should be a description here.
 */
class PassphraseRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PassphraseRegister ();

    /**
     * Copy constructor
     */
    inline  PassphraseRegister (const PassphraseRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PassphraseRegister();

    /**
     * Assignment operator
     */
    inline PassphraseRegister& operator = (const PassphraseRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PassphraseRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PassphraseRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PassphraseRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PassphraseRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PassphraseRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "MaximumStationsAllowedUpdate" isn't clear, then there should be a description here.
 */
class MaximumStationsAllowedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MaximumStationsAllowedUpdate ();

    /**
     * Copy constructor
     */
    inline  MaximumStationsAllowedUpdate (const MaximumStationsAllowedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MaximumStationsAllowedUpdate (uint16 MaximumStationsAllowed_);

    /**
     * Destructor
     */
    inline virtual  ~MaximumStationsAllowedUpdate();

    /**
     * Assignment operator
     */
    inline MaximumStationsAllowedUpdate& operator = (const MaximumStationsAllowedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MaximumStationsAllowedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MaximumStationsAllowedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MaximumStationsAllowedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MaximumStationsAllowedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MaximumStationsAllowed"

    static const int kMaximumStationsAllowed = 0;

    /**
     * Clears the field "MaximumStationsAllowed".
     *
     * The field will be set to its default value. The hasMaximumStationsAllowed()
     * method will return false.
     */
    inline void clearMaximumStationsAllowed();

    /**
     * Checks whether the field "MaximumStationsAllowed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaximumStationsAllowed()). Otherwise it will return false.
     */
    inline bool hasMaximumStationsAllowed () const;

    /**
     * Returns the value of the member "MaximumStationsAllowed".
     *
     * If the meaning of "MaximumStationsAllowed" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MaximumStationsAllowed"
     */
    inline uint16 getMaximumStationsAllowed () const;

    /**
     * Sets the value of the member "MaximumStationsAllowed".
     *
     * If the meaning of "MaximumStationsAllowed" isn't clear, then there should be a description here.
     *
     * @param MaximumStationsAllowed The value which will be set
     */
    inline void setMaximumStationsAllowed (uint16 MaximumStationsAllowed_);

    static const MaximumStationsAllowedUpdate &getDefaultInstance();

private:

    inline void set_has_MaximumStationsAllowed ();

    inline void clear_has_MaximumStationsAllowed ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _MaximumStationsAllowed;

};

/**
 * If the meaning of "MaximumStationsAllowedRegister" isn't clear, then there should be a description here.
 */
class MaximumStationsAllowedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MaximumStationsAllowedRegister ();

    /**
     * Copy constructor
     */
    inline  MaximumStationsAllowedRegister (const MaximumStationsAllowedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MaximumStationsAllowedRegister();

    /**
     * Assignment operator
     */
    inline MaximumStationsAllowedRegister& operator = (const MaximumStationsAllowedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MaximumStationsAllowedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MaximumStationsAllowedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MaximumStationsAllowedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MaximumStationsAllowedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MaximumStationsAllowedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PowerStateUpdate" isn't clear, then there should be a description here.
 */
class PowerStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PowerStateUpdate ();

    /**
     * Copy constructor
     */
    inline  PowerStateUpdate (const PowerStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PowerStateUpdate (const ::std::string& PowerState_);

    /**
     * Destructor
     */
    inline virtual  ~PowerStateUpdate();

    /**
     * Assignment operator
     */
    inline PowerStateUpdate& operator = (const PowerStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PowerStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PowerStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PowerStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PowerStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PowerState"

    static const int kPowerState = 0;

    /**
     * Clears the field "PowerState".
     *
     * The field will be set to its default value. The hasPowerState()
     * method will return false.
     */
    inline void clearPowerState();

    /**
     * Checks whether the field "PowerState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPowerState()). Otherwise it will return false.
     */
    inline bool hasPowerState () const;

    /**
     * Returns the value of the member "PowerState".
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PowerState"
     */
    inline const ::std::string& getPowerState () const;

    /**
     * Retrieves the value of the field "PowerState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PowerState".
     */
    inline ::std::string& getPowerStateMutable ();

    /**
     * Sets the value of the member "PowerState".
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @param PowerState The value which will be set
     */
    inline void setPowerState (const ::std::string& PowerState_);

    /**
     * Sets the value of the member "PowerState".
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @param PowerState The value which will be set
     */
    inline void setPowerState (const char* PowerState_);

    /**
     * Sets the value of the member "PowerState".
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @param PowerState The value which will be set
     */
    inline void setPowerState (const char* value, size_t size);

    static const PowerStateUpdate &getDefaultInstance();

private:

    inline void set_has_PowerState ();

    inline void clear_has_PowerState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _PowerState;

};

/**
 * If the meaning of "PowerStateRegister" isn't clear, then there should be a description here.
 */
class PowerStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PowerStateRegister ();

    /**
     * Copy constructor
     */
    inline  PowerStateRegister (const PowerStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PowerStateRegister();

    /**
     * Assignment operator
     */
    inline PowerStateRegister& operator = (const PowerStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PowerStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PowerStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PowerStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PowerStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PowerStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PowerFailureReasonUpdate" isn't clear, then there should be a description here.
 */
class PowerFailureReasonUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PowerFailureReasonUpdate ();

    /**
     * Copy constructor
     */
    inline  PowerFailureReasonUpdate (const PowerFailureReasonUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PowerFailureReasonUpdate (const ::std::string& PowerFailureReason_);

    /**
     * Destructor
     */
    inline virtual  ~PowerFailureReasonUpdate();

    /**
     * Assignment operator
     */
    inline PowerFailureReasonUpdate& operator = (const PowerFailureReasonUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PowerFailureReasonUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PowerFailureReasonUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PowerFailureReasonUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PowerFailureReasonUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PowerFailureReason"

    static const int kPowerFailureReason = 0;

    /**
     * Clears the field "PowerFailureReason".
     *
     * The field will be set to its default value. The hasPowerFailureReason()
     * method will return false.
     */
    inline void clearPowerFailureReason();

    /**
     * Checks whether the field "PowerFailureReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPowerFailureReason()). Otherwise it will return false.
     */
    inline bool hasPowerFailureReason () const;

    /**
     * Returns the value of the member "PowerFailureReason".
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PowerFailureReason"
     */
    inline const ::std::string& getPowerFailureReason () const;

    /**
     * Retrieves the value of the field "PowerFailureReason" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PowerFailureReason".
     */
    inline ::std::string& getPowerFailureReasonMutable ();

    /**
     * Sets the value of the member "PowerFailureReason".
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @param PowerFailureReason The value which will be set
     */
    inline void setPowerFailureReason (const ::std::string& PowerFailureReason_);

    /**
     * Sets the value of the member "PowerFailureReason".
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @param PowerFailureReason The value which will be set
     */
    inline void setPowerFailureReason (const char* PowerFailureReason_);

    /**
     * Sets the value of the member "PowerFailureReason".
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @param PowerFailureReason The value which will be set
     */
    inline void setPowerFailureReason (const char* value, size_t size);

    static const PowerFailureReasonUpdate &getDefaultInstance();

private:

    inline void set_has_PowerFailureReason ();

    inline void clear_has_PowerFailureReason ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _PowerFailureReason;

};

/**
 * If the meaning of "PowerFailureReasonRegister" isn't clear, then there should be a description here.
 */
class PowerFailureReasonRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PowerFailureReasonRegister ();

    /**
     * Copy constructor
     */
    inline  PowerFailureReasonRegister (const PowerFailureReasonRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PowerFailureReasonRegister();

    /**
     * Assignment operator
     */
    inline PowerFailureReasonRegister& operator = (const PowerFailureReasonRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PowerFailureReasonRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PowerFailureReasonRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PowerFailureReasonRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PowerFailureReasonRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PowerFailureReasonRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "CurrentOperatingChannelUpdate" isn't clear, then there should be a description here.
 */
class CurrentOperatingChannelUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentOperatingChannelUpdate ();

    /**
     * Copy constructor
     */
    inline  CurrentOperatingChannelUpdate (const CurrentOperatingChannelUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CurrentOperatingChannelUpdate (uint16 CurrentOperatingChannel_);

    /**
     * Destructor
     */
    inline virtual  ~CurrentOperatingChannelUpdate();

    /**
     * Assignment operator
     */
    inline CurrentOperatingChannelUpdate& operator = (const CurrentOperatingChannelUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentOperatingChannelUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentOperatingChannelUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentOperatingChannelUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentOperatingChannelUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CurrentOperatingChannel"

    static const int kCurrentOperatingChannel = 0;

    /**
     * Clears the field "CurrentOperatingChannel".
     *
     * The field will be set to its default value. The hasCurrentOperatingChannel()
     * method will return false.
     */
    inline void clearCurrentOperatingChannel();

    /**
     * Checks whether the field "CurrentOperatingChannel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentOperatingChannel()). Otherwise it will return false.
     */
    inline bool hasCurrentOperatingChannel () const;

    /**
     * Returns the value of the member "CurrentOperatingChannel".
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CurrentOperatingChannel"
     */
    inline uint16 getCurrentOperatingChannel () const;

    /**
     * Sets the value of the member "CurrentOperatingChannel".
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     *
     * @param CurrentOperatingChannel The value which will be set
     */
    inline void setCurrentOperatingChannel (uint16 CurrentOperatingChannel_);

    static const CurrentOperatingChannelUpdate &getDefaultInstance();

private:

    inline void set_has_CurrentOperatingChannel ();

    inline void clear_has_CurrentOperatingChannel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _CurrentOperatingChannel;

};

/**
 * If the meaning of "CurrentOperatingChannelRegister" isn't clear, then there should be a description here.
 */
class CurrentOperatingChannelRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentOperatingChannelRegister ();

    /**
     * Copy constructor
     */
    inline  CurrentOperatingChannelRegister (const CurrentOperatingChannelRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CurrentOperatingChannelRegister();

    /**
     * Assignment operator
     */
    inline CurrentOperatingChannelRegister& operator = (const CurrentOperatingChannelRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentOperatingChannelRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentOperatingChannelRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentOperatingChannelRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentOperatingChannelRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CurrentOperatingChannelRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "CurrentHwModeUpdate" isn't clear, then there should be a description here.
 */
class CurrentHwModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentHwModeUpdate ();

    /**
     * Copy constructor
     */
    inline  CurrentHwModeUpdate (const CurrentHwModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CurrentHwModeUpdate (const ::std::string& CurrentHwMode_);

    /**
     * Destructor
     */
    inline virtual  ~CurrentHwModeUpdate();

    /**
     * Assignment operator
     */
    inline CurrentHwModeUpdate& operator = (const CurrentHwModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentHwModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentHwModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentHwModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentHwModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CurrentHwMode"

    static const int kCurrentHwMode = 0;

    /**
     * Clears the field "CurrentHwMode".
     *
     * The field will be set to its default value. The hasCurrentHwMode()
     * method will return false.
     */
    inline void clearCurrentHwMode();

    /**
     * Checks whether the field "CurrentHwMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentHwMode()). Otherwise it will return false.
     */
    inline bool hasCurrentHwMode () const;

    /**
     * Returns the value of the member "CurrentHwMode".
     *
     * If the meaning of "CurrentHwMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CurrentHwMode"
     */
    inline const ::std::string& getCurrentHwMode () const;

    /**
     * Retrieves the value of the field "CurrentHwMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CurrentHwMode".
     */
    inline ::std::string& getCurrentHwModeMutable ();

    /**
     * Sets the value of the member "CurrentHwMode".
     *
     * If the meaning of "CurrentHwMode" isn't clear, then there should be a description here.
     *
     * @param CurrentHwMode The value which will be set
     */
    inline void setCurrentHwMode (const ::std::string& CurrentHwMode_);

    /**
     * Sets the value of the member "CurrentHwMode".
     *
     * If the meaning of "CurrentHwMode" isn't clear, then there should be a description here.
     *
     * @param CurrentHwMode The value which will be set
     */
    inline void setCurrentHwMode (const char* CurrentHwMode_);

    /**
     * Sets the value of the member "CurrentHwMode".
     *
     * If the meaning of "CurrentHwMode" isn't clear, then there should be a description here.
     *
     * @param CurrentHwMode The value which will be set
     */
    inline void setCurrentHwMode (const char* value, size_t size);

    static const CurrentHwModeUpdate &getDefaultInstance();

private:

    inline void set_has_CurrentHwMode ();

    inline void clear_has_CurrentHwMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _CurrentHwMode;

};

/**
 * If the meaning of "CurrentHwModeRegister" isn't clear, then there should be a description here.
 */
class CurrentHwModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentHwModeRegister ();

    /**
     * Copy constructor
     */
    inline  CurrentHwModeRegister (const CurrentHwModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CurrentHwModeRegister();

    /**
     * Assignment operator
     */
    inline CurrentHwModeRegister& operator = (const CurrentHwModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentHwModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentHwModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentHwModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentHwModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CurrentHwModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "SupportedChannelsUpdate" isn't clear, then there should be a description here.
 */
class SupportedChannelsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SupportedChannelsUpdate ();

    /**
     * Copy constructor
     */
    inline  SupportedChannelsUpdate (const SupportedChannelsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SupportedChannelsUpdate (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& SupportedChannels_);

    /**
     * Destructor
     */
    inline virtual  ~SupportedChannelsUpdate();

    /**
     * Assignment operator
     */
    inline SupportedChannelsUpdate& operator = (const SupportedChannelsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SupportedChannelsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SupportedChannelsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SupportedChannelsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SupportedChannelsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SupportedChannels"

    static const int kSupportedChannels = 0;

    /**
     * Clears the field "SupportedChannels".
     *
     * The field will be set to its default value. The hasSupportedChannels()
     * method will return false.
     */
    inline void clearSupportedChannels();

    /**
     * Checks whether the field "SupportedChannels" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupportedChannels()). Otherwise it will return false.
     */
    inline bool hasSupportedChannels () const;

    /**
     * Returns the value of the member "SupportedChannels".
     *
     * If the meaning of "SupportedChannels" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SupportedChannels"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getSupportedChannels () const;

    /**
     * Retrieves the value of the field "SupportedChannels" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SupportedChannels".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getSupportedChannelsMutable ();

    /**
     * Sets the value of the member "SupportedChannels".
     *
     * If the meaning of "SupportedChannels" isn't clear, then there should be a description here.
     *
     * @param SupportedChannels The value which will be set
     */
    inline void setSupportedChannels (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& SupportedChannels_);

    static const SupportedChannelsUpdate &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_SupportedChannels ();

    inline void clear_has_SupportedChannels ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _SupportedChannels;

};

/**
 * If the meaning of "SupportedChannelsRegister" isn't clear, then there should be a description here.
 */
class SupportedChannelsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SupportedChannelsRegister ();

    /**
     * Copy constructor
     */
    inline  SupportedChannelsRegister (const SupportedChannelsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SupportedChannelsRegister();

    /**
     * Assignment operator
     */
    inline SupportedChannelsRegister& operator = (const SupportedChannelsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SupportedChannelsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SupportedChannelsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SupportedChannelsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SupportedChannelsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SupportedChannelsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "HWFeaturesUpdate" isn't clear, then there should be a description here.
 */
class HWFeaturesUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HWFeaturesUpdate ();

    /**
     * Copy constructor
     */
    inline  HWFeaturesUpdate (const HWFeaturesUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  HWFeaturesUpdate (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& HWFeatures_);

    /**
     * Destructor
     */
    inline virtual  ~HWFeaturesUpdate();

    /**
     * Assignment operator
     */
    inline HWFeaturesUpdate& operator = (const HWFeaturesUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HWFeaturesUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HWFeaturesUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HWFeaturesUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HWFeaturesUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "HWFeatures"

    static const int kHWFeatures = 0;

    /**
     * Clears the field "HWFeatures".
     *
     * The field will be set to its default value. The hasHWFeatures()
     * method will return false.
     */
    inline void clearHWFeatures();

    /**
     * Checks whether the field "HWFeatures" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHWFeatures()). Otherwise it will return false.
     */
    inline bool hasHWFeatures () const;

    /**
     * Returns the value of the member "HWFeatures".
     *
     * If the meaning of "HWFeatures" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HWFeatures"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getHWFeatures () const;

    /**
     * Retrieves the value of the field "HWFeatures" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "HWFeatures".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getHWFeaturesMutable ();

    /**
     * Sets the value of the member "HWFeatures".
     *
     * If the meaning of "HWFeatures" isn't clear, then there should be a description here.
     *
     * @param HWFeatures The value which will be set
     */
    inline void setHWFeatures (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& HWFeatures_);

    static const HWFeaturesUpdate &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_HWFeatures ();

    inline void clear_has_HWFeatures ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _HWFeatures;

};

/**
 * If the meaning of "HWFeaturesRegister" isn't clear, then there should be a description here.
 */
class HWFeaturesRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HWFeaturesRegister ();

    /**
     * Copy constructor
     */
    inline  HWFeaturesRegister (const HWFeaturesRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~HWFeaturesRegister();

    /**
     * Assignment operator
     */
    inline HWFeaturesRegister& operator = (const HWFeaturesRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HWFeaturesRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HWFeaturesRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HWFeaturesRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HWFeaturesRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const HWFeaturesRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "VendorIEsElem1Struct" isn't clear, then there should be a description here.
 */
class VendorIEsElem1Struct {
public:

    /**
     * Default constructor
     */
    inline  VendorIEsElem1Struct ();

    /**
     * Copy constructor
     */
    inline  VendorIEsElem1Struct (const VendorIEsElem1Struct &rhs);

    /**
     * All fields constructor
     */
    inline  VendorIEsElem1Struct (uint8 elem1_);

    /**
     * Destructor
     */
    inline  ~VendorIEsElem1Struct();

    /**
     * Assignment operator
     */
    inline VendorIEsElem1Struct& operator = (const VendorIEsElem1Struct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VendorIEsElem1Struct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VendorIEsElem1Struct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VendorIEsElem1Struct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VendorIEsElem1Struct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint8 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint8 elem1_);

    static const VendorIEsElem1Struct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _elem1;

};

/**
 * If the meaning of "VendorIEsStruct" isn't clear, then there should be a description here.
 */
class VendorIEsStruct {
public:

    /**
     * Default constructor
     */
    inline  VendorIEsStruct ();

    /**
     * Copy constructor
     */
    inline  VendorIEsStruct (const VendorIEsStruct &rhs);

    /**
     * All fields constructor
     */
    inline  VendorIEsStruct (const ::std::vector< VendorIEsElem1Struct >& elem1_);

    /**
     * Destructor
     */
    inline  ~VendorIEsStruct();

    /**
     * Assignment operator
     */
    inline VendorIEsStruct& operator = (const VendorIEsStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VendorIEsStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VendorIEsStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VendorIEsStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VendorIEsStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline const ::std::vector< VendorIEsElem1Struct >& getElem1 () const;

    /**
     * Retrieves the value of the field "elem1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem1".
     */
    inline ::std::vector< VendorIEsElem1Struct >& getElem1Mutable ();

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const ::std::vector< VendorIEsElem1Struct >& elem1_);

    static const VendorIEsStruct &getDefaultInstance();

private:

    static const ::std::vector< VendorIEsElem1Struct >& getVendorIEsElem1StructList_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< VendorIEsElem1Struct > _elem1;

};

/**
 * If the meaning of "VendorIEsUpdate" isn't clear, then there should be a description here.
 */
class VendorIEsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VendorIEsUpdate ();

    /**
     * Copy constructor
     */
    inline  VendorIEsUpdate (const VendorIEsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VendorIEsUpdate (const ::std::vector< VendorIEsStruct >& VendorIEs_);

    /**
     * Destructor
     */
    inline virtual  ~VendorIEsUpdate();

    /**
     * Assignment operator
     */
    inline VendorIEsUpdate& operator = (const VendorIEsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VendorIEsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VendorIEsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VendorIEsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VendorIEsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VendorIEs"

    static const int kVendorIEs = 0;

    /**
     * Clears the field "VendorIEs".
     *
     * The field will be set to its default value. The hasVendorIEs()
     * method will return false.
     */
    inline void clearVendorIEs();

    /**
     * Checks whether the field "VendorIEs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVendorIEs()). Otherwise it will return false.
     */
    inline bool hasVendorIEs () const;

    /**
     * Returns the value of the member "VendorIEs".
     *
     * If the meaning of "VendorIEs" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VendorIEs"
     */
    inline const ::std::vector< VendorIEsStruct >& getVendorIEs () const;

    /**
     * Retrieves the value of the field "VendorIEs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VendorIEs".
     */
    inline ::std::vector< VendorIEsStruct >& getVendorIEsMutable ();

    /**
     * Sets the value of the member "VendorIEs".
     *
     * If the meaning of "VendorIEs" isn't clear, then there should be a description here.
     *
     * @param VendorIEs The value which will be set
     */
    inline void setVendorIEs (const ::std::vector< VendorIEsStruct >& VendorIEs_);

    static const VendorIEsUpdate &getDefaultInstance();

private:

    static const ::std::vector< VendorIEsStruct >& getVendorIEsStructList_DefaultInstance ();

    inline void set_has_VendorIEs ();

    inline void clear_has_VendorIEs ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< VendorIEsStruct > _VendorIEs;

};

/**
 * If the meaning of "VendorIEsRegister" isn't clear, then there should be a description here.
 */
class VendorIEsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VendorIEsRegister ();

    /**
     * Copy constructor
     */
    inline  VendorIEsRegister (const VendorIEsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VendorIEsRegister();

    /**
     * Assignment operator
     */
    inline VendorIEsRegister& operator = (const VendorIEsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VendorIEsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VendorIEsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VendorIEsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VendorIEsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VendorIEsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AssociatedStationsChangedSignalChangedstationsStruct" isn't clear, then there should be a description here.
 */
class AssociatedStationsChangedSignalChangedstationsStruct {
public:

    /**
     * Default constructor
     */
    inline  AssociatedStationsChangedSignalChangedstationsStruct ();

    /**
     * Copy constructor
     */
    inline  AssociatedStationsChangedSignalChangedstationsStruct (const AssociatedStationsChangedSignalChangedstationsStruct &rhs);

    /**
     * All fields constructor
     */
    inline  AssociatedStationsChangedSignalChangedstationsStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    /**
     * Destructor
     */
    inline  ~AssociatedStationsChangedSignalChangedstationsStruct();

    /**
     * Assignment operator
     */
    inline AssociatedStationsChangedSignalChangedstationsStruct& operator = (const AssociatedStationsChangedSignalChangedstationsStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AssociatedStationsChangedSignalChangedstationsStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AssociatedStationsChangedSignalChangedstationsStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AssociatedStationsChangedSignalChangedstationsStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AssociatedStationsChangedSignalChangedstationsStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline const ::std::string& getElem1 () const;

    /**
     * Retrieves the value of the field "elem1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem1".
     */
    inline ::std::string& getElem1Mutable ();

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const ::std::string& elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* value, size_t size);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    static const AssociatedStationsChangedSignalChangedstationsStruct &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _elem1;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _elem2;

};

/**
 * If the meaning of "AssociatedStationsChangedSignal" isn't clear, then there should be a description here.
 */
class AssociatedStationsChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AssociatedStationsChangedSignal ();

    /**
     * Copy constructor
     */
    inline  AssociatedStationsChangedSignal (const AssociatedStationsChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  AssociatedStationsChangedSignal (const ::std::vector< AssociatedStationsChangedSignalChangedstationsStruct >& changedstations_, const ::std::vector< ::std::string >& removedstations_);

    /**
     * Destructor
     */
    inline virtual  ~AssociatedStationsChangedSignal();

    /**
     * Assignment operator
     */
    inline AssociatedStationsChangedSignal& operator = (const AssociatedStationsChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AssociatedStationsChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AssociatedStationsChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AssociatedStationsChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AssociatedStationsChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "changedstations"

    static const int kChangedstations = 0;

    /**
     * Clears the field "changedstations".
     *
     * The field will be set to its default value. The hasChangedstations()
     * method will return false.
     */
    inline void clearChangedstations();

    /**
     * Checks whether the field "changedstations" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChangedstations()). Otherwise it will return false.
     */
    inline bool hasChangedstations () const;

    /**
     * Returns the value of the member "changedstations".
     *
     * If the meaning of "changedstations" isn't clear, then there should be a description here.
     *
     * @return The value of the field "changedstations"
     */
    inline const ::std::vector< AssociatedStationsChangedSignalChangedstationsStruct >& getChangedstations () const;

    /**
     * Retrieves the value of the field "changedstations" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "changedstations".
     */
    inline ::std::vector< AssociatedStationsChangedSignalChangedstationsStruct >& getChangedstationsMutable ();

    /**
     * Sets the value of the member "changedstations".
     *
     * If the meaning of "changedstations" isn't clear, then there should be a description here.
     *
     * @param changedstations The value which will be set
     */
    inline void setChangedstations (const ::std::vector< AssociatedStationsChangedSignalChangedstationsStruct >& changedstations_);

    // API of field "removedstations"

    static const int kRemovedstations = 1;

    /**
     * Clears the field "removedstations".
     *
     * The field will be set to its default value. The hasRemovedstations()
     * method will return false.
     */
    inline void clearRemovedstations();

    /**
     * Checks whether the field "removedstations" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemovedstations()). Otherwise it will return false.
     */
    inline bool hasRemovedstations () const;

    /**
     * Returns the value of the member "removedstations".
     *
     * If the meaning of "removedstations" isn't clear, then there should be a description here.
     *
     * @return The value of the field "removedstations"
     */
    inline const ::std::vector< ::std::string >& getRemovedstations () const;

    /**
     * Retrieves the value of the field "removedstations" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "removedstations".
     */
    inline ::std::vector< ::std::string >& getRemovedstationsMutable ();

    /**
     * Sets the value of the member "removedstations".
     *
     * If the meaning of "removedstations" isn't clear, then there should be a description here.
     *
     * @param removedstations The value which will be set
     */
    inline void setRemovedstations (const ::std::vector< ::std::string >& removedstations_);

    static const AssociatedStationsChangedSignal &getDefaultInstance();

private:

    static const ::std::vector< AssociatedStationsChangedSignalChangedstationsStruct >& getAssociatedStationsChangedSignalChangedstationsStructList_DefaultInstance ();

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_changedstations ();

    inline void clear_has_changedstations ();

    inline void set_has_removedstations ();

    inline void clear_has_removedstations ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< AssociatedStationsChangedSignalChangedstationsStruct > _changedstations;

    ::std::vector< ::std::string > _removedstations;

};

/**
 * If the meaning of "AssociationRequestRejectedSignal" isn't clear, then there should be a description here.
 */
class AssociationRequestRejectedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AssociationRequestRejectedSignal ();

    /**
     * Copy constructor
     */
    inline  AssociationRequestRejectedSignal (const AssociationRequestRejectedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  AssociationRequestRejectedSignal (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station_);

    /**
     * Destructor
     */
    inline virtual  ~AssociationRequestRejectedSignal();

    /**
     * Assignment operator
     */
    inline AssociationRequestRejectedSignal& operator = (const AssociationRequestRejectedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AssociationRequestRejectedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AssociationRequestRejectedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AssociationRequestRejectedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AssociationRequestRejectedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "station"

    static const int kStation = 0;

    /**
     * Clears the field "station".
     *
     * The field will be set to its default value. The hasStation()
     * method will return false.
     */
    inline void clearStation();

    /**
     * Checks whether the field "station" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStation()). Otherwise it will return false.
     */
    inline bool hasStation () const;

    /**
     * Returns the value of the member "station".
     *
     * If the meaning of "station" isn't clear, then there should be a description here.
     *
     * @return The value of the field "station"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStation () const;

    /**
     * Retrieves the value of the field "station" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "station".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStationMutable ();

    /**
     * Sets the value of the member "station".
     *
     * If the meaning of "station" isn't clear, then there should be a description here.
     *
     * @param station The value which will be set
     */
    inline void setStation (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station_);

    static const AssociationRequestRejectedSignal &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_station ();

    inline void clear_has_station ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _station;

};

inline  SetSSIDRequest::SetSSIDRequest ()  :
    _ssid (),
    _utf_ssid (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetSSIDRequest::SetSSIDRequest (const SetSSIDRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ssid (),
    _utf_ssid (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetSSIDRequest::SetSSIDRequest (const ::std::vector< uint8 >& ssid_, bool utf_ssid_)  :
    _ssid (ssid_),
    _utf_ssid (utf_ssid_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetSSIDRequest::~SetSSIDRequest() {
}

inline SetSSIDRequest& SetSSIDRequest::operator = (const SetSSIDRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSsid()) {
            setSsid(rhs.getSsid());
        } else {
            clearSsid();
        }
        if (rhs.hasUtf_ssid()) {
            setUtf_ssid(rhs.getUtf_ssid());
        } else {
            clearUtf_ssid();
        }
    }
    return *this;
}

inline bool SetSSIDRequest::operator == (const SetSSIDRequest& rhs) const {
    return (((!hasSsid() && !rhs.hasSsid()) || getSsid() == rhs.getSsid()) &&
        ((!hasUtf_ssid() && !rhs.hasUtf_ssid()) || getUtf_ssid() == rhs.getUtf_ssid()));
}

inline bool SetSSIDRequest::operator != (const SetSSIDRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetSSIDRequest::operator < (const SetSSIDRequest& rhs) const {
    if (hasSsid() || rhs.hasSsid()) {
        if (getSsid() < rhs.getSsid()) return true;
        if (getSsid() > rhs.getSsid()) return false;
    }
    if (hasUtf_ssid() || rhs.hasUtf_ssid()) {
        if (getUtf_ssid() < rhs.getUtf_ssid()) return true;
        if (getUtf_ssid() > rhs.getUtf_ssid()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetSSIDRequest::clone() {
    return new SetSSIDRequest(*this);
}

inline bool SetSSIDRequest::operator > (const SetSSIDRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetSSIDRequest::clear() {
    clearSsid();
    clearUtf_ssid();
}

inline void SetSSIDRequest::clearSsid() {
    if (hasSsid()) {
         clear_has_ssid();
        _ssid.clear();
     }
}

inline bool SetSSIDRequest::hasSsid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& SetSSIDRequest::getSsid () const {
    return _ssid;
}

inline ::std::vector< uint8 >& SetSSIDRequest::getSsidMutable () {
    set_has_ssid();
    return _ssid;
}

inline void SetSSIDRequest::setSsid (const ::std::vector< uint8 >& ssid_) {
    set_has_ssid();
    this->_ssid = ssid_;
}

inline void SetSSIDRequest::clearUtf_ssid() {
    if (hasUtf_ssid()) {
         clear_has_utf_ssid();
        _utf_ssid = false;
     }
}

inline bool SetSSIDRequest::hasUtf_ssid () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SetSSIDRequest::getUtf_ssid () const {
    return _utf_ssid;
}

inline void SetSSIDRequest::setUtf_ssid (bool utf_ssid_) {
    set_has_utf_ssid();
    this->_utf_ssid = utf_ssid_;
}

inline void SetSSIDRequest::set_has_ssid () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetSSIDRequest::clear_has_ssid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetSSIDRequest::set_has_utf_ssid () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetSSIDRequest::clear_has_utf_ssid () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DeAuthenticateStationRequest::DeAuthenticateStationRequest ()  :
    _address ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeAuthenticateStationRequest::DeAuthenticateStationRequest (const DeAuthenticateStationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _address ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeAuthenticateStationRequest::DeAuthenticateStationRequest (const ::std::string& address_)  :
    _address (address_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeAuthenticateStationRequest::~DeAuthenticateStationRequest() {
}

inline DeAuthenticateStationRequest& DeAuthenticateStationRequest::operator = (const DeAuthenticateStationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
    }
    return *this;
}

inline bool DeAuthenticateStationRequest::operator == (const DeAuthenticateStationRequest& rhs) const {
    return (((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()));
}

inline bool DeAuthenticateStationRequest::operator != (const DeAuthenticateStationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DeAuthenticateStationRequest::operator < (const DeAuthenticateStationRequest& rhs) const {
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeAuthenticateStationRequest::clone() {
    return new DeAuthenticateStationRequest(*this);
}

inline bool DeAuthenticateStationRequest::operator > (const DeAuthenticateStationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeAuthenticateStationRequest::clear() {
    clearAddress();
}

inline void DeAuthenticateStationRequest::clearAddress() {
    if (hasAddress()) {
         clear_has_address();
        _address.clear();
     }
}

inline bool DeAuthenticateStationRequest::hasAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DeAuthenticateStationRequest::getAddress () const {
    return _address;
}

inline ::std::string& DeAuthenticateStationRequest::getAddressMutable () {
    set_has_address();
    return _address;
}

inline void DeAuthenticateStationRequest::setAddress (const ::std::string& address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address = address_;
}

inline void DeAuthenticateStationRequest::setAddress (const char* address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(address_);
}

inline void DeAuthenticateStationRequest::setAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(value, size);
}

inline void DeAuthenticateStationRequest::set_has_address () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeAuthenticateStationRequest::clear_has_address () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BlacklistStationRequest::BlacklistStationRequest ()  :
    _address (),
    _allow (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BlacklistStationRequest::BlacklistStationRequest (const BlacklistStationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _address (),
    _allow (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BlacklistStationRequest::BlacklistStationRequest (const ::std::string& address_, bool allow_)  :
    _address (address_),
    _allow (allow_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BlacklistStationRequest::~BlacklistStationRequest() {
}

inline BlacklistStationRequest& BlacklistStationRequest::operator = (const BlacklistStationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
        if (rhs.hasAllow()) {
            setAllow(rhs.getAllow());
        } else {
            clearAllow();
        }
    }
    return *this;
}

inline bool BlacklistStationRequest::operator == (const BlacklistStationRequest& rhs) const {
    return (((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()) &&
        ((!hasAllow() && !rhs.hasAllow()) || getAllow() == rhs.getAllow()));
}

inline bool BlacklistStationRequest::operator != (const BlacklistStationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool BlacklistStationRequest::operator < (const BlacklistStationRequest& rhs) const {
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    if (hasAllow() || rhs.hasAllow()) {
        if (getAllow() < rhs.getAllow()) return true;
        if (getAllow() > rhs.getAllow()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BlacklistStationRequest::clone() {
    return new BlacklistStationRequest(*this);
}

inline bool BlacklistStationRequest::operator > (const BlacklistStationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BlacklistStationRequest::clear() {
    clearAddress();
    clearAllow();
}

inline void BlacklistStationRequest::clearAddress() {
    if (hasAddress()) {
         clear_has_address();
        _address.clear();
     }
}

inline bool BlacklistStationRequest::hasAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& BlacklistStationRequest::getAddress () const {
    return _address;
}

inline ::std::string& BlacklistStationRequest::getAddressMutable () {
    set_has_address();
    return _address;
}

inline void BlacklistStationRequest::setAddress (const ::std::string& address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address = address_;
}

inline void BlacklistStationRequest::setAddress (const char* address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(address_);
}

inline void BlacklistStationRequest::setAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(value, size);
}

inline void BlacklistStationRequest::clearAllow() {
    if (hasAllow()) {
         clear_has_allow();
        _allow = false;
     }
}

inline bool BlacklistStationRequest::hasAllow () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool BlacklistStationRequest::getAllow () const {
    return _allow;
}

inline void BlacklistStationRequest::setAllow (bool allow_) {
    set_has_allow();
    this->_allow = allow_;
}

inline void BlacklistStationRequest::set_has_address () {
    _has_bits_[0] |= 1u << 0;
}

inline void BlacklistStationRequest::clear_has_address () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BlacklistStationRequest::set_has_allow () {
    _has_bits_[0] |= 1u << 1;
}

inline void BlacklistStationRequest::clear_has_allow () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetOperatingChannelsRequest::SetOperatingChannelsRequest ()  :
    _channels ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetOperatingChannelsRequest::SetOperatingChannelsRequest (const SetOperatingChannelsRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _channels ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetOperatingChannelsRequest::SetOperatingChannelsRequest (const ::std::vector< uint16 >& channels_)  :
    _channels (channels_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetOperatingChannelsRequest::~SetOperatingChannelsRequest() {
}

inline SetOperatingChannelsRequest& SetOperatingChannelsRequest::operator = (const SetOperatingChannelsRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasChannels()) {
            setChannels(rhs.getChannels());
        } else {
            clearChannels();
        }
    }
    return *this;
}

inline bool SetOperatingChannelsRequest::operator == (const SetOperatingChannelsRequest& rhs) const {
    return (((!hasChannels() && !rhs.hasChannels()) || getChannels() == rhs.getChannels()));
}

inline bool SetOperatingChannelsRequest::operator != (const SetOperatingChannelsRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetOperatingChannelsRequest::operator < (const SetOperatingChannelsRequest& rhs) const {
    if (hasChannels() || rhs.hasChannels()) {
        if (getChannels() < rhs.getChannels()) return true;
        if (getChannels() > rhs.getChannels()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetOperatingChannelsRequest::clone() {
    return new SetOperatingChannelsRequest(*this);
}

inline bool SetOperatingChannelsRequest::operator > (const SetOperatingChannelsRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetOperatingChannelsRequest::clear() {
    clearChannels();
}

inline void SetOperatingChannelsRequest::clearChannels() {
    if (hasChannels()) {
         clear_has_channels();
        _channels.clear();
     }
}

inline bool SetOperatingChannelsRequest::hasChannels () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint16 >& SetOperatingChannelsRequest::getChannels () const {
    return _channels;
}

inline ::std::vector< uint16 >& SetOperatingChannelsRequest::getChannelsMutable () {
    set_has_channels();
    return _channels;
}

inline void SetOperatingChannelsRequest::setChannels (const ::std::vector< uint16 >& channels_) {
    set_has_channels();
    this->_channels = channels_;
}

inline void SetOperatingChannelsRequest::set_has_channels () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetOperatingChannelsRequest::clear_has_channels () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetAssociatedStationsResponseAssociatedstationsStruct::GetAssociatedStationsResponseAssociatedstationsStruct ()  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAssociatedStationsResponseAssociatedstationsStruct::GetAssociatedStationsResponseAssociatedstationsStruct (const GetAssociatedStationsResponseAssociatedstationsStruct &rhs)  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAssociatedStationsResponseAssociatedstationsStruct::GetAssociatedStationsResponseAssociatedstationsStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAssociatedStationsResponseAssociatedstationsStruct::~GetAssociatedStationsResponseAssociatedstationsStruct() {
}

inline GetAssociatedStationsResponseAssociatedstationsStruct& GetAssociatedStationsResponseAssociatedstationsStruct::operator = (const GetAssociatedStationsResponseAssociatedstationsStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool GetAssociatedStationsResponseAssociatedstationsStruct::operator == (const GetAssociatedStationsResponseAssociatedstationsStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool GetAssociatedStationsResponseAssociatedstationsStruct::operator != (const GetAssociatedStationsResponseAssociatedstationsStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAssociatedStationsResponseAssociatedstationsStruct::operator < (const GetAssociatedStationsResponseAssociatedstationsStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool GetAssociatedStationsResponseAssociatedstationsStruct::operator > (const GetAssociatedStationsResponseAssociatedstationsStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAssociatedStationsResponseAssociatedstationsStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void GetAssociatedStationsResponseAssociatedstationsStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1.clear();
     }
}

inline bool GetAssociatedStationsResponseAssociatedstationsStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetAssociatedStationsResponseAssociatedstationsStruct::getElem1 () const {
    return _elem1;
}

inline ::std::string& GetAssociatedStationsResponseAssociatedstationsStruct::getElem1Mutable () {
    set_has_elem1();
    return _elem1;
}

inline void GetAssociatedStationsResponseAssociatedstationsStruct::setElem1 (const ::std::string& elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetAssociatedStationsResponseAssociatedstationsStruct::setElem1 (const char* elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(elem1_);
}

inline void GetAssociatedStationsResponseAssociatedstationsStruct::setElem1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(value, size);
}

inline void GetAssociatedStationsResponseAssociatedstationsStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool GetAssociatedStationsResponseAssociatedstationsStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetAssociatedStationsResponseAssociatedstationsStruct::getElem2 () const {
    return _elem2;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetAssociatedStationsResponseAssociatedstationsStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void GetAssociatedStationsResponseAssociatedstationsStruct::setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetAssociatedStationsResponseAssociatedstationsStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAssociatedStationsResponseAssociatedstationsStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetAssociatedStationsResponseAssociatedstationsStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetAssociatedStationsResponseAssociatedstationsStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetAssociatedStationsResponse::GetAssociatedStationsResponse ()  :
    _associatedstations ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAssociatedStationsResponse::GetAssociatedStationsResponse (const GetAssociatedStationsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _associatedstations ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAssociatedStationsResponse::GetAssociatedStationsResponse (const ::std::vector< GetAssociatedStationsResponseAssociatedstationsStruct >& associatedstations_)  :
    _associatedstations (associatedstations_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAssociatedStationsResponse::~GetAssociatedStationsResponse() {
}

inline GetAssociatedStationsResponse& GetAssociatedStationsResponse::operator = (const GetAssociatedStationsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAssociatedstations()) {
            setAssociatedstations(rhs.getAssociatedstations());
        } else {
            clearAssociatedstations();
        }
    }
    return *this;
}

inline bool GetAssociatedStationsResponse::operator == (const GetAssociatedStationsResponse& rhs) const {
    return (((!hasAssociatedstations() && !rhs.hasAssociatedstations()) || getAssociatedstations() == rhs.getAssociatedstations()));
}

inline bool GetAssociatedStationsResponse::operator != (const GetAssociatedStationsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAssociatedStationsResponse::operator < (const GetAssociatedStationsResponse& rhs) const {
    if (hasAssociatedstations() || rhs.hasAssociatedstations()) {
        if (getAssociatedstations() < rhs.getAssociatedstations()) return true;
        if (getAssociatedstations() > rhs.getAssociatedstations()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetAssociatedStationsResponse::clone() {
    return new GetAssociatedStationsResponse(*this);
}

inline bool GetAssociatedStationsResponse::operator > (const GetAssociatedStationsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAssociatedStationsResponse::clear() {
    clearAssociatedstations();
}

inline void GetAssociatedStationsResponse::clearAssociatedstations() {
    if (hasAssociatedstations()) {
         clear_has_associatedstations();
        _associatedstations.clear();
     }
}

inline bool GetAssociatedStationsResponse::hasAssociatedstations () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< GetAssociatedStationsResponseAssociatedstationsStruct >& GetAssociatedStationsResponse::getAssociatedstations () const {
    return _associatedstations;
}

inline ::std::vector< GetAssociatedStationsResponseAssociatedstationsStruct >& GetAssociatedStationsResponse::getAssociatedstationsMutable () {
    set_has_associatedstations();
    return _associatedstations;
}

inline void GetAssociatedStationsResponse::setAssociatedstations (const ::std::vector< GetAssociatedStationsResponseAssociatedstationsStruct >& associatedstations_) {
    set_has_associatedstations();
    this->_associatedstations = associatedstations_;
}

inline void GetAssociatedStationsResponse::set_has_associatedstations () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAssociatedStationsResponse::clear_has_associatedstations () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RegisterVendorServiceRequest::RegisterVendorServiceRequest ()  :
    _IEs ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterVendorServiceRequest::RegisterVendorServiceRequest (const RegisterVendorServiceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _IEs ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterVendorServiceRequest::RegisterVendorServiceRequest (const ::std::vector< ::std::vector< uint8 > >& IEs_)  :
    _IEs (IEs_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterVendorServiceRequest::~RegisterVendorServiceRequest() {
}

inline RegisterVendorServiceRequest& RegisterVendorServiceRequest::operator = (const RegisterVendorServiceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIEs()) {
            setIEs(rhs.getIEs());
        } else {
            clearIEs();
        }
    }
    return *this;
}

inline bool RegisterVendorServiceRequest::operator == (const RegisterVendorServiceRequest& rhs) const {
    return (((!hasIEs() && !rhs.hasIEs()) || getIEs() == rhs.getIEs()));
}

inline bool RegisterVendorServiceRequest::operator != (const RegisterVendorServiceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterVendorServiceRequest::operator < (const RegisterVendorServiceRequest& rhs) const {
    if (hasIEs() || rhs.hasIEs()) {
        if (getIEs() < rhs.getIEs()) return true;
        if (getIEs() > rhs.getIEs()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterVendorServiceRequest::clone() {
    return new RegisterVendorServiceRequest(*this);
}

inline bool RegisterVendorServiceRequest::operator > (const RegisterVendorServiceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterVendorServiceRequest::clear() {
    clearIEs();
}

inline void RegisterVendorServiceRequest::clearIEs() {
    if (hasIEs()) {
         clear_has_IEs();
        _IEs.clear();
     }
}

inline bool RegisterVendorServiceRequest::hasIEs () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::vector< uint8 > >& RegisterVendorServiceRequest::getIEs () const {
    return _IEs;
}

inline ::std::vector< ::std::vector< uint8 > >& RegisterVendorServiceRequest::getIEsMutable () {
    set_has_IEs();
    return _IEs;
}

inline void RegisterVendorServiceRequest::setIEs (const ::std::vector< ::std::vector< uint8 > >& IEs_) {
    set_has_IEs();
    this->_IEs = IEs_;
}

inline void RegisterVendorServiceRequest::set_has_IEs () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterVendorServiceRequest::clear_has_IEs () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UnregisterVendorServiceRequest::UnregisterVendorServiceRequest ()  :
    _IEs ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnregisterVendorServiceRequest::UnregisterVendorServiceRequest (const UnregisterVendorServiceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _IEs ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnregisterVendorServiceRequest::UnregisterVendorServiceRequest (const ::std::vector< ::std::vector< uint8 > >& IEs_)  :
    _IEs (IEs_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnregisterVendorServiceRequest::~UnregisterVendorServiceRequest() {
}

inline UnregisterVendorServiceRequest& UnregisterVendorServiceRequest::operator = (const UnregisterVendorServiceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIEs()) {
            setIEs(rhs.getIEs());
        } else {
            clearIEs();
        }
    }
    return *this;
}

inline bool UnregisterVendorServiceRequest::operator == (const UnregisterVendorServiceRequest& rhs) const {
    return (((!hasIEs() && !rhs.hasIEs()) || getIEs() == rhs.getIEs()));
}

inline bool UnregisterVendorServiceRequest::operator != (const UnregisterVendorServiceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UnregisterVendorServiceRequest::operator < (const UnregisterVendorServiceRequest& rhs) const {
    if (hasIEs() || rhs.hasIEs()) {
        if (getIEs() < rhs.getIEs()) return true;
        if (getIEs() > rhs.getIEs()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnregisterVendorServiceRequest::clone() {
    return new UnregisterVendorServiceRequest(*this);
}

inline bool UnregisterVendorServiceRequest::operator > (const UnregisterVendorServiceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnregisterVendorServiceRequest::clear() {
    clearIEs();
}

inline void UnregisterVendorServiceRequest::clearIEs() {
    if (hasIEs()) {
         clear_has_IEs();
        _IEs.clear();
     }
}

inline bool UnregisterVendorServiceRequest::hasIEs () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::vector< uint8 > >& UnregisterVendorServiceRequest::getIEs () const {
    return _IEs;
}

inline ::std::vector< ::std::vector< uint8 > >& UnregisterVendorServiceRequest::getIEsMutable () {
    set_has_IEs();
    return _IEs;
}

inline void UnregisterVendorServiceRequest::setIEs (const ::std::vector< ::std::vector< uint8 > >& IEs_) {
    set_has_IEs();
    this->_IEs = IEs_;
}

inline void UnregisterVendorServiceRequest::set_has_IEs () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnregisterVendorServiceRequest::clear_has_IEs () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetDnsDhcpConfResponseDnsdhcpserverconfStruct::GetDnsDhcpConfResponseDnsdhcpserverconfStruct ()  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetDnsDhcpConfResponseDnsdhcpserverconfStruct::GetDnsDhcpConfResponseDnsdhcpserverconfStruct (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct &rhs)  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetDnsDhcpConfResponseDnsdhcpserverconfStruct::GetDnsDhcpConfResponseDnsdhcpserverconfStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetDnsDhcpConfResponseDnsdhcpserverconfStruct::~GetDnsDhcpConfResponseDnsdhcpserverconfStruct() {
}

inline GetDnsDhcpConfResponseDnsdhcpserverconfStruct& GetDnsDhcpConfResponseDnsdhcpserverconfStruct::operator = (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool GetDnsDhcpConfResponseDnsdhcpserverconfStruct::operator == (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool GetDnsDhcpConfResponseDnsdhcpserverconfStruct::operator != (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetDnsDhcpConfResponseDnsdhcpserverconfStruct::operator < (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool GetDnsDhcpConfResponseDnsdhcpserverconfStruct::operator > (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetDnsDhcpConfResponseDnsdhcpserverconfStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void GetDnsDhcpConfResponseDnsdhcpserverconfStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1.clear();
     }
}

inline bool GetDnsDhcpConfResponseDnsdhcpserverconfStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetDnsDhcpConfResponseDnsdhcpserverconfStruct::getElem1 () const {
    return _elem1;
}

inline ::std::string& GetDnsDhcpConfResponseDnsdhcpserverconfStruct::getElem1Mutable () {
    set_has_elem1();
    return _elem1;
}

inline void GetDnsDhcpConfResponseDnsdhcpserverconfStruct::setElem1 (const ::std::string& elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetDnsDhcpConfResponseDnsdhcpserverconfStruct::setElem1 (const char* elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(elem1_);
}

inline void GetDnsDhcpConfResponseDnsdhcpserverconfStruct::setElem1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(value, size);
}

inline void GetDnsDhcpConfResponseDnsdhcpserverconfStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool GetDnsDhcpConfResponseDnsdhcpserverconfStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetDnsDhcpConfResponseDnsdhcpserverconfStruct::getElem2 () const {
    return _elem2;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetDnsDhcpConfResponseDnsdhcpserverconfStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void GetDnsDhcpConfResponseDnsdhcpserverconfStruct::setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetDnsDhcpConfResponseDnsdhcpserverconfStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetDnsDhcpConfResponseDnsdhcpserverconfStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetDnsDhcpConfResponseDnsdhcpserverconfStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetDnsDhcpConfResponseDnsdhcpserverconfStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetDnsDhcpConfResponse::GetDnsDhcpConfResponse ()  :
    _dnsdhcpserverconf ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetDnsDhcpConfResponse::GetDnsDhcpConfResponse (const GetDnsDhcpConfResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _dnsdhcpserverconf ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetDnsDhcpConfResponse::GetDnsDhcpConfResponse (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& dnsdhcpserverconf_)  :
    _dnsdhcpserverconf (dnsdhcpserverconf_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetDnsDhcpConfResponse::~GetDnsDhcpConfResponse() {
}

inline GetDnsDhcpConfResponse& GetDnsDhcpConfResponse::operator = (const GetDnsDhcpConfResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDnsdhcpserverconf()) {
            setDnsdhcpserverconf(rhs.getDnsdhcpserverconf());
        } else {
            clearDnsdhcpserverconf();
        }
    }
    return *this;
}

inline bool GetDnsDhcpConfResponse::operator == (const GetDnsDhcpConfResponse& rhs) const {
    return (((!hasDnsdhcpserverconf() && !rhs.hasDnsdhcpserverconf()) || getDnsdhcpserverconf() == rhs.getDnsdhcpserverconf()));
}

inline bool GetDnsDhcpConfResponse::operator != (const GetDnsDhcpConfResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetDnsDhcpConfResponse::operator < (const GetDnsDhcpConfResponse& rhs) const {
    if (hasDnsdhcpserverconf() || rhs.hasDnsdhcpserverconf()) {
        if (getDnsdhcpserverconf() < rhs.getDnsdhcpserverconf()) return true;
        if (getDnsdhcpserverconf() > rhs.getDnsdhcpserverconf()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetDnsDhcpConfResponse::clone() {
    return new GetDnsDhcpConfResponse(*this);
}

inline bool GetDnsDhcpConfResponse::operator > (const GetDnsDhcpConfResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetDnsDhcpConfResponse::clear() {
    clearDnsdhcpserverconf();
}

inline void GetDnsDhcpConfResponse::clearDnsdhcpserverconf() {
    if (hasDnsdhcpserverconf()) {
         clear_has_dnsdhcpserverconf();
        _dnsdhcpserverconf.clear();
     }
}

inline bool GetDnsDhcpConfResponse::hasDnsdhcpserverconf () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& GetDnsDhcpConfResponse::getDnsdhcpserverconf () const {
    return _dnsdhcpserverconf;
}

inline GetDnsDhcpConfResponseDnsdhcpserverconfStruct& GetDnsDhcpConfResponse::getDnsdhcpserverconfMutable () {
    set_has_dnsdhcpserverconf();
    return _dnsdhcpserverconf;
}

inline void GetDnsDhcpConfResponse::setDnsdhcpserverconf (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& dnsdhcpserverconf_) {
    set_has_dnsdhcpserverconf();
    this->_dnsdhcpserverconf = dnsdhcpserverconf_;
}

inline void GetDnsDhcpConfResponse::set_has_dnsdhcpserverconf () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetDnsDhcpConfResponse::clear_has_dnsdhcpserverconf () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SSIDUpdate::SSIDUpdate ()  :
    _SSID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SSIDUpdate::SSIDUpdate (const SSIDUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _SSID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SSIDUpdate::SSIDUpdate (const ::std::vector< uint8 >& SSID_)  :
    _SSID (SSID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SSIDUpdate::~SSIDUpdate() {
}

inline SSIDUpdate& SSIDUpdate::operator = (const SSIDUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSSID()) {
            setSSID(rhs.getSSID());
        } else {
            clearSSID();
        }
    }
    return *this;
}

inline bool SSIDUpdate::operator == (const SSIDUpdate& rhs) const {
    return (((!hasSSID() && !rhs.hasSSID()) || getSSID() == rhs.getSSID()));
}

inline bool SSIDUpdate::operator != (const SSIDUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SSIDUpdate::operator < (const SSIDUpdate& rhs) const {
    if (hasSSID() || rhs.hasSSID()) {
        if (getSSID() < rhs.getSSID()) return true;
        if (getSSID() > rhs.getSSID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SSIDUpdate::clone() {
    return new SSIDUpdate(*this);
}

inline bool SSIDUpdate::operator > (const SSIDUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SSIDUpdate::clear() {
    clearSSID();
}

inline void SSIDUpdate::clearSSID() {
    if (hasSSID()) {
         clear_has_SSID();
        _SSID.clear();
     }
}

inline bool SSIDUpdate::hasSSID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& SSIDUpdate::getSSID () const {
    return _SSID;
}

inline ::std::vector< uint8 >& SSIDUpdate::getSSIDMutable () {
    set_has_SSID();
    return _SSID;
}

inline void SSIDUpdate::setSSID (const ::std::vector< uint8 >& SSID_) {
    set_has_SSID();
    this->_SSID = SSID_;
}

inline void SSIDUpdate::set_has_SSID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SSIDUpdate::clear_has_SSID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SSIDRegister::SSIDRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SSIDRegister::SSIDRegister (const SSIDRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SSIDRegister::~SSIDRegister() {
}

inline SSIDRegister& SSIDRegister::operator = (const SSIDRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SSIDRegister::operator == (const SSIDRegister& ) const {
    return true;
}

inline bool SSIDRegister::operator != (const SSIDRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SSIDRegister::operator < (const SSIDRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SSIDRegister::clone() {
    return new SSIDRegister(*this);
}

inline bool SSIDRegister::operator > (const SSIDRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SSIDRegister::clear() {
}

inline  MacAddressUpdate::MacAddressUpdate ()  :
    _MacAddress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MacAddressUpdate::MacAddressUpdate (const MacAddressUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _MacAddress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MacAddressUpdate::MacAddressUpdate (const ::std::string& MacAddress_)  :
    _MacAddress (MacAddress_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MacAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MacAddressUpdate::~MacAddressUpdate() {
}

inline MacAddressUpdate& MacAddressUpdate::operator = (const MacAddressUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMacAddress()) {
            setMacAddress(rhs.getMacAddress());
        } else {
            clearMacAddress();
        }
    }
    return *this;
}

inline bool MacAddressUpdate::operator == (const MacAddressUpdate& rhs) const {
    return (((!hasMacAddress() && !rhs.hasMacAddress()) || getMacAddress() == rhs.getMacAddress()));
}

inline bool MacAddressUpdate::operator != (const MacAddressUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool MacAddressUpdate::operator < (const MacAddressUpdate& rhs) const {
    if (hasMacAddress() || rhs.hasMacAddress()) {
        if (getMacAddress() < rhs.getMacAddress()) return true;
        if (getMacAddress() > rhs.getMacAddress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MacAddressUpdate::clone() {
    return new MacAddressUpdate(*this);
}

inline bool MacAddressUpdate::operator > (const MacAddressUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MacAddressUpdate::clear() {
    clearMacAddress();
}

inline void MacAddressUpdate::clearMacAddress() {
    if (hasMacAddress()) {
         clear_has_MacAddress();
        _MacAddress.clear();
     }
}

inline bool MacAddressUpdate::hasMacAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& MacAddressUpdate::getMacAddress () const {
    return _MacAddress;
}

inline ::std::string& MacAddressUpdate::getMacAddressMutable () {
    set_has_MacAddress();
    return _MacAddress;
}

inline void MacAddressUpdate::setMacAddress (const ::std::string& MacAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MacAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MacAddress();
    this->_MacAddress = MacAddress_;
}

inline void MacAddressUpdate::setMacAddress (const char* MacAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MacAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MacAddress();
    this->_MacAddress.assign(MacAddress_);
}

inline void MacAddressUpdate::setMacAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MacAddress();
    this->_MacAddress.assign(value, size);
}

inline void MacAddressUpdate::set_has_MacAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void MacAddressUpdate::clear_has_MacAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MacAddressRegister::MacAddressRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MacAddressRegister::MacAddressRegister (const MacAddressRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MacAddressRegister::~MacAddressRegister() {
}

inline MacAddressRegister& MacAddressRegister::operator = (const MacAddressRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool MacAddressRegister::operator == (const MacAddressRegister& ) const {
    return true;
}

inline bool MacAddressRegister::operator != (const MacAddressRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool MacAddressRegister::operator < (const MacAddressRegister& ) const {
    return false;
}

inline ::asf::core::Payload* MacAddressRegister::clone() {
    return new MacAddressRegister(*this);
}

inline bool MacAddressRegister::operator > (const MacAddressRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MacAddressRegister::clear() {
}

inline  InterfaceUpdate::InterfaceUpdate ()  :
    _Interface ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InterfaceUpdate::InterfaceUpdate (const InterfaceUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Interface ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InterfaceUpdate::InterfaceUpdate (const ::std::string& Interface_)  :
    _Interface (Interface_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Interface_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  InterfaceUpdate::~InterfaceUpdate() {
}

inline InterfaceUpdate& InterfaceUpdate::operator = (const InterfaceUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInterface()) {
            setInterface(rhs.getInterface());
        } else {
            clearInterface();
        }
    }
    return *this;
}

inline bool InterfaceUpdate::operator == (const InterfaceUpdate& rhs) const {
    return (((!hasInterface() && !rhs.hasInterface()) || getInterface() == rhs.getInterface()));
}

inline bool InterfaceUpdate::operator != (const InterfaceUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool InterfaceUpdate::operator < (const InterfaceUpdate& rhs) const {
    if (hasInterface() || rhs.hasInterface()) {
        if (getInterface() < rhs.getInterface()) return true;
        if (getInterface() > rhs.getInterface()) return false;
    }
    return false;
}

inline ::asf::core::Payload* InterfaceUpdate::clone() {
    return new InterfaceUpdate(*this);
}

inline bool InterfaceUpdate::operator > (const InterfaceUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InterfaceUpdate::clear() {
    clearInterface();
}

inline void InterfaceUpdate::clearInterface() {
    if (hasInterface()) {
         clear_has_Interface();
        _Interface.clear();
     }
}

inline bool InterfaceUpdate::hasInterface () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& InterfaceUpdate::getInterface () const {
    return _Interface;
}

inline ::std::string& InterfaceUpdate::getInterfaceMutable () {
    set_has_Interface();
    return _Interface;
}

inline void InterfaceUpdate::setInterface (const ::std::string& Interface_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Interface_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Interface();
    this->_Interface = Interface_;
}

inline void InterfaceUpdate::setInterface (const char* Interface_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Interface_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Interface();
    this->_Interface.assign(Interface_);
}

inline void InterfaceUpdate::setInterface (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Interface();
    this->_Interface.assign(value, size);
}

inline void InterfaceUpdate::set_has_Interface () {
    _has_bits_[0] |= 1u << 0;
}

inline void InterfaceUpdate::clear_has_Interface () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  InterfaceRegister::InterfaceRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InterfaceRegister::InterfaceRegister (const InterfaceRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InterfaceRegister::~InterfaceRegister() {
}

inline InterfaceRegister& InterfaceRegister::operator = (const InterfaceRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool InterfaceRegister::operator == (const InterfaceRegister& ) const {
    return true;
}

inline bool InterfaceRegister::operator != (const InterfaceRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool InterfaceRegister::operator < (const InterfaceRegister& ) const {
    return false;
}

inline ::asf::core::Payload* InterfaceRegister::clone() {
    return new InterfaceRegister(*this);
}

inline bool InterfaceRegister::operator > (const InterfaceRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InterfaceRegister::clear() {
}

inline  BlackListedStationsUpdate::BlackListedStationsUpdate ()  :
    _BlackListedStations ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BlackListedStationsUpdate::BlackListedStationsUpdate (const BlackListedStationsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _BlackListedStations ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BlackListedStationsUpdate::BlackListedStationsUpdate (const ::std::vector< ::std::string >& BlackListedStations_)  :
    _BlackListedStations (BlackListedStations_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BlackListedStationsUpdate::~BlackListedStationsUpdate() {
}

inline BlackListedStationsUpdate& BlackListedStationsUpdate::operator = (const BlackListedStationsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBlackListedStations()) {
            setBlackListedStations(rhs.getBlackListedStations());
        } else {
            clearBlackListedStations();
        }
    }
    return *this;
}

inline bool BlackListedStationsUpdate::operator == (const BlackListedStationsUpdate& rhs) const {
    return (((!hasBlackListedStations() && !rhs.hasBlackListedStations()) || getBlackListedStations() == rhs.getBlackListedStations()));
}

inline bool BlackListedStationsUpdate::operator != (const BlackListedStationsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool BlackListedStationsUpdate::operator < (const BlackListedStationsUpdate& rhs) const {
    if (hasBlackListedStations() || rhs.hasBlackListedStations()) {
        if (getBlackListedStations() < rhs.getBlackListedStations()) return true;
        if (getBlackListedStations() > rhs.getBlackListedStations()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BlackListedStationsUpdate::clone() {
    return new BlackListedStationsUpdate(*this);
}

inline bool BlackListedStationsUpdate::operator > (const BlackListedStationsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BlackListedStationsUpdate::clear() {
    clearBlackListedStations();
}

inline void BlackListedStationsUpdate::clearBlackListedStations() {
    if (hasBlackListedStations()) {
         clear_has_BlackListedStations();
        _BlackListedStations.clear();
     }
}

inline bool BlackListedStationsUpdate::hasBlackListedStations () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& BlackListedStationsUpdate::getBlackListedStations () const {
    return _BlackListedStations;
}

inline ::std::vector< ::std::string >& BlackListedStationsUpdate::getBlackListedStationsMutable () {
    set_has_BlackListedStations();
    return _BlackListedStations;
}

inline void BlackListedStationsUpdate::setBlackListedStations (const ::std::vector< ::std::string >& BlackListedStations_) {
    set_has_BlackListedStations();
    this->_BlackListedStations = BlackListedStations_;
}

inline void BlackListedStationsUpdate::set_has_BlackListedStations () {
    _has_bits_[0] |= 1u << 0;
}

inline void BlackListedStationsUpdate::clear_has_BlackListedStations () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BlackListedStationsRegister::BlackListedStationsRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BlackListedStationsRegister::BlackListedStationsRegister (const BlackListedStationsRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BlackListedStationsRegister::~BlackListedStationsRegister() {
}

inline BlackListedStationsRegister& BlackListedStationsRegister::operator = (const BlackListedStationsRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool BlackListedStationsRegister::operator == (const BlackListedStationsRegister& ) const {
    return true;
}

inline bool BlackListedStationsRegister::operator != (const BlackListedStationsRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool BlackListedStationsRegister::operator < (const BlackListedStationsRegister& ) const {
    return false;
}

inline ::asf::core::Payload* BlackListedStationsRegister::clone() {
    return new BlackListedStationsRegister(*this);
}

inline bool BlackListedStationsRegister::operator > (const BlackListedStationsRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BlackListedStationsRegister::clear() {
}

inline  PoweredUpdate::PoweredUpdate ()  :
    _Powered (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PoweredUpdate::PoweredUpdate (const PoweredUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Powered (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PoweredUpdate::PoweredUpdate (bool Powered_)  :
    _Powered (Powered_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PoweredUpdate::~PoweredUpdate() {
}

inline PoweredUpdate& PoweredUpdate::operator = (const PoweredUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPowered()) {
            setPowered(rhs.getPowered());
        } else {
            clearPowered();
        }
    }
    return *this;
}

inline bool PoweredUpdate::operator == (const PoweredUpdate& rhs) const {
    return (((!hasPowered() && !rhs.hasPowered()) || getPowered() == rhs.getPowered()));
}

inline bool PoweredUpdate::operator != (const PoweredUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PoweredUpdate::operator < (const PoweredUpdate& rhs) const {
    if (hasPowered() || rhs.hasPowered()) {
        if (getPowered() < rhs.getPowered()) return true;
        if (getPowered() > rhs.getPowered()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PoweredUpdate::clone() {
    return new PoweredUpdate(*this);
}

inline bool PoweredUpdate::operator > (const PoweredUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PoweredUpdate::clear() {
    clearPowered();
}

inline void PoweredUpdate::clearPowered() {
    if (hasPowered()) {
         clear_has_Powered();
        _Powered = false;
     }
}

inline bool PoweredUpdate::hasPowered () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool PoweredUpdate::getPowered () const {
    return _Powered;
}

inline void PoweredUpdate::setPowered (bool Powered_) {
    set_has_Powered();
    this->_Powered = Powered_;
}

inline void PoweredUpdate::set_has_Powered () {
    _has_bits_[0] |= 1u << 0;
}

inline void PoweredUpdate::clear_has_Powered () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PoweredRegister::PoweredRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PoweredRegister::PoweredRegister (const PoweredRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PoweredRegister::~PoweredRegister() {
}

inline PoweredRegister& PoweredRegister::operator = (const PoweredRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PoweredRegister::operator == (const PoweredRegister& ) const {
    return true;
}

inline bool PoweredRegister::operator != (const PoweredRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PoweredRegister::operator < (const PoweredRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PoweredRegister::clone() {
    return new PoweredRegister(*this);
}

inline bool PoweredRegister::operator > (const PoweredRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PoweredRegister::clear() {
}

inline  HiddenUpdate::HiddenUpdate ()  :
    _Hidden (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HiddenUpdate::HiddenUpdate (const HiddenUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Hidden (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HiddenUpdate::HiddenUpdate (bool Hidden_)  :
    _Hidden (Hidden_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HiddenUpdate::~HiddenUpdate() {
}

inline HiddenUpdate& HiddenUpdate::operator = (const HiddenUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasHidden()) {
            setHidden(rhs.getHidden());
        } else {
            clearHidden();
        }
    }
    return *this;
}

inline bool HiddenUpdate::operator == (const HiddenUpdate& rhs) const {
    return (((!hasHidden() && !rhs.hasHidden()) || getHidden() == rhs.getHidden()));
}

inline bool HiddenUpdate::operator != (const HiddenUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool HiddenUpdate::operator < (const HiddenUpdate& rhs) const {
    if (hasHidden() || rhs.hasHidden()) {
        if (getHidden() < rhs.getHidden()) return true;
        if (getHidden() > rhs.getHidden()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HiddenUpdate::clone() {
    return new HiddenUpdate(*this);
}

inline bool HiddenUpdate::operator > (const HiddenUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HiddenUpdate::clear() {
    clearHidden();
}

inline void HiddenUpdate::clearHidden() {
    if (hasHidden()) {
         clear_has_Hidden();
        _Hidden = false;
     }
}

inline bool HiddenUpdate::hasHidden () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool HiddenUpdate::getHidden () const {
    return _Hidden;
}

inline void HiddenUpdate::setHidden (bool Hidden_) {
    set_has_Hidden();
    this->_Hidden = Hidden_;
}

inline void HiddenUpdate::set_has_Hidden () {
    _has_bits_[0] |= 1u << 0;
}

inline void HiddenUpdate::clear_has_Hidden () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  HiddenRegister::HiddenRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HiddenRegister::HiddenRegister (const HiddenRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HiddenRegister::~HiddenRegister() {
}

inline HiddenRegister& HiddenRegister::operator = (const HiddenRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool HiddenRegister::operator == (const HiddenRegister& ) const {
    return true;
}

inline bool HiddenRegister::operator != (const HiddenRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool HiddenRegister::operator < (const HiddenRegister& ) const {
    return false;
}

inline ::asf::core::Payload* HiddenRegister::clone() {
    return new HiddenRegister(*this);
}

inline bool HiddenRegister::operator > (const HiddenRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HiddenRegister::clear() {
}

inline  SecurityUpdate::SecurityUpdate ()  :
    _Security ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SecurityUpdate::SecurityUpdate (const SecurityUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Security ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SecurityUpdate::SecurityUpdate (const ::std::string& Security_)  :
    _Security (Security_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Security_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SecurityUpdate::~SecurityUpdate() {
}

inline SecurityUpdate& SecurityUpdate::operator = (const SecurityUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSecurity()) {
            setSecurity(rhs.getSecurity());
        } else {
            clearSecurity();
        }
    }
    return *this;
}

inline bool SecurityUpdate::operator == (const SecurityUpdate& rhs) const {
    return (((!hasSecurity() && !rhs.hasSecurity()) || getSecurity() == rhs.getSecurity()));
}

inline bool SecurityUpdate::operator != (const SecurityUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SecurityUpdate::operator < (const SecurityUpdate& rhs) const {
    if (hasSecurity() || rhs.hasSecurity()) {
        if (getSecurity() < rhs.getSecurity()) return true;
        if (getSecurity() > rhs.getSecurity()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SecurityUpdate::clone() {
    return new SecurityUpdate(*this);
}

inline bool SecurityUpdate::operator > (const SecurityUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SecurityUpdate::clear() {
    clearSecurity();
}

inline void SecurityUpdate::clearSecurity() {
    if (hasSecurity()) {
         clear_has_Security();
        _Security.clear();
     }
}

inline bool SecurityUpdate::hasSecurity () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SecurityUpdate::getSecurity () const {
    return _Security;
}

inline ::std::string& SecurityUpdate::getSecurityMutable () {
    set_has_Security();
    return _Security;
}

inline void SecurityUpdate::setSecurity (const ::std::string& Security_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Security_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Security();
    this->_Security = Security_;
}

inline void SecurityUpdate::setSecurity (const char* Security_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Security_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Security();
    this->_Security.assign(Security_);
}

inline void SecurityUpdate::setSecurity (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Security();
    this->_Security.assign(value, size);
}

inline void SecurityUpdate::set_has_Security () {
    _has_bits_[0] |= 1u << 0;
}

inline void SecurityUpdate::clear_has_Security () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SecurityRegister::SecurityRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SecurityRegister::SecurityRegister (const SecurityRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SecurityRegister::~SecurityRegister() {
}

inline SecurityRegister& SecurityRegister::operator = (const SecurityRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SecurityRegister::operator == (const SecurityRegister& ) const {
    return true;
}

inline bool SecurityRegister::operator != (const SecurityRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SecurityRegister::operator < (const SecurityRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SecurityRegister::clone() {
    return new SecurityRegister(*this);
}

inline bool SecurityRegister::operator > (const SecurityRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SecurityRegister::clear() {
}

inline  PassphraseUpdate::PassphraseUpdate ()  :
    _Passphrase ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PassphraseUpdate::PassphraseUpdate (const PassphraseUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Passphrase ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PassphraseUpdate::PassphraseUpdate (const ::std::string& Passphrase_)  :
    _Passphrase (Passphrase_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Passphrase_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PassphraseUpdate::~PassphraseUpdate() {
}

inline PassphraseUpdate& PassphraseUpdate::operator = (const PassphraseUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPassphrase()) {
            setPassphrase(rhs.getPassphrase());
        } else {
            clearPassphrase();
        }
    }
    return *this;
}

inline bool PassphraseUpdate::operator == (const PassphraseUpdate& rhs) const {
    return (((!hasPassphrase() && !rhs.hasPassphrase()) || getPassphrase() == rhs.getPassphrase()));
}

inline bool PassphraseUpdate::operator != (const PassphraseUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PassphraseUpdate::operator < (const PassphraseUpdate& rhs) const {
    if (hasPassphrase() || rhs.hasPassphrase()) {
        if (getPassphrase() < rhs.getPassphrase()) return true;
        if (getPassphrase() > rhs.getPassphrase()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PassphraseUpdate::clone() {
    return new PassphraseUpdate(*this);
}

inline bool PassphraseUpdate::operator > (const PassphraseUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PassphraseUpdate::clear() {
    clearPassphrase();
}

inline void PassphraseUpdate::clearPassphrase() {
    if (hasPassphrase()) {
         clear_has_Passphrase();
        _Passphrase.clear();
     }
}

inline bool PassphraseUpdate::hasPassphrase () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PassphraseUpdate::getPassphrase () const {
    return _Passphrase;
}

inline ::std::string& PassphraseUpdate::getPassphraseMutable () {
    set_has_Passphrase();
    return _Passphrase;
}

inline void PassphraseUpdate::setPassphrase (const ::std::string& Passphrase_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Passphrase_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Passphrase();
    this->_Passphrase = Passphrase_;
}

inline void PassphraseUpdate::setPassphrase (const char* Passphrase_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Passphrase_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Passphrase();
    this->_Passphrase.assign(Passphrase_);
}

inline void PassphraseUpdate::setPassphrase (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Passphrase();
    this->_Passphrase.assign(value, size);
}

inline void PassphraseUpdate::set_has_Passphrase () {
    _has_bits_[0] |= 1u << 0;
}

inline void PassphraseUpdate::clear_has_Passphrase () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PassphraseRegister::PassphraseRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PassphraseRegister::PassphraseRegister (const PassphraseRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PassphraseRegister::~PassphraseRegister() {
}

inline PassphraseRegister& PassphraseRegister::operator = (const PassphraseRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PassphraseRegister::operator == (const PassphraseRegister& ) const {
    return true;
}

inline bool PassphraseRegister::operator != (const PassphraseRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PassphraseRegister::operator < (const PassphraseRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PassphraseRegister::clone() {
    return new PassphraseRegister(*this);
}

inline bool PassphraseRegister::operator > (const PassphraseRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PassphraseRegister::clear() {
}

inline  MaximumStationsAllowedUpdate::MaximumStationsAllowedUpdate ()  :
    _MaximumStationsAllowed (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MaximumStationsAllowedUpdate::MaximumStationsAllowedUpdate (const MaximumStationsAllowedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _MaximumStationsAllowed (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MaximumStationsAllowedUpdate::MaximumStationsAllowedUpdate (uint16 MaximumStationsAllowed_)  :
    _MaximumStationsAllowed (MaximumStationsAllowed_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MaximumStationsAllowedUpdate::~MaximumStationsAllowedUpdate() {
}

inline MaximumStationsAllowedUpdate& MaximumStationsAllowedUpdate::operator = (const MaximumStationsAllowedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMaximumStationsAllowed()) {
            setMaximumStationsAllowed(rhs.getMaximumStationsAllowed());
        } else {
            clearMaximumStationsAllowed();
        }
    }
    return *this;
}

inline bool MaximumStationsAllowedUpdate::operator == (const MaximumStationsAllowedUpdate& rhs) const {
    return (((!hasMaximumStationsAllowed() && !rhs.hasMaximumStationsAllowed()) || getMaximumStationsAllowed() == rhs.getMaximumStationsAllowed()));
}

inline bool MaximumStationsAllowedUpdate::operator != (const MaximumStationsAllowedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool MaximumStationsAllowedUpdate::operator < (const MaximumStationsAllowedUpdate& rhs) const {
    if (hasMaximumStationsAllowed() || rhs.hasMaximumStationsAllowed()) {
        if (getMaximumStationsAllowed() < rhs.getMaximumStationsAllowed()) return true;
        if (getMaximumStationsAllowed() > rhs.getMaximumStationsAllowed()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MaximumStationsAllowedUpdate::clone() {
    return new MaximumStationsAllowedUpdate(*this);
}

inline bool MaximumStationsAllowedUpdate::operator > (const MaximumStationsAllowedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MaximumStationsAllowedUpdate::clear() {
    clearMaximumStationsAllowed();
}

inline void MaximumStationsAllowedUpdate::clearMaximumStationsAllowed() {
    if (hasMaximumStationsAllowed()) {
         clear_has_MaximumStationsAllowed();
        _MaximumStationsAllowed = 0u;
     }
}

inline bool MaximumStationsAllowedUpdate::hasMaximumStationsAllowed () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 MaximumStationsAllowedUpdate::getMaximumStationsAllowed () const {
    return _MaximumStationsAllowed;
}

inline void MaximumStationsAllowedUpdate::setMaximumStationsAllowed (uint16 MaximumStationsAllowed_) {
    set_has_MaximumStationsAllowed();
    this->_MaximumStationsAllowed = MaximumStationsAllowed_;
}

inline void MaximumStationsAllowedUpdate::set_has_MaximumStationsAllowed () {
    _has_bits_[0] |= 1u << 0;
}

inline void MaximumStationsAllowedUpdate::clear_has_MaximumStationsAllowed () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MaximumStationsAllowedRegister::MaximumStationsAllowedRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MaximumStationsAllowedRegister::MaximumStationsAllowedRegister (const MaximumStationsAllowedRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MaximumStationsAllowedRegister::~MaximumStationsAllowedRegister() {
}

inline MaximumStationsAllowedRegister& MaximumStationsAllowedRegister::operator = (const MaximumStationsAllowedRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool MaximumStationsAllowedRegister::operator == (const MaximumStationsAllowedRegister& ) const {
    return true;
}

inline bool MaximumStationsAllowedRegister::operator != (const MaximumStationsAllowedRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool MaximumStationsAllowedRegister::operator < (const MaximumStationsAllowedRegister& ) const {
    return false;
}

inline ::asf::core::Payload* MaximumStationsAllowedRegister::clone() {
    return new MaximumStationsAllowedRegister(*this);
}

inline bool MaximumStationsAllowedRegister::operator > (const MaximumStationsAllowedRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MaximumStationsAllowedRegister::clear() {
}

inline  PowerStateUpdate::PowerStateUpdate ()  :
    _PowerState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PowerStateUpdate::PowerStateUpdate (const PowerStateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _PowerState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PowerStateUpdate::PowerStateUpdate (const ::std::string& PowerState_)  :
    _PowerState (PowerState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PowerState_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PowerStateUpdate::~PowerStateUpdate() {
}

inline PowerStateUpdate& PowerStateUpdate::operator = (const PowerStateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPowerState()) {
            setPowerState(rhs.getPowerState());
        } else {
            clearPowerState();
        }
    }
    return *this;
}

inline bool PowerStateUpdate::operator == (const PowerStateUpdate& rhs) const {
    return (((!hasPowerState() && !rhs.hasPowerState()) || getPowerState() == rhs.getPowerState()));
}

inline bool PowerStateUpdate::operator != (const PowerStateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PowerStateUpdate::operator < (const PowerStateUpdate& rhs) const {
    if (hasPowerState() || rhs.hasPowerState()) {
        if (getPowerState() < rhs.getPowerState()) return true;
        if (getPowerState() > rhs.getPowerState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PowerStateUpdate::clone() {
    return new PowerStateUpdate(*this);
}

inline bool PowerStateUpdate::operator > (const PowerStateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PowerStateUpdate::clear() {
    clearPowerState();
}

inline void PowerStateUpdate::clearPowerState() {
    if (hasPowerState()) {
         clear_has_PowerState();
        _PowerState.clear();
     }
}

inline bool PowerStateUpdate::hasPowerState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PowerStateUpdate::getPowerState () const {
    return _PowerState;
}

inline ::std::string& PowerStateUpdate::getPowerStateMutable () {
    set_has_PowerState();
    return _PowerState;
}

inline void PowerStateUpdate::setPowerState (const ::std::string& PowerState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PowerState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PowerState();
    this->_PowerState = PowerState_;
}

inline void PowerStateUpdate::setPowerState (const char* PowerState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PowerState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PowerState();
    this->_PowerState.assign(PowerState_);
}

inline void PowerStateUpdate::setPowerState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PowerState();
    this->_PowerState.assign(value, size);
}

inline void PowerStateUpdate::set_has_PowerState () {
    _has_bits_[0] |= 1u << 0;
}

inline void PowerStateUpdate::clear_has_PowerState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PowerStateRegister::PowerStateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PowerStateRegister::PowerStateRegister (const PowerStateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PowerStateRegister::~PowerStateRegister() {
}

inline PowerStateRegister& PowerStateRegister::operator = (const PowerStateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PowerStateRegister::operator == (const PowerStateRegister& ) const {
    return true;
}

inline bool PowerStateRegister::operator != (const PowerStateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PowerStateRegister::operator < (const PowerStateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PowerStateRegister::clone() {
    return new PowerStateRegister(*this);
}

inline bool PowerStateRegister::operator > (const PowerStateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PowerStateRegister::clear() {
}

inline  PowerFailureReasonUpdate::PowerFailureReasonUpdate ()  :
    _PowerFailureReason ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PowerFailureReasonUpdate::PowerFailureReasonUpdate (const PowerFailureReasonUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _PowerFailureReason ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PowerFailureReasonUpdate::PowerFailureReasonUpdate (const ::std::string& PowerFailureReason_)  :
    _PowerFailureReason (PowerFailureReason_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PowerFailureReason_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PowerFailureReasonUpdate::~PowerFailureReasonUpdate() {
}

inline PowerFailureReasonUpdate& PowerFailureReasonUpdate::operator = (const PowerFailureReasonUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPowerFailureReason()) {
            setPowerFailureReason(rhs.getPowerFailureReason());
        } else {
            clearPowerFailureReason();
        }
    }
    return *this;
}

inline bool PowerFailureReasonUpdate::operator == (const PowerFailureReasonUpdate& rhs) const {
    return (((!hasPowerFailureReason() && !rhs.hasPowerFailureReason()) || getPowerFailureReason() == rhs.getPowerFailureReason()));
}

inline bool PowerFailureReasonUpdate::operator != (const PowerFailureReasonUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PowerFailureReasonUpdate::operator < (const PowerFailureReasonUpdate& rhs) const {
    if (hasPowerFailureReason() || rhs.hasPowerFailureReason()) {
        if (getPowerFailureReason() < rhs.getPowerFailureReason()) return true;
        if (getPowerFailureReason() > rhs.getPowerFailureReason()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PowerFailureReasonUpdate::clone() {
    return new PowerFailureReasonUpdate(*this);
}

inline bool PowerFailureReasonUpdate::operator > (const PowerFailureReasonUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PowerFailureReasonUpdate::clear() {
    clearPowerFailureReason();
}

inline void PowerFailureReasonUpdate::clearPowerFailureReason() {
    if (hasPowerFailureReason()) {
         clear_has_PowerFailureReason();
        _PowerFailureReason.clear();
     }
}

inline bool PowerFailureReasonUpdate::hasPowerFailureReason () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PowerFailureReasonUpdate::getPowerFailureReason () const {
    return _PowerFailureReason;
}

inline ::std::string& PowerFailureReasonUpdate::getPowerFailureReasonMutable () {
    set_has_PowerFailureReason();
    return _PowerFailureReason;
}

inline void PowerFailureReasonUpdate::setPowerFailureReason (const ::std::string& PowerFailureReason_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PowerFailureReason_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PowerFailureReason();
    this->_PowerFailureReason = PowerFailureReason_;
}

inline void PowerFailureReasonUpdate::setPowerFailureReason (const char* PowerFailureReason_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PowerFailureReason_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PowerFailureReason();
    this->_PowerFailureReason.assign(PowerFailureReason_);
}

inline void PowerFailureReasonUpdate::setPowerFailureReason (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PowerFailureReason();
    this->_PowerFailureReason.assign(value, size);
}

inline void PowerFailureReasonUpdate::set_has_PowerFailureReason () {
    _has_bits_[0] |= 1u << 0;
}

inline void PowerFailureReasonUpdate::clear_has_PowerFailureReason () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PowerFailureReasonRegister::PowerFailureReasonRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PowerFailureReasonRegister::PowerFailureReasonRegister (const PowerFailureReasonRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PowerFailureReasonRegister::~PowerFailureReasonRegister() {
}

inline PowerFailureReasonRegister& PowerFailureReasonRegister::operator = (const PowerFailureReasonRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PowerFailureReasonRegister::operator == (const PowerFailureReasonRegister& ) const {
    return true;
}

inline bool PowerFailureReasonRegister::operator != (const PowerFailureReasonRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PowerFailureReasonRegister::operator < (const PowerFailureReasonRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PowerFailureReasonRegister::clone() {
    return new PowerFailureReasonRegister(*this);
}

inline bool PowerFailureReasonRegister::operator > (const PowerFailureReasonRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PowerFailureReasonRegister::clear() {
}

inline  CurrentOperatingChannelUpdate::CurrentOperatingChannelUpdate ()  :
    _CurrentOperatingChannel (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CurrentOperatingChannelUpdate::CurrentOperatingChannelUpdate (const CurrentOperatingChannelUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _CurrentOperatingChannel (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CurrentOperatingChannelUpdate::CurrentOperatingChannelUpdate (uint16 CurrentOperatingChannel_)  :
    _CurrentOperatingChannel (CurrentOperatingChannel_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CurrentOperatingChannelUpdate::~CurrentOperatingChannelUpdate() {
}

inline CurrentOperatingChannelUpdate& CurrentOperatingChannelUpdate::operator = (const CurrentOperatingChannelUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCurrentOperatingChannel()) {
            setCurrentOperatingChannel(rhs.getCurrentOperatingChannel());
        } else {
            clearCurrentOperatingChannel();
        }
    }
    return *this;
}

inline bool CurrentOperatingChannelUpdate::operator == (const CurrentOperatingChannelUpdate& rhs) const {
    return (((!hasCurrentOperatingChannel() && !rhs.hasCurrentOperatingChannel()) || getCurrentOperatingChannel() == rhs.getCurrentOperatingChannel()));
}

inline bool CurrentOperatingChannelUpdate::operator != (const CurrentOperatingChannelUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CurrentOperatingChannelUpdate::operator < (const CurrentOperatingChannelUpdate& rhs) const {
    if (hasCurrentOperatingChannel() || rhs.hasCurrentOperatingChannel()) {
        if (getCurrentOperatingChannel() < rhs.getCurrentOperatingChannel()) return true;
        if (getCurrentOperatingChannel() > rhs.getCurrentOperatingChannel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CurrentOperatingChannelUpdate::clone() {
    return new CurrentOperatingChannelUpdate(*this);
}

inline bool CurrentOperatingChannelUpdate::operator > (const CurrentOperatingChannelUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CurrentOperatingChannelUpdate::clear() {
    clearCurrentOperatingChannel();
}

inline void CurrentOperatingChannelUpdate::clearCurrentOperatingChannel() {
    if (hasCurrentOperatingChannel()) {
         clear_has_CurrentOperatingChannel();
        _CurrentOperatingChannel = 0u;
     }
}

inline bool CurrentOperatingChannelUpdate::hasCurrentOperatingChannel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 CurrentOperatingChannelUpdate::getCurrentOperatingChannel () const {
    return _CurrentOperatingChannel;
}

inline void CurrentOperatingChannelUpdate::setCurrentOperatingChannel (uint16 CurrentOperatingChannel_) {
    set_has_CurrentOperatingChannel();
    this->_CurrentOperatingChannel = CurrentOperatingChannel_;
}

inline void CurrentOperatingChannelUpdate::set_has_CurrentOperatingChannel () {
    _has_bits_[0] |= 1u << 0;
}

inline void CurrentOperatingChannelUpdate::clear_has_CurrentOperatingChannel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CurrentOperatingChannelRegister::CurrentOperatingChannelRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CurrentOperatingChannelRegister::CurrentOperatingChannelRegister (const CurrentOperatingChannelRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CurrentOperatingChannelRegister::~CurrentOperatingChannelRegister() {
}

inline CurrentOperatingChannelRegister& CurrentOperatingChannelRegister::operator = (const CurrentOperatingChannelRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CurrentOperatingChannelRegister::operator == (const CurrentOperatingChannelRegister& ) const {
    return true;
}

inline bool CurrentOperatingChannelRegister::operator != (const CurrentOperatingChannelRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CurrentOperatingChannelRegister::operator < (const CurrentOperatingChannelRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CurrentOperatingChannelRegister::clone() {
    return new CurrentOperatingChannelRegister(*this);
}

inline bool CurrentOperatingChannelRegister::operator > (const CurrentOperatingChannelRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CurrentOperatingChannelRegister::clear() {
}

inline  CurrentHwModeUpdate::CurrentHwModeUpdate ()  :
    _CurrentHwMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CurrentHwModeUpdate::CurrentHwModeUpdate (const CurrentHwModeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _CurrentHwMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CurrentHwModeUpdate::CurrentHwModeUpdate (const ::std::string& CurrentHwMode_)  :
    _CurrentHwMode (CurrentHwMode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CurrentHwMode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CurrentHwModeUpdate::~CurrentHwModeUpdate() {
}

inline CurrentHwModeUpdate& CurrentHwModeUpdate::operator = (const CurrentHwModeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCurrentHwMode()) {
            setCurrentHwMode(rhs.getCurrentHwMode());
        } else {
            clearCurrentHwMode();
        }
    }
    return *this;
}

inline bool CurrentHwModeUpdate::operator == (const CurrentHwModeUpdate& rhs) const {
    return (((!hasCurrentHwMode() && !rhs.hasCurrentHwMode()) || getCurrentHwMode() == rhs.getCurrentHwMode()));
}

inline bool CurrentHwModeUpdate::operator != (const CurrentHwModeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CurrentHwModeUpdate::operator < (const CurrentHwModeUpdate& rhs) const {
    if (hasCurrentHwMode() || rhs.hasCurrentHwMode()) {
        if (getCurrentHwMode() < rhs.getCurrentHwMode()) return true;
        if (getCurrentHwMode() > rhs.getCurrentHwMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CurrentHwModeUpdate::clone() {
    return new CurrentHwModeUpdate(*this);
}

inline bool CurrentHwModeUpdate::operator > (const CurrentHwModeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CurrentHwModeUpdate::clear() {
    clearCurrentHwMode();
}

inline void CurrentHwModeUpdate::clearCurrentHwMode() {
    if (hasCurrentHwMode()) {
         clear_has_CurrentHwMode();
        _CurrentHwMode.clear();
     }
}

inline bool CurrentHwModeUpdate::hasCurrentHwMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CurrentHwModeUpdate::getCurrentHwMode () const {
    return _CurrentHwMode;
}

inline ::std::string& CurrentHwModeUpdate::getCurrentHwModeMutable () {
    set_has_CurrentHwMode();
    return _CurrentHwMode;
}

inline void CurrentHwModeUpdate::setCurrentHwMode (const ::std::string& CurrentHwMode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CurrentHwMode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CurrentHwMode();
    this->_CurrentHwMode = CurrentHwMode_;
}

inline void CurrentHwModeUpdate::setCurrentHwMode (const char* CurrentHwMode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CurrentHwMode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CurrentHwMode();
    this->_CurrentHwMode.assign(CurrentHwMode_);
}

inline void CurrentHwModeUpdate::setCurrentHwMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CurrentHwMode();
    this->_CurrentHwMode.assign(value, size);
}

inline void CurrentHwModeUpdate::set_has_CurrentHwMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void CurrentHwModeUpdate::clear_has_CurrentHwMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CurrentHwModeRegister::CurrentHwModeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CurrentHwModeRegister::CurrentHwModeRegister (const CurrentHwModeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CurrentHwModeRegister::~CurrentHwModeRegister() {
}

inline CurrentHwModeRegister& CurrentHwModeRegister::operator = (const CurrentHwModeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CurrentHwModeRegister::operator == (const CurrentHwModeRegister& ) const {
    return true;
}

inline bool CurrentHwModeRegister::operator != (const CurrentHwModeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CurrentHwModeRegister::operator < (const CurrentHwModeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CurrentHwModeRegister::clone() {
    return new CurrentHwModeRegister(*this);
}

inline bool CurrentHwModeRegister::operator > (const CurrentHwModeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CurrentHwModeRegister::clear() {
}

inline  SupportedChannelsUpdate::SupportedChannelsUpdate ()  :
    _SupportedChannels ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SupportedChannelsUpdate::SupportedChannelsUpdate (const SupportedChannelsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _SupportedChannels ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SupportedChannelsUpdate::SupportedChannelsUpdate (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& SupportedChannels_)  :
    _SupportedChannels (SupportedChannels_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SupportedChannelsUpdate::~SupportedChannelsUpdate() {
}

inline SupportedChannelsUpdate& SupportedChannelsUpdate::operator = (const SupportedChannelsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSupportedChannels()) {
            setSupportedChannels(rhs.getSupportedChannels());
        } else {
            clearSupportedChannels();
        }
    }
    return *this;
}

inline bool SupportedChannelsUpdate::operator == (const SupportedChannelsUpdate& rhs) const {
    return (((!hasSupportedChannels() && !rhs.hasSupportedChannels()) || getSupportedChannels() == rhs.getSupportedChannels()));
}

inline bool SupportedChannelsUpdate::operator != (const SupportedChannelsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SupportedChannelsUpdate::operator < (const SupportedChannelsUpdate& rhs) const {
    if (hasSupportedChannels() || rhs.hasSupportedChannels()) {
        if (getSupportedChannels() < rhs.getSupportedChannels()) return true;
        if (getSupportedChannels() > rhs.getSupportedChannels()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SupportedChannelsUpdate::clone() {
    return new SupportedChannelsUpdate(*this);
}

inline bool SupportedChannelsUpdate::operator > (const SupportedChannelsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SupportedChannelsUpdate::clear() {
    clearSupportedChannels();
}

inline void SupportedChannelsUpdate::clearSupportedChannels() {
    if (hasSupportedChannels()) {
         clear_has_SupportedChannels();
        _SupportedChannels.clear();
     }
}

inline bool SupportedChannelsUpdate::hasSupportedChannels () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& SupportedChannelsUpdate::getSupportedChannels () const {
    return _SupportedChannels;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& SupportedChannelsUpdate::getSupportedChannelsMutable () {
    set_has_SupportedChannels();
    return _SupportedChannels;
}

inline void SupportedChannelsUpdate::setSupportedChannels (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& SupportedChannels_) {
    set_has_SupportedChannels();
    this->_SupportedChannels = SupportedChannels_;
}

inline void SupportedChannelsUpdate::set_has_SupportedChannels () {
    _has_bits_[0] |= 1u << 0;
}

inline void SupportedChannelsUpdate::clear_has_SupportedChannels () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SupportedChannelsRegister::SupportedChannelsRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SupportedChannelsRegister::SupportedChannelsRegister (const SupportedChannelsRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SupportedChannelsRegister::~SupportedChannelsRegister() {
}

inline SupportedChannelsRegister& SupportedChannelsRegister::operator = (const SupportedChannelsRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SupportedChannelsRegister::operator == (const SupportedChannelsRegister& ) const {
    return true;
}

inline bool SupportedChannelsRegister::operator != (const SupportedChannelsRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SupportedChannelsRegister::operator < (const SupportedChannelsRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SupportedChannelsRegister::clone() {
    return new SupportedChannelsRegister(*this);
}

inline bool SupportedChannelsRegister::operator > (const SupportedChannelsRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SupportedChannelsRegister::clear() {
}

inline  HWFeaturesUpdate::HWFeaturesUpdate ()  :
    _HWFeatures ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HWFeaturesUpdate::HWFeaturesUpdate (const HWFeaturesUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _HWFeatures ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HWFeaturesUpdate::HWFeaturesUpdate (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& HWFeatures_)  :
    _HWFeatures (HWFeatures_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HWFeaturesUpdate::~HWFeaturesUpdate() {
}

inline HWFeaturesUpdate& HWFeaturesUpdate::operator = (const HWFeaturesUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasHWFeatures()) {
            setHWFeatures(rhs.getHWFeatures());
        } else {
            clearHWFeatures();
        }
    }
    return *this;
}

inline bool HWFeaturesUpdate::operator == (const HWFeaturesUpdate& rhs) const {
    return (((!hasHWFeatures() && !rhs.hasHWFeatures()) || getHWFeatures() == rhs.getHWFeatures()));
}

inline bool HWFeaturesUpdate::operator != (const HWFeaturesUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool HWFeaturesUpdate::operator < (const HWFeaturesUpdate& rhs) const {
    if (hasHWFeatures() || rhs.hasHWFeatures()) {
        if (getHWFeatures() < rhs.getHWFeatures()) return true;
        if (getHWFeatures() > rhs.getHWFeatures()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HWFeaturesUpdate::clone() {
    return new HWFeaturesUpdate(*this);
}

inline bool HWFeaturesUpdate::operator > (const HWFeaturesUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HWFeaturesUpdate::clear() {
    clearHWFeatures();
}

inline void HWFeaturesUpdate::clearHWFeatures() {
    if (hasHWFeatures()) {
         clear_has_HWFeatures();
        _HWFeatures.clear();
     }
}

inline bool HWFeaturesUpdate::hasHWFeatures () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& HWFeaturesUpdate::getHWFeatures () const {
    return _HWFeatures;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& HWFeaturesUpdate::getHWFeaturesMutable () {
    set_has_HWFeatures();
    return _HWFeatures;
}

inline void HWFeaturesUpdate::setHWFeatures (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& HWFeatures_) {
    set_has_HWFeatures();
    this->_HWFeatures = HWFeatures_;
}

inline void HWFeaturesUpdate::set_has_HWFeatures () {
    _has_bits_[0] |= 1u << 0;
}

inline void HWFeaturesUpdate::clear_has_HWFeatures () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  HWFeaturesRegister::HWFeaturesRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HWFeaturesRegister::HWFeaturesRegister (const HWFeaturesRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HWFeaturesRegister::~HWFeaturesRegister() {
}

inline HWFeaturesRegister& HWFeaturesRegister::operator = (const HWFeaturesRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool HWFeaturesRegister::operator == (const HWFeaturesRegister& ) const {
    return true;
}

inline bool HWFeaturesRegister::operator != (const HWFeaturesRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool HWFeaturesRegister::operator < (const HWFeaturesRegister& ) const {
    return false;
}

inline ::asf::core::Payload* HWFeaturesRegister::clone() {
    return new HWFeaturesRegister(*this);
}

inline bool HWFeaturesRegister::operator > (const HWFeaturesRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HWFeaturesRegister::clear() {
}

inline  VendorIEsElem1Struct::VendorIEsElem1Struct ()  :
    _elem1 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VendorIEsElem1Struct::VendorIEsElem1Struct (const VendorIEsElem1Struct &rhs)  :
    _elem1 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VendorIEsElem1Struct::VendorIEsElem1Struct (uint8 elem1_)  :
    _elem1 (elem1_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VendorIEsElem1Struct::~VendorIEsElem1Struct() {
}

inline VendorIEsElem1Struct& VendorIEsElem1Struct::operator = (const VendorIEsElem1Struct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
    }
    return *this;
}

inline bool VendorIEsElem1Struct::operator == (const VendorIEsElem1Struct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()));
}

inline bool VendorIEsElem1Struct::operator != (const VendorIEsElem1Struct& rhs) const {
    return ! (*this == rhs);
}

inline bool VendorIEsElem1Struct::operator < (const VendorIEsElem1Struct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    return false;
}

inline bool VendorIEsElem1Struct::operator > (const VendorIEsElem1Struct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VendorIEsElem1Struct::clear() {
    clearElem1();
}

inline void VendorIEsElem1Struct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool VendorIEsElem1Struct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 VendorIEsElem1Struct::getElem1 () const {
    return _elem1;
}

inline void VendorIEsElem1Struct::setElem1 (uint8 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void VendorIEsElem1Struct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void VendorIEsElem1Struct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VendorIEsStruct::VendorIEsStruct ()  :
    _elem1 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VendorIEsStruct::VendorIEsStruct (const VendorIEsStruct &rhs)  :
    _elem1 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VendorIEsStruct::VendorIEsStruct (const ::std::vector< VendorIEsElem1Struct >& elem1_)  :
    _elem1 (elem1_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VendorIEsStruct::~VendorIEsStruct() {
}

inline VendorIEsStruct& VendorIEsStruct::operator = (const VendorIEsStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
    }
    return *this;
}

inline bool VendorIEsStruct::operator == (const VendorIEsStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()));
}

inline bool VendorIEsStruct::operator != (const VendorIEsStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool VendorIEsStruct::operator < (const VendorIEsStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    return false;
}

inline bool VendorIEsStruct::operator > (const VendorIEsStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VendorIEsStruct::clear() {
    clearElem1();
}

inline void VendorIEsStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1.clear();
     }
}

inline bool VendorIEsStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< VendorIEsElem1Struct >& VendorIEsStruct::getElem1 () const {
    return _elem1;
}

inline ::std::vector< VendorIEsElem1Struct >& VendorIEsStruct::getElem1Mutable () {
    set_has_elem1();
    return _elem1;
}

inline void VendorIEsStruct::setElem1 (const ::std::vector< VendorIEsElem1Struct >& elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void VendorIEsStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void VendorIEsStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VendorIEsUpdate::VendorIEsUpdate ()  :
    _VendorIEs ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VendorIEsUpdate::VendorIEsUpdate (const VendorIEsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _VendorIEs ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VendorIEsUpdate::VendorIEsUpdate (const ::std::vector< VendorIEsStruct >& VendorIEs_)  :
    _VendorIEs (VendorIEs_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VendorIEsUpdate::~VendorIEsUpdate() {
}

inline VendorIEsUpdate& VendorIEsUpdate::operator = (const VendorIEsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVendorIEs()) {
            setVendorIEs(rhs.getVendorIEs());
        } else {
            clearVendorIEs();
        }
    }
    return *this;
}

inline bool VendorIEsUpdate::operator == (const VendorIEsUpdate& rhs) const {
    return (((!hasVendorIEs() && !rhs.hasVendorIEs()) || getVendorIEs() == rhs.getVendorIEs()));
}

inline bool VendorIEsUpdate::operator != (const VendorIEsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool VendorIEsUpdate::operator < (const VendorIEsUpdate& rhs) const {
    if (hasVendorIEs() || rhs.hasVendorIEs()) {
        if (getVendorIEs() < rhs.getVendorIEs()) return true;
        if (getVendorIEs() > rhs.getVendorIEs()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VendorIEsUpdate::clone() {
    return new VendorIEsUpdate(*this);
}

inline bool VendorIEsUpdate::operator > (const VendorIEsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VendorIEsUpdate::clear() {
    clearVendorIEs();
}

inline void VendorIEsUpdate::clearVendorIEs() {
    if (hasVendorIEs()) {
         clear_has_VendorIEs();
        _VendorIEs.clear();
     }
}

inline bool VendorIEsUpdate::hasVendorIEs () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< VendorIEsStruct >& VendorIEsUpdate::getVendorIEs () const {
    return _VendorIEs;
}

inline ::std::vector< VendorIEsStruct >& VendorIEsUpdate::getVendorIEsMutable () {
    set_has_VendorIEs();
    return _VendorIEs;
}

inline void VendorIEsUpdate::setVendorIEs (const ::std::vector< VendorIEsStruct >& VendorIEs_) {
    set_has_VendorIEs();
    this->_VendorIEs = VendorIEs_;
}

inline void VendorIEsUpdate::set_has_VendorIEs () {
    _has_bits_[0] |= 1u << 0;
}

inline void VendorIEsUpdate::clear_has_VendorIEs () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VendorIEsRegister::VendorIEsRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VendorIEsRegister::VendorIEsRegister (const VendorIEsRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VendorIEsRegister::~VendorIEsRegister() {
}

inline VendorIEsRegister& VendorIEsRegister::operator = (const VendorIEsRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool VendorIEsRegister::operator == (const VendorIEsRegister& ) const {
    return true;
}

inline bool VendorIEsRegister::operator != (const VendorIEsRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool VendorIEsRegister::operator < (const VendorIEsRegister& ) const {
    return false;
}

inline ::asf::core::Payload* VendorIEsRegister::clone() {
    return new VendorIEsRegister(*this);
}

inline bool VendorIEsRegister::operator > (const VendorIEsRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VendorIEsRegister::clear() {
}

inline  AssociatedStationsChangedSignalChangedstationsStruct::AssociatedStationsChangedSignalChangedstationsStruct ()  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AssociatedStationsChangedSignalChangedstationsStruct::AssociatedStationsChangedSignalChangedstationsStruct (const AssociatedStationsChangedSignalChangedstationsStruct &rhs)  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AssociatedStationsChangedSignalChangedstationsStruct::AssociatedStationsChangedSignalChangedstationsStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AssociatedStationsChangedSignalChangedstationsStruct::~AssociatedStationsChangedSignalChangedstationsStruct() {
}

inline AssociatedStationsChangedSignalChangedstationsStruct& AssociatedStationsChangedSignalChangedstationsStruct::operator = (const AssociatedStationsChangedSignalChangedstationsStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool AssociatedStationsChangedSignalChangedstationsStruct::operator == (const AssociatedStationsChangedSignalChangedstationsStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool AssociatedStationsChangedSignalChangedstationsStruct::operator != (const AssociatedStationsChangedSignalChangedstationsStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool AssociatedStationsChangedSignalChangedstationsStruct::operator < (const AssociatedStationsChangedSignalChangedstationsStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool AssociatedStationsChangedSignalChangedstationsStruct::operator > (const AssociatedStationsChangedSignalChangedstationsStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AssociatedStationsChangedSignalChangedstationsStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void AssociatedStationsChangedSignalChangedstationsStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1.clear();
     }
}

inline bool AssociatedStationsChangedSignalChangedstationsStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AssociatedStationsChangedSignalChangedstationsStruct::getElem1 () const {
    return _elem1;
}

inline ::std::string& AssociatedStationsChangedSignalChangedstationsStruct::getElem1Mutable () {
    set_has_elem1();
    return _elem1;
}

inline void AssociatedStationsChangedSignalChangedstationsStruct::setElem1 (const ::std::string& elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void AssociatedStationsChangedSignalChangedstationsStruct::setElem1 (const char* elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(elem1_);
}

inline void AssociatedStationsChangedSignalChangedstationsStruct::setElem1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(value, size);
}

inline void AssociatedStationsChangedSignalChangedstationsStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool AssociatedStationsChangedSignalChangedstationsStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& AssociatedStationsChangedSignalChangedstationsStruct::getElem2 () const {
    return _elem2;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& AssociatedStationsChangedSignalChangedstationsStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void AssociatedStationsChangedSignalChangedstationsStruct::setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void AssociatedStationsChangedSignalChangedstationsStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void AssociatedStationsChangedSignalChangedstationsStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AssociatedStationsChangedSignalChangedstationsStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void AssociatedStationsChangedSignalChangedstationsStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  AssociatedStationsChangedSignal::AssociatedStationsChangedSignal ()  :
    _changedstations (),
    _removedstations ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AssociatedStationsChangedSignal::AssociatedStationsChangedSignal (const AssociatedStationsChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _changedstations (),
    _removedstations ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AssociatedStationsChangedSignal::AssociatedStationsChangedSignal (const ::std::vector< AssociatedStationsChangedSignalChangedstationsStruct >& changedstations_, const ::std::vector< ::std::string >& removedstations_)  :
    _changedstations (changedstations_),
    _removedstations (removedstations_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AssociatedStationsChangedSignal::~AssociatedStationsChangedSignal() {
}

inline AssociatedStationsChangedSignal& AssociatedStationsChangedSignal::operator = (const AssociatedStationsChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasChangedstations()) {
            setChangedstations(rhs.getChangedstations());
        } else {
            clearChangedstations();
        }
        if (rhs.hasRemovedstations()) {
            setRemovedstations(rhs.getRemovedstations());
        } else {
            clearRemovedstations();
        }
    }
    return *this;
}

inline bool AssociatedStationsChangedSignal::operator == (const AssociatedStationsChangedSignal& rhs) const {
    return (((!hasChangedstations() && !rhs.hasChangedstations()) || getChangedstations() == rhs.getChangedstations()) &&
        ((!hasRemovedstations() && !rhs.hasRemovedstations()) || getRemovedstations() == rhs.getRemovedstations()));
}

inline bool AssociatedStationsChangedSignal::operator != (const AssociatedStationsChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool AssociatedStationsChangedSignal::operator < (const AssociatedStationsChangedSignal& rhs) const {
    if (hasChangedstations() || rhs.hasChangedstations()) {
        if (getChangedstations() < rhs.getChangedstations()) return true;
        if (getChangedstations() > rhs.getChangedstations()) return false;
    }
    if (hasRemovedstations() || rhs.hasRemovedstations()) {
        if (getRemovedstations() < rhs.getRemovedstations()) return true;
        if (getRemovedstations() > rhs.getRemovedstations()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AssociatedStationsChangedSignal::clone() {
    return new AssociatedStationsChangedSignal(*this);
}

inline bool AssociatedStationsChangedSignal::operator > (const AssociatedStationsChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AssociatedStationsChangedSignal::clear() {
    clearChangedstations();
    clearRemovedstations();
}

inline void AssociatedStationsChangedSignal::clearChangedstations() {
    if (hasChangedstations()) {
         clear_has_changedstations();
        _changedstations.clear();
     }
}

inline bool AssociatedStationsChangedSignal::hasChangedstations () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< AssociatedStationsChangedSignalChangedstationsStruct >& AssociatedStationsChangedSignal::getChangedstations () const {
    return _changedstations;
}

inline ::std::vector< AssociatedStationsChangedSignalChangedstationsStruct >& AssociatedStationsChangedSignal::getChangedstationsMutable () {
    set_has_changedstations();
    return _changedstations;
}

inline void AssociatedStationsChangedSignal::setChangedstations (const ::std::vector< AssociatedStationsChangedSignalChangedstationsStruct >& changedstations_) {
    set_has_changedstations();
    this->_changedstations = changedstations_;
}

inline void AssociatedStationsChangedSignal::clearRemovedstations() {
    if (hasRemovedstations()) {
         clear_has_removedstations();
        _removedstations.clear();
     }
}

inline bool AssociatedStationsChangedSignal::hasRemovedstations () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::std::string >& AssociatedStationsChangedSignal::getRemovedstations () const {
    return _removedstations;
}

inline ::std::vector< ::std::string >& AssociatedStationsChangedSignal::getRemovedstationsMutable () {
    set_has_removedstations();
    return _removedstations;
}

inline void AssociatedStationsChangedSignal::setRemovedstations (const ::std::vector< ::std::string >& removedstations_) {
    set_has_removedstations();
    this->_removedstations = removedstations_;
}

inline void AssociatedStationsChangedSignal::set_has_changedstations () {
    _has_bits_[0] |= 1u << 0;
}

inline void AssociatedStationsChangedSignal::clear_has_changedstations () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AssociatedStationsChangedSignal::set_has_removedstations () {
    _has_bits_[0] |= 1u << 1;
}

inline void AssociatedStationsChangedSignal::clear_has_removedstations () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  AssociationRequestRejectedSignal::AssociationRequestRejectedSignal ()  :
    _station ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AssociationRequestRejectedSignal::AssociationRequestRejectedSignal (const AssociationRequestRejectedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _station ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AssociationRequestRejectedSignal::AssociationRequestRejectedSignal (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station_)  :
    _station (station_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AssociationRequestRejectedSignal::~AssociationRequestRejectedSignal() {
}

inline AssociationRequestRejectedSignal& AssociationRequestRejectedSignal::operator = (const AssociationRequestRejectedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStation()) {
            setStation(rhs.getStation());
        } else {
            clearStation();
        }
    }
    return *this;
}

inline bool AssociationRequestRejectedSignal::operator == (const AssociationRequestRejectedSignal& rhs) const {
    return (((!hasStation() && !rhs.hasStation()) || getStation() == rhs.getStation()));
}

inline bool AssociationRequestRejectedSignal::operator != (const AssociationRequestRejectedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool AssociationRequestRejectedSignal::operator < (const AssociationRequestRejectedSignal& rhs) const {
    if (hasStation() || rhs.hasStation()) {
        if (getStation() < rhs.getStation()) return true;
        if (getStation() > rhs.getStation()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AssociationRequestRejectedSignal::clone() {
    return new AssociationRequestRejectedSignal(*this);
}

inline bool AssociationRequestRejectedSignal::operator > (const AssociationRequestRejectedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AssociationRequestRejectedSignal::clear() {
    clearStation();
}

inline void AssociationRequestRejectedSignal::clearStation() {
    if (hasStation()) {
         clear_has_station();
        _station.clear();
     }
}

inline bool AssociationRequestRejectedSignal::hasStation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& AssociationRequestRejectedSignal::getStation () const {
    return _station;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& AssociationRequestRejectedSignal::getStationMutable () {
    set_has_station();
    return _station;
}

inline void AssociationRequestRejectedSignal::setStation (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station_) {
    set_has_station();
    this->_station = station_;
}

inline void AssociationRequestRejectedSignal::set_has_station () {
    _has_bits_[0] |= 1u << 0;
}

inline void AssociationRequestRejectedSignal::clear_has_station () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WAPDMAN_ACCESSPOINT_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
