/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/genivi/NodeStateManager/LcmErrorTypesConst.h"
#include "org/genivi/NodeStateManager/LifecycleControl.h"
#include "org/genivi/NodeStateManager/LifecycleControlDBus.h"
#include "org/genivi/NodeStateManager/LifecycleControlJson.h"
#include "org/genivi/NodeStateManager/LifecycleControlStub.h"

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace LifecycleControl {

DEFINE_CLASS_LOGGER("/org/genivi/NodeStateManager/org/genivi/NodeStateManager/LifecycleControl", LifecycleControlStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 11, "SetBootMode", 3 },
    { 12, "SetNodeState", 2 },
    { 16, "CheckLucRequired", 5 },
    { 18, "RequestNodeRestart", 0 },
    { 18, "SetAppHealthStatus", 4 },
    { 18, "SetApplicationMode", 1 },
};


class LifecycleControlStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    LifecycleControlStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    LifecycleControlStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    LifecycleControlStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.genivi.NodeStateManager.LifecycleControl"),
          _logger(logger) {}

    virtual ~LifecycleControlStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void LifecycleControlStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 6, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'RequestNodeRestart'

            LOG_DEBUG_STUB("process method '%s'", "RequestNodeRestart");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestNodeRestartRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestNodeRestart", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestNodeRestartRequest > payload = ::boost::static_pointer_cast<RequestNodeRestartRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<LifecycleControlStub*>(getStub())->onRequestNodeRestartRequest(payload);
            return;
        }
        case 1: {

            // method 'SetApplicationMode'

            LOG_DEBUG_STUB("process method '%s'", "SetApplicationMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetApplicationModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetApplicationMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetApplicationModeRequest > payload = ::boost::static_pointer_cast<SetApplicationModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<LifecycleControlStub*>(getStub())->onSetApplicationModeRequest(payload);
            return;
        }
        case 2: {

            // method 'SetNodeState'

            LOG_DEBUG_STUB("process method '%s'", "SetNodeState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetNodeStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetNodeState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetNodeStateRequest > payload = ::boost::static_pointer_cast<SetNodeStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<LifecycleControlStub*>(getStub())->onSetNodeStateRequest(payload);
            return;
        }
        case 3: {

            // method 'SetBootMode'

            LOG_DEBUG_STUB("process method '%s'", "SetBootMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetBootModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetBootMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetBootModeRequest > payload = ::boost::static_pointer_cast<SetBootModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<LifecycleControlStub*>(getStub())->onSetBootModeRequest(payload);
            return;
        }
        case 4: {

            // method 'SetAppHealthStatus'

            LOG_DEBUG_STUB("process method '%s'", "SetAppHealthStatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetAppHealthStatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetAppHealthStatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetAppHealthStatusRequest > payload = ::boost::static_pointer_cast<SetAppHealthStatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<LifecycleControlStub*>(getStub())->onSetAppHealthStatusRequest(payload);
            return;
        }
        case 5: {

            // method 'CheckLucRequired'

            LOG_DEBUG_STUB("process method '%s'", "CheckLucRequired");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CheckLucRequiredRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CheckLucRequired", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CheckLucRequiredRequest > payload = ::boost::static_pointer_cast<CheckLucRequiredRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<LifecycleControlStub*>(getStub())->onCheckLucRequiredRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* LifecycleControlStubDelegate::introspect() const {
    return     "<interface name=\"org.genivi.NodeStateManager.LifecycleControl\">\n"
            "    <method name=\"RequestNodeRestart\">\n"
            "      <doc>\n"
            "        <line>RequestNodeRestart = RequestNodeRestart:</line>\n"
            "        <line>RestartReason: The passed value will be based upon the enum NsmRestartReason_e.</line>\n"
            "        <line>RestartType:   This is the type of restart that is required, i.e. during Coding process it is normal for a fast shutdown to be	requested</line>\n"
            "        <line>whereas other Diagnosis restart requests would be normal.</line>\n"
            "        <line>Possible values are NSM_SHUTDOWNTYPE_FAST and NSM_SHUTDOWNTYPE_NORMAL.</line>\n"
            "        <line>ErrorCode:     Return value passed to the caller, based upon NsmErrorStatus_e.</line>\n"
            "        <line></line>\n"
            "        <line>The method is used by other applications to request a restart of the node.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"RestartReason\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>RestartReason (of type _NsmRestartReason_e) = Description missing</line>\n"
            "          <line>enum[NsmRestartReason_NotSet (null), NsmRestartReason_ApplicationFailure (null), NsmRestartReason_Diagnosis (null), NsmRestartReason_Swl (null), NsmRestartReason_User (null), NsmRestartReason_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"RestartType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>RestartType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ErrorCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ErrorCode (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetApplicationMode\">\n"
            "      <doc>\n"
            "        <line>SetApplicationMode = SetApplicationMode:</line>\n"
            "        <line>ApplicationModeId: This parameter will be based upon the NsmNodeApplicationMode_e.</line>\n"
            "        <line>ErrorCode:         Return value passed to the caller, based upon NsmErrorStatus_e.</line>\n"
            "        <line></line>\n"
            "        <line>The method is used by other applications to set the application mode.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"ApplicationModeId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ApplicationModeId (of type _NsmApplicationMode_e) = Description missing</line>\n"
            "          <line>enum[NsmApplicationMode_NotSet (null), NsmApplicationMode_Parking (null), NsmApplicationMode_Factory (null), NsmApplicationMode_Transport (null), NsmApplicationMode_Normal (null), NsmApplicationMode_Swl (null), NsmApplicationMode_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ErrorCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ErrorCode (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetNodeState\">\n"
            "      <doc>\n"
            "        <line>SetNodeState = SetNodeState:</line>\n"
            "        <line>NodeStateId: The passed value will be based upon the enum NsmNodeState_e.</line>\n"
            "        <line>ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.</line>\n"
            "        <line></line>\n"
            "        <line>The method is used by other applications to set the NodeState.</line>\n"
            "        <line>When this method is called to change the current NodeState a signal will be sent to notify registered consumers of the new state.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"NodeStateId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>NodeStateId (of type _NsmNodeState_e) = Description missing</line>\n"
            "          <line>enum[NsmNodeState_NotSet (null), NsmNodeState_StartUp (null), NsmNodeState_BaseRunning (null), NsmNodeState_LucRunning (null), NsmNodeState_FullyRunning (null), NsmNodeState_FullyOperational (null), NsmNodeState_ShuttingDown (null), NsmNodeState_ShutdownDelay (null), NsmNodeState_FastShutdown (null), NsmNodeState_DegradedPower (null), NsmNodeState_Shutdown (null), NsmNodeState_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ErrorCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ErrorCode (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetBootMode\">\n"
            "      <doc>\n"
            "        <line>SetBootMode = SetBootMode:</line>\n"
            "        <line>BootMode:    New BootMode to be set. The values will be defined by a third party header, which has not been delivered yet.</line>\n"
            "        <line>The description needs to be updated as soon as the header is available.</line>\n"
            "        <line>ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.</line>\n"
            "        <line></line>\n"
            "        <line>The method has been introduced, because the property &quot;BootMode&quot; can only be read by other applications.</line>\n"
            "        <line>Nevertheless there are some exceptions where the property should be set by a restricted set of applications which will be handled within this method.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"BootMode\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>BootMode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ErrorCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ErrorCode (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetAppHealthStatus\">\n"
            "      <doc>\n"
            "        <line>SetAppHealthStatus = SetAppHealthStatus:</line>\n"
            "        <line>AppName:     This parameter can be used to give the name of the application that has failed (this must be the applications systemd unit name).</line>\n"
            "        <line>AppRunning:  The AppState will be FALSE for failed and TRUE for running.</line>\n"
            "        <line>ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.</line>\n"
            "        <line></line>\n"
            "        <line>This method will be used by the Node Health Monitor to report to the NSM if an application has failed and if it is running again.</line>\n"
            "        <line>Internally the NSM will use this information to keep a count of the number of failed applications within the current lifecycle.</line>\n"
            "        <line>Additionally it will unset any sessions that the failing application may have had active. It will also be possible for the product</line>\n"
            "        <line>node state machine to make a decision on what to do with this information,</line>\n"
            "        <line>i.e. even reset the node or reset the node if too many applications have failed.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"AppName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>AppName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"AppRunning\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>AppRunning = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ErrorCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ErrorCode (of type _NsmErrorStatus_e) = Description missing</line>\n"
            "          <line>enum[NsmErrorStatus_NotSet (null), NsmErrorStatus_Ok (null), NsmErrorStatus_Error (null), NsmErrorStatus_Dbus (null), NsmErrorStatus_Internal (null), NsmErrorStatus_Parameter (null), NsmErrorStatus_WrongSession (null), NsmErrorStatus_ResponsePending (null), NsmErrorStatus_Last (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"CheckLucRequired\">\n"
            "      <doc>\n"
            "        <line>CheckLucRequired = CheckLucRequired:</line>\n"
            "        <line>LucWanted:   This will be a simple TRUE or FALSE to define whether the LUC is wanted in the current Lifecycle.</line>\n"
            "        <line></line>\n"
            "        <line>This method will be called exclusivley by the Boot Manager to find out whether the LUC Applications should be started in the current Lifecycle.</line>\n"
            "        <line>This is required whilst in certain Node Application Modes (i.e. Transport, Factory) we do not want the LUC Applications started.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"LucWanted\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>LucWanted = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void LifecycleControlStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<LifecycleControlStub*>(getStub()))->onGetAll (properties);
}

void LifecycleControlStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void LifecycleControlStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

LifecycleControlStub::LifecycleControlStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new LifecycleControlStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

LifecycleControlStub::LifecycleControlStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new LifecycleControlStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

LifecycleControlStub::~LifecycleControlStub() {
    delete _stubDelegate;
}

void  LifecycleControlStub::sendRequestNodeRestartResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act) {
    RequestNodeRestartResponse* payload = new RequestNodeRestartResponse(errorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "RequestNodeRestart", RequestNodeRestartResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestNodeRestart", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifecycleControlStub::sendRequestNodeRestartError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestNodeRestartError* payload = new RequestNodeRestartError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RequestNodeRestart", RequestNodeRestartError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestNodeRestart", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifecycleControlStub::sendSetApplicationModeResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act) {
    SetApplicationModeResponse* payload = new SetApplicationModeResponse(errorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetApplicationMode", SetApplicationModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetApplicationMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifecycleControlStub::sendSetApplicationModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetApplicationModeError* payload = new SetApplicationModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetApplicationMode", SetApplicationModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetApplicationMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifecycleControlStub::sendSetNodeStateResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act) {
    SetNodeStateResponse* payload = new SetNodeStateResponse(errorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetNodeState", SetNodeStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetNodeState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifecycleControlStub::sendSetNodeStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetNodeStateError* payload = new SetNodeStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetNodeState", SetNodeStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetNodeState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifecycleControlStub::sendSetBootModeResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act) {
    SetBootModeResponse* payload = new SetBootModeResponse(errorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetBootMode", SetBootModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetBootMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifecycleControlStub::sendSetBootModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetBootModeError* payload = new SetBootModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetBootMode", SetBootModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetBootMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifecycleControlStub::sendSetAppHealthStatusResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act) {
    SetAppHealthStatusResponse* payload = new SetAppHealthStatusResponse(errorCode);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetAppHealthStatus", SetAppHealthStatusResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetAppHealthStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifecycleControlStub::sendSetAppHealthStatusError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetAppHealthStatusError* payload = new SetAppHealthStatusError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetAppHealthStatus", SetAppHealthStatusError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetAppHealthStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifecycleControlStub::sendCheckLucRequiredResponse (bool lucWanted, act_t act) {
    CheckLucRequiredResponse* payload = new CheckLucRequiredResponse(lucWanted);
    DBUS_MESSAGE_REPLY(dbusMessage, "CheckLucRequired", CheckLucRequiredResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CheckLucRequired", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifecycleControlStub::sendCheckLucRequiredError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CheckLucRequiredError* payload = new CheckLucRequiredError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CheckLucRequired", CheckLucRequiredError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CheckLucRequired", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void LifecycleControlStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace LifecycleControl
} // namespace NodeStateManager
} // namespace genivi
} // namespace org
