/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONTROLPROXY_H
#define ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONTROLPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/genivi/NodeStateManager/LcmBasicTypesConst.h"
#include "org/genivi/NodeStateManager/LifecycleControl.h"
#include <dbus/dbus.h>
#include <string>

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace LifecycleControl {

class LifecycleControlProxy;

class CheckLucRequiredCallbackIF {
public:
    virtual ~CheckLucRequiredCallbackIF() {}

    virtual void onCheckLucRequiredError(const ::boost::shared_ptr< LifecycleControlProxy >& proxy, const ::boost::shared_ptr< CheckLucRequiredError >& error) = 0;

    virtual void onCheckLucRequiredResponse(const ::boost::shared_ptr< LifecycleControlProxy >& proxy, const ::boost::shared_ptr< CheckLucRequiredResponse >& response) = 0;
};

class RequestNodeRestartCallbackIF {
public:
    virtual ~RequestNodeRestartCallbackIF() {}

    virtual void onRequestNodeRestartError(const ::boost::shared_ptr< LifecycleControlProxy >& proxy, const ::boost::shared_ptr< RequestNodeRestartError >& error) = 0;

    virtual void onRequestNodeRestartResponse(const ::boost::shared_ptr< LifecycleControlProxy >& proxy, const ::boost::shared_ptr< RequestNodeRestartResponse >& response) = 0;
};

class SetAppHealthStatusCallbackIF {
public:
    virtual ~SetAppHealthStatusCallbackIF() {}

    virtual void onSetAppHealthStatusError(const ::boost::shared_ptr< LifecycleControlProxy >& proxy, const ::boost::shared_ptr< SetAppHealthStatusError >& error) = 0;

    virtual void onSetAppHealthStatusResponse(const ::boost::shared_ptr< LifecycleControlProxy >& proxy, const ::boost::shared_ptr< SetAppHealthStatusResponse >& response) = 0;
};

class SetApplicationModeCallbackIF {
public:
    virtual ~SetApplicationModeCallbackIF() {}

    virtual void onSetApplicationModeError(const ::boost::shared_ptr< LifecycleControlProxy >& proxy, const ::boost::shared_ptr< SetApplicationModeError >& error) = 0;

    virtual void onSetApplicationModeResponse(const ::boost::shared_ptr< LifecycleControlProxy >& proxy, const ::boost::shared_ptr< SetApplicationModeResponse >& response) = 0;
};

class SetBootModeCallbackIF {
public:
    virtual ~SetBootModeCallbackIF() {}

    virtual void onSetBootModeError(const ::boost::shared_ptr< LifecycleControlProxy >& proxy, const ::boost::shared_ptr< SetBootModeError >& error) = 0;

    virtual void onSetBootModeResponse(const ::boost::shared_ptr< LifecycleControlProxy >& proxy, const ::boost::shared_ptr< SetBootModeResponse >& response) = 0;
};

class SetNodeStateCallbackIF {
public:
    virtual ~SetNodeStateCallbackIF() {}

    virtual void onSetNodeStateError(const ::boost::shared_ptr< LifecycleControlProxy >& proxy, const ::boost::shared_ptr< SetNodeStateError >& error) = 0;

    virtual void onSetNodeStateResponse(const ::boost::shared_ptr< LifecycleControlProxy >& proxy, const ::boost::shared_ptr< SetNodeStateResponse >& response) = 0;
};


/**
 * LifecycleControlProxy is the client side representation of the D-Bus
 * service interface 'org.genivi.NodeStateManager.LifecycleControl'
 * (specified in file org.genivi.NodeStateManager.LifecycleControl_.xml).
 *
 * org.genivi.NodeStateManager.LifecycleControl :
 *
 *                     short_description: "Control" interface of the NodeStateManager.
 *                                         This interface contains functions, which have direct influence on the system state and therefore have to be handled with care.
 *                                         The interface can only be used by certain clients, which need to be configured in the D-Bus configuration.
 */
class LifecycleControlProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of LifecycleControlProxy.
     */
    static ::boost::shared_ptr< LifecycleControlProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of LifecycleControlProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< LifecycleControlProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of LifecycleControlProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< LifecycleControlProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< LifecycleControlProxy > proxyNew(new LifecycleControlProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~LifecycleControlProxy ();




    // Method 'RequestNodeRestart'

    /**
     * Call the method 'RequestNodeRestart'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'RequestNodeRestart'</b>:
     *
     * RequestNodeRestart:
     *     	RestartReason: The passed value will be based upon the enum NsmRestartReason_e.
     *     	RestartType:   This is the type of restart that is required, i.e. during Coding process it is normal for a fast shutdown to be	requested
     *     				   whereas other Diagnosis restart requests would be normal.
     *     	               Possible values are NSM_SHUTDOWNTYPE_FAST and NSM_SHUTDOWNTYPE_NORMAL.
     *     	ErrorCode:     Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to request a restart of the node.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param RestartReason If the meaning of "RestartReason" isn't clear, then there should be a description here.
     *
     * @param RestartType If the meaning of "RestartType" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestNodeRestartRequest(RequestNodeRestartCallbackIF& cb, ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e restartReason, uint32 restartType) const;

    // Method 'SetApplicationMode'

    /**
     * Call the method 'SetApplicationMode'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'SetApplicationMode'</b>:
     *
     * SetApplicationMode:
     *     	ApplicationModeId: This parameter will be based upon the NsmNodeApplicationMode_e.
     *     	ErrorCode:         Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to set the application mode.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param ApplicationModeId If the meaning of "ApplicationModeId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetApplicationModeRequest(SetApplicationModeCallbackIF& cb, ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e applicationModeId) const;

    // Method 'SetNodeState'

    /**
     * Call the method 'SetNodeState'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetNodeState'</b>:
     *
     * SetNodeState:
     *     	NodeStateId: The passed value will be based upon the enum NsmNodeState_e.
     *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to set the NodeState.
     *     	When this method is called to change the current NodeState a signal will be sent to notify registered consumers of the new state.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param NodeStateId If the meaning of "NodeStateId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetNodeStateRequest(SetNodeStateCallbackIF& cb, ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e nodeStateId) const;

    // Method 'SetBootMode'

    /**
     * Call the method 'SetBootMode'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SetBootMode'</b>:
     *
     * SetBootMode:
     *     	BootMode:    New BootMode to be set. The values will be defined by a third party header, which has not been delivered yet.
     *     	             The description needs to be updated as soon as the header is available.
     *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	The method has been introduced, because the property "BootMode" can only be read by other applications.
     *     	Nevertheless there are some exceptions where the property should be set by a restricted set of applications which will be handled within this method.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param BootMode If the meaning of "BootMode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetBootModeRequest(SetBootModeCallbackIF& cb, int32 bootMode) const;

    // Method 'SetAppHealthStatus'

    /**
     * Call the method 'SetAppHealthStatus'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'SetAppHealthStatus'</b>:
     *
     * SetAppHealthStatus:
     *     	AppName:     This parameter can be used to give the name of the application that has failed (this must be the applications systemd unit name).
     *     	AppRunning:  The AppState will be FALSE for failed and TRUE for running.
     *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
     *
     *     	This method will be used by the Node Health Monitor to report to the NSM if an application has failed and if it is running again.
     *     	Internally the NSM will use this information to keep a count of the number of failed applications within the current lifecycle.
     *     	Additionally it will unset any sessions that the failing application may have had active. It will also be possible for the product
     *     	node state machine to make a decision on what to do with this information,
     *     	i.e. even reset the node or reset the node if too many applications have failed.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param AppName If the meaning of "AppName" isn't clear, then there should be a description here.
     *
     * @param AppRunning If the meaning of "AppRunning" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetAppHealthStatusRequest(SetAppHealthStatusCallbackIF& cb, const ::std::string& appName, bool appRunning) const;

    // Method 'CheckLucRequired'

    /**
     * Call the method 'CheckLucRequired'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'CheckLucRequired'</b>:
     *
     * CheckLucRequired:
     *     	LucWanted:   This will be a simple TRUE or FALSE to define whether the LUC is wanted in the current Lifecycle.
     *
     *     	This method will be called exclusivley by the Boot Manager to find out whether the LUC Applications should be started in the current Lifecycle.
     *     	This is required whilst in certain Node Application Modes (i.e. Transport, Factory) we do not want the LUC Applications started.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCheckLucRequiredRequest(CheckLucRequiredCallbackIF& cb) const;


private:

    LifecycleControlProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class LifecycleControlProxyCallback;
};

} // namespace LifecycleControl
} // namespace NodeStateManager
} // namespace genivi
} // namespace org

#endif // ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONTROLPROXY_H
