#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONTROL_H
#define ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONTROL_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "org/genivi/NodeStateManager/LcmBasicTypesConst.h"
#include "org/genivi/NodeStateManager/LcmErrorTypesConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * org.genivi.NodeStateManager.LifecycleControl :
 *
 *                     short_description: "Control" interface of the NodeStateManager.
 *                                         This interface contains functions, which have direct influence on the system state and therefore have to be handled with care.
 *                                         The interface can only be used by certain clients, which need to be configured in the D-Bus configuration.
 */

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace LifecycleControl {

// method IDs
static const uint16 ID_RequestNodeRestart = 0;
static const uint16 ID_SetApplicationMode = 1;
static const uint16 ID_SetNodeState = 2;
static const uint16 ID_SetBootMode = 3;
static const uint16 ID_SetAppHealthStatus = 4;
static const uint16 ID_CheckLucRequired = 5;

// signal IDs

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 2;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class RequestNodeRestartRequest;

class RequestNodeRestartResponse;

class SetApplicationModeRequest;

class SetApplicationModeResponse;

class SetNodeStateRequest;

class SetNodeStateResponse;

class SetBootModeRequest;

class SetBootModeResponse;

class SetAppHealthStatusRequest;

class SetAppHealthStatusResponse;

class CheckLucRequiredResponse;

// type definitions
/**
 * If the meaning of "RequestNodeRestartError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestNodeRestartError;

/**
 * If the meaning of "SetApplicationModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetApplicationModeError;

/**
 * If the meaning of "SetNodeStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetNodeStateError;

/**
 * If the meaning of "SetBootModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetBootModeError;

/**
 * If the meaning of "SetAppHealthStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetAppHealthStatusError;

/**
 * CheckLucRequired:
 *     	LucWanted:   This will be a simple TRUE or FALSE to define whether the LUC is wanted in the current Lifecycle.
 *
 *     	This method will be called exclusivley by the Boot Manager to find out whether the LUC Applications should be started in the current Lifecycle.
 *     	This is required whilst in certain Node Application Modes (i.e. Transport, Factory) we do not want the LUC Applications started.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CheckLucRequiredRequest;

/**
 * If the meaning of "CheckLucRequiredError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CheckLucRequiredError;


/**
 * RequestNodeRestart:
 *     	RestartReason: The passed value will be based upon the enum NsmRestartReason_e.
 *     	RestartType:   This is the type of restart that is required, i.e. during Coding process it is normal for a fast shutdown to be	requested
 *     				   whereas other Diagnosis restart requests would be normal.
 *     	               Possible values are NSM_SHUTDOWNTYPE_FAST and NSM_SHUTDOWNTYPE_NORMAL.
 *     	ErrorCode:     Return value passed to the caller, based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to request a restart of the node.
 */
class RequestNodeRestartRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestNodeRestartRequest ();

    /**
     * Copy constructor
     */
    inline  RequestNodeRestartRequest (const RequestNodeRestartRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestNodeRestartRequest (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e RestartReason_, uint32 RestartType_);

    /**
     * Destructor
     */
    inline virtual  ~RequestNodeRestartRequest();

    /**
     * Assignment operator
     */
    inline RequestNodeRestartRequest& operator = (const RequestNodeRestartRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestNodeRestartRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestNodeRestartRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestNodeRestartRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestNodeRestartRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RestartReason"

    static const int kRestartReason = 0;

    /**
     * Clears the field "RestartReason".
     *
     * The field will be set to its default value. The hasRestartReason()
     * method will return false.
     */
    inline void clearRestartReason();

    /**
     * Checks whether the field "RestartReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRestartReason()). Otherwise it will return false.
     */
    inline bool hasRestartReason () const;

    /**
     * Returns the value of the member "RestartReason".
     *
     * If the meaning of "RestartReason" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RestartReason"
     */
    inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e getRestartReason () const;

    /**
     * Sets the value of the member "RestartReason".
     *
     * If the meaning of "RestartReason" isn't clear, then there should be a description here.
     *
     * @param RestartReason The value which will be set
     */
    inline void setRestartReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e RestartReason_);

    // API of field "RestartType"

    static const int kRestartType = 1;

    /**
     * Clears the field "RestartType".
     *
     * The field will be set to its default value. The hasRestartType()
     * method will return false.
     */
    inline void clearRestartType();

    /**
     * Checks whether the field "RestartType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRestartType()). Otherwise it will return false.
     */
    inline bool hasRestartType () const;

    /**
     * Returns the value of the member "RestartType".
     *
     * If the meaning of "RestartType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RestartType"
     */
    inline uint32 getRestartType () const;

    /**
     * Sets the value of the member "RestartType".
     *
     * If the meaning of "RestartType" isn't clear, then there should be a description here.
     *
     * @param RestartType The value which will be set
     */
    inline void setRestartType (uint32 RestartType_);

    static const RequestNodeRestartRequest &getDefaultInstance();

private:

    inline void set_has_RestartReason ();

    inline void clear_has_RestartReason ();

    inline void set_has_RestartType ();

    inline void clear_has_RestartType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e _RestartReason;

    uint32 _RestartType;

};

/**
 * RequestNodeRestart:
 *     	RestartReason: The passed value will be based upon the enum NsmRestartReason_e.
 *     	RestartType:   This is the type of restart that is required, i.e. during Coding process it is normal for a fast shutdown to be	requested
 *     				   whereas other Diagnosis restart requests would be normal.
 *     	               Possible values are NSM_SHUTDOWNTYPE_FAST and NSM_SHUTDOWNTYPE_NORMAL.
 *     	ErrorCode:     Return value passed to the caller, based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to request a restart of the node.
 */
class RequestNodeRestartResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestNodeRestartResponse ();

    /**
     * Copy constructor
     */
    inline  RequestNodeRestartResponse (const RequestNodeRestartResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestNodeRestartResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~RequestNodeRestartResponse();

    /**
     * Assignment operator
     */
    inline RequestNodeRestartResponse& operator = (const RequestNodeRestartResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestNodeRestartResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestNodeRestartResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestNodeRestartResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestNodeRestartResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    static const RequestNodeRestartResponse &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _ErrorCode;

};

/**
 * SetApplicationMode:
 *     	ApplicationModeId: This parameter will be based upon the NsmNodeApplicationMode_e.
 *     	ErrorCode:         Return value passed to the caller, based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to set the application mode.
 */
class SetApplicationModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetApplicationModeRequest ();

    /**
     * Copy constructor
     */
    inline  SetApplicationModeRequest (const SetApplicationModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetApplicationModeRequest (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e ApplicationModeId_);

    /**
     * Destructor
     */
    inline virtual  ~SetApplicationModeRequest();

    /**
     * Assignment operator
     */
    inline SetApplicationModeRequest& operator = (const SetApplicationModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetApplicationModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetApplicationModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetApplicationModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetApplicationModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ApplicationModeId"

    static const int kApplicationModeId = 0;

    /**
     * Clears the field "ApplicationModeId".
     *
     * The field will be set to its default value. The hasApplicationModeId()
     * method will return false.
     */
    inline void clearApplicationModeId();

    /**
     * Checks whether the field "ApplicationModeId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setApplicationModeId()). Otherwise it will return false.
     */
    inline bool hasApplicationModeId () const;

    /**
     * Returns the value of the member "ApplicationModeId".
     *
     * If the meaning of "ApplicationModeId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ApplicationModeId"
     */
    inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e getApplicationModeId () const;

    /**
     * Sets the value of the member "ApplicationModeId".
     *
     * If the meaning of "ApplicationModeId" isn't clear, then there should be a description here.
     *
     * @param ApplicationModeId The value which will be set
     */
    inline void setApplicationModeId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e ApplicationModeId_);

    static const SetApplicationModeRequest &getDefaultInstance();

private:

    inline void set_has_ApplicationModeId ();

    inline void clear_has_ApplicationModeId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e _ApplicationModeId;

};

/**
 * SetApplicationMode:
 *     	ApplicationModeId: This parameter will be based upon the NsmNodeApplicationMode_e.
 *     	ErrorCode:         Return value passed to the caller, based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to set the application mode.
 */
class SetApplicationModeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetApplicationModeResponse ();

    /**
     * Copy constructor
     */
    inline  SetApplicationModeResponse (const SetApplicationModeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetApplicationModeResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetApplicationModeResponse();

    /**
     * Assignment operator
     */
    inline SetApplicationModeResponse& operator = (const SetApplicationModeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetApplicationModeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetApplicationModeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetApplicationModeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetApplicationModeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    static const SetApplicationModeResponse &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _ErrorCode;

};

/**
 * SetNodeState:
 *     	NodeStateId: The passed value will be based upon the enum NsmNodeState_e.
 *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to set the NodeState.
 *     	When this method is called to change the current NodeState a signal will be sent to notify registered consumers of the new state.
 */
class SetNodeStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetNodeStateRequest ();

    /**
     * Copy constructor
     */
    inline  SetNodeStateRequest (const SetNodeStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetNodeStateRequest (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e NodeStateId_);

    /**
     * Destructor
     */
    inline virtual  ~SetNodeStateRequest();

    /**
     * Assignment operator
     */
    inline SetNodeStateRequest& operator = (const SetNodeStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetNodeStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetNodeStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetNodeStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetNodeStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NodeStateId"

    static const int kNodeStateId = 0;

    /**
     * Clears the field "NodeStateId".
     *
     * The field will be set to its default value. The hasNodeStateId()
     * method will return false.
     */
    inline void clearNodeStateId();

    /**
     * Checks whether the field "NodeStateId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNodeStateId()). Otherwise it will return false.
     */
    inline bool hasNodeStateId () const;

    /**
     * Returns the value of the member "NodeStateId".
     *
     * If the meaning of "NodeStateId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "NodeStateId"
     */
    inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e getNodeStateId () const;

    /**
     * Sets the value of the member "NodeStateId".
     *
     * If the meaning of "NodeStateId" isn't clear, then there should be a description here.
     *
     * @param NodeStateId The value which will be set
     */
    inline void setNodeStateId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e NodeStateId_);

    static const SetNodeStateRequest &getDefaultInstance();

private:

    inline void set_has_NodeStateId ();

    inline void clear_has_NodeStateId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e _NodeStateId;

};

/**
 * SetNodeState:
 *     	NodeStateId: The passed value will be based upon the enum NsmNodeState_e.
 *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
 *
 *     	The method is used by other applications to set the NodeState.
 *     	When this method is called to change the current NodeState a signal will be sent to notify registered consumers of the new state.
 */
class SetNodeStateResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetNodeStateResponse ();

    /**
     * Copy constructor
     */
    inline  SetNodeStateResponse (const SetNodeStateResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetNodeStateResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetNodeStateResponse();

    /**
     * Assignment operator
     */
    inline SetNodeStateResponse& operator = (const SetNodeStateResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetNodeStateResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetNodeStateResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetNodeStateResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetNodeStateResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    static const SetNodeStateResponse &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _ErrorCode;

};

/**
 * SetBootMode:
 *     	BootMode:    New BootMode to be set. The values will be defined by a third party header, which has not been delivered yet.
 *     	             The description needs to be updated as soon as the header is available.
 *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
 *
 *     	The method has been introduced, because the property "BootMode" can only be read by other applications.
 *     	Nevertheless there are some exceptions where the property should be set by a restricted set of applications which will be handled within this method.
 */
class SetBootModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetBootModeRequest ();

    /**
     * Copy constructor
     */
    inline  SetBootModeRequest (const SetBootModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetBootModeRequest (int32 BootMode_);

    /**
     * Destructor
     */
    inline virtual  ~SetBootModeRequest();

    /**
     * Assignment operator
     */
    inline SetBootModeRequest& operator = (const SetBootModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetBootModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetBootModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetBootModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetBootModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BootMode"

    static const int kBootMode = 0;

    /**
     * Clears the field "BootMode".
     *
     * The field will be set to its default value. The hasBootMode()
     * method will return false.
     */
    inline void clearBootMode();

    /**
     * Checks whether the field "BootMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBootMode()). Otherwise it will return false.
     */
    inline bool hasBootMode () const;

    /**
     * Returns the value of the member "BootMode".
     *
     * If the meaning of "BootMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "BootMode"
     */
    inline int32 getBootMode () const;

    /**
     * Sets the value of the member "BootMode".
     *
     * If the meaning of "BootMode" isn't clear, then there should be a description here.
     *
     * @param BootMode The value which will be set
     */
    inline void setBootMode (int32 BootMode_);

    static const SetBootModeRequest &getDefaultInstance();

private:

    inline void set_has_BootMode ();

    inline void clear_has_BootMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _BootMode;

};

/**
 * SetBootMode:
 *     	BootMode:    New BootMode to be set. The values will be defined by a third party header, which has not been delivered yet.
 *     	             The description needs to be updated as soon as the header is available.
 *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
 *
 *     	The method has been introduced, because the property "BootMode" can only be read by other applications.
 *     	Nevertheless there are some exceptions where the property should be set by a restricted set of applications which will be handled within this method.
 */
class SetBootModeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetBootModeResponse ();

    /**
     * Copy constructor
     */
    inline  SetBootModeResponse (const SetBootModeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetBootModeResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetBootModeResponse();

    /**
     * Assignment operator
     */
    inline SetBootModeResponse& operator = (const SetBootModeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetBootModeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetBootModeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetBootModeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetBootModeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    static const SetBootModeResponse &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _ErrorCode;

};

/**
 * SetAppHealthStatus:
 *     	AppName:     This parameter can be used to give the name of the application that has failed (this must be the applications systemd unit name).
 *     	AppRunning:  The AppState will be FALSE for failed and TRUE for running.
 *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
 *
 *     	This method will be used by the Node Health Monitor to report to the NSM if an application has failed and if it is running again.
 *     	Internally the NSM will use this information to keep a count of the number of failed applications within the current lifecycle.
 *     	Additionally it will unset any sessions that the failing application may have had active. It will also be possible for the product
 *     	node state machine to make a decision on what to do with this information,
 *     	i.e. even reset the node or reset the node if too many applications have failed.
 */
class SetAppHealthStatusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAppHealthStatusRequest ();

    /**
     * Copy constructor
     */
    inline  SetAppHealthStatusRequest (const SetAppHealthStatusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetAppHealthStatusRequest (const ::std::string& AppName_, bool AppRunning_);

    /**
     * Destructor
     */
    inline virtual  ~SetAppHealthStatusRequest();

    /**
     * Assignment operator
     */
    inline SetAppHealthStatusRequest& operator = (const SetAppHealthStatusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAppHealthStatusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAppHealthStatusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAppHealthStatusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAppHealthStatusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AppName"

    static const int kAppName = 0;

    /**
     * Clears the field "AppName".
     *
     * The field will be set to its default value. The hasAppName()
     * method will return false.
     */
    inline void clearAppName();

    /**
     * Checks whether the field "AppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppName()). Otherwise it will return false.
     */
    inline bool hasAppName () const;

    /**
     * Returns the value of the member "AppName".
     *
     * If the meaning of "AppName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AppName"
     */
    inline const ::std::string& getAppName () const;

    /**
     * Retrieves the value of the field "AppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AppName".
     */
    inline ::std::string& getAppNameMutable ();

    /**
     * Sets the value of the member "AppName".
     *
     * If the meaning of "AppName" isn't clear, then there should be a description here.
     *
     * @param AppName The value which will be set
     */
    inline void setAppName (const ::std::string& AppName_);

    /**
     * Sets the value of the member "AppName".
     *
     * If the meaning of "AppName" isn't clear, then there should be a description here.
     *
     * @param AppName The value which will be set
     */
    inline void setAppName (const char* AppName_);

    /**
     * Sets the value of the member "AppName".
     *
     * If the meaning of "AppName" isn't clear, then there should be a description here.
     *
     * @param AppName The value which will be set
     */
    inline void setAppName (const char* value, size_t size);

    // API of field "AppRunning"

    static const int kAppRunning = 1;

    /**
     * Clears the field "AppRunning".
     *
     * The field will be set to its default value. The hasAppRunning()
     * method will return false.
     */
    inline void clearAppRunning();

    /**
     * Checks whether the field "AppRunning" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppRunning()). Otherwise it will return false.
     */
    inline bool hasAppRunning () const;

    /**
     * Returns the value of the member "AppRunning".
     *
     * If the meaning of "AppRunning" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AppRunning"
     */
    inline bool getAppRunning () const;

    /**
     * Sets the value of the member "AppRunning".
     *
     * If the meaning of "AppRunning" isn't clear, then there should be a description here.
     *
     * @param AppRunning The value which will be set
     */
    inline void setAppRunning (bool AppRunning_);

    static const SetAppHealthStatusRequest &getDefaultInstance();

private:

    inline void set_has_AppName ();

    inline void clear_has_AppName ();

    inline void set_has_AppRunning ();

    inline void clear_has_AppRunning ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _AppName;

    bool _AppRunning;

};

/**
 * SetAppHealthStatus:
 *     	AppName:     This parameter can be used to give the name of the application that has failed (this must be the applications systemd unit name).
 *     	AppRunning:  The AppState will be FALSE for failed and TRUE for running.
 *     	ErrorCode:   Return value passed to the caller, based upon NsmErrorStatus_e.
 *
 *     	This method will be used by the Node Health Monitor to report to the NSM if an application has failed and if it is running again.
 *     	Internally the NSM will use this information to keep a count of the number of failed applications within the current lifecycle.
 *     	Additionally it will unset any sessions that the failing application may have had active. It will also be possible for the product
 *     	node state machine to make a decision on what to do with this information,
 *     	i.e. even reset the node or reset the node if too many applications have failed.
 */
class SetAppHealthStatusResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAppHealthStatusResponse ();

    /**
     * Copy constructor
     */
    inline  SetAppHealthStatusResponse (const SetAppHealthStatusResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetAppHealthStatusResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetAppHealthStatusResponse();

    /**
     * Assignment operator
     */
    inline SetAppHealthStatusResponse& operator = (const SetAppHealthStatusResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAppHealthStatusResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAppHealthStatusResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAppHealthStatusResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAppHealthStatusResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    static const SetAppHealthStatusResponse &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _ErrorCode;

};

/**
 * CheckLucRequired:
 *     	LucWanted:   This will be a simple TRUE or FALSE to define whether the LUC is wanted in the current Lifecycle.
 *
 *     	This method will be called exclusivley by the Boot Manager to find out whether the LUC Applications should be started in the current Lifecycle.
 *     	This is required whilst in certain Node Application Modes (i.e. Transport, Factory) we do not want the LUC Applications started.
 */
class CheckLucRequiredResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CheckLucRequiredResponse ();

    /**
     * Copy constructor
     */
    inline  CheckLucRequiredResponse (const CheckLucRequiredResponse &rhs);

    /**
     * All fields constructor
     */
    inline  CheckLucRequiredResponse (bool LucWanted_);

    /**
     * Destructor
     */
    inline virtual  ~CheckLucRequiredResponse();

    /**
     * Assignment operator
     */
    inline CheckLucRequiredResponse& operator = (const CheckLucRequiredResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CheckLucRequiredResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CheckLucRequiredResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CheckLucRequiredResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CheckLucRequiredResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LucWanted"

    static const int kLucWanted = 0;

    /**
     * Clears the field "LucWanted".
     *
     * The field will be set to its default value. The hasLucWanted()
     * method will return false.
     */
    inline void clearLucWanted();

    /**
     * Checks whether the field "LucWanted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLucWanted()). Otherwise it will return false.
     */
    inline bool hasLucWanted () const;

    /**
     * Returns the value of the member "LucWanted".
     *
     * If the meaning of "LucWanted" isn't clear, then there should be a description here.
     *
     * @return The value of the field "LucWanted"
     */
    inline bool getLucWanted () const;

    /**
     * Sets the value of the member "LucWanted".
     *
     * If the meaning of "LucWanted" isn't clear, then there should be a description here.
     *
     * @param LucWanted The value which will be set
     */
    inline void setLucWanted (bool LucWanted_);

    static const CheckLucRequiredResponse &getDefaultInstance();

private:

    inline void set_has_LucWanted ();

    inline void clear_has_LucWanted ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _LucWanted;

};

inline  RequestNodeRestartRequest::RequestNodeRestartRequest ()  :
    _RestartReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e__NsmRestartReason_NotSet),
    _RestartType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestNodeRestartRequest::RequestNodeRestartRequest (const RequestNodeRestartRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _RestartReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e__NsmRestartReason_NotSet),
    _RestartType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestNodeRestartRequest::RequestNodeRestartRequest (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e RestartReason_, uint32 RestartType_)  :
    _RestartReason (RestartReason_),
    _RestartType (RestartType_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e_IsValid(RestartReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RestartReason_, "_NsmRestartReason_e", "RestartReason", "RequestNodeRestartRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestNodeRestartRequest::~RequestNodeRestartRequest() {
}

inline RequestNodeRestartRequest& RequestNodeRestartRequest::operator = (const RequestNodeRestartRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRestartReason()) {
            setRestartReason(rhs.getRestartReason());
        } else {
            clearRestartReason();
        }
        if (rhs.hasRestartType()) {
            setRestartType(rhs.getRestartType());
        } else {
            clearRestartType();
        }
    }
    return *this;
}

inline bool RequestNodeRestartRequest::operator == (const RequestNodeRestartRequest& rhs) const {
    return (((!hasRestartReason() && !rhs.hasRestartReason()) || getRestartReason() == rhs.getRestartReason()) &&
        ((!hasRestartType() && !rhs.hasRestartType()) || getRestartType() == rhs.getRestartType()));
}

inline bool RequestNodeRestartRequest::operator != (const RequestNodeRestartRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestNodeRestartRequest::operator < (const RequestNodeRestartRequest& rhs) const {
    if (hasRestartReason() || rhs.hasRestartReason()) {
        if ((uint32)getRestartReason() < (uint32)rhs.getRestartReason()) return true;
        if ((uint32)getRestartReason() > (uint32)rhs.getRestartReason()) return false;
    }
    if (hasRestartType() || rhs.hasRestartType()) {
        if (getRestartType() < rhs.getRestartType()) return true;
        if (getRestartType() > rhs.getRestartType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestNodeRestartRequest::clone() {
    return new RequestNodeRestartRequest(*this);
}

inline bool RequestNodeRestartRequest::operator > (const RequestNodeRestartRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestNodeRestartRequest::clear() {
    clearRestartReason();
    clearRestartType();
}

inline void RequestNodeRestartRequest::clearRestartReason() {
    if (hasRestartReason()) {
         clear_has_RestartReason();
        _RestartReason = ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e__NsmRestartReason_NotSet;
     }
}

inline bool RequestNodeRestartRequest::hasRestartReason () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e RequestNodeRestartRequest::getRestartReason () const {
    return _RestartReason;
}

inline void RequestNodeRestartRequest::setRestartReason (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e RestartReason_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e_IsValid(RestartReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RestartReason_, "_NsmRestartReason_e", "RestartReason", "RequestNodeRestartRequest");
    }
    #endif
    set_has_RestartReason();
    this->_RestartReason = RestartReason_;
}

inline void RequestNodeRestartRequest::clearRestartType() {
    if (hasRestartType()) {
         clear_has_RestartType();
        _RestartType = 0u;
     }
}

inline bool RequestNodeRestartRequest::hasRestartType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 RequestNodeRestartRequest::getRestartType () const {
    return _RestartType;
}

inline void RequestNodeRestartRequest::setRestartType (uint32 RestartType_) {
    set_has_RestartType();
    this->_RestartType = RestartType_;
}

inline void RequestNodeRestartRequest::set_has_RestartReason () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestNodeRestartRequest::clear_has_RestartReason () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RequestNodeRestartRequest::set_has_RestartType () {
    _has_bits_[0] |= 1u << 1;
}

inline void RequestNodeRestartRequest::clear_has_RestartType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RequestNodeRestartResponse::RequestNodeRestartResponse ()  :
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestNodeRestartResponse::RequestNodeRestartResponse (const RequestNodeRestartResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestNodeRestartResponse::RequestNodeRestartResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "RequestNodeRestartResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestNodeRestartResponse::~RequestNodeRestartResponse() {
}

inline RequestNodeRestartResponse& RequestNodeRestartResponse::operator = (const RequestNodeRestartResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool RequestNodeRestartResponse::operator == (const RequestNodeRestartResponse& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool RequestNodeRestartResponse::operator != (const RequestNodeRestartResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestNodeRestartResponse::operator < (const RequestNodeRestartResponse& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestNodeRestartResponse::clone() {
    return new RequestNodeRestartResponse(*this);
}

inline bool RequestNodeRestartResponse::operator > (const RequestNodeRestartResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestNodeRestartResponse::clear() {
    clearErrorCode();
}

inline void RequestNodeRestartResponse::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool RequestNodeRestartResponse::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e RequestNodeRestartResponse::getErrorCode () const {
    return _ErrorCode;
}

inline void RequestNodeRestartResponse::setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "RequestNodeRestartResponse");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void RequestNodeRestartResponse::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestNodeRestartResponse::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetApplicationModeRequest::SetApplicationModeRequest ()  :
    _ApplicationModeId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e__NsmApplicationMode_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetApplicationModeRequest::SetApplicationModeRequest (const SetApplicationModeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ApplicationModeId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e__NsmApplicationMode_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetApplicationModeRequest::SetApplicationModeRequest (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e ApplicationModeId_)  :
    _ApplicationModeId (ApplicationModeId_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e_IsValid(ApplicationModeId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ApplicationModeId_, "_NsmApplicationMode_e", "ApplicationModeId", "SetApplicationModeRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetApplicationModeRequest::~SetApplicationModeRequest() {
}

inline SetApplicationModeRequest& SetApplicationModeRequest::operator = (const SetApplicationModeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasApplicationModeId()) {
            setApplicationModeId(rhs.getApplicationModeId());
        } else {
            clearApplicationModeId();
        }
    }
    return *this;
}

inline bool SetApplicationModeRequest::operator == (const SetApplicationModeRequest& rhs) const {
    return (((!hasApplicationModeId() && !rhs.hasApplicationModeId()) || getApplicationModeId() == rhs.getApplicationModeId()));
}

inline bool SetApplicationModeRequest::operator != (const SetApplicationModeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetApplicationModeRequest::operator < (const SetApplicationModeRequest& rhs) const {
    if (hasApplicationModeId() || rhs.hasApplicationModeId()) {
        if ((uint32)getApplicationModeId() < (uint32)rhs.getApplicationModeId()) return true;
        if ((uint32)getApplicationModeId() > (uint32)rhs.getApplicationModeId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetApplicationModeRequest::clone() {
    return new SetApplicationModeRequest(*this);
}

inline bool SetApplicationModeRequest::operator > (const SetApplicationModeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetApplicationModeRequest::clear() {
    clearApplicationModeId();
}

inline void SetApplicationModeRequest::clearApplicationModeId() {
    if (hasApplicationModeId()) {
         clear_has_ApplicationModeId();
        _ApplicationModeId = ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e__NsmApplicationMode_NotSet;
     }
}

inline bool SetApplicationModeRequest::hasApplicationModeId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e SetApplicationModeRequest::getApplicationModeId () const {
    return _ApplicationModeId;
}

inline void SetApplicationModeRequest::setApplicationModeId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e ApplicationModeId_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmApplicationMode_e_IsValid(ApplicationModeId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ApplicationModeId_, "_NsmApplicationMode_e", "ApplicationModeId", "SetApplicationModeRequest");
    }
    #endif
    set_has_ApplicationModeId();
    this->_ApplicationModeId = ApplicationModeId_;
}

inline void SetApplicationModeRequest::set_has_ApplicationModeId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetApplicationModeRequest::clear_has_ApplicationModeId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetApplicationModeResponse::SetApplicationModeResponse ()  :
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetApplicationModeResponse::SetApplicationModeResponse (const SetApplicationModeResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetApplicationModeResponse::SetApplicationModeResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "SetApplicationModeResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetApplicationModeResponse::~SetApplicationModeResponse() {
}

inline SetApplicationModeResponse& SetApplicationModeResponse::operator = (const SetApplicationModeResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool SetApplicationModeResponse::operator == (const SetApplicationModeResponse& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool SetApplicationModeResponse::operator != (const SetApplicationModeResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetApplicationModeResponse::operator < (const SetApplicationModeResponse& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetApplicationModeResponse::clone() {
    return new SetApplicationModeResponse(*this);
}

inline bool SetApplicationModeResponse::operator > (const SetApplicationModeResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetApplicationModeResponse::clear() {
    clearErrorCode();
}

inline void SetApplicationModeResponse::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool SetApplicationModeResponse::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e SetApplicationModeResponse::getErrorCode () const {
    return _ErrorCode;
}

inline void SetApplicationModeResponse::setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "SetApplicationModeResponse");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void SetApplicationModeResponse::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetApplicationModeResponse::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetNodeStateRequest::SetNodeStateRequest ()  :
    _NodeStateId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e__NsmNodeState_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetNodeStateRequest::SetNodeStateRequest (const SetNodeStateRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _NodeStateId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e__NsmNodeState_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetNodeStateRequest::SetNodeStateRequest (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e NodeStateId_)  :
    _NodeStateId (NodeStateId_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e_IsValid(NodeStateId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", NodeStateId_, "_NsmNodeState_e", "NodeStateId", "SetNodeStateRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetNodeStateRequest::~SetNodeStateRequest() {
}

inline SetNodeStateRequest& SetNodeStateRequest::operator = (const SetNodeStateRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNodeStateId()) {
            setNodeStateId(rhs.getNodeStateId());
        } else {
            clearNodeStateId();
        }
    }
    return *this;
}

inline bool SetNodeStateRequest::operator == (const SetNodeStateRequest& rhs) const {
    return (((!hasNodeStateId() && !rhs.hasNodeStateId()) || getNodeStateId() == rhs.getNodeStateId()));
}

inline bool SetNodeStateRequest::operator != (const SetNodeStateRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetNodeStateRequest::operator < (const SetNodeStateRequest& rhs) const {
    if (hasNodeStateId() || rhs.hasNodeStateId()) {
        if ((uint32)getNodeStateId() < (uint32)rhs.getNodeStateId()) return true;
        if ((uint32)getNodeStateId() > (uint32)rhs.getNodeStateId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetNodeStateRequest::clone() {
    return new SetNodeStateRequest(*this);
}

inline bool SetNodeStateRequest::operator > (const SetNodeStateRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetNodeStateRequest::clear() {
    clearNodeStateId();
}

inline void SetNodeStateRequest::clearNodeStateId() {
    if (hasNodeStateId()) {
         clear_has_NodeStateId();
        _NodeStateId = ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e__NsmNodeState_NotSet;
     }
}

inline bool SetNodeStateRequest::hasNodeStateId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e SetNodeStateRequest::getNodeStateId () const {
    return _NodeStateId;
}

inline void SetNodeStateRequest::setNodeStateId (::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e NodeStateId_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmBasicTypes::_NsmNodeState_e_IsValid(NodeStateId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", NodeStateId_, "_NsmNodeState_e", "NodeStateId", "SetNodeStateRequest");
    }
    #endif
    set_has_NodeStateId();
    this->_NodeStateId = NodeStateId_;
}

inline void SetNodeStateRequest::set_has_NodeStateId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetNodeStateRequest::clear_has_NodeStateId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetNodeStateResponse::SetNodeStateResponse ()  :
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetNodeStateResponse::SetNodeStateResponse (const SetNodeStateResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetNodeStateResponse::SetNodeStateResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "SetNodeStateResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetNodeStateResponse::~SetNodeStateResponse() {
}

inline SetNodeStateResponse& SetNodeStateResponse::operator = (const SetNodeStateResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool SetNodeStateResponse::operator == (const SetNodeStateResponse& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool SetNodeStateResponse::operator != (const SetNodeStateResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetNodeStateResponse::operator < (const SetNodeStateResponse& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetNodeStateResponse::clone() {
    return new SetNodeStateResponse(*this);
}

inline bool SetNodeStateResponse::operator > (const SetNodeStateResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetNodeStateResponse::clear() {
    clearErrorCode();
}

inline void SetNodeStateResponse::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool SetNodeStateResponse::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e SetNodeStateResponse::getErrorCode () const {
    return _ErrorCode;
}

inline void SetNodeStateResponse::setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "SetNodeStateResponse");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void SetNodeStateResponse::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetNodeStateResponse::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetBootModeRequest::SetBootModeRequest ()  :
    _BootMode (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetBootModeRequest::SetBootModeRequest (const SetBootModeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _BootMode (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetBootModeRequest::SetBootModeRequest (int32 BootMode_)  :
    _BootMode (BootMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetBootModeRequest::~SetBootModeRequest() {
}

inline SetBootModeRequest& SetBootModeRequest::operator = (const SetBootModeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBootMode()) {
            setBootMode(rhs.getBootMode());
        } else {
            clearBootMode();
        }
    }
    return *this;
}

inline bool SetBootModeRequest::operator == (const SetBootModeRequest& rhs) const {
    return (((!hasBootMode() && !rhs.hasBootMode()) || getBootMode() == rhs.getBootMode()));
}

inline bool SetBootModeRequest::operator != (const SetBootModeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetBootModeRequest::operator < (const SetBootModeRequest& rhs) const {
    if (hasBootMode() || rhs.hasBootMode()) {
        if (getBootMode() < rhs.getBootMode()) return true;
        if (getBootMode() > rhs.getBootMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetBootModeRequest::clone() {
    return new SetBootModeRequest(*this);
}

inline bool SetBootModeRequest::operator > (const SetBootModeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetBootModeRequest::clear() {
    clearBootMode();
}

inline void SetBootModeRequest::clearBootMode() {
    if (hasBootMode()) {
         clear_has_BootMode();
        _BootMode = 0;
     }
}

inline bool SetBootModeRequest::hasBootMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SetBootModeRequest::getBootMode () const {
    return _BootMode;
}

inline void SetBootModeRequest::setBootMode (int32 BootMode_) {
    set_has_BootMode();
    this->_BootMode = BootMode_;
}

inline void SetBootModeRequest::set_has_BootMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetBootModeRequest::clear_has_BootMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetBootModeResponse::SetBootModeResponse ()  :
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetBootModeResponse::SetBootModeResponse (const SetBootModeResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetBootModeResponse::SetBootModeResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "SetBootModeResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetBootModeResponse::~SetBootModeResponse() {
}

inline SetBootModeResponse& SetBootModeResponse::operator = (const SetBootModeResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool SetBootModeResponse::operator == (const SetBootModeResponse& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool SetBootModeResponse::operator != (const SetBootModeResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetBootModeResponse::operator < (const SetBootModeResponse& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetBootModeResponse::clone() {
    return new SetBootModeResponse(*this);
}

inline bool SetBootModeResponse::operator > (const SetBootModeResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetBootModeResponse::clear() {
    clearErrorCode();
}

inline void SetBootModeResponse::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool SetBootModeResponse::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e SetBootModeResponse::getErrorCode () const {
    return _ErrorCode;
}

inline void SetBootModeResponse::setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "SetBootModeResponse");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void SetBootModeResponse::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetBootModeResponse::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetAppHealthStatusRequest::SetAppHealthStatusRequest ()  :
    _AppName (),
    _AppRunning (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetAppHealthStatusRequest::SetAppHealthStatusRequest (const SetAppHealthStatusRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _AppName (),
    _AppRunning (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetAppHealthStatusRequest::SetAppHealthStatusRequest (const ::std::string& AppName_, bool AppRunning_)  :
    _AppName (AppName_),
    _AppRunning (AppRunning_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AppName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetAppHealthStatusRequest::~SetAppHealthStatusRequest() {
}

inline SetAppHealthStatusRequest& SetAppHealthStatusRequest::operator = (const SetAppHealthStatusRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAppName()) {
            setAppName(rhs.getAppName());
        } else {
            clearAppName();
        }
        if (rhs.hasAppRunning()) {
            setAppRunning(rhs.getAppRunning());
        } else {
            clearAppRunning();
        }
    }
    return *this;
}

inline bool SetAppHealthStatusRequest::operator == (const SetAppHealthStatusRequest& rhs) const {
    return (((!hasAppName() && !rhs.hasAppName()) || getAppName() == rhs.getAppName()) &&
        ((!hasAppRunning() && !rhs.hasAppRunning()) || getAppRunning() == rhs.getAppRunning()));
}

inline bool SetAppHealthStatusRequest::operator != (const SetAppHealthStatusRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetAppHealthStatusRequest::operator < (const SetAppHealthStatusRequest& rhs) const {
    if (hasAppName() || rhs.hasAppName()) {
        if (getAppName() < rhs.getAppName()) return true;
        if (getAppName() > rhs.getAppName()) return false;
    }
    if (hasAppRunning() || rhs.hasAppRunning()) {
        if (getAppRunning() < rhs.getAppRunning()) return true;
        if (getAppRunning() > rhs.getAppRunning()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetAppHealthStatusRequest::clone() {
    return new SetAppHealthStatusRequest(*this);
}

inline bool SetAppHealthStatusRequest::operator > (const SetAppHealthStatusRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetAppHealthStatusRequest::clear() {
    clearAppName();
    clearAppRunning();
}

inline void SetAppHealthStatusRequest::clearAppName() {
    if (hasAppName()) {
         clear_has_AppName();
        _AppName.clear();
     }
}

inline bool SetAppHealthStatusRequest::hasAppName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetAppHealthStatusRequest::getAppName () const {
    return _AppName;
}

inline ::std::string& SetAppHealthStatusRequest::getAppNameMutable () {
    set_has_AppName();
    return _AppName;
}

inline void SetAppHealthStatusRequest::setAppName (const ::std::string& AppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AppName();
    this->_AppName = AppName_;
}

inline void SetAppHealthStatusRequest::setAppName (const char* AppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AppName();
    this->_AppName.assign(AppName_);
}

inline void SetAppHealthStatusRequest::setAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AppName();
    this->_AppName.assign(value, size);
}

inline void SetAppHealthStatusRequest::clearAppRunning() {
    if (hasAppRunning()) {
         clear_has_AppRunning();
        _AppRunning = false;
     }
}

inline bool SetAppHealthStatusRequest::hasAppRunning () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SetAppHealthStatusRequest::getAppRunning () const {
    return _AppRunning;
}

inline void SetAppHealthStatusRequest::setAppRunning (bool AppRunning_) {
    set_has_AppRunning();
    this->_AppRunning = AppRunning_;
}

inline void SetAppHealthStatusRequest::set_has_AppName () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetAppHealthStatusRequest::clear_has_AppName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetAppHealthStatusRequest::set_has_AppRunning () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetAppHealthStatusRequest::clear_has_AppRunning () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetAppHealthStatusResponse::SetAppHealthStatusResponse ()  :
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetAppHealthStatusResponse::SetAppHealthStatusResponse (const SetAppHealthStatusResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetAppHealthStatusResponse::SetAppHealthStatusResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "SetAppHealthStatusResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetAppHealthStatusResponse::~SetAppHealthStatusResponse() {
}

inline SetAppHealthStatusResponse& SetAppHealthStatusResponse::operator = (const SetAppHealthStatusResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool SetAppHealthStatusResponse::operator == (const SetAppHealthStatusResponse& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool SetAppHealthStatusResponse::operator != (const SetAppHealthStatusResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetAppHealthStatusResponse::operator < (const SetAppHealthStatusResponse& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetAppHealthStatusResponse::clone() {
    return new SetAppHealthStatusResponse(*this);
}

inline bool SetAppHealthStatusResponse::operator > (const SetAppHealthStatusResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetAppHealthStatusResponse::clear() {
    clearErrorCode();
}

inline void SetAppHealthStatusResponse::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool SetAppHealthStatusResponse::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e SetAppHealthStatusResponse::getErrorCode () const {
    return _ErrorCode;
}

inline void SetAppHealthStatusResponse::setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "SetAppHealthStatusResponse");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void SetAppHealthStatusResponse::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetAppHealthStatusResponse::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CheckLucRequiredResponse::CheckLucRequiredResponse ()  :
    _LucWanted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CheckLucRequiredResponse::CheckLucRequiredResponse (const CheckLucRequiredResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _LucWanted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CheckLucRequiredResponse::CheckLucRequiredResponse (bool LucWanted_)  :
    _LucWanted (LucWanted_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CheckLucRequiredResponse::~CheckLucRequiredResponse() {
}

inline CheckLucRequiredResponse& CheckLucRequiredResponse::operator = (const CheckLucRequiredResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLucWanted()) {
            setLucWanted(rhs.getLucWanted());
        } else {
            clearLucWanted();
        }
    }
    return *this;
}

inline bool CheckLucRequiredResponse::operator == (const CheckLucRequiredResponse& rhs) const {
    return (((!hasLucWanted() && !rhs.hasLucWanted()) || getLucWanted() == rhs.getLucWanted()));
}

inline bool CheckLucRequiredResponse::operator != (const CheckLucRequiredResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool CheckLucRequiredResponse::operator < (const CheckLucRequiredResponse& rhs) const {
    if (hasLucWanted() || rhs.hasLucWanted()) {
        if (getLucWanted() < rhs.getLucWanted()) return true;
        if (getLucWanted() > rhs.getLucWanted()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CheckLucRequiredResponse::clone() {
    return new CheckLucRequiredResponse(*this);
}

inline bool CheckLucRequiredResponse::operator > (const CheckLucRequiredResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CheckLucRequiredResponse::clear() {
    clearLucWanted();
}

inline void CheckLucRequiredResponse::clearLucWanted() {
    if (hasLucWanted()) {
         clear_has_LucWanted();
        _LucWanted = false;
     }
}

inline bool CheckLucRequiredResponse::hasLucWanted () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool CheckLucRequiredResponse::getLucWanted () const {
    return _LucWanted;
}

inline void CheckLucRequiredResponse::setLucWanted (bool LucWanted_) {
    set_has_LucWanted();
    this->_LucWanted = LucWanted_;
}

inline void CheckLucRequiredResponse::set_has_LucWanted () {
    _has_bits_[0] |= 1u << 0;
}

inline void CheckLucRequiredResponse::clear_has_LucWanted () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace LifecycleControl
} // namespace NodeStateManager
} // namespace genivi
} // namespace org

#endif // ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONTROL_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
