/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONSUMERSTUB_H
#define ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONSUMERSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/genivi/NodeStateManager/LcmErrorTypesConst.h"
#include "org/genivi/NodeStateManager/LifeCycleConsumer.h"

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace LifeCycleConsumer {

class LifeCycleConsumerStubDelegate;

class LifeCycleConsumerStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the LifeCycleConsumerStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    LifeCycleConsumerStub (const std::string& portName);

    /**
     * Create an instance of the LifeCycleConsumerStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    LifeCycleConsumerStub (const std::string& portName, const std::string& objectPath);

    virtual ~LifeCycleConsumerStub();

    // method 'LifecycleRequest'

    /**
     * The method onLifecycleRequest() is called by ASF when a client invokes
     * the method 'LifecycleRequest'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendLifecycleRequest() or sendLifecycleRequestError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'LifecycleRequest'</b>:
     *
     * LifecycleRequest:
     *     	Request:     The type of the life cycle request. Can be NSM_SHUTDOWNTYPE_RUNUP, NSM_SHUTDOWNTYPE_NORMAL or NSM_SHUTDOWNTYPE_FAST.
     *     	RequestId:   The Id of the client (current request). This Id needs to be passed to the NSM again via the interface "LifecycleRequestComplete",
     *     	             when the client has processed the "LifecycleRequest".
     *     	ErrorCode:   Client's return value, passed to the NodeStateManager. Based upon NsmErrorStatus_e. NsmErrorStatus_Ok:
     *     	             Request was successfully processed. NsmErrorStatus_ResponsePending: Processing of request started.
     *     	             LifecycleRequestComplete will be called to pass the status after completion. NsmErrorStatus_Error: An error occured, the request could not be processed.
     *
     *     	             The method has to be implemented by every life cycle client and is called by the NodeStateManager,
     *     	             when the node is shutting down (fast or normal) or an ongoing shutdown is cancelled (run up)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onLifecycleRequestRequest (const ::boost::shared_ptr< LifecycleRequestRequest >& request) = 0;

    /**
     * The method sendLifecycleRequestResponse() sends a response of a
     * previous method invocation of 'LifecycleRequest' back to the client.
     *
     * <b>Documentation of 'LifecycleRequest'</b>:
     *
     * LifecycleRequest:
     *     	Request:     The type of the life cycle request. Can be NSM_SHUTDOWNTYPE_RUNUP, NSM_SHUTDOWNTYPE_NORMAL or NSM_SHUTDOWNTYPE_FAST.
     *     	RequestId:   The Id of the client (current request). This Id needs to be passed to the NSM again via the interface "LifecycleRequestComplete",
     *     	             when the client has processed the "LifecycleRequest".
     *     	ErrorCode:   Client's return value, passed to the NodeStateManager. Based upon NsmErrorStatus_e. NsmErrorStatus_Ok:
     *     	             Request was successfully processed. NsmErrorStatus_ResponsePending: Processing of request started.
     *     	             LifecycleRequestComplete will be called to pass the status after completion. NsmErrorStatus_Error: An error occured, the request could not be processed.
     *
     *     	             The method has to be implemented by every life cycle client and is called by the NodeStateManager,
     *     	             when the node is shutting down (fast or normal) or an ongoing shutdown is cancelled (run up)
     *
     * @param ErrorCode If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onLifecycleRequest(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendLifecycleRequestResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e errorCode, act_t act = 0);

    /**
     * The method sendLifecycleRequestError() sends an error response of a
     * previous method invocation of 'LifecycleRequest' back to the client.
     *
     * <b>Documentation of 'LifecycleRequest'</b>:
     *
     * LifecycleRequest:
     *     	Request:     The type of the life cycle request. Can be NSM_SHUTDOWNTYPE_RUNUP, NSM_SHUTDOWNTYPE_NORMAL or NSM_SHUTDOWNTYPE_FAST.
     *     	RequestId:   The Id of the client (current request). This Id needs to be passed to the NSM again via the interface "LifecycleRequestComplete",
     *     	             when the client has processed the "LifecycleRequest".
     *     	ErrorCode:   Client's return value, passed to the NodeStateManager. Based upon NsmErrorStatus_e. NsmErrorStatus_Ok:
     *     	             Request was successfully processed. NsmErrorStatus_ResponsePending: Processing of request started.
     *     	             LifecycleRequestComplete will be called to pass the status after completion. NsmErrorStatus_Error: An error occured, the request could not be processed.
     *
     *     	             The method has to be implemented by every life cycle client and is called by the NodeStateManager,
     *     	             when the node is shutting down (fast or normal) or an ongoing shutdown is cancelled (run up)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onLifecycleRequest(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendLifecycleRequestError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class LifeCycleConsumerStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace LifeCycleConsumer
} // namespace NodeStateManager
} // namespace genivi
} // namespace org

#endif // ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONSUMERSTUB_H
