/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONSUMERPROXY_H
#define ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONSUMERPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/genivi/NodeStateManager/LifeCycleConsumer.h"
#include <dbus/dbus.h>

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace LifeCycleConsumer {

class LifeCycleConsumerProxy;

class LifecycleRequestCallbackIF {
public:
    virtual ~LifecycleRequestCallbackIF() {}

    virtual void onLifecycleRequestError(const ::boost::shared_ptr< LifeCycleConsumerProxy >& proxy, const ::boost::shared_ptr< LifecycleRequestError >& error) = 0;

    virtual void onLifecycleRequestResponse(const ::boost::shared_ptr< LifeCycleConsumerProxy >& proxy, const ::boost::shared_ptr< LifecycleRequestResponse >& response) = 0;
};


/**
 * LifeCycleConsumerProxy is the client side representation of the D-Bus
 * service interface 'org.genivi.NodeStateManager.LifeCycleConsumer'
 * (specified in file org.genivi.NodeStateManager.LifecycleConsumer_.xml).
 *
 * org.genivi.NodeStateManager.LifeCycleConsumer :
 *
 *                     short_description: Interface of a life cycle client.
 *                     This interface contains functions, which need to be implemented by life cycle clients, to be able to receive life cycle requests.
 */
class LifeCycleConsumerProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of LifeCycleConsumerProxy.
     */
    static ::boost::shared_ptr< LifeCycleConsumerProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of LifeCycleConsumerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< LifeCycleConsumerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of LifeCycleConsumerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< LifeCycleConsumerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< LifeCycleConsumerProxy > proxyNew(new LifeCycleConsumerProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~LifeCycleConsumerProxy ();




    // Method 'LifecycleRequest'

    /**
     * Call the method 'LifecycleRequest'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'LifecycleRequest'</b>:
     *
     * LifecycleRequest:
     *     	Request:     The type of the life cycle request. Can be NSM_SHUTDOWNTYPE_RUNUP, NSM_SHUTDOWNTYPE_NORMAL or NSM_SHUTDOWNTYPE_FAST.
     *     	RequestId:   The Id of the client (current request). This Id needs to be passed to the NSM again via the interface "LifecycleRequestComplete",
     *     	             when the client has processed the "LifecycleRequest".
     *     	ErrorCode:   Client's return value, passed to the NodeStateManager. Based upon NsmErrorStatus_e. NsmErrorStatus_Ok:
     *     	             Request was successfully processed. NsmErrorStatus_ResponsePending: Processing of request started.
     *     	             LifecycleRequestComplete will be called to pass the status after completion. NsmErrorStatus_Error: An error occured, the request could not be processed.
     *
     *     	             The method has to be implemented by every life cycle client and is called by the NodeStateManager,
     *     	             when the node is shutting down (fast or normal) or an ongoing shutdown is cancelled (run up)
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Request If the meaning of "Request" isn't clear, then there should be a description here.
     *
     * @param RequestId If the meaning of "RequestId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLifecycleRequestRequest(LifecycleRequestCallbackIF& cb, uint32 request, uint32 requestId) const;


private:

    LifeCycleConsumerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class LifeCycleConsumerProxyCallback;
};

} // namespace LifeCycleConsumer
} // namespace NodeStateManager
} // namespace genivi
} // namespace org

#endif // ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONSUMERPROXY_H
